Rem drv: <migrate type="schema_upgrade" version="10.2.0.0" pos="-"/>
Rem
Rem $Header: sdk_schema_upgrade.sql 23-aug-2005.18:32:08 chyu Exp $
Rem
Rem sdk_schema_upgrade.sql
Rem
Rem Copyright (c) 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      sdk_schema_upgrade.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    chyu        08/23/05 - removing MGMT_TZRGN_UPDATE_CBK_OBJ since it is 
Rem                           added after BETA 
Rem    chyu        07/25/05 - modifying the header 
Rem    chyu        07/18/05 - adding the <migration> header 
Rem    rpinnama    06/23/05 - Add MGMT_TARGET_META_VER_CBK_OBJ 
Rem    jsadras     05/30/05 - target property callback 
Rem    jpyang      03/15/05 - MGMT_METRIC_INSTANCE upgrade
Rem    rpinnama    02/06/05 - rpinnama_add_upgrade_scripts
Rem    rpinnama    02/04/05 - Created
Rem


-- Create the type for returning objects owned by the user
CREATE OR REPLACE TYPE MGMT_USER_OBJECT IS OBJECT
(
 object_type        VARCHAR2(20),
 object_name        VARCHAR2(256),
 object_sub_type    VARCHAR2(256),
 async_drop         INTEGER(1)
);
/

CREATE OR REPLACE TYPE MGMT_USER_OBJECTS IS TABLE OF MGMT_USER_OBJECT;
/


CREATE OR REPLACE TYPE MGMT_INTEGER_ARRAY AS VARRAY(5000) OF INTEGER;
/

CREATE OR REPLACE TYPE MGMT_SHORT_STRING_ARRAY AS VARRAY(5000) OF VARCHAR2(64);
/

CREATE OR REPLACE TYPE MGMT_MEDIUM_STRING_ARRAY AS VARRAY(5000) OF VARCHAR2(256);
/

CREATE OR REPLACE TYPE MGMT_LONG_STRING_ARRAY AS VARRAY(5000) OF VARCHAR2(1024);
/

CREATE OR REPLACE TYPE MGMT_MAX_STRING_ARRAY AS VARRAY(5000) OF VARCHAR2(4000);
/

CREATE OR REPLACE TYPE MGMT_SHORT_STRING_TABLE AS TABLE OF VARCHAR2(64);
/

CREATE OR REPLACE TYPE MGMT_MEDIUM_STRING_TABLE AS TABLE OF VARCHAR2(256)
/

CREATE OR REPLACE TYPE MGMT_INTEGER_TABLE AS TABLE OF INTEGER
/

CREATE OR REPLACE TYPE MGMT_DATE_TABLE AS TABLE OF DATE
/

CREATE OR REPLACE TYPE MGMT_TARGET_GUID_ARRAY AS TABLE OF RAW(16)
/

CREATE OR REPLACE TYPE MGMT_TARGET_OBJ AS OBJECT
(
  target_name VARCHAR2(256),
  target_type VARCHAR2(64),
  STATIC FUNCTION new(p_target_name VARCHAR2,
                      p_target_type VARCHAR2
                      )
 RETURN mgmt_target_obj
)
/

CREATE OR REPLACE TYPE MGMT_TARGET_ARRAY AS TABLE OF MGMT_TARGET_OBJ
/
 
CREATE OR REPLACE TYPE MGMT_TARGET_META_VER_CBK_OBJ AS OBJECT (
 target_guid   RAW(16),
 target_type   VARCHAR2(64),
 from_meta_ver VARCHAR2(64),
 to_meta_ver   VARCHAR2(64),
 STATIC FUNCTION NEW(p_target_guid    RAW,
                     p_target_type    VARCHAR2,
                     p_from_meta_ver  VARCHAR2,
                     p_to_meta_ver    VARCHAR2
                     )
 RETURN MGMT_TARGET_META_VER_CBK_OBJ
);
/

CREATE OR REPLACE TYPE MGMT_TARGET_META_VER_CBK_ARRAY AS TABLE OF MGMT_TARGET_META_VER_CBK_OBJ
/

CREATE OR REPLACE TYPE mgmt_metric_name_obj AS OBJECT
( metric_name   VARCHAR2(64),
  metric_column VARCHAR2(64),
  STATIC FUNCTION NEW(p_metric_name   IN VARCHAR2,
                      p_metric_column IN VARCHAR2 DEFAULT ' ')
  RETURN mgmt_metric_name_obj
)   
/   
    
CREATE OR REPLACE TYPE mgmt_metric_name_array AS TABLE of
mgmt_metric_name_obj
/

DROP TYPE  MGMT_METRIC_INSTANCE_ARRAY;


CREATE OR REPLACE TYPE MGMT_METRIC_INSTANCE as OBJECT (
   target_name        VARCHAR2(256),
   target_type        VARCHAR2(64),
   metric_name        VARCHAR2(64),
   metric_column      VARCHAR2(64),
   key_value          VARCHAR2(256),
   STATIC FUNCTION NEW(target_name    VARCHAR2,
                   target_type    VARCHAR2,
                       metric_name    VARCHAR2,
                       metric_column  VARCHAR2,
                   key_value      VARCHAR2)
    RETURN MGMT_METRIC_INSTANCE
);
/

CREATE OR REPLACE TYPE MGMT_METRIC_INSTANCE_ARRAY as TABLE of MGMT_METRIC_INSTANCE;
/

DROP TYPE  MGMT_METRIC_DETAILS_ARRAY;


CREATE OR REPLACE TYPE MGMT_METRIC_DETAILS as OBJECT (
  target_guid      RAW(16),
  metric_guid      RAW(16),
  key_value        VARCHAR2(256),
  severity_code    NUMBER,
  avail_status     NUMBER,
   STATIC FUNCTION NEW(target_guid    RAW,
                   metric_guid    RAW,
                   key_value      VARCHAR2,
                       severity_code  NUMBER,
                   avail_status   NUMBER)
    RETURN MGMT_METRIC_DETAILS
);
/
CREATE OR REPLACE TYPE MGMT_METRIC_DETAILS_ARRAY
   as TABLE of MGMT_METRIC_DETAILS;
/



