Rem drv: <migrate type="data_upgrade" version="10.2.0.0" pos="trace/trace_data_upgrade.sql+"/>

set serveroutput on size 2000
set ECHO ON

@&EM_SQL_ROOT/core/v102010/self_monitor/self_monitor_init.sql

set ECHO ON
-- update oracle_emrep version
BEGIN
  DECLARE
    l_tname VARCHAR2(256) := '';
    l_host_name gv$instance.host_name%TYPE;
    l_tz_rgn MGMT_TARGETS.timezone_region%TYPE := TO_CHAR(SYSTIMESTAMP,'TZR');
    l_guid RAW(16);
    err NUMBER;
  BEGIN
    BEGIN
      SELECT target_name, target_guid 
        INTO l_tname, l_guid 
        FROM mgmt_targets 
        WHERE target_type=MGMT_GLOBAL.G_REPOSITORY_TARGET_TYPE
        AND rownum = 1;
      UPDATE mgmt_targets set type_meta_ver='3.0' where
        target_type=MGMT_GLOBAL.G_REPOSITORY_TARGET_TYPE;
      COMMIT;
      mgmt_admin_data.add_emrep_callback(l_tname,
        MGMT_GLOBAL.G_REPOSITORY_TARGET_TYPE,
        l_guid);
      COMMIT;
    EXCEPTION
    WHEN OTHERS THEN
      err := SQLCODE;
      dbms_output.put_line('error '||to_char(err)||' getting target_name '||l_tname);
      BEGIN
        SELECT host_name into l_host_name FROM gv$instance WHERE ROWNUM=1;
        MGMT_TARGET.add_target(MGMT_GLOBAL.G_MANAGEMENT_SYSTEM,
                  MGMT_GLOBAL.G_REPOSITORY_TARGET_TYPE,
                  l_host_name, NULL, NULL, NULL,
                  NULL, MGMT_GLOBAL.G_MANAGEMENT_SYSTEM,
                  NULL, l_tz_rgn, MGMT_GLOBAL.G_MON_MODE_DEFAULT,
                  MGMT_GLOBAL.G_MGMT_SYS_TYPE_META_VER, ' ', ' ', ' ', ' ', ' ', 1);
      EXCEPTION
      WHEN OTHERS THEN
        err := SQLCODE;
        dbms_output.put_line('error '||to_char(err)||' adding target');
      END;
    END;
  END;
  commit;
END;
/
show errors;

