Rem drv: <migrate type="pre_data_upgrade" version="10.2.0.0" pos="swlib/swlib_post_creation.sql+"/>
Rem
Rem $Header: service_post_creation.sql 27-jul-2005.14:19:58 afontana Exp $
Rem
Rem service_post_creation.sql
Rem
Rem Copyright (c) 2004, 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      service_post_creation.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    afontana    07/27/05 - add post creation header 
Rem    gsbhatia    07/03/05 - New repmgr header impl 
Rem    afontana    06/23/05 - bug 4451241 (make gensvc 3.0) 
Rem    gan         03/22/05 - Add type display name 
Rem    streddy     02/11/05 - Make aggregate service baselineable 
Rem    ktlaw       01/11/05 - add repmgr header 
Rem    andyao      12/21/04 - add baseline property 
Rem    afontana    10/22/04 - change resource bundle 
Rem    streddy     10/03/04 - Use new metric api to register metrics 
Rem    gan         09/14/04 - add target prop def 
Rem    gan         09/01/04 - create aggregate service type 
Rem    streddy     08/16/04 - streddy_agr_svc_apis
Rem    gan         08/05/04 - Created
Rem


BEGIN
  -- Add metric categories for service class
DECLARE
  l_svc_categories MGMT_CATEGORY_DEF_ARRAY := MGMT_CATEGORY_DEF_ARRAY();
BEGIN
  -- =-= str - add nls-ids when UI support is added
  l_svc_categories.extend(2);
  l_svc_categories(1) := MGMT_CATEGORY_DEF_OBJ.NEW(mgmt_global.G_SERVICE_CATEGORY_USAGE, NULL);
  l_svc_categories(2) := MGMT_CATEGORY_DEF_OBJ.NEW(mgmt_global.G_SERVICE_CATEGORY_PERFORMANCE, NULL);

  mgmt_metric.create_category_class(
              p_class_name        => mgmt_global.G_CATEGORY_CLASS_SERVICE,
              p_class_name_nlsid  => NULL, 
              p_category_def_list => l_svc_categories);

END;
END;
/
 show errors;




-- Register generic service type and its metrics
BEGIN
  em_service.initialize_service_type(MGMT_GLOBAL.G_GENERIC_SERVICE_TYPE,
                                     FALSE, '1.0', 'Generic Service');

  -- Initialize with at least G.S. 3.0.
  -- This is to workaround the bug where 10.1 agent uploads
  -- bogus metadata for G.S. 2.0
  em_service.initialize_service_type(MGMT_GLOBAL.G_GENERIC_SERVICE_TYPE,
                                     FALSE, '3.0', 'Generic Service');


  MGMT_TARGET.add_target_type_property(MGMT_GLOBAL.G_GENERIC_SERVICE_TYPE,
                                       MGMT_GLOBAL.G_IS_BASELINEABLE_PROP,
                                       'true');

  -- Set the path to the resource bundle for the service
  UPDATE MGMT_TARGET_TYPES
     SET TYPE_RESOURCE_BUNDLE = 'oracle.sysman.resources.gensvc'
   WHERE TARGET_TYPE = 'generic_service';

  -- add other generic_service spscified metric here
END;

/

-- Register aggregate service type
BEGIN
  em_service.initialize_service_type(MGMT_GLOBAL.G_AGGREGATE_SERVICE_TYPE,
                                     TRUE, '1.0', 'Aggregate Service');

  MGMT_TARGET.add_target_type_property(MGMT_GLOBAL.G_AGGREGATE_SERVICE_TYPE,
                                       MGMT_GLOBAL.G_IS_BASELINEABLE_PROP,
                                       'true');

  -- add assoc callback
  mgmt_assoc.add_assoc_deletion_callback(
         'EM_SERVICE.assoc_deletion_callback',
         mgmt_assoc.assoc_def_runs_on);
  mgmt_assoc.add_assoc_addition_callback(
         'EM_SERVICE.assoc_addition_callback',
         mgmt_assoc.assoc_def_runs_on);
         
END;
/
show errors;


BEGIN
DECLARE
PROCEDURE add_prop_def(p_service_type IN VARCHAR2, 
                       p_property_name IN VARCHAR2,
                       p_type_meta_ver IN VARCHAR2)
AS
BEGIN
   BEGIN
      INSERT INTO mgmt_target_prop_defs(target_type, type_meta_ver,
                       property_name, 
                       property_display_name, hidden_flag)
      VALUES(p_service_type, p_type_meta_ver, p_property_name, p_property_name, 1);
   EXCEPTION
      WHEN DUP_VAL_ON_INDEX THEN
          NULL;
   END;
END;
PROCEDURE add_svc_prop_defs(p_service_type IN VARCHAR2,
                            p_type_meta_ver IN VARCHAR2)
AS
BEGIN
   add_prop_def(p_service_type, 
                EM_SERVICE.G_SVC_HP_USAGE_METRIC_NAME,
                p_type_meta_ver);
   add_prop_def(p_service_type, 
                EM_SERVICE.G_SVC_HP_USAGE_METRIC_COL,
                p_type_meta_ver);
   add_prop_def(p_service_type, 
                EM_SERVICE.G_SVC_HP_USAGE_KEY,
                p_type_meta_ver);
   add_prop_def(p_service_type, 
                EM_SERVICE.G_SVC_HP_PERF_METRIC_NAME,
                p_type_meta_ver);
   add_prop_def(p_service_type, 
                EM_SERVICE.G_SVC_HP_PERF_METRIC_COL,
                p_type_meta_ver);
   add_prop_def(p_service_type, 
                EM_SERVICE.G_SVC_HP_PERF_KEY,
                p_type_meta_ver);
END;
BEGIN
   --add property def for aggregate service
   add_svc_prop_defs(MGMT_GLOBAL.G_AGGREGATE_SERVICE_TYPE, '1.0');
   add_svc_prop_defs(MGMT_GLOBAL.G_GENERIC_SERVICE_TYPE, '1.0');
   add_svc_prop_defs(MGMT_GLOBAL.G_GENERIC_SERVICE_TYPE, '3.0');
   COMMIT;
END;
END;
/
show errors;

