Rem drv: <migrate type="data_upgrade" version="10.2.0.0" pos="severity/severity_data_upgrade.sql+"/>
Rem
Rem $Header: statbsln_data_upgrade.sql 30-aug-2005.11:30:37 jberesni Exp $
Rem
Rem statbsln_data_upgrade.sql
Rem
Rem Copyright (c) 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      statbsln_data_upgrade.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    jberesni    08/30/05 - register bsln jobs
Rem    jberesni    08/30/05 - remove submit bsln jobs 
Rem    chyu        07/26/05 - modifying the migrate header position 
Rem    chyu        07/18/05 - updating the new rep manager header 
Rem    jsoule      02/25/05 - jsoule_statbsln_upgrade
Rem    jsoule      02/24/05 - Created
Rem
-----------------------------------
-- register the statbsln jobs 
-----------------------------------
begin
   mgmt_log.register_logging_module
      (v_job_name_in     => 'SET ADAPTIVE THRESHOLDS'
      ,v_display_name_in => 'Set Adaptive Metric Thresholds'
      ,v_dbms_jobname_in => mgmt_Bsln_internal.K_SET_THRESHOLDS_JOB
      );
   mgmt_log.register_logging_module
      (v_job_name_in     => 'COMPUTE METRIC BASELINE STATISTICS'
      ,v_display_name_in => 'Compute Metric Baseline Statistics'
      ,v_dbms_jobname_in => mgmt_bsln_internal.K_COMPUTE_STATS_JOB
      );
exception
   when others then RAISE;
end;
/

-------------------------------------------
--  metrics for generic services
-------------------------------------------
begin
   insert into mgmt_bsln_metrics
      (METRIC_UID
      ,TAIL_ESTIMATOR
      ,THRESHOLD_METHOD_DEFAULT
      ,NUM_OCCURRENCES_DEFAULT
      ,WARNING_PARAM_DEFAULT
      ,CRITICAL_PARAM_DEFAULT
      )
   values
      -- generic service.performance metric UID
      (mgmt_bsln.metric_uid(HEXTORAW('2AF5045B41B1046D72D58FC22AB66592'))
      ,'EXPTAIL'
      ,mgmt_bsln.K_METHOD_SIGLVL
      ,mgmt_bsln.K_DEFAULT_NUM_OCCURS
      ,mgmt_bsln.K_SIGLVL_999
      ,mgmt_bsln.K_SIGLVL_9999
      );

   insert into mgmt_bsln_metrics
      (METRIC_UID
      ,TAIL_ESTIMATOR
      ,THRESHOLD_METHOD_DEFAULT
      ,NUM_OCCURRENCES_DEFAULT
      ,WARNING_PARAM_DEFAULT
      ,CRITICAL_PARAM_DEFAULT
      )
   values
      -- generic service.usage metric UID
      (mgmt_bsln.metric_uid(HEXTORAW('11736AED0AA5FE81CE3B328E0C14F266'))
      ,'EXPTAIL'
      ,mgmt_bsln.K_METHOD_SIGLVL
      ,mgmt_bsln.K_DEFAULT_NUM_OCCURS
      ,mgmt_bsln.K_SIGLVL_999
      ,mgmt_bsln.K_SIGLVL_9999
      );
commit;
end;
/

-------------------------------------------
--  metrics for aggregate services
-------------------------------------------
begin
   insert into mgmt_bsln_metrics
      (METRIC_UID
      ,TAIL_ESTIMATOR
      ,THRESHOLD_METHOD_DEFAULT
      ,NUM_OCCURRENCES_DEFAULT
      ,WARNING_PARAM_DEFAULT
      ,CRITICAL_PARAM_DEFAULT
      )
   values
      -- aggregate service.performance metric UID
      (mgmt_bsln.metric_uid(HEXTORAW('2C0557DBDB3864419BFBB54264D037BE'))
      ,'EXPTAIL'
      ,mgmt_bsln.K_METHOD_SIGLVL
      ,mgmt_bsln.K_DEFAULT_NUM_OCCURS
      ,mgmt_bsln.K_SIGLVL_999
      ,mgmt_bsln.K_SIGLVL_9999
      );

   insert into mgmt_bsln_metrics
      (METRIC_UID
      ,TAIL_ESTIMATOR
      ,THRESHOLD_METHOD_DEFAULT
      ,NUM_OCCURRENCES_DEFAULT
      ,WARNING_PARAM_DEFAULT
      ,CRITICAL_PARAM_DEFAULT
      )
   values
      -- aggregate service.usage metric UID
      (mgmt_bsln.metric_uid(HEXTORAW('4FE0E06B443EFEF25EED1E19A9EECB12'))
      ,'EXPTAIL'
      ,mgmt_bsln.K_METHOD_SIGLVL
      ,mgmt_bsln.K_DEFAULT_NUM_OCCURS
      ,mgmt_bsln.K_SIGLVL_999
      ,mgmt_bsln.K_SIGLVL_9999
      );
commit;
end;
/

-------------------------------------------
--  metrics for web applications
-------------------------------------------
begin
   insert into mgmt_bsln_metrics
      (METRIC_UID
      ,TAIL_ESTIMATOR
      ,THRESHOLD_METHOD_DEFAULT
      ,NUM_OCCURRENCES_DEFAULT
      ,WARNING_PARAM_DEFAULT
      ,CRITICAL_PARAM_DEFAULT
      )
   values
      -- web application.performance metric UID
      (mgmt_bsln.metric_uid(HEXTORAW('72DC44207FECD7FF21E0C92D7ADDC9FA'))
      ,'EXPTAIL'
      ,mgmt_bsln.K_METHOD_SIGLVL
      ,mgmt_bsln.K_DEFAULT_NUM_OCCURS
      ,mgmt_bsln.K_SIGLVL_999
      ,mgmt_bsln.K_SIGLVL_9999
      );

   insert into mgmt_bsln_metrics
      (METRIC_UID
      ,TAIL_ESTIMATOR
      ,THRESHOLD_METHOD_DEFAULT
      ,NUM_OCCURRENCES_DEFAULT
      ,WARNING_PARAM_DEFAULT
      ,CRITICAL_PARAM_DEFAULT
      )
   values
      -- web application.usage metric UID
      (mgmt_bsln.metric_uid(HEXTORAW('283A9020E4C4C6FB8396366E94C188DC'))
      ,'EXPTAIL'
      ,mgmt_bsln.K_METHOD_SIGLVL
      ,mgmt_bsln.K_DEFAULT_NUM_OCCURS
      ,mgmt_bsln.K_SIGLVL_999
      ,mgmt_bsln.K_SIGLVL_9999
      );
commit;
end;
/
