Rem DO NOT ADD HEADER HERE, and DO NOT DELETE THIS FILE EITHER.  THIS FILE
Rem IS BEING REFERENCED FROM storage_init.sql
Rem
Rem $Header: storage_ui_post_creation.sql 19-jul-2005.13:35:06 chyu Exp $
Rem
Rem storage_ui_post_creation.sql
Rem
Rem Copyright (c) 2004, 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      storage_ui_post_creation.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      contains registration of storage repository collection
Rem      metrics and callbacks for storage history of a host.
Rem
Rem    NOTES
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    chyu        07/19/05 - modifying the new rep manager header 
Rem    gsbhatia    07/03/05 - Remove repmgr header 
Rem    rmenon      03/25/05 - 
Rem    ajdsouza    03/25/05 - moved from latest
Rem    rmenon      02/28/05 - fixed the bug due to which the collection
Rem                           frequency was incorrectly specified for
Rem                           on demand schedule
Rem    ktlaw       01/11/05 - add repmgr header 
Rem    rpinnama    01/10/05 - Create the storage metrics from 3.0 onwards 
Rem    rpinnama    01/07/05 - Fixing create_metric usage 
Rem    rmenon      12/09/04 - added 'total number of hosts'
Rem                           and 'summarized number of hosts'
Rem                           metrics for a host target as well.
Rem    rmenon      11/29/04 - change metric column constant names
Rem                           so that host and group use the same
Rem                           metric constant names.
Rem    rmenon      11/11/04 - forgot to uncomment logic to 
Rem                           add default storage history collection
Rem                           to a host - corrected that.
Rem    rmenon      11/10/04 - added metric nls ids to metric name
Rem                           while creating metric.
Rem    rmenon      10/23/04 - host/group history related changes
Rem    rmenon      10/09/04 - rmenon_storage_group_ui_and_sql_code_refactor
Rem    rmenon      09/30/04 - Created
Rem

SET ECHO ON
SET FEEDBACK 1
SET NUMWIDTH 10
SET LINESIZE 80
SET TRIMSPOOL ON
SET TAB OFF
SET PAGESIZE 100

declare
  l_dependent_snapshot_list mgmt_snapshot_array;
  l_metric_column mgmt_metric_column_obj;
  l_index number := 0;
  l_host_metric_column_list mgmt_metric_column_array;
  l_host_hist_valid_if mgmt_validif_obj;
  l_host_hist_valid_if_list mgmt_validif_array;
begin
  l_host_hist_valid_if_list := mgmt_validif_array();
  l_host_hist_valid_if_list.extend(1);
  l_host_hist_valid_if_list := mgmt_validif_array(
    mgmt_validif_obj.new( 
      p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY( 'Linux', 'SunOS',
        'AIX', 'HP-UX')));
  l_dependent_snapshot_list := mgmt_snapshot_array
  (
    mgmt_snapshot_obj.new
    (
      p_target_type => mgmt_global.G_HOST_TARGET_TYPE,
      p_snapshot_name => storage_ui_common_pkg.G_HOST_STORAGE_COLL_NAME,
      p_store_metric => mgmt_global.G_TRUE 
    )
  );
  ---------------------------------------------------------
  --- We add a repository metric that gets collected  -----
  --- daily. The metric contains storage related data -----
  --- to be shown in the storage history UI of group. -----
  ---------------------------------------------------------
  storage_rep_metrics_pkg.create_storage_rep_hist_metric
  (
     p_target_type => mgmt_global.G_COMPOSITE_TARGET_TYPE,
     p_type_meta_ver => '1.0'
  );

  COMMIT;

  ---------------------------------------------------------
  --- We add a repository metric that gets collected  -----
  --- daily. The metric contains storage related data -----
  --- to be shown in the storage history UI of host.  -----
  ---------------------------------------------------------
 
  -- all the numeric columns can be added in a loop.
  l_host_metric_column_list := mgmt_metric_column_array();
  for i in 1..storage_rep_metrics_pkg.G_HOST_COLUMN_NAME_LIST.count 
  loop
    l_metric_column := 
      mgmt_metric_column_obj.new
      (
        p_column_name => storage_rep_metrics_pkg.G_HOST_COLUMN_NAME_LIST(i),
        p_column_type => mgmt_global.G_METRIC_TYPE_NUMBER,
        p_column_label => storage_rep_metrics_pkg.G_HOST_COLUMN_LABEL_LIST(i),
        p_column_label_nlsid => storage_rep_metrics_pkg.G_HOST_COLUMN_NLSID_LIST(i),
        p_is_key => 0
      );
  
    l_host_metric_column_list.extend(1);
    l_host_metric_column_list( i ) := l_metric_column;
  end loop;
  mgmt_metric.create_metric
  (
      p_target_type => mgmt_global.G_HOST_TARGET_TYPE,
      p_metric_name => storage_rep_metrics_pkg.G_HOST_STORAGE_REP_METRIC,
      p_type_meta_ver => '3.0',
      p_valid_if_list => l_host_hist_valid_if_list,
      p_metric_type => mgmt_global.G_METRIC_TYPE_REPOS_TABLE,
      p_source=>storage_rep_metrics_pkg.G_HOST_STORAGE_REP_METRIC_PROC,
      p_source_type => mgmt_global.G_METRIC_SOURCE_OLD_PLSQL,
      p_category_list => null,
      p_metric_label => 
        storage_rep_metrics_pkg.G_HOST_STORAGE_REP_METRIC_LBL,
      p_is_repository => MGMT_GLOBAL.G_TRUE,
      p_metric_label_nlsid => 
        storage_rep_metrics_pkg.G_HOST_STORAGE_HIST_MET_NLSID,
      p_snapshot_name_list => l_dependent_snapshot_list,
      p_metric_column_list => l_host_metric_column_list 
  );

  -- in case of a host, you want the history to be enabled by
  -- default. Hence we create a default collection for the host
  -- note that this collection does not have any schedule - 
  -- it gets collected whenever we get a new host_storage
  -- snapshot. Normally this would happen once daily or whenever
  -- you do a manual refresh from the storage UI pages.

  mgmt_collection.add_default_collection
  (
    p_target_type=>mgmt_global.G_HOST_TARGET_TYPE,
    p_type_meta_ver=> '3.0',
    p_metrics_list => mgmt_short_string_array(
      storage_rep_metrics_pkg.G_HOST_STORAGE_REP_METRIC),
    p_coll_name=>storage_rep_metrics_pkg.G_HOST_STORAGE_HIST_COLL,
    p_valid_if_list => l_host_hist_valid_if_list,
    p_coll_schedule=>mgmt_coll_schedule_obj.on_demand_schedule,
    p_coll_properties=>null
  );     

  COMMIT;

  ---------------------------------------------------------
  --- We register a command that would refresh storage-----
  --- data of a host.                                 -----
  ---------------------------------------------------------

  mgmt_jobs.register_command
  (
    p_command_name => 'hostStorageRefreshCommand',
    p_class_name => 'oracle.sysman.eml.storage.host.HostStorageRefreshCommand'
  );

  COMMIT;

END;
/
