Rem
Rem $Header: storage_ui_tables.sql 29-jun-2005.01:47:54 gsbhatia Exp $
Rem
Rem storage_ui_tables.sql
Rem
Rem Copyright (c) 2004, 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      storage_ui_tables.sql - 
Rem
Rem    DESCRIPTION
Rem      contains tables used in rendering UI.
Rem
Rem    NOTES
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    gsbhatia    06/26/05 - New repmgr header impl 
Rem    ajdsouza    03/25/05 - move from latest
Rem    gsbhatia    02/13/05 - updating repmgr header 
Rem    gsbhatia    02/09/05 - updating repmgr header 
Rem    gsbhatia    02/07/05 - updating repmgr header 
Rem    ktlaw       01/11/05 - add repmgr header 
Rem    rmenon      10/09/04 - rmenon_storage_group_ui_and_sql_code_refactor
Rem    rmenon      09/23/04 - Created
Rem

SET ECHO ON
SET FEEDBACK 1
SET NUMWIDTH 10
SET LINESIZE 80
SET TRIMSPOOL ON
SET TAB OFF
SET PAGESIZE 100

------------------------------------------------------------
--  PURPOSE
--
--    The mgmt_storage_report_ui_targets temporary table 
--    contains host target names for which the UI is being
--    rendered. The UI code inserts the host names (for group
--    the expanded list of group's host members) for which the UI
--    is being rendered. Since we know that all targets are
--    of type host, we dont store target type information
--    currently in this table.
--
--  TABLE ORGANIZATION RATIONALE:
--
--    As of Oracle 9.0.1.5.0, following choices exist to define 
--    a table's organization in Oracle.
--
--    1. Heap (default)
--    2. Index Organized
--    3. Clustered table
--    4. Hash clustered table
--    5. Nested table
--    6. Temporary table
--    7. Object table
--
--    We chose the organization "temporary" because 
--    1. The data being stored in this table is temporary - it makes
--       sense only for the session for which the UI is being rendered.
--    2. No cross session overhead is incurred related to maintaining
--       concurrency; also by definition of the temporary table, one
--       session can not see another session's data - which is what
--       we want.
--
--    We ruled out the following alternative(s) for the reasons given.
--
--      Collections(Nested tables using SQL types ):
--
--      1. The syntax of querying from temporary tables is simpler.
--      2. There are known bugs currently when you use nested tables
--         in views.
--      3. You cant use indexes with nested tables if a requirement
--         comes in later.
--
--  COLUMNS
--
--    target_name - the name of the target (host) for which
--                  the UI is to be rendered.
--    target_guid - the GUID of the target (host) for which
--                  the UI is to be rendered.
--
--  NOTES
------------------------------------------------------------

create global temporary table mgmt_storage_report_ui_targets
(
  target_type varchar2(64) not null,
  target_name varchar2(256) not null,
  target_guid raw(16) not null
)  monitoring;
--on commit preserve rows;
