Rem
Rem $Header: storage_ui_types.sql 19-jul-2005.16:15:49 ajere Exp $
Rem
Rem storage_types.sql
Rem
Rem Copyright (c) 2004, 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      storage_types.sql 
Rem
Rem    DESCRIPTION
Rem      types used in storage functionality
Rem
Rem    NOTES
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    ajere       07/18/05 - Fix bug# 4494435 
Rem    gsbhatia    06/26/05 - New repmgr header impl 
Rem    ajere       06/15/05 - Fix bug# 4300002 
Rem    ajdsouza    03/25/05 - moved from latest
Rem    gsbhatia    02/13/05 - updating repmgr header 
Rem    gsbhatia    02/09/05 - updating repmgr header 
Rem    gsbhatia    02/07/05 - updating repmgr header 
Rem    ktlaw       01/11/05 - add repmgr header 
Rem    rmenon      11/11/04 - 
Rem    rmenon      10/13/04 - 
Rem    rmenon      10/04/04 - 
Rem    rmenon      08/16/04 - added types used in history UI
Rem    ajdsouza    08/10/04 - ajdsouza_ecm_processing
Rem    ajdsouza    08/09/04 - 
Rem    rmenon      08/02/04 - rmenon_storage_refresh_error_page_checkin
Rem    rmenon      07/20/04 - Created
Rem

Rem SET ECHO ON
Rem SET FEEDBACK 1
Rem SET NUMWIDTH 10
Rem SET LINESIZE 80
Rem SET TRIMSPOOL ON
Rem SET TAB OFF
Rem SET PAGESIZE 100

/* Following context is private to storage module.
   We use it to set values that are used in a view
   to get data. This is a mechanism by which a view
   can be parameterized. Note that as the name indicaes
   this context should be used to store only storage
   UI related data.
 */
create or replace context storage_context
using storage_ui_util_pkg;
/

/* Following sql type is used to return storage time series data
   to the UI. Note that the collection time stamp is a varchar2
   since the timestamp is stored in the format CHART_DATE_FORMAT
   which is a private constant in storage_ui_host_pkg package.
 */

create or replace type storage_timeseries_rec as object
(
  collection_timestamp varchar2(25),
  allocated number,
  unallocated number,
  overhead number,
  used number,
  free number
);
/
show errors;

/* Following sql type is used to return storage time series data
   to the UI
 */

create or replace type storage_timeseries_rec_list as 
table of storage_timeseries_rec;
/
show errors;
create or replace type storage_number_table is table of number;
/
show errors;
create or replace type storage_varchar2_table is table of varchar2(256);
/
show errors;

create or replace type target_metric_table is table of varchar2(256);
/
show errors;
