Rem
Rem $Header: template_tables.sql 29-jun-2005.01:47:43 gsbhatia Exp $
Rem
Rem template_tables.sql
Rem
Rem Copyright (c) 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      template_tables.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    gsbhatia    06/26/05 - New repmgr header impl 
Rem    gsbhatia    02/13/05 - updating repmgr header 
Rem    rpinnama    02/09/05 - rpinnama_bug-4167007
Rem    rpinnama    02/09/05 - Created
Rem


CREATE TABLE mgmt_templates
(
    template_guid        RAW(16)        NOT NULL,
    target_type          VARCHAR2(64)   NOT NULL,
    template_name        VARCHAR2(64)   NOT NULL,
    description          VARCHAR2(1024) DEFAULT NULL,
    is_public            NUMBER(1)      DEFAULT 1,
    owner                VARCHAR2(256)  DEFAULT '<SYSTEM>',
    created_date         DATE           DEFAULT SYSDATE,
    last_updated_date    DATE           DEFAULT SYSDATE,
    last_updated_by      VARCHAR2(256)  DEFAULT '<SYSTEM>'
)
MONITORING;

COMMENT ON TABLE mgmt_templates IS
    'This table stores the monitoring template definition.';

COMMENT ON COLUMN mgmt_templates.template_guid IS
    'The GUID of the template. Generated as 
      MD5(ora$template; target_type; template_name).';

COMMENT ON COLUMN mgmt_templates.template_name IS
    'The name of the template.';

COMMENT ON COLUMN mgmt_templates.description IS
    'The description of the template.';

COMMENT ON COLUMN mgmt_templates.is_public IS
    'The flag to specify whether the template is accessible to all EM users.';

COMMENT ON COLUMN mgmt_templates.owner IS
    'The EM user who owns the template definition.';

COMMENT ON COLUMN mgmt_templates.created_date IS
    'The date/time when the template is created in the repository.';

COMMENT ON COLUMN mgmt_templates.last_updated_date IS
    'The date/time when the template was last updated in the repository.';

COMMENT ON COLUMN mgmt_templates.last_updated_by IS
    'The EM user who last updated the template definition.';




CREATE TABLE mgmt_template_copies
(
    template_copy_guid     RAW(16)       NOT NULL,
    template_guid          RAW(16)       NOT NULL,
    target_guid            RAW(16)       NOT NULL,
    copy_req_guid          RAW(16)       NOT NULL,
    copy_type              NUMBER(1)     DEFAULT 0,
    created_date           DATE          DEFAULT SYSDATE,
    created_by             VARCHAR2(256) DEFAULT '<SYSTEM>'
)
MONITORING;

COMMENT ON TABLE mgmt_template_copies IS
    'This table stores the list of template copies.';

COMMENT ON COLUMN mgmt_template_copies.template_copy_guid IS
    'The GUID that uniquely identifies a template copy.';

COMMENT ON COLUMN mgmt_template_copies.template_guid IS
    'The GUID of the template from which the copy is created.';

COMMENT ON COLUMN mgmt_template_copies.target_guid IS
    'The GUID of the target from which the copy is created.';

COMMENT ON COLUMN mgmt_template_copies.copy_req_guid IS
    'The GUID associated with the copy request.';

COMMENT ON COLUMN mgmt_template_copies.copy_type IS
    'The type of template copy 
     0 - All (All key configurations are copied)
     1 - Common (Only the key configurations that are already present for
         the target are copied with values from template definition).';

COMMENT ON COLUMN mgmt_template_copies.created_date IS
    'The date when the template copy was created.';

COMMENT ON COLUMN mgmt_template_copies.created_by IS
    'The EM user who created the template copy.';


-- 
-- This table stores the set of monitoring setting copies
-- created to support pushing data to multi-agents

CREATE TABLE mgmt_mntr_set_copies
(
    mntr_set_copy_guid     RAW(16)       NOT NULL,
    target_guid            RAW(16)       NOT NULL,
    copy_req_guid          RAW(16)       NOT NULL,
    created_date           DATE          DEFAULT SYSDATE,
    created_by             VARCHAR2(256) DEFAULT '<SYSTEM>'
)
MONITORING;

COMMENT ON TABLE mgmt_mntr_set_copies IS
    'This table stores the list of monitoring settings copies';

COMMENT ON COLUMN mgmt_mntr_set_copies.mntr_set_copy_guid IS
    'The GUID that uniquely identifies the monitoring setting copy.';

COMMENT ON COLUMN mgmt_mntr_set_copies.target_guid IS
    'The target for which this monitoring setting copy was created.';

COMMENT ON COLUMN mgmt_mntr_set_copies.target_guid IS
    'The copy request guid for which this copy was created.';

COMMENT ON COLUMN mgmt_mntr_set_copies.created_date IS
    'The date/time when the monitoring settings copy was created.';

COMMENT ON COLUMN mgmt_mntr_set_copies.created_by IS
    'The EM user who created the monitoring setting copy.';

