Rem
Rem $Header: template_types.sql 29-jun-2005.01:46:46 gsbhatia Exp $
Rem
Rem template_types.sql
Rem
Rem Copyright (c) 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      template_types.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    gsbhatia    06/26/05 - New repmgr header impl 
Rem    gsbhatia    02/13/05 - updating repmgr header 
Rem    rpinnama    02/09/05 - rpinnama_bug-4167007
Rem    rpinnama    02/09/05 - Created
Rem


CREATE OR REPLACE TYPE mgmt_template_access AS OBJECT
(
    user_name   VARCHAR2(256),
    privilege   VARCHAR2(30),
    STATIC FUNCTION NEW( 
        p_user_name   IN VARCHAR2,
        p_privilege   IN VARCHAR2
      ) 
    RETURN MGMT_TEMPLATE_ACCESS
);
/

CREATE OR REPLACE TYPE mgmt_template_access_array IS TABLE OF mgmt_template_access;
/


CREATE OR REPLACE TYPE mgmt_mntr_metric AS OBJECT
(
    metric_name   VARCHAR2(64),
    metric_column VARCHAR2(64),
    coll_name     VARCHAR2(64),
    is_enabled    NUMBER(1),
    key_val_list  MGMT_POLICY_KEY_VAL_ARRAY,
    STATIC FUNCTION NEW( 
        p_metric_name   IN VARCHAR2,
        p_metric_column IN VARCHAR2,
        p_coll_name     IN VARCHAR2,
	p_is_enabled    IN NUMBER DEFAULT 1,
	p_key_val_list  IN MGMT_POLICY_KEY_VAL_ARRAY DEFAULT NULL
      ) 
    RETURN MGMT_mntr_METRIC
);
/

CREATE OR REPLACE TYPE mgmt_mntr_metric_array IS TABLE OF mgmt_mntr_metric;
/

CREATE OR REPLACE TYPE mgmt_mntr_policy AS OBJECT
( 
    policy_name   VARCHAR2(64),
    coll_name     VARCHAR2(64),
    is_enabled    NUMBER(1),
    key_val_list  MGMT_POLICY_KEY_VAL_ARRAY,
    STATIC FUNCTION NEW( 
        p_policy_name   IN VARCHAR2,
        p_coll_name     IN VARCHAR2,
	p_is_enabled    IN NUMBER DEFAULT 1,
	p_key_val_list  IN MGMT_POLICY_KEY_VAL_ARRAY DEFAULT NULL
      ) 
    RETURN MGMT_mntr_POLICY
);
/

CREATE OR REPLACE TYPE mgmt_mntr_policy_array IS TABLE OF mgmt_mntr_policy;
/

CREATE OR REPLACE TYPE mgmt_coll_prop AS OBJECT
(
    name      VARCHAR2(64),
    value     VARCHAR2(4000),
    STATIC FUNCTION NEW( 
        p_name   IN VARCHAR2,
        p_value  IN VARCHAR2
      ) 
    RETURN MGMT_COLL_PROP
);
/

CREATE OR REPLACE TYPE mgmt_coll_prop_array IS TABLE OF mgmt_coll_prop;
/

CREATE OR REPLACE TYPE mgmt_coll_metric AS OBJECT
(
    metric_name      VARCHAR2(64),
    property_list    MGMT_COLL_PROP_ARRAY,
    credentials      MGMT_CRED_ARRAY,
    STATIC FUNCTION NEW( 
        p_metric_name    IN VARCHAR2,
        p_property_list  IN MGMT_COLL_PROP_ARRAY DEFAULT NULL,
	p_credentials    IN MGMT_CRED_ARRAY DEFAULT NULL
      ) 
    RETURN MGMT_COLL_METRIC
);
/

CREATE OR REPLACE TYPE mgmt_coll_metric_array IS TABLE OF mgmt_coll_metric;
/

CREATE OR REPLACE TYPE mgmt_mntr_collection AS OBJECT
(
    coll_name         VARCHAR2(64),
    is_enabled        NUMBER(1),
    is_transposed     NUMBER(1),
    store_metric      NUMBER(1),
    upload_frequency  NUMBER,
    schedule_ex       VARCHAR2(1024),
    schedule          MGMT_COLL_SCHEDULE_OBJ,
    metric_list       MGMT_COLL_METRIC_ARRAY,
    STATIC FUNCTION NEW( 
        p_coll_name        IN VARCHAR2,
        p_is_enabled       IN NUMBER DEFAULT 1,
	p_is_transposed    IN NUMBER DEFAULT 0,
	p_store_metric     IN NUMBER DEFAULT 1,
	p_upload_frequency IN NUMBER DEFAULT 1,
	p_schedule_ex      IN VARCHAR2 DEFAULT NULL,
	p_schedule         IN MGMT_COLL_SCHEDULE_OBJ DEFAULT NULL,
	p_metric_list      IN MGMT_COLL_METRIC_ARRAY DEFAULT NULL
      ) 
    RETURN MGMT_mntr_COLLECTION
);
/

CREATE OR REPLACE TYPE mgmt_mntr_collection_array IS TABLE OF mgmt_mntr_collection;
/

CREATE OR REPLACE TYPE mgmt_mntr_ca AS OBJECT
(   
    ca_name   VARCHAR2(256),
    ca_creds  MGMT_JOB_CRED_ARRAY,
    STATIC FUNCTION NEW( 
        p_ca_name    IN VARCHAR2,
        p_ca_creds   IN MGMT_JOB_CRED_ARRAY
      ) 
    RETURN MGMT_mntr_CA
);
/

CREATE OR REPLACE TYPE mgmt_mntr_ca_array IS TABLE OF mgmt_mntr_ca;
/

CREATE OR REPLACE TYPE mgmt_mntr_target AS OBJECT
(   
    target_name  VARCHAR2(256),
    target_type  VARCHAR2(64),
    apply_type   NUMBER
);
/

CREATE OR REPLACE TYPE mgmt_mntr_target_array IS TABLE OF mgmt_mntr_target;
/

