Rem drv: <migrate type="schema_upgrade" version="10.2.0.0"  params="EM_ECM_DEPOT_TABLESPACE" pos="test_metadata/test_metadata_schema_upgrade.sql+"/>
Rem
Rem $Header: topology_schema_upgrade.sql 25-jul-2005.14:04:30 chyu Exp $
Rem
Rem topology_schema_upgrade.sql
Rem
Rem Copyright (c) 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      topology_schema_upgrade.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    chyu        07/25/05 - modifying the upgrade header 
Rem    chyu        07/18/05 - adding the <migration> header 
Rem    nigupta     02/16/05 - nigupta_rep_test
Rem    nigupta     02/15/05 - Created
Rem

rem
rem This script requires the following arguments
rem  1. Name of the ecm_depot tablespace where all LOBs are stored
rem
DEFINE EM_ECM_DEPOT_TABLESPACE = "&1"

rem
rem  PURPOSE
rem    The MGMT_TOPOLOGY_PAGE_BACKGROUND_IMAGE table stores the image name and
rem    content for a topology page or an instance of a topology page
rem 
rem  COLUMNS
rem    TOPO_PAGE_TYPE - 
rem      The identifier for the type of toology page. For eg. for the System
rem      Topology page, this value is 'grpsTopoPageType'. For a page, whose 
rem      background image does not vary from instance to instance of the page, 
rem      this parameter is sufficient to uniquely identify the background image
rem    PAGE_INSTANCE_ID - 
rem      The identifier for a page instance. For eg. System Topology page has 
rem      different background images for different systems, which are identified
rem      by system's GUID. Here, page type and page instance id together 
rem      uniquely identify the background image.
rem    IMAGE_NAME -
rem      The file name of the image. It should end with filename extension .gif,
rem      .svg or .jpg. It does not contain the file's directory name.
rem    IMAGE_DATA -
rem      The file content of the image. It can be of gif, svg or jpg file types.
rem 
CREATE TABLE MGMT_TOPO_PAGE_BG_IMAGE
(
    topo_page_type      VARCHAR2(64)    NOT NULL,
    page_instance_id    VARCHAR2(128)   NOT NULL,
    image_name          VARCHAR2(128)   NOT NULL,
    image_data          BLOB,
    CONSTRAINT PK_MGMT_TOPO_PAGE_BG_IMAGE
    PRIMARY KEY(topo_page_type, page_instance_id)
) MONITORING
  LOB(image_data) STORE AS (TABLESPACE &EM_ECM_DEPOT_TABLESPACE);

rem
rem  PURPOSE
rem    The MGMT_TOPOLOGY_PAGE_PREFERENCE table stores the preference name and 
rem    value for a topology page or an instance of the page. Some examples are
rem    manual layout or auto layout, icon size, etc.
rem 
rem  COLUMNS
rem    TOPO_PAGE_TYPE - 
rem      The identifier for the type of toology page. For eg. for the System
rem      Topology page, this value is 'grpsTopoPageType'. 
rem    PAGE_INSTANCE_ID - 
rem      The identifier for a page instance. 
rem    PREFERENCE_NAME -
rem      The name of the preference parameter. It should follow the variable
rem      naming standard in Oracle Java Coding Standard.
rem    PREFERENCE_VALUE -
rem      The value of the preference
rem 
CREATE TABLE MGMT_TOPO_PAGE_PREF
(
    topo_page_type      VARCHAR2(64)    NOT NULL,
    page_instance_id    VARCHAR2(128)   NOT NULL,
    preference_name     VARCHAR2(128)   NOT NULL,
    preference_value    VARCHAR2(4000)  NOT NULL,
    CONSTRAINT PK_MGMT_TOPO_PAGE_PREF
    PRIMARY KEY(topo_page_type, page_instance_id, preference_name)
) MONITORING;


rem
rem  PURPOSE
rem    The MGMT_TOPOLOGY_PAGE_OBJECT_POSITION table stores the nodes' and 
rem    subgraphs' coordinates.
rem 
rem  COLUMNS
rem    TOPO_PAGE_TYPE - 
rem      The identifier for the type of toology page. For eg. for the System
rem      Topology page, this value is 'grpsTopoPageType'.
rem    PAGE_INSTANCE_ID - 
rem      The identifier for a page instance. 
rem    NODE_ID -
rem      The id for the node instance. It should not be the graphic object ID
rem      that SDK uses when transferring data between browser and server. It 
rem      should be the business object identifier. For eg. in System Topology,
rem      a node or a subgraph is always a target and its node_id should be 
rem      target's GUID.
rem    X -
rem      The x coordinate of the node.
rem    Y -
rem      The y coordinate of the node.
rem
CREATE TABLE MGMT_TOPO_PAGE_OBJ_POS
(
    topo_page_type      VARCHAR2(64)    NOT NULL,
    page_instance_id    VARCHAR2(128)   NOT NULL,
    node_id             VARCHAR2(128)   NOT NULL,
    x                   NUMBER(5)       DEFAULT 0,
    y                   NUMBER(5)       DEFAULT 0,
    CONSTRAINT PK_MGMT_TOPO_PAGE_OBJ_POS
    PRIMARY KEY(topo_page_type, page_instance_id, node_id)
) MONITORING;    



CREATE OR REPLACE TYPE TOPO_NODE_POS AS OBJECT (
    node_id VARCHAR2(128),
    x       NUMBER(5),
    y       NUMBER(5)
);
/

CREATE OR REPLACE TYPE TOPO_NODE_POS_ARRAY AS TABLE OF TOPO_NODE_POS;
/
