Rem drv: <migrate type="schema_upgrade" version="10.2.0.0" pos="topology_schema_upgrade.sql+"/>
Rem
Rem $Header: trace_schema_upgrade.sql 25-jul-2005.14:04:31 chyu Exp $
Rem
Rem trace_schema_upgrade.sql
Rem
Rem Copyright (c) 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      trace_schema_upgrade.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    chyu        07/25/05 - modifying the upgrade header 
Rem    chyu        07/18/05 - adding the <migration> header 
Rem    rpinnama    02/06/05 - rpinnama_add_upgrade_scripts
Rem    rpinnama    02/04/05 - Created
Rem

Rem Upgrade trace types

Rem Upgrade trace tables
CREATE TABLE emdw_trace_config
( context_type_Id    NUMBER(3)    NOT NULL,
  context_type       VARCHAR2(30) NOT NULL,
  trace_level        NUMBER(1)    DEFAULT 0 NOT NULL ,
  create_date        DATE         DEFAULT SYSDATE NOT NULL ,
  last_update_date   DATE         DEFAULT SYSDATE NOT NULL ,
  CONSTRAINT emdw_trace_config_trclevel  CHECK ( Trace_level between 0 and 4) ,
  CONSTRAINT emdw_trace_config_uppercase CHECK (context_type=upper(context_type)) ,
  CONSTRAINT emdw_trace_config_noblanks  CHECK ( instr(context_type,' ')=0) ,
  CONSTRAINT emdw_trace_config_pk primary key (context_type_id)
)
MONITORING;

ALTER TABLE emdw_trace_config
ADD CONSTRAINT emdw_Trace_config_u1 unique
(Context_Type)
USING INDEX (
              CREATE INDEX emdw_trace_config_idx_01 ON 
                           emdw_trace_config(Context_Type,Context_Type_Id,Trace_Level)
            ) ;



CREATE SEQUENCE emdw_trace_context_type_id_seq
INCREMENT BY 1 START WITH 1
MAXVALUE 1.0E28 MINVALUE 1 NOCYCLE
NOCACHE ORDER;

CREATE TABLE emdw_trace_data
(
 context_type_Id    NUMBER(3)     NOT NULL,
 context_identifier VARCHAR2(30),
 log_level          NUMBER(1)     NOT NULL,
 log_timestamp      TIMESTAMP     NOT NULL,
 log_message        VARCHAR2(1000) ,
 module             VARCHAR2(100),
 oms_host           VARCHAR2(100),
 CONSTRAINT emdw_trace_data_fk 
        FOREIGN KEY (context_type_id) REFERENCES
         EMDW_TRACE_CONFIG(context_type_id)
        ON DELETE CASCADE
) 
MONITORING;

CREATE INDEX EMDW_TRACE_DATA_IDX_01
ON EMDW_TRACE_DATA
 (
  context_type_id,
  log_timeStamp,
  log_level
  ) 
COMPRESS 1;


