Rem
Rem $Header: beacon_post_creation.sql 19-jul-2005.13:35:07 chyu Exp $
Rem
Rem beacon_post_creation.sql
Rem
Rem Copyright (c) 2002, 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      beacon_post_creation.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    chyu        07/19/05 - modifying the new rep manager header 
Rem    gsbhatia    07/03/05 - Remove repmgr header 
Rem    mfidanbo    03/19/05 - mfidanbo_upgrade_post_creation
Rem    mfidanbo    03/03/05 - Beacon post_creation upgrade
Rem

DECLARE
BEGIN
  em_service.initialize_service_type(MGMT_GLOBAL.G_WEBSITE_TARGET_TYPE, FALSE, '3.0');

  MGMT_TARGET.add_target_type_property(MGMT_GLOBAL.G_WEBSITE_TARGET_TYPE,
                                       'IsBaselineable', 
                                       'true');

  -- Set the path to the resource bundle for the service
  UPDATE MGMT_TARGET_TYPES
     SET TYPE_RESOURCE_BUNDLE = 'oracle.sysman.resources.website'
   WHERE TARGET_TYPE = MGMT_GLOBAL.G_WEBSITE_TARGET_TYPE;
END;
/

BEGIN
DECLARE

  PROCEDURE add_prop_def(p_service_type IN VARCHAR2, p_type_meta_ver IN VARCHAR2, p_property_name IN VARCHAR2)
  AS
  BEGIN
     dbms_output.put_line('adding props');
     BEGIN
        INSERT INTO mgmt_target_prop_defs(target_type, type_meta_ver,
                         property_name,
                         property_display_name, hidden_flag)
        VALUES(p_service_type, p_type_meta_ver, p_property_name, p_property_name, 1);
     EXCEPTION
        WHEN DUP_VAL_ON_INDEX THEN
            NULL;
     END;
  END; -- PROCEDURE add_prop_def

  PROCEDURE add_svc_prop_defs(p_service_type IN VARCHAR2, p_type_meta_ver IN VARCHAR2)
  AS
  BEGIN
     add_prop_def(p_service_type, p_type_meta_ver, EM_SERVICE.G_SVC_HP_USAGE_METRIC_NAME);
     add_prop_def(p_service_type, p_type_meta_ver, EM_SERVICE.G_SVC_HP_USAGE_METRIC_COL );
     add_prop_def(p_service_type, p_type_meta_ver, EM_SERVICE.G_SVC_HP_USAGE_KEY );
     add_prop_def(p_service_type, p_type_meta_ver, EM_SERVICE.G_SVC_HP_PERF_METRIC_NAME);
     add_prop_def(p_service_type, p_type_meta_ver, EM_SERVICE.G_SVC_HP_PERF_METRIC_COL );
     add_prop_def(p_service_type, p_type_meta_ver, EM_SERVICE.G_SVC_HP_PERF_KEY );
  END; --PROCEDURE add_svc_prop_defs

  BEGIN
     --add property def for website target
     add_svc_prop_defs(MGMT_GLOBAL.G_WEBSITE_TARGET_TYPE, '3.0');
     COMMIT;
  EXCEPTION
    WHEN OTHERS THEN
      ROLLBACK;
  END; -- for previous BEGIN block
END; --
/
show errors;


BEGIN
  UPDATE MGMT_METRICS SET remote = 1 
   WHERE target_type = MGMT_GLOBAL.G_WEBSITE_TARGET_TYPE 
     AND (type_meta_ver = '1.0' OR type_meta_ver = '2.0')
     AND metric_name <> MGMT_GLOBAL.G_AVAIL_METRIC_NAME;
  
  UPDATE MGMT_METRICS SET remote = 1 
   WHERE target_type = MGMT_GLOBAL.G_BEACON_TARGET_TYPE
     AND (type_meta_ver = '1.0' OR type_meta_ver = '2.0')
     AND metric_name <> MGMT_GLOBAL.G_AVAIL_METRIC_NAME;

  --EMD_BCN_ADMIN.GEN_BEACON_RESP_METRICS(MGMT_GLOBAL.G_WEBSITE_TARGET_TYPE, '3.0');
  EMD_BCN_ADMIN.GEN_BEACON_RESP_METRICS(MGMT_GLOBAL.G_WEBSITE_TARGET_TYPE, '2.0');
  EMD_BCN_ADMIN.GEN_BEACON_RESP_METRICS(MGMT_GLOBAL.G_WEBSITE_TARGET_TYPE, '1.0');
  COMMIT;
EXCEPTION
  WHEN OTHERS THEN
    ROLLBACK;
END;
/


BEGIN
  EM_PURGE.drop_purge_policy('MGMT_BCN_AVAIL_LOG');
  COMMIT;
END;
/

show errors;
