Rem drv: <migrate type="schema_upgrade" version="10.2.0.1" pos="ecm_schema_upgrade.sql+"/>
Rem
Rem $Header: assoc_schema_upgrade.sql 25-jul-2005.14:22:31 chyu Exp $
Rem
Rem assoc_schema_upgrade.sql
Rem
Rem Copyright (c) 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      assoc_schema_upgrade.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    chyu        07/25/05 - modifying the upgrade header 
Rem    chyu        07/18/05 - adding the upgrade header 
Rem    pmodi       07/14/05 - pmodi_bug-4486836
Rem    pmodi       07/12/05 - Created
Rem

rem
rem  PURPOSE
rem     The MGMT_TARGET_ASSOC_STATUS table holds the assoc count and last_updated timestamp
rem     for each target.
rem
rem  COLUMNS
rem     TARGET_GUID        - the target id
rem
rem     ASSOC_COUNT        - The association starting from the target
rem
rem     LAST_UPDATE_TIME   - Time at which associations for the target were last updated.
rem

CREATE TABLE MGMT_TARGET_ASSOC_STATUS
    (target_guid        RAW(16) NOT NULL,
     assoc_count        NUMBER  DEFAULT 0,
     last_update_time   DATE    DEFAULT SYSDATE,
     CONSTRAINT PK_MGMT_TARGET_ASSOC_STATUS PRIMARY KEY (target_guid)
    )MONITORING;

DROP TYPE MGMT_TARGET_ASSOC_LIST;

CREATE OR REPLACE TYPE MGMT_TARGET_ASSOC_REC IS OBJECT
(
  assoc_guid RAW(16),
  source_target_guid RAW(16),
  assoc_target_guid RAW(16),
  scope_target_guid RAW(16),
  operation NUMBER(1),
  prop_view_priv NUMBER(1),
  STATIC FUNCTION NEW(p_assoc_guid         IN RAW,
                      p_source_target_guid IN RAW,
                      p_assoc_target_guid  IN RAW,
                      p_scope_target_guid  IN RAW,
                      p_operation          IN NUMBER,
                      p_prop_view_priv     IN NUMBER DEFAULT 0
                     )
  RETURN MGMT_TARGET_ASSOC_REC                   
);
/

CREATE OR REPLACE TYPE MGMT_TARGET_ASSOC_LIST AS TABLE OF MGMT_TARGET_ASSOC_REC;
/
