Rem drv: <migrate type="schema_upgrade" version="10.2.0.1" pos="basic/basic_schema_upgrade.sql-" condition="EM_REPOS_MODE=SYSAUX"/>
Rem
Rem $Header: basic_schema_upgrade_db.sql 03-apr-2007.04:01:15 jsadras Exp $
Rem
Rem basic_schema_upgrade_db.sql
Rem
Rem Copyright (c) 2007, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      basic_schema_upgrade_db.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    jsadras     04/03/07 - schema upgrade applicable only in dbsa
Rem    jsadras     04/03/07 - Created
Rem

DEFINE EM_URL_SIZE=1024


-- Basic tables upgrade
rem
rem  PURPOSE
rem
rem  MGMT_LAST_SYNC_LOAD_DETAILS is a table to store information about last
rem  synchronous file upload for a particular agent
rem

CREATE TABLE MGMT_LAST_SYNC_LOAD_DETAILS (
    emd_url    VARCHAR2(&EM_URL_SIZE),
    load_type  VARCHAR2(32)  DEFAULT ' ',
    load_time  DATE DEFAULT NULL,
    CONSTRAINT MGMT_LAST_SYNC_LOAD_PK PRIMARY KEY(emd_url)
) 
MONITORING;

COMMENT ON TABLE MGMT_LAST_SYNC_LOAD_DETAILS IS
  'The MGMT_LAST_SYNC_LOAD_DETAILS table provides details about the last
   synchronous file upload by a particular agent.';

COMMENT ON COLUMN MGMT_LAST_SYNC_LOAD_DETAILS.EMD_URL IS
  'URL of the agent.';

COMMENT ON COLUMN MGMT_LAST_SYNC_LOAD_DETAILS.LOAD_TYPE IS
  'load type of the last loaded file.';

COMMENT ON COLUMN MGMT_LAST_SYNC_LOAD_DETAILS.LOAD_TIME IS
  'time at which last synchronous file was loaded by the agent';

