Rem DO NOT ADD HEADER HERE SINCE THIS FILE IS ALREADY REFERENCED
Rem BY THE chronos_schema_upgrade_cond.sql depending on the condition.
Rem
Rem $Header: chronos_schema_upgrade.sql 31-aug-2005.19:14:24 eporter Exp $
Rem
Rem chronos_schema_upgrade.sql
Rem
Rem Copyright (c) 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      chronos_schema_upgrade.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    eporter     08/31/05 - Bug 4582772: Fix schema difference 
Rem    eporter     08/05/05 - Fix upgrade problem 
Rem    chyu        07/18/05 - removing the header from chronos_schema_upgrade 
Rem                           since it is referenced from the 
Rem                           chronos_schema_upgrade_cond.sql depending on the 
Rem                           condition. 
Rem    eporter     07/14/05 - eporter_bug-4481645
Rem    eporter     07/13/05 - Created
Rem

SET ECHO ON
SET FEEDBACK 1
SET NUMWIDTH 10
SET LINESIZE 80
SET TRIMSPOOL ON
SET TAB OFF
SET PAGESIZE 100

-- If the user upgraded from 10.1.0.3 to 10.1.0.4, the upgrade script doesn't 
-- make the right modifications to the raw and domain tables.

BEGIN

  -- These commands will cause an error if the table is already in that state
    execute immediate 'ALTER TABLE &EM_REPOS_USER..MGMT_RT_METRICS_RAW MODIFY visitor_ip_num NUMBER DEFAULT NULL';
    execute immediate 'ALTER TABLE &EM_REPOS_USER..MGMT_RT_DOMAIN_1HOUR MODIFY VISITOR_SUBNET_NUM DEFAULT 0 NOT NULL';
    execute immediate 'ALTER TABLE &EM_REPOS_USER..MGMT_RT_DOMAIN_1DAY MODIFY VISITOR_SUBNET_NUM DEFAULT 0 NOT NULL';
    execute immediate 'ALTER TABLE &EM_REPOS_USER..MGMT_RT_DOMAIN_DIST_1HOUR MODIFY VISITOR_SUBNET_NUM DEFAULT 0 NOT NULL';
    execute immediate 'ALTER TABLE &EM_REPOS_USER..MGMT_RT_DOMAIN_DIST_1DAY MODIFY VISITOR_SUBNET_NUM DEFAULT 0 NOT NULL';

  -- Silently catch the exception, an exception is expected.
  EXCEPTION
    WHEN OTHERS THEN RETURN;
END;
/

ALTER TABLE &EM_REPOS_USER..MGMT_RT_METRICS_RAW MODIFY DATABASE_TIME DEFAULT NULL;

ALTER TABLE &EM_REPOS_USER..MGMT_RT_URL_1HOUR 
  MODIFY (DB_TIME_AVERAGE  DEFAULT NULL NULL,
          DB_TIME_MINIMUM  DEFAULT NULL NULL,
          DB_TIME_MAXIMUM  DEFAULT NULL NULL,
          DB_TIME_SDEV     DEFAULT NULL NULL,
          DB_TIME_VARIANCE DEFAULT NULL NULL);

ALTER TABLE &EM_REPOS_USER..MGMT_RT_DOMAIN_1HOUR 
  MODIFY (DB_TIME_AVERAGE  DEFAULT NULL NULL,
          DB_TIME_MINIMUM  DEFAULT NULL NULL,
          DB_TIME_MAXIMUM  DEFAULT NULL NULL,
          DB_TIME_SDEV     DEFAULT NULL NULL,
          DB_TIME_VARIANCE DEFAULT NULL NULL,
          VISITOR_SUBNET_NUM   DEFAULT NULL);

ALTER TABLE &EM_REPOS_USER..MGMT_RT_IP_1HOUR 
  MODIFY (DB_TIME_AVERAGE  DEFAULT NULL NULL,
          DB_TIME_MINIMUM  DEFAULT NULL NULL,
          DB_TIME_MAXIMUM  DEFAULT NULL NULL,
          DB_TIME_SDEV     DEFAULT NULL NULL,
          DB_TIME_VARIANCE DEFAULT NULL NULL);

ALTER TABLE &EM_REPOS_USER..MGMT_RT_URL_BOOTSTRAP 
  MODIFY (DB_TIME_AVERAGE  DEFAULT NULL NULL,
          DB_TIME_MINIMUM  DEFAULT NULL NULL,
          DB_TIME_MAXIMUM  DEFAULT NULL NULL,
          DB_TIME_SDEV     DEFAULT NULL NULL,
          DB_TIME_VARIANCE DEFAULT NULL NULL);

ALTER TABLE &EM_REPOS_USER..MGMT_RT_DOMAIN_BOOTSTRAP 
  MODIFY (DB_TIME_AVERAGE  DEFAULT NULL NULL,
          DB_TIME_MINIMUM  DEFAULT NULL NULL,
          DB_TIME_MAXIMUM  DEFAULT NULL NULL,
          DB_TIME_SDEV     DEFAULT NULL NULL,
          DB_TIME_VARIANCE DEFAULT NULL NULL);

ALTER TABLE &EM_REPOS_USER..MGMT_RT_IP_BOOTSTRAP 
  MODIFY (DB_TIME_AVERAGE  DEFAULT NULL NULL,
          DB_TIME_MINIMUM  DEFAULT NULL NULL,
          DB_TIME_MAXIMUM  DEFAULT NULL NULL,
          DB_TIME_SDEV     DEFAULT NULL NULL,
          DB_TIME_VARIANCE DEFAULT NULL NULL);

ALTER TABLE &EM_REPOS_USER..MGMT_RT_URL_1DAY
  MODIFY (DB_TIME_AVERAGE  DEFAULT NULL NULL,
          DB_TIME_MINIMUM  DEFAULT NULL NULL,
          DB_TIME_MAXIMUM  DEFAULT NULL NULL,
          DB_TIME_SDEV     DEFAULT NULL NULL,
          DB_TIME_VARIANCE DEFAULT NULL NULL);

ALTER TABLE &EM_REPOS_USER..MGMT_RT_DOMAIN_1DAY 
  MODIFY (DB_TIME_AVERAGE  DEFAULT NULL NULL,
          DB_TIME_MINIMUM  DEFAULT NULL NULL,
          DB_TIME_MAXIMUM  DEFAULT NULL NULL,
          DB_TIME_SDEV     DEFAULT NULL NULL,
          DB_TIME_VARIANCE DEFAULT NULL NULL,
          VISITOR_SUBNET_NUM   DEFAULT NULL);

ALTER TABLE &EM_REPOS_USER..MGMT_RT_IP_1DAY 
  MODIFY (DB_TIME_AVERAGE  DEFAULT NULL NULL,
          DB_TIME_MINIMUM  DEFAULT NULL NULL,
          DB_TIME_MAXIMUM  DEFAULT NULL NULL,
          DB_TIME_SDEV     DEFAULT NULL NULL,
          DB_TIME_VARIANCE DEFAULT NULL NULL);

ALTER TABLE &EM_REPOS_USER..MGMT_RT_DOMAIN_DIST_1HOUR 
  MODIFY (VISITOR_SUBNET_NUM   DEFAULT NULL);

ALTER TABLE &EM_REPOS_USER..MGMT_RT_DOMAIN_DIST_1DAY
  MODIFY (VISITOR_SUBNET_NUM   DEFAULT NULL);

