Rem
Rem $Header: credentials_common_init.sql 13-sep-2005.00:20:46 rpinnama Exp $
Rem
Rem credentials_common_init.sql
Rem
Rem Copyright (c) 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      credentials_common_init.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    rpinnama    09/13/05 - Fix 4605552 : Add HostCredsUDM credential set. 
Rem                           register call backs 
Rem    rpinnama    08/29/05 - rpinnama_bug-4552749
Rem    rpinnama    08/27/05 - Created
Rem

-- Add logging module for add_crendential
BEGIN
  mgmt_log.register_logging_module (EM_CREDENTIAL.ADD_CRED_ACTION, 
                                    'Credential Info Addition');

  COMMIT;

END;
/

-- Add target addition callback for host targets to 
--  add HostUDMCreds credential set.
BEGIN
  mgmt_admin.add_target_addition_callback(
      p_procedure_name_in => 'EM_CREDENTIAL.handle_host_addition',
      p_target_type_in    => MGMT_GLOBAL.G_HOST_TARGET_TYPE);
  commit;
EXCEPTION
  WHEN OTHERS THEN
    -- Ignore duplicate registrations
    dbms_output.put_line( 'EXCEPTION registering target addition callback for host'|| SQLCODE );
    NULL;
END;
/

-- Add target meta ver update callback to add HostUDMCreds for the new
-- type meta ver
BEGIN
  MGMT_TARGET.add_metaver_catprop_callback(
    p_callback_name => 'EM_CREDENTIAL.handle_host_metaver_update',
    p_target_type   => MGMT_GLOBAL.G_HOST_TARGET_TYPE);
EXCEPTION
  WHEN OTHERS THEN
    -- Ignore duplicate registrations
    dbms_output.put_line( 'EXCEPTION registering meta ver update callback for host '|| SQLCODE );
    NULL;
END;
/

-- Add target addition callback for oracle_database targets to 
--  add DBCredsUDM credential set.
BEGIN
  mgmt_admin.add_target_addition_callback(
      p_procedure_name_in => 'EM_CREDENTIAL.handle_db_addition',
      p_target_type_in    => MGMT_GLOBAL.G_DATABASE_TARGET_TYPE);
  commit;
EXCEPTION
  WHEN OTHERS THEN
    -- Ignore duplicate registrations
    dbms_output.put_line( 'EXCEPTION registering target addition callback for oracle_database'|| SQLCODE );
    NULL;
END;
/

-- Add target meta ver update callback to add DBCredsUDM for the new
-- type meta ver
BEGIN
  MGMT_TARGET.add_metaver_catprop_callback(
    p_callback_name => 'EM_CREDENTIAL.handle_db_metaver_update',
    p_target_type   => MGMT_GLOBAL.G_DATABASE_TARGET_TYPE);
EXCEPTION
  WHEN OTHERS THEN
    -- Ignore duplicate registrations
    dbms_output.put_line( 'EXCEPTION registering meta ver update callback '|| SQLCODE );
    NULL;
END;
/

