Rem drv: <migrate type="data_upgrade" version="10.2.0.1"/>
Rem
Rem $Header: credentials_data_upgrade.sql 13-sep-2005.00:21:05 rpinnama Exp $
Rem
Rem credentials_data_upgrade.sql
Rem
Rem Copyright (c) 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      credentials_data_upgrade.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    rpinnama    09/13/05 - Fix 4605552 : Add HostCredsUDM credential set, 
Rem                           if missing 
Rem    rpinnama    08/29/05 - rpinnama_bug-4552749
Rem    rpinnama    08/27/05 - Created
Rem

Rem Add HostUDMCreds for all the existing host type meta vers

DECLARE
BEGIN
  FOR tmvs IN (SELECT DISTINCT type_meta_ver 
                 FROM mgmt_targets
                WHERE target_type = MGMT_GLOBAL.G_HOST_TARGET_TYPE)
  LOOP
    EM_CREDENTIAL.add_hostudmcreds_credset(MGMT_GLOBAL.G_HOST_TARGET_TYPE,
                                         tmvs.type_meta_ver);
  END LOOP;

END;
/

Rem Add DBCredsUDM for all the existing oracle_database type meta vers

DECLARE
BEGIN
  FOR tmvs IN (SELECT DISTINCT type_meta_ver 
                 FROM mgmt_targets
                WHERE target_type = MGMT_GLOBAL.G_DATABASE_TARGET_TYPE)
  LOOP
    EM_CREDENTIAL.add_dbcredsudm_credset(MGMT_GLOBAL.G_DATABASE_TARGET_TYPE,
                                         tmvs.type_meta_ver);
  END LOOP;

END;
/

Rem DO the common init.
@@&&EM_SQL_ROOT/core/v102020/credentials/credentials_common_init.sql

