Rem drv: <migrate type="schema_upgrade" version="10.2.0.1" pos="collections/collections_schema_upgrade.sql+"/>
Rem
Rem $Header: credentials_schema_upgrade.sql 08-sep-2005.18:06:10 skini Exp $
Rem
Rem credentials_schema_upgrade.sql
Rem
Rem Copyright (c) 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      credentials_schema_upgrade.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    skini       09/08/05 - Change container_location to 1024 
Rem    neearora    09/05/05 - Chk USER_NAME length before altering 
Rem                           MGMT_CRED_RECORD 
Rem    neearora    09/02/05 - Removed ALTER TYPE MGMT_CRED_RECORD
Rem    neearora    09/01/05 - neearora_bug-4582517
Rem    neearora    08/31/05 - Created
Rem


BEGIN
 EXECUTE IMMEDIATE 'DROP TYPE &&EM_REPOS_USER..MGMT_CRED_SET_COL_ARRAY';
EXCEPTION
 WHEN OTHERS THEN
   IF(SQLCODE != -4043)THEN -- Object does not exist
      RAISE;
   END IF;
END;
/

BEGIN
 EXECUTE IMMEDIATE 'DROP TYPE &&EM_REPOS_USER..MGMT_CRED_SET_COL_RECORD';
EXCEPTION
 WHEN OTHERS THEN
   IF(SQLCODE != -4043)THEN -- Object does not exist
      RAISE;
   END IF;
END;
/

CREATE OR REPLACE TYPE MGMT_CRED_SET_COL_RECORD AS OBJECT (
    type_column_name VARCHAR2(64),
    set_column_name VARCHAR2(64),
    set_column_display_name VARCHAR2(64),
    set_column_display_nlsid VARCHAR2(64),
    set_column_values MGMT_CRED_SET_COL_VAL_ARRAY,
    CONSTRUCTOR FUNCTION MGMT_CRED_SET_COL_RECORD (
       type_column_name VARCHAR2,
       set_column_name VARCHAR2,
       set_column_display_name VARCHAR2,
       set_column_display_nlsid VARCHAR2)
    RETURN SELF AS RESULT
);
/

CREATE OR REPLACE TYPE MGMT_CRED_SET_COL_ARRAY AS
    TABLE OF MGMT_CRED_SET_COL_RECORD;
/

ALTER TABLE MGMT_CONTAINER_CREDENTIALS MODIFY (container_location VARCHAR2(1024));
DECLARE
  user_name_len NUMBER;
BEGIN
 SELECT length
   INTO user_name_len
   FROM all_type_attrs
  WHERE type_name = 'MGMT_CRED_RECORD'
    AND attr_name = 'USER_NAME';

  IF(user_name_len < 256) THEN
   EXECUTE IMMEDIATE 'ALTER TYPE &&EM_REPOS_USER..MGMT_CRED_RECORD MODIFY ATTRIBUTE USER_NAME VARCHAR2(256) CASCADE';
  END IF;
END;
/
