Rem drv: <migrate type="pre_data_upgrade" version="10.2.0.1"/>
Rem
Rem $Header: data_propagation_post_creation.sql 03-aug-2005.10:49:08 pmodi Exp $
Rem
Rem data_propagation_post_creation.sql
Rem
Rem Copyright (c) 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      data_propagation_post_creation.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    pmodi       08/03/05 - pmodi_bug-4527450
Rem    pmodi       08/03/05 - Created. Moved from v102010 to v102020 for beta to
Rem                           production upgrade. Bug:4527450
Rem    chyu        07/19/05 - modifying the new rep manager header 
Rem    rzazueta    07/05/05 - rzazueta_bug-4305891
Rem    rzazueta    06/13/05 - Created
Rem

-- Add table as a delete exception.
BEGIN
DECLARE del_exceptions SMP_EMD_STRING_ARRAY := SMP_EMD_STRING_ARRAY();
BEGIN
    -- Add deletion exceptions here
    del_exceptions.extend(2);
    del_exceptions(1) := 'MGMT_UPDATE_OPERATIONS_DATA';
    del_exceptions(2) := 'MGMT_UPDATE_OPERATIONS_DETAILS';
    MGMT_ADMIN.add_target_deletion_exceptions(del_exceptions);
END;
END;
/

BEGIN
  -- Purge policy for MGMT_TARGET_UPDATE HISTORY
  EM_PURGE.add_purge_policy('MGMT_TARGET_UPDATE_HISTORY',
                            EM_PURGE.G_POLICY_TYPE_SYSTEM,
                            'MGMT_TARGET_UPDATE.PURGE',
                            31*24,
                            NULL,
                            'Purge policy for target update history.',
                            EM_PURGE.G_RETENTION_GROUP_LVL2_SUMMARY
                            );
  COMMIT;
END;
/

BEGIN
  BEGIN
    MGMT_ADMIN.add_target_deletion_callback('MGMT_TARGET_UPDATE.clean_on_tgt_del');
  EXCEPTION WHEN OTHERS THEN
    -- Ignore duplicate registration errors
    NULL;
  END;
END;
/
