Rem drv: <migrate type="schema_downgrade" version="10.2.0.0"/>
Rem
Rem $Header: ecm_schema_downgrade.sql 30-aug-2005.04:57:56 mningomb Exp $
Rem
Rem ecm_schema_downgrade.sql
Rem
Rem Copyright (c) 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      ecm_schema_downgrade.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    mningomb    08/30/05 - mningomb_upgradetxn
Rem    mningomb    08/28/05 - Created
Rem

SET ECHO ON
SET FEEDBACK 1
SET NUMWIDTH 10
SET LINESIZE 80
SET TRIMSPOOL ON
SET TAB OFF
SET PAGESIZE 100

DROP TABLE MGMT_BUG_ADV_HOME_PATCH;
CREATE TABLE MGMT_BUG_ADV_HOME_PATCH
(
  ADVISORY_NAME VARCHAR2(128) NOT NULL,
  BUG_NUMBER NUMBER NOT NULL,
  HOST_NAME VARCHAR2(256) NOT NULL,
  HOME_LOCATION VARCHAR2( 128 ) NOT NULL,
  PATCH_GUID RAW(16) NOT NULL,
  PREREQ_RELEASE VARCHAR2(256),
  HOME_LOCATION_DISPLAY VARCHAR2(256),
  TARGET_GUID RAW(16),
  CONSTRAINT MBAHP_PK PRIMARY KEY ( ADVISORY_NAME, HOST_NAME, HOME_LOCATION, BUG_NUMBER, PATCH_GUID )
) MONITORING;

DROP TABLE TABLE MGMT_CPF_METRIC_SOURCE;

rem   need to drop the type MGMT_BUG_ADVISORY_VIOLATIONS first
DROP TYPE MGMT_BUG_ADVISORY_VIOLATIONS;

rem
rem   This object is used to hold the policy violation values temporarily while
rem   being passed back from a function used to calculate the violations.
rem

CREATE OR REPLACE TYPE MGMT_BUG_ADVISORY_VIOLATION AS OBJECT
(
  ADVISORY_NAME VARCHAR2(128),
  IMPACT VARCHAR2(128),
  PATCHES VARCHAR2(2000),
  ADVISORY_ABSTRACT VARCHAR2(1024),
  HOME_LOCATION_DISPLAY VARCHAR2(1000),
  HOME_LOCATION VARCHAR2(128),
  HOST_NAME VARCHAR2(256),
  ADVISORY_URL VARCHAR2(256),
  PATCH_GUIDS VARCHAR2(4000),
  TARGET_GUID RAW(16)
);
/
show errors;

CREATE OR REPLACE TYPE MGMT_BUG_ADVISORY_VIOLATIONS AS
  TABLE OF MGMT_BUG_ADVISORY_VIOLATION;
/

