Rem drv: <migrate type="data_upgrade" version="10.2.0.1"/>
Rem
Rem $Header: esm_post_creation.sql 08-sep-2005.23:39:33 dkjain Exp $
Rem
Rem esm_post_creation.sql
Rem
Rem Copyright (c) 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      esm_post_creation.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    dkjain      09/08/05 - dkjain_bug-4530678
Rem    dkjain      07/28/05 - Created
Rem

SET ECHO ON
SET FEEDBACK 1
SET NUMWIDTH 10
SET LINESIZE 80
SET TRIMSPOOL ON
SET TAB OFF
SET PAGESIZE 100

SET DEFINE OFF
ALTER SESSION SET CONSTRAINTS = DEFERRED;
/

DECLARE
  metadata_id RAW(16) ;
  property_length INTEGER := 64;  -- CAUTION: Must match the column description in the CREATE statement
  value1_length INTEGER := 512;   -- CAUTION: Must match the column description in the CREATE statement
  value2_length INTEGER := 512;   -- CAUTION: Must match the column description in the CREATE statement
BEGIN
--  Registering oracle_security_inst snapshot START
  metadata_id := sys_guid();
  -- Remove all related metadatas
  DELETE FROM MGMT_ECM_SNAPSHOT_MD_TABLES WHERE METADATA_ID IN (SELECT METADATA_ID FROM MGMT_ECM_SNAPSHOT_METADATA WHERE TARGET_TYPE = 'oracle_database' AND SNAPSHOT_TYPE = 'oracle_security_inst');
  DELETE FROM MGMT_ECM_SNAPSHOT_METADATA WHERE TARGET_TYPE = 'oracle_database' AND SNAPSHOT_TYPE = 'oracle_security_inst';

  -- Register metadata as loader metadata
  INSERT INTO MGMT_ECM_SNAPSHOT_METADATA (SNAPSHOT_TYPE, TARGET_TYPE, KIND, METADATA_ID, UI_NAME, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, LINK_TABLE_NAME, AFTER_LOAD_PROC_NAME, AFTER_IMPORT_PROC_NAME, METADATA_VERSION, VIEW_URL, COMPARE_URL, HISTORY_URL, SAME_TARGET_COMPARE) 
    VALUES ('oracle_security_inst', 'oracle_database', 'L', metadata_id, 'Security best practices', 'N', 'N', 'Y', 'N', 'N', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'H');

  -- Register metadata as presentation metadata
  INSERT INTO MGMT_ECM_SNAPSHOT_METADATA (SNAPSHOT_TYPE, TARGET_TYPE, KIND, METADATA_ID, UI_NAME, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, LINK_TABLE_NAME, AFTER_LOAD_PROC_NAME, AFTER_IMPORT_PROC_NAME, METADATA_VERSION, VIEW_URL, COMPARE_URL, HISTORY_URL, SAME_TARGET_COMPARE) 
    VALUES ('oracle_security_inst', 'oracle_database', 'P', metadata_id, 'Security best practices', 'N', 'N', 'Y', 'N', 'N', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'H');

  -- Register metadata for table ESM_COLLECTION
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_TABLES (METADATA_ID, NAME, UI_NAME, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, PARENT_TABLE_NAME, IS_SINGLE_ROW, TBL_ORDER)
    VALUES (metadata_id, 'ESM_COLLECTION', 'ESM Collection', 'N', 'N', 'Y', 'N', 'N', NULL, 'N', 0);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'ESM_COLLECTION', 'PROPERTY', 'Property', 'S', property_length, 'N', 'N', 'Y', 'N', 'N', 'Y', 'N', 'N', 'N', NULL, 0);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'ESM_COLLECTION', 'VALUE', 'Value', 'S', value1_length, 'N', 'N', 'Y', 'N', 'N', 'Y', 'N', 'N', 'N', NULL, 1);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'ESM_COLLECTION', 'VALUE2', 'Value2', 'S', value2_length, 'N', 'N', 'Y', 'N', 'N', 'Y', 'N', 'N', 'N', NULL, 2);

--  Registering oracle_security_inst snapshot END 

--  Registering oracle_security snapshot  for oc4j ttype START 
  metadata_id := sys_guid();
  -- Remove all related metadatas
  DELETE FROM MGMT_ECM_SNAPSHOT_MD_TABLES WHERE METADATA_ID IN (SELECT METADATA_ID FROM MGMT_ECM_SNAPSHOT_METADATA WHERE TARGET_TYPE = 'oc4j' AND SNAPSHOT_TYPE = 'oracle_security');
  DELETE FROM MGMT_ECM_SNAPSHOT_METADATA WHERE TARGET_TYPE = 'oc4j' AND SNAPSHOT_TYPE = 'oracle_security';

  -- Register metadata as loader metadata
  INSERT INTO MGMT_ECM_SNAPSHOT_METADATA (SNAPSHOT_TYPE, TARGET_TYPE, KIND, METADATA_ID, UI_NAME, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, LINK_TABLE_NAME, AFTER_LOAD_PROC_NAME, AFTER_IMPORT_PROC_NAME, METADATA_VERSION, VIEW_URL, COMPARE_URL, HISTORY_URL, SAME_TARGET_COMPARE) 
    VALUES ('oracle_security', 'oc4j', 'L', metadata_id, 'Security best practices', 'N', 'N', 'Y', 'N', 'N', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'H');

  -- Register metadata as presentation metadata
  INSERT INTO MGMT_ECM_SNAPSHOT_METADATA (SNAPSHOT_TYPE, TARGET_TYPE, KIND, METADATA_ID, UI_NAME, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, LINK_TABLE_NAME, AFTER_LOAD_PROC_NAME, AFTER_IMPORT_PROC_NAME, METADATA_VERSION, VIEW_URL, COMPARE_URL, HISTORY_URL, SAME_TARGET_COMPARE) 
    VALUES ('oracle_security', 'oc4j', 'P', metadata_id, 'Security best practices', 'N', 'N', 'Y', 'N', 'N', NULL, NULL, NULL, NULL, NULL, NULL, NULL, 'H');

  -- Register metadata for table ESM_COLLECTION
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_TABLES (METADATA_ID, NAME, UI_NAME, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, PARENT_TABLE_NAME, IS_SINGLE_ROW, TBL_ORDER)
    VALUES (metadata_id, 'ESM_COLLECTION', 'ESM Collection', 'N', 'N', 'Y', 'N', 'N', NULL, 'N', 0);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'ESM_COLLECTION', 'PROPERTY', 'Property', 'S', property_length, 'N', 'N', 'Y', 'N', 'N', 'Y', 'N', 'N', 'N', NULL, 0);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'ESM_COLLECTION', 'VALUE', 'Value', 'S', value1_length, 'N', 'N', 'Y', 'N', 'N', 'Y', 'N', 'N', 'N', NULL, 1);
  INSERT INTO MGMT_ECM_SNAPSHOT_MD_COLUMNS (METADATA_ID, TABLE_NAME, NAME, UI_NAME, TYPE, TYPE_FORMAT, UI_ON, COMPARE_ON, COMPARE_UI_ON, HISTORY_ON, HISTORY_UI_ON, IS_KEY, IS_CONTEXT, IS_SUMMARY, IS_CHILD_LINK, LINK_COLUMN_NAME, COL_ORDER)
    VALUES (metadata_id, 'ESM_COLLECTION', 'VALUE2', 'Value2', 'S', value2_length, 'N', 'N', 'Y', 'N', 'N', 'Y', 'N', 'N', 'N', NULL, 2);

--  Registering oracle_security snapshot  for oc4j ttype END 
END;
/
show errors ;
ALTER SESSION SET CONSTRAINTS = IMMEDIATE;
COMMIT;

SET DEFINE ON 

