Rem
Rem $Header: gensvc_common_init.sql 04-oct-2005.04:44:49 afontana Exp $
Rem
Rem gensvc_common_init.sql
Rem
Rem Copyright (c) 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      gensvc_common_init.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    afontana    10/04/05 - add gensvc 2.0, finalize metadata 
Rem    jsadras     08/19/05 - change add_metaver_upd_callback 
Rem    vesriniv    07/30/05 - Add customziation support 
Rem    rmarripa    07/15/05 - rmarripa_bug-4438024
Rem    rmarripa    07/12/05 - Created
Rem

BEGIN
  mgmt_target.add_metaver_catprop_callback('GENSVC.BCN_TYPE_METAVER_UPD_CALLBACK',
               MGMT_GLOBAL.G_BEACON_TARGET_TYPE); 
END;
/

--
-- The following changes are intended to protect service metrics
-- from the loader.
--
BEGIN
  em_service.initialize_service_type(MGMT_GLOBAL.G_GENERIC_SERVICE_TYPE,
                                     FALSE, '2.0', 'Generic Service');

DECLARE
PROCEDURE add_prop_def(p_service_type IN VARCHAR2, 
                       p_property_name IN VARCHAR2,
                       p_type_meta_ver IN VARCHAR2)
AS
BEGIN
   BEGIN
      INSERT INTO mgmt_target_prop_defs(target_type, type_meta_ver,
                       property_name, 
                       property_display_name, hidden_flag)
      VALUES(p_service_type, p_type_meta_ver, p_property_name, p_property_name, 1);
   EXCEPTION
      WHEN DUP_VAL_ON_INDEX THEN
          NULL;
   END;
END;
PROCEDURE add_svc_prop_defs(p_service_type IN VARCHAR2,
                            p_type_meta_ver IN VARCHAR2)
AS
BEGIN
   add_prop_def(p_service_type, 
                EM_SERVICE.G_SVC_HP_USAGE_METRIC_NAME,
                p_type_meta_ver);
   add_prop_def(p_service_type, 
                EM_SERVICE.G_SVC_HP_USAGE_METRIC_COL,
                p_type_meta_ver);
   add_prop_def(p_service_type, 
                EM_SERVICE.G_SVC_HP_USAGE_KEY,
                p_type_meta_ver);
   add_prop_def(p_service_type, 
                EM_SERVICE.G_SVC_HP_PERF_METRIC_NAME,
                p_type_meta_ver);
   add_prop_def(p_service_type, 
                EM_SERVICE.G_SVC_HP_PERF_METRIC_COL,
                p_type_meta_ver);
   add_prop_def(p_service_type, 
                EM_SERVICE.G_SVC_HP_PERF_KEY,
                p_type_meta_ver);
END;
BEGIN
   --add property def for aggregate service
   add_svc_prop_defs(MGMT_GLOBAL.G_GENERIC_SERVICE_TYPE, '2.0');
   COMMIT;
END;
END;
/
show errors;

BEGIN
  emd_loader.end_metadata_set(MGMT_GLOBAL.G_GENERIC_SERVICE_TYPE, '1.0',
                              'MGMT_TARGET_TYPE_VERSIONS');
  emd_loader.end_metadata_set(MGMT_GLOBAL.G_GENERIC_SERVICE_TYPE, '1.0',
                              'MGMT_METRICS');
  emd_loader.end_metadata_set(MGMT_GLOBAL.G_GENERIC_SERVICE_TYPE, '1.0',
                              'MGMT_TARGET_PROP_DEFS');

  emd_loader.end_metadata_set(MGMT_GLOBAL.G_GENERIC_SERVICE_TYPE, '2.0',
                              'MGMT_TARGET_TYPE_VERSIONS');
  emd_loader.end_metadata_set(MGMT_GLOBAL.G_GENERIC_SERVICE_TYPE, '2.0',
                              'MGMT_METRICS');
  emd_loader.end_metadata_set(MGMT_GLOBAL.G_GENERIC_SERVICE_TYPE, '2.0',
                              'MGMT_TARGET_PROP_DEFS');

  emd_loader.end_metadata_set(MGMT_GLOBAL.G_GENERIC_SERVICE_TYPE, '3.0',
                              'MGMT_TARGET_TYPE_VERSIONS');
  emd_loader.end_metadata_set(MGMT_GLOBAL.G_GENERIC_SERVICE_TYPE, '3.0',
                              'MGMT_METRICS');
  emd_loader.end_metadata_set(MGMT_GLOBAL.G_GENERIC_SERVICE_TYPE, '3.0',
                              'MGMT_TARGET_PROP_DEFS');

  emd_loader.end_metadata_set(MGMT_GLOBAL.G_AGGREGATE_SERVICE_TYPE, '1.0',
                              'MGMT_TARGET_TYPE_VERSIONS');
  emd_loader.end_metadata_set(MGMT_GLOBAL.G_AGGREGATE_SERVICE_TYPE, '1.0',
                              'MGMT_METRICS');
  emd_loader.end_metadata_set(MGMT_GLOBAL.G_AGGREGATE_SERVICE_TYPE, '1.0',
                              'MGMT_TARGET_PROP_DEFS');
EXCEPTION
  WHEN OTHERS THEN
    NULL;
END;
/
show errors;

DECLARE
    customization_list  SMP_EMD_NVPAIR_ARRAY := SMP_EMD_NVPAIR_ARRAY();
    condition_list  SMP_EMD_STRING_ARRAY := SMP_EMD_STRING_ARRAY();

BEGIN
    condition_list.extend;
    condition_list(condition_list.COUNT) := mgmt_global.G_TYPE;
    condition_list.extend;
    condition_list(condition_list.COUNT) := mgmt_global.G_TARGET;

    customization_list.extend;
    customization_list(customization_list.COUNT) := SMP_EMD_NVPAIR(
        name => mgmt_global.G_ALLOW_MEMBER_EDIT, value => 'true');

    em_page_custmzn.add_page_customzn_metadata(mgmt_global.G_GENSVC_EDIT_SYSTEM,
        customization_list, condition_list);

END;
/

SHOW ERRORS;
