Rem drv: <migrate type="pre_data_upgrade" version="10.2.0.1" pos="test_metadata/test_metadata_post_creation_cond.sql+"/>
Rem
Rem $Header: group_post_creation.sql 18-jul-2006.09:33:20 chyu Exp $
Rem
Rem group_post_creation.sql
Rem
Rem Copyright (c) 2005, 2006, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      group_post_creation.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    chyu        07/18/06 - Backport chyu_bug-5305174 from 
Rem                           st_emcore_10.2.0.1.0 
Rem    chyu        05/17/06 - modifying the position to point to the new 
Rem                           condition file of test_metadata 
Rem    paachary    08/24/05 - Removing the property of REDUNDANCY GROUP target type 
Rem                           from is_group. Refer bug 4567883.
Rem    vesriniv    08/04/05 - vesriniv_custtxn
Rem    vesriniv    07/25/05 - Created
Rem

-- Perfrom common gensvc init
@&EM_SQL_ROOT/core/v102020/group/group_common_init.sql

DECLARE
    l_count  NUMBER DEFAULT 0;
BEGIN
    -- Check if there exists a record in mgmt_type_properties
    -- with property_name = is_group for redundancy group target type
    -- If yes, then delete it. Since redundancy group is no more an is_group = 1 property.

    SELECT count(*)
    INTO   l_count
    FROM   mgmt_type_properties
    WHERE  target_type = mgmt_global.G_REDUNDANCY_GROUP_TARGET_TYPE
       AND property_name = mgmt_global.G_IS_GROUP_PROP;
    
    IF (l_count > 0 ) THEN
        DELETE mgmt_type_properties
        WHERE  target_type = mgmt_global.G_REDUNDANCY_GROUP_TARGET_TYPE
           AND property_name = mgmt_global.G_IS_GROUP_PROP;
        COMMIT;
    END IF;
END;
/
