Rem
Rem $Header: rca_outofbox_elements.sql 10-mar-2006.03:46:23 pmaddi Exp $
Rem
Rem rca_oob_reports.sql
Rem
Rem Copyright (c) 2005, 2006, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      rca_oob_reports.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem       pmaddi   03/10/06 - Backport pmaddi_bug-4606201 from main 
Rem       pmaddi   09/14/05 - Changing IPMSG_ANY_TARGET_TYPE to 
Rem                           IPMSG_SERVICE_TARGET_TYPES 
Rem       saramasa 08/08/05 - Fix for 4540854 
Rem       pmaddi   07/31/05 - pmaddi_bug-4523007
Rem    pmaddi      07/ 14/05 - Splitting most significant impacts element defintion into 2 parts, one to handle all targets and other to handle a given target.
Rem    gsbhatia    07/14/05 - 
Rem    pmaddi      07/11/05 - Adding param controller for rca 
Rem    pmaddi      07/03/05 - pmaddi_rca_report
Rem    pmaddi      07/03/05 - Created
Rem

SET FEEDBACK 1
SET NUMWIDTH 10
SET LINESIZE 80
SET TRIMSPOOL ON
SET TAB OFF
SET PAGESIZE 100

BEGIN
 
  DECLARE 
    l_target_types  MGMT_IP_TARGET_TYPES;
    l_param_classes MGMT_IP_PARAM_CLASSES;
    l_param_values  MGMT_IP_PARAM_VALUE_LIST;
    l_targets       MGMT_IP_TARGET_LIST;
    l_report_guid   RAW(16);
    l_element_guid  RAW(16);
  
    BEGIN

      --Element for most significant impacts Report for a target
      l_param_classes := MGMT_IP_PARAM_CLASSES();
      l_param_classes.extend(4);
      l_param_classes(1) := 'oracle.sysman.eml.ip.render.elem.HeaderParamController';
      l_param_classes(2) := 'oracle.sysman.eml.ip.render.elem.TargetsParamController';
      l_param_classes(3) := 'oracle.sysman.eml.ip.render.elem.TimePeriodParamController';
      l_param_classes(4) := 'oracle.sysman.eml.ip.render.elem.rca.MSIParamController';
      mgmt_ip.add_element_definition(
          p_element_name_nlsid  => 'IPMSG_RCAIMPACTS_ELEM_ST',
          p_element_type_nlsid  => 'IPMSG_SERVICE_TARGET_TYPES',
          p_description_nlsid   => 'IPMSG_RCAIMPACTS_ELEM_ST_DESC',
          p_element_class_name  => 'oracle.sysman.eml.ip.render.elem.rca.MostSignificantImpacts',
          p_internal_use_only   => 0,
          p_param_classes       => l_param_classes,
          p_default_parameters  => null,
          p_pack_name           => null
          );

      --Element for most significant impacts Report for all targets
      l_param_classes := MGMT_IP_PARAM_CLASSES();
      l_param_classes.extend(3);
      l_param_classes(1) := 'oracle.sysman.eml.ip.render.elem.HeaderParamController';
      l_param_classes(2) := 'oracle.sysman.eml.ip.render.elem.TimePeriodParamController';
      l_param_classes(3) := 'oracle.sysman.eml.ip.render.elem.rca.MSIParamController';
      mgmt_ip.add_element_definition(
          p_element_name_nlsid  => 'IPMSG_RCAIMPACTS_ELEM',
          p_element_type_nlsid  => 'IPMSG_SERVICE_TARGET_TYPES',
          p_description_nlsid   => 'IPMSG_RCAIMPACTS_ELEM_DESC',
          p_element_class_name  => 'oracle.sysman.eml.ip.render.elem.rca.MostSignificantImpacts',
          p_internal_use_only   => 0,
          p_param_classes       => l_param_classes,
          p_default_parameters  => null,
          p_pack_name           => null
          );        

      --Element for most significant impacts for a root cause Report
      l_param_classes := MGMT_IP_PARAM_CLASSES();
      l_param_classes.extend(3);
      l_param_classes(1) := 'oracle.sysman.eml.ip.render.elem.HeaderParamController';
      l_param_classes(2) := 'oracle.sysman.eml.ip.render.elem.TargetsParamController';
      l_param_classes(3) := 'oracle.sysman.eml.ip.render.elem.TimePeriodParamController';      
      mgmt_ip.add_element_definition(
          p_element_name_nlsid  => 'IPMSG_ROOTCAUSEIMPACTS_ELEM',
          p_element_type_nlsid  => 'IPMSG_SERVICE_TARGET_TYPES',
          p_description_nlsid   => 'IPMSG_ROOTCAUSEIMPACTS_ELEM_DESC',
          p_element_class_name  => 'oracle.sysman.eml.ip.render.elem.rca.RootCauseImpacts',
          p_internal_use_only   => 1,
          p_param_classes       => l_param_classes,
          p_default_parameters  => null,
          p_pack_name           => null
          );

      --Hidden report for root cause impacts
      l_param_values := MGMT_IP_PARAM_VALUE_LIST();
      l_param_values.extend(3);
      l_param_values(1) := MGMT_IP_PARAM_VALUE_RECORD(
         'oracle.sysman.eml.ip.render.elem.TimePeriodOption',
           'true');
      l_param_values(2) := MGMT_IP_PARAM_VALUE_RECORD(
         'oracle.sysman.eml.ip.render.elem.TimePeriodUserCust',
            'true');
      l_param_values(3) := MGMT_IP_PARAM_VALUE_RECORD(
         'oracle.sysman.eml.ip.render.elem.TimePeriodParam',
            '0:1');
      l_report_guid := mgmt_ip.create_report_definition (
                           p_title_nlsid                   => 'IPMSG_ROOTCAUSE_IMPACTS_REPORT',
                           p_description_nlsid             => 'IPMSG_ROOTCAUSE_IMPACTS_REPORT',
                           p_owner => 'SYSMAN',
                           p_category_nlsid => 'IPMSG_MONITORING_CATEGORY', 
                           p_sub_category_nlsid => 'IPMSG_RCA_SUBCAT',
                           p_internal_use_only => 1,
                           p_public_report => 0,
                           p_system_report => 1,
                           p_show_navigation => 1,
                           p_parameters    =>  l_param_values);
                           
            l_param_values := MGMT_IP_PARAM_VALUE_LIST();
            l_param_values.extend(4);
            l_param_values(1) := new MGMT_IP_PARAM_VALUE_RECORD('oracle.sysman.eml.ip.render.elem.TextParamBean.textMessage',	
                                                                           'IPMSG_ROOTCAUSE_IMPACTS_REPORTHELP');
            l_param_values(2) := new MGMT_IP_PARAM_VALUE_RECORD('oracle.sysman.eml.ip.render.elem.TextParamBean.textStyle',	
                                                                           'OraInstructionText');
            l_param_values(3) := new MGMT_IP_PARAM_VALUE_RECORD('oracle.sysman.eml.ip.render.elem.TextParamBean.textDestination',
                                                                           '');
            l_param_values(4) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TextParamBean.textResourceBundleName',
                                                                           'oracle.sysman.resources.eml.ip.emr.webapps.IPWebappsResource');
            l_element_guid := mgmt_ip.add_element_to_report_def (
                                 p_report_guid => l_report_guid,
                                 p_element_name_nlsid => 'IPMSG_STYLED_TEXT',
                                 p_element_type_nlsid => 'IPMSG_ANY_TARGET_TYPE',
                                 p_element_order => 1,
                                 p_element_row => 1,
                                 p_parameters => l_param_values,
                                 p_targets => NULL
                                 );
            
            l_element_guid := mgmt_ip.add_element_to_report_def (
                                 l_report_guid,
                                 'IPMSG_ROOTCAUSEIMPACTS_ELEM',
                                 'IPMSG_SERVICE_TARGET_TYPES',
                                 NULL,
                                 2,
                                 2,
                                 NULL,
                                 NULL);
      COMMIT;    
  END;
END;
/

SET DEFINE ON
SET ECHO ON
