Rem
Rem $Header: webapp_outofbox_reports.sql 10-mar-2006.03:46:26 pmaddi Exp $
Rem
Rem webapp_outofbox_reports.sql
Rem
Rem Copyright (c) 2005, 2006, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      webapp_outofbox_reports.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    pmaddi      03/10/06 - Backport pmaddi_bug-4606201 from main 
Rem    pmaddi      09/14/05 - Changing IPMSG_ANY_TARGET_TYPE to 
Rem                           IPMSG_SERVICE_TARGET_TYPES 
Rem    saramasa    08/08/05 - Fix for 4540854 
Rem    saramasa    08/03/05 - saramasa_bug-4528002
Rem    saramasa    08/02/05 - Moved from v102010
Rem    pmaddi      07/29/05 - header removed 
Rem    pmaddi      07/12/05 - Removing  Availability related Elements 
Rem    saramasa    07/06/05 - saramasa_bug-4435525_col_metrics
Rem    saramasa    07/06/05 - Created
Rem

SET ECHO OFF
SET FEEDBACK 1
SET NUMWIDTH 10
SET LINESIZE 80
SET TRIMSPOOL ON
SET TAB OFF
SET PAGESIZE 100

BEGIN
 
  DECLARE 
    l_target_types  MGMT_IP_TARGET_TYPES;
    l_param_classes MGMT_IP_PARAM_CLASSES;
    l_param_values  MGMT_IP_PARAM_VALUE_LIST;
    l_targets       MGMT_IP_TARGET_LIST;
    l_report_guid   RAW(16);
    l_element_guid  RAW(16);
    
  BEGIN


  -- Delete all webapp beta elements

    -- e2e table from inputs
    BEGIN
      DELETE FROM MGMT_IP_REPORT_ELEM_DEF 
        where ELEMENT_NAME_NLSID = 'Web Application Request Performance'
        and ELEMENT_TYPE_NLSID = 'any_target_type';
      DELETE FROM MGMT_IP_ELEM_PARAM_CLASSES 
        where ELEMENT_NAME_NLSID = 'Web Application Request Performance'
        and ELEMENT_TYPE_NLSID = 'any_target_type';
      DELETE FROM MGMT_IP_ELEM_DEFAULT_PARAMS 
        where ELEMENT_NAME_NLSID = 'Web Application Request Performance'
        and ELEMENT_TYPE_NLSID = 'any_target_type';
      EXCEPTION WHEN OTHERS THEN NULL;
    END;

    -- e2e chart from inputs
    BEGIN
      DELETE FROM MGMT_IP_REPORT_ELEM_DEF 
        where ELEMENT_NAME_NLSID = 'Web Application URL Performance'
        and ELEMENT_TYPE_NLSID = 'any_target_type';
      DELETE FROM MGMT_IP_ELEM_PARAM_CLASSES 
        where ELEMENT_NAME_NLSID = 'Web Application URL Performance'
        and ELEMENT_TYPE_NLSID = 'any_target_type';
      DELETE FROM MGMT_IP_ELEM_DEFAULT_PARAMS 
        where ELEMENT_NAME_NLSID = 'Web Application URL Performance'
        and ELEMENT_TYPE_NLSID = 'any_target_type';
      EXCEPTION WHEN OTHERS THEN NULL;
    END;

    -- Transaction performance table from input
    BEGIN
      DELETE FROM MGMT_IP_REPORT_ELEM_DEF 
        where ELEMENT_NAME_NLSID = 'Web Application Transaction Performance Summary'
        and ELEMENT_TYPE_NLSID = 'any_target_type';
      DELETE FROM MGMT_IP_ELEM_PARAM_CLASSES 
        where ELEMENT_NAME_NLSID = 'Web Application Transaction Performance Summary'
        and ELEMENT_TYPE_NLSID = 'any_target_type';
      DELETE FROM MGMT_IP_ELEM_DEFAULT_PARAMS 
        where ELEMENT_NAME_NLSID = 'Web Application Transaction Performance Summary'
        and ELEMENT_TYPE_NLSID = 'any_target_type';
      EXCEPTION WHEN OTHERS THEN NULL;
    END;

    -- Transaction performance table from inputs
    BEGIN
      DELETE FROM MGMT_IP_REPORT_ELEM_DEF 
        where ELEMENT_NAME_NLSID = 'Web Application Transaction Performance Details'
        and ELEMENT_TYPE_NLSID = 'any_target_type';
      DELETE FROM MGMT_IP_ELEM_PARAM_CLASSES 
        where ELEMENT_NAME_NLSID = 'Web Application Transaction Performance Details'
        and ELEMENT_TYPE_NLSID = 'any_target_type';
      DELETE FROM MGMT_IP_ELEM_DEFAULT_PARAMS 
        where ELEMENT_NAME_NLSID = 'Web Application Transaction Performance Details'
        and ELEMENT_TYPE_NLSID = 'any_target_type';
      EXCEPTION WHEN OTHERS THEN NULL;
    END;

    -- Element for Page By Axis
    BEGIN
      DELETE FROM MGMT_IP_REPORT_ELEM_DEF 
        where ELEMENT_NAME_NLSID = 'Web Application Page Performance By Category'
        and ELEMENT_TYPE_NLSID = 'any_target_type';
      DELETE FROM MGMT_IP_ELEM_PARAM_CLASSES 
        where ELEMENT_NAME_NLSID = 'Web Application Page Performance By Category'
        and ELEMENT_TYPE_NLSID = 'any_target_type';
      DELETE FROM MGMT_IP_ELEM_DEFAULT_PARAMS 
        where ELEMENT_NAME_NLSID = 'Web Application Page Performance By Category'
        and ELEMENT_TYPE_NLSID = 'any_target_type';
      EXCEPTION WHEN OTHERS THEN NULL;
    END;

    -- Element for EUM reports
    BEGIN
      DELETE FROM MGMT_IP_REPORT_ELEM_DEF 
        where ELEMENT_NAME_NLSID = 'Web Application Page Performance'
        and ELEMENT_TYPE_NLSID = 'any_target_type';
      DELETE FROM MGMT_IP_ELEM_PARAM_CLASSES 
        where ELEMENT_NAME_NLSID = 'Web Application Page Performance'
        and ELEMENT_TYPE_NLSID = 'any_target_type';
      DELETE FROM MGMT_IP_ELEM_DEFAULT_PARAMS 
        where ELEMENT_NAME_NLSID = 'Web Application Page Performance'
        and ELEMENT_TYPE_NLSID = 'any_target_type';
      EXCEPTION WHEN OTHERS THEN NULL;
    END;

    -- Element for Alert Reports
    BEGIN
      DELETE FROM MGMT_IP_REPORT_ELEM_DEF 
        where ELEMENT_NAME_NLSID = 'Web Application Alerts'
        and ELEMENT_TYPE_NLSID = 'any_target_type';
      DELETE FROM MGMT_IP_ELEM_PARAM_CLASSES 
        where ELEMENT_NAME_NLSID = 'Web Application Alerts'
        and ELEMENT_TYPE_NLSID = 'any_target_type';
      DELETE FROM MGMT_IP_ELEM_DEFAULT_PARAMS 
        where ELEMENT_NAME_NLSID = 'Web Application Alerts'
        and ELEMENT_TYPE_NLSID = 'any_target_type';
      EXCEPTION WHEN OTHERS THEN NULL;
    END;

    -- Element for Performance and Usage Reports
    BEGIN
      DELETE FROM MGMT_IP_REPORT_ELEM_DEF 
        where ELEMENT_NAME_NLSID = 'Web Application Metric Details'
        and ELEMENT_TYPE_NLSID = 'any_target_type';
      DELETE FROM MGMT_IP_ELEM_PARAM_CLASSES 
        where ELEMENT_NAME_NLSID = 'Web Application Metric Details'
        and ELEMENT_TYPE_NLSID = 'any_target_type';
      DELETE FROM MGMT_IP_ELEM_DEFAULT_PARAMS 
        where ELEMENT_NAME_NLSID = 'Web Application Metric Details'
        and ELEMENT_TYPE_NLSID = 'any_target_type';
      EXCEPTION WHEN OTHERS THEN NULL;
    END;

    --Element for Availability Reports
    BEGIN
      DELETE FROM MGMT_IP_REPORT_ELEM_DEF 
        where ELEMENT_NAME_NLSID = 'Web Application Availability'
        and ELEMENT_TYPE_NLSID = 'any_target_type';
      DELETE FROM MGMT_IP_ELEM_PARAM_CLASSES 
        where ELEMENT_NAME_NLSID = 'Web Application Availability'
        and ELEMENT_TYPE_NLSID = 'any_target_type';
      DELETE FROM MGMT_IP_ELEM_DEFAULT_PARAMS 
        where ELEMENT_NAME_NLSID = 'Web Application Availability'
        and ELEMENT_TYPE_NLSID = 'any_target_type';
      EXCEPTION WHEN OTHERS THEN NULL;
    END;

    -- Element for showing Avaialabilty Grid control
    BEGIN
      DELETE FROM MGMT_IP_REPORT_ELEM_DEF 
        where ELEMENT_NAME_NLSID = 'Availability Grid Element'
        and ELEMENT_TYPE_NLSID = 'any_target_type';
      DELETE FROM MGMT_IP_ELEM_PARAM_CLASSES 
        where ELEMENT_NAME_NLSID = 'Availability Grid Element'
        and ELEMENT_TYPE_NLSID = 'any_target_type';
      DELETE FROM MGMT_IP_ELEM_DEFAULT_PARAMS 
        where ELEMENT_NAME_NLSID = 'Availability Grid Element'
        and ELEMENT_TYPE_NLSID = 'any_target_type';
      EXCEPTION WHEN OTHERS THEN NULL;
    END;

    -- Hidden report for displaying transaction performance details report by url
    BEGIN
    MGMT_IP.delete_report_by_title('SYSMAN', 'Web Application Transaction Details ', 0);
    EXCEPTION WHEN OTHERS THEN NULL;
    END;

  -- Deleted all webapp beta elements

   
        
    -- e2e table from inputs
    l_param_classes := MGMT_IP_PARAM_CLASSES();
    l_param_classes.extend(4);
    l_param_classes(1) := 'oracle.sysman.eml.ip.render.elem.HeaderParamController';
    l_param_classes(2) := 'oracle.sysman.eml.ip.render.elem.TargetsParamController';
    l_param_classes(3) := 'oracle.sysman.eml.ip.render.elem.TimePeriodParamController';
    l_param_classes(4) := 'oracle.sysman.eml.ip.render.elem.webapps.e2e.E2EParamController';
    mgmt_ip.add_element_definition
      ('IPMSG_WEBAPP_REQ_PERF_ELEMENT_DESC',
        'IPMSG_SERVICE_TARGET_TYPES',
        'IPMSG_DSP_TABLE_MONTINFO_ELEMENT_DESC',
        'oracle.sysman.eml.ip.render.elem.webapps.e2e.SlowestURLRenderController',
        0,
        l_param_classes,
        null);  
    
        
    -- e2e chart from inputs
    l_param_classes := MGMT_IP_PARAM_CLASSES();
    l_param_classes.extend(3);
    l_param_classes(1) := 'oracle.sysman.eml.ip.render.elem.TargetsParamController';
    l_param_classes(2) := 'oracle.sysman.eml.ip.render.elem.TimePeriodParamController';
    l_param_classes(3) := 'oracle.sysman.eml.ip.render.elem.webapps.e2e.E2EChartParamController';
    mgmt_ip.add_element_definition
      ('IPMSG_WEBAPP_URL_PERF_ELEMENT_DESC',
        'IPMSG_SERVICE_TARGET_TYPES',
        'IPMSG_DSP_TIMESRSCHART_URLPERF_ELEMENT_DESC',
        'oracle.sysman.eml.ip.render.elem.webapps.e2e.URLPerfRenderController',
        0,
        l_param_classes,
        null);
        
    -- Transaction performance table from inputs
    l_param_classes := MGMT_IP_PARAM_CLASSES();
    l_param_classes.extend(4);
    l_param_classes(1) := 'oracle.sysman.eml.ip.render.elem.HeaderParamController';
    l_param_classes(2) := 'oracle.sysman.eml.ip.render.elem.TargetsParamController';
    l_param_classes(3) := 'oracle.sysman.eml.ip.render.elem.TimePeriodParamController';
    l_param_classes(4) := 'oracle.sysman.eml.ip.render.elem.webapps.tp.TransactionPerformanceParamController';
    mgmt_ip.add_element_definition
      ('IPMSG_WEBAPP_TRANS_PERFSUMMARY_ELEMENT_DESC',
        'IPMSG_SERVICE_TARGET_TYPES',
        'IPMSG_SHOW_TBLSUMM_TRANSPERF_ELEMENT_DESC',
        'oracle.sysman.eml.ip.render.elem.webapps.tp.TransactionPerformanceRenderController',
        0,
        l_param_classes,
        null);
        

    -- Transaction performance details table from inputs
    l_param_classes := MGMT_IP_PARAM_CLASSES();
    l_param_classes.extend(3);
    l_param_classes(1) := 'oracle.sysman.eml.ip.render.elem.TargetsParamController';
    l_param_classes(2) := 'oracle.sysman.eml.ip.render.elem.TimePeriodParamController';
    l_param_classes(3) := 'oracle.sysman.eml.ip.render.elem.webapps.tp.TransPerfParamController';
    mgmt_ip.add_element_definition
      ('IPMSG_WEBAPP_TRANSPERF_DETL_ELEMENT_DESC',
        'IPMSG_SERVICE_TARGET_TYPES',
        'IPMSG_DSPTBL_DEPCTTRANSPERF_GIVENTRANS_ELEMENT_DESC',
        'oracle.sysman.eml.ip.render.elem.webapps.tp.TransPerfDetailsRenderController',
        0,
        l_param_classes,
        null);   


		-- Element for Page By Axis 
		l_param_classes := MGMT_IP_PARAM_CLASSES();
      l_param_classes.extend(4);
			l_param_classes(1) := 'oracle.sysman.eml.ip.render.elem.HeaderParamController';
      l_param_classes(2) := 'oracle.sysman.eml.ip.render.elem.TargetsParamController';
      l_param_classes(3) := 'oracle.sysman.eml.ip.render.elem.TimePeriodParamController';
      l_param_classes(4) := 'oracle.sysman.eml.ip.render.elem.webapps.eum.PagesByAxisParamController';
      mgmt_ip.add_element_definition(
         p_element_name_nlsid  => 'IPMSG_WEBAPP_PAGEPERF_BYCAT_ELEMENT',
         p_element_type_nlsid  => 'IPMSG_SERVICE_TARGET_TYPES',
         p_description_nlsid   => 'IPMSG_WEBAPP_RENDVAL_DIFFPAGES_ELEMENT_DESC',
         p_element_class_name  => 'oracle.sysman.eml.ip.render.elem.webapps.eum.PagesByAxisRenderController',
         p_internal_use_only   => 0,
         p_param_classes       => l_param_classes,
         p_default_parameters  => null,
         p_pack_name           => null
         );
	
		 -- Element for EUM reports
		l_param_classes := MGMT_IP_PARAM_CLASSES();
      l_param_classes.extend(4);
			l_param_classes(1) := 'oracle.sysman.eml.ip.render.elem.HeaderParamController';
      l_param_classes(2) := 'oracle.sysman.eml.ip.render.elem.TargetsParamController';
      l_param_classes(3) := 'oracle.sysman.eml.ip.render.elem.TimePeriodParamController';
      l_param_classes(4) := 'oracle.sysman.eml.ip.render.elem.webapps.eum.EUMParamController';
      mgmt_ip.add_element_definition(
         p_element_name_nlsid  => 'IPMSG_WEBAPP_PAGEPERF_ELEMENT',
         p_element_type_nlsid  => 'IPMSG_SERVICE_TARGET_TYPES',
         p_description_nlsid   => 'IPMSG_WEBAPP_RENDEUMREP_ELEMENT_DESC',
         p_element_class_name  => 'oracle.sysman.eml.ip.render.elem.webapps.eum.EUMRenderController',
         p_internal_use_only   => 0,
         p_param_classes       => l_param_classes,
         p_default_parameters  => null,
         p_pack_name           => null
         );
	

		-- Element for Alert Reports	
      l_param_classes := MGMT_IP_PARAM_CLASSES();
      l_param_classes.extend(4);				
			l_param_classes(1) := 'oracle.sysman.eml.ip.render.elem.HeaderParamController';
      l_param_classes(2) := 'oracle.sysman.eml.ip.render.elem.TargetsParamController';
      l_param_classes(3) := 'oracle.sysman.eml.ip.render.elem.TimePeriodParamController';
      l_param_classes(4) := 'oracle.sysman.eml.ip.render.elem.webapps.summary.AlertParamController';
      mgmt_ip.add_element_definition(
         p_element_name_nlsid  => 'IPMSG_WEBAPP_ALERTS_ELEMENT',
         p_element_type_nlsid  => 'IPMSG_SERVICE_TARGET_TYPES',
         p_description_nlsid   => 'IPMSG_WEBAPP_DSPALERTS_ELEMENT_DESC',
         p_element_class_name  => 'oracle.sysman.eml.ip.render.elem.webapps.summary.AlertRenderController',
         p_internal_use_only   => 0,
         p_param_classes       => l_param_classes,
         p_default_parameters  => null,
         p_pack_name           => null
         );
	
		-- Element for Performance and Usage Reports		
      l_param_classes := MGMT_IP_PARAM_CLASSES();
      l_param_classes.extend(4);
      l_param_classes(1) := 'oracle.sysman.eml.ip.render.elem.HeaderParamController';
      l_param_classes(2) := 'oracle.sysman.eml.ip.render.elem.TargetsParamController';
      l_param_classes(3) := 'oracle.sysman.eml.ip.render.elem.TimePeriodParamController';
      l_param_classes(4) := 'oracle.sysman.eml.ip.render.elem.webapps.summary.PUParamController';
      mgmt_ip.add_element_definition(
         p_element_name_nlsid  => 'IPMSG_WEBAPP_METRICDTL_ELEMENT',
         p_element_type_nlsid  => 'IPMSG_SERVICE_TARGET_TYPES',
         p_description_nlsid   => 'IPMSG_WEBAPP_METRICDTL_ELEMENT_DESC',
         p_element_class_name  => 'oracle.sysman.eml.ip.render.elem.webapps.summary.PURenderController',
         p_internal_use_only   => 0,
         p_param_classes       => l_param_classes,
         p_default_parameters  => null,
         p_pack_name           => null
         );
	
				-- Hidden report for displaying transaction performance details report by url
				 l_param_values := MGMT_IP_PARAM_VALUE_LIST();
			   l_param_values.extend(3);
				l_param_values(1) := MGMT_IP_PARAM_VALUE_RECORD(
			    'oracle.sysman.eml.ip.render.elem.TimePeriodOption',
				  'true');
			   l_param_values(2) := MGMT_IP_PARAM_VALUE_RECORD(
					'oracle.sysman.eml.ip.render.elem.TimePeriodUserCust',
					'true');
			  	l_param_values(3) := MGMT_IP_PARAM_VALUE_RECORD(
					'oracle.sysman.eml.ip.render.elem.TimePeriodParam',
					'0:0');
         l_report_guid := mgmt_ip.create_report_definition (
										p_title_nlsid                   => 'IPMSG_WEBAPP_TRANSPERF_DTLS_REPORT',
										p_description_nlsid             => 'IPMSG_WEBAPP_TRANSPERF_DTLS_REPORT_DESC',
										p_owner => 'SYSMAN',
										p_category_nlsid => 'IPMSG_MONITORING_CATEGORY', 
										p_sub_category_nlsid => 'IPMSG_MONITORING_REPORT_SUB_CAT',
										p_internal_use_only => 1,
										p_public_report => 0,
										p_system_report => 1,
										p_show_navigation => 1,
										p_parameters    =>  l_param_values);
										
					l_param_values := MGMT_IP_PARAM_VALUE_LIST();
					l_param_values.extend(4);
					l_param_values(1) := MGMT_IP_PARAM_VALUE_RECORD(
										'oracle.sysman.eml.ip.render.elem.TextParamBean.textMessage', 'IPMSG_WEBAPP_DSP_TRANSPERF_DTLS_TEXT');
					l_param_values(2) := MGMT_IP_PARAM_VALUE_RECORD(
										'oracle.sysman.eml.ip.render.elem.TextParamBean.textStyle',	'OraInstructionText');
               l_param_values(3) := new MGMT_IP_PARAM_VALUE_RECORD('oracle.sysman.eml.ip.render.elem.TextParamBean.textDestination',
																										'');
					l_param_values(4) := new mgmt_ip_param_value_record('oracle.sysman.eml.ip.render.elem.TextParamBean.textResourceBundleName',
																										'oracle.sysman.resources.eml.ip.emr.webapps.IPWebappsResource');
					
					l_element_guid := mgmt_ip.add_element_to_report_def (
												p_report_guid => l_report_guid,
												p_element_name_nlsid => 'IPMSG_STYLED_TEXT',
												p_element_type_nlsid => 'IPMSG_ANY_TARGET_TYPE',
												p_element_order => 1,
												p_element_row => 1,
												p_parameters => l_param_values,
												p_targets => NULL
												);
					
					l_element_guid := mgmt_ip.add_element_to_report_def (
												l_report_guid,
												'IPMSG_WEBAPP_TRANSPERF_DETL_ELEMENT_DESC',
												'IPMSG_SERVICE_TARGET_TYPES',
												NULL,
												2,
												2,
												NULL,
												NULL);
					
				

  -- Upgrade User Defined Reports from BETA to Production
  BEGIN
      UPDATE MGMT_IP_REPORT_DEF_ELEMENTS SET 
        ELEMENT_NAME_NLSID = 'IPMSG_WEBAPP_REQ_PERF_ELEMENT_DESC',
        ELEMENT_TYPE_NLSID = 'IPMSG_SERVICE_TARGET_TYPES'
      WHERE
        ELEMENT_NAME_NLSID = 'Web Application Request Performance'
        AND ELEMENT_TYPE_NLSID = 'any_target_type';

      UPDATE MGMT_IP_REPORT_DEF_ELEMENTS SET 
        ELEMENT_NAME_NLSID = 'IPMSG_WEBAPP_URL_PERF_ELEMENT_DESC',
        ELEMENT_TYPE_NLSID = 'IPMSG_SERVICE_TARGET_TYPES'
      WHERE
        ELEMENT_NAME_NLSID = 'Web Application URL Performance'
        AND ELEMENT_TYPE_NLSID = 'any_target_type';

      UPDATE MGMT_IP_REPORT_DEF_ELEMENTS SET 
        ELEMENT_NAME_NLSID = 'IPMSG_WEBAPP_TRANS_PERFSUMMARY_ELEMENT_DESC',
        ELEMENT_TYPE_NLSID = 'IPMSG_SERVICE_TARGET_TYPES'
      WHERE
        ELEMENT_NAME_NLSID = 'Web Application Transaction Performance Summary'
        AND ELEMENT_TYPE_NLSID = 'any_target_type';

      UPDATE MGMT_IP_REPORT_DEF_ELEMENTS SET 
        ELEMENT_NAME_NLSID = 'IPMSG_WEBAPP_TRANSPERF_DETL_ELEMENT_DESC',
        ELEMENT_TYPE_NLSID = 'IPMSG_SERVICE_TARGET_TYPES'
      WHERE
        ELEMENT_NAME_NLSID = 'Web Application Transaction Performance Details'
        AND ELEMENT_TYPE_NLSID = 'any_target_type';

      UPDATE MGMT_IP_REPORT_DEF_ELEMENTS SET 
        ELEMENT_NAME_NLSID = 'IPMSG_WEBAPP_PAGEPERF_BYCAT_ELEMENT',
        ELEMENT_TYPE_NLSID = 'IPMSG_SERVICE_TARGET_TYPES'
      WHERE
        ELEMENT_NAME_NLSID = 'Web Application Page Performance By Category'
        AND ELEMENT_TYPE_NLSID = 'any_target_type';

      UPDATE MGMT_IP_REPORT_DEF_ELEMENTS SET 
        ELEMENT_NAME_NLSID = 'IPMSG_WEBAPP_PAGEPERF_ELEMENT',
        ELEMENT_TYPE_NLSID = 'IPMSG_SERVICE_TARGET_TYPES'
      WHERE
        ELEMENT_NAME_NLSID = 'Web Application Page Performance'
        AND ELEMENT_TYPE_NLSID = 'any_target_type';

      UPDATE MGMT_IP_REPORT_DEF_ELEMENTS SET 
        ELEMENT_NAME_NLSID = 'IPMSG_WEBAPP_ALERTS_ELEMENT',
        ELEMENT_TYPE_NLSID = 'IPMSG_SERVICE_TARGET_TYPES'
      WHERE
        ELEMENT_NAME_NLSID = 'Web Application Alerts'
        AND ELEMENT_TYPE_NLSID = 'any_target_type';

      UPDATE MGMT_IP_REPORT_DEF_ELEMENTS SET 
        ELEMENT_NAME_NLSID = 'IPMSG_WEBAPP_METRICDTL_ELEMENT',
        ELEMENT_TYPE_NLSID = 'IPMSG_SERVICE_TARGET_TYPES'
      WHERE
        ELEMENT_NAME_NLSID = 'Web Application Metric Details'
        AND ELEMENT_TYPE_NLSID = 'any_target_type';

--      UPDATE MGMT_IP_REPORT_DEF_ELEMENTS SET 
--        ELEMENT_NAME_NLSID = '',
--        ELEMENT_TYPE_NLSID = 'IPMSG_ANY_TARGET_TYPE'
--      WHERE
--        ELEMENT_NAME_NLSID = 'Web Application Availability'
--        AND ELEMENT_TYPE_NLSID = 'any_target_type';

  END;
  -- Upgraded User Defined Reports from BETA to Production

    COMMIT;    
  END;
END;
/

SET DEFINE ON
SET ECHO ON
