Rem
Rem $Header: jobs_init.sql 19-jul-2005.13:07:36 pkantawa Exp $
Rem
Rem jobs_init.sql
Rem
Rem Copyright (c) 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      jobs_init.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem       pkantawa 07/19/05 - Add target delete exception 
Rem       skini    07/12/05 - skini_gcbugs
Rem

-- Register commonly used command block procedures. Deregister
-- them to make sure any old versions are cleared first.
BEGIN
    MGMT_JOBS.deregister_command_block_proc('MGMT_JOBS.ADD_JOB_PARAMETERS');
    MGMT_JOBS.register_command_block_proc('MGMT_JOBS.ADD_JOB_PARAMETERS', MGMT_SHORT_STRING_ARRAY('RAW', 'RAW', 'MGMT_JOB_PARAM_LIST'));
END;
/
COMMIT;


-- Group membership change callbacks
BEGIN
    -- Callbacks for adding/removing a target to/from a group
    MGMT_ASSOC.add_assoc_addition_callback('MGMT_JOB_ENGINE.group_change_callback',
                                           MGMT_ASSOC.ASSOC_DEF_CONTAINS);
    EXCEPTION WHEN OTHERS THEN
        -- Ignore duplicate registration errors
        NULL;
END;
/

BEGIN
    MGMT_ASSOC.add_assoc_deletion_callback('MGMT_JOB_ENGINE.group_change_callback',
                                          MGMT_ASSOC.ASSOC_DEF_CONTAINS);
    EXCEPTION WHEN OTHERS THEN
      -- Ignore duplicate registration errors
      NULL;
END;
/

--Remove old target pre-deletion callback.  Add new target pre and post deletion callback.
DECLARE 
  del_exceptions SMP_EMD_STRING_ARRAY := SMP_EMD_STRING_ARRAY();
BEGIN
    
    EM_TARGET.del_tgt_pre_deletion_callback('MGMT_JOB_ENGINE.handle_target_delete');

    EM_TARGET.add_tgt_pre_deletion_callback('MGMT_JOB_ENGINE.handle_target_pre_delete');
    EM_TARGET.add_tgt_post_deletion_callback('MGMT_JOB_ENGINE.handle_target_post_delete');

    -- Add deletion exceptions
    del_exceptions.extend(1);
    del_exceptions(1) := 'MGMT_CORRECTIVE_ACTION';
    MGMT_ADMIN.add_target_deletion_exceptions(del_exceptions);
END;
/
show errors;

COMMIT;

