Rem drv: <migrate type="data_upgrade" version="10.2.0.1.0"/>
Rem
Rem $Header: license_data_upgrade.sql 20-sep-2005.01:28:58 paachary Exp $
Rem
Rem license_data_upgrade.sql
Rem
Rem Copyright (c) 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      license_data_upgrade.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    paachary    09/20/05 - grabtrans
Rem    sdantkal    09/19/05 - Having a differnt logic for beta-prod upgrade
Rem    paachary    09/16/05 - Calling license_post_creation_script
Rem    bram        08/24/05 - Taking care of beta-prod upgrade
Rem    paachary    07/18/05 - paachary_bug-4492521
Rem    paachary    07/15/05 - Created
Rem

SET ECHO ON

-- Calling license_post_creation.sql for inserting seed-data post beta into repository
@&EM_SQL_ROOT/core/v102020/license/license_post_creation.sql

COLUMN :script_name NEW_VALUE licensing_file NOPRINT
VARIABLE script_name VARCHAR2(500)

DECLARE
    all_pack_cnt      NUMBER DEFAULT 0;
    license_pack_cnt  NUMBER DEFAULT 0;
BEGIN
    -- Doing this step because to support licensing for targets
    -- post upgrade from older version to 10.2GC, we create two
    -- temporary tables in v102010/license to hold old data.
    -- These tables are being referenced in v102020/licensing_scripts.sql
    -- This was an issue when upgrading from Beta to 10.2GC.
    -- So, adding this conditional statements
    SELECT count(*) 
    INTO   all_pack_cnt
    FROM   all_tables
    WHERE  LOWER(table_name)='all_packs_1014';

    SELECT count(*) 
    INTO   license_pack_cnt
    FROM   all_tables
    WHERE  LOWER(table_name)='licensed_packs_1014';

    IF (license_pack_cnt >0 ) THEN
        :script_name := '&EM_SQL_ROOT/core/v102020/license/licensing_script.sql';
    ELSE 
        :script_name := '&EM_SQL_ROOT/core/v102020/license/licensing_script_post_beta.sql';
    END IF;
    
END;
/

SELECT :script_name  FROM DUAL;
@&licensing_file

DECLARE
    l_count NUMBER DEFAULT 0;
BEGIN
    SELECT count(*)
    INTO  l_count
    FROM  all_tables
    WHERE LOWER(table_name) = 'admin_licenses_beta';
   
   IF (l_count > 0 ) THEN
       EXECUTE IMMEDIATE 'DROP TABLE admin_licenses_beta';
   END IF;
END;
/

