Rem DO NOT PUT ANY HEADERS TO THIS FILE AS IT IS BEING CALLED FROM 
Rem license_data_upgrade.sql
Rem $Header: license_post_creation.sql 26-sep-2005.04:54:00 spandita Exp $
Rem
Rem license_post_creation.sql
Rem
Rem Copyright (c) 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      license_post_creation.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      Added new packs and target types
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    spandita    09/26/05 - bug-4632961(remove 
Rem                           weblogic_domain,weblogic_cluster,websphere_cell 
Rem                           and websphere_cluster as licensable target 
Rem                           types) 
Rem    paachary    09/23/05 - make website licensable target type
Rem    paachary    09/22/05 - paachary_bug-4610525
Rem    paachary    09/20/05 - grabtrans
Rem    paachary    09/15/05 - Created
Rem

SET ECHO ON

DECLARE
    l_count NUMBER DEFAULT 0;
BEGIN
    -- Remove the dependencies of host from the DB and iAS packs
    -- Remove the dependencies of cluster from RAC
    SELECT count(*)
    INTO   l_count
    FROM   mgmt_licensable_target_types
    WHERE  target_type       = 'host';
    
    IF (l_count > 0 ) THEN
        DELETE mgmt_licensable_target_types
        WHERE  target_type       = 'host';
    END IF;

    SELECT count(*)
    INTO   l_count
    FROM   mgmt_licensable_target_types
    WHERE  pack_target_type = 'rac_database' AND
           target_type       = 'cluster';

    IF (l_count > 0 ) THEN
        DELETE mgmt_licensable_target_types
        WHERE  pack_target_type = 'rac_database' AND
               target_type       = 'cluster';
    END IF;

    -- Add new packs for target types
    em_license.add_pack_definitions
    (
        p_pack_label         => 'nos_config'  ,
        p_target_type        => 'host'  ,
        p_pack_display_label => 'Configuration Management Pack for Non-Oracle Systems',
        p_pack_description   => 'Configuration Management for Non-Oracle Systems delivers functionality that centrally collects and analyzes configuration data for systems not running Oracle software. This pack provides capabilities such as :<p><li>Search and compare across all systems</li><li>Configuration monitoring</li><li>Policy management and compliance support</li><li>Security configuration scoring and dashboards</li> <li>Comprehensive reporting</li></p>' ,
        p_pack_abbr          => 'CMNOS'  
    );

    em_license.add_pack_definitions
    (
        p_pack_label         => 'nos_config'  ,
        p_target_type        => 'cluster'  ,
        p_pack_display_label => 'Configuration Management Pack for Non-Oracle Systems',
        p_pack_description   => 'Configuration Management for Non-Oracle Systems delivers functionality that centrally collects and analyzes configuration data for systems not running Oracle software. This pack provides capabilities such as :<p><li>Search and compare across all systems</li><li>Configuration monitoring</li><li>Policy management and compliance support</li><li>Security configuration scoring and dashboards</li> <li>Comprehensive reporting</li></p>' ,
        p_pack_abbr          => 'CMNOS'  
    );

    em_license.add_pack_definitions
    (
        p_pack_label         => 'host_smp'  ,
        p_target_type        => 'host'  ,
        p_pack_display_label => 'Enterprise Manager System Monitoring Plug-in for Hosts',
        p_pack_description   => 'The System Monitoring Plug-in for Hosts provides performance and availabity data collection.<p><li>Real-time and historical monitoring</li><li>Event monitoring</li><li>Notifications</li><li>Performance reporting for host systems</li></p>' ,
        p_pack_abbr          => 'SMH'  
    );

    em_license.add_pack_definitions
    (
        p_pack_label         => 'host_smp'  ,
        p_target_type        => 'cluster'  ,
        p_pack_display_label => 'Enterprise Manager System Monitoring Plug-in for Hosts',
        p_pack_description   => 'The System Monitoring Plug-in for Hosts provides performance and availabity data collection.<p><li>Real-time and historical monitoring</li><li>Event monitoring</li><li>Notifications</li><li>Performance reporting for host systems</li></p>' ,
        p_pack_abbr          => 'SMH'  
    );

    em_license.add_pack_definitions
    (
        p_pack_label         => 'provisioning'  ,
        p_target_type        => 'oracle_database'  ,
        p_pack_display_label => 'Provisioning Pack',
        p_pack_description   => 'Provisioning Pack delivers functionality that automates deployment of software, applications, and patches.This pack provides functionality for :<p><li>Bare metal provisioning of operating systems and software images</li><li>Cloning of existing installations and software images (such as CRS/RAC and AS)</li><li>Patching</li></p>' ,
        p_pack_abbr          => 'PV'  
    );

    em_license.add_pack_definitions
    (
        p_pack_label         => 'provisioning'  ,
        p_target_type        => 'oracle_ias'  ,
        p_pack_display_label => 'Provisioning Pack',
        p_pack_description   => 'Provisioning Pack delivers functionality that automates deployment of software, applications, and patches.This pack provides functionality for :<p><li>Bare metal provisioning of operating systems and software images</li><li>Cloning of existing installations and software images (such as CRS/RAC and AS)</li><li>Patching</li></p>' ,
        p_pack_abbr          => 'PV'  
    );

    em_license.add_pack_definitions
    (
        p_pack_label         => 'provisioning'  ,
        p_target_type        => 'host'  ,
        p_pack_display_label => 'Provisioning Pack',
        p_pack_description   => 'Provisioning Pack delivers functionality that automates deployment of software, applications, and patches.This pack provides functionality for :<p><li>Bare metal provisioning of operating systems and software images</li><li>Cloning of existing installations and software images (such as CRS/RAC and AS)</li><li>Patching</li></p>' ,
        p_pack_abbr          => 'PV'  
    );

    em_license.add_pack_definitions
    (
        p_pack_label         => 'provisioning'  ,
        p_target_type        => 'cluster'  ,
        p_pack_display_label => 'Provisioning Pack',
        p_pack_description   => 'Provisioning Pack delivers functionality that automates deployment of software, applications, and patches.This pack provides functionality for :<p><li>Bare metal provisioning of operating systems and software images</li><li>Cloning of existing installations and software images (such as CRS/RAC and AS)</li><li>Patching</li></p>' ,
        p_pack_abbr          => 'PV'  
    );

    em_license.add_pack_definitions
    (
        p_pack_label         => 'provisioning'  ,
        p_target_type        => 'rac_database'  ,
        p_pack_display_label => 'Provisioning Pack',
        p_pack_description   => 'Provisioning Pack delivers functionality that automates deployment of software, applications, and patches.This pack provides functionality for :<p><li>Bare metal provisioning of operating systems and software images</li><li>Cloning of existing installations and software images (such as CRS/RAC and AS)</li><li>Patching</li></p>' ,
        p_pack_abbr          => 'PV'  
    );

    em_license.add_pack_definitions
    (
        p_pack_label         => 'service_level_mgmt'  ,
        p_target_type        => 'oracle_beacon'  ,
        p_pack_display_label => 'Service Level Management Pack',
        p_pack_description   => 'Service Level Management delivers functionality to actively monitor and report on availability,performance of critical applications, sites, and infrastructure components using synthetic transactions executed from remote sites (beacons.)' ,
        p_pack_abbr          => 'SLM'  
    );

    em_license.add_pack_definitions
    (
        p_pack_label         => 'service_level_mgmt'  ,
        p_target_type        => 'website'  ,
        p_pack_display_label => 'Service Level Management Pack',
        p_pack_description   => 'Service Level Management delivers functionality to actively monitor and report on availability,performance of critical applications, sites, and infrastructure components using synthetic transactions executed from remote sites (beacons.)' ,
        p_pack_abbr          => 'SLM'  
    );

    em_license.add_pack_definitions
    (
        p_pack_label         => 'service_level_mgmt'  ,
        p_target_type        => 'generic_service'  ,
        p_pack_display_label => 'Service Level Management Pack',
        p_pack_description   => 'Service Level Management delivers functionality to actively monitor and report on availability,performance of critical applications, sites, and infrastructure components using synthetic transactions executed from remote sites (beacons.)' ,
        p_pack_abbr          => 'SLM'  
    );
    
    em_license.add_pack_definitions
    (
        p_pack_label         => 'nodb_smp'  ,
        p_target_type        => 'microsoft_sqlserver_database'  ,
        p_pack_display_label => 'Enterprise Manager System Monitoring Plug-in for Non-Oracle Databases',
        p_pack_description   => 'The System Monitoring Plug-in for Non-Oracle Databases provides performance and availabity data collection.<p><li>Real-time and historical monitoring</li><li>Event monitoring</li><li>Notifications</li><li>Performance reporting for Non-Oracle databases</li></p>' ,
        p_pack_abbr          => 'SMNOD'  
    );

    em_license.add_pack_definitions
    (
        p_pack_label         => 'nodb_smp'  ,
        p_target_type        => 'ibm_db2_database'  ,
        p_pack_display_label => 'Enterprise Manager System Monitoring Plug-in for Non-Oracle Databases',
        p_pack_description   => 'The System Monitoring Plug-in for Non-Oracle Databases provides performance and availabity data collection.<p><li>Real-time and historical monitoring</li><li>Event monitoring</li><li>Notifications</li><li>Performance reporting for Non-Oracle databases</li></p>' ,
        p_pack_abbr          => 'SMNOD'  
    );

    em_license.add_pack_definitions
    (
        p_pack_label         => 'nom_smp'  ,
        p_target_type        => 'weblogic_j2eeserver'  ,
        p_pack_display_label => 'Enterprise Manager System Monitoring Plug-in for Non-Oracle Middleware',
        p_pack_description   => 'The System Monitoring Plug-in for Non-Oracle Middleware provides performance and availabity data collection.<p><li>Real-time and historical monitoring</li><li>Event monitoring</li><li>Notifications</li><li>Performance reporting for Non-Oracle Middleware</li><li>Application MBeans and Web Service Endpoints</li></p>' ,
        p_pack_abbr          => 'SMNOM'  
    );

    em_license.add_pack_definitions
    (
        p_pack_label         => 'nom_smp'  ,
        p_target_type        => 'websphere_j2eeserver'  ,
        p_pack_display_label => 'Enterprise Manager System Monitoring Plug-in for Non-Oracle Middleware',
        p_pack_description   => 'The System Monitoring Plug-in for Non-Oracle Middleware provides performance and availabity data collection.<p><li>Real-time and historical monitoring</li><li>Event monitoring</li><li>Notifications</li><li>Performance reporting for Non-Oracle Middleware</li><li>Application MBeans and Web Service Endpoints</li></p>' ,
        p_pack_abbr          => 'SMNOM'  
    );

    em_license.add_pack_definitions
    (
        p_pack_label         => 'storage_smp'  ,
        p_target_type        => 'netapp_filer'  ,
        p_pack_display_label => 'Enterprise Manager System Monitoring Plug-in for Storage',
        p_pack_description   => 'The System Monitoring Plug-in for Storage provides performance and availabity data collection.<p><li>Real-time and historical monitoring</li><li>Event monitoring</li><li>Notifications</li><li>Performance reporting for storage devices</li></p>' ,
        p_pack_abbr          => 'SMS'  
    );

    em_license.add_pack_definitions
    (
        p_pack_label         => 'storage_smp'  ,
        p_target_type        => 'slb'  ,
        p_pack_display_label => 'Enterprise Manager System Monitoring Plug-in for Storage',
        p_pack_description   => 'The System Monitoring Plug-in for Storage provides performance and availabity data collection.<p><li>Real-time and historical monitoring</li><li>Event monitoring</li><li>Notifications</li><li>Performance reporting for storage devices</li></p>' ,
        p_pack_abbr          => 'SMS'  
    );

    em_license.add_pack_definitions
    (
        p_pack_label         => 'nd_smp'  ,
        p_target_type        => 'juniper_netscreen_firewall'  ,
        p_pack_display_label => 'Enterprise Manager System Monitoring Plug-in for Network Devices',
        p_pack_description   => 'The System Monitoring Plug-in for Network Devices provides performance and availabity data collection.<p><li>Real-time and historical monitoring</li><li>Event monitoring</li><li>Notifications</li><li>Performance reporting for network devices</li></p>' ,
        p_pack_abbr          => 'SMND'  
    );

    em_license.add_pack_definitions
    (
        p_pack_label         => 'nd_smp'  ,
        p_target_type        => 'checkpoint_firewall'  ,
        p_pack_display_label => 'Enterprise Manager System Monitoring Plug-in for Network Devices',
        p_pack_description   => 'The System Monitoring Plug-in for Network Devices provides performance and availabity data collection.<p><li>Real-time and historical monitoring</li><li>Event monitoring</li><li>Notifications</li><li>Performance reporting for network devices</li></p>' ,
        p_pack_abbr          => 'SMND'  
    );

    em_license.add_pack_definitions
    (
        p_pack_label         => 'nd_smp'  ,
        p_target_type        => 'f5_bigip_v9plus_loadbalancer'  ,
        p_pack_display_label => 'Enterprise Manager System Monitoring Plug-in for Network Devices',
        p_pack_description   => 'The System Monitoring Plug-in for Network Devices provides performance and availabity data collection.<p><li>Real-time and historical monitoring</li><li>Event monitoring</li><li>Notifications</li><li>Performance reporting for network devices</li></p>' ,
        p_pack_abbr          => 'SMND'  
    );


    em_license.add_pack_definitions
    (
        p_pack_label         => 'db_diag'  ,
        p_target_type        => 'oracle_database'  ,
        p_pack_display_label => 'Database Diagnostics Pack',
        p_pack_description   => 'Oracle Diagnostics Pack 10g for database offers a complete, cost-effective, and easy to use solution for managing the performance of Oracle Database environments by providing unique functionality such as automatic identification of performance bottlenecks, guided problem resolution, and comprehensive system monitoring.<p><li> Performance Monitoring (Database and Host)</li> <li> ADDM (Automated Database Diagnostic Monitor)</li> <li> Automatic Workload Repository </li> <li> Event Notifications:  Notification Methods, Rules and Schedules <li> Event history/metric history (Database and Host)</li> <li> Blackouts</li></p>',
        p_pack_abbr          => 'DD'  
    );
    
    em_license.add_pack_definitions
    (
        p_pack_label         => 'db_tuning'  ,
        p_target_type        => 'oracle_database'  ,
        p_pack_display_label => 'Database Tuning Pack',
        p_pack_description   => 'Oracle Tuning Pack 10g offers a set of new, groundbreaking technologies that automate the entire application tuning process, thereby significantly lowering database management costs while enhancing performance and reliability.<p><li>SQL Access Advisor</li><li>SQL Tuning Advisor</li><li>SQL Tuning Sets</li><li>Reorganize Objects</li></p>',
        p_pack_abbr          => 'DT'  
    );

    -- Make the following target types parent licensable target types
    em_license.add_licensable_target_types
    (
        p_pack_target_type    => 'host',
        p_target_type         => 'host'
    );

    em_license.add_licensable_target_types
    (
        p_pack_target_type    => 'cluster',
        p_target_type         => 'cluster'
    );

    em_license.add_licensable_target_types
    (
        p_pack_target_type    => 'oracle_beacon',
        p_target_type         => 'oracle_beacon'
    );

    em_license.add_licensable_target_types
    (
        p_pack_target_type    => 'oracle_beacon',
        p_target_type         => 'oracle_beacon'
    );

    em_license.add_licensable_target_types
    (
        p_pack_target_type    => 'generic_service',
        p_target_type         => 'generic_service'
    );

    em_license.add_licensable_target_types
    (
        p_pack_target_type    => 'microsoft_sqlserver_database',
        p_target_type         => 'microsoft_sqlserver_database'
    );

    em_license.add_licensable_target_types
    (
        p_pack_target_type    => 'ibm_db2_database',
        p_target_type         => 'ibm_db2_database'
    );

    em_license.add_licensable_target_types
    (
        p_pack_target_type    => 'weblogic_j2eeserver',
        p_target_type         => 'weblogic_j2eeserver'
    );

    em_license.add_licensable_target_types
    (
        p_pack_target_type    => 'websphere_j2eeserver',
        p_target_type         => 'websphere_j2eeserver'
    );

    em_license.add_licensable_target_types
    (
        p_pack_target_type    => 'juniper_netscreen_firewall',
        p_target_type         => 'juniper_netscreen_firewall'
    );

    em_license.add_licensable_target_types
    (
        p_pack_target_type    => 'checkpoint_firewall',
        p_target_type         => 'checkpoint_firewall'
    );

    em_license.add_licensable_target_types
    (
        p_pack_target_type    => 'f5_bigip_v9plus_loadbalancer',
        p_target_type         => 'f5_bigip_v9plus_loadbalancer'
    );

    em_license.add_licensable_target_types
    (
        p_pack_target_type    => 'netapp_filer',
        p_target_type         => 'netapp_filer'
    );

    em_license.add_licensable_target_types
    (
        p_pack_target_type    => 'slb',
        p_target_type         => 'slb'
    );

    em_license.add_licensable_target_types
    (
        p_pack_target_type    => 'website',
        p_target_type         => 'website'
    );

    -- Add new packs in mgmt_admin_licenses
    em_license.add_packs
    (
        p_pack_name     => 'nos_config'
    );

    em_license.add_packs
    (
        p_pack_name     => 'host_smp'
    );

    em_license.add_packs
    (
        p_pack_name     => 'provisioning'
    );

    em_license.add_packs
    (
        p_pack_name     => 'service_level_mgmt'
    );

    em_license.add_packs
    (
        p_pack_name     => 'nodb_smp'
    );

    em_license.add_packs
    (
        p_pack_name     => 'nom_smp'
    );

    em_license.add_packs
    (
        p_pack_name     => 'storage_smp'
    );

    em_license.add_packs
    (
        p_pack_name     => 'nd_smp'
    );
    
    COMMIT;
END;
/
