Rem drv: <migrate type="schema_upgrade" version="10.2.0.1"/>
Rem
Rem $Header: metric_schema_upgrade.sql 25-aug-2005.05:04:48 neearora Exp $
Rem
Rem metric_schema_upgrade.sql
Rem
Rem Copyright (c) 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      metric_schema_upgrade.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    neearora 08/25/05 - Added existence check before dropping MGMT_METRIC_COLUMN_ARRAY 
Rem    chyu     08/24/05 - chyu_bugix_4567468
Rem    chyu     08/23/05 - Created
Rem

BEGIN
 EXECUTE IMMEDIATE 'DROP TYPE &&EM_REPOS_USER..MGMT_METRIC_COLUMN_ARRAY';
EXCEPTION
 WHEN OTHERS THEN
   IF(SQLCODE != -4043)THEN -- Object does not exist
      RAISE;
   END IF;
END;
/

Rem PURPOSE
Rem Used to define metric column for a table metric.
CREATE OR REPLACE TYPE MGMT_METRIC_COLUMN_OBJ IS OBJECT
(
    column_name          VARCHAR2(64),
    column_type          NUMBER(2),
    is_key               NUMBER(1),
    column_label         VARCHAR2(64),
    column_label_nlsid   VARCHAR2(64),
    description          VARCHAR2(128),
    description_nlsid    VARCHAR2(64),
    unit                 VARCHAR2(64),
    unit_nlsid           VARCHAR2(64), 
    short_name           VARCHAR2(64),
    short_name_nlsid     VARCHAR2(64),
    is_for_summary       NUMBER(1),
    statefull            NUMBER(1),
    source_type          NUMBER(1),
    source               VARCHAR2(4000),
    non_thresholded_alerts NUMBER(1),
    keyonly_thresholds   NUMBER(1),
    is_renderable        NUMBER(1),
    category_list        MGMT_CATEGORY_ARRAY,
    STATIC FUNCTION NEW(
        p_column_name        IN VARCHAR2,
        p_column_type        IN NUMBER,
        p_is_key             IN NUMBER   DEFAULT 0,
        p_column_label       IN VARCHAR2 DEFAULT NULL,
        p_column_label_nlsid IN VARCHAR2 DEFAULT NULL,
        p_description        IN VARCHAR2 DEFAULT ' ',
        p_description_nlsid  IN VARCHAR2 DEFAULT NULL,
        p_unit               IN VARCHAR2 DEFAULT ' ',
        p_unit_nlsid         IN VARCHAR2 DEFAULT NULL,
        p_short_name         IN VARCHAR2 DEFAULT NULL,
        p_short_name_nlsid   IN VARCHAR2 DEFAULT NULL,
        p_is_for_summary     IN NUMBER   DEFAULT 0,
        p_statefull          IN NUMBER   DEFAULT 1,
        p_source_type        IN NUMBER   DEFAULT 0,
        p_source             IN VARCHAR2 DEFAULT NULL,
        p_non_thresholded_alerts IN NUMBER DEFAULT 0,
        p_keyonly_thresholds IN NUMBER DEFAULT 0,
        p_is_renderable      IN NUMBER DEFAULT 1,
        p_category_list      IN MGMT_CATEGORY_ARRAY DEFAULT NULL
      )
    RETURN MGMT_METRIC_COLUMN_OBJ
);
/

CREATE OR REPLACE TYPE MGMT_METRIC_COLUMN_ARRAY IS TABLE OF MGMT_METRIC_COLUMN_OBJ;
/


