Rem drv: <migrate type="schema_upgrade" version="10.2.0.1"/>
Rem
Rem $Header: ping_schema_upgrade.sql 03-aug-2005.00:17:43 pmodi Exp $
Rem
Rem ping_schema_upgrade.sql
Rem
Rem Copyright (c) 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      ping_schema_upgrade.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    pmodi       08/03/05 - Bug:4527456 - Include a call for 
Rem                           ping_upgrade_4397891 
Rem    chyu        07/29/05 - adding the <create> header 
Rem    rkpandey    07/28/05 - rkpandey_bug-3369474
Rem    rkpandey    07/21/05 - Created
Rem

DROP TYPE EM_AGENT_HEARTBEAT_ARRAY;

CREATE OR REPLACE TYPE EM_AGENT_HEARTBEAT AS OBJECT
(
  emd_url          VARCHAR2(2000),
  heartbeat_time   VARCHAR2(32),
  is_first_hb      VARCHAR2(2),
  is_clean_hb      VARCHAR2(2),
  status_sent_upto VARCHAR2(32),
  emd_uptime       VARCHAR2(32),
  recorder_url     VARCHAR2(2000),
  agent_errors     VARCHAR2(256)
);
/

CREATE OR REPLACE TYPE EM_AGENT_HEARTBEAT_ARRAY AS TABLE
  OF EM_AGENT_HEARTBEAT;
/

-- Conditionally run the schema upgrade script

COLUMN :script_name NEW_VALUE sch_upg_file NOPRINT
VARIABLE script_name VARCHAR2(1024);

DECLARE
  l_obj_name VARCHAR2(64);
BEGIN

  BEGIN
    SELECT object_name INTO l_obj_name
      FROM all_objects
     WHERE owner = '&&EM_REPOS_USER'
       AND object_type = 'TABLE'
       AND object_name = 'MGMT_EMD_PING_CHECK';

    :script_name := '&&EM_SQL_ROOT/core/latest/admin/admin_do_nothing.sql';

  EXCEPTION
    WHEN NO_DATA_FOUND THEN
      :script_name := '&&EM_SQL_ROOT/core/v102020/ping/ping_upgrade_4397891.sql';
  END;

END;
/

SELECT :script_name FROM DUAL;

@@&&sch_upg_file

