Rem
Rem $Header: policy_types_downgrade.sql 03-aug-2005.08:04:23 niramach Exp $
Rem
Rem policy_types_downgrade.sql
Rem
Rem Copyright (c) 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem     policy_types_downgrade.sql - Downgrade scripts for policy types 
Rem
Rem    DESCRIPTION
Rem      It has the creation of V1 policy types and removal of V2 
Rem      policy types and type bodies.
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    niramach    08/03/05 - niramach_bugfix-4527462
Rem    niramach    04/29/05 - niramach_bug-4293674
Rem    niramach    04/26/05 - Created
Rem

-- Create the V1 policy types that are obsolete in V2 policy framework.
-- Since it is downgrade, those V1 policy types should be created.
--  POLICY API
-- The following types are for use by the POLICY API.
-- The API requires that the user pass lists of objects such as rule columns, 
-- rule parameters, policy criteria....

rem           RULE_COLUMN
rem  PURPOSE
rem     The object is used to represent individual rule columns.  A list (table)
rem   of these is passed along with its parent rule in CREATE_POLICY_RULE().
rem
rem  COLUMNS
rem     COLUMN_NAME     The name of the column.
rem     IS_KEY          Is the column a key, 'Y' or 'N'?
rem     IS_VISIBLE      Should this column be visible in UI, , 'Y' or 'N'?
rem     URL             URL template with column names for substitution.
rem     DISPLAY_NAME    Name to display if resource (using COLUMN_NAME) can't be
rem                     found
rem     DISPLAY_FORMAT  Display format to use when displaying the row-column
rem                       values in the UI.  0,1,2 (textFormat, numberFormat,
rem                       dateFormat)
rem
CREATE OR REPLACE TYPE ECM_RULE_COLUMN AS OBJECT
(
  COLUMN_NAME VARCHAR2( &P_COLUMN_NAME_LENGTH ),
  IS_KEY VARCHAR2( &P_Y_N_LENGTH ),
  IS_VISIBLE VARCHAR2( &P_Y_N_LENGTH ),
  URL VARCHAR2( &P_URL_LENGTH ),
  DISPLAY_NAME VARCHAR2( &P_COLUMN_NAME_LENGTH ),
  DISPLAY_FORMAT NUMBER (&P_REASONABLE_NUMBER_LENGTH )
);
/

CREATE OR REPLACE TYPE ECM_RULE_COLUMN_LIST AS TABLE OF ECM_RULE_COLUMN;
/


rem           RULE_PARAM
rem  PURPOSE
rem     The object is used to represent individual rule paramaters.  A list (table)
rem   of these is passed along with it's parent rule in CREATE_POLICY_RULE().
rem
rem  COLUMNS
rem     PARAM_NAME      The name of the parameter.  Used for binding the 
rem                       parameter value to the placeholders in the rule predicates.
rem     PARAM_VALUE     The value of the parameter, used as a default if the 
rem                       policy using the rule doesn't override it.
rem     DISPLAY_NAME    Name to display if resource (using COLUMN_NAME) can't be
rem                     found
rem     DISPLAY_FORMAT  Display format to use when displaying the parameter
rem                       values in the UI.  0,1,2 (textFormat, numberFormat,
rem                       dateFormat)
rem
CREATE OR REPLACE TYPE ECM_RULE_PARAM AS OBJECT
(
  PARAM_NAME VARCHAR2( &P_PARAM_NAME_LENGTH ),
  PARAM_VALUE VARCHAR2( &P_PARAM_VALUE_LENGTH ),
  DISPLAY_NAME VARCHAR2( &P_PARAM_NAME_LENGTH ),
  DISPLAY_FORMAT NUMBER (&P_REASONABLE_NUMBER_LENGTH )
);
/

CREATE OR REPLACE TYPE ECM_RULE_PARAM_LIST AS TABLE OF ECM_RULE_PARAM;
/

rem           ECM_RULE_VIOLATION_VALUE
rem
rem PURPOSE
rem   Rule violation rows can be represented as a list of name value pairs for
rem   each column/attribute in the result set of the rule object.  The 
rem   RULE_VIOLATION_VALUE object is used to represent each attribute/column
rem   name-value pair.
CREATE OR REPLACE TYPE ECM_RULE_VIOLATION_VALUE AS OBJECT
(
  ATTRIBUTE_NAME VARCHAR2( &P_ATTRIBUTE_NAME_LENGTH ),
  ATTRIBUTE_VALUE VARCHAR2( &P_ATTRIBUTE_VALUE_LENGTH )
);
/

CREATE OR REPLACE TYPE ECM_RULE_VIOLATION_VALUE_LIST AS TABLE OF ECM_RULE_VIOLATION_VALUE;
/


rem           POLICY_PARAM
rem  PURPOSE
rem     The object is used to represent individual policy paramaters.  A list 
rem   (table) of these is passed along with its parent rule in 
rem   CREATE_POLICY_GROUP().  The values of these are used to override rule 
rem   parameters with the same name.  The authore target_type, category and
rem   rule name are used to determine which rules the parameter applies to.  
rem   This can be more than one since they can be wildcarded strings.
rem
rem  COLUMNS
rem     AUTHOR            The rule author....Used to determin which rules in the
rem                   policy this parameter can be applied to.
rem     TARGET_TYPE       A string used to determine which rules in the policy
rem                   this parameter can be applied to.  Rules are identified by
rem                   their name, target_type and category.
rem     CATEGORY          A string used to determine which rules in the policy
rem                   this parameter can be applied to.  Rules are identified by
rem                   their name, target_type and category.
rem     RULE_NAME         A string used to determine which rule in the policy 
rem                   that this parameter can be applied to.  It can be a wildcarded
rem                   string.
rem     PARAM_NAME        The name of the parameter.  Used for binding the 
rem                   parameter value to the placeholders in the rule predicates.
rem     PARAM_VALUE       The value of the parameter, used as a default if the 
rem                   policy using the rule doesn't override it.
rem
CREATE OR REPLACE TYPE ECM_POLICY_PARAM AS OBJECT
(
  AUTHOR VARCHAR2( &P_AUTHOR_LENGTH ),
  TARGET_TYPE VARCHAR2( &P_TARGET_TYPE_LENGTH ), 
  CATEGORY VARCHAR2( &P_CATEGORY_LENGTH ), 
  RULE_NAME VARCHAR2( &P_RULE_NAME_LENGTH ), 
  PARAM_NAME VARCHAR2( &P_PARAM_NAME_LENGTH ), 
  PARAM_VALUE VARCHAR2( &P_PARAM_VALUE_LENGTH ) 
);
/

CREATE OR REPLACE TYPE ECM_POLICY_PARAM_LIST AS TABLE OF ECM_POLICY_PARAM;
/

rem           POLICY_RULE_CRITERION
rem  PURPOSE
rem     A policy must specify criteria that is used at run-time to determine 
rem     which rules are to be evaluated.  Rules are identified by their author,  
rem     target_type, category and rule name.  The values in this object can be 
rem     wild-carded allowing a single criterion to refer to multiple rules, the 
rem     set of which is determined each time a policy is evaluated.
rem
rem  COLUMNS
rem     AUTHOR            The rule author.
rem     TARGET_TYPE       A string used to determine which rules should be
rem                   evaluated when the policy is checked.  Rules are identified by
rem                   their name, target_type and category.
rem     CATEGORY          A string used to determine which rules should be
rem                   evaluated when the policy is checked.   Rules are identified by
rem                   their name, target_type and category.
rem     RULE_NAME         A string used to determine which rules should be
rem                   evaluated when the policy is checked.  It can be a wildcarded
rem                   string.
rem
CREATE OR REPLACE TYPE ECM_POLICY_RULE_CRITERION AS OBJECT
(
  AUTHOR VARCHAR2( &P_AUTHOR_LENGTH ),
  TARGET_TYPE VARCHAR2( &P_TARGET_TYPE_LENGTH ), 
  CATEGORY VARCHAR2( &P_CATEGORY_LENGTH ),
  RULE_NAME VARCHAR2( &P_RULE_NAME_LENGTH )
);
/

CREATE OR REPLACE TYPE ECM_POLICY_RULE_CRITERIA AS TABLE OF ECM_POLICY_RULE_CRITERION;
/

rem           POLICY_TARGET_CRITERION
rem  PURPOSE
rem     A policy must specify criteria that is used at run-time to determine 
rem     which targets the rules are to be evaluated against.  Targets are 
rem     identified by their name and target_type.  The filter op is used to 
rem     indicate "LIKE", or "NOT LIKE". The values in this object can be 
rem     wild-carded allowing a single criterion to refer to multiple targets, 
rem     the set of which is determined each time a policy is evaluated.
rem
rem  COLUMNS
rem     NAME_IS_GROUP     'Y' if the name is a group name to which the criterion says
rem                       any matching target in the group with a matching target
rem                       type is included.
rem     TARGET_TYPE       A string used to determine which targets on which to 
rem                   evaluate the rules.  This can be wildcarded.
rem     TARGET_NAME          A string used to determine which targets on which to 
rem                   evaluate the rules.  This can be wildcarded.
rem     FILTER_OP          A string indicating how to match the targets.
rem
CREATE OR REPLACE TYPE ECM_POLICY_TARGET_CRITERION AS OBJECT
(
  NAME_IS_GROUP VARCHAR2(&P_Y_N_LENGTH),
  TARGET_TYPE VARCHAR2( &P_TARGET_TYPE_LENGTH ), 
  TARGET_NAME VARCHAR2( &P_TARGET_NAME_LENGTH ), 
  FILTER_OP VARCHAR2( &P_FILTER_OP_LENGTH ) 
);
/

CREATE OR REPLACE TYPE ECM_POLICY_TARGET_CRITERIA IS TABLE OF ECM_POLICY_TARGET_CRITERION;
/

rem           ECM_RULE
rem  PURPOSE
rem    This object represents an ECM Rule object.  It is a non-instantiable, 
rem    meaning one must create a subtype that implements the HANDLE_VIOLATION
rem    method.  See MGMT_POLICY_RULE, et. al. for more detail of the attributes. 
rem    In general, this object should have all columns in that table 
rem    represented as members.
rem  METHODS:
rem    EVALUATE:
rem    The method EVALUATE is used to evaluate the rule, Parameters to EVALUATE 
rem    are:
rem      p_evalTime - evaluation time which is used to ensure that all rule 
rem        violations detected can use the same timestamp is so desired.
rem      p_rt_params - A list of parameter name value pairs used to override the
rem        default parameters of this rule.  For policies, these are the policy
rem        params.
rem      p_targetClause - a select statement that defines the set of targets 
rem        againsts which the rules are evaluated.
rem    GET_VIOLATION_GUID:
rem    This method is to be overrided and is meant to return a unique id 
rem    for the violation  
rem    HANDLE_VIOLATION:
rem    This method is to be overrided and is meant to handle each row violation 
rem    found.  For Policies, the method would write the results to a database
rem    table.  
CREATE OR REPLACE TYPE ECM_RULE AS OBJECT
(
  AUTHOR VARCHAR(&P_AUTHOR_LENGTH),
  TARGET_TYPE VARCHAR2(&P_TARGET_TYPE_LENGTH),
  CATEGORY VARCHAR2(&P_CATEGORY_LENGTH),
  RULE_NAME VARCHAR2(&P_RULE_NAME_LENGTH),
  DISPLAY_ID VARCHAR2(&P_DISPLAY_ID_LENGTH),
  DESCRIPTION VARCHAR2(&P_DESCRIPTION_LENGTH),
  RULE_TYPE VARCHAR2(&P_RULE_TYPE_LENGTH),
  RULE_OBJECT VARCHAR2(&P_LARGE_VARCHAR_LENGTH),
  TEST VARCHAR2(&P_LARGE_VARCHAR_LENGTH),
  PRIORITY NUMBER,
  IMPACT_OF_PROBLEM VARCHAR2(&P_SHORT_DESCRIPTION_LENGTH),
  RECOMMENDATION VARCHAR2(&P_SHORT_DESCRIPTION_LENGTH),
  COLUMN_LIST ECM_RULE_COLUMN_LIST,
  PARAM_LIST ECM_RULE_PARAM_LIST,
  MEMBER PROCEDURE EVALUATE( p_evalTime DATE, 
                             p_rt_params ECM_RULE_PARAM_LIST, 
                             p_targetClause VARCHAR2,
                             p_targetBindParams VARCHAR2_TABLE ),                            
  NOT INSTANTIABLE MEMBER 
         PROCEDURE GET_VIOLATION_GUID( p_targetGuid RAW,
                                       p_violationGuid OUT RAW,
                                       p_newViolation OUT BOOLEAN ),
  NOT INSTANTIABLE MEMBER 
         PROCEDURE HANDLE_VIOLATION( p_evalTime DATE,
                                     p_targetGuid RAW,
                                     p_violationGuid RAW,
                                     p_newViolation BOOLEAN,
                                     p_priority NUMBER,
                                     p_values ECM_RULE_VIOLATION_VALUE_LIST ),
  MEMBER PROCEDURE GET_ROWS_KEY_STRING( p_values ECM_RULE_VIOLATION_VALUE_LIST,
                                        p_key OUT VARCHAR2,
                                        p_allKeyColumns OUT BOOLEAN )
) NOT INSTANTIABLE NOT FINAL;
/

rem           ECM_POLICY_RULE
rem  PURPOSE
rem    This object represents an ECM Rule object for ECM policies.  It includes
rem    a policy id and rule_id members identifying the ids used in the 
rem    repository for this rule.  See MGMT_POLICY_RULE, et. al. for more detail.
rem    This method implements
rem    1.  The GET_VIOLATION_GUID method which returns a unique id for
rem        the violation.
rem    2.  The HANDLE_VIOLATION method such as to write the 
rem    resulting violation rows to the repository MGMT_RULE_VIOLATIONS table.
CREATE OR REPLACE TYPE ECM_POLICY_RULE UNDER ECM_RULE
(
  RULE_ID RAW(16),
  POLICY_ID RAW(16),
  OVERRIDING MEMBER PROCEDURE GET_VIOLATION_GUID( p_targetGuid RAW,
                                                  p_violationGuid OUT RAW,
                                                  p_newViolation OUT BOOLEAN ),
  OVERRIDING MEMBER PROCEDURE HANDLE_VIOLATION( p_evalTime DATE,
                                                p_targetGuid RAW,
                                                p_violationGuid RAW,
                                                p_newViolation BOOLEAN,
                                                p_priority NUMBER,
                                                p_values ECM_RULE_VIOLATION_VALUE_LIST )   
);
/

--tbd:Remove the V2 policy types and policy type bodies.


