Rem drv: <migrate type="data_upgrade" version="10.2.0.1" />
Rem
Rem $Header: rep_metric_data_upgrade.sql 27-sep-2005.16:18:27 gan Exp $
Rem
Rem rep_metric_data_upgrade.sql
Rem
Rem Copyright (c) 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      rep_metric_data_upgrade.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    gan         09/27/05 - call ini 
Rem    gan         09/27/05 - call ini 
Rem    gan         08/26/05 - gan_bug-4518533
Rem    gan         08/18/05 - Created
Rem

BEGIN
  -- update rs_metric
  UPDATE mgmt_metric_dependency d 
     SET rs_metric = 1 
   WHERE EXISTS 
         (SELECT 1 
            FROM mgmt_metrics m 
           WHERE m.metric_guid = d.metric_guid 
             AND m.metric_name = mgmt_global.G_AVAIL_METRIC_NAME 
             AND m.metric_column = mgmt_global.G_AVAIL_METRIC_COLUMN); 
  COMMIT; 

  -- update eval_func
  UPDATE mgmt_metric_dependency d
     SET eval_func =
        (SELECT distinct source
           FROM mgmt_metrics m,
                mgmt_targets t
          WHERE m.metric_guid = d.metric_guid
            AND t.target_guid = d.target_guid
            AND t.type_meta_ver = m.type_meta_ver
            AND (m.category_prop_1 = t.category_prop_1
                OR m.category_prop_1 = ' ')
           AND (m.category_prop_2 = t.category_prop_2
                OR m.category_prop_2 = ' ')
           AND (m.category_prop_3 = t.category_prop_3
                OR m.category_prop_3 = ' ')
           AND (m.category_prop_4 = t.category_prop_4 OR
                m.category_prop_4 = ' ')
           AND (m.category_prop_5 = t.category_prop_5 OR
                 m.category_prop_5 = ' '))
  WHERE eval_func IS NULL;

  COMMIT; 

  -- update repo_metric_only
  UPDATE mgmt_metric_dependency d
     SET repo_metric_only = 1
   WHERE rs_metric =1 
     AND NOT EXISTS (
                      SELECT 1
                      FROM mgmt_metrics m, mgmt_targets t
                      WHERE t.target_guid =  d.target_guid
                        AND m.target_type = t.target_type
                        AND m.type_meta_ver = t.type_meta_ver
                        AND (m.category_prop_1 = t.category_prop_1 
                             OR m.category_prop_1 = ' ')
                        AND (m.category_prop_2 = t.category_prop_2 
                             OR m.category_prop_2 = ' ')
                        AND (m.category_prop_3 = t.category_prop_3
                             OR m.category_prop_3 = ' ')
                        AND (m.category_prop_4 = t.category_prop_4 
                             OR m.category_prop_4 = ' ')
                        AND (m.category_prop_5 = t.category_prop_5
                             OR m.category_prop_5 = ' ')
                        AND m.is_repository  <> 1
                        AND ROWNUM = 1
                     );
  COMMIT;

  -- update opt_code
  UPDATE mgmt_metric_dependency d
     SET opt_code = DECODE(UPPER(eval_func),
                           UPPER(mgmt_severity_helper.G_OR_AVAIL_EVAL_PROC_NAME),
                           mgmt_global.G_REPO_SEV_OPT_OR,
                           UPPER(mgmt_severity_helper.G_AND_AVAIL_EVAL_PROC_NAME),
                           mgmt_global.G_REPO_SEV_OPT_AND,
                           mgmt_global.G_REPO_SEV_OPT_NONE)
   WHERE rs_metric = 1;

  UPDATE mgmt_metric_dependency_def d
     SET opt_code = (SELECT DECODE(UPPER(m.source),
                            UPPER(mgmt_severity_helper.G_OR_AVAIL_EVAL_PROC_NAME),
                            mgmt_global.G_REPO_SEV_OPT_OR,
                            UPPER(mgmt_severity_helper.G_AND_AVAIL_EVAL_PROC_NAME),
                            mgmt_global.G_REPO_SEV_OPT_AND,
                            mgmt_global.G_REPO_SEV_OPT_NONE)
                       FROM mgmt_metrics m
                      WHERE m.target_type = d.target_type
                        AND m.type_meta_ver = d.type_meta_ver
                        AND m.metric_guid = d.metric_guid
                        AND m.source IS NOT NULL
                        AND ROWNUM = 1);
  commit;
END;
/
show errors;

@@&&EM_SQL_ROOT/core/v102020/rep_metric/rep_metric_init.sql
