Rem drv: <migrate type="pre_data_upgrade" version="10.2.0.1" pos="-"/>
Rem
Rem $Header: sdk_post_creation.sql 06-oct-2005.05:41:04 prayarot Exp $
Rem
Rem sdk_post_creation.sql
Rem
Rem Copyright (c) 2002, 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      sdk_post_creation.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    chyu        12/12/05 - created for upgrade the dif of the 10.1.0.4
Rem                           to 10.2.0.1 aggregate.
Rem



-- Register "built-in" commands
BEGIN
    mgmt_jobs.register_command('remoteOp',
                         'oracle.sysman.emdrep.jobs.commands.RemoteOp');

    mgmt_jobs.register_command('execAndSuspend',
                         'oracle.sysman.emdrep.jobs.commands.ExecAndSuspend');

    mgmt_jobs.register_command('getFile',
                         'oracle.sysman.emdrep.jobs.commands.GetFile',
                         MGMT_JOBS.LONG_RUNNING_COMMAND);

    mgmt_jobs.register_command('putFile',
                         'oracle.sysman.emdrep.jobs.commands.PutFile',
                         MGMT_JOBS.LONG_RUNNING_COMMAND);

    mgmt_jobs.register_command('putFileSWLib',
                         'oracle.sysman.emdrep.jobs.commands.PutFileSWLib',
                         MGMT_JOBS.LONG_RUNNING_COMMAND);

    mgmt_jobs.register_command('fileTransfer',
                         'oracle.sysman.emdrep.jobs.commands.FileTransfer');

    mgmt_jobs.register_command('email',
                         'oracle.sysman.emdrep.jobs.commands.Email',
                         MGMT_JOBS.LONG_RUNNING_COMMAND);

    mgmt_jobs.register_command('repSQL',
                         'oracle.sysman.emdrep.jobs.commands.RepSQL',
                         MGMT_JOBS.LONG_RUNNING_COMMAND);

    mgmt_jobs.register_command('addTarget',
                         'oracle.sysman.emdrep.jobs.commands.AddTarget');

    mgmt_jobs.register_command('reloadTargetProperties',
              'oracle.sysman.emdrep.jobs.commands.ReloadTargetProperties');

    mgmt_jobs.register_command('deleteTarget',
                         'oracle.sysman.emdrep.jobs.commands.DeleteTarget');

  mgmt_jobs.register_command('deleteAgentTarget',
                         'oracle.sysman.emdrep.jobs.commands.DeleteAgentTarget');


    mgmt_jobs.register_command('pingCfmEMDDown',
                         'oracle.sysman.emdrep.ping.PingFailureCfm');

    mgmt_jobs.register_command('patchNotifyCommand',
                         'oracle.sysman.eml.ecm.executor.PatchNotifyExecutor',
                         MGMT_JOBS.LONG_RUNNING_COMMAND);

    mgmt_jobs.register_command('snapshotCollectionCommand',
                         'oracle.sysman.eml.ecm.track.SnapshotCollectionCommand',
                         MGMT_JOBS.LONG_RUNNING_COMMAND);

    mgmt_jobs.register_command('cachePatchFile',
                         'oracle.sysman.emdrep.jobs.commands.CachePatchFile',
                         MGMT_JOBS.LONG_RUNNING_COMMAND);
    mgmt_jobs.register_command('updateARUTables',
                         'oracle.sysman.emdrep.jobs.commands.UpdateARUTables',
                         MGMT_JOBS.LONG_RUNNING_COMMAND);
    mgmt_jobs.register_command('setMasterAgent',
                         'oracle.sysman.emdrep.jobs.commands.SetMasterAgent');
    mgmt_jobs.register_command('setStandbyAgent',
                         'oracle.sysman.emdrep.jobs.commands.SetStandbyAgent');
    mgmt_jobs.register_command('updatePackagesInfo',
                         'oracle.sysman.emdrep.jobs.commands.UpdatePackagesInfo',
                         MGMT_JOBS.LONG_RUNNING_COMMAND);
    mgmt_jobs.register_command('collectComplianceInfo',
                         'oracle.sysman.emdrep.jobs.commands.CollectComplianceInfo',
                         MGMT_JOBS.LONG_RUNNING_COMMAND);

    -- For debugging/examples only
    mgmt_jobs.register_command('echoParams',
                         'oracle.sysman.emdrep.jobs.commands.examples.EchoParams');
    mgmt_jobs.register_command('vectorTargets',
                         'oracle.sysman.emdrep.jobs.commands.examples.VectorTargets');
    mgmt_jobs.register_command('vectorProperties',
                         'oracle.sysman.emdrep.jobs.commands.examples.VectorProperties',
                         MGMT_JOBS.LONG_RUNNING_COMMAND);

    -- Internal commands
    mgmt_jobs.register_command('pingEMD',
                         'oracle.sysman.emdrep.jobs.commands.examples.PingEMD',
                         MGMT_JOBS.LONG_RUNNING_COMMAND);

    mgmt_jobs.register_command('startBlackout',
                         'oracle.sysman.emdrep.jobs.commands.StartBlackout',
                         MGMT_JOBS.LONG_RUNNING_COMMAND);
    
     mgmt_jobs.register_command('stopBlackout',
                         'oracle.sysman.emdrep.jobs.commands.StopBlackout',
                         MGMT_JOBS.LONG_RUNNING_COMMAND);

    mgmt_jobs.register_command('discardState',
                         'oracle.sysman.emdrep.jobs.commands.DiscardState',
                         MGMT_JOBS.LONG_RUNNING_COMMAND);

    mgmt_jobs.register_command('propagateTargetData',
                         'oracle.sysman.emdrep.jobs.commands.PropagateTargetData',
                         MGMT_JOBS.LONG_RUNNING_COMMAND);

    mgmt_jobs.register_command('UpdateBeaconCollections',
                         'oracle.sysman.emdrep.jobs.commands.UpdateBeaconCollections',
                         MGMT_JOBS.LONG_RUNNING_COMMAND);

    mgmt_jobs.register_command('RemoveBeaconCollections',
                         'oracle.sysman.emdrep.jobs.commands.RemoveBeaconCollections',
                         MGMT_JOBS.LONG_RUNNING_COMMAND);

    mgmt_jobs.register_command('RemoveAgentTargetInstance',
                         'oracle.sysman.emdrep.jobs.commands.DeleteAgentTargetInstance',
                         MGMT_JOBS.LONG_RUNNING_COMMAND);

    mgmt_jobs.register_command('AddSimpleTargetInstance',
                         'oracle.sysman.emdrep.jobs.commands.AddSimpleTarget',
                         MGMT_JOBS.LONG_RUNNING_COMMAND);

    mgmt_jobs.register_command('UpgradeWebappTargetData',
                         'oracle.sysman.emdrep.jobs.commands.UpgradeWebappTargetData',
                         MGMT_JOBS.LONG_RUNNING_COMMAND);


		
    -- all provision commands starts
    mgmt_jobs.register_command('UpdateProvisioningStatusCommand',
                         'oracle.sysman.emgc.provision.jobs.commands.UpdateProvisioningStatusCommand');

    mgmt_jobs.register_command('InsertBinaryDataCommand',
                         'oracle.sysman.emgc.provision.jobs.commands.InsertBinaryDataCommand');

    mgmt_jobs.register_command('InstallCommand',
                         'oracle.sysman.emgc.provision.jobs.commands.InstallCommand');

    mgmt_jobs.register_command('UpdateInstallProgressCommand',
                         'oracle.sysman.emgc.provision.jobs.commands.UpdateInstallProgressCommand');

    mgmt_jobs.register_command('ReportErrorCommand',
                         'oracle.sysman.emgc.provision.jobs.commands.ReportErrorCommand');

    mgmt_jobs.register_command('PutBinaryCommand',
                         'oracle.sysman.emgc.provision.jobs.commands.PutBinaryCommand');

    mgmt_jobs.register_command('getFileSWLib',
                         'oracle.sysman.emgc.provision.jobs.commands.GetFileSWLib',
                         MGMT_JOBS.LONG_RUNNING_COMMAND);
    mgmt_jobs.register_command('DiagnosticsCommand',
                         'oracle.sysman.emgc.provision.jobs.commands.DiagnosticsCommand');

    mgmt_jobs.register_command('CheckDiagnosticCommand',
                         'oracle.sysman.emgc.provision.jobs.commands.CheckDiagnosticCommand');

     mgmt_jobs.register_command('StageCommand',
                         'oracle.sysman.emgc.provision.jobs.commands.StageCommand');

     mgmt_jobs.register_command('StageImageCommand',
                         'oracle.sysman.emgc.provision.jobs.commands.StageImageCommand');

     mgmt_jobs.register_command('StagingExecutor',
                         'oracle.sysman.emgc.provision.jobs.commands.StagingExecutor');

     mgmt_jobs.register_command('ResetInitialCommand',
                         'oracle.sysman.emgc.provision.jobs.commands.ResetInitialCommand');

     mgmt_jobs.register_command('StageComponentCommand',
                         'oracle.sysman.emgc.provision.jobs.commands.StageComponentCommand');

     mgmt_jobs.register_command('StageComponentLinkCommand',
                         'oracle.sysman.emgc.provision.jobs.commands.StageComponentLinkCommand');

     mgmt_jobs.register_command('UpdateStageProgressCommand',
                         'oracle.sysman.emgc.provision.jobs.commands.UpdateStageProgressCommand');
     
     mgmt_jobs.register_command('StageResetJobCommand',
                         'oracle.sysman.emgc.provision.jobs.commands.StageResetJobCommand');

     mgmt_jobs.register_command('CheckSuiteCommand',
                         'oracle.sysman.emgc.provision.jobs.commands.CheckSuiteCommand');

     mgmt_jobs.register_command('SuiteProvisionCommand',
                         'oracle.sysman.emgc.provision.jobs.commands.SuiteProvisionCommand');

     mgmt_jobs.register_command('CopyProvosionProperties',
                         'oracle.sysman.emgc.provision.jobs.commands.CopyProvosionProperties');

     mgmt_jobs.register_command('CredentialVerifierCommand',
                         'oracle.sysman.emgc.provision.jobs.commands.CredentialVerifierCommand');

     mgmt_jobs.register_command('CreateRPMNamesFileCommand',
                        'oracle.sysman.emgc.provision.jobs.commands.CreateRPMNamesFileCommand');

     mgmt_jobs.register_command('GetRPMDirCommand',
                        'oracle.sysman.emgc.provision.jobs.commands.GetRPMDirCommand');

     mgmt_jobs.register_command('GetRPMListCommand',
                        'oracle.sysman.emgc.provision.jobs.commands.GetRPMListCommand', MGMT_JOBS.LONG_RUNNING_COMMAND);

     mgmt_jobs.register_command('AddBinaryToComponentCommand',
                        'oracle.sysman.emgc.provision.jobs.commands.AddBinaryToComponentCommand', MGMT_JOBS.LONG_RUNNING_COMMAND);

     mgmt_jobs.register_command('GetFolderPathCommand',
                        'oracle.sysman.emgc.provision.jobs.commands.GetFolderPathCommand', MGMT_JOBS.LONG_RUNNING_COMMAND);

     mgmt_jobs.register_command('ExecuteDirectiveCommand',
                         'oracle.sysman.emgc.provision.jobs.commands.ExecuteDirectiveCommand', MGMT_JOBS.LONG_RUNNING_COMMAND);

     mgmt_jobs.register_command('GetDefaultRPMListCommand', 'oracle.sysman.emgc.provision.jobs.commands.GetDefaultRPMListCommand');

     mgmt_jobs.register_command('CreateDefaultComponentsCommand', 'oracle.sysman.emgc.provision.jobs.commands.CreateDefaultComponentsCommand');

     mgmt_jobs.register_command('AddComponentsToImageCommand', 'oracle.sysman.emgc.provision.jobs.commands.AddComponentsToImageCommand');

     mgmt_jobs.register_command('GetDefaultDirectivesLocCommand', 'oracle.sysman.emgc.provision.jobs.commands.GetDefaultDirectivesLocCommand');

    mgmt_jobs.register_command('StageNetworkCompCommand',
                         'oracle.sysman.emgc.provision.jobs.commands.StageNetworkCompCommand');

     mgmt_jobs.register_command('CheckClusterCommand',
                         'oracle.sysman.emgc.provision.jobs.commands.CheckClusterCommand');

     mgmt_jobs.register_command('ClusterProvisionCommand',
                         'oracle.sysman.emgc.provision.jobs.commands.ClusterProvisionCommand');

     mgmt_jobs.register_command('ClusterDirectivesCommand',
                         'oracle.sysman.emgc.provision.jobs.commands.ClusterDirectivesCommand');

     mgmt_jobs.register_command('PostAddRemoveNodeCommand',
                         'oracle.sysman.emgc.provision.jobs.commands.PostAddRemoveNodeCommand');

     mgmt_jobs.register_command('PostInstallCommand',
                         'oracle.sysman.emgc.provision.jobs.commands.PostInstallCommand');

     mgmt_jobs.register_command('PostStageCommand',
                         'oracle.sysman.emgc.provision.jobs.commands.PostStageCommand');


     mgmt_jobs.register_command('StageOMSInfoCommand',
                         'oracle.sysman.emgc.provision.jobs.commands.StageOMSInfoCommand');

     mgmt_jobs.register_command('CheckRunCloneCommand',
                         'oracle.sysman.emgc.provision.jobs.commands.CheckRunCloneCommand');
     mgmt_jobs.register_command('CheckCloneCommand',
                         'oracle.sysman.emgc.provision.jobs.commands.CheckCloneCommand');
     mgmt_jobs.register_command('CloneJobArgsCommand',
                         'oracle.sysman.emgc.provision.jobs.commands.CloneJobArgsCommand');

     mgmt_jobs.register_command('CloneDoneCheckCommand',
                         'oracle.sysman.emgc.provision.jobs.commands.CloneDoneCheckCommand');

     mgmt_jobs.register_command('CreateCloneUsersCommand',
                         'oracle.sysman.emgc.provision.jobs.commands.CreateCloneUsersCommand');
     
     mgmt_jobs.register_command('CleanUpStageCommand',
                         'oracle.sysman.emgc.provision.jobs.commands.CleanUpStageCommand');
    -- all provision commands ends
     mgmt_jobs.register_command('StrayHomeCollectionCommand',
                         'oracle.sysman.emdrep.jobs.commands.StrayHomeCollectionCommand');

END;
/
COMMIT;


-- Create PULBIC role
BEGIN
  IF mgmt_user.has_role('SYSMAN','PUBLIC',0) = MGMT_USER.USER_HAS_ROLE
  THEN RETURN;
  ELSE
    mgmt_user.create_role('PUBLIC','');
  END IF;
END;
/
COMMIT;


BEGIN
DECLARE 
l_host_type_cols MGMT_CRED_TYPE_COL_ARRAY := MGMT_CRED_TYPE_COL_ARRAY();
l_db_type_cols MGMT_CRED_TYPE_COL_ARRAY := MGMT_CRED_TYPE_COL_ARRAY();
l_db_host_type_cols MGMT_CRED_TYPE_COL_ARRAY := MGMT_CRED_TYPE_COL_ARRAY();
l_lsnr_type_cols MGMT_CRED_TYPE_COL_ARRAY := MGMT_CRED_TYPE_COL_ARRAY();
l_role_col_vals MGMT_CRED_TYPE_COL_VAL_ARRAY := MGMT_CRED_TYPE_COL_VAL_ARRAY();
l_prov_type_cols MGMT_CRED_TYPE_COL_ARRAY := MGMT_CRED_TYPE_COL_ARRAY();

l_host_set_cols MGMT_CRED_SET_COL_ARRAY := MGMT_CRED_SET_COL_ARRAY();
l_db_set_cols MGMT_CRED_SET_COL_ARRAY := MGMT_CRED_SET_COL_ARRAY();
l_oh_set_cols MGMT_CRED_SET_COL_ARRAY := MGMT_CRED_SET_COL_ARRAY();
l_provision_set_cols MGMT_CRED_SET_COL_ARRAY := MGMT_CRED_SET_COL_ARRAY();
l_db_host_set_cols MGMT_CRED_SET_COL_ARRAY := MGMT_CRED_SET_COL_ARRAY();
l_lsnr_set_cols MGMT_CRED_SET_COL_ARRAY := MGMT_CRED_SET_COL_ARRAY();

l_host_ref MGMT_CRED_TYPE_REF;
l_refs MGMT_CRED_TYPE_REF_ARRAY := MGMT_CRED_TYPE_REF_ARRAY();
BEGIN
    BEGIN
    -- Create the host type HostCreds
    l_host_type_cols.extend(2);
    l_host_type_cols(1) := MGMT_CRED_TYPE_COL_RECORD('HostUserName', 1,
                                                     null, null,
                                                     'UserName', 
                                                     'CREDS_HOST_USERNAME',
                                                     null);
    l_host_type_cols(2) := MGMT_CRED_TYPE_COL_RECORD('HostPassword', 0,
                                                     null, null,
                                                     'Password',
                                                     'CREDS_HOST_PASSWORD',
                                                     null);

    MGMT_CREDENTIAL.create_credential_type('host', 'HostCreds', '2.0',
                                           'Host Credentials',
                                           'CREDS_HOST_HOSTCREDS',
                                           'Base type for host credentials', 
                                           null, l_host_type_cols);
    EXCEPTION
    WHEN DUP_VAL_ON_INDEX THEN
        NULL;
    END;

    BEGIN    
    -- Create the database type DBCreds
    -- Values for the DBRole type column
    l_role_col_vals.extend(2);
    l_role_col_vals(1) := MGMT_CRED_TYPE_COL_VAL('normal', 1);
    l_role_col_vals(2) := MGMT_CRED_TYPE_COL_VAL('sysdba', 0);

    -- First, create the type DBCreds
    l_db_type_cols.extend(3);
    l_db_type_cols(1) := MGMT_CRED_TYPE_COL_RECORD('DBUserName', 1,
                                                   null, null,
                                                   'UserName', 
                                                   'CREDS_DATABASE_USERNAME',
                                                   null);
    l_db_type_cols(2) := MGMT_CRED_TYPE_COL_RECORD('DBPassword', 0,
                                                   null, null,
                                                   'Password',
                                                   'CREDS_DATABASE_PASSWORD',
                                                   null);
    l_db_type_cols(3) := MGMT_CRED_TYPE_COL_RECORD('DBRole', 0,
                                                   null, null,
                                                   'Role',
                                                   'CREDS_DATABASE_ROLE',
                                                   l_role_col_vals);

    MGMT_CREDENTIAL.create_credential_type('oracle_database', 
                                           'DBCreds', '3.0',
                                           'Database credentials', 
                                           'CREDS_DATABASE_DBCREDS',
                                           'database credentials', null, 
                                           l_db_type_cols);
    EXCEPTION
    WHEN DUP_VAL_ON_INDEX THEN
        NULL;
    END;

    BEGIN
    -- Create the type DBHostCreds
    l_host_ref := MGMT_CRED_TYPE_REF('HostRef', 'HostCreds', 'host', '2.0', 'host');
    l_refs.extend(1);
    l_refs(1) := l_host_ref;

    l_db_host_type_cols.extend(2);
    l_db_host_type_cols(1) := MGMT_CRED_TYPE_COL_RECORD('HostUserName', 1,
                                                   'HostRef', 'HostUserName',
                                                   'Host UserName', 
                                                   'CREDS_DATABASE_HOSTTYPE_USERNAME',
                                                   null);
    l_db_host_type_cols(2) := MGMT_CRED_TYPE_COL_RECORD('HostPassword', 0,
                                                   'HostRef', 'HostPassword',
                                                   'Host Password',
                                                   'CREDS_DATABASE_HOSTTYPE_PASSWORD',
                                                   null);


    MGMT_CREDENTIAL.create_credential_type('oracle_database', 
                                           'DBHostCreds', '3.0',
                                           'Database host credentials', 
                                           'CREDS_DATABASE_DBHOSTCREDS',
                                           'database host credentials', 
                                           l_refs,
                                           l_db_host_type_cols);
    EXCEPTION
    WHEN DUP_VAL_ON_INDEX THEN
        NULL;
    END;

    BEGIN
    -- Create the type LsnrCreds
    l_lsnr_type_cols.extend(1);
    l_lsnr_type_cols(1) := MGMT_CRED_TYPE_COL_RECORD('Password', 1,
                                                   null, null,
                                                   'Password', 
                                                   'CREDS_LISTENER_PASSWORD',
                                                   null);



    MGMT_CREDENTIAL.create_credential_type('oracle_listener', 
                                           'LsnrCreds', '1.0',
                                           'Listener credentials', 
                                           'CREDS_LISTENER_CREDS',
                                           'listener credentials', null, 
                                           l_lsnr_type_cols);
    EXCEPTION
    WHEN DUP_VAL_ON_INDEX THEN
        NULL;
    END;


    BEGIN
    -- Create the type Provcreds
    l_prov_type_cols.extend(4);
    l_prov_type_cols(1) := MGMT_CRED_TYPE_COL_RECORD('OMSRegistrationPassword', 1, 
						      null, null, 
						      'RegPassword', 
						      'CREDS_OMS_REGISTRATION_PASSWORD',  null);

    l_prov_type_cols(2) := MGMT_CRED_TYPE_COL_RECORD('InstallUserName', 1, 
							null, null, 
							'InstallUserName',
						  	'CREDS_INSTALL_USER',  null);

    l_prov_type_cols(3) := MGMT_CRED_TYPE_COL_RECORD('InstallPassword', 1, 
							 null, null,  
							'InstallPassword',  
							'CREDS_INSTALL_PASSWORD',  null);

    l_prov_type_cols(4) := MGMT_CRED_TYPE_COL_RECORD('ProvCompPasswd', 1, 
					 	     null, null, 
						     'CompSecretProperty',
						     'CREDS_COMP_SECRET_PASSWORD',  null);	                                                   

    MGMT_CREDENTIAL.create_credential_type('host',  
					   'ProvisionCreds', '2.0',
                                           'provision credentials', 
                          		   'CREDS_PROVISION',  
 					   'provision credentials', null,
					   l_prov_type_cols);
EXCEPTION
WHEN DUP_VAL_ON_INDEX THEN
	NULL;
END;


    BEGIN
    -- Create the credential set HostCredsNormal
    l_host_set_cols.extend(2);
    l_host_set_cols(1) := MGMT_CRED_SET_COL_RECORD('HostUserName', 
                                                   'username',     
                                                   'UserName',
                                                   'CREDS_NORMAL_USER',
                                                   null);
                                                   
    l_host_set_cols(2) := MGMT_CRED_SET_COL_RECORD('HostPassword', 
                                                   'password',
                                                   'Password',
                                                   'CREDS_NORMAL_PASSWORD',
                                                   null);

    MGMT_CREDENTIAL.create_credential_set('host', '2.0',
                                          'HostCredsNormal',
                                          MGMT_CREDENTIAL.PREFCRED_SET_USAGE,
                                          MGMT_CREDENTIAL.TARGET_SET_CONTEXT_TYPE,
                                          null,
                                          'Normal Host Credentials',
                                          'CREDS_HOST_NORMAL',
                                          'HostCreds', l_host_set_cols);
    EXCEPTION
    WHEN DUP_VAL_ON_INDEX THEN
        NULL;
    END;

    BEGIN
    -- Insert the credential set HostCredsPriv
    l_host_set_cols(1) := MGMT_CRED_SET_COL_RECORD('HostUserName', 
                                                   'username',     
                                                   'Privileged UserName',
                                                   'CREDS_PRIV_USER',
                                                   null);
                                                   
    l_host_set_cols(2) := MGMT_CRED_SET_COL_RECORD('HostPassword', 
                                                   'password',
                                                   'Privileged Password',
                                                   'CREDS_PRIV_PASSWORD',
                                                   null);

    MGMT_CREDENTIAL.create_credential_set('host', '2.0',
                                          'HostCredsPriv',
                                          MGMT_CREDENTIAL.PREFCRED_SET_USAGE,
                                          MGMT_CREDENTIAL.TARGET_SET_CONTEXT_TYPE,
                                          null,
                                          'Privileged Host Credentials',
                                          'CREDS_HOST_PRIV',
                                          'HostCreds', l_host_set_cols);
    EXCEPTION
    WHEN DUP_VAL_ON_INDEX THEN
        NULL;
    END;

    BEGIN
    -- Create the credential set DBCredsNormal
    l_db_set_cols.extend(3);
    l_db_set_cols(1) := MGMT_CRED_SET_COL_RECORD('DBUserName', 
                                                 'username',   
                                                 'UserName',
                                                 'CREDS_NORMAL_USER',
                                                 null);
                                                 
    l_db_set_cols(2) := MGMT_CRED_SET_COL_RECORD('DBPassword', 
                                                 'password',
                                                 'Password',
                                                 'CREDS_NORMAL_PASSWORD',
                                                  null);

    l_db_set_cols(3) := MGMT_CRED_SET_COL_RECORD('DBRole', 
                                                 'role',
                                                 'Role',
                                                 'CREDS_NORMAL_ROLE',
                                                 null);

    MGMT_CREDENTIAL.create_credential_set('oracle_database', '3.0',
                                          'DBCredsNormal', 
                                          MGMT_CREDENTIAL.PREFCRED_SET_USAGE,
                                          MGMT_CREDENTIAL.TARGET_SET_CONTEXT_TYPE,
                                          null,
                                          'Normal Database Credentials',
                                          'CREDS_DATABASE_NORMAL',
                                          'DBCreds', l_db_set_cols);
    EXCEPTION
    WHEN DUP_VAL_ON_INDEX THEN
        NULL;
    END;

    BEGIN
    -- Create the credential set DBCredsSYSDBA
    l_db_set_cols(1) := MGMT_CRED_SET_COL_RECORD('DBUserName', 
                                                 'sysDBAUserName',   
                                                 'SYSDBA UserName',
                                                 'CREDS_SYSDBA_USER',
                                                 null);
                                                 
    l_db_set_cols(2) := MGMT_CRED_SET_COL_RECORD('DBPassword', 
                                                 'sysDBAPassword',
                                                 'SYSDBA Password',
                                                 'CREDS_SYSDBA_PASSWORD',
                                                 null);

    l_db_set_cols(3) := MGMT_CRED_SET_COL_RECORD('DBRole', 
                                                 'sysDBARole',
                                                 'SYSDBA Role',
                                                 'CREDS_SYSDBA_ROLE',
                                                 null);

    MGMT_CREDENTIAL.create_credential_set('oracle_database', '3.0',
                                          'DBCredsSYSDBA', 
                                          MGMT_CREDENTIAL.PREFCRED_SET_USAGE,
                                          MGMT_CREDENTIAL.TARGET_SET_CONTEXT_TYPE,
                                          null,
                                          'SYSDBA Database Credentials',
                                          'CREDS_DATABASE_SYSDBA',
                                          'DBCreds', l_db_set_cols);
    EXCEPTION
    WHEN DUP_VAL_ON_INDEX THEN
        NULL;
    END;

    BEGIN
    -- Create the credential set DBHostCreds
    l_db_host_set_cols.extend(2);
    l_db_host_set_cols(1) := MGMT_CRED_SET_COL_RECORD('HostUserName', 
                                                 'HostUsername',   
                                                 'Host UserName',
                                                 'CREDS_HOST_USER',
                                                 null);
                                                 
    l_db_host_set_cols(2) := MGMT_CRED_SET_COL_RECORD('HostPassword', 
                                                 'HostPassword',
                                                 'Host Password',
                                                 'CREDS_HOST_PASSWORD',
                                                  null);


    MGMT_CREDENTIAL.create_credential_set('oracle_database', '3.0',
                                          'DBHostCreds', 
                                          MGMT_CREDENTIAL.PREFCRED_SET_USAGE,
                                          MGMT_CREDENTIAL.TARGET_SET_CONTEXT_TYPE,
                                          null,
                                          'Database Host Credentials',
                                          'CREDS_HOST',
                                          'DBHostCreds', l_db_host_set_cols);
    EXCEPTION
    WHEN DUP_VAL_ON_INDEX THEN
        NULL;
    END;

    BEGIN
    -- Create the credential set OHCreds
    l_oh_set_cols.extend(2);
    l_oh_set_cols(1) := MGMT_CRED_SET_COL_RECORD('HostUserName', 
                                                 'OHUsername',   
                                                 'Oracle Home User',
                                                 'CREDS_OH_USER',
                                                 null);
                                                 
    l_oh_set_cols(2) := MGMT_CRED_SET_COL_RECORD('HostPassword', 
                                                 'OHPassword',
                                                 'Oracle Home Password',
                                                 'CREDS_OH_PASSWORD',
                                                 null);


    MGMT_CREDENTIAL.create_credential_set('host', '2.0',
                                          'OHCreds', 
                                          MGMT_CREDENTIAL.PREFCRED_SET_USAGE,
                                          MGMT_CREDENTIAL.CONTAINER_SET_CONTEXT_TYPE,
                                          MGMT_CREDENTIAL.CONTAINER_TYPE_ORACLEHOME,
                                          'Oracle Home Credentials',
                                          'CREDS_OH',
                                          'HostCreds', l_oh_set_cols);
    EXCEPTION
    WHEN DUP_VAL_ON_INDEX THEN
        NULL;
    END;

    -- Create the credential set ProvisionCreds
   BEGIN
    l_provision_set_cols.extend(4);
    l_provision_set_cols(1) := MGMT_CRED_SET_COL_RECORD('OMSRegistrationPassword',
                                                 'OMS_REGISTRATION_PASSWORD',
                                                 'OMS Registration Password',
                                                 'CREDS_OMS_REGISTRATION_PASSWORD',
                                                 null);

    l_provision_set_cols(2) := MGMT_CRED_SET_COL_RECORD('InstallUserName', 
                                                 'INSTALLUSERNAME',
                                                 'Install User',
                                                 'CREDS_INSTALL_USER',
                                                 null);
                                                 
    l_provision_set_cols(3) := MGMT_CRED_SET_COL_RECORD('InstallPassword', 
                                                 'INSTALLPASSWORD',
                                                 'Install Password',
                                                 'CREDS_INSTALL_PASSWORD',
                                                 null);

    l_provision_set_cols(4) := MGMT_CRED_SET_COL_RECORD('ProvCompPasswd',
                                                 'COMP_SECRET_PROPERTY',
                                                 'Comp secret  Password',
                                                 'CREDS_COMP_SECRET_PASSWORD',
                                                 null);



    MGMT_CREDENTIAL.create_credential_set('host', '2.0',
                                          'ProvisionCredsPref', 
                                          MGMT_CREDENTIAL.PREFCRED_SET_USAGE,
                                          MGMT_CREDENTIAL.CONTAINER_SET_CONTEXT_TYPE,
                                          MGMT_CREDENTIAL.CONTAINER_TYPE_ORACLEHOME,
                                          'Provisioning Credentials',
                                          'CREDS_PROVISION',
                                          'ProvisionCreds', l_provision_set_cols);
    EXCEPTION
    WHEN DUP_VAL_ON_INDEX THEN
        NULL;
    END;

   BEGIN
   -- Create the credential set LsnrCreds
   l_lsnr_set_cols.extend(1);
   l_lsnr_set_cols(1) := MGMT_CRED_SET_COL_RECORD('Password', 
                                                 'password',   
                                                 'Listener password',
                                                 'CREDS_LISTENER_PASSWORD',
                                                 null);
   
    MGMT_CREDENTIAL.create_credential_set('oracle_listener', '1.0',
                                          'LsnrCreds', 
                                          MGMT_CREDENTIAL.PREFCRED_SET_USAGE,
                                          MGMT_CREDENTIAL.TARGET_SET_CONTEXT_TYPE,
                                          null,
                                          'Listener Credentials',
                                          'CREDS_OH',
                                          'LsnrCreds', l_lsnr_set_cols);
    EXCEPTION
    WHEN DUP_VAL_ON_INDEX THEN
        NULL;
    END;
END;

END;
/
COMMIT;

-- register user model callbacks
BEGIN
    -- for templates                        
    MGMT_USER.add_callback('MGMT_TEMPLATE.get_user_templates', MGMT_USER.GET_USER_OBJECTS_CALLBACK);
    MGMT_USER.add_callback('MGMT_TEMPLATE.drop_user_templates', MGMT_USER.USER_DROPPED_CALLBACK);
    MGMT_USER.add_callback('MGMT_TEMPLATE.reassign_user_templates', MGMT_USER.USER_REASSIGN_CALLBACK);
    
    -- for targets          
    MGMT_USER.add_callback('MGMT_TARGET.get_user_targets', MGMT_USER.GET_USER_OBJECTS_CALLBACK);
    MGMT_USER.add_callback('MGMT_TARGET.drop_user_targets', MGMT_USER.USER_DROPPED_CALLBACK);
    MGMT_USER.add_callback('MGMT_TARGET.reassign_user_targets', MGMT_USER.USER_REASSIGN_CALLBACK);
END;
/
COMMIT;

-- Add a target addition callback to introduce host credentials on
-- target addition
BEGIN
    EMD_LOADER.add_target_addition_callback('EM_CREDENTIAL.add_host_credential_info');
EXCEPTION
    WHEN DUP_VAL_ON_INDEX THEN NULL;
END;
/
COMMIT;

