Rem drv: <migrate type="schema_upgrade" version="10.2.0.1" pos="website/website_schema_upgrade.sql+"/>
Rem
Rem $Header: severity_schema_upgrade.sql 24-aug-2005.07:14:27 ramalhot Exp $
Rem
Rem severity_schema_upgrade.sql
Rem
Rem Copyright (c) 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      severity_schema_upgrade.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    ramalhot    08/24/05 - Moved mgmt_last_violation to v102020 
Rem    chyu        07/25/05 - modifying the upgrade header 
Rem    chyu        07/18/05 - adding the upgrade 
Rem                           header
Rem    jsadras     07/16/05 - jsadras_bug-4339821
Rem    jsadras     07/08/05 - Created
Rem

ALTER TABLE mgmt_current_violation
ADD
( cfg_coll_name         VARCHAR2(64)   DEFAULT NULL,
  cfg_key_value         VARCHAR2(256)  DEFAULT NULL,
  cfg_key_operator      NUMBER         DEFAULT NULL
) ;


-- Add the mgmt_last_violation table if it does not exist
DECLARE
  l_ignore VARCHAR2(64);
BEGIN

  BEGIN
    SELECT object_name INTO l_ignore
      FROM all_objects
     WHERE owner = UPPER('&&EM_REPOS_USER')
       AND object_type = 'TABLE'
       AND object_name = 'MGMT_LAST_VIOLATION';

  EXCEPTION
    WHEN NO_DATA_FOUND THEN
      EXECUTE IMMEDIATE
        'CREATE TABLE mgmt_last_violation
(
    target_guid           RAW(16)        NOT NULL,
    policy_guid           RAW(16)        NOT NULL,
    key_value             VARCHAR2(256)  DEFAULT '' '',
    collection_timestamp  DATE           DEFAULT SYSDATE,
    CONSTRAINT mgmt_last_violation_pk
       PRIMARY KEY (target_guid, policy_guid, key_value)
)
ORGANIZATION INDEX
COMPRESS 2 INITRANS 4
MONITORING';

  END;

END;
/

