Rem drv: <migrate type="data_upgrade" version="10.2.0.1"/>
Rem
Rem $Header: statbsln_data_upgrade.sql 30-aug-2005.11:30:44 jberesni Exp $
Rem
Rem statbsln_data_upgrade.sql
Rem
Rem Copyright (c) 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      statbsln_data_upgrade.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    jberesni    08/30/05 - register bsln jobs 
Rem    chyu        07/18/05 - adding the upgrade header 
Rem    scgrover    07/15/05 - scgrover_add_dbms_job_extended_sql_trace
Rem    scgrover    07/08/05 - Created
Rem

-----------------------------------
-- register the statbsln jobs 
-----------------------------------
begin
   mgmt_log.register_logging_module
      (v_job_name_in     => 'SET ADAPTIVE THRESHOLDS'
      ,v_display_name_in => 'Set Adaptive Metric Thresholds'
      ,v_dbms_jobname_in => mgmt_Bsln_internal.K_SET_THRESHOLDS_JOB
      );
   mgmt_log.register_logging_module
      (v_job_name_in     => 'COMPUTE METRIC BASELINE STATISTICS'
      ,v_display_name_in => 'Compute Metric Baseline Statistics'
      ,v_dbms_jobname_in => mgmt_bsln_internal.K_COMPUTE_STATS_JOB
      );
exception
   when others then RAISE;
end;
/
---------------------------------------------
BEGIN
  INSERT INTO MGMT_PARAMETERS
    (parameter_name, parameter_value, parameter_comment)
  VALUES
    ('EST_BSLN_STAT', 'OFF', 'Extended SQL trace for BEGIN MGMT_BSLN_INTERNAL.PURGE_EXTRACT_RAWDATA;MGMT_BSLN.COMPUTE_ALL_STATISTICS;' || 
                             ' /*GC*/END; dbms jobs. Use MGMT_BSLN_INTERNAL.DBMSJOB_EXTENDED_SQL_TRACE_ON(boolean, 1) to alter');

  COMMIT;
EXCEPTION
  WHEN OTHERS THEN
    UPDATE MGMT_PARAMETERS SET parameter_value = 'OFF' WHERE parameter_name = 'EST_BSLN_STAT';
    COMMIT;
END;
/

BEGIN
  INSERT INTO MGMT_PARAMETERS
    (parameter_name, parameter_value, parameter_comment)
  VALUES
    ('EST_BSLN_THRESHOLDS', 'OFF', 'Extended SQL trace for BEGIN MGMT_BSLN.SET_ALL_THRESHOLDS;/*GC*/END; dbms jobs. ' ||
                           'Use MGMT_BSLN_INTERNAL.DBMSJOB_EXTENDED_SQL_TRACE_ON(boolean, 2) to alter');

  COMMIT;
EXCEPTION
  WHEN OTHERS THEN
    UPDATE MGMT_PARAMETERS SET parameter_value = 'OFF' WHERE parameter_name = 'EST_BSLN_THRESHOLDS';
    COMMIT;
END;
/
