Rem
Rem $Header: storage_ui_post_creation.sql 26-jul-2005.18:13:06 ajdsouza Exp $
Rem
Rem storage_ui_post_creation.sql
Rem
Rem Copyright (c) 2004, 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      storage_ui_post_creation.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem     storage repository metrics where earlier registered to 4 platforms
Rem      This will update the storage rep metrics to be registered to 
Rem       all platforms
Rem
Rem    NOTES
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    ajdsouza    07/26/05 - ajdsouza_bug4409361_fix1
Rem    ajdsouza    07/21/05 - enable storage metrics to be registered to all
Rem                            platforms
Rem    ajdsouza    07/19/05 - Created
Rem

BEGIN

  BEGIN
    -- Delete the collection defined for the storage rep metric
    MGMT_COLLECTION.DELETE_DEFAULT_COLLECTION
    (
      p_target_type       => MGMT_GLOBAL.G_HOST_TARGET_TYPE,
      p_type_meta_ver     => '3.0',
      p_coll_name         => STORAGE_REP_METRICS_PKG.G_HOST_STORAGE_HIST_COLL,
      p_valid_if_list     => 
       MGMT_VALIDIF_ARRAY
       (
        MGMT_VALIDIF_OBJ.NEW
        (
          p_catprop_1_choices => MGMT_CATEGORY_PROP_ARRAY
          ( 
           'Linux', 
           'SunOS',
           'AIX', 
           'HP-UX'
          )
        )
       )
    );

   EXCEPTION
     -- This exception is thrown if 
     --  Collection Item to Deleted does not exist
     WHEN MGMT_GLOBAL.INVALID_PARAMS THEN
      RETURN;
   
   END;

  -- Modify the category prop for the storage rep metric
  --  by directly updating the mgmt_metrics table
  -- This is a workaround to modify a storage rep metric
  --  as there is no api implemented to do this as of now
  EXECUTE IMMEDIATE 'ALTER TABLE MGMT_METRICS DISABLE ALL TRIGGERS';

  -- delete metrics for all platforms except linux
  --  for storage rep metrics
  DELETE FROM MGMT_METRICS
  WHERE   target_type = 'host'
  AND     metric_name = 'host_storage_history'
  AND     category_prop_1 != 'Linux';

  -- update the category_prop1 for the storage rep metrics
  --  to space
  UPDATE  mgmt_metrics 
  SET     category_prop_1 = ' '
  WHERE   target_type = 'host'
  AND     metric_name = 'host_storage_history';

  EXECUTE IMMEDIATE 'ALTER TABLE MGMT_METRICS ENABLE ALL TRIGGERS';

  -- Add a new default collection for the updated storage rep 
  -- metrics
  -- the collection is for all platforms
  MGMT_COLLECTION.ADD_DEFAULT_COLLECTION
  (
    p_target_type       => MGMT_GLOBAL.G_HOST_TARGET_TYPE,
    p_type_meta_ver     => '3.0',
    p_metrics_list      => MGMT_SHORT_STRING_ARRAY
                           (
                             STORAGE_REP_METRICS_PKG.G_HOST_STORAGE_REP_METRIC
                           ),
    p_coll_name         => STORAGE_REP_METRICS_PKG.G_HOST_STORAGE_HIST_COLL,
    p_coll_schedule     => MGMT_COLL_SCHEDULE_OBJ.ON_DEMAND_SCHEDULE
  );     

  COMMIT;

EXCEPTION
  WHEN OTHERS THEN
    EXECUTE IMMEDIATE 'ALTER TABLE MGMT_METRICS ENABLE ALL TRIGGERS';
    RAISE;
END;
/
