Rem
Rem $Header: system_dashboard_types.sql 18-jul-2005.22:07:19 paachary Exp $
Rem
Rem system_dashboard_types.sql
Rem
Rem Copyright (c) 2005, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      system_dashboard_types.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    paachary    07/18/05 - paachary_bug-4492521
Rem    paachary    07/15/05 - Created
Rem

SET ECHO ON
SET FEEDBACK 1
SET NUMWIDTH 10
SET LINESIZE 80
SET TRIMSPOOL ON
SET TAB OFF
SET PAGESIZE 100


drop type em_system_obj;

drop type em_targettype_array;

drop type em_targettype_obj;

drop type em_target_array;

drop type em_target_obj;

drop type em_policy_viol_array;

drop type em_policy_viol_obj;

drop type em_alert_array;

drop type em_alert_obj;

drop type em_metric_array;

drop type em_metric_obj;

drop type em_status_array;

drop type em_status_obj;

CREATE OR REPLACE TYPE em_status_obj AS OBJECT
(
    status_type    VARCHAR2(256),
    status_count   NUMBER
);
/

CREATE OR REPLACE TYPE em_status_array AS TABLE OF em_status_obj;
/

CREATE OR REPLACE TYPE em_metric_obj AS OBJECT
(
    metric_name           VARCHAR2(256),
    metric_abbreviation   VARCHAR2(256),
    metric_column         VARCHAR2(64),
    metric_involved_name  VARCHAR2(64),
    metric_status         VARCHAR2(64),
    metric_value          NUMBER,
    target_property_value VARCHAR2(256)
);
/

CREATE OR REPLACE TYPE em_metric_array AS TABLE OF em_metric_obj;
/

CREATE OR REPLACE TYPE em_alert_obj AS OBJECT
(
    alert_type     VARCHAR2(256),
    alert_count    NUMBER,
    severity_code  NUMBER,
    severity_type  NUMBER,
    current_status NUMBER,
    target_guid    varchar2(64)
);
/

CREATE OR REPLACE TYPE em_alert_array AS TABLE OF em_alert_obj;
/

CREATE OR REPLACE TYPE em_policy_viol_obj AS OBJECT
(
    severity_type     VARCHAR2(256),
    violation_count   NUMBER
);
/

CREATE OR REPLACE TYPE em_policy_viol_array AS TABLE OF em_policy_viol_obj;
/

CREATE OR REPLACE TYPE em_target_obj AS OBJECT
(
    target_guid     VARCHAR2(64),
    target_name     VARCHAR2(256),
    target_type     VARCHAR2(64),
    is_aggregate    NUMBER,
    status_details  em_status_array,
    metric_details  em_metric_array,
    alert_details   em_alert_array,
    policy_details  em_policy_viol_array
);
/

CREATE OR REPLACE TYPE em_target_array AS TABLE OF em_target_obj;
/

CREATE OR REPLACE TYPE em_targettype_obj AS OBJECT
(
    target_type_name  VARCHAR2(64),
    status_details    em_status_array,
    alert_details     em_alert_array
);
/

CREATE OR REPLACE TYPE em_targettype_array AS TABLE OF em_targettype_obj;
/

create or replace type em_system_obj is Object
(
    system_guid     varchar2(64),
    system_name     varchar2(256),
    system_type     varchar2(64),
    status_details  em_status_array
);
/
