Rem
Rem $Header: website_common_init.sql 21-nov-2006.17:42:42 yxie Exp $
Rem
Rem website_common_init.sql
Rem
Rem Copyright (c) 2005, 2006, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      website_common_init.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    yxie        11/21/06 - XbranchMerge yxie_bug5527422 from main
Rem    yxie        07/22/05 - add support for generic_redudancy_group
Rem    yxie        06/20/05 - yxie_bug-4390544
Rem    yxie        06/10/05 - Created
Rem

-- Add new supportsEUM and supportsE2E properties
BEGIN

  MGMT_TARGET.add_target_type_property(MGMT_GLOBAL.G_WEBSITE_TARGET_TYPE,
                                     MGMT_WEBSITE_TARGET.SUPPORTS_EUM_PROP, 1);
  MGMT_TARGET.add_target_type_property(MGMT_GLOBAL.G_WEBSITE_TARGET_TYPE,
                                     MGMT_WEBSITE_TARGET.SUPPORTS_E2E_PROP, 1);

  mgmt_log.register_logging_module ( MGMT_WEBSITE_TARGET.MODULE_NAME,
                                     'Website EUME2E Association Callbacks');
END;
/
show errors;

-- Register callbacks
BEGIN

  mgmt_assoc.add_assoc_deletion_callback(
    'MGMT_WEBSITE_TARGET.key_del_callback',
    MGMT_ASSOC.ASSOC_DEF_DEPENDS_ON,
    MGMT_GLOBAL.G_WEBSITE_TARGET_TYPE);

  mgmt_assoc.add_assoc_deletion_callback(
    'MGMT_WEBSITE_TARGET.cluster_mem_del_callback',
    MGMT_ASSOC.ASSOC_DEF_CONTAINS,
    'oc4j_cluster');

  mgmt_assoc.add_assoc_addition_callback(
    'MGMT_WEBSITE_TARGET.cluster_mem_add_callback',
    MGMT_ASSOC.ASSOC_DEF_CONTAINS,
    'oc4j_cluster');

  mgmt_assoc.add_assoc_deletion_callback(
    'MGMT_WEBSITE_TARGET.cluster_mem_del_callback',
    MGMT_ASSOC.ASSOC_DEF_CONTAINS,
    'oracle_apache_cluster');

  mgmt_assoc.add_assoc_addition_callback(
    'MGMT_WEBSITE_TARGET.cluster_mem_add_callback',
    MGMT_ASSOC.ASSOC_DEF_CONTAINS,
    'oracle_apache_cluster');

  mgmt_assoc.add_assoc_deletion_callback(
    'MGMT_WEBSITE_TARGET.cluster_mem_del_callback',
    MGMT_ASSOC.ASSOC_DEF_CONTAINS,
    MGMT_GLOBAL.G_REDUNDANCY_GROUP_TARGET_TYPE);

  mgmt_assoc.add_assoc_addition_callback(
    'MGMT_WEBSITE_TARGET.cluster_mem_add_callback',
    MGMT_ASSOC.ASSOC_DEF_CONTAINS,
    MGMT_GLOBAL.G_REDUNDANCY_GROUP_TARGET_TYPE);

  em_target.add_tgt_pre_deletion_callback('MGMT_WEBSITE_TARGET.del_key_cluster_callback', ' ', 'oc4j_cluster', 0);

  em_target.add_tgt_pre_deletion_callback('MGMT_WEBSITE_TARGET.del_key_cluster_callback', ' ', 'oracle_apache_cluster', 0);

  em_target.add_tgt_pre_deletion_callback('MGMT_WEBSITE_TARGET.del_key_cluster_callback', ' ', MGMT_GLOBAL.G_REDUNDANCY_GROUP_TARGET_TYPE, 0);

END;
/
show error;

-- Fill in EUM/E2E association lookup table
BEGIN

INSERT INTO EUME2E_ASSOCS_LOOKUP (TARGET_TYPE, ASSOC_GUID) VALUES(MGMT_GLOBAL.G_WEBCACHE_TARGET_TYPE, MGMT_WEBSITE_TARGET.supports_eum_on_guid);
INSERT INTO EUME2E_ASSOCS_LOOKUP (TARGET_TYPE, ASSOC_GUID) VALUES(MGMT_GLOBAL.G_HTTP_SERVER_TARGET_TYPE, MGMT_WEBSITE_TARGET.supports_eum_on_guid);
INSERT INTO EUME2E_ASSOCS_LOOKUP (TARGET_TYPE, ASSOC_GUID) VALUES('generic_apache', MGMT_WEBSITE_TARGET.supports_eum_on_guid);
INSERT INTO EUME2E_ASSOCS_LOOKUP (TARGET_TYPE, ASSOC_GUID) VALUES('oracle_apache_cluster', MGMT_WEBSITE_TARGET.supports_eum_on_guid);
INSERT INTO EUME2E_ASSOCS_LOOKUP (TARGET_TYPE, ASSOC_GUID) VALUES(MGMT_GLOBAL.G_REDUNDANCY_GROUP_TARGET_TYPE, MGMT_WEBSITE_TARGET.supports_eum_on_guid);
INSERT INTO EUME2E_ASSOCS_LOOKUP (TARGET_TYPE, ASSOC_GUID) VALUES(MGMT_GLOBAL.G_OC4J_TARGET_TYPE, MGMT_WEBSITE_TARGET.supports_e2e_on_guid);
INSERT INTO EUME2E_ASSOCS_LOOKUP (TARGET_TYPE, ASSOC_GUID) VALUES('oc4j_cluster', MGMT_WEBSITE_TARGET.supports_e2e_on_guid);
INSERT INTO EUME2E_ASSOCS_LOOKUP (TARGET_TYPE, ASSOC_GUID) VALUES(MGMT_GLOBAL.G_REDUNDANCY_GROUP_TARGET_TYPE, MGMT_WEBSITE_TARGET.supports_e2e_on_guid);

END;
/
show errors;
