set define off
set verify off
set serveroutput on size 1000000
set feedback off
begin wwv_flow.g_import_in_progress := true; end; 
/
 
 
--application/set_environment
prompt  APPLICATION 4053 - APEX - Internal Administration
--
-- Application Export:
--   Application:     4053
--   Name:            APEX - Internal Administration
--   Date and Time:   13:51 Thursday May 28, 2009
--   Exported By:     
--   Flashback:       0
--   Export Type:     Application Export
--   Version: 3.2.1.00.09
 
-- Import:
--   Using application builder
--   or
--   Using SQL*Plus as the Oracle user APEX_030200 or as the owner (parsing schema) of the application.
 
-- Application Statistics:
--   Pages:               102
--     Items:             342
--     Computations:       24
--     Validations:       116
--     Processes:         119
--     Regions:           406
--     Buttons:           173
--   Shared Components
--     Breadcrumbs:         1
--        Entries          99
--     Items:               3
--     Computations:        1
--     Processes:           0
--     Parent Tabs:         0
--     Tab Sets:            0
--        Tabs:             0
--     NavBars:             2
--     Lists:              30
--     Shortcuts:           5
--     Themes:              0
--     Templates:
--        Page:             3
--        List:            10
--        Report:           4
--        Label:            4
--        Region:          18
--     Messages:            0
--     Build Options:       0
 
 
--       AAAA       PPPPP   EEEEEE  XX      XX
--      AA  AA      PP  PP  EE       XX    XX
--     AA    AA     PP  PP  EE        XX  XX
--    AAAAAAAAAA    PPPPP   EEEE       XXXX
--   AA        AA   PP      EE        XX  XX
--  AA          AA  PP      EE       XX    XX
--  AA          AA  PP      EEEEEE  XX      XX
prompt  Set Credentials...
 
begin
 
  -- Assumes you are running the script connected to SQL*Plus as the Oracle user APEX_030200 or as the owner (parsing schema) of the application.
  wwv_flow_api.set_security_group_id(p_security_group_id=>10);
 
end;
/

begin wwv_flow.g_import_in_progress := true; end;
/
begin 

select value into wwv_flow_api.g_nls_numeric_chars from nls_session_parameters where parameter='NLS_NUMERIC_CHARACTERS';

end;

/
begin execute immediate 'alter session set nls_numeric_characters=''.,''';

end;

/
begin wwv_flow.g_browser_language := 'en-us'; end;
/
prompt  Check Compatibility...
 
begin
 
-- This date identifies the minimum version required to import this file.
wwv_flow_api.set_version(p_version_yyyy_mm_dd=>'2009.01.12');
 
end;
/

prompt  Set Application ID...
 
begin
 
   -- SET APPLICATION ID
   wwv_flow.g_flow_id := 4053;
   wwv_flow_api.g_id_offset := 0;
null;
 
end;
/

--application/delete_application
 
begin
 
   -- Remove Application
wwv_flow_api.remove_flow(4053);
 
end;
/

 
begin
 
wwv_flow_audit.remove_audit_trail(4053);
null;
 
end;
/

--application/create_application
 
begin
 
wwv_flow_api.create_flow(
  p_id    => 4053,
  p_display_id=> 4053,
  p_owner => 'APEX_030200',
  p_name  => 'APEX - Internal Administration',
  p_alias => 'A198383923795422329',
  p_page_view_logging => 'YES',
  p_default_page_template=> 19236405723931959.4053 + wwv_flow_api.g_id_offset,
  p_printer_friendly_template=> 19236405723931959.4053 + wwv_flow_api.g_id_offset,
  p_default_region_template=> 75821319588166981.4053 + wwv_flow_api.g_id_offset,
  p_error_template    => 19236405723931959.4053 + wwv_flow_api.g_id_offset,
  p_charset           => 'utf-8',
  p_checksum_salt_last_reset => '20090528134550',
  p_max_session_length_sec=> 28800,
  p_home_link         => 'f?p=4050:3:&SESSION.',
  p_flow_language     => 'de',
  p_flow_language_derived_from=> 'BROWSER',
  p_flow_image_prefix => '/i/',
  p_documentation_banner=> '',
  p_authentication    => 'CUSTOM2',
  p_login_url         => 'HTMLDB_SERVICE_ADMINISTRATION',
  p_logout_url        => 'wwv_flow_custom_auth_std.logout?p_this_flow=&FLOW_ID.&p_next_flow_page_sess=4550:8:&SESSION.::::P8_NEXTPAGE:10',
  p_application_tab_set=> 1,
  p_logo_image => '#IMAGE_PREFIX#htmldb/apex_logo.gif',
  p_logo_image_attributes => 'width="300" height="30" alt="&PRODUCT_NAME."',
  p_public_url_prefix => '',
  p_public_user       => 'APEX_PUBLIC_USER',
  p_dbauth_url_prefix => '',
  p_proxy_server      => '',
  p_cust_authentication_process=> '.'||to_char(60858404230121142 + wwv_flow_api.g_id_offset)||'.',
  p_cust_authentication_page=> '',
  p_custom_auth_login_url=> '',
  p_flow_version      => '&PRODUCT_NAME. 3.2.1.00.09',
  p_flow_status       => 'AVAILABLE_W_EDIT_LINK',
  p_flow_unavailable_text=> 'This application is currently unavailable.',
  p_build_status      => 'RUN_AND_BUILD',
  p_exact_substitutions_only=> 'Y',
  p_vpd               => '',
  p_security_scheme => 1018002984071621+ wwv_flow_api.g_id_offset,
  p_csv_encoding    => 'Y',
  p_theme_id => 3,
  p_default_label_template => 111843720754869910.4053 + wwv_flow_api.g_id_offset,
  p_default_report_template => 6897002870390711.4053 + wwv_flow_api.g_id_offset,
  p_default_list_template => 82702000896937873.4053 + wwv_flow_api.g_id_offset,
  p_substitution_string_01 => 'LOGOUT',
  p_substitution_value_01  => 'Abmelden',
  p_substitution_string_02 => 'DELETE_MSG',
  p_substitution_value_02  => 'Soll dieser Löschvorgang ausgeführt werden?',
  p_substitution_string_04 => 'PRODUCT_NAME',
  p_substitution_value_04  => 'Application Express',
  p_substitution_string_05 => 'COMPANY_NAME',
  p_substitution_value_05  => 'Workspace',
  p_substitution_string_06 => 'MSG_COMPANY',
  p_substitution_value_06  => 'Workspace: &COMPANY.',
  p_substitution_string_07 => 'MSG_LANGUAGE',
  p_substitution_value_07  => 'Sprache',
  p_substitution_string_08 => 'MSG_COPYRIGHT',
  p_substitution_value_08  => 'Copyright &copy; 1999, 2009, Oracle. All rights reserved. Alle Rechte vorbehalten.',
  p_substitution_string_09 => 'MSG_USER',
  p_substitution_value_09  => 'Benutzer',
  p_substitution_string_10 => 'MSG_JSCRIPT',
  p_substitution_value_10  => 'Wenn Sie dieses Produkt ausführen, muss JavaScript aktiviert sein.',
  p_substitution_string_11 => 'MSG_TBL_SUMMARY',
  p_substitution_value_11  => 'Tabelle für das Seitenlayout',
  p_substitution_string_12 => 'EDIT',
  p_substitution_value_12  => 'Bearbeiten',
  p_substitution_string_13 => 'DONE',
  p_substitution_value_13  => 'Fertig',
  p_substitution_string_14 => 'TOP',
  p_substitution_value_14  => 'Oben',
  p_substitution_string_15 => 'CLOSE',
  p_substitution_value_15  => 'Schließen',
  p_substitution_string_16 => 'DATE_FORMAT',
  p_substitution_value_16  => 'dd.mm.rr',
  p_substitution_string_17 => 'LONG_DATE_FORMAT',
  p_substitution_value_17  => 'fmDay, dd. Month yyyy',
  p_substitution_string_18 => 'TIME_FORMAT',
  p_substitution_value_18  => 'hh24:mi:ss',
  p_substitution_string_19 => 'DATE_TIME_FORMAT',
  p_substitution_value_19  => 'dd.mm.rr hh24:mi:ss',
  p_substitution_string_20 => 'RETURN_TO_APP',
  p_substitution_value_20  => 'Zurück zu Anwendung',
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss=> '20090528134451',
  p_global_notification=> '<style type="text/css">'||chr(10)||
'<!--'||chr(10)||
'#htmldbWorkspace{display:none;}'||chr(10)||
'-->'||chr(10)||
'</style>',
  p_required_roles=> wwv_flow_utilities.string_to_table2(''));
 
 
end;
/

prompt  ...authorization schemes
--
 
begin
 
null;
 
end;
/

--application/shared_components/navigation/navigation_bar
prompt  ...navigation bar entries
--
 
begin
 
wwv_flow_api.create_icon_bar_item(
  p_id             => 652214800522885.4053 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_icon_sequence  => 1,
  p_icon_image     => 'htmldb/icons/navbarhelp_25x25.gif',
  p_icon_subtext   => 'Hilfe',
  p_icon_target    => 'javascript:popupURL(''wwv_flow_help.show_help?p_lang=&BROWSER_LANGUAGE.&p_session=&APP_SESSION.&p_flow_id=&APP_TRANSLATION_ID.&p_step_id=&APP_TRANSLATION_PAGE_ID.'');',
  p_icon_image_alt => 'Hilfe',
  p_icon_height    => 25,
  p_icon_width     => 25,
  p_icon_height2   => null,
  p_icon_width2    => null,
  p_icon_bar_disp_cond      => '',
  p_icon_bar_disp_cond_type => '',
  p_begins_on_new_line=> 'NO',
  p_cell_colspan      => 1,
  p_onclick=> '',
  p_icon_bar_comment=> 'Display same page with print view page template');
 
wwv_flow_api.create_icon_bar_item(
  p_id             => 24559226221.4053 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_icon_sequence  => 2,
  p_icon_image     => 'htmldb/icons/navbarlogout_25x25.gif',
  p_icon_image2    => 'wwv_logout24.gif',
  p_icon_subtext   => 'Abmelden',
  p_icon_target    => '&LOGOUT_URL.',
  p_icon_image_alt => 'Abmelden',
  p_icon_height    => 25,
  p_icon_width     => 25,
  p_icon_height2   => 24,
  p_icon_width2    => 24,
  p_icon_bar_disp_cond      => '',
  p_icon_bar_disp_cond_type => 'CURRENT_LOOK_IS_1',
  p_begins_on_new_line=> 'NO',
  p_cell_colspan      => 1,
  p_onclick=> '',
  p_icon_bar_comment=> 'Navigate to Flow Attribute LOGOUT_URL when pressed.');
 
 
end;
/

prompt  ...application processes
--
prompt  ...application items
--
--application/shared_components/logic/application_items/company
 
begin
 
wwv_flow_api.create_flow_item(
  p_id=> 24661497730.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'COMPANY',
  p_data_type=> 'VARCHAR',
  p_is_persistent=> 'Y',
  p_protection_level=> '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_item_comment=> 'company logged into flow');
 
null;
 
end;
/

--application/shared_components/logic/application_items/fsp_after_login_url
 
begin
 
wwv_flow_api.create_flow_item(
  p_id=> 69693210447779230.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'FSP_AFTER_LOGIN_URL',
  p_data_type=> 'VARCHAR',
  p_is_persistent=> 'Y',
  p_protection_level=> '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_item_comment=> 'Used by Custom2 authentication for deep linking support');
 
null;
 
end;
/

--application/shared_components/logic/application_items/last_view
 
begin
 
wwv_flow_api.create_flow_item(
  p_id=> 48673315869342015.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'LAST_VIEW',
  p_data_type=> 'NUMBER',
  p_is_persistent=> 'Y',
  p_protection_level=> '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_item_comment=> 'used for help');
 
null;
 
end;
/

prompt  ...application level computations
--
 
begin
 
--application/shared_components/logic/application_computations/company
wwv_flow_api.create_flow_computation (
  p_id => 24663499759.4053 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_computation_sequence => 10,
  p_computation_item => 'COMPANY',
  p_computation_point    => 'ON_NEW_INSTANCE',
  p_computation_type => 'PLSQL_EXPRESSION',
  p_computation_processed=> 'REPLACE_EXISTING',
  p_computation => 'wwv_flow.get_company_name;',
  p_compute_when=> '',
  p_compute_when_type=> '',
  p_computation_error_message=>'Abrufen des Workspace-Namens nicht möglich.',
  p_computation_comment=> '',
  p_required_patch=> null + wwv_flow_api.g_id_offset);
 
 
end;
/

prompt  ...Application Tabs
--
 
begin
 
null;
 
end;
/

prompt  ...Application Parent Tabs
--
 
begin
 
null;
 
end;
/

prompt  ...Shared Lists of values
--
--application/shared_components/user_interface/lov/account_lock_status
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 12506800188785204.4053 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'ACCOUNT_LOCK_STATUS',
  p_lov_query=> '.'||to_char(12506800188785204 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>12507123798785207.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>12506800188785204.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Gesperrt',
  p_lov_return_value=>'Y',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>12507312044785207.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>12506800188785204.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'Freigegeben',
  p_lov_return_value=>'N',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/application_themes
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 138044801783643280.4053 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'APPLICATION THEMES',
  p_lov_query=> 'select theme_id||''. '' ||htf.escape_sc(theme_name) d, theme_id'||chr(10)||
'from   wwv_flow_themes'||chr(10)||
'where  flow_id = :fb_flow_id'||chr(10)||
'order by theme_id');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/audit_naming
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 192906504723933391.4053 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'AUDIT_NAMING',
  p_lov_query=> '.'||to_char(192906504723933391 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>192906720941933395.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>192906504723933391.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Anwendungsattribute',
  p_lov_return_value=>'WWV_FLOWS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>192906908350933397.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>192906504723933391.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Seiten-Template',
  p_lov_return_value=>'WWV_FLOW_TEMPLATES',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>192907100225933398.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>192906504723933391.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3,
  p_lov_disp_value=>'Navigationsleiste',
  p_lov_return_value=>'WWV_FLOW_ICON_BAR',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>192907329971933398.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>192906504723933391.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>4,
  p_lov_disp_value=>'Anwendungsprozess',
  p_lov_return_value=>'WWV_FLOW_PROCESSING',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>192907525100933398.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>192906504723933391.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>5,
  p_lov_disp_value=>'Anwendungselement',
  p_lov_return_value=>'WWV_FLOW_ITEMS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>192907723181933398.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>192906504723933391.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>6,
  p_lov_disp_value=>'Anwendungsberechnung',
  p_lov_return_value=>'WWV_FLOW_COMPUTATIONS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>192907918785933401.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>192906504723933391.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>7,
  p_lov_disp_value=>'Registerkarten',
  p_lov_return_value=>'WWV_FLOW_TABS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>192908101742933401.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>192906504723933391.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>8,
  p_lov_disp_value=>'Übergeordnete Registerkarte',
  p_lov_return_value=>'WWV_FLOW_TOPLEVEL_TABS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>192908312729933401.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>192906504723933391.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>9,
  p_lov_disp_value=>'Werteliste',
  p_lov_return_value=>'WWV_FLOW_LISTS_OF_VALUES$',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>192908508490933401.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>192906504723933391.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Statische Wertelistenwerte',
  p_lov_return_value=>'WWV_FLOW_LISTS_OF_VALUES_DATA',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>192908720172933401.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>192906504723933391.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Navigationspfadeintrag',
  p_lov_return_value=>'WWV_FLOW_MENU_OPTIONS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>192917410258942992.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>192906504723933391.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Themes',
  p_lov_return_value=>'WWV_FLOW_THEMES',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>192908929274933402.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>192906504723933391.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>11,
  p_lov_disp_value=>'Seitenattribute',
  p_lov_return_value=>'WWV_FLOW_STEPS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>192909112437933402.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>192906504723933391.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>12,
  p_lov_disp_value=>'Seitenschaltfläche',
  p_lov_return_value=>'WWV_FLOW_STEP_BUTTONS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>192909326218933402.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>192906504723933391.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>13,
  p_lov_disp_value=>'Seitenverzweigung',
  p_lov_return_value=>'WWV_FLOW_STEP_BRANCHES',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>192909515542933402.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>192906504723933391.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>14,
  p_lov_disp_value=>'Seitenverzweigungsargumente',
  p_lov_return_value=>'WWV_FLOW_STEP_BRANCH_ARGS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>192909710968933403.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>192906504723933391.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>15,
  p_lov_disp_value=>'Seitenelement',
  p_lov_return_value=>'WWV_FLOW_STEP_ITEMS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>192909909431933403.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>192906504723933391.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>16,
  p_lov_disp_value=>'Seitenberechnung',
  p_lov_return_value=>'WWV_FLOW_STEP_COMPUTATIONS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>192910102627933403.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>192906504723933391.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>17,
  p_lov_disp_value=>'Seitenvalidierung',
  p_lov_return_value=>'WWV_FLOW_STEP_VALIDATIONS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>192910304404933403.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>192906504723933391.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>18,
  p_lov_disp_value=>'Seitenprozess',
  p_lov_return_value=>'WWV_FLOW_STEP_PROCESSING',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>192910501092933404.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>192906504723933391.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>19,
  p_lov_disp_value=>'Regions-Template',
  p_lov_return_value=>'WWV_FLOW_PAGE_PLUG_TEMPLATES',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>192910701238933404.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>192906504723933391.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'Zeilen-Template',
  p_lov_return_value=>'WWV_FLOW_ROW_TEMPLATES',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>192910921309933404.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>192906504723933391.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>21,
  p_lov_disp_value=>'Listen-Template',
  p_lov_return_value=>'WWV_FLOW_LIST_TEMPLATES',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>192911107468933404.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>192906504723933391.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>22,
  p_lov_disp_value=>'Regionsattribute',
  p_lov_return_value=>'WWV_FLOW_PAGE_PLUGS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>192911327453933408.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>192906504723933391.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>23,
  p_lov_disp_value=>'Meldungen',
  p_lov_return_value=>'WWV_FLOW_MESSAGES$',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>192911518683933408.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>192906504723933391.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>24,
  p_lov_disp_value=>'Erstelloptionen',
  p_lov_return_value=>'WWV_FLOW_PATCHES',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>192911719543933408.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>192906504723933391.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>25,
  p_lov_disp_value=>'Anwendungsentwickler (Administration)',
  p_lov_return_value=>'WWV_FLOW_DEVELOPERS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>192911931458933408.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>192906504723933391.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>26,
  p_lov_disp_value=>'Listen',
  p_lov_return_value=>'WWV_FLOW_LISTS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>192912106135933409.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>192906504723933391.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>27,
  p_lov_disp_value=>'Listenelement',
  p_lov_return_value=>'WWV_FLOW_LIST_ITEMS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>192912316871933409.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>192906504723933391.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>28,
  p_lov_disp_value=>'Effektive UserID (Administration)',
  p_lov_return_value=>'WWV_FLOW_EFFECTIVE_USERID_MAP',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>192912501053933409.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>192906504723933391.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>29,
  p_lov_disp_value=>'Shortcuts',
  p_lov_return_value=>'WWV_FLOW_SHORTCUTS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>192912709920933409.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>192906504723933391.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>30,
  p_lov_disp_value=>'Hilfetext für Seitenelement',
  p_lov_return_value=>'WWV_FLOW_STEP_ITEM_HELP',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>192912922654933410.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>192906504723933391.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>31,
  p_lov_disp_value=>'Authentifizierungs-Setups',
  p_lov_return_value=>'WWV_FLOW_CUSTOM_AUTH_SETUPS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>192913116096933410.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>192906504723933391.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>32,
  p_lov_disp_value=>'Eintrittspunkte',
  p_lov_return_value=>'WWV_FLOW_ENTRY_POINTS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>192913326886933410.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>192906504723933391.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>33,
  p_lov_disp_value=>'Eintrittspunktargumente',
  p_lov_return_value=>'WWV_FLOW_ENTRY_POINT_ARGS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/bipublisher_support
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 66524307689014582.4053 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'BIPUBLISHER_SUPPORT',
  p_lov_query=> '.'||to_char(66524307689014582 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>66524606927014584.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>66524307689014582.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Standard',
  p_lov_return_value=>'STANDARD',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>66524808931014584.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>66524307689014582.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Erweitert (erfordert Oracle BI Publisher)',
  p_lov_return_value=>'ADVANCED',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/build_status
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 244320808989852457.4053 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'BUILD_STATUS',
  p_lov_query=> '.'||to_char(244320808989852457 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>244321119544852463.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>244320808989852457.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Anwendung nur ausführen',
  p_lov_return_value=>'RUN_ONLY',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>244321323574852464.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>244320808989852457.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Anwendung ausführen und erstellen',
  p_lov_return_value=>'RUN_AND_BUILD',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/confirm_delete_denied_request
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 87822015190102927.4053 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'CONFIRM.DELETE.DENIED.REQUEST',
  p_lov_query=> '.'||to_char(87822015190102927 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87822220071102927.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>87822015190102927.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Soll dieser Request bei Verweigerung gelöscht werden?',
  p_lov_return_value=>'YES',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/confirm_pwd_removal
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 35215801480283409.4053 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'CONFIRM.PWD.REMOVAL',
  p_lov_query=> '.'||to_char(35215801480283409 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>35216131980283418.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>35215801480283409.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Aktivieren Sie diese Option, um zu bestätigen, dass das Wallet-Kennwort geändert werden soll',
  p_lov_return_value=>'Y',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/confirm_removal
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 87818332243088870.4053 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'CONFIRM.REMOVAL',
  p_lov_query=> '.'||to_char(87818332243088870 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87818517495088870.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>87818332243088870.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Aktivieren Sie dieses Kontrollkästchen, um zu bestätigen, dass mit dem Löschvorgang fortgefahren werden soll.',
  p_lov_return_value=>'Yes',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/confirm_remove_request
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 87819107787091340.4053 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'CONFIRM.REMOVE.REQUEST',
  p_lov_query=> '.'||to_char(87819107787091340 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87819312320091340.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>87819107787091340.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Aktivieren Sie dieses Kontrollkästchen, wenn auch der Request für diesen Workspace entfernt werden soll.',
  p_lov_return_value=>'Yes',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/confirm_workspace_install
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 73876902692924600.4053 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'CONFIRM.WORKSPACE_INSTALL',
  p_lov_query=> '.'||to_char(73876902692924600 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>73877205249924603.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>73876902692924600.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Wählen Sie diese Option, um mit der Installation des Workspace fortzufahren, der vollen Zugriff auf das angezeigte Primärschema und die angegebenen zusätzlichen Schemas hat.',
  p_lov_return_value=>'Yes',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/countries
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 77152009156464203.4053 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'COUNTRIES',
  p_lov_query=> 'select COUNTRY_NAME d, COUNTRY_NAME r'||chr(10)||
'from wwv_flow_countries'||chr(10)||
'order by country_name');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/db_tablespaces
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 161644121203686372.4053 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'DB.TABLESPACES',
  p_lov_query=> 'select tablespace_name tname_disp, tablespace_name tname_ret'||chr(10)||
'  from sys.dba_tablespaces');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/developer_activity_action
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 110357115975241430.4053 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'DEVELOPER ACTIVITY ACTION',
  p_lov_query=> '.'||to_char(110357115975241430 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>110357309735241430.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>110357115975241430.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Erstellen',
  p_lov_return_value=>'I',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>110357503716241431.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>110357115975241430.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Löschen',
  p_lov_return_value=>'D',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>110357728444241431.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>110357115975241430.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3,
  p_lov_disp_value=>'Ändern',
  p_lov_return_value=>'U',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/developer_privs
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 182796815771077530.4053 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'DEVELOPER.PRIVS',
  p_lov_query=> '.'||to_char(182796815771077530 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87840032028448399.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>182796815771077530.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Administration',
  p_lov_return_value=>'ADMIN',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87840228629448402.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>182796815771077530.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'Durchsuchen',
  p_lov_return_value=>'BROWSE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87840406518448402.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>182796815771077530.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>30,
  p_lov_disp_value=>'Erstellen',
  p_lov_return_value=>'CREATE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87840629693448402.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>182796815771077530.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>40,
  p_lov_disp_value=>'Data Loader',
  p_lov_return_value=>'DATA_LOADER',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87840818626448402.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>182796815771077530.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>50,
  p_lov_disp_value=>'DB-Überwachung',
  p_lov_return_value=>'DB_MONITOR',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87841009541448403.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>182796815771077530.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>60,
  p_lov_disp_value=>'Bearbeiten',
  p_lov_return_value=>'EDIT',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87841204704448403.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>182796815771077530.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>70,
  p_lov_disp_value=>'Hilfe',
  p_lov_return_value=>'HELP',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87841420783448403.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>182796815771077530.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>80,
  p_lov_disp_value=>'Überwachen',
  p_lov_return_value=>'MONITOR',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87841623734448404.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>182796815771077530.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>90,
  p_lov_disp_value=>'SQL',
  p_lov_return_value=>'SQL',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87841806856448404.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>182796815771077530.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>100,
  p_lov_disp_value=>'Benutzer-Manager',
  p_lov_return_value=>'USER_MANAGER',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/file_format
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 175743214959227187.4053 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'FILE_FORMAT',
  p_lov_query=> '.'||to_char(175743214959227187 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>175743426983227191.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>175743214959227187.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'DOS',
  p_lov_return_value=>'DOS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>175743601146227192.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>175743214959227187.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'UNIX',
  p_lov_return_value=>'UNIX',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/i18n_iana_charset
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 175798011541253458.4053 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'I18N_IANA_CHARSET',
  p_reference_id=> 144796827445692396,
  p_lov_query=> '.'||to_char(175798011541253458 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70934618367399256.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>175798011541253458.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Arabisch (ISO-8859-6)',
  p_lov_return_value=>'iso-8859-6',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70934821980399256.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>175798011541253458.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'Arabisch (Windows 1256)',
  p_lov_return_value=>'windows-1256',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70935006414399256.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>175798011541253458.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>30,
  p_lov_disp_value=>'Chinesisch (Big5)',
  p_lov_return_value=>'big5',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70935216265399257.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>175798011541253458.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>40,
  p_lov_disp_value=>'Chinesisch (GBK)',
  p_lov_return_value=>'gbk',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70935419960399257.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>175798011541253458.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>50,
  p_lov_disp_value=>'Kyrillisch (ISO-8859-5)',
  p_lov_return_value=>'iso-8859-5',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70935624734399257.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>175798011541253458.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>60,
  p_lov_disp_value=>'Kyrillisch (KOI8-R)',
  p_lov_return_value=>'koi8-r',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70935825841399257.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>175798011541253458.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>70,
  p_lov_disp_value=>'Kyrillisch (KOI8-U)',
  p_lov_return_value=>'koi8-u',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70936006970399257.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>175798011541253458.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>80,
  p_lov_disp_value=>'Kyrillisch (Windows 1251)',
  p_lov_return_value=>'windows-1251',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70936231255399257.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>175798011541253458.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>90,
  p_lov_disp_value=>'Osteuropäisch (ISO-8859-2)',
  p_lov_return_value=>'iso-8859-2',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70936402013399257.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>175798011541253458.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>100,
  p_lov_disp_value=>'Osteuropäisch (Windows 1250)',
  p_lov_return_value=>'windows-1250',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70936608479399257.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>175798011541253458.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>110,
  p_lov_disp_value=>'Griechisch (ISO-8859-7)',
  p_lov_return_value=>'iso-8859-7',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70936826272399257.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>175798011541253458.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>120,
  p_lov_disp_value=>'Griechisch (Windows 1253)',
  p_lov_return_value=>'windows-1253',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70937010820399257.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>175798011541253458.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>130,
  p_lov_disp_value=>'Hebräisch (ISO-8859-8-i)',
  p_lov_return_value=>'iso-8859-8-i',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70937227021399257.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>175798011541253458.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>140,
  p_lov_disp_value=>'Hebräisch (Windows 1255)',
  p_lov_return_value=>'windows-1255',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70937401446399257.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>175798011541253458.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>150,
  p_lov_disp_value=>'Japanisch (EUC)',
  p_lov_return_value=>'euc-jp',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70937622141399257.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>175798011541253458.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>160,
  p_lov_disp_value=>'Japanisch (Shift JIS)',
  p_lov_return_value=>'shift_jis',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70937801046399258.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>175798011541253458.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>170,
  p_lov_disp_value=>'Koreanisch (EUC)',
  p_lov_return_value=>'euc-kr',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70938021293399258.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>175798011541253458.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>180,
  p_lov_disp_value=>'Nordeuropäisch (ISO-8859-4)',
  p_lov_return_value=>'iso-8859-4',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70938209547399258.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>175798011541253458.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>190,
  p_lov_disp_value=>'Nordeuropäisch (Windows 1257)',
  p_lov_return_value=>'windows-1257',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70938408347399258.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>175798011541253458.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>200,
  p_lov_disp_value=>'Südeuropäisch (ISO-8859-3)',
  p_lov_return_value=>'iso-8859-3',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70938619183399258.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>175798011541253458.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>210,
  p_lov_disp_value=>'Thailändisch (TIS-620)',
  p_lov_return_value=>'tis-620',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70938810956399258.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>175798011541253458.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>220,
  p_lov_disp_value=>'Türkisch (ISO-8859-9)',
  p_lov_return_value=>'iso-8859-9',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70939021765399258.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>175798011541253458.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>230,
  p_lov_disp_value=>'Türkisch (Windows 1254)',
  p_lov_return_value=>'windows-1254',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70939212407399258.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>175798011541253458.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>240,
  p_lov_disp_value=>'Unicode (UTF-8)',
  p_lov_return_value=>'utf-8',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70939412184399258.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>175798011541253458.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>242,
  p_lov_disp_value=>'Unicode UTF-16 Big-Endian',
  p_lov_return_value=>'utf-16be',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70939629276399258.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>175798011541253458.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>244,
  p_lov_disp_value=>'Unicode UTF-16 Little-Endian',
  p_lov_return_value=>'utf-16le',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70939800695399258.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>175798011541253458.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>248,
  p_lov_disp_value=>'US-ASCII',
  p_lov_return_value=>'us-ascii',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70940025642399258.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>175798011541253458.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>250,
  p_lov_disp_value=>'Vietnamesisch (Windows 1258)',
  p_lov_return_value=>'windows-1258',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70940221790399259.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>175798011541253458.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>260,
  p_lov_disp_value=>'Westeuropäisch (ISO-8859-1)',
  p_lov_return_value=>'iso-8859-1',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>70940420795399259.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>175798011541253458.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>270,
  p_lov_disp_value=>'Westeuropäisch (Windows 1252)',
  p_lov_return_value=>'windows-1252',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/list_workspaces
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 159434915946336703.4053 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'LIST.WORKSPACES',
  p_lov_query=> 'select short_name d, short_name v'||chr(10)||
'  from wwv_flow_companies'||chr(10)||
' where (provisioning_company_id not in (0,10,11))'||chr(10)||
'order by 1');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/list_all_companies
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 41061332989455513.4053 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'LIST_ALL_COMPANIES',
  p_lov_query=> 'select ''- ''||'||chr(10)||
'wwv_flow_lang.system_message(''F4050_SHOW_ALL_WORKSPACES'')||'||chr(10)||
''' -'' d, 0 r from dual union all'||chr(10)||
'select short_name||'' (''||PROVISIONING_COMPANY_ID||'')'' d,'||chr(10)||
'       PROVISIONING_COMPANY_ID r'||chr(10)||
'from   WWV_FLOW_COMPANIES'||chr(10)||
'where  provisioning_company_id > 0'||chr(10)||
'order by 1');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/list_all_companies_escaped
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 33198215215866564.4053 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'LIST_ALL_COMPANIES_ESCAPED',
  p_lov_query=> 'select ''- ''||'||chr(10)||
'wwv_flow_lang.system_message(''F4050_SHOW_ALL_WORKSPACES'')||'||chr(10)||
''' -'' d, 0 r from dual union all'||chr(10)||
'select htf.escape_sc(short_name)||'' (''||PROVISIONING_COMPANY_ID||'')'' d,'||chr(10)||
'       PROVISIONING_COMPANY_ID r'||chr(10)||
'from   WWV_FLOW_COMPANIES'||chr(10)||
'where  provisioning_company_id > 0'||chr(10)||
'order by 1');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/list_all_companies_no_null_option
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 71982116125334375.4053 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'LIST_ALL_COMPANIES_NO_NULL_OPTION',
  p_lov_query=> 'select short_name||'' (''||PROVISIONING_COMPANY_ID||'')'' d,'||chr(10)||
'       PROVISIONING_COMPANY_ID r'||chr(10)||
'from   WWV_FLOW_COMPANIES'||chr(10)||
'where  provisioning_company_id > 0'||chr(10)||
'order by 1');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/list_all_database_schemas
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 41061720511468543.4053 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'LIST_ALL_DATABASE_SCHEMAS',
  p_lov_query=> 'declare q varchar2(32767);'||chr(10)||
'  l_flows_schema varchar2(30) := wwv_flow.g_flow_schema_owner;'||chr(10)||
'begin'||chr(10)||
'    q := ''select name n, name r from sys.user$ u where type#=1 and name <> ''''''||l_flows_schema||'''''' and name not in (''''HTMLDB_PUBLIC_USER'''',''''PUBLIC_USER'''',''''FLOWS_FILES'''',''''SCHEDULER'''',''''PEOPLE'''',''''APEX_PUBLIC_USER'''')'';'||chr(10)||
'    q := q||'' and name not in (select schema from wwv_flow_restricted_schemas where not exists (select 1 from wwv_flow_rschema_exceptions where schema_id = (select id from wwv_flow_restricted_schemas where schema = u.name))) '';'||chr(10)||
'    q := q ||'' order by 1'';'||chr(10)||
'    return q;'||chr(10)||
'end;');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/list_developer_workspaces
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 245468425022265187.4053 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'LIST_DEVELOPER_WORKSPACES',
  p_lov_query=> 'select ''- ''||'||chr(10)||
'wwv_flow_lang.system_message(''F4050_SHOW_ALL_WORKSPACES'')||'||chr(10)||
''' -'' d, 0 r from dual union all'||chr(10)||
'select short_name||'' (''||PROVISIONING_COMPANY_ID||'')'' d,'||chr(10)||
'       PROVISIONING_COMPANY_ID r'||chr(10)||
'from   WWV_FLOW_COMPANIES'||chr(10)||
'where  provisioning_company_id not in (0,10,11)'||chr(10)||
'order by 1');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/list_developer_workspaces_no_null_option
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 201412507067809360.4053 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'LIST_DEVELOPER_WORKSPACES_NO_NULL_OPTION',
  p_lov_query=> 'select short_name||'' (''||PROVISIONING_COMPANY_ID||'')'' d,'||chr(10)||
'       PROVISIONING_COMPANY_ID r'||chr(10)||
'from   WWV_FLOW_COMPANIES'||chr(10)||
'where  provisioning_company_id not in (0,10,11)'||chr(10)||
'order by 1');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/list_flow_status
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 85746300886317667.4053 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'LIST_FLOW_STATUS',
  p_reference_id=> 634347472712995,
  p_lov_query=> '.'||to_char(85746300886317667 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>85777626835319570.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>85746300886317667.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Verfügbar',
  p_lov_return_value=>'AVAILABLE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>85777811385319570.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>85746300886317667.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'Verfügbar mit Bearbeiten-Links',
  p_lov_return_value=>'AVAILABLE_W_EDIT_LINK',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>85778029581319570.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>85746300886317667.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>30,
  p_lov_disp_value=>'Nur verfügbar für Entwickler',
  p_lov_return_value=>'DEVELOPERS_ONLY',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>85778208286319570.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>85746300886317667.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>40,
  p_lov_disp_value=>'Eingeschränkter Zugriff',
  p_lov_return_value=>'RESTRICTED_ACCESS',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>85778428641319571.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>85746300886317667.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>50,
  p_lov_disp_value=>'Nicht verfügbar',
  p_lov_return_value=>'UNAVAILABLE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>85778631627319571.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>85746300886317667.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>60,
  p_lov_disp_value=>'Nicht verfügbar (Status mit PL/SQL anzeigen)',
  p_lov_return_value=>'UNAVAILABLE_PLSQL',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>85778821414319571.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>85746300886317667.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>70,
  p_lov_disp_value=>'Nicht verfügbar (Zu URL umleiten)',
  p_lov_return_value=>'UNAVAILABLE_URL',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/login_status_codes
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 46388624571234535.4053 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'LOGIN STATUS CODES',
  p_lov_query=> '.'||to_char(46388624571234535 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>46388926156234544.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>46388624571234535.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Normale, erfolgreiche Authentifizierung',
  p_lov_return_value=>'0',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>46389114667234544.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>46388624571234535.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Unbekannter Benutzername',
  p_lov_return_value=>'1',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>46389305475234544.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>46388624571234535.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3,
  p_lov_disp_value=>'Account gesperrt',
  p_lov_return_value=>'2',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>46389507635234544.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>46388624571234535.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>4,
  p_lov_disp_value=>'Account abgelaufen',
  p_lov_return_value=>'3',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>46389702262234544.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>46388624571234535.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>5,
  p_lov_disp_value=>'Falsches Kennwort',
  p_lov_return_value=>'4',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>46389924389234544.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>46388624571234535.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>6,
  p_lov_disp_value=>'Erste Verwendung des Kennworts',
  p_lov_return_value=>'5',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>46390117950234544.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>46388624571234535.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>7,
  p_lov_disp_value=>'Maximale Anmeldeversuche überschritten',
  p_lov_return_value=>'6',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>46390320270234545.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>46388624571234535.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>8,
  p_lov_disp_value=>'Unbekannter interner Fehler',
  p_lov_return_value=>'7',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/login_message
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 138589612463299624.4053 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'LOGIN_MESSAGE',
  p_lov_query=> '.'||to_char(138589612463299624 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>138589828636299629.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>138589612463299624.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Keine Nachricht',
  p_lov_return_value=>'NONE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>138590030175299632.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>138589612463299624.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Benutzerdefinierte Nachricht',
  p_lov_return_value=>'CUSTOM',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/max_rows_a
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 87504531900192794.4053 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'MAX_ROWS_A',
  p_lov_query=> '.'||to_char(87504531900192794 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87504713683192797.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>87504531900192794.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'10',
  p_lov_return_value=>'10',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87504927403192799.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>87504531900192794.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'15',
  p_lov_return_value=>'15',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87505127136192799.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>87504531900192794.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>30,
  p_lov_disp_value=>'20',
  p_lov_return_value=>'20',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87505325056192799.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>87504531900192794.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>40,
  p_lov_disp_value=>'25',
  p_lov_return_value=>'25',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87505511346192800.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>87504531900192794.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>50,
  p_lov_disp_value=>'30',
  p_lov_return_value=>'30',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87505729136192800.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>87504531900192794.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>60,
  p_lov_disp_value=>'50',
  p_lov_return_value=>'50',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87505932223192800.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>87504531900192794.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>70,
  p_lov_disp_value=>'100',
  p_lov_return_value=>'100',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87506102365192800.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>87504531900192794.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>80,
  p_lov_disp_value=>'200',
  p_lov_return_value=>'200',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87506312795192801.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>87504531900192794.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>90,
  p_lov_disp_value=>'500',
  p_lov_return_value=>'500',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87506502410192801.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>87504531900192794.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>100,
  p_lov_disp_value=>'1000',
  p_lov_return_value=>'1000',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87506703570192801.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>87504531900192794.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>110,
  p_lov_disp_value=>'5000',
  p_lov_return_value=>'5000',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87506912687192801.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>87504531900192794.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>120,
  p_lov_disp_value=>'10000',
  p_lov_return_value=>'10000',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/max_rows_b
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 87717417968152000.4053 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'MAX_ROWS_B',
  p_lov_query=> '.'||to_char(87717417968152000 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87717608742152001.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>87717417968152000.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'1',
  p_lov_return_value=>'1',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87717807507152001.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>87717417968152000.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'5',
  p_lov_return_value=>'5',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87718000141152003.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>87717417968152000.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>30,
  p_lov_disp_value=>'10',
  p_lov_return_value=>'10',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87718209200152003.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>87717417968152000.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>40,
  p_lov_disp_value=>'15',
  p_lov_return_value=>'15',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87718403676152003.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>87717417968152000.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>50,
  p_lov_disp_value=>'20',
  p_lov_return_value=>'20',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87718622762152003.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>87717417968152000.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>60,
  p_lov_disp_value=>'30',
  p_lov_return_value=>'30',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87718817778152004.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>87717417968152000.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>70,
  p_lov_disp_value=>'50',
  p_lov_return_value=>'50',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87719020177152004.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>87717417968152000.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>80,
  p_lov_disp_value=>'100',
  p_lov_return_value=>'100',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87719230831152004.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>87717417968152000.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>90,
  p_lov_disp_value=>'200',
  p_lov_return_value=>'200',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87719426010152005.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>87717417968152000.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>100,
  p_lov_disp_value=>'500',
  p_lov_return_value=>'500',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87719614892152005.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>87717417968152000.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>110,
  p_lov_disp_value=>'1000',
  p_lov_return_value=>'1000',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87719804628152005.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>87717417968152000.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>120,
  p_lov_disp_value=>'2000',
  p_lov_return_value=>'2000',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/max_rows_c
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 87727319971247226.4053 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'MAX_ROWS_C',
  p_lov_query=> '.'||to_char(87727319971247226 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87727500041247227.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>87727319971247226.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'1',
  p_lov_return_value=>'1',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87727716571247227.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>87727319971247226.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'5',
  p_lov_return_value=>'5',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87727920372247227.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>87727319971247226.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>30,
  p_lov_disp_value=>'10',
  p_lov_return_value=>'10',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87728108070247227.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>87727319971247226.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>40,
  p_lov_disp_value=>'15',
  p_lov_return_value=>'15',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87728307878247228.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>87727319971247226.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>50,
  p_lov_disp_value=>'20',
  p_lov_return_value=>'20',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87728503519247228.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>87727319971247226.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>60,
  p_lov_disp_value=>'25',
  p_lov_return_value=>'25',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87728723800247228.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>87727319971247226.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>70,
  p_lov_disp_value=>'50',
  p_lov_return_value=>'50',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87728931351247228.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>87727319971247226.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>80,
  p_lov_disp_value=>'100',
  p_lov_return_value=>'100',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87729117092247229.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>87727319971247226.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>90,
  p_lov_disp_value=>'200',
  p_lov_return_value=>'200',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87729303121247229.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>87727319971247226.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>100,
  p_lov_disp_value=>'500',
  p_lov_return_value=>'500',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87729526911247229.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>87727319971247226.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>110,
  p_lov_disp_value=>'1000',
  p_lov_return_value=>'1000',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87729730366247229.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>87727319971247226.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>120,
  p_lov_disp_value=>'5000',
  p_lov_return_value=>'5000',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/max_rows_d
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 87730331399250507.4053 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'MAX_ROWS_D',
  p_lov_query=> '.'||to_char(87730331399250507 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87730525692250508.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>87730331399250507.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'1',
  p_lov_return_value=>'1',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87730714234250508.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>87730331399250507.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'5',
  p_lov_return_value=>'5',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87730921624250509.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>87730331399250507.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>30,
  p_lov_disp_value=>'10',
  p_lov_return_value=>'10',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87731129062250509.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>87730331399250507.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>40,
  p_lov_disp_value=>'15',
  p_lov_return_value=>'15',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87731321929250509.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>87730331399250507.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>50,
  p_lov_disp_value=>'20',
  p_lov_return_value=>'20',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87731521610250509.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>87730331399250507.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>60,
  p_lov_disp_value=>'25',
  p_lov_return_value=>'25',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87731715300250510.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>87730331399250507.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>70,
  p_lov_disp_value=>'30',
  p_lov_return_value=>'30',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87731919898250510.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>87730331399250507.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>80,
  p_lov_disp_value=>'50',
  p_lov_return_value=>'50',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87732124808250510.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>87730331399250507.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>90,
  p_lov_disp_value=>'100',
  p_lov_return_value=>'100',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87732326765250510.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>87730331399250507.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>100,
  p_lov_disp_value=>'1000',
  p_lov_return_value=>'1000',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87732513594250511.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>87730331399250507.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>110,
  p_lov_disp_value=>'5000',
  p_lov_return_value=>'5000',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/max_rows_e
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 87733213522254832.4053 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'MAX_ROWS_E',
  p_lov_query=> '.'||to_char(87733213522254832 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87733416419254833.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>87733213522254832.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'1',
  p_lov_return_value=>'1',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87733622113254833.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>87733213522254832.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'5',
  p_lov_return_value=>'5',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87733822263254833.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>87733213522254832.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>30,
  p_lov_disp_value=>'10',
  p_lov_return_value=>'10',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87734024639254833.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>87733213522254832.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>40,
  p_lov_disp_value=>'15',
  p_lov_return_value=>'15',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87734223358254834.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>87733213522254832.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>50,
  p_lov_disp_value=>'20',
  p_lov_return_value=>'20',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87734413410254834.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>87733213522254832.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>60,
  p_lov_disp_value=>'25',
  p_lov_return_value=>'25',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87734626070254834.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>87733213522254832.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>70,
  p_lov_disp_value=>'30',
  p_lov_return_value=>'30',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87734809939254834.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>87733213522254832.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>80,
  p_lov_disp_value=>'50',
  p_lov_return_value=>'50',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87735015995254834.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>87733213522254832.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>90,
  p_lov_disp_value=>'100',
  p_lov_return_value=>'100',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87735225800254835.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>87733213522254832.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>100,
  p_lov_disp_value=>'500',
  p_lov_return_value=>'500',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87735423051254835.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>87733213522254832.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>110,
  p_lov_disp_value=>'1000',
  p_lov_return_value=>'1000',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87735614522254835.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>87733213522254832.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>120,
  p_lov_disp_value=>'10000',
  p_lov_return_value=>'10000',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/max_rows_f
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 87736221141257059.4053 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'MAX_ROWS_F',
  p_lov_query=> '.'||to_char(87736221141257059 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87736411674257059.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>87736221141257059.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'2',
  p_lov_return_value=>'2',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87736631478257060.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>87736221141257059.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'5',
  p_lov_return_value=>'5',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87736801252257060.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>87736221141257059.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>30,
  p_lov_disp_value=>'10',
  p_lov_return_value=>'10',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87737027711257060.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>87736221141257059.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>40,
  p_lov_disp_value=>'15',
  p_lov_return_value=>'15',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87737221803257060.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>87736221141257059.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>50,
  p_lov_disp_value=>'20',
  p_lov_return_value=>'20',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87737414548257062.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>87736221141257059.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>60,
  p_lov_disp_value=>'30',
  p_lov_return_value=>'30',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87737609481257062.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>87736221141257059.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>70,
  p_lov_disp_value=>'50',
  p_lov_return_value=>'50',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87737813226257062.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>87736221141257059.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>80,
  p_lov_disp_value=>'100',
  p_lov_return_value=>'100',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87738032062257063.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>87736221141257059.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>90,
  p_lov_disp_value=>'1000',
  p_lov_return_value=>'1000',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87738230641257063.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>87736221141257059.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>100,
  p_lov_disp_value=>'5000',
  p_lov_return_value=>'5000',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/max_rows_g
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 87738929453259457.4053 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'MAX_ROWS_G',
  p_lov_query=> '.'||to_char(87738929453259457 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87739106498259457.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>87738929453259457.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'1',
  p_lov_return_value=>'1',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87739329779259460.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>87738929453259457.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'5',
  p_lov_return_value=>'5',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87739525994259460.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>87738929453259457.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>30,
  p_lov_disp_value=>'10',
  p_lov_return_value=>'10',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87739719147259460.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>87738929453259457.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>40,
  p_lov_disp_value=>'15',
  p_lov_return_value=>'15',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87739911170259460.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>87738929453259457.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>50,
  p_lov_disp_value=>'20',
  p_lov_return_value=>'20',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87740103875259461.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>87738929453259457.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>60,
  p_lov_disp_value=>'25',
  p_lov_return_value=>'25',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87740303300259461.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>87738929453259457.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>70,
  p_lov_disp_value=>'50',
  p_lov_return_value=>'50',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87740516812259461.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>87738929453259457.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>80,
  p_lov_disp_value=>'100',
  p_lov_return_value=>'100',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87740731715259461.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>87738929453259457.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>90,
  p_lov_disp_value=>'200',
  p_lov_return_value=>'200',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87740924006259462.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>87738929453259457.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>100,
  p_lov_disp_value=>'500',
  p_lov_return_value=>'500',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87741116404259462.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>87738929453259457.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>110,
  p_lov_disp_value=>'1000',
  p_lov_return_value=>'1000',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87741300621259463.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>87738929453259457.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>120,
  p_lov_disp_value=>'5000',
  p_lov_return_value=>'5000',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/max_rows_h
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 87745327899296842.4053 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'MAX_ROWS_H',
  p_lov_query=> '.'||to_char(87745327899296842 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87745524146296844.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>87745327899296842.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'1',
  p_lov_return_value=>'1',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87745725148296845.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>87745327899296842.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'5',
  p_lov_return_value=>'5',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87745929261296845.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>87745327899296842.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>30,
  p_lov_disp_value=>'10',
  p_lov_return_value=>'10',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87746105830296845.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>87745327899296842.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>40,
  p_lov_disp_value=>'15',
  p_lov_return_value=>'15',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87746317502296845.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>87745327899296842.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>50,
  p_lov_disp_value=>'20',
  p_lov_return_value=>'20',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87746523232296846.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>87745327899296842.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>60,
  p_lov_disp_value=>'50',
  p_lov_return_value=>'50',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87746716198296846.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>87745327899296842.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>70,
  p_lov_disp_value=>'100',
  p_lov_return_value=>'100',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87746907159296846.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>87745327899296842.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>80,
  p_lov_disp_value=>'500',
  p_lov_return_value=>'500',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87747109934296846.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>87745327899296842.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>90,
  p_lov_disp_value=>'1000',
  p_lov_return_value=>'1000',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87747307992296846.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>87745327899296842.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>100,
  p_lov_disp_value=>'5000',
  p_lov_return_value=>'5000',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/new_or_existing
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 87820927180096887.4053 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'NEW_OR_EXISTING',
  p_lov_query=> '.'||to_char(87820927180096887 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87821100243096888.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>87820927180096887.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Vorhanden',
  p_lov_return_value=>'Existing',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87821304136096888.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>87820927180096887.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'Neu',
  p_lov_return_value=>'New',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/p16_printsvr_protocol
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 41576101209699161.4053 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'P16.PRINTSVR.PROTOCOL',
  p_lov_query=> '.'||to_char(41576101209699161 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>41576425139699162.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>41576101209699161.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'HTTP',
  p_lov_return_value=>'http',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>41576620353699162.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>41576101209699161.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'HTTPS',
  p_lov_return_value=>'https',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/page_view_mode
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 131020216973707367.4053 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'PAGE VIEW MODE',
  p_lov_query=> '.'||to_char(131020216973707367 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>131020902774707369.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>131020216973707367.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Dynamische Seite',
  p_lov_return_value=>'D',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>131020730367707369.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>131020216973707367.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Seitenverarbeitung',
  p_lov_return_value=>'A',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>131020524068707368.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>131020216973707367.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3,
  p_lov_disp_value=>'Seitenbestandteile',
  p_lov_return_value=>'P',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>131023120221717730.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>131020216973707367.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>4,
  p_lov_disp_value=>'Cache erstellt',
  p_lov_return_value=>'C',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>131023727840719977.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>131020216973707367.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>5,
  p_lov_disp_value=>'Gecachte Seite',
  p_lov_return_value=>'R',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/project_status
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 87715313766122404.4053 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'PROJECT.STATUS',
  p_lov_query=> '.'||to_char(87715313766122404 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87715507041122405.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>87715313766122404.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Abgelehnt',
  p_lov_return_value=>'DECLINED',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87715706617122406.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>87715313766122404.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'Angefordert',
  p_lov_return_value=>'REQUESTED',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87715911749122406.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>87715313766122404.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>30,
  p_lov_disp_value=>'Beendet',
  p_lov_return_value=>'TERMINATED',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/provisioning_status
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 87819917137094037.4053 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'PROVISIONING.STATUS',
  p_lov_query=> '.'||to_char(87819917137094037 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87820106497094037.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>87819917137094037.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'<b>Manuell</b>: Jeder Workspace wird von einem Administrator manuell erstellt',
  p_lov_return_value=>'MANUAL',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87820317112094038.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>87819917137094037.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'<b>Anfordern</b>: Die Benutzer können über den Link auf der Anmeldeseite Workspaces anfordern',
  p_lov_return_value=>'4700',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>27774028242361017.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>87819917137094037.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>30,
  p_lov_disp_value=>'E-Mail-Verifizierung - Workspace wurde erstellt, nachdem die E-Mail-Adresse vom Benutzer überprüft wurde',
  p_lov_return_value=>'EMAIL',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/public_theme_app_selector
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 138968902616481833.4053 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'PUBLIC.THEME.APP.SELECTOR',
  p_lov_query=> 'select id || '' - '' || name d, id v'||chr(10)||
'  from WWV_FLOWS'||chr(10)||
' where security_group_id = :P47_WORKSPACE'||chr(10)||
'   and security_group_id not in (0,10,11)'||chr(10)||
' order by 1');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/recent_time
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 88332700235936298.4053 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'RECENT_TIME',
  p_lov_query=> 'select ''10 ''||wwv_flow_lang.system_message(initcap(''SECONDS'')) d, 10/(24*60*60) t from dual union all'||chr(10)||
'select ''1 ''||wwv_flow_lang.system_message(initcap(''MINUTE'')) d, 1/(24*60) t from dual union all'||chr(10)||
'select ''5 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 5/(24*60) t from dual union all'||chr(10)||
'select ''15 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 15/(24*60) t from dual union all'||chr(10)||
'select ''30 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 30/(24*60) t from dual union all'||chr(10)||
'select ''1 ''||wwv_flow_lang.system_message(initcap(''HOUR'')) d, 1/24 t from dual union all'||chr(10)||
'select ''2 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 1/12  t from dual union all'||chr(10)||
'select ''6 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 6/24 t from dual union all'||chr(10)||
'select ''8 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 8/24 t from dual union all'||chr(10)||
'select ''1 ''||wwv_flow_lang.system_message(initcap(''DAY'')) d, 1 t from dual union all'||chr(10)||
'select ''2 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 2 t from dual union all'||chr(10)||
'select ''1 ''||wwv_flow_lang.system_message(initcap(''WEEK'')) d, 7 t  from dual union all'||chr(10)||
'select ''2 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 14 t  from dual union all'||chr(10)||
'select ''4 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 28 t from dual union all'||chr(10)||
'select ''1 ''||wwv_flow_lang.system_message(initcap(''YEAR'')) d, 365 t from dual order by 2');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/request_status_show
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 87760131282243533.4053 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'REQUEST.STATUS.SHOW',
  p_lov_query=> '.'||to_char(87760131282243533 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87760332362243533.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>87760131282243533.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Alle',
  p_lov_return_value=>'All',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87760505501243533.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>87760131282243533.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'Genehmigt',
  p_lov_return_value=>'Approved',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87760729237243534.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>87760131282243533.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>30,
  p_lov_disp_value=>'Abgelehnt',
  p_lov_return_value=>'Denied',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87760900898243534.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>87760131282243533.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>40,
  p_lov_disp_value=>'Öffnen',
  p_lov_return_value=>'Open',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/seconds
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 265067300720195470.4053 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'SECONDS',
  p_lov_query=> '.'||to_char(265067300720195470 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>265067629517195484.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>265067300720195470.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>0,
  p_lov_disp_value=>'10 Sekunden',
  p_lov_return_value=>'10',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>265067827328195487.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>265067300720195470.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'1 Minute',
  p_lov_return_value=>'60',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>265068021323195487.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>265067300720195470.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'10 Minuten',
  p_lov_return_value=>'600',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>265068228775195487.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>265067300720195470.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>30,
  p_lov_disp_value=>'30 Minuten',
  p_lov_return_value=>'1800',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>265068421421195487.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>265067300720195470.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>40,
  p_lov_disp_value=>'1 Stunde',
  p_lov_return_value=>'3600',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>265068624219195487.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>265067300720195470.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>50,
  p_lov_disp_value=>'2 Stunden',
  p_lov_return_value=>'7200',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>265068819677195487.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>265067300720195470.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>60,
  p_lov_disp_value=>'3 Stunden',
  p_lov_return_value=>'10800',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>265069021642195487.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>265067300720195470.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>70,
  p_lov_disp_value=>'4 Stunden',
  p_lov_return_value=>'14400',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>265069228778195487.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>265067300720195470.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>80,
  p_lov_disp_value=>'6 Stunden',
  p_lov_return_value=>'21600',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>265069416024195488.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>265067300720195470.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>90,
  p_lov_disp_value=>'12 Stunden',
  p_lov_return_value=>'43200',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>265069601479195488.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>265067300720195470.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>100,
  p_lov_disp_value=>'1 Tag',
  p_lov_return_value=>'86400',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>265069803740195488.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>265067300720195470.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>110,
  p_lov_disp_value=>'2 Tage',
  p_lov_return_value=>'172800',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>265070017856195488.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>265067300720195470.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>120,
  p_lov_disp_value=>'3 Tage',
  p_lov_return_value=>'259200',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>265070226433195488.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>265067300720195470.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>130,
  p_lov_disp_value=>'4 Tage',
  p_lov_return_value=>'345600',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>265070406606195488.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>265067300720195470.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>140,
  p_lov_disp_value=>'1 Woche',
  p_lov_return_value=>'604800',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>265070622658195488.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>265067300720195470.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>150,
  p_lov_disp_value=>'2 Wochen',
  p_lov_return_value=>'1209600',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>265070800909195488.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>265067300720195470.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>155,
  p_lov_disp_value=>'4 Wochen',
  p_lov_return_value=>'2419200',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>265071009072195488.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>265067300720195470.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>160,
  p_lov_disp_value=>'10 Wochen',
  p_lov_return_value=>'6048000',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>265071213825195488.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>265067300720195470.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>170,
  p_lov_disp_value=>'1 Jahr',
  p_lov_return_value=>'31536000',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/service_request_name
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 110368323210290856.4053 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'SERVICE.REQUEST.NAME',
  p_lov_query=> '.'||to_char(110368323210290856 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>110368501503290856.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>110368323210290856.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Neues Schema',
  p_lov_return_value=>'NEW_SCHEMA',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>110368723358290857.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>110368323210290856.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Workspace entfernen',
  p_lov_return_value=>'REMOVE_EXISTING_SERVICE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>110368924348290857.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>110368323210290856.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>3,
  p_lov_disp_value=>'Schema entfernen',
  p_lov_return_value=>'REMOVE_EXISTING_SCHEMA',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>110369132258290857.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>110368323210290856.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>4,
  p_lov_disp_value=>'Speicherplatz anfordern',
  p_lov_return_value=>'CHANGE_DB_SIZE',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/service_request_status
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 87755726864223308.4053 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'SERVICE.REQUEST.STATUS',
  p_lov_query=> '.'||to_char(87755726864223308 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87755910389223309.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>87755726864223308.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Genehmigt',
  p_lov_return_value=>'APPROVED',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87756108879223309.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>87755726864223308.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'Abgelehnt',
  p_lov_return_value=>'DECLINED',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87756328524223309.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>87755726864223308.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>30,
  p_lov_disp_value=>'In Bearbeitung',
  p_lov_return_value=>'IN_PROGRESS',
  p_lov_disp_cond_type=>'CURRENT_PAGE_NOT_EQUAL_CONDITION',
  p_lov_disp_cond=> '26',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87756529293223310.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>87755726864223308.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>40,
  p_lov_disp_value=>'Angefordert',
  p_lov_return_value=>'REQUESTED',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87756716926223310.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>87755726864223308.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>50,
  p_lov_disp_value=>'Beendet',
  p_lov_return_value=>'TERMINATED',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>22138608522000517.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>87755726864223308.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>60,
  p_lov_disp_value=>'Akzeptiert',
  p_lov_return_value=>'ACCEPTED',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/site_admin_password_option
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 25698924524085246.4053 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'SITE ADMIN PASSWORD OPTION',
  p_lov_query=> '.'||to_char(25698924524085246 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>89831430148813773.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>25698924524085246.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Policy verwenden, die in der Policy für das Workspace-Kennwort angegeben ist',
  p_lov_return_value=>'N',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>25699227500085250.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>25698924524085246.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Starke Standard-Kennwortrichtlinie verwenden',
  p_lov_return_value=>'Y',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/task_display_location
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 75242612126455451.4053 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'TASK_DISPLAY_LOCATION',
  p_lov_query=> '.'||to_char(75242612126455451 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>75243106849455455.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>75242612126455451.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Workspace-Anmeldung',
  p_lov_return_value=>'WORKSPACE_LOGIN',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>75242903496455454.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>75242612126455451.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Workspace-Homepage',
  p_lov_return_value=>'WORKSPACE_HOME',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/time_intervals
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 87720511660244788.4053 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'TIME_INTERVALS',
  p_lov_query=> '.'||to_char(87720511660244788 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87720705217244789.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>87720511660244788.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'1',
  p_lov_return_value=>'1',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87720918270244790.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>87720511660244788.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'2',
  p_lov_return_value=>'2',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87721128398244790.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>87720511660244788.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>30,
  p_lov_disp_value=>'3',
  p_lov_return_value=>'3',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87721316635244790.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>87720511660244788.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>40,
  p_lov_disp_value=>'4',
  p_lov_return_value=>'4',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87721518511244790.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>87720511660244788.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>50,
  p_lov_disp_value=>'5',
  p_lov_return_value=>'5',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87721714192244790.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>87720511660244788.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>60,
  p_lov_disp_value=>'6',
  p_lov_return_value=>'6',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87721929981244791.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>87720511660244788.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>70,
  p_lov_disp_value=>'7',
  p_lov_return_value=>'7',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87722127765244791.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>87720511660244788.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>80,
  p_lov_disp_value=>'8',
  p_lov_return_value=>'8',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87722317438244791.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>87720511660244788.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>90,
  p_lov_disp_value=>'9',
  p_lov_return_value=>'9',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87722509755244791.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>87720511660244788.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>100,
  p_lov_disp_value=>'10',
  p_lov_return_value=>'10',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87722724680244792.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>87720511660244788.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>110,
  p_lov_disp_value=>'11',
  p_lov_return_value=>'11',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87722931920244792.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>87720511660244788.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>120,
  p_lov_disp_value=>'12',
  p_lov_return_value=>'12',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87723110878244792.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>87720511660244788.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>130,
  p_lov_disp_value=>'13',
  p_lov_return_value=>'13',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87723310283244792.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>87720511660244788.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>140,
  p_lov_disp_value=>'14',
  p_lov_return_value=>'14',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87723528574244793.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>87720511660244788.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>150,
  p_lov_disp_value=>'15',
  p_lov_return_value=>'15',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87723715299244793.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>87720511660244788.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>160,
  p_lov_disp_value=>'16',
  p_lov_return_value=>'16',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87723913501244793.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>87720511660244788.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>170,
  p_lov_disp_value=>'17',
  p_lov_return_value=>'17',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87724129057244793.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>87720511660244788.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>180,
  p_lov_disp_value=>'18',
  p_lov_return_value=>'18',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87724326333244793.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>87720511660244788.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>190,
  p_lov_disp_value=>'19',
  p_lov_return_value=>'19',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87724500227244794.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>87720511660244788.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>200,
  p_lov_disp_value=>'20',
  p_lov_return_value=>'20',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87724715549244794.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>87720511660244788.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>210,
  p_lov_disp_value=>'21',
  p_lov_return_value=>'21',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87724919187244794.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>87720511660244788.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>220,
  p_lov_disp_value=>'22',
  p_lov_return_value=>'22',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87725132288244794.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>87720511660244788.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>230,
  p_lov_disp_value=>'23',
  p_lov_return_value=>'23',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87725315196244795.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>87720511660244788.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>240,
  p_lov_disp_value=>'24',
  p_lov_return_value=>'24',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87725519222244795.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>87720511660244788.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>250,
  p_lov_disp_value=>'25',
  p_lov_return_value=>'25',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87725726981244795.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>87720511660244788.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>260,
  p_lov_disp_value=>'26',
  p_lov_return_value=>'26',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87725929193244795.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>87720511660244788.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>270,
  p_lov_disp_value=>'27',
  p_lov_return_value=>'27',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87726105331244796.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>87720511660244788.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>280,
  p_lov_disp_value=>'28',
  p_lov_return_value=>'28',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87726330087244796.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>87720511660244788.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>290,
  p_lov_disp_value=>'29',
  p_lov_return_value=>'29',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87726525128244796.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>87720511660244788.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>300,
  p_lov_disp_value=>'30',
  p_lov_return_value=>'30',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87726708945244797.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>87720511660244788.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>310,
  p_lov_disp_value=>'31',
  p_lov_return_value=>'31',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/user_groups
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 161727824824923998.4053 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'USER.GROUPS',
  p_lov_query=> 'select htf.escape_sc(group_name) d, id r'||chr(10)||
'from wwv_flow_fnd_user_groups'||chr(10)||
'where security_group_id = :F4050_P23_SECURITY_GROUP_ID order by 1');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/view_as_list_or_icons
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 138021018445611867.4053 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'VIEW AS LIST OR ICONS',
  p_lov_query=> '.'||to_char(138021018445611867 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>138021303911611867.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>138021018445611867.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'Symbole',
  p_lov_return_value=>'ICON',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>138021517322611867.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>138021018445611867.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>30,
  p_lov_disp_value=>'Details',
  p_lov_return_value=>'DETAIL',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/ws_provisioning_status
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 113228404836854036.4053 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'WS_PROVISIONING_STATUS',
  p_lov_query=> '.'||to_char(113228404836854036 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>113228711736854036.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>113228404836854036.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Aktiviert',
  p_lov_return_value=>'N',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>113228921295854036.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>113228404836854036.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Deaktiviert',
  p_lov_return_value=>'Y',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/yes_no_returns_yes_or_no
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 110344620122166929.4053 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'YES NO RETURNS YES OR NO',
  p_lov_query=> '.'||to_char(110344620122166929 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>110344806562166931.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>110344620122166929.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>1,
  p_lov_disp_value=>'Ja',
  p_lov_return_value=>'YES',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>110345012767166934.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>110344620122166929.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>2,
  p_lov_disp_value=>'Nein',
  p_lov_return_value=>'NO',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/yes_no_returns_1_or_0
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 87817312158083090.4053 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'YES.NO.RETURNS.1_OR_0',
  p_lov_query=> '.'||to_char(87817312158083090 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87817530004083091.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>87817312158083090.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Nein',
  p_lov_return_value=>'0',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>87817713905083091.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>87817312158083090.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'Ja',
  p_lov_return_value=>'1',
  p_lov_data_comment=> '');
 
null;
 
end;
/

--application/shared_components/user_interface/lov/yes_no_returns_y_or_n
 
begin
 
wwv_flow_api.create_list_of_values (
  p_id       => 157992123774592395.4053 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_lov_name => 'YES_NO_RETURNS_Y_OR_N',
  p_lov_query=> '.'||to_char(157992123774592395 + wwv_flow_api.g_id_offset)||'.');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>157992405775592399.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>157992123774592395.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>10,
  p_lov_disp_value=>'Ja',
  p_lov_return_value=>'Y',
  p_lov_data_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_static_lov_data (
  p_id=>157992613021592401.4053 + wwv_flow_api.g_id_offset,
  p_lov_id=>157992123774592395.4053 + wwv_flow_api.g_id_offset,
  p_lov_disp_sequence=>20,
  p_lov_disp_value=>'Nein',
  p_lov_return_value=>'N',
  p_lov_data_comment=> '');
 
null;
 
end;
/

prompt  ...Application Trees
--
--application/pages/page_groups
prompt  ...page groups
--
 
begin
 
null;
 
end;
/

 
--application/pages/page_.4053
prompt  ...PAGE .4053: Null
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h := null;
ph := null;
wwv_flow_api.create_page(
  p_id     => .4053,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'Null',
  p_step_title=> 'Null',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'NO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_help_text => '',
  p_html_page_header => '',
  p_step_template => '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409160248',
  p_page_comment  => '');
 
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'40102013671283832';

wwv_flow_api.create_page_plug (
  p_id=> 40103228562288155.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> .4053,
  p_plug_name=> 'Tabs',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 10,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_07',
  p_plug_source=> s,
  p_plug_source_type=> 40102013671283832 + wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
null;
 
end;
/

 
begin
 
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page .4053
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_1.405
prompt  ...PAGE 1.4053: Vorhandene Workspaces
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEADM/adm_wrkspc_existing.htm';

ph := null;
wwv_flow_api.create_page(
  p_id     => 1.4053,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'Vorhandene Workspaces',
  p_step_title=> 'Vorhandene Workspaces',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'AUTO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 216765317551591446+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => '',
  p_step_template => 19236405723931959.4053+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409160248',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>1.4053,p_text=>h);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'<p>Auf dieser Seite können Sie die Workspaces suchen, die durch Provisioning bereitgestellt wurden. Klicken Sie auf einen Workspace-Namen, um einen detaillierten Bericht zu einem bestimmten Workspace aufzurufen. Klicken Sie in der Spalte für die Aktion auf <b>Löschen</b>, um den Assistenten zum Entfernen von Workspaces zu starten.</p>';

wwv_flow_api.create_page_plug (
  p_id=> 24550226216.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 1.4053,
  p_plug_name=> 'Workspaces',
  p_region_name=>'',
  p_plug_template=> 79623830123907946.4053+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 10,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_03',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> 'Unable to display page region #SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> 'Region generated by create flow wizard');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 4738629702933373.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 1.4053,
  p_plug_name=> 'Menu',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(4585800473139662 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 4589126493175495.4053+ wwv_flow_api.g_id_offset,
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 190755626440439097.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 1.4053,
  p_plug_name=> 'Button Box',
  p_region_name=>'',
  p_plug_template=> 107311831567346457.4053+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings => 'blue_arrow_down.gif::blue_arrow_up.gif:|3,3,4\1,2|'||chr(10)||
''||chr(10)||
'&nbsp;:'||chr(10)||
''||chr(10)||
'<font class="nounderline" color="black">CompanyShortName</font>:'||chr(10)||
''||chr(10)||
'<font class="nounderline" color="green">Users</font>:'||chr(10)||
''||chr(10)||
'<font class="nounderline" color="green">Developers</font>:'||chr(10)||
''||chr(10)||
'<font class="nounderline" color="green">Flows</font>:<font color=green>ProvStatus</font>:'||chr(10)||
''||chr(10)||
'<font class="nounderline" color="black">CompanyID</font>:',
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_num_rows => 25,
  p_plug_query_num_rows_item => 'F4050_P1_ROWS',
  p_plug_query_num_rows_type => 'ROWS_X_TO_Y_OF_Z',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_query_show_nulls_as => '(null)',
  p_plug_query_col_allignments => 'L:L:L:L:R:R:R:L',
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'select'||chr(10)||
'    short_name,'||chr(10)||
'    (select count(*) from wwv_flow_fnd_user where  SECURITY_GROUP_ID = c.PROVISIONING_COMPANY_ID) c, '||chr(10)||
'    (select count(*) c from wwv_flow_developers where security_group_id=c.PROVISIONING_COMPANY_ID) d,'||chr(10)||
'    (select count(*) c from wwv_flows where security_group_id = c.PROVISIONING_COMPANY_ID) f,'||chr(10)||
'    (select project_status from wwv_flow_provision_company where security_group';

s:=s||'_id=c.PROVISIONING_COMPANY_ID) status,'||chr(10)||
'    (select project_approval_date from wwv_flow_provision_company where security_group_id=c.PROVISIONING_COMPANY_ID) provision_date,'||chr(10)||
'    PROVISIONING_COMPANY_ID,'||chr(10)||
'  decode('||chr(10)||
'  provisioning_company_id,'||chr(10)||
'  ''10'','||chr(10)||
'  '' '','||chr(10)||
'  ''<a href="f?p=4050:81:''||:flow_session||'||chr(10)||
'  '':BRANCH_TO_PAGE_ACCEPT|NEXT::81,82:P81_COMPANY:''||'||chr(10)||
'        wwv_flow_utilities.escape_url(short_name,n';

s:=s||'ull,''Y'')||''">''||'||chr(10)||
'        wwv_flow_lang.system_message(''F4350.DELETE''))||''</a>'' delete_me'||chr(10)||
'from   WWV_FLOW_COMPANIES c '||chr(10)||
'where short_name <> ''Unknown'' '||chr(10)||
'  and provisioning_company_id != 11'||chr(10)||
'  and (:P1_SEARCH is null or'||chr(10)||
'       upper(short_name) like ''%''||upper(:P1_SEARCH)||''%'')';

wwv_flow_api.create_report_region (
  p_id=> 193842626747469150.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 1.4053,
  p_name=> 'Workspaces',
  p_region_name=>'',
  p_template=> 0+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 50,
  p_display_column=> 1,
  p_display_point=> 'AFTER_SHOW_ITEMS',
  p_source=> s,
  p_source_type=> 'SQL_QUERY',
  p_display_error_message=> '#SQLERRM#',
  p_plug_caching=> 'NOT_CACHED',
  p_customized=> '0',
  p_ajax_enabled=> 'N',
  p_query_row_template=> 6897002870390711.4053+ wwv_flow_api.g_id_offset,
  p_query_headings_type=> 'COLON_DELMITED_LIST',
  p_query_num_rows=> '15',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_show_nulls_as=> '(null)',
  p_query_break_cols=> '0',
  p_query_no_data_found=> 'Keine Daten gefunden.',
  p_query_num_rows_item=> 'F4050_P1_ROWS',
  p_query_num_rows_type=> 'ROW_RANGES_WITH_LINKS',
  p_query_row_count_max=> '500',
  p_pagination_display_position=> 'BOTTOM_RIGHT',
  p_csv_output=> 'Y',
  p_csv_output_link_text=> 'Herunterladen',
  p_prn_output=> 'Y',
  p_prn_format=> 'PDF',
  p_prn_output_show_link=> 'Y',
  p_prn_output_link_text=> 'Drucken',
  p_prn_units=> 'INCHES',
  p_prn_paper_size=> 'LETTER',
  p_prn_width=> 11,
  p_prn_height=> 8.5,
  p_prn_orientation=> 'HORIZONTAL',
  p_prn_page_header=> '&PRODUCT_NAME.',
  p_prn_page_header_font_color=> '#000000',
  p_prn_page_header_font_family=> 'Helvetica',
  p_prn_page_header_font_weight=> 'normal',
  p_prn_page_header_font_size=> '12',
  p_prn_page_footer_font_color=> '#000000',
  p_prn_page_footer_font_family=> 'Helvetica',
  p_prn_page_footer_font_weight=> 'normal',
  p_prn_page_footer_font_size=> '12',
  p_prn_header_bg_color=> '#9bafde',
  p_prn_header_font_color=> '#ffffff',
  p_prn_header_font_family=> 'Helvetica',
  p_prn_header_font_weight=> 'normal',
  p_prn_header_font_size=> '8',
  p_prn_body_bg_color=> '#efefef',
  p_prn_body_font_color=> '#000000',
  p_prn_body_font_family=> 'Helvetica',
  p_prn_body_font_weight=> 'normal',
  p_prn_body_font_size=> '8',
  p_prn_border_width=> .25,
  p_query_asc_image=> 'arrow_down_gray_dark.gif',
  p_query_asc_image_attr=> 'width="13" height="12"',
  p_query_desc_image=> 'arrow_up_gray_dark.gif',
  p_query_desc_image_attr=> 'width="13" height="12"',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48794528128772256.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 193842626747469150.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'SHORT_NAME',
  p_column_display_sequence=> 1,
  p_column_heading=> 'Workspace-Name',
  p_column_link=>'f?p=&APP_ID.:14:&SESSION.:REPORT:&DEBUG.:14:SGID:#PROVISIONING_COMPANY_ID#',
  p_column_linktext=>'#SHORT_NAME#',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_print_col_width=> '21',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48794610711772256.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 193842626747469150.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'C',
  p_column_display_sequence=> 2,
  p_column_heading=> 'Benutzer',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>1,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_include_in_export=> 'Y',
  p_print_col_width=> '12',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48794726108772256.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 193842626747469150.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 3,
  p_form_element_id=> null,
  p_column_alias=> 'D',
  p_column_display_sequence=> 3,
  p_column_heading=> 'Entwickler',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>3,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_include_in_export=> 'Y',
  p_print_col_width=> '12',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48794802929772256.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 193842626747469150.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 4,
  p_form_element_id=> null,
  p_column_alias=> 'F',
  p_column_display_sequence=> 4,
  p_column_heading=> 'Anwendung',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'RIGHT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_include_in_export=> 'Y',
  p_print_col_width=> '12',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48794918362772256.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 193842626747469150.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 5,
  p_form_element_id=> null,
  p_column_alias=> 'STATUS',
  p_column_display_sequence=> 5,
  p_column_heading=> 'Provisioning-Status',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'RIGHT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_include_in_export=> 'Y',
  p_print_col_width=> '18',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48795002361772257.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 193842626747469150.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 6,
  p_form_element_id=> null,
  p_column_alias=> 'PROVISION_DATE',
  p_column_display_sequence=> 6,
  p_column_heading=> 'Provisioning-Datum',
  p_column_format=> '&DATE_TIME_FORMAT.',
  p_column_css_style=>'white-space: nowrap;',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'RIGHT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_include_in_export=> 'Y',
  p_print_col_width=> '18',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48795128574772257.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 193842626747469150.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 7,
  p_form_element_id=> null,
  p_column_alias=> 'PROVISIONING_COMPANY_ID',
  p_column_display_sequence=> 7,
  p_column_heading=> 'Workspace ID',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_include_in_export=> 'N',
  p_print_col_width=> '0',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48795218806772257.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 193842626747469150.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 8,
  p_form_element_id=> null,
  p_column_alias=> 'DELETE_ME',
  p_column_display_sequence=> 8,
  p_column_heading=> 'Aktion',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_include_in_export=> 'N',
  p_print_col_width=> '0',
  p_column_comment=>'');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 5495805493730213.4053 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 1.4053,
  p_button_sequence=> 10,
  p_button_plug_id => 190755626440439097+wwv_flow_api.g_id_offset,
  p_button_name    => 'CREATE_COMPANY',
  p_button_image_alt=> 'Workspace erstellen &gt;',
  p_button_position=> 'REGION_TEMPLATE_CREATE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=&FLOW_ID.:27:&SESSION.::&DEBUG.:27,72,79::',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>24599238284.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 1.4053,
  p_branch_action=> '1',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'BRANCH_TO_STEP',
  p_branch_sequence=> 99,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Geben Sie eine Abfrage ohne Berücksichtigung der Groß-/Kleinschreibung ein, und klicken Sie anschließend auf <b>Los</b>.';

wwv_flow_api.create_page_item(
  p_id=>24644364694.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 1.4053,
  p_name=>'P1_SEARCH',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 1009,
  p_item_plug_id => 190755626440439097.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Suche',
  p_source_type=> 'STATIC',
  p_display_as=> 'TEXT',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 343399818250317904.4053+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>24648370307.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 1.4053,
  p_name=>'F4050_P1_GO',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 1019,
  p_item_plug_id => 190755626440439097.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default => 'GO',
  p_prompt=>'Los',
  p_source=>'GO',
  p_source_type=> 'STATIC',
  p_display_as=> 'BUTTON',
  p_lov_columns=> null,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> 2000,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'LEFT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Wählen Sie die Anzahl der Zeilen, die angezeigt werden sollen, und klicken Sie anschließend auf <b>Los</b>.';

wwv_flow_api.create_page_item(
  p_id=>81354710204276887.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 1.4053,
  p_name=>'F4050_P1_ROWS',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 1010,
  p_item_plug_id => 190755626440439097.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Anzeigen',
  p_source=>'15',
  p_source_type=> 'STATIC',
  p_display_as=> 'COMBOBOX',
  p_named_lov=> 'MAX_ROWS_A',
  p_lov => '.'||to_char(87504531900192794 + wwv_flow_api.g_id_offset)||'.',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'LEFT',
  p_field_alignment  => 'LEFT',
  p_field_template => 343399818250317904.4053+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_computation(
  p_id=> 24601238285.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 1.4053,
  p_computation_sequence => 1,
  p_computation_item=> 'F4050_P2_ID',
  p_computation_point=> 'AFTER_SUBMIT',
  p_computation_type=> 'STATIC_ASSIGNMENT',
  p_computation_processed=> 'REPLACE_EXISTING',
  p_computation=> '',
  p_computation_comment=> 'Set the value of the item conainting the primary key to null when asked to create a new row.',
  p_compute_when => 'CREATE_ROW',
  p_compute_when_type=>'REQUEST_EQUALS_CONDITION');
 
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'reset_pagination';

wwv_flow_api.create_page_process(
  p_id     => 104317715949674713.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 1.4053,
  p_process_sequence=> 10,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'RESET_PAGINATION',
  p_process_name=> 'Reset Pagination',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_when=>':REQUEST is null or :REQUEST = ''GO''',
  p_process_when_type=>'PLSQL_EXPRESSION',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 1.4053
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_3.405
prompt  ...PAGE 3.4053: Administration Services für Application Express
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEADM/adm_wrkspc.htm';

ph := null;
wwv_flow_api.create_page(
  p_id     => 3.4053,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'Administration Services für Application Express',
  p_step_title=> 'Administration Services für Application Express',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'AUTO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 216800021154677630+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => '',
  p_step_template => 19236405723931959.4053+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409160248',
  p_page_is_public_y_n=> 'N',
  p_protection_level=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>3.4053,p_text=>h);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'Diese Seite bietet Zugriff auf die Administrations-Tasks für den &PRODUCT_NAME.-Service.';

wwv_flow_api.create_page_plug (
  p_id=> 118635692071.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 3.4053,
  p_plug_name=> 'Administration',
  p_region_name=>'',
  p_plug_template=> 79623830123907946.4053+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 5,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_03',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top" align="right"',
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 4597204638216479.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 3.4053,
  p_plug_name=> 'Menu',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 30,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(4585800473139662 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 4589126493175495.4053+ wwv_flow_api.g_id_offset,
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'5953426056662285';

wwv_flow_api.create_page_plug (
  p_id=> 6030412819853676.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 3.4053,
  p_plug_name=> 'Administration Menu',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 5953426056662285 + wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'htp.p(''<ul class="noIndent">'');'||chr(10)||
''||chr(10)||
'if nvl(wwv_flow_platform.get_preference(''SERVICE_REQUEST_FLOW''),''MANUAL'') <> ''MANUAL'' then '||chr(10)||
'htp.prn(''<li>''||wwv_flow_lang.system_message(''4050_3_SERVICE_REQUESTS'')||''<br />(<b><a href="f?p=4050:26:''||:flow_session||''::::F4050_P26_STATUS:0">'');'||chr(10)||
'htp.prn(wwv_flow_provisioning.total_service_requests);'||chr(10)||
'htp.prn(''</a>, <a href="f?p=4050:26:''||:flow_session||''::::F4050_P26';

s:=s||'_STATUS:REQUESTED">'');'||chr(10)||
'htp.prn(wwv_flow_provisioning.total_open_service_requests);'||chr(10)||
'htp.p(''</a></b> ''||wwv_flow_lang.system_message(''PENDING'')||'')</li>'');'||chr(10)||
'end if;'||chr(10)||
'--'||chr(10)||
'htp.prn(''<li>''||wwv_flow_lang.system_message(''4050_3_CHANGE_REQUESTS'')||''<br />(<b><a href="f?p=4050:28:''||:flow_session||''::::F4050_P28_STATUS:0">'');'||chr(10)||
'htp.prn(wwv_flow_provisioning.total_change_requests);'||chr(10)||
'htp.prn(''</a>, <a href="f?p=40';

s:=s||'50:28:&SESSION.::::F4050_P28_STATUS:REQUESTED">'');'||chr(10)||
'htp.prn(wwv_flow_provisioning.total_open_change_requests);'||chr(10)||
'htp.p(''</a></b> ''||wwv_flow_lang.system_message(''PENDING'')||'')</li>'');'||chr(10)||
''||chr(10)||
'--'||chr(10)||
'htp.p(''</ul>'');';

wwv_flow_api.create_page_plug (
  p_id=> 75828712782181553.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 3.4053,
  p_plug_name=> 'Benachrichtigungen',
  p_region_name=>'',
  p_plug_template=> 31640708314725266.4053+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 10,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_03',
  p_plug_source=> s,
  p_plug_source_type=> 'PLSQL_PROCEDURE',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top" align="right"',
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_required_patch=> '-739403989402288.4053' + wwv_flow_api.g_id_offset,
  p_plug_comment=> '');
end;
/
 
begin
 
null;
 
end;
/

 
begin
 
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'F4050_P72_ADMIN_PASS,F4050_P79_SCHEMA_PASSWORD,F4050_P23_WEB_PASSWORD,F4050_P53_PASSWORD,P106_PASSWORD,P277_SCHEMA_PASSWORD';

wwv_flow_api.create_page_process(
  p_id     => 359767105825562475.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 3.4053,
  p_process_sequence=> 10,
  p_process_point=> 'BEFORE_HEADER',
  p_process_type=> 'CLEAR_CACHE_FOR_ITEMS',
  p_process_name=> 'clear',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 3.4053
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_4.405
prompt  ...PAGE 4.4053: Provisioning-Administration
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEADM/adm_create_wkspc.htm';

ph := null;
wwv_flow_api.create_page(
  p_id     => 4.4053,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'Provisioning-Administration',
  p_step_title=> 'Provisioning-Administration',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'AUTO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 216766430018595041+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => '',
  p_step_template => 12930201930057128.4053+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409160248',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>4.4053,p_text=>h);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'select     '||chr(10)||
'    COMPANY_NAME,'||chr(10)||
'    ADMIN_FIRST_NAME,'||chr(10)||
'    ADMIN_LAST_NAME,'||chr(10)||
'    ADMIN_TITLE,'||chr(10)||
'    ADMIN_EMAIL,'||chr(10)||
'    ADMIN_PHONE,'||chr(10)||
'    ADMIN_USERID,'||chr(10)||
'    COMPANY_ADDRESS,'||chr(10)||
'    CITY,'||chr(10)||
'    STATE,'||chr(10)||
'    ZIP,'||chr(10)||
'    COUNTRY,'||chr(10)||
'    COMPANY_TYPE,'||chr(10)||
'    COMPANY_WEBSITE,'||chr(10)||
'    NUMBER_OF_EMPLOYEES,'||chr(10)||
'    COMPANY_PHONE,'||chr(10)||
'    COMPANY_FAX,'||chr(10)||
'    ORACLE_PARTNER,'||chr(10)||
'    HOW_DID_YOU_HEAR_ABOUT_US,'||chr(10)||
'    SERVICE_USE_STATUS,'||chr(10)||
'    DATABASE_SIZE,'||chr(10)||
'';

s:=s||'    SERVICE_START_DATE,'||chr(10)||
'    SERVICE_TERMINATION_DATE,'||chr(10)||
'    SCHEMA_NAME,'||chr(10)||
'    ESTIMATED_END_USERS,'||chr(10)||
'    PAGE_VIEWS_PER_DAY,'||chr(10)||
'    PROJECT_DESCRIPTION,'||chr(10)||
'    PROJECT_JUSTIFICATION,'||chr(10)||
'    PROJECT_APPROVAL_DATE,'||chr(10)||
'    PROJECT_ACTUAL_BEGIN_DATE,'||chr(10)||
'    PROJECT_ACTUAL_END_DATE,'||chr(10)||
'    PROJECT_STATUS,'||chr(10)||
'    request_date,'||chr(10)||
'    SECURITY_GROUP_ID,'||chr(10)||
'    id'||chr(10)||
'from WWV_FLOW_PROVISION_COMPANY'||chr(10)||
'where id = :provision_id';

wwv_flow_api.create_report_region (
  p_id=> 173724892445.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 4.4053,
  p_name=> 'Provisioning Request',
  p_region_name=>'',
  p_template=> 24544226211.4053+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 10,
  p_display_column=> 1,
  p_display_point=> 'REGION_POSITION_02',
  p_source=> s,
  p_source_type=> 'SQL_QUERY',
  p_display_error_message=> '#SQLERRM#',
  p_plug_caching=> 'NOT_CACHED',
  p_customized=> '0',
  p_query_row_template=> 3,
  p_query_headings_type=> 'COLON_DELMITED_LIST',
  p_query_num_rows=> '15',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_break_cols=> '0',
  p_query_num_rows_type=> '0',
  p_query_row_count_max=> '500',
  p_pagination_display_position=> 'BOTTOM_RIGHT',
  p_csv_output=> 'N',
  p_query_asc_image=> 'arrow_down_gray_dark.gif',
  p_query_asc_image_attr=> 'width="13" height="12"',
  p_query_desc_image=> 'arrow_up_gray_dark.gif',
  p_query_desc_image_attr=> 'width="13" height="12"',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48687419982771655.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 173724892445.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'COMPANY_NAME',
  p_column_display_sequence=> 1,
  p_column_heading=> 'Workspace-Name',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48687515843771656.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 173724892445.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'ADMIN_FIRST_NAME',
  p_column_display_sequence=> 2,
  p_column_heading=> 'Vorname des Administrators',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48687628068771656.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 173724892445.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 3,
  p_form_element_id=> null,
  p_column_alias=> 'ADMIN_LAST_NAME',
  p_column_display_sequence=> 3,
  p_column_heading=> 'Nachname des Administrators',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48687729004771656.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 173724892445.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 4,
  p_form_element_id=> null,
  p_column_alias=> 'ADMIN_TITLE',
  p_column_display_sequence=> 4,
  p_column_heading=> 'Admin Title',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48687805987771656.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 173724892445.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 5,
  p_form_element_id=> null,
  p_column_alias=> 'ADMIN_EMAIL',
  p_column_display_sequence=> 5,
  p_column_heading=> 'Administrator-E-Mail',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48687909288771656.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 173724892445.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 6,
  p_form_element_id=> null,
  p_column_alias=> 'ADMIN_PHONE',
  p_column_display_sequence=> 6,
  p_column_heading=> 'Admin Phone',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48688029577771656.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 173724892445.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 7,
  p_form_element_id=> null,
  p_column_alias=> 'ADMIN_USERID',
  p_column_display_sequence=> 7,
  p_column_heading=> 'Administrator-Benutzer-ID',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48688118304771656.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 173724892445.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 8,
  p_form_element_id=> null,
  p_column_alias=> 'COMPANY_ADDRESS',
  p_column_display_sequence=> 8,
  p_column_heading=> 'Company Address',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48688207126771656.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 173724892445.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 9,
  p_form_element_id=> null,
  p_column_alias=> 'CITY',
  p_column_display_sequence=> 9,
  p_column_heading=> 'City',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48688309531771656.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 173724892445.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 10,
  p_form_element_id=> null,
  p_column_alias=> 'STATE',
  p_column_display_sequence=> 10,
  p_column_heading=> 'State',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48688426433771657.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 173724892445.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 11,
  p_form_element_id=> null,
  p_column_alias=> 'ZIP',
  p_column_display_sequence=> 11,
  p_column_heading=> 'Zip',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48688501652771657.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 173724892445.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 12,
  p_form_element_id=> null,
  p_column_alias=> 'COUNTRY',
  p_column_display_sequence=> 12,
  p_column_heading=> 'Country',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48688632281771657.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 173724892445.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 13,
  p_form_element_id=> null,
  p_column_alias=> 'COMPANY_TYPE',
  p_column_display_sequence=> 13,
  p_column_heading=> 'Company Type',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48688721428771657.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 173724892445.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 14,
  p_form_element_id=> null,
  p_column_alias=> 'COMPANY_WEBSITE',
  p_column_display_sequence=> 14,
  p_column_heading=> 'Company Website',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48688808773771657.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 173724892445.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 15,
  p_form_element_id=> null,
  p_column_alias=> 'NUMBER_OF_EMPLOYEES',
  p_column_display_sequence=> 15,
  p_column_heading=> 'Number Of Employees',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48688903783771657.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 173724892445.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 16,
  p_form_element_id=> null,
  p_column_alias=> 'COMPANY_PHONE',
  p_column_display_sequence=> 16,
  p_column_heading=> 'Company Phone',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48689016797771657.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 173724892445.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 17,
  p_form_element_id=> null,
  p_column_alias=> 'COMPANY_FAX',
  p_column_display_sequence=> 17,
  p_column_heading=> 'Company Fax',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48689116782771657.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 173724892445.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 18,
  p_form_element_id=> null,
  p_column_alias=> 'ORACLE_PARTNER',
  p_column_display_sequence=> 18,
  p_column_heading=> 'Oracle Partner',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48689200152771658.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 173724892445.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 19,
  p_form_element_id=> null,
  p_column_alias=> 'HOW_DID_YOU_HEAR_ABOUT_US',
  p_column_display_sequence=> 19,
  p_column_heading=> 'How Did You Hear About Us',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48689300933771658.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 173724892445.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 20,
  p_form_element_id=> null,
  p_column_alias=> 'SERVICE_USE_STATUS',
  p_column_display_sequence=> 20,
  p_column_heading=> 'Verwendungsstatus für den Workspace',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48689400444771658.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 173724892445.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 21,
  p_form_element_id=> null,
  p_column_alias=> 'DATABASE_SIZE',
  p_column_display_sequence=> 21,
  p_column_heading=> 'Datenbankgröße',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48689521409771658.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 173724892445.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 22,
  p_form_element_id=> null,
  p_column_alias=> 'SERVICE_START_DATE',
  p_column_display_sequence=> 22,
  p_column_heading=> 'Service Start Date',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48689621142771658.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 173724892445.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 23,
  p_form_element_id=> null,
  p_column_alias=> 'SERVICE_TERMINATION_DATE',
  p_column_display_sequence=> 23,
  p_column_heading=> 'Service Termination Date',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48689700511771658.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 173724892445.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 24,
  p_form_element_id=> null,
  p_column_alias=> 'SCHEMA_NAME',
  p_column_display_sequence=> 24,
  p_column_heading=> 'Schemaname',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48689810534771658.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 173724892445.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 25,
  p_form_element_id=> null,
  p_column_alias=> 'ESTIMATED_END_USERS',
  p_column_display_sequence=> 25,
  p_column_heading=> 'Estimated End Users',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48689908996771658.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 173724892445.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 26,
  p_form_element_id=> null,
  p_column_alias=> 'PAGE_VIEWS_PER_DAY',
  p_column_display_sequence=> 26,
  p_column_heading=> 'Page Views Per Day',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48690003327771658.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 173724892445.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 27,
  p_form_element_id=> null,
  p_column_alias=> 'PROJECT_DESCRIPTION',
  p_column_display_sequence=> 27,
  p_column_heading=> 'Beschreibung',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48690115108771658.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 173724892445.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 28,
  p_form_element_id=> null,
  p_column_alias=> 'PROJECT_JUSTIFICATION',
  p_column_display_sequence=> 28,
  p_column_heading=> 'Begründung',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48690213710771659.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 173724892445.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 29,
  p_form_element_id=> null,
  p_column_alias=> 'PROJECT_APPROVAL_DATE',
  p_column_display_sequence=> 29,
  p_column_heading=> 'Project Approval Date',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48690326689771659.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 173724892445.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 30,
  p_form_element_id=> null,
  p_column_alias=> 'PROJECT_ACTUAL_BEGIN_DATE',
  p_column_display_sequence=> 30,
  p_column_heading=> 'Project Actual Begin Date',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48690425411771659.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 173724892445.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 31,
  p_form_element_id=> null,
  p_column_alias=> 'PROJECT_ACTUAL_END_DATE',
  p_column_display_sequence=> 31,
  p_column_heading=> 'Project Actual End Date',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48690503555771659.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 173724892445.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 32,
  p_form_element_id=> null,
  p_column_alias=> 'PROJECT_STATUS',
  p_column_display_sequence=> 32,
  p_column_heading=> 'Project Status',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48690621397771659.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 173724892445.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 33,
  p_form_element_id=> null,
  p_column_alias=> 'REQUEST_DATE',
  p_column_display_sequence=> 33,
  p_column_heading=> 'Request-Datum',
  p_column_format=> '&DATE_TIME_FORMAT.',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48690710746771659.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 173724892445.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 34,
  p_form_element_id=> null,
  p_column_alias=> 'SECURITY_GROUP_ID',
  p_column_display_sequence=> 34,
  p_column_heading=> 'Workspace',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48690814352771659.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 173724892445.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 35,
  p_form_element_id=> null,
  p_column_alias=> 'ID',
  p_column_display_sequence=> 35,
  p_column_heading=> 'Identification Number',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 3638630950114201.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 4.4053,
  p_plug_name=> 'topbar',
  p_region_name=>'',
  p_plug_template=> 182507118036154586.4053+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 5,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_02',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS_INITCAP',
  p_plug_query_num_rows => 15,
  p_plug_query_num_rows_type => 'ROWS_X_TO_Y_OF_Z',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_query_show_nulls_as => '(null)',
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 40437913187665660.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 4.4053,
  p_plug_name=> 'Menu',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(4585800473139662 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 4589126493175495.4053+ wwv_flow_api.g_id_offset,
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'declare '||chr(10)||
'l_schema varchar2(30) := null;'||chr(10)||
'l_schema_exists             boolean := false;'||chr(10)||
'l_schema_in_use             boolean := false;'||chr(10)||
'l_schema_cannot_be_assigned boolean := false;'||chr(10)||
'begin'||chr(10)||
''||chr(10)||
'for c1 in (select upper(schema_name) sa1'||chr(10)||
'    from wwv_flow_provision_company'||chr(10)||
'    where id = :PROVISION_ID) loop'||chr(10)||
'    l_schema := c1.sa1;'||chr(10)||
'end loop;'||chr(10)||
''||chr(10)||
'for c1 in (select 1 from sys.user$ where name = l_schema) loop'||chr(10)||
'  l_s';

s:=s||'chema_exists := true;'||chr(10)||
'end loop;'||chr(10)||
''||chr(10)||
'for c1 in (select 1 from wwv_flow_company_schemas '||chr(10)||
'  where schema = l_schema) loop'||chr(10)||
'  l_schema_in_use := true;'||chr(10)||
'end loop;'||chr(10)||
''||chr(10)||
'for c1 in (select 1 from dual'||chr(10)||
'  where wwv_flow_provisioning.reserved_schema_i(l_schema) = 1'||chr(10)||
'  or wwv_flow_provisioning.restricted_schema_i(l_schema, :P4_COMPANY_NAME) = 1) loop'||chr(10)||
'    l_schema_cannot_be_assigned := true;'||chr(10)||
'end loop;'||chr(10)||
''||chr(10)||
'htp.p(''<br />'');h';

s:=s||'tp.p(''<br />'');'||chr(10)||
''||chr(10)||
'if l_schema_exists then'||chr(10)||
'  htp.p(''<p />''||'||chr(10)||
'  wwv_flow_lang.system_message(''F4050.SCHEMA_EXISTS''));'||chr(10)||
'end if;'||chr(10)||
''||chr(10)||
'if l_schema_in_use then'||chr(10)||
'  htp.p(''<p />''||'||chr(10)||
'  wwv_flow_lang.system_message(''F4050.SCHEMA_ASSIGNED''));'||chr(10)||
'end if;'||chr(10)||
''||chr(10)||
'if l_schema_cannot_be_assigned then'||chr(10)||
'  htp.p(''<p />''||'||chr(10)||
'  wwv_flow_lang.system_message(''F4050.RESTRICTED_ADMIN''));'||chr(10)||
'end if;'||chr(10)||
''||chr(10)||
'end;';

wwv_flow_api.create_page_plug (
  p_id=> 179795422363234062.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 4.4053,
  p_plug_name=> 'Warnungen',
  p_region_name=>'',
  p_plug_template=> 162426626171243866.4053+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 20,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_02',
  p_plug_source=> s,
  p_plug_source_type=> 'PLSQL_PROCEDURE',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => 'FUNCTION_BODY',
  p_plug_display_when_condition => 'declare '||chr(10)||
'l_schema varchar2(30) := null;'||chr(10)||
'l_schema_exists             boolean := false;'||chr(10)||
'l_schema_in_use             boolean := false;'||chr(10)||
'l_schema_restricted         boolean := false;'||chr(10)||
'begin'||chr(10)||
''||chr(10)||
'for c1 in (select upper(schema_name) sa1'||chr(10)||
'    from wwv_flow_provision_company'||chr(10)||
'    where id = :PROVISION_ID) loop'||chr(10)||
'    l_schema := c1.sa1;'||chr(10)||
'end loop;'||chr(10)||
''||chr(10)||
'for c1 in (select 1 from sys.user$ where name = l_schema) loop'||chr(10)||
'  l_schema_exists := true;'||chr(10)||
'end loop;'||chr(10)||
''||chr(10)||
'for c1 in (select 1 from wwv_flow_company_schemas '||chr(10)||
'  where schema = l_schema) loop'||chr(10)||
'  l_schema_in_use := true;'||chr(10)||
'end loop;'||chr(10)||
''||chr(10)||
'for c1 in (select 1 from dual'||chr(10)||
'  where wwv_flow_provisioning.reserved_schema_i(l_schema) = 1'||chr(10)||
'  or wwv_flow_provisioning.restricted_schema_i(l_schema,:P4_COMPANY_NAME) = 1) loop'||chr(10)||
'  l_schema_restricted := true;'||chr(10)||
'end loop;'||chr(10)||
''||chr(10)||
'if l_schema_exists or l_schema_in_use or l_schema_restricted then'||chr(10)||
'  return true;'||chr(10)||
'else'||chr(10)||
'  return false;'||chr(10)||
'end if;'||chr(10)||
''||chr(10)||
'end;',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'select short_name from wwv_flow_companies where provisioning_company_id in (select security_group_id from wwv_flow_company_schemas where schema = ('||chr(10)||
' select upper(schema_name)'||chr(10)||
'    from wwv_flow_provision_company'||chr(10)||
'    where id = :PROVISION_ID))';

wwv_flow_api.create_report_region (
  p_id=> 179796001715237593.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 4.4053,
  p_name=> '<a name="REQUEST"></a>Workspaces, die das angeforderte Schema verwenden',
  p_region_name=>'',
  p_template=> 2424107150426143.4053+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 30,
  p_display_column=> 1,
  p_display_point=> 'REGION_POSITION_02',
  p_source=> s,
  p_source_type=> 'SQL_QUERY',
  p_display_error_message=> '#SQLERRM#',
  p_display_when_condition=> 'select 1 from wwv_flow_company_schemas where schema = ('||chr(10)||
' select upper(schema_name)'||chr(10)||
'    from wwv_flow_provision_company'||chr(10)||
'    where id = :PROVISION_ID)',
  p_display_condition_type=> 'EXISTS',
  p_plug_caching=> 'NOT_CACHED',
  p_customized=> '0',
  p_query_row_template=> 6897002870390711.4053+ wwv_flow_api.g_id_offset,
  p_query_headings_type=> 'COLON_DELMITED_LIST',
  p_query_num_rows=> '15',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_show_nulls_as=> ' - ',
  p_query_break_cols=> '0',
  p_query_num_rows_type=> 'NEXT_PREVIOUS_LINKS',
  p_query_row_count_max=> '500',
  p_pagination_display_position=> 'BOTTOM_RIGHT',
  p_csv_output=> 'N',
  p_query_asc_image=> 'blue_arrow_down.gif',
  p_query_asc_image_attr=> 'width="13" height="12"',
  p_query_desc_image=> 'blue_arrow_up.gif',
  p_query_desc_image_attr=> 'width="13" height="12"',
  p_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 179796231768237594.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 179796001715237593.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'SHORT_NAME',
  p_column_display_sequence=> 1,
  p_column_heading=> 'Workspace',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>1,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'<p>Klicken Sie auf die Schaltfläche für die entsprechende Aktion eines bestimmten Workspace Requests.</p>'||chr(10)||
'<p>Wenn Sie den Request ablehnen möchten, klicken Sie auf <b>Ablehnen ></b>, um mit dem letzten Benachrichtigungsschritt fortzufahren.</p>'||chr(10)||
'<p>Wenn Sie den Request genehmigen möchten, klicken Sie auf <b>Genehmigen ></b>, um mit dem letzten Benachrichtigungsschritt fortzufahren.</p>';

wwv_flow_api.create_page_plug (
  p_id=> 179802513712347644.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 4.4053,
  p_plug_name=> 'Workspace Request verarbeiten',
  p_region_name=>'',
  p_plug_template=> 79623830123907946.4053+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 40,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_03',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 225165738087.4053 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 4.4053,
  p_button_sequence=> 5,
  p_button_plug_id => 3638630950114201+wwv_flow_api.g_id_offset,
  p_button_name    => 'DECLINE',
  p_button_image_alt=> 'Ablehnen &gt;',
  p_button_position=> 'REGION_TEMPLATE_CHANGE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=4050:56:&SESSION.:::56',
  p_button_cattributes=>'class="button10"',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 203403932651.4053 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 4.4053,
  p_button_sequence=> 1,
  p_button_plug_id => 3638630950114201+wwv_flow_api.g_id_offset,
  p_button_name    => 'Cancel',
  p_button_image_alt=> 'Abbrechen',
  p_button_position=> 'REGION_TEMPLATE_CLOSE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_cattributes=>'class="button10"',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 200345928591.4053 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 4.4053,
  p_button_sequence=> 10,
  p_button_plug_id => 3638630950114201+wwv_flow_api.g_id_offset,
  p_button_name    => 'Approve',
  p_button_image_alt=> 'Genehmigen &gt;',
  p_button_position=> 'REGION_TEMPLATE_CREATE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=&APP_ID.:55:&SESSION.::&DEBUG.:55::',
  p_button_condition=> 'declare l_schema varchar2(30) := null;'||chr(10)||
'begin'||chr(10)||
'    for c1 in (select upper(schema_name) sa1'||chr(10)||
'        from wwv_flow_provision_company'||chr(10)||
'        where id = :PROVISION_ID) loop'||chr(10)||
'        l_schema := c1.sa1;'||chr(10)||
'    end loop;'||chr(10)||
'    '||chr(10)||
'    if l_schema is not null then        '||chr(10)||
'        for c1 in ('||chr(10)||
'          select 1 from dual'||chr(10)||
'          where '||chr(10)||
'(wwv_flow_provisioning.reserved_schema_i(l_schema) = 1)'||chr(10)||
' or'||chr(10)||
'(wwv_flow_provisioning.restricted_schema_i(l_schema,:P4_COMPANY_NAME) = 1)) loop'||chr(10)||
'            return false;'||chr(10)||
'        end loop;'||chr(10)||
'        return true;'||chr(10)||
'    else'||chr(10)||
'        return false;'||chr(10)||
'    end if;'||chr(10)||
'end;',
  p_button_condition_type=> 'FUNCTION_BODY',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>203412932673.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 4.4053,
  p_branch_action=> '26',
  p_branch_point=> 'BEFORE_VALIDATION',
  p_branch_type=> 'BRANCH_TO_STEP',
  p_branch_when_button_id=>203403932651.4053+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>183253903897.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 4.4053,
  p_name=>'PROVISION_ID',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 173724892445.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_prompt=>'PROVISION_ID',
  p_display_as=> 'HIDDEN',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>48853112333141000.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 4.4053,
  p_name=>'P4_COMPANY_NAME',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 20,
  p_item_plug_id => 173724892445.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source_type=> 'STATIC',
  p_display_as=> 'HIDDEN',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'LEFT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_item_comment => '');
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_computation(
  p_id=> 48857919699199941.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 4.4053,
  p_computation_sequence => 10,
  p_computation_item=> 'P4_COMPANY_NAME',
  p_computation_point=> 'AFTER_HEADER',
  p_computation_type=> 'QUERY',
  p_computation_processed=> 'REPLACE_EXISTING',
  p_computation=> 'select company_name from wwv_flow_provision_company'||chr(10)||
' where id = :PROVISION_ID',
  p_compute_when => '',
  p_compute_when_type=>'');
 
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 4.4053
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_5.405
prompt  ...PAGE 5.4053: Service verwalten
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEADM/adm_mg_service.htm';

ph := null;
wwv_flow_api.create_page(
  p_id     => 5.4053,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'Service verwalten',
  p_step_title=> 'Service verwalten',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'AUTO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 216800021154677630+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => '',
  p_step_template => 12930201930057128.4053+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409160248',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>5.4053,p_text=>h);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 6022815598804767.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 5.4053,
  p_plug_name=> 'Menu',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 30,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(4585800473139662 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 4589126493175495.4053+ wwv_flow_api.g_id_offset,
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 6023019713804767.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 5.4053,
  p_plug_name=> 'Service verwalten',
  p_region_name=>'',
  p_plug_template=> 75821319588166981.4053+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 40,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 19017202882431374 + wwv_flow_api.g_id_offset,
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_display_condition_type => '',
  p_plug_header=> '<table summary=""><tr><td valign="top"><img src="#IMAGE_PREFIX#menu/manage_service.gif" width="64" height="64" alt="&PRODUCT_NAME." /></td><td valign="top">',
  p_plug_footer=> '</td></tr></table>',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'Auf dieser Seite können Sie die Features und Funktionen dieser &PRODUCT_NAME.-Instanz steuern und festlegen.';

wwv_flow_api.create_page_plug (
  p_id=> 6119928615239299.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 5.4053,
  p_plug_name=> 'Service verwalten',
  p_region_name=>'',
  p_plug_template=> 79623830123907946.4053+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 50,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_03',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'47534314618390800';

wwv_flow_api.create_page_plug (
  p_id=> 47536031372405041.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 5.4053,
  p_plug_name=> 'Umgebungseinstellungen verwalten',
  p_region_name=>'',
  p_plug_template=> 75821319588166981.4053+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 60,
  p_plug_display_column=> 2,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 47534314618390800 + wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_header=> '<table summary=""><tr><td valign="top"><img src="#IMAGE_PREFIX#menu/todo_64.gif" width="64" height="64" alt="&PRODUCT_NAME." /></td><td valign="top">',
  p_plug_footer=> '</td></tr></table>',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'137961006165346808';

wwv_flow_api.create_page_plug (
  p_id=> 137963026597352771.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 5.4053,
  p_plug_name=> 'Gemeinsame Komponenten verwalten',
  p_region_name=>'',
  p_plug_template=> 75821319588166981.4053+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 70,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 137961006165346808 + wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_header=> '<table summary=""><tr><td valign="top"><img src="#IMAGE_PREFIX#menu/client_64.gif" width="64" height="64" alt="&PRODUCT_NAME." /></td><td valign="top">',
  p_plug_footer=> '</td></tr></table>',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
null;
 
end;
/

 
begin
 
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 5.4053
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_6.405
prompt  ...PAGE 6.4053: Provisioning Request
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEADM/adm_ser_rqst.htm';

ph := null;
wwv_flow_api.create_page(
  p_id     => 6.4053,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'Provisioning Request',
  p_step_title=> 'Provisioning Request',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'AUTO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 216766430018595041+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => '',
  p_step_template => '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409160248',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>6.4053,p_text=>h);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 225183790487.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 6.4053,
  p_plug_name=> 'Provisioning Request bearbeiten',
  p_region_name=>'',
  p_plug_template=> 2424107150426143.4053+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 10,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> 'Unable to show report. #SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_num_rows => 15,
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_query_show_nulls_as => '(null)',
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> 'generated 23-FEB-2001 17:53:48');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'<p>Bearbeiten Sie den aktuellen Workspace Request.</p>'||chr(10)||
'<p>Klicken Sie auf <b>Änderungen anwenden</b>, falls vorhanden, um Ihre Änderungen zu speichern. Klicken Sie auf <b>Beenden oder löschen</b>, falls vorhanden, um den Request zu beenden. Klicken Sie auf <b>Löschen</b>, falls vorhanden, um den Request zu löschen.</p>';

wwv_flow_api.create_page_plug (
  p_id=> 225294842695.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 6.4053,
  p_plug_name=> 'Request bearbeiten',
  p_region_name=>'',
  p_plug_template=> 79623830123907946.4053+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 20,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_03',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS_INITCAP',
  p_plug_query_num_rows => 15,
  p_plug_query_num_rows_type => 'ROWS_X_TO_Y_OF_Z',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top" align="right"',
  p_plug_query_show_nulls_as => '(null)',
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 40441304661672658.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 6.4053,
  p_plug_name=> 'Menu',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(4585800473139662 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 4589126493175495.4053+ wwv_flow_api.g_id_offset,
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 225186790489.4053 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 6.4053,
  p_button_sequence=> 1,
  p_button_plug_id => 225183790487+wwv_flow_api.g_id_offset,
  p_button_name    => 'Cancel',
  p_button_image_alt=> 'Abbrechen',
  p_button_position=> 'REGION_TEMPLATE_CLOSE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_cattributes=>'class="button10"',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 225190790490.4053 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 6.4053,
  p_button_sequence=> 3,
  p_button_plug_id => 225183790487+wwv_flow_api.g_id_offset,
  p_button_name    => 'Apply_Changes',
  p_button_image_alt=> 'Änderungen anwenden',
  p_button_position=> 'REGION_TEMPLATE_CREATE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_condition=> 'F4050_P6_ID',
  p_button_condition_type=> 'ITEM_IS_NOT_NULL',
  p_button_cattributes=>'class="button10"',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 2934116575079521.4053 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 6.4053,
  p_button_sequence=> 10,
  p_button_plug_id => 225183790487+wwv_flow_api.g_id_offset,
  p_button_name    => 'Terminate_or_Delete',
  p_button_image_alt=> 'Beenden oder löschen',
  p_button_position=> 'REGION_TEMPLATE_DELETE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_condition=> 'select 1'||chr(10)||
''||chr(10)||
'from wwv_flow_provision_company'||chr(10)||
''||chr(10)||
'where id = :F4050_P6_ID'||chr(10)||
''||chr(10)||
'and project_status = ''APPROVED''',
  p_button_condition_type=> 'EXISTS',
  p_button_cattributes=>'class="button10"',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 52722223258062562.4053 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 6.4053,
  p_button_sequence=> 10,
  p_button_plug_id => 225183790487+wwv_flow_api.g_id_offset,
  p_button_name    => 'Delete',
  p_button_image_alt=> 'Löschen',
  p_button_position=> 'REGION_TEMPLATE_DELETE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=4050:8:&SESSION.::NO::D_PROVISION_ID:&F4050_P6_ID.',
  p_button_condition=> 'select 1'||chr(10)||
''||chr(10)||
'from wwv_flow_provision_company'||chr(10)||
''||chr(10)||
'where id = :F4050_P6_ID'||chr(10)||
''||chr(10)||
'and project_status = ''APPROVED''',
  p_button_condition_type=> 'NOT_EXISTS',
  p_button_cattributes=>'class="button10"',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>135407227774354772.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 6.4053,
  p_branch_action=> 'f?p=&FLOW_ID.:81:&SESSION.::&DEBUG.:81,82:P81_COMPANY:&F4050_P6_COMPANY_NAME.',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_when_button_id=>2934116575079521.4053+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Created 01-AUG-2003 15:02 by JASON');
 
wwv_flow_api.create_page_branch(
  p_id=>225180790486.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 6.4053,
  p_branch_action=> '26',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'BRANCH_TO_STEP',
  p_branch_sequence=> 99,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
wwv_flow_api.create_page_branch(
  p_id=>225182790487.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 6.4053,
  p_branch_action=> '26',
  p_branch_point=> 'BEFORE_VALIDATION',
  p_branch_type=> 'BRANCH_TO_STEP',
  p_branch_sequence=> 10,
  p_branch_condition_type=> 'REQUEST_EQUALS_CONDITION',
  p_branch_condition=> 'Cancel',
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>225194790494.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 6.4053,
  p_name=>'F4050_P6_ID',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 1000,
  p_item_plug_id => 225183790487.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_prompt=>'Id',
  p_source=>'ID',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'HIDDEN',
  p_lov_columns=> null,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 32,
  p_cMaxlength=> 255,
  p_cHeight=> 1,
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 111843720754869910.4053+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>225196790494.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 6.4053,
  p_name=>'F4050_P6_SECURITY_GROUP_ID',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 20,
  p_item_plug_id => 225183790487.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'&COMPANY_NAME.',
  p_source=>'SECURITY_GROUP_ID',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'HIDDEN',
  p_lov_columns=> null,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 32,
  p_cMaxlength=> 255,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 111843720754869910.4053+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Geben Sie einen Workspace ein.';

wwv_flow_api.create_page_item(
  p_id=>225198790495.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 6.4053,
  p_name=>'F4050_P6_COMPANY_NAME',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 30,
  p_item_plug_id => 225183790487.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Workspace',
  p_source=>'COMPANY_NAME',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'TEXT',
  p_lov_columns=> null,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 32,
  p_cMaxlength=> 255,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 111844628719872228.4053+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Geben Sie den Vornamen ein.';

wwv_flow_api.create_page_item(
  p_id=>225200790495.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 6.4053,
  p_name=>'F4050_P6_ADMIN_FIRST_NAME',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 40,
  p_item_plug_id => 225183790487.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Vorname des Administrators',
  p_source=>'ADMIN_FIRST_NAME',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'TEXT',
  p_lov_columns=> null,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 32,
  p_cMaxlength=> 255,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 111843720754869910.4053+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Geben Sie den Nachnamen ein.';

wwv_flow_api.create_page_item(
  p_id=>225202790496.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 6.4053,
  p_name=>'F4050_P6_ADMIN_LAST_NAME',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 50,
  p_item_plug_id => 225183790487.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Nachname des Administrators',
  p_source=>'ADMIN_LAST_NAME',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'TEXT',
  p_lov_columns=> null,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 32,
  p_cMaxlength=> 255,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 111843720754869910.4053+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>225204790497.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 6.4053,
  p_name=>'F4050_P6_ADMIN_TITLE',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 60,
  p_item_plug_id => 225183790487.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Admin Title',
  p_source=>'ADMIN_TITLE',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'HIDDEN',
  p_lov_columns=> null,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 32,
  p_cMaxlength=> 255,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 111843720754869910.4053+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Geben Sie die E-Mail-Adresse ein.';

wwv_flow_api.create_page_item(
  p_id=>225206790497.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 6.4053,
  p_name=>'F4050_P6_ADMIN_EMAIL',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 32,
  p_item_plug_id => 225183790487.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'E-Mail-Adresse des Administrators',
  p_source=>'ADMIN_EMAIL',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'TEXT',
  p_lov_columns=> null,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 32,
  p_cMaxlength=> 255,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 111844628719872228.4053+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>225208790498.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 6.4053,
  p_name=>'F4050_P6_ADMIN_PHONE',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 80,
  p_item_plug_id => 225183790487.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Admin Phone',
  p_source=>'ADMIN_PHONE',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'HIDDEN',
  p_lov_columns=> null,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 32,
  p_cMaxlength=> 255,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 111843720754869910.4053+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Geben Sie die Benutzer-ID für den Administrator an.';

wwv_flow_api.create_page_item(
  p_id=>225210790498.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 6.4053,
  p_name=>'F4050_P6_ADMIN_USERID',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 31,
  p_item_plug_id => 225183790487.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Benutzer-ID für den Administrator',
  p_source=>'ADMIN_USERID',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'TEXT',
  p_lov_columns=> null,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 32,
  p_cMaxlength=> 255,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 111844628719872228.4053+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>225212790499.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 6.4053,
  p_name=>'F4050_P6_COMPANY_ADDRESS',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 100,
  p_item_plug_id => 225183790487.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Company Address',
  p_source=>'COMPANY_ADDRESS',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'HIDDEN',
  p_lov_columns=> null,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 32,
  p_cMaxlength=> 255,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 111843720754869910.4053+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>225214790500.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 6.4053,
  p_name=>'F4050_P6_CITY',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 110,
  p_item_plug_id => 225183790487.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'City',
  p_source=>'CITY',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'HIDDEN',
  p_lov_columns=> null,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 32,
  p_cMaxlength=> 255,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 111843720754869910.4053+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>225216790500.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 6.4053,
  p_name=>'F4050_P6_STATE',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 120,
  p_item_plug_id => 225183790487.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'State',
  p_source=>'STATE',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'HIDDEN',
  p_lov_columns=> null,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 32,
  p_cMaxlength=> 255,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 111843720754869910.4053+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>225218790501.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 6.4053,
  p_name=>'F4050_P6_ZIP',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 130,
  p_item_plug_id => 225183790487.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Postal Code',
  p_source=>'ZIP',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'HIDDEN',
  p_lov_columns=> null,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 32,
  p_cMaxlength=> 255,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 111843720754869910.4053+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>225220790501.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 6.4053,
  p_name=>'F4050_P6_COUNTRY',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 140,
  p_item_plug_id => 225183790487.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Country',
  p_source=>'COUNTRY',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'HIDDEN',
  p_named_lov=> 'COUNTRIES',
  p_lov => 'select COUNTRY_NAME d, COUNTRY_NAME r'||chr(10)||
'from wwv_flow_countries'||chr(10)||
'order by country_name',
  p_lov_columns=> null,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 31,
  p_cMaxlength=> 255,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 111843720754869910.4053+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>225222790502.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 6.4053,
  p_name=>'F4050_P6_COMPANY_TYPE',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 150,
  p_item_plug_id => 225183790487.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Company Type',
  p_source=>'COMPANY_TYPE',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'HIDDEN',
  p_lov_columns=> null,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 32,
  p_cMaxlength=> 255,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 111843720754869910.4053+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>225236790507.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 6.4053,
  p_name=>'F4050_P6_SERVICE_USE_STATUS',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 220,
  p_item_plug_id => 225183790487.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Service Use Status',
  p_source=>'SERVICE_USE_STATUS',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'HIDDEN',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 32,
  p_cMaxlength=> 30,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 111843720754869910.4053+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Geben Sie die Datenbankgröße an.';

wwv_flow_api.create_page_item(
  p_id=>225238790508.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 6.4053,
  p_name=>'F4050_P6_DATABASE_SIZE',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 230,
  p_item_plug_id => 225183790487.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Datenbankgröße',
  p_source=>'DATABASE_SIZE',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'TEXT',
  p_lov_columns=> null,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 32,
  p_cMaxlength=> 255,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 111843720754869910.4053+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Geben Sie das Datum für den Service-Beginn an.';

wwv_flow_api.create_page_item(
  p_id=>225240790509.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 6.4053,
  p_name=>'F4050_P6_SERVICE_START_DATE',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 240,
  p_item_plug_id => 225183790487.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Service Start Date',
  p_source=>'SERVICE_START_DATE',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'HIDDEN',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 32,
  p_cMaxlength=> 255,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 111843720754869910.4053+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Geben Sie das Datum für das Service-Ende an.';

wwv_flow_api.create_page_item(
  p_id=>225242790509.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 6.4053,
  p_name=>'F4050_P6_SERVICE_TERMINATION_DATE',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 250,
  p_item_plug_id => 225183790487.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Service Termination Date',
  p_source=>'SERVICE_TERMINATION_DATE',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'HIDDEN',
  p_lov_columns=> null,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 32,
  p_cMaxlength=> 255,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 111843720754869910.4053+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Geben Sie den Schemanamen an.';

wwv_flow_api.create_page_item(
  p_id=>225244790510.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 6.4053,
  p_name=>'F4050_P6_SCHEMA_NAME',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 260,
  p_item_plug_id => 225183790487.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Schemaname',
  p_source=>'SCHEMA_NAME',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'POPUP',
  p_named_lov=> 'LIST_ALL_DATABASE_SCHEMAS',
  p_lov => 'declare q varchar2(32767);'||chr(10)||
'  l_flows_schema varchar2(30) := wwv_flow.g_flow_schema_owner;'||chr(10)||
'begin'||chr(10)||
'    q := ''select name n, name r from sys.user$ u where type#=1 and name <> ''''''||l_flows_schema||'''''' and name not in (''''HTMLDB_PUBLIC_USER'''',''''PUBLIC_USER'''',''''FLOWS_FILES'''',''''SCHEDULER'''',''''PEOPLE'''',''''APEX_PUBLIC_USER'''')'';'||chr(10)||
'    q := q||'' and name not in (select schema from wwv_flow_restricted_schemas where not exists (select 1 from wwv_flow_rschema_exceptions where schema_id = (select id from wwv_flow_restricted_schemas where schema = u.name))) '';'||chr(10)||
'    q := q ||'' order by 1'';'||chr(10)||
'    return q;'||chr(10)||
'end;',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 32,
  p_cMaxlength=> 255,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 111844628719872228.4053+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Geben Sie die Projektbeschreibung an';

wwv_flow_api.create_page_item(
  p_id=>225250790511.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 6.4053,
  p_name=>'F4050_P6_PROJECT_DESCRIPTION',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 290,
  p_item_plug_id => 225183790487.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Projektbeschreibung',
  p_source=>'PROJECT_DESCRIPTION',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'TEXTAREA',
  p_lov_columns=> null,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 60,
  p_cMaxlength=> 255,
  p_cHeight=> 4,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 111843720754869910.4053+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Geben Sie die Begründung für das Projekt an.';

wwv_flow_api.create_page_item(
  p_id=>225252790512.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 6.4053,
  p_name=>'F4050_P6_PROJECT_JUSTIFICATION',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 300,
  p_item_plug_id => 225183790487.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Projektbegründung',
  p_source=>'PROJECT_JUSTIFICATION',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'TEXTAREA',
  p_lov_columns=> null,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 60,
  p_cMaxlength=> 255,
  p_cHeight=> 4,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 111843720754869910.4053+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Gibt das Datum der Genehmigung an.';

wwv_flow_api.create_page_item(
  p_id=>225254790513.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 6.4053,
  p_name=>'F4050_P6_PROJECT_APPROVAL_DATE',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 310,
  p_item_plug_id => 225183790487.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Approval Date',
  p_source=>'PROJECT_APPROVAL_DATE',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'HIDDEN',
  p_lov_columns=> null,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 32,
  p_cMaxlength=> 255,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 111843720754869910.4053+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Gibt das Provisioning-Datum an.';

wwv_flow_api.create_page_item(
  p_id=>225256790513.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 6.4053,
  p_name=>'F4050_P6_PROJECT_ACTUAL_BEGIN_DATE',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 320,
  p_item_plug_id => 225183790487.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Project Actual Begin Date',
  p_source=>'PROJECT_ACTUAL_BEGIN_DATE',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'HIDDEN',
  p_lov_columns=> null,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 32,
  p_cMaxlength=> 255,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 111843720754869910.4053+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Geben Sie den Projektstatus an.';

wwv_flow_api.create_page_item(
  p_id=>225260790515.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 6.4053,
  p_name=>'F4050_P6_PROJECT_STATUS',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 340,
  p_item_plug_id => 225183790487.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Projektstatus:',
  p_source=>'PROJECT_STATUS',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'DISPLAY_ONLY_LOV',
  p_named_lov=> 'SERVICE.REQUEST.STATUS',
  p_lov => '.'||to_char(87755726864223308 + wwv_flow_api.g_id_offset)||'.',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 32,
  p_cMaxlength=> 255,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_tag_attributes  => 'class="fielddatabold"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 111843720754869910.4053+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Geben Sie das Workspace-Schema für das Projekt an.';

wwv_flow_api.create_page_item(
  p_id=>225262790515.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 6.4053,
  p_name=>'F4050_P6_PROJECT_SCHEMA_LIST',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 350,
  p_item_plug_id => 225183790487.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Projektschemaliste',
  p_source=>'PROJECT_SCHEMA_LIST',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'TEXTAREA',
  p_lov_columns=> null,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 60,
  p_cMaxlength=> 255,
  p_cHeight=> 4,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_display_when_type=>'NEVER',
  p_field_template => 111843720754869910.4053+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 183384800804268476.4053 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 6.4053,
  p_validation_name => 'schema not restricted',
  p_validation_sequence=> 10,
  p_validation => 'if (wwv_flow_provisioning.site_admin_is_restricted and'||chr(10)||
'     wwv_flow_provisioning.restricted_schema('||chr(10)||
'         p_schema => upper(:F4050_P6_SCHEMA_NAME),'||chr(10)||
'         p_workspace_name => upper(:F4050_P6_COMPANY_NAME)'||chr(10)||
'         )) then'||chr(10)||
'  return false;'||chr(10)||
'else'||chr(10)||
'  return true;'||chr(10)||
'end if;',
  p_validation_type => 'FUNC_BODY_RETURNING_BOOLEAN',
  p_error_message => 'Das angeforderte Schema ist eingeschränkt. Eingeschränkte Schemas können Workspaces nicht zugeordnet werden.',
  p_when_button_pressed=> 225190790490.4053 + wwv_flow_api.g_id_offset,
  p_associated_item=> 225244790510.4053 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 183404521151643333.4053 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 6.4053,
  p_validation_name => 'schema not reserved',
  p_validation_sequence=> 20,
  p_validation => 'if wwv_flow_provisioning.reserved_schema(p_schema =>   '||chr(10)||
'    upper(:F4050_P6_SCHEMA_NAME)) then'||chr(10)||
'  return false;'||chr(10)||
'else'||chr(10)||
'  return true;'||chr(10)||
'end if;',
  p_validation_type => 'FUNC_BODY_RETURNING_BOOLEAN',
  p_error_message => 'Das angeforderte Schema ist reserviert.',
  p_when_button_pressed=> 225190790490.4053 + wwv_flow_api.g_id_offset,
  p_associated_item=> .4053 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'#OWNER#:WWV_FLOW_PROVISION_COMPANY:F4050_P6_ID:ID';

wwv_flow_api.create_page_process(
  p_id     => 225264790516.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 6.4053,
  p_process_sequence=> 1,
  p_process_point=> 'AFTER_HEADER',
  p_process_type=> 'DML_FETCH_ROW',
  p_process_name=> 'Fetch Row from WWV_FLOW_PROVISION_COMPANY',
  p_process_sql_clob => p, 
  p_process_error_message=> 'Fehler beim Abrufen von Zeile.',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'#OWNER#:WWV_FLOW_PROVISION_COMPANY:F4050_P6_ID:ID|U';

wwv_flow_api.create_page_process(
  p_id     => 225266790517.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 6.4053,
  p_process_sequence=> 1,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'DML_PROCESS_ROW',
  p_process_name=> 'Process Row of WWV_FLOW_PROVISION_COMPANY',
  p_process_sql_clob => p, 
  p_process_error_message=> 'Fehler beim Verarbeiten von Zeile.',
  p_process_when_button_id=>225190790490.4053 + wwv_flow_api.g_id_offset,
  p_process_success_message=> 'Aktion wurde verarbeitet.',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 6.4053
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_7.405
prompt  ...PAGE 7.4053: Request anpassen
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEADM/adm_create_wkspc.htm';

ph := null;
wwv_flow_api.create_page(
  p_id     => 7.4053,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'Request anpassen',
  p_step_title=> 'Request anpassen',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'AUTO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 216766430018595041+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => '',
  p_step_template => 12930201930057128.4053+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409160249',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>7.4053,p_text=>h);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 43187720190328736.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 7.4053,
  p_plug_name=> 'Status-Provisioning-Attribut ändern',
  p_region_name=>'',
  p_plug_template=> 2424107150426143.4053+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 10,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_02',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> 'Unable to show report. #SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS_INITCAP',
  p_plug_query_num_rows => 5,
  p_plug_query_num_rows_type => 'ROWS_X_TO_Y_OF_Z',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_query_show_nulls_as => '(null)',
  p_plug_display_condition_type => '',
  p_plug_footer=> '<div class="htmldbInstructionText">Die oben angegebenen Informationen stammen vom Workspace Request. Der tatsächliche Name des Workspace und andere Attribute unterscheiden sich möglicherweise für einen durch Provisioning bereitgestellten Benutzer, hier handelt es sich lediglich um den Request.</div>',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> 'generated 16-MAR-2001 18:11:26');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'<p>Auf dieser Seite können Workspace-Administratoren den Status eines Workspace Requests ändern.</p>'||chr(10)||
'<p>Wenn Sie einen Request auf <b>Angefordert</b> zurücksetzen, kann ein Workspace erneut durch Provisioning bereitgestellt werden.</p>'||chr(10)||
'<p><b>Hinweis</b>: Wenn Sie einen Workspace mit dem Status <b>Genehmigt</b> auf <b>Angefordert</b> zurücksetzen, können aufgrund des Provisionings von Accounts Date';

s:=s||'n beschädigt werden. Das Provisioning-System geht davon aus, dass Workspace Requests mit dem Status <b>Angefordert</b> keine entsprechenden Schemas und Dictionary-Einträge für einen Workspace-Administrator oder Entwickler haben. Um den Projektstatus eines Workspace von <b>Genehmigt</b> auf <b>Angefordert</b> zurückzusetzen, empfiehlt es sich, zuerst den Workspace zu beenden und anschließend den St';

s:=s||'atus <b>Angefordert</b> festzulegen.</p>';

wwv_flow_api.create_page_plug (
  p_id=> 43202121056423198.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 7.4053,
  p_plug_name=> 'Status ändern',
  p_region_name=>'',
  p_plug_template=> 79623830123907946.4053+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 20,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_03',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS_INITCAP',
  p_plug_query_num_rows => 5,
  p_plug_query_num_rows_type => 'ROWS_X_TO_Y_OF_Z',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top" align="right"',
  p_plug_query_show_nulls_as => '(null)',
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'select * from wwv_flow_provision_company where id = :T_PROVISION_ID';

wwv_flow_api.create_report_region (
  p_id=> 48679045286466446.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 7.4053,
  p_name=> 'Bericht über Provisioning Request',
  p_region_name=>'',
  p_template=> 159419508372158325.4053+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 15,
  p_display_column=> 1,
  p_display_point=> 'REGION_POSITION_02',
  p_source=> s,
  p_source_type=> 'SQL_QUERY',
  p_display_error_message=> '#SQLERRM#',
  p_plug_caching=> 'NOT_CACHED',
  p_customized=> '0',
  p_query_row_template=> 3,
  p_query_headings_type=> 'COLON_DELMITED_LIST',
  p_query_num_rows=> '5',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_show_nulls_as=> '(null)',
  p_query_break_cols=> '0',
  p_query_num_rows_type=> '0',
  p_query_row_count_max=> '500',
  p_pagination_display_position=> 'BOTTOM_RIGHT',
  p_csv_output=> 'N',
  p_query_asc_image=> 'blue_arrow_down.gif',
  p_query_asc_image_attr=> 'width="13" height="12"',
  p_query_desc_image=> 'blue_arrow_up.gif',
  p_query_desc_image_attr=> 'width="13" height="12"',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48556132422770818.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 48679045286466446.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'ID',
  p_column_display_sequence=> 1,
  p_column_heading=> 'ID',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48556223377770818.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 48679045286466446.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'SECURITY_GROUP_ID',
  p_column_display_sequence=> 2,
  p_column_heading=> 'Workspace',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48556324615770818.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 48679045286466446.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 3,
  p_form_element_id=> null,
  p_column_alias=> 'COMPANY_NAME',
  p_column_display_sequence=> 3,
  p_column_heading=> 'Workspace-Name',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48556402156770818.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 48679045286466446.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 4,
  p_form_element_id=> null,
  p_column_alias=> 'ADMIN_FIRST_NAME',
  p_column_display_sequence=> 4,
  p_column_heading=> 'Vorname des Administrators',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48556509895770818.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 48679045286466446.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 5,
  p_form_element_id=> null,
  p_column_alias=> 'ADMIN_LAST_NAME',
  p_column_display_sequence=> 5,
  p_column_heading=> 'Nachname des Administrators',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48556604610770818.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 48679045286466446.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 6,
  p_form_element_id=> null,
  p_column_alias=> 'ADMIN_TITLE',
  p_column_display_sequence=> 6,
  p_column_heading=> 'Anrede für den Administrator',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48556719143770818.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 48679045286466446.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 7,
  p_form_element_id=> null,
  p_column_alias=> 'ADMIN_EMAIL',
  p_column_display_sequence=> 7,
  p_column_heading=> 'E-Mail-Adresse des Administrators',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48556819251770818.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 48679045286466446.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 8,
  p_form_element_id=> null,
  p_column_alias=> 'ADMIN_PHONE',
  p_column_display_sequence=> 8,
  p_column_heading=> 'Telefonnummer des Administrators',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48556903983770819.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 48679045286466446.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 9,
  p_form_element_id=> null,
  p_column_alias=> 'ADMIN_ID',
  p_column_display_sequence=> 9,
  p_column_heading=> 'Admin-ID',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48557019200770819.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 48679045286466446.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 10,
  p_form_element_id=> null,
  p_column_alias=> 'ADMIN_USERID',
  p_column_display_sequence=> 10,
  p_column_heading=> 'Admin-Benutzer',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48557116708770819.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 48679045286466446.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 11,
  p_form_element_id=> null,
  p_column_alias=> 'COMPANY_ADDRESS',
  p_column_display_sequence=> 11,
  p_column_heading=> 'Firmenadresse',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48557212730770819.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 48679045286466446.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 12,
  p_form_element_id=> null,
  p_column_alias=> 'CITY',
  p_column_display_sequence=> 12,
  p_column_heading=> 'Ort',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48557300303770819.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 48679045286466446.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 13,
  p_form_element_id=> null,
  p_column_alias=> 'STATE',
  p_column_display_sequence=> 13,
  p_column_heading=> 'Bundesland',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48557417190770819.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 48679045286466446.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 14,
  p_form_element_id=> null,
  p_column_alias=> 'ZIP',
  p_column_display_sequence=> 14,
  p_column_heading=> 'PLZ',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48557531161770819.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 48679045286466446.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 15,
  p_form_element_id=> null,
  p_column_alias=> 'COUNTRY',
  p_column_display_sequence=> 15,
  p_column_heading=> 'Land',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48557603733770819.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 48679045286466446.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 16,
  p_form_element_id=> null,
  p_column_alias=> 'COMPANY_TYPE',
  p_column_display_sequence=> 16,
  p_column_heading=> 'Firmentyp',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48557725446770820.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 48679045286466446.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 17,
  p_form_element_id=> null,
  p_column_alias=> 'COMPANY_WEBSITE',
  p_column_display_sequence=> 17,
  p_column_heading=> 'Website der Firma',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48557807266770820.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 48679045286466446.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 18,
  p_form_element_id=> null,
  p_column_alias=> 'NUMBER_OF_EMPLOYEES',
  p_column_display_sequence=> 18,
  p_column_heading=> 'Anzahl Mitarbeiter',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48557909867770820.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 48679045286466446.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 19,
  p_form_element_id=> null,
  p_column_alias=> 'COMPANY_PHONE',
  p_column_display_sequence=> 19,
  p_column_heading=> 'Telefonnummer der Firma',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48558009366770820.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 48679045286466446.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 20,
  p_form_element_id=> null,
  p_column_alias=> 'COMPANY_FAX',
  p_column_display_sequence=> 20,
  p_column_heading=> 'Faxnummer der Firma',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48558128386770820.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 48679045286466446.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 21,
  p_form_element_id=> null,
  p_column_alias=> 'ORACLE_PARTNER',
  p_column_display_sequence=> 21,
  p_column_heading=> 'Oracle-Partner',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48558215519770820.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 48679045286466446.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 22,
  p_form_element_id=> null,
  p_column_alias=> 'HOW_DID_YOU_HEAR_ABOUT_US',
  p_column_display_sequence=> 22,
  p_column_heading=> 'Wie haben Sie von uns erfahren',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48558301343770820.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 48679045286466446.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 23,
  p_form_element_id=> null,
  p_column_alias=> 'SERVICE_USE_STATUS',
  p_column_display_sequence=> 23,
  p_column_heading=> 'Verwendungsstatus für den Workspace',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48558416989770820.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 48679045286466446.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 24,
  p_form_element_id=> null,
  p_column_alias=> 'DATABASE_SIZE',
  p_column_display_sequence=> 24,
  p_column_heading=> 'Datenbankgröße',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48558502328770820.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 48679045286466446.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 25,
  p_form_element_id=> null,
  p_column_alias=> 'SERVICE_START_DATE',
  p_column_display_sequence=> 25,
  p_column_heading=> 'Workspace-Beginn am',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48558608436770821.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 48679045286466446.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 26,
  p_form_element_id=> null,
  p_column_alias=> 'SERVICE_TERMINATION_DATE',
  p_column_display_sequence=> 26,
  p_column_heading=> 'Workspace-Ende am',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48558732412770821.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 48679045286466446.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 27,
  p_form_element_id=> null,
  p_column_alias=> 'SCHEMA_NAME',
  p_column_display_sequence=> 27,
  p_column_heading=> 'Schemaname',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48558828706770821.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 48679045286466446.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 28,
  p_form_element_id=> null,
  p_column_alias=> 'ESTIMATED_END_USERS',
  p_column_display_sequence=> 28,
  p_column_heading=> 'Geschätzte Zahl der Endbenutzer',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48558926502770821.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 48679045286466446.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 29,
  p_form_element_id=> null,
  p_column_alias=> 'PAGE_VIEWS_PER_DAY',
  p_column_display_sequence=> 29,
  p_column_heading=> 'Seitenansichten pro Tag',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48559028941770821.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 48679045286466446.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 30,
  p_form_element_id=> null,
  p_column_alias=> 'PROJECT_DESCRIPTION',
  p_column_display_sequence=> 30,
  p_column_heading=> 'Projektbeschreibung',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48559105122770821.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 48679045286466446.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 31,
  p_form_element_id=> null,
  p_column_alias=> 'PROJECT_JUSTIFICATION',
  p_column_display_sequence=> 31,
  p_column_heading=> 'Projektbegründung',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48559207106770821.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 48679045286466446.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 32,
  p_form_element_id=> null,
  p_column_alias=> 'PROJECT_APPROVAL_DATE',
  p_column_display_sequence=> 32,
  p_column_heading=> 'Projekt genehmigt am',
  p_column_format=> '&DATE_TIME_FORMAT.',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48559322056770821.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 48679045286466446.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 33,
  p_form_element_id=> null,
  p_column_alias=> 'PROJECT_ACTUAL_BEGIN_DATE',
  p_column_display_sequence=> 33,
  p_column_heading=> 'Tatsächlicher Projektbeginn am',
  p_column_format=> '&DATE_TIME_FORMAT.',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48559424282770822.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 48679045286466446.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 34,
  p_form_element_id=> null,
  p_column_alias=> 'PROJECT_ACTUAL_END_DATE',
  p_column_display_sequence=> 34,
  p_column_heading=> 'Tatsächliches Projektende am',
  p_column_format=> '&DATE_TIME_FORMAT.',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48559505641770822.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 48679045286466446.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 35,
  p_form_element_id=> null,
  p_column_alias=> 'PROJECT_STATUS',
  p_column_display_sequence=> 35,
  p_column_heading=> 'Projektstatus',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48559628424770822.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 48679045286466446.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 36,
  p_form_element_id=> null,
  p_column_alias=> 'WORK_LOG',
  p_column_display_sequence=> 36,
  p_column_heading=> 'Arbeits-Log',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48559715673770822.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 48679045286466446.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 37,
  p_form_element_id=> null,
  p_column_alias=> 'REQUEST_DATE',
  p_column_display_sequence=> 37,
  p_column_heading=> 'Request-Datum',
  p_column_format=> '&DATE_TIME_FORMAT.',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 68360032073823482.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 7.4053,
  p_plug_name=> 'Menu',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 60,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(4585800473139662 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 4589126493175495.4053+ wwv_flow_api.g_id_offset,
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 227262248958.4053 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 7.4053,
  p_button_sequence=> 10,
  p_button_plug_id => 43187720190328736+wwv_flow_api.g_id_offset,
  p_button_name    => 'Cancel',
  p_button_image_alt=> 'Abbrechen',
  p_button_position=> 'REGION_TEMPLATE_CLOSE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=&APP_ID.:26:&SESSION.::&DEBUG.:::',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 43186036285311765.4053 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 7.4053,
  p_button_sequence=> 25,
  p_button_plug_id => 43187720190328736+wwv_flow_api.g_id_offset,
  p_button_name    => 'Apply_Changes',
  p_button_image_alt=> 'Änderungen anwenden',
  p_button_position=> 'REGION_TEMPLATE_CREATE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_condition=> '(:T_PROVISION_ID is not null)',
  p_button_condition_type=> 'PLSQL_EXPRESSION',
  p_button_cattributes=>'class="button10"',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 23895428675298516.4053 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 7.4053,
  p_button_sequence=> 35,
  p_button_plug_id => 43187720190328736+wwv_flow_api.g_id_offset,
  p_button_name    => 'APPLY_CHANGES',
  p_button_image_alt=> 'Löschen',
  p_button_position=> 'REGION_TEMPLATE_CREATE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_condition=> 'F4050_P26_STATUS',
  p_button_condition2=> 'ACCEPTED',
  p_button_condition_type=> 'VAL_OF_ITEM_IN_COND_EQ_COND2',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>227270253105.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 7.4053,
  p_branch_action=> '26',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'BRANCH_TO_STEP',
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>227275281088.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 7.4053,
  p_name=>'T_PROVISION_ID',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'<b>New Service Provisioning Request ID</b>:',
  p_display_as=> 'HIDDEN',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Die ID des Provisioning Requests.';

wwv_flow_api.create_page_item(
  p_id=>3143616388404027.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 7.4053,
  p_name=>'F4050_P7_ID',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 20,
  p_item_plug_id => 43187720190328736.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Request-ID:',
  p_source=>'ID',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'DISPLAY_AND_SAVE',
  p_lov_columns=> null,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 32,
  p_cMaxlength=> 255,
  p_cHeight=> 1,
  p_tag_attributes  => 'class="fielddatabold"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 111843720754869910.4053+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Die ID des durch Provisioning bereitgestellten Workspace.';

wwv_flow_api.create_page_item(
  p_id=>3147132094442338.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 7.4053,
  p_name=>'F4050_P7_SECURITY_GROUP_ID',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 30,
  p_item_plug_id => 43187720190328736.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Sicherheitsgruppen-ID (gibt den Workspace an):',
  p_source=>'SECURITY_GROUP_ID',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'DISPLAY_AND_SAVE',
  p_lov_columns=> null,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 32,
  p_cMaxlength=> 255,
  p_cHeight=> 1,
  p_tag_attributes  => 'class="fielddatabold"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 111843720754869910.4053+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Der Name des Workspace.';

wwv_flow_api.create_page_item(
  p_id=>3149427134444600.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 7.4053,
  p_name=>'F4050_P7_COMPANY_NAME',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 40,
  p_item_plug_id => 43187720190328736.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Workspace:',
  p_source=>'COMPANY_NAME',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'DISPLAY_AND_SAVE',
  p_lov_columns=> null,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 32,
  p_cMaxlength=> 255,
  p_cHeight=> 1,
  p_tag_attributes  => 'class="fielddatabold"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 111843720754869910.4053+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Die E-Mail-Adresse des Administrators für den Workspace.';

wwv_flow_api.create_page_item(
  p_id=>3151719586448120.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 7.4053,
  p_name=>'F4050_P7_ADMIN_EMAIL',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 50,
  p_item_plug_id => 43187720190328736.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'E-Mail-Adresse des Administrators:',
  p_source=>'ADMIN_EMAIL',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'DISPLAY_AND_SAVE',
  p_lov_columns=> null,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 32,
  p_cMaxlength=> 255,
  p_cHeight=> 1,
  p_tag_attributes  => 'class="fielddatabold"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 111843720754869910.4053+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Das Schema, das durch Provisioning bereitgestellt werden soll.';

wwv_flow_api.create_page_item(
  p_id=>3154014626450405.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 7.4053,
  p_name=>'F4050_P7_SCHEMA_NAME',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 60,
  p_item_plug_id => 43187720190328736.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Schemaname:',
  p_source=>'SCHEMA_NAME',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'DISPLAY_AND_SAVE',
  p_lov_columns=> null,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 32,
  p_cMaxlength=> 255,
  p_cHeight=> 1,
  p_tag_attributes  => 'class="fielddatabold"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 111843720754869910.4053+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Projektstatus.';

wwv_flow_api.create_page_item(
  p_id=>3156308803453087.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 7.4053,
  p_name=>'F4050_P7_PROJECT_STATUS',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 70,
  p_item_plug_id => 43187720190328736.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Projektstatus',
  p_source=>'PROJECT_STATUS',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'COMBOBOX',
  p_named_lov=> 'SERVICE.REQUEST.STATUS',
  p_lov => '.'||to_char(87755726864223308 + wwv_flow_api.g_id_offset)||'.',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 32,
  p_cMaxlength=> 255,
  p_cHeight=> 1,
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 111843720754869910.4053+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'YES',
  p_protection_level => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>52855125454514117.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 7.4053,
  p_name=>'F4050_P7_PREV_PROJ_STATUS',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 80,
  p_item_plug_id => 43187720190328736.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'F4050_P7_PREV_PROJ_STATUS',
  p_source=>'select project_status'||chr(10)||
''||chr(10)||
'from wwv_flow_provision_company'||chr(10)||
''||chr(10)||
'where id = :F4050_P7_ID',
  p_source_type=> 'QUERY',
  p_display_as=> 'HIDDEN',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_item_comment => '');
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 52862315508549089.4053 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 7.4053,
  p_validation_name => 'status error',
  p_validation_sequence=> 10,
  p_validation => 'if :F4050_P7_PREV_PROJ_STATUS = ''APPROVED'' then'||chr(10)||
''||chr(10)||
'  if :F4050_P7_PROJECT_STATUS = ''TERMINATED'' then'||chr(10)||
''||chr(10)||
'    return true;'||chr(10)||
''||chr(10)||
'  else'||chr(10)||
''||chr(10)||
'    return false;'||chr(10)||
''||chr(10)||
'  end if;'||chr(10)||
''||chr(10)||
'else'||chr(10)||
''||chr(10)||
'  return true;'||chr(10)||
''||chr(10)||
'end if;',
  p_validation_type => 'FUNC_BODY_RETURNING_BOOLEAN',
  p_error_message => 'Der genehmigte Service kann nur beendet werden. Jede andere Statusänderung führt zu einer Beschädigung der Daten.',
  p_when_button_pressed=> 43186036285311765.4053 + wwv_flow_api.g_id_offset,
  p_associated_item=> 3156308803453087.4053 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'#OWNER#:WWV_FLOW_PROVISION_COMPANY:T_PROVISION_ID:ID';

wwv_flow_api.create_page_process(
  p_id     => 43195820508328757.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 7.4053,
  p_process_sequence=> 1,
  p_process_point=> 'AFTER_HEADER',
  p_process_type=> 'DML_FETCH_ROW',
  p_process_name=> 'Fetch Row from WWV_FLOW_PROVISION_COMPANY',
  p_process_sql_clob => p, 
  p_process_error_message=> 'Fehler beim Abrufen von Zeile.',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'#OWNER#:WWV_FLOW_PROVISION_COMPANY:T_PROVISION_ID:ID|IUD';

wwv_flow_api.create_page_process(
  p_id     => 43196090106328758.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 7.4053,
  p_process_sequence=> 1,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'DML_PROCESS_ROW',
  p_process_name=> 'Process Row of WWV_FLOW_PROVISION_COMPANY',
  p_process_sql_clob => p, 
  p_process_error_message=> 'Fehler beim Verarbeiten von Zeile.',
  p_process_when_button_id=>43186036285311765.4053 + wwv_flow_api.g_id_offset,
  p_process_when=>'F4050_P7_PROJECT_STATUS',
  p_process_when_type=>'VAL_OF_ITEM_IN_COND_NOT_EQ_COND2',
  p_process_when2=>'TERMINATED',
  p_process_when_type2=>'',
  p_process_success_message=> 'Aktion wurde verarbeitet.',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'wwv_flow_provisioning.terminate_service(p_id=>:F4050_P7_ID);';

wwv_flow_api.create_page_process(
  p_id     => 52670212528973146.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 7.4053,
  p_process_sequence=> 10,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'terminate service',
  p_process_sql_clob => p, 
  p_process_error_message=> 'Fehler beim Beenden von Service.',
  p_process_when_button_id=>43186036285311765.4053 + wwv_flow_api.g_id_offset,
  p_process_when=>'F4050_P7_PROJECT_STATUS',
  p_process_when_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2',
  p_process_when2=>'TERMINATED',
  p_process_when_type2=>'',
  p_process_success_message=> 'Service wurde beendet.',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'wwv_flow_provisioning.delete_accepted_request(p_id=>:F4050_P7_ID);';

wwv_flow_api.create_page_process(
  p_id     => 22250501311969152.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 7.4053,
  p_process_sequence=> 20,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'delete service',
  p_process_sql_clob => p, 
  p_process_error_message=> 'Fehler beim Löschen von Service.',
  p_process_when_button_id=>23895428675298516.4053 + wwv_flow_api.g_id_offset,
  p_process_when=>'F4050_P26_STATUS',
  p_process_when_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2',
  p_process_when2=>'ACCEPTED',
  p_process_when_type2=>'',
  p_process_success_message=> 'Service gelöscht.',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 7.4053
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_8.405
prompt  ...PAGE 8.4053: Request löschen
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEADM/adm_create_wkspc.htm';

ph := null;
wwv_flow_api.create_page(
  p_id     => 8.4053,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'Request löschen',
  p_step_title=> 'Request löschen',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'AUTO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 216766430018595041+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => '',
  p_step_template => '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409160249',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>8.4053,p_text=>h);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'select * from wwv_flow_provision_company where id = :D_PROVISION_ID';

wwv_flow_api.create_report_region (
  p_id=> 2842620068855323.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 8.4053,
  p_name=> 'Provisioning Request',
  p_region_name=>'',
  p_template=> 2424107150426143.4053+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 40,
  p_display_column=> 1,
  p_display_point=> 'AFTER_SHOW_ITEMS',
  p_source=> s,
  p_source_type=> 'SQL_QUERY',
  p_display_error_message=> '#SQLERRM#',
  p_plug_caching=> 'NOT_CACHED',
  p_customized=> '0',
  p_query_row_template=> 2,
  p_query_headings_type=> 'COLON_DELMITED_LIST',
  p_query_num_rows=> '5',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_show_nulls_as=> '(null)',
  p_query_break_cols=> '0',
  p_query_num_rows_type=> '0',
  p_query_row_count_max=> '500',
  p_pagination_display_position=> 'BOTTOM_RIGHT',
  p_csv_output=> 'N',
  p_query_asc_image=> 'blue_arrow_down.gif',
  p_query_asc_image_attr=> 'width="13" height="12"',
  p_query_desc_image=> 'blue_arrow_up.gif',
  p_query_desc_image_attr=> 'width="13" height="12"',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48631213889771330.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 2842620068855323.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'ID',
  p_column_display_sequence=> 1,
  p_column_heading=> 'ID',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48631331903771330.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 2842620068855323.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'SECURITY_GROUP_ID',
  p_column_display_sequence=> 2,
  p_column_heading=> 'Workspace',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48631423316771330.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 2842620068855323.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 3,
  p_form_element_id=> null,
  p_column_alias=> 'COMPANY_NAME',
  p_column_display_sequence=> 3,
  p_column_heading=> 'Workspace-Name',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48631502805771331.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 2842620068855323.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 4,
  p_form_element_id=> null,
  p_column_alias=> 'ADMIN_FIRST_NAME',
  p_column_display_sequence=> 4,
  p_column_heading=> 'Vorname des Administrators',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48631615946771331.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 2842620068855323.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 5,
  p_form_element_id=> null,
  p_column_alias=> 'ADMIN_LAST_NAME',
  p_column_display_sequence=> 5,
  p_column_heading=> 'Nachname des Administrators',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48631701678771331.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 2842620068855323.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 6,
  p_form_element_id=> null,
  p_column_alias=> 'ADMIN_TITLE',
  p_column_display_sequence=> 6,
  p_column_heading=> 'Anrede für den Administrator',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48631811461771331.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 2842620068855323.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 7,
  p_form_element_id=> null,
  p_column_alias=> 'ADMIN_EMAIL',
  p_column_display_sequence=> 7,
  p_column_heading=> 'E-Mail-Adresse des Administrators',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48631925591771331.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 2842620068855323.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 8,
  p_form_element_id=> null,
  p_column_alias=> 'ADMIN_PHONE',
  p_column_display_sequence=> 8,
  p_column_heading=> 'Telefonnummer des Administrators',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48632024673771331.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 2842620068855323.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 9,
  p_form_element_id=> null,
  p_column_alias=> 'ADMIN_ID',
  p_column_display_sequence=> 9,
  p_column_heading=> 'Admin',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48632117814771331.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 2842620068855323.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 10,
  p_form_element_id=> null,
  p_column_alias=> 'ADMIN_USERID',
  p_column_display_sequence=> 10,
  p_column_heading=> 'Benutzer-ID für den Administrator',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48632218354771331.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 2842620068855323.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 11,
  p_form_element_id=> null,
  p_column_alias=> 'COMPANY_ADDRESS',
  p_column_display_sequence=> 11,
  p_column_heading=> 'Firmenadresse',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48632328727771331.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 2842620068855323.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 12,
  p_form_element_id=> null,
  p_column_alias=> 'CITY',
  p_column_display_sequence=> 12,
  p_column_heading=> 'Ort',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48632405878771332.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 2842620068855323.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 13,
  p_form_element_id=> null,
  p_column_alias=> 'STATE',
  p_column_display_sequence=> 13,
  p_column_heading=> 'Bundesland',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48632521698771332.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 2842620068855323.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 14,
  p_form_element_id=> null,
  p_column_alias=> 'ZIP',
  p_column_display_sequence=> 14,
  p_column_heading=> 'PLZ',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48632632685771332.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 2842620068855323.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 15,
  p_form_element_id=> null,
  p_column_alias=> 'COUNTRY',
  p_column_display_sequence=> 15,
  p_column_heading=> 'Land',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48632706380771332.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 2842620068855323.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 16,
  p_form_element_id=> null,
  p_column_alias=> 'COMPANY_TYPE',
  p_column_display_sequence=> 16,
  p_column_heading=> 'Firmentyp',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48632818574771332.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 2842620068855323.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 17,
  p_form_element_id=> null,
  p_column_alias=> 'COMPANY_WEBSITE',
  p_column_display_sequence=> 17,
  p_column_heading=> 'Website der Firma',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48632908699771332.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 2842620068855323.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 18,
  p_form_element_id=> null,
  p_column_alias=> 'NUMBER_OF_EMPLOYEES',
  p_column_display_sequence=> 18,
  p_column_heading=> 'Anzahl Mitarbeiter',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48633014812771332.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 2842620068855323.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 19,
  p_form_element_id=> null,
  p_column_alias=> 'COMPANY_PHONE',
  p_column_display_sequence=> 19,
  p_column_heading=> 'Telefonnummer der Firma',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48633113309771332.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 2842620068855323.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 20,
  p_form_element_id=> null,
  p_column_alias=> 'COMPANY_FAX',
  p_column_display_sequence=> 20,
  p_column_heading=> 'Faxnummer der Firma',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48633231303771332.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 2842620068855323.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 21,
  p_form_element_id=> null,
  p_column_alias=> 'ORACLE_PARTNER',
  p_column_display_sequence=> 21,
  p_column_heading=> 'Oracle-Partner',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48633303328771333.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 2842620068855323.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 22,
  p_form_element_id=> null,
  p_column_alias=> 'HOW_DID_YOU_HEAR_ABOUT_US',
  p_column_display_sequence=> 22,
  p_column_heading=> 'Wie haben Sie von uns erfahren',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48633407898771333.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 2842620068855323.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 23,
  p_form_element_id=> null,
  p_column_alias=> 'SERVICE_USE_STATUS',
  p_column_display_sequence=> 23,
  p_column_heading=> 'Verwendungsstatus für den Workspace',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48633520261771333.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 2842620068855323.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 24,
  p_form_element_id=> null,
  p_column_alias=> 'DATABASE_SIZE',
  p_column_display_sequence=> 24,
  p_column_heading=> 'Datenbankgröße',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48633625766771333.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 2842620068855323.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 25,
  p_form_element_id=> null,
  p_column_alias=> 'SERVICE_START_DATE',
  p_column_display_sequence=> 25,
  p_column_heading=> 'Workspace-Beginn am',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48633723979771333.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 2842620068855323.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 26,
  p_form_element_id=> null,
  p_column_alias=> 'SERVICE_TERMINATION_DATE',
  p_column_display_sequence=> 26,
  p_column_heading=> 'Workspace-Ende am',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48633823851771333.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 2842620068855323.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 27,
  p_form_element_id=> null,
  p_column_alias=> 'SCHEMA_NAME',
  p_column_display_sequence=> 27,
  p_column_heading=> 'Schemaname',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48633922599771333.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 2842620068855323.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 28,
  p_form_element_id=> null,
  p_column_alias=> 'ESTIMATED_END_USERS',
  p_column_display_sequence=> 28,
  p_column_heading=> 'Geschätzte Zahl der Endbenutzer',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48634022185771333.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 2842620068855323.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 29,
  p_form_element_id=> null,
  p_column_alias=> 'PAGE_VIEWS_PER_DAY',
  p_column_display_sequence=> 29,
  p_column_heading=> 'Seitenansichten pro Tag',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48634128002771334.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 2842620068855323.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 30,
  p_form_element_id=> null,
  p_column_alias=> 'PROJECT_DESCRIPTION',
  p_column_display_sequence=> 30,
  p_column_heading=> 'Projektbeschreibung',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48634202021771334.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 2842620068855323.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 31,
  p_form_element_id=> null,
  p_column_alias=> 'PROJECT_JUSTIFICATION',
  p_column_display_sequence=> 31,
  p_column_heading=> 'Projektbegründung',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48634307951771334.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 2842620068855323.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 32,
  p_form_element_id=> null,
  p_column_alias=> 'PROJECT_APPROVAL_DATE',
  p_column_display_sequence=> 32,
  p_column_heading=> 'Projekt genehmigt am',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48634404873771334.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 2842620068855323.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 33,
  p_form_element_id=> null,
  p_column_alias=> 'PROJECT_ACTUAL_BEGIN_DATE',
  p_column_display_sequence=> 33,
  p_column_heading=> 'Tatsächlicher Projektbeginn am',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48634508156771334.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 2842620068855323.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 34,
  p_form_element_id=> null,
  p_column_alias=> 'PROJECT_ACTUAL_END_DATE',
  p_column_display_sequence=> 34,
  p_column_heading=> 'Tatsächliches Projektende am',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48634623965771334.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 2842620068855323.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 35,
  p_form_element_id=> null,
  p_column_alias=> 'PROJECT_STATUS',
  p_column_display_sequence=> 35,
  p_column_heading=> 'Projektstatus',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48634727595771334.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 2842620068855323.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 36,
  p_form_element_id=> null,
  p_column_alias=> 'WORK_LOG',
  p_column_display_sequence=> 36,
  p_column_heading=> 'Arbeits-Log',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48634805072771335.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 2842620068855323.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 37,
  p_form_element_id=> null,
  p_column_alias=> 'REQUEST_DATE',
  p_column_display_sequence=> 37,
  p_column_heading=> 'Anforderungsdatum',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'Wenn der Workspace beendet oder verweigert wird, können Sie auf dieser Seite der gesamte Request aus dem System löschen. ';

wwv_flow_api.create_page_plug (
  p_id=> 56499914833442395.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 8.4053,
  p_plug_name=> 'Request löschen',
  p_region_name=>'',
  p_plug_template=> 79623830123907946.4053+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 30,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_03',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings => 'Edit:Seq.:Col.:Name:Display:Template:Source:Items:Buttons:BuildOption:DisplayWhenType',
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_num_rows => 500,
  p_plug_query_num_rows_type => 'ROWS_X_TO_Y_OF_Z',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top" align="right"',
  p_plug_query_show_nulls_as => '-',
  p_plug_query_col_allignments => 'L:L:L:L:L:L:L:R:R:L:L:L:L',
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 68367616058837770.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 8.4053,
  p_plug_name=> 'Menu',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 60,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(4585800473139662 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 4589126493175495.4053+ wwv_flow_api.g_id_offset,
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 227287494596.4053 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 8.4053,
  p_button_sequence=> 10,
  p_button_plug_id => 2842620068855323+wwv_flow_api.g_id_offset,
  p_button_name    => 'Cancel',
  p_button_image_alt=> 'Abbrechen',
  p_button_position=> 'REGION_TEMPLATE_CLOSE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_cattributes=>'class="button10"',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 227285494595.4053 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 8.4053,
  p_button_sequence=> 30,
  p_button_plug_id => 2842620068855323+wwv_flow_api.g_id_offset,
  p_button_name    => 'DeleteRequest',
  p_button_image_alt=> 'Request löschen',
  p_button_position=> 'REGION_TEMPLATE_DELETE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_cattributes=>'class="button10"',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>227291494598.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 8.4053,
  p_branch_action=> '26',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'BRANCH_TO_STEP',
  p_branch_when_button_id=>227285494595.4053+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
wwv_flow_api.create_page_branch(
  p_id=>227319764028.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 8.4053,
  p_branch_action=> '26',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'BRANCH_TO_STEP',
  p_branch_sequence=> 99,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Created 23-FEB-2001 20:36 by MIKE');
 
wwv_flow_api.create_page_branch(
  p_id=>227293494598.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 8.4053,
  p_branch_action=> '26',
  p_branch_point=> 'BEFORE_VALIDATION',
  p_branch_type=> 'BRANCH_TO_STEP',
  p_branch_when_button_id=>227287494596.4053+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>2847701305864055.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 8.4053,
  p_name=>'D_PROVISION_ID',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 2842620068855323.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'D_PROVISION_ID',
  p_source_type=> 'STATIC',
  p_display_as=> 'HIDDEN',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_item_comment => '');
 
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'wwv_flow_provisioning.delete_provision_request(p_id=>:D_PROVISION_ID);';

wwv_flow_api.create_page_process(
  p_id     => 2855101293879192.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 8.4053,
  p_process_sequence=> 10,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'delete request',
  p_process_sql_clob => p, 
  p_process_error_message=> 'Fehler beim Löschen von Workspace Request.',
  p_process_when_button_id=>227285494595.4053 + wwv_flow_api.g_id_offset,
  p_process_success_message=> 'Request wurde gelöscht.',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 8.4053
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_9.405
prompt  ...PAGE 9.4053: Anwendungen verwalten
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEADM/adm_app.htm';

ph := null;
wwv_flow_api.create_page(
  p_id     => 9.4053,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'Anwendungen verwalten',
  p_step_title=> 'Anwendungen verwalten',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'AUTO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 275228225185505839+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => '',
  p_step_template => 12930201930057128.4053+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409160250',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>9.4053,p_text=>h);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 6043204716910307.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 9.4053,
  p_plug_name=> 'Menu',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 30,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(4585800473139662 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 4589126493175495.4053+ wwv_flow_api.g_id_offset,
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 6043622896910308.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 9.4053,
  p_plug_name=> 'Manage Applications',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 80,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_02',
  p_plug_source=> s,
  p_plug_source_type=> 244253103570784647 + wwv_flow_api.g_id_offset,
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top" align="right"',
  p_plug_display_condition_type => '',
  p_plug_header=> '<table summary=""><tr><td valign="top"><img src="#IMAGE_PREFIX#menu/prod_apex_64.gif" width="64" height="64" alt="&PRODUCT_NAME." /></td><td valign="top">',
  p_plug_footer=> '</td></tr></table>',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'Sie können mit den Links auf dieser Seite die Berichte zu den Schlüsselattributen der Anwendungen in allen Workspaces anzeigen.';

wwv_flow_api.create_page_plug (
  p_id=> 179849815771897076.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 9.4053,
  p_plug_name=> 'Anwendungen',
  p_region_name=>'',
  p_plug_template=> 79623830123907946.4053+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 90,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_03',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
null;
 
end;
/

 
begin
 
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 9.4053
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_10.40
prompt  ...PAGE 10.4053: Workspaces verwalten
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'adm_mg_wrkspc_pg.htm';

ph := null;
wwv_flow_api.create_page(
  p_id     => 10.4053,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'Workspaces verwalten',
  p_step_title=> 'Workspaces verwalten',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'AUTO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 216765317551591446+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => '',
  p_step_template => 12930201930057128.4053+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409160250',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>10.4053,p_text=>h);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 6049701880928601.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 10.4053,
  p_plug_name=> 'Workspaces verwalten',
  p_region_name=>'',
  p_plug_template=> 75821319588166981.4053+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 50,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 19017606691432489 + wwv_flow_api.g_id_offset,
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_display_condition_type => '',
  p_plug_header=> '<table summary=""><tr><td valign="top"><img src="#IMAGE_PREFIX#menu/change_storage.gif" width="64" height="64" alt="&PRODUCT_NAME." /></td><td valign="top">',
  p_plug_footer=> '</td></tr></table>',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 6049911157928601.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 10.4053,
  p_plug_name=> 'Menu',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 30,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(4585800473139662 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 4589126493175495.4053+ wwv_flow_api.g_id_offset,
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'Bei einem Workspace handelt es sich um einen gemeinsamen Arbeitsbereich, in dem mehrere Entwickler Anwendungen erstellen können. Jeder Workspace ist zum Parsen als ein oder mehrere Datenbankschemas berechtigt.';

wwv_flow_api.create_page_plug (
  p_id=> 6144611534376254.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 10.4053,
  p_plug_name=> 'Workspaces verwalten',
  p_region_name=>'',
  p_plug_template=> 79623830123907946.4053+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 60,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_03',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'10332318553893424';

wwv_flow_api.create_page_plug (
  p_id=> 10332829289896519.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 10.4053,
  p_plug_name=> 'Workspace-Berichte',
  p_region_name=>'',
  p_plug_template=> 75821319588166981.4053+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 80,
  p_plug_display_column=> 2,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 10332318553893424 + wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_header=> '<table summary=""><tr><td valign="top"><img src="#IMAGE_PREFIX#menu/browse_db.gif" width="64" height="64" alt="&PRODUCT_NAME." /></td><td valign="top">',
  p_plug_footer=> '</td></tr></table>',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||':F4050_P79_SCHEMA_PASSWORD  := null;';

wwv_flow_api.create_page_plug (
  p_id=> 32847028451566366.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 10.4053,
  p_plug_name=> 'reset',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 70,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_HEADER',
  p_plug_source=> s,
  p_plug_source_type=> 'PLSQL_PROCEDURE',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 57460618757700816.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 10.4053,
  p_plug_name=> 'Requests verwalten',
  p_region_name=>'',
  p_plug_template=> 75821319588166981.4053+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 10,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 56669616639130949 + wwv_flow_api.g_id_offset,
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_display_condition_type => '',
  p_plug_header=> '<table summary=""><tr><td valign="top"><img src="#IMAGE_PREFIX#menu/logic_64.gif" width="64" height="64" alt="&PRODUCT_NAME." /></td><td valign="top">',
  p_plug_footer=> '</td></tr></table>',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
null;
 
end;
/

 
begin
 
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 10.4053
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_11.40
prompt  ...PAGE 11.4053: Anwendungsattribute
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEADM/adm_app.htm';

ph := null;
wwv_flow_api.create_page(
  p_id     => 11.4053,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'Anwendungsattribute',
  p_step_title=> 'Anwendungsattribute',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'AUTO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 275228225185505839+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => '',
  p_step_template => 12930201930057128.4053+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409160250',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>11.4053,p_text=>h);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'<p>In diesem Bericht werden die Schlüsselattribute der Anwendungen in allen Workspaces angezeigt.</p>';

wwv_flow_api.create_page_plug (
  p_id=> 179852526338937927.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 11.4053,
  p_plug_name=> 'Anwendungsattribute',
  p_region_name=>'',
  p_plug_template=> 79623830123907946.4053+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 20,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_03',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 244646517065077646.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 11.4053,
  p_plug_name=> 'Button Bar',
  p_region_name=>'',
  p_plug_template=> 104306421944266933.4053+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_02',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'select ID, '||chr(10)||
'(select short_name  from WWV_FLOW_COMPANIES where PROVISIONING_COMPANY_ID = f.security_group_id) SECURITY_GROUP_ID,'||chr(10)||
'OWNER,'||chr(10)||
'"NAME",'||chr(10)||
'LAST_UPDATED_BY, LAST_UPDATED_ON,'||chr(10)||
'(select count(*) from wwv_flow_steps where flow_id = f.id) pages,'||chr(10)||
'CHARSET,'||chr(10)||
'FLOW_LANGUAGE'||chr(10)||
'from WWV_FLOWS f'||chr(10)||
'where'||chr(10)||
'(:P11_APPLICATION_ID is null or :P11_APPLICATION_ID = id) and'||chr(10)||
'(:P11_PARSE_AS is null or instr(upper(owner),uppe';

s:=s||'r(:P11_PARSE_AS))>0 ) and'||chr(10)||
'(:P11_WORKSPACE is null or :P11_WORKSPACE = ''%''||''null%'' or :P11_WORKSPACE = ''0'' or security_group_id = :P11_WORKSPACE) and'||chr(10)||
'f.security_group_id != 10'||chr(10)||
'  ';

wwv_flow_api.create_report_region (
  p_id=> 244646920291077651.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 11.4053,
  p_name=> 'Applications',
  p_region_name=>'',
  p_template=> 0+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 10,
  p_display_column=> 1,
  p_display_point=> 'REGION_POSITION_02',
  p_source=> s,
  p_source_type=> 'SQL_QUERY',
  p_display_error_message=> 'Unable to show report. #SQLERRM#',
  p_display_condition_type=> 'NOT_DISPLAYING_INLINE_VALIDATION_ERRORS',
  p_plug_caching=> 'NOT_CACHED',
  p_customized=> '0',
  p_query_row_template=> 6897002870390711.4053+ wwv_flow_api.g_id_offset,
  p_query_headings_type=> 'COLON_DELMITED_LIST',
  p_query_num_rows=> '15',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_break_cols=> '1',
  p_query_no_data_found=> 'Bericht enthält keine Daten',
  p_query_num_rows_item=> 'P11_ROWS',
  p_query_num_rows_type=> 'ROW_RANGES_WITH_LINKS',
  p_query_row_count_max=> '5000000',
  p_pagination_display_position=> 'BOTTOM_RIGHT',
  p_break_type_flag=> 'DEFAULT_BREAK_FORMATTING',
  p_csv_output=> 'Y',
  p_csv_output_link_text=> 'Herunterladen',
  p_prn_output=> 'Y',
  p_prn_format=> 'PDF',
  p_prn_output_show_link=> 'Y',
  p_prn_output_link_text=> 'Drucken',
  p_prn_units=> 'INCHES',
  p_prn_paper_size=> 'LETTER',
  p_prn_width=> 11,
  p_prn_height=> 8.5,
  p_prn_orientation=> 'HORIZONTAL',
  p_prn_page_header=> '&PRODUCT_NAME.',
  p_prn_page_header_font_color=> '#000000',
  p_prn_page_header_font_family=> 'Helvetica',
  p_prn_page_header_font_weight=> 'normal',
  p_prn_page_header_font_size=> '12',
  p_prn_page_footer_font_color=> '#000000',
  p_prn_page_footer_font_family=> 'Helvetica',
  p_prn_page_footer_font_weight=> 'normal',
  p_prn_page_footer_font_size=> '12',
  p_prn_header_bg_color=> '#9bafde',
  p_prn_header_font_color=> '#ffffff',
  p_prn_header_font_family=> 'Helvetica',
  p_prn_header_font_weight=> 'normal',
  p_prn_header_font_size=> '10',
  p_prn_body_bg_color=> '#efefef',
  p_prn_body_font_color=> '#000000',
  p_prn_body_font_family=> 'Helvetica',
  p_prn_body_font_weight=> 'normal',
  p_prn_body_font_size=> '10',
  p_prn_border_width=> .5,
  p_query_asc_image=> 'arrow_down_gray_dark.gif',
  p_query_asc_image_attr=> 'width="13" height="12"',
  p_query_desc_image=> 'arrow_up_gray_dark.gif',
  p_query_desc_image_attr=> 'width="13" height="12"',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 244647311837077653.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 244646920291077651.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'ID',
  p_column_display_sequence=> 2,
  p_column_heading=> 'Anwendung',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>2,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_include_in_export=> 'Y',
  p_print_col_width=> '11',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 244647419939077653.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 244646920291077651.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'SECURITY_GROUP_ID',
  p_column_display_sequence=> 1,
  p_column_heading=> 'Workspace',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>1,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_print_col_width=> '11',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 244647518285077653.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 244646920291077651.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 3,
  p_form_element_id=> null,
  p_column_alias=> 'OWNER',
  p_column_display_sequence=> 3,
  p_column_heading=> 'Parsing-Schema',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_print_col_width=> '16',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 244647630044077653.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 244646920291077651.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 4,
  p_form_element_id=> null,
  p_column_alias=> 'NAME',
  p_column_display_sequence=> 4,
  p_column_heading=> 'Anwendungsname',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_print_col_width=> '16',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 244653905685088056.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 244646920291077651.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 5,
  p_form_element_id=> null,
  p_column_alias=> 'LAST_UPDATED_BY',
  p_column_display_sequence=> 5,
  p_column_heading=> 'Zuletzt aktualisiert',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_include_in_export=> 'Y',
  p_print_col_width=> '12',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 244654002969088057.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 244646920291077651.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 6,
  p_form_element_id=> null,
  p_column_alias=> 'LAST_UPDATED_ON',
  p_column_display_sequence=> 6,
  p_column_heading=> 'Datum',
  p_column_format=> 'SINCE',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_print_col_width=> '11',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 244654131547088057.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 244646920291077651.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 7,
  p_form_element_id=> null,
  p_column_alias=> 'PAGES',
  p_column_display_sequence=> 7,
  p_column_heading=> 'Seiten',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_include_in_export=> 'Y',
  p_print_col_width=> '11',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 244673802053124827.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 244646920291077651.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 8,
  p_form_element_id=> null,
  p_column_alias=> 'CHARSET',
  p_column_display_sequence=> 8,
  p_column_heading=> 'Character Set',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_include_in_export=> 'N',
  p_print_col_width=> '0',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 244673921910124827.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 244646920291077651.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 9,
  p_form_element_id=> null,
  p_column_alias=> 'FLOW_LANGUAGE',
  p_column_display_sequence=> 9,
  p_column_heading=> 'Sprache',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_print_col_width=> '11',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 244647719275077653.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 11.4053,
  p_plug_name=> 'menu',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(4585800473139662 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 4589126493175495.4053+ wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>244651516120077672.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 11.4053,
  p_branch_action=> 'f?p=&APP_ID.:11:&SESSION.::&DEBUG.:::',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_sequence=> 99,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Gibt das Schema an, auf dessen Basis das gesamte SQL und PL/SQL in der Anwendung geparst wird. Geben Sie ohne Berücksichtigung der Groß-/Kleinschreibung Abfragekriterien ein, und klicken Sie auf <b>Los</b>. ';

wwv_flow_api.create_page_item(
  p_id=>104348930306915451.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 11.4053,
  p_name=>'P11_PARSE_AS',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 23,
  p_item_plug_id => 244646517065077646.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Parsing-Schema',
  p_source_type=> 'STATIC',
  p_display_as=> 'TEXT',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 20,
  p_cMaxlength=> 2000,
  p_cHeight=> 5,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 343399818250317904.4053+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>244648805444077658.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 11.4053,
  p_name=>'P11_GO',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 25,
  p_item_plug_id => 244646517065077646.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default => 'GO',
  p_prompt=>'Los',
  p_source=>'GO',
  p_source_type=> 'STATIC',
  p_display_as=> 'BUTTON',
  p_lov_columns=> null,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> 2000,
  p_cHeight=> null,
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Schränken Sie die Anzeige durch Angabe einer Anwendungs-ID ein, und klicken Sie anschließend auf <b>Los</b>. ';

wwv_flow_api.create_page_item(
  p_id=>244649201162077658.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 11.4053,
  p_name=>'P11_APPLICATION_ID',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 22,
  p_item_plug_id => 244646517065077646.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Anwendung',
  p_post_element_text=>'&nbsp;&nbsp;',
  p_source_type=> 'STATIC',
  p_display_as=> 'POPUP',
  p_lov => 'select id||'': ''||name n, id from wwv_flows '||chr(10)||
' where id not between 4000 and 4999 '||chr(10)||
'order by id, name',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 7,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 3,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 343399818250317904.4053+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Um nach Workspace zu filtern, wählen Sie einen Workspace und klicken anschließend auf <b>Los</b>. Um Ergebnisse aus allen Workspaces zurückzugeben, wählen Sie <b>Alle Workspaces anzeigen</b>.';

wwv_flow_api.create_page_item(
  p_id=>244649927881077660.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 11.4053,
  p_name=>'P11_WORKSPACE',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 21,
  p_item_plug_id => 244646517065077646.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default => '0',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Workspace',
  p_source_type=> 'STATIC',
  p_display_as=> 'POPUP_KEY_LOV',
  p_named_lov=> 'LIST_DEVELOPER_WORKSPACES',
  p_lov => 'select ''- ''||'||chr(10)||
'wwv_flow_lang.system_message(''F4050_SHOW_ALL_WORKSPACES'')||'||chr(10)||
''' -'' d, 0 r from dual union all'||chr(10)||
'select short_name||'' (''||PROVISIONING_COMPANY_ID||'')'' d,'||chr(10)||
'       PROVISIONING_COMPANY_ID r'||chr(10)||
'from   WWV_FLOW_COMPANIES'||chr(10)||
'where  provisioning_company_id not in (0,10,11)'||chr(10)||
'order by 1',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 343399818250317904.4053+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Wählen Sie die Anzahl der Zeilen, die im Bericht angezeigt werden sollen, und klicken Sie anschließend auf <b>Los</b>.';

wwv_flow_api.create_page_item(
  p_id=>244680004739144514.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 11.4053,
  p_name=>'P11_ROWS',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 24,
  p_item_plug_id => 244646517065077646.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Anzeigen',
  p_post_element_text=>'&nbsp;&nbsp;',
  p_source=>'15',
  p_source_type=> 'STATIC',
  p_display_as=> 'COMBOBOX',
  p_lov => 'STATIC2:10,15,20,50,100,200,500,1000,5000',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 343399818250317904.4053+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_computation(
  p_id=> 244650723515077662.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 11.4053,
  p_computation_sequence => 1,
  p_computation_item=> 'P111_ID',
  p_computation_point=> 'AFTER_SUBMIT',
  p_computation_type=> 'STATIC_ASSIGNMENT',
  p_computation_processed=> 'REPLACE_EXISTING',
  p_computation=> '',
  p_compute_when => 'CREATE_ROW',
  p_compute_when_type=>'REQUEST_EQUALS_CONDITION');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 82841415173496344.4053 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 11.4053,
  p_validation_name => 'P11_APPLICATION_ID is Numeric',
  p_validation_sequence=> 10,
  p_validation => 'P11_APPLICATION_ID',
  p_validation_type => 'ITEM_IS_NUMERIC',
  p_error_message => 'Geben Sie einen numerischen Wert für die Anwendung ein',
  p_validation_condition=> 'P11_APPLICATION_ID',
  p_validation_condition_type=> 'ITEM_IS_NOT_NULL',
  p_when_button_pressed=> 244648805444077658.4053 + wwv_flow_api.g_id_offset,
  p_associated_item=> 244649201162077658.4053 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'reset_pagination';

wwv_flow_api.create_page_process(
  p_id     => 104315311662664109.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 11.4053,
  p_process_sequence=> 10,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'RESET_PAGINATION',
  p_process_name=> 'Reset Pagination',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_when_button_id=>244648805444077658.4053 + wwv_flow_api.g_id_offset,
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 11.4053
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_12.40
prompt  ...PAGE 12.4053: Entwickler und Benutzer verwalten
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEADM/adm_users.htm';

ph := null;
wwv_flow_api.create_page(
  p_id     => 12.4053,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'Entwickler und Benutzer verwalten',
  p_step_title=> 'Entwickler und Benutzer verwalten',
  p_step_sub_title => 'Report',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'AUTO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 216787602191653217+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => '',
  p_step_template => 19236405723931959.4053+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409160250',
  p_page_is_public_y_n=> 'N',
  p_protection_level=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>12.4053,p_text=>h);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'select '||chr(10)||
'u.user_name,'||chr(10)||
'u.first_name||'' ''||u.last_name fn,'||chr(10)||
'u.security_group_id,'||chr(10)||
'c.short_name "company_name", '||chr(10)||
'replace(u.default_schema,''%null''||''%'',null) "DefaultSchema",'||chr(10)||
'u.CREATION_DATE created, '||chr(10)||
'u.LAST_UPDATE_DATE last_updated,'||chr(10)||
'decode(user_name,''ADMIN'',null,'||chr(10)||
'''<a href="f?p=4050:53:''||:flow_session||'||chr(10)||
'    ''::NO:53:F4050_P53_USER_ID:''||u.user_id||''">''||'||chr(10)||
'wwv_flow_lang.system_message(''F4050.RESET'')||''</a';

s:=s||'>'') p,'||chr(10)||
'u.user_id'||chr(10)||
'from wwv_flow_fnd_user u, wwv_flow_companies c'||chr(10)||
'where c.provisioning_company_id = u.security_group_id'||chr(10)||
'and (:F4050_P12_FIND is null or instr(user_name,upper(:F4050_P12_FIND)) > 0)'||chr(10)||
'and ((:F4050_P12_COMPANY = ''0'' or :F4050_P12_COMPANY is null) or u.security_group_id = :F4050_P12_COMPANY)';

wwv_flow_api.create_report_region (
  p_id=> 6305760065.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 12.4053,
  p_name=> 'Manage Application Developers and Users',
  p_region_name=>'',
  p_template=> 0+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 10,
  p_display_column=> 1,
  p_display_point=> 'AFTER_SHOW_ITEMS',
  p_source=> s,
  p_source_type=> 'SQL_QUERY',
  p_display_error_message=> 'Unable to show report. #SQLERRM#',
  p_plug_caching=> 'NOT_CACHED',
  p_customized=> '0',
  p_ajax_enabled=> 'N',
  p_query_row_template=> 6897002870390711.4053+ wwv_flow_api.g_id_offset,
  p_query_headings_type=> 'COLON_DELMITED_LIST',
  p_query_num_rows=> '15',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_show_nulls_as=> ' -',
  p_query_break_cols=> '0',
  p_query_no_data_found=> 'Es wurden keine Benutzer gefunden.',
  p_query_num_rows_item=> 'F4050_P12_ROWS',
  p_query_num_rows_type=> 'ROW_RANGES_WITH_LINKS',
  p_query_row_count_max=> '5000',
  p_pagination_display_position=> 'BOTTOM_RIGHT',
  p_csv_output=> 'Y',
  p_csv_output_link_text=> 'Herunterladen',
  p_prn_output=> 'Y',
  p_prn_format=> 'PDF',
  p_prn_output_show_link=> 'Y',
  p_prn_output_link_text=> 'Drucken',
  p_prn_units=> 'INCHES',
  p_prn_paper_size=> 'LETTER',
  p_prn_width=> 11,
  p_prn_height=> 8.5,
  p_prn_orientation=> 'HORIZONTAL',
  p_prn_page_header=> '&PRODUCT_NAME.',
  p_prn_page_header_font_color=> '#000000',
  p_prn_page_header_font_family=> 'Helvetica',
  p_prn_page_header_font_weight=> 'normal',
  p_prn_page_header_font_size=> '12',
  p_prn_page_footer_font_color=> '#000000',
  p_prn_page_footer_font_family=> 'Helvetica',
  p_prn_page_footer_font_weight=> 'normal',
  p_prn_page_footer_font_size=> '12',
  p_prn_header_bg_color=> '#9bafde',
  p_prn_header_font_color=> '#ffffff',
  p_prn_header_font_family=> 'Helvetica',
  p_prn_header_font_weight=> 'normal',
  p_prn_header_font_size=> '8',
  p_prn_body_bg_color=> '#efefef',
  p_prn_body_font_color=> '#000000',
  p_prn_body_font_family=> 'Helvetica',
  p_prn_body_font_weight=> 'normal',
  p_prn_body_font_size=> '8',
  p_prn_border_width=> .5,
  p_query_asc_image=> 'arrow_down_gray_dark.gif',
  p_query_asc_image_attr=> 'width="13" height="12"',
  p_query_desc_image=> 'arrow_up_gray_dark.gif',
  p_query_desc_image_attr=> 'width="13" height="12"',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48897207662772958.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 6305760065.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'USER_NAME',
  p_column_display_sequence=> 1,
  p_column_heading=> 'Benutzer',
  p_column_link=>'f?p=&APP_ID.:23:&SESSION.::&DEBUG.:23,EDIT_USER_PRIVS:F4050_P23_USER_ID:#USER_ID#',
  p_column_linktext=>'#USER_NAME#',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>1,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'N',
  p_print_col_width=> '11',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48897314410772958.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 6305760065.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'FN',
  p_column_display_sequence=> 2,
  p_column_heading=> 'Vollständiger Name',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>2,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_print_col_width=> '11',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48897423061772959.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 6305760065.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 3,
  p_form_element_id=> null,
  p_column_alias=> 'SECURITY_GROUP_ID',
  p_column_display_sequence=> 3,
  p_column_heading=> 'Workspace-Nummer',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_include_in_export=> 'Y',
  p_print_col_width=> '11',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48897529140772959.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 6305760065.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 4,
  p_form_element_id=> null,
  p_column_alias=> 'company_name',
  p_column_display_sequence=> 4,
  p_column_heading=> 'Workspace',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_print_col_width=> '11',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48897619360772959.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 6305760065.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 5,
  p_form_element_id=> null,
  p_column_alias=> 'DefaultSchema',
  p_column_display_sequence=> 5,
  p_column_heading=> 'Standardschema',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_print_col_width=> '11',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48897713460772959.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 6305760065.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 6,
  p_form_element_id=> null,
  p_column_alias=> 'CREATED',
  p_column_display_sequence=> 6,
  p_column_heading=> 'Erstellt',
  p_column_format=> 'SINCE',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_print_col_width=> '11',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48897827691772959.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 6305760065.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 7,
  p_form_element_id=> null,
  p_column_alias=> 'LAST_UPDATED',
  p_column_display_sequence=> 7,
  p_column_heading=> 'Zuletzt aktualisiert',
  p_column_format=> 'SINCE',
  p_column_css_style=>'white-space: nowrap;',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_print_col_width=> '11',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48897908103772959.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 6305760065.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 8,
  p_form_element_id=> null,
  p_column_alias=> 'P',
  p_column_display_sequence=> 8,
  p_column_heading=> 'Kennwort',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_include_in_export=> 'Y',
  p_print_col_width=> '11',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 175940004529195689.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 6305760065.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 9,
  p_form_element_id=> null,
  p_column_alias=> 'USER_ID',
  p_column_display_sequence=> 9,
  p_column_heading=> 'User ID',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_include_in_export=> 'Y',
  p_print_col_width=> '11',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'<p>Die internen &PRODUCT_NAME.-Anwendungen (beispielsweise Application Builder und SQL Workshop) führen eine Authentifizierung für die Benutzer-ID-Daten mit den Einträgen im &PRODUCT_NAME.-Account-Repository aus. Auch von Benutzern entwickelte Anwendungen können dieses Account-Repository für die Authentifizierung verwenden.</p>'||chr(10)||
'<p> In diesem Bericht werden Einträge für Benutzernamen im Repository ';

s:=s||'pro Workspace angezeigt. Klicken Sie auf einen Benutzernamen im Bericht, um diesen Benutzer zu bearbeiten, oder auf <b>Erstellen</b>, um einen neuen Benutzer zu erstellen. Klicken Sie auf <b>Zurücksetzen</b>, wenn Sie das Kennwort für diesen Benutzer ändern möchten.</p>';

wwv_flow_api.create_page_plug (
  p_id=> 6318778195.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 12.4053,
  p_plug_name=> 'Entwickler und Benutzer',
  p_region_name=>'',
  p_plug_template=> 79623830123907946.4053+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 20,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_03',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 4747729056961631.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 12.4053,
  p_plug_name=> 'Menu',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(4585800473139662 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 4589126493175495.4053+ wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 190767901208450802.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 12.4053,
  p_plug_name=> 'button and filter bar',
  p_region_name=>'',
  p_plug_template=> 107311831567346457.4053+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 43040243631941918.4053 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 12.4053,
  p_button_sequence=> 10,
  p_button_plug_id => 190767901208450802+wwv_flow_api.g_id_offset,
  p_button_name    => 'Create New',
  p_button_image_alt=> 'Erstellen &gt;',
  p_button_position=> 'REGION_TEMPLATE_CREATE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=4050:23:&SESSION.::NO:23,EDIT_USER_PRIVS',
  p_button_cattributes=>'class="button10"',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>25567619615581607.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 12.4053,
  p_branch_action=> 'f?p=&FLOW_ID.:12:&SESSION.::&DEBUG.:::',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Created 11-MAY-2004 14:22 by MIKE');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Geben Sie eine Abfrage für den Benutzernamen oder einen Bestandteil des Benutzernamens (ohne Berücksichtigung der Groß-/Kleinschreibung) ein, und klicken Sie anschließend auf <b>Los</b>. ';

wwv_flow_api.create_page_item(
  p_id=>242041059533.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 12.4053,
  p_name=>'F4050_P12_FIND',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 190767901208450802.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Benutzer suchen',
  p_source_type=> 'STATIC',
  p_display_as=> 'TEXT',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 15,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 343399818250317904.4053+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>242044066789.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 12.4053,
  p_name=>'F4050_P12_GO',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 99,
  p_item_plug_id => 190767901208450802.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default => 'GO',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Los',
  p_source=>'GO',
  p_source_type=> 'STATIC',
  p_display_as=> 'BUTTON',
  p_lov_columns=> null,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'LEFT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Um nach Workspace zu filtern, wählen Sie einen Workspace und klicken anschließend auf <b>Los</b>. Um Ergebnisse aus allen Workspaces zurückzugeben, wählen Sie <b>Alle Workspaces</b>.';

wwv_flow_api.create_page_item(
  p_id=>177285325097953306.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 12.4053,
  p_name=>'F4050_P12_COMPANY',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 30,
  p_item_plug_id => 190767901208450802.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Workspace',
  p_source_type=> 'STATIC',
  p_display_as=> 'POPUP_KEY_LOV',
  p_named_lov=> 'LIST_ALL_COMPANIES',
  p_lov => 'select ''- ''||'||chr(10)||
'wwv_flow_lang.system_message(''F4050_SHOW_ALL_WORKSPACES'')||'||chr(10)||
''' -'' d, 0 r from dual union all'||chr(10)||
'select short_name||'' (''||PROVISIONING_COMPANY_ID||'')'' d,'||chr(10)||
'       PROVISIONING_COMPANY_ID r'||chr(10)||
'from   WWV_FLOW_COMPANIES'||chr(10)||
'where  provisioning_company_id > 0'||chr(10)||
'order by 1',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 20,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 343399818250317904.4053+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Wählen Sie die Anzahl der Zeilen, die im Bericht angezeigt werden sollen, und klicken Sie anschließend auf <b>Los</b>.';

wwv_flow_api.create_page_item(
  p_id=>177312409988975502.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 12.4053,
  p_name=>'F4050_P12_ROWS',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 44,
  p_item_plug_id => 190767901208450802.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Anzeigen',
  p_source=>'15',
  p_source_type=> 'STATIC',
  p_display_as=> 'COMBOBOX',
  p_named_lov=> 'MAX_ROWS_B',
  p_lov => '.'||to_char(87717417968152000 + wwv_flow_api.g_id_offset)||'.',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 343399818250317904.4053+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'reset_pagination';

wwv_flow_api.create_page_process(
  p_id     => 25564831604575604.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 12.4053,
  p_process_sequence=> 10,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'RESET_PAGINATION',
  p_process_name=> 'rp',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_when=>'GO',
  p_process_when_type=>'REQUEST_EQUALS_CONDITION',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 12.4053
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_13.40
prompt  ...PAGE 13.4053: Seitenansichten pro Betriebssystem
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEADM/adm_activity.htm';

ph := null;
wwv_flow_api.create_page(
  p_id     => 13.4053,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'Seitenansichten pro Betriebssystem',
  p_step_title=> 'Seitenansichten pro Betriebssystem',
  p_step_sub_title => 'Page Views by Operating System',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'AUTO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_help_text => ' ',
  p_html_page_header => '',
  p_step_template => '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409160250',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>13.4053,p_text=>h);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'with total_count as'||chr(10)||
'(select count(*) a '||chr(10)||
'from wwv_flow_activity_log '||chr(10)||
'where security_group_id = :flow_security_group_id and '||chr(10)||
'time_stamp >= sysdate - nvl(:P13_TIME,1)'||chr(10)||
') '||chr(10)||
'select os, page_views , 100*page_views/total_count.a pct, round(300*page_views/total_count.a) graph'||chr(10)||
'from ('||chr(10)||
'select '||chr(10)||
' x.os, '||chr(10)||
' sum(x.c) page_views'||chr(10)||
'from'||chr(10)||
'('||chr(10)||
'select session_id, max(decode(user_agent,null,'' Null'','||chr(10)||
'       nvl('||chr(10)||
'       decode(i';

s:=s||'nstr(user_agent,''Mac OS X''),0,'''',''Mac OS X'')||'||chr(10)||
'       decode(instr(user_agent,''Linux''),0,'''',''Linux'')||'||chr(10)||
'       decode(instr(user_agent,''Windows NT 5.0''),0,'''',''Windows 2000'')||'||chr(10)||
'       decode(instr(user_agent,''Windows NT 6.0''),0,'''',''Windows Vista'')||'||chr(10)||
'       decode(instr(user_agent,''Windows NT 5.1''),0,'''',''Windows XP''),'||chr(10)||
'       t.other))) os, count(*) c'||chr(10)||
'from wwv_flow_activity_log, '||chr(10)||
'    (select wwv_flow_';

s:=s||'lang.system_message(''other'') other from dual) t'||chr(10)||
'where security_group_id = :flow_security_group_id'||chr(10)||
'       and time_stamp >= sysdate - nvl(:P13_TIME,1)'||chr(10)||
'group by session_id'||chr(10)||
') x'||chr(10)||
'group by os) d, '||chr(10)||
'total_count'||chr(10)||
'where (:P13_SEARCH is null or instr(upper(os),upper(:P13_SEARCH)) > 0)';

wwv_flow_api.create_report_region (
  p_id=> 2584726337646135.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 13.4053,
  p_name=> 'Page Views by Operating System',
  p_region_name=>'',
  p_template=> 0+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 10,
  p_display_column=> 1,
  p_display_point=> 'AFTER_SHOW_ITEMS',
  p_source=> s,
  p_source_type=> 'SQL_QUERY',
  p_display_error_message=> '#SQLERRM#',
  p_plug_caching=> 'NOT_CACHED',
  p_customized=> '0',
  p_query_row_template=> 6897002870390711.4053+ wwv_flow_api.g_id_offset,
  p_query_headings_type=> 'COLON_DELMITED_LIST',
  p_query_num_rows=> '15',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_break_cols=> '0',
  p_query_no_data_found=> 'Keine Daten gefunden.',
  p_query_num_rows_item=> 'P13_ROWS',
  p_query_num_rows_type=> 'ROW_RANGES_IN_SELECT_LIST',
  p_query_row_count_max=> '5000',
  p_pagination_display_position=> 'BOTTOM_RIGHT',
  p_csv_output=> 'Y',
  p_csv_output_link_text=> 'Herunterladen',
  p_prn_output=> 'Y',
  p_prn_format=> 'PDF',
  p_prn_output_show_link=> 'Y',
  p_prn_output_link_text=> 'Drucken',
  p_prn_units=> 'INCHES',
  p_prn_paper_size=> 'LETTER',
  p_prn_width=> 11,
  p_prn_height=> 8.5,
  p_prn_orientation=> 'HORIZONTAL',
  p_prn_page_header=> '&PRODUCT_NAME.',
  p_prn_page_header_font_color=> '#000000',
  p_prn_page_header_font_family=> 'Helvetica',
  p_prn_page_header_font_weight=> 'normal',
  p_prn_page_header_font_size=> '12',
  p_prn_page_footer_font_color=> '#000000',
  p_prn_page_footer_font_family=> 'Helvetica',
  p_prn_page_footer_font_weight=> 'normal',
  p_prn_page_footer_font_size=> '12',
  p_prn_header_bg_color=> '#9bafde',
  p_prn_header_font_color=> '#ffffff',
  p_prn_header_font_family=> 'Helvetica',
  p_prn_header_font_weight=> 'normal',
  p_prn_header_font_size=> '10',
  p_prn_body_bg_color=> '#efefef',
  p_prn_body_font_color=> '#000000',
  p_prn_body_font_family=> 'Helvetica',
  p_prn_body_font_weight=> 'normal',
  p_prn_body_font_size=> '10',
  p_prn_border_width=> .5,
  p_query_asc_image=> 'arrow_down_gray_dark.gif',
  p_query_asc_image_attr=> 'width="13" height="12"',
  p_query_desc_image=> 'arrow_up_gray_dark.gif',
  p_query_desc_image_attr=> 'width="13" height="12"',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 3213125863900959.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 2584726337646135.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'OS',
  p_column_display_sequence=> 1,
  p_column_heading=> 'Betriebssystem',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>1,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_include_in_export=> 'Y',
  p_print_col_width=> '40',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 2585103254646189.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 2584726337646135.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'PAGE_VIEWS',
  p_column_display_sequence=> 2,
  p_column_heading=> 'Seitenansichten',
  p_column_format=> '999G999G999G999G999G999G990',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'Y',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_print_col_width=> '30',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 3213229658900959.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 2584726337646135.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 3,
  p_form_element_id=> null,
  p_column_alias=> 'PCT',
  p_column_display_sequence=> 3,
  p_column_heading=> 'Prozentsatz',
  p_column_format=> '999G999G999G999G990D00',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'Y',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_print_col_width=> '30',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 3213317952900970.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 2584726337646135.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 4,
  p_form_element_id=> null,
  p_column_alias=> 'GRAPH',
  p_column_display_sequence=> 4,
  p_column_heading=> '&nbsp;',
  p_column_html_expression=>'<div style="width:300px;height:14px;background:#dddddd;border-top:1px solid #aaaaaa;border-left:1px solid #aaaaaa;border-bottom:1px solid #ffffff;border-right:1px solid #ffffff;">'||chr(10)||
'<img src="#IMAGE_PREFIX#1px_trans.gif" width="#GRAPH#" height="14" border="0" style="background:#3f863f;"></div>',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'N',
  p_print_col_width=> '0',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 2589118765659862.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 13.4053,
  p_plug_name=> 'Breadcrumb',
  p_region_name=>'',
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(4585800473139662 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 4589126493175495.4053+ wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 108275219905850320.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 13.4053,
  p_plug_name=> 'Button Bar',
  p_region_name=>'',
  p_plug_template=> 107311831567346457.4053+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>3216823822918897.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 13.4053,
  p_branch_action=> 'f?p=&FLOW_ID.:13:&SESSION.',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_sequence=> 99,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Schränken Sie den Bericht auf einen bestimmten Zeitrahmen ein. Geben Sie die Dauer an, die für den Bericht berücksichtigt werden soll, und klicken Sie anschließend auf <b>Los</b>.<p />'||chr(10)||
'Wenn Sie 1 Tag auswählen, werden nur die letzten 24 Stunden angezeigt.  ';

wwv_flow_api.create_page_item(
  p_id=>3215505347913957.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 13.4053,
  p_name=>'P13_TIME',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 108275219905850320.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default => '1',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Aufnehmen',
  p_source=>'1',
  p_source_type=> 'STATIC',
  p_display_as=> 'COMBOBOX',
  p_named_lov=> 'RECENT_TIME',
  p_lov => 'select ''10 ''||wwv_flow_lang.system_message(initcap(''SECONDS'')) d, 10/(24*60*60) t from dual union all'||chr(10)||
'select ''1 ''||wwv_flow_lang.system_message(initcap(''MINUTE'')) d, 1/(24*60) t from dual union all'||chr(10)||
'select ''5 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 5/(24*60) t from dual union all'||chr(10)||
'select ''15 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 15/(24*60) t from dual union all'||chr(10)||
'select ''30 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 30/(24*60) t from dual union all'||chr(10)||
'select ''1 ''||wwv_flow_lang.system_message(initcap(''HOUR'')) d, 1/24 t from dual union all'||chr(10)||
'select ''2 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 1/12  t from dual union all'||chr(10)||
'select ''6 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 6/24 t from dual union all'||chr(10)||
'select ''8 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 8/24 t from dual union all'||chr(10)||
'select ''1 ''||wwv_flow_lang.system_message(initcap(''DAY'')) d, 1 t from dual union all'||chr(10)||
'select ''2 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 2 t from dual union all'||chr(10)||
'select ''1 ''||wwv_flow_lang.system_message(initcap(''WEEK'')) d, 7 t  from dual union all'||chr(10)||
'select ''2 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 14 t  from dual union all'||chr(10)||
'select ''4 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 28 t from dual union all'||chr(10)||
'select ''1 ''||wwv_flow_lang.system_message(initcap(''YEAR'')) d, 365 t from dual order by 2',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 343399818250317904.4053+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3216622316918896.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 13.4053,
  p_name=>'P13_GO',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 30,
  p_item_plug_id => 108275219905850320.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default => 'Go',
  p_prompt=>'Los',
  p_source=>'Go',
  p_source_type=> 'STATIC',
  p_display_as=> 'BUTTON',
  p_lov_columns=> null,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> 2000,
  p_cHeight=> null,
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Wählen Sie die Anzahl der Zeilen, die angezeigt werden sollen, und klicken Sie anschließend auf <b>Los</b>.';

wwv_flow_api.create_page_item(
  p_id=>92431227952006274.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 13.4053,
  p_name=>'P13_ROWS',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 20,
  p_item_plug_id => 108275219905850320.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default => '100',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Anzeigen',
  p_source_type=> 'STATIC',
  p_display_as=> 'COMBOBOX',
  p_named_lov=> 'MAX_ROWS_G',
  p_lov => '.'||to_char(87738929453259457 + wwv_flow_api.g_id_offset)||'.',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 343399818250317904.4053+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Geben Sie Abfragekriterien ohne Berücksichtigung der Groß-/Kleinschreibung ein, und klicken Sie anschließend auf <b>Los</b>.';

wwv_flow_api.create_page_item(
  p_id=>92433515962012317.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 13.4053,
  p_name=>'P13_SEARCH',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 4,
  p_item_plug_id => 108275219905850320.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Suche',
  p_source_type=> 'STATIC',
  p_display_as=> 'TEXT',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 343399818250317904.4053+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'reset_pagination';

wwv_flow_api.create_page_process(
  p_id     => 3217325779919882.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 13.4053,
  p_process_sequence=> 10,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'RESET_PAGINATION',
  p_process_name=> 'Reset Pagination',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_when_button_id=>3216622316918896.4053 + wwv_flow_api.g_id_offset,
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 13.4053
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_14.40
prompt  ...PAGE 14.4053: Workspace-Details
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEADM/adm_wrkspc_details.htm';

ph := null;
wwv_flow_api.create_page(
  p_id     => 14.4053,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'Workspace-Details',
  p_step_title=> 'Workspace-Details',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'NO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 216765317551591446+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => '',
  p_step_template => 12930201930057128.4053+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409160250',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>14.4053,p_text=>h);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 2882705150907846.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 14.4053,
  p_plug_name=> 'Button Box',
  p_region_name=>'',
  p_plug_template=> 107311831567346457.4053+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 5,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_02',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 81008210556197147.4053+ wwv_flow_api.g_id_offset,
  p_plug_query_headings => 'blue_arrow_down.gif::blue_arrow_up.gif:|2,3,4\1|'||chr(10)||
''||chr(10)||
'&nbsp;:'||chr(10)||
''||chr(10)||
'<font color="black" class="nounderline">Schema</font>:'||chr(10)||
''||chr(10)||
'<font color="black" class="nounderline">Company</font>:'||chr(10)||
''||chr(10)||
'<font color="black" class="nounderline">CompanyID</font>',
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_num_rows => 15,
  p_plug_query_num_rows_type => 'ROWS_X_TO_Y_OF_Z',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_query_show_nulls_as => '(null)',
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 4741924292941268.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 14.4053,
  p_plug_name=> 'Menu',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(4585800473139662 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 4589126493175495.4053+ wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'select grantee, privilege, admin_option from DBA_SYS_PRIVS'||chr(10)||
'where grantee in ('||chr(10)||
'select '||chr(10)||
'  distinct cs.SCHEMA'||chr(10)||
'from WWV_FLOW_COMPANY_SCHEMAS cs'||chr(10)||
'where '||chr(10)||
'      security_group_id = :sgid)';

wwv_flow_api.create_report_region (
  p_id=> 10319017935798659.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 14.4053,
  p_name=> '<a name="P"></a>Berechtigungen',
  p_region_name=>'',
  p_template=> 24544226211.4053+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 11,
  p_display_column=> 1,
  p_display_point=> 'REGION_POSITION_02',
  p_source=> s,
  p_source_type=> 'SQL_QUERY',
  p_display_error_message=> '#SQLERRM#',
  p_display_when_condition=> 'SGID',
  p_display_condition_type=> 'ITEM_NOT_NULL_OR_ZERO',
  p_plug_caching=> 'NOT_CACHED',
  p_customized=> '0',
  p_query_row_template=> 6897002870390711.4053+ wwv_flow_api.g_id_offset,
  p_query_headings_type=> 'COLON_DELMITED_LIST',
  p_query_num_rows=> '5000',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_show_nulls_as=> ' - ',
  p_query_break_cols=> '0',
  p_query_num_rows_type=> 'ROWS_X_TO_Y_OF_Z',
  p_query_row_count_max=> '5000',
  p_pagination_display_position=> 'BOTTOM_RIGHT',
  p_csv_output=> 'N',
  p_query_asc_image=> 'blue_arrow_down.gif',
  p_query_asc_image_attr=> 'width="13" height="12"',
  p_query_desc_image=> 'blue_arrow_up.gif',
  p_query_desc_image_attr=> 'width="13" height="12"',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 10322617767836478.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 10319017935798659.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'GRANTEE',
  p_column_display_sequence=> 1,
  p_column_heading=> 'Berechtigungsempfänger',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 10320909306812321.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 10319017935798659.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'PRIVILEGE',
  p_column_display_sequence=> 2,
  p_column_heading=> 'Berechtigung',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 10321019208812321.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 10319017935798659.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 3,
  p_form_element_id=> null,
  p_column_alias=> 'ADMIN_OPTION',
  p_column_display_sequence=> 3,
  p_column_heading=> 'Admin-Option',
  p_column_alignment=>'CENTER',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'TEXT_FROM_LOV',
  p_named_lov=>110344620122166929 + wwv_flow_api.g_id_offset,
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'select grantee, granted_role, admin_option, default_role from DBA_ROLE_PRIVS'||chr(10)||
'where grantee in ('||chr(10)||
'select '||chr(10)||
'  distinct cs.SCHEMA'||chr(10)||
'from WWV_FLOW_COMPANY_SCHEMAS cs'||chr(10)||
'where '||chr(10)||
'      security_group_id = :sgid)'||chr(10)||
'order by 2';

wwv_flow_api.create_report_region (
  p_id=> 10325826340857891.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 14.4053,
  p_name=> '<a name="RP"></a>Rollenberechtigungen',
  p_region_name=>'',
  p_template=> 24544226211.4053+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 26,
  p_display_column=> 1,
  p_display_point=> 'REGION_POSITION_02',
  p_source=> s,
  p_source_type=> 'SQL_QUERY',
  p_display_error_message=> '#SQLERRM#',
  p_display_when_condition=> 'SGID',
  p_display_condition_type=> 'ITEM_NOT_NULL_OR_ZERO',
  p_plug_caching=> 'NOT_CACHED',
  p_customized=> '0',
  p_query_row_template=> 6897002870390711.4053+ wwv_flow_api.g_id_offset,
  p_query_headings_type=> 'COLON_DELMITED_LIST',
  p_query_num_rows=> '15',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_show_nulls_as=> ' - ',
  p_query_break_cols=> '0',
  p_query_num_rows_type=> 'NEXT_PREVIOUS_LINKS',
  p_query_row_count_max=> '5000',
  p_pagination_display_position=> 'BOTTOM_RIGHT',
  p_csv_output=> 'N',
  p_query_asc_image=> 'blue_arrow_down.gif',
  p_query_asc_image_attr=> 'width="13" height="12"',
  p_query_desc_image=> 'blue_arrow_up.gif',
  p_query_desc_image_attr=> 'width="13" height="12"',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 10326230540857894.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 10325826340857891.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'GRANTEE',
  p_column_display_sequence=> 1,
  p_column_heading=> 'Berechtigungsempfänger',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 10326604308860937.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 10325826340857891.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'GRANTED_ROLE',
  p_column_display_sequence=> 2,
  p_column_heading=> 'Erteilte Rolle',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 10326129011857893.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 10325826340857891.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 3,
  p_form_element_id=> null,
  p_column_alias=> 'ADMIN_OPTION',
  p_column_display_sequence=> 3,
  p_column_heading=> 'Admin-Option',
  p_column_alignment=>'CENTER',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'TEXT_FROM_LOV',
  p_named_lov=>110344620122166929 + wwv_flow_api.g_id_offset,
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 10326726429860937.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 10325826340857891.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 4,
  p_form_element_id=> null,
  p_column_alias=> 'DEFAULT_ROLE',
  p_column_display_sequence=> 4,
  p_column_heading=> 'Standardrolle',
  p_column_alignment=>'CENTER',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'TEXT_FROM_LOV',
  p_named_lov=>110344620122166929 + wwv_flow_api.g_id_offset,
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'select a.name schemas, b.name tablespace'||chr(10)||
'  from sys.user$ a, sys.ts$ b, sys.seg$ c'||chr(10)||
' where a.user# = c.user#'||chr(10)||
'   and b.ts# = c.ts#'||chr(10)||
'   and a.name in (select schema'||chr(10)||
'                    from wwv_flow_company_schemas'||chr(10)||
'                   where security_group_id = :SGID)'||chr(10)||
'group by a.name, b.name';

wwv_flow_api.create_report_region (
  p_id=> 19293102374945196.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 14.4053,
  p_name=> '<a name="T"></a>Tablespace-Nutzung',
  p_region_name=>'',
  p_template=> 24544226211.4053+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 30,
  p_display_column=> 1,
  p_display_point=> 'REGION_POSITION_02',
  p_source=> s,
  p_source_type=> 'SQL_QUERY',
  p_display_error_message=> '#SQLERRM#',
  p_display_when_condition=> 'SGID',
  p_display_condition_type=> 'ITEM_NOT_NULL_OR_ZERO',
  p_plug_caching=> 'NOT_CACHED',
  p_customized=> '0',
  p_query_row_template=> 6897002870390711.4053+ wwv_flow_api.g_id_offset,
  p_query_headings_type=> 'COLON_DELMITED_LIST',
  p_query_num_rows=> '15',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_show_nulls_as=> ' - ',
  p_query_break_cols=> '1',
  p_query_no_data_found=> 'Es wurden keine Schemas gefunden.',
  p_query_num_rows_type=> 'ROW_RANGES_WITH_LINKS',
  p_query_row_count_max=> '5000',
  p_pagination_display_position=> 'BOTTOM_RIGHT',
  p_break_type_flag=> 'DEFAULT_BREAK_FORMATTING',
  p_csv_output=> 'N',
  p_query_asc_image=> 'blue_arrow_down.gif',
  p_query_asc_image_attr=> 'width="13" height="12"',
  p_query_desc_image=> 'blue_arrow_up.gif',
  p_query_desc_image_attr=> 'width="13" height="12"',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48651203572771436.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 19293102374945196.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'SCHEMAS',
  p_column_display_sequence=> 1,
  p_column_heading=> 'Schema',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 249727531231008914.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 19293102374945196.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'TABLESPACE',
  p_column_display_sequence=> 2,
  p_column_heading=> 'Tablespace',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'select id, name, owner'||chr(10)||
'  from wwv_flows'||chr(10)||
' where security_group_id = :SGID'||chr(10)||
'order by 1';

wwv_flow_api.create_report_region (
  p_id=> 19296329302971933.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 14.4053,
  p_name=> '<a name="A"></a>Anwendungen',
  p_region_name=>'',
  p_template=> 24544226211.4053+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 40,
  p_display_column=> 1,
  p_display_point=> 'REGION_POSITION_02',
  p_source=> s,
  p_source_type=> 'SQL_QUERY',
  p_display_error_message=> '#SQLERRM#',
  p_display_when_condition=> 'SGID',
  p_display_condition_type=> 'ITEM_NOT_NULL_OR_ZERO',
  p_plug_caching=> 'NOT_CACHED',
  p_customized=> '0',
  p_query_row_template=> 6897002870390711.4053+ wwv_flow_api.g_id_offset,
  p_query_headings_type=> 'COLON_DELMITED_LIST',
  p_query_num_rows=> '15',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_show_nulls_as=> ' - ',
  p_query_break_cols=> '0',
  p_query_no_data_found=> 'Keine Anwendungen im Workspace gefunden.',
  p_query_num_rows_type=> 'ROW_RANGES_WITH_LINKS',
  p_query_row_count_max=> '5000',
  p_pagination_display_position=> 'BOTTOM_RIGHT',
  p_csv_output=> 'N',
  p_query_asc_image=> 'arrow_down_gray_dark.gif',
  p_query_asc_image_attr=> 'width="13" height="12"',
  p_query_desc_image=> 'arrow_up_gray_dark.gif',
  p_query_desc_image_attr=> 'width="13" height="12"',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48947314555773241.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 19296329302971933.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'ID',
  p_column_display_sequence=> 1,
  p_column_heading=> 'ID',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'RIGHT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48947404897773241.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 19296329302971933.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'NAME',
  p_column_display_sequence=> 2,
  p_column_heading=> 'Name',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48947515967773241.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 19296329302971933.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 3,
  p_form_element_id=> null,
  p_column_alias=> 'OWNER',
  p_column_display_sequence=> 3,
  p_column_heading=> 'Schema',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'select userid, '||chr(10)||
'       decode(flow_id,null,wwv_flow_lang.system_message(''F4050.ALL'')) flows,'||chr(10)||
'       developer_role'||chr(10)||
'  from wwv_flow_developers'||chr(10)||
' where security_group_id = :SGID'||chr(10)||
'order by 1';

wwv_flow_api.create_report_region (
  p_id=> 19300200390001422.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 14.4053,
  p_name=> '<a name="D"></a>Entwickler',
  p_region_name=>'',
  p_template=> 24544226211.4053+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 50,
  p_display_column=> 1,
  p_display_point=> 'REGION_POSITION_02',
  p_source=> s,
  p_source_type=> 'SQL_QUERY',
  p_display_error_message=> '#SQLERRM#',
  p_display_when_condition=> 'SGID',
  p_display_condition_type=> 'ITEM_NOT_NULL_OR_ZERO',
  p_plug_caching=> 'NOT_CACHED',
  p_customized=> '0',
  p_query_row_template=> 6897002870390711.4053+ wwv_flow_api.g_id_offset,
  p_query_headings_type=> 'COLON_DELMITED_LIST',
  p_query_num_rows=> '15',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_show_nulls_as=> ' - ',
  p_query_break_cols=> '0',
  p_query_no_data_found=> 'Es wurden keine Entwickler gefunden.',
  p_query_num_rows_type=> 'ROW_RANGES_WITH_LINKS',
  p_query_row_count_max=> '500',
  p_pagination_display_position=> 'BOTTOM_RIGHT',
  p_csv_output=> 'N',
  p_query_asc_image=> 'arrow_down_gray_dark.gif',
  p_query_asc_image_attr=> 'width="13" height="12"',
  p_query_desc_image=> 'arrow_up_gray_dark.gif',
  p_query_desc_image_attr=> 'width="13" height="12"',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48586805124771044.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 19300200390001422.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'USERID',
  p_column_display_sequence=> 1,
  p_column_heading=> 'Benutzer-ID',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48586923612771044.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 19300200390001422.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'FLOWS',
  p_column_display_sequence=> 2,
  p_column_heading=> 'Application',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48587031940771044.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 19300200390001422.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 3,
  p_form_element_id=> null,
  p_column_alias=> 'DEVELOPER_ROLE',
  p_column_display_sequence=> 3,
  p_column_heading=> 'Role',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'select user_name, default_schema, email_address'||chr(10)||
'  from wwv_flow_fnd_user'||chr(10)||
' where security_group_id = :SGID'||chr(10)||
'order by 1';

wwv_flow_api.create_report_region (
  p_id=> 19325216245100571.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 14.4053,
  p_name=> '<a name="U"></a>&PRODUCT_NAME.-Benutzer',
  p_region_name=>'',
  p_template=> 24544226211.4053+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 60,
  p_display_column=> 1,
  p_display_point=> 'REGION_POSITION_02',
  p_source=> s,
  p_source_type=> 'SQL_QUERY',
  p_display_error_message=> '#SQLERRM#',
  p_display_when_condition=> 'SGID',
  p_display_condition_type=> 'ITEM_NOT_NULL_OR_ZERO',
  p_plug_caching=> 'NOT_CACHED',
  p_customized=> '0',
  p_query_row_template=> 6897002870390711.4053+ wwv_flow_api.g_id_offset,
  p_query_headings_type=> 'COLON_DELMITED_LIST',
  p_query_num_rows=> '15',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_show_nulls_as=> ' - ',
  p_query_break_cols=> '0',
  p_query_no_data_found=> 'Es wurden keine Benutzer gefunden.',
  p_query_num_rows_type=> 'ROW_RANGES_WITH_LINKS',
  p_query_row_count_max=> '5000',
  p_pagination_display_position=> 'BOTTOM_RIGHT',
  p_csv_output=> 'N',
  p_query_asc_image=> 'blue_arrow_down.gif',
  p_query_asc_image_attr=> 'width="13" height="12"',
  p_query_desc_image=> 'blue_arrow_up.gif',
  p_query_desc_image_attr=> 'width="13" height="12"',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48750515861771993.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 19325216245100571.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'USER_NAME',
  p_column_display_sequence=> 1,
  p_column_heading=> 'Benutzer',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48750606498771993.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 19325216245100571.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'DEFAULT_SCHEMA',
  p_column_display_sequence=> 2,
  p_column_heading=> 'Standardschema',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48750712681771993.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 19325216245100571.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 3,
  p_form_element_id=> null,
  p_column_alias=> 'EMAIL_ADDRESS',
  p_column_display_sequence=> 3,
  p_column_heading=> 'E-Mail',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'select o.object_type,'||chr(10)||
'       count(*) cnt'||chr(10)||
'  from sys.dba_objects o, wwv_flow_company_schemas s'||chr(10)||
' where o.owner = s.schema'||chr(10)||
'   and s.security_group_id = :SGID'||chr(10)||
' group by o.object_type'||chr(10)||
' order by 1';

wwv_flow_api.create_report_region (
  p_id=> 19477530238557418.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 14.4053,
  p_name=> '<a name="O"></a>Objekte nach Typ',
  p_region_name=>'',
  p_template=> 24544226211.4053+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 70,
  p_display_column=> 1,
  p_display_point=> 'REGION_POSITION_02',
  p_source=> s,
  p_source_type=> 'SQL_QUERY',
  p_display_error_message=> '#SQLERRM#',
  p_display_when_condition=> 'SGID',
  p_display_condition_type=> 'ITEM_NOT_NULL_OR_ZERO',
  p_plug_caching=> 'NOT_CACHED',
  p_customized=> '0',
  p_query_row_template=> 6897002870390711.4053+ wwv_flow_api.g_id_offset,
  p_query_headings_type=> 'COLON_DELMITED_LIST',
  p_query_num_rows=> '500',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_show_nulls_as=> ' - ',
  p_query_break_cols=> '0',
  p_query_no_data_found=> 'Es wurden keine Datenbankobjekte gefunden.',
  p_query_num_rows_type=> 'ROW_RANGES_WITH_LINKS',
  p_query_row_count_max=> '5000',
  p_pagination_display_position=> 'BOTTOM_RIGHT',
  p_csv_output=> 'N',
  p_query_asc_image=> 'arrow_down_gray_dark.gif',
  p_query_asc_image_attr=> 'width="13" height="12"',
  p_query_desc_image=> 'arrow_up_gray_dark.gif',
  p_query_desc_image_attr=> 'width="13" height="12"',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48612303647771184.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 19477530238557418.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'OBJECT_TYPE',
  p_column_display_sequence=> 1,
  p_column_heading=> 'Objekttyp',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48612428677771184.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 19477530238557418.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'CNT',
  p_column_display_sequence=> 2,
  p_column_heading=> 'Anzahl',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'RIGHT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'select SERVICE_NAME, SERVICE_ATTRIBUTE_1, REQUESTED_ON, REQUEST_STATUS'||chr(10)||
'               from   WWV_FLOW_PROVISION_SERICE_MOD'||chr(10)||
'               where  security_group_id = :SGID'||chr(10)||
'               order  by REQUESTED_ON desc';

wwv_flow_api.create_report_region (
  p_id=> 19485016657648074.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 14.4053,
  p_name=> '<a name="C"></a>Änderungsanforderungen',
  p_region_name=>'',
  p_template=> 24544226211.4053+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 80,
  p_display_column=> 1,
  p_display_point=> 'REGION_POSITION_02',
  p_source=> s,
  p_source_type=> 'SQL_QUERY',
  p_display_error_message=> '#SQLERRM#',
  p_display_when_condition=> 'SGID',
  p_display_condition_type=> 'ITEM_NOT_NULL_OR_ZERO',
  p_plug_caching=> 'NOT_CACHED',
  p_customized=> '0',
  p_query_row_template=> 6897002870390711.4053+ wwv_flow_api.g_id_offset,
  p_query_headings_type=> 'COLON_DELMITED_LIST',
  p_query_num_rows=> '15',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_show_nulls_as=> ' - ',
  p_query_break_cols=> '0',
  p_query_no_data_found=> 'Es wurden keine Änderungsanforderungen gefunden.',
  p_query_num_rows_type=> 'ROW_RANGES_WITH_LINKS',
  p_query_row_count_max=> '500',
  p_pagination_display_position=> 'BOTTOM_RIGHT',
  p_csv_output=> 'N',
  p_query_asc_image=> 'arrow_down_gray_dark.gif',
  p_query_asc_image_attr=> 'width="13" height="12"',
  p_query_desc_image=> 'arrow_up_gray_dark.gif',
  p_query_desc_image_attr=> 'width="13" height="12"',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48468627661770227.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 19485016657648074.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'SERVICE_NAME',
  p_column_display_sequence=> 1,
  p_column_heading=> 'Service-Name',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'TEXT_FROM_LOV',
  p_named_lov=>110368323210290856 + wwv_flow_api.g_id_offset,
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48468712741770227.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 19485016657648074.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'SERVICE_ATTRIBUTE_1',
  p_column_display_sequence=> 2,
  p_column_heading=> 'Service-Typ',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48468806292770227.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 19485016657648074.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 3,
  p_form_element_id=> null,
  p_column_alias=> 'REQUESTED_ON',
  p_column_display_sequence=> 3,
  p_column_heading=> 'Request-Datum',
  p_column_format=> '&DATE_TIME_FORMAT. Day',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48468912715770227.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 19485016657648074.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 4,
  p_form_element_id=> null,
  p_column_alias=> 'REQUEST_STATUS',
  p_column_display_sequence=> 4,
  p_column_heading=> 'Status',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'TEXT_FROM_LOV',
  p_named_lov=>87755726864223308 + wwv_flow_api.g_id_offset,
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'select time_stamp, elap, num_rows, userid, flow_id, step_id, session_id'||chr(10)||
'  from wwv_flow_activity_log'||chr(10)||
' where security_group_id = :SGID'||chr(10)||
'order by time_stamp desc';

wwv_flow_api.create_report_region (
  p_id=> 19487612857722745.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 14.4053,
  p_name=> '<a name="UA"></a>Benutzeraktivität',
  p_region_name=>'',
  p_template=> 24544226211.4053+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 90,
  p_display_column=> 1,
  p_display_point=> 'REGION_POSITION_02',
  p_source=> s,
  p_source_type=> 'SQL_QUERY',
  p_display_error_message=> '#SQLERRM#',
  p_display_when_condition=> 'SGID',
  p_display_condition_type=> 'ITEM_NOT_NULL_OR_ZERO',
  p_plug_caching=> 'NOT_CACHED',
  p_customized=> '0',
  p_query_row_template=> 6897002870390711.4053+ wwv_flow_api.g_id_offset,
  p_query_headings_type=> 'COLON_DELMITED_LIST',
  p_query_num_rows=> '15',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_show_nulls_as=> ' - ',
  p_query_break_cols=> '0',
  p_query_no_data_found=> 'Es wurden keine Benutzeraktivitäten gefunden.',
  p_query_num_rows_type=> 'NEXT_PREVIOUS_LINKS',
  p_query_row_count_max=> '5000',
  p_pagination_display_position=> 'BOTTOM_RIGHT',
  p_csv_output=> 'N',
  p_query_asc_image=> 'arrow_down_gray_dark.gif',
  p_query_asc_image_attr=> 'width="13" height="12"',
  p_query_desc_image=> 'arrow_up_gray_dark.gif',
  p_query_desc_image_attr=> 'width="13" height="12"',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48929215287773141.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 19487612857722745.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'TIME_STAMP',
  p_column_display_sequence=> 1,
  p_column_heading=> 'Datum',
  p_column_format=> 'SINCE',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48929325868773142.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 19487612857722745.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'ELAP',
  p_column_display_sequence=> 2,
  p_column_heading=> 'Verstrichene Zeit',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48929420088773142.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 19487612857722745.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 3,
  p_form_element_id=> null,
  p_column_alias=> 'NUM_ROWS',
  p_column_display_sequence=> 3,
  p_column_heading=> 'Anzahl Zeilen',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48929506819773142.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 19487612857722745.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 4,
  p_form_element_id=> null,
  p_column_alias=> 'USERID',
  p_column_display_sequence=> 4,
  p_column_heading=> 'Benutzer',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48929600468773142.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 19487612857722745.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 5,
  p_form_element_id=> null,
  p_column_alias=> 'FLOW_ID',
  p_column_display_sequence=> 5,
  p_column_heading=> 'Anwendung',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48929728695773142.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 19487612857722745.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 6,
  p_form_element_id=> null,
  p_column_alias=> 'STEP_ID',
  p_column_display_sequence=> 6,
  p_column_heading=> 'Seite',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48929825811773142.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 19487612857722745.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 7,
  p_form_element_id=> null,
  p_column_alias=> 'SESSION_ID',
  p_column_display_sequence=> 7,
  p_column_heading=> 'Session',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'select t.flow_user, '||chr(10)||
'       t.flow_id f,'||chr(10)||
'       t.page_id p, '||chr(10)||
'       t.audit_date, '||chr(10)||
'       t.flow_table,'||chr(10)||
'       t.audit_action'||chr(10)||
'  from wwv_flow_builder_audit_trail t'||chr(10)||
' where t.security_group_id = :SGID'||chr(10)||
'       order  by audit_date desc';

wwv_flow_api.create_report_region (
  p_id=> 19493704471814930.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 14.4053,
  p_name=> '<a name="DA"></a>Entwickleraktivität',
  p_region_name=>'',
  p_template=> 24544226211.4053+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 100,
  p_display_column=> 1,
  p_display_point=> 'REGION_POSITION_02',
  p_source=> s,
  p_source_type=> 'SQL_QUERY',
  p_display_error_message=> '#SQLERRM#',
  p_display_when_condition=> 'SGID',
  p_display_condition_type=> 'ITEM_IS_NOT_NULL',
  p_plug_caching=> 'NOT_CACHED',
  p_customized=> '0',
  p_query_row_template=> 6897002870390711.4053+ wwv_flow_api.g_id_offset,
  p_query_headings_type=> 'COLON_DELMITED_LIST',
  p_query_num_rows=> '15',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_show_nulls_as=> ' - ',
  p_query_break_cols=> '0',
  p_query_no_data_found=> 'Es wurden keine Entwickleraktivitäten gefunden.',
  p_query_num_rows_type=> 'NEXT_PREVIOUS_LINKS',
  p_query_row_count_max=> '5000',
  p_pagination_display_position=> 'BOTTOM_RIGHT',
  p_csv_output=> 'N',
  p_query_asc_image=> 'arrow_down_gray_dark.gif',
  p_query_asc_image_attr=> 'width="13" height="12"',
  p_query_desc_image=> 'arrow_up_gray_dark.gif',
  p_query_desc_image_attr=> 'width="13" height="12"',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48474601972770254.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 19493704471814930.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'FLOW_USER',
  p_column_display_sequence=> 1,
  p_column_heading=> 'Entwickler',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48474704585770254.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 19493704471814930.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'F',
  p_column_display_sequence=> 2,
  p_column_heading=> 'Anwendung',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'RIGHT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48474827707770254.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 19493704471814930.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 3,
  p_form_element_id=> null,
  p_column_alias=> 'P',
  p_column_display_sequence=> 3,
  p_column_heading=> 'Seite',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'RIGHT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48474904194770255.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 19493704471814930.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 4,
  p_form_element_id=> null,
  p_column_alias=> 'AUDIT_DATE',
  p_column_display_sequence=> 4,
  p_column_heading=> 'Datum',
  p_column_format=> 'SINCE',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 192900632028920805.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 19493704471814930.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 5,
  p_form_element_id=> null,
  p_column_alias=> 'FLOW_TABLE',
  p_column_display_sequence=> 5,
  p_column_heading=> 'Komponente',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'TEXT_FROM_LOV',
  p_named_lov=>192906504723933391 + wwv_flow_api.g_id_offset,
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 192901712766924762.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 19493704471814930.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 6,
  p_form_element_id=> null,
  p_column_alias=> 'AUDIT_ACTION',
  p_column_display_sequence=> 6,
  p_column_heading=> 'Aktion',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'TEXT_FROM_LOV',
  p_named_lov=>110357115975241430 + wwv_flow_api.g_id_offset,
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'select a.schema, c.name'||chr(10)||
'  from wwv_flow_company_schemas a, sys.user$ b, sys.ts$ c'||chr(10)||
' where a.schema = b.name'||chr(10)||
'   and b.datats# = c.ts#'||chr(10)||
'   and a.security_group_id = :SGID'||chr(10)||
'order by 1';

wwv_flow_api.create_report_region (
  p_id=> 20089917869255077.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 14.4053,
  p_name=> '<a name="S"></a>Schemas',
  p_region_name=>'',
  p_template=> 24544226211.4053+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 10,
  p_display_column=> 1,
  p_display_point=> 'REGION_POSITION_02',
  p_source=> s,
  p_source_type=> 'SQL_QUERY',
  p_display_error_message=> '#SQLERRM#',
  p_display_when_condition=> 'SGID',
  p_display_condition_type=> 'ITEM_NOT_NULL_OR_ZERO',
  p_plug_caching=> 'NOT_CACHED',
  p_customized=> '0',
  p_query_row_template=> 6897002870390711.4053+ wwv_flow_api.g_id_offset,
  p_query_headings_type=> 'COLON_DELMITED_LIST',
  p_query_num_rows=> '500',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_show_nulls_as=> ' - ',
  p_query_break_cols=> '0',
  p_query_num_rows_type=> 'ROWS_X_TO_Y_OF_Z',
  p_query_row_count_max=> '5000',
  p_pagination_display_position=> 'BOTTOM_RIGHT',
  p_csv_output=> 'N',
  p_query_asc_image=> 'blue_arrow_down.gif',
  p_query_asc_image_attr=> 'width="13" height="12"',
  p_query_desc_image=> 'blue_arrow_up.gif',
  p_query_desc_image_attr=> 'width="13" height="12"',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48908209419773034.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 20089917869255077.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'SCHEMA',
  p_column_display_sequence=> 1,
  p_column_heading=> 'Schema',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48908311720773034.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 20089917869255077.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'NAME',
  p_column_display_sequence=> 2,
  p_column_heading=> 'Default Tablespace',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'SELECT '||chr(10)||
'   "WWV_FLOW_COMPANIES"."PROVISIONING_COMPANY_ID" "PROVISIONING_COMPANY_ID", '||chr(10)||
'   "WWV_FLOW_COMPANIES"."SHORT_NAME" "SHORT_NAME", '||chr(10)||
'   "WWV_FLOW_COMPANIES"."FIRST_SCHEMA_PROVISIONED" "FIRST_SCHEMA_PROVISIONED"'||chr(10)||
'FROM '||chr(10)||
'   "WWV_FLOW_COMPANIES"'||chr(10)||
'WHERE (("WWV_FLOW_COMPANIES"."PROVISIONING_COMPANY_ID" =:SGID))';

wwv_flow_api.create_report_region (
  p_id=> 64835820002482322.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 14.4053,
  p_name=> '<a name="N"></a>Name',
  p_region_name=>'',
  p_template=> 24544226211.4053+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 8,
  p_display_column=> 1,
  p_display_point=> 'REGION_POSITION_02',
  p_source=> s,
  p_source_type=> 'STRUCTURED_QUERY',
  p_display_error_message=> '#SQLERRM#',
  p_display_when_condition=> 'SGID',
  p_display_condition_type=> 'ITEM_NOT_NULL_OR_ZERO',
  p_plug_caching=> 'NOT_CACHED',
  p_customized=> '0',
  p_query_row_template=> 3,
  p_query_headings_type=> 'COLON_DELMITED_LIST',
  p_query_num_rows=> '15',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_break_cols=> '0',
  p_query_num_rows_type=> '0',
  p_query_row_count_max=> '500',
  p_pagination_display_position=> 'BOTTOM_RIGHT',
  p_csv_output=> 'N',
  p_query_asc_image=> 'arrow_down_gray_dark.gif',
  p_query_asc_image_attr=> 'width="13" height="12"',
  p_query_desc_image=> 'arrow_up_gray_dark.gif',
  p_query_desc_image_attr=> 'width="13" height="12"',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 64836802284482356.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 64835820002482322.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'PROVISIONING_COMPANY_ID',
  p_column_display_sequence=> 1,
  p_column_heading=> 'Workspace',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 64837007099482356.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 64835820002482322.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'SHORT_NAME',
  p_column_display_sequence=> 2,
  p_column_heading=> 'Kurzname',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 64837209181482357.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 64835820002482322.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 3,
  p_form_element_id=> null,
  p_column_alias=> 'FIRST_SCHEMA_PROVISIONED',
  p_column_display_sequence=> 3,
  p_column_heading=> 'Erstes durch Provisioning bereitgestelltes Schema',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'167507730958837131';

wwv_flow_api.create_page_plug (
  p_id=> 167509724294854140.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 14.4053,
  p_plug_name=> 'Anchor',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 6,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_02',
  p_plug_source=> s,
  p_plug_source_type=> 167507730958837131 + wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => 'NEVER',
  p_plug_display_when_condition => 'SGID',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'Auf dieser Seite werden Berichte für den ausgewählten Workspace angezeigt.';

wwv_flow_api.create_page_plug (
  p_id=> 177744611327233052.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 14.4053,
  p_plug_name=> 'Workspace-Details',
  p_region_name=>'',
  p_plug_template=> 79623830123907946.4053+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 110,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_03',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 360939525109430983.4053 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 14.4053,
  p_button_sequence=> 10,
  p_button_plug_id => 64835820002482322+wwv_flow_api.g_id_offset,
  p_button_name    => 'EDIT_WS',
  p_button_image_alt=> 'Attribute bearbeiten',
  p_button_position=> 'REGION_TEMPLATE_EDIT',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=&APP_ID.:78:&SESSION.::&DEBUG.::P78_PROVISIONING_COMPANY_ID:&SGID.',
  p_button_condition=> 'SGID',
  p_button_condition2=> '10',
  p_button_condition_type=> 'VAL_OF_ITEM_IN_COND_NOT_EQ_COND2',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 360949518239533093.4053 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 14.4053,
  p_button_sequence=> 10,
  p_button_plug_id => 20089917869255077+wwv_flow_api.g_id_offset,
  p_button_name    => 'MAN_WS_SCHEMAS',
  p_button_image_alt=> 'Zuordnungen vom Workspace zum Schema',
  p_button_position=> 'REGION_TEMPLATE_EDIT',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=&APP_ID.:21:&SESSION.::&DEBUG.::P21_COMPANY:&SGID.',
  p_button_condition=> 'SGID',
  p_button_condition2=> '10',
  p_button_condition_type=> 'VAL_OF_ITEM_IN_COND_NOT_EQ_COND2',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 360979420167722897.4053 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 14.4053,
  p_button_sequence=> 10,
  p_button_plug_id => 19300200390001422+wwv_flow_api.g_id_offset,
  p_button_name    => 'MAN_APP_DEV',
  p_button_image_alt=> 'Anwendungsentwickler verwalten',
  p_button_position=> 'REGION_TEMPLATE_EDIT',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=&APP_ID.:12:&SESSION.::&DEBUG.::F4050_P12_COMPANY:&SGID.',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 361023100417991549.4053 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 14.4053,
  p_button_sequence=> 20,
  p_button_plug_id => 19325216245100571+wwv_flow_api.g_id_offset,
  p_button_name    => 'MAN_USERS',
  p_button_image_alt=> 'Benutzer verwalten',
  p_button_position=> 'REGION_TEMPLATE_EDIT',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=&APP_ID.:12:&SESSION.::&DEBUG.::F4050_P12_COMPANY:&SGID.',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>317937565640.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 14.4053,
  p_branch_action=> '14',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'BRANCH_TO_STEP',
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Wählen Sie einen Workspace, und klicken Sie anschließend auf <b>Los</b>.';

wwv_flow_api.create_page_item(
  p_id=>297977429861.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 14.4053,
  p_name=>'SGID',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 2882705150907846.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Workspace',
  p_source_type=> 'STATIC',
  p_display_as=> 'POPUP_KEY_LOV',
  p_lov => 'select short_name, PROVISIONING_COMPANY_ID'||chr(10)||
'from   WWV_FLOW_COMPANIES'||chr(10)||
'where provisioning_company_id != 0'||chr(10)||
'order  by short_name',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 343399818250317904.4053+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>19471711351438457.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 14.4053,
  p_name=>'P14_GO',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 20,
  p_item_plug_id => 2882705150907846.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default => 'GO',
  p_prompt=>'Los',
  p_source=>'GO',
  p_source_type=> 'STATIC',
  p_display_as=> 'BUTTON',
  p_lov_columns=> null,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> 2000,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'LEFT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'N',
  p_item_comment => '');
 
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'reset_pagination';

wwv_flow_api.create_page_process(
  p_id     => 19034431362034300.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 14.4053,
  p_process_sequence=> 10,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'RESET_PAGINATION',
  p_process_name=> 'reset pagination',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_when_button_id=>19471711351438457.4053 + wwv_flow_api.g_id_offset,
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 14.4053
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_15.40
prompt  ...PAGE 15.4053: Seitenansichten pro Browser
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEADM/adm_activity.htm';

ph := null;
wwv_flow_api.create_page(
  p_id     => 15.4053,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'Seitenansichten pro Browser',
  p_step_title=> 'Seitenansichten pro Browser',
  p_step_sub_title => 'Page Views by Browser',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'AUTO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_help_text => ' ',
  p_html_page_header => '',
  p_step_template => '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409160251',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>15.4053,p_text=>h);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'with total_count as'||chr(10)||
'(select count(*) a '||chr(10)||
'from wwv_flow_activity_log '||chr(10)||
'where security_group_id = :flow_security_group_id and '||chr(10)||
'time_stamp >= sysdate - nvl(:P15_TIME,1)) '||chr(10)||
'select os, page_views , 100*page_views/total_count.a pct, round(300*page_views/total_count.a) graph'||chr(10)||
'from ('||chr(10)||
'select '||chr(10)||
' x.os, '||chr(10)||
' sum(x.c) page_views'||chr(10)||
'from'||chr(10)||
'('||chr(10)||
'select session_id, max(decode(user_agent,null,''  Unknown '','||chr(10)||
'       nvl('||chr(10)||
'       deco';

s:=s||'de(instr(user_agent,''MSIE''),0,'''',''MSIE'')||'||chr(10)||
'       decode(instr(user_agent,''Firefox''),0,'''',''Firefox'')||'||chr(10)||
'       decode(instr(user_agent,''Safari''),0,'''',''Safari'')||'||chr(10)||
'       decode(instr(user_agent,''Opra''),0,'''',''Opra''),'||chr(10)||
'       ''Other''))) os, '||chr(10)||
'       count(*) c'||chr(10)||
'from wwv_flow_activity_log'||chr(10)||
'where security_group_id = :flow_security_group_id'||chr(10)||
'       and time_stamp >= sysdate - nvl(:P15_TIME,1)'||chr(10)||
'group by session';

s:=s||'_id'||chr(10)||
') x'||chr(10)||
'group by os) d, total_count';

wwv_flow_api.create_report_region (
  p_id=> 2597607668687988.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 15.4053,
  p_name=> 'Page Views by Browser',
  p_region_name=>'',
  p_template=> 0+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 10,
  p_display_column=> 1,
  p_display_point=> 'AFTER_SHOW_ITEMS',
  p_source=> s,
  p_source_type=> 'SQL_QUERY',
  p_display_error_message=> '#SQLERRM#',
  p_plug_caching=> 'NOT_CACHED',
  p_customized=> '0',
  p_query_row_template=> 6897002870390711.4053+ wwv_flow_api.g_id_offset,
  p_query_headings_type=> 'COLON_DELMITED_LIST',
  p_query_num_rows=> '15',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_break_cols=> '0',
  p_query_no_data_found=> 'Keine Daten gefunden.',
  p_query_num_rows_type=> 'ROW_RANGES_IN_SELECT_LIST',
  p_query_row_count_max=> '500',
  p_pagination_display_position=> 'BOTTOM_RIGHT',
  p_csv_output=> 'Y',
  p_csv_output_link_text=> 'Herunterladen',
  p_prn_output=> 'Y',
  p_prn_format=> 'PDF',
  p_prn_output_show_link=> 'Y',
  p_prn_output_link_text=> 'Drucken',
  p_prn_units=> 'INCHES',
  p_prn_paper_size=> 'LETTER',
  p_prn_width=> 11,
  p_prn_height=> 8.5,
  p_prn_orientation=> 'HORIZONTAL',
  p_prn_page_header=> '&PRODUCT_NAME.',
  p_prn_page_header_font_color=> '#000000',
  p_prn_page_header_font_family=> 'Helvetica',
  p_prn_page_header_font_weight=> 'normal',
  p_prn_page_header_font_size=> '12',
  p_prn_page_footer_font_color=> '#000000',
  p_prn_page_footer_font_family=> 'Helvetica',
  p_prn_page_footer_font_weight=> 'normal',
  p_prn_page_footer_font_size=> '12',
  p_prn_header_bg_color=> '#9bafde',
  p_prn_header_font_color=> '#ffffff',
  p_prn_header_font_family=> 'Helvetica',
  p_prn_header_font_weight=> 'normal',
  p_prn_header_font_size=> '10',
  p_prn_body_bg_color=> '#efefef',
  p_prn_body_font_color=> '#000000',
  p_prn_body_font_family=> 'Helvetica',
  p_prn_body_font_weight=> 'normal',
  p_prn_body_font_size=> '10',
  p_prn_border_width=> .5,
  p_query_asc_image=> 'arrow_down_gray_dark.gif',
  p_query_asc_image_attr=> 'width="13" height="12"',
  p_query_desc_image=> 'arrow_up_gray_dark.gif',
  p_query_desc_image_attr=> 'width="13" height="12"',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 2597921064687990.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 2597607668687988.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'OS',
  p_column_display_sequence=> 1,
  p_column_heading=> 'Browser',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>1,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_include_in_export=> 'Y',
  p_print_col_width=> '50',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 2598028849688000.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 2597607668687988.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'PAGE_VIEWS',
  p_column_display_sequence=> 2,
  p_column_heading=> 'Seitenansichten',
  p_column_format=> '999G999G999G999G999G999G990',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'Y',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_print_col_width=> '25',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 3207811487858971.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 2597607668687988.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 3,
  p_form_element_id=> null,
  p_column_alias=> 'PCT',
  p_column_display_sequence=> 3,
  p_column_heading=> 'Prozentsatz',
  p_column_format=> '999G999G999G999G999G999G990D00',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'Y',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_print_col_width=> '25',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 3207921931858972.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 2597607668687988.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 4,
  p_form_element_id=> null,
  p_column_alias=> 'GRAPH',
  p_column_display_sequence=> 4,
  p_column_heading=> '&nbsp;',
  p_column_html_expression=>'<div style="width:300px;height:14px;background:#dddddd;border-top:1px solid #aaaaaa;border-left:1px solid #aaaaaa;border-bottom:1px solid #ffffff;border-right:1px solid #ffffff;">'||chr(10)||
'<img src="#IMAGE_PREFIX#1px_trans.gif" width="#GRAPH#" height="14" border="0" style="background:#3f863f;"></div>',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'N',
  p_print_col_width=> '0',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 2600007168694328.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 15.4053,
  p_plug_name=> 'Breadcrumb',
  p_region_name=>'',
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(4585800473139662 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 4589126493175495.4053+ wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 108279024884861232.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 15.4053,
  p_plug_name=> 'Button Bar',
  p_region_name=>'',
  p_plug_template=> 107311831567346457.4053+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>3210226447872086.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 15.4053,
  p_branch_action=> 'f?p=&FLOW_ID.:15:&SESSION.',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_sequence=> 99,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Schränken Sie den Bericht auf einen bestimmten Zeitrahmen ein. Geben Sie die Dauer an, die für den Bericht berücksichtigt werden soll, und klicken Sie anschließend auf <b>Los</b>.<p />'||chr(10)||
'Wenn Sie 1 Tag auswählen, werden nur die letzten 24 Stunden angezeigt.  ';

wwv_flow_api.create_page_item(
  p_id=>3208727763863613.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 15.4053,
  p_name=>'P15_TIME',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 108279024884861232.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default => '1',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Aufnehmen',
  p_source=>'1',
  p_source_type=> 'STATIC',
  p_display_as=> 'COMBOBOX',
  p_named_lov=> 'RECENT_TIME',
  p_lov => 'select ''10 ''||wwv_flow_lang.system_message(initcap(''SECONDS'')) d, 10/(24*60*60) t from dual union all'||chr(10)||
'select ''1 ''||wwv_flow_lang.system_message(initcap(''MINUTE'')) d, 1/(24*60) t from dual union all'||chr(10)||
'select ''5 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 5/(24*60) t from dual union all'||chr(10)||
'select ''15 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 15/(24*60) t from dual union all'||chr(10)||
'select ''30 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 30/(24*60) t from dual union all'||chr(10)||
'select ''1 ''||wwv_flow_lang.system_message(initcap(''HOUR'')) d, 1/24 t from dual union all'||chr(10)||
'select ''2 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 1/12  t from dual union all'||chr(10)||
'select ''6 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 6/24 t from dual union all'||chr(10)||
'select ''8 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 8/24 t from dual union all'||chr(10)||
'select ''1 ''||wwv_flow_lang.system_message(initcap(''DAY'')) d, 1 t from dual union all'||chr(10)||
'select ''2 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 2 t from dual union all'||chr(10)||
'select ''1 ''||wwv_flow_lang.system_message(initcap(''WEEK'')) d, 7 t  from dual union all'||chr(10)||
'select ''2 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 14 t  from dual union all'||chr(10)||
'select ''4 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 28 t from dual union all'||chr(10)||
'select ''1 ''||wwv_flow_lang.system_message(initcap(''YEAR'')) d, 365 t from dual order by 2',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 343399818250317904.4053+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>3210024085872083.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 15.4053,
  p_name=>'P15_GO',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 20,
  p_item_plug_id => 108279024884861232.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default => 'Go',
  p_prompt=>'Los',
  p_source=>'Go',
  p_source_type=> 'STATIC',
  p_display_as=> 'BUTTON',
  p_lov_columns=> null,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> 2000,
  p_cHeight=> null,
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'N',
  p_item_comment => '');
 
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 15.4053
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_16.40
prompt  ...PAGE 16.4053: Feature-Konfiguration
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEADM/adm_env.htm';

ph := null;
wwv_flow_api.create_page(
  p_id     => 16.4053,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'Feature-Konfiguration',
  p_step_title=> 'Feature-Konfiguration',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'NO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 216766702444596508+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => '',
  p_step_template => 12930201930057128.4053+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409160251',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>16.4053,p_text=>h);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 4611532520262367.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 16.4053,
  p_plug_name=> 'Menu',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 10,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(4585800473139662 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 4589126493175495.4053+ wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'<div id="ContentArea" style="display:none;">';

wwv_flow_api.create_page_plug (
  p_id=> 73660722701725213.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 16.4053,
  p_plug_name=> 'Start Div',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 40,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> 'Error displaying region',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_num_rows => 15,
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'</div>';

wwv_flow_api.create_page_plug (
  p_id=> 73660928304725215.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 16.4053,
  p_plug_name=> 'End Div',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 80,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> 'Error displaying region',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_num_rows => 15,
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 169304800930079016.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 16.4053,
  p_plug_name=> '<a name="A"></a>Anwendungsentwicklung',
  p_region_name=>'',
  p_plug_template=> 24544226211.4053+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 50,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 169306214436082917.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 16.4053,
  p_plug_name=> '<a name="C"></a>SQL Workshop',
  p_region_name=>'',
  p_plug_template=> 24544226211.4053+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 60,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 169312431105116196.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 16.4053,
  p_plug_name=> '<a name="M"></a>Überwachung',
  p_region_name=>'',
  p_plug_template=> 24544226211.4053+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 70,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 169386325798256586.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 16.4053,
  p_plug_name=> 'Button Box',
  p_region_name=>'',
  p_plug_template=> 4888405638168833.4053+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 20,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'169592700462495276';

wwv_flow_api.create_page_plug (
  p_id=> 169598411936526905.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 16.4053,
  p_plug_name=> 'Anchor',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 30,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 169592700462495276 + wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 12936728094071536.4053 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 16.4053,
  p_button_sequence=> 10,
  p_button_plug_id => 169386325798256586+wwv_flow_api.g_id_offset,
  p_button_name    => 'CANCEL',
  p_button_image_alt=> 'Abbrechen',
  p_button_position=> 'REGION_TEMPLATE_CLOSE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=&APP_ID.:5:&SESSION.::&DEBUG.:::',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 169388709307261209.4053 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 16.4053,
  p_button_sequence=> 10,
  p_button_plug_id => 169386325798256586+wwv_flow_api.g_id_offset,
  p_button_name    => 'APPLY_CHANGES',
  p_button_image_alt=> 'Änderungen anwenden',
  p_button_position=> 'REGION_TEMPLATE_CREATE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>637743863872055.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 16.4053,
  p_branch_action=> '5',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'BRANCH_TO_STEP',
  p_branch_sequence=> 99,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Sie können die Überwachung in SQL Workshop aktivieren oder deaktivieren.';

wwv_flow_api.create_page_item(
  p_id=>169297610580053441.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 16.4053,
  p_name=>'P16_ALLOW_DB_MONITOR',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 169312431105116196.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default => 'Y',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Datenbanküberwachung aktivieren',
  p_source_type=> 'STATIC',
  p_display_as=> 'COMBOBOX',
  p_named_lov=> 'YES_NO_RETURNS_Y_OR_N',
  p_lov => '.'||to_char(157992123774592395 + wwv_flow_api.g_id_offset)||'.',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 4000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 111843720754869910.4053+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Wenn Entwickler Datenbankprozeduren, Packages und Funktionen durchsuchen, können sie standardmäßig den PL/SQL-Quellcode ändern und kompilieren. Um das Bearbeiten und die Kompilierung von PL/SQL-Programmblöcken im Objektbrowser zu deaktivieren, wählen Sie <b>Nein</b>.';

wwv_flow_api.create_page_item(
  p_id=>169297816049053446.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 16.4053,
  p_name=>'P16_PLSQL_EDITING',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 20,
  p_item_plug_id => 169304800930079016.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default => 'Y',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Bearbeiten von PL/SQL-Programmblock zulassen',
  p_source_type=> 'STATIC',
  p_display_as=> 'COMBOBOX',
  p_named_lov=> 'YES_NO_RETURNS_Y_OR_N',
  p_lov => '.'||to_char(157992123774592395 + wwv_flow_api.g_id_offset)||'.',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 4000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 111843720754869910.4053+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Dieser Parameter steuert den Erstellvorgang für Demoanwendungen und Demo-Datenbankobjekte beim Erstellen von neuen Workspaces. Um das Erstellen von Demoanwendungen zu deaktivieren, wählen Sie <b>Nein</b>.  '||chr(10)||
'';

wwv_flow_api.create_page_item(
  p_id=>169298013657053447.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 16.4053,
  p_name=>'P16_WORKSPACE_P_DEMO_OBJECT',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 30,
  p_item_plug_id => 169304800930079016.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default => 'Y',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Demonstrationsobjekte in neuen Workspaces erstellen',
  p_source_type=> 'STATIC',
  p_display_as=> 'COMBOBOX',
  p_named_lov=> 'YES_NO_RETURNS_Y_OR_N',
  p_lov => '.'||to_char(157992123774592395 + wwv_flow_api.g_id_offset)||'.',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 4000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 111843720754869910.4053+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Geben Sie die maximale Wartezeit an, die ein transaktionaler Befehl in SQL Command Processor wartet, bis ein Timeout eintritt.';

wwv_flow_api.create_page_item(
  p_id=>169299221292053451.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 16.4053,
  p_name=>'P16_SQL_C_MAX_INACTIVITY',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 90,
  p_item_plug_id => 169306214436082917.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default => '60',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Maximale Inaktivität für SQL-Befehle in Minuten',
  p_source_type=> 'STATIC',
  p_display_as=> 'TEXT',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 4000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 111843720754869910.4053+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Geben Sie die maximale Ausgabe an, die ein SQL-Skript generieren kann. SQL-Skripts werden in SQL Workshop ausgeführt.';

wwv_flow_api.create_page_item(
  p_id=>169299418817053452.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 16.4053,
  p_name=>'P16_SQL_SCRIPT_MAX_OUTPUT_SIZE',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 100,
  p_item_plug_id => 169306214436082917.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Maximale Ausgabegröße für das SQL-Skript in Byte',
  p_source_type=> 'STATIC',
  p_display_as=> 'TEXT',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 4000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 111843720754869910.4053+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Geben Sie den maximalen Speicherplatz für alle Skripts eines Workspace an. SQL-Skriptergebnisse werden generiert, wenn SQL-Skripts von SQL Command Processor ausgeführt werden.';

wwv_flow_api.create_page_item(
  p_id=>169299604071053452.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 16.4053,
  p_name=>'P16_WORKSPACE_MAX_OUTPUT_SIZE',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 110,
  p_item_plug_id => 169306214436082917.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Maximale Ausgabegröße für den SQL-Skript-Workspace in Byte',
  p_source_type=> 'STATIC',
  p_display_as=> 'TEXT',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 4000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 111843720754869910.4053+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Geben Sie die Maximalgröße eines SQL-Skripts an, das in SQL Workshop verwendet wird.';

wwv_flow_api.create_page_item(
  p_id=>169299802122053454.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 16.4053,
  p_name=>'P16_MAX_SCRIPT_SIZE',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 120,
  p_item_plug_id => 169306214436082917.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Maximale Skriptgröße für das SQL-Skript in Byte',
  p_source_type=> 'STATIC',
  p_display_as=> 'TEXT',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 4000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 111843720754869910.4053+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Sie können transaktionale SQL-Befehle für die gesamte Instanz aktivieren, damit Benutzer mehrere SQL-Befehle in derselben physischen Datenbanktransaktion absetzen können.';

wwv_flow_api.create_page_item(
  p_id=>175483619946469918.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 16.4053,
  p_name=>'P16_ENABLE_TRANSACTIONAL_SQL',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 130,
  p_item_plug_id => 169306214436082917.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default => 'N',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Transaktionale SQL-Befehle aktivieren',
  p_source_type=> 'STATIC',
  p_display_as=> 'COMBOBOX',
  p_named_lov=> 'YES_NO_RETURNS_Y_OR_N',
  p_lov => '.'||to_char(157992123774592395 + wwv_flow_api.g_id_offset)||'.',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 111843720754869910.4053+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_computation(
  p_id=> 637919682872057.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 16.4053,
  p_computation_sequence => 1,
  p_computation_item=> 'F4050_P15_ID',
  p_computation_point=> 'AFTER_SUBMIT',
  p_computation_type=> 'STATIC_ASSIGNMENT',
  p_computation_processed=> 'REPLACE_EXISTING',
  p_computation=> '',
  p_computation_comment=> 'Set the value of the item conainting the primary key to null when asked to create a new row.',
  p_compute_when => 'CREATE_ROW',
  p_compute_when_type=>'REQUEST_EQUALS_CONDITION');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 169656715464057857.4053 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 16.4053,
  p_validation_name => 'P16_SQL_C_MAX_INACTIVITY Not Null',
  p_validation_sequence=> 1,
  p_validation => 'P16_SQL_C_MAX_INACTIVITY',
  p_validation_type => 'ITEM_NOT_NULL',
  p_error_message => 'Wert muss angegeben werden.',
  p_associated_item=> 169299221292053451.4053 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> 'generated 19-APR-2005 19:48');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 169656912645057859.4053 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 16.4053,
  p_validation_name => 'P16_SQL_SCRIPT_MAX_OUTPUT_SIZE Not Null',
  p_validation_sequence=> 2,
  p_validation => 'P16_SQL_SCRIPT_MAX_OUTPUT_SIZE',
  p_validation_type => 'ITEM_NOT_NULL',
  p_error_message => 'Wert muss angegeben werden.',
  p_associated_item=> 169299418817053452.4053 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> 'generated 19-APR-2005 19:48');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 169657123504057860.4053 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 16.4053,
  p_validation_name => 'P16_WORKSPACE_MAX_OUTPUT_SIZE Not Null',
  p_validation_sequence=> 3,
  p_validation => 'P16_WORKSPACE_MAX_OUTPUT_SIZE',
  p_validation_type => 'ITEM_NOT_NULL',
  p_error_message => 'Wert muss angegeben werden.',
  p_associated_item=> 169299604071053452.4053 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'ON_ERROR_PAGE',
  p_validation_comment=> 'generated 19-APR-2005 19:48');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 169657306009057860.4053 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 16.4053,
  p_validation_name => 'P16_MAX_SCRIPT_SIZE Not Null',
  p_validation_sequence=> 4,
  p_validation => 'P16_MAX_SCRIPT_SIZE',
  p_validation_type => 'ITEM_NOT_NULL',
  p_error_message => 'Wert muss angegeben werden.',
  p_associated_item=> 169299802122053454.4053 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> 'generated 19-APR-2005 19:48');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 171947423698040938.4053 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 16.4053,
  p_validation_name => 'P16_SQL_C_MAX_INACTIVITY must be positive integer',
  p_validation_sequence=> 20,
  p_validation => 'declare'||chr(10)||
'    l_number number;'||chr(10)||
'begin'||chr(10)||
'    l_number := to_number( :P16_SQL_C_MAX_INACTIVITY );'||chr(10)||
'    if l_number = abs(trunc(l_number)) then'||chr(10)||
'        return TRUE;'||chr(10)||
'    else '||chr(10)||
'        return FALSE;'||chr(10)||
'    end if;'||chr(10)||
'exception'||chr(10)||
'    when others then'||chr(10)||
'        return FALSE;'||chr(10)||
'end;',
  p_validation_type => 'FUNC_BODY_RETURNING_BOOLEAN',
  p_error_message => 'Der Wert muss eine positive Ganzzahl sein.',
  p_when_button_pressed=> 169388709307261209.4053 + wwv_flow_api.g_id_offset,
  p_associated_item=> 169299221292053451.4053 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 172007922499154166.4053 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 16.4053,
  p_validation_name => 'P16_SQL_SCRIPT_MAX_OUTPUT_SIZE positive integer',
  p_validation_sequence=> 30,
  p_validation => 'declare'||chr(10)||
'    l_number number;'||chr(10)||
'begin'||chr(10)||
'    l_number := to_number( :P16_SQL_SCRIPT_MAX_OUTPUT_SIZE );'||chr(10)||
'    if l_number = abs(trunc(l_number)) then'||chr(10)||
'        return TRUE;'||chr(10)||
'    else '||chr(10)||
'        return FALSE;'||chr(10)||
'    end if;'||chr(10)||
'exception'||chr(10)||
'    when others then'||chr(10)||
'        return FALSE;'||chr(10)||
'end;',
  p_validation_type => 'FUNC_BODY_RETURNING_BOOLEAN',
  p_error_message => 'Der Wert muss eine positive Ganzzahl sein.',
  p_when_button_pressed=> 169388709307261209.4053 + wwv_flow_api.g_id_offset,
  p_associated_item=> 169299418817053452.4053 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 172010617436162145.4053 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 16.4053,
  p_validation_name => 'P16_WORKSPACE_MAX_OUTPUT_SIZE positive integer',
  p_validation_sequence=> 40,
  p_validation => 'declare'||chr(10)||
'    l_number number;'||chr(10)||
'begin'||chr(10)||
'    l_number := to_number( :P16_WORKSPACE_MAX_OUTPUT_SIZE );'||chr(10)||
'    if l_number = abs(trunc(l_number)) then'||chr(10)||
'        return TRUE;'||chr(10)||
'    else '||chr(10)||
'        return FALSE;'||chr(10)||
'    end if;'||chr(10)||
'exception'||chr(10)||
'    when others then'||chr(10)||
'        return FALSE;'||chr(10)||
'end;',
  p_validation_type => 'FUNC_BODY_RETURNING_BOOLEAN',
  p_error_message => 'Der Wert muss eine positive Ganzzahl sein.',
  p_when_button_pressed=> 169388709307261209.4053 + wwv_flow_api.g_id_offset,
  p_associated_item=> 169299604071053452.4053 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 172014314796170894.4053 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 16.4053,
  p_validation_name => 'P16_MAX_SCRIPT_SIZE positive integer',
  p_validation_sequence=> 50,
  p_validation => 'declare'||chr(10)||
'    l_number number;'||chr(10)||
'begin'||chr(10)||
'    l_number := to_number( :P16_MAX_SCRIPT_SIZE );'||chr(10)||
'    if l_number = abs(trunc(l_number)) then'||chr(10)||
'        return TRUE;'||chr(10)||
'    else '||chr(10)||
'        return FALSE;'||chr(10)||
'    end if;'||chr(10)||
'exception'||chr(10)||
'    when others then'||chr(10)||
'        return FALSE;'||chr(10)||
'end;',
  p_validation_type => 'FUNC_BODY_RETURNING_BOOLEAN',
  p_error_message => 'Der Wert muss eine positive Ganzzahl sein.',
  p_when_button_pressed=> 169388709307261209.4053 + wwv_flow_api.g_id_offset,
  p_associated_item=> 169299802122053454.4053 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||':P16_PLSQL_EDITING := '||chr(10)||
'    wwv_flow_platform.get_preference( p_preference_name => ''PLSQL_EDITING'' );'||chr(10)||
''||chr(10)||
':P16_WORKSPACE_P_DEMO_OBJECT := '||chr(10)||
'    wwv_flow_platform.get_preference( p_preference_name => ''WORKSPACE_PROVISION_DEMO_OBJECTS'' );'||chr(10)||
''||chr(10)||
':P16_SQL_C_MAX_INACTIVITY := '||chr(10)||
'    wwv_flow_platform.get_preference( p_preference_name => ''SQL_COMMAND_MAX_INACTIVITY'' );'||chr(10)||
''||chr(10)||
':P16_SQL_SCRIPT_MAX_OUTPUT_SIZE := '||chr(10)||
'    wwv_f';

p:=p||'low_platform.get_preference( p_preference_name => ''SQL_SCRIPT_MAX_OUTPUT_SIZE'' );'||chr(10)||
''||chr(10)||
':P16_WORKSPACE_MAX_OUTPUT_SIZE := '||chr(10)||
'    wwv_flow_platform.get_preference( p_preference_name => ''WORKSPACE_MAX_OUTPUT_SIZE'' );'||chr(10)||
''||chr(10)||
':P16_MAX_SCRIPT_SIZE := '||chr(10)||
'    wwv_flow_platform.get_preference( p_preference_name => ''MAX_SCRIPT_SIZE'' );'||chr(10)||
''||chr(10)||
':P16_ALLOW_DB_MONITOR := '||chr(10)||
'    wwv_flow_platform.get_preference( p_preference_name => ';

p:=p||'''ALLOW_DB_MONITOR'' );'||chr(10)||
''||chr(10)||
':P16_ENABLE_TRANSACTIONAL_SQL := '||chr(10)||
'    wwv_flow_platform.get_preference( p_preference_name => ''ENABLE_TRANSACTIONAL_SQL'' );';

wwv_flow_api.create_page_process(
  p_id     => 169602917870557035.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 16.4053,
  p_process_sequence=> 20,
  p_process_point=> 'AFTER_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'Fetch values from platform prefs table',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'wwv_flow_platform.set_preference( p_preference_name => ''PLSQL_EDITING'','||chr(10)||
'                                  p_preference_value => :P16_PLSQL_EDITING );'||chr(10)||
''||chr(10)||
'wwv_flow_platform.set_preference( p_preference_name => ''WORKSPACE_PROVISION_DEMO_OBJECTS'','||chr(10)||
'                                  p_preference_value => :P16_WORKSPACE_P_DEMO_OBJECT );'||chr(10)||
''||chr(10)||
'wwv_flow_platform.set_preference( p_preference_name => ''SQL_COMMAND_M';

p:=p||'AX_INACTIVITY'','||chr(10)||
'                                  p_preference_value => :P16_SQL_C_MAX_INACTIVITY );'||chr(10)||
''||chr(10)||
'wwv_flow_platform.set_preference( p_preference_name => ''SQL_SCRIPT_MAX_OUTPUT_SIZE'','||chr(10)||
'                                  p_preference_value => :P16_SQL_SCRIPT_MAX_OUTPUT_SIZE );'||chr(10)||
''||chr(10)||
'wwv_flow_platform.set_preference( p_preference_name => ''WORKSPACE_MAX_OUTPUT_SIZE'','||chr(10)||
'                                  p_p';

p:=p||'reference_value => :P16_WORKSPACE_MAX_OUTPUT_SIZE );'||chr(10)||
''||chr(10)||
'wwv_flow_platform.set_preference( p_preference_name => ''MAX_SCRIPT_SIZE'','||chr(10)||
'                                  p_preference_value => :P16_MAX_SCRIPT_SIZE );'||chr(10)||
''||chr(10)||
'wwv_flow_platform.set_preference( p_preference_name => ''ALLOW_DB_MONITOR'','||chr(10)||
'                                  p_preference_value => :P16_ALLOW_DB_MONITOR );'||chr(10)||
''||chr(10)||
'wwv_flow_platform.set_preference( ';

p:=p||'p_preference_name => ''ENABLE_TRANSACTIONAL_SQL'','||chr(10)||
'                                  p_preference_value => :P16_ENABLE_TRANSACTIONAL_SQL );'||chr(10)||
'commit;';

wwv_flow_api.create_page_process(
  p_id     => 169524720875349790.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 16.4053,
  p_process_sequence=> 10,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'Apply Changes',
  p_process_sql_clob => p, 
  p_process_error_message=> 'Speichern von Feature-Konfigurationseinstellungen nicht möglich.',
  p_process_when_button_id=>169388709307261209.4053 + wwv_flow_api.g_id_offset,
  p_process_success_message=> 'Feature-Konfigurationseinstellungen wurden gespeichert.',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'16';

wwv_flow_api.create_page_process(
  p_id     => 35198113704069357.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 16.4053,
  p_process_sequence=> 20,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'CLEAR_CACHE_FOR_PAGES',
  p_process_name=> 'clear',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 16.4053
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_17.40
prompt  ...PAGE 17.4053: Site-spezifische Tasks erstellen/bearbeiten
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEADM/adm_tasklist.htm';

ph := null;
wwv_flow_api.create_page(
  p_id     => 17.4053,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'Site-spezifische Tasks erstellen/bearbeiten',
  p_step_title=> 'Site-spezifische Tasks erstellen/bearbeiten',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'AUTO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 216789322970659213+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => '',
  p_step_template => 12930201930057128.4053+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409160251',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>17.4053,p_text=>h);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 951214632736321.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 17.4053,
  p_plug_name=> 'Menu',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(4585800473139662 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 4589126493175495.4053+ wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 951627136736335.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 17.4053,
  p_plug_name=> 'Site-spezifische Tasks',
  p_region_name=>'',
  p_plug_template=> 2424107150426143.4053+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 10,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> 'Unable to show report. #SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> 'generated 04-MAR-2001 19:43:24');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'<p>Geben Sie die Tasks für die Site-spezifischen Task-Listen an, die auf der Seite für die Workspace-Anmeldung und der Workspace-Homepage angezeigt werden.</p>'||chr(10)||
'<p>Um zu bestimmen, ob eine Task angezeigt wird, wählen Sie in der Liste für die angezeigten Elemente <b>Ja</b> oder <b>Nein</b>.</p>';

wwv_flow_api.create_page_plug (
  p_id=> 952029128736337.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 17.4053,
  p_plug_name=> 'Site-spezifische Tasks',
  p_region_name=>'',
  p_plug_template=> 79623830123907946.4053+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 20,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_03',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 952400766736345.4053 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 17.4053,
  p_button_sequence=> 3,
  p_button_plug_id => 951627136736335+wwv_flow_api.g_id_offset,
  p_button_name    => 'Apply Changes',
  p_button_image_alt=> 'Änderungen anwenden',
  p_button_position=> 'REGION_TEMPLATE_CHANGE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_condition=> 'P17_ID',
  p_button_condition_type=> 'ITEM_IS_NOT_NULL',
  p_button_cattributes=>'class="button10"',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 952714907736406.4053 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 17.4053,
  p_button_sequence=> 1,
  p_button_plug_id => 951627136736335+wwv_flow_api.g_id_offset,
  p_button_name    => 'Cancel',
  p_button_image_alt=> 'Abbrechen',
  p_button_position=> 'REGION_TEMPLATE_CLOSE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_cattributes=>'class="button10"',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 953110060736407.4053 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 17.4053,
  p_button_sequence=> 4,
  p_button_plug_id => 951627136736335+wwv_flow_api.g_id_offset,
  p_button_name    => 'Create',
  p_button_image_alt=> 'Erstellen',
  p_button_position=> 'REGION_TEMPLATE_CREATE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_condition=> 'P17_ID',
  p_button_condition_type=> 'ITEM_IS_NULL',
  p_button_cattributes=>'class="button10"',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 953528940736408.4053 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 17.4053,
  p_button_sequence=> 2,
  p_button_plug_id => 951627136736335+wwv_flow_api.g_id_offset,
  p_button_name    => 'Delete',
  p_button_image_alt=> 'Löschen',
  p_button_position=> 'REGION_TEMPLATE_DELETE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_condition=> 'P17_ID',
  p_button_condition_type=> 'ITEM_IS_NOT_NULL',
  p_button_cattributes=>'class="button10"',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>75294331022650118.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 17.4053,
  p_branch_action=> 'f?p=&APP_ID.:18:&SESSION.::&DEBUG.:17::&success_msg=#SUCCESS_MSG#',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Created 15-JUN-2004 19:41 by SSPADAFO');
 
wwv_flow_api.create_page_branch(
  p_id=>75293614053645275.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 17.4053,
  p_branch_action=> 'f?p=&FLOW_ID.:18:&SESSION.::&DEBUG.:17::',
  p_branch_point=> 'BEFORE_COMPUTATION',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_when_button_id=>952714907736406.4053+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Created 15-JUN-2004 19:40 by SSPADAFO');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Geben Sie den Text ein, der mit dem Link-Ziel angezeigt werden soll. Ansonsten geben Sie den Text ein, der angezeigt werden soll, wenn für diese Task kein Link festgelegt ist.';

wwv_flow_api.create_page_item(
  p_id=>953917950736415.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 17.4053,
  p_name=>'P17_TASK_NAME',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 20,
  p_item_plug_id => 951627136736335.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Task-Name',
  p_source=>'TASK_NAME',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'TEXTAREA',
  p_lov_columns=> null,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 32,
  p_cMaxlength=> 255,
  p_cHeight=> 2,
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 111844628719872228.4053+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Geben Sie optional ein Link-Ziel an, das in der Task-Region angezeigt werden soll (beispielsweise <pre>http://www.oracle.com</pre>).';

wwv_flow_api.create_page_item(
  p_id=>954517336736480.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 17.4053,
  p_name=>'P17_TASK_LINK',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 30,
  p_item_plug_id => 951627136736335.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Task-Link',
  p_source=>'TASK_LINK',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'TEXT',
  p_lov_columns=> null,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 50,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 111843720754869910.4053+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>955210485736485.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 17.4053,
  p_name=>'P17_ID',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 951627136736335.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Id',
  p_source=>'ID',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'HIDDEN',
  p_lov_columns=> null,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 32,
  p_cMaxlength=> 255,
  p_cHeight=> 1,
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 111843720754869910.4053+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Definiert die relative Reihenfolge, in der die Links in den jeweiligen Task-Listen angezeigt werden.';

wwv_flow_api.create_page_item(
  p_id=>75234509655426344.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 17.4053,
  p_name=>'P17_DISPLAY_SEQUENCE',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 12,
  p_item_plug_id => 951627136736335.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default => '10',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Anzeigereihenfolge',
  p_source=>'DISPLAY_SEQUENCE',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'TEXT',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 5,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 111844628719872228.4053+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Bestimmt, ob eine Task oder ein Link angezeigt wird. Wählen Sie <b>Ja</b>, um die Anzeige zu aktivieren. Wenn Sie <b>Nein</b> wählen, wird die Anzeige deaktiviert.';

wwv_flow_api.create_page_item(
  p_id=>75236031126432516.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 17.4053,
  p_name=>'P17_DISPLAYED',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 120,
  p_item_plug_id => 951627136736335.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default => 'Y',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Angezeigt',
  p_source=>'DISPLAYED',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'COMBOBOX',
  p_named_lov=> 'YES_NO_RETURNS_Y_OR_N',
  p_lov => '.'||to_char(157992123774592395 + wwv_flow_api.g_id_offset)||'.',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 5,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 111843720754869910.4053+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Wählen Sie, in welcher Task-Liste dieser Link oder Text angezeigt werden soll. Mögliche Optionen:'||chr(10)||
'<ul>'||chr(10)||
'<li>Workspace-Homepage</li>'||chr(10)||
'<li>Workspace-Anmeldeseite</li>'||chr(10)||
'</ul>';

wwv_flow_api.create_page_item(
  p_id=>75239916843447392.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 17.4053,
  p_name=>'P17_DISPLAY_LOCATION',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 15,
  p_item_plug_id => 951627136736335.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default => 'WORKSPACE_HOME',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Anzeigeposition',
  p_source=>'DISPLAY_LOCATION',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'RADIOGROUP',
  p_named_lov=> 'TASK_DISPLAY_LOCATION',
  p_lov => '.'||to_char(75242612126455451 + wwv_flow_api.g_id_offset)||'.',
  p_lov_columns=> 2,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 32,
  p_cMaxlength=> 255,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_tag_attributes2=> 'class="fielddata"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 111843720754869910.4053+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 956110817736502.4053 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 17.4053,
  p_validation_name => 'value is required',
  p_validation_sequence=> 20,
  p_validation => 'P17_TASK_NAME',
  p_validation_type => 'ITEM_NOT_NULL',
  p_error_message => 'Der Text muss angegeben werden.',
  p_validation_condition=> 'Create,Apply Changes',
  p_validation_condition_type=> 'REQUEST_IN_CONDITION',
  p_associated_item=> 953917950736415.4053 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 152718005693876831.4053 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 17.4053,
  p_validation_name => 'name not whitespace',
  p_validation_sequence=> 30,
  p_validation => 'replace(:P17_TASK_NAME,'' '',null) is not null',
  p_validation_type => 'PLSQL_EXPRESSION',
  p_error_message => 'Der Task-Name darf nicht nur aus Leerzeichen bestehen',
  p_validation_condition=> 'Apply Changes,Create',
  p_validation_condition_type=> 'REQUEST_IN_CONDITION',
  p_associated_item=> 953917950736415.4053 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 202090127032390388.4053 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 17.4053,
  p_validation_name => 'display sequence must be numeric',
  p_validation_sequence=> 40,
  p_validation => 'P17_DISPLAY_SEQUENCE',
  p_validation_type => 'ITEM_IS_NUMERIC',
  p_error_message => 'Der Wert muss numerisch sein.',
  p_validation_condition=> 'Create, Apply Changes',
  p_validation_condition_type=> 'REQUEST_IN_CONDITION',
  p_associated_item=> 75234509655426344.4053 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'F|#OWNER#:WWV_FLOW_CUSTOMIZED_TASKS:P17_ID:ID';

wwv_flow_api.create_page_process(
  p_id     => 956523719736519.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 17.4053,
  p_process_sequence=> 1,
  p_process_point=> 'AFTER_HEADER',
  p_process_type=> 'DML_FETCH_ROW',
  p_process_name=> 'Fetch Row from WWV_FLOW_CUSTOMIZED_TASKS',
  p_process_sql_clob => p, 
  p_process_error_message=> 'Fehler beim Abrufen von Zeile.',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||':P17_ID := wwv_flow_id.next_val;';

wwv_flow_api.create_page_process(
  p_id     => 152749516531012440.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 17.4053,
  p_process_sequence=> 11,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'set ID',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_when=>'P17_ID',
  p_process_when_type=>'ITEM_IS_NULL',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'#OWNER#:WWV_FLOW_CUSTOMIZED_TASKS:P17_ID:ID';

wwv_flow_api.create_page_process(
  p_id     => 956903422736535.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 17.4053,
  p_process_sequence=> 21,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'DML_PROCESS_ROW',
  p_process_name=> 'Process Row of WWV_FLOW_CUSTOMIZED_TASKS',
  p_process_sql_clob => p, 
  p_process_error_message=> 'Fehler beim Verarbeiten einer Zeile der Tabelle WWV_FLOW_CUSTOMIZED_TASKS.',
  p_process_success_message=> 'Aktion wurde verarbeitet.',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 17.4053
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_18.40
prompt  ...PAGE 18.4053: Site-spezifische Tasks
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEADM/adm_tasklist.htm';

ph := null;
wwv_flow_api.create_page(
  p_id     => 18.4053,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'Site-spezifische Tasks',
  p_step_title=> 'Site-spezifische Tasks',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'AUTO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 216765317551591446+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => '',
  p_step_template => 19236405723931959.4053+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409160251',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>18.4053,p_text=>h);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'Diese Links werden auf der Workspace-Homepage und der Seite für die Workspace-Anmeldung als Listen für Site-spezifische Tasks angezeigt.';

wwv_flow_api.create_page_plug (
  p_id=> 960020599743353.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 18.4053,
  p_plug_name=> 'Site-spezifische Tasks',
  p_region_name=>'',
  p_plug_template=> 79623830123907946.4053+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 20,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_03',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 960422841743364.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 18.4053,
  p_plug_name=> 'Menu',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(4585800473139662 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 4589126493175495.4053+ wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'select id, '||chr(10)||
'   display_sequence, '||chr(10)||
'   task_name, '||chr(10)||
'   task_link, '||chr(10)||
'   decode('||chr(10)||
'      display_location,'||chr(10)||
'     ''WORKSPACE_HOME'','||chr(10)||
'      wwv_flow_lang.system_message(''F4050.WORKSPACE_HOME''),'||chr(10)||
'     ''WORKSPACE_LOGIN'','||chr(10)||
'     wwv_flow_lang.system_message(''F4050.WORKSPACE_LOGIN'')'||chr(10)||
'     ) display_location, '||chr(10)||
'   decode('||chr(10)||
'     displayed,'||chr(10)||
'     ''Y'','||chr(10)||
'     wwv_flow_lang.system_message(''F4000.YES''),'||chr(10)||
'     wwv_flow_lang.syste';

s:=s||'m_message(''F4000.NO'')'||chr(10)||
'     ) displayed'||chr(10)||
'from wwv_flow_customized_tasks';

wwv_flow_api.create_report_region (
  p_id=> 964406793756833.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 18.4053,
  p_name=> 'Site-Specific Tasks',
  p_region_name=>'',
  p_template=> 0+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 50,
  p_display_column=> 1,
  p_display_point=> 'REGION_POSITION_02',
  p_source=> s,
  p_source_type=> 'SQL_QUERY',
  p_display_error_message=> '#SQLERRM#',
  p_plug_caching=> 'NOT_CACHED',
  p_customized=> '0',
  p_query_row_template=> 6897002870390711.4053+ wwv_flow_api.g_id_offset,
  p_query_headings_type=> 'COLON_DELMITED_LIST',
  p_query_num_rows=> '15',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_show_nulls_as=> ' - ',
  p_query_break_cols=> '0',
  p_query_no_data_found=> 'keine Tasks gefunden',
  p_query_num_rows_type=> 'ROW_RANGES_WITH_LINKS',
  p_query_row_count_max=> '50000',
  p_pagination_display_position=> 'BOTTOM_RIGHT',
  p_csv_output=> 'N',
  p_query_asc_image=> 'arrow_down_gray_dark.gif',
  p_query_asc_image_attr=> 'width="13" height="12"',
  p_query_desc_image=> 'arrow_up_gray_dark.gif',
  p_query_desc_image_attr=> 'width="13" height="12"',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 75164114382143826.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 964406793756833.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'ID',
  p_column_display_sequence=> 1,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 965130942757270.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 964406793756833.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'DISPLAY_SEQUENCE',
  p_column_display_sequence=> 3,
  p_column_heading=> 'Sequence',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 964932084757269.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 964406793756833.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 3,
  p_form_element_id=> null,
  p_column_alias=> 'TASK_NAME',
  p_column_display_sequence=> 2,
  p_column_heading=> 'Name',
  p_column_link=>'f?p=&APP_ID.:17:&SESSION.::&DEBUG.:17:P17_ID:#ID#',
  p_column_linktext=>'#TASK_NAME#',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 965011042757269.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 964406793756833.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 4,
  p_form_element_id=> null,
  p_column_alias=> 'TASK_LINK',
  p_column_display_sequence=> 5,
  p_column_heading=> 'Task-Link',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 965232430757270.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 964406793756833.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 5,
  p_form_element_id=> null,
  p_column_alias=> 'DISPLAY_LOCATION',
  p_column_display_sequence=> 4,
  p_column_heading=> 'Angezeigt auf Seite',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>1,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 965320533757270.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 964406793756833.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 6,
  p_form_element_id=> null,
  p_column_alias=> 'DISPLAYED',
  p_column_display_sequence=> 6,
  p_column_heading=> 'Anzeigen',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 200723903023857946.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 18.4053,
  p_plug_name=> 'Buttons',
  p_region_name=>'',
  p_plug_template=> 182507118036154586.4053+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 40,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_02',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 961500556743430.4053 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 18.4053,
  p_button_sequence=> 10,
  p_button_plug_id => 200723903023857946+wwv_flow_api.g_id_offset,
  p_button_name    => 'CANCEL',
  p_button_image_alt=> 'Abbrechen',
  p_button_position=> 'REGION_TEMPLATE_CLOSE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=&APP_ID.:5:&SESSION.::&DEBUG.:::',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 961902894743435.4053 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 18.4053,
  p_button_sequence=> 6,
  p_button_plug_id => 200723903023857946+wwv_flow_api.g_id_offset,
  p_button_name    => 'CREATE_ROW',
  p_button_image_alt=> 'Erstellen &gt;',
  p_button_position=> 'REGION_TEMPLATE_CREATE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>962710881743501.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 18.4053,
  p_branch_action=> '17',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'BRANCH_TO_STEP',
  p_branch_sequence=> 1,
  p_branch_condition_type=> 'REQUEST_EQUALS_CONDITION',
  p_branch_condition=> 'CREATE_ROW',
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
wwv_flow_api.create_page_branch(
  p_id=>963118584743503.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 18.4053,
  p_branch_action=> '5',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'BRANCH_TO_STEP',
  p_branch_sequence=> 99,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_computation(
  p_id=> 962412919743490.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 18.4053,
  p_computation_sequence => 1,
  p_computation_item=> 'P17_ID',
  p_computation_point=> 'AFTER_SUBMIT',
  p_computation_type=> 'STATIC_ASSIGNMENT',
  p_computation_processed=> 'REPLACE_EXISTING',
  p_computation=> '',
  p_computation_comment=> 'Set the value of the item conainting the primary key to null when asked to create a new row.',
  p_compute_when => 'CREATE_ROW',
  p_compute_when_type=>'REQUEST_EQUALS_CONDITION');
 
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 18.4053
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_19.40
prompt  ...PAGE 19.4053: Entwickleraktivitäts-Log verwalten
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEADM/adm_logs.htm';

ph := null;
wwv_flow_api.create_page(
  p_id     => 19.4053,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'Entwickleraktivitäts-Log verwalten',
  p_step_title=> 'Entwickleraktivitäts-Log verwalten',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'NO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 216783731365642767+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => '',
  p_step_template => 12930201930057128.4053+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409160252',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>19.4053,p_text=>h);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'declare'||chr(10)||
'   c_dev pls_integer := 0;'||chr(10)||
''||chr(10)||
'begin'||chr(10)||
''||chr(10)||
'htp.p(''<table class="htmldbInstructionText" summary=""><tbody>'');'||chr(10)||
'select count(*) into c_dev from wwv_flow_builder_audit_trail;'||chr(10)||
'htp.p(''<tr><td>''||wwv_flow_lang.system_message(''4050_19_LOG_ENTRIES'')||''</td>'');'||chr(10)||
'htp.p(''<td align="right">''|| to_char(c_dev,''999,999,999,990'') || ''</td></tr>'');'||chr(10)||
'htp.p(''</tbody></table>'');'||chr(10)||
''||chr(10)||
'end;';

wwv_flow_api.create_page_plug (
  p_id=> 19799503430565082.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 19.4053,
  p_plug_name=> 'Einträge des Aktivitäts-Logs für Entwickler löschen',
  p_region_name=>'',
  p_plug_template=> 2424107150426143.4053+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 10,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_02',
  p_plug_source=> s,
  p_plug_source_type=> 'PLSQL_PROCEDURE',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 19886413585776250.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 19.4053,
  p_plug_name=> 'Menu',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(4585800473139662 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 4589126493175495.4053+ wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 19847614137691252.4053 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 19.4053,
  p_button_sequence=> 10,
  p_button_plug_id => 19799503430565082+wwv_flow_api.g_id_offset,
  p_button_name    => 'CANCEL',
  p_button_image_alt=> 'Abbrechen',
  p_button_position=> 'REGION_TEMPLATE_CLOSE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=&FLOW_ID.:68:&SESSION.::&DEBUG.:::',
  p_button_cattributes=>'class="button10"',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 19803315335578026.4053 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 19.4053,
  p_button_sequence=> 10,
  p_button_plug_id => 19799503430565082+wwv_flow_api.g_id_offset,
  p_button_name    => 'DELETE_ENTRIES',
  p_button_image_alt=> 'Einträge löschen',
  p_button_position=> 'REGION_TEMPLATE_CREATE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_cattributes=>'class="BUTTON10"',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>19803703152578047.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 19.4053,
  p_branch_action=> '19',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'BRANCH_TO_STEP',
  p_branch_when_button_id=>19803315335578026.4053+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Löschen Sie die Einträge im Aktivitäts-Log, die älter als die angegebene Anzahl der Tage sind.';

wwv_flow_api.create_page_item(
  p_id=>19801228364572352.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 19.4053,
  p_name=>'P19_TIME',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 19799503430565082.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Einträge ab dieser Anzahl von Tagen löschen:',
  p_source=>'31',
  p_source_type=> 'STATIC',
  p_display_as=> 'COMBOBOX',
  p_named_lov=> 'TIME_INTERVALS',
  p_lov => '.'||to_char(87720511660244788 + wwv_flow_api.g_id_offset)||'.',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 111843720754869910.4053+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'delete from WWV_FLOW_BUILDER_AUDIT_TRAIL where AUDIT_DATE < (sysdate - nvl(:p19_time,31))';

wwv_flow_api.create_page_process(
  p_id     => 19880014493766985.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 19.4053,
  p_process_sequence=> 10,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'delete rows',
  p_process_sql_clob => p, 
  p_process_error_message=> 'Fehler beim Verarbeiten des Entwickler-Aktivitäts-Logs.',
  p_process_when_button_id=>19803315335578026.4053 + wwv_flow_api.g_id_offset,
  p_process_success_message=> 'Aktivitäts-Log für den Entwickler wurde verarbeitet.',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 19.4053
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_20.40
prompt  ...PAGE 20.4053: Zuordnung vom Schema zum Workspace bearbeiten
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEADM/adm_mg_wrkspc.htm';

ph := null;
wwv_flow_api.create_page(
  p_id     => 20.4053,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'Zuordnung vom Schema zum Workspace bearbeiten',
  p_step_title=> 'Zuordnung vom Schema zum Workspace bearbeiten',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'AUTO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 216765317551591446+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => '',
  p_step_template => 12930201930057128.4053+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409160252',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>20.4053,p_text=>h);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 680521474522216.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 20.4053,
  p_plug_name=> 'Workspace-Schema-Zuordnung',
  p_region_name=>'',
  p_plug_template=> 2424107150426143.4053+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 10,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> 'Unable to show report. #SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> 'generated 10-MAR-2001 10:51:46');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 13888724699867646.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 20.4053,
  p_plug_name=> 'Menu',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(4585800473139662 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 4589126493175495.4053+ wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 680801594522218.4053 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 20.4053,
  p_button_sequence=> 1,
  p_button_plug_id => 680521474522216+wwv_flow_api.g_id_offset,
  p_button_name    => 'Cancel',
  p_button_image_alt=> 'Abbrechen',
  p_button_position=> 'REGION_TEMPLATE_CLOSE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_cattributes=>'class="button10"',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 681208267522219.4053 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 20.4053,
  p_button_sequence=> 3,
  p_button_plug_id => 680521474522216+wwv_flow_api.g_id_offset,
  p_button_name    => 'Apply_Changes',
  p_button_image_alt=> 'Änderungen anwenden',
  p_button_position=> 'REGION_TEMPLATE_CREATE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 681404738522220.4053 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 20.4053,
  p_button_sequence=> 4,
  p_button_plug_id => 680521474522216+wwv_flow_api.g_id_offset,
  p_button_name    => 'Create',
  p_button_image_alt=> 'Erstellen',
  p_button_position=> 'REGION_TEMPLATE_CREATE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_condition=> 'F4050_P20_ID',
  p_button_condition_type=> 'ITEM_IS_NULL',
  p_button_cattributes=>'class="button10"',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 681012794522218.4053 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 20.4053,
  p_button_sequence=> 2,
  p_button_plug_id => 680521474522216+wwv_flow_api.g_id_offset,
  p_button_name    => 'Delete',
  p_button_image_alt=> 'Löschen',
  p_button_position=> 'REGION_TEMPLATE_DELETE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_condition=> ':F4050_P20_ID is not null and :P20_IS_FIRST_SCHEMA = ''N''',
  p_button_condition_type=> 'PLSQL_EXPRESSION',
  p_button_cattributes=>'class="button10"',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>680228915522216.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 20.4053,
  p_branch_action=> '21',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'BRANCH_TO_STEP',
  p_branch_sequence=> 99,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
wwv_flow_api.create_page_branch(
  p_id=>274506709117217135.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 20.4053,
  p_branch_action=> 'f?p=&APP_ID.:78:&SESSION.::&DEBUG.::P78_PROVISIONING_COMPANY_ID:&F4050_P20_SECURITY_GROUP_ID.',
  p_branch_point=> 'BEFORE_COMPUTATION',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_sequence=> 10,
  p_branch_condition_type=> 'VAL_OF_ITEM_IN_COND_EQ_COND2',
  p_branch_condition=> 'F4050_P20_SECURITY_GROUP_ID',
  p_branch_condition_text=>'10',
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Created 31-JUL-2004 03:52 by SSPADAFO');
 
wwv_flow_api.create_page_branch(
  p_id=>680427844522216.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 20.4053,
  p_branch_action=> '21',
  p_branch_point=> 'BEFORE_VALIDATION',
  p_branch_type=> 'BRANCH_TO_STEP',
  p_branch_sequence=> 10,
  p_branch_condition_type=> 'REQUEST_EQUALS_CONDITION',
  p_branch_condition=> 'Cancel',
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>681626422522223.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 20.4053,
  p_name=>'F4050_P20_ID',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 100,
  p_item_plug_id => 680521474522216.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_prompt=>'Id',
  p_source=>'ID',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'HIDDEN',
  p_lov_columns=> null,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 32,
  p_cMaxlength=> 255,
  p_cHeight=> 1,
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Geben Sie den Workspace an.';

wwv_flow_api.create_page_item(
  p_id=>681827271522225.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 20.4053,
  p_name=>'F4050_P20_SECURITY_GROUP_ID',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 20,
  p_item_plug_id => 680521474522216.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Workspace',
  p_source=>'SECURITY_GROUP_ID',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'POPUP_KEY_LOV',
  p_named_lov=> 'LIST_DEVELOPER_WORKSPACES_NO_NULL_OPTION',
  p_lov => 'select short_name||'' (''||PROVISIONING_COMPANY_ID||'')'' d,'||chr(10)||
'       PROVISIONING_COMPANY_ID r'||chr(10)||
'from   WWV_FLOW_COMPANIES'||chr(10)||
'where  provisioning_company_id not in (0,10,11)'||chr(10)||
'order by 1',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 32,
  p_cMaxlength=> 255,
  p_cHeight=> 1,
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 111843720754869910.4053+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Geben Sie das entsprechende Schema an.';

wwv_flow_api.create_page_item(
  p_id=>682001271522225.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 20.4053,
  p_name=>'F4050_P20_SCHEMA',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 30,
  p_item_plug_id => 680521474522216.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Datenbankschema',
  p_source=>'SCHEMA',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'POPUP_KEY_LOV',
  p_named_lov=> 'LIST_ALL_DATABASE_SCHEMAS',
  p_lov => 'declare q varchar2(32767);'||chr(10)||
'  l_flows_schema varchar2(30) := wwv_flow.g_flow_schema_owner;'||chr(10)||
'begin'||chr(10)||
'    q := ''select name n, name r from sys.user$ u where type#=1 and name <> ''''''||l_flows_schema||'''''' and name not in (''''HTMLDB_PUBLIC_USER'''',''''PUBLIC_USER'''',''''FLOWS_FILES'''',''''SCHEDULER'''',''''PEOPLE'''',''''APEX_PUBLIC_USER'''')'';'||chr(10)||
'    q := q||'' and name not in (select schema from wwv_flow_restricted_schemas where not exists (select 1 from wwv_flow_rschema_exceptions where schema_id = (select id from wwv_flow_restricted_schemas where schema = u.name))) '';'||chr(10)||
'    q := q ||'' order by 1'';'||chr(10)||
'    return q;'||chr(10)||
'end;',
  p_lov_columns=> null,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 32,
  p_cMaxlength=> 255,
  p_cHeight=> 1,
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 111843720754869910.4053+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>135418406612396046.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 20.4053,
  p_name=>'P20_IS_FIRST_SCHEMA',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 110,
  p_item_plug_id => 680521474522216.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source_type=> 'STATIC',
  p_display_as=> 'HIDDEN',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> 2000,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'LEFT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'Y',
  p_item_comment => '');
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_computation(
  p_id=> 135422609644415804.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 20.4053,
  p_computation_sequence => 10,
  p_computation_item=> 'P20_IS_FIRST_SCHEMA',
  p_computation_point=> 'BEFORE_BOX_BODY',
  p_computation_type=> 'FUNCTION_BODY',
  p_computation_processed=> 'REPLACE_EXISTING',
  p_computation=> 'for c1 in (select a.schema, b.first_schema_provisioned'||chr(10)||
'             from wwv_flow_company_schemas a, wwv_flow_companies b'||chr(10)||
'            where a.security_group_id = b.provisioning_company_id'||chr(10)||
'              and a.id = :F4050_P20_ID ) loop'||chr(10)||
'  if c1.schema = c1.first_schema_provisioned then'||chr(10)||
'    return ''Y'';'||chr(10)||
'  else '||chr(10)||
'    return ''N'';'||chr(10)||
'  end if;'||chr(10)||
'  exit;'||chr(10)||
'end loop;',
  p_compute_when => '',
  p_compute_when_type=>'');
 
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'#OWNER#:WWV_FLOW_COMPANY_SCHEMAS:F4050_P20_ID:ID';

wwv_flow_api.create_page_process(
  p_id     => 682212029522226.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 20.4053,
  p_process_sequence=> 1,
  p_process_point=> 'AFTER_HEADER',
  p_process_type=> 'DML_FETCH_ROW',
  p_process_name=> 'Fetch Row from WWV_FLOW_COMPANY_SCHEMAS',
  p_process_sql_clob => p, 
  p_process_error_message=> 'Fehler beim Abrufen von Zeile.',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'if wwv_flow_provisioning.reserved_schema(p_schema => :F4050_P20_SCHEMA)'||chr(10)||
' or '||chr(10)||
'  (wwv_flow_provisioning.site_admin_is_restricted and '||chr(10)||
'   wwv_flow_provisioning.restricted_schema('||chr(10)||
'     p_schema =>  :F4050_P20_SCHEMA, '||chr(10)||
'     p_workspace_name => wwv_flow_security.find_company_name(:F4050_P20_SECURITY_GROUP_ID))) then'||chr(10)||
'  :F4050_P20_SCHEMA := ''INVALID'';'||chr(10)||
'end if;';

wwv_flow_api.create_page_process(
  p_id     => 274482203755203147.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 20.4053,
  p_process_sequence=> 10,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'check schema',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'#OWNER#:WWV_FLOW_COMPANY_SCHEMAS:F4050_P20_ID:ID';

wwv_flow_api.create_page_process(
  p_id     => 682401703522227.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 20.4053,
  p_process_sequence=> 20,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'DML_PROCESS_ROW',
  p_process_name=> 'Process Row of WWV_FLOW_COMPANY_SCHEMAS',
  p_process_sql_clob => p, 
  p_process_error_message=> 'Fehler beim Verarbeiten von Zeile.',
  p_process_success_message=> 'Aktion wurde verarbeitet.',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 20.4053
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_21.40
prompt  ...PAGE 21.4053: Zuordnungen vom Workspace zum Schema verwalten
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEADM/adm_schema_assign.htm';

ph := null;
wwv_flow_api.create_page(
  p_id     => 21.4053,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'Zuordnungen vom Workspace zum Schema verwalten',
  p_step_title=> 'Zuordnungen vom Workspace zum Schema verwalten',
  p_step_sub_title => 'Report',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'AUTO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_help_text => ' ',
  p_html_page_header => '',
  p_step_template => 12930201930057128.4053+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409160252',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>21.4053,p_text=>h);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 19712704963515408.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 21.4053,
  p_plug_name=> 'Menu',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(4585800473139662 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 4589126493175495.4053+ wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 19712909520515410.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 21.4053,
  p_plug_name=> 'Provisioned Schemas',
  p_region_name=>'',
  p_plug_template=> 107311831567346457.4053+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'select '||chr(10)||
'  cs.SCHEMA,'||chr(10)||
'  c.short_name,'||chr(10)||
'  cs.SECURITY_GROUP_ID,'||chr(10)||
'  cs.id'||chr(10)||
'from WWV_FLOW_COMPANY_SCHEMAS cs,'||chr(10)||
'     wwv_flow_companies c'||chr(10)||
'where (:P21_FIND_SCHEMA is null or '||chr(10)||
'         instr(upper(cs.schema),upper(:P21_FIND_SCHEMA)) > 0 or'||chr(10)||
'         instr(upper(c.short_name),upper(:f4050_p21_find_schema)) > 0) and'||chr(10)||
'     cs.security_group_id = c.PROVISIONING_COMPANY_ID(+) and'||chr(10)||
'      ((:P21_COMPANY = ''0'' or :P21_';

s:=s||'COMPANY is null)  or c.provisioning_company_id = :P21_COMPANY)'||chr(10)||
'and short_name != ''INTERNAL''';

wwv_flow_api.create_report_region (
  p_id=> 19713132168515411.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 21.4053,
  p_name=> 'Schemas Provisioned by Workspace',
  p_region_name=>'',
  p_template=> 0+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 10,
  p_display_column=> 1,
  p_display_point=> 'AFTER_SHOW_ITEMS',
  p_source=> s,
  p_source_type=> 'SQL_QUERY',
  p_display_error_message=> 'Unable to show report. #SQLERRM#',
  p_plug_caching=> 'NOT_CACHED',
  p_customized=> '0',
  p_query_row_template=> 6897002870390711.4053+ wwv_flow_api.g_id_offset,
  p_query_headings_type=> 'COLON_DELMITED_LIST',
  p_query_num_rows=> '15',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_break_cols=> '1',
  p_query_no_data_found=> 'Es wurden keine Schemas gefunden.',
  p_query_num_rows_item=> 'P21_ROWS',
  p_query_num_rows_type=> 'ROW_RANGES_WITH_LINKS',
  p_query_row_count_max=> '50000',
  p_pagination_display_position=> 'BOTTOM_RIGHT',
  p_break_type_flag=> 'DEFAULT_BREAK_FORMATTING',
  p_csv_output=> 'N',
  p_query_asc_image=> 'arrow_down_gray_dark.gif',
  p_query_asc_image_attr=> 'width="13" height="12"',
  p_query_desc_image=> 'arrow_up_gray_dark.gif',
  p_query_desc_image_attr=> 'width="13" height="12"',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'generated 25-FEB-2001 17:06:34');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 19713427221515412.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 19713132168515411.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'SCHEMA',
  p_column_display_sequence=> 2,
  p_column_heading=> 'Schema',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>2,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 19713530990515413.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 19713132168515411.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'SHORT_NAME',
  p_column_display_sequence=> 1,
  p_column_heading=> 'Workspace',
  p_column_link=>'f?p=&APP_ID.:20:&SESSION.::&DEBUG.::F4050_P20_ID:#ID#',
  p_column_linktext=>'#SHORT_NAME#',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>1,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 19713607336515413.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 19713132168515411.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 3,
  p_form_element_id=> null,
  p_column_alias=> 'SECURITY_GROUP_ID',
  p_column_display_sequence=> 3,
  p_column_heading=> 'Workspace',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 175968612447519614.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 19713132168515411.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 4,
  p_form_element_id=> null,
  p_column_alias=> 'ID',
  p_column_display_sequence=> 4,
  p_column_heading=> 'ID',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'<p>Dieser Bericht listet die Schemas auf, die in einem Workspace erstellt werden können. Der Entwickler einer neuen Anwendung kann in der Liste der dem Workspace zugewiesenen Schemas festlegen, dass der SQL-Code als identifiziertes "integriertes" Schema geparst wird.</p>';

wwv_flow_api.create_page_plug (
  p_id=> 19713719462515413.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 21.4053,
  p_plug_name=> 'Workspace-Schemas',
  p_region_name=>'',
  p_plug_template=> 79623830123907946.4053+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 20,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_03',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||':P106_PASSWORD := null;';

wwv_flow_api.create_page_plug (
  p_id=> 32859321338800843.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 21.4053,
  p_plug_name=> 'reset',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 30,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_HEADER',
  p_plug_source=> s,
  p_plug_source_type=> 'PLSQL_PROCEDURE',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 19713915330515414.4053 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 21.4053,
  p_button_sequence=> 10,
  p_button_plug_id => 19712909520515410+wwv_flow_api.g_id_offset,
  p_button_name    => 'Create',
  p_button_image_alt=> 'Erstellen &gt;',
  p_button_position=> 'REGION_TEMPLATE_CREATE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=&FLOW_ID.:105:&SESSION.::&DEBUG.:105,106,107::',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>19715800116515426.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 21.4053,
  p_branch_action=> '21',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'BRANCH_TO_STEP',
  p_branch_sequence=> 99,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Geben Sie eine Abfrage für den Schemanamen (ohne Berücksichtigung der Groß-/Kleinschreibung) ein, und klicken Sie anschließend auf <b>Los</b>.';

wwv_flow_api.create_page_item(
  p_id=>19714121904515416.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 21.4053,
  p_name=>'P21_FIND_SCHEMA',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 1,
  p_item_plug_id => 19712909520515410.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Schema',
  p_source_type=> 'STATIC',
  p_display_as=> 'TEXT',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 15,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 343399818250317904.4053+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Um nach Workspace zu filtern, wählen Sie einen Workspace und klicken anschließend auf <b>Los</b>. Um Ergebnisse aus allen Workspaces zurückzugeben, wählen Sie <b>Alle Workspaces</b>.';

wwv_flow_api.create_page_item(
  p_id=>19714602679515419.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 21.4053,
  p_name=>'P21_COMPANY',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 1.5,
  p_item_plug_id => 19712909520515410.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Workspace',
  p_source_type=> 'STATIC',
  p_display_as=> 'POPUP_KEY_LOV',
  p_named_lov=> 'LIST_DEVELOPER_WORKSPACES',
  p_lov => 'select ''- ''||'||chr(10)||
'wwv_flow_lang.system_message(''F4050_SHOW_ALL_WORKSPACES'')||'||chr(10)||
''' -'' d, 0 r from dual union all'||chr(10)||
'select short_name||'' (''||PROVISIONING_COMPANY_ID||'')'' d,'||chr(10)||
'       PROVISIONING_COMPANY_ID r'||chr(10)||
'from   WWV_FLOW_COMPANIES'||chr(10)||
'where  provisioning_company_id not in (0,10,11)'||chr(10)||
'order by 1',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 25,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 343399818250317904.4053+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Wählen Sie die Anzahl der Zeilen, die im Bericht angezeigt werden sollen, und klicken Sie anschließend auf <b>Los</b>.';

wwv_flow_api.create_page_item(
  p_id=>19715100356515422.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 21.4053,
  p_name=>'P21_ROWS',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 2,
  p_item_plug_id => 19712909520515410.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Anzeigen',
  p_source=>'15',
  p_source_type=> 'STATIC',
  p_display_as=> 'COMBOBOX',
  p_lov => 'STATIC2:1,2,3,4,5,6,7,8,9,10,15,20,30,40,50,100,1000,5000',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_cattributes_element=>'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 343399818250317904.4053+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>19715631170515422.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 21.4053,
  p_name=>'P21_GO',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 3,
  p_item_plug_id => 19712909520515410.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default => 'GO',
  p_prompt=>'Los',
  p_source=>'GO',
  p_source_type=> 'STATIC',
  p_display_as=> 'BUTTON',
  p_lov_columns=> null,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> 2000,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'N',
  p_item_comment => '');
 
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'reset_pagination';

wwv_flow_api.create_page_process(
  p_id     => 104329223708762143.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 21.4053,
  p_process_sequence=> 10,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'RESET_PAGINATION',
  p_process_name=> 'Reset Pagination',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_when_button_id=>19715631170515422.4053 + wwv_flow_api.g_id_offset,
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 21.4053
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_22.40
prompt  ...PAGE 22.4053: Datenbankberechtigungen für Workspace verwalten
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEADM/adm_wrkspc_privs.htm';

ph := null;
wwv_flow_api.create_page(
  p_id     => 22.4053,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'Datenbankberechtigungen für Workspace verwalten',
  p_step_title=> 'Datenbankberechtigungen für Workspace verwalten',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'NO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_help_text => ' ',
  p_html_page_header => '',
  p_step_template => '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409160252',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>22.4053,p_text=>h);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 8781520672978158.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 22.4053,
  p_plug_name=> 'Breadcrumb',
  p_region_name=>'',
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(4585800473139662 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 4589126493175495.4053+ wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 8782817687986777.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 22.4053,
  p_plug_name=> 'Button Bar',
  p_region_name=>'',
  p_plug_template=> 107311831567346457.4053+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 10,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'select '||chr(10)||
'  cs.SCHEMA,'||chr(10)||
'  c.short_name,'||chr(10)||
'  cs.SECURITY_GROUP_ID,'||chr(10)||
'  cs.id, p.privilege, p.admin_option'||chr(10)||
'from '||chr(10)||
'  WWV_FLOW_COMPANY_SCHEMAS cs, '||chr(10)||
'  wwv_flow_companies c, '||chr(10)||
'  DBA_SYS_PRIVS p'||chr(10)||
'where '||chr(10)||
'cs.schema = p.grantee and'||chr(10)||
'(:P22_FIND is null or '||chr(10)||
' instr(p.privilege,upper(:P22_FIND)) > 0 or'||chr(10)||
' instr(upper(cs.schema),upper(:P22_FIND)) > 0 or'||chr(10)||
' instr(upper(c.short_name),upper(:P22_FIND)) > 0)  and'||chr(10)||
'cs.security_group';

s:=s||'_id = c.PROVISIONING_COMPANY_ID(+)';

wwv_flow_api.create_report_region (
  p_id=> 8784826606008242.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 22.4053,
  p_name=> 'Workspace Privileges',
  p_region_name=>'',
  p_template=> 0+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 20,
  p_display_column=> 1,
  p_display_point=> 'AFTER_SHOW_ITEMS',
  p_source=> s,
  p_source_type=> 'SQL_QUERY',
  p_display_error_message=> '#SQLERRM#',
  p_plug_caching=> 'NOT_CACHED',
  p_customized=> '0',
  p_query_row_template=> 6897002870390711.4053+ wwv_flow_api.g_id_offset,
  p_query_headings_type=> 'COLON_DELMITED_LIST',
  p_query_num_rows=> '15',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_show_nulls_as=> ' - ',
  p_query_break_cols=> '1',
  p_query_no_data_found=> 'Keine Daten gefunden.',
  p_query_num_rows_item=> 'P22_ROWS',
  p_query_num_rows_type=> 'NEXT_PREVIOUS_LINKS',
  p_query_row_count_max=> '50000',
  p_pagination_display_position=> 'BOTTOM_RIGHT',
  p_break_type_flag=> 'DEFAULT_BREAK_FORMATTING',
  p_csv_output=> 'N',
  p_query_asc_image=> 'arrow_down_gray_dark.gif',
  p_query_asc_image_attr=> 'width="13" height="12"',
  p_query_desc_image=> 'arrow_up_gray_dark.gif',
  p_query_desc_image_attr=> 'width="13" height="12"',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 10313629055754565.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 8784826606008242.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'SCHEMA',
  p_column_display_sequence=> 2,
  p_column_heading=> 'Schema',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>2,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 10313726515754566.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 8784826606008242.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'SHORT_NAME',
  p_column_display_sequence=> 1,
  p_column_heading=> 'Workspace',
  p_column_link=>'f?p=4050:14:&SESSION.:REPORT:NO:14:SGID:#SECURITY_GROUP_ID#',
  p_column_linktext=>'#SHORT_NAME#',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>1,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 10313825682754566.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 8784826606008242.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 3,
  p_form_element_id=> null,
  p_column_alias=> 'SECURITY_GROUP_ID',
  p_column_display_sequence=> 3,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 10313925109754567.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 8784826606008242.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 4,
  p_form_element_id=> null,
  p_column_alias=> 'ID',
  p_column_display_sequence=> 4,
  p_column_heading=> '',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 10314526762763331.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 8784826606008242.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 5,
  p_form_element_id=> null,
  p_column_alias=> 'PRIVILEGE',
  p_column_display_sequence=> 5,
  p_column_heading=> 'Berechtigung',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 10314607537763333.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 8784826606008242.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 6,
  p_form_element_id=> null,
  p_column_alias=> 'ADMIN_OPTION',
  p_column_display_sequence=> 6,
  p_column_heading=> 'Administrationsoption',
  p_column_alignment=>'CENTER',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
 
begin
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>8790031024028450.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 22.4053,
  p_branch_action=> 'f?p=&APP_ID.:22:&SESSION.::&DEBUG.:::',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Created 25-JAN-2006 00:12 by MIKE');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Geben Sie eine Abfrage ohne Berücksichtigung der Groß-/Kleinschreibung ein, und klicken Sie anschließend auf <b>Los</b>.';

wwv_flow_api.create_page_item(
  p_id=>8786501803010525.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 22.4053,
  p_name=>'P22_FIND',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 8782817687986777.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Suchen',
  p_source_type=> 'STATIC',
  p_display_as=> 'TEXT',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 343399818250317904.4053+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Wählen Sie die Anzahl der Zeilen, die angezeigt werden sollen, und klicken Sie anschließend auf <b>Los</b>.';

wwv_flow_api.create_page_item(
  p_id=>8788201934020094.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 22.4053,
  p_name=>'P22_ROWS',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 20,
  p_item_plug_id => 8782817687986777.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Anzeigen',
  p_source=>'15',
  p_source_type=> 'STATIC',
  p_display_as=> 'COMBOBOX',
  p_named_lov=> 'MAX_ROWS_A',
  p_lov => '.'||to_char(87504531900192794 + wwv_flow_api.g_id_offset)||'.',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'LEFT',
  p_field_alignment  => 'LEFT',
  p_field_template => 343399818250317904.4053+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>8790618342034215.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 22.4053,
  p_name=>'P22_GO',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 30,
  p_item_plug_id => 8782817687986777.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default => 'GO',
  p_prompt=>'Los',
  p_source=>'GO',
  p_source_type=> 'STATIC',
  p_display_as=> 'BUTTON',
  p_lov_columns=> null,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> 2000,
  p_cHeight=> null,
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'N',
  p_item_comment => '');
 
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'reset_pagination';

wwv_flow_api.create_page_process(
  p_id     => 8796107438068988.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 22.4053,
  p_process_sequence=> 10,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'RESET_PAGINATION',
  p_process_name=> 'Reset Pagination',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_when=>':REQUEST is null or :REQUEST = ''GO''',
  p_process_when_type=>'PLSQL_EXPRESSION',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 22.4053
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_23.40
prompt  ...PAGE 23.4053: Benutzer erstellen/bearbeiten
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEADM/adm_users.htm';

ph := null;
wwv_flow_api.create_page(
  p_id     => 23.4053,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'Benutzer erstellen/bearbeiten',
  p_step_title=> 'Benutzer erstellen/bearbeiten',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'AUTO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => 'OFF',
  p_group_id => 216787602191653217+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => '',
  p_step_template => 19236405723931959.4053+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409160252',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>23.4053,p_text=>h);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 4789806742494505.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 23.4053,
  p_plug_name=> '<a name="PRIV"></a>Entwicklerberechtigungen',
  p_region_name=>'',
  p_plug_template=> 24544226211.4053+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 35,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_02',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_display_condition_type => 'VAL_OF_ITEM_IN_COND_EQ_COND2',
  p_plug_display_when_condition => 'P23_IS_ADMIN',
  p_plug_display_when_cond2=>'N',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 12492516163001293.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 23.4053,
  p_plug_name=> '<a name="AC"></a>Account-Steuerung',
  p_region_name=>'',
  p_plug_template=> 24544226211.4053+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 50,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_02',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_display_condition_type => 'VAL_OF_ITEM_IN_COND_EQ_COND2',
  p_plug_display_when_condition => 'P23_IS_ADMIN',
  p_plug_display_when_cond2=>'N',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||':F4050_P23_WEB_PASSWORD := null;'||chr(10)||
':F4050_P23_CONFIRM_PASSWD := null;';

wwv_flow_api.create_page_plug (
  p_id=> 20502200062918881.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 23.4053,
  p_plug_name=> 'reset',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 70,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_HEADER',
  p_plug_source=> s,
  p_plug_source_type=> 'PLSQL_PROCEDURE',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 39295419295089129.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 23.4053,
  p_plug_name=> 'Menu',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(4585800473139662 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 4589126493175495.4053+ wwv_flow_api.g_id_offset,
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 43032554506866236.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 23.4053,
  p_plug_name=> '<a name="USER"></a>Benutzerattribute',
  p_region_name=>'',
  p_plug_template=> 24544226211.4053+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 10,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_02',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> 'Unable to show report. #SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings => 'UserID:Security<br>GroupID:<font color=green>Company</font>:Web<br>Password',
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_num_rows => 15,
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_query_no_data_found=>'Es wurden keine auf Cookies basierenden Benutzer definiert. Klicken Sie auf "Hinzufügen", um einen neuen Benutzer zu erstellen.',
  p_plug_query_show_nulls_as => '(null)',
  p_plug_display_condition_type => '',
  p_plug_header=> 'Administratoren für den &PRODUCT_NAME.-Service können Benutzer-Accounts für einen beliebigen Workspace verwalten.',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> 'generated 16-MAR-2001 11:21:01');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 61303115419117985.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 23.4053,
  p_plug_name=> '<a name="PASSWORD"></a>Kennwort',
  p_region_name=>'',
  p_plug_template=> 24544226211.4053+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 30,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_02',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'&nbsp;';

wwv_flow_api.create_page_plug (
  p_id=> 161703707200871657.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 23.4053,
  p_plug_name=> 'Links',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 5,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_02',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 182517420179163788.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 23.4053,
  p_plug_name=> 'Users',
  p_region_name=>'',
  p_plug_template=> 4888405638168833.4053+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_02',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 190667230101179100.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 23.4053,
  p_plug_name=> '<a name="GROUP"></a>Benutzergruppen',
  p_region_name=>'',
  p_plug_template=> 24544226211.4053+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 60,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_02',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings => '&nbsp;:Flow:User:Developer Role(s)',
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_num_rows => 500,
  p_plug_query_num_rows_type => 'ROWS_X_TO_Y_OF_Z',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_query_show_nulls_as => '(null)',
  p_plug_display_condition_type => 'FUNCTION_BODY',
  p_plug_display_when_condition => 'declare'||chr(10)||
'  l_fnd boolean default false;'||chr(10)||
'begin'||chr(10)||
'for c1 in ('||chr(10)||
'select 1'||chr(10)||
'from wwv_flow_fnd_user_groups'||chr(10)||
'where security_group_id = :F4050_P23_SECURITY_GROUP_ID ) loop'||chr(10)||
'  l_fnd := true;'||chr(10)||
'end loop;'||chr(10)||
'return l_fnd and :P23_IS_ADMIN = ''N'';'||chr(10)||
'end;',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 43032820185866237.4053 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 23.4053,
  p_button_sequence=> 10,
  p_button_plug_id => 182517420179163788+wwv_flow_api.g_id_offset,
  p_button_name    => 'Cancel',
  p_button_image_alt=> 'Abbrechen',
  p_button_position=> 'REGION_TEMPLATE_CLOSE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=&FLOW_ID.:12:&SESSION.::&DEBUG.:::',
  p_button_cattributes=>'class="button10"',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 43033257856866238.4053 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 23.4053,
  p_button_sequence=> 30,
  p_button_plug_id => 182517420179163788+wwv_flow_api.g_id_offset,
  p_button_name    => 'Apply_Changes',
  p_button_image_alt=> 'Änderungen anwenden',
  p_button_position=> 'REGION_TEMPLATE_CREATE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_condition=> 'F4050_P23_USER_ID',
  p_button_condition_type=> 'ITEM_IS_NOT_NULL',
  p_button_cattributes=>'class="button10"',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 43033414946866238.4053 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 23.4053,
  p_button_sequence=> 40,
  p_button_plug_id => 182517420179163788+wwv_flow_api.g_id_offset,
  p_button_name    => 'CREATE',
  p_button_image_alt=> 'Erstellen',
  p_button_position=> 'REGION_TEMPLATE_CREATE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_condition=> 'F4050_P23_USER_ID',
  p_button_condition_type=> 'ITEM_IS_NULL',
  p_button_cattributes=>'class="button10"',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 39279805171990401.4053 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 23.4053,
  p_button_sequence=> 50,
  p_button_plug_id => 182517420179163788+wwv_flow_api.g_id_offset,
  p_button_name    => 'CREATE_ANOTHER',
  p_button_image_alt=> 'Erstellen und weitere(n) erstellen:',
  p_button_position=> 'REGION_TEMPLATE_CREATE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_condition=> 'F4050_P23_USER_ID',
  p_button_condition_type=> 'ITEM_IS_NULL',
  p_button_cattributes=>'class="BUTTON10"',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 43033071157866237.4053 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 23.4053,
  p_button_sequence=> 25,
  p_button_plug_id => 182517420179163788+wwv_flow_api.g_id_offset,
  p_button_name    => 'Delete',
  p_button_image_alt=> 'Benutzer löschen',
  p_button_position=> 'REGION_TEMPLATE_DELETE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'javascript:confirmDelete(''&DELETE_MSG.'');',
  p_button_condition=> ':F4050_P23_USER_ID is not null and :F4050_P23_USER_ID != wwv_flow_user_api.get_user_id(:FLOW_USER)',
  p_button_condition_type=> 'PLSQL_EXPRESSION',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>43031812037866231.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 23.4053,
  p_branch_action=> '12',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'BRANCH_TO_STEP',
  p_branch_sequence=> 20,
  p_branch_condition_type=> 'REQUEST_EQUALS_CONDITION',
  p_branch_condition=> 'Create',
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
wwv_flow_api.create_page_branch(
  p_id=>39280113672990404.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 23.4053,
  p_branch_action=> 'f?p=&APP_ID.:23:&SESSION.::&DEBUG.:23,EDIT_USER_PRIVS::&success_msg=#SUCCESS_MSG#',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_when_button_id=>39279805171990401.4053+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 30,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
wwv_flow_api.create_page_branch(
  p_id=>43032215890866234.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 23.4053,
  p_branch_action=> '12',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'BRANCH_TO_STEP',
  p_branch_sequence=> 99,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Geben Sie das Standardschema für diesen Benutzer ein.';

wwv_flow_api.create_page_item(
  p_id=>2691628386326712.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 23.4053,
  p_name=>'F4050_P23_DEFAULT_SCHEMA',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 30,
  p_item_plug_id => 43032554506866236.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Standardschema',
  p_source_type=> 'STATIC',
  p_display_as=> 'TEXT',
  p_lov_columns=> null,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 32,
  p_cMaxlength=> 255,
  p_cHeight=> 1,
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_read_only_when=>'P23_IS_ADMIN',
  p_read_only_when2=>'Y',
  p_read_only_when_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2',
  p_read_only_disp_attr=>'class="fielddatabold"',
  p_field_template => 111844628719872228.4053+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>12480015129149970.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 23.4053,
  p_name=>'P23_ACCOUNT_EXPIRY',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 170,
  p_item_plug_id => 12492516163001293.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source_type=> 'STATIC',
  p_display_as=> 'HIDDEN',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> 2000,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'LEFT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Verfügbare Optionen:'||chr(10)||
'<ul>'||chr(10)||
'<li>Wählen Sie <b>Gesperrt</b>, um zu verhindern, dass der Account verwendet wird.</li> '||chr(10)||
'<li>Wählen Sie <b>Freigegeben</b>, um die Verwendung dieses Accounts zuzulassen.</b></li>'||chr(10)||
'</ul>';

wwv_flow_api.create_page_item(
  p_id=>12480931059154603.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 23.4053,
  p_name=>'P23_ACCOUNT_LOCKED',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 180,
  p_item_plug_id => 12492516163001293.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default => 'N',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Account-Verfügbarkeit',
  p_source_type=> 'STATIC',
  p_display_as=> 'COMBOBOX',
  p_named_lov=> 'ACCOUNT_LOCK_STATUS',
  p_lov => '.'||to_char(12506800188785204 + wwv_flow_api.g_id_offset)||'.',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 111843720754869910.4053+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>12481506257156915.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 23.4053,
  p_name=>'P23_FAILED_ACCESS_ATTEMPTS',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 220,
  p_item_plug_id => 12492516163001293.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source_type=> 'STATIC',
  p_display_as=> 'HIDDEN',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> 2000,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'LEFT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Wählen Sie <b>Ja</b>, wenn der Benutzer das Kennwort unmittelbar nach der Anmeldung mit dem aktuellen, temporären Kennwort ändern soll. '||chr(10)||
'<p>Diese Regel gilt bei diesem Account für Entwickler und Workspace-Administratoren. Sie gilt außerdem für alle Benutzer, die diesen Account für die Anmeldung bei entwickelten Anwendungen nutzen.';

wwv_flow_api.create_page_item(
  p_id=>12482115260159568.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 23.4053,
  p_name=>'P23_CHANGE_PWD_ON_FIRST_USE',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 225,
  p_item_plug_id => 12492516163001293.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Kennwort muss nach erster Verwendung geändert werden',
  p_source_type=> 'STATIC',
  p_display_as=> 'COMBOBOX',
  p_named_lov=> 'YES_NO_RETURNS_Y_OR_N',
  p_lov => '.'||to_char(157992123774592395 + wwv_flow_api.g_id_offset)||'.',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_cattributes_element=>'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 111843720754869910.4053+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>12482722533161601.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 23.4053,
  p_name=>'P23_FIRST_PWD_USE_OCCURRED',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 230,
  p_item_plug_id => 12492516163001293.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source_type=> 'STATIC',
  p_display_as=> 'HIDDEN',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> 2000,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'LEFT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>12496823435353552.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 23.4053,
  p_name=>'P23_SHOW_EXPIRE_FLAG',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 200,
  p_item_plug_id => 12492516163001293.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source_type=> 'STATIC',
  p_display_as=> 'HIDDEN',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'LEFT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Gibt an, ob das Kennwort abgelaufen ist oder für die Anmeldung als Entwickler oder Administrator gültig ist.';

wwv_flow_api.create_page_item(
  p_id=>12498809783385770.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 23.4053,
  p_name=>'P23_EXPIRATION_STATUS1',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 190,
  p_item_plug_id => 12492516163001293.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Entwickler-/Administratorkennwort:',
  p_source_type=> 'STATIC',
  p_display_as=> 'DISPLAY_ONLY_ESCAPE_SC',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_tag_attributes  => 'class="fielddatabold" ',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_display_when=>':F4050_P23_USER_ID is not null and :P23_EXPIRATION_STATUS1 <> ''NA''',
  p_display_when_type=>'PLSQL_EXPRESSION',
  p_field_template => 111843720754869910.4053+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Gibt an, ob das Kennwort abgelaufen ist oder für die Anmeldung als Endbenutzer gültig ist.';

wwv_flow_api.create_page_item(
  p_id=>12499022628385770.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 23.4053,
  p_name=>'P23_EXPIRATION_STATUS2',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 195,
  p_item_plug_id => 12492516163001293.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Endbenutzerkennwort:',
  p_source_type=> 'STATIC',
  p_display_as=> 'DISPLAY_ONLY_ESCAPE_SC',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 4000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap',
  p_tag_attributes  => 'class="fielddatabold" ',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_display_when=>':F4050_P23_USER_ID is not null and :P23_EXPIRATION_STATUS2 <> ''NA''',
  p_display_when_type=>'PLSQL_EXPRESSION',
  p_field_template => 111843720754869910.4053+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Aktivieren Sie diese Option, damit das Benutzerkennwort abläuft. Davon ist sowohl die Anmeldung als Entwickler/Administrator als auch der Zugriff als Endbenutzer betroffen. Wenn das Kennwort abgelaufen ist, muss der Benutzer beim nächsten Account-Zugriff das alte Kennwort zusammen mit einem neuen Kennwort eingeben, um sich anmelden zu können.';

wwv_flow_api.create_page_item(
  p_id=>12501217642408601.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 23.4053,
  p_name=>'P23_EXPIRE',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 210,
  p_item_plug_id => 12492516163001293.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Kennwortablauf',
  p_source_type=> 'STATIC',
  p_display_as=> 'CHECKBOX',
  p_lov => 'select null d, ''Y'' r from dual',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_display_when=>':P23_SHOW_EXPIRE_FLAG = ''Y'' and :F4050_P23_USER_ID is not null',
  p_display_when_type=>'PLSQL_EXPRESSION',
  p_field_template => 111843720754869910.4053+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>43033620636866241.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 23.4053,
  p_name=>'F4050_P23_USER_ID',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 90,
  p_item_plug_id => 43032554506866236.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'User ID',
  p_display_as=> 'HIDDEN',
  p_lov_columns=> null,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 32,
  p_cMaxlength=> 255,
  p_cHeight=> 1,
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Geben Sie den Benutzernamen ein.';

wwv_flow_api.create_page_item(
  p_id=>43033813964866242.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 23.4053,
  p_name=>'F4050_P23_USER_NAME',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 43032554506866236.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Benutzername',
  p_source_type=> 'STATIC',
  p_display_as=> 'TEXT',
  p_lov_columns=> null,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 32,
  p_cMaxlength=> 255,
  p_cHeight=> 1,
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_read_only_when=>'P23_IS_ADMIN',
  p_read_only_when2=>'Y',
  p_read_only_when_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2',
  p_read_only_disp_attr=>'class="fielddatabold"',
  p_field_template => 111844628719872228.4053+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Geben Sie den Vornamen des Benutzers ein.';

wwv_flow_api.create_page_item(
  p_id=>43034067641866243.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 23.4053,
  p_name=>'F4050_P23_FIRST_NAME',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 50,
  p_item_plug_id => 43032554506866236.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Vorname',
  p_source_type=> 'STATIC',
  p_display_as=> 'TEXT',
  p_lov_columns=> null,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 32,
  p_cMaxlength=> 255,
  p_cHeight=> 1,
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_read_only_when=>'P23_IS_ADMIN',
  p_read_only_when2=>'Y',
  p_read_only_when_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2',
  p_read_only_disp_attr=>'class="fielddatabold"',
  p_field_template => 111843720754869910.4053+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Geben Sie den Nachnamen des Benutzers ein.'||chr(10)||
''||chr(10)||
'';

wwv_flow_api.create_page_item(
  p_id=>43034227119866244.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 23.4053,
  p_name=>'F4050_P23_LAST_NAME',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 60,
  p_item_plug_id => 43032554506866236.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Nachname',
  p_source_type=> 'STATIC',
  p_display_as=> 'TEXT',
  p_lov_columns=> null,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 32,
  p_cMaxlength=> 255,
  p_cHeight=> 1,
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_read_only_when=>'P23_IS_ADMIN',
  p_read_only_when2=>'Y',
  p_read_only_when_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2',
  p_read_only_disp_attr=>'class="fielddatabold"',
  p_field_template => 111843720754869910.4053+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Geben Sie optional eine Beschreibung für diesen Benutzer ein.';

wwv_flow_api.create_page_item(
  p_id=>43035819093866248.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 23.4053,
  p_name=>'F4050_P23_DESCRIPTION',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 70,
  p_item_plug_id => 43032554506866236.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Beschreibung',
  p_source_type=> 'STATIC',
  p_display_as=> 'TEXTAREA-AUTO-HEIGHT',
  p_lov_columns=> null,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 32,
  p_cMaxlength=> 255,
  p_cHeight=> 3,
  p_cAttributes=> 'valign="top"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_read_only_when=>'P23_IS_ADMIN',
  p_read_only_when2=>'Y',
  p_read_only_when_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2',
  p_read_only_disp_attr=>'class="fielddatabold"',
  p_field_template => 111843720754869910.4053+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Geben Sie die E-Mail-Adresse des Benutzers ein.';

wwv_flow_api.create_page_item(
  p_id=>43037241672866252.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 23.4053,
  p_name=>'F4050_P23_EMAIL_ADDRESS',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 20,
  p_item_plug_id => 43032554506866236.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'E-Mail-Adresse',
  p_source_type=> 'STATIC',
  p_display_as=> 'TEXT',
  p_lov_columns=> null,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 32,
  p_cMaxlength=> 255,
  p_cHeight=> 1,
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_read_only_when=>'P23_IS_ADMIN',
  p_read_only_when2=>'Y',
  p_read_only_when_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2',
  p_read_only_disp_attr=>'class="fielddatabold"',
  p_field_template => 111844628719872228.4053+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Geben Sie das Kennwort ein. (Führen Sie diesen Vorgang nur dann aus, wenn Sie einen neuen Account mit einem Kennwort erstellen oder wenn Sie das Kennwort für einen vorhandenen Account aktualisieren.)';

wwv_flow_api.create_page_item(
  p_id=>43037870063866254.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 23.4053,
  p_name=>'F4050_P23_WEB_PASSWORD',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 80,
  p_item_plug_id => 61303115419117985.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Kennwort',
  p_post_element_text=>' <span class="instructiontext">Bei der Kennworteingabe wird zwischen Groß- und Kleinschreibung unterschieden</span>',
  p_source_type=> 'ALWAYS_NULL',
  p_display_as=> 'PASSWORD_DNSS',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 32,
  p_cMaxlength=> 255,
  p_cHeight=> 1,
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'ABOVE',
  p_field_alignment  => 'LEFT',
  p_field_template => 111843720754869910.4053+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Wählen Sie einen Workspace für den Benutzer aus der Popup-Liste.';

wwv_flow_api.create_page_item(
  p_id=>43042986599987259.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 23.4053,
  p_name=>'F4050_P23_SECURITY_GROUP_ID',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 40,
  p_item_plug_id => 43032554506866236.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Workspace',
  p_source_type=> 'STATIC',
  p_display_as=> 'POPUP_KEY_LOV',
  p_named_lov=> 'LIST_ALL_COMPANIES_NO_NULL_OPTION',
  p_lov => 'select short_name||'' (''||PROVISIONING_COMPANY_ID||'')'' d,'||chr(10)||
'       PROVISIONING_COMPANY_ID r'||chr(10)||
'from   WWV_FLOW_COMPANIES'||chr(10)||
'where  provisioning_company_id > 0'||chr(10)||
'order by 1',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_read_only_when=>'P23_IS_ADMIN',
  p_read_only_when2=>'Y',
  p_read_only_when_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2',
  p_read_only_disp_attr=>'class="fielddatabold"',
  p_field_template => 111844628719872228.4053+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>68678531660411621.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 23.4053,
  p_name=>'P23_IS_ADMIN',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 140,
  p_item_plug_id => 43032554506866236.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_source_type=> 'STATIC',
  p_display_as=> 'HIDDEN',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> 2000,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'LEFT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Geben Sie an, ob dieser Benutzer mit Entwicklerberechtigungen ausgestattet werden soll.';

wwv_flow_api.create_page_item(
  p_id=>157994413889601615.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 23.4053,
  p_name=>'P23_DEVELOPER',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 150,
  p_item_plug_id => 4789806742494505.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default => 'Y',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Benutzer ist Entwickler:',
  p_source_type=> 'STATIC',
  p_display_as=> 'RADIOGROUP',
  p_named_lov=> 'YES_NO_RETURNS_Y_OR_N',
  p_lov => '.'||to_char(157992123774592395 + wwv_flow_api.g_id_offset)||'.',
  p_lov_columns=> 2,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_tag_attributes  => 'onClick="javascript:if (document.forms[0].P23_ADMIN_0.checked) document.forms[0].P23_DEVELOPER_0.checked = true;"',
  p_tag_attributes2=> 'class="fielddata"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 111843720754869910.4053+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Geben Sie an, ob dieser Benutzer mit Administratorberechtigungen (beispielsweise zum Erstellen von neuen Benutzern) ausgestattet werden soll.';

wwv_flow_api.create_page_item(
  p_id=>157996406317627808.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 23.4053,
  p_name=>'P23_ADMIN',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 160,
  p_item_plug_id => 4789806742494505.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default => 'Y',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Benutzer ist Administrator:',
  p_source_type=> 'STATIC',
  p_display_as=> 'RADIOGROUP',
  p_named_lov=> 'YES_NO_RETURNS_Y_OR_N',
  p_lov => '.'||to_char(157992123774592395 + wwv_flow_api.g_id_offset)||'.',
  p_lov_columns=> 2,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_tag_attributes  => 'onClick="javascript:if (document.forms[0].P23_ADMIN_0.checked) document.forms[0].P23_DEVELOPER_0.checked = true;"',
  p_tag_attributes2=> 'class="fielddata"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 111843720754869910.4053+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>182810818563091386.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 23.4053,
  p_name=>'F4050_P23_DEV_PRIVS',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 120,
  p_item_plug_id => 4789806742494505.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Developer Privileges (Click only ADMIN to receive all privileges)',
  p_source_type=> 'STATIC',
  p_display_as=> 'HIDDEN',
  p_named_lov=> 'DEVELOPER.PRIVS',
  p_lov => '.'||to_char(182796815771077530 + wwv_flow_api.g_id_offset)||'.',
  p_lov_columns=> 3,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_tag_attributes2=> 'class="fieldtitleleft"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'LEFT',
  p_field_alignment  => 'LEFT',
  p_field_template => 111843720754869910.4053+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Geben Sie an, welchen Gruppen der Benutzer angehört.';

wwv_flow_api.create_page_item(
  p_id=>190665205313175398.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 23.4053,
  p_name=>'F4050_P23_GROUPS',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 130,
  p_item_plug_id => 190667230101179100.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Gruppen',
  p_source_type=> 'STATIC',
  p_display_as=> 'MULTIPLESELECT',
  p_named_lov=> 'USER.GROUPS',
  p_lov => 'select htf.escape_sc(group_name) d, id r'||chr(10)||
'from wwv_flow_fnd_user_groups'||chr(10)||
'where security_group_id = :F4050_P23_SECURITY_GROUP_ID order by 1',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 8,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 111843720754869910.4053+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Bestätigen Sie das Kennwort durch eine erneute Eingabe. (Führen Sie diesen Vorgang nur dann aus, wenn Sie einen neuen Account mit einem Kennwort erstellen oder wenn Sie das Kennwort für einen vorhandenen Account aktualisieren.)';

wwv_flow_api.create_page_item(
  p_id=>240387620119665972.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 23.4053,
  p_name=>'F4050_P23_CONFIRM_PASSWD',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 82,
  p_item_plug_id => 61303115419117985.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Kennwort bestätigen',
  p_post_element_text=>' <span class="instructiontext">Bei der Kennworteingabe wird zwischen Groß- und Kleinschreibung unterschieden</span>',
  p_source=>'F4050_P23_WEB_PASSWORD',
  p_source_type=> 'ITEM',
  p_display_as=> 'PASSWORD_DNSS',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 32,
  p_cMaxlength=> 255,
  p_cHeight=> 1,
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'ABOVE',
  p_field_alignment  => 'LEFT',
  p_field_template => 111843720754869910.4053+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_computation(
  p_id=> 61308415871133351.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 23.4053,
  p_computation_sequence => 10,
  p_computation_item=> 'F4050_P23_WEB_PASSWORD',
  p_computation_point=> 'AFTER_SUBMIT',
  p_computation_type=> 'PLSQL_EXPRESSION',
  p_computation_processed=> 'REPLACE_EXISTING',
  p_computation=> 'ltrim(rtrim(:F4050_P23_WEB_PASSWORD))',
  p_compute_when => '',
  p_compute_when_type=>'');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_computation(
  p_id=> 316540319552589525.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 23.4053,
  p_computation_sequence => 20,
  p_computation_item=> 'F4050_P23_DEFAULT_SCHEMA',
  p_computation_point=> 'AFTER_SUBMIT',
  p_computation_type=> 'PLSQL_EXPRESSION',
  p_computation_processed=> 'REPLACE_EXISTING',
  p_computation=> 'replace(:F4050_P23_DEFAULT_SCHEMA,''%''||''null%'',null)',
  p_compute_when => '',
  p_compute_when_type=>'');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_computation(
  p_id=> 240393507137700064.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 23.4053,
  p_computation_sequence => 30,
  p_computation_item=> 'F4050_P23_CONFIRM_PASSWD',
  p_computation_point=> 'AFTER_SUBMIT',
  p_computation_type=> 'PLSQL_EXPRESSION',
  p_computation_processed=> 'REPLACE_EXISTING',
  p_computation=> 'ltrim(rtrim(:F4050_P23_CONFIRM_PASSWD))',
  p_compute_when => '',
  p_compute_when_type=>'');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_computation(
  p_id=> 12553531088759090.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 23.4053,
  p_computation_sequence => 40,
  p_computation_item=> 'P23_CHANGE_PWD_ON_FIRST_USE',
  p_computation_point=> 'AFTER_SUBMIT',
  p_computation_type=> 'FUNCTION_BODY',
  p_computation_processed=> 'REPLACE_EXISTING',
  p_computation=> 'if nvl(:P23_CHANGE_PWD_ON_FIRST_USE,''N'') <> ''Y'' then'||chr(10)||
'  return ''N'';'||chr(10)||
'else'||chr(10)||
'  return ''Y'';'||chr(10)||
'end if;'||chr(10)||
'',
  p_compute_when => '',
  p_compute_when_type=>'');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_computation(
  p_id=> 12554726371767163.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 23.4053,
  p_computation_sequence => 50,
  p_computation_item=> 'P23_EXPIRE',
  p_computation_point=> 'AFTER_SUBMIT',
  p_computation_type=> 'FUNCTION_BODY',
  p_computation_processed=> 'REPLACE_EXISTING',
  p_computation=> 'if nvl(:P23_EXPIRE,''N'') <> ''Y'' then'||chr(10)||
'  return ''N'';'||chr(10)||
'else'||chr(10)||
'  return ''Y'';'||chr(10)||
'end if;',
  p_compute_when => '',
  p_compute_when_type=>'');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_computation(
  p_id=> 12555506070770774.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 23.4053,
  p_computation_sequence => 60,
  p_computation_item=> 'P23_ACCOUNT_LOCKED',
  p_computation_point=> 'AFTER_SUBMIT',
  p_computation_type=> 'FUNCTION_BODY',
  p_computation_processed=> 'REPLACE_EXISTING',
  p_computation=> 'if nvl(:P23_ACCOUNT_LOCKED,''N'') <> ''Y'' then'||chr(10)||
'  return ''N'';'||chr(10)||
'else'||chr(10)||
'  return ''Y'';'||chr(10)||
'end if;',
  p_compute_when => '',
  p_compute_when_type=>'');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 182742403109007422.4053 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 23.4053,
  p_validation_name => 'F4050_P23_EMAIL_ADDRESS Not Null',
  p_validation_sequence=> 1,
  p_validation => 'F4050_P23_EMAIL_ADDRESS',
  p_validation_type => 'ITEM_NOT_NULL',
  p_error_message => 'Die E-Mail-Adresse muss angegeben werden.',
  p_validation_condition=> ':REQUEST IN (''Apply_Changes'',''CREATE'',''CREATE_ANOTHER'') and'||chr(10)||
':P23_IS_ADMIN != ''Y''',
  p_validation_condition_type=> 'PLSQL_EXPRESSION',
  p_associated_item=> 43037241672866252.4053 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> 'generated 22-FEB-2002 12:40');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 182745532211009071.4053 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 23.4053,
  p_validation_name => 'F4050_P23_USER_NAME Not Null',
  p_validation_sequence=> 1,
  p_validation => 'F4050_P23_USER_NAME',
  p_validation_type => 'ITEM_NOT_NULL',
  p_error_message => 'Der Benutzername muss angegeben werden.',
  p_validation_condition=> ':REQUEST in (''Apply_Changes'',''CREATE'',''CREATE_ANOTHER'') and'||chr(10)||
':P23_IS_ADMIN != ''Y''',
  p_validation_condition_type=> 'PLSQL_EXPRESSION',
  p_associated_item=> 43033813964866242.4053 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> 'generated 22-FEB-2002 12:40');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 182742730875007426.4053 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 23.4053,
  p_validation_name => 'F4050_P23_WEB_PASSWORD Not Null',
  p_validation_sequence=> 2,
  p_validation => 'F4050_P23_WEB_PASSWORD',
  p_validation_type => 'ITEM_NOT_NULL',
  p_error_message => 'Das Kennwort** muss angegeben werden.',
  p_validation_condition=> 'CREATE,CREATE_ANOTHER',
  p_validation_condition_type=> 'REQUEST_IN_CONDITION',
  p_associated_item=> 43037870063866254.4053 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> 'generated 22-FEB-2002 12:40');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 240392628824696884.4053 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 23.4053,
  p_validation_name => 'Confirm PAssword',
  p_validation_sequence=> 3,
  p_validation => '( :F4050_P23_WEB_PASSWORD = :F4050_P23_CONFIRM_PASSWD ) '||chr(10)||
'or ( :REQUEST = ''Apply_Changes'' '||chr(10)||
'     AND  :F4050_P23_WEB_PASSWORD is null '||chr(10)||
'     and  :F4050_P23_CONFIRM_PASSWD is null )',
  p_validation_type => 'PLSQL_EXPRESSION',
  p_error_message => 'Die Kennwörter stimmen nicht überein.',
  p_validation_condition=> 'CREATE,CREATE_ANOTHER,Apply_Changes',
  p_validation_condition_type=> 'REQUEST_IN_CONDITION',
  p_associated_item=> .4053 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 39286930629035660.4053 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 23.4053,
  p_validation_name => 'workspace not null',
  p_validation_sequence=> 10,
  p_validation => 'F4050_P23_SECURITY_GROUP_ID',
  p_validation_type => 'ITEM_NOT_NULL',
  p_error_message => 'Der Workspace muss angegeben werden.',
  p_validation_condition=> ':REQUEST in (''Apply_Changes'',''CREATE'',''CREATE_ANOTHER'') and'||chr(10)||
':P23_IS_ADMIN != ''Y''',
  p_validation_condition_type=> 'PLSQL_EXPRESSION',
  p_associated_item=> 43042986599987259.4053 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 149174714581321552.4053 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 23.4053,
  p_validation_name => 'WorkspaceNumeric',
  p_validation_sequence=> 15,
  p_validation => 'F4050_P23_SECURITY_GROUP_ID',
  p_validation_type => 'ITEM_IS_NUMERIC',
  p_error_message => 'Der Workspace muss numerisch sein.',
  p_validation_condition=> ':REQUEST in (''Apply_Changes'',''CREATE'',''CREATE_ANOTHER'') and'||chr(10)||
':P23_IS_ADMIN != ''Y''',
  p_validation_condition_type=> 'PLSQL_EXPRESSION',
  p_associated_item=> 43042986599987259.4053 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'ON_ERROR_PAGE',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 149172103583299374.4053 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 23.4053,
  p_validation_name => 'WorkspaceValid',
  p_validation_sequence=> 20,
  p_validation => 'select ''1'' '||chr(10)||
'  from WWV_FLOW_COMPANIES'||chr(10)||
' where provisioning_company_id > 0'||chr(10)||
'   and :F4050_P23_SECURITY_GROUP_ID = PROVISIONING_COMPANY_ID',
  p_validation_type => 'EXISTS',
  p_error_message => 'Es muss ein gültiger Workspace ausgewählt werden.',
  p_validation_condition=> ':REQUEST in (''Apply_Changes'',''CREATE'',''CREATE_ANOTHER'') and'||chr(10)||
':P23_IS_ADMIN != ''Y''',
  p_validation_condition_type=> 'NEVER',
  p_associated_item=> .4053 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 159991611582821049.4053 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 23.4053,
  p_validation_name => 'cannot remove admin from yourself',
  p_validation_sequence=> 30,
  p_validation => 'if :F4050_P23_USER_ID = wwv_flow_user_api.get_user_id(:FLOW_USER) and :P23_ADMIN = ''N'' then'||chr(10)||
'  return false;'||chr(10)||
'else'||chr(10)||
'  return true;'||chr(10)||
'end if;',
  p_validation_type => 'FUNC_BODY_RETURNING_BOOLEAN',
  p_error_message => 'Sie können sich keine Administratorrechte entziehen.',
  p_validation_condition=> ':P23_IS_ADMIN != ''Y''',
  p_validation_condition_type=> 'PLSQL_EXPRESSION',
  p_when_button_pressed=> 43033257856866238.4053 + wwv_flow_api.g_id_offset,
  p_associated_item=> 157996406317627808.4053 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 161251407978152754.4053 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 23.4053,
  p_validation_name => 'default schema required',
  p_validation_sequence=> 40,
  p_validation => 'F4050_P23_DEFAULT_SCHEMA',
  p_validation_type => 'ITEM_NOT_NULL',
  p_error_message => 'Das Standardschema muss angegeben werden.',
  p_validation_condition=> ':REQUEST in (''Apply_Changes'',''CREATE'',''CREATE_ANOTHER'') and'||chr(10)||
':P23_IS_ADMIN != ''Y''',
  p_validation_condition_type=> 'PLSQL_EXPRESSION',
  p_associated_item=> 2691628386326712.4053 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 164285025826484749.4053 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 23.4053,
  p_validation_name => 'prevent duplicate username',
  p_validation_sequence=> 50,
  p_validation => 'select 1 r'||chr(10)||
'  from wwv_flow_fnd_user'||chr(10)||
' where user_name = upper(:F4050_P23_USER_NAME)'||chr(10)||
'   and security_group_id = :F4050_P23_SECURITY_GROUP_ID',
  p_validation_type => 'NOT_EXISTS',
  p_error_message => 'Der Benutzername muss innerhalb des Workspace eindeutig sein.',
  p_validation_condition=> ':REQUEST in (''CREATE'',''CREATE_ANOTHER'') and'||chr(10)||
':P23_IS_ADMIN != ''Y''',
  p_validation_condition_type=> 'PLSQL_EXPRESSION',
  p_associated_item=> 43033813964866242.4053 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 111539302381125034.4053 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 23.4053,
  p_validation_name => 'Invalid characters in username',
  p_validation_sequence=> 70,
  p_validation => 'F4050_P23_USER_NAME',
  p_validation2 => '<>',
  p_validation_type => 'ITEM_IN_VALIDATION_CONTAINS_NO_CHAR_IN_STRING2',
  p_error_message => 'Ungültiger Benutzername.',
  p_validation_condition=> 'Apply_Changes,CREATE,CREATE_ANOTHER',
  p_validation_condition_type=> 'REQUEST_IN_CONDITION',
  p_associated_item=> 43033813964866242.4053 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 23877827234193982.4053 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 23.4053,
  p_validation_name => 'strong password verification',
  p_validation_sequence=> 80,
  p_validation => 'declare '||chr(10)||
'  l_use_strong_rules boolean;'||chr(10)||
'begin'||chr(10)||
'  if :F4050_P23_SECURITY_GROUP_ID = 10 and nvl(wwv_flow_platform.get_preference(''STRONG_SITE_ADMIN_PASSWORD''),''N'') = ''Y'' then'||chr(10)||
'    l_use_strong_rules := true;'||chr(10)||
'  else'||chr(10)||
'    l_use_strong_rules := false;'||chr(10)||
'  end if;'||chr(10)||
'  '||chr(10)||
'  return wwv_flow_security.strong_password_validation('||chr(10)||
'      p_username              => :F4050_P23_USER_NAME,'||chr(10)||
'      p_password              => :F4050_P23_WEB_PASSWORD,'||chr(10)||
'      p_old_password          => null,'||chr(10)||
'      p_workspace_name        => wwv_flow_security.find_company_name(:F4050_P23_SECURITY_GROUP_ID),'||chr(10)||
'      p_use_strong_rules      => l_use_strong_rules);'||chr(10)||
'end;',
  p_validation_type => 'FUNC_BODY_RETURNING_ERR_TEXT',
  p_error_message => 'Fehler',
  p_validation_condition=> ':F4050_P23_WEB_PASSWORD is not null and'||chr(10)||
':REQUEST IN (''Apply_Changes'',''CREATE'',''CREATE_ANOTHER'')',
  p_validation_condition_type=> 'PLSQL_EXPRESSION',
  p_associated_item=> 43037870063866254.4053 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'wwv_flow_admin_api.fetch_user (     '||chr(10)||
'     p_user_id         => :F4050_P23_USER_ID,     '||chr(10)||
'     p_user_name       => :F4050_P23_USER_NAME,'||chr(10)||
'     p_first_name      => :F4050_P23_FIRST_NAME,'||chr(10)||
'     p_last_name       => :F4050_P23_LAST_NAME,     '||chr(10)||
'     p_email_address   => :F4050_P23_EMAIL_ADDRESS,     '||chr(10)||
'     p_groups          => :F4050_P23_GROUPS,'||chr(10)||
'     p_developer_role  => :F4050_P23_DEV_PRIVS,'||chr(10)||
'     p_defau';

p:=p||'lt_schema  => :F4050_P23_DEFAULT_SCHEMA,'||chr(10)||
'     p_description     => :F4050_P23_DESCRIPTION,'||chr(10)||
'     p_account_expiry     => :P23_ACCOUNT_EXPIRY,'||chr(10)||
'     p_account_locked     => :P23_ACCOUNT_LOCKED,'||chr(10)||
'     p_failed_access_attempts     => :P23_FAILED_ACCESS_ATTEMPTS,'||chr(10)||
'     p_change_password_on_first_use     => :P23_CHANGE_PWD_ON_FIRST_USE, '||chr(10)||
'     p_first_password_use_occurred     => :P23_FIRST_PWD_USE_OCCURRED';

p:=p||','||chr(10)||
'     p_security_group_id => :F4050_P23_SECURITY_GROUP_ID'||chr(10)||
'     );'||chr(10)||
''||chr(10)||
'if :F4050_P23_DEV_PRIVS is null then'||chr(10)||
'  :P23_DEVELOPER := ''N'';'||chr(10)||
'  :P23_ADMIN := ''N'';'||chr(10)||
'elsif instr(:F4050_P23_DEV_PRIVS,''ADMIN'') > 0 then'||chr(10)||
'  :P23_DEVELOPER := ''Y'';'||chr(10)||
'  :P23_ADMIN := ''Y'';'||chr(10)||
'else'||chr(10)||
'  :P23_DEVELOPER := ''Y'';'||chr(10)||
'  :P23_ADMIN := ''N'';'||chr(10)||
'end if;';

wwv_flow_api.create_page_process(
  p_id     => 43038016537866257.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 23.4053,
  p_process_sequence=> 10,
  p_process_point=> 'AFTER_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'fetch user information',
  p_process_sql_clob => p, 
  p_process_error_message=> 'Fehler beim Abrufen von Zeile.',
  p_process_when=>'F4050_P23_USER_ID',
  p_process_when_type=>'ITEM_IS_NOT_NULL',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'declare'||chr(10)||
'  l_site_account_lifetime number := '||chr(10)||
'    nvl(wwv_flow_platform.get_preference(''ACCOUNT_LIFETIME_DAYS''),45);'||chr(10)||
'  l_workspace_account_lifetime number;'||chr(10)||
'  l_account_last_updated date;'||chr(10)||
'  l_dev_admin_expired boolean := false;'||chr(10)||
'  l_end_user_expired boolean := false;'||chr(10)||
'  l_found boolean := false;'||chr(10)||
'begin'||chr(10)||
''||chr(10)||
'if :F4050_P23_SECURITY_GROUP_ID = ''10'' and :F4050_P23_USER_NAME = ''ADMIN'' then'||chr(10)||
'  :P23_IS_ADMIN := ''Y';

p:=p||''';'||chr(10)||
'else'||chr(10)||
'  :P23_IS_ADMIN := ''N'';'||chr(10)||
'end if;'||chr(10)||
''||chr(10)||
'--'||chr(10)||
'-- account expiration notices'||chr(10)||
'--'||chr(10)||
'l_account_last_updated := nvl(:P23_ACCOUNT_EXPIRY, trunc(sysdate));'||chr(10)||
'for c1 in (select ACCOUNT_LIFETIME_DAYS from WWV_FLOW_COMPANIES'||chr(10)||
'           where provisioning_company_id = :F4050_P23_SECURITY_GROUP_ID) loop'||chr(10)||
'  l_workspace_account_lifetime := c1.account_lifetime_days;'||chr(10)||
'end loop;'||chr(10)||
''||chr(10)||
':P23_SHOW_EXPIRE_FLAG := ''N'';'||chr(10)||
'if :P23_DEVE';

p:=p||'LOPER = ''Y'' then'||chr(10)||
'  if l_account_last_updated + l_site_account_lifetime < sysdate then'||chr(10)||
'    l_dev_admin_expired := true;'||chr(10)||
'    :P23_EXPIRATION_STATUS1 := wwv_flow_lang.system_message(''EXPIRED'');'||chr(10)||
'  else'||chr(10)||
'    :P23_EXPIRATION_STATUS1 := wwv_flow_lang.system_message(''VALID'');'||chr(10)||
'    :P23_SHOW_EXPIRE_FLAG := ''Y'';'||chr(10)||
'  end if;'||chr(10)||
'else'||chr(10)||
'  :P23_EXPIRATION_STATUS1 := ''NA'';'||chr(10)||
'end if;'||chr(10)||
''||chr(10)||
'for c1 in (select ACCOUNT_LIFETIME_DAYS';

p:=p||' from WWV_FLOW_COMPANIES'||chr(10)||
'           where EXPIRE_FND_USER_ACCOUNTS = ''Y'''||chr(10)||
'           and provisioning_company_id = :F4050_P23_SECURITY_GROUP_ID) loop'||chr(10)||
'  l_found := true;'||chr(10)||
'  if l_account_last_updated + l_workspace_account_lifetime < sysdate then'||chr(10)||
'    l_end_user_expired := true;'||chr(10)||
'    :P23_EXPIRATION_STATUS2 := wwv_flow_lang.system_message(''EXPIRED'');'||chr(10)||
'  else'||chr(10)||
'    :P23_EXPIRATION_STATUS2 := wwv_flow_lang.sy';

p:=p||'stem_message(''VALID'');'||chr(10)||
'    :P23_SHOW_EXPIRE_FLAG := ''Y'';'||chr(10)||
'  end if;'||chr(10)||
'end loop;'||chr(10)||
'if not l_found then'||chr(10)||
'  :P23_EXPIRATION_STATUS2 := ''NA'';'||chr(10)||
'end if;'||chr(10)||
'end;';

wwv_flow_api.create_page_process(
  p_id     => 68692203366535952.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 23.4053,
  p_process_sequence=> 20,
  p_process_point=> 'AFTER_HEADER',
  p_process_type=> 'PLSQL',
  p_process_name=> 'set values',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'wwv_flow_admin_api.remove_user (p_user_id => :F4050_P23_USER_ID,'||chr(10)||
'                                p_security_group_id => :F4050_P23_SECURITY_GROUP_ID);';

wwv_flow_api.create_page_process(
  p_id     => 182690830061736577.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 23.4053,
  p_process_sequence=> 20,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'cascade delete to developer privs',
  p_process_sql_clob => p, 
  p_process_error_message=> 'Fehler beim Löschen von Benutzer.',
  p_process_when_button_id=>43033071157866237.4053 + wwv_flow_api.g_id_offset,
  p_process_success_message=> 'Benutzer &F4050_P23_USER_NAME. wurde gelöscht.',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'declare '||chr(10)||
'  l_p1 varchar2(256) := v(''F4050_P23_WEB_PASSWORD'');'||chr(10)||
'  l_p2 varchar2(256) := v(''F4050_P23_CONFIRM_PASSWD'');'||chr(10)||
'  l_site_account_lifetime number := '||chr(10)||
'    nvl(wwv_flow_platform.get_preference(''ACCOUNT_LIFETIME_DAYS''),45);'||chr(10)||
'  l_workspace_account_lifetime number;'||chr(10)||
'  l_account_last_updated date;'||chr(10)||
'  l_account_next_updated date;'||chr(10)||
'  l_new_expiry date;'||chr(10)||
'begin'||chr(10)||
'  l_account_last_updated := nvl(:P23_ACCOUNT_EX';

p:=p||'PIRY, trunc(sysdate));'||chr(10)||
'  for c1 in (select ACCOUNT_LIFETIME_DAYS from WWV_FLOW_COMPANIES'||chr(10)||
'           where provisioning_company_id = :F4050_P23_SECURITY_GROUP_ID) loop'||chr(10)||
'    l_workspace_account_lifetime := nvl(c1.account_lifetime_days,l_site_account_lifetime);'||chr(10)||
'  end loop;'||chr(10)||
'  l_account_next_updated := trunc(sysdate) -'||chr(10)||
'    greatest(l_workspace_account_lifetime,l_site_account_lifetime); '||chr(10)||
'  if v(''P23_EXPI';

p:=p||'RE'') = ''N'' then'||chr(10)||
'    l_new_expiry := l_account_last_updated;'||chr(10)||
'  else'||chr(10)||
'    l_new_expiry := l_account_next_updated;'||chr(10)||
'  end if;'||chr(10)||
''||chr(10)||
'  wwv_flow.update_cache_with_write(''F4050_P23_WEB_PASSWORD'',null);'||chr(10)||
'  wwv_flow.update_cache_with_write(''F4050_P23_CONFIRM_PASSWD'',null);'||chr(10)||
'  '||chr(10)||
'wwv_flow_admin_api.edit_user_and_group ('||chr(10)||
'     p_user_id            => :F4050_P23_USER_ID,     '||chr(10)||
'     p_security_group_id  => :F4050_P23_SECU';

p:=p||'RITY_GROUP_ID,'||chr(10)||
'     p_user_name          => :F4050_P23_USER_NAME,'||chr(10)||
'     p_first_name         => :F4050_P23_FIRST_NAME,'||chr(10)||
'     p_last_name          => :F4050_P23_LAST_NAME,'||chr(10)||
'     p_web_password       => l_p1,'||chr(10)||
'     p_new_password       => l_p2,'||chr(10)||
'     p_email_address      => :F4050_P23_EMAIL_ADDRESS,     '||chr(10)||
'     p_default_schema     => :F4050_P23_DEFAULT_SCHEMA,     '||chr(10)||
'     p_group_ids          => :F4050_P23_';

p:=p||'GROUPS,     '||chr(10)||
'     p_description        => :F4050_P23_DESCRIPTION,'||chr(10)||
'     p_account_expiry     => l_new_expiry,'||chr(10)||
'     p_account_locked     => :P23_ACCOUNT_LOCKED,'||chr(10)||
'     p_failed_access_attempts => 0, '||chr(10)||
'     p_change_password_on_first_use => :P23_CHANGE_PWD_ON_FIRST_USE,        '||chr(10)||
'     p_first_password_use_occurred  => :P23_FIRST_PWD_USE_OCCURRED);'||chr(10)||
'--'||chr(10)||
'-- Developer and Admin roles'||chr(10)||
'--'||chr(10)||
'if :P23_ADMIN = ''N'' and';

p:=p||' :P23_DEVELOPER = ''N'' then'||chr(10)||
'  delete from wwv_flow_developers where user_id = :F4050_P23_USER_ID;'||chr(10)||
'elsif :P23_ADMIN = ''Y'' then'||chr(10)||
'  wwv_flow_admin_api.edit_developer_role('||chr(10)||
'    p_id => 1,'||chr(10)||
'    p_user_id => :F4050_P23_USER_ID,'||chr(10)||
'    p_security_group_id => :F4050_P23_SECURITY_GROUP_ID,'||chr(10)||
'    p_user_name => :F4050_P23_USER_NAME,'||chr(10)||
'    p_developer_roles => ''ADMIN:CREATE:DATA_LOADER:EDIT:HELP:MONITOR:SQL'');'||chr(10)||
'else'||chr(10)||
'  ';

p:=p||'wwv_flow_admin_api.edit_developer_role('||chr(10)||
'    p_id => 1,'||chr(10)||
'    p_user_id => :F4050_P23_USER_ID,'||chr(10)||
'    p_security_group_id => :F4050_P23_SECURITY_GROUP_ID,'||chr(10)||
'    p_user_name => :F4050_P23_USER_NAME,'||chr(10)||
'    p_developer_roles => ''CREATE:DATA_LOADER:EDIT:HELP:MONITOR:SQL'');'||chr(10)||
'end if;'||chr(10)||
''||chr(10)||
'commit;'||chr(10)||
'end;';

wwv_flow_api.create_page_process(
  p_id     => 43038214859866258.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 23.4053,
  p_process_sequence=> 30,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'edit user',
  p_process_sql_clob => p, 
  p_process_error_message=> 'Fehler beim Aktualisieren von Benutzer.',
  p_process_when_button_id=>43033257856866238.4053 + wwv_flow_api.g_id_offset,
  p_process_success_message=> 'Benutzer &F4050_P23_USER_NAME. wurde aktualisiert.',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'declare'||chr(10)||
'  l_user_id number := wwv_flow_id.next_val;'||chr(10)||
'  l_p varchar2(256) := v(''F4050_P23_WEB_PASSWORD'');'||chr(10)||
'begin'||chr(10)||
'wwv_flow.update_cache_with_write(''F4050_P23_WEB_PASSWORD'',null);'||chr(10)||
'wwv_flow_admin_api.create_user (    '||chr(10)||
'    p_user_id                      => l_user_id,'||chr(10)||
'    p_security_group_id            => :F4050_P23_SECURITY_GROUP_ID,'||chr(10)||
'    p_user_name                    => :F4050_P23_USER_NAME,'||chr(10)||
'    p_first';

p:=p||'_name                   => :F4050_P23_FIRST_NAME,'||chr(10)||
'    p_last_name                    => :F4050_P23_LAST_NAME,'||chr(10)||
'    p_description                  => :F4050_P23_DESCRIPTION,'||chr(10)||
'    p_email_address                => :F4050_P23_EMAIL_ADDRESS,'||chr(10)||
'    p_default_schema               => :F4050_P23_DEFAULT_SCHEMA,  '||chr(10)||
'    p_web_password                 => l_p,    '||chr(10)||
'    p_group_ids                    => :F4050_P23_G';

p:=p||'ROUPS,'||chr(10)||
'    p_developer_privs              => :F4050_P23_DEV_PRIVS,'||chr(10)||
'    p_account_expiry               => :P23_ACCOUNT_EXPIRY,              '||chr(10)||
'    p_account_locked               => :P23_ACCOUNT_LOCKED,              '||chr(10)||
'    p_failed_access_attempts       => :P23_FAILED_ACCESS_ATTEMPTS,      '||chr(10)||
'    p_change_password_on_first_use => :P23_CHANGE_PWD_ON_FIRST_USE,'||chr(10)||
'    p_first_password_use_occurred  => :P23_FIR';

p:=p||'ST_PWD_USE_OCCURRED'||chr(10)||
'    );'||chr(10)||
'--'||chr(10)||
'-- Developer and Admin roles'||chr(10)||
'--'||chr(10)||
'if :P23_ADMIN = ''N'' and :P23_DEVELOPER = ''N'' then'||chr(10)||
'  null;'||chr(10)||
'elsif :P23_ADMIN = ''Y'' then'||chr(10)||
'  wwv_flow_admin_api.edit_developer_role('||chr(10)||
'    p_id => 1,'||chr(10)||
'    p_user_id => l_user_id,'||chr(10)||
'    p_security_group_id => :F4050_P23_SECURITY_GROUP_ID,'||chr(10)||
'    p_user_name => :F4050_P23_USER_NAME,'||chr(10)||
'    p_developer_roles => ''ADMIN:CREATE:DATA_LOADER:EDIT:HELP:MONITOR:';

p:=p||'SQL'');'||chr(10)||
'else'||chr(10)||
'  wwv_flow_admin_api.edit_developer_role('||chr(10)||
'    p_id => 1,'||chr(10)||
'    p_user_id => l_user_id,'||chr(10)||
'    p_security_group_id => :F4050_P23_SECURITY_GROUP_ID,'||chr(10)||
'    p_user_name => :F4050_P23_USER_NAME,'||chr(10)||
'    p_developer_roles => ''CREATE:DATA_LOADER:EDIT:HELP:MONITOR:SQL'');'||chr(10)||
'end if;'||chr(10)||
'end;'||chr(10)||
'commit;';

wwv_flow_api.create_page_process(
  p_id     => 190972529902954165.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 23.4053,
  p_process_sequence=> 40,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'create user',
  p_process_sql_clob => p, 
  p_process_error_message=> 'Fehler beim Erstellen von Benutzer.',
  p_process_when=>'CREATE,CREATE_ANOTHER',
  p_process_when_type=>'REQUEST_IN_CONDITION',
  p_process_success_message=> 'Benutzer &F4050_P23_USER_NAME. wurde erstellt.',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'23';

wwv_flow_api.create_page_process(
  p_id     => 359753732687409302.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 23.4053,
  p_process_sequence=> 60,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'CLEAR_CACHE_FOR_PAGES',
  p_process_name=> 'clear',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_when=>'CREATE,CREATE_ANOTHER,Apply_Changes',
  p_process_when_type=>'REQUEST_IN_CONDITION',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 23.4053
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_24.40
prompt  ...PAGE 24.4053: Anmeldeversuche
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEADM/adm_activity.htm';

ph := null;
wwv_flow_api.create_page(
  p_id     => 24.4053,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'Anmeldeversuche',
  p_step_title=> 'Anmeldeversuche',
  p_step_sub_title => 'Login Access Log',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'NO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 216662902659587159+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => '',
  p_step_template => 12930201930057128.4053+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409160253',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>24.4053,p_text=>h);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'declare'||chr(10)||
'  q varchar2(32767) := null;'||chr(10)||
'begin'||chr(10)||
'  q := ''select login_name,'';'||chr(10)||
'  q := q||'' application,'';'||chr(10)||
'  q := q||'' owner,'';'||chr(10)||
'  q := q||'' decode(authentication_method,''''FND_ACCOUNT'''',v(''''PRODUCT_NAME''''),'||chr(10)||
'  ''''CUSTOM'''',wwv_flow_lang.system_message(''''CUSTOM_AUTH_SCHEME_DESC''''),'||chr(10)||
'  ''''$SITE_INTERNAL$'''',wwv_flow_lang.system_message(''''SERVICE_LOGIN''''),'||chr(10)||
'  ''''$WORKSPACE_INTERNAL$'''',wwv_flow_lang.system_message(''''W';

s:=s||'ORKSPACE_LOGIN''''),'||chr(10)||
'  ''''DB ACCOUNT'''',wwv_flow_lang.system_message(''''DBACCOUNT_AUTH_SCHEME_DESC''''),'||chr(10)||
'  ''''LDAP'''',wwv_flow_lang.system_message(''''LDAP_AUTH_SCHEME_DESC''''),'||chr(10)||
'   authentication_method) authentication_method,'';'||chr(10)||
'  q := q||'' access_date,'';'||chr(10)||
'  q := q||'' access_date access_time,'';'||chr(10)||
'  q := q||'' decode(nvl(authentication_result,0),'||chr(10)||
'0,wwv_flow_lang.system_message(''''AUTH_SUCCESS''''),'||chr(10)||
'1,wwv_flow_lang.sy';

s:=s||'stem_message(''''AUTH_UNKNOWN_USER''''),'||chr(10)||
'2,wwv_flow_lang.system_message(''''AUTH_ACCOUNT_LOCKED''''),'||chr(10)||
'3,wwv_flow_lang.system_message(''''AUTH_ACCOUNT_EXPIRED''''),'||chr(10)||
'4,wwv_flow_lang.system_message(''''AUTH_PASSWORD_INCORRECT''''),'||chr(10)||
'5,wwv_flow_lang.system_message(''''AUTH_PASSWORD_FIRST_USE''''),'||chr(10)||
'6,wwv_flow_lang.system_message(''''AUTH_ATTEMPTS_EXCEEDED''''),'||chr(10)||
'7,wwv_flow_lang.system_message(''''AUTH_INTERNAL_ERROR''''),'||chr(10)||
'8,wwv_flo';

s:=s||'w_lang.system_message(''''AUTH_UNKNOWN_WORKSPACE''''),'||chr(10)||
'authentication_result) authentication_result'||chr(10)||
','';'||chr(10)||
'  q := q||'' custom_status_text,'';'||chr(10)||
'  q := q||'' wwv_flow_security.find_company_name(security_group_id) workspace'';'||chr(10)||
'  q := q||'' from   wwv_flow_user_access_log_v'';'||chr(10)||
''||chr(10)||
'  if :P24_COMPANY is not null and :P24_COMPANY != ''0'' then'||chr(10)||
'    q := q||'' where  security_group_id = ''||:P24_COMPANY;'||chr(10)||
'  else'||chr(10)||
'    q := q||'' ';

s:=s||'where 1 = 1 '';'||chr(10)||
'  end if;'||chr(10)||
' if :P24_APPLICATION is not null then'||chr(10)||
'    q := q||'' and application like ''''%''''||:P24_APPLICATION||''''%'''''';'||chr(10)||
'  end if;'||chr(10)||
' if :P24_USER is not null then'||chr(10)||
'    q := q||'' and lower(login_name) like ''''%''''||lower(:P24_USER)||''''%'''''';'||chr(10)||
'  end if;'||chr(10)||
''||chr(10)||
'  return q;'||chr(10)||
'end;';

wwv_flow_api.create_report_region (
  p_id=> 12732211904664458.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 24.4053,
  p_name=> 'Logins',
  p_region_name=>'',
  p_template=> 0+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 10,
  p_display_column=> 1,
  p_display_point=> 'AFTER_SHOW_ITEMS',
  p_source=> s,
  p_source_type=> 'FUNCTION_RETURNING_SQL_QUERY',
  p_display_error_message=> 'Unable to render report. #SQLERRM#',
  p_plug_caching=> 'NOT_CACHED',
  p_customized=> '0',
  p_ajax_enabled=> 'N',
  p_query_row_template=> 6897002870390711.4053+ wwv_flow_api.g_id_offset,
  p_query_headings_type=> 'COLON_DELMITED_LIST',
  p_query_num_rows=> '15',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_break_cols=> '0',
  p_query_num_rows_item=> 'P24_ROWS',
  p_query_num_rows_type=> 'NEXT_PREVIOUS_LINKS',
  p_query_row_count_max=> '5000',
  p_pagination_display_position=> 'BOTTOM_RIGHT',
  p_csv_output=> 'Y',
  p_csv_output_link_text=> 'Herunterladen',
  p_prn_output=> 'Y',
  p_prn_format=> 'PDF',
  p_prn_output_show_link=> 'Y',
  p_prn_output_link_text=> 'Drucken',
  p_prn_units=> 'INCHES',
  p_prn_paper_size=> 'LETTER',
  p_prn_width=> 11,
  p_prn_height=> 8.5,
  p_prn_orientation=> 'HORIZONTAL',
  p_prn_page_header=> '&PRODUCT_NAME.',
  p_prn_page_header_font_color=> '#000000',
  p_prn_page_header_font_family=> 'Helvetica',
  p_prn_page_header_font_weight=> 'normal',
  p_prn_page_header_font_size=> '12',
  p_prn_page_footer_font_color=> '#000000',
  p_prn_page_footer_font_family=> 'Helvetica',
  p_prn_page_footer_font_weight=> 'normal',
  p_prn_page_footer_font_size=> '12',
  p_prn_header_bg_color=> '#9bafde',
  p_prn_header_font_color=> '#ffffff',
  p_prn_header_font_family=> 'Helvetica',
  p_prn_header_font_weight=> 'normal',
  p_prn_header_font_size=> '10',
  p_prn_body_bg_color=> '#efefef',
  p_prn_body_font_color=> '#000000',
  p_prn_body_font_family=> 'Helvetica',
  p_prn_body_font_weight=> 'normal',
  p_prn_body_font_size=> '10',
  p_prn_border_width=> .5,
  p_query_asc_image=> 'arrow_down_gray_dark.gif',
  p_query_asc_image_attr=> 'width="13" height="12"',
  p_query_desc_image=> 'arrow_up_gray_dark.gif',
  p_query_desc_image_attr=> 'width="13" height="12"',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'generated 19-APR-2001 17:42:20');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 12740121331793087.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 12732211904664458.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'LOGIN_NAME',
  p_column_display_sequence=> 1,
  p_column_heading=> 'Anmeldename',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_print_col_width=> '11',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 12740302850793087.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 12732211904664458.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'APPLICATION',
  p_column_display_sequence=> 3,
  p_column_heading=> 'Anwendung',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_include_in_export=> 'Y',
  p_print_col_width=> '11',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 12740427964793087.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 12732211904664458.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 3,
  p_form_element_id=> null,
  p_column_alias=> 'OWNER',
  p_column_display_sequence=> 4,
  p_column_heading=> 'Eigentümer',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_print_col_width=> '11',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 12740223417793087.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 12732211904664458.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 4,
  p_form_element_id=> null,
  p_column_alias=> 'AUTHENTICATION_METHOD',
  p_column_display_sequence=> 6,
  p_column_heading=> 'Authentifizierungsmethode',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_include_in_export=> 'Y',
  p_print_col_width=> '11',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 12740527623793087.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 12732211904664458.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 5,
  p_form_element_id=> null,
  p_column_alias=> 'ACCESS_DATE',
  p_column_display_sequence=> 7,
  p_column_heading=> 'Datum',
  p_column_format=> '&DATE_TIME_FORMAT.',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_print_col_width=> '11',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 49028319172363424.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 12732211904664458.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 6,
  p_form_element_id=> null,
  p_column_alias=> 'ACCESS_TIME',
  p_column_display_sequence=> 8,
  p_column_heading=> 'Uhrzeit',
  p_column_format=> 'SINCE',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'RIGHT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_print_col_width=> '11',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 12740820924793088.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 12732211904664458.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 7,
  p_form_element_id=> null,
  p_column_alias=> 'AUTHENTICATION_RESULT',
  p_column_display_sequence=> 5,
  p_column_heading=> 'Authentifizierungsergebnis',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_include_in_export=> 'Y',
  p_print_col_width=> '11',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 12740903748793088.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 12732211904664458.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 8,
  p_form_element_id=> null,
  p_column_alias=> 'CUSTOM_STATUS_TEXT',
  p_column_display_sequence=> 9,
  p_column_heading=> 'Benutzerdefinierter<br />Status',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_print_col_width=> '11',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 12743232469900392.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 12732211904664458.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 9,
  p_form_element_id=> null,
  p_column_alias=> 'WORKSPACE',
  p_column_display_sequence=> 2,
  p_column_heading=> 'Workspace',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_print_col_width=> '11',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 12733116132664460.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 24.4053,
  p_plug_name=> 'Button Bar',
  p_region_name=>'',
  p_plug_template=> 107311831567346457.4053+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'In diesem Bericht werden die zuletzt ausgeführten Anmeldungen bei Workspaces und Anwendungen angezeigt. Alle Anmeldungen beim &PRODUCT_NAME.-Service, Entwickleranmeldungen bei Workspaces und Endbenutzeranmeldungen bei Anwendungen, welche die &PRODUCT_NAME.-Anmeldungs-API im Authentifizierungsschema verwenden, werden protokolliert.';

wwv_flow_api.create_page_plug (
  p_id=> 12733303372664460.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 24.4053,
  p_plug_name=> 'Anmeldeversuche',
  p_region_name=>'',
  p_plug_template=> 79623830123907946.4053+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 20,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_03',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 12733513865664460.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 24.4053,
  p_plug_name=> 'Login Access Log',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(4585800473139662 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 4589126493175495.4053+ wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>13265308543834693.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 24.4053,
  p_branch_action=> 'f?p=&APP_ID.:24:&SESSION.::&DEBUG.:RP::',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_when_button_id=>12734905755664462.4053+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Created 28-NOV-2006 01:38 by SSPADAFO');
 
wwv_flow_api.create_page_branch(
  p_id=>12735921894664463.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 24.4053,
  p_branch_action=> '24',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'BRANCH_TO_STEP',
  p_branch_sequence=> 99,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Um nach Workspace zu filtern, wählen Sie einen Workspace und klicken anschließend auf <b>Los</b>. Um Ergebnisse aus allen Workspaces zurückzugeben, wählen Sie <b>Alle Workspaces anzeigen</b>.';

wwv_flow_api.create_page_item(
  p_id=>12734417988664461.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 24.4053,
  p_name=>'P24_COMPANY',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 12733116132664460.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Workspace',
  p_source_type=> 'STATIC',
  p_display_as=> 'POPUP_KEY_LOV',
  p_named_lov=> 'LIST_ALL_COMPANIES',
  p_lov => 'select ''- ''||'||chr(10)||
'wwv_flow_lang.system_message(''F4050_SHOW_ALL_WORKSPACES'')||'||chr(10)||
''' -'' d, 0 r from dual union all'||chr(10)||
'select short_name||'' (''||PROVISIONING_COMPANY_ID||'')'' d,'||chr(10)||
'       PROVISIONING_COMPANY_ID r'||chr(10)||
'from   WWV_FLOW_COMPANIES'||chr(10)||
'where  provisioning_company_id > 0'||chr(10)||
'order by 1',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 343399818250317904.4053+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>12734905755664462.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 24.4053,
  p_name=>'P24_GO',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 20,
  p_item_plug_id => 12733116132664460.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default => 'GO',
  p_prompt=>'Los',
  p_source=>'GO',
  p_source_type=> 'STATIC',
  p_display_as=> 'BUTTON',
  p_lov_columns=> null,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> 2000,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'LEFT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Wählen Sie die Anzahl der Zeilen, die angezeigt werden sollen, und klicken Sie anschließend auf <b>Los</b>.';

wwv_flow_api.create_page_item(
  p_id=>12735103841664462.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 24.4053,
  p_name=>'P24_ROWS',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 15,
  p_item_plug_id => 12733116132664460.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default => '15',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Anzeigen',
  p_source_type=> 'STATIC',
  p_display_as=> 'COMBOBOX',
  p_named_lov=> 'MAX_ROWS_D',
  p_lov => '.'||to_char(87730331399250507 + wwv_flow_api.g_id_offset)||'.',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 343399818250317904.4053+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Um nach Anwendung zu filtern, geben Sie eine Anwendungs-ID ein und klicken anschließend auf <b>Los</b>.';

wwv_flow_api.create_page_item(
  p_id=>13259223322630763.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 24.4053,
  p_name=>'P24_APPLICATION',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 12,
  p_item_plug_id => 12733116132664460.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Anwendung',
  p_source_type=> 'STATIC',
  p_display_as=> 'TEXT',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 5,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 343399818250317904.4053+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Um nach Anmeldename zu filtern, geben Sie einen Anmeldenamen ein und klicken anschließend auf <b>Los</b>.';

wwv_flow_api.create_page_item(
  p_id=>13263107439654575.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 24.4053,
  p_name=>'P24_USER',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 13,
  p_item_plug_id => 12733116132664460.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Anmeldename',
  p_source_type=> 'STATIC',
  p_display_as=> 'TEXT',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 5,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 343399818250317904.4053+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'reset_pagination';

wwv_flow_api.create_page_process(
  p_id     => 12735624079664462.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 24.4053,
  p_process_sequence=> 10,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'RESET_PAGINATION',
  p_process_name=> 'reset pg',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_when=>'GO',
  p_process_when_type=>'REQUEST_EQUALS_CONDITION',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 24.4053
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_25.40
prompt  ...PAGE 25.4053: Zuletzt verwendeter Workspace
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEADM/adm_activity.htm';

ph := null;
wwv_flow_api.create_page(
  p_id     => 25.4053,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'Zuletzt verwendeter Workspace',
  p_step_title=> 'Zuletzt verwendeter Workspace',
  p_step_sub_title => 'Workspace Usage',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'AUTO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_help_text => ' ',
  p_html_page_header => '',
  p_step_template => '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409160253',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>25.4053,p_text=>h);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'select'||chr(10)||
'    short_name,'||chr(10)||
'    last_login,'||chr(10)||
'    LAST_LOGIN since'||chr(10)||
'from   WWV_FLOW_COMPANIES c '||chr(10)||
'where short_name <> ''Unknown'' and'||chr(10)||
'(:P25_WS is null or instr(upper(short_name),upper(:P25_WS))>0)';

wwv_flow_api.create_report_region (
  p_id=> 98185303352171218.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 25.4053,
  p_name=> 'Workspace Usage',
  p_region_name=>'',
  p_template=> 0+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 10,
  p_display_column=> 1,
  p_display_point=> 'AFTER_SHOW_ITEMS',
  p_source=> s,
  p_source_type=> 'SQL_QUERY',
  p_display_error_message=> '#SQLERRM#',
  p_plug_caching=> 'NOT_CACHED',
  p_customized=> '0',
  p_query_row_template=> 6897002870390711.4053+ wwv_flow_api.g_id_offset,
  p_query_headings_type=> 'COLON_DELMITED_LIST',
  p_query_num_rows=> '15',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_break_cols=> '0',
  p_query_no_data_found=> 'Keine Daten gefunden.',
  p_query_num_rows_item=> 'P25_DISPLAY',
  p_query_num_rows_type=> 'NEXT_PREVIOUS_LINKS',
  p_query_row_count_max=> '50000',
  p_pagination_display_position=> 'BOTTOM_RIGHT',
  p_csv_output=> 'Y',
  p_csv_output_link_text=> 'Herunterladen',
  p_prn_output=> 'Y',
  p_prn_format=> 'PDF',
  p_prn_output_show_link=> 'Y',
  p_prn_output_link_text=> 'Drucken',
  p_prn_units=> 'INCHES',
  p_prn_paper_size=> 'LETTER',
  p_prn_width=> 11,
  p_prn_height=> 8.5,
  p_prn_orientation=> 'HORIZONTAL',
  p_prn_page_header=> '&PRODUCT_NAME.',
  p_prn_page_header_font_color=> '#000000',
  p_prn_page_header_font_family=> 'Helvetica',
  p_prn_page_header_font_weight=> 'normal',
  p_prn_page_header_font_size=> '12',
  p_prn_page_footer_font_color=> '#000000',
  p_prn_page_footer_font_family=> 'Helvetica',
  p_prn_page_footer_font_weight=> 'normal',
  p_prn_page_footer_font_size=> '12',
  p_prn_header_bg_color=> '#9bafde',
  p_prn_header_font_color=> '#ffffff',
  p_prn_header_font_family=> 'Helvetica',
  p_prn_header_font_weight=> 'normal',
  p_prn_header_font_size=> '10',
  p_prn_body_bg_color=> '#efefef',
  p_prn_body_font_color=> '#000000',
  p_prn_body_font_family=> 'Helvetica',
  p_prn_body_font_weight=> 'normal',
  p_prn_body_font_size=> '10',
  p_prn_border_width=> .5,
  p_query_asc_image=> 'arrow_down_gray_dark.gif',
  p_query_asc_image_attr=> 'width="13" height="12"',
  p_query_desc_image=> 'arrow_up_gray_dark.gif',
  p_query_desc_image_attr=> 'width="13" height="12"',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 98185622875171220.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 98185303352171218.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'SHORT_NAME',
  p_column_display_sequence=> 1,
  p_column_heading=> 'Workspace',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>1,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_include_in_export=> 'Y',
  p_print_col_width=> '40',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 98185723504171220.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 98185303352171218.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'LAST_LOGIN',
  p_column_display_sequence=> 2,
  p_column_heading=> 'Letzte Session gelöscht',
  p_column_format=> '&DATE_FORMAT.',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_print_col_width=> '30',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 98194523077209522.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 98185303352171218.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 3,
  p_form_element_id=> null,
  p_column_alias=> 'SINCE',
  p_column_display_sequence=> 3,
  p_column_heading=> 'Datum',
  p_column_format=> 'SINCE',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_print_col_width=> '30',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 98196718968236724.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 25.4053,
  p_plug_name=> 'Breadcrumb',
  p_region_name=>'',
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(4585800473139662 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 4589126493175495.4053+ wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 108281618782868953.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 25.4053,
  p_plug_name=> 'Button Bar',
  p_region_name=>'',
  p_plug_template=> 107311831567346457.4053+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>98190327061192901.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 25.4053,
  p_branch_action=> 'f?p=&FLOW_ID.:25:&SESSION.',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_sequence=> 99,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Wählen Sie die Anzahl der Zeilen, die angezeigt werden sollen, und klicken Sie anschließend auf <b>Los</b>.';

wwv_flow_api.create_page_item(
  p_id=>98188419006189456.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 25.4053,
  p_name=>'P25_DISPLAY',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 108281618782868953.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default => '15',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Anzeigen',
  p_source_type=> 'STATIC',
  p_display_as=> 'COMBOBOX',
  p_named_lov=> 'MAX_ROWS_D',
  p_lov => '.'||to_char(87730331399250507 + wwv_flow_api.g_id_offset)||'.',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 343399818250317904.4053+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>98190130780192898.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 25.4053,
  p_name=>'P25_GO',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 20,
  p_item_plug_id => 108281618782868953.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default => 'Go',
  p_prompt=>'Los',
  p_source=>'Go',
  p_source_type=> 'STATIC',
  p_display_as=> 'BUTTON',
  p_lov_columns=> null,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> 2000,
  p_cHeight=> null,
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'LEFT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Geben Sie Abfragekriterien ein, bei denen die Schreibweise ignoriert wird, und klicken Sie auf <b>Los</b>.';

wwv_flow_api.create_page_item(
  p_id=>138300821896262474.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 25.4053,
  p_name=>'P25_WS',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 1,
  p_item_plug_id => 108281618782868953.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Workspace',
  p_source_type=> 'STATIC',
  p_display_as=> 'TEXT',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 40,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_cattributes_element=>'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 343399818250317904.4053+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'reset_pagination';

wwv_flow_api.create_page_process(
  p_id     => 98191003899194539.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 25.4053,
  p_process_sequence=> 10,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'RESET_PAGINATION',
  p_process_name=> 'Reset Pagination',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_when_button_id=>98190130780192898.4053 + wwv_flow_api.g_id_offset,
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 25.4053
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_26.40
prompt  ...PAGE 26.4053: Workspace Requests
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEADM/adm_ser_rqst.htm';

ph := null;
wwv_flow_api.create_page(
  p_id     => 26.4053,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'Workspace Requests',
  p_step_title=> 'Workspace Requests',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'AUTO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 216766430018595041+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => '',
  p_step_template => 12930201930057128.4053+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409160253',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>26.4053,p_text=>h);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 4600315504229141.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 26.4053,
  p_plug_name=> 'Menu',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(4585800473139662 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 4589126493175495.4053+ wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 25375627955410651.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 26.4053,
  p_plug_name=> 'Button Bar',
  p_region_name=>'',
  p_plug_template=> 107311831567346457.4053+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'declare'||chr(10)||
'   q varchar2(5000) := null;'||chr(10)||
''||chr(10)||
'   l_provision varchar2(200);'||chr(10)||
'   l_adjust    varchar2(200);'||chr(10)||
'begin'||chr(10)||
''||chr(10)||
'select wwv_flow_lang.system_message(''F4050.PROVISION'')'||chr(10)||
'  into l_provision'||chr(10)||
'  from dual;'||chr(10)||
''||chr(10)||
'select wwv_flow_lang.system_message(''F4050.ADJUST'')'||chr(10)||
'  into l_adjust'||chr(10)||
'  from dual;'||chr(10)||
''||chr(10)||
''||chr(10)||
'q := ''select '||chr(10)||
'    htf.anchor(''''f?p=4050:6:''''||:flow_session||''''::NO::F4050_P6_ID:''''||'||chr(10)||
'        id ,''''<img src="#IMAGE_PREFIX#';

s:=s||'e2.gif" alt="&EDIT." border="0" />'''') edit_me,'||chr(10)||
'    COMPANY_NAME,'||chr(10)||
'    schema_name,'||chr(10)||
'    lower(ADMIN_userid),'||chr(10)||
'    ''''<a href="mailto:''''||admin_email||''''">''''||htf.escape_sc(admin_email)||''''</a>'''' admin_email,'||chr(10)||
'    DATABASE_SIZE,'||chr(10)||
'    country,'||chr(10)||
'    request_date,'||chr(10)||
'    project_status,'||chr(10)||
'    decode(project_status,''''REQUESTED'''','||chr(10)||
'      htf.anchor(''''f?p=4050:4:''''||:flow_session||''''::NO::PROVISION_ID:''''||id,''''''||l_p';

s:=s||'rovision||''''''),'||chr(10)||
'      ''''APPROVED'''','||chr(10)||
'      htf.anchor(''''f?p=4050:7:''''||:flow_session||''''::NO::T_PROVISION_ID:''''||id,''''''||l_adjust||''''''),'||chr(10)||
'      ''''ACCEPTED'''','||chr(10)||
'      htf.anchor(''''f?p=4050:7:''''||:flow_session||''''::NO::T_PROVISION_ID:''''||id,''''''||l_adjust||''''''),'||chr(10)||
'      htf.anchor(''''f?p=4050:7:''''||:flow_session||''''::NO::T_PROVISION_ID:''''||id,''''''||l_adjust||'''''')'||chr(10)||
'     ) action'||chr(10)||
'from WWV_FLOW_PROVISION_COMPANY';

s:=s||' '';'||chr(10)||
''||chr(10)||
'if :F4050_P26_STATUS is not null and :F4050_P26_STATUS != ''0'' then'||chr(10)||
'   q := q||'' where project_status = :F4050_P26_STATUS '';'||chr(10)||
'end if;'||chr(10)||
''||chr(10)||
'if :P26_SEARCH is not null then'||chr(10)||
'      if :F4050_P26_STATUS is not null and :F4050_P26_STATUS != ''0'' then'||chr(10)||
'          q := q || '' and '';'||chr(10)||
'      else'||chr(10)||
'          q := q || '' where '';'||chr(10)||
'      end if;'||chr(10)||
'      q := q || '' upper(company_name) like ''''%''''||upper(:P26_SEARCH)||''''';

s:=s||'%'''' '';'||chr(10)||
'end if;'||chr(10)||
''||chr(10)||
'return q;'||chr(10)||
'end;';

wwv_flow_api.create_report_region (
  p_id=> 50768516306471803.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 26.4053,
  p_name=> 'Workspace Requests',
  p_region_name=>'',
  p_template=> 0+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 10,
  p_display_column=> 1,
  p_display_point=> 'AFTER_SHOW_ITEMS',
  p_source=> s,
  p_source_type=> 'FUNCTION_RETURNING_SQL_QUERY',
  p_display_error_message=> 'Unable to show report. #SQLERRM#',
  p_plug_caching=> 'NOT_CACHED',
  p_customized=> '0',
  p_ajax_enabled=> 'N',
  p_query_row_template=> 6897002870390711.4053+ wwv_flow_api.g_id_offset,
  p_plug_query_max_columns=> 12,
  p_query_headings_type=> 'COLON_DELMITED_LIST',
  p_query_num_rows=> '25',
  p_query_options=> 'GENERIC_REPORT_COLUMNS',
  p_query_show_nulls_as=> '-',
  p_query_break_cols=> '0',
  p_query_no_data_found=> 'Keine Daten gefunden.',
  p_query_num_rows_item=> 'F4050_P26_ROWS',
  p_query_num_rows_type=> 'ROW_RANGES_WITH_LINKS',
  p_query_row_count_max=> '5000',
  p_pagination_display_position=> 'BOTTOM_RIGHT',
  p_csv_output=> 'N',
  p_query_asc_image=> 'arrow_down_gray_dark.gif',
  p_query_asc_image_attr=> 'width="13" height="12"',
  p_query_desc_image=> 'arrow_up_gray_dark.gif',
  p_query_desc_image_attr=> 'width="13" height="12"',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48488413392770349.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 50768516306471803.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'COL01',
  p_column_display_sequence=> 1,
  p_column_heading=> '&nbsp;',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48488526197770349.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 50768516306471803.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'COL02',
  p_column_display_sequence=> 2,
  p_column_heading=> 'Workspace',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>1,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48488609984770349.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 50768516306471803.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 3,
  p_form_element_id=> null,
  p_column_alias=> 'COL03',
  p_column_display_sequence=> 3,
  p_column_heading=> 'Schema',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>2,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48488730465770349.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 50768516306471803.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 4,
  p_form_element_id=> null,
  p_column_alias=> 'COL04',
  p_column_display_sequence=> 4,
  p_column_heading=> 'Benutzer mit Administratorrechten',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48488816498770349.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 50768516306471803.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 5,
  p_form_element_id=> null,
  p_column_alias=> 'COL05',
  p_column_display_sequence=> 5,
  p_column_heading=> 'E-Mail',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48488920740770349.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 50768516306471803.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 6,
  p_form_element_id=> null,
  p_column_alias=> 'COL06',
  p_column_display_sequence=> 6,
  p_column_heading=> 'Datenbankgröße',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48489029515770350.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 50768516306471803.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 7,
  p_form_element_id=> null,
  p_column_alias=> 'COL07',
  p_column_display_sequence=> 7,
  p_column_heading=> 'Country',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48489113472770350.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 50768516306471803.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 8,
  p_form_element_id=> null,
  p_column_alias=> 'COL08',
  p_column_display_sequence=> 8,
  p_column_heading=> 'Angefordert',
  p_column_format=> 'SINCE',
  p_column_css_style=>'white-space: nowrap;',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48489200744770350.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 50768516306471803.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 9,
  p_form_element_id=> null,
  p_column_alias=> 'COL09',
  p_column_display_sequence=> 9,
  p_column_heading=> 'Status',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'TEXT_FROM_LOV',
  p_named_lov=>87755726864223308 + wwv_flow_api.g_id_offset,
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48489327877770350.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 50768516306471803.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 10,
  p_form_element_id=> null,
  p_column_alias=> 'COL10',
  p_column_display_sequence=> 10,
  p_column_heading=> 'Aktion',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48489425157770350.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 50768516306471803.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 11,
  p_form_element_id=> null,
  p_column_alias=> 'COL11',
  p_column_display_sequence=> 11,
  p_column_heading=> 'COL11',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48489507194770350.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 50768516306471803.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 12,
  p_form_element_id=> null,
  p_column_alias=> 'COL12',
  p_column_display_sequence=> 12,
  p_column_heading=> 'COL12',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_column_comment=>'');
end;
/
 
begin
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>51343812293251966.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 26.4053,
  p_branch_action=> '26',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'BRANCH_TO_STEP',
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Created 29-MAR-2001 17:45 by MIKE');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Um den Bericht nach Status zu filtern, wählen Sie ein Element aus der Liste und klicken anschließend auf <b>Los</b> ';

wwv_flow_api.create_page_item(
  p_id=>227233099194.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 26.4053,
  p_name=>'F4050_P26_STATUS',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 25375627955410651.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Status',
  p_source_type=> 'STATIC',
  p_display_as=> 'COMBOBOX',
  p_named_lov=> 'SERVICE.REQUEST.STATUS',
  p_lov => '.'||to_char(87755726864223308 + wwv_flow_api.g_id_offset)||'.',
  p_lov_columns=> 1,
  p_lov_display_null=> 'YES',
  p_lov_translated=> 'N',
  p_lov_null_text=>'- Alles -',
  p_lov_null_value=> '0',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 343399818250317904.4053+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>227237125731.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 26.4053,
  p_name=>'F4050_P26_GO',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 30,
  p_item_plug_id => 25375627955410651.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default => 'GO',
  p_prompt=>'Los',
  p_source=>'GO',
  p_source_type=> 'STATIC',
  p_display_as=> 'BUTTON',
  p_lov_columns=> null,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'LEFT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Wählen Sie die Anzahl der Zeilen, die angezeigt werden sollen, und klicken Sie anschließend auf <b>Los</b>.';

wwv_flow_api.create_page_item(
  p_id=>133654704904602400.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 26.4053,
  p_name=>'F4050_P26_ROWS',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 20,
  p_item_plug_id => 25375627955410651.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default => '20',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Anzeigen',
  p_source_type=> 'STATIC',
  p_display_as=> 'COMBOBOX',
  p_named_lov=> 'MAX_ROWS_C',
  p_lov => '.'||to_char(87727319971247226 + wwv_flow_api.g_id_offset)||'.',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 343399818250317904.4053+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Geben Sie eine Abfrage ein, bei der die Schreibweise ignoriert wird, und klicken Sie auf "Los".';

wwv_flow_api.create_page_item(
  p_id=>135655632650273356.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 26.4053,
  p_name=>'P26_SEARCH',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 3,
  p_item_plug_id => 25375627955410651.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Suche',
  p_source_type=> 'STATIC',
  p_display_as=> 'TEXT',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 5,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 343399818250317904.4053+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'reset_pagination';

wwv_flow_api.create_page_process(
  p_id     => 133663005970617117.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 26.4053,
  p_process_sequence=> 10,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'RESET_PAGINATION',
  p_process_name=> 'reset pg',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_when_button_id=>227237125731.4053 + wwv_flow_api.g_id_offset,
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 26.4053
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_27.40
prompt  ...PAGE 27.4053: Workspace erstellen
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEADM/adm_create_wkspc.htm';

ph := null;
wwv_flow_api.create_page(
  p_id     => 27.4053,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'Workspace erstellen',
  p_step_title=> 'Workspace erstellen',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'AUTO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 216765317551591446+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => '',
  p_step_template => 12930201930057128.4053+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409160253',
  p_page_is_public_y_n=> 'N',
  p_protection_level=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>27.4053,p_text=>h);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 4607802392253720.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 27.4053,
  p_plug_name=> 'Menu',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(4585800473139662 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 4589126493175495.4053+ wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'List:  auto.provision.progress';

wwv_flow_api.create_page_plug (
  p_id=> 12052824814385644.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 27.4053,
  p_plug_name=> 'Navigation',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 20,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_01',
  p_plug_source=> s,
  p_plug_source_type=> 12048115202363924 + wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||':F4050_P79_SCHEMA_PASSWORD := null;';

wwv_flow_api.create_page_plug (
  p_id=> 32847912999571331.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 27.4053,
  p_plug_name=> 'reset',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 30,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_HEADER',
  p_plug_source=> s,
  p_plug_source_type=> 'PLSQL_PROCEDURE',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 51837012095286656.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 27.4053,
  p_plug_name=> '&COMPANY_NAME. erstellen',
  p_region_name=>'',
  p_plug_template=> 2424107150426143.4053+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 10,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 51838114075301402.4053 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 27.4053,
  p_button_sequence=> 10,
  p_button_plug_id => 51837012095286656+wwv_flow_api.g_id_offset,
  p_button_name    => 'Cancel',
  p_button_image_alt=> 'Abbrechen',
  p_button_position=> 'REGION_TEMPLATE_CLOSE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_cattributes=>'class="button10"',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 12005721821568003.4053 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 27.4053,
  p_button_sequence=> 10,
  p_button_plug_id => 51837012095286656+wwv_flow_api.g_id_offset,
  p_button_name    => 'NEXT',
  p_button_image_alt=> 'Weiter &gt;',
  p_button_position=> 'REGION_TEMPLATE_NEXT',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>12006017199568012.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 27.4053,
  p_branch_action=> '79',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'BRANCH_TO_STEP',
  p_branch_when_button_id=>12005721821568003.4053+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
wwv_flow_api.create_page_branch(
  p_id=>56575929733626519.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 27.4053,
  p_branch_action=> '27',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'BRANCH_TO_STEP',
  p_branch_sequence=> 99,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Created 02-APR-2001 14:30 by MIKE');
 
wwv_flow_api.create_page_branch(
  p_id=>51838415724301406.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 27.4053,
  p_branch_action=> '10',
  p_branch_point=> 'BEFORE_COMPUTATION',
  p_branch_type=> 'BRANCH_TO_STEP',
  p_branch_when_button_id=>51838114075301402.4053+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Geben Sie einen Namen für den Workspace ein. Bei einem Workspace handelt es sich um einen gemeinsamen Arbeitsbereich, in dem mehrere Entwickler Anwendungen erstellen können.';

wwv_flow_api.create_page_item(
  p_id=>51839319663316706.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 27.4053,
  p_name=>'F4050_P27_COMPANY',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 51837012095286656.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Workspace-Name',
  p_source_type=> 'STATIC',
  p_display_as=> 'TEXT',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 111844628719872228.4053+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Geben Sie eine Beschreibung für diesen Workspace ein.';

wwv_flow_api.create_page_item(
  p_id=>52809911597500660.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 27.4053,
  p_name=>'F4050_P27_PROJDESC',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 40,
  p_item_plug_id => 51837012095286656.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Beschreibung des Workspace',
  p_source_type=> 'STATIC',
  p_display_as=> 'TEXTAREA',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 50,
  p_cMaxlength=> 2000,
  p_cHeight=> 5,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 3,
  p_rowspan => 1,
  p_label_alignment  => 'ABOVE',
  p_field_alignment  => 'LEFT',
  p_field_template => 111843720754869910.4053+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>102040200715981237.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 27.4053,
  p_name=>'F4050_P27_SECURITY_GROUP_ID',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 15,
  p_item_plug_id => 51837012095286656.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Security Group ID',
  p_source_type=> 'STATIC',
  p_display_as=> 'HIDDEN',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 111843720754869910.4053+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_item_comment => '');
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 175961730770991651.4053 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 27.4053,
  p_validation_name => 'F4050_P27_COMPANY Not Null',
  p_validation_sequence=> 1,
  p_validation => 'F4050_P27_COMPANY',
  p_validation_type => 'ITEM_NOT_NULL',
  p_error_message => 'Der Workspace muss angegeben werden.',
  p_associated_item=> 51839319663316706.4053 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> 'generated 15-FEB-2002 13:56');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 13102508023008244.4053 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 27.4053,
  p_validation_name => 'security group id is numeric',
  p_validation_sequence=> 10,
  p_validation => 'F4050_P27_SECURITY_GROUP_ID',
  p_validation_type => 'ITEM_IS_NUMERIC',
  p_error_message => 'Die Sicherheitsgruppen-ID muss numerisch sein.',
  p_validation_condition=> 'F4050_P27_SECURITY_GROUP_ID',
  p_validation_condition_type=> 'ITEM_IS_NOT_NULL',
  p_associated_item=> 102040200715981237.4053 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 13103125946032313.4053 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 27.4053,
  p_validation_name => 'security group id not exists',
  p_validation_sequence=> 10,
  p_validation => 'select null'||chr(10)||
'  from wwv_flow_companies'||chr(10)||
' where provisioning_company_id = :F4050_P27_SECURITY_GROUP_ID',
  p_validation_type => 'NOT_EXISTS',
  p_error_message => 'Die Sicherheitsgruppen-ID ist bereits vorhanden.',
  p_validation_condition=> 'declare'||chr(10)||
'  l_num number;'||chr(10)||
'begin'||chr(10)||
'  l_num := to_number(nvl(:F4050_P27_SECURITY_GROUP_ID,''1''));'||chr(10)||
'  return true;'||chr(10)||
'exception when others then'||chr(10)||
'  return false;'||chr(10)||
'end;',
  p_validation_condition_type=> 'FUNCTION_BODY',
  p_when_button_pressed=> 12005721821568003.4053 + wwv_flow_api.g_id_offset,
  p_associated_item=> 102040200715981237.4053 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 72385310766234746.4053 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 27.4053,
  p_validation_name => 'reserved company name',
  p_validation_sequence=> 20,
  p_validation => 'nvl(upper(:F4050_P27_COMPANY),''x'') not in (''INTERNAL'',''UNKNOWN'',''CSS'',''JAVASCRIPT'',''THEMES'',''TUTORIAL'',''XML'',''DOC'',''DP'',''TEMPLATES'')',
  p_validation_type => 'PLSQL_EXPRESSION',
  p_error_message => '"Workspace" ist ein reservierter Name. Der Request wurde verweigert.',
  p_associated_item=> 51839319663316706.4053 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 14411726317427900.4053 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 27.4053,
  p_validation_name => 'company already exists or requested',
  p_validation_sequence=> 30,
  p_validation => 'for c1 in (select null'||chr(10)||
'             from wwv_flow_provision_company'||chr(10)||
'            where company_name = upper(:F4050_P27_COMPANY)) loop'||chr(10)||
'  return false;'||chr(10)||
'  exit;'||chr(10)||
'end loop;'||chr(10)||
'for c1 in (select null'||chr(10)||
'             from wwv_flow_companies'||chr(10)||
'            where short_name = upper(:F4050_P27_COMPANY) ) loop'||chr(10)||
'   return false;'||chr(10)||
'   exit;'||chr(10)||
'end loop;'||chr(10)||
''||chr(10)||
'if not nvl(length(trim(:F4050_P27_COMPANY)),0) > 0 then'||chr(10)||
'  return false;'||chr(10)||
'end if;'||chr(10)||
''||chr(10)||
'return true;',
  p_validation_type => 'FUNC_BODY_RETURNING_BOOLEAN',
  p_error_message => 'Der Workspace-Name ist bereits vorhanden',
  p_validation_condition=> 'F4050_P27_COMPANY',
  p_validation_condition_type=> 'ITEM_IS_NOT_NULL',
  p_when_button_pressed=> 12005721821568003.4053 + wwv_flow_api.g_id_offset,
  p_associated_item=> 51839319663316706.4053 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 111441226211952153.4053 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 27.4053,
  p_validation_name => 'Invalid characters in workspace name',
  p_validation_sequence=> 40,
  p_validation => 'F4050_P27_COMPANY',
  p_validation2 => '<>',
  p_validation_type => 'ITEM_IN_VALIDATION_CONTAINS_NO_CHAR_IN_STRING2',
  p_error_message => 'Ungültiger Workspace-Name.',
  p_when_button_pressed=> 12005721821568003.4053 + wwv_flow_api.g_id_offset,
  p_associated_item=> 51839319663316706.4053 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 27.4053
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_28.40
prompt  ...PAGE 28.4053: Änderungsanforderung
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEADM/adm_chg_rqst.htm';

ph := null;
wwv_flow_api.create_page(
  p_id     => 28.4053,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'Änderungsanforderung',
  p_step_title=> 'Änderungsanforderungen',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'AUTO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 216766430018595041+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => '',
  p_step_template => 12930201930057128.4053+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409160253',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>28.4053,p_text=>h);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 4603017713239216.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 28.4053,
  p_plug_name=> 'Menu',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(4585800473139662 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 4589126493175495.4053+ wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'Auf dieser Seite werden Requests für Änderungen bei vorhandenen Services angezeigt. Um einen Request zu überprüfen, klicken Sie auf <b>Request anzeigen</b>. Klicken Sie auf die Aktion für den Workspace, den Sie verarbeiten möchten. Aktionen, die als <b>Keine Aktion</b> angegeben werden, sind abgeschlossen und erfordern somit keine weitere Ausführung.';

wwv_flow_api.create_page_plug (
  p_id=> 59534981464167587.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 28.4053,
  p_plug_name=> 'Änderungsanforderungen',
  p_region_name=>'',
  p_plug_template=> 79623830123907946.4053+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 10,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_03',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 81008210556197147.4053+ wwv_flow_api.g_id_offset,
  p_plug_query_headings => 'blue_arrow_down.gif::blue_arrow_up.gif:|2,3\1,9|'||chr(10)||
''||chr(10)||
'&nbsp;:'||chr(10)||
''||chr(10)||
'<font class="nounderline" color="black">Company</font>:'||chr(10)||
''||chr(10)||
'<font class="nounderline" color="black">Schema</font>:'||chr(10)||
''||chr(10)||
'<font class="nounderline" color="black">AdminUserID</font>:'||chr(10)||
''||chr(10)||
'<font class="nounderline" color="black">Email</font>:'||chr(10)||
''||chr(10)||
'<font class="nounderline" color="black">DBsize</font>:'||chr(10)||
''||chr(10)||
'<font class="nounderline" color="black">Requested</font>:'||chr(10)||
''||chr(10)||
'<font class="nounderline" color="black">Status</font>:'||chr(10)||
''||chr(10)||
'<font class="nounderline" color="black">Action</font>',
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_num_rows => 25,
  p_plug_query_num_rows_type => 'ROWS_X_TO_Y_OF_Z',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_query_no_data_found=>'Keine Daten gefunden.',
  p_plug_query_show_nulls_as => '-',
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'declare'||chr(10)||
'   q varchar2(5000) := null;'||chr(10)||
'begin'||chr(10)||
''||chr(10)||
'/*'||chr(10)||
' * CURRENT TITLE ACCORDING TO THIS SELECT, AS NOTED BELOW IN QUERY HEADINGS FIELD'||chr(10)||
' * Company:Requested&nbsp;Change:Value&nbspfor&nbspChange:Requested:Requested&nbsp;By:Status:Action'||chr(10)||
' */'||chr(10)||
''||chr(10)||
'  q := ''select c.short_name company_name,'||chr(10)||
'         m.service_name requested_change,'||chr(10)||
'         m.service_attribute_1 value,'||chr(10)||
'         m.requested_on requested_on,'||chr(10)||
'      ';

s:=s||'   m.requested_by,'||chr(10)||
'         m.request_status status,'||chr(10)||
'         decode(m.request_status,''''REQUESTED'''','||chr(10)||
'         htf.anchor(''''f?p=4050:110:''||:flow_session||''::NO:110:P110_REQUEST_ID,P110_SGID:''''||m.id||'''',''''||m.security_group_id,''''''||wwv_flow_lang.system_message(''F4050.VIEW_REQUEST'')||''''''),'||chr(10)||
'         ''''APPROVED'''', ''''''||wwv_flow_lang.system_message(''F4050.NO_ACTION'')||'''''','||chr(10)||
'         htf.anchor(''''f?p=40';

s:=s||'50:110:''||:flow_session||''::NO:110,RP:P110_REQUEST_ID,P110_SGID:''''||m.id||'''',''''||m.security_group_id,''''''||wwv_flow_lang.system_message(''F4050.VIEW_REQUEST'')||'''''')) '||chr(10)||
'         action'||chr(10)||
'    from wwv_flow_provision_serice_mod m, wwv_flow_companies c'||chr(10)||
'   where m.security_group_id = c.provisioning_company_id '';'||chr(10)||
''||chr(10)||
'  if :F4050_P28_STATUS is not null and :F4050_P28_STATUS != ''0'' then'||chr(10)||
'     q := q||''   and reque';

s:=s||'st_status = :F4050_P28_STATUS '';'||chr(10)||
'  end if;'||chr(10)||
''||chr(10)||
'    if :P28_SEARCH is not null then'||chr(10)||
'          q := q || '' and upper(short_name) like ''''%''''||upper(:P28_SEARCH)||''''%'''' '';'||chr(10)||
'    end if;'||chr(10)||
''||chr(10)||
'  return q;'||chr(10)||
'end;';

wwv_flow_api.create_report_region (
  p_id=> 59535312500167589.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 28.4053,
  p_name=> 'Service Change Requests',
  p_region_name=>'',
  p_template=> 0+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 10,
  p_display_column=> 1,
  p_display_point=> 'AFTER_SHOW_ITEMS',
  p_source=> s,
  p_source_type=> 'FUNCTION_RETURNING_SQL_QUERY',
  p_display_error_message=> 'Unable to show report. #SQLERRM#',
  p_plug_caching=> 'NOT_CACHED',
  p_customized=> '0',
  p_ajax_enabled=> 'N',
  p_query_row_template=> 6897002870390711.4053+ wwv_flow_api.g_id_offset,
  p_query_headings_type=> 'COLON_DELMITED_LIST',
  p_query_num_rows=> '25',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_show_nulls_as=> '-',
  p_query_break_cols=> '0',
  p_query_no_data_found=> '<font class="fielddata">Keine Daten gefunden.</font>',
  p_query_num_rows_item=> 'P28_ROWS',
  p_query_num_rows_type=> 'ROW_RANGES_WITH_LINKS',
  p_query_row_count_max=> '500',
  p_pagination_display_position=> 'BOTTOM_RIGHT',
  p_csv_output=> 'N',
  p_query_asc_image=> 'arrow_down_gray_dark.gif',
  p_query_asc_image_attr=> 'width="13" height="12"',
  p_query_desc_image=> 'arrow_up_gray_dark.gif',
  p_query_desc_image_attr=> 'width="13" height="12"',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48525928245770622.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 59535312500167589.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'COMPANY_NAME',
  p_column_display_sequence=> 1,
  p_column_heading=> 'Workspace',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>1,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48526011074770622.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 59535312500167589.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'REQUESTED_CHANGE',
  p_column_display_sequence=> 2,
  p_column_heading=> 'Angeforderte Änderung',
  p_column_alignment=>'CENTER',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'TEXT_FROM_LOV',
  p_named_lov=>110368323210290856 + wwv_flow_api.g_id_offset,
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48526119186770622.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 59535312500167589.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 3,
  p_form_element_id=> null,
  p_column_alias=> 'VALUE',
  p_column_display_sequence=> 3,
  p_column_heading=> 'Wert für die Änderung',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48526211732770622.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 59535312500167589.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 4,
  p_form_element_id=> null,
  p_column_alias=> 'REQUESTED_ON',
  p_column_display_sequence=> 4,
  p_column_heading=> 'Angefordert',
  p_column_format=> 'SINCE',
  p_column_css_style=>'white-space: nowrap;',
  p_column_alignment=>'CENTER',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48526303311770622.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 59535312500167589.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 5,
  p_form_element_id=> null,
  p_column_alias=> 'REQUESTED_BY',
  p_column_display_sequence=> 5,
  p_column_heading=> 'Angefordert von',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48526401366770622.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 59535312500167589.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 6,
  p_form_element_id=> null,
  p_column_alias=> 'STATUS',
  p_column_display_sequence=> 6,
  p_column_heading=> 'Status',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'TEXT_FROM_LOV',
  p_named_lov=>87755726864223308 + wwv_flow_api.g_id_offset,
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48526504734770622.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 59535312500167589.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 7,
  p_form_element_id=> null,
  p_column_alias=> 'ACTION',
  p_column_display_sequence=> 7,
  p_column_heading=> 'Aktion',
  p_column_alignment=>'CENTER',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 190884725848636908.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 28.4053,
  p_plug_name=> 'Button Bar',
  p_region_name=>'',
  p_plug_template=> 107311831567346457.4053+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings => 'blue_arrow_down.gif::blue_arrow_up.gif:|3,3,4\1,2|'||chr(10)||
''||chr(10)||
'&nbsp;:'||chr(10)||
''||chr(10)||
'<font class="nounderline" color="black">CompanyShortName</font>:'||chr(10)||
''||chr(10)||
'<font class="nounderline" color="green">Users</font>:'||chr(10)||
''||chr(10)||
'<font class="nounderline" color="green">Developers</font>:'||chr(10)||
''||chr(10)||
'<font class="nounderline" color="green">Flows</font>:<font color=green>ProvStatus</font>:'||chr(10)||
''||chr(10)||
'<font class="nounderline" color="black">CompanyID</font>:',
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_num_rows => 25,
  p_plug_query_num_rows_item => 'F4050_P1_ROWS',
  p_plug_query_num_rows_type => 'ROWS_X_TO_Y_OF_Z',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_query_show_nulls_as => '(null)',
  p_plug_query_col_allignments => 'L:L:L:L:R:R:R:L',
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>59534110308167581.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 28.4053,
  p_branch_action=> '28',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'BRANCH_TO_STEP',
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Created 29-MAR-2001 17:45 by MIKE');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Um den Bericht nach Status zu filtern, wählen Sie ein Element aus der Liste und klicken anschließend auf <b>Los</b> ';

wwv_flow_api.create_page_item(
  p_id=>59534316415167582.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 28.4053,
  p_name=>'F4050_P28_STATUS',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 190884725848636908.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Status',
  p_source_type=> 'STATIC',
  p_display_as=> 'COMBOBOX',
  p_named_lov=> 'SERVICE.REQUEST.STATUS',
  p_lov => '.'||to_char(87755726864223308 + wwv_flow_api.g_id_offset)||'.',
  p_lov_columns=> 1,
  p_lov_display_null=> 'YES',
  p_lov_translated=> 'N',
  p_lov_null_text=>'- Alles -',
  p_lov_null_value=> '0',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 343399818250317904.4053+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>59534516416167583.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 28.4053,
  p_name=>'F4050_P28_GO',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 30,
  p_item_plug_id => 190884725848636908.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default => 'GO',
  p_prompt=>'Los',
  p_source=>'GO',
  p_source_type=> 'STATIC',
  p_display_as=> 'BUTTON',
  p_lov_columns=> null,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'LEFT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Geben Sie eine Abfrage ein, bei der die Schreibweise ignoriert wird, und klicken Sie auf "Los".';

wwv_flow_api.create_page_item(
  p_id=>135738826107574190.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 28.4053,
  p_name=>'P28_SEARCH',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 3,
  p_item_plug_id => 190884725848636908.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Suche',
  p_source_type=> 'STATIC',
  p_display_as=> 'TEXT',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 5,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 343399818250317904.4053+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Wählen Sie die Anzahl von anzuzeigenden Zeilen, und klicken Sie auf "Los".';

wwv_flow_api.create_page_item(
  p_id=>135986716551006681.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 28.4053,
  p_name=>'P28_ROWS',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 25,
  p_item_plug_id => 190884725848636908.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default => '20',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Anzeigen',
  p_source_type=> 'STATIC',
  p_display_as=> 'COMBOBOX',
  p_named_lov=> 'MAX_ROWS_C',
  p_lov => '.'||to_char(87727319971247226 + wwv_flow_api.g_id_offset)||'.',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 5,
  p_cAttributes=> 'nowrap',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 343399818250317904.4053+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'reset_pagination';

wwv_flow_api.create_page_process(
  p_id     => 108330122937220232.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 28.4053,
  p_process_sequence=> 20,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'RESET_PAGINATION',
  p_process_name=> 'Reset Pagination',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_when_button_id=>59534516416167583.4053 + wwv_flow_api.g_id_offset,
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 28.4053
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_29.40
prompt  ...PAGE 29.4053: Aktivität überwachen
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEADM/adm_activity.htm';

ph := null;
wwv_flow_api.create_page(
  p_id     => 29.4053,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'Aktivität überwachen',
  p_step_title=> 'Aktivität überwachen',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'AUTO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 216662902659587159+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => '',
  p_step_template => 12930201930057128.4053+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409160254',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>29.4053,p_text=>h);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 4617524125278866.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 29.4053,
  p_plug_name=> 'Menu',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(4585800473139662 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 4589126493175495.4053+ wwv_flow_api.g_id_offset,
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 14723216460004096.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 29.4053,
  p_plug_name=> 'Kalenderberichte',
  p_region_name=>'',
  p_plug_template=> 75821319588166981.4053+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 20,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_02',
  p_plug_source=> s,
  p_plug_source_type=> 14738731575074699 + wwv_flow_api.g_id_offset,
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_display_condition_type => '',
  p_plug_header=> '<table summary=""><tr><td valign="top"><img src="#IMAGE_PREFIX#menu/calendar_64.gif" width="64" height="64" alt="&PRODUCT_NAME." /></td><td valign="top">',
  p_plug_footer=> '</td></tr></table><p />',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 14755429806121434.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 29.4053,
  p_plug_name=> 'Entwickleraktivität',
  p_region_name=>'',
  p_plug_template=> 75821319588166981.4053+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 3,
  p_plug_display_column=> 2,
  p_plug_display_point=> 'REGION_POSITION_02',
  p_plug_source=> s,
  p_plug_source_type=> 206097723808588940 + wwv_flow_api.g_id_offset,
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_display_condition_type => '',
  p_plug_header=> '<table summary=""><tr><td valign="top"><img src="#IMAGE_PREFIX#menu/flashlight_wbg_64x64.png" border="0" height="64" width="64" alt="&PRODUCT_NAME." /></td><td valign="top">',
  p_plug_footer=> '</td></tr></table>',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'49036204543378170';

wwv_flow_api.create_page_plug (
  p_id=> 49038908699379385.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 29.4053,
  p_plug_name=> 'Anmeldeversuche',
  p_region_name=>'',
  p_plug_template=> 75821319588166981.4053+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 50,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_02',
  p_plug_source=> s,
  p_plug_source_type=> 49036204543378170 + wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_header=> '<table summary=""><tr><td valign="top"><img src="#IMAGE_PREFIX#menu/users_64.gif" width="64" height="64" alt="&PRODUCT_NAME." /></td><td valign="top">',
  p_plug_footer=> '</td></tr></table>',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 82696814914931381.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 29.4053,
  p_plug_name=> 'Seitenansichten',
  p_region_name=>'',
  p_plug_template=> 75821319588166981.4053+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_02',
  p_plug_source=> s,
  p_plug_source_type=> 159973015345793688 + wwv_flow_api.g_id_offset,
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_display_condition_type => '',
  p_plug_header=> '<table summary=""><tr><td valign="top"><img src="#IMAGE_PREFIX#menu/chart_bar_64.gif" width="64" height="64" alt="&PRODUCT_NAME." /></td><td valign="top">',
  p_plug_footer=> '</td></tr></table><p />',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'<p>Mit den Links auf dieser Seite können Sie Berichte zu den Anwendungen, Entwicklern und Sessionaktivitäten für alle Workspaces anzeigen.</p>';

wwv_flow_api.create_page_plug (
  p_id=> 179853623006946463.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 29.4053,
  p_plug_name=> 'Überwachungsberichte',
  p_region_name=>'',
  p_plug_template=> 79623830123907946.4053+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 40,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_03',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 206100700867601271.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 29.4053,
  p_plug_name=> 'Umgebungsberichte',
  p_region_name=>'',
  p_plug_template=> 75821319588166981.4053+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 40,
  p_plug_display_column=> 2,
  p_plug_display_point=> 'REGION_POSITION_02',
  p_plug_source=> s,
  p_plug_source_type=> 14750409028115431 + wwv_flow_api.g_id_offset,
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_display_condition_type => '',
  p_plug_header=> '<table summary=""><tr><td valign="top"><img src="#IMAGE_PREFIX#menu/client_64.gif" border="0" height="64" width="64" alt="&PRODUCT_NAME." /></td><td valign="top">',
  p_plug_footer=> '</td></tr></table>',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
null;
 
end;
/

 
begin
 
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 29.4053
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_30.40
prompt  ...PAGE 30.4053: Aktivität pro Seitenansicht
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEADM/adm_activity.htm';

ph := null;
wwv_flow_api.create_page(
  p_id     => 30.4053,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'Aktivität pro Seitenansicht',
  p_step_title=> 'Aktivität pro Seitenansicht',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'NO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 216662902659587159+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => '',
  p_step_template => 12930201930057128.4053+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409160254',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>30.4053,p_text=>h);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 4762011488013280.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 30.4053,
  p_plug_name=> 'Menu',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(4585800473139662 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 4589126493175495.4053+ wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'select '||chr(10)||
'time_stamp page_view,'||chr(10)||
'time_stamp t2,'||chr(10)||
' lower(l.userid) userid,'||chr(10)||
' upper(c.short_name) company,'||chr(10)||
' COMPONENT_ATTRIBUTE,'||chr(10)||
' elap,'||chr(10)||
' flow_id,'||chr(10)||
' step_id page_id,'||chr(10)||
' cached_regions,'||chr(10)||
'    decode(page_mode,'||chr(10)||
'        ''A'',m.m_PAGE_PROCESSING,'||chr(10)||
'        ''C'',m.m_CACHE_CREATED,'||chr(10)||
'        ''D'',m.m_DYNAMIC,'||chr(10)||
'        ''P'',m.m_PARTIAL_PAGE, '||chr(10)||
'        ''R'',m.m_CACHED,'||chr(10)||
'        page_mode) page_mode'||chr(10)||
' from ('||chr(10)||
'select '||chr(10)||
' security_group';

s:=s||'_id,'||chr(10)||
' time_stamp,'||chr(10)||
' userid,'||chr(10)||
' COMPONENT_ATTRIBUTE,'||chr(10)||
' elap,'||chr(10)||
' cached_regions,'||chr(10)||
' flow_id,'||chr(10)||
'step_id,'||chr(10)||
' page_mode'||chr(10)||
'from   #OWNER#.wwv_flow_activity_log'||chr(10)||
'where  (:F4050_P30_COMPANY is null or :F4050_P30_COMPANY = ''0'' or security_group_id = :F4050_P30_COMPANY) and'||chr(10)||
'      time_stamp > (sysdate - :P30_SINCE) and'||chr(10)||
'(nvl(:P30_PAGE_MODE,''0'')=''0'' or page_mode = :P30_PAGE_MODE)'||chr(10)||
'order  by time_stamp desc) l,'||chr(10)||
'wwv_flow_compa';

s:=s||'nies c,'||chr(10)||
'   (select wwv_flow_lang.system_message(''PAGE_PROCESSING'') m_PAGE_PROCESSING,'||chr(10)||
'           wwv_flow_lang.system_message(''CACHE_CREATED'') m_CACHE_CREATED,'||chr(10)||
'           wwv_flow_lang.system_message(''F4000.DYNAMIC'') m_DYNAMIC,'||chr(10)||
'           wwv_flow_lang.system_message(''PARTIAL_PAGE'') m_PARTIAL_PAGE,'||chr(10)||
'           wwv_flow_lang.system_message(''CACHED'') m_CACHED'||chr(10)||
'    from dual) m'||chr(10)||
'where security_group_id ';

s:=s||'= provisioning_company_id';

wwv_flow_api.create_report_region (
  p_id=> 59663210606281249.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 30.4053,
  p_name=> 'Recent Page Views',
  p_region_name=>'',
  p_template=> 0+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 10,
  p_display_column=> 1,
  p_display_point=> 'AFTER_SHOW_ITEMS',
  p_source=> s,
  p_source_type=> 'SQL_QUERY',
  p_display_error_message=> 'Unable to render chart. #SQLERRM#',
  p_plug_caching=> 'NOT_CACHED',
  p_customized=> '0',
  p_ajax_enabled=> 'N',
  p_query_row_template=> 6897002870390711.4053+ wwv_flow_api.g_id_offset,
  p_query_headings_type=> 'COLON_DELMITED_LIST',
  p_query_num_rows=> '15',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_show_nulls_as=> '(null)',
  p_query_break_cols=> '0',
  p_query_num_rows_item=> 'F4050_P30_ROWS',
  p_query_num_rows_type=> 'NEXT_PREVIOUS_LINKS',
  p_query_row_count_max=> '5000',
  p_pagination_display_position=> 'BOTTOM_RIGHT',
  p_csv_output=> 'N',
  p_query_asc_image=> 'blue_arrow_down.gif',
  p_query_asc_image_attr=> 'width="13" height="12"',
  p_query_desc_image=> 'blue_arrow_up.gif',
  p_query_desc_image_attr=> 'width="13" height="12" alt=""',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'generated 19-APR-2001 17:42:20');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48455219902770111.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 59663210606281249.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'PAGE_VIEW',
  p_column_display_sequence=> 1,
  p_column_heading=> 'Uhrzeit',
  p_column_format=> 'Dy &DATE_TIME_FORMAT.',
  p_column_css_style=>'white-space: nowrap;',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 47132723423237435.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 59663210606281249.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'T2',
  p_column_display_sequence=> 2,
  p_column_heading=> '&nbsp;',
  p_column_format=> 'SINCE',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48455325472770111.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 59663210606281249.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 3,
  p_form_element_id=> null,
  p_column_alias=> 'USERID',
  p_column_display_sequence=> 3,
  p_column_heading=> 'Benutzer',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48455413492770112.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 59663210606281249.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 4,
  p_form_element_id=> null,
  p_column_alias=> 'COMPANY',
  p_column_display_sequence=> 5,
  p_column_heading=> 'Workspace',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48455518040770112.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 59663210606281249.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 5,
  p_form_element_id=> null,
  p_column_alias=> 'COMPONENT_ATTRIBUTE',
  p_column_display_sequence=> 8,
  p_column_heading=> 'Seitenname',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48455619272770112.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 59663210606281249.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 6,
  p_form_element_id=> null,
  p_column_alias=> 'ELAP',
  p_column_display_sequence=> 7,
  p_column_heading=> 'Verstrichen',
  p_column_format=> '999G999G999G999G990D00',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'RIGHT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48455705676770112.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 59663210606281249.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 7,
  p_form_element_id=> null,
  p_column_alias=> 'FLOW_ID',
  p_column_display_sequence=> 4,
  p_column_heading=> 'Anwendung',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'RIGHT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 48455823869770112.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 59663210606281249.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 8,
  p_form_element_id=> null,
  p_column_alias=> 'PAGE_ID',
  p_column_display_sequence=> 6,
  p_column_heading=> 'Seite',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'RIGHT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 58083524886620303.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 59663210606281249.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 9,
  p_form_element_id=> null,
  p_column_alias=> 'CACHED_REGIONS',
  p_column_display_sequence=> 9,
  p_column_heading=> 'Gecachte<br />Regionen',
  p_column_format=> '999G999G999G999G999G999G990',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'RIGHT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 131019027924701075.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 59663210606281249.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 10,
  p_form_element_id=> null,
  p_column_alias=> 'PAGE_MODE',
  p_column_display_sequence=> 10,
  p_column_heading=> 'Seitenmodus',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'TEXT_FROM_LOV',
  p_named_lov=>131020216973707367 + wwv_flow_api.g_id_offset,
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 190796222078501880.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 30.4053,
  p_plug_name=> 'Button Bar',
  p_region_name=>'',
  p_plug_template=> 107311831567346457.4053+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 3130130253431532.4053 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 30.4053,
  p_button_sequence=> 10,
  p_button_plug_id => 59663210606281249+wwv_flow_api.g_id_offset,
  p_button_name    => 'FLOW_NEXT_PAGE',
  p_button_image   => 'smv.gif',
  p_button_image_alt=> 'Nächste Seite',
  p_button_position=> 'REGION_TEMPLATE_NEXT',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 3131511337435555.4053 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 30.4053,
  p_button_sequence=> 10,
  p_button_plug_id => 59663210606281249+wwv_flow_api.g_id_offset,
  p_button_name    => 'FLOW_PREVIOUS_PAGE',
  p_button_image   => 'srmv.gif',
  p_button_image_alt=> 'Vorherige Seite',
  p_button_position=> 'REGION_TEMPLATE_PREVIOUS',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>131026017582726466.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 30.4053,
  p_branch_action=> 'f?p=&APP_ID.:30:&SESSION.::&DEBUG.:::',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Created 05-DEC-2007 14:03 by MIKE');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Schränken Sie den Bericht auf einen bestimmten Zeitrahmen ein. Geben Sie die Dauer an, die für den Bericht berücksichtigt werden soll, und klicken Sie anschließend auf <b>Los</b>.<p />'||chr(10)||
'Wenn Sie 1 Tag auswählen, werden nur die letzten 24 Stunden angezeigt.  ';

wwv_flow_api.create_page_item(
  p_id=>47128703206222148.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 30.4053,
  p_name=>'P30_SINCE',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 11,
  p_item_plug_id => 190796222078501880.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default => '1',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Seit',
  p_source_type=> 'STATIC',
  p_display_as=> 'COMBOBOX',
  p_named_lov=> 'RECENT_TIME',
  p_lov => 'select ''10 ''||wwv_flow_lang.system_message(initcap(''SECONDS'')) d, 10/(24*60*60) t from dual union all'||chr(10)||
'select ''1 ''||wwv_flow_lang.system_message(initcap(''MINUTE'')) d, 1/(24*60) t from dual union all'||chr(10)||
'select ''5 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 5/(24*60) t from dual union all'||chr(10)||
'select ''15 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 15/(24*60) t from dual union all'||chr(10)||
'select ''30 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 30/(24*60) t from dual union all'||chr(10)||
'select ''1 ''||wwv_flow_lang.system_message(initcap(''HOUR'')) d, 1/24 t from dual union all'||chr(10)||
'select ''2 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 1/12  t from dual union all'||chr(10)||
'select ''6 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 6/24 t from dual union all'||chr(10)||
'select ''8 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 8/24 t from dual union all'||chr(10)||
'select ''1 ''||wwv_flow_lang.system_message(initcap(''DAY'')) d, 1 t from dual union all'||chr(10)||
'select ''2 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 2 t from dual union all'||chr(10)||
'select ''1 ''||wwv_flow_lang.system_message(initcap(''WEEK'')) d, 7 t  from dual union all'||chr(10)||
'select ''2 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 14 t  from dual union all'||chr(10)||
'select ''4 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 28 t from dual union all'||chr(10)||
'select ''1 ''||wwv_flow_lang.system_message(initcap(''YEAR'')) d, 365 t from dual order by 2',
  p_lov_columns=> 1,
  p_lov_display_null=> 'YES',
  p_lov_translated=> 'N',
  p_lov_null_text=>'',
  p_lov_null_value=> '',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 343399818250317904.4053+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Um nach Workspace zu filtern, wählen Sie einen Workspace und klicken anschließend auf <b>Los</b>. Um Ergebnisse aus allen Workspaces zurückzugeben, wählen Sie <b>Alle Workspaces anzeigen</b>.';

wwv_flow_api.create_page_item(
  p_id=>59664512389385377.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 30.4053,
  p_name=>'F4050_P30_COMPANY',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 190796222078501880.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Workspace',
  p_source_type=> 'STATIC',
  p_display_as=> 'POPUP_KEY_LOV',
  p_named_lov=> 'LIST_ALL_COMPANIES',
  p_lov => 'select ''- ''||'||chr(10)||
'wwv_flow_lang.system_message(''F4050_SHOW_ALL_WORKSPACES'')||'||chr(10)||
''' -'' d, 0 r from dual union all'||chr(10)||
'select short_name||'' (''||PROVISIONING_COMPANY_ID||'')'' d,'||chr(10)||
'       PROVISIONING_COMPANY_ID r'||chr(10)||
'from   WWV_FLOW_COMPANIES'||chr(10)||
'where  provisioning_company_id > 0'||chr(10)||
'order by 1',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 343399818250317904.4053+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>59665949535463099.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 30.4053,
  p_name=>'F4050_P30_GO',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 20,
  p_item_plug_id => 190796222078501880.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default => 'GO',
  p_prompt=>'Los',
  p_source=>'GO',
  p_source_type=> 'STATIC',
  p_display_as=> 'BUTTON',
  p_lov_columns=> null,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> 2000,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'LEFT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Gibt das protokollierte Seitenereignis an';

wwv_flow_api.create_page_item(
  p_id=>131028006285732714.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 30.4053,
  p_name=>'P30_PAGE_MODE',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 12,
  p_item_plug_id => 190796222078501880.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default => '0',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Seitenmodus',
  p_source=>'0',
  p_source_type=> 'STATIC',
  p_display_as=> 'COMBOBOX',
  p_named_lov=> 'PAGE VIEW MODE',
  p_lov => '.'||to_char(131020216973707367 + wwv_flow_api.g_id_offset)||'.',
  p_lov_columns=> 1,
  p_lov_display_null=> 'YES',
  p_lov_translated=> 'N',
  p_lov_null_text=>'- Alles -',
  p_lov_null_value=> '0',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 5,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 343399818250317904.4053+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Wählen Sie die maximale Anzahl der Zeilen, die pro Seite angezeigt werden sollen.';

wwv_flow_api.create_page_item(
  p_id=>133015926403696373.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 30.4053,
  p_name=>'F4050_P30_ROWS',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 15,
  p_item_plug_id => 190796222078501880.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default => '15',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Anzeigen',
  p_source_type=> 'STATIC',
  p_display_as=> 'COMBOBOX',
  p_named_lov=> 'MAX_ROWS_D',
  p_lov => '.'||to_char(87730331399250507 + wwv_flow_api.g_id_offset)||'.',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 343399818250317904.4053+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'reset_pagination';

wwv_flow_api.create_page_process(
  p_id     => 59664916506391552.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 30.4053,
  p_process_sequence=> 10,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'RESET_PAGINATION',
  p_process_name=> 'reset pg',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_when=>'GO',
  p_process_when_type=>'REQUEST_EQUALS_CONDITION',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 30.4053
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_31.40
prompt  ...PAGE 31.4053: Zugriffs-Log für die Anmeldung verwalten
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEADM/adm_logs.htm';

ph := null;
wwv_flow_api.create_page(
  p_id     => 31.4053,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'Zugriffs-Log für die Anmeldung verwalten',
  p_step_title=> 'Zugriffs-Log für die Anmeldung verwalten',
  p_step_sub_title => 'Manage Login Access Log',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'NO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 216783731365642767+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => '',
  p_step_template => '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409160254',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>31.4053,p_text=>h);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'declare'||chr(10)||
'   c_dev pls_integer := 0;'||chr(10)||
''||chr(10)||
'begin'||chr(10)||
'   htp.p(''<table class="instructiontext" summary="">'');'||chr(10)||
'   select count(*) into c_dev from wwv_flow_user_access_log_v;'||chr(10)||
'   htp.p(''<tr><td>''||wwv_flow_lang.system_message(''4050_31_LOG_COUNT'')||''</td><td align="right">'');'||chr(10)||
'   htp.p(to_char(c_dev,''999,999,999,990''));'||chr(10)||
'   htp.p(''</td><td><br /></td></tr>'');'||chr(10)||
'   htp.p(''</table>'');'||chr(10)||
'end;';

wwv_flow_api.create_page_plug (
  p_id=> 15366007090981094.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 31.4053,
  p_plug_name=> 'Einträge im Zugriffs-Log für die Anmeldung löschen',
  p_region_name=>'',
  p_plug_template=> 2424107150426143.4053+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 10,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'PLSQL_PROCEDURE',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 15366424092981097.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 31.4053,
  p_plug_name=> 'Manage Login Access Log',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(4585800473139662 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 4589126493175495.4053+ wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 15366901763981105.4053 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 31.4053,
  p_button_sequence=> 10,
  p_button_plug_id => 15366007090981094+wwv_flow_api.g_id_offset,
  p_button_name    => 'CANCEL',
  p_button_image_alt=> 'Abbrechen',
  p_button_position=> 'REGION_TEMPLATE_CLOSE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=&FLOW_ID.:68:&SESSION.::&DEBUG.:::',
  p_button_cattributes=>'class="button10"',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 15367111801981107.4053 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 31.4053,
  p_button_sequence=> 10,
  p_button_plug_id => 15366007090981094+wwv_flow_api.g_id_offset,
  p_button_name    => 'DELETE_ENTRIES',
  p_button_image_alt=> 'Einträge löschen',
  p_button_position=> 'REGION_TEMPLATE_CREATE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_cattributes=>'class="BUTTON10"',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>15368103316981118.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 31.4053,
  p_branch_action=> '31',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'BRANCH_TO_STEP',
  p_branch_when_button_id=>15367111801981107.4053+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Einträge ab dieser Anzahl von Tagen löschen.';

wwv_flow_api.create_page_item(
  p_id=>15367328334981108.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 31.4053,
  p_name=>'P31_TIME',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 15366007090981094.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Einträge ab dieser Anzahl von Tagen löschen:',
  p_source=>'31',
  p_source_type=> 'STATIC',
  p_display_as=> 'COMBOBOX',
  p_named_lov=> 'TIME_INTERVALS',
  p_lov => '.'||to_char(87720511660244788 + wwv_flow_api.g_id_offset)||'.',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 111843720754869910.4053+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'delete from wwv_flow_user_access_log1$'||chr(10)||
'where access_date < (sysdate - nvl(:p31_time,31));'||chr(10)||
'delete from wwv_flow_user_access_log2$'||chr(10)||
'where access_date < (sysdate - nvl(:p31_time,31));';

wwv_flow_api.create_page_process(
  p_id     => 15367807877981115.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 31.4053,
  p_process_sequence=> 10,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'delete rows',
  p_process_sql_clob => p, 
  p_process_error_message=> 'Fehler beim Leeren von Zugriffs-Log für die Anmeldung.',
  p_process_when_button_id=>15367111801981107.4053 + wwv_flow_api.g_id_offset,
  p_process_success_message=> 'Zugriffs-Log für die Anmeldung wurde geleert.',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 31.4053
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_32.40
prompt  ...PAGE 32.4053: Zugriffs-Log für die Anmeldung
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEADM/adm_logs.htm';

ph := null;
wwv_flow_api.create_page(
  p_id     => 32.4053,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'Zugriffs-Log für die Anmeldung',
  p_step_title=> 'Zugriffs-Log für die Anmeldung',
  p_step_sub_title => 'Login Access Log',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'NO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 216783731365642767+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => '',
  p_step_template => 12930201930057128.4053+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409160254',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>32.4053,p_text=>h);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'declare'||chr(10)||
'   c_dev pls_integer := 0;'||chr(10)||
'begin'||chr(10)||
'   htp.p(''<table class="instructiontext" summary="">'');'||chr(10)||
'   select count(*) into c_dev from wwv_flow_user_access_log_v;'||chr(10)||
'   htp.p(''<tr><td>''||wwv_flow_lang.system_message(''4050_31_LOG_COUNT'')||'':&nbsp;</td><td align="right">'');'||chr(10)||
'   htp.p(to_char(c_dev,''999,999,999,990''));'||chr(10)||
'   htp.p(''</td><td><br /></td></tr>'');'||chr(10)||
'   htp.p(''</table>'');'||chr(10)||
'end;';

wwv_flow_api.create_page_plug (
  p_id=> 15371009700023708.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 32.4053,
  p_plug_name=> 'Zugriffs-Log für die Anmeldung',
  p_region_name=>'',
  p_plug_template=> 2424107150426143.4053+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 10,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_02',
  p_plug_source=> s,
  p_plug_source_type=> 'PLSQL_PROCEDURE',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'Diese Tabelle erfasst die Authentifizierungsereignisse von Entwicklern und Administratoren bei der &PRODUCT_NAME.-Umgebung sowie von Endbenutzern der &PRODUCT_NAME.-Anwendungen, welche die integrierten Anmeldungs-APIs für Entwickler verwenden. Log-Einträge werden periodisch aus den Log-Tabellen als veraltet gelöscht.'||chr(10)||
'';

wwv_flow_api.create_page_plug (
  p_id=> 15371221700023709.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 32.4053,
  p_plug_name=> 'Zugriffs-Log für die Anmeldung',
  p_region_name=>'',
  p_plug_template=> 79623830123907946.4053+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 20,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_03',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 15371605299023709.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 32.4053,
  p_plug_name=> 'Login Access Log',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(4585800473139662 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 4589126493175495.4053+ wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 15372100384023710.4053 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 32.4053,
  p_button_sequence=> 10,
  p_button_plug_id => 15371009700023708+wwv_flow_api.g_id_offset,
  p_button_name    => 'CANCEL',
  p_button_image_alt=> 'Abbrechen',
  p_button_position=> 'REGION_TEMPLATE_CLOSE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=&FLOW_ID.:68:&SESSION.::&DEBUG.:::',
  p_button_cattributes=>'class="button10"',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 15372326450023710.4053 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 32.4053,
  p_button_sequence=> 10,
  p_button_plug_id => 15371009700023708+wwv_flow_api.g_id_offset,
  p_button_name    => 'MANAGE',
  p_button_image_alt=> 'Verwalten &gt;',
  p_button_position=> 'REGION_TEMPLATE_CREATE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=&APP_ID.:31:&SESSION.::&DEBUG.:::',
  p_button_cattributes=>'class="button10"',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 32.4053
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_33.40
prompt  ...PAGE 33.4053: Seitenansichten pro Workspace
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEADM/adm_activity.htm';

ph := null;
wwv_flow_api.create_page(
  p_id     => 33.4053,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'Seitenansichten pro Workspace',
  p_step_title=> 'Seitenansichten pro Workspace',
  p_step_sub_title => 'Chart 1',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'AUTO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 216662902659587159+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => '',
  p_step_template => 12930201930057128.4053+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409160254',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>33.4053,p_text=>h);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 4753811788985055.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 33.4053,
  p_plug_name=> 'Menu',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(4585800473139662 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 4589126493175495.4053+ wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'with total_views as ('||chr(10)||
'select count(*) tv '||chr(10)||
'from WWV_FLOW_ACTIVITY_LOG '||chr(10)||
' where time_stamp>=(select sysdate - to_number(:P33_DAYS) from dual) )'||chr(10)||
'select c.short_name workspace, count(*) page_views, sum(elap) elapsed, count(distinct ip_address) ip_addresses, sum(num_rows) report_rows, 100*count(*)/max(tv) pct, round(300*count(*)/max(tv)) graph'||chr(10)||
'from WWV_FLOW_ACTIVITY_LOG l, wwv_flow_companies c, total_vi';

s:=s||'ews'||chr(10)||
'where l.security_group_id = c.provisioning_company_id(+)'||chr(10)||
'and l.page_mode != ''A'''||chr(10)||
'and l.time_stamp>=(select sysdate - to_number('||chr(10)||
':P33_DAYS) x from dual ) '||chr(10)||
'group by c.short_name';

wwv_flow_api.create_report_region (
  p_id=> 7654425481341918.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 33.4053,
  p_name=> 'Page Views by Workspace',
  p_region_name=>'',
  p_template=> 0+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 30,
  p_display_column=> 1,
  p_display_point=> 'AFTER_SHOW_ITEMS',
  p_source=> s,
  p_source_type=> 'SQL_QUERY',
  p_display_error_message=> '#SQLERRM#',
  p_plug_caching=> 'NOT_CACHED',
  p_customized=> '0',
  p_query_row_template=> 6897002870390711.4053+ wwv_flow_api.g_id_offset,
  p_query_headings_type=> 'COLON_DELMITED_LIST',
  p_query_num_rows=> '15',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_show_nulls_as=> ' - ',
  p_query_break_cols=> '0',
  p_query_no_data_found=> 'Keine Daten gefunden.',
  p_query_num_rows_item=> 'P33_ROWS',
  p_query_num_rows_type=> 'NEXT_PREVIOUS_LINKS',
  p_query_row_count_max=> '5000000',
  p_pagination_display_position=> 'BOTTOM_RIGHT',
  p_csv_output=> 'Y',
  p_csv_output_link_text=> 'Herunterladen',
  p_prn_output=> 'Y',
  p_prn_format=> 'PDF',
  p_prn_output_show_link=> 'Y',
  p_prn_output_link_text=> 'Drucken',
  p_prn_units=> 'INCHES',
  p_prn_paper_size=> 'LETTER',
  p_prn_width=> 11,
  p_prn_height=> 8.5,
  p_prn_orientation=> 'HORIZONTAL',
  p_prn_page_header=> '&PRODUCT_NAME.',
  p_prn_page_header_font_color=> '#000000',
  p_prn_page_header_font_family=> 'Helvetica',
  p_prn_page_header_font_weight=> 'normal',
  p_prn_page_header_font_size=> '12',
  p_prn_page_footer_font_color=> '#000000',
  p_prn_page_footer_font_family=> 'Helvetica',
  p_prn_page_footer_font_weight=> 'normal',
  p_prn_page_footer_font_size=> '12',
  p_prn_header_bg_color=> '#9bafde',
  p_prn_header_font_color=> '#ffffff',
  p_prn_header_font_family=> 'Helvetica',
  p_prn_header_font_weight=> 'normal',
  p_prn_header_font_size=> '10',
  p_prn_body_bg_color=> '#efefef',
  p_prn_body_font_color=> '#000000',
  p_prn_body_font_family=> 'Helvetica',
  p_prn_body_font_weight=> 'normal',
  p_prn_body_font_size=> '10',
  p_prn_border_width=> .5,
  p_query_asc_image=> 'arrow_down_gray_dark.gif',
  p_query_asc_image_attr=> 'width="13" height="12"',
  p_query_desc_image=> 'arrow_up_gray_dark.gif',
  p_query_desc_image_attr=> 'width="13" height="12"',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 7654704708341922.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 7654425481341918.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'WORKSPACE',
  p_column_display_sequence=> 1,
  p_column_heading=> 'Workspace',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>2,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_print_col_width=> '21',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 7654812792341922.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 7654425481341918.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'PAGE_VIEWS',
  p_column_display_sequence=> 2,
  p_column_heading=> 'Seitenansichten',
  p_column_format=> '999G999G999G999G999G999G990',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>1,
  p_default_sort_dir=>'desc',
  p_disable_sort_column=>'N',
  p_sum_column=> 'Y',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_print_col_width=> '14',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 7668703542401871.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 7654425481341918.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 3,
  p_form_element_id=> null,
  p_column_alias=> 'ELAPSED',
  p_column_display_sequence=> 5,
  p_column_heading=> 'Verstrichene Zeit',
  p_column_format=> '999G999G999G999G990D00',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'Y',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_print_col_width=> '14',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 7668806599401871.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 7654425481341918.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 4,
  p_form_element_id=> null,
  p_column_alias=> 'IP_ADDRESSES',
  p_column_display_sequence=> 6,
  p_column_heading=> 'IP-Adressen',
  p_column_format=> '999G999G999G999G999G999G990',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'Y',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_print_col_width=> '21',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 7671503111420608.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 7654425481341918.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 5,
  p_form_element_id=> null,
  p_column_alias=> 'REPORT_ROWS',
  p_column_display_sequence=> 7,
  p_column_heading=> 'Berichtszeilen',
  p_column_format=> '999G999G999G999G999G999G990',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'Y',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_print_col_width=> '14',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 7655825265351339.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 7654425481341918.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 6,
  p_form_element_id=> null,
  p_column_alias=> 'PCT',
  p_column_display_sequence=> 3,
  p_column_heading=> 'Prozentsatz',
  p_column_format=> '999G999G999G999G990D0000',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'Y',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_print_col_width=> '14',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 7656203926354662.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 7654425481341918.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 7,
  p_form_element_id=> null,
  p_column_alias=> 'GRAPH',
  p_column_display_sequence=> 4,
  p_column_heading=> 'Prozentsatz Seitenansichten',
  p_column_html_expression=>'<div style="width:300px;height:14px;background:#dddddd;border-top:1px solid #aaaaaa;border-left:1px solid #aaaaaa;border-bottom:1px solid #ffffff;border-right:1px solid #ffffff;">'||chr(10)||
'<img src="#IMAGE_PREFIX#1px_trans.gif" width="#GRAPH#" height="14" border="0" style="background:#3f863f;"></div>',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'N',
  p_print_col_width=> '0',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 61103509800592682.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 33.4053,
  p_plug_name=> 'Button Bar',
  p_region_name=>'',
  p_plug_template=> 107311831567346457.4053+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 5,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'Dieses Diagramm fasst die Anzahl der Seitenansichten pro Workspace für einen angegebenen Zeitraum zusammen.';

wwv_flow_api.create_page_plug (
  p_id=> 248929631244283875.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 33.4053,
  p_plug_name=> 'Seitenansichten pro Workspace',
  p_region_name=>'',
  p_plug_template=> 79623830123907946.4053+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 20,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_03',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>138316905713314612.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 33.4053,
  p_branch_action=> 'f?p=&APP_ID.:33:&SESSION.::&DEBUG.:::',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Created 12-DEC-2007 19:56 by MIKE');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Wählen Sie die Anzahl der Zeilen, die angezeigt werden sollen, und klicken Sie anschließend auf <b>Los</b>.';

wwv_flow_api.create_page_item(
  p_id=>7666001333391733.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 33.4053,
  p_name=>'P33_ROWS',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 15,
  p_item_plug_id => 61103509800592682.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default => '15',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Anzeigen',
  p_source_type=> 'STATIC',
  p_display_as=> 'COMBOBOX',
  p_named_lov=> 'MAX_ROWS_D',
  p_lov => '.'||to_char(87730331399250507 + wwv_flow_api.g_id_offset)||'.',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 343399818250317904.4053+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Schränken Sie den Bericht auf einen bestimmten Zeitrahmen ein. Geben Sie die Dauer an, die für den Bericht berücksichtigt werden soll, und klicken Sie anschließend auf <b>Los</b>.<p />'||chr(10)||
'Wenn Sie 1 Tag auswählen, werden nur die letzten 24 Stunden angezeigt.  ';

wwv_flow_api.create_page_item(
  p_id=>61104914087603350.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 33.4053,
  p_name=>'P33_DAYS',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 61103509800592682.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default => 'to_number(.000694444)',
  p_item_default_type => 'PLSQL_EXPRESSION',
  p_prompt=>'Aufnehmen',
  p_source_type=> 'STATIC',
  p_display_as=> 'COMBOBOX',
  p_named_lov=> 'RECENT_TIME',
  p_lov => 'select ''10 ''||wwv_flow_lang.system_message(initcap(''SECONDS'')) d, 10/(24*60*60) t from dual union all'||chr(10)||
'select ''1 ''||wwv_flow_lang.system_message(initcap(''MINUTE'')) d, 1/(24*60) t from dual union all'||chr(10)||
'select ''5 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 5/(24*60) t from dual union all'||chr(10)||
'select ''15 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 15/(24*60) t from dual union all'||chr(10)||
'select ''30 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 30/(24*60) t from dual union all'||chr(10)||
'select ''1 ''||wwv_flow_lang.system_message(initcap(''HOUR'')) d, 1/24 t from dual union all'||chr(10)||
'select ''2 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 1/12  t from dual union all'||chr(10)||
'select ''6 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 6/24 t from dual union all'||chr(10)||
'select ''8 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 8/24 t from dual union all'||chr(10)||
'select ''1 ''||wwv_flow_lang.system_message(initcap(''DAY'')) d, 1 t from dual union all'||chr(10)||
'select ''2 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 2 t from dual union all'||chr(10)||
'select ''1 ''||wwv_flow_lang.system_message(initcap(''WEEK'')) d, 7 t  from dual union all'||chr(10)||
'select ''2 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 14 t  from dual union all'||chr(10)||
'select ''4 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 28 t from dual union all'||chr(10)||
'select ''1 ''||wwv_flow_lang.system_message(initcap(''YEAR'')) d, 365 t from dual order by 2',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 343399818250317904.4053+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>61106528978607676.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 33.4053,
  p_name=>'P33_GO',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 20,
  p_item_plug_id => 61103509800592682.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default => 'GO',
  p_prompt=>'Los',
  p_source=>'GO',
  p_source_type=> 'STATIC',
  p_display_as=> 'BUTTON',
  p_lov_columns=> null,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> 2000,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'LEFT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'N',
  p_item_comment => '');
 
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'reset_pagination';

wwv_flow_api.create_page_process(
  p_id     => 7662327390380352.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 33.4053,
  p_process_sequence=> 10,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'RESET_PAGINATION',
  p_process_name=> 'Reset Pagination',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_when_button_id=>61106528978607676.4053 + wwv_flow_api.g_id_offset,
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 33.4053
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_35.40
prompt  ...PAGE 35.4053: Letzte Entwickleranmeldung
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEADM/adm_activity.htm';

ph := null;
wwv_flow_api.create_page(
  p_id     => 35.4053,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'Letzte Entwickleranmeldung',
  p_step_title=> 'Letzte Entwickleranmeldung',
  p_step_sub_title => 'Developer Last Login',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'NO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 216662902659587159+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => '',
  p_step_template => 12930201930057128.4053+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409160254',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>35.4053,p_text=>h);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'select  u.USER_NAME, u.EMAIL_ADDRESS, u.LAST_LOGIN, u.LAST_IP, u.LAST_AGENT, w.short_name'||chr(10)||
'from  WWV_FLOW_FND_USER u,'||chr(10)||
'         WWV_FLOW_COMPANIES w'||chr(10)||
'where u.security_group_id = w.PROVISIONING_COMPANY_ID and'||chr(10)||
'(:P35_COMPANY is null or :P35_COMPANY = 0 or u.security_group_id = :P35_COMPANY) and u.last_login is not null';

wwv_flow_api.create_report_region (
  p_id=> 47180117495860052.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 35.4053,
  p_name=> 'Developer Last Login',
  p_region_name=>'',
  p_template=> 0+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 10,
  p_display_column=> 1,
  p_display_point=> 'REGION_POSITION_02',
  p_source=> s,
  p_source_type=> 'SQL_QUERY',
  p_display_error_message=> '#SQLERRM#',
  p_plug_caching=> 'NOT_CACHED',
  p_customized=> '0',
  p_query_row_template=> 6897002870390711.4053+ wwv_flow_api.g_id_offset,
  p_query_headings_type=> 'COLON_DELMITED_LIST',
  p_query_num_rows=> '15',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_break_cols=> '0',
  p_query_num_rows_item=> 'P35_ROWS',
  p_query_num_rows_type=> 'ROW_RANGES_WITH_LINKS',
  p_query_row_count_max=> '500',
  p_pagination_display_position=> 'BOTTOM_RIGHT',
  p_csv_output=> 'Y',
  p_csv_output_link_text=> 'Herunterladen',
  p_prn_output=> 'Y',
  p_prn_format=> 'PDF',
  p_prn_output_show_link=> 'Y',
  p_prn_output_link_text=> 'Drucken',
  p_prn_units=> 'INCHES',
  p_prn_paper_size=> 'LETTER',
  p_prn_width=> 11,
  p_prn_height=> 8.5,
  p_prn_orientation=> 'HORIZONTAL',
  p_prn_page_header=> '&PRODUCT_NAME.',
  p_prn_page_header_font_color=> '#000000',
  p_prn_page_header_font_family=> 'Helvetica',
  p_prn_page_header_font_weight=> 'normal',
  p_prn_page_header_font_size=> '12',
  p_prn_page_footer_font_color=> '#000000',
  p_prn_page_footer_font_family=> 'Helvetica',
  p_prn_page_footer_font_weight=> 'normal',
  p_prn_page_footer_font_size=> '12',
  p_prn_header_bg_color=> '#9bafde',
  p_prn_header_font_color=> '#ffffff',
  p_prn_header_font_family=> 'Helvetica',
  p_prn_header_font_weight=> 'normal',
  p_prn_header_font_size=> '10',
  p_prn_body_bg_color=> '#efefef',
  p_prn_body_font_color=> '#000000',
  p_prn_body_font_family=> 'Helvetica',
  p_prn_body_font_weight=> 'normal',
  p_prn_body_font_size=> '10',
  p_prn_border_width=> .5,
  p_query_asc_image=> 'arrow_down_gray_dark.gif',
  p_query_asc_image_attr=> 'width="13" height="12"',
  p_query_desc_image=> 'arrow_up_gray_dark.gif',
  p_query_desc_image_attr=> 'width="13" height="12"',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 47189018958888947.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 47180117495860052.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'USER_NAME',
  p_column_display_sequence=> 2,
  p_column_heading=> 'Benutzer',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>2,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_print_col_width=> '11',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 47189128048888947.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 47180117495860052.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'EMAIL_ADDRESS',
  p_column_display_sequence=> 3,
  p_column_heading=> 'E-Mail',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_print_col_width=> '16',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 47189213748888947.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 47180117495860052.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 3,
  p_form_element_id=> null,
  p_column_alias=> 'LAST_LOGIN',
  p_column_display_sequence=> 4,
  p_column_heading=> 'Anmeldung',
  p_column_format=> 'SINCE',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_print_col_width=> '16',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 47189309594888947.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 47180117495860052.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 4,
  p_form_element_id=> null,
  p_column_alias=> 'LAST_IP',
  p_column_display_sequence=> 5,
  p_column_heading=> 'IP-Adresse',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_print_col_width=> '10',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 47189416703888947.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 47180117495860052.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 5,
  p_form_element_id=> null,
  p_column_alias=> 'LAST_AGENT',
  p_column_display_sequence=> 6,
  p_column_heading=> 'Agent',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_print_col_width=> '32',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 47192329047920292.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 47180117495860052.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 6,
  p_form_element_id=> null,
  p_column_alias=> 'SHORT_NAME',
  p_column_display_sequence=> 1,
  p_column_heading=> 'Workspace',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>1,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_include_in_export=> 'Y',
  p_print_col_width=> '11',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 47180820085860052.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 35.4053,
  p_plug_name=> 'Button Bar',
  p_region_name=>'',
  p_plug_template=> 107311831567346457.4053+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_02',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings => 'blue_arrow_down.gif::blue_arrow_up.gif:|3,3,4\1,2|'||chr(10)||
''||chr(10)||
'&nbsp;:'||chr(10)||
''||chr(10)||
'<font class="nounderline" color="black">CompanyShortName</font>:'||chr(10)||
''||chr(10)||
'<font class="nounderline" color="green">Users</font>:'||chr(10)||
''||chr(10)||
'<font class="nounderline" color="green">Developers</font>:'||chr(10)||
''||chr(10)||
'<font class="nounderline" color="green">Flows</font>:<font color=green>ProvStatus</font>:'||chr(10)||
''||chr(10)||
'<font class="nounderline" color="black">CompanyID</font>:',
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_num_rows => 25,
  p_plug_query_num_rows_item => 'F4050_P1_ROWS',
  p_plug_query_num_rows_type => 'ROWS_X_TO_Y_OF_Z',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_query_show_nulls_as => '(null)',
  p_plug_query_col_allignments => 'L:L:L:L:R:R:R:L',
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 47181016431860053.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 35.4053,
  p_plug_name=> 'Developer Last Login',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(4585800473139662 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 4589126493175495.4053+ wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>47183931696860057.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 35.4053,
  p_branch_action=> '35',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'BRANCH_TO_STEP',
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Created 29-NOV-2001 21:40 by MIKE');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Wählen Sie die maximale Anzahl der Zeilen, die pro Seite angezeigt werden sollen.';

wwv_flow_api.create_page_item(
  p_id=>47181514966860054.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 35.4053,
  p_name=>'P35_ROWS',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 15,
  p_item_plug_id => 47180820085860052.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default => '15',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Anzeigen',
  p_source_type=> 'STATIC',
  p_display_as=> 'COMBOBOX',
  p_named_lov=> 'MAX_ROWS_D',
  p_lov => '.'||to_char(87730331399250507 + wwv_flow_api.g_id_offset)||'.',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 343399818250317904.4053+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>47182525953860055.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 35.4053,
  p_name=>'P35_GO',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 20,
  p_item_plug_id => 47180820085860052.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default => 'GO',
  p_prompt=>'Los',
  p_source=>'GO',
  p_source_type=> 'STATIC',
  p_display_as=> 'BUTTON',
  p_lov_columns=> null,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> 2000,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'LEFT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Um nach Workspace zu filtern, wählen Sie einen Workspace und klicken anschließend auf <b>Los</b>. Um Ergebnisse aus allen Workspaces zurückzugeben, wählen Sie <b>Alle Workspaces</b>.';

wwv_flow_api.create_page_item(
  p_id=>47182703982860055.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 35.4053,
  p_name=>'P35_COMPANY',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 5,
  p_item_plug_id => 47180820085860052.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default => '0',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Workspace',
  p_source_type=> 'STATIC',
  p_display_as=> 'POPUP_KEY_LOV',
  p_named_lov=> 'LIST_DEVELOPER_WORKSPACES',
  p_lov => 'select ''- ''||'||chr(10)||
'wwv_flow_lang.system_message(''F4050_SHOW_ALL_WORKSPACES'')||'||chr(10)||
''' -'' d, 0 r from dual union all'||chr(10)||
'select short_name||'' (''||PROVISIONING_COMPANY_ID||'')'' d,'||chr(10)||
'       PROVISIONING_COMPANY_ID r'||chr(10)||
'from   WWV_FLOW_COMPANIES'||chr(10)||
'where  provisioning_company_id not in (0,10,11)'||chr(10)||
'order by 1',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 343399818250317904.4053+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'reset_pagination';

wwv_flow_api.create_page_process(
  p_id     => 47183610973860056.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 35.4053,
  p_process_sequence=> 10,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'RESET_PAGINATION',
  p_process_name=> 'reset pg ',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_when_button_id=>47182525953860055.4053 + wwv_flow_api.g_id_offset,
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 35.4053
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_36.40
prompt  ...PAGE 36.4053: Seitenansichten pro Workspace und Benutzer
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEADM/adm_activity.htm';

ph := null;
wwv_flow_api.create_page(
  p_id     => 36.4053,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'Seitenansichten pro Workspace und Benutzer',
  p_step_title=> 'Seitenansichten pro Workspace und Benutzer',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'NO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 216662902659587159+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => '',
  p_step_template => 12930201930057128.4053+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090528134451',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>36.4053,p_text=>h);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 4767432051028719.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 36.4053,
  p_plug_name=> 'Menu',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(4585800473139662 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 4589126493175495.4053+ wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'with messages as ('||chr(10)||
'select wwv_flow_lang.system_message(''AUTH.LOGIN_PAGE'') login_page,'||chr(10)||
'wwv_flow_lang.system_message(''UNAUTHENTICATED_USER'') unauth_user,'||chr(10)||
'(select count(*) tv'||chr(10)||
'from wwv_flow_activity_log l'||chr(10)||
'where l.time_stamp>=(select sysdate - to_number('||chr(10)||
':F4050_P36_DAYS) x from dual )  ) tv'||chr(10)||
'from dual)'||chr(10)||
'select '||chr(10)||
'decode(upper(l.userid),null,'||chr(10)||
'  messages.login_page,''NOBODY'','||chr(10)||
'  messages.unauth_user,upper(l.us';

s:=s||'erid))'||chr(10)||
'   user_name,'||chr(10)||
'lower(c.short_name) workspace,'||chr(10)||
' count(*) page_views, 100*count(*)/tv pct, sum(num_rows) report_rows, count(distinct(ip_address)) ip_addresses, sum(elap) total_elapsed, avg(elap) average_elapsed, count(distinct to_char(time_stamp,''YYYYMMDDHH24'')) distinct_hours, count(distinct to_char(time_stamp,''YYYYMMDD'')) distinct_days'||chr(10)||
'from wwv_flow_activity_log l, wwv_flow_companies c, mess';

s:=s||'ages'||chr(10)||
'where l.security_group_id = c.provisioning_company_id (+)'||chr(10)||
'and page_mode != ''A'''||chr(10)||
'and l.time_stamp>=(select sysdate - to_number('||chr(10)||
':F4050_P36_DAYS) x from dual )  '||chr(10)||
'and (c.PROVISIONING_COMPANY_ID = :F4050_P36_COMPANY or :F4050_P36_COMPANY = 0)'||chr(10)||
'group by decode(upper(l.userid),null,'||chr(10)||
'  login_page,''NOBODY'','||chr(10)||
'  unauth_user,upper(l.userid)),'||chr(10)||
'  lower(c.short_name),'||chr(10)||
'  tv';

wwv_flow_api.create_report_region (
  p_id=> 7636510665243086.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 36.4053,
  p_name=> 'Page Views by User',
  p_region_name=>'',
  p_template=> 0+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 60,
  p_display_column=> 1,
  p_display_point=> 'AFTER_SHOW_ITEMS',
  p_source=> s,
  p_source_type=> 'SQL_QUERY',
  p_display_error_message=> '#SQLERRM#',
  p_plug_caching=> 'NOT_CACHED',
  p_customized=> '0',
  p_ajax_enabled=> 'N',
  p_query_row_template=> 6897002870390711.4053+ wwv_flow_api.g_id_offset,
  p_query_headings_type=> 'COLON_DELMITED_LIST',
  p_query_num_rows=> '15',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_show_nulls_as=> ' - ',
  p_query_break_cols=> '0',
  p_query_no_data_found=> 'Keine Daten gefunden.',
  p_query_num_rows_item=> 'P36_ROWS',
  p_query_num_rows_type=> 'NEXT_PREVIOUS_LINKS',
  p_query_row_count_max=> '50000',
  p_pagination_display_position=> 'BOTTOM_RIGHT',
  p_csv_output=> 'N',
  p_query_asc_image=> 'arrow_down_gray_dark.gif',
  p_query_asc_image_attr=> 'width="13" height="12"',
  p_query_desc_image=> 'arrow_up_gray_dark.gif',
  p_query_desc_image_attr=> 'width="13" height="12"',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'with messages as ('||chr(10)||
'select wwv_flow_lang.system_message(''AUTH.LOGIN_PAGE'') login_page,'||chr(10)||
'wwv_flow_lang.system_message(''UNAUTHENTICATED_USER'') unauth_user,'||chr(10)||
'(select count(*) tv'||chr(10)||
'from wwv_flow_activity_log l'||chr(10)||
'where l.time_stamp>=(select sysdate - to_number('||chr(10)||
':F4050_P36_DAYS) x from dual )  ) tv'||chr(10)||
'from dual)'||chr(10)||
'select '||chr(10)||
'decode(upper(l.userid),null,'||chr(10)||
'  messages.login_page,''NOBODY'','||chr(10)||
'  messages.unauth_user,upper(l.userid))'||chr(10)||
'   user_name,'||chr(10)||
'lower(c.short_name) workspace,'||chr(10)||
' count(*) page_views, 100*count(*)/tv pct, round(300*count(*)/tv) graph, sum(num_rows) report_rows, count(distinct(ip_address)) ip_addresses, sum(elap) total_elapsed, avg(elap) average_elapsed'||chr(10)||
'from wwv_flow_activity_log l, wwv_flow_companies c, messages'||chr(10)||
'where l.security_group_id = c.provisioning_company_id (+)'||chr(10)||
'and l.time_stamp>=(select sysdate - to_number('||chr(10)||
':F4050_P36_DAYS) x from dual )  '||chr(10)||
'and (c.PROVISIONING_COMPANY_ID = :F4050_P36_COMPANY or :F4050_P36_COMPANY = 0)'||chr(10)||
'group by decode(upper(l.userid),null,'||chr(10)||
'  login_page,''NOBODY'','||chr(10)||
'  unauth_user,upper(l.userid)),'||chr(10)||
'  lower(c.short_name)');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 7636821388243091.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 7636510665243086.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'USER_NAME',
  p_column_display_sequence=> 2,
  p_column_heading=> 'Benutzername',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>3,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 7640317984273571.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 7636510665243086.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'WORKSPACE',
  p_column_display_sequence=> 1,
  p_column_heading=> 'Workspace',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>2,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 7636928194243092.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 7636510665243086.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 3,
  p_form_element_id=> null,
  p_column_alias=> 'PAGE_VIEWS',
  p_column_display_sequence=> 3,
  p_column_heading=> 'Seitenansichten',
  p_column_format=> '999G999G999G999G999G999G990',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'RIGHT',
  p_default_sort_column_sequence=>1,
  p_default_sort_dir=>'desc',
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 7642526903295033.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 7636510665243086.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 4,
  p_form_element_id=> null,
  p_column_alias=> 'PCT',
  p_column_display_sequence=> 4,
  p_column_heading=> 'Prozentsatz',
  p_column_format=> '999G999G999G999G990D00',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'Y',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 7677422289435613.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 7636510665243086.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 5,
  p_form_element_id=> null,
  p_column_alias=> 'REPORT_ROWS',
  p_column_display_sequence=> 6,
  p_column_heading=> 'Berichtszeilen',
  p_column_format=> '999G999G999G999G999G999G990',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'Y',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 7680928307446895.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 7636510665243086.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 6,
  p_form_element_id=> null,
  p_column_alias=> 'IP_ADDRESSES',
  p_column_display_sequence=> 7,
  p_column_heading=> 'IP-<br />Adressen',
  p_column_format=> '999G999G999G999G999G999G990',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'Y',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 7681912508451781.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 7636510665243086.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 7,
  p_form_element_id=> null,
  p_column_alias=> 'TOTAL_ELAPSED',
  p_column_display_sequence=> 8,
  p_column_heading=> 'Gesamt<br />verstrichen',
  p_column_format=> '999G999G999G999G990D00',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'Y',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 7682030057451781.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 7636510665243086.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 8,
  p_form_element_id=> null,
  p_column_alias=> 'AVERAGE_ELAPSED',
  p_column_display_sequence=> 9,
  p_column_heading=> 'Durchschnittlich<br />verstrichen',
  p_column_format=> '999G999G999G999G990D00',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 58048303097491041.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 7636510665243086.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 9,
  p_form_element_id=> null,
  p_column_alias=> 'DISTINCT_HOURS',
  p_column_display_sequence=> 10,
  p_column_heading=> 'Eindeutige<br />Stunden',
  p_column_format=> '999G999G999G999G999G999G990',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'RIGHT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 248797519246004353.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 7636510665243086.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 9,
  p_form_element_id=> null,
  p_column_alias=> 'DERIVED$01',
  p_column_display_sequence=> 5,
  p_column_heading=> 'Prozentsatz Seitenansichten',
  p_column_html_expression=>'<div style="width:300px;height:14px;background:#dddddd;border-top:1px solid #aaaaaa;border-left:1px solid #aaaaaa;border-bottom:1px solid #ffffff;border-right:1px solid #ffffff;">'||chr(10)||
'<img src="#IMAGE_PREFIX#1px_trans.gif" width="#PCT#%" height="14" border="0" style="background:#3f863f;"></div>',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'Y',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_derived_column=> 'Y',
  p_include_in_export=> 'Y',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 58049321451496359.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 7636510665243086.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 10,
  p_form_element_id=> null,
  p_column_alias=> 'DISTINCT_DAYS',
  p_column_display_sequence=> 11,
  p_column_heading=> 'Eindeutige<br />Tage',
  p_column_format=> '999G999G999G999G999G999G990',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'RIGHT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 190804631770512632.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 36.4053,
  p_plug_name=> 'Button Bar',
  p_region_name=>'',
  p_plug_template=> 107311831567346457.4053+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>138371731264766571.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 36.4053,
  p_branch_action=> 'f?p=&APP_ID.:36:&SESSION.::&DEBUG.:::',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Created 12-DEC-2007 21:11 by MIKE');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Wählen Sie die Anzahl der Zeilen, die angezeigt werden sollen, und klicken Sie anschließend auf <b>Los</b>.';

wwv_flow_api.create_page_item(
  p_id=>7649410328318622.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 36.4053,
  p_name=>'P36_ROWS',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 18,
  p_item_plug_id => 190804631770512632.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default => '15',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Anzeigen',
  p_source_type=> 'STATIC',
  p_display_as=> 'COMBOBOX',
  p_named_lov=> 'MAX_ROWS_D',
  p_lov => '.'||to_char(87730331399250507 + wwv_flow_api.g_id_offset)||'.',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 343399818250317904.4053+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Schränken Sie den Bericht auf einen bestimmten Zeitrahmen ein. Geben Sie die Dauer an, die für den Bericht berücksichtigt werden soll, und klicken Sie anschließend auf <b>Los</b>.<p />'||chr(10)||
'Wenn Sie 1 Tag auswählen, werden nur die letzten 24 Stunden angezeigt.  ';

wwv_flow_api.create_page_item(
  p_id=>78411482361787247.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 36.4053,
  p_name=>'F4050_P36_DAYS',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 190804631770512632.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default => 'to_number(.000694444)',
  p_item_default_type => 'PLSQL_EXPRESSION',
  p_prompt=>'Seit',
  p_source_type=> 'STATIC',
  p_display_as=> 'COMBOBOX',
  p_named_lov=> 'RECENT_TIME',
  p_lov => 'select ''10 ''||wwv_flow_lang.system_message(initcap(''SECONDS'')) d, 10/(24*60*60) t from dual union all'||chr(10)||
'select ''1 ''||wwv_flow_lang.system_message(initcap(''MINUTE'')) d, 1/(24*60) t from dual union all'||chr(10)||
'select ''5 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 5/(24*60) t from dual union all'||chr(10)||
'select ''15 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 15/(24*60) t from dual union all'||chr(10)||
'select ''30 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 30/(24*60) t from dual union all'||chr(10)||
'select ''1 ''||wwv_flow_lang.system_message(initcap(''HOUR'')) d, 1/24 t from dual union all'||chr(10)||
'select ''2 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 1/12  t from dual union all'||chr(10)||
'select ''6 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 6/24 t from dual union all'||chr(10)||
'select ''8 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 8/24 t from dual union all'||chr(10)||
'select ''1 ''||wwv_flow_lang.system_message(initcap(''DAY'')) d, 1 t from dual union all'||chr(10)||
'select ''2 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 2 t from dual union all'||chr(10)||
'select ''1 ''||wwv_flow_lang.system_message(initcap(''WEEK'')) d, 7 t  from dual union all'||chr(10)||
'select ''2 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 14 t  from dual union all'||chr(10)||
'select ''4 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 28 t from dual union all'||chr(10)||
'select ''1 ''||wwv_flow_lang.system_message(initcap(''YEAR'')) d, 365 t from dual order by 2',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 343399818250317904.4053+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>78416586194793694.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 36.4053,
  p_name=>'P36_GO',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 20,
  p_item_plug_id => 190804631770512632.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default => 'GO',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Los',
  p_source=>'GO',
  p_source_type=> 'STATIC',
  p_display_as=> 'BUTTON',
  p_lov_columns=> null,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'LEFT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>78541219898279373.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 36.4053,
  p_name=>'F4050_P36_ROWS',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 15,
  p_item_plug_id => 190804631770512632.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default => '50',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Rows',
  p_source=>'50',
  p_source_type=> 'STATIC',
  p_display_as=> 'HIDDEN',
  p_named_lov=> 'MAX_ROWS_F',
  p_lov => '.'||to_char(87736221141257059 + wwv_flow_api.g_id_offset)||'.',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 343399818250317904.4053+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Um nach Workspace zu filtern, wählen Sie einen Workspace und klicken anschließend auf <b>Los</b>. Um Ergebnisse aus allen Workspaces zurückzugeben, wählen Sie <b>Alle Workspaces anzeigen</b>.';

wwv_flow_api.create_page_item(
  p_id=>193027223918115371.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 36.4053,
  p_name=>'F4050_P36_COMPANY',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 5,
  p_item_plug_id => 190804631770512632.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default => '0',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Workspace',
  p_source_type=> 'STATIC',
  p_display_as=> 'POPUP_KEY_LOV',
  p_named_lov=> 'LIST_ALL_COMPANIES',
  p_lov => 'select ''- ''||'||chr(10)||
'wwv_flow_lang.system_message(''F4050_SHOW_ALL_WORKSPACES'')||'||chr(10)||
''' -'' d, 0 r from dual union all'||chr(10)||
'select short_name||'' (''||PROVISIONING_COMPANY_ID||'')'' d,'||chr(10)||
'       PROVISIONING_COMPANY_ID r'||chr(10)||
'from   WWV_FLOW_COMPANIES'||chr(10)||
'where  provisioning_company_id > 0'||chr(10)||
'order by 1',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 40,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_cattributes_element=>'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 343399818250317904.4053+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'reset_pagination';

wwv_flow_api.create_page_process(
  p_id     => 138372404383768262.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 36.4053,
  p_process_sequence=> 10,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'RESET_PAGINATION',
  p_process_name=> 'Reset Pagination',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_when_button_id=>78416586194793694.4053 + wwv_flow_api.g_id_offset,
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 36.4053
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_37.40
prompt  ...PAGE 37.4053: Seitenansichten pro Tag pro Anwendung und Benutzer
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEADM/adm_activity.htm';

ph := null;
wwv_flow_api.create_page(
  p_id     => 37.4053,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'Seitenansichten pro Tag pro Anwendung und Benutzer',
  p_step_title=> 'Seitenansichten pro Tag pro Anwendung und Benutzer',
  p_step_sub_title => 'Calendar of Page Views',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'AUTO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 216662902659587159+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => '',
  p_step_template => 12930201930057128.4053+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409160255',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>37.4053,p_text=>h);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 4760431789009756.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 37.4053,
  p_plug_name=> 'Menu',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(4585800473139662 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 4589126493175495.4053+ wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'select trunc(TIME_STAMP) ts, '||chr(10)||
'       ''<span class="instructiontext">''||'||chr(10)||
'       wwv_flow_lang.system_message(''views'')||'':''||'||chr(10)||
'             to_char(count(*),''999,999,999,999,990'') ||''<br />''||'||chr(10)||
'       wwv_flow_lang.system_message(''users'')||'':''||'||chr(10)||
'             count(distinct upper(USERID))   ||''<br />''||'||chr(10)||
'       wwv_flow_lang.system_message(''applications'')||'':''||'||chr(10)||
'             count(distinct flow_id)  ||''';

s:=s||'<br />''||'||chr(10)||
'       wwv_flow_lang.system_message(''pages'')||'':''||'||chr(10)||
'             count(distinct step_id)||''</span>'' display'||chr(10)||
'    from   WWV_FLOW_ACTIVITY_LOG'||chr(10)||
'group by trunc(time_stamp)';

wwv_flow_api.create_calendar (
  p_id=> 291645413029240107.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 37.4053,
  p_plug_name=> 'Calendar of Page Views',
  p_region_name=>'',
  p_plug_source=> s,
  p_plug_source_type  => 'CALENDAR',
  p_plug_template=> 0,
  p_plug_display_sequence=> 30,
  p_plug_display_column  => 1,
  p_plug_display_point   => 'AFTER_SHOW_ITEMS',
  p_plug_display_error_message=> '',
  p_plug_display_condition_type => '',
  p_plug_display_when_condition => '',
  p_plug_display_when_cond2=>'',
  p_plug_caching => 'NOT_CACHED',
  p_plug_header=> '',
  p_plug_footer=> '',
  p_plug_override_reg_pos=>'',
  p_plug_customized=>'0',
  p_plug_customized_name=>'',
  p_translate_title=>'',
  p_plug_comment=> '',
  p_cal_id=>291645601238240116.4053 + wwv_flow_api.g_id_offset,
  p_start_date=>'',
  p_end_date=>'',
  p_begin_at_start_of_interval=>'Y',
  p_date_item=>'P37_CALENDAR_DATE',
  p_display_as=>'M',
  p_display_item=>'P37_CALENDAR_DISPLAY',
  p_display_type=>'COL',
  p_item_format=>'',
  p_easy_sql_owner=>'',
  p_easy_sql_table=>'',
  p_date_column=>'TS',
  p_display_column=>'DISPLAY',
  p_start_of_week=>'',
  p_day_link=>'',
  p_item_link=>'',
  p_start_time=>'',
  p_end_time=>'',
  p_time_format=>'',
  p_week_start_day=>'',
  p_week_end_day=>'',
  p_date_type_column=>'',
  p_template_id=>291623505663181263.4053 + wwv_flow_api.g_id_offset,
  p_calendar_comments=>'');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 291645904273240125.4053 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 37.4053,
  p_button_sequence=> 30,
  p_button_plug_id => 291645413029240107+wwv_flow_api.g_id_offset,
  p_button_name    => 'Previous',
  p_button_image_alt=> 'Zurück',
  p_button_position=> 'TOP',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 291646113484240158.4053 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 37.4053,
  p_button_sequence=> 30,
  p_button_plug_id => 291645413029240107+wwv_flow_api.g_id_offset,
  p_button_name    => 'Today',
  p_button_image_alt=> 'Heute',
  p_button_position=> 'TOP',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 291646311615240158.4053 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 37.4053,
  p_button_sequence=> 30,
  p_button_plug_id => 291645413029240107+wwv_flow_api.g_id_offset,
  p_button_name    => 'Next',
  p_button_image_alt=> 'Weiter',
  p_button_position=> 'TOP',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>291646529995240159.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 37.4053,
  p_branch_action=> 'f?p=&FLOW_ID.:37:&SESSION.',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>291645819139240122.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 37.4053,
  p_name=>'P37_CALENDAR_DATE',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 291645413029240107.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> '',
  p_item_default => 'return to_char(sysdate,''YYYYMMDD'');',
  p_item_default_type => 'PLSQL_FUNCTION_BODY',
  p_prompt=>'P37_CALENDAR_DATE',
  p_display_as=> 'HIDDEN',
  p_lov_columns=> null,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> null,
  p_cHeight=> null,
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'LEFT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'Y',
  p_item_comment => 'Generated by Calendar wizard on 06-AUG-04');
 
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||' wwv_flow_utilities.decrement_calendar;';

wwv_flow_api.create_page_process(
  p_id     => 291646014277240138.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 37.4053,
  p_process_sequence=> 10,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'Adjust Calendar Date -Previous',
  p_process_sql_clob => p, 
  p_process_error_message=> 'Fehler beim Ändern von Kalenderdatum.',
  p_process_when_button_id=>291645904273240125.4053 + wwv_flow_api.g_id_offset,
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'Generated 06-AUG-04');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||' wwv_flow_utilities.today_calendar;';

wwv_flow_api.create_page_process(
  p_id     => 291646229414240158.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 37.4053,
  p_process_sequence=> 10,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'Adjust Calendar Date -Today',
  p_process_sql_clob => p, 
  p_process_error_message=> 'Fehler beim Ändern von Kalenderdatum.',
  p_process_when_button_id=>291646113484240158.4053 + wwv_flow_api.g_id_offset,
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'Generated 06-AUG-04');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||' wwv_flow_utilities.increment_calendar;';

wwv_flow_api.create_page_process(
  p_id     => 291646406278240158.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 37.4053,
  p_process_sequence=> 10,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'Adjust Calendar Date -Next',
  p_process_sql_clob => p, 
  p_process_error_message=> 'Fehler beim Ändern von Kalenderdatum.',
  p_process_when_button_id=>291646311615240158.4053 + wwv_flow_api.g_id_offset,
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'Generated 06-AUG-04');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 37.4053
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_38.40
prompt  ...PAGE 38.4053: Seitenansichten pro Benutzer-Agent
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEADM/adm_activity.htm';

ph := null;
wwv_flow_api.create_page(
  p_id     => 38.4053,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'Seitenansichten pro Benutzer-Agent',
  p_step_title=> 'Seitenansichten pro Benutzer-Agent',
  p_step_sub_title => 'Browsers',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'AUTO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 216662902659587159+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => '',
  p_step_template => 12930201930057128.4053+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409160255',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>38.4053,p_text=>h);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 4645611583369955.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 38.4053,
  p_plug_name=> 'Menu',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(4585800473139662 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 4589126493175495.4053+ wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'with total_views as ('||chr(10)||
'select count(*) tv from wwv_flow_activity_log where :P38_SEARCH is null or instr(upper(user_agent),upper(:P38_SEARCH))>0)'||chr(10)||
'select user_agent, count(distinct ip_address) ip_addresses, sum(the_count) page_views, 100*sum(the_count)/max(tv) pct, round(300*sum(the_count)/max(tv)) graph'||chr(10)||
'  from'||chr(10)||
'   (select session_id, max(nvl(user_agent,'' Unknown'')) user_agent, count(*) the_count,max(';

s:=s||'ip_address) ip_address'||chr(10)||
'      from wwv_flow_activity_log'||chr(10)||
'where  time_stamp >= (select sysdate - to_number(:p38_include) x from dual)'||chr(10)||
'and (:P38_SEARCH is null or instr(upper(user_agent),upper(:P38_SEARCH))>0)'||chr(10)||
'     group by session_id) l,'||chr(10)||
'total_views'||chr(10)||
' group by user_agent';

wwv_flow_api.create_report_region (
  p_id=> 7598527877115551.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 38.4053,
  p_name=> 'Page Views by User Agent',
  p_region_name=>'',
  p_template=> 0+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 50,
  p_display_column=> 1,
  p_display_point=> 'AFTER_SHOW_ITEMS',
  p_source=> s,
  p_source_type=> 'SQL_QUERY',
  p_display_error_message=> '#SQLERRM#',
  p_plug_caching=> 'NOT_CACHED',
  p_customized=> '0',
  p_query_row_template=> 6897002870390711.4053+ wwv_flow_api.g_id_offset,
  p_query_headings_type=> 'COLON_DELMITED_LIST',
  p_query_num_rows=> '15',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_show_nulls_as=> ' - ',
  p_query_break_cols=> '0',
  p_query_no_data_found=> 'Keine Daten gefunden.',
  p_query_num_rows_item=> 'P38_ROWS',
  p_query_num_rows_type=> 'NEXT_PREVIOUS_LINKS',
  p_query_row_count_max=> '50000',
  p_pagination_display_position=> 'BOTTOM_RIGHT',
  p_csv_output=> 'Y',
  p_csv_output_link_text=> 'Herunterladen',
  p_prn_output=> 'Y',
  p_prn_format=> 'PDF',
  p_prn_output_show_link=> 'Y',
  p_prn_output_link_text=> 'Drucken',
  p_prn_units=> 'INCHES',
  p_prn_paper_size=> 'LETTER',
  p_prn_width=> 11,
  p_prn_height=> 8.5,
  p_prn_orientation=> 'HORIZONTAL',
  p_prn_page_header=> '&PRODUCT_NAME.',
  p_prn_page_header_font_color=> '#000000',
  p_prn_page_header_font_family=> 'Helvetica',
  p_prn_page_header_font_weight=> 'normal',
  p_prn_page_header_font_size=> '12',
  p_prn_page_footer_font_color=> '#000000',
  p_prn_page_footer_font_family=> 'Helvetica',
  p_prn_page_footer_font_weight=> 'normal',
  p_prn_page_footer_font_size=> '12',
  p_prn_header_bg_color=> '#9bafde',
  p_prn_header_font_color=> '#ffffff',
  p_prn_header_font_family=> 'Helvetica',
  p_prn_header_font_weight=> 'normal',
  p_prn_header_font_size=> '10',
  p_prn_body_bg_color=> '#efefef',
  p_prn_body_font_color=> '#000000',
  p_prn_body_font_family=> 'Helvetica',
  p_prn_body_font_weight=> 'normal',
  p_prn_body_font_size=> '10',
  p_prn_border_width=> .5,
  p_query_asc_image=> 'arrow_down_gray_dark.gif',
  p_query_asc_image_attr=> 'width="13" height="12"',
  p_query_desc_image=> 'arrow_up_gray_dark.gif',
  p_query_desc_image_attr=> 'width="13" height="12"',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 7598801442115555.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 7598527877115551.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'USER_AGENT',
  p_column_display_sequence=> 1,
  p_column_heading=> 'Benutzer-Agent',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>2,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_print_col_width=> '70',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 7598920151115555.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 7598527877115551.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'IP_ADDRESSES',
  p_column_display_sequence=> 2,
  p_column_heading=> 'IP-Adressen',
  p_column_format=> '999G999G999G999G999G999G990',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'Y',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_print_col_width=> '10',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 7599005653115555.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 7598527877115551.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 3,
  p_form_element_id=> null,
  p_column_alias=> 'PAGE_VIEWS',
  p_column_display_sequence=> 3,
  p_column_heading=> 'Seitenansichten',
  p_column_format=> '999G999G999G999G999G999G990',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>1,
  p_default_sort_dir=>'desc',
  p_disable_sort_column=>'N',
  p_sum_column=> 'Y',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_print_col_width=> '10',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 7607614203149434.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 7598527877115551.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 4,
  p_form_element_id=> null,
  p_column_alias=> 'PCT',
  p_column_display_sequence=> 4,
  p_column_heading=> 'Prozentsatz',
  p_column_format=> '999G999G999G999G990D00',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'Y',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_print_col_width=> '10',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 7607726638149434.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 7598527877115551.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 5,
  p_form_element_id=> null,
  p_column_alias=> 'GRAPH',
  p_column_display_sequence=> 5,
  p_column_heading=> '&nbsp;',
  p_column_html_expression=>'<div style="width:300px;height:14px;background:#dddddd;border-top:1px solid #aaaaaa;border-left:1px solid #aaaaaa;border-bottom:1px solid #ffffff;border-right:1px solid #ffffff;">'||chr(10)||
'<img src="#IMAGE_PREFIX#1px_trans.gif" width="#GRAPH#" height="14" border="0" style="background:#3f863f;"></div>',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'N',
  p_print_col_width=> '0',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 7600207230119070.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 38.4053,
  p_plug_name=> 'Button Bar',
  p_region_name=>'',
  p_plug_template=> 107311831567346457.4053+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>81196032551905007.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 38.4053,
  p_branch_action=> '38',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'BRANCH_TO_STEP',
  p_branch_sequence=> 99,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Generated 10-AUG-2001 12:39:10');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Schränken Sie den Bericht auf einen bestimmten Zeitrahmen ein. Geben Sie die Dauer an, die für den Bericht berücksichtigt werden soll, und klicken Sie anschließend auf <b>Los</b>.<p />'||chr(10)||
'Wenn Sie 1 Tag auswählen, werden nur die letzten 24 Stunden angezeigt.  ';

wwv_flow_api.create_page_item(
  p_id=>7601517273121938.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 38.4053,
  p_name=>'P38_INCLUDE',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 7600207230119070.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default => '1',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Aufnehmen',
  p_source=>'1',
  p_source_type=> 'STATIC',
  p_display_as=> 'COMBOBOX',
  p_named_lov=> 'RECENT_TIME',
  p_lov => 'select ''10 ''||wwv_flow_lang.system_message(initcap(''SECONDS'')) d, 10/(24*60*60) t from dual union all'||chr(10)||
'select ''1 ''||wwv_flow_lang.system_message(initcap(''MINUTE'')) d, 1/(24*60) t from dual union all'||chr(10)||
'select ''5 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 5/(24*60) t from dual union all'||chr(10)||
'select ''15 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 15/(24*60) t from dual union all'||chr(10)||
'select ''30 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 30/(24*60) t from dual union all'||chr(10)||
'select ''1 ''||wwv_flow_lang.system_message(initcap(''HOUR'')) d, 1/24 t from dual union all'||chr(10)||
'select ''2 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 1/12  t from dual union all'||chr(10)||
'select ''6 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 6/24 t from dual union all'||chr(10)||
'select ''8 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 8/24 t from dual union all'||chr(10)||
'select ''1 ''||wwv_flow_lang.system_message(initcap(''DAY'')) d, 1 t from dual union all'||chr(10)||
'select ''2 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 2 t from dual union all'||chr(10)||
'select ''1 ''||wwv_flow_lang.system_message(initcap(''WEEK'')) d, 7 t  from dual union all'||chr(10)||
'select ''2 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 14 t  from dual union all'||chr(10)||
'select ''4 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 28 t from dual union all'||chr(10)||
'select ''1 ''||wwv_flow_lang.system_message(initcap(''YEAR'')) d, 365 t from dual order by 2',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 343399818250317904.4053+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Wählen Sie die Anzahl der Zeilen, die angezeigt werden sollen, und klicken Sie anschließend auf <b>Los</b>.';

wwv_flow_api.create_page_item(
  p_id=>7602421428123133.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 38.4053,
  p_name=>'P38_ROWS',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 20,
  p_item_plug_id => 7600207230119070.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default => '15',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Anzeigen',
  p_source_type=> 'STATIC',
  p_display_as=> 'COMBOBOX',
  p_named_lov=> 'MAX_ROWS_D',
  p_lov => '.'||to_char(87730331399250507 + wwv_flow_api.g_id_offset)||'.',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 343399818250317904.4053+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>7603526623124696.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 38.4053,
  p_name=>'P38_GO',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 30,
  p_item_plug_id => 7600207230119070.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default => 'GO',
  p_prompt=>'Los',
  p_source=>'GO',
  p_source_type=> 'STATIC',
  p_display_as=> 'BUTTON',
  p_lov_columns=> null,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> 2000,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'LEFT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Geben Sie Abfragekriterien ohne Berücksichtigung der Groß-/Kleinschreibung ein, und klicken Sie anschließend auf <b>Los</b>.';

wwv_flow_api.create_page_item(
  p_id=>92476023253515802.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 38.4053,
  p_name=>'P38_SEARCH',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 4,
  p_item_plug_id => 7600207230119070.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Suche',
  p_source_type=> 'STATIC',
  p_display_as=> 'TEXT',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 343399818250317904.4053+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 38.4053
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_42.40
prompt  ...PAGE 42.4053: Öffentliches Theme bearbeiten
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEADM/adm_themes_public.htm';

ph:=ph||'<script language="JavaScript" type="text/javascript">'||chr(10)||
'<!--'||chr(10)||
''||chr(10)||
' htmldb_delete_message=''"DELETE_CONFIRM_MSG"'';'||chr(10)||
''||chr(10)||
'//-->'||chr(10)||
'</script>';

wwv_flow_api.create_page(
  p_id     => 42.4053,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'Öffentliches Theme bearbeiten',
  p_step_title=> 'Öffentliches Theme bearbeiten',
  p_step_sub_title => 'Edit Workspace Theme',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'NO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_help_text => ' ',
  p_html_page_header => ' ',
  p_step_template => '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409160255',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>42.4053,p_text=>h);
wwv_flow_api.set_html_page_header(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>42.4053,p_text=>ph);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 138031028642631493.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 42.4053,
  p_plug_name=> 'Öffentliches Theme',
  p_region_name=>'',
  p_plug_template=> 2424107150426143.4053+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 10,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 138031232143631493.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 42.4053,
  p_plug_name=> 'Edit Public Theme',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(4585800473139662 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 4589126493175495.4053+ wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 138032120818631497.4053 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 42.4053,
  p_button_sequence=> 30,
  p_button_plug_id => 138031028642631493+wwv_flow_api.g_id_offset,
  p_button_name    => 'SAVE',
  p_button_image_alt=> 'Änderungen anwenden',
  p_button_position=> 'REGION_TEMPLATE_CHANGE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_button_condition=> 'P42_ID',
  p_button_condition_type=> 'ITEM_IS_NOT_NULL',
  p_database_action=>'UPDATE',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 138031725433631494.4053 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 42.4053,
  p_button_sequence=> 10,
  p_button_plug_id => 138031028642631493+wwv_flow_api.g_id_offset,
  p_button_name    => 'CANCEL',
  p_button_image_alt=> 'Abbrechen',
  p_button_position=> 'REGION_TEMPLATE_CLOSE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=&APP_ID.:555:&SESSION.::&DEBUG.:::',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 138031909392631497.4053 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 42.4053,
  p_button_sequence=> 20,
  p_button_plug_id => 138031028642631493+wwv_flow_api.g_id_offset,
  p_button_name    => 'DELETE',
  p_button_image_alt=> 'Löschen',
  p_button_position=> 'REGION_TEMPLATE_DELETE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'javascript:confirmDelete(htmldb_delete_message,''DELETE'');',
  p_button_condition=> 'P42_ID',
  p_button_condition_type=> 'ITEM_IS_NOT_NULL',
  p_database_action=>'DELETE',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>138035131295631504.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 42.4053,
  p_branch_action=> 'f?p=&APP_ID.:555:&SESSION.::&DEBUG.:::&success_msg=#SUCCESS_MSG#',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_sequence=> 1,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>138032320063631498.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 42.4053,
  p_name=>'P42_ID',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 1,
  p_item_plug_id => 138031028642631493.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_prompt=>'Id',
  p_source=>'ID',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'HIDDEN_PROTECTED',
  p_lov_columns=> null,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 255,
  p_cHeight=> null,
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 148842116797733609.4053+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Die Nummer identifiziert ein Theme in einem Workspace eindeutig. Sie müssen einen Wert größer als 100 eingeben.';

wwv_flow_api.create_page_item(
  p_id=>138032507109631498.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 42.4053,
  p_name=>'P42_THEME_ID',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 30,
  p_item_plug_id => 138031028642631493.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Nummer',
  p_source=>'THEME_ID',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'TEXT',
  p_lov_columns=> null,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 255,
  p_cHeight=> 1,
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 111844628719872228.4053+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Identifiziert das Workspace Theme.';

wwv_flow_api.create_page_item(
  p_id=>138033017002631498.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 42.4053,
  p_name=>'P42_THEME_NAME',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 50,
  p_item_plug_id => 138031028642631493.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Name',
  p_source=>'THEME_NAME',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'TEXT',
  p_lov_columns=> null,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 255,
  p_cHeight=> 1,
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 111844628719872228.4053+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Eine kurze Beschreibung des Themes.';

wwv_flow_api.create_page_item(
  p_id=>138033530776631499.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 42.4053,
  p_name=>'P42_THEME_DESCRIPTION',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 320,
  p_item_plug_id => 138031028642631493.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Beschreibung',
  p_source=>'THEME_DESCRIPTION',
  p_source_type=> 'DB_COLUMN',
  p_display_as=> 'TEXTAREA',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 60,
  p_cMaxlength=> 4000,
  p_cHeight=> 4,
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 2,
  p_rowspan => 1,
  p_label_alignment  => 'ABOVE',
  p_field_alignment  => 'LEFT',
  p_field_template => 148842116797733609.4053+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 138034118219631500.4053 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 42.4053,
  p_validation_name => 'P42_THEME_ID not null',
  p_validation_sequence=> 30,
  p_validation => 'P42_THEME_ID',
  p_validation_type => 'ITEM_NOT_NULL',
  p_error_message => 'Für "Theme-Nummer" muss ein Wert angegeben werden.',
  p_associated_item=> 138032507109631498.4053 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 138034321549631503.4053 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 42.4053,
  p_validation_name => 'P42_THEME_NAME not null',
  p_validation_sequence=> 50,
  p_validation => 'P42_THEME_NAME',
  p_validation_type => 'ITEM_NOT_NULL',
  p_error_message => 'Für "Theme-Name" muss ein Wert angegeben werden.',
  p_associated_item=> 138033017002631498.4053 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'F|#OWNER#:WWV_FLOW_THEMES:P42_ID:ID';

wwv_flow_api.create_page_process(
  p_id     => 138034819862631504.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 42.4053,
  p_process_sequence=> 10,
  p_process_point=> 'AFTER_HEADER',
  p_process_type=> 'DML_FETCH_ROW',
  p_process_name=> 'Fetch Row from WWV_FLOW_THEMES',
  p_process_sql_clob => p, 
  p_process_error_message=> 'Abrufen von Zeile nicht möglich.',
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'wwv_flow_theme_manager.change_public_theme ('||chr(10)||
'   p_id           => :P42_ID,'||chr(10)||
'   p_theme_name   => :P42_THEME_NAME,'||chr(10)||
'   p_theme_number => :P42_THEME_ID,'||chr(10)||
'   p_theme_desc   => :P42_THEME_DESCRIPTION);';

wwv_flow_api.create_page_process(
  p_id     => 138034431628631503.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 42.4053,
  p_process_sequence=> 10,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'apply changes',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_when_button_id=>138032120818631497.4053 + wwv_flow_api.g_id_offset,
  p_process_success_message=> 'Aktion wurde verarbeitet',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'wwv_flow_theme_manager.delete_public_theme ('||chr(10)||
'p_id=>:P42_ID);';

wwv_flow_api.create_page_process(
  p_id     => 138034606078631504.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 42.4053,
  p_process_sequence=> 20,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'PLSQL',
  p_process_name=> 'delete theme',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_when_button_id=>138031909392631497.4053 + wwv_flow_api.g_id_offset,
  p_process_success_message=> 'Aktion wurde verarbeitet',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 42.4053
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_43.40
prompt  ...PAGE 43.4053: Anwendungsänderungen pro Entwickler
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEADM/adm_activity.htm';

ph := null;
wwv_flow_api.create_page(
  p_id     => 43.4053,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'Anwendungsänderungen pro Entwickler',
  p_step_title=> 'Anwendungsänderungen pro Entwickler',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'NO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 216662902659587159+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => '',
  p_step_template => 12930201930057128.4053+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409160255',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>43.4053,p_text=>h);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 4770703916039472.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 43.4053,
  p_plug_name=> 'Menu',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(4585800473139662 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 4589126493175495.4053+ wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'select '||chr(10)||
'a.flow_user uu, '||chr(10)||
'c.short_name,                            '||chr(10)||
'count(*) c ,'||chr(10)||
'min(a.audit_date) first_change,'||chr(10)||
'max(a.audit_date) last_change,'||chr(10)||
'count(distinct FLOW_ID) applications,'||chr(10)||
'count(distinct page_id) pages,'||chr(10)||
'count(distinct FLOW_TABLE) components'||chr(10)||
'from '||chr(10)||
'   wwv_flow_builder_audit_trail a, '||chr(10)||
'   wwv_flow_companies c '||chr(10)||
'where '||chr(10)||
'  c.provisioning_company_id = a.security_group_id '||chr(10)||
'  and a.AUDIT_DATE > (sel';

s:=s||'ect sysdate - :F4050_P43_TIME_FILTER x from dual)'||chr(10)||
'  and (:F4050_P43_COMPANY is null or :F4050_P43_COMPANY = 0 or a.security_group_id = :F4050_P43_COMPANY ) '||chr(10)||
'group by a.flow_user ,c.short_name';

wwv_flow_api.create_report_region (
  p_id=> 133956016915800050.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 43.4053,
  p_name=> 'Application Changes by Workspace and Developer',
  p_region_name=>'',
  p_template=> 0+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 10,
  p_display_column=> 1,
  p_display_point=> 'REGION_POSITION_02',
  p_source=> s,
  p_source_type=> 'SQL_QUERY',
  p_display_error_message=> '#SQLERRM#',
  p_plug_caching=> 'NOT_CACHED',
  p_customized=> '0',
  p_ajax_enabled=> 'N',
  p_query_row_template=> 6897002870390711.4053+ wwv_flow_api.g_id_offset,
  p_query_headings_type=> 'COLON_DELMITED_LIST',
  p_query_num_rows=> '15',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_break_cols=> '0',
  p_query_num_rows_item=> 'P43_ROWS',
  p_query_num_rows_type=> 'NEXT_PREVIOUS_LINKS',
  p_query_row_count_max=> '500',
  p_pagination_display_position=> 'BOTTOM_RIGHT',
  p_csv_output=> 'Y',
  p_csv_output_link_text=> 'Herunterladen',
  p_prn_output=> 'Y',
  p_prn_format=> 'PDF',
  p_prn_output_show_link=> 'Y',
  p_prn_output_link_text=> 'Drucken',
  p_prn_units=> 'INCHES',
  p_prn_paper_size=> 'LETTER',
  p_prn_width=> 11,
  p_prn_height=> 8.5,
  p_prn_orientation=> 'HORIZONTAL',
  p_prn_page_header=> '&PRODUCT_NAME.',
  p_prn_page_header_font_color=> '#000000',
  p_prn_page_header_font_family=> 'Helvetica',
  p_prn_page_header_font_weight=> 'normal',
  p_prn_page_header_font_size=> '12',
  p_prn_page_footer_font_color=> '#000000',
  p_prn_page_footer_font_family=> 'Helvetica',
  p_prn_page_footer_font_weight=> 'normal',
  p_prn_page_footer_font_size=> '12',
  p_prn_header_bg_color=> '#9bafde',
  p_prn_header_font_color=> '#ffffff',
  p_prn_header_font_family=> 'Helvetica',
  p_prn_header_font_weight=> 'normal',
  p_prn_header_font_size=> '10',
  p_prn_body_bg_color=> '#efefef',
  p_prn_body_font_color=> '#000000',
  p_prn_body_font_family=> 'Helvetica',
  p_prn_body_font_weight=> 'normal',
  p_prn_body_font_size=> '10',
  p_prn_border_width=> .5,
  p_query_asc_image=> 'arrow_down_gray_dark.gif',
  p_query_asc_image_attr=> 'width="13" height="12"',
  p_query_desc_image=> 'arrow_up_gray_dark.gif',
  p_query_desc_image_attr=> 'width="13" height="12"',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 49064304767444446.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 133956016915800050.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'UU',
  p_column_display_sequence=> 2,
  p_column_heading=> 'Benutzer',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>2,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_include_in_export=> 'Y',
  p_print_col_width=> '12',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 49064412822444446.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 133956016915800050.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'SHORT_NAME',
  p_column_display_sequence=> 1,
  p_column_heading=> 'Workspace',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>1,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_include_in_export=> 'Y',
  p_print_col_width=> '12',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 49064522788444446.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 133956016915800050.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 3,
  p_form_element_id=> null,
  p_column_alias=> 'C',
  p_column_display_sequence=> 3,
  p_column_heading=> 'Anzahl',
  p_column_format=> '999G999G999G999G999G999G990',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'RIGHT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_print_col_width=> '12',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 49070919790458211.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 133956016915800050.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 4,
  p_form_element_id=> null,
  p_column_alias=> 'FIRST_CHANGE',
  p_column_display_sequence=> 4,
  p_column_heading=> 'Erste Änderung',
  p_column_format=> 'SINCE',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'RIGHT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_print_col_width=> '12',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 49071015829458212.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 133956016915800050.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 5,
  p_form_element_id=> null,
  p_column_alias=> 'LAST_CHANGE',
  p_column_display_sequence=> 5,
  p_column_heading=> 'Letzte Änderung',
  p_column_format=> 'SINCE',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'RIGHT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_print_col_width=> '12',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 49073914726466256.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 133956016915800050.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 6,
  p_form_element_id=> null,
  p_column_alias=> 'APPLICATIONS',
  p_column_display_sequence=> 6,
  p_column_heading=> 'Anwendungen',
  p_column_format=> '999G999G999G999G999G999G990',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'RIGHT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_print_col_width=> '12',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 49074031344466256.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 133956016915800050.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 7,
  p_form_element_id=> null,
  p_column_alias=> 'PAGES',
  p_column_display_sequence=> 7,
  p_column_heading=> 'Seiten',
  p_column_format=> '999G999G999G999G999G999G990',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_print_col_width=> '12',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 49075707585473603.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 133956016915800050.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 8,
  p_form_element_id=> null,
  p_column_alias=> 'COMPONENTS',
  p_column_display_sequence=> 8,
  p_column_heading=> 'Komponenten',
  p_column_format=> '999G999G999G999G999G999G990',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'RIGHT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_print_col_width=> '12',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 133959431567808445.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 43.4053,
  p_plug_name=> 'Button Bar',
  p_region_name=>'',
  p_plug_template=> 107311831567346457.4053+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_02',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings => 'blue_arrow_down.gif::blue_arrow_up.gif:|3,3,4\1,2|'||chr(10)||
''||chr(10)||
'&nbsp;:'||chr(10)||
''||chr(10)||
'<font class="nounderline" color="black">CompanyShortName</font>:'||chr(10)||
''||chr(10)||
'<font class="nounderline" color="green">Users</font>:'||chr(10)||
''||chr(10)||
'<font class="nounderline" color="green">Developers</font>:'||chr(10)||
''||chr(10)||
'<font class="nounderline" color="green">Flows</font>:<font color=green>ProvStatus</font>:'||chr(10)||
''||chr(10)||
'<font class="nounderline" color="black">CompanyID</font>:',
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_num_rows => 25,
  p_plug_query_num_rows_item => 'F4050_P1_ROWS',
  p_plug_query_num_rows_type => 'ROWS_X_TO_Y_OF_Z',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_query_show_nulls_as => '(null)',
  p_plug_query_col_allignments => 'L:L:L:L:R:R:R:L',
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>138328232510331757.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 43.4053,
  p_branch_action=> 'f?p=&APP_ID.:43:&SESSION.::&DEBUG.:::',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Created 12-DEC-2007 19:59 by MIKE');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Wählen Sie die Anzahl der Zeilen, die angezeigt werden sollen, und klicken Sie anschließend auf <b>Los</b>.';

wwv_flow_api.create_page_item(
  p_id=>108265702066807320.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 43.4053,
  p_name=>'P43_ROWS',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 15,
  p_item_plug_id => 133959431567808445.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default => '15',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Anzeigen',
  p_source_type=> 'STATIC',
  p_display_as=> 'COMBOBOX',
  p_named_lov=> 'MAX_ROWS_D',
  p_lov => '.'||to_char(87730331399250507 + wwv_flow_api.g_id_offset)||'.',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 343399818250317904.4053+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Schränken Sie den Bericht auf einen bestimmten Zeitrahmen ein. Geben Sie die Dauer an, die für den Bericht berücksichtigt werden soll, und klicken Sie anschließend auf <b>Los</b>.<p />'||chr(10)||
'Wenn Sie 1 Tag auswählen, werden nur die letzten 24 Stunden angezeigt.  ';

wwv_flow_api.create_page_item(
  p_id=>133964907629819539.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 43.4053,
  p_name=>'F4050_P43_TIME_FILTER',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 133959431567808445.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Seit',
  p_source=>'1',
  p_source_type=> 'STATIC',
  p_display_as=> 'COMBOBOX',
  p_named_lov=> 'RECENT_TIME',
  p_lov => 'select ''10 ''||wwv_flow_lang.system_message(initcap(''SECONDS'')) d, 10/(24*60*60) t from dual union all'||chr(10)||
'select ''1 ''||wwv_flow_lang.system_message(initcap(''MINUTE'')) d, 1/(24*60) t from dual union all'||chr(10)||
'select ''5 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 5/(24*60) t from dual union all'||chr(10)||
'select ''15 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 15/(24*60) t from dual union all'||chr(10)||
'select ''30 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 30/(24*60) t from dual union all'||chr(10)||
'select ''1 ''||wwv_flow_lang.system_message(initcap(''HOUR'')) d, 1/24 t from dual union all'||chr(10)||
'select ''2 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 1/12  t from dual union all'||chr(10)||
'select ''6 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 6/24 t from dual union all'||chr(10)||
'select ''8 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 8/24 t from dual union all'||chr(10)||
'select ''1 ''||wwv_flow_lang.system_message(initcap(''DAY'')) d, 1 t from dual union all'||chr(10)||
'select ''2 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 2 t from dual union all'||chr(10)||
'select ''1 ''||wwv_flow_lang.system_message(initcap(''WEEK'')) d, 7 t  from dual union all'||chr(10)||
'select ''2 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 14 t  from dual union all'||chr(10)||
'select ''4 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 28 t from dual union all'||chr(10)||
'select ''1 ''||wwv_flow_lang.system_message(initcap(''YEAR'')) d, 365 t from dual order by 2',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 343399818250317904.4053+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>133966401375822439.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 43.4053,
  p_name=>'F4050_P43_GO',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 20,
  p_item_plug_id => 133959431567808445.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default => 'GO',
  p_prompt=>'Los',
  p_source=>'GO',
  p_source_type=> 'STATIC',
  p_display_as=> 'BUTTON',
  p_lov_columns=> null,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> 2000,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'LEFT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'N',
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Um nach Workspace zu filtern, wählen Sie einen Workspace und klicken anschließend auf <b>Los</b>. Um Ergebnisse aus allen Workspaces zurückzugeben, wählen Sie <b>Alle Workspaces</b>.';

wwv_flow_api.create_page_item(
  p_id=>193300101475204568.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 43.4053,
  p_name=>'F4050_P43_COMPANY',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 5,
  p_item_plug_id => 133959431567808445.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default => '0',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Workspace',
  p_source_type=> 'STATIC',
  p_display_as=> 'POPUP_KEY_LOV',
  p_named_lov=> 'LIST_DEVELOPER_WORKSPACES',
  p_lov => 'select ''- ''||'||chr(10)||
'wwv_flow_lang.system_message(''F4050_SHOW_ALL_WORKSPACES'')||'||chr(10)||
''' -'' d, 0 r from dual union all'||chr(10)||
'select short_name||'' (''||PROVISIONING_COMPANY_ID||'')'' d,'||chr(10)||
'       PROVISIONING_COMPANY_ID r'||chr(10)||
'from   WWV_FLOW_COMPANIES'||chr(10)||
'where  provisioning_company_id not in (0,10,11)'||chr(10)||
'order by 1',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 343399818250317904.4053+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_escape_on_http_input => 'Y',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>198070200195476999.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 43.4053,
  p_name=>'F4050_P43_COMPANY_NAME',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 30,
  p_item_plug_id => 133959431567808445.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'F4050_P43_COMPANY_NAME',
  p_display_as=> 'HIDDEN',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'N',
  p_item_comment => '');
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_computation(
  p_id=> 198074201261491716.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 43.4053,
  p_computation_sequence => 10,
  p_computation_item=> 'F4050_P43_COMPANY_NAME',
  p_computation_point=> 'AFTER_SUBMIT',
  p_computation_type=> 'FUNCTION_BODY',
  p_computation_processed=> 'REPLACE_EXISTING',
  p_computation=> 'declare'||chr(10)||
''||chr(10)||
'  l_company  varchar2(255) := null;'||chr(10)||
''||chr(10)||
'begin'||chr(10)||
''||chr(10)||
'  for c1 in (select short_name'||chr(10)||
''||chr(10)||
'             from wwv_flow_companies'||chr(10)||
''||chr(10)||
'             where provisioning_company_id = :F4050_P43_COMPANY) loop'||chr(10)||
''||chr(10)||
'    l_company := c1.short_name;'||chr(10)||
''||chr(10)||
'  end loop;'||chr(10)||
''||chr(10)||
'  if l_company is null then'||chr(10)||
''||chr(10)||
'    l_company := ''All Companies'';'||chr(10)||
''||chr(10)||
'  end if;'||chr(10)||
''||chr(10)||
'  return l_company;'||chr(10)||
''||chr(10)||
'end;',
  p_compute_when => '',
  p_compute_when_type=>'');
 
null;
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'reset_pagination';

wwv_flow_api.create_page_process(
  p_id     => 133971420340828824.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 43.4053,
  p_process_sequence=> 10,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'RESET_PAGINATION',
  p_process_name=> 'reset pg ',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_when_button_id=>133966401375822439.4053 + wwv_flow_api.g_id_offset,
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 43.4053
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_44.40
prompt  ...PAGE 44.4053: Seitenansichten pro Anwendung
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEADM/adm_activity.htm';

ph := null;
wwv_flow_api.create_page(
  p_id     => 44.4053,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'Seitenansichten pro Anwendung',
  p_step_title=> 'Seitenansichten pro Anwendung',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'AUTO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 216662902659587159+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => '',
  p_step_template => 12930201930057128.4053+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409160255',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>44.4053,p_text=>h);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 4623632221290709.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 44.4053,
  p_plug_name=> 'Menu',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(4585800473139662 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 4589126493175495.4053+ wwv_flow_api.g_id_offset,
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'with total_views as (select count(*) tv from wwv_flow_activity_log'||chr(10)||
'where  time_stamp >= (select sysdate - to_number(:F4050_P44_DAYS) x from dual) and page_mode != ''A'')'||chr(10)||
'select f.name,  x.flow_id application, x.c page_views, f.security_group_id, 100*x.c/tv pct, round(300*x.c/tv ) graph, c.short_name'||chr(10)||
'from ('||chr(10)||
'select flow_id, count(*) c'||chr(10)||
'from   wwv_flow_activity_log'||chr(10)||
'where  time_stamp >= (select sysdate -';

s:=s||' to_number(:F4050_P44_DAYS) x from dual) and page_mode != ''A'''||chr(10)||
'group by flow_id) x, '||chr(10)||
'wwv_flows f,'||chr(10)||
'total_views,'||chr(10)||
'wwv_flow_companies c'||chr(10)||
'where x.flow_id = f.id and f.security_group_id = c.provisioning_company_id and'||chr(10)||
'(:P44_FIND is null or instr(upper(c.short_name),upper(:P44_FIND)) >0 or instr(upper(f.name),upper(:P44_FIND))> 0)';

wwv_flow_api.create_report_region (
  p_id=> 7574232454022265.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 44.4053,
  p_name=> 'Page Views by Application',
  p_region_name=>'',
  p_template=> 0+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 60,
  p_display_column=> 1,
  p_display_point=> 'AFTER_SHOW_ITEMS',
  p_source=> s,
  p_source_type=> 'SQL_QUERY',
  p_display_error_message=> '#SQLERRM#',
  p_plug_caching=> 'NOT_CACHED',
  p_customized=> '0',
  p_query_row_template=> 6897002870390711.4053+ wwv_flow_api.g_id_offset,
  p_query_headings_type=> 'COLON_DELMITED_LIST',
  p_query_num_rows=> '15',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_show_nulls_as=> ' - ',
  p_query_break_cols=> '0',
  p_query_no_data_found=> 'Keine Daten gefunden.',
  p_query_num_rows_item=> 'P44_ROWS',
  p_query_num_rows_type=> 'NEXT_PREVIOUS_LINKS',
  p_query_row_count_max=> '50000',
  p_pagination_display_position=> 'BOTTOM_RIGHT',
  p_csv_output=> 'Y',
  p_csv_output_link_text=> 'Herunterladen',
  p_prn_output=> 'Y',
  p_prn_format=> 'PDF',
  p_prn_output_show_link=> 'Y',
  p_prn_output_link_text=> 'Drucken',
  p_prn_units=> 'INCHES',
  p_prn_paper_size=> 'LETTER',
  p_prn_width=> 11,
  p_prn_height=> 8.5,
  p_prn_orientation=> 'HORIZONTAL',
  p_prn_page_header=> '&PRODUCT_NAME.',
  p_prn_page_header_font_color=> '#000000',
  p_prn_page_header_font_family=> 'Helvetica',
  p_prn_page_header_font_weight=> 'normal',
  p_prn_page_header_font_size=> '12',
  p_prn_page_footer_font_color=> '#000000',
  p_prn_page_footer_font_family=> 'Helvetica',
  p_prn_page_footer_font_weight=> 'normal',
  p_prn_page_footer_font_size=> '12',
  p_prn_header_bg_color=> '#9bafde',
  p_prn_header_font_color=> '#ffffff',
  p_prn_header_font_family=> 'Helvetica',
  p_prn_header_font_weight=> 'normal',
  p_prn_header_font_size=> '10',
  p_prn_body_bg_color=> '#efefef',
  p_prn_body_font_color=> '#000000',
  p_prn_body_font_family=> 'Helvetica',
  p_prn_body_font_weight=> 'normal',
  p_prn_body_font_size=> '10',
  p_prn_border_width=> .5,
  p_query_asc_image=> 'arrow_down_gray_dark.gif',
  p_query_asc_image_attr=> 'width="13" height="12"',
  p_query_desc_image=> 'arrow_up_gray_dark.gif',
  p_query_desc_image_attr=> 'width="13" height="12"',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 7574506045022274.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 7574232454022265.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'NAME',
  p_column_display_sequence=> 3,
  p_column_heading=> 'Anwendungsname',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_print_col_width=> '14',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 7574620666022274.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 7574232454022265.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'APPLICATION',
  p_column_display_sequence=> 2,
  p_column_heading=> 'Anwendung',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>2,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_include_in_export=> 'Y',
  p_print_col_width=> '21',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 7574726854022274.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 7574232454022265.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 3,
  p_form_element_id=> null,
  p_column_alias=> 'PAGE_VIEWS',
  p_column_display_sequence=> 5,
  p_column_heading=> 'Seitenansichten',
  p_column_format=> '999G999G999G999G999G999G990',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'Y',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_print_col_width=> '14',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 7575315962026973.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 7574232454022265.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 4,
  p_form_element_id=> null,
  p_column_alias=> 'SECURITY_GROUP_ID',
  p_column_display_sequence=> 4,
  p_column_heading=> 'Workspace',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'Y',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_include_in_export=> 'N',
  p_print_col_width=> '0',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 7578416571046077.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 7574232454022265.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 5,
  p_form_element_id=> null,
  p_column_alias=> 'PCT',
  p_column_display_sequence=> 6,
  p_column_heading=> 'Prozentsatz',
  p_column_format=> '999G999G999G999G990D00',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'N',
  p_sum_column=> 'Y',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'Y',
  p_print_col_width=> '14',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 7578520254046077.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 7574232454022265.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 6,
  p_form_element_id=> null,
  p_column_alias=> 'GRAPH',
  p_column_display_sequence=> 7,
  p_column_heading=> '&nbsp;',
  p_column_html_expression=>'<div style="width:300px;height:14px;background:#dddddd;border-top:1px solid #aaaaaa;border-left:1px solid #aaaaaa;border-bottom:1px solid #ffffff;border-right:1px solid #ffffff;">'||chr(10)||
'<img src="#IMAGE_PREFIX#1px_trans.gif" width="#GRAPH#" height="14" border="0" style="background:#3f863f;"></div>',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_include_in_export=> 'N',
  p_print_col_width=> '0',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 7590024714086279.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 7574232454022265.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 7,
  p_form_element_id=> null,
  p_column_alias=> 'SHORT_NAME',
  p_column_display_sequence=> 1,
  p_column_heading=> 'Workspace',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>1,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_pk_col_source=> s,
  p_include_in_export=> 'Y',
  p_print_col_width=> '21',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 134117404639991595.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 44.4053,
  p_plug_name=> 'Button Bar',
  p_region_name=>'',
  p_plug_template=> 107311831567346457.4053+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings => 'blue_arrow_down.gif::blue_arrow_up.gif:|3,3,4\1,2|'||chr(10)||
''||chr(10)||
'&nbsp;:'||chr(10)||
''||chr(10)||
'<font class="nounderline" color="black">CompanyShortName</font>:'||chr(10)||
''||chr(10)||
'<font class="nounderline" color="green">Users</font>:'||chr(10)||
''||chr(10)||
'<font class="nounderline" color="green">Developers</font>:'||chr(10)||
''||chr(10)||
'<font class="nounderline" color="green">Flows</font>:<font color=green>ProvStatus</font>:'||chr(10)||
''||chr(10)||
'<font class="nounderline" color="black">CompanyID</font>:',
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_num_rows => 25,
  p_plug_query_num_rows_item => 'F4050_P1_ROWS',
  p_plug_query_num_rows_type => 'ROWS_X_TO_Y_OF_Z',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_query_show_nulls_as => '(null)',
  p_plug_query_col_allignments => 'L:L:L:L:R:R:R:L',
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>134124518861000187.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 44.4053,
  p_branch_action=> '44',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'BRANCH_TO_STEP',
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Created 30-NOV-2001 09:16 by MIKE');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Wählen Sie die Anzahl der Zeilen, die angezeigt werden sollen, und klicken Sie anschließend auf <b>Los</b>.';

wwv_flow_api.create_page_item(
  p_id=>7592515494093063.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 44.4053,
  p_name=>'P44_ROWS',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 15,
  p_item_plug_id => 134117404639991595.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default => '15',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Anzeigen',
  p_source_type=> 'STATIC',
  p_display_as=> 'COMBOBOX',
  p_named_lov=> 'MAX_ROWS_D',
  p_lov => '.'||to_char(87730331399250507 + wwv_flow_api.g_id_offset)||'.',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 343399818250317904.4053+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Geben Sie eine Abfrage ohne Berücksichtigung der Groß-/Kleinschreibung ein, und klicken Sie anschließend auf <b>Los</b>.';

wwv_flow_api.create_page_item(
  p_id=>108337423807258362.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 44.4053,
  p_name=>'P44_FIND',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 1,
  p_item_plug_id => 134117404639991595.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Suche',
  p_source_type=> 'STATIC',
  p_display_as=> 'TEXT',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 343399818250317904.4053+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Schränken Sie den Bericht auf einen bestimmten Zeitrahmen ein. Geben Sie die Dauer an, die für den Bericht berücksichtigt werden soll, und klicken Sie anschließend auf <b>Los</b>.<p />'||chr(10)||
'Wenn Sie 1 Tag auswählen, werden nur die letzten 24 Stunden angezeigt.  ';

wwv_flow_api.create_page_item(
  p_id=>134120128565995681.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 44.4053,
  p_name=>'F4050_P44_DAYS',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 134117404639991595.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default => '1',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Aufnehmen',
  p_source=>'1',
  p_source_type=> 'STATIC',
  p_display_as=> 'COMBOBOX',
  p_named_lov=> 'RECENT_TIME',
  p_lov => 'select ''10 ''||wwv_flow_lang.system_message(initcap(''SECONDS'')) d, 10/(24*60*60) t from dual union all'||chr(10)||
'select ''1 ''||wwv_flow_lang.system_message(initcap(''MINUTE'')) d, 1/(24*60) t from dual union all'||chr(10)||
'select ''5 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 5/(24*60) t from dual union all'||chr(10)||
'select ''15 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 15/(24*60) t from dual union all'||chr(10)||
'select ''30 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 30/(24*60) t from dual union all'||chr(10)||
'select ''1 ''||wwv_flow_lang.system_message(initcap(''HOUR'')) d, 1/24 t from dual union all'||chr(10)||
'select ''2 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 1/12  t from dual union all'||chr(10)||
'select ''6 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 6/24 t from dual union all'||chr(10)||
'select ''8 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 8/24 t from dual union all'||chr(10)||
'select ''1 ''||wwv_flow_lang.system_message(initcap(''DAY'')) d, 1 t from dual union all'||chr(10)||
'select ''2 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 2 t from dual union all'||chr(10)||
'select ''1 ''||wwv_flow_lang.system_message(initcap(''WEEK'')) d, 7 t  from dual union all'||chr(10)||
'select ''2 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 14 t  from dual union all'||chr(10)||
'select ''4 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 28 t from dual union all'||chr(10)||
'select ''1 ''||wwv_flow_lang.system_message(initcap(''YEAR'')) d, 365 t from dual order by 2',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 343399818250317904.4053+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>134122621233999084.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 44.4053,
  p_name=>'F4050_P44_GO',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 20,
  p_item_plug_id => 134117404639991595.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default => 'GO',
  p_prompt=>'Los',
  p_source=>'GO',
  p_source_type=> 'STATIC',
  p_display_as=> 'BUTTON',
  p_lov_columns=> null,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> 2000,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'LEFT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'N',
  p_item_comment => '');
 
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'reset_pagination';

wwv_flow_api.create_page_process(
  p_id     => 134126812822002989.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 44.4053,
  p_process_sequence=> 10,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'RESET_PAGINATION',
  p_process_name=> 'reset pg',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_when_button_id=>134122621233999084.4053 + wwv_flow_api.g_id_offset,
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 44.4053
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_45.40
prompt  ...PAGE 45.4053: Seitenansichten pro externer Site
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEADM/adm_activity.htm';

ph := null;
wwv_flow_api.create_page(
  p_id     => 45.4053,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'Seitenansichten pro externer Site',
  p_step_title=> 'Seitenansichten pro externer Site',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'AUTO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 216662902659587159+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => '',
  p_step_template => 12930201930057128.4053+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409160255',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>45.4053,p_text=>h);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 4756101530991492.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 45.4053,
  p_plug_name=> 'Menu',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(4585800473139662 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 4589126493175495.4053+ wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'with total_clicks as ('||chr(10)||
'select count(*) tc'||chr(10)||
'from wwv_flow_clickthru_log_v '||chr(10)||
'where clickdate >= (sysdate - (select :F4050_P45_DAYS from dual)) )'||chr(10)||
'select  category, count(*) clicks, 100*count(*)/max(tc) pct, 300*count(*)/max(tc) graph'||chr(10)||
'from wwv_flow_clickthru_log_v , total_clicks'||chr(10)||
'where clickdate >= (sysdate - (select :F4050_P45_DAYS from dual)) '||chr(10)||
'group by category';

wwv_flow_api.create_report_region (
  p_id=> 7686024329483531.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 45.4053,
  p_name=> 'Page Views by External Site',
  p_region_name=>'',
  p_template=> 0+ wwv_flow_api.g_id_offset,
  p_display_sequence=> 40,
  p_display_column=> 1,
  p_display_point=> 'AFTER_SHOW_ITEMS',
  p_source=> s,
  p_source_type=> 'SQL_QUERY',
  p_display_error_message=> '#SQLERRM#',
  p_plug_caching=> 'NOT_CACHED',
  p_customized=> '0',
  p_query_row_template=> 6897002870390711.4053+ wwv_flow_api.g_id_offset,
  p_query_headings_type=> 'COLON_DELMITED_LIST',
  p_query_num_rows=> '15',
  p_query_options=> 'DERIVED_REPORT_COLUMNS',
  p_query_show_nulls_as=> ' - ',
  p_query_break_cols=> '0',
  p_query_no_data_found=> 'Keine Daten für Bericht gefunden',
  p_query_num_rows_type=> 'NEXT_PREVIOUS_LINKS',
  p_query_row_count_max=> '500',
  p_pagination_display_position=> 'BOTTOM_RIGHT',
  p_csv_output=> 'N',
  p_query_asc_image=> 'arrow_down_gray_dark.gif',
  p_query_asc_image_attr=> 'width="13" height="12"',
  p_query_desc_image=> 'arrow_up_gray_dark.gif',
  p_query_desc_image_attr=> 'width="13" height="12"',
  p_plug_query_strip_html=> 'Y',
  p_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 7686327013483538.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 7686024329483531.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 1,
  p_form_element_id=> null,
  p_column_alias=> 'CATEGORY',
  p_column_display_sequence=> 1,
  p_column_heading=> 'Kategorie',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>2,
  p_disable_sort_column=>'N',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'ESCAPE_SC',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 7686410853483538.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 7686024329483531.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 2,
  p_form_element_id=> null,
  p_column_alias=> 'CLICKS',
  p_column_display_sequence=> 2,
  p_column_heading=> 'Klicks',
  p_column_format=> '999G999G999G999G999G999G990',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'LEFT',
  p_default_sort_column_sequence=>1,
  p_default_sort_dir=>'desc',
  p_disable_sort_column=>'N',
  p_sum_column=> 'Y',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 7690220436501333.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 7686024329483531.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 3,
  p_form_element_id=> null,
  p_column_alias=> 'PCT',
  p_column_display_sequence=> 3,
  p_column_heading=> 'Prozentsatz',
  p_column_format=> '999G999G999G999G990D0000',
  p_column_alignment=>'RIGHT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
begin
s := null;
wwv_flow_api.create_report_columns (
  p_id=> 7690321393501333.4053 + wwv_flow_api.g_id_offset,
  p_region_id=> 7686024329483531.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_query_column_id=> 4,
  p_form_element_id=> null,
  p_column_alias=> 'GRAPH',
  p_column_display_sequence=> 4,
  p_column_heading=> '&nbsp;',
  p_column_html_expression=>'<div style="width:300px;height:14px;background:#dddddd;border-top:1px solid #aaaaaa;border-left:1px solid #aaaaaa;border-bottom:1px solid #ffffff;border-right:1px solid #ffffff;">'||chr(10)||
'<img src="#IMAGE_PREFIX#1px_trans.gif" width="#GRAPH#" height="14" border="0" style="background:#3f863f;"></div>',
  p_column_alignment=>'LEFT',
  p_heading_alignment=>'CENTER',
  p_default_sort_column_sequence=>0,
  p_disable_sort_column=>'Y',
  p_sum_column=> 'N',
  p_hidden_column=> 'N',
  p_display_as=>'WITHOUT_MODIFICATION',
  p_lov_show_nulls=> 'NO',
  p_pk_col_source=> s,
  p_lov_display_extra=> 'YES',
  p_column_comment=>'');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'Auf dieser Seite werden die Benutzerklicks auf Links zu externen Sites angezeigt. Diese Klicks wurden über die &PRODUCT_NAME.-Prozedur <code>HTMLDB_UTIL.COUNT_CLICK</code> erfasst.';

wwv_flow_api.create_page_plug (
  p_id=> 145277907592163494.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 45.4053,
  p_plug_name=> 'Externes Clickthrough',
  p_region_name=>'',
  p_plug_template=> 79623830123907946.4053+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 30,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_03',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 190854513377597141.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 45.4053,
  p_plug_name=> 'Button Bar',
  p_region_name=>'',
  p_plug_template=> 107311831567346457.4053+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
null;
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>145361011387268162.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 45.4053,
  p_branch_action=> '45',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'BRANCH_TO_STEP',
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Created 10-DEC-2001 15:30 by MIKE');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Schränken Sie den Bericht auf einen bestimmten Zeitrahmen ein. Geben Sie die Dauer an, die für den Bericht berücksichtigt werden soll, und klicken Sie anschließend auf <b>Los</b>.<p />'||chr(10)||
'Wenn Sie 1 Tag auswählen, werden nur die letzten 24 Stunden angezeigt.  '||chr(10)||
'';

wwv_flow_api.create_page_item(
  p_id=>145345501048257700.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 45.4053,
  p_name=>'F4050_P45_DAYS',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 10,
  p_item_plug_id => 190854513377597141.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default => '1',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Aufnehmen',
  p_source=>'1',
  p_source_type=> 'STATIC',
  p_display_as=> 'COMBOBOX',
  p_named_lov=> 'RECENT_TIME',
  p_lov => 'select ''10 ''||wwv_flow_lang.system_message(initcap(''SECONDS'')) d, 10/(24*60*60) t from dual union all'||chr(10)||
'select ''1 ''||wwv_flow_lang.system_message(initcap(''MINUTE'')) d, 1/(24*60) t from dual union all'||chr(10)||
'select ''5 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 5/(24*60) t from dual union all'||chr(10)||
'select ''15 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 15/(24*60) t from dual union all'||chr(10)||
'select ''30 ''||wwv_flow_lang.system_message(initcap(''MINUTES'')) d, 30/(24*60) t from dual union all'||chr(10)||
'select ''1 ''||wwv_flow_lang.system_message(initcap(''HOUR'')) d, 1/24 t from dual union all'||chr(10)||
'select ''2 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 1/12  t from dual union all'||chr(10)||
'select ''6 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 6/24 t from dual union all'||chr(10)||
'select ''8 ''||wwv_flow_lang.system_message(initcap(''HOURS'')) d, 8/24 t from dual union all'||chr(10)||
'select ''1 ''||wwv_flow_lang.system_message(initcap(''DAY'')) d, 1 t from dual union all'||chr(10)||
'select ''2 ''||wwv_flow_lang.system_message(initcap(''DAYS'')) d, 2 t from dual union all'||chr(10)||
'select ''1 ''||wwv_flow_lang.system_message(initcap(''WEEK'')) d, 7 t  from dual union all'||chr(10)||
'select ''2 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 14 t  from dual union all'||chr(10)||
'select ''4 ''||wwv_flow_lang.system_message(initcap(''WEEKS'')) d, 28 t from dual union all'||chr(10)||
'select ''1 ''||wwv_flow_lang.system_message(initcap(''YEAR'')) d, 365 t from dual order by 2',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 30,
  p_cMaxlength=> 2000,
  p_cHeight=> 1,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 343399818250317904.4053+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
wwv_flow_api.create_page_item(
  p_id=>145349821954263192.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 45.4053,
  p_name=>'F4050_P45_GO',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 20,
  p_item_plug_id => 190854513377597141.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'NO',
  p_item_default => 'GO',
  p_prompt=>'Los',
  p_source=>'GO',
  p_source_type=> 'STATIC',
  p_display_as=> 'BUTTON',
  p_lov_columns=> null,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> null,
  p_cMaxlength=> 2000,
  p_cHeight=> null,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'NO',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'LEFT',
  p_field_alignment  => 'LEFT',
  p_is_persistent=> 'N',
  p_item_comment => '');
 
 
end;
/

 
begin
 
declare
  p varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
p:=p||'reset_pagination';

wwv_flow_api.create_page_process(
  p_id     => 145358315269266332.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id => 45.4053,
  p_process_sequence=> 10,
  p_process_point=> 'AFTER_SUBMIT',
  p_process_type=> 'RESET_PAGINATION',
  p_process_name=> 'reset pg',
  p_process_sql_clob => p, 
  p_process_error_message=> '',
  p_process_when_button_id=>145349821954263192.4053 + wwv_flow_api.g_id_offset,
  p_process_success_message=> '',
  p_process_is_stateful_y_n=>'N',
  p_process_comment=>'');
end;
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 45.4053
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_46.40
prompt  ...PAGE 46.4053: SQL Workshop-Logs
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEADM/adm_logs.htm';

ph := null;
wwv_flow_api.create_page(
  p_id     => 46.4053,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'SQL Workshop-Logs',
  p_step_title=> 'SQL Workshop-Logs',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'NO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_group_id => 216783731365642767+ wwv_flow_api.g_id_offset,
  p_help_text => ' ',
  p_html_page_header => '',
  p_step_template => '',
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409160255',
  p_page_is_public_y_n=> 'N',
  p_protection_level=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>46.4053,p_text=>h);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 22614318288619694.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 46.4053,
  p_plug_name=> 'Menu',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(4585800473139662 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 4589126493175495.4053+ wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'htp.p(''<table class="instructiontext" summary="">'');'||chr(10)||
'htp.p(''<tr>'');'||chr(10)||
'htp.p(''<td align="right">'');'||chr(10)||
'htp.p(''<a href="f?p=4050:75:''||:flow_session||''::::P75_LOG_TYPE:SCRIPT">''||wwv_flow_lang.system_message(''4050_46_SCRIPT_FILE'')||''</a>''||'':'');'||chr(10)||
'htp.p(''</td>'');'||chr(10)||
'htp.prn(''<td align="left">'');'||chr(10)||
'for c1 in (select count(*) c from wwv_flow_sw_results) loop'||chr(10)||
'    htp.p(to_char(c1.c,''999,999,999,999,990''));'||chr(10)||
'end loo';

s:=s||'p;'||chr(10)||
'htp.prn(''</td>'');'||chr(10)||
'htp.p(''</tr>'');'||chr(10)||
'htp.p(''<tr>'');'||chr(10)||
'htp.p(''<td align="right">'');'||chr(10)||
'htp.p(''<a href="f?p=4050:75:''||:flow_session||''::::P75_LOG_TYPE:HISTORY">''||wwv_flow_lang.system_message(''4050_46_AD_HOC'')||''</a>''||'':'');'||chr(10)||
'htp.p(''</td>'');'||chr(10)||
'htp.prn(''<td align="left">'');'||chr(10)||
'for c1 in (select count(*) c from wwv_flow_sw_sql_cmds) loop'||chr(10)||
'    htp.p(to_char(c1.c,''999,999,999,999,990''));'||chr(10)||
'end loop;'||chr(10)||
'htp.prn(''</td>'')';

s:=s||';'||chr(10)||
'htp.p(''</tr>'');'||chr(10)||
'htp.p(''</table>'');';

wwv_flow_api.create_page_plug (
  p_id=> 22617807253644948.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 46.4053,
  p_plug_name=> 'SQL Workshop-Logs',
  p_region_name=>'',
  p_plug_template=> 2424107150426143.4053+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 11,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_02',
  p_plug_source=> s,
  p_plug_source_type=> 'PLSQL_PROCEDURE',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> '',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign="top"',
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'Der SQL Workshop verwaltet eine Historie der SQL-Anweisungen. Diese Historie steht SQL Workshop-Benutzern im Historien-Utility zur Verfügung. Diese Tabelle kann geleert werden, um die Speicherplatzauslastung zu reduzieren.';

wwv_flow_api.create_page_plug (
  p_id=> 22619003706662819.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 46.4053,
  p_plug_name=> 'SQL Workshop-Logs',
  p_region_name=>'',
  p_plug_template=> 79623830123907946.4053+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 21,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_03',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 161897913639838567.4053 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 46.4053,
  p_button_sequence=> 10,
  p_button_plug_id => 22617807253644948+wwv_flow_api.g_id_offset,
  p_button_name    => 'CANCEL',
  p_button_image_alt=> 'Abbrechen',
  p_button_position=> 'REGION_TEMPLATE_CLOSE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=&FLOW_ID.:68:&SESSION.::&DEBUG.:::',
  p_button_cattributes=>'class="button10"',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>22620213748665756.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 46.4053,
  p_branch_action=> '46',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'BRANCH_TO_STEP',
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> 'Created 18-JAN-2003 12:59 by MIKE');
 
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 46.4053
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_47.40
prompt  ...PAGE 47.4053: Öffentliches Theme erstellen
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEADM/adm_themes_public.htm';

ph := null;
wwv_flow_api.create_page(
  p_id     => 47.4053,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'Öffentliches Theme erstellen',
  p_step_title=> 'Öffentliches Theme erstellen',
  p_step_sub_title => 'Create Workspace Theme',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'NO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_help_text => ' ',
  p_html_page_header => '',
  p_step_template => 12930201930057128.4053+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409160255',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow_step_id=>47.4053,p_text=>h);
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'114829600122838504';

wwv_flow_api.create_page_plug (
  p_id=> 138041907898643265.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 47.4053,
  p_plug_name=> 'Progress',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 20,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_01',
  p_plug_source=> s,
  p_plug_source_type=> 138045104803643281 + wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 138042300956643271.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 47.4053,
  p_plug_name=> 'Öffentliches Theme erstellen',
  p_region_name=>'',
  p_plug_template=> 2424107150426143.4053+ wwv_flow_api.g_id_offset,
  p_plug_display_sequence=> 10,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_column_width => 'valign=top',
  p_plug_display_condition_type => '',
  p_plug_header=> 'Öffentliche Themes sind für alle Workspaces verfügbar. Beim Erstellen von Anwendungen können Entwickler ein öffentliches Theme zusätzlich zu den &PRODUCT_NAME. Themes und Workspace Themes wählen. '||chr(10)||
'<p/>'||chr(10)||
'Geben Sie den Workspace an, der das Anwendungs-Theme enthält, das in das öffentliche Theme Repository kopiert werden soll.'||chr(10)||
'<p/>',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s := null;
wwv_flow_api.create_page_plug (
  p_id=> 138042501921643272.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 47.4053,
  p_plug_name=> 'Create Public Theme',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 1,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'REGION_POSITION_08',
  p_plug_source=> s,
  p_plug_source_type=> 'M'|| to_char(4585800473139662 + wwv_flow_api.g_id_offset),
  p_menu_template_id=> 4589126493175495.4053+ wwv_flow_api.g_id_offset,
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'COLON_DELMITED_LIST',
  p_plug_query_row_count_max => 500,
  p_plug_display_condition_type => '',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
wwv_flow_api.create_page_button(
  p_id             => 138043401976643278.4053 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 47.4053,
  p_button_sequence=> 10,
  p_button_plug_id => 138042300956643271+wwv_flow_api.g_id_offset,
  p_button_name    => 'CANCEL',
  p_button_image_alt=> 'Abbrechen',
  p_button_position=> 'REGION_TEMPLATE_CLOSE',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> 'f?p=&APP_ID.:555:&SESSION.::&DEBUG.:::',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
wwv_flow_api.create_page_button(
  p_id             => 138043000845643273.4053 + wwv_flow_api.g_id_offset,
  p_flow_id        => wwv_flow.g_flow_id,
  p_flow_step_id   => 47.4053,
  p_button_sequence=> 20,
  p_button_plug_id => 138042300956643271+wwv_flow_api.g_id_offset,
  p_button_name    => 'NEXT',
  p_button_image_alt=> 'Weiter &gt;',
  p_button_position=> 'REGION_TEMPLATE_NEXT',
  p_button_alignment=> 'RIGHT',
  p_button_redirect_url=> '',
  p_required_patch => null + wwv_flow_api.g_id_offset);
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_branch(
  p_id=>138044704585643280.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 47.4053,
  p_branch_action=> 'f?p=&APP_ID.:57:&SESSION.::&DEBUG.:::&success_msg=#SUCCESS_MSG#',
  p_branch_point=> 'AFTER_PROCESSING',
  p_branch_type=> 'REDIRECT_URL',
  p_branch_when_button_id=>138043000845643273.4053+ wwv_flow_api.g_id_offset,
  p_branch_sequence=> 10,
  p_save_state_before_branch_yn=>'N',
  p_branch_comment=> '');
 
 
end;
/

declare
    h varchar2(32767) := null;
begin
h := null;
h:=h||'Gibt den Workspace an, in dem das zu kopierenden Anwendungs-Theme gespeichert ist.';

wwv_flow_api.create_page_item(
  p_id=>138044131207643279.4053 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_flow_step_id=> 47.4053,
  p_name=>'P47_WORKSPACE',
  p_data_type=> 'VARCHAR',
  p_accept_processing=> 'REPLACE_EXISTING',
  p_item_sequence=> 1,
  p_item_plug_id => 138042300956643271.4053+wwv_flow_api.g_id_offset,
  p_use_cache_before_default=> 'YES',
  p_item_default_type => 'STATIC_TEXT_WITH_SUBSTITUTIONS',
  p_prompt=>'Workspace',
  p_source_type=> 'STATIC',
  p_display_as=> 'POPUP_KEY_LOV',
  p_named_lov=> 'LIST_DEVELOPER_WORKSPACES_NO_NULL_OPTION',
  p_lov => 'select short_name||'' (''||PROVISIONING_COMPANY_ID||'')'' d,'||chr(10)||
'       PROVISIONING_COMPANY_ID r'||chr(10)||
'from   WWV_FLOW_COMPANIES'||chr(10)||
'where  provisioning_company_id not in (0,10,11)'||chr(10)||
'order by 1',
  p_lov_columns=> 1,
  p_lov_display_null=> 'NO',
  p_lov_translated=> 'N',
  p_cSize=> 50,
  p_cMaxlength=> 2000,
  p_cHeight=> 5,
  p_cAttributes=> 'nowrap="nowrap"',
  p_begin_on_new_line => 'YES',
  p_begin_on_new_field=> 'YES',
  p_colspan => 1,
  p_rowspan => 1,
  p_label_alignment  => 'RIGHT',
  p_field_alignment  => 'LEFT',
  p_field_template => 111843720754869910.4053+wwv_flow_api.g_id_offset,
  p_is_persistent=> 'Y',
  p_lov_display_extra=>'NO',
  p_protection_level => 'N',
  p_help_text   => h,
  p_item_comment => '');
 
 
end;
/

 
begin
 
wwv_flow_api.create_page_validation(
  p_id => 138164321008022878.4053 + wwv_flow_api.g_id_offset,
  p_flow_id => wwv_flow.g_flow_id,
  p_flow_step_id => 47.4053,
  p_validation_name => 'P47_WORKSPACE',
  p_validation_sequence=> 10,
  p_validation => 'P47_WORKSPACE',
  p_validation_type => 'ITEM_NOT_NULL',
  p_error_message => 'Der Workspace muss angegeben werden.',
  p_when_button_pressed=> 138043000845643273.4053 + wwv_flow_api.g_id_offset,
  p_associated_item=> 138044131207643279.4053 + wwv_flow_api.g_id_offset,
  p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION',
  p_validation_comment=> '');
 
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 47.4053
--
 
begin
 
null;
end;
null;
 
end;
/

 
--application/pages/page_48.40
prompt  ...PAGE 48.4053: Öffentliches Theme erstellen
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h:=h||'AEADM/adm_themes_public.htm';

ph := null;
wwv_flow_api.create_page(
  p_id     => 48.4053,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'Öffentliches Theme erstellen',
  p_step_title=> 'Öffentliches Theme erstellen',
  p_step_sub_title => 'Create Workspace Theme',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'NO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_help_text => ' ',
  p_html_page_header => '',
  p_step_template => 12930201930057128.4053+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409160256',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
wwv_flow_api.set_page_help_text(p_flow_id=>wwv_flow.g_flow_id,p_flow