set define off
set verify off
set serveroutput on size 1000000
set feedback off
begin wwv_flow.g_import_in_progress := true; end; 
/
 
 
--application/set_environment
prompt  APPLICATION 4414 - APEX  - System Messages
--
-- Application Export:
--   Application:     4414
--   Name:            APEX  - System Messages
--   Date and Time:   08:04 Tuesday May 19, 2009
--   Exported By:     
--   Flashback:       0
--   Export Type:     Application Export
--   Version: 3.2.1.00.08
 
-- Import:
--   Using application builder
--   or
--   Using SQL*Plus as the Oracle user APEX_030200 or as the owner (parsing schema) of the application.
 
-- Application Statistics:
--   Pages:                 1
--     Items:               0
--     Computations:        0
--     Validations:         0
--     Processes:           0
--     Regions:             1
--     Buttons:             0
--   Shared Components
--     Breadcrumbs:         0
--        Entries           0
--     Items:               0
--     Computations:        0
--     Processes:           0
--     Parent Tabs:         0
--     Tab Sets:            0
--        Tabs:             0
--     NavBars:             0
--     Lists:               0
--     Shortcuts:           0
--     Themes:              0
--     Templates:
--        Page:             9
--        List:            14
--        Report:           7
--        Label:            5
--        Region:          21
--     Messages:        3,702
--     Build Options:       0
 
 
--       AAAA       PPPPP   EEEEEE  XX      XX
--      AA  AA      PP  PP  EE       XX    XX
--     AA    AA     PP  PP  EE        XX  XX
--    AAAAAAAAAA    PPPPP   EEEE       XXXX
--   AA        AA   PP      EE        XX  XX
--  AA          AA  PP      EE       XX    XX
--  AA          AA  PP      EEEEEE  XX      XX
prompt  Set Credentials...
 
begin
 
  -- Assumes you are running the script connected to SQL*Plus as the Oracle user APEX_030200 or as the owner (parsing schema) of the application.
  wwv_flow_api.set_security_group_id(p_security_group_id=>10);
 
end;
/

begin wwv_flow.g_import_in_progress := true; end;
/
begin 

select value into wwv_flow_api.g_nls_numeric_chars from nls_session_parameters where parameter='NLS_NUMERIC_CHARACTERS';

end;

/
begin execute immediate 'alter session set nls_numeric_characters=''.,''';

end;

/
begin wwv_flow.g_browser_language := 'en-us'; end;
/
prompt  Check Compatibility...
 
begin
 
-- This date identifies the minimum version required to import this file.
wwv_flow_api.set_version(p_version_yyyy_mm_dd=>'2009.01.12');
 
end;
/

prompt  Set Application ID...
 
begin
 
   -- SET APPLICATION ID
   wwv_flow.g_flow_id := 4414;
   wwv_flow_api.g_id_offset := 0;
null;
 
end;
/

--application/delete_application
 
begin
 
   -- Remove Application
wwv_flow_api.remove_flow(4414);
 
end;
/

 
begin
 
wwv_flow_audit.remove_audit_trail(4414);
null;
 
end;
/

--application/create_application
 
begin
 
wwv_flow_api.create_flow(
  p_id    => 4414,
  p_display_id=> 4414,
  p_owner => 'APEX_030200',
  p_name  => 'APEX  - System Messages',
  p_alias => 'A198391106101442732',
  p_page_view_logging => 'YES',
  p_default_page_template=> 91626406749381989.4414 + wwv_flow_api.g_id_offset,
  p_printer_friendly_template=> 91626529080381989.4414 + wwv_flow_api.g_id_offset,
  p_default_region_template=> 91632832228382001.4414 + wwv_flow_api.g_id_offset,
  p_error_template    => 91626406749381989.4414 + wwv_flow_api.g_id_offset,
  p_charset           => 'utf-8',
  p_checksum_salt_last_reset => '20090519073429',
  p_max_session_length_sec=> 28800,
  p_home_link         => 'f?p=4411:1:&SESSION.',
  p_flow_language     => 'de',
  p_flow_language_derived_from=> 'BROWSER',
  p_flow_image_prefix => '/i/',
  p_documentation_banner=> '',
  p_authentication    => 'CUSTOM2',
  p_login_url         => '',
  p_logout_url        => '',
  p_application_tab_set=> 1,
  p_public_url_prefix => '',
  p_public_user       => 'APEX_PUBLIC_USER',
  p_dbauth_url_prefix => '',
  p_proxy_server      => '',
  p_cust_authentication_process=> '.'||to_char(91645213681389498 + wwv_flow_api.g_id_offset)||'.',
  p_cust_authentication_page=> '',
  p_custom_auth_login_url=> '',
  p_flow_version      => '&PRODUCT_NAME. 3.2.1.00.08',
  p_flow_status       => 'AVAILABLE_W_EDIT_LINK',
  p_flow_unavailable_text=> 'This application is currently unavailable.',
  p_build_status      => 'RUN_AND_BUILD',
  p_exact_substitutions_only=> 'Y',
  p_vpd               => '',
  p_rejoin_existing_sessions   => 'N',
  p_theme_id => 1,
  p_default_label_template => 91641225667382016.4414 + wwv_flow_api.g_id_offset,
  p_default_report_template => 91638400927382012.4414 + wwv_flow_api.g_id_offset,
  p_default_list_template => 91636711305382010.4414 + wwv_flow_api.g_id_offset,
  p_default_menu_template => 91641814330382017.4414 + wwv_flow_api.g_id_offset,
  p_default_button_template => 91626823864381990.4414 + wwv_flow_api.g_id_offset,
  p_default_chart_template => 91631622717381999.4414 + wwv_flow_api.g_id_offset,
  p_default_form_template => 91630725782381998.4414 + wwv_flow_api.g_id_offset,
  p_default_wizard_template => 91632204784382001.4414 + wwv_flow_api.g_id_offset,
  p_default_tabform_template => 91632832228382001.4414 + wwv_flow_api.g_id_offset,
  p_default_reportr_template   =>91632832228382001.4414 + wwv_flow_api.g_id_offset,
  p_default_menur_template => 91633105066382001.4414 + wwv_flow_api.g_id_offset,
  p_default_listr_template => 91627727983381992.4414 + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss=> '20090518134313',
  p_required_roles=> wwv_flow_utilities.string_to_table2(''));
 
 
end;
/

prompt  ...authorization schemes
--
 
begin
 
null;
 
end;
/

--application/shared_components/navigation/navigation_bar
prompt  ...navigation bar entries
--
 
begin
 
null;
 
end;
/

prompt  ...application processes
--
prompt  ...application items
--
prompt  ...application level computations
--
 
begin
 
null;
 
end;
/

prompt  ...Application Tabs
--
 
begin
 
null;
 
end;
/

prompt  ...Application Parent Tabs
--
 
begin
 
null;
 
end;
/

prompt  ...Shared Lists of values
--
prompt  ...Application Trees
--
--application/pages/page_groups
prompt  ...page groups
--
 
begin
 
null;
 
end;
/

 
--application/pages/page_1.441
prompt  ...PAGE 1.4414: Nachrichten
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h := null;
ph := null;
wwv_flow_api.create_page(
  p_id     => 1.4414,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'Nachrichten',
  p_step_title=> 'Nachrichten',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'AUTO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_help_text => '',
  p_html_page_header => '',
  p_step_template => 91626406749381989.4414+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss => '20090409155755',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'<h1>APEX-Entwicklung</h1><p>'||chr(10)||
'Mit dieser Anwendung werden APEX-Systemmeldungen verwaltet. Klicken Sie auf "Gemeinsame Komponenten" und dann auf "Meldungen"'||chr(10)||
'</p>';

wwv_flow_api.create_page_plug (
  p_id=> 91624704892377483.4414 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 1.4414,
  p_plug_name=> 'System Messages',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 10,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
null;
 
end;
/

 
begin
 
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 1.4414
--
 
begin
 
null;
end;
null;
 
end;
/

prompt  ...lists
--
--application/shared_components/navigation/breadcrumbs
prompt  ...breadcrumbs
--
prompt  ...page templates for application: 4414
--
--application/shared_components/user_interface/templates/page/login_de
prompt  ......Page template 91625820476381987.4414
 
begin
 
declare
  c1 varchar2(32767) := null;
  c2 varchar2(32767) := null;
  c3 varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
c1:=c1||'<html lang="&BROWSER_LANGUAGE." xmlns:htmldb="http://htmldb.oracle.com">'||chr(10)||
'<head>'||chr(10)||
'<title>#TITLE#</title>'||chr(10)||
'<link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_1/theme_V3.css" type="text/css" />'||chr(10)||
'#HEAD#'||chr(10)||
'</head>'||chr(10)||
'<body #ONLOAD#>#FORM_OPEN#';

c2:=c2||'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="">'||chr(10)||
'  <tr>'||chr(10)||
'    <td><img src="#IMAGE_PREFIX#themes/theme_1/bot_bar_left.png" alt="" /></td>'||chr(10)||
'    <td class="t1BotbarMiddle"><br /></td>'||chr(10)||
'    <td><img src="#IMAGE_PREFIX#themes/theme_1/bot_bar_right.png" alt="" /></td>'||chr(10)||
'  </tr>'||chr(10)||
'</table>'||chr(10)||
'<br />'||chr(10)||
'#FORM_CLOSE# '||chr(10)||
'</body>'||chr(10)||
'</html>';

c3:=c3||'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="">'||chr(10)||
'  <tr>'||chr(10)||
'    <td valign="top" class="t1Logo">#LOGO#</td>'||chr(10)||
'    <td align="right" valign="top"><br /></td>'||chr(10)||
'  </tr>'||chr(10)||
'</table>'||chr(10)||
'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="">'||chr(10)||
'  <tr>'||chr(10)||
'    <td><img src="#IMAGE_PREFIX#themes/theme_1/top_bar_left.png" alt="" /></td>'||chr(10)||
'    <td class="t1topbarMiddle"><br /></td>'||chr(10)||
' ';

c3:=c3||'   <td><img src="#IMAGE_PREFIX#themes/theme_1/top_bar_right.png" alt="" /></td>'||chr(10)||
'  </tr>'||chr(10)||
'</table>'||chr(10)||
'<table class="t1PageBody" cellpadding="0" cellspacing="0" border="0" summary="" width="100%" height="70%">'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1PageCenter" valign="top"><table summary="" cellpadding="0" width="100%" cellspacing="0" border="0">'||chr(10)||
'<tr>'||chr(10)||
'<td width="100%" valign="top" class="t1PageBody"><div class="t1messages">';

c3:=c3||'#GLOBAL_NOTIFICATION##SUCCESS_MESSAGE##NOTIFICATION_MESSAGE#</div>#BOX_BODY##REGION_POSITION_02##REGION_POSITION_03##REGION_POSITION_04##REGION_POSITION_05##REGION_POSITION_06##REGION_POSITION_07##REGION_POSITION_08#</td>'||chr(10)||
'</tr>'||chr(10)||
'</table></td>'||chr(10)||
'</tr>'||chr(10)||
'</table>'||chr(10)||
'';

wwv_flow_api.create_template(
  p_id=> 91625820476381987.4414 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'Login.de',
  p_body_title=> '',
  p_header_template=> c1,
  p_box=> c3,
  p_footer_template=> c2,
  p_success_message=> '<div class="t1success">#SUCCESS_MESSAGE#</div>',
  p_current_tab=> '',
  p_current_tab_font_attr=> '',
  p_non_current_tab=> '',
  p_non_current_tab_font_attr => '',
  p_top_current_tab=> '',
  p_top_current_tab_font_attr => '',
  p_top_non_curr_tab=> '',
  p_top_non_curr_tab_font_attr=> '',
  p_current_image_tab=> '',
  p_non_current_image_tab=> '',
  p_notification_message=> '<div class="t1notification">#MESSAGE#</div>',
  p_navigation_bar=> '',
  p_navbar_entry=> '',
  p_app_tab_before_tabs=>'',
  p_app_tab_current_tab=>'',
  p_app_tab_non_current_tab=>'',
  p_app_tab_after_tabs=>'',
  p_region_table_cattributes=> ' summary="" cellpadding="0" border="0" cellspacing="0"',
  p_theme_id  => 1,
  p_theme_class_id => 6,
  p_translate_this_template => 'N',
  p_template_comment => '18');
end;
 
null;
 
end;
/

--application/shared_components/user_interface/templates/page/no_tabs_de
prompt  ......Page template 91625930032381988.4414
 
begin
 
declare
  c1 varchar2(32767) := null;
  c2 varchar2(32767) := null;
  c3 varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
c1:=c1||'<html lang="&BROWSER_LANGUAGE." xmlns:htmldb="http://htmldb.oracle.com">'||chr(10)||
'<head>'||chr(10)||
'<title>#TITLE#</title>'||chr(10)||
'<link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_1/theme_V3.css" type="text/css" />'||chr(10)||
'#HEAD#'||chr(10)||
'</head>'||chr(10)||
'<body #ONLOAD#>#FORM_OPEN#';

c2:=c2||'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="">'||chr(10)||
'  <tr>'||chr(10)||
'    <td><img src="#IMAGE_PREFIX#themes/theme_1/bot_bar_left.png" alt="" /></td>'||chr(10)||
'    <td class="t1BotbarMiddle"><div id="t1user">&APP_USER.</div></td>'||chr(10)||
'    <td class="t1BotbarMiddle"><div id="t1copy"><!-- Copyright Here --><span class="t1Customize">#CUSTOMIZE#</span></div></td>'||chr(10)||
'    <td><img src="#IMAGE_PREFIX#themes/th';

c2:=c2||'eme_1/bot_bar_right.png" alt="" /></td>'||chr(10)||
'  </tr>'||chr(10)||
'</table>'||chr(10)||
'<br />'||chr(10)||
'#REGION_POSITION_05#'||chr(10)||
'#FORM_CLOSE# '||chr(10)||
'</body>'||chr(10)||
'</html>';

c3:=c3||'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="">'||chr(10)||
'  <tr>'||chr(10)||
'    <td valign="top" class="t1Logo">#LOGO##REGION_POSITION_06#</td>'||chr(10)||
'	<td valign="top" width="100%">#REGION_POSITION_07#</td>'||chr(10)||
'    <td align="right" valign="top">#NAVIGATION_BAR##REGION_POSITION_08#</td>'||chr(10)||
'  </tr>'||chr(10)||
'</table>'||chr(10)||
'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="">'||chr(10)||
'  <tr>'||chr(10)||
'    <td><img src=';

c3:=c3||'"#IMAGE_PREFIX#themes/theme_1/top_bar_left.png" alt="" /></td>'||chr(10)||
'    <td class="t1topbarMiddle"><br />#REGION_POSITION_01#</td>'||chr(10)||
'    <td><img src="#IMAGE_PREFIX#themes/theme_1/top_bar_right.png" alt="" /></td>'||chr(10)||
'  </tr>'||chr(10)||
'</table>'||chr(10)||
'<table class="t1PageBody" cellpadding="0" cellspacing="0" border="0" summary="" width="100%" height="70%">'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1PageCenter" valign="top"><table summary="" cellpadd';

c3:=c3||'ing="0" width="100%" cellspacing="0" border="0">'||chr(10)||
'<tr>'||chr(10)||
'<td width="100%" valign="top" class="t1PageBody"><div class="t1messages">#GLOBAL_NOTIFICATION##SUCCESS_MESSAGE##NOTIFICATION_MESSAGE#</div>#BOX_BODY##REGION_POSITION_02##REGION_POSITION_04#</td>'||chr(10)||
'<td valign="top">#REGION_POSITION_03#<br /></td>'||chr(10)||
'</tr>'||chr(10)||
'</table></td>'||chr(10)||
'</tr>'||chr(10)||
'</table>'||chr(10)||
'';

wwv_flow_api.create_template(
  p_id=> 91625930032381988.4414 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'No Tabs.de',
  p_body_title=> '',
  p_header_template=> c1,
  p_box=> c3,
  p_footer_template=> c2,
  p_success_message=> '<div class="t1success">#SUCCESS_MESSAGE#</div>',
  p_current_tab=> '',
  p_current_tab_font_attr=> '',
  p_non_current_tab=> '',
  p_non_current_tab_font_attr => '',
  p_top_current_tab=> '',
  p_top_current_tab_font_attr => '',
  p_top_non_curr_tab=> '',
  p_top_non_curr_tab_font_attr=> '',
  p_current_image_tab=> '',
  p_non_current_image_tab=> '',
  p_notification_message=> '<div class="t1Notification">#MESSAGE#</div>',
  p_navigation_bar=> '<div class="t1NavigationBar">#BAR_BODY#</div>',
  p_navbar_entry=> '<a href="#LINK#" class="t1NavigationBar">#TEXT#</a>',
  p_app_tab_before_tabs=>'',
  p_app_tab_current_tab=>'',
  p_app_tab_non_current_tab=>'',
  p_app_tab_after_tabs=>'',
  p_region_table_cattributes=> ' summary="" cellpadding="0" border="0" cellspacing="0" width="100%"',
  p_sidebar_def_reg_pos => 'REGION_POSITION_02',
  p_breadcrumb_def_reg_pos => 'REGION_POSITION_01',
  p_theme_id  => 1,
  p_theme_class_id => 3,
  p_translate_this_template => 'N',
  p_template_comment => '');
end;
 
null;
 
end;
/

--application/shared_components/user_interface/templates/page/two_level_tabs_de
prompt  ......Page template 91626019499381988.4414
 
begin
 
declare
  c1 varchar2(32767) := null;
  c2 varchar2(32767) := null;
  c3 varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
c1:=c1||'<html lang="&BROWSER_LANGUAGE." xmlns:htmldb="http://htmldb.oracle.com">'||chr(10)||
'<head>'||chr(10)||
'<title>#TITLE#</title>'||chr(10)||
'<link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_1/theme_V3.css" type="text/css" />'||chr(10)||
'#HEAD#'||chr(10)||
'</head>'||chr(10)||
'<body #ONLOAD#>#FORM_OPEN#';

c2:=c2||'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="">'||chr(10)||
'  <tr>'||chr(10)||
'    <td><img src="#IMAGE_PREFIX#themes/theme_1/bot_bar_left.png" alt="" /></td>'||chr(10)||
'    <td class="t1BotbarMiddle"><div id="t1user">&APP_USER.</div></td>'||chr(10)||
'    <td class="t1BotbarMiddle"><div id="t1copy"><!-- Copyright Here --><span class="t1Customize">#CUSTOMIZE#</span></div></td>'||chr(10)||
'    <td><img src="#IMAGE_PREFIX#themes/th';

c2:=c2||'eme_1/bot_bar_right.png" alt="" /></td>'||chr(10)||
'  </tr>'||chr(10)||
'</table>'||chr(10)||
'<br />'||chr(10)||
'#REGION_POSITION_05#'||chr(10)||
'#FORM_CLOSE# '||chr(10)||
'</body>'||chr(10)||
'</html>';

c3:=c3||'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="">'||chr(10)||
'  <tr>'||chr(10)||
'    <td valign="top" class="t1Logo">#LOGO##REGION_POSITION_06#</td>'||chr(10)||
'	<td valign="top" width="100%">#REGION_POSITION_07#</td>'||chr(10)||
'    <td align="right" valign="top">#NAVIGATION_BAR##REGION_POSITION_08#</td>'||chr(10)||
'  </tr>'||chr(10)||
'</table>'||chr(10)||
'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="" height="70%">'||chr(10)||
'  <tr>'||chr(10)||
'    ';

c3:=c3||'<td colspan="5" class="t1ParentTabHolder"><table border="0" cellpadding="0" cellspacing="0" summary="" align="right"><tr><td><br /></td>#PARENT_TAB_CELLS#</tr></table></td>'||chr(10)||
'  </tr>'||chr(10)||
'  <tr>'||chr(10)||
'    <td align="right" class="t1topbarLeft"><img src="#IMAGE_PREFIX#themes/theme_1/top_bar_left2.png" alt="" /></td>'||chr(10)||
'    <td class="t1topbarMiddle" valign="top"><table border="0" cellpadding="0" cellspacing="0" su';

c3:=c3||'mmary=""><tr><td height="20">#TAB_CELLS#</td></tr><tr><td height="20">#REGION_POSITION_01#</td></tr></table></td>'||chr(10)||
'    <td><img src="#IMAGE_PREFIX#themes/theme_1/top_bar_right.png" alt="" /></td>'||chr(10)||
'  </tr>'||chr(10)||
'  <tr>'||chr(10)||
'    <td><br /></td>'||chr(10)||
'    <td class="t1PageRight" colspan="2" valign="top" height="100%"><table summary="" cellpadding="0" width="100%" cellspacing="0" border="0">'||chr(10)||
'<tr>'||chr(10)||
'<td width="100%" valign';

c3:=c3||'="top" class="t1PageBody"><div class="t1messages">#GLOBAL_NOTIFICATION##SUCCESS_MESSAGE##NOTIFICATION_MESSAGE#</div>#BOX_BODY##REGION_POSITION_02##REGION_POSITION_04#</td>'||chr(10)||
'<td valign="top">#REGION_POSITION_03#<br /></td>'||chr(10)||
'</tr>'||chr(10)||
'</table></td>'||chr(10)||
'  </tr>'||chr(10)||
'</table>';

wwv_flow_api.create_template(
  p_id=> 91626019499381988.4414 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'Two Level Tabs.de',
  p_body_title=> '',
  p_header_template=> c1,
  p_box=> c3,
  p_footer_template=> c2,
  p_success_message=> '<div class="t1success">#SUCCESS_MESSAGE#</div>',
  p_current_tab=> '<span class="t1ChildTab">[&nbsp;#TAB_LABEL#&nbsp;]</span>#TAB_INLINE_EDIT#',
  p_current_tab_font_attr=> '',
  p_non_current_tab=> '<a href="#TAB_LINK#" class="t1ChildTab">#TAB_LABEL#</a>#TAB_INLINE_EDIT#',
  p_non_current_tab_font_attr => '',
  p_top_current_tab=> '<td><img src="#IMAGE_PREFIX#themes/theme_1/tab_on_left.png" border="0" alt="" /></td>'||chr(10)||
'<td class="t1ParentTabCenterOn">#TAB_LABEL##TAB_INLINE_EDIT#</td>'||chr(10)||
'<td><img src="#IMAGE_PREFIX#themes/theme_1/tab_on_right.png" border="0" alt="" /></td>',
  p_top_current_tab_font_attr => '',
  p_top_non_curr_tab=> '<td><img src="#IMAGE_PREFIX#themes/theme_1/tab_off_left.png" border="0" alt="" /></td>'||chr(10)||
'<td class="t1ParentTabCenterOff"><a href="#TAB_LINK#">#TAB_LABEL#</a>#TAB_INLINE_EDIT#</td>'||chr(10)||
'<td><img src="#IMAGE_PREFIX#themes/theme_1/tab_off_right.png" border="0" alt="" /></td>',
  p_top_non_curr_tab_font_attr=> '',
  p_current_image_tab=> '',
  p_non_current_image_tab=> '',
  p_notification_message=> '<div class="t1notification">#MESSAGE#</div>',
  p_navigation_bar=> '<div class="t1NavigationBar">#BAR_BODY#</div>',
  p_navbar_entry=> '<a href="#LINK#" class="t1NavigationBar">#TEXT#</a>',
  p_app_tab_before_tabs=>'',
  p_app_tab_current_tab=>'',
  p_app_tab_non_current_tab=>'',
  p_app_tab_after_tabs=>'',
  p_region_table_cattributes=> ' summary="" cellpadding="0" border="0" cellspacing="0" width="100%"',
  p_breadcrumb_def_reg_pos => 'REGION_POSITION_01',
  p_theme_id  => 1,
  p_theme_class_id => 2,
  p_translate_this_template => 'N',
  p_template_comment => '');
end;
 
null;
 
end;
/

--application/shared_components/user_interface/templates/page/two_level_tabs_with_side_bar_de
prompt  ......Page template 91626101050381989.4414
 
begin
 
declare
  c1 varchar2(32767) := null;
  c2 varchar2(32767) := null;
  c3 varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
c1:=c1||'<html lang="&BROWSER_LANGUAGE." xmlns:htmldb="http://htmldb.oracle.com">'||chr(10)||
'<head>'||chr(10)||
'<title>#TITLE#</title>'||chr(10)||
'<link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_1/theme_V3.css" type="text/css" />'||chr(10)||
'#HEAD#'||chr(10)||
'</head>'||chr(10)||
'<body #ONLOAD#>#FORM_OPEN#';

c2:=c2||'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="">'||chr(10)||
'  <tr>'||chr(10)||
'    <td><img src="#IMAGE_PREFIX#themes/theme_1/bot_bar_left.png" alt="" /></td>'||chr(10)||
'    <td class="t1BotbarMiddle"><div id="t1user">&APP_USER.</div></td>'||chr(10)||
'    <td class="t1BotbarMiddle"><div id="t1copy"><!-- Copyright Here --><span class="t1Customize">#CUSTOMIZE#</span></div></td>'||chr(10)||
'    <td><img src="#IMAGE_PREFIX#themes/th';

c2:=c2||'eme_1/bot_bar_right.png" alt="" /></td>'||chr(10)||
'  </tr>'||chr(10)||
'</table>'||chr(10)||
'<br />'||chr(10)||
'#REGION_POSITION_05#'||chr(10)||
'#FORM_CLOSE# '||chr(10)||
'</body>'||chr(10)||
'</html>';

c3:=c3||'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="">'||chr(10)||
'  <tr>'||chr(10)||
'    <td valign="top" class="t1Logo">#LOGO##REGION_POSITION_06#</td>'||chr(10)||
'	<td valign="top" width="100%">#REGION_POSITION_07#</td>'||chr(10)||
'    <td align="right" valign="top">#NAVIGATION_BAR##REGION_POSITION_08#</td>'||chr(10)||
'  </tr>'||chr(10)||
'</table>'||chr(10)||
'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="" height="70%">'||chr(10)||
'  <tr>'||chr(10)||
'    ';

c3:=c3||'<td colspan="5" class="t1ParentTabHolder"><table border="0" cellpadding="0" cellspacing="0" summary="" align="right"><tr><td><br /></td>#PARENT_TAB_CELLS#</tr></table></td>'||chr(10)||
'  </tr>'||chr(10)||
'  <tr>'||chr(10)||
'    <td class="t1topbarLeft" valign="top"><img src="#IMAGE_PREFIX#themes/theme_1/top_bar_far_left.png" alt="" /></td>'||chr(10)||
'    <td class="t1topbarLeft" colspan="2"  valign="top"><img src="#IMAGE_PREFIX#themes/theme_1/';

c3:=c3||'top_barleft2_1.png" alt="" /></td>'||chr(10)||
'    <td class="t1topbarLeft" valign="top"><img src="#IMAGE_PREFIX#themes/theme_1/top_barleft2_2.png" alt="" /></td>'||chr(10)||
'    <td class="t1topbarMiddle" valign="top"><table height="100%" cellpadding="0" cellspacing="0" border="0" summary=""><tr><td height="20">#TAB_CELLS#</td></tr><tr><td valign="bottom" height="20">#REGION_POSITION_01#</td></tr></table></td>'||chr(10)||
'    <td v';

c3:=c3||'align="top"><img src="#IMAGE_PREFIX#themes/theme_1/top_bar_right.png" alt="" /></td>'||chr(10)||
'  </tr>'||chr(10)||
'  <tr>'||chr(10)||
'    <td class="t1PageLeft" colspan="3" align="left" valign="top">#REGION_POSITION_02#</td>'||chr(10)||
'    <td><br /></td>'||chr(10)||
'    <td class="t1PageRight" colspan="2" valign="top" height="100%"><table summary="" cellpadding="0" width="100%" cellspacing="0" border="0">'||chr(10)||
'<tr>'||chr(10)||
'<td width="100%" valign="top" class="t1Pag';

c3:=c3||'eBody"><div class="t1messages">#GLOBAL_NOTIFICATION##SUCCESS_MESSAGE##NOTIFICATION_MESSAGE#</div>#BOX_BODY##REGION_POSITION_04#</td>'||chr(10)||
'<td valign="top">#REGION_POSITION_03#<br /></td>'||chr(10)||
'</tr>'||chr(10)||
'</table></td>'||chr(10)||
'  </tr>'||chr(10)||
'</table>';

wwv_flow_api.create_template(
  p_id=> 91626101050381989.4414 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'Two Level Tabs with Side Bar.de',
  p_body_title=> '',
  p_header_template=> c1,
  p_box=> c3,
  p_footer_template=> c2,
  p_success_message=> '<div class="t1success">#SUCCESS_MESSAGE#</div>',
  p_current_tab=> '<span class="t1ChildTab">[&nbsp;#TAB_LABEL#&nbsp;]</span>#TAB_INLINE_EDIT#',
  p_current_tab_font_attr=> '',
  p_non_current_tab=> '<a href="#TAB_LINK#" class="t1ChildTab">#TAB_LABEL#</a>#TAB_INLINE_EDIT#',
  p_non_current_tab_font_attr => '',
  p_top_current_tab=> '<td><img src="#IMAGE_PREFIX#themes/theme_1/tab_on_left.png" border="0" alt="" /></td>'||chr(10)||
'<td class="t1ParentTabCenterOn">#TAB_LABEL##TAB_INLINE_EDIT#</td>'||chr(10)||
'<td><img src="#IMAGE_PREFIX#themes/theme_1/tab_on_right.png" border="0" alt="" /></td>',
  p_top_current_tab_font_attr => '',
  p_top_non_curr_tab=> '<td><img src="#IMAGE_PREFIX#themes/theme_1/tab_off_left.png" border="0" alt="" /></td>'||chr(10)||
'<td class="t1ParentTabCenterOff"><a href="#TAB_LINK#">#TAB_LABEL#</a>#TAB_INLINE_EDIT#</td>'||chr(10)||
'<td><img src="#IMAGE_PREFIX#themes/theme_1/tab_off_right.png" border="0" alt="" /></td>',
  p_top_non_curr_tab_font_attr=> '',
  p_current_image_tab=> '',
  p_non_current_image_tab=> '',
  p_notification_message=> '<div class="t1notification">#MESSAGE#</div>',
  p_navigation_bar=> '<div class="t1NavigationBar">#BAR_BODY#</div>',
  p_navbar_entry=> '<a href="#LINK#" class="t1NavigationBar">#TEXT#</a>',
  p_app_tab_before_tabs=>'',
  p_app_tab_current_tab=>'',
  p_app_tab_non_current_tab=>'',
  p_app_tab_after_tabs=>'',
  p_region_table_cattributes=> ' summary="" cellpadding="0" border="0" cellspacing="0" width="100%"',
  p_sidebar_def_reg_pos => 'REGION_POSITION_02',
  p_breadcrumb_def_reg_pos => 'REGION_POSITION_01',
  p_theme_id  => 1,
  p_theme_class_id => 18,
  p_translate_this_template => 'N',
  p_template_comment => '');
end;
 
null;
 
end;
/

--application/shared_components/user_interface/templates/page/one_level_tabs_with_side_bar_de
prompt  ......Page template 91626232237381989.4414
 
begin
 
declare
  c1 varchar2(32767) := null;
  c2 varchar2(32767) := null;
  c3 varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
c1:=c1||'<html lang="&BROWSER_LANGUAGE." xmlns:htmldb="http://htmldb.oracle.com">'||chr(10)||
'<head>'||chr(10)||
'<title>#TITLE#</title>'||chr(10)||
'<link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_1/theme_V3.css" type="text/css" />'||chr(10)||
'#HEAD#'||chr(10)||
'</head>'||chr(10)||
'<body #ONLOAD#>#FORM_OPEN#';

c2:=c2||'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="">'||chr(10)||
'  <tr>'||chr(10)||
'    <td><img src="#IMAGE_PREFIX#themes/theme_1/bot_bar_left.png" alt="" /></td>'||chr(10)||
'    <td class="t1BotbarMiddle"><div id="t1user">&APP_USER.</div></td>'||chr(10)||
'    <td class="t1BotbarMiddle"><div id="t1copy"><!-- Copyright Here --><span class="t1Customize">#CUSTOMIZE#</span></div></td>'||chr(10)||
'    <td><img src="#IMAGE_PREFIX#themes/th';

c2:=c2||'eme_1/bot_bar_right.png" alt="" /></td>'||chr(10)||
'  </tr>'||chr(10)||
'</table>'||chr(10)||
'<br />'||chr(10)||
'#REGION_POSITION_05#'||chr(10)||
'#FORM_CLOSE# '||chr(10)||
'</body>'||chr(10)||
'</html>';

c3:=c3||'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="">'||chr(10)||
'  <tr>'||chr(10)||
'    <td valign="top" class="t1Logo">#LOGO##REGION_POSITION_06#</td>'||chr(10)||
'	<td valign="top" width="100%">#REGION_POSITION_07#</td>'||chr(10)||
'    <td align="right" valign="top">#NAVIGATION_BAR##REGION_POSITION_08#</td>'||chr(10)||
'  </tr>'||chr(10)||
'</table>'||chr(10)||
'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="" height="70%">'||chr(10)||
'  <tr>'||chr(10)||
'    ';

c3:=c3||'<td colspan="5" class="t1ParentTabHolder"><table border="0" cellpadding="0" cellspacing="0" summary="" align="right"><tr><td><br /></td>#TAB_CELLS#</tr></table></td>'||chr(10)||
'  </tr>'||chr(10)||
'  <tr>'||chr(10)||
'    <td class="t1topbarLeft" valign="top"><img src="#IMAGE_PREFIX#themes/theme_1/top_bar_far_left.png" alt="" /></td>'||chr(10)||
'    <td align="right" class="t1topbarLeft" colspan="2"  valign="top"><img src="#IMAGE_PREFIX#themes/t';

c3:=c3||'heme_1/top_barleft2_1.png" alt="" /></td>'||chr(10)||
'    <td align="right" class="t1topbarLeft" valign="top"><img src="#IMAGE_PREFIX#themes/theme_1/top_barleft2_2.png" alt="" /></td>'||chr(10)||
'    <td class="t1topbarMiddle" valign="top"><table height="100%" cellpadding="0" cellspacing="0" border="0" summary=""><tr><td height="20"><br /></td></tr><tr><td valign="bottom" height="20">#REGION_POSITION_01#</td></tr></table';

c3:=c3||'></td>'||chr(10)||
'    <td valign="top"><img src="#IMAGE_PREFIX#themes/theme_1/top_bar_right.png" alt="" /></td>'||chr(10)||
'  </tr>'||chr(10)||
'  <tr>'||chr(10)||
'    <td class="t1PageLeft" colspan="3" align="left" valign="top">#REGION_POSITION_02#</td>'||chr(10)||
'    <td><br /></td>'||chr(10)||
'    <td class="t1PageRight" colspan="2" valign="top" height="100%"><table summary="" cellpadding="0" width="100%" cellspacing="0" border="0">'||chr(10)||
'<tr>'||chr(10)||
'<td width="100%" valign="t';

c3:=c3||'op" class="t1PageBody"><div class="t1messages">#GLOBAL_NOTIFICATION##SUCCESS_MESSAGE##NOTIFICATION_MESSAGE#</div>#BOX_BODY##REGION_POSITION_04#</td>'||chr(10)||
'<td valign="top">#REGION_POSITION_03#<br /></td>'||chr(10)||
'</tr>'||chr(10)||
'</table></td>'||chr(10)||
'  </tr>'||chr(10)||
'</table>';

wwv_flow_api.create_template(
  p_id=> 91626232237381989.4414 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'One Level Tabs with Side Bar.de',
  p_body_title=> '',
  p_header_template=> c1,
  p_box=> c3,
  p_footer_template=> c2,
  p_success_message=> '<div class="t1success">#SUCCESS_MESSAGE#</div>',
  p_current_tab=> '<td><img src="#IMAGE_PREFIX#themes/theme_1/tab_on_left.png" border="0" alt="" /></td>'||chr(10)||
'<td class="t1ParentTabCenterOn">#TAB_LABEL##TAB_INLINE_EDIT#</td>'||chr(10)||
'<td><img src="#IMAGE_PREFIX#themes/theme_1/tab_on_right.png" border="0" alt="" /></td>'||chr(10)||
'',
  p_current_tab_font_attr=> '',
  p_non_current_tab=> '<td><img src="#IMAGE_PREFIX#themes/theme_1/tab_off_left.png" border="0" alt="" /></td>'||chr(10)||
'<td class="t1ParentTabCenterOff"><a href="#TAB_LINK#">#TAB_LABEL#</a>#TAB_INLINE_EDIT#</td>'||chr(10)||
'<td><img src="#IMAGE_PREFIX#themes/theme_1/tab_off_right.png" border="0" alt="" /></td>'||chr(10)||
'',
  p_non_current_tab_font_attr => '',
  p_top_current_tab=> '',
  p_top_current_tab_font_attr => '',
  p_top_non_curr_tab=> '',
  p_top_non_curr_tab_font_attr=> '',
  p_current_image_tab=> '',
  p_non_current_image_tab=> '',
  p_notification_message=> '<div class="t2notification">#MESSAGE#</div>',
  p_navigation_bar=> '<div class="t1NavigationBar">#BAR_BODY#</div>',
  p_navbar_entry=> '<a href="#LINK#" class="t1NavigationBar">#TEXT#</a>',
  p_app_tab_before_tabs=>'',
  p_app_tab_current_tab=>'',
  p_app_tab_non_current_tab=>'',
  p_app_tab_after_tabs=>'',
  p_region_table_cattributes=> ' summary="" cellpadding="0" border="0" cellspacing="0" width="100%"',
  p_sidebar_def_reg_pos => 'REGION_POSITION_02',
  p_breadcrumb_def_reg_pos => 'REGION_POSITION_01',
  p_theme_id  => 1,
  p_theme_class_id => 16,
  p_translate_this_template => 'N',
  p_template_comment => '');
end;
 
null;
 
end;
/

--application/shared_components/user_interface/templates/page/no_tabs_with_side_bar_de
prompt  ......Page template 91626321000381989.4414
 
begin
 
declare
  c1 varchar2(32767) := null;
  c2 varchar2(32767) := null;
  c3 varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
c1:=c1||'<html lang="&BROWSER_LANGUAGE." xmlns:htmldb="http://htmldb.oracle.com">'||chr(10)||
'<head>'||chr(10)||
'<title>#TITLE#</title>'||chr(10)||
'<link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_1/theme_V3.css" type="text/css" />'||chr(10)||
'#HEAD#'||chr(10)||
'</head>'||chr(10)||
'<body #ONLOAD#>#FORM_OPEN#';

c2:=c2||'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="">'||chr(10)||
'  <tr>'||chr(10)||
'    <td><img src="#IMAGE_PREFIX#themes/theme_1/bot_bar_left.png" alt="" /></td>'||chr(10)||
'    <td class="t1BotbarMiddle"><div id="t1user">&APP_USER.</div></td>'||chr(10)||
'    <td class="t1BotbarMiddle"><div id="t1copy"><!-- Copyright Here --><span class="t1Customize">#CUSTOMIZE#</span></div></td>'||chr(10)||
'    <td><img src="#IMAGE_PREFIX#themes/th';

c2:=c2||'eme_1/bot_bar_right.png" alt="" /></td>'||chr(10)||
'  </tr>'||chr(10)||
'</table>'||chr(10)||
'<br />'||chr(10)||
'#REGION_POSITION_05#'||chr(10)||
'#FORM_CLOSE# '||chr(10)||
'</body>'||chr(10)||
'</html>';

c3:=c3||'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="">'||chr(10)||
'  <tr>'||chr(10)||
'    <td valign="top" class="t1Logo">#LOGO##REGION_POSITION_06#</td>'||chr(10)||
'	<td valign="top" width="100%">#REGION_POSITION_07#</td>'||chr(10)||
'    <td align="right" valign="top">#NAVIGATION_BAR##REGION_POSITION_08#</td>'||chr(10)||
'  </tr>'||chr(10)||
'</table>'||chr(10)||
'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="" height="70%">'||chr(10)||
'  <tr>'||chr(10)||
'    ';

c3:=c3||'<td class="t1topbarLeft" valign="top"><img src="#IMAGE_PREFIX#themes/theme_1/top_bar_far_left.png" alt="" /></td>'||chr(10)||
'    <td align="right" class="t1topbarLeft" colspan="2"  valign="top"><img src="#IMAGE_PREFIX#themes/theme_1/top_barleft2_1.png" alt="" /></td>'||chr(10)||
'    <td align="right" class="t1topbarLeft" valign="top"><img src="#IMAGE_PREFIX#themes/theme_1/top_barleft2_2.png" alt="" /></td>'||chr(10)||
'    <td class';

c3:=c3||'="t1topbarMiddle" valign="top"><table height="100%" cellpadding="0" cellspacing="0" border="0" summary=""><tr><td height="20"><br /></td></tr><tr><td valign="bottom" height="20">#REGION_POSITION_01#</td></tr></table></td>'||chr(10)||
'    <td valign="top"><img src="#IMAGE_PREFIX#themes/theme_1/top_bar_right.png" alt="" /></td>'||chr(10)||
'  </tr>'||chr(10)||
'  <tr>'||chr(10)||
'    <td class="t1PageLeft" colspan="3" align="left" valign="top">#REG';

c3:=c3||'ION_POSITION_02#</td>'||chr(10)||
'    <td><br /></td>'||chr(10)||
'    <td class="t1PageRight" colspan="2" valign="top" height="100%"><table summary="" cellpadding="0" width="100%" cellspacing="0" border="0">'||chr(10)||
'<tr>'||chr(10)||
'<td width="100%" valign="top" class="t1PageBody"><div class="t1messages">#GLOBAL_NOTIFICATION##SUCCESS_MESSAGE##NOTIFICATION_MESSAGE#</div>#BOX_BODY##REGION_POSITION_04#</td>'||chr(10)||
'<td valign="top">#REGION_POSITION_03';

c3:=c3||'#<br /></td>'||chr(10)||
'</tr>'||chr(10)||
'</table></td>'||chr(10)||
'  </tr>'||chr(10)||
'</table>';

wwv_flow_api.create_template(
  p_id=> 91626321000381989.4414 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'No Tabs with Side Bar.de',
  p_body_title=> '',
  p_header_template=> c1,
  p_box=> c3,
  p_footer_template=> c2,
  p_success_message=> '<div class="t1success">#SUCCESS_MESSAGE#</div>',
  p_current_tab=> '',
  p_current_tab_font_attr=> '',
  p_non_current_tab=> '',
  p_non_current_tab_font_attr => '',
  p_top_current_tab=> '',
  p_top_current_tab_font_attr => '',
  p_top_non_curr_tab=> '',
  p_top_non_curr_tab_font_attr=> '',
  p_current_image_tab=> '',
  p_non_current_image_tab=> '',
  p_notification_message=> '<div class="t1notification">#MESSAGE#</div>',
  p_navigation_bar=> '<div class="t1NavigationBar">#BAR_BODY#</div>',
  p_navbar_entry=> '<a href="#LINK#" class="t1NavigationBar">#TEXT#</a>',
  p_app_tab_before_tabs=>'',
  p_app_tab_current_tab=>'',
  p_app_tab_non_current_tab=>'',
  p_app_tab_after_tabs=>'',
  p_region_table_cattributes=> 'summary="" cellpadding="0" border="0" cellspacing="0" width="100%"',
  p_sidebar_def_reg_pos => 'REGION_POSITION_02',
  p_breadcrumb_def_reg_pos => 'REGION_POSITION_01',
  p_theme_id  => 1,
  p_theme_class_id => 17,
  p_translate_this_template => 'N',
  p_template_comment => '');
end;
 
null;
 
end;
/

--application/shared_components/user_interface/templates/page/one_level_tabs_de
prompt  ......Page template 91626406749381989.4414
 
begin
 
declare
  c1 varchar2(32767) := null;
  c2 varchar2(32767) := null;
  c3 varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
c1:=c1||'<html lang="&BROWSER_LANGUAGE." xmlns:htmldb="http://htmldb.oracle.com">'||chr(10)||
'<head>'||chr(10)||
'<title>#TITLE#</title>'||chr(10)||
'<link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_1/theme_V3.css" type="text/css" />'||chr(10)||
'#HEAD#'||chr(10)||
'</head>'||chr(10)||
'<body #ONLOAD#>#FORM_OPEN#';

c2:=c2||'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="">'||chr(10)||
'  <tr>'||chr(10)||
'    <td><img src="#IMAGE_PREFIX#themes/theme_1/bot_bar_left.png" alt="" /></td>'||chr(10)||
'    <td class="t1BotbarMiddle"><div id="t1user">&APP_USER.</div></td>'||chr(10)||
'    <td class="t1BotbarMiddle"><div id="t1copy"><!-- Copyright Here --><span class="t1Customize">#CUSTOMIZE#</span></div></td>'||chr(10)||
'    <td><img src="#IMAGE_PREFIX#themes/th';

c2:=c2||'eme_1/bot_bar_right.png" alt="" /></td>'||chr(10)||
'  </tr>'||chr(10)||
'</table>'||chr(10)||
'<br />'||chr(10)||
'#REGION_POSITION_05#'||chr(10)||
'#FORM_CLOSE# '||chr(10)||
'</body>'||chr(10)||
'</html>';

c3:=c3||'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="">'||chr(10)||
'  <tr>'||chr(10)||
'    <td valign="top" class="t1Logo">#LOGO##REGION_POSITION_06#</td>'||chr(10)||
'	<td valign="top" width="100%">#REGION_POSITION_07#</td>'||chr(10)||
'    <td align="right" valign="top">#NAVIGATION_BAR##REGION_POSITION_08#</td>'||chr(10)||
'  </tr>'||chr(10)||
'</table>'||chr(10)||
'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="" height="70%">'||chr(10)||
'  <tr>'||chr(10)||
'    ';

c3:=c3||'<td colspan="5" class="t1ParentTabHolder"><table border="0" cellpadding="0" cellspacing="0" summary="" align="right"><tr><td><br /></td>#TAB_CELLS#</tr></table></td>'||chr(10)||
'  </tr>'||chr(10)||
'  <tr>'||chr(10)||
'    <td valign="top"><img src="#IMAGE_PREFIX#themes/theme_1/top_bar_left.png" alt="" /></td>'||chr(10)||
'    <td class="t1topbarMiddle" valign="bottom"><table cellpadding="0" cellspacing="0" border="0" summary=""><tr><td height="50';

c3:=c3||'%"><br /></td></tr><tr><td height="50%">#REGION_POSITION_01#</td></tr></table></td>'||chr(10)||
'    <td valign="top"><img src="#IMAGE_PREFIX#themes/theme_1/top_bar_right.png" alt="" /></td>'||chr(10)||
'  </tr>'||chr(10)||
'<tr>'||chr(10)||
'<td><br /></td>'||chr(10)||
'<td class="t1PageCenter" colspan="2" valign="top" height="100%"><table summary="" cellpadding="0" width="100%" cellspacing="0" border="0">'||chr(10)||
'<tr>'||chr(10)||
'<td width="100%" valign="top" class="t1PageBody">';

c3:=c3||'<div class="t1messages">#GLOBAL_NOTIFICATION##SUCCESS_MESSAGE##NOTIFICATION_MESSAGE#</div>#BOX_BODY##REGION_POSITION_02##REGION_POSITION_04#</td>'||chr(10)||
'<td valign="top">#REGION_POSITION_03#<br /></td>'||chr(10)||
'</tr>'||chr(10)||
'</table></td>'||chr(10)||
'</tr>'||chr(10)||
'</table>';

wwv_flow_api.create_template(
  p_id=> 91626406749381989.4414 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'One Level Tabs.de',
  p_body_title=> '',
  p_header_template=> c1,
  p_box=> c3,
  p_footer_template=> c2,
  p_success_message=> '<div class="t1success">#SUCCESS_MESSAGE#</div>',
  p_current_tab=> '<td><img src="#IMAGE_PREFIX#themes/theme_1/tab_on_left.png" border="0" alt="" /></td>'||chr(10)||
'<td class="t1ParentTabCenterOn">#TAB_LABEL##TAB_INLINE_EDIT#</td>'||chr(10)||
'<td><img src="#IMAGE_PREFIX#themes/theme_1/tab_on_right.png" border="0" alt="" /></td>'||chr(10)||
''||chr(10)||
'',
  p_current_tab_font_attr=> '',
  p_non_current_tab=> '<td><img src="#IMAGE_PREFIX#themes/theme_1/tab_off_left.png" border="0" alt="" /></td>'||chr(10)||
'<td class="t1ParentTabCenterOff"><a href="#TAB_LINK#">#TAB_LABEL#</a>#TAB_INLINE_EDIT#</td>'||chr(10)||
'<td><img src="#IMAGE_PREFIX#themes/theme_1/tab_off_right.png" border="0" alt="" /></td>'||chr(10)||
'',
  p_non_current_tab_font_attr => '',
  p_top_current_tab=> '',
  p_top_current_tab_font_attr => '',
  p_top_non_curr_tab=> '',
  p_top_non_curr_tab_font_attr=> '',
  p_current_image_tab=> '',
  p_non_current_image_tab=> '',
  p_notification_message=> '<div class="t1notification">#MESSAGE#</div>',
  p_navigation_bar=> '<div class="t1NavigationBar">#BAR_BODY#</div>',
  p_navbar_entry=> '<a href="#LINK#" class="t1NavigationBar">#TEXT#</a>',
  p_app_tab_before_tabs=>'',
  p_app_tab_current_tab=>'',
  p_app_tab_non_current_tab=>'',
  p_app_tab_after_tabs=>'',
  p_region_table_cattributes=> ' summary="" cellpadding="0" border="0" cellspacing="0" width="100%"',
  p_breadcrumb_def_reg_pos => 'REGION_POSITION_01',
  p_theme_id  => 1,
  p_theme_class_id => 1,
  p_translate_this_template => 'N',
  p_template_comment => '12');
end;
 
null;
 
end;
/

--application/shared_components/user_interface/templates/page/printer_friendly_de
prompt  ......Page template 91626529080381989.4414
 
begin
 
declare
  c1 varchar2(32767) := null;
  c2 varchar2(32767) := null;
  c3 varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
c1:=c1||'<html lang="&BROWSER_LANGUAGE." xmlns:htmldb="http://htmldb.oracle.com">'||chr(10)||
'<head>'||chr(10)||
'<title>#TITLE#</title>'||chr(10)||
'<link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_1/theme_V3.css" type="text/css" />'||chr(10)||
'#HEAD#'||chr(10)||
'</head>'||chr(10)||
'<body #ONLOAD#>#FORM_OPEN#';

c2:=c2||'#FORM_CLOSE#</body>'||chr(10)||
'</html>';

c3:=c3||'<table summary="" cellpadding="0" width="100%" cellspacing="0" border="0">'||chr(10)||
'<tr>'||chr(10)||
'<td width="100%" valign="top">'||chr(10)||
'<div style="border:1px solid black;">#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE#</div>'||chr(10)||
'#BOX_BODY##REGION_POSITION_04#</td>'||chr(10)||
'<td valign="top">#REGION_POSITION_03#<br /></td>'||chr(10)||
'</tr>'||chr(10)||
'</table>';

wwv_flow_api.create_template(
  p_id=> 91626529080381989.4414 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'Printer Friendly.de',
  p_body_title=> '',
  p_header_template=> c1,
  p_box=> c3,
  p_footer_template=> c2,
  p_success_message=> '',
  p_current_tab=> '',
  p_current_tab_font_attr=> '',
  p_non_current_tab=> '',
  p_non_current_tab_font_attr => '',
  p_top_current_tab=> '',
  p_top_current_tab_font_attr => '',
  p_top_non_curr_tab=> '',
  p_top_non_curr_tab_font_attr=> '',
  p_current_image_tab=> '',
  p_non_current_image_tab=> '',
  p_notification_message=> '',
  p_navigation_bar=> '',
  p_navbar_entry=> '',
  p_app_tab_before_tabs=>'',
  p_app_tab_current_tab=>'',
  p_app_tab_non_current_tab=>'',
  p_app_tab_after_tabs=>'',
  p_region_table_cattributes=> ' summary="" cellpadding="0" border="0" cellspacing="0" width="100%"',
  p_theme_id  => 1,
  p_theme_class_id => 5,
  p_translate_this_template => 'N',
  p_template_comment => '3');
end;
 
null;
 
end;
/

--application/shared_components/user_interface/templates/page/popup_de
prompt  ......Page template 91626623032381989.4414
 
begin
 
declare
  c1 varchar2(32767) := null;
  c2 varchar2(32767) := null;
  c3 varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
c1:=c1||'<html lang="&BROWSER_LANGUAGE." xmlns:htmldb="http://htmldb.oracle.com">'||chr(10)||
'<head>'||chr(10)||
'<title>#TITLE#</title>'||chr(10)||
'<link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_1/theme_V3.css" type="text/css" />'||chr(10)||
'#HEAD#'||chr(10)||
'</head>'||chr(10)||
'<body #ONLOAD#>#FORM_OPEN#';

c2:=c2||'#FORM_CLOSE#</body>'||chr(10)||
'</html>';

c3:=c3||'<table summary="" cellpadding="0" width="100%" cellspacing="0" border="0">'||chr(10)||
'<tr>'||chr(10)||
'<td width="100%" valign="top"><div class="t1messages">#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE#</div>#BOX_BODY##REGION_POSITION_01##REGION_POSITION_02##REGION_POSITION_04##REGION_POSITION_05##REGION_POSITION_06##REGION_POSITION_07##REGION_POSITION_08#</td>'||chr(10)||
'<td valign="top">#REGION_POSITION_03#<br /></td>'||chr(10)||
'</tr>'||chr(10)||
'</table>';

wwv_flow_api.create_template(
  p_id=> 91626623032381989.4414 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'Popup.de',
  p_body_title=> '',
  p_header_template=> c1,
  p_box=> c3,
  p_footer_template=> c2,
  p_success_message=> '<div class="t1success">#SUCCESS_MESSAGE#</div>',
  p_current_tab=> '',
  p_current_tab_font_attr=> '',
  p_non_current_tab=> '',
  p_non_current_tab_font_attr => '',
  p_top_current_tab=> '',
  p_top_current_tab_font_attr => '',
  p_top_non_curr_tab=> '',
  p_top_non_curr_tab_font_attr=> '',
  p_current_image_tab=> '',
  p_non_current_image_tab=> '',
  p_notification_message=> '<div class="t1notification">#MESSAGE#</div>',
  p_navigation_bar=> '#BAR_BODY#',
  p_navbar_entry=> '<a href="#LINK#">#TEXT#</a>',
  p_app_tab_before_tabs=>'',
  p_app_tab_current_tab=>'',
  p_app_tab_non_current_tab=>'',
  p_app_tab_after_tabs=>'',
  p_region_table_cattributes=> ' summary="" cellpadding="0" border="0" cellspacing="0" width="100%"',
  p_theme_id  => 1,
  p_theme_class_id => 4,
  p_translate_this_template => 'N',
  p_template_comment => '');
end;
 
null;
 
end;
/

prompt  ...button templates
--
--application/shared_components/user_interface/templates/button/button
prompt  ......Button Template 91626823864381990.4414
declare
  t varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
t:=t||'<table class="t1Button" cellspacing="0" cellpadding="0" border="0"  summary="">'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1L"><a href="#LINK#"><img src="#IMAGE_PREFIX#themes/theme_1/button_left.gif" alt="" width="4" height="24" /></a></td>'||chr(10)||
'<td class="t1C"><a href="#LINK#">#LABEL#</a></td>'||chr(10)||
'<td class="t1R"><a href="#LINK#"><img src="#IMAGE_PREFIX#themes/theme_1/button_right.gif" width="4" height="24" alt="" /></a></td>'||chr(10)||
'</tr';

t:=t||'>'||chr(10)||
'</table>';

wwv_flow_api.create_button_templates (
  p_id=>91626823864381990.4414 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_template=>t,
  p_template_name=> 'Button',
  p_translate_this_template => 'N',
  p_theme_id  => 1,
  p_theme_class_id => 1,
  p_template_comment       => '');
end;
/
---------------------------------------
prompt  ...region templates
--
--application/shared_components/user_interface/templates/region/report_list
prompt  ......region template 91627404948381991.4414
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table cellpadding="0" cellspacing="0" border="0" summary="" class="t1ListRegionwithIcon" id="#REGION_ID#">'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1RegionHeader">#TITLE#</td>'||chr(10)||
'<td class="t1ButtonHolder">#CLOSE#&nbsp;&nbsp;&nbsp;#PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##HELP#</td>'||chr(10)||
'</tr>'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1Body" colspan="2"><table cellpadding="0" cellspacing="0" border="0" summary="" ><tr>'||chr(10)||
'<td valign="top"><img src="#';

t:=t||'IMAGE_PREFIX#themes/theme_1/report.gif" alt=""/></td>'||chr(10)||
'<td>#BODY#</td></tr></table></td>'||chr(10)||
'</tr>'||chr(10)||
'</table>';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 91627404948381991.4414 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Report List',
  p_plug_table_bgcolor     => '#ffffff',
  p_theme_id  => 1,
  p_theme_class_id => 29,
  p_plug_heading_bgcolor => '#ffffff',
  p_plug_font_size => '-1',
  p_translate_this_template => 'N',
  p_template_comment       => 'Red Theme');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 91627404948381991.4414 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/chart_list
prompt  ......region template 91627727983381992.4414
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table cellpadding="0" cellspacing="0" border="0" summary="" class="t1ListRegionwithIcon" id="#REGION_ID#">'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1RegionHeader">#TITLE#</td>'||chr(10)||
'<td class="t1ButtonHolder">#CLOSE#&nbsp;&nbsp;&nbsp;#PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##HELP#</td>'||chr(10)||
'</tr>'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1Body" colspan="2"><table cellpadding="0" cellspacing="0" border="0" summary="" ><tr><td valign="top"><img src="#I';

t:=t||'MAGE_PREFIX#themes/theme_1/chart.gif" alt=""/></td>'||chr(10)||
'<td>#BODY#</td></tr></table></td>'||chr(10)||
'</tr>'||chr(10)||
'</table>';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 91627727983381992.4414 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Chart List',
  p_plug_table_bgcolor     => '#ffffff',
  p_theme_id  => 1,
  p_theme_class_id => 29,
  p_plug_heading_bgcolor => '#ffffff',
  p_plug_font_size => '-1',
  p_translate_this_template => 'N',
  p_template_comment       => 'Red Theme');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 91627727983381992.4414 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/region_without_title
prompt  ......region template 91628005149381992.4414
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table cellpadding="0" cellspacing="0" border="0" summary="" class="t1RegionwithoutTitle" id="#REGION_ID#">'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1ButtonHolder">#CLOSE#&nbsp;&nbsp;&nbsp;#PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##HELP#</td>'||chr(10)||
'</tr>'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1Body">#BODY#</td>'||chr(10)||
'</tr>'||chr(10)||
'</table>';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 91628005149381992.4414 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Region without Title',
  p_plug_table_bgcolor     => '',
  p_theme_id  => 1,
  p_theme_class_id => 11,
  p_plug_heading_bgcolor => '',
  p_plug_font_size => '',
  p_translate_this_template => 'N',
  p_template_comment       => '');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 91628005149381992.4414 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/hide_and_show_region
prompt  ......region template 91628313436381993.4414
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table cellpadding="0" cellspacing="0" border="0" summary="" class="t1HideandShowRegion" id="#REGION_ID#">'||chr(10)||
'<tr>'||chr(10)||
'<td><table width="100%" cellpadding="0" cellspacing="0" border="0" summary="">'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1RegionHeader">#TITLE#<a style="margin-left:5px;" href="javascript:hideShow(''region#REGION_SEQUENCE_ID#'',''shIMG#REGION_SEQUENCE_ID#'',''#IMAGE_PREFIX#themes/theme_1/rollup_plus_dgray.gif'',''#IMAG';

t:=t||'E_PREFIX#themes/theme_1/rollup_minus_dgray.gif'');" class="t1HideandShowRegionLink"><img src="#IMAGE_PREFIX#themes/theme_1/rollup_plus_dgray.gif" '||chr(10)||
'  id="shIMG#REGION_SEQUENCE_ID#" alt="" /></a></td>'||chr(10)||
'<td class="t1ButtonHolder">#CLOSE#&nbsp;&nbsp;&nbsp;#PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##HELP#</td>'||chr(10)||
'</tr>'||chr(10)||
'</table></td>'||chr(10)||
'</tr>'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1Body"><div class="t1Hide" id="region#REGION_SEQU';

t:=t||'ENCE_ID#">#BODY#</div></td>'||chr(10)||
'</tr>'||chr(10)||
'</table>';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 91628313436381993.4414 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Hide and Show Region',
  p_plug_table_bgcolor     => '',
  p_theme_id  => 1,
  p_theme_class_id => 1,
  p_plug_heading_bgcolor => '',
  p_plug_font_size => '',
  p_translate_this_template => 'N',
  p_template_comment       => 'Gray Head, white body');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 91628313436381993.4414 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/button_region_without_title
prompt  ......region template 91628622914381993.4414
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table cellpadding="0" cellspacing="0" border="0" summary="" class="t1ButtonRegionwithoutTitle" id="#REGION_ID#">'||chr(10)||
'<tr><td class="t1ButtonHolder">#CLOSE#&nbsp;&nbsp;&nbsp;#PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##HELP#<img src="#IMAGE_PREFIX#/themes/theme_1/1px_trans.gif" height="1" width="600" style="display:block;" alt="" /></td></tr>'||chr(10)||
'</table>'||chr(10)||
'#BODY#';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 91628622914381993.4414 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Button Region without Title',
  p_plug_table_bgcolor     => '',
  p_theme_id  => 1,
  p_theme_class_id => 17,
  p_plug_heading_bgcolor => '',
  p_plug_font_size => '',
  p_translate_this_template => 'N',
  p_template_comment       => '');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 91628622914381993.4414 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/region_without_buttons_and_titles
prompt  ......region template 91628912641381993.4414
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table summary="" cellpadding="0" cellspacing="0" border="0" class="t1RegionwithoutButtonsandTitles" id="#REGION_ID#">'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1Body">#BODY#</td>'||chr(10)||
'</tr>'||chr(10)||
'</table>'||chr(10)||
''||chr(10)||
'';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 91628912641381993.4414 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Region without Buttons and Titles',
  p_plug_table_bgcolor     => '',
  p_theme_id  => 1,
  p_theme_class_id => 19,
  p_plug_heading_bgcolor => '',
  p_plug_font_size => '',
  p_translate_this_template => 'N',
  p_template_comment       => '');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 91628912641381993.4414 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/reports_region_alternative_1
prompt  ......region template 91629226514381996.4414
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table cellpadding="0" cellspacing="0" border="0" summary="" class="t1ReportsRegionAlternative1" id="#REGION_ID#">'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1RegionHeader">#TITLE#</td>'||chr(10)||
'<td class="t1ButtonHolder">#CLOSE#&nbsp;&nbsp;&nbsp;#PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##HELP#</td>'||chr(10)||
'</tr>'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1Body" colspan="2">#BODY#</td>'||chr(10)||
'</tr>'||chr(10)||
'</table>';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 91629226514381996.4414 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Reports Region, Alternative 1',
  p_plug_table_bgcolor     => '#ffffff',
  p_theme_id  => 1,
  p_theme_class_id => 10,
  p_plug_heading_bgcolor => '#ffffff',
  p_plug_font_size => '-1',
  p_translate_this_template => 'N',
  p_template_comment       => 'Red Theme');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 91629226514381996.4414 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/borderless_region
prompt  ......region template 91629526498381997.4414
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table cellpadding="0" cellspacing="0" border="0" summary="" class="t1BorderlessRegion" id="#REGION_ID#">'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1RegionHeader">#TITLE#</td>'||chr(10)||
'<td class="t1ButtonHolder">#CLOSE#&nbsp;&nbsp;&nbsp;#PREVIOUS##NEXT##DELETE##EDIT##CHANGE##COPY##CREATE##CREATE2##EXPAND##HELP#</td>'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1Body" colspan="2">#BODY#</td>'||chr(10)||
'</tr>'||chr(10)||
'</table>';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 91629526498381997.4414 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Borderless Region',
  p_plug_table_bgcolor     => '',
  p_theme_id  => 1,
  p_theme_class_id => 7,
  p_plug_heading_bgcolor => '',
  p_plug_font_size => '',
  p_translate_this_template => 'N',
  p_template_comment       => 'Use this region template when you want to contain content without a border.'||chr(10)||
''||chr(10)||
'TITLE=YES'||chr(10)||
'BUTTONS=YES'||chr(10)||
'100% WIDTH=NO');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 91629526498381997.4414 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/button_region_with_title
prompt  ......region template 91629802954381997.4414
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table cellpadding="0" cellspacing="0" border="0" summary="" class="t1ButtonRegionwithTitle" id="#REGION_ID#">'||chr(10)||
'<tr><td class="t1RegionHeader">#TITLE#</td></tr>'||chr(10)||
'<tr><td class="t1ButtonHolder">#CLOSE#&nbsp;&nbsp;&nbsp;#PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##CREATE2##COPY##EXPAND##HELP#<img src="#IMAGE_PREFIX#/themes/theme_1/1px_trans.gif" height="1" width="600" style="display:block;" alt="" /';

t:=t||'></td></tr>'||chr(10)||
'</table>#BODY#'||chr(10)||
'';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 91629802954381997.4414 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Button Region with Title',
  p_plug_table_bgcolor     => '',
  p_theme_id  => 1,
  p_theme_class_id => 4,
  p_plug_heading_bgcolor => '',
  p_plug_font_size => '',
  p_translate_this_template => 'N',
  p_template_comment       => '');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 91629802954381997.4414 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/sidebar_region_alternative_1
prompt  ......region template 91630115446381997.4414
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table cellspacing="0" cellpadding="0" border="0" class="t1SidebarRegionAlternative1" summary="" id="#REGION_ID#" align="right">'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1EndCaps" valign="top"><img src="#IMAGE_PREFIX#themes/theme_1/left_curve.gif" width="10" height="20" alt="" /></td>'||chr(10)||
'<td class="t1RegionHeader">#TITLE#</td>'||chr(10)||
'<td class="t1EndCaps" valign="top"><img src="#IMAGE_PREFIX#themes/theme_1/right_curve.gif" width="';

t:=t||'10" height="20" alt="" /></td>'||chr(10)||
'</tr>'||chr(10)||
'<tr>'||chr(10)||
'<td colspan="3" class="t1Body">#BODY#</td>'||chr(10)||
'</tr>'||chr(10)||
'</table><br />';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 91630115446381997.4414 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Sidebar Region, Alternative 1',
  p_plug_table_bgcolor     => '#f7f7e7',
  p_theme_id  => 1,
  p_theme_class_id => 3,
  p_plug_heading_bgcolor => '#f7f7e7',
  p_plug_font_size => '-1',
  p_translate_this_template => 'N',
  p_template_comment       => '');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 91630115446381997.4414 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/sidebar_region
prompt  ......region template 91630411450381997.4414
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table cellspacing="0" cellpadding="0" border="0" class="t1SidebarRegion" summary="" id="#REGION_ID#" align="right">'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1EndCaps" valign="top"><img src="#IMAGE_PREFIX#themes/theme_1/left_curve.gif" width="10" height="20" alt="" /></td>'||chr(10)||
'<td class="t1RegionHeader">#TITLE#</td>'||chr(10)||
'<td class="t1EndCaps" valign="top"><img src="#IMAGE_PREFIX#themes/theme_1/right_curve.gif" width="10" height="';

t:=t||'20" alt="" /></td>'||chr(10)||
'</tr>'||chr(10)||
'<tr>'||chr(10)||
'<td colspan="3" class="t1Body">#BODY#</td>'||chr(10)||
'</tr>'||chr(10)||
'</table><br />';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 91630411450381997.4414 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Sidebar Region',
  p_plug_table_bgcolor     => '#f7f7e7',
  p_theme_id  => 1,
  p_theme_class_id => 2,
  p_plug_heading_bgcolor => '#f7f7e7',
  p_plug_font_size => '-1',
  p_translate_this_template => 'N',
  p_template_comment       => '<table border="0" cellpadding="0" cellspacing="0">'||chr(10)||
'        <tr>'||chr(10)||
'          <td rowspan="2" valign="top" width="4" bgcolor="#FF0000"><img src="#IMAGE_PREFIX#tl_img.gif" border="0" width="4" height="18" alt="" /></td>'||chr(10)||
'          <td bgcolor="#000000" height="1"><img src="#IMAGE_PREFIX#stretch.gif" width="142" height="1" border="0" alt="" /></td>'||chr(10)||
'          <td rowspan="2" valign="top" width="4" bgcolor="#FF0000"><img src="#IMAGE_PREFIX#tr_img.gif" border="0" width="4" height="18" alt="" /></td>'||chr(10)||
'        </tr>'||chr(10)||
'        <tr>'||chr(10)||
'          <td bgcolor="#FF0000" height="16">'||chr(10)||
'            <table border="0" cellpadding="0" cellspacing="0" width="100%">'||chr(10)||
'              <tr>'||chr(10)||
'                <td align=middle valign="top">'||chr(10)||
'                  <div align="center">'||chr(10)||
'                     <font color="#ffffff" face="Arial, Helvetica, sans-serif" size="1">'||chr(10)||
'                      <b>#TITLE# </b></font></div>'||chr(10)||
'                </td>'||chr(10)||
'              </tr>'||chr(10)||
'            </table>'||chr(10)||
'          </td>'||chr(10)||
'        </tr>'||chr(10)||
'</table>'||chr(10)||
'<table border="0" cellpadding="0" cellspacing="0">'||chr(10)||
'   <tr>'||chr(10)||
'   <td bgcolor="#000000" width="1" height="96"><img src="#IMAGE_PREFIX#stretch.gif" width="1" height="1" border="0" alt="" /></td>'||chr(10)||
'   <td valign="top" height="96"><img src="#IMAGE_PREFIX#stretch.gif" width="146" height="1" border="0" alt="" /><br />'||chr(10)||
'            <table border="0" cellpadding="1" cellspacing="0" width="146" summary="">'||chr(10)||
'              <tr>'||chr(10)||
'                <td colspan="2">'||chr(10)||
'                  <table border="0" cellpadding="2" cellspacing="0" width="124" summary="">'||chr(10)||
'                    <tr>'||chr(10)||
'                      <td>&nbsp;</td>'||chr(10)||
'                      <td valign="top" width="106">'||chr(10)||
'                        <P><FONT face="arial, helvetica" size="1">'||chr(10)||
'                            #BODY#'||chr(10)||
'                           </font>'||chr(10)||
'                        </P>'||chr(10)||
'                      </td>'||chr(10)||
'                    </tr>'||chr(10)||
'                  </table>'||chr(10)||
'            </table>'||chr(10)||
'          </td>'||chr(10)||
'          <td bgcolor="#000000" width="1" height="96"><img src="#IMAGE_PREFIX#stretch.gif" width="1" height="1" border="0" alt="" /></td>'||chr(10)||
'          <td bgcolor="#9a9c9a" width="1" height="96"><img src="#IMAGE_PREFIX#stretch.gif" width="1" height="1" border="0" alt="" /></td>'||chr(10)||
'          <td bgcolor="#b3b4b3" width="1" height="96"><img src="#IMAGE_PREFIX#stretch.gif" width="1" height="1" border="0" alt="" /></td>'||chr(10)||
'        </tr>'||chr(10)||
'      </table>'||chr(10)||
'      <table border="0" cellpadding="0" cellspacing="0">'||chr(10)||
'        <tr>'||chr(10)||
'          <td rowspan="4" valign="top" width="4"><img src="#IMAGE_PREFIX#bl_img.gif" border="0" width="4" height="6" alt="" /></td>'||chr(10)||
'          <td bgcolor="#ffffff" height="2"><img src="#IMAGE_PREFIX#stretch.gif" width="142" height="1" border="0" alt="" /></td>'||chr(10)||
'          <td rowspan="4" valign="top" width="4"><img src="#IMAGE_PREFIX#br_img.gif" border="0" width="4" height="6" alt="" /></td>'||chr(10)||
'        </tr>'||chr(10)||
'        <tr>'||chr(10)||
'          <td bgcolor="#000000" width="1"><img src="#IMAGE_PREFIX#stretch.gif" width="1" height="1" border="0" alt="" /></td>'||chr(10)||
'        </tr>'||chr(10)||
'        <tr>'||chr(10)||
'          <td bgcolor="#9a9c9a" width="1"><img src="#IMAGE_PREFIX#stretch.gif" width="1" height="1" border="0" alt="" /></td>'||chr(10)||
'        </tr>'||chr(10)||
'        <tr>'||chr(10)||
'          <td bgcolor="#b3b4b3" width="1" height="2"><img src="#IMAGE_PREFIX#stretch.gif" width="1" height="1" border="0" alt="" /></td>'||chr(10)||
'        </tr>'||chr(10)||
'</table>'||chr(10)||
'');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 91630411450381997.4414 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/form_region
prompt  ......region template 91630725782381998.4414
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table cellpadding="0" cellspacing="0" border="0" summary="" class="t1FormRegion" id="#REGION_ID#">'||chr(10)||
'<tr>'||chr(10)||
'<td><img src="#IMAGE_PREFIX#themes/theme_1/1px_trans.gif" height="1" width="400" alt="" /><table width="100%" cellpadding="0" cellspacing="0" border="0" summary="">'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1RegionHeader">#TITLE#</td>'||chr(10)||
'<td class="t1ButtonHolder">#CLOSE#&nbsp;&nbsp;&nbsp;#PREVIOUS##NEXT##DELETE##EDIT##CH';

t:=t||'ANGE##CREATE##HELP#</td>'||chr(10)||
'</tr>'||chr(10)||
'</table></td>'||chr(10)||
'</tr>'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1Body">#BODY#<img src="#IMAGE_PREFIX#/themes/theme_1/1px_trans.gif" height="1" width="600" style="display:block;" alt="" /></td>'||chr(10)||
'</tr>'||chr(10)||
'</table>';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 91630725782381998.4414 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Form Region',
  p_plug_table_bgcolor     => '#f7f7e7',
  p_theme_id  => 1,
  p_theme_class_id => 8,
  p_plug_heading_bgcolor => '#f7f7e7',
  p_plug_font_size => '-1',
  p_translate_this_template => 'N',
  p_template_comment       => 'Red Theme');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 91630725782381998.4414 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/navigation_region_alternative_1
prompt  ......region template 91631001900381998.4414
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table cellpadding="0" cellspacing="0" border="0" summary="" class="t1NavigationRegionAlternative1" id="#REGION_ID#">'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1RegionHeader">#TITLE#</td>'||chr(10)||
'</tr>'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1Body">#BODY#</td>'||chr(10)||
'</tr>'||chr(10)||
'</table>';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 91631001900381998.4414 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Navigation Region, Alternative 1',
  p_plug_table_bgcolor     => '',
  p_theme_id  => 1,
  p_theme_class_id => 16,
  p_plug_heading_bgcolor => '',
  p_plug_font_size => '',
  p_translate_this_template => 'N',
  p_template_comment       => '');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 91631001900381998.4414 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/wizard_region_with_icon
prompt  ......region template 91631304733381999.4414
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table cellpadding="0" cellspacing="0" border="0" summary="" class="t1WizardRegionwithIcon" id="#REGION_ID#">'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1RegionHeader">#TITLE#</td>'||chr(10)||
'<td class="t1ButtonHolder">#CLOSE#&nbsp;&nbsp;&nbsp;#PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##HELP#</td>'||chr(10)||
'</tr>'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1Body" colspan="2"><table summary="" cellpadding="0" cellspacing="0" border="0">'||chr(10)||
'<tr>'||chr(10)||
'<td valign="top"><img src=';

t:=t||'"#IMAGE_PREFIX#themes/theme_1/wizard_icon.gif" alt=""/></td>'||chr(10)||
'<td width="100%" valign="top">#BODY#</td>'||chr(10)||
'</tr>'||chr(10)||
'</table></td>'||chr(10)||
'</tr>'||chr(10)||
'</table>';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 91631304733381999.4414 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Wizard Region with Icon',
  p_plug_table_bgcolor     => '',
  p_theme_id  => 1,
  p_theme_class_id => 20,
  p_plug_heading_bgcolor => '',
  p_plug_font_size => '',
  p_translate_this_template => 'N',
  p_template_comment       => '');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 91631304733381999.4414 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/chart_region
prompt  ......region template 91631622717381999.4414
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table cellpadding="0" cellspacing="0" border="0" summary="" class="t1ChartRegion" id="#REGION_ID#">'||chr(10)||
'<tr>'||chr(10)||
'<td><table width="100%" cellpadding="0" cellspacing="0" border="0" summary="">'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1RegionHeader">#TITLE#</td>'||chr(10)||
'<td class="t1ButtonHolder">#CLOSE#&nbsp;&nbsp;&nbsp;#PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##HELP#</td>'||chr(10)||
'</tr>'||chr(10)||
'</table></td>'||chr(10)||
'</tr>'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1Body">#BODY#</td';

t:=t||'>'||chr(10)||
'</tr>'||chr(10)||
'</table>';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 91631622717381999.4414 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Chart Region',
  p_plug_table_bgcolor     => '#ffffff',
  p_theme_id  => 1,
  p_theme_class_id => 30,
  p_plug_heading_bgcolor => '#ffffff',
  p_plug_font_size => '-1',
  p_translate_this_template => 'N',
  p_template_comment       => 'Red Theme');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 91631622717381999.4414 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/bracketed_region
prompt  ......region template 91631925531382001.4414
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table cellpadding="0" cellspacing="0" border="0" summary="" class="t1BracketedRegion" id="#REGION_ID#">'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1RegionHeader">#TITLE#</td>'||chr(10)||
'<td class="t1ButtonHolder">#CLOSE#&nbsp;&nbsp;&nbsp;#PREVIOUS##NEXT##DELETE##EDIT##CHANGE##COPY##CREATE##CREATE2##EXPAND##HELP#</td>'||chr(10)||
'</tr>'||chr(10)||
'<tr>'||chr(10)||
'<td colspan="2"><table cellpadding="0" cellspacing="0" border="0" summary="" width="100%">'||chr(10)||
'<tr>'||chr(10)||
'<td class=';

t:=t||'"t1bracket"><img src="" height="5" width="1" alt="#IMAGE_PREFIX#themes/theme_1/1px_trans.gif" /></td>'||chr(10)||
'<td rowspan="3" class="t1Body">#BODY#</td>'||chr(10)||
'<td class="t1bracket"><img src="" height="5" width="1" alt="#IMAGE_PREFIX#themes/theme_1/1px_trans.gif" /></td>'||chr(10)||
'</tr>'||chr(10)||
'<tr>'||chr(10)||
'<td><img src="#IMAGE_PREFIX#themes/theme_1/1px_trans.gif" height="1" width="1" alt="" /></td>'||chr(10)||
'<td><img src="#IMAGE_PREFIX#themes/the';

t:=t||'me_1/1px_trans.gif" height="1" width="1" alt="" /></td>'||chr(10)||
'</tr>'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1bracket"><img src="" height="5" width="1" alt="#IMAGE_PREFIX#themes/theme_1/1px_trans.gif" /></td>'||chr(10)||
'<td class="t1bracket"><img src="" height="5" width="1" alt="#IMAGE_PREFIX#themes/theme_1/1px_trans.gif" /></td>'||chr(10)||
'</tr>'||chr(10)||
'</table></td>'||chr(10)||
'</tr>'||chr(10)||
'</table>';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 91631925531382001.4414 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Bracketed Region',
  p_plug_table_bgcolor     => '',
  p_theme_id  => 1,
  p_theme_class_id => 18,
  p_plug_heading_bgcolor => '',
  p_plug_font_size => '',
  p_translate_this_template => 'N',
  p_template_comment       => 'Use this region template when you want to contain content with a bracket UI.'||chr(10)||
''||chr(10)||
'TITLE=YES'||chr(10)||
'BUTTONS=YES'||chr(10)||
'100% WIDTH=NO');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 91631925531382001.4414 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/wizard_region
prompt  ......region template 91632204784382001.4414
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table cellpadding="0" cellspacing="0" border="0" summary="" class="t1WizardRegion" id="#REGION_ID#">'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1RegionHeader">#TITLE#</td>'||chr(10)||
'<td class="t1ButtonHolder">#CLOSE#&nbsp;&nbsp;&nbsp;#PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##HELP#</td>'||chr(10)||
'</tr>'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1Body" colspan="2">#BODY#</td>'||chr(10)||
'</tr>'||chr(10)||
'</table>';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 91632204784382001.4414 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Wizard Region',
  p_plug_table_bgcolor     => '',
  p_theme_id  => 1,
  p_theme_class_id => 12,
  p_plug_heading_bgcolor => '',
  p_plug_font_size => '',
  p_translate_this_template => 'N',
  p_template_comment       => '');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 91632204784382001.4414 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/reports_region_100_width
prompt  ......region template 91632529189382001.4414
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table cellpadding="0" cellspacing="0" border="0" summary="" class="t1ReportsRegion100Width" width="100%" id="#REGION_ID#">'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1RegionHeader">#TITLE#</td>'||chr(10)||
'<td class="t1ButtonHolder">#CLOSE#&nbsp;&nbsp;&nbsp;#PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##HELP#</td>'||chr(10)||
'</tr>'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1Body" colspan="2">#BODY#</td>'||chr(10)||
'</tr>'||chr(10)||
'</table>';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 91632529189382001.4414 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Reports Region 100% Width',
  p_plug_table_bgcolor     => '#ffffff',
  p_theme_id  => 1,
  p_theme_class_id => 13,
  p_plug_heading_bgcolor => '#ffffff',
  p_plug_font_size => '-1',
  p_translate_this_template => 'N',
  p_template_comment       => 'Red Theme');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 91632529189382001.4414 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/reports_region
prompt  ......region template 91632832228382001.4414
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table cellpadding="0" cellspacing="0" border="0" summary="" class="t1ReportsRegion" id="#REGION_ID#">'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1RegionHeader">#TITLE#</td>'||chr(10)||
'<td class="t1ButtonHolder">#CLOSE#&nbsp;&nbsp;&nbsp;#PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##HELP#</td>'||chr(10)||
'</tr>'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1Body" colspan="2">#BODY#</td>'||chr(10)||
'</tr>'||chr(10)||
'</table>';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 91632832228382001.4414 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Reports Region',
  p_plug_table_bgcolor     => '#ffffff',
  p_theme_id  => 1,
  p_theme_class_id => 9,
  p_plug_heading_bgcolor => '#ffffff',
  p_plug_font_size => '-1',
  p_translate_this_template => 'N',
  p_template_comment       => 'Red Theme');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 91632832228382001.4414 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/breadcrumb_region
prompt  ......region template 91633105066382001.4414
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<div class="t1BreadcrumbRegion" id="#REGION_ID#">#BODY#</div>';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 91633105066382001.4414 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Breadcrumb Region',
  p_plug_table_bgcolor     => '',
  p_theme_id  => 1,
  p_theme_class_id => 6,
  p_plug_heading_bgcolor => '',
  p_plug_font_size => '',
  p_translate_this_template => 'N',
  p_template_comment       => 'Use this region template to contain breadcrumb menus.  Breadcrumb menus are implemented using breadcrumbs.  Breadcrumb menus are designed to displayed in #REGION_POSITION_01#');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 91633105066382001.4414 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/navigation_region
prompt  ......region template 91633419116382002.4414
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<div class="t1NavigationRegion" id="#REGION_ID#">#BODY#</div>';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 91633419116382002.4414 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Navigation Region',
  p_plug_table_bgcolor     => '',
  p_theme_id  => 1,
  p_theme_class_id => 5,
  p_plug_heading_bgcolor => '',
  p_plug_font_size => '',
  p_translate_this_template => 'N',
  p_template_comment       => '');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 91633419116382002.4414 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

prompt  ...List Templates
--
--application/shared_components/user_interface/templates/list/dhtml_list_image_with_sublist
prompt  ......list template 91633715033382002.4414
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  t4 varchar2(32767) := null;
  t5 varchar2(32767) := null;
  t6 varchar2(32767) := null;
  t7 varchar2(32767) := null;
  t8 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_clob4 clob;
  l_clob5 clob;
  l_clob6 clob;
  l_clob7 clob;
  l_clob8 clob;
  l_length number := 1;
begin
t:=t||'<div class="dhtmlMenuItem"><a href="#LINK#"><img src="#IMAGE_PREFIX#themes/generic_list.gif" #IMAGE_ATTR# / alt=""></a><img src="#IMAGE_PREFIX#themes/generic_nochild.gif" width="22" height="75" alt="" / ><a href="#LINK#" class="dhtmlBottom">#TEXT#</a></div>';

t2:=t2||'<div class="dhtmlMenuItem"><a href="#LINK#"><img src="#IMAGE_PREFIX#themes/generic_list.gif" #IMAGE_ATTR# alt="" / ></a><img src="#IMAGE_PREFIX#themes/generic_nochild.gif" width="22" height="75" alt="" / ><a href="#LINK#" class="dhtmlBottom">#TEXT#</a></div>';

t3:=t3||'<li class="dhtmlMenuSep"><img src="#IMAGE_PREFIX#themes/theme_13/1px_trans.gif"  width="1" height="1" alt=""  class="dhtmlMenuSep" /></li>';

t4:=t4||'<li><a href="#LINK#" class="dhtmlSubMenuN" onmouseover="dhtml_CloseAllSubMenusL(this)">#TEXT#</a></li>';

t5:=t5||'<div class="dhtmlMenuItem"><a href="#LINK#"><img src="#IMAGE_PREFIX#themes/generic_list.gif" #IMAGE_ATTR# alt="" / ></a><img src="#IMAGE_PREFIX#themes/generic_open.gif" width="22" height="75" class="dhtmlMenu" onclick="app_AppMenuMultiOpenBottom(this,''#LIST_ITEM_ID#'',false)" alt="" / ><a href="#LINK#" class="dhtmlBottom">#TEXT#</a></div>';

t6:=t6||'<div class="dhtmlMenuItem"><a href="#LINK#"><img src="#IMAGE_PREFIX#themes/generic_list.gif" #IMAGE_ATTR# alt="" / ></a><img src="#IMAGE_PREFIX#themes/generic_open.gif" width="22" height="75" class="dhtmlMenu" onclick="app_AppMenuMultiOpenBottom(this,''#LIST_ITEM_ID#'',false)" alt="" / ><a href="#LINK#" class="dhtmlBottom">#TEXT#</a></div>';

t7:=t7||'<li class="dhtmlSubMenuS"><a href="#LINK#" class="dhtmlSubMenuS" onmouseover="dhtml_MenuOpen(this,''#LIST_ITEM_ID#'',true,''Left'')"><span style="float:left;">#TEXT#</span><img class="t13MIMG" src="#IMAGE_PREFIX#menu_open_right2.gif"  alt="" /></a></li>';

t8:=t8||'<li class="dhtmlSubMenuS"><a href="#LINK#" class="dhtmlSubMenuS" onmouseover="dhtml_MenuOpen(this,''#LIST_ITEM_ID#'',true,''Left'')"><span style="float:left;">#TEXT#</span><img class="t13MIMG" src="#IMAGE_PREFIX#menu_open_right2.gif" alt="" / ></a></li>';

wwv_flow_api.create_list_template (
  p_id=>91633715033382002.4414 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_list_template_current=>t,
  p_list_template_noncurrent=> t2,
  p_list_template_name=>'DHTML List (Image) with Sublist',
  p_theme_id  => 1,
  p_theme_class_id => 21,
  p_list_template_before_rows=>'<div class="dhtmlMenuLG">',
  p_list_template_after_rows=>'</div><br style="clear:both;"/><br style="clear:both;"/>',
  p_before_sub_list=>'<ul id="#PARENT_LIST_ITEM_ID#" htmldb:listlevel="#LEVEL#" class="dhtmlSubMenu2" style="display:none;"><li class="dhtmlSubMenuP" onmouseover="dhtml_CloseAllSubMenusL(this)">#PARENT_TEXT#</li>',
  p_after_sub_list=>'</ul>',
  p_sub_list_item_current=> t3,
  p_sub_list_item_noncurrent=> t4,
  p_item_templ_curr_w_child=> t5,
  p_item_templ_noncurr_w_child=> t6,
  p_sub_templ_curr_w_child=> t7,
  p_sub_templ_noncurr_w_child=> t8,
  p_translate_this_template => 'N',
  p_list_template_comment=>'');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/list/dhtml_menu_with_sublist
prompt  ......list template 91634003460382007.4414
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  t4 varchar2(32767) := null;
  t5 varchar2(32767) := null;
  t6 varchar2(32767) := null;
  t7 varchar2(32767) := null;
  t8 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_clob4 clob;
  l_clob5 clob;
  l_clob6 clob;
  l_clob7 clob;
  l_clob8 clob;
  l_length number := 1;
begin
t:=t||'<li class="dhtmlMenuItem"><a href="#LINK#">#TEXT#</a></li>';

t2:=t2||'<li class="dhtmlMenuItem"><a href="#LINK#">#TEXT#</a></li>';

t3:=t3||'<li class="dhtmlMenuSep2"><img src="#IMAGE_PREFIX#themes/theme_13/1px_trans.gif"  width="1" height="1" alt="" class="dhtmlMenuSep2" /></li>';

t4:=t4||'<li><a href="#LINK#" class="dhtmlSubMenuN" onmouseover="dhtml_CloseAllSubMenusL(this)">#TEXT#</a></li>';

t5:=t5||'<li class="dhtmlMenuItem1"><a href="#LINK#">#TEXT#</a><img src="#IMAGE_PREFIX#themes/theme_13/menu_small.gif" alt="Expand" onclick="app_AppMenuMultiOpenBottom2(this,''#LIST_ITEM_ID#'',false)" /></li>';

t6:=t6||'<li class="dhtmlMenuItem1"><a href="#LINK#">#TEXT#</a><img src="#IMAGE_PREFIX#themes/theme_13/menu_small.gif" alt="Expand" onclick="app_AppMenuMultiOpenBottom2(this,''#LIST_ITEM_ID#'',false)" /></li>';

t7:=t7||'<li class="dhtmlSubMenuS"><a href="#LINK#" class="dhtmlSubMenuS" onmouseover="dhtml_MenuOpen(this,''#LIST_ITEM_ID#'',true,''Left'')"><span style="float:left;">#TEXT#</span><img class="t13MIMG" src="#IMAGE_PREFIX#menu_open_right2.gif" alt="" /></a></li>';

t8:=t8||'<li class="dhtmlSubMenuS"><a href="#LINK#" class="dhtmlSubMenuS" onmouseover="dhtml_MenuOpen(this,''#LIST_ITEM_ID#'',true,''Left'')"><span style="float:left;">#TEXT#</span><img class="t13MIMG" src="#IMAGE_PREFIX#menu_open_right2.gif" alt="" / ></a></li>';

wwv_flow_api.create_list_template (
  p_id=>91634003460382007.4414 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_list_template_current=>t,
  p_list_template_noncurrent=> t2,
  p_list_template_name=>'DHTML Menu with Sublist',
  p_theme_id  => 1,
  p_theme_class_id => 20,
  p_list_template_before_rows=>'<ul class="dhtmlMenuLG2">',
  p_list_template_after_rows=>'</ul><br style="clear:both;"/><br style="clear:both;"/>',
  p_before_sub_list=>'<ul id="#PARENT_LIST_ITEM_ID#" htmldb:listlevel="#LEVEL#" class="dhtmlSubMenu2" style="display:none;">',
  p_after_sub_list=>'</ul>',
  p_sub_list_item_current=> t3,
  p_sub_list_item_noncurrent=> t4,
  p_item_templ_curr_w_child=> t5,
  p_item_templ_noncurr_w_child=> t6,
  p_sub_templ_curr_w_child=> t7,
  p_sub_templ_noncurr_w_child=> t8,
  p_translate_this_template => 'N',
  p_list_template_comment=>'');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/list/dhtml_tree
prompt  ......list template 91634310642382007.4414
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  t4 varchar2(32767) := null;
  t5 varchar2(32767) := null;
  t6 varchar2(32767) := null;
  t7 varchar2(32767) := null;
  t8 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_clob4 clob;
  l_clob5 clob;
  l_clob6 clob;
  l_clob7 clob;
  l_clob8 clob;
  l_length number := 1;
begin
t:=t||'<li><img src="#IMAGE_PREFIX#themes/theme_13/node.gif" align="middle" alt="" /><a href="#LINK#">#TEXT#</a></li>';

t2:=t2||'<li><img src="#IMAGE_PREFIX#themes/theme_13/node.gif" align="middle"  alt="" /><a href="#LINK#">#TEXT#</a></li>';

t3:=t3||'<li><img src="#IMAGE_PREFIX#themes/theme_13/node.gif" align="middle"  alt="" /><a href="#LINK#">#TEXT#</a></li>';

t4:=t4||'<li><img src="#IMAGE_PREFIX#themes/theme_13/node.gif"  align="middle" alt="" /><a href="#LINK#">#TEXT#</a></li>';

t5:=t5||'<li><img src="#IMAGE_PREFIX#themes/theme_13/plus.gif" align="middle"  onclick="htmldb_ToggleWithImage(this,''#LIST_ITEM_ID#'')" class="pseudoButtonInactive" alt="" /><a href="#LINK#">#TEXT#</a></li>';

t6:=t6||'<li><img src="#IMAGE_PREFIX#themes/theme_13/plus.gif" align="middle"  onclick="htmldb_ToggleWithImage(this,''#LIST_ITEM_ID#'')" class="pseudoButtonInactive" alt="" /><a href="#LINK#">#TEXT#</a></li>';

t7:=t7||'<li><img src="#IMAGE_PREFIX#themes/theme_13/plus.gif" onclick="htmldb_ToggleWithImage(this,''#LIST_ITEM_ID#'')" align="middle" class="pseudoButtonInactive" alt="" /><a href="#LINK#">#TEXT#</a></li>';

t8:=t8||'<li><img src="#IMAGE_PREFIX#themes/theme_13/plus.gif" onclick="htmldb_ToggleWithImage(this,''#LIST_ITEM_ID#'')" align="middle" class="pseudoButtonInactive" alt="" /><a href="#LINK#">#TEXT#</a></li>';

wwv_flow_api.create_list_template (
  p_id=>91634310642382007.4414 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_list_template_current=>t,
  p_list_template_noncurrent=> t2,
  p_list_template_name=>'DHTML Tree',
  p_theme_id  => 1,
  p_theme_class_id => 22,
  p_list_template_before_rows=>'<ul class="dhtmlTree">',
  p_list_template_after_rows=>'</ul><br style="clear:both;"/><br style="clear:both;"/>',
  p_before_sub_list=>'<ul id="#PARENT_LIST_ITEM_ID#" htmldb:listlevel="#LEVEL#" style="display:none;" class="dhtmlTree">',
  p_after_sub_list=>'</ul>',
  p_sub_list_item_current=> t3,
  p_sub_list_item_noncurrent=> t4,
  p_item_templ_curr_w_child=> t5,
  p_item_templ_noncurr_w_child=> t6,
  p_sub_templ_curr_w_child=> t7,
  p_sub_templ_noncurr_w_child=> t8,
  p_translate_this_template => 'N',
  p_list_template_comment=>'');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/list/wizard_progress_list
prompt  ......list template 91634602833382007.4414
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  t4 varchar2(32767) := null;
  t5 varchar2(32767) := null;
  t6 varchar2(32767) := null;
  t7 varchar2(32767) := null;
  t8 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_clob4 clob;
  l_clob5 clob;
  l_clob6 clob;
  l_clob7 clob;
  l_clob8 clob;
  l_length number := 1;
begin
t:=t||'<tr><td><div class="t1current">#TEXT#</div><img src="#IMAGE_PREFIX#themes/theme_1/arrow_down.gif" alt="Down" /></td></tr>';

t2:=t2||'<tr><td><div>#TEXT#</div><img src="#IMAGE_PREFIX#themes/theme_1/arrow_down.gif" alt="Down" /></td></tr>';

t3 := null;
t4 := null;
t5 := null;
t6 := null;
t7 := null;
t8 := null;
wwv_flow_api.create_list_template (
  p_id=>91634602833382007.4414 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_list_template_current=>t,
  p_list_template_noncurrent=> t2,
  p_list_template_name=>'Wizard Progress List',
  p_theme_id  => 1,
  p_theme_class_id => 17,
  p_list_template_before_rows=>'<table cellpadding="0" border="0" cellspacing="0" summary="" class="t1WizardProgressList">',
  p_list_template_after_rows=>'<tr><td>&DONE.</td></tr>'||chr(10)||
'</table>',
  p_translate_this_template => 'N',
  p_list_template_comment=>'');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/list/vertical_ordered_list
prompt  ......list template 91634920736382008.4414
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  t4 varchar2(32767) := null;
  t5 varchar2(32767) := null;
  t6 varchar2(32767) := null;
  t7 varchar2(32767) := null;
  t8 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_clob4 clob;
  l_clob5 clob;
  l_clob6 clob;
  l_clob7 clob;
  l_clob8 clob;
  l_length number := 1;
begin
t:=t||'<li class="t1current">#TEXT#</li>';

t2:=t2||'<li><a href="#LINK#">#TEXT#</a></li>';

t3 := null;
t4 := null;
t5 := null;
t6 := null;
t7 := null;
t8 := null;
wwv_flow_api.create_list_template (
  p_id=>91634920736382008.4414 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_list_template_current=>t,
  p_list_template_noncurrent=> t2,
  p_list_template_name=>'Vertical Ordered List',
  p_theme_id  => 1,
  p_theme_class_id => 2,
  p_list_template_before_rows=>'<ol class="t1VerticalOrderedList">',
  p_list_template_after_rows=>'</ol>',
  p_translate_this_template => 'N',
  p_list_template_comment=>'');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/list/button_list
prompt  ......list template 91635207728382008.4414
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  t4 varchar2(32767) := null;
  t5 varchar2(32767) := null;
  t6 varchar2(32767) := null;
  t7 varchar2(32767) := null;
  t8 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_clob4 clob;
  l_clob5 clob;
  l_clob6 clob;
  l_clob7 clob;
  l_clob8 clob;
  l_length number := 1;
begin
t:=t||'<table class="t1ButtonList" cellspacing="0" cellpadding="0" border="0" summary="">'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1L"><img src="#IMAGE_PREFIX#/themes/theme_1/list_button_left_hl.gif" alt="" /></td>'||chr(10)||
'<td class="t1C"><a href="#LINK#" style="color:#FFFFFF;">#TEXT#</a></td>'||chr(10)||
'<td class="t1R"><img src="#IMAGE_PREFIX#/themes/theme_1/list_button_right_hl.gif" alt="" /></td>'||chr(10)||
'</tr>'||chr(10)||
'</table>';

t2:=t2||'<table class="t1ButtonList" cellspacing="0" cellpadding="0" border="0" summary="">'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1L"><img src="#IMAGE_PREFIX#/themes/theme_1/list_button_left.gif" alt="" /></td>'||chr(10)||
'<td class="t1NC"><a href="#LINK#">#TEXT#</a></td>'||chr(10)||
'<td class="t1R"><img src="#IMAGE_PREFIX#/themes/theme_1/list_button_right.gif" alt="" /></td>'||chr(10)||
'</tr>'||chr(10)||
'</table>';

t3 := null;
t4 := null;
t5 := null;
t6 := null;
t7 := null;
t8 := null;
wwv_flow_api.create_list_template (
  p_id=>91635207728382008.4414 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_list_template_current=>t,
  p_list_template_noncurrent=> t2,
  p_list_template_name=>'Button List',
  p_theme_id  => 1,
  p_theme_class_id => 6,
  p_list_template_before_rows=>'<div class="t1ButtonList">',
  p_list_template_after_rows=>'</div>',
  p_translate_this_template => 'N',
  p_list_template_comment=>'');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/list/horizontal_links_list
prompt  ......list template 91635520047382008.4414
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  t4 varchar2(32767) := null;
  t5 varchar2(32767) := null;
  t6 varchar2(32767) := null;
  t7 varchar2(32767) := null;
  t8 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_clob4 clob;
  l_clob5 clob;
  l_clob6 clob;
  l_clob7 clob;
  l_clob8 clob;
  l_length number := 1;
begin
t:=t||'<a href="#LINK#" class="t1current">#TEXT#</a>';

t2:=t2||'<a href="#LINK#">#TEXT#</a>';

t3 := null;
t4 := null;
t5 := null;
t6 := null;
t7 := null;
t8 := null;
wwv_flow_api.create_list_template (
  p_id=>91635520047382008.4414 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_list_template_current=>t,
  p_list_template_noncurrent=> t2,
  p_list_template_name=>'Horizontal Links List',
  p_theme_id  => 1,
  p_theme_class_id => 3,
  p_list_template_before_rows=>'<div class="t1HorizontalLinksList">',
  p_list_template_after_rows=>'</div>',
  p_translate_this_template => 'N',
  p_list_template_comment=>'');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/list/vertical_images_list
prompt  ......list template 91635830396382009.4414
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  t4 varchar2(32767) := null;
  t5 varchar2(32767) := null;
  t6 varchar2(32767) := null;
  t7 varchar2(32767) := null;
  t8 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_clob4 clob;
  l_clob5 clob;
  l_clob6 clob;
  l_clob7 clob;
  l_clob8 clob;
  l_length number := 1;
begin
t:=t||'<tr><td class="t1current"><img src="#IMAGE_PREFIX##IMAGE#" #IMAGE_ATTR# alt="" / >#TEXT#</td></tr>';

t2:=t2||'<tr><td><a href="#LINK#"><img src="#IMAGE_PREFIX##IMAGE#" #IMAGE_ATTR# alt="" / >#TEXT#</a></td></tr>';

t3 := null;
t4 := null;
t5 := null;
t6 := null;
t7 := null;
t8 := null;
wwv_flow_api.create_list_template (
  p_id=>91635830396382009.4414 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_list_template_current=>t,
  p_list_template_noncurrent=> t2,
  p_list_template_name=>'Vertical Images List',
  p_theme_id  => 1,
  p_theme_class_id => 5,
  p_list_template_before_rows=>'<table cellpadding="0" cellspacing="0" border="0" summary="0" class="t1VerticalImagesList">',
  p_list_template_after_rows=>'</table>',
  p_translate_this_template => 'N',
  p_list_template_comment=>'');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/list/vertical_sidebar_list
prompt  ......list template 91636106164382009.4414
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  t4 varchar2(32767) := null;
  t5 varchar2(32767) := null;
  t6 varchar2(32767) := null;
  t7 varchar2(32767) := null;
  t8 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_clob4 clob;
  l_clob5 clob;
  l_clob6 clob;
  l_clob7 clob;
  l_clob8 clob;
  l_length number := 1;
begin
t:=t||'<a href="#LINK#" class="t1navcurrent">#TEXT#</a>';

t2:=t2||'<a href="#LINK#" class="t1nav">#TEXT#</a>';

t3 := null;
t4 := null;
t5 := null;
t6 := null;
t7 := null;
t8 := null;
wwv_flow_api.create_list_template (
  p_id=>91636106164382009.4414 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_list_template_current=>t,
  p_list_template_noncurrent=> t2,
  p_list_template_name=>'Vertical Sidebar List',
  p_theme_id  => 1,
  p_theme_class_id => 19,
  p_list_template_before_rows=>'<div class="t1VerticalSidebarList">',
  p_list_template_after_rows=>'</div>',
  p_translate_this_template => 'N',
  p_list_template_comment=>'');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/list/vertical_unordered_list_without_bullet
prompt  ......list template 91636400543382009.4414
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  t4 varchar2(32767) := null;
  t5 varchar2(32767) := null;
  t6 varchar2(32767) := null;
  t7 varchar2(32767) := null;
  t8 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_clob4 clob;
  l_clob5 clob;
  l_clob6 clob;
  l_clob7 clob;
  l_clob8 clob;
  l_length number := 1;
begin
t:=t||'<li class="t1current">#TEXT#</li>';

t2:=t2||'<li><a href="#LINK#">#TEXT#</a></li>';

t3 := null;
t4 := null;
t5 := null;
t6 := null;
t7 := null;
t8 := null;
wwv_flow_api.create_list_template (
  p_id=>91636400543382009.4414 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_list_template_current=>t,
  p_list_template_noncurrent=> t2,
  p_list_template_name=>'Vertical Unordered List without Bullet',
  p_theme_id  => 1,
  p_theme_class_id => 18,
  p_list_template_before_rows=>'<ul class="t1VerticalUnorderedListwithoutBullet">',
  p_list_template_after_rows=>'</ul>',
  p_translate_this_template => 'N',
  p_list_template_comment=>'');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/list/vertical_unordered_list_with_bullets
prompt  ......list template 91636711305382010.4414
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  t4 varchar2(32767) := null;
  t5 varchar2(32767) := null;
  t6 varchar2(32767) := null;
  t7 varchar2(32767) := null;
  t8 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_clob4 clob;
  l_clob5 clob;
  l_clob6 clob;
  l_clob7 clob;
  l_clob8 clob;
  l_length number := 1;
begin
t:=t||'<li class="t1current">#TEXT#</li>';

t2:=t2||'<li><a href="#LINK#">#TEXT#</a></li>';

t3 := null;
t4 := null;
t5 := null;
t6 := null;
t7 := null;
t8 := null;
wwv_flow_api.create_list_template (
  p_id=>91636711305382010.4414 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_list_template_current=>t,
  p_list_template_noncurrent=> t2,
  p_list_template_name=>'Vertical Unordered List with Bullets',
  p_theme_id  => 1,
  p_theme_class_id => 1,
  p_list_template_before_rows=>'<ul class="t1VerticalUnorderedListwithBullets">',
  p_list_template_after_rows=>'</ul>',
  p_translate_this_template => 'N',
  p_list_template_comment=>'');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/list/tabbed_navigation_list
prompt  ......list template 91637003772382010.4414
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  t4 varchar2(32767) := null;
  t5 varchar2(32767) := null;
  t6 varchar2(32767) := null;
  t7 varchar2(32767) := null;
  t8 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_clob4 clob;
  l_clob5 clob;
  l_clob6 clob;
  l_clob7 clob;
  l_clob8 clob;
  l_length number := 1;
begin
t:=t||'<li><a class="t1current" href="#LINK#">#TEXT#</a></li>';

t2:=t2||'<li><a href="#LINK#">#TEXT#</a></li>';

t3 := null;
t4 := null;
t5 := null;
t6 := null;
t7 := null;
t8 := null;
wwv_flow_api.create_list_template (
  p_id=>91637003772382010.4414 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_list_template_current=>t,
  p_list_template_noncurrent=> t2,
  p_list_template_name=>'Tabbed Navigation List',
  p_theme_id  => 1,
  p_theme_class_id => 7,
  p_list_template_before_rows=>'<ul class="t1TabbedNavigationList">',
  p_list_template_after_rows=>'</ul>',
  p_translate_this_template => 'N',
  p_list_template_comment=>'');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/list/hierarchical_expanded
prompt  ......list template 91637324450382010.4414
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  t4 varchar2(32767) := null;
  t5 varchar2(32767) := null;
  t6 varchar2(32767) := null;
  t7 varchar2(32767) := null;
  t8 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_clob4 clob;
  l_clob5 clob;
  l_clob6 clob;
  l_clob7 clob;
  l_clob8 clob;
  l_length number := 1;
begin
t:=t||'<li><a href="#LINK#">#TEXT#</a></li>';

t2:=t2||'<li><a href="#LINK#">#TEXT#</a></li>';

t3:=t3||'<li><a href="#LINK#">#TEXT#</a></li>';

t4:=t4||'<li><a href="#LINK#">#TEXT#</a></li>';

t5:=t5||'<li><a href="#LINK#">#TEXT#</a></li>';

t6:=t6||'<li><a href="#LINK#">#TEXT#</a></li>';

t7:=t7||'<li><a href="#LINK#">#TEXT#</a></li>';

t8:=t8||'<li><a href="#LINK#">#TEXT#</a></li>';

wwv_flow_api.create_list_template (
  p_id=>91637324450382010.4414 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_list_template_current=>t,
  p_list_template_noncurrent=> t2,
  p_list_template_name=>'Hierarchical Expanded',
  p_theme_id  => 1,
  p_theme_class_id => 23,
  p_list_template_before_rows=>'<ul class="dhtmlTree">',
  p_list_template_after_rows=>'</ul><br style="clear:both;"/><br style="clear:both;"/>',
  p_before_sub_list=>'<ul id="#PARENT_LIST_ITEM_ID#" htmldb:listlevel="#LEVEL#">',
  p_after_sub_list=>'</ul>',
  p_sub_list_item_current=> t3,
  p_sub_list_item_noncurrent=> t4,
  p_item_templ_curr_w_child=> t5,
  p_item_templ_noncurr_w_child=> t6,
  p_sub_templ_curr_w_child=> t7,
  p_sub_templ_noncurr_w_child=> t8,
  p_translate_this_template => 'N',
  p_list_template_comment=>'');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/list/horizontal_images_with_label_list
prompt  ......list template 91637614810382010.4414
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  t4 varchar2(32767) := null;
  t5 varchar2(32767) := null;
  t6 varchar2(32767) := null;
  t7 varchar2(32767) := null;
  t8 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_clob4 clob;
  l_clob5 clob;
  l_clob6 clob;
  l_clob7 clob;
  l_clob8 clob;
  l_length number := 1;
begin
t:=t||'<td class="t1current"><img src="#IMAGE_PREFIX##IMAGE#" #IMAGE_ATTR# alt="" / ><br />#TEXT#</td>';

t2:=t2||'<td><a href="#LINK#"><img src="#IMAGE_PREFIX##IMAGE#" #IMAGE_ATTR# alt="" / ></a><br /><a href="#LINK#">#TEXT#</a></td>';

t3 := null;
t4 := null;
t5 := null;
t6 := null;
t7 := null;
t8 := null;
wwv_flow_api.create_list_template (
  p_id=>91637614810382010.4414 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_list_template_current=>t,
  p_list_template_noncurrent=> t2,
  p_list_template_name=>'Horizontal Images with Label List',
  p_theme_id  => 1,
  p_theme_class_id => 4,
  p_list_template_before_rows=>'<table cellspacing="0" cellpadding="0" border="0" class="t1HorizontalImageswithLabelList" summary=""><tr>',
  p_list_template_after_rows=>'</tr></table>',
  p_translate_this_template => 'N',
  p_list_template_comment=>'');
end;
null;
 
end;
/

prompt  ...report templates
--
--application/shared_components/user_interface/templates/report/one_column_unordered_list
prompt  ......report template 91637905071382010.4414
 
begin
 
declare
  c1 varchar2(32767) := null;
  c2 varchar2(32767) := null;
  c3 varchar2(32767) := null;
  c4 varchar2(32767) := null;
begin
c1:=c1||'<li>#COLUMN_VALUE#</li>';

c2 := null;
c3 := null;
c4 := null;
wwv_flow_api.create_row_template (
  p_id=> 91637905071382010.4414 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_row_template_name=> 'One Column Unordered List',
  p_row_template1=> c1,
  p_row_template_condition1=> '',
  p_row_template2=> c2,
  p_row_template_condition2=> '',
  p_row_template3=> c3,
  p_row_template_condition3=> '',
  p_row_template4=> c4,
  p_row_template_condition4=> '',
  p_row_template_before_rows=>'<table cellpadding="0" cellspacing="0" summary="">'||chr(10)||
'#TOP_PAGINATION#'||chr(10)||
'<tr><td><ul class="t1OneColumnUnorderedList">',
  p_row_template_after_rows =>'</ul><div class="t1CVS">#EXTERNAL_LINK##CSV_LINK#</div></td></tr>'||chr(10)||
'#PAGINATION#'||chr(10)||
'</table>',
  p_row_template_table_attr =>'OMIT',
  p_row_template_type =>'GENERIC_COLUMNS',
  p_column_heading_template=>'',
  p_row_template_display_cond1=>'NOT_CONDITIONAL',
  p_row_template_display_cond2=>'NOT_CONDITIONAL',
  p_row_template_display_cond3=>'NOT_CONDITIONAL',
  p_row_template_display_cond4=>'NOT_CONDITIONAL',
  p_next_page_template=>'<a href="#LINK#" class="t1pagination">#PAGINATION_NEXT#<img src="#IMAGE_PREFIX#themes/theme_1/paginate_next.gif" alt="Next"></a>',
  p_previous_page_template=>'<a href="#LINK#" class="t1pagination"><img src="#IMAGE_PREFIX#themes/theme_1/paginate_prev.gif" alt="Previous">#PAGINATION_PREVIOUS#</a>',
  p_next_set_template=>'<a href="#LINK#" class="t1pagination">#PAGINATION_NEXT_SET#<img src="#IMAGE_PREFIX#themes/theme_1/paginate_next.gif" alt="Next"></a>',
  p_previous_set_template=>'<a href="#LINK#" class="t1pagination"><img src="#IMAGE_PREFIX#themes/theme_1/paginate_prev.gif" alt="Previous">#PAGINATION_PREVIOUS_SET#</a>',
  p_theme_id  => 1,
  p_theme_class_id => 3,
  p_translate_this_template => 'N',
  p_row_template_comment=> '');
end;
null;
 
end;
/

 
begin
 
begin
wwv_flow_api.create_row_template_patch (
  p_id => 91637905071382010.4414 + wwv_flow_api.g_id_offset,
  p_row_template_before_first =>'OMIT',
  p_row_template_after_last =>'OMIT');
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/report/standard
prompt  ......report template 91638400927382012.4414
 
begin
 
declare
  c1 varchar2(32767) := null;
  c2 varchar2(32767) := null;
  c3 varchar2(32767) := null;
  c4 varchar2(32767) := null;
begin
c1:=c1||'<td#ALIGNMENT# headers="#COLUMN_HEADER_NAME#" class="t1data">#COLUMN_VALUE#</td>';

c2 := null;
c3 := null;
c4 := null;
wwv_flow_api.create_row_template (
  p_id=> 91638400927382012.4414 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_row_template_name=> 'Standard',
  p_row_template1=> c1,
  p_row_template_condition1=> '',
  p_row_template2=> c2,
  p_row_template_condition2=> '',
  p_row_template3=> c3,
  p_row_template_condition3=> '',
  p_row_template4=> c4,
  p_row_template_condition4=> '',
  p_row_template_before_rows=>'<table cellpadding="0" border="0" cellspacing="0" summary="">#TOP_PAGINATION#'||chr(10)||
'<tr>'||chr(10)||
'<td><table cellpadding="0" border="0" cellspacing="0" summary="" class="t1standard">',
  p_row_template_after_rows =>'</table><div class="t1CVS">#EXTERNAL_LINK##CSV_LINK#</div></td>'||chr(10)||
'</tr>'||chr(10)||
'#PAGINATION#'||chr(10)||
'</table>',
  p_row_template_table_attr =>'',
  p_row_template_type =>'GENERIC_COLUMNS',
  p_column_heading_template=>'<th#ALIGNMENT# id="#COLUMN_HEADER_NAME#" class="t1header">#COLUMN_HEADER#</th>',
  p_row_template_display_cond1=>'0',
  p_row_template_display_cond2=>'0',
  p_row_template_display_cond3=>'0',
  p_row_template_display_cond4=>'0',
  p_next_page_template=>'<a href="#LINK#" class="t1pagination">#PAGINATION_NEXT#<img src="#IMAGE_PREFIX#themes/theme_1/paginate_next.gif" alt="Next"></a>',
  p_previous_page_template=>'<a href="#LINK#" class="t1pagination"><img src="#IMAGE_PREFIX#themes/theme_1/paginate_prev.gif" alt="Previous">#PAGINATION_PREVIOUS#</a>',
  p_next_set_template=>'<a href="#LINK#" class="t1pagination">#PAGINATION_NEXT_SET#<img src="#IMAGE_PREFIX#themes/theme_1/paginate_next.gif" alt="Next"></a>',
  p_previous_set_template=>'<a href="#LINK#" class="t1pagination"><img src="#IMAGE_PREFIX#themes/theme_1/paginate_prev.gif" alt="Previous">#PAGINATION_PREVIOUS_SET#</a>',
  p_row_style_checked=>'#CCCCCC',
  p_theme_id  => 1,
  p_theme_class_id => 4,
  p_translate_this_template => 'N',
  p_row_template_comment=> '');
end;
null;
 
end;
/

 
begin
 
begin
wwv_flow_api.create_row_template_patch (
  p_id => 91638400927382012.4414 + wwv_flow_api.g_id_offset,
  p_row_template_before_first =>'<tr #HIGHLIGHT_ROW#>',
  p_row_template_after_last =>'</tr>');
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/report/standard_alternating_row_colors
prompt  ......report template 91638924547382013.4414
 
begin
 
declare
  c1 varchar2(32767) := null;
  c2 varchar2(32767) := null;
  c3 varchar2(32767) := null;
  c4 varchar2(32767) := null;
begin
c1:=c1||'<td class="t1data"#ALIGNMENT#>#COLUMN_VALUE#</td>';

c2:=c2||'<td class="t1dataalt"#ALIGNMENT#>#COLUMN_VALUE#</td>';

c3 := null;
c4 := null;
wwv_flow_api.create_row_template (
  p_id=> 91638924547382013.4414 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_row_template_name=> 'Standard, Alternating Row Colors',
  p_row_template1=> c1,
  p_row_template_condition1=> '',
  p_row_template2=> c2,
  p_row_template_condition2=> '',
  p_row_template3=> c3,
  p_row_template_condition3=> '',
  p_row_template4=> c4,
  p_row_template_condition4=> '',
  p_row_template_before_rows=>'<table cellpadding="0" border="0" cellspacing="0" summary="">'||chr(10)||
'#TOP_PAGINATION#'||chr(10)||
'<tr><td><table border="0" cellpadding="0" cellspacing="0" summary="" class="t1standardalternatingrowcolors">',
  p_row_template_after_rows =>'</table><div class="t1CVS">#EXTERNAL_LINK##CSV_LINK#</div></td>'||chr(10)||
'</tr>'||chr(10)||
'#PAGINATION#'||chr(10)||
'</table>',
  p_row_template_table_attr =>'OMIT',
  p_row_template_type =>'GENERIC_COLUMNS',
  p_column_heading_template=>'<th class="t1header"#ALIGNMENT# id="#COLUMN_HEADER_NAME#">#COLUMN_HEADER#</th>',
  p_row_template_display_cond1=>'ODD_ROW_NUMBERS',
  p_row_template_display_cond2=>'0',
  p_row_template_display_cond3=>'0',
  p_row_template_display_cond4=>'ODD_ROW_NUMBERS',
  p_next_page_template=>'<a href="#LINK#" class="t1pagination">#PAGINATION_NEXT#<img src="#IMAGE_PREFIX#themes/theme_1/paginate_next.gif" alt="Next"></a>'||chr(10)||
'',
  p_previous_page_template=>'<a href="#LINK#" class="t1pagination"><img src="#IMAGE_PREFIX#themes/theme_1/paginate_prev.gif" alt="Previous">#PAGINATION_PREVIOUS#</a>',
  p_next_set_template=>'<a href="#LINK#" class="t1pagination">#PAGINATION_NEXT_SET#<img src="#IMAGE_PREFIX#themes/theme_1/paginate_next.gif" alt="Next"></a>',
  p_previous_set_template=>'<a href="#LINK#" class="t1pagination"><img src="#IMAGE_PREFIX#themes/theme_1/paginate_prev.gif" alt="Previous">#PAGINATION_PREVIOUS_SET#</a>',
  p_row_style_checked=>'#CCCCCC',
  p_theme_id  => 1,
  p_theme_class_id => 5,
  p_translate_this_template => 'N',
  p_row_template_comment=> '');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/report/standard_ppr
prompt  ......report template 91639203883382013.4414
 
begin
 
declare
  c1 varchar2(32767) := null;
  c2 varchar2(32767) := null;
  c3 varchar2(32767) := null;
  c4 varchar2(32767) := null;
begin
c1:=c1||'<td#ALIGNMENT# headers="#COLUMN_HEADER_NAME#" class="t1data">#COLUMN_VALUE#</td>';

c2 := null;
c3 := null;
c4 := null;
wwv_flow_api.create_row_template (
  p_id=> 91639203883382013.4414 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_row_template_name=> 'Standard (PPR)',
  p_row_template1=> c1,
  p_row_template_condition1=> '',
  p_row_template2=> c2,
  p_row_template_condition2=> '',
  p_row_template3=> c3,
  p_row_template_condition3=> '',
  p_row_template4=> c4,
  p_row_template_condition4=> '',
  p_row_template_before_rows=>'<div id="report#REGION_ID#"><htmldb:#REGION_ID#><table cellpadding="0" border="0" cellspacing="0" summary="">#TOP_PAGINATION#'||chr(10)||
'<tr>'||chr(10)||
'<td><table cellpadding="0" border="0" cellspacing="0" summary="" class="t1standard">',
  p_row_template_after_rows =>'</table><div class="t1CVS">#EXTERNAL_LINK##CSV_LINK#</div></td>'||chr(10)||
'</tr>'||chr(10)||
'#PAGINATION#'||chr(10)||
'</table>'||chr(10)||
'<script language=JavaScript type=text/javascript>'||chr(10)||
'<!--'||chr(10)||
'init_htmlPPRReport(''#REGION_ID#'');'||chr(10)||
''||chr(10)||
'//-->'||chr(10)||
'</script>'||chr(10)||
'</htmldb:#REGION_ID#>'||chr(10)||
'</div>',
  p_row_template_table_attr =>'',
  p_row_template_type =>'GENERIC_COLUMNS',
  p_column_heading_template=>'<th#ALIGNMENT# id="#COLUMN_HEADER_NAME#" class="t1header">#COLUMN_HEADER#</th>',
  p_row_template_display_cond1=>'0',
  p_row_template_display_cond2=>'0',
  p_row_template_display_cond3=>'0',
  p_row_template_display_cond4=>'0',
  p_next_page_template=>'<a href="javascript:html_PPR_Report_Page(this,''#REGION_ID#'',''#LINK#'')"  class="t1pagination">#PAGINATION_NEXT#<img src="#IMAGE_PREFIX#themes/theme_1/paginate_next.gif" alt="Next"></a>',
  p_previous_page_template=>'<a href="javascript:html_PPR_Report_Page(this,''#REGION_ID#'',''#LINK#'')"  class="t1pagination"><img src="#IMAGE_PREFIX#themes/theme_1/paginate_prev.gif" alt="Previous">#PAGINATION_PREVIOUS#</a>',
  p_next_set_template=>'<a href="javascript:html_PPR_Report_Page(this,''#REGION_ID#'',''#LINK#'')"  class="t1pagination">#PAGINATION_NEXT_SET#<img src="#IMAGE_PREFIX#themes/theme_1/paginate_next.gif" alt="Next"></a>',
  p_previous_set_template=>'<a href="javascript:html_PPR_Report_Page(this,''#REGION_ID#'',''#LINK#'')"  class="t1pagination"><img src="#IMAGE_PREFIX#themes/theme_1/paginate_prev.gif" alt="Previous">#PAGINATION_PREVIOUS_SET#</a>',
  p_row_style_checked=>'#CCCCCC',
  p_theme_id  => 1,
  p_theme_class_id => 7,
  p_translate_this_template => 'N',
  p_row_template_comment=> '');
end;
null;
 
end;
/

 
begin
 
begin
wwv_flow_api.create_row_template_patch (
  p_id => 91639203883382013.4414 + wwv_flow_api.g_id_offset,
  p_row_template_before_first =>'<tr #HIGHLIGHT_ROW#>',
  p_row_template_after_last =>'</tr>');
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/report/horizontal_border
prompt  ......report template 91639730548382014.4414
 
begin
 
declare
  c1 varchar2(32767) := null;
  c2 varchar2(32767) := null;
  c3 varchar2(32767) := null;
  c4 varchar2(32767) := null;
begin
c1:=c1||'<td#ALIGNMENT# headers="#COLUMN_HEADER_NAME#" class="t1data">#COLUMN_VALUE#</td>';

c2 := null;
c3 := null;
c4 := null;
wwv_flow_api.create_row_template (
  p_id=> 91639730548382014.4414 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_row_template_name=> 'Horizontal Border',
  p_row_template1=> c1,
  p_row_template_condition1=> '',
  p_row_template2=> c2,
  p_row_template_condition2=> '',
  p_row_template3=> c3,
  p_row_template_condition3=> '',
  p_row_template4=> c4,
  p_row_template_condition4=> '',
  p_row_template_before_rows=>'<table cellpadding="0" border="0" cellspacing="0" summary="">#TOP_PAGINATION#'||chr(10)||
'<tr>'||chr(10)||
'<td><table cellpadding="0" cellspacing="0" border="0" class="t1HorizontalBorder" summary="">',
  p_row_template_after_rows =>'</table><div class="t1CVS">#EXTERNAL_LINK##CSV_LINK#</div></td>'||chr(10)||
'</tr>'||chr(10)||
'#PAGINATION#'||chr(10)||
'</table>',
  p_row_template_table_attr =>'',
  p_row_template_type =>'GENERIC_COLUMNS',
  p_column_heading_template=>'<th#ALIGNMENT# id="#COLUMN_HEADER_NAME#" class="t1header">#COLUMN_HEADER#</th>',
  p_row_template_display_cond1=>'0',
  p_row_template_display_cond2=>'0',
  p_row_template_display_cond3=>'0',
  p_row_template_display_cond4=>'0',
  p_next_page_template=>'<a href="#LINK#" class="t1pagination">#PAGINATION_NEXT#<img src="#IMAGE_PREFIX#themes/theme_1/paginate_next.gif" alt="Next"></a>'||chr(10)||
'',
  p_previous_page_template=>'<a href="#LINK#" class="t1pagination"><img src="#IMAGE_PREFIX#themes/theme_1/paginate_prev.gif" alt="Previous">#PAGINATION_PREVIOUS#</a>',
  p_next_set_template=>'<a href="#LINK#" class="t1pagination">#PAGINATION_NEXT_SET#<img src="#IMAGE_PREFIX#themes/theme_1/paginate_next.gif" alt="Next"></a>',
  p_previous_set_template=>'<a href="#LINK#" class="t1pagination"><img src="#IMAGE_PREFIX#themes/theme_1/paginate_prev.gif" alt="Previous">#PAGINATION_PREVIOUS_SET#</a>',
  p_row_style_checked=>'#CCCCCC',
  p_theme_id  => 1,
  p_theme_class_id => 2,
  p_translate_this_template => 'N',
  p_row_template_comment=> '');
end;
null;
 
end;
/

 
begin
 
begin
wwv_flow_api.create_row_template_patch (
  p_id => 91639730548382014.4414 + wwv_flow_api.g_id_offset,
  p_row_template_before_first =>'<tr #HIGHLIGHT_ROW#>',
  p_row_template_after_last =>'</tr>');
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/report/value_attribute_pairs
prompt  ......report template 91640211522382014.4414
 
begin
 
declare
  c1 varchar2(32767) := null;
  c2 varchar2(32767) := null;
  c3 varchar2(32767) := null;
  c4 varchar2(32767) := null;
begin
c1:=c1||'<tr><th class="t1header">#COLUMN_HEADER#</th><td class="t1data">#COLUMN_VALUE#</td></tr>';

c2 := null;
c3 := null;
c4 := null;
wwv_flow_api.create_row_template (
  p_id=> 91640211522382014.4414 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_row_template_name=> 'Value Attribute Pairs',
  p_row_template1=> c1,
  p_row_template_condition1=> '',
  p_row_template2=> c2,
  p_row_template_condition2=> '',
  p_row_template3=> c3,
  p_row_template_condition3=> '',
  p_row_template4=> c4,
  p_row_template_condition4=> '',
  p_row_template_before_rows=>'<table cellpadding="0" border="0" cellspacing="0" summary="">'||chr(10)||
'#TOP_PAGINATION#'||chr(10)||
'<tr><td><table cellpadding="0" cellspacing="0" border="0" summary="" class="t1ValueAttributePairs">',
  p_row_template_after_rows =>'</table><div class="t1CVS">#EXTERNAL_LINK##CSV_LINK#</div></td></tr>#PAGINATION#</table>',
  p_row_template_table_attr =>'',
  p_row_template_type =>'GENERIC_COLUMNS',
  p_column_heading_template=>'',
  p_row_template_display_cond1=>'0',
  p_row_template_display_cond2=>'0',
  p_row_template_display_cond3=>'0',
  p_row_template_display_cond4=>'0',
  p_next_page_template=>'<a href="#LINK#" class="t1pagination">#PAGINATION_NEXT#<img src="#IMAGE_PREFIX#themes/theme_1/paginate_next.gif" alt="Next"></a>',
  p_previous_page_template=>'<a href="#LINK#" class="t1pagination"><img src="#IMAGE_PREFIX#themes/theme_1/paginate_prev.gif" alt="Previous">#PAGINATION_PREVIOUS#</a>',
  p_next_set_template=>'<a href="#LINK#" class="t1pagination">#PAGINATION_NEXT_SET#<img src="#IMAGE_PREFIX#themes/theme_1/paginate_next.gif" alt="Next"></a>',
  p_previous_set_template=>'<a href="#LINK#" class="t1pagination"><img src="#IMAGE_PREFIX#themes/theme_1/paginate_prev.gif" alt="Previous">#PAGINATION_PREVIOUS_SET#</a>',
  p_theme_id  => 1,
  p_theme_class_id => 6,
  p_translate_this_template => 'N',
  p_row_template_comment=> '');
end;
null;
 
end;
/

 
begin
 
begin
wwv_flow_api.create_row_template_patch (
  p_id => 91640211522382014.4414 + wwv_flow_api.g_id_offset,
  p_row_template_before_first =>'OMIT',
  p_row_template_after_last =>'<tr><td colspan="2" class="t1seperate"><hr /></td></tr>');
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/report/borderless
prompt  ......report template 91640708921382015.4414
 
begin
 
declare
  c1 varchar2(32767) := null;
  c2 varchar2(32767) := null;
  c3 varchar2(32767) := null;
  c4 varchar2(32767) := null;
begin
c1:=c1||'<td#ALIGNMENT# headers="#COLUMN_HEADER_NAME#" class="t1data">#COLUMN_VALUE#</td>';

c2 := null;
c3 := null;
c4 := null;
wwv_flow_api.create_row_template (
  p_id=> 91640708921382015.4414 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_row_template_name=> 'Borderless',
  p_row_template1=> c1,
  p_row_template_condition1=> '',
  p_row_template2=> c2,
  p_row_template_condition2=> '',
  p_row_template3=> c3,
  p_row_template_condition3=> '',
  p_row_template4=> c4,
  p_row_template_condition4=> '',
  p_row_template_before_rows=>'<table cellpadding="0" border="0" cellspacing="0" summary="">'||chr(10)||
'#TOP_PAGINATION#'||chr(10)||
'<tr>'||chr(10)||
'<td><table class="t1borderless" cellpadding="0" border="0" cellspacing="0" summary="">',
  p_row_template_after_rows =>'</table><div class="t1CVS">#EXTERNAL_LINK##CSV_LINK#</div></td>'||chr(10)||
'</tr>'||chr(10)||
'#PAGINATION#'||chr(10)||
'</table>',
  p_row_template_table_attr =>'',
  p_row_template_type =>'GENERIC_COLUMNS',
  p_column_heading_template=>'<th class="t1header"#ALIGNMENT# id="#COLUMN_HEADER_NAME#">#COLUMN_HEADER#</th>',
  p_row_template_display_cond1=>'0',
  p_row_template_display_cond2=>'0',
  p_row_template_display_cond3=>'0',
  p_row_template_display_cond4=>'0',
  p_next_page_template=>'<a href="#LINK#" class="t1pagination">#PAGINATION_NEXT#<img src="#IMAGE_PREFIX#themes/theme_1/paginate_next.gif" alt="Next"></a>',
  p_previous_page_template=>'<a href="#LINK#" class="t1pagination"><img src="#IMAGE_PREFIX#themes/theme_1/paginate_prev.gif" alt="Previous">#PAGINATION_PREVIOUS#</a>',
  p_next_set_template=>'<a href="#LINK#" class="t1pagination">#PAGINATION_NEXT_SET#<img src="#IMAGE_PREFIX#themes/theme_1/paginate_next.gif" alt="Next"></a>',
  p_previous_set_template=>'<a href="#LINK#" class="t1pagination"><img src="#IMAGE_PREFIX#themes/theme_1/paginate_prev.gif" alt="Previous">#PAGINATION_PREVIOUS_SET#</a>',
  p_row_style_checked=>'#CCCCCC',
  p_theme_id  => 1,
  p_theme_class_id => 1,
  p_translate_this_template => 'N',
  p_row_template_comment=> '');
end;
null;
 
end;
/

 
begin
 
begin
wwv_flow_api.create_row_template_patch (
  p_id => 91640708921382015.4414 + wwv_flow_api.g_id_offset,
  p_row_template_before_first =>'<tr #HIGHLIGHT_ROW#>',
  p_row_template_after_last =>'</tr>');
exception when others then null;
end;
null;
 
end;
/

prompt  ...label templates
--
--application/shared_components/user_interface/templates/label/optional_with_help
prompt  ......label template 91641225667382016.4414
 
begin
 
begin
wwv_flow_api.create_field_template (
  p_id=> 91641225667382016.4414 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_template_name=>'Optional with help',
  p_template_body1=>'<label for="#CURRENT_ITEM_NAME#" tabindex="999"><a class="t1OptionalwithHelp" href="javascript:popupFieldHelp(''#CURRENT_ITEM_ID#'',''&SESSION.'')" tabindex="999">',
  p_template_body2=>'</a></label>',
  p_on_error_before_label=>'<div class="t1InlineError">',
  p_on_error_after_label=>'<br/>#ERROR_MESSAGE#</div>',
  p_theme_id  => 1,
  p_theme_class_id => 1,
  p_translate_this_template=> 'N',
  p_template_comment=> '');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/label/no_label
prompt  ......label template 91641313897382017.4414
 
begin
 
begin
wwv_flow_api.create_field_template (
  p_id=> 91641313897382017.4414 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_template_name=>'No Label',
  p_template_body1=>'<span class="t1NoLabel">',
  p_template_body2=>'</span>',
  p_on_error_before_label=>'<div class="t1InlineError">',
  p_on_error_after_label=>'<br/>#ERROR_MESSAGE#</div>',
  p_theme_id  => 1,
  p_theme_class_id => 13,
  p_translate_this_template=> 'N',
  p_template_comment=> '');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/label/optional
prompt  ......label template 91641421336382017.4414
 
begin
 
begin
wwv_flow_api.create_field_template (
  p_id=> 91641421336382017.4414 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_template_name=>'Optional',
  p_template_body1=>'<label for="#CURRENT_ITEM_NAME#" tabindex="999"><span class="t1Optional">',
  p_template_body2=>'</span></label>',
  p_on_error_before_label=>'<div class="t1InlineError">',
  p_on_error_after_label=>'<br/>#ERROR_MESSAGE#</div>',
  p_theme_id  => 1,
  p_theme_class_id => 3,
  p_translate_this_template=> 'N',
  p_template_comment=> '');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/label/required_with_help
prompt  ......label template 91641529261382017.4414
 
begin
 
begin
wwv_flow_api.create_field_template (
  p_id=> 91641529261382017.4414 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_template_name=>'Required with help',
  p_template_body1=>'<label for="#CURRENT_ITEM_NAME#" tabindex="999"><img src="#IMAGE_PREFIX#themes/theme_1/required.gif" alt="Required Field Icon" tabindex="999" /><a class="t1RequiredwithHelp" href="javascript:popupFieldHelp(''#CURRENT_ITEM_ID#'',''&SESSION.'')" tabindex="999">',
  p_template_body2=>'</a></label>',
  p_on_error_before_label=>'<div class="t1InlineError">',
  p_on_error_after_label=>'<br/>#ERROR_MESSAGE#</div>',
  p_theme_id  => 1,
  p_theme_class_id => 2,
  p_translate_this_template=> 'N',
  p_template_comment=> '');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/label/required
prompt  ......label template 91641600810382017.4414
 
begin
 
begin
wwv_flow_api.create_field_template (
  p_id=> 91641600810382017.4414 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_template_name=>'Required',
  p_template_body1=>'<label for="#CURRENT_ITEM_NAME#" tabindex="999"><img src="#IMAGE_PREFIX#themes/theme_1/required.gif" alt="Required Field Icon" tabindex="999" /><span class="t1Required">',
  p_template_body2=>'</span></label>',
  p_on_error_before_label=>'<div class="t1InlineError">',
  p_on_error_after_label=>'<br/>#ERROR_MESSAGE#</div>',
  p_theme_id  => 1,
  p_theme_class_id => 4,
  p_translate_this_template=> 'N',
  p_template_comment=> '');
end;
null;
 
end;
/

prompt  ...breadcrumb templates
--
--application/shared_components/user_interface/templates/breadcrumb/hierarchical_menu
prompt  ......template 91641730492382017.4414
 
begin
 
begin
wwv_flow_api.create_menu_template (
  p_id=> 91641730492382017.4414 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=>'Hierarchical Menu',
  p_before_first=>'<ul class="t1HierarchicalMenu">',
  p_current_page_option=>'<li class="t1current">#NAME#</li>',
  p_non_current_page_option=>'<li><a href="#LINK#">#NAME#</a></li>',
  p_menu_link_attributes=>'',
  p_between_levels=>'',
  p_after_last=>'</ul>',
  p_max_levels=>11,
  p_start_with_node=>'CHILD_MENU',
  p_theme_id  => 1,
  p_theme_class_id => 2,
  p_translate_this_template => 'N',
  p_template_comments=>'');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/breadcrumb/breadcrumb_menu
prompt  ......template 91641814330382017.4414
 
begin
 
begin
wwv_flow_api.create_menu_template (
  p_id=> 91641814330382017.4414 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=>'Breadcrumb Menu',
  p_before_first=>'<div class="t1BreadcrumbMenu">',
  p_current_page_option=>'<span class="t1current">#NAME#</span>',
  p_non_current_page_option=>'<a href="#LINK#">#NAME#</a>',
  p_menu_link_attributes=>'',
  p_between_levels=>'&nbsp;&gt;&nbsp;',
  p_after_last=>'</div>',
  p_max_levels=>12,
  p_start_with_node=>'PARENT_TO_LEAF',
  p_theme_id  => 1,
  p_theme_class_id => 1,
  p_translate_this_template => 'N',
  p_template_comments=>'');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/popuplov
prompt  ...popup list of values templates
--
prompt  ......template 91642503902382024.4414
 
begin
 
begin
wwv_flow_api.create_popup_lov_template (
  p_id=> 91642503902382024.4414 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_popup_icon=>'#IMAGE_PREFIX#list_gray.gif',
  p_popup_icon_attr=>'width="13" height="13" alt="Popup Lov"',
  p_popup_icon2=>'',
  p_popup_icon_attr2=>'',
  p_page_name=>'winlov',
  p_page_title=>'Dialogfeld "Suche"',
  p_page_html_head=>'<link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_1/theme_V2.css" type="text/css">'||chr(10)||
'',
  p_page_body_attr=>'onload="first_field()" style="margin:0;"',
  p_before_field_text=>'<div class="t1PopupHead">',
  p_page_heading_text=>'',
  p_page_footer_text =>'',
  p_filter_width     =>'20',
  p_filter_max_width =>'100',
  p_filter_text_attr =>'',
  p_find_button_text =>'Suche',
  p_find_button_image=>'',
  p_find_button_attr =>'',
  p_close_button_text=>'Schließen',
  p_close_button_image=>'',
  p_close_button_attr=>'',
  p_next_button_text =>'Weiter >',
  p_next_button_image=>'',
  p_next_button_attr =>'',
  p_prev_button_text =>'< Zurück',
  p_prev_button_image=>'',
  p_prev_button_attr =>'',
  p_after_field_text=>'</div>',
  p_scrollbars=>'1',
  p_resizable=>'1',
  p_width =>'400',
  p_height=>'450',
  p_result_row_x_of_y=>'<br /><div style="padding:2px; font-size:8pt;">Row(s) #FIRST_ROW# - #LAST_ROW#</div>',
  p_result_rows_per_pg=>500,
  p_before_result_set=>'<div class="t1PopupBody">',
  p_theme_id  => 1,
  p_theme_class_id => 1,
  p_translate_this_template => 'N',
  p_after_result_set   =>'</div>');
end;
null;
 
end;
/

prompt  ...calendar templates
--
--application/shared_components/user_interface/templates/calendar/small_calendar
prompt  ......template 91641910982382018.4414
 
begin
 
begin
wwv_flow_api.create_calendar_template(
  p_id=> 91641910982382018.4414 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_cal_template_name=>'Small Calendar',
  p_translate_this_template=> 'N',
  p_day_of_week_format=> '<th class="t1DayOfWeek">#DY#</th>',
  p_month_title_format=> '<table cellspacing="0" cellpadding="0" border="0" summary="" class="t1SmallCalendarHolder"> '||chr(10)||
' <tr>'||chr(10)||
'   <td class="t1MonthTitle">#IMONTH# #YYYY#</td>'||chr(10)||
' </tr>'||chr(10)||
' <tr>'||chr(10)||
' <td>',
  p_month_open_format=> '<table border="0" cellpadding="0" cellspacing="1" summary="" class="t1SmallCalendar">',
  p_month_close_format=> '</table></td>'||chr(10)||
'</tr>'||chr(10)||
'</table>',
  p_day_title_format=> '<div class="t1DayTitle">#DD#</div>',
  p_day_open_format=> '<td class="t1Day" valign="top">',
  p_day_close_format=> '</td>',
  p_today_open_format=> '<td valign="top" class="t1Today">',
  p_weekend_title_format=> '<div class="t1WeekendDayTitle">#DD#</div>',
  p_weekend_open_format => '<td valign="top" class="t1WeekendDay">',
  p_weekend_close_format => '</td>',
  p_nonday_title_format => '<div class="t1NonDayTitle">#DD#</div>',
  p_nonday_open_format => '<td class="t1NonDay" valign="top">',
  p_nonday_close_format => '</td>',
  p_week_title_format => '',
  p_week_open_format => '<tr>',
  p_week_close_format => '</tr> ',
  p_daily_title_format => '<table cellspacing="0" cellpadding="0" border="0" summary="" class="t1DayCalendarHolder"> <tr> <td class="t1MonthTitle">#IMONTH# #DD#, #YYYY#</td> </tr> <tr> <td>',
  p_daily_open_format => '<tr>',
  p_daily_close_format => '</tr>',
  p_weekly_title_format => '<table cellspacing="0" cellpadding="0" border="0" summary="" class="t1SmallWeekCalendarHolder">'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1MonthTitle" id="test">#WTITLE#</td>'||chr(10)||
'</tr>'||chr(10)||
'<tr>'||chr(10)||
'<td>',
  p_weekly_day_of_week_format => '<th class="t1DayOfWeek">#IDAY#<br />#MM#/#DD#</th>',
  p_weekly_month_open_format => '<table border="0" cellpadding="0" cellspacing="1" summary="0" class="t1SmallWeekCalendar">',
  p_weekly_month_close_format => '</table></td></tr></table>',
  p_weekly_day_title_format => '',
  p_weekly_day_open_format => '<td class="t1Day" valign="top">',
  p_weekly_day_close_format => '<br /></td>',
  p_weekly_today_open_format => '<td class="t1Today" valign="top">',
  p_weekly_weekend_title_format => '',
  p_weekly_weekend_open_format => '<td valign="top" class="t1NonDay">',
  p_weekly_weekend_close_format => '<br /></td>',
  p_weekly_time_open_format => '<th class="t1Hour">',
  p_weekly_time_close_format => '<br /></th>',
  p_weekly_time_title_format => '#TIME#',
  p_weekly_hour_open_format => '<tr>',
  p_weekly_hour_close_format => '</tr>',
  p_daily_day_of_week_format => '<th class="t1DayOfWeek">#IDAY# #DD#/#MM#</th>',
  p_daily_month_title_format => '<table cellspacing="0" cellpadding="0" border="0" summary="" class="t1SmallDayCalendarHolder"> <tr> <td class="t1MonthTitle">#IMONTH# #DD#, #YYYY#</td> </tr><tr><td>'||chr(10)||
'',
  p_daily_month_open_format => '<table border="0" cellpadding="2" cellspacing="1" summary="0" class="t1SmallDayCalendar">',
  p_daily_month_close_format => '</table></td></tr></table>',
  p_daily_day_title_format => '',
  p_daily_day_open_format => '<td valign="top" class="t1Day">',
  p_daily_day_close_format => '<br /></td>',
  p_daily_today_open_format => '<td valign="top" class="t1Today">',
  p_daily_time_open_format => '<th class="t1Hour">',
  p_daily_time_close_format => '<br /></th>',
  p_daily_time_title_format => '#TIME#',
  p_daily_hour_open_format => '<tr>',
  p_daily_hour_close_format => '</tr>',
  p_theme_id  => 1,
  p_theme_class_id => 3,
  p_reference_id=> null);
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/calendar/calendar
prompt  ......template 91642102481382020.4414
 
begin
 
begin
wwv_flow_api.create_calendar_template(
  p_id=> 91642102481382020.4414 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_cal_template_name=>'Calendar',
  p_translate_this_template=> 'N',
  p_day_of_week_format=> '<th class="t1DayOfWeek">#IDAY#</th>',
  p_month_title_format=> '<table cellspacing="0" cellpadding="0" border="0" summary="" class="t1CalendarHolder"> '||chr(10)||
' <tr>'||chr(10)||
'   <td class="t1MonthTitle">#IMONTH# #YYYY#</td>'||chr(10)||
' </tr>'||chr(10)||
' <tr>'||chr(10)||
' <td>',
  p_month_open_format=> '<table border="0" cellpadding="0" cellspacing="0" summary="0" class="t1Calendar">',
  p_month_close_format=> '</table></td>'||chr(10)||
'</tr>'||chr(10)||
'</table>'||chr(10)||
'',
  p_day_title_format=> '<div class="t1DayTitle">#DD#</div>',
  p_day_open_format=> '<td class="t1Day" valign="top">',
  p_day_close_format=> '</td>',
  p_today_open_format=> '<td valign="top" class="t1Today">',
  p_weekend_title_format=> '<div class="t1WeekendDayTitle">#DD#</div>',
  p_weekend_open_format => '<td valign="top" class="t1WeekendDay">',
  p_weekend_close_format => '</td>',
  p_nonday_title_format => '<div class="t1NonDayTitle">#DD#</div>',
  p_nonday_open_format => '<td class="t1NonDay" valign="top">',
  p_nonday_close_format => '</td>',
  p_week_title_format => '',
  p_week_open_format => '<tr>',
  p_week_close_format => '</tr> ',
  p_daily_title_format => '<table cellspacing="0" cellpadding="0" border="0" summary="" class="t1DayCalendarHolder"> <tr> <td class="t1MonthTitle">#IMONTH# #DD#, #YYYY#</td> </tr> <tr> <td>',
  p_daily_open_format => '<tr>',
  p_daily_close_format => '</tr>',
  p_weekly_title_format => '<table cellspacing="0" cellpadding="0" border="0" summary="" class="t1WeekCalendarHolder">'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1MonthTitle" id="test">#WTITLE#</td>'||chr(10)||
'</tr>'||chr(10)||
'<tr>'||chr(10)||
'<td>',
  p_weekly_day_of_week_format => '<th class="t1DayOfWeek">#IDAY#<br>#MM#/#DD#</th>',
  p_weekly_month_open_format => '<table border="0" cellpadding="0" cellspacing="0" summary="0" class="t1WeekCalendar">',
  p_weekly_month_close_format => '</table></td></tr></table>',
  p_weekly_day_title_format => '',
  p_weekly_day_open_format => '<td class="t1Day" valign="top">',
  p_weekly_day_close_format => '<br /></td>',
  p_weekly_today_open_format => '<td class="t1Today" valign="top">',
  p_weekly_weekend_title_format => '',
  p_weekly_weekend_open_format => '<td valign="top" class="t1NonDay">',
  p_weekly_weekend_close_format => '<br /></td>',
  p_weekly_time_open_format => '<th class="t1Hour">',
  p_weekly_time_close_format => '<br /></th>',
  p_weekly_time_title_format => '#TIME#',
  p_weekly_hour_open_format => '<tr>',
  p_weekly_hour_close_format => '</tr>',
  p_daily_day_of_week_format => '<th class="t1DayOfWeek">#IDAY# #DD#/#MM#</th>',
  p_daily_month_title_format => '<table cellspacing="0" cellpadding="0" border="0" summary="" class="t1DayCalendarHolder"> <tr> <td class="t1MonthTitle">#IMONTH# #DD#, #YYYY#</td> </tr> <tr> <td>'||chr(10)||
'',
  p_daily_month_open_format => '<table border="0" cellpadding="2" cellspacing="0" summary="0" class="t1DayCalendar">',
  p_daily_month_close_format => '</table></td> </tr> </table>',
  p_daily_day_title_format => '',
  p_daily_day_open_format => '<td valign="top" class="t1Day">',
  p_daily_day_close_format => '<br /></td>',
  p_daily_today_open_format => '<td valign="top" class="t1Today">',
  p_daily_time_open_format => '<th class="t1Hour">',
  p_daily_time_close_format => '<br /></th>',
  p_daily_time_title_format => '#TIME#',
  p_daily_hour_open_format => '<tr>',
  p_daily_hour_close_format => '</tr>',
  p_theme_id  => 1,
  p_theme_class_id => 1,
  p_reference_id=> null);
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/calendar/calendar_alternative_1
prompt  ......template 91642303533382020.4414
 
begin
 
begin
wwv_flow_api.create_calendar_template(
  p_id=> 91642303533382020.4414 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_cal_template_name=>'Calendar, Alternative 1',
  p_translate_this_template=> 'N',
  p_day_of_week_format=> '<th valign="bottom" class="t1DayOfWeek">#IDAY#</th>',
  p_month_title_format=> '<table cellspacing="0" cellpadding="0" border="0" summary="" class="t1CalendarAlternative1Holder"> '||chr(10)||
' <tr>'||chr(10)||
'   <td class="t1MonthTitle">#IMONTH# #YYYY#</td>'||chr(10)||
' </tr>'||chr(10)||
' <tr>'||chr(10)||
' <td>',
  p_month_open_format=> '<table border="0" cellpadding="0" cellspacing="2" summary="0" class="t1CalendarAlternative1">',
  p_month_close_format=> '</table></td>'||chr(10)||
'</tr>'||chr(10)||
'</table>'||chr(10)||
'',
  p_day_title_format=> '<div class="t1DayTitle">#DD#</div>',
  p_day_open_format=> '<td class="t1Day" valign="top" height="100" height="100">',
  p_day_close_format=> '</td>',
  p_today_open_format=> '<td valign="top" class="t1Today">',
  p_weekend_title_format=> '<div class="t1WeekendDayTitle">#DD#</div>',
  p_weekend_open_format => '<td valign="top" class="t1WeekendDay">',
  p_weekend_close_format => '</td>',
  p_nonday_title_format => '<div class="t1NonDayTitle">#DD#</div>',
  p_nonday_open_format => '<td class="t1NonDay" valign="top">',
  p_nonday_close_format => '</td>',
  p_week_title_format => '',
  p_week_open_format => '<tr>',
  p_week_close_format => '</tr> ',
  p_daily_title_format => '<table cellspacing="0" cellpadding="0" border="0" summary="" class="t1DayCalendarHolder"> <tr> <td class="t1MonthTitle">#IMONTH# #DD#, #YYYY#</td> </tr> <tr> <td>',
  p_daily_open_format => '<tr>',
  p_daily_close_format => '</tr>',
  p_weekly_title_format => '<table cellspacing="0" cellpadding="0" border="0" summary="" class="t1WeekCalendarAlternative1Holder">'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1MonthTitle" id="test">#WTITLE#</td>'||chr(10)||
'</tr>'||chr(10)||
'<tr>'||chr(10)||
'<td>',
  p_weekly_day_of_week_format => '<th class="t1DayOfWeek">#IDAY#<br>#MM#/#DD#</th>',
  p_weekly_month_open_format => '<table border="0" cellpadding="0" cellspacing="2" summary="0" class="t1WeekCalendarAlternative1">',
  p_weekly_month_close_format => '</table></td></tr></table>',
  p_weekly_day_title_format => '',
  p_weekly_day_open_format => '<td class="t1Day" valign="top">',
  p_weekly_day_close_format => '<br /></td>',
  p_weekly_today_open_format => '<td class="t1Today" valign="top">',
  p_weekly_weekend_title_format => '',
  p_weekly_weekend_open_format => '<td valign="top" class="t1NonDay">',
  p_weekly_weekend_close_format => '<br /></td>',
  p_weekly_time_open_format => '<th class="t1Hour">',
  p_weekly_time_close_format => '<br /></th>',
  p_weekly_time_title_format => '#TIME#',
  p_weekly_hour_open_format => '<tr>',
  p_weekly_hour_close_format => '</tr>',
  p_daily_day_of_week_format => '<th class="t1DayOfWeek">#IDAY# #DD#/#MM#</th>',
  p_daily_month_title_format => '<table cellspacing="0" cellpadding="0" border="0" summary="" class="t1DayCalendarAlternative1Holder"> <tr><td class="t1MonthTitle">#IMONTH# #DD#, #YYYY#</td></tr><tr><td>'||chr(10)||
'',
  p_daily_month_open_format => '<table border="0" cellpadding="2" cellspacing="2" summary="0" class="t1DayCalendarAlternative1">',
  p_daily_month_close_format => '</table></td> </tr> </table>',
  p_daily_day_title_format => '',
  p_daily_day_open_format => '<td valign="top" class="t1Day">',
  p_daily_day_close_format => '<br /></td>',
  p_daily_today_open_format => '<td valign="top" class="t1Today">',
  p_daily_time_open_format => '<th class="t1Hour">',
  p_daily_time_close_format => '<br /></th>',
  p_daily_time_title_format => '#TIME#',
  p_daily_hour_open_format => '<tr>',
  p_daily_hour_close_format => '</tr>',
  p_theme_id  => 1,
  p_theme_class_id => 2,
  p_reference_id=> null);
end;
null;
 
end;
/

prompt  ...application themes
--
prompt  ...build options used by application 4414
--
 
begin
 
null;
 
end;
/

--application/shared_components/globalization/messages
prompt  ...messages used by application: 4414
--
prompt  ......Message master_detail
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Master-Detail';

wwv_flow_api.create_message (
  p_id=>195790305716152020 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'MASTER_DETAIL',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message master_detail_edit
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 bearbeiten';

wwv_flow_api.create_message (
  p_id=>195790406397152020 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'MASTER_DETAIL_EDIT',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message master_detail_detail
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 Detail';

wwv_flow_api.create_message (
  p_id=>195790506025152020 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'MASTER_DETAIL_DETAIL',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message sw_empty_script
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Sie können kein leeres SQL-Skript bearbeiten.';

wwv_flow_api.create_message (
  p_id=>195790615255152020 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SW_EMPTY_SCRIPT',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message sw_greater_than_30k
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Sie können kein Skript bearbeiten, das größer als 30 000 Byte ist.';

wwv_flow_api.create_message (
  p_id=>195790729047152021 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SW_GREATER_THAN_30K',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_create_master_detail
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Sie haben das Erstellen von Master-Detailseiten mit folgenden Attributen angefordert. Bitte bestätigen Sie Ihre Auswahl.';

wwv_flow_api.create_message (
  p_id=>195790813225152021 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CREATE_MASTER_DETAIL',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_3_page_master_detail
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Master-Detail (3 Seiten)';

wwv_flow_api.create_message (
  p_id=>195790915742152021 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.3_PAGE_MASTER_DETAIL',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_2_page_master_detail
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Master-Detail (2 Seiten)';

wwv_flow_api.create_message (
  p_id=>195791014621152021 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.2_PAGE_MASTER_DETAIL',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_master_table
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Master-Tabelle';

wwv_flow_api.create_message (
  p_id=>195791110617152021 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.MASTER_TABLE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_master_display_columns
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Master-Anzeigespalte(n)';

wwv_flow_api.create_message (
  p_id=>195791227206152021 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.MASTER_DISPLAY_COLUMNS',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_detail_table
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Detail-Tabelle';

wwv_flow_api.create_message (
  p_id=>195791316832152022 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.DETAIL_TABLE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_detail_display_columns
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Detail-Anzeigespalte(n)';

wwv_flow_api.create_message (
  p_id=>195791416998152022 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.DETAIL_DISPLAY_COLUMNS',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_master_sort
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Master-Datensatz navigieren nach';

wwv_flow_api.create_message (
  p_id=>195791512253152022 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.MASTER_SORT',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_include_master_report
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Master-Bericht einbeziehen?';

wwv_flow_api.create_message (
  p_id=>195791620808152022 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.INCLUDE_MASTER_REPORT',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_master_detail_layout
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Master-Detail-Layout';

wwv_flow_api.create_message (
  p_id=>195791700797152022 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.MASTER_DETAIL_LAYOUT',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_wizard_api_create_master_detail
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erstellen von Master-Detailseite nicht möglich. %0';

wwv_flow_api.create_message (
  p_id=>195791825086152022 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WIZARD_API.CREATE_MASTER_DETAIL',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p42_sql_valid
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Gültig';

wwv_flow_api.create_message (
  p_id=>195791905961152023 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P42_SQL_VALID',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p42_code_compiled
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Code erfolgreich kompiliert';

wwv_flow_api.create_message (
  p_id=>195792005870152023 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P42_CODE_COMPILED',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message static_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Statische Referenz';

wwv_flow_api.create_message (
  p_id=>195792129482152023 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'STATIC_REFERENCE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message dynamic_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Dynamische Referenz';

wwv_flow_api.create_message (
  p_id=>195792222429152023 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DYNAMIC_REFERENCE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message chart_invalid_query
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Parsen von SQL-Abfrage nicht erfolgreich:'||chr(10)||
'<p>%0</p>'||chr(10)||
'<p>%1</p>'||chr(10)||
'Bestimmte Abfragen können nur in Ihrer Anwendung ausgeführt werden. Wenn Ihre Abfrage syntaktisch korrekt ist, können Sie Ihre Abfrage ohne Validierung speichern. Die entsprechenden Optionen werden unter der Abfragequelle angezeigt.';

wwv_flow_api.create_message (
  p_id=>195792321412152023 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CHART.INVALID_QUERY',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message chart_chart_query_syntax_invalid
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Ungültige Diagrammabfrage: %0<br><br>'||chr(10)||
'Verwenden Sie folgende Syntax:'||chr(10)||
'<pre>'||chr(10)||
'SELECT LINK, LABEL, VALUE'||chr(10)||
'FROM   ...'||chr(10)||
'</pre>'||chr(10)||
'<table class="instructiontext">'||chr(10)||
'<tr><td>LINK</td><td>URL</td></tr>'||chr(10)||
'<tr><td>LABEL</td><td>Text für den Balken</td></tr>'||chr(10)||
'<tr><td>VALUE</td><td>Numerische Spalte für die Definition der Balkengröße</td></tr>'||chr(10)||
'</table>';

wwv_flow_api.create_message (
  p_id=>195792420752152023 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CHART.CHART_QUERY_SYNTAX_INVALID',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_flash_chart
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Flash-Diagramm';

wwv_flow_api.create_message (
  p_id=>195792522918152024 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.FLASH_CHART',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_page_zero
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Komponenten für die Seite null werden von allen Seiten einer Anwendung gemeinsam verwendet.';

wwv_flow_api.create_message (
  p_id=>195792619342152024 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_PAGE_ZERO',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message builder
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Builder';

wwv_flow_api.create_message (
  p_id=>195792718286152024 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'BUILDER',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message home
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Home';

wwv_flow_api.create_message (
  p_id=>195792818730152024 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'HOME',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message nav_app_builder_home
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Zur Application Builder-Homepage navigieren';

wwv_flow_api.create_message (
  p_id=>195792914923152024 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'NAV_APP_BUILDER_HOME',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message home_nav
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Application Express-Homepage';

wwv_flow_api.create_message (
  p_id=>195793020065152024 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'HOME_NAV',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Name';

wwv_flow_api.create_message (
  p_id=>195793106751152025 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'NAME',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_create_flash_chart
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Sie haben das Erstellen einer Flash-Diagrammseite mit folgenden Attributen angefordert. Bitte bestätigen Sie Ihre Auswahl.';

wwv_flow_api.create_message (
  p_id=>195793229353152025 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CREATE_FLASH_CHART',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message page_group
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Seitengruppe';

wwv_flow_api.create_message (
  p_id=>195793331701152025 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PAGE_GROUP',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message form
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Form';

wwv_flow_api.create_message (
  p_id=>195793428882152025 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'FORM',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_xe_config_set_sga_target
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fehler beim Festlegen des neuen SGA-Ziels. %0';

wwv_flow_api.create_message (
  p_id=>195793505443152025 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_XE_CONFIG.SET_SGA_TARGET',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_xe_config_set_pga_agg_target
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fehler beim Festlegen des neuen PGA-Aggregat-Ziels. %0';

wwv_flow_api.create_message (
  p_id=>195793630582152025 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_XE_CONFIG.SET_PGA_AGG_TARGET',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message view_all_page_groups
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Alle Seitengruppen anzeigen';

wwv_flow_api.create_message (
  p_id=>195793710166152025 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'VIEW ALL PAGE GROUPS',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message view_all_page_types
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Alle Seitentypen anzeigen';

wwv_flow_api.create_message (
  p_id=>195793832760152026 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'VIEW ALL PAGE TYPES',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message view_pages_of_this_type
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Seiten dieses Typs anzeigen';

wwv_flow_api.create_message (
  p_id=>195793932533152026 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'VIEW_PAGES_OF_THIS_TYPE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message page_zero
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Seite null';

wwv_flow_api.create_message (
  p_id=>195794001728152026 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PAGE_ZERO',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message reset_4000
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Zurücksetzen';

wwv_flow_api.create_message (
  p_id=>195794125337152026 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'RESET_4000',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message blank
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Leer';

wwv_flow_api.create_message (
  p_id=>195794212721152026 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'BLANK',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message edit_page_group
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Seitengruppe bearbeiten';

wwv_flow_api.create_message (
  p_id=>195794314171152026 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'EDIT PAGE GROUP',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 - Layout';

wwv_flow_api.create_message (
  p_id=>195794421007152027 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message processing
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Ihre Anforderung wird verarbeitet, bitte warten';

wwv_flow_api.create_message (
  p_id=>195794531127152027 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PROCESSING',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message shared_pool
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Shared Pool';

wwv_flow_api.create_message (
  p_id=>195794619790152027 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SHARED POOL',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message buffer_cache
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Buffer Cache';

wwv_flow_api.create_message (
  p_id=>195794702497152027 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'BUFFER CACHE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message other
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Weitere';

wwv_flow_api.create_message (
  p_id=>195794825734152027 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'OTHER',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message navigation_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Navigationsseite';

wwv_flow_api.create_message (
  p_id=>195794906456152027 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'NAVIGATION_PAGE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_menus
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Navigationspfade';

wwv_flow_api.create_message (
  p_id=>195795007292152028 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_MENUS',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_lists
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Listen';

wwv_flow_api.create_message (
  p_id=>195795130457152028 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_LISTS',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message manage_page_groups
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Seitengruppen verwalten';

wwv_flow_api.create_message (
  p_id=>195795216504152028 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'MANAGE PAGE GROUPS',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_no_lists
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Keine Listen verwendet.';

wwv_flow_api.create_message (
  p_id=>195795305932152028 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_NO_LISTS',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_no_menus
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Keine Navigationspfade verwendet.';

wwv_flow_api.create_message (
  p_id=>195795412402152028 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_NO_MENUS',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p374_pos_5
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Pos. 5';

wwv_flow_api.create_message (
  p_id=>195795528370152028 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000.P374.POS.5',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message reassign_pages
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Seiten erneut zuweisen';

wwv_flow_api.create_message (
  p_id=>195795628463152028 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'REASSIGN_PAGES',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message static_html
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Statisches HTML';

wwv_flow_api.create_message (
  p_id=>195795723976152029 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'STATIC_HTML',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message password_must_be_changed
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Das Kennwort für diesen Account muss geändert werden.';

wwv_flow_api.create_message (
  p_id=>195795818273152029 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PASSWORD_MUST_BE_CHANGED',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message dynamic_form
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Dynamische Form';

wwv_flow_api.create_message (
  p_id=>195795914231152029 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DYNAMIC_FORM',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apex_wizard_form
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Navigations-Form';

wwv_flow_api.create_message (
  p_id=>195796028408152029 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEX_WIZARD_FORM',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_help_htmldb_user_guide
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Application Builder User''s Guide';

wwv_flow_api.create_message (
  p_id=>195796123621152029 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_HELP.HTMLDB_USER_GUIDE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_help_2_day_dev
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'2 Day Developer';

wwv_flow_api.create_message (
  p_id=>195796224089152029 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_HELP.2_DAY_DEV',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_help_2_day_dba
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'2 Day DBA';

wwv_flow_api.create_message (
  p_id=>195796332426152030 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_HELP.2_DAY_DBA',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4500_referential
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Referential';

wwv_flow_api.create_message (
  p_id=>195796411123152030 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4500_REFERENTIAL',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message inactive
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Inaktiv';

wwv_flow_api.create_message (
  p_id=>195796506070152030 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INACTIVE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_1220_script_result
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Ergebnisse von %0, ausgeführt um %1';

wwv_flow_api.create_message (
  p_id=>195796614840152030 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500_1220_SCRIPT_RESULT',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message dml_form
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'DML-Form';

wwv_flow_api.create_message (
  p_id=>195796720065152030 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DML_FORM',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_wizard_api_get_next_prev_pk_item
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Dieses Element wird für den Prozess zum Abrufen des nächsten oder vorherigen Primärschlüsselwertes benötigt.';

wwv_flow_api.create_message (
  p_id=>195796827673152030 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WIZARD_API.GET_NEXT_PREV_PK_ITEM',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_wizard_api_get_next_prev_pk_button
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Diese Schaltfläche wird für den Prozess zum Abrufen des nächsten oder vorherigen Primärschlüsselwertes benötigt.';

wwv_flow_api.create_message (
  p_id=>195796913513152030 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WIZARD_API.GET_NEXT_PREV_PK_BUTTON',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_wizard_api_get_next_prev_pk
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Nächsten oder vorherigen Primärschlüsselwert abrufen';

wwv_flow_api.create_message (
  p_id=>195797030488152031 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WIZARD_API.GET_NEXT_PREV_PK',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_1002_qb_show_cols
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Spalten ein-/ausblenden';

wwv_flow_api.create_message (
  p_id=>195797125889152031 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500_1002_QB_SHOW_COLS',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_1002_qb_remove_table
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Entfernen';

wwv_flow_api.create_message (
  p_id=>195797225870152031 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500_1002_QB_REMOVE_TABLE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_1002_qb_join_hint
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Klicken Sie hier, um die Spalte für den Join auszuwählen';

wwv_flow_api.create_message (
  p_id=>195797306817152031 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500_1002_QB_JOIN_HINT',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_wizard_api_get_next_prev_pk_process
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Ausführen von Prozess zum Abrufen des nächsten oder vorherigen Primärschlüsselwertes nicht möglich.';

wwv_flow_api.create_message (
  p_id=>195797426296152031 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WIZARD_API.GET_NEXT_PREV_PK_PROCESS',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_form_control_get_next_or_prev_pk_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Abrufen des nächsten oder vorherigen Primärschlüsselwertes nicht möglich. %0';

wwv_flow_api.create_message (
  p_id=>195797510681152031 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FORM_CONTROL.GET_NEXT_OR_PREV_PK_ERROR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_form_control_check_process
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Überprüfen Sie Ihre Prozessdefinition erneut. %0';

wwv_flow_api.create_message (
  p_id=>195797622057152032 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FORM_CONTROL.CHECK_PROCESS',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_stmt_processed
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Anweisung wurde verarbeitet.';

wwv_flow_api.create_message (
  p_id=>195797702098152032 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.STMT_PROCESSED',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message installer_deinstall
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Deinstall-Skript';

wwv_flow_api.create_message (
  p_id=>195797818923152032 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTALLER.DEINSTALL',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_1002_qb_clone_column
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Spalte';

wwv_flow_api.create_message (
  p_id=>195797914594152032 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500_1002_QB_CLONE_COLUMN',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_1002_qb_clone_alias
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Aliasname';

wwv_flow_api.create_message (
  p_id=>195798025666152032 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500_1002_QB_CLONE_ALIAS',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_1002_qb_clone_object
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Objekt';

wwv_flow_api.create_message (
  p_id=>195798114589152032 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500_1002_QB_CLONE_OBJECT',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_1002_qb_clone_condition
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Bedingung';

wwv_flow_api.create_message (
  p_id=>195798213441152033 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500_1002_QB_CLONE_CONDITION',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_1002_qb_clone_sort
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Sortiertyp';

wwv_flow_api.create_message (
  p_id=>195798318612152033 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500_1002_QB_CLONE_SORT',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_1002_qb_clone_sort_order
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Sortierreihenfolge';

wwv_flow_api.create_message (
  p_id=>195798406331152033 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500_1002_QB_CLONE_SORT_ORDER',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_1002_qb_clone_output
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Anzeigen';

wwv_flow_api.create_message (
  p_id=>195798529966152033 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500_1002_QB_CLONE_OUTPUT',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_1002_qb_clone_function
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Funktion';

wwv_flow_api.create_message (
  p_id=>195798609267152033 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500_1002_QB_CLONE_FUNCTION',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_1002_qb_clone_group
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Gruppieren nach';

wwv_flow_api.create_message (
  p_id=>195798723434152033 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500_1002_QB_CLONE_GROUP',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message file_too_big
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Die Textdatei ist so groß, dass sie nicht bearbeitet werden kann. Um den Inhalt zu ändern, müssen Sie die Datei auf Ihrem lokalen Rechner bearbeiten und wieder hochladen.';

wwv_flow_api.create_message (
  p_id=>195798813137152033 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'FILE_TOO_BIG',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4350_total_sessions2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Gesamte Sessions: %0';

wwv_flow_api.create_message (
  p_id=>195798910291152034 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4350_TOTAL_SESSIONS2',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4350_prefs_exists_for2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 Voreinstellungen sind für %1 Benutzer vorhanden';

wwv_flow_api.create_message (
  p_id=>195799006162152034 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4350_PREFS_EXISTS_FOR2',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_provision_unable_to_create_tablespace
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Der Tablespace kann derzeit nicht erstellt werden. Führen Sie den Vorgang später erneut aus.';

wwv_flow_api.create_message (
  p_id=>195799100665152034 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PROVISION.UNABLE_TO_CREATE_TABLESPACE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message sql_query_required
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Ungültige Abfrage, keine SELECT-Anweisung gefunden';

wwv_flow_api.create_message (
  p_id=>195799214884152034 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SQL_QUERY_REQUIRED',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_1002_qb_join
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Join';

wwv_flow_api.create_message (
  p_id=>195799323678152034 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500_1002_QB_JOIN',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_1002_qb_to
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'bis';

wwv_flow_api.create_message (
  p_id=>195799413361152034 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500_1002_QB_TO',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_1002_qb_max_cols
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Es können maximal 60 Spalten ausgewählt werden.';

wwv_flow_api.create_message (
  p_id=>195799510222152035 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500_1002_QB_MAX_COLS',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message application_x
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Anwendung %0';

wwv_flow_api.create_message (
  p_id=>195799629701152035 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APPLICATION_X',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_script_executing
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Wird ausgeführt';

wwv_flow_api.create_message (
  p_id=>195799713309152035 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_SCRIPT.EXECUTING',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message clear_command
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Befehl löschen';

wwv_flow_api.create_message (
  p_id=>195799815762152035 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CLEAR_COMMAND',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message find_tables
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Tabellen suchen';

wwv_flow_api.create_message (
  p_id=>195799907783152035 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'FIND_TABLES',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_wizard_api_get_next_prev_pk_shortcut
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Möchten Sie diese Seite wirklich verlassen, ohne die Änderungen zu speichern?';

wwv_flow_api.create_message (
  p_id=>195800014592152035 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WIZARD_API.GET_NEXT_PREV_PK_SHORTCUT',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message download
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Herunterladen';

wwv_flow_api.create_message (
  p_id=>195800115800152036 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DOWNLOAD',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message view_for_printing
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Anzeige für den Druck';

wwv_flow_api.create_message (
  p_id=>195800231311152036 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'VIEW_FOR_PRINTING',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message no_developer_priv
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Keine Entwicklerberechtigung';

wwv_flow_api.create_message (
  p_id=>195800329396152036 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'NO_DEVELOPER_PRIV',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message password_valid
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Kennwort gültig';

wwv_flow_api.create_message (
  p_id=>195800417707152036 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PASSWORD_VALID',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message password_expired
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Kennwort abgelaufen';

wwv_flow_api.create_message (
  p_id=>195800516876152036 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PASSWORD_EXPIRED',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_script_completed
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Abgeschlossen';

wwv_flow_api.create_message (
  p_id=>195800616905152036 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_SCRIPT.COMPLETED',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_script_in_progress
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'In Arbeit';

wwv_flow_api.create_message (
  p_id=>195800714926152037 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_SCRIPT.IN_PROGRESS',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_script_result_row
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 Zeile.';

wwv_flow_api.create_message (
  p_id=>195800831149152037 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_SCRIPT.RESULT_ROW',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_script_result_rows
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 Zeilen.';

wwv_flow_api.create_message (
  p_id=>195800924967152037 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_SCRIPT.RESULT_ROWS',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_script_elapsed
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 Sekunden';

wwv_flow_api.create_message (
  p_id=>195801019094152037 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_SCRIPT.ELAPSED',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message custom_auth_scheme_desc
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Entwicklerdefiniert';

wwv_flow_api.create_message (
  p_id=>195801122998152037 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CUSTOM_AUTH_SCHEME_DESC',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message auth_success
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Normale, erfolgreiche Authentifizierung';

wwv_flow_api.create_message (
  p_id=>195801214353152037 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'AUTH_SUCCESS',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message auth_unknown_user
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unbekannter Benutzername';

wwv_flow_api.create_message (
  p_id=>195801309444152037 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'AUTH_UNKNOWN_USER',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message auth_account_locked
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Account gesperrt';

wwv_flow_api.create_message (
  p_id=>195801431974152038 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'AUTH_ACCOUNT_LOCKED',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message auth_account_expired
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Account abgelaufen';

wwv_flow_api.create_message (
  p_id=>195801500818152038 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'AUTH_ACCOUNT_EXPIRED',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message auth_password_incorrect
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Falsches Kennwort';

wwv_flow_api.create_message (
  p_id=>195801617357152038 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'AUTH_PASSWORD_INCORRECT',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message auth_password_first_use
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erste Verwendung des Kennworts';

wwv_flow_api.create_message (
  p_id=>195801721960152038 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'AUTH_PASSWORD_FIRST_USE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message auth_attempts_exceeded
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Maximale Anmeldeversuche überschritten';

wwv_flow_api.create_message (
  p_id=>195801824118152038 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'AUTH_ATTEMPTS_EXCEEDED',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message auth_internal_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unbekannter interner Fehler';

wwv_flow_api.create_message (
  p_id=>195801925349152038 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'AUTH_INTERNAL_ERROR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message service_login
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Site-Administration';

wwv_flow_api.create_message (
  p_id=>195802022030152039 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SERVICE_LOGIN',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message workspace_login
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Workspace-Anmeldung';

wwv_flow_api.create_message (
  p_id=>195802116541152039 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WORKSPACE_LOGIN',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_admin_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Administrationsseite für die Zugriffskontrolle';

wwv_flow_api.create_message (
  p_id=>195802222905152039 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_ADMIN_PAGE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_confirm_table
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Tabelle erstellen';

wwv_flow_api.create_message (
  p_id=>195802315405152039 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_CONFIRM_TABLE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_app_admin
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Anwendungsadministration';

wwv_flow_api.create_message (
  p_id=>195802420422152039 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_APP_ADMIN',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_mode1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Voller Zugriff auf alle, Access Control-Liste nicht verwendet.';

wwv_flow_api.create_message (
  p_id=>195802514574152039 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_MODE1',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_mode2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Eingeschränkter Zugriff. Nur in der Access Control-Liste definierte Benutzer sind zugelassen.';

wwv_flow_api.create_message (
  p_id=>195802629955152040 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_MODE2',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_mode3
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Nur öffentlicher Lesezugriff. Berechtigungen für das Bearbeiten und die Administration werden über die Access Control-Liste gesteuert.';

wwv_flow_api.create_message (
  p_id=>195802727746152040 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_MODE3',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_mode4
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Nur Administratorzugriff.';

wwv_flow_api.create_message (
  p_id=>195802813816152040 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_MODE4',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_app_mode_help
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Geben Sie an, wie der Zugriff auf diese Anwendung kontrolliert wird.';

wwv_flow_api.create_message (
  p_id=>195802932034152040 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_APP_MODE_HELP',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_app_mode
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Anwendungsmodus';

wwv_flow_api.create_message (
  p_id=>195803016504152040 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_APP_MODE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_set_app_mode
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Anwendungsmodus festlegen';

wwv_flow_api.create_message (
  p_id=>195803105644152040 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_SET_APP_MODE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message dbaccount_auth_scheme_desc
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Datenbank-Account';

wwv_flow_api.create_message (
  p_id=>195803225667152040 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DBACCOUNT_AUTH_SCHEME_DESC',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_list
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Access Control-Liste';

wwv_flow_api.create_message (
  p_id=>195803321885152041 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_LIST',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message ldap_auth_scheme_desc
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'LDAP';

wwv_flow_api.create_message (
  p_id=>195803401781152041 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LDAP_AUTH_SCHEME_DESC',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_username
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Benutzername';

wwv_flow_api.create_message (
  p_id=>195803527493152041 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_USERNAME',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_priv
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Berechtigung';

wwv_flow_api.create_message (
  p_id=>195803608622152041 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_PRIV',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_admin
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Administrator';

wwv_flow_api.create_message (
  p_id=>195803702644152041 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_ADMIN',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_last_changed_by
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Zuletzt geändert von';

wwv_flow_api.create_message (
  p_id=>195803804476152041 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_LAST_CHANGED_BY',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_find_help
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Geben Sie Abfragekriterien ohne Berücksichtigung der Groß-/Kleinschreibung ein, und klicken Sie anschließend auf <b>Los</b>.';

wwv_flow_api.create_message (
  p_id=>195803922223152042 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_FIND_HELP',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_get_app_mode_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Abrufen des Modus für die Anwendungsadministration nicht möglich.';

wwv_flow_api.create_message (
  p_id=>195804000947152042 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_GET_APP_MODE_ERROR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_no_priv
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Keine Berechtigung für versuchte Aktion.';

wwv_flow_api.create_message (
  p_id=>195804103471152042 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_NO_PRIV',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_app_mode_set_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Verarbeiten des Requests zum Festlegen des Anwendungsmodus nicht möglich.';

wwv_flow_api.create_message (
  p_id=>195804201445152042 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_APP_MODE_SET_ERROR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_app_mode_set_success
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Anwendungsmodus festgelegt.';

wwv_flow_api.create_message (
  p_id=>195804331864152042 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_APP_MODE_SET_SUCCESS',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_print_util_invalid_proxy_url
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Die Druck-Engine konnte nicht erreicht werden, weil entweder der angegebene URL falsch ist oder ein Proxy-URL angegeben werden muss.';

wwv_flow_api.create_message (
  p_id=>195804419342152042 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PRINT_UTIL.INVALID_PROXY_URL',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_object_browser_only_n_cols
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Die ersten %0 angezeigten Spalten.';

wwv_flow_api.create_message (
  p_id=>195804529541152043 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500_OBJECT_BROWSER_ONLY_N_COLS',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_run_script
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Sie haben die Ausführung des folgenden Skripts angefordert. Bitte bestätigen Sie Ihre Auswahl.';

wwv_flow_api.create_message (
  p_id=>195804611395152043 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.RUN_SCRIPT',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4500_p10_script_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Skriptname';

wwv_flow_api.create_message (
  p_id=>195804720780152043 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4500_P10_SCRIPT_NAME',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4500_p10_num_stmts
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Anzahl der Anweisungen';

wwv_flow_api.create_message (
  p_id=>195804810695152043 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4500_P10_NUM_STMTS',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message view_details
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Details anzeigen';

wwv_flow_api.create_message (
  p_id=>195804905716152043 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'VIEW_DETAILS',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_deinstall
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Entfernen';

wwv_flow_api.create_message (
  p_id=>195805011733152043 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.DEINSTALL',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4050_31_log_count
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Einträge im Zugriffs-Log für die Anmeldung';

wwv_flow_api.create_message (
  p_id=>195805117018152043 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4050_31_LOG_COUNT',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message ob_compile_errors
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 Fehler.';

wwv_flow_api.create_message (
  p_id=>195805205117152044 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'OB_COMPILE_ERRORS',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message color_palette
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Farbpalette';

wwv_flow_api.create_message (
  p_id=>195805300607152044 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'COLOR_PALETTE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_script_run_file_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Ausführen von Skript nicht möglich. %0';

wwv_flow_api.create_message (
  p_id=>195805402926152044 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_SCRIPT.RUN_FILE_ERROR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_script_run_stmt_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fehler in run_statement. %0';

wwv_flow_api.create_message (
  p_id=>195805511275152044 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_SCRIPT.RUN_STMT_ERROR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_api_run_sql_arr
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fehler in run_sql_arr. %0';

wwv_flow_api.create_message (
  p_id=>195805606389152044 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_API.RUN_SQL_ARR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message installer_script_success
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erfolg';

wwv_flow_api.create_message (
  p_id=>195805700908152044 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTALLER.SCRIPT.SUCCESS',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message installer_script_fail
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fehler';

wwv_flow_api.create_message (
  p_id=>195805826854152045 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTALLER.SCRIPT.FAIL',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message edit_all
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Alle bearbeiten';

wwv_flow_api.create_message (
  p_id=>195805905694152045 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'EDIT_ALL',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_script_query_limit
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'SELECT-Anweisung darf nicht größer sein als 32 KB.';

wwv_flow_api.create_message (
  p_id=>195806024292152045 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_SCRIPT.QUERY_LIMIT',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message administator
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Workspace-Administrator';

wwv_flow_api.create_message (
  p_id=>195806129597152045 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ADMINISTATOR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message developer
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Entwickler';

wwv_flow_api.create_message (
  p_id=>195806227522152045 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEVELOPER',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message end_user
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Endbenutzer';

wwv_flow_api.create_message (
  p_id=>195806331240152045 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'END_USER',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_err_nosgid
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Sicherheitsgruppen-ID ist Null.';

wwv_flow_api.create_message (
  p_id=>195806414330152046 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ERR_NOSGID',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_script_rows_selected
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 Zeilen ausgewählt.';

wwv_flow_api.create_message (
  p_id=>195806508974152046 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_SCRIPT.ROWS_SELECTED',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message installer_welcome
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Willkommen';

wwv_flow_api.create_message (
  p_id=>195806615970152046 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTALLER.WELCOME',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message installer_existence
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fehler bei Prüfung von Vorhandensein';

wwv_flow_api.create_message (
  p_id=>195806701548152046 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTALLER.EXISTENCE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message installer_configuration
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Anwendungsbezogene Ersetzungen';

wwv_flow_api.create_message (
  p_id=>195806831023152046 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTALLER.CONFIGURATION',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message installer_build_options
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erstelloptionen';

wwv_flow_api.create_message (
  p_id=>195806931055152046 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTALLER.BUILD_OPTIONS',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message installer_validation
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Validierung';

wwv_flow_api.create_message (
  p_id=>195807001769152046 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTALLER.VALIDATION',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message installer_confirmation
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Installationsbestätigung';

wwv_flow_api.create_message (
  p_id=>195807108438152047 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTALLER.CONFIRMATION',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message installer_success
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Post-Installation - Erfolg';

wwv_flow_api.create_message (
  p_id=>195807232594152047 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTALLER.SUCCESS',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message installer_failure
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Post-Installation - Fehler';

wwv_flow_api.create_message (
  p_id=>195807310306152047 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTALLER.FAILURE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message installer_license
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Lizenz';

wwv_flow_api.create_message (
  p_id=>195807421874152047 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTALLER.LICENSE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message installer_confirm_deinstall
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Deinstallationsbestätigung';

wwv_flow_api.create_message (
  p_id=>195807509501152047 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTALLER.CONFIRM_DEINSTALL',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message installer_deinstall_success
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Deinstallation - Erfolg';

wwv_flow_api.create_message (
  p_id=>195807603663152047 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTALLER.DEINSTALL_SUCCESS',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4500_p2613_expired
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Kennwort abgelaufen';

wwv_flow_api.create_message (
  p_id=>195807703832152048 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4500_P2613_EXPIRED',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message manual
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Manuell';

wwv_flow_api.create_message (
  p_id=>195807824113152048 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'MANUAL',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_flow_dbaccount
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Datenbank-Account';

wwv_flow_api.create_message (
  p_id=>195807904441152048 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_FLOW.DBACCOUNT',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_auth_scheme_desc_dbaccount
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Verwenden Sie Datenbank-Account-ID-Daten.';

wwv_flow_api.create_message (
  p_id=>195808030400152048 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.AUTH_SCHEME_DESC_DBACCOUNT',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_use_table
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Vorhandene Tabelle verwenden';

wwv_flow_api.create_message (
  p_id=>195808110152152048 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_USE_TABLE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_create_auth_scheme
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Autorisierungsschema erstellen';

wwv_flow_api.create_message (
  p_id=>195808201638152048 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_CREATE_AUTH_SCHEME',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_script_script_not_found
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1001 Skript nicht gefunden.';

wwv_flow_api.create_message (
  p_id=>195808311041152049 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_SCRIPT.SCRIPT_NOT_FOUND',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_script_max_nest_level
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1004 Skripts können maximal auf %0 Ebenen verschachtelt sein.';

wwv_flow_api.create_message (
  p_id=>195808411703152049 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_SCRIPT.MAX_NEST_LEVEL',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_api_cannot_run_cmd
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0-Befehl blockiert. Ausführung aus SQL Workshop nicht möglich.';

wwv_flow_api.create_message (
  p_id=>195808507409152049 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_API.CANNOT_RUN_CMD',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p802_dbaccount_title
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Klicken Sie hier, um die Authentifizierungsfunktion mit -DBACCOUNT- aufzufüllen'||chr(10)||
''||chr(10)||
'';

wwv_flow_api.create_message (
  p_id=>195808604553152049 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000.P802.DBACCOUNT_TITLE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p808_dbauth_type
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Verwenden Sie den Benutzernamen und das Kennwort des Datenbank-Accounts für die Authentifizierung.';

wwv_flow_api.create_message (
  p_id=>195808719945152049 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P808_DBAUTH_TYPE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message parsing_schema
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Parsing-Schema';

wwv_flow_api.create_message (
  p_id=>195808817098152049 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PARSING_SCHEMA',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_use_auth_scheme
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Vorhandenes Autorisierungsschema verwenden';

wwv_flow_api.create_message (
  p_id=>195808925169152049 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_USE_AUTH_SCHEME',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_rpt_region_header
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Identifizieren Sie Benutzernamen, die diesem Anwendungsautorisierungsschema entsprechen.';

wwv_flow_api.create_message (
  p_id=>195809031794152050 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_RPT_REGION_HEADER',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_action15a
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Überprüfen Sie den Benutzernamen und das Kennwort in der Anmelde-Form mit den Angaben für die Oracle-Datenbank-Accounts. Diese Technik ist nützlich, wenn die Benutzer Ihrer Anwendung Accounts in der Datenbank haben.';

wwv_flow_api.create_message (
  p_id=>195809125531152050 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ACTION15A',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message account_locked
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Account ist gesperrt.';

wwv_flow_api.create_message (
  p_id=>195809224672152050 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCOUNT_LOCKED',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message unknown_authentication_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Ein unbekannter Authentifizierungsfehler ist aufgetreten.';

wwv_flow_api.create_message (
  p_id=>195809327622152050 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'UNKNOWN_AUTHENTICATION_ERROR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_before_body
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Vor Body';

wwv_flow_api.create_message (
  p_id=>195809419337152050 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.BEFORE_BODY',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_after_body
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Nach Body';

wwv_flow_api.create_message (
  p_id=>195809517172152050 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.AFTER_BODY',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_script_max_script_output_reached
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1005 Die Skriptausgabe hat die maximale Größe erreicht. Legen Sie fest, dass Ihr Skript eine geringere Ausgabe generiert, oder bitten Sie Ihren Administrator, die maximale Größe für das Skriptergebnis zu erhöhen.';

wwv_flow_api.create_message (
  p_id=>195809616956152051 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_SCRIPT.MAX_SCRIPT_OUTPUT_REACHED',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_script_max_workspace_output_reached
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1005 Die Skriptausgabe hat die maximale Größe für das Workspace-Ergebnis erreicht. Löschen Sie vorhandene Ergebnisse, oder bitten Sie Ihren Administrator, die maximale Größe für das Workspace-Ergebnis zu erhöhen.';

wwv_flow_api.create_message (
  p_id=>195809724931152051 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_SCRIPT.MAX_WORKSPACE_OUTPUT_REACHED',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message hr_account_unlocked
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Sperre von HR-Account wurde aufgehoben.';

wwv_flow_api.create_message (
  p_id=>195809826094152051 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'HR_ACCOUNT_UNLOCKED',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_800_hd_htmldb
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Oracle Application Express 2 Day Plus Developer Guide.';

wwv_flow_api.create_message (
  p_id=>195809928161152051 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500 800 HD HTMLDB',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_800_hd_dba
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Oracle Database Express Edition 2 Day DBA.';

wwv_flow_api.create_message (
  p_id=>195810020039152051 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500 800 HD DBA',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_800_hd_dev
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Oracle Database Express Edition 2 Day Developer Guide.';

wwv_flow_api.create_message (
  p_id=>195810126709152051 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500 800 HD DEV',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_800_hd_java
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Oracle Database Express Edition 2 Day Plus Java Developer Guide.';

wwv_flow_api.create_message (
  p_id=>195810214377152051 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500 800 HD JAVA',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_800_hd_net
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Oracle Database Express Edition 2 Day Plus .NET Developer Guide.';

wwv_flow_api.create_message (
  p_id=>195810328282152052 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500 800 HD NET',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_800_hd_php
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Oracle Database Express Edition 2 Day Plus PHP Developer.';

wwv_flow_api.create_message (
  p_id=>195810415266152052 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500 800 HD PHP',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_800_msg_dba
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erläutert allgemeine, täglich auszuführende administrative Tasks.';

wwv_flow_api.create_message (
  p_id=>195810524984152052 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500 800 MSG DBA',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_800_msg_dev
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erläutert, wie Sie die Vorteile der Oracle Database Express Edition-Entwicklungsumgebung nutzen.';

wwv_flow_api.create_message (
  p_id=>195810614419152052 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500 800 MSG DEV',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_800_msg_htmldb
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Bietet eine Reihe von Lernprogrammen, die die Erstellung von auf Datenbanken basierenden Webanwendungen beschreiben.';

wwv_flow_api.create_message (
  p_id=>195810719455152052 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500 800 MSG HTMLDB',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_800_msg_php
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Dieses Dokument bietet ein Lernprogramm, das zeigt, wie Sie Apache und die Zend Core PHP-Treiber herunterladen und installieren. Danach erfahren Sie, wie Sie sich mit PHP bei Oracle Database XE anmelden und eine einfache Anwendung entwickeln, die auf Daten zugreift und diese ändert.';

wwv_flow_api.create_message (
  p_id=>195810829676152053 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500 800 MSG PHP',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_800_msg_java
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Dieses Dokument bietet ein Lernprogramm, das zeigt, wie Sie sich mit Java und JDBC bei Oracle Database XE anmelden. Außerdem erfahren Sie, wie Sie damit eine einfache Java-Anwendung entwickeln, die auf Daten zugreift und diese ändert.';

wwv_flow_api.create_message (
  p_id=>195810913845152053 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500 800 MSG JAVA',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_800_msg_net
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Dieses Dokument beschreibt die Haupt-Features von Oracle Data Provider for .NET und Oracle Developer Tools for Visual Studio .NET. Es führt Sie durch die Installation und Konfiguration und zeigt, wie Sie einfache Anwendungen mit Oracle Data Provider for .NET und Oracle Developer Tools for Visual Studio .NET erstellen. Außerdem erfahren Sie, wie Sie gespeicherte PL/SQL- sowie .NET-Prozeduren erstel';

h:=h||'len und verwenden.';

wwv_flow_api.create_message (
  p_id=>195811004294152053 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500 800 MSG NET',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message account_created
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Account wurde erstellt.';

wwv_flow_api.create_message (
  p_id=>195811122129152053 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCOUNT_CREATED',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_mail_invalid_context
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Diese Prozedur muss innerhalb einer Anwendungssession aufgerufen werden.';

wwv_flow_api.create_message (
  p_id=>195811206864152053 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_MAIL.INVALID_CONTEXT',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4500_foreign
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fremd';

wwv_flow_api.create_message (
  p_id=>195811303774152053 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4500_FOREIGN',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_web_services_wsdl_requires_auth
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Dieses WSDL benötigt ID-Daten für die Authentifizierung. Geben Sie unten den Benutzernamen und das Kennwort ein.';

wwv_flow_api.create_message (
  p_id=>195811432579152053 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WEB_SERVICES.WSDL_REQUIRES_AUTH',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_item_protection_save_item_show
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Es wurde versucht, das Element %0 im Sessionstatus während der show-Verarbeitung zu speichern. Die Schutzebene für das Element gibt "%1" an. Es wurde keine Prüfsumme (Checksum) übergeben, oder die übergebene Prüfsumme ist für ein Element mit der Schutzebene "%2" geeignet.';

wwv_flow_api.create_message (
  p_id=>195811516947152054 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.ITEM_PROTECTION.SAVE_ITEM_SHOW',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_item_protection_unprotected
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Element ist nicht geschützt.';

wwv_flow_api.create_message (
  p_id=>195811626579152054 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.ITEM_PROTECTION.UNPROTECTED',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_item_protection_public_bookmark
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Das Element kann festgelegt werden, wenn es von einer "application-level bookmark"-Prüfsumme (Checksum) begleitet wird.';

wwv_flow_api.create_message (
  p_id=>195811705067152054 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.ITEM_PROTECTION.PUBLIC_BOOKMARK',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_item_protection_private_bookmark
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Das Element kann festgelegt werden, wenn es von einer "user-level bookmark"-Prüfsumme (Checksum) begleitet wird.';

wwv_flow_api.create_message (
  p_id=>195811813410152054 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.ITEM_PROTECTION.PRIVATE_BOOKMARK',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_item_protection_session
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Das Element kann festgelegt werden, wenn es von einer "session"-Prüfsumme (Checksum) begleitet wird.';

wwv_flow_api.create_message (
  p_id=>195811920865152054 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.ITEM_PROTECTION.SESSION',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_item_protection_internal_only
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Das Element kann nicht festgelegt werden, indem Argumente an die Anwendung übergeben werden.';

wwv_flow_api.create_message (
  p_id=>195812015965152054 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.ITEM_PROTECTION.INTERNAL_ONLY',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_page_protection_unprotected
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Seite ist nicht geschützt';

wwv_flow_api.create_message (
  p_id=>195812103894152055 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.PAGE_PROTECTION.UNPROTECTED',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_page_protection_checksum_required
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Die Seite kann mit Argumenten angefordert werden, wenn eine Prüfsumme (Checksum) an die show-Prozedur übergeben wird';

wwv_flow_api.create_message (
  p_id=>195812216192152055 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.PAGE_PROTECTION.CHECKSUM_REQUIRED',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_page_protection_no_args_allowed
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Auf die Seite kann nur ohne Argumente zugegriffen werden';

wwv_flow_api.create_message (
  p_id=>195812301808152055 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.PAGE_PROTECTION.NO_ARGS_ALLOWED ',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_page_protection_direct_branch_only
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Auf die Seite kann nur mit einer Verzweigung vom Typ "Verzweigung zu Seite" von einer anderen Seite zugegriffen werden';

wwv_flow_api.create_message (
  p_id=>195812412293152055 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.PAGE_PROTECTION.DIRECT_BRANCH_ONLY',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_page_protection_show_checksum_missing
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Es wurde keine Prüfsumme (Checksum) für die Verarbeitungsanzeige für eine Seite zur Verfügung gestellt, die eine Prüfsumme (Checksum) benötigt, wenn Werte für Requests, Löschvorgänge beim Cacheinhalt oder Argumente als Parameter übergeben werden.';

wwv_flow_api.create_message (
  p_id=>195812503700152055 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.PAGE_PROTECTION.SHOW_CHECKSUM_MISSING',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_page_protection_show_checksum_mismatch
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Die berechnete Prüfsumme (Checksum) für Requests, Löschvorgänge beim Cacheinhalt oder Argumentnamen und -werte (%0) stimmt nicht mit der Prüfsumme überein, die an die show-Prozedur (%1) übergeben wurde.';

wwv_flow_api.create_message (
  p_id=>195812620835152055 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.PAGE_PROTECTION.SHOW_CHECKSUM_MISMATCH',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_page_protection_show_no_args_allowed
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Die Argumente wurden an eine Seite übergeben, die keine Argumente akzeptiert (Request, Cacheinhalt löschen, Element).';

wwv_flow_api.create_message (
  p_id=>195812707655152056 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.PAGE_PROTECTION.SHOW_NO_ARGS_ALLOWED',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_page_protection_show_no_url_allowed
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Diese Seite kann nicht mit einem URL oder über einen GET- oder POST-Vorgang bei der show-Prozedur aufgerufen werden. Sie muss mit einer Verzweigung vom Typ "Verzweigung zu Seite" aufgerufen werden.';

wwv_flow_api.create_message (
  p_id=>195812821793152056 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.PAGE_PROTECTION.SHOW_NO_URL_ALLOWED',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_item_protection_save_item_internal_only_accept
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Es wurde versucht, das Element %0 im Sessionstatus während der accept-Verarbeitung zu speichern. Das Element ist nur intern geschützt oder ist kein Form-Element, bei dem ein POST-Vorgang ausgeführt werden kann.';

wwv_flow_api.create_message (
  p_id=>195812924438152056 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.ITEM_PROTECTION.SAVE_ITEM_INTERNAL_ONLY_ACCEPT',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_item_protection_no_checksum
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'(Keine Prüfsumme angegeben)';

wwv_flow_api.create_message (
  p_id=>195813026353152056 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.ITEM_PROTECTION.NO_CHECKSUM',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_dbms_sql_invalid_date
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Ungültiger Datumswert gefunden. Überprüfen Sie das Datumsformat.';

wwv_flow_api.create_message (
  p_id=>195813117021152056 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_DBMS_SQL.INVALID_DATE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_ui_def_hint_text
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Benutzeroberflächen-Standards werden von Application Builder verwendet, um die Ausgangswerte für die Regions- und Elementeigenschaften aufzufüllen, und gewährleisten eine Konsistenz bei mehreren Seiten einer oder mehrerer Anwendungen.';

wwv_flow_api.create_message (
  p_id=>195813210126152056 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500_UI_DEF_HINT_TEXT',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4500_p2610_open
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Öffnen';

wwv_flow_api.create_message (
  p_id=>195813301248152056 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4500_P2610_OPEN',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4500_p2610_locked
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Gesperrt';

wwv_flow_api.create_message (
  p_id=>195813407954152057 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4500_P2610_LOCKED',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4500_p2610_expired
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Abgelaufen';

wwv_flow_api.create_message (
  p_id=>195813518708152057 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4500_P2610_EXPIRED',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4500_p2610_expired_and_locked
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Abgelaufen und gesperrt';

wwv_flow_api.create_message (
  p_id=>195813619388152057 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4500_P2610_EXPIRED_AND_LOCKED',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message delete_msg
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Soll dieser Löschvorgang ausgeführt werden?';

wwv_flow_api.create_message (
  p_id=>195813732137152057 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DELETE_MSG',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message size
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Größe';

wwv_flow_api.create_message (
  p_id=>195813820642152057 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SIZE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message length
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Länge';

wwv_flow_api.create_message (
  p_id=>195813923893152057 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LENGTH',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message lines
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Zeilen';

wwv_flow_api.create_message (
  p_id=>195814029694152058 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LINES',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message calendar_type
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Kalender';

wwv_flow_api.create_message (
  p_id=>195814131539152058 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CALENDAR_TYPE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message calendar_easy_type
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Einfacher Kalender';

wwv_flow_api.create_message (
  p_id=>195814210012152058 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CALENDAR_EASY_TYPE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4050_email_click_on_link
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Klicken Sie auf den Link'||chr(10)||
''||chr(10)||
'%0, '||chr(10)||
''||chr(10)||
'um den Genehmigungsvorgang abzuschließen und Ihre ID-Daten zu erhalten.';

wwv_flow_api.create_message (
  p_id=>195814326413152058 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4050.EMAIL_CLICK_ON_LINK',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4050_accepted
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'DELETE';

wwv_flow_api.create_message (
  p_id=>195814418961152058 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4050.ACCEPTED',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_create_form_on_ws
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Sie haben das Erstellen einer Form basierend auf einer Web Service-Referenzseite mit folgenden Attributen angefordert. Bitte bestätigen Sie Ihre Auswahl.';

wwv_flow_api.create_message (
  p_id=>195814525740152058 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CREATE_FORM_ON_WS',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_web_service_ref
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Web Service-Referenz, Vorgang';

wwv_flow_api.create_message (
  p_id=>195814621443152058 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.WEB_SERVICE_REF',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_input_items
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Form-Elemente';

wwv_flow_api.create_message (
  p_id=>195814708423152059 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.INPUT_ITEMS',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_output_items
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Ausgabeelemente';

wwv_flow_api.create_message (
  p_id=>195814802794152059 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.OUTPUT_ITEMS',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p30_no_view
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Es wurde keine Oracle-View gefunden, die der Microsoft Access-Abfrage entspricht. Die Microsoft Access-Abfragesyntax wurde in das Bearbeitungsfenster geladen. Ändern Sie diese Syntax entsprechend, um eine Oracle-View zu erstellen.';

wwv_flow_api.create_message (
  p_id=>195814915972152059 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P30_NO_VIEW',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p30_view_help
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Eine View muss den Status <b>Gültig</b> haben, um während des Migrationsprozesses verwendet werden zu können.';

wwv_flow_api.create_message (
  p_id=>195815007954152059 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P30_VIEW_HELP',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message storage
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Speicherung:';

wwv_flow_api.create_message (
  p_id=>195815106794152059 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'STORAGE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message memory
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Speicher:';

wwv_flow_api.create_message (
  p_id=>195815216580152059 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'MEMORY',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message home_page_users
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Benutzer:';

wwv_flow_api.create_message (
  p_id=>195815322577152060 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'HOME_PAGE_USERS',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message sessions
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Sessions:';

wwv_flow_api.create_message (
  p_id=>195815426214152060 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SESSIONS',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message active
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Aktiv';

wwv_flow_api.create_message (
  p_id=>195815509845152060 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACTIVE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p3_find_file
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Suchen Sie die Datei, die vom Exporter generiert wurde';

wwv_flow_api.create_message (
  p_id=>195815618282152060 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P3_FIND_FILE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p12_howto_step1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'<b>1. Microsoft Access-Metadaten exportieren.</b><br />'||chr(10)||
'Führen Sie den Exporter für Microsoft Access aus, und extrahieren Sie die Metadaten aus der MDB-Datei. Dadurch werden Ausgabedateien für die Datenbank (.xml) und die Anwendung (.sql) erstellt.'||chr(10)||
'<p />';

wwv_flow_api.create_message (
  p_id=>195815722464152060 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P12_HOWTO_STEP1',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p12_howto_step2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'<b>2. Microsoft Access-Datenbank zu Oracle migrieren.</b><br />'||chr(10)||
'Führen Sie Oracle Migration Workbench aus, und laden Sie die Metadaten der Datenbank aus Schritt 1. Dadurch werden das Schema und die Daten zu Oracle migriert.'||chr(10)||
'<p />';

wwv_flow_api.create_message (
  p_id=>195815820970152060 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P12_HOWTO_STEP2',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p12_howto_step3
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'<b>3. Oracle Application Express-Workspace erstellen.</b><br />'||chr(10)||
'Führen Sie Oracle Application Express aus, und erstellen Sie einen Workspace. Ordnen Sie den Workspace dem in Schritt 2 neu erstellten Schema zu.'||chr(10)||
'<p />';

wwv_flow_api.create_message (
  p_id=>195815927449152060 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P12_HOWTO_STEP3',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p12_howto_step4
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'<b>4. Migrationsprojekt erstellen.</b><br />'||chr(10)||
'Melden Sie sich bei dem in Schritt 3 erstellten Workspace an, und führen Sie Application Migration Workshop aus. Erstellen Sie ein Migrationsprojekt, und laden Sie die Metadaten der Anwendung aus Schritt 1.'||chr(10)||
'<p />';

wwv_flow_api.create_message (
  p_id=>195816001730152061 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P12_HOWTO_STEP4',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p12_howto_step5
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'<b>5. Microsoft Access-Anwendung analysieren.</b><br />In Application Migration Workshop können Sie die Metadaten der Access-Anwendung überprüfen und anpassen. Optimieren Sie den Anwendungsbereich der Migration, und passen Sie gegebenenfalls ungültige Objekte an. '||chr(10)||
'<p />';

wwv_flow_api.create_message (
  p_id=>195816100061152061 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P12_HOWTO_STEP5',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p12_howto_step6
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'<b>6. Oracle Application Express-Anwendung generieren.</b><br />'||chr(10)||
'Sie können entweder eine Anwendung erstellen, die auf gültigen Forms und Berichten basiert, oder eine Wartungsanwendung, die auf gültigen Tabellen und Views basiert.'||chr(10)||
'<p />';

wwv_flow_api.create_message (
  p_id=>195816220163152061 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P12_HOWTO_STEP6',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p12_howto_step7
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'<b>7. Application Express-Anwendung anpassen.</b><br />'||chr(10)||
'Öffnen Sie die Anwendung im Application Builder-Modul von Application Express, und passen Sie die migrierte Anwendung an. Sie können die Anwendungsattribute ändern oder der Anwendung neue Seiten hinzufügen.';

wwv_flow_api.create_message (
  p_id=>195816305815152061 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P12_HOWTO_STEP7',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message internal_users
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Intern';

wwv_flow_api.create_message (
  p_id=>195816403995152061 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INTERNAL_USERS',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message database_users
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Datenbank';

wwv_flow_api.create_message (
  p_id=>195816520583152061 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DATABASE_USERS',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p22_obj_created
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'"%0" wurde erfolgreich erstellt.';

wwv_flow_api.create_message (
  p_id=>195816606525152062 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P22_OBJ_CREATED',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p10_queries_help
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'In der linken Spalte können Sie die Abfragen auswählen, die in die Migration aufgenommen werden sollen. '||chr(10)||
'<br><br>'||chr(10)||
'Um eine Abfrage einzubeziehen, muss diese den Status <b>Gültig</b> haben. Standardmäßig werden alle Abfragen mit dem Status <b>Gültig</b> ausgewählt.'||chr(10)||
'<br><br>'||chr(10)||
'Wenn eine Abfrage nicht ausgewählt wird, um sie einzubeziehen, werden auch die auf dieser Abfrage basierenden Forms oder Berich';

h:=h||'te nicht in die Migration einbezogen.'||chr(10)||
'<br><br>'||chr(10)||
'Klicken Sie auf <b>Versuchen, ungültige Abfragen zu kompilieren</b>, um einen Bulk-Prozess auszuführen, der versucht, alle Abfragen zu kompilieren.'||chr(10)||
'<br><br>'||chr(10)||
'Klicken Sie auf <b>Änderungen anwenden</b>, um die Auswahlen oder Aktualisierungen zu speichern.';

wwv_flow_api.create_message (
  p_id=>195816728283152062 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P10_QUERIES_HELP',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p9_tables_help
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'In der linken Spalte können Sie die Tabellen auswählen, die in die Migration aufgenommen werden sollen. '||chr(10)||
'<br><br>'||chr(10)||
'Um eine Tabelle einzubeziehen, muss diese den Status <b>Gültig</b> haben. Standardmäßig werden alle Tabellen mit dem Status <b>Gültig</b> ausgewählt.'||chr(10)||
'<br><br>'||chr(10)||
'Wenn eine Abfrage nicht ausgewählt wird, um sie einzubeziehen, werden auch die auf dieser Tabelle basierenden Forms oder Berich';

h:=h||'te nicht in die Migration einbezogen.'||chr(10)||
'<br><br>'||chr(10)||
'Klicken Sie auf <b>Änderungen anwenden</b>, um die Auswahlen oder Aktualisierungen zu speichern.';

wwv_flow_api.create_message (
  p_id=>195816801720152062 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P9_TABLES_HELP',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p22_table_info
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Wenn für eine Tabelle kein Primärschlüssel definiert ist, klicken Sie auf <b>Primärschlüssel erstellen</b>. Alle zu migrierenden Tabellen müssen einen Primärschlüssel haben.';

wwv_flow_api.create_message (
  p_id=>195816921516152062 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P22_TABLE_INFO',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p8_forms_help
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'1. In der linken Spalte können Sie die Forms auswählen, die in die Migration aufgenommen werden sollen.'||chr(10)||
'<br /><br />'||chr(10)||
'Um eine Form einzubeziehen, muss diese den Status <b>Gültig</b> haben. Standardmäßig werden alle Abfragen ausgewählt, die auf gültigen Quellobjekten basieren.'||chr(10)||
'<br /><br />'||chr(10)||
'2. Klicken Sie auf <b>Auch nicht gültige SQL-Abfragen kompilieren</b>, um einen Prozess auszuführen, der versuc';

h:=h||'ht, alle ungültigen SQL-Abfragen zu kompilieren.'||chr(10)||
'<br /><br />'||chr(10)||
'3. Wählen Sie in der Spalte <b>Migrieren zu</b> den Typ des Oracle Application Express-Objekts, zu dem die Microsoft Access-Form migriert werden soll:  '||chr(10)||
'<li>Form (Standardoption)</li>'||chr(10)||
'<li>Tabellarische Form</li>'||chr(10)||
'<li>Bericht und Form</li>'||chr(10)||
'<br><br>'||chr(10)||
'Diese Optionen werden für gültige Tabellen und Abfragen angezeigt.'||chr(10)||
'<br><br>'||chr(10)||
'4. Klicken Sie ';

h:=h||'auf <b>Änderungen anwenden</b>, um die Auswahlen oder Aktualisierungen zu speichern. '||chr(10)||
'<p />'||chr(10)||
'';

wwv_flow_api.create_message (
  p_id=>195817025782152062 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P8_FORMS_HELP',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p20_reports_help
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'In der linken Spalte können Sie die Berichte auswählen, die in die Migration aufgenommen werden sollen'||chr(10)||
'<br><br>'||chr(10)||
'Um einen Bericht einzubeziehen, muss dieser den Status <b>Gültig</b> haben. Standardmäßig werden alle Berichte ausgewählt, die auf gültigen Quellobjekten basieren.'||chr(10)||
'<br><br>'||chr(10)||
'Klicken Sie auf <b>Versuchen, ungültige SQL-Abfragen zu kompilieren</b>, um einen Bulk-Prozess auszuführen, der ver';

h:=h||'sucht, alle ungültigen SQL-Abfragen zu kompilieren.'||chr(10)||
'<br><br>'||chr(10)||
'Klicken Sie auf <b>Änderungen anwenden</b>, um die Auswahlen oder Aktualisierungen zu speichern.';

wwv_flow_api.create_message (
  p_id=>195817114679152062 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P20_REPORTS_HELP',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p49_defs_help
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Beim Erstellen von neuen Anwendungen werden diese Standards verwendet.';

wwv_flow_api.create_message (
  p_id=>195817202589152063 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P49_DEFS_HELP',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_item_protection_save_item_internal_only_show
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Es wurde versucht, das Element %0 im Sessionstatus während der show-Verarbeitung zu speichern. Das Element ist nur intern geschützt.';

wwv_flow_api.create_message (
  p_id=>195817317611152063 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.ITEM_PROTECTION.SAVE_ITEM_INTERNAL_ONLY_SHOW',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_parser_line_exceeds_32k
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Die Skriptzeile überschreitet 32767 Byte';

wwv_flow_api.create_message (
  p_id=>195817426633152063 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_PARSER.LINE_EXCEEDS_32K',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_api_check_priv_obj
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Das Schema %0 hat keine Auswahlberechtigungen für die Tabelle oder View %1.';

wwv_flow_api.create_message (
  p_id=>195817515940152063 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_API.CHECK_PRIV_OBJ',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4050_approved_account_req_display
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Ihr Request für einen Workspace wurde genehmigt. ID-Daten wurden per E-Mail an %0 gesendet.';

wwv_flow_api.create_message (
  p_id=>195817631896152063 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4050.APPROVED_ACCOUNT_REQ_DISPLAY',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message archivelog
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Log-Archivierung: Ein';

wwv_flow_api.create_message (
  p_id=>195817722026152063 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ARCHIVELOG',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message noarchivelog
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Log-Archivierung: Aus';

wwv_flow_api.create_message (
  p_id=>195817825405152064 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'NOARCHIVELOG',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_search
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Suche';

wwv_flow_api.create_message (
  p_id=>195817921621152064 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.SEARCH',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_show_chart_by
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Diagramm anzeigen nach';

wwv_flow_api.create_message (
  p_id=>195818025492152064 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.SHOW_CHART_BY',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_choose_a_column
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Wählen Sie eine Spalte';

wwv_flow_api.create_message (
  p_id=>195818118486152064 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.CHOOSE_A_COLUMN',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_analysis
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0-Analyse';

wwv_flow_api.create_message (
  p_id=>195818225007152064 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.ANALYSIS',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_chart
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0-Diagramm';

wwv_flow_api.create_message (
  p_id=>195818316573152064 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.CHART',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_insert_form
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Einfüge-Form';

wwv_flow_api.create_message (
  p_id=>195818417178152065 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.INSERT FORM',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_create_new
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 neu erstellen';

wwv_flow_api.create_message (
  p_id=>195818507994152065 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.CREATE_NEW',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_update_form
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Aktualisierungs-Form';

wwv_flow_api.create_message (
  p_id=>195818618941152065 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.UPDATE_FORM',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_update
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 aktualisieren';

wwv_flow_api.create_message (
  p_id=>195818723587152065 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.UPDATE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_not_null
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 Name muss einen Wert haben.';

wwv_flow_api.create_message (
  p_id=>195818809256152065 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.NOT_NULL',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_is_num
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 muss eine Zahl sein.';

wwv_flow_api.create_message (
  p_id=>195818906210152065 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.IS_NUM',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_success_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erfolgsseite';

wwv_flow_api.create_message (
  p_id=>195819001524152065 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.SUCCESS_PAGE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_insert_success
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Die Daten wurden erfolgreich eingefügt.';

wwv_flow_api.create_message (
  p_id=>195819116323152066 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.INSERT_SUCCESS',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_insert_another
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Weiteres Element einfügen';

wwv_flow_api.create_message (
  p_id=>195819212599152066 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.INSERT_ANOTHER',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_view_report
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Bericht anzeigen';

wwv_flow_api.create_message (
  p_id=>195819315026152066 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.VIEW_REPORT',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_return_home
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Zurück zur Homepage';

wwv_flow_api.create_message (
  p_id=>195819420156152066 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.RETURN_HOME',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_success
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erfolg';

wwv_flow_api.create_message (
  p_id=>195819529159152066 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.SUCCESS',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_help_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Auf dieser Seite wird die Hilfe für eine Seite angezeigt.';

wwv_flow_api.create_message (
  p_id=>195819605383152066 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.HELP_PAGE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_return_prev_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Zurück zur vorherigen Seite';

wwv_flow_api.create_message (
  p_id=>195819708289152067 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.RETURN_PREV_PAGE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_menu
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 Navigationspfad';

wwv_flow_api.create_message (
  p_id=>195819826946152067 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.MENU',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_insert
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 einfügen';

wwv_flow_api.create_message (
  p_id=>195819920583152067 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.INSERT',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_report_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Anzeigen von Bericht nicht möglich.';

wwv_flow_api.create_message (
  p_id=>195820001965152067 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.REPORT_ERROR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_csv_link
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Arbeitsblatt';

wwv_flow_api.create_message (
  p_id=>195820120762152067 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.CSV_LINK',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_clear_cache_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Löschen von Cacheinhalt nicht möglich.';

wwv_flow_api.create_message (
  p_id=>195820224295152067 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.CLEAR_CACHE_ERROR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_reset_pagination_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Zurücksetzen von Seitennummerierung nicht möglich.';

wwv_flow_api.create_message (
  p_id=>195820313374152068 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.RESET_PAGINATION_ERROR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_insert_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Einfügen von Zeile in %0 nicht möglich.';

wwv_flow_api.create_message (
  p_id=>195820413792152068 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.INSERT_ERROR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_analyze
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Analysieren';

wwv_flow_api.create_message (
  p_id=>195820519797152068 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.ANALYZE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_report_and_edit
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Melden und bearbeiten';

wwv_flow_api.create_message (
  p_id=>195820632359152068 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.REPORT_AND_EDIT',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_create_new2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Neu erstellen';

wwv_flow_api.create_message (
  p_id=>195820702670152068 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.CREATE_NEW2',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p22_no_table
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Die zugehörige Microsoft Access-Tabelle wurde nicht erfolgreich zu Oracle migriert. Weitere Informationen hierzu finden Sie in der Log-Datei von Oracle Migration Workbench.';

wwv_flow_api.create_message (
  p_id=>195820828288152068 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P22_NO_TABLE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4050_p74_provision
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Datenbankbenutzer %0 mit Default Tablespace %1 und Datendatei %2 erstellt';

wwv_flow_api.create_message (
  p_id=>195820909266152069 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4050_P74_PROVISION',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p42_validate
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Um die Syntax der SQL-Abfrage zu validieren, klicken Sie auf <b>Validieren</b>. Die angezeigte Syntax wurde aus Ihrer Microsoft Access-Datenbank extrahiert.'||chr(10)||
'<br><br>'||chr(10)||
'Stellen Sie sicher, dass die Abfrage eine gültige Oracle-Syntax verwendet. Nur SQL-Abfragen mit dem Status <b>Gültig</b> können in den Migrationsprozess einbezogen werden. ';

wwv_flow_api.create_message (
  p_id=>195821012555152069 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P42_VALIDATE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_show_menu_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Anzeigen von Navigationspfad nicht möglich.';

wwv_flow_api.create_message (
  p_id=>195821124086152069 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.SHOW_MENU_ERROR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_display_region_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Anzeigen von Seitenregion nicht möglich.';

wwv_flow_api.create_message (
  p_id=>195821217000152069 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.DISPLAY_REGION_ERROR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_ws_entire_response_doc
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Gesamtes Antwortdokument';

wwv_flow_api.create_message (
  p_id=>195821312471152069 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_WS_ENTIRE_RESPONSE_DOC',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_web_services_invalid_wsdl
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Der angegebene URL hat kein gültiges WSDL-Dokument zurückgegeben.';

wwv_flow_api.create_message (
  p_id=>195821428690152069 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WEB_SERVICES.INVALID_WSDL',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message password_min_len_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Das Kennwort muss mindestens %0 Zeichen enthalten.';

wwv_flow_api.create_message (
  p_id=>195821504048152070 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PASSWORD_MIN_LEN_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message password_differs_by_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Das neue Kennwort muss sich vom alten Kennwort um mindestens %0 Zeichen unterscheiden.';

wwv_flow_api.create_message (
  p_id=>195821600629152070 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PASSWORD_DIFFERS_BY_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message password_one_alpha_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Das Kennwort muss mindestens ein alphabetisches Zeichen (%0) enthalten.';

wwv_flow_api.create_message (
  p_id=>195821723115152070 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PASSWORD_ONE_ALPHA_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message password_one_numeric_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Das Kennwort muss mindestens einen numerischen Wert (0123456789) enthalten.';

wwv_flow_api.create_message (
  p_id=>195821826205152070 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PASSWORD_ONE_NUMERIC_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message password_one_punctuation_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Das Kennwort muss mindestens ein Interpunktionszeichen (%0) enthalten.';

wwv_flow_api.create_message (
  p_id=>195821913905152070 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PASSWORD_ONE_PUNCTUATION_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message password_one_upper_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Das Kennwort muss mindestens ein Zeichen in Großbuchstaben enthalten.';

wwv_flow_api.create_message (
  p_id=>195822018391152070 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PASSWORD_ONE_UPPER_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message password_one_lower_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Das Kennwort muss mindestens ein Zeichen in Kleinbuchstaben enthalten.';

wwv_flow_api.create_message (
  p_id=>195822129810152070 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PASSWORD_ONE_LOWER_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message password_like_username_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Das Kennwort darf nicht den Benutzernamen enthalten.';

wwv_flow_api.create_message (
  p_id=>195822202651152071 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PASSWORD_LIKE_USERNAME_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message password_like_workspace_name_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Das Kennwort darf nicht den Workspace-Namen enthalten.';

wwv_flow_api.create_message (
  p_id=>195822325660152071 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PASSWORD_LIKE_WORKSPACE_NAME_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message password_like_words_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Das Kennwort enthält ein nicht zulässiges einfaches Wort.';

wwv_flow_api.create_message (
  p_id=>195822429335152071 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PASSWORD_LIKE_WORDS_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message exists_sql_query
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'SQL-Abfrage EXISTS';

wwv_flow_api.create_message (
  p_id=>195822506603152071 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'EXISTS_SQL_QUERY',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message not_exists_sql_query
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'SQL-Abfrage NOT EXISTS';

wwv_flow_api.create_message (
  p_id=>195822615413152071 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'NOT_EXISTS_SQL_QUERY',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message item_in_exp1_null
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Element in Ausdruck 1 ist NULL';

wwv_flow_api.create_message (
  p_id=>195822720294152071 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ITEM_IN_EXP1_NULL',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message item_in_exp1_not_null
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Element in Ausdruck 1 ist NOT NULL';

wwv_flow_api.create_message (
  p_id=>195822819049152072 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ITEM_IN_EXP1_NOT_NULL',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message func_ret_boolean
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'PL/SQL-Funktion, die Boolean zurückgibt';

wwv_flow_api.create_message (
  p_id=>195822907751152072 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'FUNC_RET_BOOLEAN',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message pref_eq_exp
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Wert von Voreinstellung in Ausdruck';

wwv_flow_api.create_message (
  p_id=>195823013370152072 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PREF_EQ_EXP',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message pref_ne_exp
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Wert von Voreinstellung in Ausdruck 1 ist NICHT gleich Ausdruck 2';

wwv_flow_api.create_message (
  p_id=>195823105264152072 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PREF_NE_EXP',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message item_exp1_eq_exp2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Wert von Element in Ausdruck 1 ist gleich Ausdruck 2';

wwv_flow_api.create_message (
  p_id=>195823211700152072 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ITEM_EXP1_EQ_EXP2',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message item_exp1_ne_exp2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Wert von Element in Ausdruck 1 ist NICHT gleich Ausdruck 2';

wwv_flow_api.create_message (
  p_id=>195823329867152072 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ITEM_EXP1_NE_EXP2',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message authz_cache_per_page_view
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Für jede Seitenansicht auswerten';

wwv_flow_api.create_message (
  p_id=>195823419852152073 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'AUTHZ_CACHE_PER_PAGE_VIEW',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message authz_cache_per_session
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Einmal pro Session auswerten';

wwv_flow_api.create_message (
  p_id=>195823505697152073 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'AUTHZ_CACHE_PER_SESSION',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message password_complexity_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Das Kennwort entspricht nicht den Komplexitätsregeln für Kennwörter.';

wwv_flow_api.create_message (
  p_id=>195823631455152073 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PASSWORD_COMPLEXITY_ERROR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_export
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Exportieren';

wwv_flow_api.create_message (
  p_id=>195823709033152073 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000.EXPORT',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_app_export_curr_ws
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Diese Anwendung wurde aus dem aktuellen Workspace exportiert.';

wwv_flow_api.create_message (
  p_id=>195823830988152073 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000.APP_EXPORT_CURR_WS',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_app_export_non_curr_ws
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Diese Anwendung wurde aus einem anderen Workspace exportiert.';

wwv_flow_api.create_message (
  p_id=>195823911875152073 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000.APP_EXPORT_NON_CURR_WS',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4050_ws_exists
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Der Workspace wird nicht erstellt, weil er bereits vorhanden ist.';

wwv_flow_api.create_message (
  p_id=>195824008159152074 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4050.WS_EXISTS',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4050_ws_tobe_created
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Der Workspace wird erstellt.';

wwv_flow_api.create_message (
  p_id=>195824109211152074 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4050.WS_TOBE_CREATED',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message back
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Zurück';

wwv_flow_api.create_message (
  p_id=>195824225732152074 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'BACK',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message today
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Heute';

wwv_flow_api.create_message (
  p_id=>195824313056152074 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'TODAY',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message forward
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Weiter';

wwv_flow_api.create_message (
  p_id=>195824431742152074 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'FORWARD',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_auth_scheme_desc_dad
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Datenbank-Authentifizierung verwenden (Benutzer von DAD identifiziert).';

wwv_flow_api.create_message (
  p_id=>195824519296152074 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.AUTH_SCHEME_DESC_DAD',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_auth_scheme_desc_internal
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ID-Daten von internem %0 Account und Anmeldeseite in dieser Anwendung verwenden.';

wwv_flow_api.create_message (
  p_id=>195824608724152075 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.AUTH_SCHEME_DESC_INTERNAL',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_sample_app
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Beispielanwendung';

wwv_flow_api.create_message (
  p_id=>195824701917152075 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO.SAMPLE.APP',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_sample_app_descr
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Eine Beispielanwendung, aus der allgemeine Designkonzepte hervorgehen.';

wwv_flow_api.create_message (
  p_id=>195824832750152075 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO.SAMPLE.APP.DESCR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_collect_descr
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Wissenswertes über die Konzepte bei Einkaufskorb.';

wwv_flow_api.create_message (
  p_id=>195824904954152075 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO.COLLECT.DESCR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message bytes
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Byte';

wwv_flow_api.create_message (
  p_id=>195825023519152075 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'BYTES',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message rows_returned_in
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Zeilen zurückgegeben in';

wwv_flow_api.create_message (
  p_id=>195825114135152075 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ROWS_RETURNED_IN',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message invalid_object
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Das Objekt %0 ist ungültig.';

wwv_flow_api.create_message (
  p_id=>195825214350152076 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INVALID_OBJECT',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message query_builder
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Query Builder';

wwv_flow_api.create_message (
  p_id=>195825325800152076 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'QUERY BUILDER',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message no_lov
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Keine Werteliste';

wwv_flow_api.create_message (
  p_id=>195825424566152076 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'NO_LOV',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message no_shortcut
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Kein Shortcut';

wwv_flow_api.create_message (
  p_id=>195825521852152076 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'NO_SHORTCUT',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message no_authorization_scheme
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Kein Autorisierungsschema';

wwv_flow_api.create_message (
  p_id=>195825611515152076 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'NO_AUTHORIZATION_SCHEME',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4350_reset_session
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Setzen Sie den Sessionstatus zurück, wenn die Anwendung ohne im Voraus festgelegte Werte ausgeführt werden soll.';

wwv_flow_api.create_message (
  p_id=>195825715489152076 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4350_RESET_SESSION',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p111_cancel_button_text
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Anzeigetext für die Schaltfläche Abbrechen';

wwv_flow_api.create_message (
  p_id=>195825804228152076 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000.P111.CANCEL_BUTTON_TEXT',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p111_finish_button_text
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Anzeigetext für die Schaltfläche Fertig stellen';

wwv_flow_api.create_message (
  p_id=>195825907691152077 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000.P111.FINISH_BUTTON_TEXT',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p111_previous_button_text
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Anzeigetext für die Schaltfläche Zurück';

wwv_flow_api.create_message (
  p_id=>195826018010152077 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000.P111.PREVIOUS_BUTTON_TEXT',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p111_next_button_text
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Anzeigetext für die Schaltfläche Weiter';

wwv_flow_api.create_message (
  p_id=>195826118321152077 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000.P111.NEXT_BUTTON_TEXT',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p111_cancel_button_branch
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Verzweigung für Schaltfläche Abbrechen';

wwv_flow_api.create_message (
  p_id=>195826201083152077 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000.P111.CANCEL_BUTTON_BRANCH',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p111_finish_button_branch
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Verzweigung für Schaltfläche Fertig stellen';

wwv_flow_api.create_message (
  p_id=>195826305295152077 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000.P111.FINISH_BUTTON_BRANCH',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message form_of
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 von %1';

wwv_flow_api.create_message (
  p_id=>195826407140152077 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'FORM_OF',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message html_button
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'HTML-Schaltfläche';

wwv_flow_api.create_message (
  p_id=>195826521175152078 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'HTML_BUTTON',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message one
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Eins';

wwv_flow_api.create_message (
  p_id=>195826625343152078 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ONE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message my_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Meine Seite';

wwv_flow_api.create_message (
  p_id=>195826707065152078 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'MY_PAGE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message copyright
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Copyright &copy; %0, All rights reserved. Alle Rechte vorbehalten.';

wwv_flow_api.create_message (
  p_id=>195826824756152078 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'COPYRIGHT',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message regions
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Regionen';

wwv_flow_api.create_message (
  p_id=>195826910527152078 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'REGIONS',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message processes
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Prozesse';

wwv_flow_api.create_message (
  p_id=>195827019154152078 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PROCESSES',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message computations
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Berechnungen';

wwv_flow_api.create_message (
  p_id=>195827116604152079 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'COMPUTATIONS',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message validations
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Validierungen';

wwv_flow_api.create_message (
  p_id=>195827221709152079 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'VALIDATIONS',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message branches
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Verzweigungen';

wwv_flow_api.create_message (
  p_id=>195827315964152079 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'BRANCHES',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message items
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Elemente';

wwv_flow_api.create_message (
  p_id=>195827418688152079 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ITEMS',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message buttons
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Schaltflächen';

wwv_flow_api.create_message (
  p_id=>195827515470152079 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'BUTTONS',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_report3_x_y_of_z_2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 - %1 von %2';

wwv_flow_api.create_message (
  p_id=>195827626863152079 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_REPORT3.X_Y_OF_Z_2',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4050_p74_provision1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Workspace %0 mit Administrator %1 durch Provisioning bereitgestellt.';

wwv_flow_api.create_message (
  p_id=>195827716297152080 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4050_P74_PROVISION1',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_web_services_wsdl_unretrievable
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Das WSDL-Dokument konnte nicht abgerufen werden, weil der angegebene URL ungültig war oder Ihre Umgebung eine gültige Proxyserveradresse für HTTP-Requests benötigt, die für diese Anwendung nicht definiert wurde, oder es muss ein Wallet für diese Instanz von &PRODUCT_NAME. für HTTPS-Requests konfiguriert werden.';

wwv_flow_api.create_message (
  p_id=>195827813195152080 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WEB_SERVICES.WSDL_UNRETRIEVABLE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_web_services_wsdl_no_soap
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Das WSDL-Dokument enthält kein Binding für SOAP. Dies ist erforderlich, um die Referenz hinzufügen zu können.';

wwv_flow_api.create_message (
  p_id=>195827923420152080 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WEB_SERVICES.WSDL_NO_SOAP',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message drillup
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Weniger Verzweigungsebenen anzeigen';

wwv_flow_api.create_message (
  p_id=>195828000156152080 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DRILLUP',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message drilldown
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Mehr Verzweigungsebenen anzeigen';

wwv_flow_api.create_message (
  p_id=>195828126721152080 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DRILLDOWN',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message edit
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Bearbeiten';

wwv_flow_api.create_message (
  p_id=>195828228377152080 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'EDIT',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message generated_table
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Diese Tabelle wurde mit dem Tabellenassistenten erstellt.';

wwv_flow_api.create_message (
  p_id=>195828321773152081 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'GENERATED_TABLE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message series
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Datenreihe %0';

wwv_flow_api.create_message (
  p_id=>195828432357152081 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SERIES',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_wizard_api_unable_to_fetch
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Abrufen von Zeile nicht möglich.';

wwv_flow_api.create_message (
  p_id=>195828513756152081 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WIZARD_API.UNABLE_TO_FETCH',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_wizard_api_unable_to_process
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Verarbeiten von Zeile der Tabelle %0 nicht möglich.';

wwv_flow_api.create_message (
  p_id=>195828627548152081 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WIZARD_API.UNABLE_TO_PROCESS',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_wizard_api_action_processed
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Aktion wurde verarbeitet.';

wwv_flow_api.create_message (
  p_id=>195828717371152081 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WIZARD_API.ACTION_PROCESSED',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message to_many_columns_selected
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Es können maximal %0 Spalten ausgewählt werden.';

wwv_flow_api.create_message (
  p_id=>195828801658152082 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'TO_MANY_COLUMNS_SELECTED',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4550_javascript_enabled
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Für diese Anwendung muss JavaScript aktiviert sein.';

wwv_flow_api.create_message (
  p_id=>195828921963152082 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4550_JAVASCRIPT_ENABLED',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4550_cookies_enabled
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Für diese Anwendung müssen Cookies aktiviert sein.';

wwv_flow_api.create_message (
  p_id=>195829026882152082 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4550_COOKIES_ENABLED',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_help_unauthorized
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unberechtigter Zugriff.';

wwv_flow_api.create_message (
  p_id=>195829116751152082 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_HELP.UNAUTHORIZED',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4500_p602_no_datatype
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Kein Datentyp für %0 angegeben.';

wwv_flow_api.create_message (
  p_id=>195829209073152082 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4500_P602_NO_DATATYPE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_web_services_multiple_soap
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Das WSDL-Dokument enthält mehrere SOAP-Bindings. &PRODUCT_NAME. unterstützt nur WSDLs mit einem SOAP-Binding. Klicken Sie auf <b>Web Service-Referenz manuell erstellen</b>, um mit dem Erstellvorgang für eine Referenz für diesen Service fortzufahren.';

wwv_flow_api.create_message (
  p_id=>195829328087152082 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WEB_SERVICES.MULTIPLE_SOAP',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4050_html_email_click_on_link
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Klicken Sie auf <a href=''%0''>here</a> um den Genehmigungsvorgang abzuschließen und Ihre ID-Daten zu erhalten.';

wwv_flow_api.create_message (
  p_id=>195829418207152083 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4050.HTML_EMAIL_CLICK_ON_LINK',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4500_p1023_parsing
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Skript wird geparst. Bitte warten.';

wwv_flow_api.create_message (
  p_id=>195829524187152083 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4500_P1023_PARSING',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_script_line_number
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Zeilennummer';

wwv_flow_api.create_message (
  p_id=>195829614678152083 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_SCRIPT.LINE_NUMBER',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_script_invalid_stmt
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Sie haben die Ausführung eines Skripts mit unbekannten Anweisungen angefordert. Entfernen Sie die folgenden Anweisungen.';

wwv_flow_api.create_message (
  p_id=>195829704918152083 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_SCRIPT.INVALID_STMT',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f400_p107_step
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Schritt %0';

wwv_flow_api.create_message (
  p_id=>195829830103152083 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F400_P107_STEP',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p4719_yn
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Ja/Nein anzeigen, Y und N zurückgeben';

wwv_flow_api.create_message (
  p_id=>195829929820152083 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000.P4719.YN',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_array
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Ergebnisbaum für Bericht';

wwv_flow_api.create_message (
  p_id=>195830029429152084 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.ARRAY',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_array_parms
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Ergebnisparameter für Bericht';

wwv_flow_api.create_message (
  p_id=>195830105454152084 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.ARRAY_PARMS',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_collection
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Name für die temporäre Ergebnismenge';

wwv_flow_api.create_message (
  p_id=>195830219088152084 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.COLLECTION',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_input_region_title
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Form-Regionsüberschrift';

wwv_flow_api.create_message (
  p_id=>195830303216152084 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.INPUT_REGION_TITLE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_input_region_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Form-Regions-Template';

wwv_flow_api.create_message (
  p_id=>195830405475152084 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.INPUT_REGION_TEMPLATE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_report_region_title
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Berichts-Regionsüberschrift';

wwv_flow_api.create_message (
  p_id=>195830528750152084 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.REPORT_REGION_TITLE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_report_region_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Berichtsregions-Template';

wwv_flow_api.create_message (
  p_id=>195830619927152085 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.REPORT_REGION_TEMPLATE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_dml_dml_insert_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Ausführen von INSERT-Vorgang nicht möglich. %0  %1';

wwv_flow_api.create_message (
  p_id=>195830722421152085 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_DML.DML_INSERT_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_rpt_template_name15
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Standard: Darstellung 5';

wwv_flow_api.create_message (
  p_id=>195830826067152085 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.RPT_TEMPLATE_NAME15',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message no_display_value
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'- Keine Anzeige -';

wwv_flow_api.create_message (
  p_id=>195830902313152085 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'NO_DISPLAY_VALUE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message xml_load_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'XML-Ladefehler.';

wwv_flow_api.create_message (
  p_id=>195831017489152085 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'XML_LOAD_ERROR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message shared_component
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Gemeinsame Komponente';

wwv_flow_api.create_message (
  p_id=>195831129572152085 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SHARED_COMPONENT',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p4731_delete
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Löschen';

wwv_flow_api.create_message (
  p_id=>195831203480152086 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000.P4731.DELETE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message unexpired
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Nicht abgelaufen';

wwv_flow_api.create_message (
  p_id=>195831302902152086 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'UNEXPIRED',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message html_chart
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'HTML-Diagramm';

wwv_flow_api.create_message (
  p_id=>195831401957152086 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'HTML_CHART',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message html_slash_text
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'HTML/Text';

wwv_flow_api.create_message (
  p_id=>195831531244152086 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'HTML_SLASH_TEXT',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message html_text_with_shortcuts
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'HTML-Text (mit Shortcuts)';

wwv_flow_api.create_message (
  p_id=>195831610357152086 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'HTML_TEXT_WITH_SHORTCUTS',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_generate_ddl_save_ddl_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Speichern von DDL als Skriptdatei nicht möglich. %0';

wwv_flow_api.create_message (
  p_id=>195831701989152087 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_GENERATE_DDL.SAVE_DDL_ERROR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message item_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Objektname';

wwv_flow_api.create_message (
  p_id=>195831830247152087 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ITEM NAME',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message display_type
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Anzeigetyp';

wwv_flow_api.create_message (
  p_id=>195831905234152087 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DISPLAY_TYPE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_data_quick_flow_analyze_column
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 analysieren';

wwv_flow_api.create_message (
  p_id=>195832026925152087 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_DATA_QUICK_FLOW.ANALYZE_COLUMN',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_data_quick_flow_view_by
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Anzeigen nach';

wwv_flow_api.create_message (
  p_id=>195832111427152087 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_DATA_QUICK_FLOW.VIEW_BY',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_create_analyze_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erstellen von Analyseseite nicht möglich. %0';

wwv_flow_api.create_message (
  p_id=>195832201800152087 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.CREATE_ANALYZE_PAGE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message icon
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Symbol %0';

wwv_flow_api.create_message (
  p_id=>195832304264152088 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ICON',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message check
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Zeilen-Selector';

wwv_flow_api.create_message (
  p_id=>195832400071152088 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CHECK$',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message link
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Spalten-Link';

wwv_flow_api.create_message (
  p_id=>195832513872152088 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LINK$',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message derived
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Abgeleitete Spalte';

wwv_flow_api.create_message (
  p_id=>195832620156152088 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DERIVED$',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_region_layout_about
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Info';

wwv_flow_api.create_message (
  p_id=>195832713228152088 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_REGION_LAYOUT.ABOUT',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_region_layout_branching
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Verzweigung';

wwv_flow_api.create_message (
  p_id=>195832812578152088 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_REGION_LAYOUT.BRANCHING',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p4731_add
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Zeile hinzufügen';

wwv_flow_api.create_message (
  p_id=>195832929215152088 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000.P4731.ADD',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_edit
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Bearbeiten';

wwv_flow_api.create_message (
  p_id=>195833032684152089 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.EDIT',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p295_page_must_be_numeric
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Die Seite muss numerisch sein.';

wwv_flow_api.create_message (
  p_id=>195833117700152089 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P295_PAGE_MUST_BE_NUMERIC',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p295_page_must_be_positive
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Die Seite muss eine positive Zahl darstellen.';

wwv_flow_api.create_message (
  p_id=>195833216698152089 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P295_PAGE_MUST_BE_POSITIVE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p295_page_must_be_whole_number
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Die Seite muss eine Ganzzahl darstellen.';

wwv_flow_api.create_message (
  p_id=>195833329263152089 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P295_PAGE_MUST_BE_WHOLE_NUMBER',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_collection_collection_not_exist
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Anwendungs-Collection %0 ist nicht vorhanden';

wwv_flow_api.create_message (
  p_id=>195833413086152089 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COLLECTION.COLLECTION_NOT_EXIST',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_collection_member_not_exist
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Die Mitglieder-Sequence %0 ist in Anwendungs-Collection %1 nicht vorhanden'||chr(10)||
'';

wwv_flow_api.create_message (
  p_id=>195833504152152089 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COLLECTION.MEMBER_NOT_EXIST',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_collection_attribute_number_invalid
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Die angegebene Mitgliedsattributnummer %0 ist ungültig';

wwv_flow_api.create_message (
  p_id=>195833611705152090 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COLLECTION.ATTRIBUTE_NUMBER_INVALID',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_collection_attribute_number_outside_range
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Die angegebene Mitgliedsattributnummer %0 ist ungültig.  Die Attributnummer muss zwischen 1 und %1 liegen';

wwv_flow_api.create_message (
  p_id=>195833719145152090 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COLLECTION.ATTRIBUTE_NUMBER_OUTSIDE_RANGE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_collection_member_sequence_number_invalid
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Die Mitglieder-Sequence %0 ist in Anwendungs-Collection "%1" nicht vorhanden';

wwv_flow_api.create_message (
  p_id=>195833801633152090 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COLLECTION.MEMBER_SEQUENCE_NUMBER_INVALID',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_collection_array_not_null
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Das Anwendungs-Collection-Array darf nicht Null sein';

wwv_flow_api.create_message (
  p_id=>195833921935152090 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COLLECTION.ARRAY_NOT_NULL',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_collection_collection_name_not_null
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Name der Collection darf nicht Null sein';

wwv_flow_api.create_message (
  p_id=>195834021313152090 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COLLECTION.COLLECTION_NAME_NOT_NULL',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_collection_collection_name_too_large
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Der Collection-Name darf maximal 255 Zeichen enthalten';

wwv_flow_api.create_message (
  p_id=>195834130458152090 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COLLECTION.COLLECTION_NAME_TOO_LARGE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_collection_collection_exists
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Anwendungs-Collection ist vorhanden';

wwv_flow_api.create_message (
  p_id=>195834222588152091 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COLLECTION.COLLECTION_EXISTS',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_collection_cursor_not_open
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Cursor ist noch nicht geöffnet';

wwv_flow_api.create_message (
  p_id=>195834327469152091 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COLLECTION.CURSOR_NOT_OPEN',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_seed_translations_translation_not_found
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 Übersetzung von Anwendung %1 nicht gefunden';

wwv_flow_api.create_message (
  p_id=>195834429689152091 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SEED_TRANSLATIONS.TRANSLATION_NOT_FOUND',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_seed_translations_seed_insert_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fehler beim Einfügen von Ausgangswert: %0.%1 %2';

wwv_flow_api.create_message (
  p_id=>195834516945152091 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SEED_TRANSLATIONS.SEED_INSERT_ERROR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_seed_translations_seed_delete_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fehler beim Löschen von Ausgangswert: %0.%1 %2';

wwv_flow_api.create_message (
  p_id=>195834612953152091 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SEED_TRANSLATIONS.SEED_DELETE_ERROR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_translations_seed_update_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fehler beim Aktualisieren von Ausgangswert: %0.%1 %2';

wwv_flow_api.create_message (
  p_id=>195834701131152091 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_TRANSLATIONS.SEED_UPDATE_ERROR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sync_translations_sync_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Synchronisationsfehler: %0.%1 %2';

wwv_flow_api.create_message (
  p_id=>195834818390152092 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SYNC_TRANSLATIONS.SYNC_ERROR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message trigger_sgid_reserved
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Die Sicherheitsgruppen-ID 20 ist für den Workspace ORACLE reserviert';

wwv_flow_api.create_message (
  p_id=>195834920316152092 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'TRIGGER.SGID_RESERVED',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message trigger_button_tab_names_not_equal
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Schaltflächennamen dürfen nicht mit dem Namen von vorhandenen Registerkarten identisch sein';

wwv_flow_api.create_message (
  p_id=>195835011374152092 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'TRIGGER.BUTTON_TAB_NAMES_NOT_EQUAL',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_file_api_error_writing_to_directory
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fehler beim Schreiben in das physische Dateiverzeichnis "%0". (%1: %2)';

wwv_flow_api.create_message (
  p_id=>195835124536152092 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FILE_API.ERROR_WRITING_TO_DIRECTORY',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_file_api_no_file_to_write
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Es ist keine Datei zum Schreiben für ID %0 vorhanden';

wwv_flow_api.create_message (
  p_id=>195835200811152092 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FILE_API.NO_FILE_TO_WRITE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_file_api_error_removing_file
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Beim Server ist ein Fehler beim Entfernen von Datei "%0" aufgetreten';

wwv_flow_api.create_message (
  p_id=>195835307167152092 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FILE_API.ERROR_REMOVING_FILE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_file_api_error_removing_file2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Entfernen von Datei %0 nicht möglich';

wwv_flow_api.create_message (
  p_id=>195835420461152092 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FILE_API.ERROR_REMOVING_FILE2',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_dml_version_of_data_changed_with_checksum
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Die aktuelle Version der Daten in der Datenbank wurde geändert, seit der Benutzer einen Update-Prozess eingeleitet hat. Aktuelle Prüfsumme (Checksum) = "%0" Anwendungs-Prüfsumme (Checksum) = "%1"'||chr(10)||
'';

wwv_flow_api.create_message (
  p_id=>195835522256152093 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_DML.VERSION_OF_DATA_CHANGED_WITH_CHECKSUM',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_dml_version_of_data_changed
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Die aktuelle Version der Daten in der Datenbank wurde geändert, seit der Benutzer einen Update-Prozess eingeleitet hat.';

wwv_flow_api.create_message (
  p_id=>195835632628152093 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_DML.VERSION_OF_DATA_CHANGED',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_dml_invalid_action
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Ungültige Aktion %0 bei diesem Objekt. (%1)';

wwv_flow_api.create_message (
  p_id=>195835706774152093 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_DML.INVALID_ACTION',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_templates_util_template_not_found
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Template (%0) für den Kopiervorgang nicht gefunden';

wwv_flow_api.create_message (
  p_id=>195835820716152093 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_TEMPLATES_UTIL.TEMPLATE_NOT_FOUND',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_templates_util_field_template_not_found
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Feld-Template (%0) in Anwendung "%1" Workspace "%2" für den Kopiervorgang nicht gefunden';

wwv_flow_api.create_message (
  p_id=>195835902555152093 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_TEMPLATES_UTIL.FIELD_TEMPLATE_NOT_FOUND',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_fnd_user_api_check_user
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unberechtigter Zugriff.';

wwv_flow_api.create_message (
  p_id=>195836029279152093 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FND_USER_API.CHECK_USER',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_templates_util_menu_template_not_found
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Navigationspfad-Template (%0) in Anwendung "%1" Workspace "%2" für den Kopiervorgang nicht gefunden';

wwv_flow_api.create_message (
  p_id=>195836116235152094 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_TEMPLATES_UTIL.MENU_TEMPLATE_NOT_FOUND',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_templates_util_button_template_not_found
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Schaltflächen-Template (%0) in Anwendung "%1" Workspace "%2" für den Kopiervorgang nicht gefunden';

wwv_flow_api.create_message (
  p_id=>195836208086152094 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_TEMPLATES_UTIL.BUTTON_TEMPLATE_NOT_FOUND',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_templates_util_template_replace
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Ersetzen von %0-Template nicht möglich. %1';

wwv_flow_api.create_message (
  p_id=>195836309672152094 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_TEMPLATES_UTIL.TEMPLATE_REPLACE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_templates_util_page_template_replace
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Ersetzen von Seiten-Template nicht möglich. %0';

wwv_flow_api.create_message (
  p_id=>195836424348152094 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_TEMPLATES_UTIL.PAGE_TEMPLATE_REPLACE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_templates_util_region_template_replace
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Ersetzen von Regions-Template nicht möglich. %0';

wwv_flow_api.create_message (
  p_id=>195836507834152094 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_TEMPLATES_UTIL.REGION_TEMPLATE_REPLACE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_templates_util_report_template_replace
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Ersetzen von Berichts-Template nicht möglich. %0';

wwv_flow_api.create_message (
  p_id=>195836609044152094 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_TEMPLATES_UTIL.REPORT_TEMPLATE_REPLACE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_templates_util_list_template_replace
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Ersetzen von Listen-Template nicht möglich. %0';

wwv_flow_api.create_message (
  p_id=>195836732394152095 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_TEMPLATES_UTIL.LIST_TEMPLATE_REPLACE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_templates_util_field_template_replace
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Ersetzen von Feld-Template nicht möglich. %0';

wwv_flow_api.create_message (
  p_id=>195836811750152095 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_TEMPLATES_UTIL.FIELD_TEMPLATE_REPLACE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_templates_util_menu_template_replace
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Ersetzen von Navigationspfad-Template nicht möglich. %0';

wwv_flow_api.create_message (
  p_id=>195836929381152095 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_TEMPLATES_UTIL.MENU_TEMPLATE_REPLACE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_templates_util_popup_lov_template_replace
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Ersetzen von Template für Popup-Werteliste nicht möglich.%0';

wwv_flow_api.create_message (
  p_id=>195837010742152095 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_TEMPLATES_UTIL.POPUP_LOV_TEMPLATE_REPLACE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_templates_util_button_template_replace
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Ersetzen von Schaltflächen-Template nicht möglich. %0';

wwv_flow_api.create_message (
  p_id=>195837131731152095 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_TEMPLATES_UTIL.BUTTON_TEMPLATE_REPLACE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p122_cal_templ
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Kalender-Templates, die dieses Template referenzieren';

wwv_flow_api.create_message (
  p_id=>195837205586152095 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P122_CAL_TEMPL',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_remove_page_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Entfernen von Seitenreferenz-ID nicht möglich. %0';

wwv_flow_api.create_message (
  p_id=>195837311506152095 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.REMOVE_PAGE_REFERENCE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_remove_region_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Entfernen von Regionsreferenz-ID nicht möglich. %0';

wwv_flow_api.create_message (
  p_id=>195837422310152096 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.REMOVE_REGION_REFERENCE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_remove_list_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Entfernen von Listenreferenz-ID nicht möglich. %0';

wwv_flow_api.create_message (
  p_id=>195837504751152096 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.REMOVE_LIST_REFERENCE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_remove_report_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Entfernen von Berichtsreferenz-ID nicht möglich. %0';

wwv_flow_api.create_message (
  p_id=>195837617624152096 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.REMOVE_REPORT_REFERENCE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_remove_field_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Entfernen von Feldreferenz-ID nicht möglich. %0';

wwv_flow_api.create_message (
  p_id=>195837726348152096 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.REMOVE_FIELD_REFERENCE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_remove_security_scheme_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Entfernen von Sicherheitsschema-Referenz-ID nicht möglich. %0';

wwv_flow_api.create_message (
  p_id=>195837808207152096 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.REMOVE_SECURITY_SCHEME_REFERENCE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_remove_shortcut_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Entfernen von Shortcut-Referenz-ID nicht möglich. %0';

wwv_flow_api.create_message (
  p_id=>195837918019152096 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.REMOVE_SHORTCUT_REFERENCE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_remove_navbar_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Entfernen von Navigationsleisten-Referenz-ID nicht möglich. %0';

wwv_flow_api.create_message (
  p_id=>195838029215152096 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.REMOVE_NAVBAR_REFERENCE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_remove_lov_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Entfernen von Referenz-ID für Werteliste nicht möglich. %0';

wwv_flow_api.create_message (
  p_id=>195838121753152097 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.REMOVE_LOV_REFERENCE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_remove_popup_lov_template_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Entfernen von Referenz-ID für Popup-Werteliste nicht möglich. %0';

wwv_flow_api.create_message (
  p_id=>195838208009152097 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.REMOVE_POPUP_LOV_TEMPLATE_REFERENCE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_remove_menu_template_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Entfernen von Navigationspfad-Template-Referenz-ID nicht möglich. %0';

wwv_flow_api.create_message (
  p_id=>195838329382152097 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.REMOVE_MENU_TEMPLATE_REFERENCE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_remove_button_template_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Entfernen von Schaltflächen-Template-Referenz-ID nicht möglich. %0';

wwv_flow_api.create_message (
  p_id=>195838418061152097 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.REMOVE_BUTTON_TEMPLATE_REFERENCE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_create_form_on_ws_rpt
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Sie haben das Erstellen einer Form und eines Berichts über eine Web Service-Referenzseite mit folgenden Attributen angefordert. Bitte bestätigen Sie Ihre Auswahl.';

wwv_flow_api.create_message (
  p_id=>195838504824152097 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CREATE_FORM_ON_WS_RPT',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_remove_auth_setup_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Entfernen von Authentifizierungsschema-Referenz-ID nicht möglich. %0';

wwv_flow_api.create_message (
  p_id=>195838619720152097 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.REMOVE_AUTH_SETUP_REFERENCE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_remove_item_help_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Entfernen von Elementhilfe-Referenz-ID nicht möglich. %0';

wwv_flow_api.create_message (
  p_id=>195838721374152098 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.REMOVE_ITEM_HELP_REFERENCE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_subscribe_page_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Abonnieren von Seiten-Template nicht möglich. %0';

wwv_flow_api.create_message (
  p_id=>195838818319152098 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.SUBSCRIBE_PAGE_TEMPLATE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_subscribe_region_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Abonnieren von Regions-Template nicht möglich. %0';

wwv_flow_api.create_message (
  p_id=>195838926623152098 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.SUBSCRIBE_REGION_TEMPLATE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_subscribe_list_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Abonnieren von Listen-Template nicht möglich. %0';

wwv_flow_api.create_message (
  p_id=>195839026502152098 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.SUBSCRIBE_LIST_TEMPLATE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_subscribe_report_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Abonnieren von Berichts-Template nicht möglich. %0';

wwv_flow_api.create_message (
  p_id=>195839102847152098 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.SUBSCRIBE_REPORT_TEMPLATE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_subscribe_field_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Abonnieren von Feld-Template nicht möglich. %0';

wwv_flow_api.create_message (
  p_id=>195839212326152098 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.SUBSCRIBE_FIELD_TEMPLATE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_subscribe_popup_lov_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Abonnieren von Template für Popup-Werteliste nicht möglich. %0';

wwv_flow_api.create_message (
  p_id=>195839324339152099 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.SUBSCRIBE_POPUP_LOV_TEMPLATE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_subscribe_menu_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Abonnieren von Navigationspfad-Template nicht möglich. %0';

wwv_flow_api.create_message (
  p_id=>195839406062152099 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.SUBSCRIBE_MENU_TEMPLATE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_subscribe_button_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Abonnieren von Schaltflächen-Template nicht möglich. %0';

wwv_flow_api.create_message (
  p_id=>195839508865152099 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.SUBSCRIBE_BUTTON_TEMPLATE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_subscribe_security_scheme
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Abonnieren von Sicherheitsschema nicht möglich. %0';

wwv_flow_api.create_message (
  p_id=>195839625650152099 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.SUBSCRIBE_SECURITY_SCHEME',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_subscribe_shortcut
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Abonnieren von Shortcut nicht möglich. %0';

wwv_flow_api.create_message (
  p_id=>195839719623152099 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.SUBSCRIBE_SHORTCUT',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_subscribe_navbar
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Abonnieren von Navigationsleiste nicht möglich. %0';

wwv_flow_api.create_message (
  p_id=>195839807690152099 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.SUBSCRIBE_NAVBAR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_subscribe_lov
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Abonnieren von Werteliste nicht möglich. %0';

wwv_flow_api.create_message (
  p_id=>195839915937152099 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.SUBSCRIBE_LOV',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_subscribe_auth_setup
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Abonnieren von Authentifizierungsschema nicht möglich. %0';

wwv_flow_api.create_message (
  p_id=>195840027139152100 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.SUBSCRIBE_AUTH_SETUP',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_subscribe_item_help
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Abonnieren von Elementhilfe nicht möglich. %0';

wwv_flow_api.create_message (
  p_id=>195840108505152100 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.SUBSCRIBE_ITEM_HELP',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_publish_page_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Veröffentlichen von Seiten-Template nicht möglich. %0';

wwv_flow_api.create_message (
  p_id=>195840205102152100 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.PUBLISH_PAGE_TEMPLATE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_publish_region_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Veröffentlichen von Regions-Template nicht möglich. %0';

wwv_flow_api.create_message (
  p_id=>195840300921152100 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.PUBLISH_REGION_TEMPLATE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_publish_list_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Veröffentlichen von Listen-Template nicht möglich. %0';

wwv_flow_api.create_message (
  p_id=>195840405662152100 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.PUBLISH_LIST_TEMPLATE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_publish_report_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Veröffentlichen von Berichts-Template nicht möglich. %0';

wwv_flow_api.create_message (
  p_id=>195840508810152100 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.PUBLISH_REPORT_TEMPLATE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_publish_field_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Veröffentlichen von Feld-Template nicht möglich. %0';

wwv_flow_api.create_message (
  p_id=>195840603302152101 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.PUBLISH_FIELD_TEMPLATE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_publish_popup_lov_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Veröffentlichen von Template für Popup-Werteliste nicht möglich. %0';

wwv_flow_api.create_message (
  p_id=>195840727907152101 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.PUBLISH_POPUP_LOV_TEMPLATE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_publish_button_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Veröffentlichen von Schaltflächen-Template nicht möglich. %0'||chr(10)||
'';

wwv_flow_api.create_message (
  p_id=>195840821836152101 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.PUBLISH_BUTTON_TEMPLATE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_publish_menu_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Veröffentlichen von Navigationspfad-Template nicht möglich. %0'||chr(10)||
'';

wwv_flow_api.create_message (
  p_id=>195840926494152101 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.PUBLISH_MENU_TEMPLATE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_publish_security_scheme
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Veröffentlichen von Sicherheitsschema nicht möglich. %0';

wwv_flow_api.create_message (
  p_id=>195841009310152101 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.PUBLISH_SECURITY_SCHEME',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_publish_shortcut
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Veröffentlichen von Shortcut nicht möglich. %0'||chr(10)||
'';

wwv_flow_api.create_message (
  p_id=>195841101578152101 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.PUBLISH_SHORTCUT',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_publish_navbar
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Veröffentlichen von Navigationsleiste nicht möglich. %0';

wwv_flow_api.create_message (
  p_id=>195841216617152102 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.PUBLISH_NAVBAR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_publish_lov
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Veröffentlichen von Werteliste nicht möglich. %0'||chr(10)||
'';

wwv_flow_api.create_message (
  p_id=>195841313588152102 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.PUBLISH_LOV',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_publish_auth_setup
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Veröffentlichen von Authentifizierungsschema nicht möglich. %0'||chr(10)||
'';

wwv_flow_api.create_message (
  p_id=>195841417296152102 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.PUBLISH_AUTH_SETUP',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_publish_item_help
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Veröffentlichen von Elementhilfe nicht möglich. %0'||chr(10)||
'';

wwv_flow_api.create_message (
  p_id=>195841519954152102 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.PUBLISH_ITEM_HELP',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_provisioning_user_no_privileges
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Benutzer %0 besitzt keine Zugriffsberechtigung auf das %1-Schema.'||chr(10)||
'';

wwv_flow_api.create_message (
  p_id=>195841626987152102 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PROVISIONING.USER_NO_PRIVILEGES',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_provisioning_no_company
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Es wurde kein Workspace mit folgender Workspace-ID gefunden: %0';

wwv_flow_api.create_message (
  p_id=>195841705158152102 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PROVISIONING.NO_COMPANY',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_provisioning_no_schema
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Es wurde kein Schema für die Workspace-ID zugeordnet: %0';

wwv_flow_api.create_message (
  p_id=>195841811187152103 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PROVISIONING.NO_SCHEMA',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_provisioning_auto_provision_failure
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Das automatische Provisioning war während der "MAKE_REQUEST"-Phase nicht erfolgreich';

wwv_flow_api.create_message (
  p_id=>195841914731152103 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PROVISIONING.AUTO_PROVISION_FAILURE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_provisioning_company_user_add
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Beim Hinzufügen eines Benutzers zum Workspace %0 ist ein Fehler aufgetreten';

wwv_flow_api.create_message (
  p_id=>195842000817152103 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PROVISIONING.COMPANY_USER_ADD',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_provisioning_request_processed
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Dieser Request wurde verarbeitet oder wird gerade verarbeitet. Der Status muss "%0" lauten';

wwv_flow_api.create_message (
  p_id=>195842116452152103 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PROVISIONING.REQUEST_PROCESSED',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_provisioning_company_reserved
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Der Workspace %0 ist ein reservierter Name. Der Request wurde verweigert';

wwv_flow_api.create_message (
  p_id=>195842204194152103 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PROVISIONING.COMPANY_RESERVED',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_provisioning_schema_reserved
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Der Schemaname %0 ist ein reserviertes Schema und kann nicht durch Provisioning bereitgestellt werden.';

wwv_flow_api.create_message (
  p_id=>195842305329152103 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PROVISIONING.SCHEMA_RESERVED',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_provisioning_request_not_processed
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Der Request %0 konnte nicht verarbeitet werden. %1';

wwv_flow_api.create_message (
  p_id=>195842424974152104 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PROVISIONING.REQUEST_NOT_PROCESSED',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_provisioning_schema_exists
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Der Request %0 konnte nicht verarbeitet werden, weil das Schema %1 in der %2-Tabelle vorhanden ist.';

wwv_flow_api.create_message (
  p_id=>195842518700152104 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PROVISIONING.SCHEMA_EXISTS',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_provisioning_request_not_found
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Request %0 nicht gefunden';

wwv_flow_api.create_message (
  p_id=>195842620042152104 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PROVISIONING.REQUEST_NOT_FOUND',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_generate_ddl_generate_ddl_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Rem Generieren von DDL für %0 %1 nicht möglich.';

wwv_flow_api.create_message (
  p_id=>195842715334152104 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_GENERATE_DDL.GENERATE_DDL_ERROR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_generate_ddl_save_ddl_parse_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fehler beim Parsen von DDL-Skript. %0';

wwv_flow_api.create_message (
  p_id=>195842827670152104 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_GENERATE_DDL.SAVE_DDL_PARSE_ERROR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_generate_ddl_save_ddl_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Save_ddl-Fehler %0';

wwv_flow_api.create_message (
  p_id=>195842900750152104 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_GENERATE_DDL.SAVE_DDL ERROR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_install_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Importieren der Attribut-ID für die Datenbankobjektinstallation nicht möglich="%0"';

wwv_flow_api.create_message (
  p_id=>195843002584152104 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_INSTALL_CREATE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_install_script_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fehler beim Erstellen der Installationsskript-ID="%0"';

wwv_flow_api.create_message (
  p_id=>195843127154152105 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_INSTALL_SCRIPT_CREATE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_wizard_api_next_prev_pk_process_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erstellen des Prozesses für den Abruf des vorherigen Primärschlüsselwertes nicht möglich. %0';

wwv_flow_api.create_message (
  p_id=>195843231271152105 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WIZARD_API.NEXT_PREV_PK_PROCESS_ERROR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_create_table_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erstellen der Zugriffskontrolltabellen nicht möglich. %0';

wwv_flow_api.create_message (
  p_id=>195843308990152105 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_CREATE_TABLE_ERROR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_create_page_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erstellen der Zugriffskontrollseite nicht möglich. %0';

wwv_flow_api.create_message (
  p_id=>195843417313152105 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_CREATE_PAGE_ERROR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message out_of_range
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Ungültige Zeilenmenge angefordert, die Quelldaten des Berichts wurden geändert.';

wwv_flow_api.create_message (
  p_id=>195843506618152105 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'OUT_OF_RANGE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message reset
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Seitennummerierung zurücksetzen';

wwv_flow_api.create_message (
  p_id=>195843616572152105 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'RESET',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message installer_welcome_message
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Dieses Anwendungsinstallationsprogramm führt Sie durch den Prozess zum Erstellen von Datenbankobjekten und Seed-Daten.';

wwv_flow_api.create_message (
  p_id=>195843708922152106 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTALLER.WELCOME_MESSAGE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message installer_configuration_message
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Sie können die folgenden Attribute der Anwendung konfigurieren.';

wwv_flow_api.create_message (
  p_id=>195843810580152106 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTALLER.CONFIGURATION_MESSAGE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message installer_build_options_message
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Sie können die folgenden Erstelloptionen einbeziehen.';

wwv_flow_api.create_message (
  p_id=>195843912896152106 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTALLER.BUILD_OPTIONS_MESSAGE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message installer_validation_message
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Die folgenden Validierungen werden durchgeführt, um sicherzustellen, dass das System mit dieser Anwendung kompatibel ist.';

wwv_flow_api.create_message (
  p_id=>195844015982152106 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTALLER.VALIDATION_MESSAGE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message installer_confirmation_message
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Bestätigen Sie, dass Sie die unterstützenden Objekte dieser Anwendung installieren möchten.';

wwv_flow_api.create_message (
  p_id=>195844117886152106 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTALLER.CONFIRMATION_MESSAGE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message installer_success_message
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Ihre unterstützenden Objekte wurden installiert.';

wwv_flow_api.create_message (
  p_id=>195844214301152106 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTALLER.SUCCESS_MESSAGE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message installer_failure_message
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Installation der Datenbankobjekte und Seed-Daten nicht erfolgreich.';

wwv_flow_api.create_message (
  p_id=>195844332251152107 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTALLER.FAILURE_MESSAGE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message installer_deinstall_success_message
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Deinstallation abgeschlossen.';

wwv_flow_api.create_message (
  p_id=>195844420939152107 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTALLER.DEINSTALL_SUCCESS_MESSAGE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_method
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Methode';

wwv_flow_api.create_message (
  p_id=>195844524612152107 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_METHOD',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_details
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Details';

wwv_flow_api.create_message (
  p_id=>195844629211152107 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_DETAILS',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_details_bi1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Integrierte Sessionverwaltungslogik, eine integrierte Anmeldeseite und die Benutzerauthentifizierung beim internen "Cookie User"-Account-Repository.';

wwv_flow_api.create_message (
  p_id=>195844709750152107 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_DETAILS_BI1',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_details_bi2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Integrierte Sessionverwaltungslogik. Die Benutzerauthentifizierung wird über die modplsql-DAD-Konfiguration ausgeführt.'||chr(10)||
'';

wwv_flow_api.create_message (
  p_id=>195844826076152107 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_DETAILS_BI2',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_details_obs1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Diese Methode wurde durch die SCHEME-Authentifizierung ersetzt.';

wwv_flow_api.create_message (
  p_id=>195844914049152107 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_DETAILS_OBS1',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_details_obs2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Diese Methode wurde verworfen.';

wwv_flow_api.create_message (
  p_id=>195845015685152108 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_DETAILS_OBS2',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_public_pages
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Seiten veröffentlichen';

wwv_flow_api.create_message (
  p_id=>195845112366152108 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_PUBLIC_PAGES',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_action
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Aktion';

wwv_flow_api.create_message (
  p_id=>195845224817152108 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_ACTION',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_review1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Überprüfen oder bearbeiten';

wwv_flow_api.create_message (
  p_id=>195845306332152108 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_REVIEW1',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_review2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'oder bearbeiten';

wwv_flow_api.create_message (
  p_id=>195845411607152108 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_REVIEW2',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_review3
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Attribute der Sessionverwaltung';

wwv_flow_api.create_message (
  p_id=>195845514535152108 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_REVIEW3',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_review4
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'dieser Anwendung auf der Seite für die Anwendungsattribute. Oder verwenden Sie den oben angegebenen Bericht, um Authentifizierungsschemas zu erstellen und zu verwalten, die verwendet werden können, wenn Sie als Authentifizierungsmethode %0 festlegen.';

wwv_flow_api.create_message (
  p_id=>195845616816152109 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_REVIEW4',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_paren_none
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'(keine)';

wwv_flow_api.create_message (
  p_id=>195845702385152109 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_PAREN_NONE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_manage
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Verwalten Sie Authentifizierungsschemas mit dem oben angegebenen Bericht.';

wwv_flow_api.create_message (
  p_id=>195845819907152109 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_MANAGE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_deactivate
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Status in inaktiv ändern';

wwv_flow_api.create_message (
  p_id=>195845926063152109 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_DEACTIVATE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_paren_current
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'(aktuell)';

wwv_flow_api.create_message (
  p_id=>195846005725152109 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_PAREN_CURRENT',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_activate1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Dieses Schema als aktuelles Schema festlegen';

wwv_flow_api.create_message (
  p_id=>195846107142152109 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_ACTIVATE1',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_activate2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Als aktuelles Element festlegen';

wwv_flow_api.create_message (
  p_id=>195846212886152110 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_ACTIVATE2',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p802_copy_from
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Kopiert aus Anwendung';

wwv_flow_api.create_message (
  p_id=>195846320663152110 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P802_COPY_FROM',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p802_master
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Hierbei handelt es sich um die "Master"-Kopie dieses Authentifizierungsschemas.';

wwv_flow_api.create_message (
  p_id=>195846414955152110 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P802_MASTER',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p802_subscribers
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Schemas, die dieses Authentifizierungsschema referenzieren';

wwv_flow_api.create_message (
  p_id=>195846522893152110 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P802_SUBSCRIBERS',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p802_no_subscribers
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Es gibt keine Abonnenten für dieses Authentifizierungsschema.';

wwv_flow_api.create_message (
  p_id=>195846623656152110 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P802_NO_SUBSCRIBERS',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p811_paren_builtin
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'(Integriert)';

wwv_flow_api.create_message (
  p_id=>195846724557152110 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P811_PAREN_BUILTIN',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p811_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Name';

wwv_flow_api.create_message (
  p_id=>195846801604152111 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P811_NAME',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p811_pg_sentry
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Seiten-Sentry-Funktion';

wwv_flow_api.create_message (
  p_id=>195846919898152111 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P811_PG_SENTRY',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p811_sess_verify
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Funktion für die Sessionverifizierung';

wwv_flow_api.create_message (
  p_id=>195847016456152111 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P811_SESS_VERIFY',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p811_inv_sess_tgt
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Ungültiges Sessionziel';

wwv_flow_api.create_message (
  p_id=>195847120062152111 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P811_INV_SESS_TGT',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p811_pre_auth
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Prozess vor der Authentifizierung';

wwv_flow_api.create_message (
  p_id=>195847223894152111 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P811_PRE_AUTH',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p811_auth
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Authentifizierungsfunktion'||chr(10)||
'';

wwv_flow_api.create_message (
  p_id=>195847306149152111 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P811_AUTH',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p811_ldap_host
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'LDAP-Host';

wwv_flow_api.create_message (
  p_id=>195847430438152112 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P811_LDAP_HOST',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p811_ldap_port
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'LDAP-Port';

wwv_flow_api.create_message (
  p_id=>195847523563152112 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P811_LDAP_PORT',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p811_ldap_dn
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Basis für die LDAP-Suche';

wwv_flow_api.create_message (
  p_id=>195847618014152112 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P811_LDAP_DN',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p811_ldap_edit
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'LDAP-Benutzername bearbeiten';

wwv_flow_api.create_message (
  p_id=>195847706819152112 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P811_LDAP_EDIT',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p811_post_auth
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Prozess nach der Authentifizierung';

wwv_flow_api.create_message (
  p_id=>195847826562152112 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P811_POST_AUTH',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p811_c_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Cookie-Name';

wwv_flow_api.create_message (
  p_id=>195847925578152112 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P811_C_NAME',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p811_c_path
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Cookie-Pfad';

wwv_flow_api.create_message (
  p_id=>195848031225152112 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P811_C_PATH',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p811_c_domain
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Cookie-Domain';

wwv_flow_api.create_message (
  p_id=>195848109728152113 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P811_C_DOMAIN',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p811_logout_url
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Abmelde-URL';

wwv_flow_api.create_message (
  p_id=>195848230486152113 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P811_LOGOUT_URL',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p811_paren_dbauth
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'(Datenbank-Authentifizierung)';

wwv_flow_api.create_message (
  p_id=>195848321247152113 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P811_PAREN_DBAUTH',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p819_flow_id
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Anwendungs-ID';

wwv_flow_api.create_message (
  p_id=>195848404968152113 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P819_FLOW_ID',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p819_auth_method
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Authentifizierungsmethode';

wwv_flow_api.create_message (
  p_id=>195848515073152113 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P819_AUTH_METHOD',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p819_scheme_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Schemaname';

wwv_flow_api.create_message (
  p_id=>195848601087152113 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P819_SCHEME_NAME',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p819_description
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Beschreibung';

wwv_flow_api.create_message (
  p_id=>195848715547152114 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P819_DESCRIPTION',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p822_curr_method
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Aktuelle Authentifizierungsmethode';

wwv_flow_api.create_message (
  p_id=>195848820387152114 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P822_CURR_METHOD',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_create_list_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erstellen von Listen-Template nicht möglich. %0';

wwv_flow_api.create_message (
  p_id=>195848916345152114 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.CREATE_LIST_TEMPLATE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_create_flow
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Anwendung kann nicht erstellt werden. %0';

wwv_flow_api.create_message (
  p_id=>195849017521152114 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.CREATE_FLOW',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_create_page_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erstellen von Seiten-Template nicht möglich. %0';

wwv_flow_api.create_message (
  p_id=>195849102197152114 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.CREATE_PAGE_TEMPLATE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_create_label_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erstellen von Label-Template nicht möglich. %0';

wwv_flow_api.create_message (
  p_id=>195849201697152114 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.CREATE_LABEL_TEMPLATE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_create_report_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erstellen von Berichts-Template nicht möglich. %0';

wwv_flow_api.create_message (
  p_id=>195849317929152115 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.CREATE_REPORT_TEMPLATE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_create_region_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erstellen von Regions-Template nicht möglich. %0';

wwv_flow_api.create_message (
  p_id=>195849417820152115 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.CREATE_REGION_TEMPLATE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_create_menu_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erstellen von Navigationspfad-Template nicht möglich. %0';

wwv_flow_api.create_message (
  p_id=>195849529927152115 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.CREATE_MENU_TEMPLATE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_create_button_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erstellen von Schaltflächen-Template nicht möglich. %0';

wwv_flow_api.create_message (
  p_id=>195849619175152115 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.CREATE_BUTTON_TEMPLATE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_popup_lov_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erstellen von Template für Popup-Werteliste nicht möglich.';

wwv_flow_api.create_message (
  p_id=>195849714620152115 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.POPUP_LOV_TEMPLATE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_create_tab
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erstellen von Standardregisterkarten nicht möglich. %0';

wwv_flow_api.create_message (
  p_id=>195849809625152115 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.CREATE_TAB',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_create_navbar
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erstellen von Navigationsleiste nicht möglich. %0';

wwv_flow_api.create_message (
  p_id=>195849927403152115 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.CREATE_NAVBAR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_create_menu
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Navigationspfad kann nicht erstellt werden. %0';

wwv_flow_api.create_message (
  p_id=>195850023375152116 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.CREATE_MENU',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_create_report_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erstellen von Berichtsseite nicht möglich. %0';

wwv_flow_api.create_message (
  p_id=>195850105761152116 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.CREATE_REPORT_PAGE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_create_insert_form
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erstellen von Einfüge-Form nicht möglich. %0';

wwv_flow_api.create_message (
  p_id=>195850218842152116 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.CREATE_INSERT_FORM',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_create_update_form
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erstellen von Aktualisierungs-Form nicht möglich. %0';

wwv_flow_api.create_message (
  p_id=>195850324758152116 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.CREATE_UPDATE_FORM',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_create_chart_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erstellen von Diagrammseite nicht möglich.';

wwv_flow_api.create_message (
  p_id=>195850421275152116 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.CREATE_CHART_PAGE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_err_ldap_user_edit
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fehler beim Einrichten der Bearbeitung des LDAP-Benutzernamens.';

wwv_flow_api.create_message (
  p_id=>195850502027152116 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ERR_LDAP_USER_EDIT',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_err_ldap_user_fn
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Ausführen der Bearbeitung der LDAP-Benutzerfunktion nicht möglich.';

wwv_flow_api.create_message (
  p_id=>195850608656152117 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ERR_LDAP_USER_FN',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_err_ldap_missing
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'SYS.DBMS_LDAP-Package ist nicht vorhanden oder ungültig.';

wwv_flow_api.create_message (
  p_id=>195850717044152117 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ERR_LDAP_MISSING',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_err_ldap_fix
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Bitten Sie Ihren Datenbankadministrator, die Datei $OH/rdbms/admin/catldap.sql auszuführen.';

wwv_flow_api.create_message (
  p_id=>195850817466152117 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ERR_LDAP_FIX',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_err_run_ldap_auth
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fehler beim Ausführen von wwv_flow_custom_auth_ldap.authenticate.';

wwv_flow_api.create_message (
  p_id=>195850932007152117 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ERR_RUN_LDAP_AUTH',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_err_run_pre_auth
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Ausführen von benutzerdefiniertem Prozess vor der Authentifizierung nicht möglich.';

wwv_flow_api.create_message (
  p_id=>195851017758152117 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ERR_RUN_PRE_AUTH',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_err_setup_cred
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fehler beim Einrichten der Ausführung von ID-Daten-Prüfung.';

wwv_flow_api.create_message (
  p_id=>195851109252152117 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ERR_SETUP_CRED',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_err_run_cred
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Ausführen von Funktion zum Prüfen der Authentifizierungs-ID-Daten nicht möglich.';

wwv_flow_api.create_message (
  p_id=>195851210201152118 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ERR_RUN_CRED',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_err_run_post_auth
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Ausführen von benutzerdefiniertem Prozess nach der Authentifizierung nicht möglich.';

wwv_flow_api.create_message (
  p_id=>195851308317152118 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ERR_RUN_POST_AUTH',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_err_malformed_login_args
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fehlerhaftes Argument für wwv_flow_custom_auth_std.login--p_flow_page:p_session_id:p_entry_point:%0:%1:%2.';

wwv_flow_api.create_message (
  p_id=>195851429309152118 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ERR_MALFORMED_LOGIN_ARGS',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_err_null_login_arg
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Null p_session_id-Argument an wwv_flow_custom_auth_std.login--p_flow_page:%0';

wwv_flow_api.create_message (
  p_id=>195851512503152118 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ERR_NULL_LOGIN_ARG',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_err_contact_admin
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Wenden Sie sich an Ihren Administrator.';

wwv_flow_api.create_message (
  p_id=>195851620781152118 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ERR_CONTACT_ADMIN',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_err_illegal_login_arg
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Ungültige p_session in wwv_flow_custom_auth_std.login--p_flow_page:%0 p_session_id:%1.';

wwv_flow_api.create_message (
  p_id=>195851717449152118 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ERR_ILLEGAL_LOGIN_ARG',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_err_invalid_login_arg
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Ungültige p_session in wwv_flow_custom_auth_std.login--p_flow_page:%0 p_session_id:%1.';

wwv_flow_api.create_message (
  p_id=>195851816113152119 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ERR_INVALID_LOGIN_ARG',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_err_malformed_login_args2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Ungültiges Eintrittspunktargument für wwv_flow_custom_auth_std.login--p_flow_page:p_session_id:p_entry_point:%0:%1:%2.  ';

wwv_flow_api.create_message (
  p_id=>195851906756152119 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ERR_MALFORMED_LOGIN_ARGS2',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_err_login_null_user
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Null Benutzername an Anmeldeprozedur übergeben.';

wwv_flow_api.create_message (
  p_id=>195852020096152119 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ERR_LOGIN_NULL_USER',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_err_partner_app_unreg
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Name der registrierten Partneranwendung im Authentifizierungsschema nicht gefunden.';

wwv_flow_api.create_message (
  p_id=>195852108347152119 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ERR_PARTNER_APP_UNREG',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_err_fix_partner_app
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Bearbeiten Sie das Authentifizierungsschema, und fügen Sie den Anwendungsnamen hinzu.';

wwv_flow_api.create_message (
  p_id=>195852201197152119 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ERR_FIX_PARTNER_APP',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_err_wwsec_pkg_missing
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'WWSEC_SSO_ENABLER_PRIVATE-Package ist nicht vorhanden oder ist ungültig.';

wwv_flow_api.create_message (
  p_id=>195852300111152119 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ERR_WWSEC_PKG_MISSING',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_err_fix_wwsec
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Bitten Sie den Administrator, die Engine für Oracle AS Single Sign-On zu konfigurieren.';

wwv_flow_api.create_message (
  p_id=>195852425722152120 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ERR_FIX_WWSEC',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_err_sso_redir
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fehler beim Ausführen von wwv_flow_custom_auth_sso.portal_sso_redirect.';

wwv_flow_api.create_message (
  p_id=>195852500973152120 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ERR_SSO_REDIR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_err_illegal_login_pg_arg
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fehler in der Prozedur p_flow_page argument to login_page.';

wwv_flow_api.create_message (
  p_id=>195852622210152120 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ERR_ILLEGAL_LOGIN_PG_ARG',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_create_home_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erstellen von Homepage nicht möglich. %0';

wwv_flow_api.create_message (
  p_id=>195852703418152120 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.CREATE_HOME_PAGE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_create_list
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erstellen von Liste nicht möglich. %0';

wwv_flow_api.create_message (
  p_id=>195852804018152120 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.CREATE_LIST',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_create_list_item
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erstellen von Listenelement nicht möglich. %0';

wwv_flow_api.create_message (
  p_id=>195852919235152120 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.CREATE_LIST_ITEM',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_create_success_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erstellen von Erfolgsseite nicht möglich. %0';

wwv_flow_api.create_message (
  p_id=>195853002702152120 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.CREATE_SUCCESS_PAGE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_define_default_templates
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Definieren Sie die Standard-Templates zu Erstellen der Anwendung.';

wwv_flow_api.create_message (
  p_id=>195853117514152121 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.DEFINE_DEFAULT_TEMPLATES',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_use_one_level_tab
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Sie können die Anwendung nur mit einer Registerkarte für eine Ebene erstellen.';

wwv_flow_api.create_message (
  p_id=>195853214453152121 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.USE_ONE_LEVEL_TAB',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_create_modules
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erstellen von Modulen nicht möglich. %0';

wwv_flow_api.create_message (
  p_id=>195853317577152121 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.CREATE_MODULES',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_wizard_api_parse_error2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fehler 2 beim Parsen %0';

wwv_flow_api.create_message (
  p_id=>195853408482152121 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WIZARD_API.PARSE_ERROR2',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_wizard_api_parse_error1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fehler beim Parsen: %0';

wwv_flow_api.create_message (
  p_id=>195853515646152121 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WIZARD_API.PARSE_ERROR1',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_wizard_api_create_updateable_report
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erstellen von aktualisierbarem Bericht nicht möglich. %0';

wwv_flow_api.create_message (
  p_id=>195853601237152121 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WIZARD_API.CREATE_UPDATEABLE_REPORT',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_wizard_api_create_form_on_sp
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erstellen von Form basierend auf SP nicht möglich. %0';

wwv_flow_api.create_message (
  p_id=>195853721384152122 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WIZARD_API.CREATE_FORM_ON_SP',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_wizard_api_create_form_on_table
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erstellen von Form basierend auf Tabelle nicht möglich. %0';

wwv_flow_api.create_message (
  p_id=>195853807411152122 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WIZARD_API.CREATE_FORM_ON_TABLE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_wizard_api_create_insert_form
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erstellen von Einfüge-Form nicht möglich. %0';

wwv_flow_api.create_message (
  p_id=>195853918381152122 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WIZARD_API.CREATE_INSERT_FORM',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_wizard_api_create_query_and_update_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erstellen von Abfrage und Aktualisierung der Seite nicht möglich. %0';

wwv_flow_api.create_message (
  p_id=>195854029942152122 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WIZARD_API.CREATE_QUERY_AND_UPDATE_PAGE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_wizard_api_create_chart_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erstellen von Diagrammseite nicht möglich. %0';

wwv_flow_api.create_message (
  p_id=>195854129641152122 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WIZARD_API.CREATE_CHART_PAGE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_wizard_api_invalid_report_type
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Ungültiger Berichtstyp.';

wwv_flow_api.create_message (
  p_id=>195854204037152122 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WIZARD_API.INVALID_REPORT_TYPE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_wizard_api_create_report_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erstellen von Berichtsseite nicht möglich. %0';

wwv_flow_api.create_message (
  p_id=>195854314206152123 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WIZARD_API.CREATE_REPORT_PAGE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_wizard_api_create_calendar_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erstellen von Kalenderseite nicht möglich. %0';

wwv_flow_api.create_message (
  p_id=>195854413717152123 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WIZARD_API.CREATE_CALENDAR_PAGE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_wizard_api_create_form_on_equijoin
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erstellen von Form basierend auf Equi Join nicht möglich. %0';

wwv_flow_api.create_message (
  p_id=>195854531054152123 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WIZARD_API.CREATE_FORM_ON_EQUIJOIN',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_wizard_api_create_wizard
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erstellen von Assistenten zum Erstellen von Assistenten nicht möglich. %0';

wwv_flow_api.create_message (
  p_id=>195854627860152123 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WIZARD_API.CREATE_WIZARD',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_wizard_api_create_tree
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erstellen von Baum nicht möglich. %0';

wwv_flow_api.create_message (
  p_id=>195854719725152123 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WIZARD_API.CREATE_TREE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_wizard_api_create_excel_chart
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erstellen von Excel-Diagramm nicht möglich. %0';

wwv_flow_api.create_message (
  p_id=>195854821721152123 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WIZARD_API.CREATE_EXCEL_CHART',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_wizard_api_create_summary_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erstellen von Zusammenfassungsseite nicht möglich. %0';

wwv_flow_api.create_message (
  p_id=>195854909742152123 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WIZARD_API.CREATE_SUMMARY_PAGE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_wizard_api_create_svg_chart
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erstellen von SVG-Diagrammseite nicht möglich. %0';

wwv_flow_api.create_message (
  p_id=>195855027461152124 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WIZARD_API.CREATE_SVG_CHART',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_wizard_api_updateable_query_exists
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Die aktualisierbare SQL-Abfrage ist bereits vorhanden. Sie können nur eine aktualisierbare SQL-Abfrage pro Seite hinzufügen.';

wwv_flow_api.create_message (
  p_id=>195855132635152124 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WIZARD_API.UPDATEABLE_QUERY_EXISTS',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_login_pg_handling
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Verarbeitung der Anmeldeseite';

wwv_flow_api.create_message (
  p_id=>195855217758152124 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.LOGIN_PG_HANDLING',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_login_pg1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Diese Anwendung (%0) verwendet die Seite %1 als Anmeldeseite.';

wwv_flow_api.create_message (
  p_id=>195855329584152124 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.LOGIN_PG1',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_login_pg2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Wenn die Seite %0 angefordert wird, werden keine weiteren Überprüfungen der Authentifizierung ausgeführt, und die Seite wird angezeigt oder akzeptiert. Dadurch kann die Anmeldeseite vor der Ausführung der Authentifizierung angezeigt werden.';

wwv_flow_api.create_message (
  p_id=>195855401229152124 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.LOGIN_PG2',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_dbauth
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Datenbank-Authentifizierung';

wwv_flow_api.create_message (
  p_id=>195855507573152124 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.DBAUTH',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_dbauth2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Diese Anwendung verwendet die DAD-Konfiguration für die Authentifizierung. Wenn in der DAD-Konfiguration Account-Informationen gespeichert sind, wird die APP_USER-Variable auf den Benutzer gesetzt, der der DAD zugeordnet ist. Wenn das Anwendungsattribut PUBLIC_USER auf den Wert des in der DAD gespeicherten Benutzernamens gesetzt wird, können in Anwendungsbedingungen, Sicherheitsschemaauswertungen ';

h:=h||'und anderer eingebetteter Logik nützliche Vergleiche mit der APP_USER-Variablen und dem PUBLIC_USER-Attribut angestellt werden. Wenn der DAD keine Benutzer-Account-Informationen enthält, muss der Benutzer das Basis-Authentifizierungs-Challenge über ein Dialogfeld übergeben, das vom Browser aufgerufen wird. Nach dieser Authentifizierung setzt die Engine APP_USER auf den Namen, der von diesem Challe';

h:=h||'nge erfasst wurde.';

wwv_flow_api.create_message (
  p_id=>195855623424152125 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.DBAUTH2',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_dbauth3
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Dem Benutzer wird von der Engine keine Anmeldeseite angezeigt.';

wwv_flow_api.create_message (
  p_id=>195855711179152125 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.DBAUTH3',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_page_sentry_function
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Seiten-Sentry-Funktion';

wwv_flow_api.create_message (
  p_id=>195855823712152125 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.PAGE_SENTRY_FUNCTION',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_pg_sentry1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Sie können mit der integrierten Logik Seiten-Sentry-Tasks ausführen. Die Seiten-Sentry-Funktion führt für jeden Seiten-Request eine Sessionverifizierung aus und berechnet den Rückgabewert.';

wwv_flow_api.create_message (
  p_id=>195855901225152125 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.PG_SENTRY1',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_sess_verify_function
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Funktion für die Sessionverifizierung';

wwv_flow_api.create_message (
  p_id=>195856012516152125 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.SESS_VERIFY_FUNCTION',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_chk_cookie1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Überprüfen Sie mit Hilfe der integrierten Logik das Cookie [%0]. Wenn das Cookie vorhanden ist und der decodierte Wert eine Zeile in der Tabelle für interne Sessions ermittelt, gehen Sie davon aus, dass die Session gültig ist.';

wwv_flow_api.create_message (
  p_id=>195856111388152125 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.CHK_COOKIE1',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_sess_verify1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Verwenden Sie zusätzlichen vom Benutzer zur Verfügung gestellten Code, um zu bestimmen, ob die Session gültig ist. Nachdem oben von der integrierten Prüfung für die Sessionverifizierung TRUE zurückgegeben wird, führen Sie folgenden Code aus, und notieren Sie sich den booleschen Rückgabewert:';

wwv_flow_api.create_message (
  p_id=>195856206813152126 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.SESS_VERIFY1',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_compute_return_value
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Rückgabewert berechnen';

wwv_flow_api.create_message (
  p_id=>195856326948152126 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.COMPUTE_RETURN_VALUE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_action1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Die Seiten-Sentry-Funktion gibt das boolesche Ergebnis der integrierten Prüfung für die Sessionverifizierung an die Engine zurück. Wenn das Ergebnis TRUE lautet, wird die Engine die Seite weiterhin anzeigen oder akzeptieren. Wenn das Ergebnis FALSE lautet, führt die Engine eine Umleitung zur Seite für die ungültige Session oder zum URL aus, der in diesem Authentifizierungsschema angegeben ist (sie';

h:=h||'he unten).';

wwv_flow_api.create_message (
  p_id=>195856406733152126 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ACTION1',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_action2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Die Seiten-Sentry-Funktion gibt das boolesche Ergebnis der integrierten Prüfung für die Sessionverifizierung mit einer AND-Kombination des Ergebnisses der vom Benutzer angegebenen Prüfung für die Sessionverifizierung an die Engine zurück. Wenn das Ergebnis TRUE lautet, wird die Engine die Seite weiterhin anzeigen oder akzeptieren. Wenn das Ergebnis FALSE lautet, führt die Engine eine Umleitung zur';

h:=h||' Seite für das ungültige Sessionziel aus, das in diesem Authentifizierungsschema angegeben ist (siehe unten).';

wwv_flow_api.create_message (
  p_id=>195856529608152126 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ACTION2',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_action3
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Verwenden Sie eine benutzerdefinierte Logik, um Seiten-Sentry-Tasks auszuführen. Die Engine führt für jeden Seiten-Request folgenden Code aus:';

wwv_flow_api.create_message (
  p_id=>195856601720152126 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ACTION3',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_action4
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Das boolesche Ergebnis des oben angegebenen Blocks wird an die Engine zurückgegeben. Wenn das Ergebnis TRUE lautet, wird die Engine die Seite weiterhin anzeigen oder akzeptieren. Wenn das Ergebnis FALSE lautet, führt die Engine eine Umleitung zur Seite für das ungültige Sessionziel aus, das in diesem Authentifizierungsschema angegeben ist (siehe unten).';

wwv_flow_api.create_message (
  p_id=>195856727473152126 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ACTION4',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_action5
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Die integrierte Methode für die Sessionverifizierung ist für den %0-Entwickler über den API-Aufruf verfügbar:';

wwv_flow_api.create_message (
  p_id=>195856807070152126 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ACTION5',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_action6
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Das Ergebnis dieser booleschen Funktion kann mit anderen Prüfungen in der vom Benutzer zur Verfügung gestellten Seiten-Sentry-Funktion in einem Authentifizierungsschema kombiniert werden. Beim Aufruf dieser API wird das Cookie %0 geprüft';

wwv_flow_api.create_message (
  p_id=>195856919667152127 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ACTION6',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_action7
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Wenn das Cookie vorhanden ist und der decodierte Wert eine Zeile in der Tabelle der internen Sessions ermittelt, ist die Session gültig, und es wird TRUE an die aufrufende Seiten-Sentry-Funktion zurückgegeben.';

wwv_flow_api.create_message (
  p_id=>195857028839152127 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ACTION7',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_invalid_sess_target
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Ungültiges Sessionziel';

wwv_flow_api.create_message (
  p_id=>195857130190152127 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.INVALID_SESS_TARGET',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_action8
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Wenn die Seiten-Sentry-Funktion TRUE zurückgibt, wird mit der Wiedergabe oder Verarbeitung der Seite fortgefahren. Lautet das Ergebnis jedoch FALSE, ruft die Engine die Seite %0 auf, bei der es sich um die Anmeldeseite der Anwendung handelt, die aufgrund der Position im Authentifizierungsschema die ungültige Sessionseite ist.';

wwv_flow_api.create_message (
  p_id=>195857201578152127 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ACTION8',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_builtin_login_pg
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'die integrierte Anmeldeseite';

wwv_flow_api.create_message (
  p_id=>195857316225152127 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.BUILTIN_LOGIN_PG',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_sso_server
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Oracle Application Server Single Sign-On-Server';

wwv_flow_api.create_message (
  p_id=>195857412240152127 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.SSO_SERVER',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_the_url
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'der URL';

wwv_flow_api.create_message (
  p_id=>195857508880152128 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.THE_URL',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_action9
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Die Seiten-Sentry-Funktion gibt ein boolesches Ergebnis an die Engine zurück. Bei Rückgabe von TRUE wird mit der Wiedergabe oder Verarbeitung der Seite fortgefahren. Wenn das Ergebnis FALSE lautet, erfolgt seitens der Engine eine Umleitung zu %0.';

wwv_flow_api.create_message (
  p_id=>195857611588152128 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ACTION9',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_action10
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Wenn die Seiten-Sentry-Funktion TRUE zurückgibt, wird mit der Wiedergabe oder Verarbeitung der Seite fortgefahren. Wenn das Ergebnis FALSE lautet, muss die Engine beendet werden, weil im Authentifizierungsschema kein ungültiges Sessionziel angegeben ist. In diesem Fall wird die vom Benutzer zur Verfügung gestellte Seiten-Sentry-Funktion an eine Anmeldeseite außerhalb der %0-Umgebung umgeleitet, un';

h:=h||'d zwar möglicherweise zu einem externen Authentifizierungsportal. Bei der Funktion muss außerdem die globale Variable "g_unrecoverable_error := true" festgelegt sein, damit die Engine angewiesen wird, ohne Fehlermeldungsseite beendet zu werden.';

wwv_flow_api.create_message (
  p_id=>195857705996152128 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ACTION10',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_action11
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Die Engine führt folgenden Code aus, der als Prozess vor der Authentifizierung für dieses Authentifizierungsschema angegeben wird:';

wwv_flow_api.create_message (
  p_id=>195857818290152128 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ACTION11',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_action12
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Dies wird als anonymer Block ausgeführt, der keinen Wert zurückgibt.';

wwv_flow_api.create_message (
  p_id=>195857907897152128 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ACTION12',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_action13
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Es ist kein benutzerdefinierter Code für die Ausführung vor der Authentifizierung in diesem Schema angegeben.';

wwv_flow_api.create_message (
  p_id=>195858023812152128 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ACTION13',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_credentials_verification
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ID-Daten-Verifizierung (Authentifizierung)';

wwv_flow_api.create_message (
  p_id=>195858109734152129 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.CREDENTIALS_VERIFICATION',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_action14
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Jede in der Anmelde-Form eingegebene Kombination aus Benutzername/Kennwort ist gültig. Der eingegebene Benutzername wird als Name für den angemeldeten Benutzer während der Dauer der Session verwendet. Diese Technik ist nützlich, wenn Sie Ihre Anwendung entwickeln, bevor tatsächliche Benutzer-Accounts eingerichtet sind.';

wwv_flow_api.create_message (
  p_id=>195858231507152129 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ACTION14',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_action15
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Überprüfen Sie den Benutzernamen und das Kennwort in der Anmelde-Form mit den Angaben für die Cookie User-Accounts von Application Builder. Hierbei handelt es sich um dieselben Accounts, die von Ihrem Workspace für die Anmeldung bei %0 verwendet werden. Diese Technik ist nützlich, wenn die Benutzer Ihrer Anwendung Entwickler sind, die %0 Accounts in derselben Datenbank für denselben Workspace habe';

h:=h||'n.';

wwv_flow_api.create_message (
  p_id=>195858319895152129 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ACTION15',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_action16
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Überprüfen Sie den Benutzernamen und Kennwort in der Anmelde-Form in Bezug auf das LDAP-Verzeichnis, das in diesem Authentifizierungsschema angegeben ist.';

wwv_flow_api.create_message (
  p_id=>195858432598152129 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ACTION16',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_action17
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Die LDAP-Parameter sind folgendermaßen gesetzt:';

wwv_flow_api.create_message (
  p_id=>195858505296152129 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ACTION17',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_ldap_host
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'LDAP-Host:';

wwv_flow_api.create_message (
  p_id=>195858624363152129 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.LDAP_HOST',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_ldap_port
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'LDAP-Port:';

wwv_flow_api.create_message (
  p_id=>195858709279152130 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.LDAP_PORT',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_ldap_dn
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Basis für die LDAP-Suche';

wwv_flow_api.create_message (
  p_id=>195858806985152130 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.LDAP_DN',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_ldap_edit_fn
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Der folgende Block wird für den Aufruf einer Funktion verwendet, bevor DBMS_LDAP.SIMPLE_BIND_S aufgerufen wird. Der in der Anmelde-Form erfasste Benutzername wird an die Funktion übergeben, die einen Wert zurückgibt, der %LDAP_USER% in der LDAP Search Base (siehe oben) ersetzt.';

wwv_flow_api.create_message (
  p_id=>195858926650152130 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.LDAP_EDIT_FN',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_ldap_edit_fn2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Der Codeblock muss diese Signatur haben:';

wwv_flow_api.create_message (
  p_id=>195859012815152130 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.LDAP_EDIT_FN2',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_ldap_edit_fn3
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Mit dieser Funktion können Sie den in der Anmelde-Form eingegebenen Benutzernamen in ein Format für Ihren LDAP-Verzeichniseintrag konvertieren.';

wwv_flow_api.create_message (
  p_id=>195859131211152130 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.LDAP_EDIT_FN3',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_action18
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Führen Sie den folgenden benutzerdefinierten Code aus, um die ID-Daten zu überprüfen:';

wwv_flow_api.create_message (
  p_id=>195859206807152130 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ACTION18',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_post_auth_proc
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Prozess nach der Authentifizierung';

wwv_flow_api.create_message (
  p_id=>195859303613152130 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.POST_AUTH_PROC',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_action19
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Überprüfen Sie, ob in der integrierten Sessiontabelle die Session enthalten ist, die von der integrierten Anmeldeseite verwendet wird. Wenn die Session vorhanden ist und noch keinem anderen Benutzer gehört, legen Sie fest, dass sie jetzt dem berechtigten Benutzer (über den Benutzernamen auf der Anmelde-Form) gehört.';

wwv_flow_api.create_message (
  p_id=>195859402336152131 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ACTION19',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_action20
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Setzen Sie das Cookie %0 auf einen Wert, der die Zeile in der Tabelle für die internen Sessions angibt.';

wwv_flow_api.create_message (
  p_id=>195859519153152131 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ACTION20',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_action22
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Bestimmen Sie, dass der URL beim Klick auf <b>Weiter</b> umgeleitet wird. Wenn ein "Deep Link" im Sessionstatus von der Rendering Engine erfasst wurde, verwenden Sie diesen als Navigations-URL. Navigieren Sie andernfalls zum URL, der als Home-Link-Attribut der Anwendung angegeben ist.';

wwv_flow_api.create_message (
  p_id=>195859600368152131 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ACTION22',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_cust_post_auth_proc
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Benutzerdefinierter Prozess nach der Authentifizierung';

wwv_flow_api.create_message (
  p_id=>195859704855152131 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.CUST_POST_AUTH_PROC',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_action23
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Nach der ID-Daten-Verifizierung führt die Engine folgenden Code aus, der als Prozess nach der Authentifizierung für dieses Authentifizierungsschema angegeben wird:';

wwv_flow_api.create_message (
  p_id=>195859807732152131 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ACTION23',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_action24
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Dies wird als anonymer Block ausgeführt, der keinen Wert zurückgibt.';

wwv_flow_api.create_message (
  p_id=>195859909988152131 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ACTION24',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_action25
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Es ist kein benutzerdefinierter Code für die Ausführung nach der Authentifizierung in diesem Schema angegeben.';

wwv_flow_api.create_message (
  p_id=>195860001163152132 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ACTION25',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_action26
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Führen Sie die Umleitung zum oben angegebenen URL aus. Dadurch wird das Ende der Anmeldungsverarbeitung mit der integrierten Anmeldeseite und den APIs, die diese Seite aufrufen, gekennzeichnet.';

wwv_flow_api.create_message (
  p_id=>195860122982152132 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ACTION26',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_api_common1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'In der Regel enthält die Seite eine Anmelde-Form zum Erfassen der ID-Daten des Benutzers. Anschließend wird nach den Weiterleitungsprozessen für die Seite ein Authentifizierungsmodul zur Überprüfung der ID-Daten aufgerufen. Nach der Authentifizierung führt die Seite Tasks für die Sessionregistrierung und Cookieeinstellung aus. Abschließend erfolgt eine Umleitung zur Startseite der Anwendung.';

wwv_flow_api.create_message (
  p_id=>195860218756152132 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.API_COMMON1',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_api_common2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Die %0-API wwv_flow_custom_auth_std kann von derartigen Prozessen nach der Weiterleitung aufgerufen werden, um die oben beschriebenen Schritte auszuführen. Es stehen zwei Eintrittspunkte zur Verfügung:';

wwv_flow_api.create_message (
  p_id=>195860319248152132 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.API_COMMON2',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_api_common3
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Rufen Sie die Anmeldeprozedur auf, damit die Engine alle Schritte ausführt. Die Engine verwendet die integrierte Sessiontabelle und führt die Task für die Sessionregistrierung und Cookieeinstellung für Sie aus. Wenn Sie benutzerdefinierten Code in dieses Authentifizierungsschema eingeben, wird dieser am Punkt vor der Authentifizierung, während der Authentifizierung oder nach der Authentifizierung ';

h:=h||'ausgeführt.';

wwv_flow_api.create_message (
  p_id=>195860410608152132 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.API_COMMON3',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_api_common4
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Rufen Sie die Prozedur post_login auf, wenn Sie die Authentifizierung selbst ausführen und möchten, dass %0 die Prozesse nach der Authentifizierung für Sie ausführt. Sie können mit diesen beiden Eintrittspunkten beliebige integrierte Schritte für die Anmeldungsverarbeitung in Verbindung mit Ihrer eigenen Anmeldeseite und den Prozessen verwenden, die darauf ausgeführt werden. Wenn Sie die integrier';

h:=h||'ten Prozesse nach der Authentifizierung verwenden, können Sie auch vom Integrierten Seiten-Sentry- und Sessionverifizierungsprozess profitieren.';

wwv_flow_api.create_message (
  p_id=>195860529766152132 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.API_COMMON4',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_chart_login1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Externe Anmeldungsverarbeitung';

wwv_flow_api.create_message (
  p_id=>195860629271152133 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.CHART_LOGIN1',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_chart_login2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Dieses Authentifizierungsschema gibt weder eine Anmeldeseite noch einen URL für das ungültige Sessionziel an. Es wird vorausgesetzt, dass die Seiten-Sentry-Funktion diesen Vorgang ausführt. Möglicherweise erfolgt eine Umleitung zu einem SSO-Portal oder einem anderen Login-Server. Außerdem gibt es im Authentifizierungsschema keine Werte für die Anmeldungsverarbeitung. Wenn dies nicht Ihren Vorstell';

h:=h||'ungen entspricht, bearbeiten Sie dieses Authentifizierungsschema, und geben Sie eine ungültige Sessionseite oder einen URL an. Untersuchen Sie anschließend diese Diagramm-View erneut.';

wwv_flow_api.create_message (
  p_id=>195860707792152133 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.CHART_LOGIN2',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_chart_login3
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Dieses Authentifizierungsschema gibt weder eine Anmeldeseite noch einen URL für das ungültige Sessionziel an. Dabei wird vorausgesetzt, dass die Seiten-Sentry-Funktion diesen Fall verarbeitet. Möglicherweise erfolgt eine Umleitung zu einem SSO-Portal oder einem anderen Login-Server. Es sind jedoch Werte für die Anmeldungsverarbeitung im Authentifizierungsschema festgelegt:';

wwv_flow_api.create_message (
  p_id=>195860823807152133 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.CHART_LOGIN3',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_chart_login4
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Der Anmelde-URL %0 gibt möglicherweise eine %1-Anwendungsseite als ungültiges Sessionziel an. Es befinden sich jedoch im Authentifizierungsschema keine Werte für die Login-Verarbeitung. Auf dieser Seite werden folgende Schritte ausgeführt:';

wwv_flow_api.create_message (
  p_id=>195860930159152133 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.CHART_LOGIN4',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_chart_login6
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Damit die %0-Engine die Anmeldeseite in Ihrer Anwendung anzeigen oder annehmen kann, müssen Sie das Seitenattribut <b>Ja - diese Seite ist öffentlich</b> auf der Seite <b>Seitenattribute</b> in Application Builder angeben. Andernfalls versucht die Engine, die Seiten-Sentry-Funktion vor der Anzeige der Seite auszuführen. Wenn Sie sich noch nicht angemeldet haben, wird eine Umleitung zum gleichen UR';

h:=h||'L ausgeführt. Dadurch entsteht eine störende Schleife. Wenn Sie Ihre eigene Seiten-Sentry-Funktion codieren, müssen Sie gegebenenfalls ermitteln, wann die aktuelle Seite die Anmeldeseite ist und diese anders als andere Seiten behandeln. Wenn die Seite direkt anhand der Seitennummer erkannt werden kann, ist das sicherlich die einfachste Methode. Ein etwas allgemeineres Verfahren bietet die Verwendu';

h:=h||'ng der booleschen Funktion wwv_flow_custom_auth.current_page_is_public, um dieses öffentliche Attribut der Anmeldeseite oder einer anderen Seite in Ihrer Anwendung zu erkennen.';

wwv_flow_api.create_message (
  p_id=>195861001967152133 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.CHART_LOGIN6',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_chart_login7
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Der Anmelde-URL %0 gibt möglicherweise eine %1-Anwendungsseite als ungültiges Sessionziel an. Auf dieser Seite werden folgende Schritte ausgeführt:';

wwv_flow_api.create_message (
  p_id=>195861104467152133 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.CHART_LOGIN7',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_chart_login8
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Die Werte für die Anmeldung im Authentifizierungsschema werden nachstehend angezeigt:';

wwv_flow_api.create_message (
  p_id=>195861211333152134 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.CHART_LOGIN8',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_chart_login9
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Der Oracle Application Server Single Sign-On-Server nimmt nach der Benutzer-Authentifizierung wieder eine Umleitung zurück zu dieser Anwendung vor. Der Eintrittspunkt ist die Prozedur wwv_flow_custom_auth_sso.process_success in dem Schema %0. %0 ist als Oracle Application Server Single Sign-On-Partneranwendung registriert und kann alle Schnittstellen zu dem Login-Server für Sie verwalten. Wenn Sie';

h:=h||' jedoch eine eigene Anwendung in Ihrem eigenen Schema registrieren möchten, ist dies auch möglich. Sie können Ihre eigene Seiten-Sentry-Funktion schreiben oder einfach ein Authentifizierungsschema basierend auf dem Portal-SSO-Schema (meine Anwendung als Partneranwendung) aus der Galerie mit Authentifizierungsschemas erstellen. Das Ergebnisschema ruft die integrierte SSO-Seiten-Sentry-Funktion wwv_';

h:=h||'flow_custom_auth_std.portal_sso_sentry_v1 auf. Diese Funktion erfordert, dass das aktuelle Authentifizierungsschema den Namen der Partneranwendung kennt, wie mit Oracle Application Server Single Sign-On registriert. Der Assistent für das Erstellen des Authentifizierungsschemas fordert Sie zur Angabe des Namens der Partneranwendung auf. Dieser kann jedoch auch hinzugefügt oder durch Bearbeiten des ';

h:=h||'Schemas geändert werden, nachdem dieses erstellt wurde. Der Name muss genau wie registriert eingegeben werden, wobei die Groß-/Kleinschreibung berücksichtigt werden muss. Außerdem müssen Sie Ihre eigene URLC-Empfängerprozedur schreiben und die API wwv_flow_custom_auth_sso.process_success aus dieser Prozedur aufrufen, indem Sie den Namen der Anwendung übergeben, so wie er mit Oracle Application Ser';

h:=h||'ver Single Sign-On registriert wurde. Dadurch wird die Session mit %0 nach der Authentifizierung registriert. Wenn Sie eine eigene Seiten-Sentry-Funktion schreiben, kann die API wwv_flow_custom_auth_sso.portal_sso_redirect von der Seiten-Sentry-Funktion aufgerufen werden, um die Umleitung zu dem Login-Server vorzunehmen, wenn festgestellt wird, dass eine Authentifizierung erforderlich ist. Sie müs';

h:=h||'sen den registrierten Namen der Partneranwendung an diese Prozedur übergeben. Weitere Einzelheiten finden Sie in der %0 Dokumentation und der %1 Dokumentation.';

wwv_flow_api.create_message (
  p_id=>195861323946152134 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.CHART_LOGIN9',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_chart_login12
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Der Anmelde-URL %0 gibt keine %1-Anwendungsseite als ungültiges Sessionziel an. Außerdem befinden sich im Authentifizierungsschema keine Werte für die Login-Verarbeitung. Auf dieser Seite werden folgende Schritte ausgeführt:';

wwv_flow_api.create_message (
  p_id=>195861417460152134 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.CHART_LOGIN12',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_chart_login13
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Wenn die bei diesem URL aufgerufenen Services zur Unterstützung von Sessionregistrierungs-Tasks nicht die %0-API wwv_custom_auth_std verwenden, kann Ihre Anwendung die integrierte Seiten-Sentry- oder Sessionverifizierungsverarbeitung nicht nutzen. Bitte verwenden Sie in diesem Fall ein eigenes, geeignetes Verfahren.';

wwv_flow_api.create_message (
  p_id=>195861506864152134 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.CHART_LOGIN13',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_chart_pre_auth_proc
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Prozess vor der Authentifizierung';

wwv_flow_api.create_message (
  p_id=>195861602944152134 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.CHART_PRE_AUTH_PROC',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_chart_post_auth_proc
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Prozess nach der Authentifizierung';

wwv_flow_api.create_message (
  p_id=>195861729683152134 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.CHART_POST_AUTH_PROC',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_chart_login14
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Der Anmelde-URL %0 gibt keine %1-Anwendungsseite als ungültiges Sessionziel an. Auf dieser Seite werden folgende Schritte ausgeführt:';

wwv_flow_api.create_message (
  p_id=>195861821021152134 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.CHART_LOGIN14',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_chart_login15
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Die Werte für die Anmeldung im Authentifizierungsschema werden nachstehend angezeigt:';

wwv_flow_api.create_message (
  p_id=>195861919622152135 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.CHART_LOGIN15',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_chart_login16
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Bei der in diesem Schema angegebenen Anmeldeseite handelt es sich um die Seite [%0] in dieser Anwendung. Diese Seite ist für die Ausführung folgender Schritte zuständig:';

wwv_flow_api.create_message (
  p_id=>195862022384152135 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.CHART_LOGIN16',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_chart_login17
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Es befinden sich im Authentifizierungsschema keine Werte für die Anmeldungsverarbeitung.';

wwv_flow_api.create_message (
  p_id=>195862114228152135 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.CHART_LOGIN17',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_chart_login18
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Da es sich bei dieser Seite um die Anmeldeseite für die Anwendung handelt, können bestimmte Aktionen nicht auf der Seite ausgeführt werden, wenn die Seite zuerst angezeigt wird, weil die Benutzerauthentifizierung noch nicht ausgeführt wurde. Außerdem können bestimmte Sessionstatus- und Session-ID-Variablen nicht für Seitenberechnungen oder Prozesse verwendet werden, weil diese sich auf konventione';

h:=h||'llen Seiten befinden, die nach der Authentifizierung verarbeitet werden. Deshalb ist die Spezifikation einer Anmeldeseite nach Seitennummer in einem Authentifizierungsschema nur für Seiten geeignet, die keine Funktionalität aufweisen bzw. lediglich die Verarbeitung der Anmelde-Form ausführen. Wenn Sie eine aktivere Anmeldeseite verwenden möchten, verwenden Sie die Anmelde-URL-Angabe im Assistenten';

h:=h||' für das Authentifizierungsschema, oder bearbeiten Sie die Seite. Wenn Sie mittels der Seitenattribut-Form mit dem Builder das öffentliche Seitenattribut auf "Ja - Diese Seite ist öffentlich" setzen, kann die Anmeldeseite alle %0-Funktionen verwenden und außerdem als Anmeldeseite in Ihrer Anwendung eingesetzt werden.';

wwv_flow_api.create_message (
  p_id=>195862205605152135 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.CHART_LOGIN18',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p817_refresh_auth_scheme_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fehler beim Aktualisieren von Authentifizierungsschemas.';

wwv_flow_api.create_message (
  p_id=>195862316248152135 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P817_REFRESH_AUTH_SCHEME_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p826_create1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Single Sign-On (nur Oracle)';

wwv_flow_api.create_message (
  p_id=>195862431968152135 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P826_CREATE1',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p826_create2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Oracle Application Server Single Sign-On (%0 als Partneranwendung)';

wwv_flow_api.create_message (
  p_id=>195862513568152136 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P826_CREATE2',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p826_create3
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Oracle Application Server Single Sign-On (Meine Anwendung als Partneranwendung)';

wwv_flow_api.create_message (
  p_id=>195862611629152136 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P826_CREATE3',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p826_create4
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Integrierte Anmeldeseite: %0-Account-ID-Daten verwenden';

wwv_flow_api.create_message (
  p_id=>195862720039152136 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P826_CREATE4',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p826_create5
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Integrierte Anmeldeseite: Open Door-ID-Daten';

wwv_flow_api.create_message (
  p_id=>195862829301152136 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P826_CREATE5',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p826_create6
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Integrierte Anmeldeseite: LDAP-Verzeichnis-ID-Daten verwenden';

wwv_flow_api.create_message (
  p_id=>195862926125152136 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P826_CREATE6',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p826_create7
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Basiert auf dem Authentifizierungsschema der Galerie';

wwv_flow_api.create_message (
  p_id=>195863028526152136 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P826_CREATE7',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_util_obj_not_found_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 (%1) für den Kopiervorgang nicht gefunden';

wwv_flow_api.create_message (
  p_id=>195863124561152137 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_UTIL.OBJ_NOT_FOUND_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_provisioning_cannot_find_sgid
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Bestimmen der Sicherheitsgruppen-ID für die angegebene Workspace-ID = "%0" nicht möglich'||chr(10)||
'';

wwv_flow_api.create_message (
  p_id=>195863228855152137 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PROVISIONING.CANNOT_FIND_SGID',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_provisioning_remove_last_schema
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Sie können mit dieser Funktion nicht das letzte Schema eines Workspace entfernen';

wwv_flow_api.create_message (
  p_id=>195863329783152137 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PROVISIONING.REMOVE_LAST_SCHEMA',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_provisioning_reset_password_reserved_schema
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Zurücksetzen von Kennwort für Schema %0 nicht möglich';

wwv_flow_api.create_message (
  p_id=>195863430498152137 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PROVISIONING.RESET_PASSWORD_RESERVED_SCHEMA',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_provisioning_reset_password_not_in_schema
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Es ist nicht zulässig, das Kennwort für ein Schema zurückzusetzen, das nicht Ihrem Workspace zugeordnet ist. %0';

wwv_flow_api.create_message (
  p_id=>195863514794152137 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PROVISIONING.RESET_PASSWORD_NOT_IN_SCHEMA',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_provisioning_reset_password_not_in_company
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Der Benutzername %0 ist in Workspace %1 nicht vorhanden';

wwv_flow_api.create_message (
  p_id=>195863605213152137 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PROVISIONING.RESET_PASSWORD_NOT_IN_COMPANY',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message no_page_dev_priv
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Der Entwickler hat keine Berechtigungen zu Erstellen von Komponenten auf dieser Seite.';

wwv_flow_api.create_message (
  p_id=>195863731474152137 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'NO_PAGE_DEV_PRIV',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message no_layout
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Kein Berichtslayout ausgewählt';

wwv_flow_api.create_message (
  p_id=>195863802099152138 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'NO_LAYOUT',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message auth_unknown_workspace
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unbekannter Workspace-Name';

wwv_flow_api.create_message (
  p_id=>195863906008152138 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'AUTH_UNKNOWN_WORKSPACE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_web_services_wsdl_unhandled
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Das WSDL-Dokument wurde von der Rendering Engine nicht verstanden. Klicken Sie auf <b>Web Service-Referenz manuell erstellen</b>, um mit dem Erstellvorgang für eine Referenz für diesen Service fortzufahren.';

wwv_flow_api.create_message (
  p_id=>195864022238152138 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WEB_SERVICES.WSDL_UNHANDLED',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_flows_api_last_extended
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'API zuletzt erweitert:';

wwv_flow_api.create_message (
  p_id=>195864109070152138 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.FLOWS_API_LAST_EXTENDED',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_current_flows_version
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Ihre Aktuelle Version:';

wwv_flow_api.create_message (
  p_id=>195864222244152138 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.CURRENT_FLOWS_VERSION',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_import_compatible_with_version
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Der Import ist kompatibel zu Version:';

wwv_flow_api.create_message (
  p_id=>195864301044152139 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.IMPORT_COMPATIBLE_WITH_VERSION',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_missing_export_version
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Ihr Anwendungsimport hat keine Exportversion angegeben.';

wwv_flow_api.create_message (
  p_id=>195864402356152139 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.MISSING_EXPORT_VERSION',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_unkown_engine_version
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Die Version Ihrer Engine konnte nicht eingerichtet werden.';

wwv_flow_api.create_message (
  p_id=>195864514865152139 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.UNKOWN_ENGINE_VERSION',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_unkown_api_version
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Die letzte API-Version Ihrer Engine konnte nicht eingerichtet werden.';

wwv_flow_api.create_message (
  p_id=>195864600126152139 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.UNKOWN_API_VERSION',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_upgrade_needed
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Sie müssen ein Upgrade ausführen, um diesen Anwendungsexport importieren zu können.';

wwv_flow_api.create_message (
  p_id=>195864712414152139 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.UPGRADE_NEEDED',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_invalid_credentials
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Ungültige Kombination aus Benutzername, Kennwort oder Workspace';

wwv_flow_api.create_message (
  p_id=>195864815603152139 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.INVALID_CREDENTIALS',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_user_not_admin
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Der Benutzer %0 benötigt ADMIN-Berechtigungen für die Ausführung dieses Vorgangs.';

wwv_flow_api.create_message (
  p_id=>195864905456152139 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.USER_NOT_ADMIN',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_sgid_not_set_import
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Package-Variable g_security_group_id muss für den Import einer Anwendung festgelegt werden.';

wwv_flow_api.create_message (
  p_id=>195865016381152140 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.SGID_NOT_SET_IMPORT',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_flow_id_missing
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Die Prozedur %0 wurde ohne Wert für p_id aufgerufen. Es muss eine Anwendungs-ID angegeben werden.';

wwv_flow_api.create_message (
  p_id=>195865117153152140 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.FLOW_ID_MISSING',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_flow_not_deleted
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Die Anwendung %0 wurde nicht gelöscht. Der Import wird nicht eingeleitet.';

wwv_flow_api.create_message (
  p_id=>195865218315152140 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.FLOW_NOT_DELETED',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_templ_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fehler beim Erstellen von Template-Name=%0';

wwv_flow_api.create_message (
  p_id=>195865327791152140 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_TEMPL_CREATE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_build_option_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fehler beim Erstellen des Namens für Erstelloption=%0';

wwv_flow_api.create_message (
  p_id=>195865411004152140 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_BUILD_OPTION_CREATE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_build_option_set
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fehler beim Einrichten von Erstelloptions-ID="%0"';

wwv_flow_api.create_message (
  p_id=>195865523593152140 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_BUILD_OPTION_SET',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_nav_bar_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fehler beim Erstellen von Navigationsleisten-ID="%0"';

wwv_flow_api.create_message (
  p_id=>195865619418152141 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_NAV_BAR_CREATE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_nav_bar_item_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fehler beim Erstellen von Navigationsleisten-Element-ID="%0"';

wwv_flow_api.create_message (
  p_id=>195865731259152141 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_NAV_BAR_ITEM_CREATE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_flow_process_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fehler beim Erstellen von Anwendungsprozess-ID="%0"';

wwv_flow_api.create_message (
  p_id=>195865800734152141 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_FLOW_PROCESS_CREATE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_process_sql_set
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fehler beim Einrichten von Prozess-SQL-ID="%0"';

wwv_flow_api.create_message (
  p_id=>195865919680152141 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_PROCESS_SQL_SET',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_flow_item_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fehler beim Erstellen von Anwendungselement-ID="%0"';

wwv_flow_api.create_message (
  p_id=>195866030197152141 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_FLOW_ITEM_CREATE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_flow_computation_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fehler beim Erstellen von Anwendungsberechnungselement="%0"';

wwv_flow_api.create_message (
  p_id=>195866101124152141 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_FLOW_COMPUTATION_CREATE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_std_tab_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fehler beim Erstellen von Standardregisterkarten-ID="%0"';

wwv_flow_api.create_message (
  p_id=>195866226174152142 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_STD_TAB_CREATE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_tabset_rename
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fehler beim Umbenennen von Registerkartengruppe %1 in %0';

wwv_flow_api.create_message (
  p_id=>195866314799152142 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_TABSET_RENAME',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_parent_tab_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fehler beim Erstellen von übergeordneter Registerkarten-ID="%0"';

wwv_flow_api.create_message (
  p_id=>195866421816152142 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_PARENT_TAB_CREATE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_lov_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fehler beim Erstellen von Wertelisten-ID="%0"';

wwv_flow_api.create_message (
  p_id=>195866510879152142 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_LOV_CREATE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_page_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fehler beim Erstellen von Seitenname="%0" id="%1"';

wwv_flow_api.create_message (
  p_id=>195866628313152142 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_PAGE_CREATE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_page_help_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fehler beim Erstellen von Seite %0 für den Hilfetext:';

wwv_flow_api.create_message (
  p_id=>195866710228152142 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_PAGE_HELP_CREATE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_page_name_upd
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fehler beim Aktualisieren von Seitenname="%0" id="%1"';

wwv_flow_api.create_message (
  p_id=>195866800140152143 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_PAGE_NAME_UPD',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_button_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fehler beim Erstellen von Schaltflächenname="%0" id="%1"';

wwv_flow_api.create_message (
  p_id=>195866904059152143 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_BUTTON_CREATE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_branch_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fehler beim Erstellen von Verzweigungs-ID="%0"';

wwv_flow_api.create_message (
  p_id=>195867001594152143 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_BRANCH_CREATE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_branch_args_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fehler beim Erstellen von Verzweigungsargument-ID="%0"';

wwv_flow_api.create_message (
  p_id=>195867111904152143 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_BRANCH_ARGS_CREATE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_page_item_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fehlermeldungsseite=%0 Element="%1" id="%2"';

wwv_flow_api.create_message (
  p_id=>195867228920152143 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_PAGE_ITEM_CREATE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_page_computation_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fehler beim Erstellen von Seite für die Seitenberechnung=%0 item=%1 id="%2"';

wwv_flow_api.create_message (
  p_id=>195867317219152143 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_PAGE_COMPUTATION_CREATE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_page_validation_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fehler beim Erstellen von Seite für die Seitenvalidierung=%0 name=%1';

wwv_flow_api.create_message (
  p_id=>195867400615152143 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_PAGE_VALIDATION_CREATE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_page_process_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fehler beim Erstellen von Seite für den Seitenprozess=%0 name=%1';

wwv_flow_api.create_message (
  p_id=>195867518931152144 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_PAGE_PROCESS_CREATE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_lang_map_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fehler beim Erstellen von Anwendungs-Übersetzungszuordnung';

wwv_flow_api.create_message (
  p_id=>195867615979152144 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_LANG_MAP_CREATE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_page_on_table_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erstellen von Seite auf Tabelle "%0" nicht möglich';

wwv_flow_api.create_message (
  p_id=>195867732021152144 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_PAGE_ON_TABLE_CREATE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_invalid_report_type
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Ungültiger Berichtstyp';

wwv_flow_api.create_message (
  p_id=>195867819914152144 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_INVALID_REPORT_TYPE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_report_page_exists
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Berichtsseite %0 ist vorhanden, die Berichtsregion wurde hinzugefügt.';

wwv_flow_api.create_message (
  p_id=>195867903194152144 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_REPORT_PAGE_EXISTS',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_page_has_buttons
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Die Seite %0 hat bereits Schaltflächen.';

wwv_flow_api.create_message (
  p_id=>195868010952152145 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_PAGE_HAS_BUTTONS',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_form_added_to_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Der vorhandenen Seite %0 wurde eine Form hinzugefügt.';

wwv_flow_api.create_message (
  p_id=>195868104289152145 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_FORM_ADDED_TO_PAGE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_report_page_exists2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Die Seite %0 wurde nicht erstellt, weil sie bereits vorhanden ist.';

wwv_flow_api.create_message (
  p_id=>195868212066152145 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_REPORT_PAGE_EXISTS2',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_bug_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fehler beim Erstellen von Bug-ID="%0"';

wwv_flow_api.create_message (
  p_id=>195868310121152145 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_BUG_CREATE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_shortcut_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fehler beim Erstellen von Shortcut-ID="%0"';

wwv_flow_api.create_message (
  p_id=>195868410034152145 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_SHORTCUT_CREATE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_auth_scheme_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fehler beim Erstellen von Name für das Authentifizierungsschema=%0';

wwv_flow_api.create_message (
  p_id=>195868511652152145 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_AUTH_SCHEME_CREATE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_sgid_not_set
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Die Package-Variable g_security_group_id muss festgelegt werden.';

wwv_flow_api.create_message (
  p_id=>195868630762152146 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.SGID_NOT_SET',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_flow_id_reserved
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Die Anwendungs-ID %0 ist für die Oracle Corporation reserviert ';

wwv_flow_api.create_message (
  p_id=>195868702740152146 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.FLOW_ID_RESERVED',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_flows_api_runtime_incompatible
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'API-Vorgang enthält Aufrufe, die mit der aktuellen Runtime-Version nicht kompatibel sind.';

wwv_flow_api.create_message (
  p_id=>195868816282152146 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.FLOWS_API_RUNTIME_INCOMPATIBLE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_compatible
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'COMPATIBLE (Dieser Import wird in der Regel ohne Probleme ausgeführt.)';

wwv_flow_api.create_message (
  p_id=>195868919046152146 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.COMPATIBLE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_not_compatible
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'NICHT KOMPATIBEL (Ihr Export enthält möglicherweise Aufrufe, die von Ihrer %0-Version nicht unterstützt werden.)';

wwv_flow_api.create_message (
  p_id=>195869010442152146 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.NOT_COMPATIBLE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_inline_plus_notification
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Inline+Benachrichtigung';

wwv_flow_api.create_message (
  p_id=>195869105075152146 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_INLINE_PLUS_NOTIFICATION',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_inline
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Inline';

wwv_flow_api.create_message (
  p_id=>195869206280152146 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_INLINE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_notification
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Benachrichtigung';

wwv_flow_api.create_message (
  p_id=>195869322898152147 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_NOTIFICATION',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_error_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fehlermeldungsseite';

wwv_flow_api.create_message (
  p_id=>195869421116152147 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ERROR_PAGE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_location
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Position';

wwv_flow_api.create_message (
  p_id=>195869503159152147 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_LOCATION',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_button_above_box
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Über dem Feld';

wwv_flow_api.create_message (
  p_id=>195869627430152147 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.BUTTON.ABOVE_BOX',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_button_below_box
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unter dem Feld';

wwv_flow_api.create_message (
  p_id=>195869707734152147 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.BUTTON.BELOW_BOX',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_button_bottom
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unten';

wwv_flow_api.create_message (
  p_id=>195869818434152147 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.BUTTON.BOTTOM',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_button_region_template_change
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Template ändern';

wwv_flow_api.create_message (
  p_id=>195869928646152148 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.BUTTON.REGION_TEMPLATE_CHANGE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_button_region_template_close
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Template schließen';

wwv_flow_api.create_message (
  p_id=>195870011154152148 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.BUTTON.REGION_TEMPLATE_CLOSE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_button_region_template_copy
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Template kopieren';

wwv_flow_api.create_message (
  p_id=>195870117274152148 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.BUTTON.REGION_TEMPLATE_COPY',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_button_region_template_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Template erstellen';

wwv_flow_api.create_message (
  p_id=>195870225926152148 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.BUTTON.REGION_TEMPLATE_CREATE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_button_region_template_delete
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Template löschen';

wwv_flow_api.create_message (
  p_id=>195870314398152148 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.BUTTON.REGION_TEMPLATE_DELETE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_button_region_template_edit
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Template bearbeiten';

wwv_flow_api.create_message (
  p_id=>195870417765152148 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.BUTTON.REGION_TEMPLATE_EDIT',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_button_region_template_expand
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Template erweitern';

wwv_flow_api.create_message (
  p_id=>195870503140152149 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.BUTTON.REGION_TEMPLATE_EXPAND',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_button_region_template_next
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Nächstes Template';

wwv_flow_api.create_message (
  p_id=>195870631633152149 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.BUTTON.REGION_TEMPLATE_NEXT',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_button_region_template_previous
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Vorheriges Template';

wwv_flow_api.create_message (
  p_id=>195870710824152149 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.BUTTON.REGION_TEMPLATE_PREVIOUS',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_button_top
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Oben';

wwv_flow_api.create_message (
  p_id=>195870806783152149 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.BUTTON.TOP',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_branch_to_page_accept
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Verzweigung zu PAGE ACCEPT';

wwv_flow_api.create_message (
  p_id=>195870915372152149 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_BRANCH_TO_PAGE_ACCEPT',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_branch_to_page_identified_by_item
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Verzweigung zu Seite, angegeben von Element';

wwv_flow_api.create_message (
  p_id=>195871011760152149 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_BRANCH_TO_PAGE_IDENTIFIED_BY_ITEM',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_branch_to_url_identified_by_item
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Verzweigung zu URL, angegeben von Element';

wwv_flow_api.create_message (
  p_id=>195871124699152149 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_BRANCH_TO_URL_IDENTIFIED_BY_ITEM',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_branch_to_function_returning_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Verzweigung zu Funktion, die eine Seite zurückgibt';

wwv_flow_api.create_message (
  p_id=>195871212310152150 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_BRANCH_TO_FUNCTION_RETURNING_PAGE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_branch_to_function_returning_url
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Verzweigung zu Funktion, die einen URL zurückgibt';

wwv_flow_api.create_message (
  p_id=>195871304668152150 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_BRANCH_TO_FUNCTION_RETURNING_URL',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_branch_to_plsql
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Verzweigung zu PL/SQL-Prozedur';

wwv_flow_api.create_message (
  p_id=>195871418916152150 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_BRANCH_TO_PLSQL',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_none
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Kein Eintrag';

wwv_flow_api.create_message (
  p_id=>195871503700152150 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_NONE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_unconditional
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Ohne Bedingung';

wwv_flow_api.create_message (
  p_id=>195871613823152150 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_UNCONDITIONAL',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_standard_condition
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Standardbedingung';

wwv_flow_api.create_message (
  p_id=>195871729931152150 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_STANDARD_CONDITION',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_never
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Niemals';

wwv_flow_api.create_message (
  p_id=>195871826697152151 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_NEVER',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p4656_default_calendar_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Standard-Kalender-Template';

wwv_flow_api.create_message (
  p_id=>195871914804152151 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000.P4656.DEFAULT_CALENDAR_TEMPLATE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_calendar
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Kalender';

wwv_flow_api.create_message (
  p_id=>195872021563152151 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000.CALENDAR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_generate_ddl_no_ddl
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 zum Generieren von DDL nicht gefunden.';

wwv_flow_api.create_message (
  p_id=>195872109947152151 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_GENERATE_DDL.NO_DDL',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_edit_report_err_updating_cols
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fehler beim Aktualisieren von Berichtspalten: %0';

wwv_flow_api.create_message (
  p_id=>195872225224152151 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_EDIT_REPORT.ERR_UPDATING_COLS',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message auth_unknown_workspace_colon
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unbekannter Workspace-Name: %0';

wwv_flow_api.create_message (
  p_id=>195872325689152151 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'AUTH_UNKNOWN_WORKSPACE_COLON',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_svg_migrate_svg_to_flash_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fehler beim Migrieren von SVG-Diagramm zu Flash-Diagramm. %0';

wwv_flow_api.create_message (
  p_id=>195872427333152152 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SVG.MIGRATE_SVG_TO_FLASH_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_migrate_svg_to_flash
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Sie haben das Migrieren eines SVG-Diagramms zu einem Flash-Diagramm angefordert. Bestätigen Sie diesen Request.';

wwv_flow_api.create_message (
  p_id=>195872509393152152 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.MIGRATE_SVG_TO_FLASH',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_imp_parser_run_stmt_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Die Ausführung der Anweisung war nicht erfolgreich. %0<pre>%1</pre>';

wwv_flow_api.create_message (
  p_id=>195872626625152152 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_IMP_PARSER.RUN_STMT_ERROR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_imp_parser_get_stmt
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'GET_STMT-Fehler. %0';

wwv_flow_api.create_message (
  p_id=>195872725408152152 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_IMP_PARSER.GET_STMT',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_imp_parser_get_block
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'GET_BLOCK-Fehler. %0';

wwv_flow_api.create_message (
  p_id=>195872812186152152 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_IMP_PARSER.GET_BLOCK',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_imp_parser_no_file_found
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Datei nicht gefunden. %0';

wwv_flow_api.create_message (
  p_id=>195872901395152152 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_IMP_PARSER.NO_FILE_FOUND',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message item_name_date_picker
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Datumsauswahl';

wwv_flow_api.create_message (
  p_id=>195873016307152152 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ITEM_NAME.DATE_PICKER',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message item_name_hidden
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Ausgeblendet';

wwv_flow_api.create_message (
  p_id=>195873124537152153 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ITEM_NAME.HIDDEN',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message item_name_file_browse
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Datei durchsuchen';

wwv_flow_api.create_message (
  p_id=>195873222282152153 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ITEM_NAME.FILE_BROWSE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message item_name_stop_and_start_html_table
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Stoppen und Tabelle starten';

wwv_flow_api.create_message (
  p_id=>195873331303152153 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ITEM_NAME.STOP_AND_START_HTML_TABLE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message item_name_list_manager
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Listen-Manager';

wwv_flow_api.create_message (
  p_id=>195873400558152153 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ITEM_NAME.LIST_MANAGER',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message item_name_check_box
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Kontrollkästchen';

wwv_flow_api.create_message (
  p_id=>195873515724152153 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ITEM_NAME.CHECK_BOX',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message item_name_display_only
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Nur anzeigen';

wwv_flow_api.create_message (
  p_id=>195873612862152153 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ITEM_NAME.DISPLAY_ONLY',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message item_name_multiple_select
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Mehrfachauswahl';

wwv_flow_api.create_message (
  p_id=>195873718794152154 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ITEM_NAME.MULTIPLE_SELECT',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message item_name_popup_list_of_values
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Popup-Werteliste';

wwv_flow_api.create_message (
  p_id=>195873822458152154 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ITEM_NAME.POPUP_LIST_OF_VALUES',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message item_name_radio
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Option';

wwv_flow_api.create_message (
  p_id=>195873924652152154 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ITEM_NAME.RADIO',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message item_name_select_list
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Auswahlliste';

wwv_flow_api.create_message (
  p_id=>195874028683152154 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ITEM_NAME.SELECT_LIST',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message item_name_text
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Text';

wwv_flow_api.create_message (
  p_id=>195874124687152154 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ITEM_NAME.TEXT',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message item_name_text_area
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Textbereich';

wwv_flow_api.create_message (
  p_id=>195874201737152155 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ITEM_NAME.TEXT_AREA',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message item_name_shuttle
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Shuttle';

wwv_flow_api.create_message (
  p_id=>195874304666152155 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ITEM_NAME.SHUTTLE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message copy_list_entry
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Listeneintrag kopieren';

wwv_flow_api.create_message (
  p_id=>195874427638152155 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'COPY_LIST_ENTRY',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_imp_parser_no_priv
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Sie verfügen nicht über ausreichende Berechtigungen für das %0-Schema.';

wwv_flow_api.create_message (
  p_id=>195874522970152155 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_IMP_PARSER.NO_PRIV',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message no_images_found
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Keine Bilder gefunden';

wwv_flow_api.create_message (
  p_id=>195874624218152155 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'NO_IMAGES_FOUND',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_fnd_user_api_check_sgid
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unberechtigter Zugriff (Package-Variable für die Sicherheitsgruppe kein festgelegt).';

wwv_flow_api.create_message (
  p_id=>195874732764152155 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FND_USER_API.CHECK_SGID',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_fnd_user_api_create_user_group
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Die Benutzergruppe konnte nicht erstellt werden, weil sie bereits vorhanden ist.';

wwv_flow_api.create_message (
  p_id=>195874814215152155 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FND_USER_API.CREATE_USER_GROUP',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_fnd_user_api_create_company
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Der Workspace konnte nicht erstellt werden, weil dieser bereits vorhanden ist.';

wwv_flow_api.create_message (
  p_id=>195874904412152156 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FND_USER_API.CREATE_COMPANY',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_fnd_user_api_create_fnd_user
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Der Benutzer kann aus folgendem Grund nicht erstellt werden: %0';

wwv_flow_api.create_message (
  p_id=>195875018991152156 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FND_USER_API.CREATE_FND_USER',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_fnd_user_api_no_user_exist
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Benutzer %0 ist nicht vorhanden.';

wwv_flow_api.create_message (
  p_id=>195875103134152156 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FND_USER_API.NO_USER_EXIST',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_fnd_user_api_no_email
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Der Benutzer %0 hat keine E-Mail-Adresse angegeben.';

wwv_flow_api.create_message (
  p_id=>195875218899152156 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FND_USER_API.NO_EMAIL',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_fnd_user_api_fetch_fnd_user
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Abrufen von FND-Benutzerinformationen nicht möglich. %0';

wwv_flow_api.create_message (
  p_id=>195875309328152156 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FND_USER_API.FETCH_FND_USER',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_notification_msg_checksum_format_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Benachrichtigung zu Fehler bei Format von Prüfsumme (Checksum): %0';

wwv_flow_api.create_message (
  p_id=>195875406002152156 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.NOTIFICATION_MSG_CHECKSUM_FORMAT_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_notification_msg_checksum_content_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Benachrichtigung zu Fehler bei Inhalt von Prüfsumme (Checksum): %0 : %1';

wwv_flow_api.create_message (
  p_id=>195875529609152157 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.NOTIFICATION_MSG_CHECKSUM_CONTENT_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_print_success_msg_checksum_format_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fehler beim Drucken des Formats einer Prüfsumme (Checksum) für eine Prozesserfolgsmeldung: %0';

wwv_flow_api.create_message (
  p_id=>195875600324152157 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.PRINT_SUCCESS_MSG_CHECKSUM_FORMAT_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_print_success_msg_checksum_content_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fehler beim Drucken des Inhalts einer Prüfsumme (Checksum) für eine Prozesserfolgsmeldung: %0 : %1';

wwv_flow_api.create_message (
  p_id=>195875731127152157 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.PRINT_SUCCESS_MSG_CHECKSUM_CONTENT_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_flow_created_success
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Die %0-Demoanwendung wurde erstellt.';

wwv_flow_api.create_message (
  p_id=>195875816035152157 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_FLOW.CREATED_SUCCESS',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_flow_created_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Es steht nicht genügend Speicherplatz zum Erstellen dieser Demo zur Verfügung. Fordern Sie zusätzliche Speicherkapazität an, indem Sie zur Seite für die Administration navigieren und anschließend auf "Änderungen beim aktuellen Service anfordern" klicken.';

wwv_flow_api.create_message (
  p_id=>195875932322152157 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_FLOW.CREATED_ERROR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4150_column_number
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Spalte %0';

wwv_flow_api.create_message (
  p_id=>195876025516152157 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4150_COLUMN_NUMBER',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message cached
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Gecacht';

wwv_flow_api.create_message (
  p_id=>195876110800152158 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CACHED',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message valid
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Gültig';

wwv_flow_api.create_message (
  p_id=>195876213829152158 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'VALID',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message expired
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Abgelaufen';

wwv_flow_api.create_message (
  p_id=>195876314853152158 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'EXPIRED',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_enabled
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Aktiviert';

wwv_flow_api.create_message (
  p_id=>195876418570152158 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_ENABLED',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_highlight_type
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Markierungstyp';

wwv_flow_api.create_message (
  p_id=>195876527834152158 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_HIGHLIGHT_TYPE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_cell
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Zelle';

wwv_flow_api.create_message (
  p_id=>195876607625152158 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_CELL',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_bgcolor
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Hintergrundfarbe';

wwv_flow_api.create_message (
  p_id=>195876731425152159 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_BGCOLOR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_yellow
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'gelb';

wwv_flow_api.create_message (
  p_id=>195876822939152159 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_YELLOW',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_green
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'grün';

wwv_flow_api.create_message (
  p_id=>195876922957152159 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_GREEN',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_orange
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'orange';

wwv_flow_api.create_message (
  p_id=>195877020539152159 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_ORANGE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_text_color
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Textfarbe';

wwv_flow_api.create_message (
  p_id=>195877106966152159 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_TEXT_COLOR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_highlight_when
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Markieren wenn';

wwv_flow_api.create_message (
  p_id=>195877205541152159 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_HIGHLIGHT_WHEN',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_comparison_like
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'wie';

wwv_flow_api.create_message (
  p_id=>195877310166152159 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_COMPARISON_LIKE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_comparison_not_like
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'nicht wie';

wwv_flow_api.create_message (
  p_id=>195877408747152160 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_COMPARISON_NOT_LIKE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_comparison_is_null
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ist Null';

wwv_flow_api.create_message (
  p_id=>195877515214152160 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_COMPARISON_IS_NULL',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_comparison_is_not_null
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ist nicht Null';

wwv_flow_api.create_message (
  p_id=>195877616767152160 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_COMPARISON_IS_NOT_NULL',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_comparison_in
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'in';

wwv_flow_api.create_message (
  p_id=>195877715155152160 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_COMPARISON_IN',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_comparison_not_in
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'nicht in';

wwv_flow_api.create_message (
  p_id=>195877824478152160 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_COMPARISON_NOT_IN',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_save
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Speichern';

wwv_flow_api.create_message (
  p_id=>195877930809152160 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_SAVE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_ascending
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Aufsteigend';

wwv_flow_api.create_message (
  p_id=>195878029541152161 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_ASCENDING',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_descending
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Absteigend';

wwv_flow_api.create_message (
  p_id=>195878109455152161 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_DESCENDING',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_select_category
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'- Kategorie wählen -';

wwv_flow_api.create_message (
  p_id=>195878220662152161 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_SELECT_CATEGORY',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Name';

wwv_flow_api.create_message (
  p_id=>195878322700152161 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_NAME',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_sequence
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Sequence';

wwv_flow_api.create_message (
  p_id=>195878409338152161 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_SEQUENCE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_yes
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Ja';

wwv_flow_api.create_message (
  p_id=>195878527679152161 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_YES',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_no
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Nein';

wwv_flow_api.create_message (
  p_id=>195878621215152162 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_NO',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_row
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Zeile';

wwv_flow_api.create_message (
  p_id=>195878727387152162 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_ROW',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_blue
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'blau';

wwv_flow_api.create_message (
  p_id=>195878829854152162 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_BLUE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_red
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'rot';

wwv_flow_api.create_message (
  p_id=>195878916284152162 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_RED',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_displayed
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Angezeigt';

wwv_flow_api.create_message (
  p_id=>195879021052152162 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_DISPLAYED',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_other
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Weitere';

wwv_flow_api.create_message (
  p_id=>195879120757152162 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_OTHER',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_value
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Wert';

wwv_flow_api.create_message (
  p_id=>195879203187152163 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_VALUE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_column
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Spalte';

wwv_flow_api.create_message (
  p_id=>195879327235152163 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_COLUMN',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_cancel
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Abbrechen';

wwv_flow_api.create_message (
  p_id=>195879412113152163 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_CANCEL',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_delete
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Löschen';

wwv_flow_api.create_message (
  p_id=>195879513472152163 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_DELETE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_select_column
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'- Spalte wählen -';

wwv_flow_api.create_message (
  p_id=>195879618858152163 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_SELECT_COLUMN',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message installer_upgrade_message
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Das Anwendungsinstallationsprogramm hat ermittelt, dass die unterstützenden Objekte dieser Anwendung zuvor installiert wurden. Dieser Assistent unterstützt Sie beim Upgrade dieser unterstützenden Objekte.';

wwv_flow_api.create_message (
  p_id=>195879710058152163 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTALLER.UPGRADE_MESSAGE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message caching
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Caching';

wwv_flow_api.create_message (
  p_id=>195879823793152163 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CACHING',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p4045_branch
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Verzweigung=';

wwv_flow_api.create_message (
  p_id=>195879924822152164 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000.P4045.BRANCH=',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p4045_menu_option
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Navigationspfadeintrag=';

wwv_flow_api.create_message (
  p_id=>195880008595152164 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000.P4045.MENU_OPTION=',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message installer_upgrade_success_message
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Die unterstützenden Objekte dieser Anwendung wurden installiert.';

wwv_flow_api.create_message (
  p_id=>195880112293152164 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTALLER.UPGRADE_SUCCESS_MESSAGE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message installer_upgrade_failure_message
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Das Upgrade der unterstützenden Objekte dieser Anwendung wurde nicht erfolgreich ausgeführt.';

wwv_flow_api.create_message (
  p_id=>195880217002152164 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTALLER.UPGRADE_FAILURE_MESSAGE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message installer_upgrade_confirm_message
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Bestätigen Sie, dass Sie bei den unterstützenden Objekten dieser Anwendung ein Upgrade ausführen möchten.';

wwv_flow_api.create_message (
  p_id=>195880332319152164 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTALLER.UPGRADE_CONFIRM_MESSAGE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message yes_by_user
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Ja, pro Benutzer';

wwv_flow_api.create_message (
  p_id=>195880426085152164 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'YES_BY_USER',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message set_binds
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Beim Testen einer Abfrage müssen Werte für alle Bind-Variablen festgelegt werden.';

wwv_flow_api.create_message (
  p_id=>195880509049152165 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SET_BINDS',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p826_create6a
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Neu erstellte Anmeldeseite: LDAP-Verzeichnis-ID-Daten verwenden';

wwv_flow_api.create_message (
  p_id=>195880611760152165 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P826_CREATE6A',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p826_create6b
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Vorhandene Anmeldeseite: LDAP-Verzeichnis-ID-Daten verwenden';

wwv_flow_api.create_message (
  p_id=>195880710703152165 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P826_CREATE6B',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p826_create4a
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Neu erstellte Anmeldeseite: %0-Account-ID-Daten verwenden';

wwv_flow_api.create_message (
  p_id=>195880822474152165 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P826_CREATE4A',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p826_create4b
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Vorhandene Anmeldeseite: %0-Account-ID-Daten verwenden';

wwv_flow_api.create_message (
  p_id=>195880907838152165 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P826_CREATE4B',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_flash_chart_flash_chart_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Flash-Diagrammfehler: %0';

wwv_flow_api.create_message (
  p_id=>195881025415152165 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FLASH_CHART.FLASH_CHART_ERROR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message report_queries_valid_query
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Abfrage ist gültig. Bind-Variablen wurden geparst.';

wwv_flow_api.create_message (
  p_id=>195881126561152166 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'REPORT_QUERIES.VALID_QUERY',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_no_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Keine Seite ausgewählt.';

wwv_flow_api.create_message (
  p_id=>195881213614152166 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_NO_PAGE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Seite';

wwv_flow_api.create_message (
  p_id=>195881309851152166 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_PAGE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_create_button
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erstellen';

wwv_flow_api.create_message (
  p_id=>195881404789152166 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_CREATE_BUTTON',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_edit_button
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Bearbeiten';

wwv_flow_api.create_message (
  p_id=>195881510709152166 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_EDIT_BUTTON',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_copy_button
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Kopieren';

wwv_flow_api.create_message (
  p_id=>195881611337152166 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_COPY_BUTTON',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_view_button
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Anzeigen';

wwv_flow_api.create_message (
  p_id=>195881715070152167 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_VIEW_BUTTON',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_page_not_found
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Seite nicht gefunden.';

wwv_flow_api.create_message (
  p_id=>195881817447152167 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_PAGE_NOT_FOUND',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_page_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Name';

wwv_flow_api.create_message (
  p_id=>195881926504152167 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_PAGE_NAME',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_page_title
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Überschrift';

wwv_flow_api.create_message (
  p_id=>195882024939152167 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_PAGE_TITLE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_page_alias
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Aliasname';

wwv_flow_api.create_message (
  p_id=>195882112858152167 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_PAGE_ALIAS',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_page_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Template';

wwv_flow_api.create_message (
  p_id=>195882200674152167 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_PAGE_TEMPLATE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_invalid_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Ungültiges Template';

wwv_flow_api.create_message (
  p_id=>195882300882152168 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_INVALID_TEMPLATE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_page_tabset
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Standard-Registerkartengruppe';

wwv_flow_api.create_message (
  p_id=>195882429448152168 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_PAGE_TABSET',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_page_authorization
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Autorisierung';

wwv_flow_api.create_message (
  p_id=>195882514341152168 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_PAGE_AUTHORIZATION',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_page_build_option
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erstelloption';

wwv_flow_api.create_message (
  p_id=>195882621485152168 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_PAGE_BUILD_OPTION',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_page_authentication
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Authentifizierung';

wwv_flow_api.create_message (
  p_id=>195882731204152168 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_PAGE_AUTHENTICATION',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_page_public
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Öffentlich';

wwv_flow_api.create_message (
  p_id=>195882810244152168 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_PAGE_PUBLIC',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_page_required
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erforderlich';

wwv_flow_api.create_message (
  p_id=>195882902673152169 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_PAGE_REQUIRED',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_region
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Regionen';

wwv_flow_api.create_message (
  p_id=>195883018557152169 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_REGION',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_display_pt
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Anzeigepunkt:&nbsp;';

wwv_flow_api.create_message (
  p_id=>195883105313152169 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_DISPLAY_PT',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_no_region
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Seite "%0" hat keine Regionen.';

wwv_flow_api.create_message (
  p_id=>195883213375152169 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_NO_REGION',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_button
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Schaltflächen';

wwv_flow_api.create_message (
  p_id=>195883321353152169 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_BUTTON',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_item
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Elemente';

wwv_flow_api.create_message (
  p_id=>195883412193152169 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ITEM',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_computation
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Berechnungen';

wwv_flow_api.create_message (
  p_id=>195883508349152170 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_COMPUTATION',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_computation_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Die Seite 0 unterstützt keine Berechnungen. Berechnungen, die auf jeder Seite auftreten sollen, müssen von Berechnungen auf Anwendungsebene verarbeitet werden.';

wwv_flow_api.create_message (
  p_id=>195883616228152170 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_COMPUTATION_ERROR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_process_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Die Seite 0 unterstützt keine Prozesse. Prozesse, die auf jeder Seite auftreten sollen, müssen von Prozessen auf Anwendungsebene verarbeitet werden.';

wwv_flow_api.create_message (
  p_id=>195883714543152170 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_PROCESS_ERROR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_no_onload_computation
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Die Seite "%0" hat keine onLoad-Berechnungen.';

wwv_flow_api.create_message (
  p_id=>195883815342152170 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_NO_ONLOAD_COMPUTATION',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_process
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Prozesse';

wwv_flow_api.create_message (
  p_id=>195883924341152170 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_PROCESS',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_no_onload_process
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Die Seite "%0" hat keine onLoad-Prozesse.';

wwv_flow_api.create_message (
  p_id=>195884006639152170 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_NO_ONLOAD_PROCESS',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_page_zero_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Die Seite 0 unterstützt keine Verzweigungen, Berechnungen, Prozesse und Validierungen. Berechnungen und Prozesse, die auf jeder Seite auftreten sollen, müssen von Berechnungen und Prozessen auf Anwendungsebene verarbeitet werden.';

wwv_flow_api.create_message (
  p_id=>195884132757152170 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_PAGE_ZERO_ERROR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_no_onsubmit_computation
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Die Seite "%0" hat keine onSubmit-Berechnungen.';

wwv_flow_api.create_message (
  p_id=>195884209197152171 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_NO_ONSUBMIT_COMPUTATION',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_validation
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Validierungen';

wwv_flow_api.create_message (
  p_id=>195884312910152171 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_VALIDATION',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_no_validation
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Seite "%0" hat keine Validierungen.';

wwv_flow_api.create_message (
  p_id=>195884419581152171 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_NO_VALIDATION',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_no_onsubmit_process
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Die Seite "%0" hat keine onSubmit-Prozesse.';

wwv_flow_api.create_message (
  p_id=>195884524666152171 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_NO_ONSUBMIT_PROCESS',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_branching
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Verzweigung';

wwv_flow_api.create_message (
  p_id=>195884602820152171 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_BRANCHING',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_no_branching
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Seite "%0" hat keine Verzweigungen.';

wwv_flow_api.create_message (
  p_id=>195884715986152171 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_NO_BRANCHING',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_parent_tab
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Übergeordnete Registerkarten';

wwv_flow_api.create_message (
  p_id=>195884827992152172 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_PARENT_TAB',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_no_parent_tab
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Keine Registerkarten der übergeordneten Ebene';

wwv_flow_api.create_message (
  p_id=>195884924998152172 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_NO_PARENT_TAB',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_std_tab
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Standardregisterkarten';

wwv_flow_api.create_message (
  p_id=>195885016034152172 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_STD_TAB',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_tab_set
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Registerkartengruppe';

wwv_flow_api.create_message (
  p_id=>195885131366152172 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_TAB_SET',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_no_tab_set
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Für die Seite %0 ist keine Registerkarte festgelegt.';

wwv_flow_api.create_message (
  p_id=>195885226690152172 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_NO_TAB_SET',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_nav_bar
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Navigationsleiste';

wwv_flow_api.create_message (
  p_id=>195885324807152172 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_NAV_BAR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_no_nav_bar
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Die Anwendung "%0" hat keine Navigationsleiste.';

wwv_flow_api.create_message (
  p_id=>195885405039152173 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_NO_NAV_BAR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message region_templates_no_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Kein Template';

wwv_flow_api.create_message (
  p_id=>195885528944152173 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'REGION_TEMPLATES_NO_TEMPLATE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_flow_no_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Keine Seite ausgewählt.';

wwv_flow_api.create_message (
  p_id=>195885609346152173 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_FLOW_NO_PAGE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_flow_no_region
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Keine Regionen';

wwv_flow_api.create_message (
  p_id=>195885706414152173 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_FLOW_NO_REGION',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_flow_no_computation
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Keine Berechnungen';

wwv_flow_api.create_message (
  p_id=>195885828723152173 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_FLOW_NO_COMPUTATION',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_flow_no_process
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Keine Prozesse';

wwv_flow_api.create_message (
  p_id=>195885910248152173 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_FLOW_NO_PROCESS',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_flow_no_validation
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Keine Validierungen';

wwv_flow_api.create_message (
  p_id=>195886013613152173 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_FLOW_NO_VALIDATION',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_flow_no_branching
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Keine Verzweigungen';

wwv_flow_api.create_message (
  p_id=>195886119109152174 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_FLOW_NO_BRANCHING',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_warning
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Warnung';

wwv_flow_api.create_message (
  p_id=>195886219781152174 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_WARNING',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_region
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Region erstellen';

wwv_flow_api.create_message (
  p_id=>195886328381152174 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_REGION',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_process
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Prozess erstellen';

wwv_flow_api.create_message (
  p_id=>195886432695152174 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_PROCESS',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_computation
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Berechnung erstellen';

wwv_flow_api.create_message (
  p_id=>195886524275152174 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_COMPUTATION',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_validation
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Validierung erstellen';

wwv_flow_api.create_message (
  p_id=>195886615670152175 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_VALIDATION',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_branch
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Verzweigung erstellen';

wwv_flow_api.create_message (
  p_id=>195886703466152175 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_BRANCH',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_title_create_region
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Region erstellen';

wwv_flow_api.create_message (
  p_id=>195886801210152175 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_TITLE_CREATE_REGION',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_title_create_computation
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Berechnung erstellen';

wwv_flow_api.create_message (
  p_id=>195886908594152175 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_TITLE_CREATE_COMPUTATION',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_title_create_process
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Prozess erstellen';

wwv_flow_api.create_message (
  p_id=>195887016895152175 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_TITLE_CREATE_PROCESS',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_title_create_validation
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Validierung erstellen';

wwv_flow_api.create_message (
  p_id=>195887104345152175 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_TITLE_CREATE_VALIDATION',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_title_create_branch
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Verzweigung erstellen';

wwv_flow_api.create_message (
  p_id=>195887214085152175 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_TITLE_CREATE_BRANCH',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message password_changed
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Ihr Kennwort für %0 wurde geändert.';

wwv_flow_api.create_message (
  p_id=>195887328462152176 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PASSWORD_CHANGED',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message email_not_found
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'E-Mail-Adresse "%0" wurde nicht gefunden.';

wwv_flow_api.create_message (
  p_id=>195887432744152176 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'EMAIL_NOT_FOUND',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message change_pw_request
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0-Request';

wwv_flow_api.create_message (
  p_id=>195887512440152176 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CHANGE_PW_REQUEST',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_arrow_down
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Inaktiv';

wwv_flow_api.create_message (
  p_id=>195887603304152176 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_ARROW_DOWN',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_button
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erstellen, Schaltfläche';

wwv_flow_api.create_message (
  p_id=>195887728930152176 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_BUTTON',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_item
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Element erstellen';

wwv_flow_api.create_message (
  p_id=>195887806267152176 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_ITEM',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_title_region
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Regionsüberschrift';

wwv_flow_api.create_message (
  p_id=>195887902361152177 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_TITLE_REGION',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_title_create_button
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erstellen, Schaltfläche';

wwv_flow_api.create_message (
  p_id=>195888014270152177 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_TITLE_CREATE_BUTTON',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_title_edit_button
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Bearbeiten, Schaltfläche';

wwv_flow_api.create_message (
  p_id=>195888117774152177 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_TITLE_EDIT_BUTTON',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_title_create_item
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Element erstellen';

wwv_flow_api.create_message (
  p_id=>195888214760152177 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_TITLE_CREATE_ITEM',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_title_edit_button_item
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Schaltflächenelement bearbeiten';

wwv_flow_api.create_message (
  p_id=>195888310544152177 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_TITLE_EDIT_BUTTON_ITEM',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_title_edit_item
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Element bearbeiten';

wwv_flow_api.create_message (
  p_id=>195888411708152177 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_TITLE_EDIT_ITEM',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_no_priv_on_schema
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Der Workspace %0 hat keine Berechtigungen zum Parsen als Schema %1.';

wwv_flow_api.create_message (
  p_id=>195888512061152178 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.NO_PRIV_ON_SCHEMA',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_button_w_no_region
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Schaltflächen ohne Regionen';

wwv_flow_api.create_message (
  p_id=>195888611578152178 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_BUTTON_W_NO_REGION',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_no_button
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Seite "%0" hat keine Schaltflächen.';

wwv_flow_api.create_message (
  p_id=>195888710663152178 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_NO_BUTTON',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_no_item
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Seite "%0" hat keine Elemente.';

wwv_flow_api.create_message (
  p_id=>195888829178152178 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_NO_ITEM',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_item_exceeds_max
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Elementanzahl überschreitet das Maximum von 100.';

wwv_flow_api.create_message (
  p_id=>195888910101152178 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ITEM_EXCEEDS_MAX',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_region_title
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Regionsüberschrift';

wwv_flow_api.create_message (
  p_id=>195889029817152178 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_REGION_TITLE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_edit
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Bearbeiten';

wwv_flow_api.create_message (
  p_id=>195889120804152179 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_EDIT',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message password_reset_notification
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Benachrichtigung über Zurücksetzen des Kennworts';

wwv_flow_api.create_message (
  p_id=>195889218111152179 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PASSWORD_RESET_NOTIFICATION',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_expand
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Anzeigen';

wwv_flow_api.create_message (
  p_id=>195889328767152179 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_EXPAND',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message account_has_been_created
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Ihr %0-Account wurde erstellt.';

wwv_flow_api.create_message (
  p_id=>195889415393152179 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCOUNT_HAS_BEEN_CREATED',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message new_account_login_instructions
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Sie können sich bei %0 anmelden über:';

wwv_flow_api.create_message (
  p_id=>195889531743152179 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'NEW_ACCOUNT_LOGIN_INSTRUCTIONS',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erstellen';

wwv_flow_api.create_message (
  p_id=>195889613842152179 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_CREATE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message new_account_notification
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Benachrichtigung über neuen %0-Account';

wwv_flow_api.create_message (
  p_id=>195889700313152180 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'NEW_ACCOUNT_NOTIFICATION',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_create2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erstellen';

wwv_flow_api.create_message (
  p_id=>195889813443152180 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_CREATE2',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_close
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Schließen';

wwv_flow_api.create_message (
  p_id=>195889917469152180 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_CLOSE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_region_body
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Regions-Body';

wwv_flow_api.create_message (
  p_id=>195890007294152180 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_REGION_BODY',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_form_open
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Form öffnen';

wwv_flow_api.create_message (
  p_id=>195890127416152180 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_FORM_OPEN',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_form_close
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Form schließen';

wwv_flow_api.create_message (
  p_id=>195890206650152180 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_FORM_CLOSE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_help
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Hilfe';

wwv_flow_api.create_message (
  p_id=>195890310546152180 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_HELP',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_delete
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Löschen';

wwv_flow_api.create_message (
  p_id=>195890408740152181 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_DELETE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_copy
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Kopieren';

wwv_flow_api.create_message (
  p_id=>195890504162152181 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_COPY',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_next
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Weiter';

wwv_flow_api.create_message (
  p_id=>195890631121152181 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_NEXT',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_previous
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Zurück';

wwv_flow_api.create_message (
  p_id=>195890711893152181 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_PREVIOUS',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_change
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Ändern';

wwv_flow_api.create_message (
  p_id=>195890819975152181 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_CHANGE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Template';

wwv_flow_api.create_message (
  p_id=>195890919179152181 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_TEMPLATE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message themes
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Themes';

wwv_flow_api.create_message (
  p_id=>195891032242152182 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'THEMES',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_nav_bar
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Navigationsleiste';

wwv_flow_api.create_message (
  p_id=>195891112516152182 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_NAV_BAR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_notification
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Benachrichtigung';

wwv_flow_api.create_message (
  p_id=>195891208084152182 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_NOTIFICATION',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_global_notification
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Globale Benachrichtigung';

wwv_flow_api.create_message (
  p_id=>195891324368152182 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_GLOBAL_NOTIFICATION',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_template_body
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Template-Body';

wwv_flow_api.create_message (
  p_id=>195891420625152182 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_TEMPLATE_BODY',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_success_msg
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erfolgsmeldung';

wwv_flow_api.create_message (
  p_id=>195891527835152182 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_SUCCESS_MSG',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_title
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Überschrift';

wwv_flow_api.create_message (
  p_id=>195891623153152183 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_TITLE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_body_title
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Body-Überschrift';

wwv_flow_api.create_message (
  p_id=>195891721586152183 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_BODY_TITLE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_region_position
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Region Position';

wwv_flow_api.create_message (
  p_id=>195891823322152183 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_REGION_POSITION',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_std_tab
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Registerkarten';

wwv_flow_api.create_message (
  p_id=>195891928912152183 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_STD_TAB',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_parent_tab
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Übergeordnete Registerkarten';

wwv_flow_api.create_message (
  p_id=>195892028807152183 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_PARENT_TAB',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_application_tab
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Anwendungsregisterkarten';

wwv_flow_api.create_message (
  p_id=>195892104404152183 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_APPLICATION_TAB',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_company_img
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Workspace-Bilder';

wwv_flow_api.create_message (
  p_id=>195892229977152184 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_COMPANY_IMG',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_yes
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Ja';

wwv_flow_api.create_message (
  p_id=>195892331697152184 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_YES',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_no
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Nein';

wwv_flow_api.create_message (
  p_id=>195892413906152184 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_NO',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_header_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Header-Template';

wwv_flow_api.create_message (
  p_id=>195892522551152184 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_HEADER_TEMPLATE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_body
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Body';

wwv_flow_api.create_message (
  p_id=>195892618921152184 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_BODY',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_footer_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Footer-Template';

wwv_flow_api.create_message (
  p_id=>195892731969152184 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_FOOTER_TEMPLATE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_substitution
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Ersetzung';

wwv_flow_api.create_message (
  p_id=>195892819816152184 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_SUBSTITUTION',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_referenced
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Referenziert';

wwv_flow_api.create_message (
  p_id=>195892932148152185 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_REFERENCED',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_from
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Von';

wwv_flow_api.create_message (
  p_id=>195893000735152185 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_FROM',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_description
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Beschreibung';

wwv_flow_api.create_message (
  p_id=>195893114319152185 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_DESCRIPTION',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_page_onload
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Seite Onload';

wwv_flow_api.create_message (
  p_id=>195893229000152185 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_PAGE_ONLOAD',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_page_title2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Seitenüberschrift';

wwv_flow_api.create_message (
  p_id=>195893330426152185 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_PAGE_TITLE2',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_page_head
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Seiten-Header';

wwv_flow_api.create_message (
  p_id=>195893400438152186 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_PAGE_HEAD',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_form_open
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'HTML-Form öffnen';

wwv_flow_api.create_message (
  p_id=>195893517784152186 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_FORM_OPEN',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_notification_msg
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Benachrichtigung';

wwv_flow_api.create_message (
  p_id=>195893604710152186 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_NOTIFICATION_MSG',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_success_msg
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erfolgsmeldung';

wwv_flow_api.create_message (
  p_id=>195893706953152186 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_SUCCESS_MSG',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_page_body
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Seiten-Body';

wwv_flow_api.create_message (
  p_id=>195893814142152186 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_PAGE_BODY',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_page_body_title
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Seiten-Body-Überschrift';

wwv_flow_api.create_message (
  p_id=>195893927711152186 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_PAGE_BODY_TITLE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_form_close
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'HTML-Form schließen';

wwv_flow_api.create_message (
  p_id=>195894027507152187 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_FORM_CLOSE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_region_pos1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Region Position1';

wwv_flow_api.create_message (
  p_id=>195894113455152187 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_REGION_POS1',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_region_pos2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Region Position2';

wwv_flow_api.create_message (
  p_id=>195894225153152187 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_REGION_POS2',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_region_pos3
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Region Position3';

wwv_flow_api.create_message (
  p_id=>195894304139152187 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_REGION_POS3',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_region_pos4
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Region Position4';

wwv_flow_api.create_message (
  p_id=>195894431985152187 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_REGION_POS4',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_region_pos5
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Region Position5';

wwv_flow_api.create_message (
  p_id=>195894515330152187 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_REGION_POS5',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_region_pos6
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Region Position6';

wwv_flow_api.create_message (
  p_id=>195894617078152188 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_REGION_POS6',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_region_pos7
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Region Position7';

wwv_flow_api.create_message (
  p_id=>195894712897152188 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_REGION_POS7',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_region_pos8
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Region Position8';

wwv_flow_api.create_message (
  p_id=>195894806904152188 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_REGION_POS8',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message quick_app_detail_view
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Detailansicht';

wwv_flow_api.create_message (
  p_id=>195894923551152188 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'QUICK_APP_DETAIL_VIEW',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_action
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Aktion';

wwv_flow_api.create_message (
  p_id=>195895003369152188 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ACTION',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_condition
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Bedingung';

wwv_flow_api.create_message (
  p_id=>195895116034152188 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_CONDITION',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_exp
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Exp';

wwv_flow_api.create_message (
  p_id=>195895231042152188 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_EXP',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_display
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Anzeige';

wwv_flow_api.create_message (
  p_id=>195895306209152189 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_DISPLAY',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_button2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Schaltfläche';

wwv_flow_api.create_message (
  p_id=>195895410858152189 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_BUTTON2',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_branch_to_pg
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Gehe zu Seite';

wwv_flow_api.create_message (
  p_id=>195895508678152189 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_BRANCH_TO_PG',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_redirect_to_pg
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Gehe zu Seite';

wwv_flow_api.create_message (
  p_id=>195895624958152189 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_REDIRECT_TO_PG',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_navigate_to_pg
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Navigiert zur Seite';

wwv_flow_api.create_message (
  p_id=>195895712868152189 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_NAVIGATE_TO_PG',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message views2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Ansichten';

wwv_flow_api.create_message (
  p_id=>195895803957152189 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'VIEWS2',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_validation2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Validierung';

wwv_flow_api.create_message (
  p_id=>195895926170152190 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_VALIDATION2',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_process2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Prozess';

wwv_flow_api.create_message (
  p_id=>195896032722152190 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_PROCESS2',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_computation2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Berechnung';

wwv_flow_api.create_message (
  p_id=>195896110971152190 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_COMPUTATION2',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message quick_app_chart_by
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Diagramm pro %0';

wwv_flow_api.create_message (
  p_id=>195896214753152190 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'QUICK_APP_CHART_BY',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message quick_app_by
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Pro %0';

wwv_flow_api.create_message (
  p_id=>195896320439152190 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'QUICK_APP_BY',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_region2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Region';

wwv_flow_api.create_message (
  p_id=>195896429106152190 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_REGION2',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message theme
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Theme';

wwv_flow_api.create_message (
  p_id=>195896531311152191 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'THEME',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_flow
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Anwendung';

wwv_flow_api.create_message (
  p_id=>195896606925152191 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_FLOW',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_paren_deprecated
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'(verworfen)';

wwv_flow_api.create_message (
  p_id=>195896714212152191 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_PAREN_DEPRECATED',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_scheme_convert
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Die %0-Authentifizierung ist eine verworfene Methode. Klicken Sie in einem der Authentifizierungsschemas dieser Anwendung auf <b>Als aktuelles Element festlegen</b> (siehe oben), oder erstellen Sie ein neues Authentifizierungsschema, das Sie anschließend als aktuelles Schema festlegen. Das INTERNAL-SETUP-Authentifizierungsschema entspricht der %0-Methode.';

wwv_flow_api.create_message (
  p_id=>195896800736152191 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_SCHEME_CONVERT',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_edit_deprecated1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Verworfene Authentifizierungsattribute bearbeiten';

wwv_flow_api.create_message (
  p_id=>195896923515152191 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_EDIT_DEPRECATED1',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_edit_deprecated2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Verworfene Attribute';

wwv_flow_api.create_message (
  p_id=>195897000840152191 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_EDIT_DEPRECATED2',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_edit_deprecated3
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'oder belassen Sie diese, bis Sie als Authentifizierungsmethode %0 festlegen können.';

wwv_flow_api.create_message (
  p_id=>195897107725152192 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_EDIT_DEPRECATED3',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_review5
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Überprüfen oder bearbeiten Sie die Attribute für die Sessionverwaltung'||chr(10)||
'';

wwv_flow_api.create_message (
  p_id=>195897217604152192 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_REVIEW5',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_scheme_desc
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Verwendet Authentifizierungsschemas zur Steuerung der Benutzerauthentifizierung und allen anderen Aspekten der Sessionverwaltung für Ihre Anwendung.';

wwv_flow_api.create_message (
  p_id=>195897318533152192 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_SCHEME_DESC',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_edit_deprecated4
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Gibt verworfene Authentifizierungsattribute an.';

wwv_flow_api.create_message (
  p_id=>195897420544152192 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_EDIT_DEPRECATED4',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_review6
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Diese Elemente überprüfen oder bearbeiten';

wwv_flow_api.create_message (
  p_id=>195897513765152192 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_REVIEW6',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_edit_deprecated5
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'oder migrieren Sie diese zu einem Authentifizierungsschema.';

wwv_flow_api.create_message (
  p_id=>195897627630152192 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_EDIT_DEPRECATED5',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message month
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Monat';

wwv_flow_api.create_message (
  p_id=>195897731869152193 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'MONTH',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p13_version
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Version';

wwv_flow_api.create_message (
  p_id=>195897829549152193 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P13_VERSION',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p13_dbname
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Datenbankname';

wwv_flow_api.create_message (
  p_id=>195897923385152193 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P13_DBNAME',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p13_linked
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Verknüpft';

wwv_flow_api.create_message (
  p_id=>195898008169152193 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P13_LINKED',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_as_app_on_exist_table
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Als Anwendung auf einer Datenbanktabelle';

wwv_flow_api.create_message (
  p_id=>195898109627152193 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_AS_APP_ON_EXIST_TABLE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message flash_chart_show_xml
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'XML anzeigen';

wwv_flow_api.create_message (
  p_id=>195898205950152193 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'FLASH_CHART.SHOW_XML',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_report3_err_determine_query_headings
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Bestimmen der Abfrageüberschriften nicht möglich: %0';

wwv_flow_api.create_message (
  p_id=>195898315989152194 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_REPORT3.ERR_DETERMINE_QUERY_HEADINGS',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_report3_err_determine_pagination
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fehler beim Bestimmen der Zeichenfolge für die Seitennummerierung';

wwv_flow_api.create_message (
  p_id=>195898410563152194 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_REPORT3.ERR_DETERMINE_PAGINATION',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_report3_err_report_footer
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fehler beim Ausführen von Berichts-Footer-Ersetzungen';

wwv_flow_api.create_message (
  p_id=>195898504757152194 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_REPORT3.ERR_REPORT_FOOTER',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_report3_err_proc_function_body
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Verarbeiten von Funktions-Body nicht möglich, der Abfrage zurückgibt: %0';

wwv_flow_api.create_message (
  p_id=>195898628868152194 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_REPORT3.ERR_PROC_FUNCTION_BODY',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_report3_failed_parsing_query
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Parsen von SQL-Abfrage nicht erfolgreich: %0 %1';

wwv_flow_api.create_message (
  p_id=>195898712732152194 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_REPORT3.FAILED_PARSING_QUERY',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_report3_report_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Berichtsfehler: %0';

wwv_flow_api.create_message (
  p_id=>195898810714152194 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_REPORT3.REPORT_ERROR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_invalid_lov_query
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Die Abfrage der Popup-Werteliste ist ungültig. Es muss ein Anzeigewert und Rückgabewert angegeben werden. Außerdem müssen die Spaltennamen unterschiedlich sein.';

wwv_flow_api.create_message (
  p_id=>195898900864152194 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.INVALID_LOV_QUERY',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_new_category
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'- Neue Kategorie -';

wwv_flow_api.create_message (
  p_id=>195899002461152195 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_NEW_CATEGORY',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_no_edit
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'(Kann nicht bearbeitet werden)';

wwv_flow_api.create_message (
  p_id=>195899124770152195 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_NO_EDIT',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_current
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Aktuell';

wwv_flow_api.create_message (
  p_id=>195899219304152195 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_CURRENT',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_wizard_api_create_flash_chart
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erstellen von Flash-Diagramm nicht möglich. %0';

wwv_flow_api.create_message (
  p_id=>195899329704152195 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WIZARD_API.CREATE_FLASH_CHART',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p2_invalid
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Ungültig';

wwv_flow_api.create_message (
  p_id=>195899403619152195 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P2_INVALID',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p2_included
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Einbezogen';

wwv_flow_api.create_message (
  p_id=>195899526413152195 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P2_INCLUDED',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p2_databases
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Datenbanken';

wwv_flow_api.create_message (
  p_id=>195899604177152196 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P2_DATABASES',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p802_lov_no_scheme
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'- Kein Schema -';

wwv_flow_api.create_message (
  p_id=>195899732497152196 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P802_LOV_NO_SCHEME',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message initcap_refresh
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Aktualisieren (Refresh)';

wwv_flow_api.create_message (
  p_id=>195899827606152196 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INITCAP_REFRESH',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message y
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Y';

wwv_flow_api.create_message (
  p_id=>195899901293152196 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'Y',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_schema_not_exists
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Das Parsing-Schema "%0" der Anwendung ist nicht in der Datenbank vorhanden.';

wwv_flow_api.create_message (
  p_id=>195900012973152196 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.SCHEMA_NOT_EXISTS',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_flash_chart_open
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Öffnen:';

wwv_flow_api.create_message (
  p_id=>195900112879152196 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FLASH_CHART.OPEN',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p4790_date_timestamp_note
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'(mit Spalte für das Datum oder den Timestamp)';

wwv_flow_api.create_message (
  p_id=>195900219463152197 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P4790_DATE_TIMESTAMP_NOTE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message instadmin_bipub_option
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Die Druckunterstützung muss entweder STANDARD oder ERWEITERT sein';

wwv_flow_api.create_message (
  p_id=>195900327768152197 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTADMIN_BIPUB_OPTION',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message instadmin_first_schema
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Das erste bereitgestellte Schema kann nicht entfernt werden';

wwv_flow_api.create_message (
  p_id=>195900415761152197 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTADMIN_FIRST_SCHEMA',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message instadmin_invalid_port
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Ungültige Port-Nummer';

wwv_flow_api.create_message (
  p_id=>195900529924152197 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTADMIN_INVALID_PORT',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message instadmin_invalid_wallet
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Der Wallet-Pfad muss in der Form-Datei sein:<filesystempath>';

wwv_flow_api.create_message (
  p_id=>195900614023152197 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTADMIN_INVALID_WALLET',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message instadmin_parm_notfound
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Instanzparameter nicht gefunden';

wwv_flow_api.create_message (
  p_id=>195900725706152197 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTADMIN_PARM_NOTFOUND',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p806_builtin_login_pg
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Integrierte Anmeldeseite';

wwv_flow_api.create_message (
  p_id=>195900819619152198 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P806_BUILTIN_LOGIN_PG',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p806_page_in_this_flow
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Seite in dieser Anwendung';

wwv_flow_api.create_message (
  p_id=>195900922009152198 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P806_PAGE_IN_THIS_FLOW',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p806_url
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'URL';

wwv_flow_api.create_message (
  p_id=>195901027151152198 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P806_URL',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p806_sso_server
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Oracle Application Server Single Sign-On';

wwv_flow_api.create_message (
  p_id=>195901115579152198 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P806_SSO_SERVER',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p806_none
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Keine';

wwv_flow_api.create_message (
  p_id=>195901207645152198 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P806_NONE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p808_auth_type
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Verwenden Sie den %0-Account-Benutzernamen und das Kennwort für die Authentifizierung.';

wwv_flow_api.create_message (
  p_id=>195901325760152198 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P808_AUTH_TYPE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p808_no_verify_cred
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Keine ID-Daten verifizieren';

wwv_flow_api.create_message (
  p_id=>195901412593152199 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P808_NO_VERIFY_CRED',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p808_use_ldap
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'LDAP-Server für die Authentifizierung verwenden.';

wwv_flow_api.create_message (
  p_id=>195901520514152199 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P808_USE_LDAP',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p808_use_custom
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Meine benutzerdefinierte Funktion für die Authentifizierung verwenden.';

wwv_flow_api.create_message (
  p_id=>195901624993152199 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P808_USE_CUSTOM',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p815_scratch
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Völlig neu';

wwv_flow_api.create_message (
  p_id=>195901727176152199 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P815_SCRATCH',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p815_copy
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Als Kopie eines vorhandenen Authentifizierungsschemas';

wwv_flow_api.create_message (
  p_id=>195901818558152199 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P815_COPY',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p815_gallery
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Basiert auf einem vorkonfigurierten Schema aus der Galerie';

wwv_flow_api.create_message (
  p_id=>195901903465152199 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P815_GALLERY',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p820_use_dad
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Keine Authentifizierung (mit DAD)';

wwv_flow_api.create_message (
  p_id=>195902029950152199 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P820_USE_DAD',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p820_moc_sso
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'SSO-Cookie (my.oracle.com - Nur für Verwendung mit Oracle)';

wwv_flow_api.create_message (
  p_id=>195902109185152200 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P820_MOC_SSO',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p820_show_account_cred
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Anmeldeseite anzeigen und %0-Account-ID-Daten verwenden';

wwv_flow_api.create_message (
  p_id=>195902206457152200 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P820_SHOW_ACCOUNT_CRED',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p820_show_builtin_pg_open
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Integrierte Anmeldeseite anzeigen und Open Door-ID-Daten verwenden';

wwv_flow_api.create_message (
  p_id=>195902318738152200 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P820_SHOW_BUILTIN_PG_OPEN',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p820_show_use_ldap
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Anmeldeseite anzeigen und LDAP-Verzeichnis-ID-Daten verwenden';

wwv_flow_api.create_message (
  p_id=>195902429249152200 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P820_SHOW_USE_LDAP',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p820_sso_htmldb_partner
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Oracle Application Server Single Sign-On (%0-Engine als Partneranwendung)';

wwv_flow_api.create_message (
  p_id=>195902522545152200 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P820_SSO_HTMLDB_PARTNER',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p820_my_partner
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Oracle Application Server Single Sign-On (Meine Anwendung als Partneranwendung)';

wwv_flow_api.create_message (
  p_id=>195902622972152200 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P820_MY_PARTNER',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p826_new
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Neu';

wwv_flow_api.create_message (
  p_id=>195902719754152201 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P826_NEW',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message instadmin_printsvr_protocol
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Das Druckserverprotokoll muss entweder HTTP oder HTTPS sein';

wwv_flow_api.create_message (
  p_id=>195902817344152201 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTADMIN_PRINTSVR_PROTOCOL',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message instadmin_schema_exists
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Das Schema ist nicht vorhanden';

wwv_flow_api.create_message (
  p_id=>195902925143152201 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTADMIN_SCHEMA_EXISTS',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message instadmin_schema_restricted
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Das Schema ist eingeschränkt';

wwv_flow_api.create_message (
  p_id=>195903024041152201 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTADMIN_SCHEMA_RESTRICTED',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_admin_auth
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Zugriffskontrolle - Administrator';

wwv_flow_api.create_message (
  p_id=>195903126571152201 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_ADMIN_AUTH',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_edit_auth
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Zugriffskontrolle - Bearbeiten';

wwv_flow_api.create_message (
  p_id=>195903209443152202 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_EDIT_AUTH',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_view_auth
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Zugriffskontrolle - Anzeigen';

wwv_flow_api.create_message (
  p_id=>195903304735152202 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_VIEW_AUTH',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_service_admin_link_p1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Accounts im INTERNAL-Workspace können nur verwendet werden, um';

wwv_flow_api.create_message (
  p_id=>195903409172152202 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.SERVICE_ADMIN_LINK_P1',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_service_admin_link_p2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0-Service-Administration';

wwv_flow_api.create_message (
  p_id=>195903529527152202 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.SERVICE_ADMIN_LINK_P2',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_generate_ddl_domain_index_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Es gibt einen Domain-Index im ausgewählten %0. Der Befehl "DDL generieren" kann kein DDL für den Domain-Index generieren.';

wwv_flow_api.create_message (
  p_id=>195903615731152202 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_GENERATE_DDL.DOMAIN_INDEX_ERROR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_unsupported_data_type
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Datentyp nicht unterstützt';

wwv_flow_api.create_message (
  p_id=>195903731877152202 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_UNSUPPORTED_DATA_TYPE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_exclude_null
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Nullwerte ausschließen';

wwv_flow_api.create_message (
  p_id=>195903826798152202 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_EXCLUDE_NULL',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_displayed_columns
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Angezeigte Spalten';

wwv_flow_api.create_message (
  p_id=>195903904818152203 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_DISPLAYED_COLUMNS',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_all_columns
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Alle Spalten';

wwv_flow_api.create_message (
  p_id=>195904017191152203 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_ALL_COLUMNS',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_cannot_delete
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Sie können sich nicht selbst löschen.';

wwv_flow_api.create_message (
  p_id=>195904104430152203 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_CANNOT_DELETE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_cannot_remove_admin
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Sie können die Administratorberechtigung für sich selbst nicht entfernen.';

wwv_flow_api.create_message (
  p_id=>195904220981152203 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_CANNOT_REMOVE_ADMIN',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_chart_type
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Diagrammtyp';

wwv_flow_api.create_message (
  p_id=>195904308224152203 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_CHART_TYPE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_hcolumn
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Horizontale Spalte';

wwv_flow_api.create_message (
  p_id=>195904419820152203 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_HCOLUMN',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_vcolumn
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Vertikale Spalte';

wwv_flow_api.create_message (
  p_id=>195904508324152204 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_VCOLUMN',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_pie
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Kreis';

wwv_flow_api.create_message (
  p_id=>195904630426152204 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_PIE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_line
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Zeile';

wwv_flow_api.create_message (
  p_id=>195904701888152204 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_LINE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_3d
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'3D';

wwv_flow_api.create_message (
  p_id=>195904818293152204 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_3D',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_label
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Label';

wwv_flow_api.create_message (
  p_id=>195904907410152204 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_LABEL',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_aggregate
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Aggregat';

wwv_flow_api.create_message (
  p_id=>195905022002152204 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_AGGREGATE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_do_not_aggregate
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'- Nicht aggregieren -';

wwv_flow_api.create_message (
  p_id=>195905102951152205 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_DO_NOT_AGGREGATE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_date
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Datum';

wwv_flow_api.create_message (
  p_id=>195905211395152205 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_DATE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_display
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Anzeige';

wwv_flow_api.create_message (
  p_id=>195905316448152205 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_DISPLAY',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_select_function
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'- Funktion wählen -';

wwv_flow_api.create_message (
  p_id=>195905400801152205 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_SELECT_FUNCTION',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_public
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Öffentlich';

wwv_flow_api.create_message (
  p_id=>195905512353152205 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_PUBLIC',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_delete_confirm
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Möchten Sie diese Berichtseinstellungen löschen?';

wwv_flow_api.create_message (
  p_id=>195905631350152205 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_DELETE_CONFIRM',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_reset_confirm
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Stellen Sie die Standardeinstellungen für den Bericht wieder her.';

wwv_flow_api.create_message (
  p_id=>195905727119152206 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_RESET_CONFIRM',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_dup_username
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Sie dürfen keine doppelten Benutzernamen eingeben.';

wwv_flow_api.create_message (
  p_id=>195905806596152206 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_DUP_USERNAME',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message custom_auth_std_login_page_1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Geben Sie eine beliebige Zeichenfolge als Ihre Benutzer-ID für diese Session ein.';

wwv_flow_api.create_message (
  p_id=>195905917669152206 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CUSTOM_AUTH_STD.LOGIN_PAGE_1',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message custom_auth_std_login_page_2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Geben Sie den Benutzernamen und das Kennwort für %0 ein.';

wwv_flow_api.create_message (
  p_id=>195906001685152206 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CUSTOM_AUTH_STD.LOGIN_PAGE_2',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message custom_auth_std_login_page_3
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Geben Sie den Benutzernamen und das Kennwort für die Verifizierung durch den LDAP-Host ein: %0.';

wwv_flow_api.create_message (
  p_id=>195906121912152206 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CUSTOM_AUTH_STD.LOGIN_PAGE_3',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message custom_auth_std_login_page_4
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Geben Sie den Benutzernamen und das Kennwort für das Datenbankschema ein.';

wwv_flow_api.create_message (
  p_id=>195906216158152206 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CUSTOM_AUTH_STD.LOGIN_PAGE_4',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message chart_dial_chart_query_syntax_invalid
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Ungültige Diagrammabfrage: %0<br /><br /> Verwenden Sie folgende Syntax: <pre> SELECT VALUE, MAX, (LOW), (HIGH) VALUE FROM ... </pre>'||chr(10)||
'<table class="instructiontext">'||chr(10)||
'<tr>'||chr(10)||
'<td>VALUE</td>'||chr(10)||
'<td>Numerische Spalte für die Definition des Dial-Wertes.</td>'||chr(10)||
'</tr>'||chr(10)||
'<tr>'||chr(10)||
'<td>MAX</td>'||chr(10)||
'<td>Numerische Spalte für die Definition des maximalen Dial-Wertes.</td>'||chr(10)||
'</tr>'||chr(10)||
'<tr>'||chr(10)||
'<td>LOW (optional)</td>'||chr(10)||
'<td>Numerische Spal';

h:=h||'te für die Definition des minimalen vorherigen Dial-Wertes.</td>'||chr(10)||
'</tr>'||chr(10)||
'<tr>'||chr(10)||
'<td>HIGH (optional)</td>'||chr(10)||
'<td>Numerische Spalte für die Definition des maximalen vorherigen Dial-Wertes.</td>'||chr(10)||
'</tr>'||chr(10)||
'</table>';

wwv_flow_api.create_message (
  p_id=>195906319831152207 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CHART.DIAL_CHART_QUERY_SYNTAX_INVALID',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_dup_page_item_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Error page=%0 item="%1" id="%2" hat denselben Namen wie ein vorhandenes Element auf Anwendungsebene.';

wwv_flow_api.create_message (
  p_id=>195906408346152207 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_DUP_PAGE_ITEM_CREATE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_between
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'zwischen';

wwv_flow_api.create_message (
  p_id=>195906501121152207 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_BETWEEN',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_report3_cursor_not_open
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Die Abfrage kann nicht geparst werden. Der Cursor ist noch nicht geöffnet, oder es wurde eine Funktion, die eine SQL-Abfrage zurückgibt, ohne Wert zurückgegeben.';

wwv_flow_api.create_message (
  p_id=>195906616645152207 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_REPORT3.CURSOR_NOT_OPEN',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_report3_query_cannot_be_parsed
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Funktion für die Rückgabe der SQL-Abfrage: Die Abfrage kann nicht im Builder geparst werden. Wenn die Abfrage syntaktisch korrekt ist, aktivieren Sie das Kontrollkästchen <b>Generische Spalten</b> unter der Regionsquelle, um ohne Parsen fortzufahren.'||chr(10)||
'<br />'||chr(10)||
'(%0)';

wwv_flow_api.create_message (
  p_id=>195906717154152207 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_REPORT3.QUERY_CANNOT_BE_PARSED',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_report3_use_column_alias
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Die Abfragespalte #%0 (%1) ist ungültig. Verwenden Sie den Spaltenaliasnamen';

wwv_flow_api.create_message (
  p_id=>195906812289152207 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_REPORT3.USE_COLUMN_ALIAS',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_report3_html_use_column_alias
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Die Abfragespalte #%0 (%1) ist ungültig. HTML-Spalten benötigen Aliasnamen';

wwv_flow_api.create_message (
  p_id=>195906930144152208 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_REPORT3.HTML_USE_COLUMN_ALIAS',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_report3_syntax_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'<p>Die Abfrage kann nicht geparst werden. Überprüfen Sie die Abfragesyntax. (%0) </p>';

wwv_flow_api.create_message (
  p_id=>195907007374152208 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_REPORT3.SYNTAX_ERROR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_report3_syntax_error2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'<p>Die Abfrage kann nicht im Builder geparst werden. Wenn die Abfrage syntaktisch korrekt ist, aktivieren Sie das Kontrollkästchen für die generischen Spalten unter der Regionsquelle, um ohne Parsen fortzufahren. %0</p>';

wwv_flow_api.create_message (
  p_id=>195907127574152208 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_REPORT3.SYNTAX_ERROR2',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_apply
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Anwenden';

wwv_flow_api.create_message (
  p_id=>195907214226152208 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_APPLY',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_migrate_svg_restriction
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Das SVG-Diagramm wird mit folgenden Einschränkungen migriert:  '||chr(10)||
'<ul>'||chr(10)||
'<li>'||chr(10)||
'Es werden nur Zahlenformate migriert, die in Achsenformat-Zeichenfolgen definiert sind. Datums- und Zeitformate werden ignoriert.'||chr(10)||
'</li>'||chr(10)||
'<li>'||chr(10)||
'Es werden Zahlenformatelemente migriert, die Folgendes enthalten:'||chr(10)||
'<br />'||chr(10)||
'0,9,D,G,, (Komma),. (Punkt),$,C,L,FM'||chr(10)||
'</li>'||chr(10)||
'<li>'||chr(10)||
'Das Label für die Datenreihe im Flash-Diagramm wird vom Spaltena';

h:=h||'liasnamen der Datenreihe abgeleitet.  '||chr(10)||
'Bei SVG-Diagrammen wird hingegen das Label der jeweiligen Datenreihe vom Namensattribut der Datenreihe abgeleitet.'||chr(10)||
'</li>'||chr(10)||
'<li>'||chr(10)||
'In Flash Dial-Diagrammen werden anstelle von Prozentsätzen die tatsächlichen Werte angezeigt.'||chr(10)||
'</li>'||chr(10)||
'</ul>';

wwv_flow_api.create_message (
  p_id=>195907302932152208 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.MIGRATE_SVG_RESTRICTION',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_flash_chart_close
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Schließen:';

wwv_flow_api.create_message (
  p_id=>195907431349152208 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FLASH_CHART.CLOSE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_flash_chart_high
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Hoch:';

wwv_flow_api.create_message (
  p_id=>195907516991152208 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FLASH_CHART.HIGH',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_flash_chart_low
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Niedrig:';

wwv_flow_api.create_message (
  p_id=>195907627437152209 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FLASH_CHART.LOW',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message monthly
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Monatlich';

wwv_flow_api.create_message (
  p_id=>195907713504152209 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'MONTHLY',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message weekly
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Wöchentlich';

wwv_flow_api.create_message (
  p_id=>195907826641152209 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WEEKLY',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message daily
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Täglich';

wwv_flow_api.create_message (
  p_id=>195907911239152209 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DAILY',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message calendar_previous
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'< Zurück';

wwv_flow_api.create_message (
  p_id=>195908017366152209 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CALENDAR.PREVIOUS',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message calendar_next
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Weiter >';

wwv_flow_api.create_message (
  p_id=>195908115594152209 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CALENDAR.NEXT',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message p4111_used_on_pages
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Diese Werteliste wird auf Seite %0 verwendet. Möchten Sie den Löschvorgang wirklich ausführen? ';

wwv_flow_api.create_message (
  p_id=>195908224951152210 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'P4111_USED_ON_PAGES',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_imp_parser_create_ws_sec_violation
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Während der Workspace-Installation ist ein zweiter create_company-Aufruf aufgetreten.';

wwv_flow_api.create_message (
  p_id=>195908330190152210 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_IMP_PARSER.CREATE_WS_SEC_VIOLATION',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_mail_to_is_required
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Es muss ein Nachrichtenempfänger angegeben werden, damit E-Mails gesendet werden können.';

wwv_flow_api.create_message (
  p_id=>195908415873152210 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_MAIL.TO_IS_REQUIRED',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message must_be_xsl
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Vergewissern Sie sich, dass der Dateityp der Berichtslayoutdatei XSL-FO und die Dateierweiterung ''.xsl'' ist.';

wwv_flow_api.create_message (
  p_id=>195908522773152210 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'MUST_BE_XSL',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message your_email_iuws
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Ihre E-Mail-Adresse ist mit einem Benutzer in den folgenden Workspaces registriert:';

wwv_flow_api.create_message (
  p_id=>195908628718152210 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'YOUR_EMAIL_IUWS',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4050_workspace_home
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Workspace-Homepage';

wwv_flow_api.create_message (
  p_id=>195908723207152210 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4050.WORKSPACE_HOME',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4050_workspace_login
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Workspace-Anmeldung';

wwv_flow_api.create_message (
  p_id=>195908811807152211 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4050.WORKSPACE_LOGIN',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message dynamic_query
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Interaktiver Bericht';

wwv_flow_api.create_message (
  p_id=>195908920634152211 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DYNAMIC_QUERY',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_templates
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Templates';

wwv_flow_api.create_message (
  p_id=>195909028563152211 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_TEMPLATES',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_lov
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Wertelisten';

wwv_flow_api.create_message (
  p_id=>195909101526152211 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_LOV',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_no_lov
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Es werden keine gemeinsam verwendeten Wertelisten verwendet.';

wwv_flow_api.create_message (
  p_id=>195909222376152211 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_NO_LOV',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_no_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Keine Templates verwendet.';

wwv_flow_api.create_message (
  p_id=>195909324205152211 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_NO_TEMPLATE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message button_id
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Numerische Schaltflächen-ID';

wwv_flow_api.create_message (
  p_id=>195909416717152212 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'BUTTON_ID',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message flash_chart_invalid_chart_query
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Ungültige Diagrammabfrage: %0<br /><br />'||chr(10)||
'Verwenden Sie folgende Syntax:'||chr(10)||
'<pre>'||chr(10)||
'SELECT LINK, LABEL, VALUE'||chr(10)||
'FROM   ...'||chr(10)||
'</pre>'||chr(10)||
'Oder verwenden Sie die folgende Syntax für eine Abfrage, die mehrere Datenreihen zurückgibt:'||chr(10)||
'<pre>'||chr(10)||
'SELECT LINK, LABEL, VALUE1 [, VALUE2 [, VALUE3...]]'||chr(10)||
'FROM   ...'||chr(10)||
'</pre>'||chr(10)||
'<table class="instructiontext">'||chr(10)||
'<tr><td>LINK</td><td>URL</td></tr>'||chr(10)||
'<tr><td>LABEL</td><td>Text, der entlang e';

h:=h||'iner Diagrammachse angezeigt wird.</td></tr>'||chr(10)||
'<tr><td>VALUE1, VALUE2, VALUE3...</td><td>Numerische Spalten, die die Datenwerte definieren.</td></tr>'||chr(10)||
'</table>'||chr(10)||
'Hinweis: Die Datenreihennamen für Spalten- und Liniendiagramme werden von den Spaltenaliasnamen in der Abfrage abgeleitet.';

wwv_flow_api.create_message (
  p_id=>195909522471152212 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'FLASH_CHART.INVALID_CHART_QUERY',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message flash_chart_invalid_scatter_chart_query
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Ungültige Streuungsdiagrammabfrage: %0<br /><br />'||chr(10)||
'Verwenden Sie folgende Syntax:'||chr(10)||
'<pre>'||chr(10)||
'SELECT LINK, LABEL, X_VALUE, Y_VALUE'||chr(10)||
'FROM   ...'||chr(10)||
'</pre>'||chr(10)||
'<table class="instructiontext">'||chr(10)||
'<tr><td>LINK</td><td>URL</td></tr>'||chr(10)||
'<tr><td>LABEL</td><td>Text, der in Hinweisen angezeigt wird.</td></tr>'||chr(10)||
'<tr><td>X_VALUE</td><td>Numerische Spalte, die X-Koordinatenwerte angibt.</td></tr>'||chr(10)||
'<tr><td>Y_VALUE</td><td>Numerische ';

h:=h||'Spalte, die Y-Koordinatenwerte angibt.</td></tr>'||chr(10)||
'</table>';

wwv_flow_api.create_message (
  p_id=>195909612523152212 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'FLASH_CHART.INVALID_SCATTER_CHART_QUERY',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message flash_chart_invalid_range_chart_query
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Ungültige Bereichsdiagrammabfrage: %0<br /><br />'||chr(10)||
'Verwenden Sie folgende Syntax:'||chr(10)||
'<pre>'||chr(10)||
'SELECT LINK, LABEL, OPEN_VALUE, CLOSE_VALUE'||chr(10)||
'FROM   ...'||chr(10)||
'</pre>'||chr(10)||
'<table class="instructiontext">'||chr(10)||
'<tr><td>LINK</td><td>URL</td></tr>'||chr(10)||
'<tr><td>LABEL</td><td>Text, der entlang einer Diagrammachse angezeigt wird.</td></tr>'||chr(10)||
'<tr><td>OPEN_VALUE</td><td>Numerische Spalte, die den Anfang des Bereichs angibt.</td></tr>'||chr(10)||
'<tr><t';

h:=h||'d>CLOSE_VALUE</td><td>Numerische Spalte, die das Ende des Bereichs angibt.</td></tr>'||chr(10)||
'</table>';

wwv_flow_api.create_message (
  p_id=>195909709198152212 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'FLASH_CHART.INVALID_RANGE_CHART_QUERY',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message flash_chart_invalid_candlestick_chart_query
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Ungültige Kerzendiagrammabfrage: %0<br /><br />'||chr(10)||
'Verwenden Sie folgende Syntax:'||chr(10)||
'<pre>'||chr(10)||
'SELECT LINK, LABEL, OPEN, HIGH, LOW, CLOSE'||chr(10)||
'FROM   ...'||chr(10)||
'</pre>'||chr(10)||
'<table class="instructiontext">'||chr(10)||
'<tr><td>LINK</td><td>URL</td></tr>'||chr(10)||
'<tr><td>LABEL</td><td>Text, der entlang einer Diagrammachse angezeigt wird.</td></tr>'||chr(10)||
'<tr><td>OPEN</td><td>Numerische Spalte, die den Anfang des Kerzendiagramms angibt.</td></tr>'||chr(10)||
'<tr><td>';

h:=h||'HIGH</td><td>Numerische Spalte, die das Maximum des Kerzendiagramms angibt.</td></tr>'||chr(10)||
'<tr><td>LOW</td><td>Numerische Spalte, die das Minimum des Kerzendiagramms angibt.</td></tr>'||chr(10)||
'<tr><td>CLOSE</td><td>Numerische Spalte, die das Ende des Kerzendiagramms angibt.</td></tr>'||chr(10)||
'</table>';

wwv_flow_api.create_message (
  p_id=>195909832244152212 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'FLASH_CHART.INVALID_CANDLESTICK_CHART_QUERY',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message flash_chart_invalid_dial_chart_query
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Ungültige Dial-Diagrammabfrage: %0<br /><br /> Verwenden Sie folgende Syntax:'||chr(10)||
'<pre> SELECT VALUE, MAX [, LOW, HIGH] VALUE FROM ... </pre>'||chr(10)||
'<table class="instructiontext">'||chr(10)||
'<tr>'||chr(10)||
'<td>VALUE</td>'||chr(10)||
'<td>Numerische Spalte, die den Dial-Wert definiert.</td>'||chr(10)||
'</tr>'||chr(10)||
'<tr>'||chr(10)||
'<td>MAX</td>'||chr(10)||
'<td>Numerische Spalte, die den maximalen Dial-Wert definiert.</td>'||chr(10)||
'</tr>'||chr(10)||
'<tr>'||chr(10)||
'<td>LOW (optional)</td>'||chr(10)||
'<td>Numerische Spalte, die ';

h:=h||'den Minimalwert eines Bereichs für die Anzeige im Dial-Diagramm definiert. Wenn dieser Wert definiert ist, muss ein HIGH-Wert angegeben werden.</td>'||chr(10)||
'</tr>'||chr(10)||
'<tr>'||chr(10)||
'<td>HIGH (optional)</td>'||chr(10)||
'<td>Numerische Spalte, die den Maximalwert eines Bereichs für die Anzeige im Dial-Diagramm definiert. Wenn dieser Wert definiert ist, muss ein LOW-Wert angegeben werden.</td>'||chr(10)||
'</tr>'||chr(10)||
'</table>'||chr(10)||
'Diese Abfrage sollte eine';

h:=h||' Zeile zurückgeben.';

wwv_flow_api.create_message (
  p_id=>195909924498152212 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'FLASH_CHART.INVALID_DIAL_CHART_QUERY',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message flash_chart_invalid_pie_chart_query
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Ungültige Diagrammabfrage: %0<br /><br />'||chr(10)||
'Verwenden Sie folgende Syntax:'||chr(10)||
'<pre>'||chr(10)||
'SELECT LINK, LABEL, VALUE'||chr(10)||
'FROM   ...'||chr(10)||
'</pre>'||chr(10)||
'<table class="instructiontext">'||chr(10)||
'<tr><td>LINK</td><td>URL</td></tr>'||chr(10)||
'<tr><td>LABEL</td><td>Text, der in Legenden, Hinweisen und Kreissegment-Labels angezeigt wird.</td></tr>'||chr(10)||
'<tr><td>VALUE</td><td>Numerische Spalte, die die Datenwerte definiert.</td></tr>'||chr(10)||
'</table>';

wwv_flow_api.create_message (
  p_id=>195910001236152212 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'FLASH_CHART.INVALID_PIE_CHART_QUERY',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message drag_and_drop
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Drag & Drop';

wwv_flow_api.create_message (
  p_id=>195910119213152213 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DRAG_AND_DROP',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_mail_add_attachment_parameter_null
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Für Parameter %0 wurde ein Nullwert angegeben.';

wwv_flow_api.create_message (
  p_id=>195910228157152213 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_MAIL.ADD_ATTACHMENT.PARAMETER_NULL',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_mail_add_attachment_invalid_mail_id
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Ungültiger Wert für Parameter p_mail_id: %0';

wwv_flow_api.create_message (
  p_id=>195910319917152213 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_MAIL.ADD_ATTACHMENT.INVALID_MAIL_ID',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_category
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Kategorie';

wwv_flow_api.create_message (
  p_id=>195910422014152213 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_CATEGORY',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_description
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Beschreibung';

wwv_flow_api.create_message (
  p_id=>195910513666152213 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_DESCRIPTION',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_imp_parser_sec_violation
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'API-Aufruf für die remove_page-Prozedur in einem großen Block der Exportdatei.';

wwv_flow_api.create_message (
  p_id=>195910622249152214 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_IMP_PARSER.SEC_VIOLATION',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p52_fmb_content_invalid
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Die Datei, die Sie in Ihr Forms-Migrationsprojekt hochladen möchten, ist keine gültige Forms-Modul-Datei (_fmb.XML). Nur Forms-Modul-XML-Dateien, die mit dem Forms2XML-Konvertierungstool von Oracle Forms generiert wurden, können hochgeladen werden.';

wwv_flow_api.create_message (
  p_id=>195910721712152214 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P52_FMB_CONTENT_INVALID',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p52_rpt_content_invalid
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Die Datei, die Sie in Ihr Forms-Migrationsprojekt hochladen möchten, ist keine gültige Report-Datei (.XML). Nur Report-XML-Dateien, die mit der Funktion "Dateikonvertierung" von Oracle Forms Builder generiert wurden, können hochgeladen werden.';

wwv_flow_api.create_message (
  p_id=>195910814265152214 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P52_RPT_CONTENT_INVALID',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p430_url
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'URL: http(s)://domain/path/doc.(pdf)(html)(etc...)';

wwv_flow_api.create_message (
  p_id=>195910920684152214 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P430_URL',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p430_ip
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'IP-Adresse';

wwv_flow_api.create_message (
  p_id=>195911026798152214 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P430_IP',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p430_phone
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Telefonnummer, USA: %0';

wwv_flow_api.create_message (
  p_id=>195911114703152214 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P430_PHONE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p430_phone2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Telefonnummer, USA (flexibel): 999.999.9999, (999)-999-9999, 999 999 9999 usw.';

wwv_flow_api.create_message (
  p_id=>195911200989152214 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P430_PHONE2',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p430_zip
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Postleitzahl: 99999';

wwv_flow_api.create_message (
  p_id=>195911328682152215 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P430_ZIP',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p430_zip2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ZIP + 4: 99999-9999';

wwv_flow_api.create_message (
  p_id=>195911422373152215 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P430_ZIP2',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p430_date
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Datum: %0';

wwv_flow_api.create_message (
  p_id=>195911502804152215 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P430_DATE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p430_date2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Datum, flexibel: %0 mit beliebigem Trennzeichen';

wwv_flow_api.create_message (
  p_id=>195911606927152215 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P430_DATE2',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p430_url_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Ungültiger URL';

wwv_flow_api.create_message (
  p_id=>195911717015152215 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P430_URL_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p430_ip_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Ungültige IP-Adresse';

wwv_flow_api.create_message (
  p_id=>195911827958152215 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P430_IP_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p430_phone_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Die Telefonnummer muss im Format %0 sein';

wwv_flow_api.create_message (
  p_id=>195911916669152216 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P430_PHONE_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p430_phone2_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Das Format für die Telefonnummer wurde nicht erkannt';

wwv_flow_api.create_message (
  p_id=>195912006994152216 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P430_PHONE2_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p430_zip_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Die Postleitzahl muss im Format %0 sein';

wwv_flow_api.create_message (
  p_id=>195912118186152216 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P430_ZIP_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p430_date_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Das Datum muss im Format %0 sein';

wwv_flow_api.create_message (
  p_id=>195912208321152216 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P430_DATE_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p430_date2_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Datumsformat nicht erkannt';

wwv_flow_api.create_message (
  p_id=>195912315157152216 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P430_DATE2_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p819_curr_warn
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Warnung: Sie sind im Begriff, das aktuelle Authentifizierungsschema für diese Anwendung zu löschen.';

wwv_flow_api.create_message (
  p_id=>195912414546152216 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P819_CURR_WARN',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_security_custom_auth_func_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Ausführen von benutzerdefinierter Authentifizierungsfunktion in Anwendung %0 nicht möglich.';

wwv_flow_api.create_message (
  p_id=>195912522158152217 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SECURITY.CUSTOM_AUTH_FUNC_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_security_custom_auth_fetch_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Abrufen von benutzerdefiniertem Authentifizierungs-Funktions-Body in Anwendung %0 nicht möglich.';

wwv_flow_api.create_message (
  p_id=>195912631310152217 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SECURITY.CUSTOM_AUTH_FETCH_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_security_auth_scheme_fetch_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Abrufen von authentication_scheme in Anwendung %0 nicht möglich.';

wwv_flow_api.create_message (
  p_id=>195912723670152217 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SECURITY.AUTH_SCHEME_FETCH_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_security_auth_pg_sentry_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Ausführen von Seiten-Sentry in Anwendung %0 nicht möglich.';

wwv_flow_api.create_message (
  p_id=>195912809454152217 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SECURITY.AUTH_PG_SENTRY_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_security_auth_sess_verify_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Ausführen von Funktion zum Überprüfen von Plugin-Session aus Authentifizierungsschema in Anwendung %0 nicht möglich.';

wwv_flow_api.create_message (
  p_id=>195912908477152217 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SECURITY.AUTH_SESS_VERIFY_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_security_sso_pkg_missing1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'WWSEC_SSO_ENABLER_PRIVATE-Package ist nicht vorhanden oder ist ungültig.';

wwv_flow_api.create_message (
  p_id=>195913022775152217 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SECURITY.SSO_PKG_MISSING1',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_security_sso_pkg_missing2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Bitten Sie den %0 Administrator, die Engine für Oracle Application Server Single Sign-On zu konfigurieren.';

wwv_flow_api.create_message (
  p_id=>195913116797152218 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SECURITY.SSO_PKG_MISSING2',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_security_sso_pkg_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fehler beim Ausführen von wwv_flow_custom_auth_sso.portal_sso_redirect.';

wwv_flow_api.create_message (
  p_id=>195913212164152218 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SECURITY.SSO_PKG_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_api_deep_link_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unerwarteter Fehler in remember_deep_link für Session %0.';

wwv_flow_api.create_message (
  p_id=>195913315075152218 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_API.DEEP_LINK_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_fnd_user_api_dup_user
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Mehrfach vorhandener Benutzername für %0 gefunden.';

wwv_flow_api.create_message (
  p_id=>195913423316152218 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FND_USER_API.DUP_USER',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_fnd_user_api_load_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fehler beim Laden von Benutzern. Vorgang bei Benutzer %0 nicht erfolgreich.';

wwv_flow_api.create_message (
  p_id=>195913519407152218 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FND_USER_API.LOAD_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p52_mmb_content_invalid
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Die Datei, die Sie in Ihr Forms-Migrationsprojekt hochladen möchten, ist keine gültige Forms-Menü-Datei (_mmb.XML). Nur Forms-Menü-XML-Dateien, die mit dem Forms2XML-Konvertierungstool von Oracle Forms generiert wurden, können hochgeladen werden.';

wwv_flow_api.create_message (
  p_id=>195913603712152218 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P52_MMB_CONTENT_INVALID',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_report3_x_y_of_z
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Zeile(n) %0 - %1 von %2';

wwv_flow_api.create_message (
  p_id=>195913705137152219 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_REPORT3.X_Y_OF_Z',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_report3_found_but_not_displayed
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Minimale Zeile angefordert: %0, Zeilen gefunden, die jedoch nicht angezeigt werden: %1';

wwv_flow_api.create_message (
  p_id=>195913832423152219 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_REPORT3.FOUND_BUT_NOT_DISPLAYED',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_report3_x_y_of_more_than_z
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Zeile(n) %0 - %1 von mehr als %2';

wwv_flow_api.create_message (
  p_id=>195913931916152219 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_REPORT3.X_Y_OF_MORE_THAN_Z',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_application
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Anwendung';

wwv_flow_api.create_message (
  p_id=>195914030631152219 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.APPLICATION',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Seite';

wwv_flow_api.create_message (
  p_id=>195914130752152219 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.PAGE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_page_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Seitenname';

wwv_flow_api.create_message (
  p_id=>195914216521152219 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.PAGE_NAME',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_region_title
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Regionsüberschrift';

wwv_flow_api.create_message (
  p_id=>195914324497152220 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.REGION_TITLE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_tab_set
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Registerkartengruppe';

wwv_flow_api.create_message (
  p_id=>195914430881152220 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.TAB_SET',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_tab_label
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Registerkarten-Label';

wwv_flow_api.create_message (
  p_id=>195914528744152220 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.TAB_LABEL',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_table_owner
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Tabelleneigentümer';

wwv_flow_api.create_message (
  p_id=>195914618453152220 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.TABLE_OWNER',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_table_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Tabellenname';

wwv_flow_api.create_message (
  p_id=>195914731955152220 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.TABLE_NAME',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_columns
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Spalten';

wwv_flow_api.create_message (
  p_id=>195914814662152220 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.COLUMNS',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_updateable_columns
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Aktualisierbare Spalten';

wwv_flow_api.create_message (
  p_id=>195914909536152221 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.UPDATEABLE_COLUMNS',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_primary_key
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Primärschlüssel %0';

wwv_flow_api.create_message (
  p_id=>195915027411152221 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.PRIMARY_KEY',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_page_title
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Seitenüberschrift';

wwv_flow_api.create_message (
  p_id=>195915104186152221 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.PAGE_TITLE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_no_tabset_selected
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Für diese Seite wurde keine Registerkartengruppe ausgewählt.';

wwv_flow_api.create_message (
  p_id=>195915205162152221 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.NO.TABSET.SELECTED',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_create_new_tabset
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Eine neue Registerkartengruppe "%0" wird erstellt und von dieser Seite verwendet.';

wwv_flow_api.create_message (
  p_id=>195915307223152221 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CREATE.NEW.TABSET',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_use_existing_tabset
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Diese Seite verwendet die vorhandene Registerkartengruppe "%0".';

wwv_flow_api.create_message (
  p_id=>195915405606152221 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.USE.EXISTING.TABSET',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_tabset_incomplete
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Warnung. Informationen zur Registerkartengruppe sind unvollständig.';

wwv_flow_api.create_message (
  p_id=>195915501019152221 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.TABSET.INCOMPLETE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_parent_tab_set
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Übergeordnete Registerkartengruppe';

wwv_flow_api.create_message (
  p_id=>195915612651152222 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.PARENT_TAB_SET',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_parent_tab_label
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Label für übergeordnete Registerkarte';

wwv_flow_api.create_message (
  p_id=>195915727410152222 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.PARENT_TAB_LABEL',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_no_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Kein Template';

wwv_flow_api.create_message (
  p_id=>195915825594152222 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.NO_TEMPLATE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_items
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Elemente';

wwv_flow_api.create_message (
  p_id=>195915925913152222 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.ITEMS',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_region_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Regions-Template';

wwv_flow_api.create_message (
  p_id=>195916004026152222 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.REGION_TEMPLATE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_information_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Informations-Template';

wwv_flow_api.create_message (
  p_id=>195916116360152222 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.INFORMATION_TEMPLATE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_information_text
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Informations-Standardtext';

wwv_flow_api.create_message (
  p_id=>195916229800152223 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.INFORMATION_TEXT',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_button_text
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Anzeigetext für die Schaltfläche "%0"';

wwv_flow_api.create_message (
  p_id=>195916321757152223 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.BUTTON_TEXT',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_button_branch
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0-Schaltflächenverzweigung';

wwv_flow_api.create_message (
  p_id=>195916410152152223 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.BUTTON_BRANCH',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_suggested_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Vorgeschlagener Name';

wwv_flow_api.create_message (
  p_id=>195916522460152223 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.SUGGESTED_NAME',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_actual_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Tatsächlicher Name';

wwv_flow_api.create_message (
  p_id=>195916618156152223 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.ACTUAL_NAME',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_new_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Neues Template';

wwv_flow_api.create_message (
  p_id=>195916711380152224 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.NEW_TEMPLATE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_display_columns
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Spalten anzeigen';

wwv_flow_api.create_message (
  p_id=>195916805427152224 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.DISPLAY_COLUMNS',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_process_options
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Prozessoptionen';

wwv_flow_api.create_message (
  p_id=>195916916505152224 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.PROCESS_OPTIONS',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_owner
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Eigentümer';

wwv_flow_api.create_message (
  p_id=>195917011529152224 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.OWNER',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_stored_procedure_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Name der gespeicherten Prozedur';

wwv_flow_api.create_message (
  p_id=>195917121290152224 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.STORED_PROCEDURE_NAME',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_sql_query
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'SQL-Abfrage';

wwv_flow_api.create_message (
  p_id=>195917229584152224 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.SQL_QUERY',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_chart_query
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Diagrammabfrage';

wwv_flow_api.create_message (
  p_id=>195917300564152224 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CHART_QUERY',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_chart_axis
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Diagrammachse';

wwv_flow_api.create_message (
  p_id=>195917407035152225 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CHART_AXIS',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_chart_scale
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Nachkommastellen';

wwv_flow_api.create_message (
  p_id=>195917500612152225 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CHART_SCALE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_chart_number_mask
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Zahlenmaske';

wwv_flow_api.create_message (
  p_id=>195917622331152225 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CHART_NUMBER_MASK',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_chart_type
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Diagrammtyp';

wwv_flow_api.create_message (
  p_id=>195917702973152225 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CHART_TYPE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_chart_title
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Diagrammüberschrift';

wwv_flow_api.create_message (
  p_id=>195917826589152225 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CHART_TITLE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_chart_size
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Diagrammgröße';

wwv_flow_api.create_message (
  p_id=>195917929123152225 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CHART_SIZE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_chart_vertical_bar
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Vertikaler Balken';

wwv_flow_api.create_message (
  p_id=>195918004669152226 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CHART_VERTICAL_BAR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_chart_horizontal_bar
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Horizontaler Balken';

wwv_flow_api.create_message (
  p_id=>195918132198152226 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CHART_HORIZONTAL_BAR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_chart_pie
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Kreis';

wwv_flow_api.create_message (
  p_id=>195918216027152226 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CHART_PIE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_chart_line
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Zeile';

wwv_flow_api.create_message (
  p_id=>195918310518152226 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CHART_LINE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_chart_scatter
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Streuungsdiagramm';

wwv_flow_api.create_message (
  p_id=>195918411965152226 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CHART_SCATTER',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_insert_process
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Einfügen';

wwv_flow_api.create_message (
  p_id=>195918513080152226 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.INSERT_PROCESS',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_update_process
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Aktualisieren';

wwv_flow_api.create_message (
  p_id=>195918623835152227 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.UPDATE_PROCESS',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_delete_process
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Löschen';

wwv_flow_api.create_message (
  p_id=>195918729567152227 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.DELETE_PROCESS',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_create_tabular_form
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Sie haben das Erstellen einer tabellarischen Form-Seite mit folgenden Attributen angefordert. Bitte bestätigen Sie Ihre Auswahl.';

wwv_flow_api.create_message (
  p_id=>195918819402152227 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CREATE_TABULAR_FORM',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_create_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Sie haben das Erstellen einer Seite mit folgenden Attributen angefordert. Bitte bestätigen Sie Ihre Auswahl.';

wwv_flow_api.create_message (
  p_id=>195918907571152227 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CREATE_PAGE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_create_wizard
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Sie haben das Erstellen eines Assistenten mit folgenden Attributen angefordert. Bitte bestätigen Sie Ihre Auswahl.';

wwv_flow_api.create_message (
  p_id=>195919023591152227 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CREATE_WIZARD',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_create_form_on_table
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Sie haben das Erstellen einer Form basierend auf einer Tabellenseite mit folgenden Attributen angefordert. Bitte bestätigen Sie Ihre Auswahl.';

wwv_flow_api.create_message (
  p_id=>195919112234152227 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CREATE_FORM_ON_TABLE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_create_form_on_sp
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Sie haben das Erstellen einer Form basierend auf einer gespeicherten Prozedur mit folgenden Attributen angefordert. Bitte bestätigen Sie Ihre Auswahl.';

wwv_flow_api.create_message (
  p_id=>195919218535152228 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CREATE_FORM_ON_SP',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_create_form_on_query
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Sie haben das Erstellen einer Form basierend auf einer SQL-Abfrage mit folgenden Attributen angefordert. Bitte bestätigen Sie Ihre Auswahl.';

wwv_flow_api.create_message (
  p_id=>195919322597152228 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CREATE_FORM_ON_QUERY',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_create_simple_chart
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Sie haben das Erstellen einer HTML-Balkendiagrammseite mit folgenden Attributen angefordert. Bitte bestätigen Sie Ihre Auswahl.';

wwv_flow_api.create_message (
  p_id=>195919405790152228 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CREATE_SIMPLE_CHART',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_create_svg_chart
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Sie haben das Erstellen einer SVG-Diagrammseite mit folgenden Attributen angefordert. Bitte bestätigen Sie Ihre Auswahl.';

wwv_flow_api.create_message (
  p_id=>195919531242152228 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CREATE_SVG_CHART',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_create_calendar
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Sie haben das Erstellen einer Kalenderseite mit folgenden Attributen angefordert. Bitte bestätigen Sie Ihre Auswahl.';

wwv_flow_api.create_message (
  p_id=>195919626840152228 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CREATE_CALENDAR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_date_column
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Datumsspalte';

wwv_flow_api.create_message (
  p_id=>195919702062152228 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.DATE_COLUMN',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_label_column
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Label-Spalte';

wwv_flow_api.create_message (
  p_id=>195919830811152229 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.LABEL_COLUMN',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_create_tree
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Sie haben das Erstellen einer Baumseite mit folgenden Attributen angefordert. Bitte bestätigen Sie Ihre Auswahl.';

wwv_flow_api.create_message (
  p_id=>195919927253152229 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CREATE_TREE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_tree_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Baumname';

wwv_flow_api.create_message (
  p_id=>195920025132152229 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.TREE_NAME',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_tree_type
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Baumtyp';

wwv_flow_api.create_message (
  p_id=>195920126514152229 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.TREE_TYPE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_tree_max_level
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Maximale Ebenen';

wwv_flow_api.create_message (
  p_id=>195920216742152229 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.TREE_MAX_LEVEL',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_tree_start
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Ausgangsbaum';

wwv_flow_api.create_message (
  p_id=>195920325986152229 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.TREE_START',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_tree_query
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Baumabfrage';

wwv_flow_api.create_message (
  p_id=>195920430732152230 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.TREE_QUERY',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_tree_lov
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Basiert auf neuem Element mit Popup-Werteliste';

wwv_flow_api.create_message (
  p_id=>195920506783152230 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.TREE_LOV',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_tree_sql
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Auf einer SQL-Abfrage basierend';

wwv_flow_api.create_message (
  p_id=>195920602394152230 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.TREE_SQL',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_tree_static
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Statischer Wert';

wwv_flow_api.create_message (
  p_id=>195920714657152230 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.TREE_STATIC',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_create_menu
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Sie haben das Erstellen einer Navigationspfadregion und Navigationspfadoption mit folgenden Attributen angefordert. Bitte bestätigen Sie Ihre Auswahl.';

wwv_flow_api.create_message (
  p_id=>195920806338152230 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CREATE_MENU',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_region_type
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Regionstyp';

wwv_flow_api.create_message (
  p_id=>195920909217152230 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.REGION_TYPE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_display_point
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Anzeigepunkt';

wwv_flow_api.create_message (
  p_id=>195921003862152230 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.DISPLAY_POINT',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_menu_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Navigationspfad-Template';

wwv_flow_api.create_message (
  p_id=>195921101018152231 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.MENU_TEMPLATE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_sequence
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Sequence';

wwv_flow_api.create_message (
  p_id=>195921209101152231 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.SEQUENCE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_menu_link
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Navigationspfad-Link';

wwv_flow_api.create_message (
  p_id=>195921307298152231 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.MENU_LINK',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_menu_text
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Navigationspfadtext';

wwv_flow_api.create_message (
  p_id=>195921408360152231 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.MENU_TEXT',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_parent_menu
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Übergeordneter Navigationspfad';

wwv_flow_api.create_message (
  p_id=>195921508201152231 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.PARENT_MENU',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_create_query_and_update
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Sie haben das Erstellen von Form- und Berichtseiten mit folgenden Attributen angefordert. Bestätigen Sie Ihre Wahl.';

wwv_flow_api.create_message (
  p_id=>195921617700152231 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CREATE_QUERY_AND_UPDATE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_report_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Berichtsseite';

wwv_flow_api.create_message (
  p_id=>195921700679152232 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.REPORT_PAGE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_report_page_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Der Name der Berichtsseite';

wwv_flow_api.create_message (
  p_id=>195921810102152232 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.REPORT_PAGE_NAME',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_report_page_tab_set
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Berichtsseiten-Registerkartengruppe';

wwv_flow_api.create_message (
  p_id=>195921904345152232 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.REPORT_PAGE_TAB_SET',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_report_page_tab_label
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Berichtsseiten-Registerkarten-Label';

wwv_flow_api.create_message (
  p_id=>195922005768152232 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.REPORT_PAGE_TAB_LABEL',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_form_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Form-Seite';

wwv_flow_api.create_message (
  p_id=>195922117287152232 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.FORM_PAGE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_form_page_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Form-Seitenname';

wwv_flow_api.create_message (
  p_id=>195922209390152232 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.FORM_PAGE_NAME',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_form_page_tab_set
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Form-Seiten-Registerkartengruppe';

wwv_flow_api.create_message (
  p_id=>195922311744152233 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.FORM_PAGE_TAB_SET',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_form_page_tab_label
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Form-Seiten-Registerkarten-Label';

wwv_flow_api.create_message (
  p_id=>195922427151152233 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.FORM_PAGE_TAB_LABEL',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_primary_key_column
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Primärschlüsselspalte';

wwv_flow_api.create_message (
  p_id=>195922522062152233 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.PRIMARY_KEY_COLUMN',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_report_columns
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Berichtspalten';

wwv_flow_api.create_message (
  p_id=>195922610737152233 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.REPORT_COLUMNS',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_where_clause
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'WHERE-Klausel';

wwv_flow_api.create_message (
  p_id=>195922701275152233 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.WHERE_CLAUSE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_create_drill_down
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Sie haben das Erstellen einer Seite für einen Aufgliederungsbericht mit folgenden Attributen angefordert. Bitte bestätigen Sie Ihre Auswahl.';

wwv_flow_api.create_message (
  p_id=>195922829357152233 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CREATE_DRILL_DOWN',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_parent_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Übergeordnete Seite';

wwv_flow_api.create_message (
  p_id=>195922901618152234 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.PARENT_PAGE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_detail_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Detailseite %0';

wwv_flow_api.create_message (
  p_id=>195923006715152234 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.DETAIL_PAGE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_detail_tab_label
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Label für Detailregisterkarte %0';

wwv_flow_api.create_message (
  p_id=>195923113449152234 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.DETAIL_TAB_LABEL',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_parent_table_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Der Name der übergeordneten Tabelle';

wwv_flow_api.create_message (
  p_id=>195923212678152234 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.PARENT_TABLE_NAME',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_detail_table_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Der Name der Detail-Tabelle %0';

wwv_flow_api.create_message (
  p_id=>195923319028152234 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.DETAIL_TABLE_NAME',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_parent_display_cols
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Übergeordnete Anzeigespalten';

wwv_flow_api.create_message (
  p_id=>195923416150152235 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.PARENT_DISPLAY_COLS',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_detail_display_cols
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0-Anzeigespalten - Detail';

wwv_flow_api.create_message (
  p_id=>195923513549152235 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.DETAIL_DISPLAY_COLS',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_parent_order_by
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Übergeordnete Tabelle anordnen nach';

wwv_flow_api.create_message (
  p_id=>195923621938152235 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.PARENT_ORDER_BY',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_detail_order_by
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Detail-Tabelle %0 anordnen nach';

wwv_flow_api.create_message (
  p_id=>195923716506152235 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.DETAIL_ORDER_BY',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_inc_bread_crumb
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Navigationspfad einbeziehen';

wwv_flow_api.create_message (
  p_id=>195923832255152235 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.INC_BREAD_CRUMB',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_menu_root
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Navigationspfad-Root';

wwv_flow_api.create_message (
  p_id=>195923920479152235 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.MENU_ROOT',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_parent_menu_col
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Übergeordnete Navigationspfadspalte';

wwv_flow_api.create_message (
  p_id=>195924031311152236 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.PARENT_MENU_COL',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_detail_menu_col
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Detail-Navigationspfadspalte';

wwv_flow_api.create_message (
  p_id=>195924112139152236 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.DETAIL_MENU_COL',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_create_summary_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Sie haben das Erstellen einer Zusammenfassungsseite mit folgenden Attributen angefordert. Klicken Sie auf <b>Weitere hinzufügen</b>, um zusätzliche Elemente von anderen Seiten und/oder Regionen hinzuzufügen. Klicken Sie auf <b>Beenden</b>, um die Zusammenfassungselemente zu erstellen.';

wwv_flow_api.create_message (
  p_id=>195924214872152236 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CREATE_SUMMARY_PAGE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_copy_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Sie haben das Kopieren einer Seite mit folgenden Attributen angefordert. Bitte bestätigen Sie Ihre Auswahl.';

wwv_flow_api.create_message (
  p_id=>195924316818152236 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.COPY_PAGE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_create_report_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Sie haben das Erstellen einer Berichtsseite mit folgenden Attributen angefordert. Bitte bestätigen Sie Ihre Auswahl.';

wwv_flow_api.create_message (
  p_id=>195924428365152236 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CREATE_REPORT_PAGE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_tab_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Registerkartenname';

wwv_flow_api.create_message (
  p_id=>195924509708152236 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.TAB_NAME',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_create_easy_report
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Sie haben das Erstellen einer Berichtsseite mit folgenden Attributen angefordert. Bitte bestätigen Sie Ihre Auswahl.';

wwv_flow_api.create_message (
  p_id=>195924611792152237 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CREATE_EASY_REPORT',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_report_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Berichts-Template';

wwv_flow_api.create_message (
  p_id=>195924715852152237 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.REPORT_TEMPLATE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_sort_option
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Sortieroption';

wwv_flow_api.create_message (
  p_id=>195924830070152237 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.SORT_OPTION',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_rpt_template_name1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Standard: HTML (Standard)';

wwv_flow_api.create_message (
  p_id=>195924905594152237 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.RPT_TEMPLATE_NAME1',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_rpt_template_name2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Standard: vertikaler Bericht, Darstellung 1 (Null-Spalten ausschließen)';

wwv_flow_api.create_message (
  p_id=>195925019024152237 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.RPT_TEMPLATE_NAME2',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_rpt_template_name3
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Standard: vertikaler Bericht, Darstellung 1 (Null-Spalten einbeziehen)';

wwv_flow_api.create_message (
  p_id=>195925122434152238 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.RPT_TEMPLATE_NAME3',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_rpt_template_name11
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Standard: Darstellung 1';

wwv_flow_api.create_message (
  p_id=>195925209276152238 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.RPT_TEMPLATE_NAME11',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_rpt_template_name12
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Standard: Darstellung 2';

wwv_flow_api.create_message (
  p_id=>195925301639152238 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.RPT_TEMPLATE_NAME12',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_rpt_template_name21
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Exportieren: CSV';

wwv_flow_api.create_message (
  p_id=>195925425448152238 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.RPT_TEMPLATE_NAME21',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_rpt_template_name22
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Exportieren: XML';

wwv_flow_api.create_message (
  p_id=>195925501332152238 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.RPT_TEMPLATE_NAME22',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Template:';

wwv_flow_api.create_message (
  p_id=>195925621448152238 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.TEMPLATE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_col_head_sorting
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Sortierung nach Spaltenüberschriften';

wwv_flow_api.create_message (
  p_id=>195925714745152239 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.COL_HEAD_SORTING',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_create_application
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Sie haben das Erstellen einer Anwendung mit folgenden Attributen angefordert. Bitte bestätigen Sie Ihre Auswahl.';

wwv_flow_api.create_message (
  p_id=>195925815544152239 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CREATE_APPLICATION',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_application_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Name';

wwv_flow_api.create_message (
  p_id=>195925915880152239 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.APPLICATION_NAME',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_application_alias
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Aliasname';

wwv_flow_api.create_message (
  p_id=>195926018623152239 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.APPLICATION_ALIAS',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_application_default_lang
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Standardsprache';

wwv_flow_api.create_message (
  p_id=>195926124832152239 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.APPLICATION_DEFAULT_LANG',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_authentication
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Authentifizierung';

wwv_flow_api.create_message (
  p_id=>195926215203152240 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.AUTHENTICATION',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_pages
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Seiten';

wwv_flow_api.create_message (
  p_id=>195926328009152240 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.PAGES',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_tabs
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Registerkarten';

wwv_flow_api.create_message (
  p_id=>195926400855152240 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.TABS',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_nav_bar
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Navigationsleiste';

wwv_flow_api.create_message (
  p_id=>195926515798152240 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.NAV_BAR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_ui_theme
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Theme';

wwv_flow_api.create_message (
  p_id=>195926619824152240 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.UI_THEME',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_ui_theme1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Blau und Gelbbraun';

wwv_flow_api.create_message (
  p_id=>195926713985152240 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.UI_THEME1',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_ui_theme2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Rot';

wwv_flow_api.create_message (
  p_id=>195926824858152241 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.UI_THEME2',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_ui_theme4
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Marineblau und Grau';

wwv_flow_api.create_message (
  p_id=>195926918333152241 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.UI_THEME4',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_ui_theme5
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Olivgrün';

wwv_flow_api.create_message (
  p_id=>195927020803152241 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.UI_THEME5',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_ui_theme6
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Kastanienbraun';

wwv_flow_api.create_message (
  p_id=>195927118006152241 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.UI_THEME6',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_ui_theme7
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Einfaches Blau und Gelbbraun';

wwv_flow_api.create_message (
  p_id=>195927231994152241 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.UI_THEME7',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_ui_theme8
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Blau';

wwv_flow_api.create_message (
  p_id=>195927314293152241 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.UI_THEME8',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_ui_theme_none
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Keine';

wwv_flow_api.create_message (
  p_id=>195927402364152242 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.UI_THEME_NONE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message label_template_copied
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Kopiert aus Anwendung';

wwv_flow_api.create_message (
  p_id=>195927511554152242 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LABEL_TEMPLATE.COPIED',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message label_template_master
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Dies ist die "Master"-Kopie dieses Templates.';

wwv_flow_api.create_message (
  p_id=>195927631126152242 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LABEL_TEMPLATE.MASTER',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message label_template_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Label-Templates, die dieses Template referenzieren';

wwv_flow_api.create_message (
  p_id=>195927704732152242 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LABEL_TEMPLATE.REFERENCE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message label_template_no_subscription
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Keine Templates abonnieren dieses Template.';

wwv_flow_api.create_message (
  p_id=>195927826541152242 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LABEL_TEMPLATE.NO_SUBSCRIPTION',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message auth_current_auth_method
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Aktuelle Authentifizierungsmethode';

wwv_flow_api.create_message (
  p_id=>195927932631152243 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'AUTH.CURRENT_AUTH_METHOD',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message auth_login_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Anmeldeseite';

wwv_flow_api.create_message (
  p_id=>195928008652152243 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'AUTH.LOGIN_PAGE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message auth_none
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Kein Eintrag';

wwv_flow_api.create_message (
  p_id=>195928102985152243 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'AUTH.NONE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message auth_login_url
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Anmelde-URL';

wwv_flow_api.create_message (
  p_id=>195928216130152243 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'AUTH.LOGIN_URL',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message auth_custom_auth_function
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Funktion für eine benutzerdefinierte Authentifizierung';

wwv_flow_api.create_message (
  p_id=>195928314001152243 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'AUTH.CUSTOM_AUTH_FUNCTION',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message auth_confirm_migrate
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Sie sind im Begriff, die benutzerdefinierten Authentifizierungsoptionen zu einem Authentifizierungsschema zu migrieren.';

wwv_flow_api.create_message (
  p_id=>195928402943152243 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'AUTH.CONFIRM_MIGRATE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_value_required
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Wert muss angegeben werden.';

wwv_flow_api.create_message (
  p_id=>195928525515152244 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000.VALUE_REQUIRED',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message conditions_shortcut_plsql
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'PL/SQL';

wwv_flow_api.create_message (
  p_id=>195928608747152244 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONDITIONS_SHORTCUT_PLSQL',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message conditions_shortcut_item_e_val
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'item=value';

wwv_flow_api.create_message (
  p_id=>195928703964152244 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONDITIONS_SHORTCUT_ITEM_E_VAL',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message conditions_shortcut_item_not_null
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Element nicht Null';

wwv_flow_api.create_message (
  p_id=>195928810410152244 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONDITIONS_SHORTCUT_ITEM_NOT_NULL',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message conditions_shortcut_req_e_e1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'request=e1';

wwv_flow_api.create_message (
  p_id=>195928905758152244 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONDITIONS_SHORTCUT_REQ_E_E1',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message conditions_shortcut_page_in
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Seite in';

wwv_flow_api.create_message (
  p_id=>195929000333152245 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONDITIONS_SHORTCUT_PAGE_IN',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message conditions_shortcut_page_not_in
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Seite nicht in';

wwv_flow_api.create_message (
  p_id=>195929124937152245 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONDITIONS_SHORTCUT_PAGE_NOT_IN',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message conditions_shortcut_exists
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'vorhanden';

wwv_flow_api.create_message (
  p_id=>195929229349152245 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONDITIONS_SHORTCUT_EXISTS',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message conditions_shortcut_never
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Niemals';

wwv_flow_api.create_message (
  p_id=>195929331375152245 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONDITIONS_SHORTCUT_NEVER',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message conditions_shortcut_none
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Kein Eintrag';

wwv_flow_api.create_message (
  p_id=>195929420138152245 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONDITIONS_SHORTCUT_NONE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message p688_text
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Geben Sie die Komponenten einer Anwendung an, die exportiert werden sollen. Dieser Export kann zu Backup-Zwecken oder zum Laden dieser Komponenten in eine andere Instanz verwendet werden.';

wwv_flow_api.create_message (
  p_id=>195929511212152245 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'P688_TEXT',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_object_exists
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'vorhanden';

wwv_flow_api.create_message (
  p_id=>195929607095152246 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.OBJECT_EXISTS',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_object_not_exists
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'nicht vorhanden ist';

wwv_flow_api.create_message (
  p_id=>195929710930152246 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.OBJECT_NOT_EXISTS',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_create_web_services
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erstellen Sie eine Beispielanwendung für die Demonstration von Web Services.';

wwv_flow_api.create_message (
  p_id=>195929814286152246 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.CREATE_WEB_SERVICES',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_create_business_look
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Sie sind im Begriff, die Business Look-Demoanwendung (neu) zu erstellen.';

wwv_flow_api.create_message (
  p_id=>195929921465152246 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.CREATE_BUSINESS_LOOK',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_create_worldcup_mania
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Sie sind im Begriff, die WorldCup Mania-Demoanwendung zu erstellen.';

wwv_flow_api.create_message (
  p_id=>195930029406152246 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.CREATE_WORLDCUP_MANIA',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_object_recreate
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Folgende Datenbankobjekte werden neu erstellt, falls sie vorhanden sind';

wwv_flow_api.create_message (
  p_id=>195930122368152246 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.OBJECT_RECREATE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_schema
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Schema';

wwv_flow_api.create_message (
  p_id=>195930216124152247 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.SCHEMA',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_object_type
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Objekttyp';

wwv_flow_api.create_message (
  p_id=>195930320478152247 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.OBJECT_TYPE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_object_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Name';

wwv_flow_api.create_message (
  p_id=>195930426074152247 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.OBJECT_NAME',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_object_exist
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Vorhanden';

wwv_flow_api.create_message (
  p_id=>195930523349152247 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.OBJECT_EXIST',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_table
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Tabelle';

wwv_flow_api.create_message (
  p_id=>195930616600152247 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.TABLE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_application_reserved
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Die Anwendungs-IDs von 3000 bis 8999 sind reserviert.';

wwv_flow_api.create_message (
  p_id=>195930715491152248 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000.APPLICATION_RESERVED',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_sequence
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Sequence';

wwv_flow_api.create_message (
  p_id=>195930819840152248 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.SEQUENCE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_trigger
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Trigger';

wwv_flow_api.create_message (
  p_id=>195930911945152248 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.TRIGGER',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_package
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Package';

wwv_flow_api.create_message (
  p_id=>195931012886152248 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.PACKAGE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_create_basic
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Sie sind im Begriff, die Basic Examples-Demoanwendung zu erstellen.';

wwv_flow_api.create_message (
  p_id=>195931105472152248 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.CREATE_BASIC',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_create_collection_showcase
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Sie sind im Begriff, eine Collections Showcase-Demoanwendung zu erstellen.';

wwv_flow_api.create_message (
  p_id=>195931228733152248 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.CREATE_COLLECTION_SHOWCASE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_create_or_recreate
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'In Schema %0 erstellen oder neu erstellen';

wwv_flow_api.create_message (
  p_id=>195931305902152249 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.CREATE_OR_RECREATE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p19_validation
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Es muss mindestens ein Element angegeben werden, um eine NOT NULL-Validierung zu erstellen.';

wwv_flow_api.create_message (
  p_id=>195931408930152249 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000.P19.VALIDATION',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_object_name2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Objektname';

wwv_flow_api.create_message (
  p_id=>195931504447152249 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.OBJECT_NAME2',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_basic_lexer
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'BASIC_LEXER';

wwv_flow_api.create_message (
  p_id=>195931626345152249 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.BASIC_LEXER',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_context_index
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'CONTEXT INDEX';

wwv_flow_api.create_message (
  p_id=>195931711467152249 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.CONTEXT_INDEX',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_header_validation1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Header muss <b> &lt;head&gt;</b>- und <b>&lt;/head&gt;</b>-Tags enthalten.';

wwv_flow_api.create_message (
  p_id=>195931820177152249 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000.HEADER_VALIDATION1',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_application
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Anwendung';

wwv_flow_api.create_message (
  p_id=>195931923154152250 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.APPLICATION',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_need_7m
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Für das Presidential Inaugural Address-Demo sind etwa 7 MB freier Speicherplatz erforderlich. Die Installation in Ihr Schema dauert ungefähr zwei Minuten.';

wwv_flow_api.create_message (
  p_id=>195932020430152250 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.NEED_7M',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_header_validation2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'<b>#HEAD#</b>-Ersetzungszeichenfolge muss zwischen den <b> &lt;head&gt;</b>- und <b>&lt;/head&gt;</b>-Tags angezeigt werden.';

wwv_flow_api.create_message (
  p_id=>195932105335152250 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000.HEADER_VALIDATION2',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_free_space
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Es stehen Ihnen etwa %0 MB zur Verfügung.';

wwv_flow_api.create_message (
  p_id=>195932219975152250 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.FREE_SPACE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_will_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Es tritt gegebenenfalls ein Fehler auf, wenn Sie diese Demo nicht neu erstellen.';

wwv_flow_api.create_message (
  p_id=>195932308023152250 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.WILL_ERROR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p818_validation
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Es muss mindestens ein Schema für den Kopiervorgang ausgewählt werden.';

wwv_flow_api.create_message (
  p_id=>195932431736152251 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000.P818.VALIDATION',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_template_name_mand
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Der Template-Name muss angegeben werden.';

wwv_flow_api.create_message (
  p_id=>195932502425152251 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000.TEMPLATE_NAME_MAND',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_template_copied_from
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Kopiert aus Anwendung';

wwv_flow_api.create_message (
  p_id=>195932610986152251 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_TEMPLATE.COPIED_FROM',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_template_popup_lov
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Template für Popup-Werteliste';

wwv_flow_api.create_message (
  p_id=>195932714954152251 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_TEMPLATE.POPUP_LOV',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_template_master
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Dies ist die "Master"-Kopie dieses Templates.';

wwv_flow_api.create_message (
  p_id=>195932800703152251 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_TEMPLATE.MASTER',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_template_popup_lov_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Templates für Popup-Werteliste, die dieses Template referenzieren';

wwv_flow_api.create_message (
  p_id=>195932903646152251 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_TEMPLATE.POPUP_LOV_REFERENCE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_template_no_subscription
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Keine Templates abonnieren dieses Template.';

wwv_flow_api.create_message (
  p_id=>195933028039152252 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_TEMPLATE.NO_SUBSCRIPTION',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message current_application
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Aktuelle Anwendung';

wwv_flow_api.create_message (
  p_id=>195933127082152252 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CURRENT_APPLICATION',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message alias
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Aliasname';

wwv_flow_api.create_message (
  p_id=>195933226515152252 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ALIAS',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message updated
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Aktualisiert';

wwv_flow_api.create_message (
  p_id=>195933327451152252 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'UPDATED',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_template_report_template_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Berichts-Templates, die dieses Template referenzieren';

wwv_flow_api.create_message (
  p_id=>195933426372152252 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_TEMPLATE.REPORT_TEMPLATE_REFERENCE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message owner
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Eigentümer';

wwv_flow_api.create_message (
  p_id=>195933521680152252 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'OWNER',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message authentication
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Authentifizierung';

wwv_flow_api.create_message (
  p_id=>195933615880152253 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'AUTHENTICATION',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p1_edit_this_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Dieses Template bearbeiten';

wwv_flow_api.create_message (
  p_id=>195933719332152253 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P1_EDIT_THIS_TEMPLATE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p1_authentication_home
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Authentifizierung - Home';

wwv_flow_api.create_message (
  p_id=>195933818758152253 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P1_AUTHENTICATION_HOME',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Template';

wwv_flow_api.create_message (
  p_id=>195933923052152253 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'TEMPLATE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_template_menu_template_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Navigationspfad-Templates, die dieses Template referenzieren';

wwv_flow_api.create_message (
  p_id=>195934030754152253 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_TEMPLATE.MENU_TEMPLATE_REFERENCE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_table_summary
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Demoanwendung installieren - Statusbericht';

wwv_flow_api.create_message (
  p_id=>195934106892152254 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.TABLE_SUMMARY',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_demo_app
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Demoanwendung';

wwv_flow_api.create_message (
  p_id=>195934222243152254 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.DEMO_APP',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_status
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Status';

wwv_flow_api.create_message (
  p_id=>195934325697152254 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.STATUS',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_action
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Aktion';

wwv_flow_api.create_message (
  p_id=>195934419170152254 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.ACTION',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_collection_showcase
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Collection Showcase';

wwv_flow_api.create_message (
  p_id=>195934532512152254 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.COLLECTION_SHOWCASE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_learn_about
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Wissenswertes über die Konzepte bei %0-Einkaufskorb.';

wwv_flow_api.create_message (
  p_id=>195934614154152254 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.LEARN_ABOUT',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_installed
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Installiert';

wwv_flow_api.create_message (
  p_id=>195934716098152255 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.INSTALLED',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_run
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Ausführen';

wwv_flow_api.create_message (
  p_id=>195934821777152255 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.RUN',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_not_installed
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Nicht installiert';

wwv_flow_api.create_message (
  p_id=>195934901854152255 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.NOT_INSTALLED',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_install
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Installieren';

wwv_flow_api.create_message (
  p_id=>195935015152152255 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.INSTALL',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Seite';

wwv_flow_api.create_message (
  p_id=>195935110190152255 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PAGE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message title
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Überschrift';

wwv_flow_api.create_message (
  p_id=>195935229771152255 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'TITLE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message security
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Sicherheit';

wwv_flow_api.create_message (
  p_id=>195935328827152256 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SECURITY',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message standard_tab_set
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Standard-Registerkartengruppe';

wwv_flow_api.create_message (
  p_id=>195935407486152256 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'STANDARD_TAB_SET',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_petstore
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Petstore';

wwv_flow_api.create_message (
  p_id=>195935507177152256 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.PETSTORE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_about_petstore
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Beispiel für einen Online-Store, der mit %0 erstellt wurde.';

wwv_flow_api.create_message (
  p_id=>195935629776152256 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.ABOUT_PETSTORE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_install_now
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Jetzt installieren';

wwv_flow_api.create_message (
  p_id=>195935706196152256 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.INSTALL_NOW',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_business_look
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Business Look';

wwv_flow_api.create_message (
  p_id=>195935802810152256 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.BUSINESS_LOOK',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_about_business_look
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Beispiele für stabile Berichte und Konzepte für die Seitennummerierung.';

wwv_flow_api.create_message (
  p_id=>195935906139152257 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.ABOUT_BUSINESS_LOOK',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_web_services
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Web Services';

wwv_flow_api.create_message (
  p_id=>195936001159152257 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.WEB_SERVICES',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_about_webservices
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Wissenswertes über die Verwendung der Web Services mit %0.';

wwv_flow_api.create_message (
  p_id=>195936131059152257 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.ABOUT_WEBSERVICES',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_presidential
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Presidential Inaugural Addresses';

wwv_flow_api.create_message (
  p_id=>195936200499152257 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.PRESIDENTIAL',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_about_presidential
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Wissenswertes über das Verwenden von Oracle Text mit %0.';

wwv_flow_api.create_message (
  p_id=>195936318862152258 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.ABOUT_PRESIDENTIAL',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p88_select_time
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Wählen Sie die Uhrzeit, zu der Sie zurückkehren möchten. Klicken Sie anschließend auf die Quelle, um das gewünschte Element aufzufüllen und diese Seite zu schließen.';

wwv_flow_api.create_message (
  p_id=>195936408148152258 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P88_SELECT_TIME',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_project_tracking
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Projektprotokollierung';

wwv_flow_api.create_message (
  p_id=>195936521157152258 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.PROJECT_TRACKING',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p88_flashback_query
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Das Undo Feature von %0 verwendet das integrierte Datenbank-Feature "Flashback Query", mit dem Sie die Daten zeitorientiert abfragen können.';

wwv_flow_api.create_message (
  p_id=>195936619761152258 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P88_FLASHBACK_QUERY',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_about_proj_tracking
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Beispiel einer Anwendung zur Protokollierung des Projektstatus, die mit %0 erstellt wurde.';

wwv_flow_api.create_message (
  p_id=>195936728707152258 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.ABOUT_PROJ_TRACKING',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p88_undo_retention
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Sie können - basierend auf dem Datenbankparameter UNDO_RETENTION - nur Änderungen rückgängig machen, die innerhalb der letzten %0 Stunde(n) vorgenommen wurden.';

wwv_flow_api.create_message (
  p_id=>195936821147152259 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P88_UNDO_RETENTION',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_item_help_copied_from
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Kopiert aus Anwendung';

wwv_flow_api.create_message (
  p_id=>195936920154152259 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_ITEM_HELP.COPIED_FROM',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_item_help_master
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Hierbei handelt es sich um die "Master"-Kopie dieser Elementhilfe.';

wwv_flow_api.create_message (
  p_id=>195937011996152259 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_ITEM_HELP.MASTER',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_item_help_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Elemente, die diesen Elementhilfetext referenzieren';

wwv_flow_api.create_message (
  p_id=>195937125589152259 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_ITEM_HELP.REFERENCE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_item_help_no_subscription
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Keine Elemente abonnieren diesen Text für die Elementhilfe.';

wwv_flow_api.create_message (
  p_id=>195937202837152259 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_ITEM_HELP.NO_SUBSCRIPTION',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p92_confirm_create_std_tab
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erstellen von Standardregisterkarte in Anwendung bestätigen';

wwv_flow_api.create_message (
  p_id=>195937319390152260 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P92_CONFIRM_CREATE_STD_TAB',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p92_tabset_info_incomplete
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Warnung. Informationen zur Registerkartengruppe sind unvollständig.';

wwv_flow_api.create_message (
  p_id=>195937400555152260 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P92_TABSET_INFO_INCOMPLETE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_authorization_copied_from
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Kopiert aus Anwendung';

wwv_flow_api.create_message (
  p_id=>195937501329152260 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_AUTHORIZATION.COPIED_FROM',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p92_page_will_use_existng_tabset
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Seite %0 verwendet die vorhandene Registerkartengruppe "%1".';

wwv_flow_api.create_message (
  p_id=>195937624530152260 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P92_PAGE_WILL_USE_EXISTNG_TABSET',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p92_new_tabset_will_be_created
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Es wird eine neue Registerkartengruppe %0 erstellt.';

wwv_flow_api.create_message (
  p_id=>195937707798152260 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P92_NEW_TABSET_WILL_BE_CREATED',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_authorization_master
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Hierbei handelt es sich um die "Master"-Kopie dieses Autorisierungsschemas.';

wwv_flow_api.create_message (
  p_id=>195937824976152261 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_AUTHORIZATION.MASTER',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_authorization_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Autorisierungsschemas, die dieses Autorisierungsschema referenzieren';

wwv_flow_api.create_message (
  p_id=>195937902676152261 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_AUTHORIZATION.REFERENCE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_authorization_no_subscription
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Keine Autorisierungsschemas abonnieren dieses Autorisierungsschema.';

wwv_flow_api.create_message (
  p_id=>195938030863152261 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_AUTHORIZATION.NO_SUBSCRIPTION',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_change_password_psswd_not_supplied
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Es müssen das Kennwort und die Kennwortbestätigung angegeben werden.';

wwv_flow_api.create_message (
  p_id=>195938127774152261 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CHANGE_PASSWORD.PSSWD_NOT_SUPPLIED',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_change_password_psswd_no_match
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Die Kennwörter stimmen nicht überein. Führen Sie den Vorgang erneut aus.';

wwv_flow_api.create_message (
  p_id=>195938207458152261 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CHANGE_PASSWORD.PSSWD_NO_MATCH',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_shortcut_copied_from
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Kopiert aus Anwendung';

wwv_flow_api.create_message (
  p_id=>195938327974152262 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_SHORTCUT.COPIED_FROM',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_change_password_psswd_chg_only_yours
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Sie können nur Ihr eigenes Kennwort ändern.';

wwv_flow_api.create_message (
  p_id=>195938401338152262 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CHANGE_PASSWORD.PSSWD_CHG_ONLY_YOURS',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_shortcut_master
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Hierbei handelt es sich um die "Master"-Kopie dieses Shortcuts.';

wwv_flow_api.create_message (
  p_id=>195938531169152262 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_SHORTCUT.MASTER',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_change_password_psswd_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unerwarteter Fehler beim Verarbeiten Ihres Requests zur Kennwortänderung: %0';

wwv_flow_api.create_message (
  p_id=>195938603402152262 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CHANGE_PASSWORD.PSSWD_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_shortcut_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Shortcuts, die diesen Shortcut referenzieren';

wwv_flow_api.create_message (
  p_id=>195938728599152262 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_SHORTCUT.REFERENCE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_shortcut_no_subscription
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Keine Shortcuts abonnieren diesen Shortcut.';

wwv_flow_api.create_message (
  p_id=>195938828484152262 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_SHORTCUT.NO_SUBSCRIPTION',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_check_err_proc_plsql
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1025 Fehler beim Verarbeiten von PL/SQL-Ausdruck: %0';

wwv_flow_api.create_message (
  p_id=>195938901337152262 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CHECK.ERR_PROC_PLSQL',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_check_err_proc_sql
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1026 Fehler beim Verarbeiten von SQL-Ausdruck: %0';

wwv_flow_api.create_message (
  p_id=>195939003506152263 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CHECK.ERR_PROC_SQL',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message tab_set
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Registerkartengruppe';

wwv_flow_api.create_message (
  p_id=>195939130520152263 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'TAB_SET',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_check_err_orcl
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Oracle-Fehler: %0';

wwv_flow_api.create_message (
  p_id=>195939212582152263 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CHECK.ERR_ORCL',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message tab_text
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Registerkartentext';

wwv_flow_api.create_message (
  p_id=>195939304328152263 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'TAB_TEXT',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message current_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Aktuelle Seite';

wwv_flow_api.create_message (
  p_id=>195939411371152263 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CURRENT_PAGE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_lov_copied_from
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Kopiert aus Anwendung';

wwv_flow_api.create_message (
  p_id=>195939514524152263 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_LOV.COPIED_FROM',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_lov_master
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Dies ist die "Master"-Kopie dieser Werteliste.';

wwv_flow_api.create_message (
  p_id=>195939600054152264 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_LOV.MASTER',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_lov_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Wertelisten, die diese Werteliste referenzieren';

wwv_flow_api.create_message (
  p_id=>195939712567152264 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_LOV.REFERENCE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_lov_no_subscription
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Keine Wertelisten abonnieren diese Werteliste.';

wwv_flow_api.create_message (
  p_id=>195939822877152264 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_LOV.NO_SUBSCRIPTION',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message parent_tab_set
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Übergeordnete Registerkartengruppe';

wwv_flow_api.create_message (
  p_id=>195939929199152264 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PARENT_TAB_SET',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message parent_tab_set_new
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Neue übergeordnete Registerkartengruppe';

wwv_flow_api.create_message (
  p_id=>195940013484152264 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PARENT_TAB_SET_NEW',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message parent_tab_text
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Text in übergeordneter Registerkarte';

wwv_flow_api.create_message (
  p_id=>195940116079152264 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PARENT_TAB_TEXT',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message tab_sequence
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Registerkarten-Sequence';

wwv_flow_api.create_message (
  p_id=>195940208692152265 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'TAB_SEQUENCE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message current_image
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Aktuelles Bild';

wwv_flow_api.create_message (
  p_id=>195940311382152265 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CURRENT_IMAGE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_template_page_template_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Seiten-Templates, die dieses Template referenzieren';

wwv_flow_api.create_message (
  p_id=>195940407152152265 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_TEMPLATE.PAGE_TEMPLATE_REFERENCE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message non_current_image
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Bild für nicht aktuelles Element';

wwv_flow_api.create_message (
  p_id=>195940502453152265 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'NON_CURRENT_IMAGE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message image_attributes
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Bildattribute';

wwv_flow_api.create_message (
  p_id=>195940617672152265 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'IMAGE_ATTRIBUTES',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message display_condition
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Anzeigebedingung';

wwv_flow_api.create_message (
  p_id=>195940717544152265 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DISPLAY_CONDITION',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message condition_type
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Bedingungstyp';

wwv_flow_api.create_message (
  p_id=>195940808486152266 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONDITION_TYPE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message display_condition_text
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Bedingungstext anzeigen';

wwv_flow_api.create_message (
  p_id=>195940925705152266 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DISPLAY_CONDITION_TEXT',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_navbar_copied_from
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Kopiert aus Anwendung';

wwv_flow_api.create_message (
  p_id=>195941011022152266 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_NAVBAR.COPIED_FROM',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4300_f4500_table_already_exists
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Der Tabellenname ist bereits vorhanden.';

wwv_flow_api.create_message (
  p_id=>195941113132152266 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4300.F4500.TABLE_ALREADY_EXISTS',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message build_option
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erstelloption';

wwv_flow_api.create_message (
  p_id=>195941230716152266 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'BUILD_OPTION',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_navbar_master
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Hierbei handelt es sich um die "Master"-Kopie dieser Navigationsleiste.';

wwv_flow_api.create_message (
  p_id=>195941310753152266 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_NAVBAR.MASTER',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4300_col_length_not_zero
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Die Spaltenlänge darf nicht Null sein.';

wwv_flow_api.create_message (
  p_id=>195941403710152267 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4300.COL_LENGTH_NOT_ZERO',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4300_col_length_not_null
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Die Spaltenlänge darf nicht Null sein.';

wwv_flow_api.create_message (
  p_id=>195941521652152267 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4300.COL_LENGTH_NOT_NULL',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_navbar_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Navigationsleisten, die diese Navigationsleiste referenzieren';

wwv_flow_api.create_message (
  p_id=>195941613747152267 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_NAVBAR.REFERENCE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4300_col_names_not_longer_than_30
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Spaltennamen dürfen nicht mehr als 30 Zeichen enthalten.';

wwv_flow_api.create_message (
  p_id=>195941705186152267 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4300.COL_NAMES_NOT_LONGER_THAN_30',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4300_col_names_not_null
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Spaltennamen dürfen nicht Null sein.';

wwv_flow_api.create_message (
  p_id=>195941824708152267 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4300.COL_NAMES_NOT_NULL',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_navbar_no_subscription
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Keine Navigationsleisten abonnieren diese Navigationsleiste.';

wwv_flow_api.create_message (
  p_id=>195941909882152267 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_NAVBAR.NO_SUBSCRIPTION',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4300_table_names_not_longer_than_30
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Tabellennamen müssen kürzer als 30 Zeichen sein.';

wwv_flow_api.create_message (
  p_id=>195942001132152268 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4300.TABLE_NAMES_NOT_LONGER_THAN_30',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4300_not_valid_pk_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'<b>%0</b> ist kein gültiger Primärschlüsselname.';

wwv_flow_api.create_message (
  p_id=>195942100768152268 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4300.NOT_VALID_PK_NAME',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p173_no_help
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Für dieses Element ist keine Hilfe verfügbar';

wwv_flow_api.create_message (
  p_id=>195942213802152268 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P173_NO_HELP',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4300_f4500_name_already_used
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Der Name <b>%0</b> wird bereits von einem vorhandenen Objekt verwendet.';

wwv_flow_api.create_message (
  p_id=>195942316088152268 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4300.F4500.NAME_ALREADY_USED',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_err_lov
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1000 Bestimmen der Werteliste aus "declare function x return varchar2 is begin %0 return null; end; begin wwv_flow_utilities.g_query := x; end;" nicht möglich.';

wwv_flow_api.create_message (
  p_id=>195942423733152268 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.ERR_LOV',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4300_f4500_not_valid_seq_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'<b>%0</b> ist kein gültiger Sequence-Name.';

wwv_flow_api.create_message (
  p_id=>195942503575152268 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4300.F4500.NOT_VALID_SEQ_NAME',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_add
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Hinzufügen';

wwv_flow_api.create_message (
  p_id=>195942618501152269 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.ADD',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4500_not_valid_table_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'<b>%0</b> ist kein gültiger Tabellenname.';

wwv_flow_api.create_message (
  p_id=>195942728716152269 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4500.NOT_VALID_TABLE_NAME',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_remove
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Entfernen';

wwv_flow_api.create_message (
  p_id=>195942829012152269 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.REMOVE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4500_not_valid_object_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'<b>%0</b> ist kein gültiger Objektname.';

wwv_flow_api.create_message (
  p_id=>195942932265152269 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4500.NOT_VALID_OBJECT_NAME',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4500_table_not_found_in_schema
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Tabelle <b>%0</b> wurde in Schema <b>%1</b> nicht gefunden.';

wwv_flow_api.create_message (
  p_id=>195943022367152269 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4500.TABLE_NOT_FOUND_IN_SCHEMA',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_no_matches
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Keine Übereinstimmungen.';

wwv_flow_api.create_message (
  p_id=>195943124109152269 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.NO_MATCHES',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_prev
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Zurück';

wwv_flow_api.create_message (
  p_id=>195943214674152270 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.PREV',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4500_need_unique_execution_order
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Geben Sie die eindeutige Nummer für die Ausführungsreihenfolge ein.';

wwv_flow_api.create_message (
  p_id=>195943302490152270 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4500.NEED_UNIQUE_EXECUTION_ORDER',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p204_copied_from_app
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Kopiert aus Anwendung';

wwv_flow_api.create_message (
  p_id=>195943430437152270 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P204_COPIED_FROM_APP',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_next
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Weiter';

wwv_flow_api.create_message (
  p_id=>195943531176152270 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.NEXT',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_cal
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Kalender';

wwv_flow_api.create_message (
  p_id=>195943617484152270 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.CAL',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_close
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Schließen';

wwv_flow_api.create_message (
  p_id=>195943728905152271 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.CLOSE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_ok
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'OK';

wwv_flow_api.create_message (
  p_id=>195943805201152271 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.OK',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_search_dialog
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Dialogfeld "Suche"';

wwv_flow_api.create_message (
  p_id=>195943908991152271 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.SEARCH_DIALOG',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_find
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Find%0';

wwv_flow_api.create_message (
  p_id=>195944017654152271 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.FIND',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_template_region_template_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Regions-Templates, die dieses Template referenzieren';

wwv_flow_api.create_message (
  p_id=>195944121457152271 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_TEMPLATE.REGION_TEMPLATE_REFERENCE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_js_no_support
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'JavaScript wird nicht unterstützt';

wwv_flow_api.create_message (
  p_id=>195944216666152271 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.JS_NO_SUPPORT',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p204_master_copy
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Dies ist die "Master"-Kopie dieses Templates.';

wwv_flow_api.create_message (
  p_id=>195944327811152272 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P204_MASTER_COPY',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_list
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Liste';

wwv_flow_api.create_message (
  p_id=>195944432240152272 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.LIST',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_template_list_template_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Listen-Templates, die dieses Template referenzieren';

wwv_flow_api.create_message (
  p_id=>195944524896152272 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_TEMPLATE.LIST_TEMPLATE_REFERENCE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p204_button_templ
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Schaltflächen-Templates, die dieses Template referenzieren';

wwv_flow_api.create_message (
  p_id=>195944603355152272 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P204_BUTTON_TEMPL',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p204_no_subscirbers
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Keine Templates abonnieren dieses Template.';

wwv_flow_api.create_message (
  p_id=>195944715216152272 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P204_NO_SUBSCIRBERS',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_lov2_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fehler: %0 beim Ausführen der Wertelisten-Abfrage: "%1".';

wwv_flow_api.create_message (
  p_id=>195944831949152272 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.LOV2_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message select_region_template_theme
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Theme';

wwv_flow_api.create_message (
  p_id=>195944914358152273 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SELECT_REGION_TEMPLATE.THEME',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message select_page_template_theme
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Theme';

wwv_flow_api.create_message (
  p_id=>195945032066152273 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SELECT_PAGE_TEMPLATE.THEME',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message select_list_template_theme
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Theme';

wwv_flow_api.create_message (
  p_id=>195945116616152273 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SELECT_LIST_TEMPLATE.THEME',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message select_label_template_theme
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Theme';

wwv_flow_api.create_message (
  p_id=>195945220321152273 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SELECT_LABEL_TEMPLATE.THEME',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message select_report_template_theme
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Theme';

wwv_flow_api.create_message (
  p_id=>195945306144152273 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SELECT_REPORT_TEMPLATE.THEME',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_process_page_items
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Seitenelemente';

wwv_flow_api.create_message (
  p_id=>195945427258152273 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_PROCESS.PAGE_ITEMS',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_process_region
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Region';

wwv_flow_api.create_message (
  p_id=>195945502452152274 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_PROCESS.REGION',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message template_utilization_default_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Als Anwendungs-Standard-Template referenziert.';

wwv_flow_api.create_message (
  p_id=>195945608011152274 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'TEMPLATE_UTILIZATION.DEFAULT_TEMPLATE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message template_utilization_printer_friendly_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Wird als Druckversions-Template referenziert.';

wwv_flow_api.create_message (
  p_id=>195945715734152274 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'TEMPLATE_UTILIZATION.PRINTER_FRIENDLY_TEMPLATE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message template_utilization_error_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Als Fehler-Template referenziert.';

wwv_flow_api.create_message (
  p_id=>195945821722152274 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'TEMPLATE_UTILIZATION.ERROR_TEMPLATE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message template_utilization_page_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Referenziert in Seite(n)';

wwv_flow_api.create_message (
  p_id=>195945907479152274 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'TEMPLATE_UTILIZATION.PAGE_REFERENCE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message template_utilization_not_referenced
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Dieses Seiten-Template wird NICHT referenziert.';

wwv_flow_api.create_message (
  p_id=>195946024516152274 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'TEMPLATE_UTILIZATION.NOT_REFERENCED',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message template_utilization_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Dieses Seiten-Template';

wwv_flow_api.create_message (
  p_id=>195946101267152275 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'TEMPLATE_UTILIZATION.PAGE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message page_region_tree_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Baumname';

wwv_flow_api.create_message (
  p_id=>195946230479152275 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PAGE_REGION.TREE_NAME',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message page_region_tree_type
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Typ';

wwv_flow_api.create_message (
  p_id=>195946327700152275 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PAGE_REGION.TREE_TYPE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message page_region_tree_item
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Element';

wwv_flow_api.create_message (
  p_id=>195946431142152275 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PAGE_REGION.TREE_ITEM',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message page_region_tree_query
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Baumabfrage';

wwv_flow_api.create_message (
  p_id=>195946512660152275 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PAGE_REGION.TREE_QUERY',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message page_region_query_show_source
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Quelle anzeigen';

wwv_flow_api.create_message (
  p_id=>195946609734152275 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PAGE_REGION.QUERY_SHOW_SOURCE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message page_region_query_hide_source
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Quelle ausblenden';

wwv_flow_api.create_message (
  p_id=>195946701570152276 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PAGE_REGION.QUERY_HIDE_SOURCE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message page_region_list_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Name';

wwv_flow_api.create_message (
  p_id=>195946808640152276 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PAGE_REGION.LIST_NAME',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message page_region_list_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Listen-Template';

wwv_flow_api.create_message (
  p_id=>195946929236152276 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PAGE_REGION.LIST_TEMPLATE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message page_region_list_item_seq
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Sequence';

wwv_flow_api.create_message (
  p_id=>195947018654152276 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PAGE_REGION.LIST_ITEM_SEQ',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message page_region_list_item_text
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Text';

wwv_flow_api.create_message (
  p_id=>195947121933152276 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PAGE_REGION.LIST_ITEM_TEXT',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message page_region_list_item_target
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Ziel';

wwv_flow_api.create_message (
  p_id=>195947217753152276 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PAGE_REGION.LIST_ITEM_TARGET',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_page_item_page_items
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Seitenelemente';

wwv_flow_api.create_message (
  p_id=>195947300934152276 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_PAGE_ITEM.PAGE_ITEMS',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_page_item_region
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Region';

wwv_flow_api.create_message (
  p_id=>195947429966152277 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_PAGE_ITEM.REGION',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_page_item_set_region
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Klicken Sie hier, um die Region festzulegen';

wwv_flow_api.create_message (
  p_id=>195947523984152277 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_PAGE_ITEM.SET_REGION',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_page_item_prompt
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Prompt';

wwv_flow_api.create_message (
  p_id=>195947614594152277 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_PAGE_ITEM.PROMPT',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_page_item_no_item_found
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Keine Elemente gefunden';

wwv_flow_api.create_message (
  p_id=>195947701971152277 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_PAGE_ITEM.NO_ITEM_FOUND',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message prefs_apply_permissions
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Berechtigungen anwenden';

wwv_flow_api.create_message (
  p_id=>195947831443152277 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PREFS_APPLY_PERMISSIONS',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message sql_report_wiz_display_value
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Anzeigewert';

wwv_flow_api.create_message (
  p_id=>195947913200152278 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SQL_REPORT_WIZ.DISPLAY_VALUE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message sql_report_wiz_return_value
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Rückgabewert';

wwv_flow_api.create_message (
  p_id=>195948005537152278 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SQL_REPORT_WIZ.RETURN_VALUE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message prefs_revoke_permissions
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Berechtigungen entziehen';

wwv_flow_api.create_message (
  p_id=>195948128980152278 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PREFS_REVOKE_PERMISSIONS',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message sql_report_wiz_default
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Standard';

wwv_flow_api.create_message (
  p_id=>195948228125152278 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SQL_REPORT_WIZ.DEFAULT',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message sql_report_wiz_primary_sort_col
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Primärsortierspalte';

wwv_flow_api.create_message (
  p_id=>195948313020152278 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SQL_REPORT_WIZ.PRIMARY_SORT_COL',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message prefs_noaction_required
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Keine Aktion erforderlich';

wwv_flow_api.create_message (
  p_id=>195948428603152278 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PREFS_NOACTION_REQUIRED',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message sql_report_wiz_secondary_sort_col
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Sekundärsortierspalte';

wwv_flow_api.create_message (
  p_id=>195948507859152279 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SQL_REPORT_WIZ.SECONDARY_SORT_COL',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message sql_report_wiz_select_col
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Spalte auswählen';

wwv_flow_api.create_message (
  p_id=>195948630266152279 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SQL_REPORT_WIZ.SELECT_COL',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message sql_report_wiz_disable_sort_col
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Sortierspalte deaktivieren';

wwv_flow_api.create_message (
  p_id=>195948709762152279 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SQL_REPORT_WIZ.DISABLE_SORT_COL',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message tab_manager_warning
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Warnung: Übergeordnetes Registerkartenziel "%0" referenziert möglicherweise eine Seite, die nicht vorhanden ist.';

wwv_flow_api.create_message (
  p_id=>195948821761152279 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'TAB_MANAGER.WARNING',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message publish_item_help_confirm
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Sie haben die Aktualisierung der folgenden Elementhilfe angefordert';

wwv_flow_api.create_message (
  p_id=>195948900094152279 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PUBLISH_ITEM_HELP.CONFIRM',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message publish_item_help_confirm2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Wenn dies der Fall ist, klicken Sie auf <b>Alles aktualisieren</b>. Klicken Sie andernfalls auf <b>Abbrechen</b>.';

wwv_flow_api.create_message (
  p_id=>195949030082152279 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PUBLISH_ITEM_HELP.CONFIRM2',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message authentication_confirm_delete
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Sie sind im Begriff, ein Authentifizierungsschema aus der Anwendung %0 zu löschen. Wenn die Anwendung aktuell nicht die SCHEME-Authentifizierung verwendet oder SCHEME nicht das aktuelle Authentifizierungsschema ist und Sie das Schema löschen, hat dies keine Auswirkung auf den Vorgang der Anwendung. Wenn die Anwendung die SCHEME-Authentifizierung verwendet und es sich hierbei um das aktuelle Authen';

h:=h||'tifizierungsschema handelt, führt die Anwendung weiterhin die SCHEME-Authentifizierung durch, und zwar mit einem Standard-Authentifizierungsschema. Hierbei wird eine integrierte Anmeldeseite mit einer "Open Door"-ID-Daten-Verifizierung verwendet (bei der jeder Benutzer berechtigt ist, die Anwendung auszuführen). ';

wwv_flow_api.create_message (
  p_id=>195949124852152279 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'AUTHENTICATION.CONFIRM_DELETE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4500_p602_dup_col_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Die Spaltennamen <b>%0</b> werden mehrmals in dieser Tabelle verwendet.';

wwv_flow_api.create_message (
  p_id=>195949215390152280 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4500.P602.DUP_COL_NAME',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4500_p602_invalid_precision_nbr
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Die Gesamtstellenzahl für die Spalte <b>%0</b> ist ungültig (1 - 38).<br />';

wwv_flow_api.create_message (
  p_id=>195949325933152280 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4500.P602.INVALID_PRECISION_NBR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4500_p602_invalid_scale
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Die Anzahl der Nachkommastellen für die Spalte <b>%0</b> ist ungültig (-84 - 127).<br />';

wwv_flow_api.create_message (
  p_id=>195949419524152280 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4500.P602.INVALID_SCALE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4500_p602_invalid_precision_char
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Die Gesamtstellenzahl für die Spalte <b>%0</b> ist ungültig (%1 - %2).<br />';

wwv_flow_api.create_message (
  p_id=>195949502012152280 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4500.P602.INVALID_PRECISION_CHAR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4500_p602_invalid_col_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Der Spaltenname <b>%0</b> ist ungültig.<br />';

wwv_flow_api.create_message (
  p_id=>195949621184152280 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4500.P602.INVALID_COL_NAME',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4500_p602_enter_at_least_one_col
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Sie müssen den Namen von mindestens einer Spalte eingeben.';

wwv_flow_api.create_message (
  p_id=>195949719445152280 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4500.P602.ENTER_AT_LEAST_ONE_COL',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4500_dup_arg_names
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Der Argumentname <b>%0</b> wird mehrmals in dieser Funktion verwendet.<br />';

wwv_flow_api.create_message (
  p_id=>195949819377152281 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4500.DUP_ARG_NAMES',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p232_reset_css
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'CSS zurücksetzen';

wwv_flow_api.create_message (
  p_id=>195949932700152281 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P232_RESET_CSS',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4500_native
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Natives Dateiformat.';

wwv_flow_api.create_message (
  p_id=>195950021989152281 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4500_NATIVE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4500_text_file_format
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Dokument als Text anzeigen.';

wwv_flow_api.create_message (
  p_id=>195950120972152281 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4500_TEXT_FILE_FORMAT',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4500_parse
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Dieses Skript parsen.';

wwv_flow_api.create_message (
  p_id=>195950208072152281 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4500_PARSE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4050_show_all_workspaces
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Alle Workspaces anzeigen';

wwv_flow_api.create_message (
  p_id=>195950317643152282 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4050_SHOW_ALL_WORKSPACES',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_condition_columns
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Spalten';

wwv_flow_api.create_message (
  p_id=>195950424680152282 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_CONDITION.COLUMNS',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_condition_conditions
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Bedingungen';

wwv_flow_api.create_message (
  p_id=>195950507903152282 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_CONDITION.CONDITIONS',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_condition_arrow_down
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Pfeil nach unten';

wwv_flow_api.create_message (
  p_id=>195950615425152282 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_CONDITION.ARROW_DOWN',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_condition_arrow_right
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Pfeil nach rechts';

wwv_flow_api.create_message (
  p_id=>195950708619152282 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_CONDITION.ARROW_RIGHT',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_condition_and
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'AND';

wwv_flow_api.create_message (
  p_id=>195950823499152282 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_CONDITION.AND',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_condition_or
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'OR';

wwv_flow_api.create_message (
  p_id=>195950926321152282 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_CONDITION.OR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_condition_preview
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Vorschaubedingung';

wwv_flow_api.create_message (
  p_id=>195951007549152283 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_CONDITION.PREVIEW',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message authentication_refresh
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Sie haben die Aktualisierung von Authentifizierungsschemas angefordert';

wwv_flow_api.create_message (
  p_id=>195951100686152283 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'AUTHENTICATION.REFRESH',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message authentication_make_current
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Klicken Sie auf <b>Als aktuelles Element festlegen</b>, damit Ihre Anwendung dieses Authentifizierungsschema verwendet.';

wwv_flow_api.create_message (
  p_id=>195951232582152283 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'AUTHENTICATION.MAKE_CURRENT',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_table_script_created
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Das Skript zum Erstellen von Tabellen für die Tabelle %0 wurde im SQL-Skript-Repository erstellt.';

wwv_flow_api.create_message (
  p_id=>195951324470152283 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_TABLE.SCRIPT_CREATED',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_table_script_repository
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Gehe zu Skript-Repository';

wwv_flow_api.create_message (
  p_id=>195951424749152283 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_TABLE.SCRIPT_REPOSITORY',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_table_sql_workshop_home
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'SQL Workshop - Home';

wwv_flow_api.create_message (
  p_id=>195951525771152283 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_TABLE.SQL_WORKSHOP_HOME',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_table_run_script
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Skript ausführen';

wwv_flow_api.create_message (
  p_id=>195951602321152284 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_TABLE.RUN_SCRIPT',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_table_return_to
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Zurück zu';

wwv_flow_api.create_message (
  p_id=>195951717807152284 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_TABLE.RETURN_TO',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_table_sql_workshop
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'SQL&nbsp;Workshop';

wwv_flow_api.create_message (
  p_id=>195951802050152284 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_TABLE.SQL_WORKSHOP',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_table_home
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Home';

wwv_flow_api.create_message (
  p_id=>195951905948152284 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_TABLE.HOME',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_package_created
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Das Package "%0" wurde im "%1"-Schema erstellt.';

wwv_flow_api.create_message (
  p_id=>195952007663152284 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_PACKAGE.CREATED',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_package_browse
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Package durchsuchen';

wwv_flow_api.create_message (
  p_id=>195952119367152284 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_PACKAGE.BROWSE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_package_sql_workshop_home
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'SQL Workshop - Home';

wwv_flow_api.create_message (
  p_id=>195952229078152285 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_PACKAGE.SQL_WORKSHOP_HOME',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_package_return_to
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Zurück zu';

wwv_flow_api.create_message (
  p_id=>195952320732152285 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_PACKAGE.RETURN_TO',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_package_sql_workshop
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'SQL&nbsp;Workshop';

wwv_flow_api.create_message (
  p_id=>195952431483152285 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_PACKAGE.SQL_WORKSHOP',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_package_home
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Home';

wwv_flow_api.create_message (
  p_id=>195952504750152285 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_PACKAGE.HOME',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_package_back
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Zurück zum Assistenten zum Erstellen von Tabellen';

wwv_flow_api.create_message (
  p_id=>195952620184152285 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_PACKAGE.BACK',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_package_failed
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erstellen von Tabelle "%0" nicht erfolgreich.';

wwv_flow_api.create_message (
  p_id=>195952720702152285 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_PACKAGE.FAILED',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message null_in_paren
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'(null)';

wwv_flow_api.create_message (
  p_id=>195952826039152286 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'NULL_IN_PAREN',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4300_instruct_text
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Die erste Zeile enthält Spaltennamen.';

wwv_flow_api.create_message (
  p_id=>195952900821152286 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4300_INSTRUCT_TEXT',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message table_in_paren
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'(Tabelle)';

wwv_flow_api.create_message (
  p_id=>195953010301152286 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'TABLE_IN_PAREN',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message view_in_paren
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'(View)';

wwv_flow_api.create_message (
  p_id=>195953102255152286 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'VIEW_IN_PAREN',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message all_applications
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Alle Anwendungen';

wwv_flow_api.create_message (
  p_id=>195953201618152286 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ALL_APPLICATIONS',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message seconds
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Sekunden';

wwv_flow_api.create_message (
  p_id=>195953310379152287 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SECONDS',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message minute
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Minute';

wwv_flow_api.create_message (
  p_id=>195953414629152287 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'MINUTE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message minutes
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Minuten';

wwv_flow_api.create_message (
  p_id=>195953503471152287 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'MINUTES',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message hour
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Stunde';

wwv_flow_api.create_message (
  p_id=>195953606202152287 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'HOUR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message hours
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Stunden';

wwv_flow_api.create_message (
  p_id=>195953725718152287 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'HOURS',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message day
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Tag';

wwv_flow_api.create_message (
  p_id=>195953812299152287 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DAY',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message days
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Tage';

wwv_flow_api.create_message (
  p_id=>195953918381152288 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DAYS',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message week
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Woche';

wwv_flow_api.create_message (
  p_id=>195954007394152288 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WEEK',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message weeks
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Wochen';

wwv_flow_api.create_message (
  p_id=>195954107188152288 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WEEKS',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message year
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Jahr';

wwv_flow_api.create_message (
  p_id=>195954207921152288 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'YEAR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message all_users
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Alle Benutzer';

wwv_flow_api.create_message (
  p_id=>195954308834152288 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ALL_USERS',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message last
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'letzte';

wwv_flow_api.create_message (
  p_id=>195954431957152288 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAST',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message function
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Funktion';

wwv_flow_api.create_message (
  p_id=>195954514130152289 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'FUNCTION',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message index
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Index';

wwv_flow_api.create_message (
  p_id=>195954610251152289 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INDEX',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message package
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Package';

wwv_flow_api.create_message (
  p_id=>195954712943152289 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PACKAGE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message procedure
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Prozedur';

wwv_flow_api.create_message (
  p_id=>195954817148152289 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PROCEDURE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message sequence
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Sequence';

wwv_flow_api.create_message (
  p_id=>195954903853152289 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SEQUENCE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message synonym
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Synonym';

wwv_flow_api.create_message (
  p_id=>195955012970152289 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SYNONYM',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message table
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Tabelle';

wwv_flow_api.create_message (
  p_id=>195955105018152290 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'TABLE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message trigger
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Trigger';

wwv_flow_api.create_message (
  p_id=>195955224108152290 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'TRIGGER',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message view
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'View';

wwv_flow_api.create_message (
  p_id=>195955310313152290 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'VIEW',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message insert
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'einfügen';

wwv_flow_api.create_message (
  p_id=>195955413420152290 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSERT',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message update
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'aktualisieren';

wwv_flow_api.create_message (
  p_id=>195955530245152290 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'UPDATE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message delete
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Löschen';

wwv_flow_api.create_message (
  p_id=>195955605363152290 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DELETE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message not_in_data_dict
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Nicht in Data Dictionary';

wwv_flow_api.create_message (
  p_id=>195955721552152291 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'NOT_IN_DATA_DICT',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message new_tabset
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Neue Registerkartengruppe';

wwv_flow_api.create_message (
  p_id=>195955823202152291 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'NEW_TABSET',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message not
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Nicht';

wwv_flow_api.create_message (
  p_id=>195955906897152291 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'NOT',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message menu
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Navigationspfad';

wwv_flow_api.create_message (
  p_id=>195956006052152291 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'MENU',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message sql_query
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'SQL-Abfrage';

wwv_flow_api.create_message (
  p_id=>195956105420152291 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SQL_QUERY',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message structured_query
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Strukturierte Abfrage';

wwv_flow_api.create_message (
  p_id=>195956208194152291 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'STRUCTURED_QUERY',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message function_body_returning_query
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'PL/SQL-Funktions-Body, der eine SQL-Abfrage zurückgibt';

wwv_flow_api.create_message (
  p_id=>195956314226152292 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'FUNCTION_BODY_RETURNING_QUERY',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message html_text
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'HTML-Text';

wwv_flow_api.create_message (
  p_id=>195956423712152292 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'HTML_TEXT',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message plsql_procedure
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'PL/SQL';

wwv_flow_api.create_message (
  p_id=>195956525223152292 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PLSQL_PROCEDURE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message anonymous_block
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'anonymer Block';

wwv_flow_api.create_message (
  p_id=>195956606798152292 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ANONYMOUS_BLOCK',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message help_text
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Hilfetext';

wwv_flow_api.create_message (
  p_id=>195956700083152292 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'HELP_TEXT',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message web_service_result
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Web Service-Ergebnis';

wwv_flow_api.create_message (
  p_id=>195956813032152292 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WEB_SERVICE_RESULT',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message chart
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Diagramm';

wwv_flow_api.create_message (
  p_id=>195956910081152292 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CHART',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message simple
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'einfach';

wwv_flow_api.create_message (
  p_id=>195957003524152293 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SIMPLE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message escape_sc
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Escape bei Sonderzeichen';

wwv_flow_api.create_message (
  p_id=>195957121325152293 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ESCAPE_SC',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message with_shortcuts
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Mit Shortcuts';

wwv_flow_api.create_message (
  p_id=>195957214048152293 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WITH_SHORTCUTS',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message updateable_report
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'aktualisierbarer Bericht';

wwv_flow_api.create_message (
  p_id=>195957306386152293 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'UPDATEABLE_REPORT',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message url
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'URL';

wwv_flow_api.create_message (
  p_id=>195957403335152293 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'URL',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message tree
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Baum';

wwv_flow_api.create_message (
  p_id=>195957516578152293 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'TREE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message list
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Liste';

wwv_flow_api.create_message (
  p_id=>195957605478152294 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LIST',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message all_themes
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Alle Themes';

wwv_flow_api.create_message (
  p_id=>195957716385152294 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ALL_THEMES',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message html
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'HTML';

wwv_flow_api.create_message (
  p_id=>195957814925152294 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'HTML',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message driven
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'gesteuert';

wwv_flow_api.create_message (
  p_id=>195957927839152294 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DRIVEN',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message image
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Bild';

wwv_flow_api.create_message (
  p_id=>195958018707152294 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'IMAGE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message no_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Kein Template';

wwv_flow_api.create_message (
  p_id=>195958120901152294 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'NO_TEMPLATE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message no_item
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'kein Element';

wwv_flow_api.create_message (
  p_id=>195958227915152295 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'NO_ITEM',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message popup_lov
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Popup-Werteliste';

wwv_flow_api.create_message (
  p_id=>195958301522152295 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'POPUP_LOV',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message schemes
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Schemas';

wwv_flow_api.create_message (
  p_id=>195958415824152295 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SCHEMES',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message shortcut
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Shortcut';

wwv_flow_api.create_message (
  p_id=>195958513116152295 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SHORTCUT',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message use_page_as_login_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Seite %0 als Anmeldeseite verwenden.';

wwv_flow_api.create_message (
  p_id=>195958619806152295 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'USE_PAGE_AS_LOGIN_PAGE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_new_login_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Neue Anmeldeseite erstellen.';

wwv_flow_api.create_message (
  p_id=>195958719913152295 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_NEW_LOGIN_PAGE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message use_builtin_login_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Integrierte Anmeldeseite verwenden.';

wwv_flow_api.create_message (
  p_id=>195958801693152296 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'USE_BUILTIN_LOGIN_PAGE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message workspace
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Workspace';

wwv_flow_api.create_message (
  p_id=>195958917833152296 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WORKSPACE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message core
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Kern';

wwv_flow_api.create_message (
  p_id=>195959012154152296 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CORE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message all_static_files
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Alle statischen Dateien';

wwv_flow_api.create_message (
  p_id=>195959128109152296 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ALL_STATIC_FILES',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message associated
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'zugehörig';

wwv_flow_api.create_message (
  p_id=>195959204510152296 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ASSOCIATED',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_alias_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1816 Unerwarteter Fehler beim Konvertieren von Anwendungsaliasname p_flow_alias_or_id (%0).';

wwv_flow_api.create_message (
  p_id=>195959321458152296 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.ALIAS_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_not_logged_in
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Nicht angemeldet. Das Cookie für die Form zur Authentifizierung war nicht vorhanden oder ungültig.';

wwv_flow_api.create_message (
  p_id=>195959415192152297 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.NOT_LOGGED_IN',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_click_to_login
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'<p>Klicken Sie <a href="%0">hier</a>, um sich anzumelden</a>';

wwv_flow_api.create_message (
  p_id=>195959505693152297 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.CLICK_TO_LOGIN',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_create_session_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-99900 Erstellen von eindeutiger Session-ID nicht möglich: %0';

wwv_flow_api.create_message (
  p_id=>195959601639152297 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.CREATE_SESSION_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_session_info_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1029 Speichern von Sessioninformationen nicht möglich. session=%0 item=%1';

wwv_flow_api.create_message (
  p_id=>195959716472152297 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.SESSION_INFO_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_save_routine_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1001 Unerwarteter Fehler in Speicherroutine.';

wwv_flow_api.create_message (
  p_id=>195959811419152297 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.SAVE_ROUTINE_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_deeplinking_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1001 Unerwarteter Fehler in make_deeplinking_item session=%0';

wwv_flow_api.create_message (
  p_id=>195959908686152297 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.DEEPLINKING_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_find_item_id_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1002 Element-ID für Element "%0" in Anwendung "%1" nicht gefunden.';

wwv_flow_api.create_message (
  p_id=>195960014985152298 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.FIND_ITEM_ID_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_find_item_id_err2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unerwarteter Fehler: Elementname auf Anwendungs- oder Seitenebene nicht gefunden.';

wwv_flow_api.create_message (
  p_id=>195960120121152298 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.FIND_ITEM_ID_ERR2',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_find_item_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1902 Element-ID ist Null in find_item_name-Routine.';

wwv_flow_api.create_message (
  p_id=>195960214020152298 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.FIND_ITEM_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_unexpected_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unerwarteter Fehler';

wwv_flow_api.create_message (
  p_id=>195960315203152298 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.UNEXPECTED_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_find_item_err2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1802 Element-ID "%0" nicht gefunden';

wwv_flow_api.create_message (
  p_id=>195960426717152298 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.FIND_ITEM_ERR2',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_auth_scheme_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1082 Fehler beim Ausführen von Code für Autorisierungsschema.';

wwv_flow_api.create_message (
  p_id=>195960508932152298 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.AUTH_SCHEME_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_access_denied
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Zugriff von %0-Sicherheitsprüfung verweigert';

wwv_flow_api.create_message (
  p_id=>195960622935152299 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.ACCESS_DENIED',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_first_page_data_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Sie befinden sich bereits auf der ersten Datenseite.';

wwv_flow_api.create_message (
  p_id=>195960716168152299 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.FIRST_PAGE_DATA_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_create_item_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1001 Unerwarteter Fehler beim Erstellen von Element: FSP_PROCESS_STATE_%0';

wwv_flow_api.create_message (
  p_id=>195960805136152299 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.CREATE_ITEM_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_comp_query_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1003 Fehler beim Ausführen von Berechnungsabfrage.';

wwv_flow_api.create_message (
  p_id=>195960922011152299 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.COMP_QUERY_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_comp_exp_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1030 Fehler beim Ausführen von Berechnungsausdruck.';

wwv_flow_api.create_message (
  p_id=>195961012749152299 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.COMP_EXP_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_comp_function_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1004 Berechnen von Funktion nicht möglich. computation_point=%0 computation_type=%1';

wwv_flow_api.create_message (
  p_id=>195961122388152299 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.COMP_FUNCTION_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_comp_unknown_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1005 Unbekannter Berechnungstyp.';

wwv_flow_api.create_message (
  p_id=>195961219183152300 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.COMP_UNKNOWN_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_validation_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1006 Fehler in Validierungsroutine.';

wwv_flow_api.create_message (
  p_id=>195961314287152300 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.VALIDATION_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_func_body_ret_text_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1024 Ausführen von "function body returning text"-Validierung nicht möglich.';

wwv_flow_api.create_message (
  p_id=>195961404603152300 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.FUNC_BODY_RET_TEXT_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_func_body_ret_bool_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1021 Ausführen von "function body returning boolean"-Validierung nicht möglich.';

wwv_flow_api.create_message (
  p_id=>195961503326152300 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.FUNC_BODY_RET_BOOL_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_branch_point_null_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1007 Verzweigungspunkt darf nicht Null sein: %0';

wwv_flow_api.create_message (
  p_id=>195961610485152300 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.BRANCH_POINT_NULL_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_branch_to_page_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1008 Fehler beim Ausführen von Verzweigung zu Seite %0.';

wwv_flow_api.create_message (
  p_id=>195961707543152300 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.BRANCH_TO_PAGE_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_page_accept_recur_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1010 Rekursionsgrenzwert für die Abnahme der Verarbeitung bei Verzweigung zu Seite überschritten. %0';

wwv_flow_api.create_message (
  p_id=>195961828610152301 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.PAGE_ACCEPT_RECUR_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_branch_to_funct_ret_page_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-7744 Verarbeiten von Verzweigung zu Seite für die Rückgabe der Funktion nicht möglich.';

wwv_flow_api.create_message (
  p_id=>195961918720152301 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.BRANCH_TO_FUNCT_RET_PAGE_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_branch_func_returning_url_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-7744 Verarbeiten URL von Verzweigung zu Seite für die Rückgabe der Funktion nicht möglich.';

wwv_flow_api.create_message (
  p_id=>195962020626152301 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.BRANCH_FUNC_RETURNING_URL_ERROR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_branch_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1009 Fehler bei Verzweigungsverarbeitung.';

wwv_flow_api.create_message (
  p_id=>195962122130152301 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.BRANCH_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sql_exp_heading_text_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1910 Fehler beim Auswerten von SQL-Ausdruck in Header-Text.';

wwv_flow_api.create_message (
  p_id=>195962228984152301 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.SQL_EXP_HEADING_TEXT_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_eval_type_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1011 Ungültiger Auswertungstyp: %0';

wwv_flow_api.create_message (
  p_id=>195962301322152301 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.EVAL_TYPE_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fehler';

wwv_flow_api.create_message (
  p_id=>195962416574152302 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_g_flow_id_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1812 Unerwarteter Fehler beim Zuweisen von G_FLOW_ID (%0).';

wwv_flow_api.create_message (
  p_id=>195962509502152302 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.G_FLOW_ID_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_page_alias_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1412 Auflösen von Seiten-Aliasname (%0) nicht möglich.';

wwv_flow_api.create_message (
  p_id=>195962609879152302 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.PAGE_ALIAS_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_call_to_show_from_proc_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1430 Der Aufruf für die Anzeige vom Seitenprozess wird nicht unterstützt: G_FLOW_STEP_ID (%0).';

wwv_flow_api.create_message (
  p_id=>195962708969152302 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.CALL_TO_SHOW_FROM_PROC_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_det_company_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-7620 Bestimmen des Workspace für die Anwendung (%0) nicht möglich.';

wwv_flow_api.create_message (
  p_id=>195962813630152303 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.DET_COMPANY_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_det_company_footer_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Es wird erwartet, dass das p_company- oder wwv_flow_company-Cookie die Sicherheitsgruppen-ID des Anwendungseigentümers enthält.';

wwv_flow_api.create_message (
  p_id=>195962922136152303 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.DET_COMPANY_FOOTER_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_app_not_found_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1014 Anwendung nicht gefunden.';

wwv_flow_api.create_message (
  p_id=>195963015397152303 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.APP_NOT_FOUND_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message service_signup_workspace_info
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Informationen zum Workspace';

wwv_flow_api.create_message (
  p_id=>195963111033152303 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SERVICE_SIGNUP.WORKSPACE_INFO',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_app_not_found_footer_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Anwendung=%0  Workspace=%1';

wwv_flow_api.create_message (
  p_id=>195963232054152303 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.APP_NOT_FOUND_FOOTER_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message service_signup_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Name';

wwv_flow_api.create_message (
  p_id=>195963321782152303 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SERVICE_SIGNUP.NAME',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message service_signup_justification
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Begründung';

wwv_flow_api.create_message (
  p_id=>195963412387152304 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SERVICE_SIGNUP.JUSTIFICATION',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_login_server_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1555 Nicht beim Oracle-Login-Server angemeldet. Es wurde kein öffentlicher Benutzer angegeben.';

wwv_flow_api.create_message (
  p_id=>195963527463152304 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.LOGIN_SERVER_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message service_signup_description
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Beschreibung';

wwv_flow_api.create_message (
  p_id=>195963629680152304 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SERVICE_SIGNUP.DESCRIPTION',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message service_signup_admin_info
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Administratorinformationen';

wwv_flow_api.create_message (
  p_id=>195963721346152304 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SERVICE_SIGNUP.ADMIN_INFO',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message service_signup_first_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Vorname';

wwv_flow_api.create_message (
  p_id=>195963823161152304 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SERVICE_SIGNUP.FIRST_NAME',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message service_signup_last_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Nachname';

wwv_flow_api.create_message (
  p_id=>195963913163152304 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SERVICE_SIGNUP.LAST_NAME',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message service_signup_email
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'E-Mail';

wwv_flow_api.create_message (
  p_id=>195964002027152305 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SERVICE_SIGNUP.EMAIL',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message service_signup_phone
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Telefon';

wwv_flow_api.create_message (
  p_id=>195964126904152305 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SERVICE_SIGNUP.PHONE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message service_signup_schema_info
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Schemainformationen';

wwv_flow_api.create_message (
  p_id=>195964219681152305 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SERVICE_SIGNUP.SCHEMA_INFO',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message service_signup_reuse_schema
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Vorhandenes Schema erneut verwenden';

wwv_flow_api.create_message (
  p_id=>195964310981152305 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SERVICE_SIGNUP.REUSE_SCHEMA',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message service_signup_yes
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Ja';

wwv_flow_api.create_message (
  p_id=>195964431784152305 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SERVICE_SIGNUP.YES',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message service_signup_no
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Nein';

wwv_flow_api.create_message (
  p_id=>195964516387152305 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SERVICE_SIGNUP.NO',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message service_signup_schema_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Schemaname';

wwv_flow_api.create_message (
  p_id=>195964624659152306 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SERVICE_SIGNUP.SCHEMA_NAME',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_afscookie_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1333 ASFCOOKIE konnte nicht abgerufen werden.';

wwv_flow_api.create_message (
  p_id=>195964731606152306 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.AFSCOOKIE_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message service_signup_db_size
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Datenbankgröße';

wwv_flow_api.create_message (
  p_id=>195964820400152306 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SERVICE_SIGNUP.DB_SIZE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_session_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1201 Keine Session-ID bei benutzerdefinierter Authentifizierung festgelegt.';

wwv_flow_api.create_message (
  p_id=>195964911251152306 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.CUSTOM_AUTH_SESSION_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_session_footer_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'page=%0';

wwv_flow_api.create_message (
  p_id=>195965029426152306 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.CUSTOM_AUTH_SESSION_FOOTER_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message service_signup_accept
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Geben Sie den Verifizierungscode unter Berücksichtigung der Groß-/Kleinschreibung ein, und klicken Sie anschließend auf <b>Request weiterleiten</b>.';

wwv_flow_api.create_message (
  p_id=>195965119808152306 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SERVICE_SIGNUP.ACCEPT',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_unsupp_auth_scheme_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1444 Authentifizierungsschema nicht unterstützt.';

wwv_flow_api.create_message (
  p_id=>195965230569152307 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.UNSUPP_AUTH_SCHEME_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message provision_request_new
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Sie haben das neue Provisioning für %0 angefordert.';

wwv_flow_api.create_message (
  p_id=>195965318947152307 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PROVISION_REQUEST.NEW',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message provision_request_workspace_info
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Informationen zum Workspace';

wwv_flow_api.create_message (
  p_id=>195965410165152307 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PROVISION_REQUEST.WORKSPACE_INFO',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message provision_request_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Name';

wwv_flow_api.create_message (
  p_id=>195965520673152307 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PROVISION_REQUEST.NAME',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message provision_request_sgid
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Sicherheitsgruppen-ID';

wwv_flow_api.create_message (
  p_id=>195965622043152307 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PROVISION_REQUEST.SGID',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message provision_request_system_assigned
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Vom System zugewiesen';

wwv_flow_api.create_message (
  p_id=>195965700777152307 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PROVISION_REQUEST.SYSTEM_ASSIGNED',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message provision_request_description
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Beschreibung';

wwv_flow_api.create_message (
  p_id=>195965812823152308 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PROVISION_REQUEST.DESCRIPTION',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_app_not_fnd_inv_comp_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1014 Anwendung nicht gefunden. Ungültiger Workspace.';

wwv_flow_api.create_message (
  p_id=>195965920525152308 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.APP_NOT_FND_INV_COMP_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message provision_request_admin_info
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Administratorinformationen';

wwv_flow_api.create_message (
  p_id=>195966007870152308 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PROVISION_REQUEST.ADMIN_INFO',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message provision_request_user_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Benutzername';

wwv_flow_api.create_message (
  p_id=>195966103421152308 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PROVISION_REQUEST.USER_NAME',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message provision_request_email
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'E-Mail';

wwv_flow_api.create_message (
  p_id=>195966231234152308 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PROVISION_REQUEST.EMAIL',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message provision_request_title
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Überschrift';

wwv_flow_api.create_message (
  p_id=>195966302187152308 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PROVISION_REQUEST.TITLE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_app_not_fnd_footer_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Anwendung=%0 Aktueller Workspace=%1 Angeforderter Workspace=%2';

wwv_flow_api.create_message (
  p_id=>195966403334152309 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.APP_NOT_FND_FOOTER_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_app_restricted_to_dev
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Auf diese Anwendung dürfen nur Anwendungsentwickler zugreifen. Führen Sie den Vorgang später aus.';

wwv_flow_api.create_message (
  p_id=>195966518895152309 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.APP_RESTRICTED_TO_DEV',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message provision_request_schema_info
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Schemainformationen';

wwv_flow_api.create_message (
  p_id=>195966609209152309 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PROVISION_REQUEST.SCHEMA_INFO',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_app_restricted
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Auf diese Anwendung dürfen nur bestimmte Benutzer zugreifen. Führen Sie den Vorgang später aus.';

wwv_flow_api.create_message (
  p_id=>195966716946152309 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.APP_RESTRICTED',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message provision_request_reuse_schema
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Vorhandenes Schema erneut verwenden';

wwv_flow_api.create_message (
  p_id=>195966808242152309 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PROVISION_REQUEST.REUSE_SCHEMA',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_set_vpd_context_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1181 Festlegen von VPD-Sicherheitskontext bei Page Show nicht möglich.';

wwv_flow_api.create_message (
  p_id=>195966906115152309 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.SET_VPD_CONTEXT_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message provision_request_yes
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Ja';

wwv_flow_api.create_message (
  p_id=>195967018822152310 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PROVISION_REQUEST.YES',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_afscookie_null_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1111 ASFCOOKIE darf nicht Null sein.';

wwv_flow_api.create_message (
  p_id=>195967126436152310 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.AFSCOOKIE_NULL_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message provision_request_no
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Nein';

wwv_flow_api.create_message (
  p_id=>195967217424152310 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PROVISION_REQUEST.NO',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message provision_request_schema_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Schemaname';

wwv_flow_api.create_message (
  p_id=>195967332080152310 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PROVISION_REQUEST.SCHEMA_NAME',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message provision_request_create_tblspace
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Tablespace wird erstellt';

wwv_flow_api.create_message (
  p_id=>195967428131152310 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PROVISION_REQUEST.CREATE_TBLSPACE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_app_page_not_fnd_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1016 Anwendung "%0" Seite "%1" nicht gefunden (angeforderte Sprache="%2")';

wwv_flow_api.create_message (
  p_id=>195967504938152310 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.APP_PAGE_NOT_FND_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message provision_request_flow_xxx
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'FLOW_XXX';

wwv_flow_api.create_message (
  p_id=>195967605205152311 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PROVISION_REQUEST.FLOW_XXX',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_contact_admin
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Wenden Sie sich an Ihren Anwendungsadministrator.';

wwv_flow_api.create_message (
  p_id=>195967715544152311 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.CONTACT_ADMIN',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message provision_request_datafile
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Datendatei für Tablespace';

wwv_flow_api.create_message (
  p_id=>195967831468152311 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PROVISION_REQUEST.DATAFILE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_required_role_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Die erforderliche Rolle ist nicht aktiviert.';

wwv_flow_api.create_message (
  p_id=>195967922544152311 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.REQUIRED_ROLE_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_logout
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Abmelden';

wwv_flow_api.create_message (
  p_id=>195968009756152311 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.LOGOUT',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_no_priv_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1013 Keine Berechtigung für den Vorgang von Benutzer %0. Es ist die Rolle %1 erforderlich. Wenden Sie sich an Ihren Anwendungsadministrator.';

wwv_flow_api.create_message (
  p_id=>195968114248152311 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.NO_PRIV_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_clear_step_cache_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1018 Fehler beim Löschen von Schrittcacheinhalt.';

wwv_flow_api.create_message (
  p_id=>195968221060152312 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.CLEAR_STEP_CACHE_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_unable_resolve_alias_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1512 Auflösen von Seiten-Aliasname (%0) nicht möglich.';

wwv_flow_api.create_message (
  p_id=>195968313251152312 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.UNABLE_RESOLVE_ALIAS_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_det_company_on_accept_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-7621 Bestimmen des Workspace für Anwendung (%0) bei Anwendungsannahme nicht möglich.';

wwv_flow_api.create_message (
  p_id=>195968400955152312 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.DET_COMPANY_ON_ACCEPT_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_det_comp_for_flow_footer_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Es wird erwartet, dass das p_company- oder wwv_flow_company-Cookie die Sicherheitsgruppen-ID des Anwendungseigentümers enthält.';

wwv_flow_api.create_message (
  p_id=>195968514291152312 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.DET_COMP_FOR_FLOW_FOOTER_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_set_vpd_context_err2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1182 Festlegen von VPD-Sicherheitskontext bei Page Accept nicht möglich.';

wwv_flow_api.create_message (
  p_id=>195968616071152312 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.SET_VPD_CONTEXT_ERR2',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_insufficent_info_on_req_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-9988 Es wurden nicht genügend Informationen für diesen Request angegeben: Möglicherweise haben Sie nicht gewartet, bis die vorherige Seite vollständig geladen wurde. Klicken Sie auf <b>Zurück</b> und <b>Neu laden</b> Ihres Browsers, oder navigieren Sie zur Homepage Ihrer Anwendungen, um fortzufahren.';

wwv_flow_api.create_message (
  p_id=>195968729769152312 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.INSUFFICENT_INFO_ON_REQ_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_app_page_request_footer_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Application=%0 Seite=%1 Request=%2';

wwv_flow_api.create_message (
  p_id=>195968818126152313 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.APP_PAGE_REQUEST_FOOTER_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_unable_to_save_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1022 Speichern von Attributen nicht möglich.';

wwv_flow_api.create_message (
  p_id=>195968931627152313 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.UNABLE_TO_SAVE_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_unable_to_perf_valid_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1023 Ausführung von Validierungen nicht möglich.';

wwv_flow_api.create_message (
  p_id=>195969021040152313 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.UNABLE_TO_PERF_VALID_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_unable_to_perf_processing_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1024 Ausführen von Verarbeitung nicht möglich.';

wwv_flow_api.create_message (
  p_id=>195969100993152313 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.UNABLE_TO_PERF_PROCESSING_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_no_page_to_branch_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1777: Die Seite %0 hat keine Seite für die Verzweigung zur Verfügung gestellt. Melden Sie diesen Fehler Ihrem Anwendungsadministrator.';

wwv_flow_api.create_message (
  p_id=>195969231870152313 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.NO_PAGE_TO_BRANCH_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_restart_app
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'<a href="f?p=%0">Anwendung neu starten</a>';

wwv_flow_api.create_message (
  p_id=>195969308577152313 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.RESTART_APP',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_no_page_help
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Kein Hilfetext für die Seite verfügbar.';

wwv_flow_api.create_message (
  p_id=>195969431500152314 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.NO_PAGE_HELP',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_forms_item_default_val_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1019 Fehler beim Berechnen von Standardwert für Element: page=%0 name=%1.';

wwv_flow_api.create_message (
  p_id=>195969523292152314 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FORMS.ITEM_DEFAULT_VAL_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_forms_plsql_item_proc_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1020 Fehler beim Verarbeiten von PLSQL-Element (Funktion).';

wwv_flow_api.create_message (
  p_id=>195969616403152314 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FORMS.PLSQL_ITEM_PROC_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_forms_item_default_func_body_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1904 Berechnen von Elementstandard nicht möglich: type = Function Body computation_type= %0.';

wwv_flow_api.create_message (
  p_id=>195969720414152314 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FORMS.ITEM_DEFAULT_FUNC_BODY_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_forms_item_post_calc_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1079 Fehler in Element nach der Berechnung.';

wwv_flow_api.create_message (
  p_id=>195969824286152314 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FORMS.ITEM_POST_CALC_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_forms_spell_chk
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Rechtschreibprüfung';

wwv_flow_api.create_message (
  p_id=>195969904955152314 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FORMS.SPELL_CHK',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_disp_page_plugs_plsql_exp_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1025 Fehler beim Verarbeiten von PL/SQL-Ausdruck: %0';

wwv_flow_api.create_message (
  p_id=>195970014266152315 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_DISP_PAGE_PLUGS.PLSQL_EXP_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_disp_page_plugs_plsql_exp_footer_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Anwendung=%0 Seite=%1 SQLERRM=%2';

wwv_flow_api.create_message (
  p_id=>195970112769152315 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_DISP_PAGE_PLUGS.PLSQL_EXP_FOOTER_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_disp_page_plugs_func_return_query_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1101 Verarbeiten von Funktions-Body, der die Abfrage zurückgibt, nicht möglich.';

wwv_flow_api.create_message (
  p_id=>195970217556152315 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_DISP_PAGE_PLUGS.FUNC_RETURN_QUERY_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_disp_page_plugs_proc_curr_cond_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1108 Verarbeiten von aktueller Elementbedingung nicht möglich.';

wwv_flow_api.create_message (
  p_id=>195970322634152315 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_DISP_PAGE_PLUGS.PROC_CURR_COND_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_render_shortcut_unable_set_short_val_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-2904 Festlegen von Shortcut-Wert nicht möglich.';

wwv_flow_api.create_message (
  p_id=>195970424471152315 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_RENDER_SHORTCUT.UNABLE_SET_SHORT_VAL_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_region_trees_root_not_fnd_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Warnung: Baum-Root-ID "%0" nicht gefunden.';

wwv_flow_api.create_message (
  p_id=>195970510906152315 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_REGION_TREES.ROOT_NOT_FND_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message v_alias_conversion_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1812 Unerwarteter Fehler beim Konvertieren von Anwendungsaliasname (%0).';

wwv_flow_api.create_message (
  p_id=>195970606954152316 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'V.ALIAS_CONVERSION_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_builder_application
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Anwendung:';

wwv_flow_api.create_message (
  p_id=>195970712507152316 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_BUILDER.APPLICATION',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_builder_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Seite:';

wwv_flow_api.create_message (
  p_id=>195970820238152316 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_BUILDER.PAGE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_builder_plsql_lines_source
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'PL/SQL %0 %1 enthält %2 Zeilen Quellcode.';

wwv_flow_api.create_message (
  p_id=>195970921607152316 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_BUILDER.PLSQL_LINES_SOURCE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_builder_no_pages
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'<span class="tiny">Keine Seiten gefunden.</font>';

wwv_flow_api.create_message (
  p_id=>195971026780152316 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_BUILDER.NO_PAGES',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_builder_pages
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 <font size=-2>Seiten</span>';

wwv_flow_api.create_message (
  p_id=>195971123942152316 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_BUILDER.PAGES',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_item_unable_det_lov_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1000 Bestimmen der Werteliste aus "declare function x return varchar2 is begin %0 return null; end; begin wwv_flow_utilities.g_query := x; end;" nicht möglich.';

wwv_flow_api.create_message (
  p_id=>195971225678152317 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_ITEM.UNABLE_DET_LOV_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_item_js_not_supported
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'JavaScript wird nicht unterstützt.';

wwv_flow_api.create_message (
  p_id=>195971311662152317 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_ITEM.JS_NOT_SUPPORTED',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_item_list
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Liste';

wwv_flow_api.create_message (
  p_id=>195971411538152317 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_ITEM.LIST',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message manage_unassigned
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Nicht zugeordnete Seiten verwalten';

wwv_flow_api.create_message (
  p_id=>195971518816152317 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'MANAGE_UNASSIGNED',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message color_palette_complementary
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Komplementär';

wwv_flow_api.create_message (
  p_id=>195971600544152317 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'COLOR_PALETTE_COMPLEMENTARY',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message color_palette_split_complementary
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Teil-komplementär';

wwv_flow_api.create_message (
  p_id=>195971702907152317 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'COLOR_PALETTE_SPLIT_COMPLEMENTARY',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message color_palette_triade
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Triade';

wwv_flow_api.create_message (
  p_id=>195971801607152318 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'COLOR_PALETTE_TRIADE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message color_palette_tetrade
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Tetrade';

wwv_flow_api.create_message (
  p_id=>195971918299152318 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'COLOR_PALETTE_TETRADE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message color_palette_analogic
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Analog';

wwv_flow_api.create_message (
  p_id=>195972019439152318 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'COLOR_PALETTE_ANALOGIC',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message color_palette_monotone
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Monochromatisch';

wwv_flow_api.create_message (
  p_id=>195972112444152318 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'COLOR_PALETTE_MONOTONE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message color_palette_complementary_colors
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Komplementärfarben';

wwv_flow_api.create_message (
  p_id=>195972207995152318 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'COLOR_PALETTE_COMPLEMENTARY_COLORS',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_fetch_value_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Anwendungsfehler in fetch_value.';

wwv_flow_api.create_message (
  p_id=>195972306238152318 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.FETCH_VALUE_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_button_temp_fetch_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fehler beim Abrufen von Schaltflächen-Template-ID=%0';

wwv_flow_api.create_message (
  p_id=>195972403095152319 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.BUTTON_TEMP_FETCH_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_unable_to_trace_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Trace nicht möglich: %0';

wwv_flow_api.create_message (
  p_id=>195972509050152319 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.UNABLE_TO_TRACE_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_unable_set_timed_stat_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Festlegen von timed_statistics nicht möglich: %0';

wwv_flow_api.create_message (
  p_id=>195972614361152319 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.UNABLE_SET_TIMED_STAT_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_app_not_available
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Anwendungen nicht verfügbar';

wwv_flow_api.create_message (
  p_id=>195972730501152319 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.APP_NOT_AVAILABLE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_unable_to_stop_trace_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Trace konnte nicht gestoppt werden: %0';

wwv_flow_api.create_message (
  p_id=>195972812402152320 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.UNABLE_TO_STOP_TRACE_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_view_help_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Um die Hilfe anzeigen zu können, müssen die Anwendung und die Seite angegeben werden.';

wwv_flow_api.create_message (
  p_id=>195972907641152320 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.VIEW_HELP_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_forms_item_not_disp_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fehler: Das Element "%0" wurde nicht angezeigt, weil die HTML-Form noch nicht geöffnet wurde.';

wwv_flow_api.create_message (
  p_id=>195973021099152320 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FORMS.ITEM_NOT_DISP_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_forms_unable_cast_value
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Konvertieren von Wert "%0" in Datumsformatmaske %1 nicht möglich.';

wwv_flow_api.create_message (
  p_id=>195973109722152320 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FORMS.UNABLE_CAST_VALUE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_forms_edit_item
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Element %0 bearbeiten - %1 , Sequence: %2';

wwv_flow_api.create_message (
  p_id=>195973202337152320 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FORMS.EDIT ITEM',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_disp_page_plugs_reset_pag_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Zurücksetzen von Seitennummerierung für Region nicht möglich.';

wwv_flow_api.create_message (
  p_id=>195973314034152320 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_DISP_PAGE_PLUGS.RESET_PAG_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_disp_page_plugs_print_shortcut_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Drucken von Shortcut nicht möglich: %0';

wwv_flow_api.create_message (
  p_id=>195973419836152321 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_DISP_PAGE_PLUGS.PRINT_SHORTCUT_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_disp_page_plugs_render_chart_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fehler bei Wiedergabe von Diagramm: %0';

wwv_flow_api.create_message (
  p_id=>195973514485152321 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_DISP_PAGE_PLUGS.RENDER_CHART_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_disp_page_plugs_debug
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Debuggen:';

wwv_flow_api.create_message (
  p_id=>195973613719152321 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_DISP_PAGE_PLUGS.DEBUG',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_disp_page_plugs_feature_not_supported
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Dieses Feature wird in dieser Version nicht unterstützt.';

wwv_flow_api.create_message (
  p_id=>195973707407152321 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_DISP_PAGE_PLUGS.FEATURE_NOT_SUPPORTED',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_disp_page_plugs_request_for_help_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fehler 4322- Für den Hilfe-Request wurde die falsche Syntax verwendet. Der Request war Null, wobei eine gültige Seitennummer erwartet wurde.';

wwv_flow_api.create_message (
  p_id=>195973832526152321 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_DISP_PAGE_PLUGS.REQUEST_FOR_HELP_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_disp_page_plugs_help_request_err2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fehler 4323- Im Hilfe-Request ist keine numerische Seiten-ID angegeben.';

wwv_flow_api.create_message (
  p_id=>195973906097152322 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_DISP_PAGE_PLUGS.HELP_REQUEST_ERR2',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_item_unable_init_query
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Die Abfrage konnte nicht initialisiert werden.';

wwv_flow_api.create_message (
  p_id=>195974027628152322 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_ITEM.UNABLE_INIT_QUERY',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_security_company_required
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Workspace erforderlich.';

wwv_flow_api.create_message (
  p_id=>195974100392152322 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SECURITY.COMPANY_REQUIRED',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_security_flow_required
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Anwendung erforderlich.';

wwv_flow_api.create_message (
  p_id=>195974205181152322 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SECURITY.FLOW_REQUIRED',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_security_invalid_user_pass
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Ungültiger Benutzername "%0" bzw. ungültiges Kennwort.';

wwv_flow_api.create_message (
  p_id=>195974331375152322 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SECURITY.INVALID_USER_PASS',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_chart2_t_rows
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Zeilen';

wwv_flow_api.create_message (
  p_id=>195974401633152323 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_CHART2.T_ROWS',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_chart2_t_axis
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Achse';

wwv_flow_api.create_message (
  p_id=>195974503741152323 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_CHART2.T_AXIS',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_chart2_t_average
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Durchschnitt';

wwv_flow_api.create_message (
  p_id=>195974618099152323 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_CHART2.T_AVERAGE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_chart2_t_sum
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Summe';

wwv_flow_api.create_message (
  p_id=>195974720432152323 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_CHART2.T_SUM',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_chart2_t_maximum
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Maximum';

wwv_flow_api.create_message (
  p_id=>195974800815152323 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_CHART2.T_MAXIMUM',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_chart2_t_minimum
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Minimum';

wwv_flow_api.create_message (
  p_id=>195974901044152323 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_CHART2.T_MINIMUM',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_chart2_t_last
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Letzte';

wwv_flow_api.create_message (
  p_id=>195975012814152324 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_CHART2.T_LAST',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_chart2_t_first
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erster';

wwv_flow_api.create_message (
  p_id=>195975122030152324 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_CHART2.T_FIRST',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_chart2_t_go
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Los';

wwv_flow_api.create_message (
  p_id=>195975225237152324 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_CHART2.T_GO',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message chart_invalid_chart_type_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Ungültiger Diagrammtyp.';

wwv_flow_api.create_message (
  p_id=>195975322579152324 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CHART.INVALID_CHART_TYPE_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_sso_redirect_to_login_server
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Es erfolgt die Umleitung zum Login-Server für die Authentifizierung...';

wwv_flow_api.create_message (
  p_id=>195975421902152324 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_SSO.REDIRECT_TO_LOGIN_SERVER',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_parser_line_too_long
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Zeilenlänge %0 überschreitet Maximum %1 bei Zeile %2';

wwv_flow_api.create_message (
  p_id=>195975523515152325 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PARSER.LINE_TOO_LONG',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_customize_t_message1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Aktivieren Sie die Kontrollkästchen für die Regionen, die in diese Seite aufgenommen werden sollen. Diese Regionen werden dann nur angezeigt, wenn Sie sich im richtigen Anwendungskontext befinden und über die geeigneten Berechtigungen verfügen.';

wwv_flow_api.create_message (
  p_id=>195975603873152325 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOMIZE.T_MESSAGE1',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_customize_t_message2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Es wurden keine anpassbaren Regionen für diese Seite gefunden.';

wwv_flow_api.create_message (
  p_id=>195975730561152325 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOMIZE.T_MESSAGE2',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_customize_t_close
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Schließen';

wwv_flow_api.create_message (
  p_id=>195975803587152325 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOMIZE.T_CLOSE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_customize_t_apply
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Änderungen anwenden';

wwv_flow_api.create_message (
  p_id=>195975926045152325 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOMIZE.T_APPLY',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_customize_t_cust_opt
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Optionen für die Seitenanpassung';

wwv_flow_api.create_message (
  p_id=>195976015421152325 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOMIZE.T_CUST_OPT',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_customize_t_default
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Standard';

wwv_flow_api.create_message (
  p_id=>195976132537152326 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOMIZE.T_DEFAULT',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_customize_t_disp
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Angezeigt';

wwv_flow_api.create_message (
  p_id=>195976205110152326 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOMIZE.T_DISP',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_customize_t_hidden
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Ausgeblendet';

wwv_flow_api.create_message (
  p_id=>195976313640152326 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOMIZE.T_HIDDEN',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_dbms_sql_func_body_null_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Parse-Fehler: Funktions-Body darf nicht Null sein.';

wwv_flow_api.create_message (
  p_id=>195976426366152326 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_DBMS_SQL.FUNC_BODY_NULL_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_dbms_sql_parse_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fehler beim Parsen: %0';

wwv_flow_api.create_message (
  p_id=>195976504143152326 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_DBMS_SQL.PARSE_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_administration_deprecated
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Verworfen';

wwv_flow_api.create_message (
  p_id=>195976618967152327 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_ADMINISTRATION.DEPRECATED',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_cache_purge_session
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 Sessions wurden gelöscht.';

wwv_flow_api.create_message (
  p_id=>195976728029152327 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CACHE.PURGE_SESSION',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_cache_purge_dup_sessions
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 mehrfach vorhandene Sessions wurden gelöscht.';

wwv_flow_api.create_message (
  p_id=>195976825897152327 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CACHE.PURGE_DUP_SESSIONS',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_cache_obsolete
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'veraltet';

wwv_flow_api.create_message (
  p_id=>195976905191152327 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CACHE.OBSOLETE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_conditions_invalid_plsql_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Ungültige PL/SQL-Ausdrucksbedingung: %0';

wwv_flow_api.create_message (
  p_id=>195977026598152327 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CONDITIONS.INVALID_PLSQL_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_conditions_invalid_func_body_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Ungültige Funktions-Body-Bedingung: %0';

wwv_flow_api.create_message (
  p_id=>195977120579152328 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CONDITIONS.INVALID_FUNC_BODY_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_conditions_invalid_sql_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Ungültige SQL-Ausdrucksbedingung: %0';

wwv_flow_api.create_message (
  p_id=>195977211911152328 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CONDITIONS.INVALID_SQL_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_conditions_invalid_exists_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Ungültige Exists/Not Exists-Bedingung: %0';

wwv_flow_api.create_message (
  p_id=>195977304755152328 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CONDITIONS.INVALID_EXISTS_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_popup_filter_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Generieren von Popup-Werteliste mit Filter %0 nicht möglich';

wwv_flow_api.create_message (
  p_id=>195977419622152328 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.POPUP_FILTER_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_generate_query_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fehler beim Generieren von Abfrage: %0';

wwv_flow_api.create_message (
  p_id=>195977520964152328 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.GENERATE_QUERY_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_init_lov_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fehler beim Initialisieren von Werteliste: %0 ';

wwv_flow_api.create_message (
  p_id=>195977619563152329 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.INIT_LOV_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_unable_to_bind_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Binden von "%0" nicht möglich';

wwv_flow_api.create_message (
  p_id=>195977728620152329 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.UNABLE_TO_BIND_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_disp_only_list_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fehler: Schreibgeschützte Wertelisten müssen zwei Spalten auswählen.';

wwv_flow_api.create_message (
  p_id=>195977801663152329 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.DISP_ONLY_LIST_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_popup_lov_auth_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Authentifizierung der Popup-Werteliste nicht erfolgreich.';

wwv_flow_api.create_message (
  p_id=>195977931722152329 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.POPUP_LOV_AUTH_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_popup_lov_check_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Überprüfung der Prüfsumme (Checksum) für die Popup-Werteliste nicht erfolgreich.';

wwv_flow_api.create_message (
  p_id=>195978007040152329 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.POPUP_LOV_CHECK_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_init_query_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Die Abfrage konnte nicht initialisiert werden.';

wwv_flow_api.create_message (
  p_id=>195978113684152329 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.INIT_QUERY_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_checkbox_query_lov
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fehler beim Auswerten von Kontrollkästchen-Abfrage: %0';

wwv_flow_api.create_message (
  p_id=>195978223026152330 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.CHECKBOX_QUERY_LOV',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_comparison_contains
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'enthält';

wwv_flow_api.create_message (
  p_id=>195978324506152330 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_COMPARISON_CONTAINS',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_comparison_regexp_like
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'entspricht regulärem Ausdruck';

wwv_flow_api.create_message (
  p_id=>195978419416152330 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_COMPARISON_REGEXP_LIKE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_t_bold
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fett';

wwv_flow_api.create_message (
  p_id=>195978515434152330 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.T_BOLD',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_t_italics
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Kursiv';

wwv_flow_api.create_message (
  p_id=>195978621890152330 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.T_ITALICS',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_t_underline
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unterstrichen';

wwv_flow_api.create_message (
  p_id=>195978704240152331 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.T_UNDERLINE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_t_no_list
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Nummerierung';

wwv_flow_api.create_message (
  p_id=>195978819251152331 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.T_NO_LIST',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_t_bull_list
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Aufzählung';

wwv_flow_api.create_message (
  p_id=>195978922029152331 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.T_BULL_LIST',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_t_just_left
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Linksbündig';

wwv_flow_api.create_message (
  p_id=>195979015777152331 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.T_JUST_LEFT',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_t_just_cen
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Zentrieren';

wwv_flow_api.create_message (
  p_id=>195979125468152331 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.T_JUST_CEN',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_t_just_rt
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Rechtsbündig';

wwv_flow_api.create_message (
  p_id=>195979201420152332 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.T_JUST_RT',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_t_ind_left
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Links eingerückt';

wwv_flow_api.create_message (
  p_id=>195979321110152332 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.T_IND_LEFT',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_t_ind_right
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Nach rechts einrücken';

wwv_flow_api.create_message (
  p_id=>195979423768152332 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.T_IND_RIGHT',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message new_email_address
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Die neue E-Mail-Adresse für Ihren Application Express-Account.';

wwv_flow_api.create_message (
  p_id=>195979528796152332 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'NEW_EMAIL_ADDRESS',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_worksheet_show_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fehler beim Wiedergeben von Bericht: %0';

wwv_flow_api.create_message (
  p_id=>195979610218152332 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WORKSHEET.SHOW_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_generate_table_api_t_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'PL/SQL-Package %0 mit folgenden Prozeduren erstellen:'||chr(10)||
'';

wwv_flow_api.create_message (
  p_id=>195979731600152332 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_GENERATE_TABLE_API.T_CREATE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_generate_table_api_t_show_spec
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Spezifikation anzeigen';

wwv_flow_api.create_message (
  p_id=>195979801083152333 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_GENERATE_TABLE_API.T_SHOW_SPEC',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_generate_table_api_t_hide_spec
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Spezifikation ausblenden';

wwv_flow_api.create_message (
  p_id=>195979904315152333 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_GENERATE_TABLE_API.T_HIDE_SPEC',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_generate_table_api_t_show_body
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Body anzeigen';

wwv_flow_api.create_message (
  p_id=>195980020837152333 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_GENERATE_TABLE_API.T_SHOW_BODY',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_generate_table_api_t_hide_body
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Body ausblenden';

wwv_flow_api.create_message (
  p_id=>195980125754152333 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_GENERATE_TABLE_API.T_HIDE_BODY',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_generate_table_api_t_down_spec
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Spezifikation herunterladen';

wwv_flow_api.create_message (
  p_id=>195980218444152333 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_GENERATE_TABLE_API.T_DOWN_SPEC',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_generate_table_api_t_down_body
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Body herunterladen';

wwv_flow_api.create_message (
  p_id=>195980322217152334 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_GENERATE_TABLE_API.T_DOWN_BODY',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_generate_table_api_t_subprogram
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unterprogramm';

wwv_flow_api.create_message (
  p_id=>195980424182152334 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_GENERATE_TABLE_API.T_SUBPROGRAM',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_generate_table_api_t_description
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Beschreibung';

wwv_flow_api.create_message (
  p_id=>195980510751152334 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_GENERATE_TABLE_API.T_DESCRIPTION',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_generate_table_api_t_desc1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Zum Einfügen von Daten in %0. Der Primärschlüssel muss angegeben werden';

wwv_flow_api.create_message (
  p_id=>195980617582152334 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_GENERATE_TABLE_API.T_DESC1',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_generate_table_api_t_desc2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Hiermit können Sie Daten in %0 aktualisieren, die nach Primärschlüssel angegeben werden';

wwv_flow_api.create_message (
  p_id=>195980714908152334 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_GENERATE_TABLE_API.T_DESC2',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_generate_table_api_t_desc3
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'verwenden, um Daten anhand von Primärschlüsseln aus %0 zu löschen';

wwv_flow_api.create_message (
  p_id=>195980814980152335 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_GENERATE_TABLE_API.T_DESC3',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_generate_table_api_t_desc4
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'verwenden, um Daten anhand von Primärschlüssel(n) aus %0 abzurufen';

wwv_flow_api.create_message (
  p_id=>195980931253152335 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_GENERATE_TABLE_API.T_DESC4',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_generate_table_api_t_comment
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'-- Tabellen-API für Anwendung %0, %1 generiert';

wwv_flow_api.create_message (
  p_id=>195981030670152335 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_GENERATE_TABLE_API.T_COMMENT',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_no_column_info
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Keine Spalteninformationen verfügbar.';

wwv_flow_api.create_message (
  p_id=>195981130470152335 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_NO_COLUMN_INFO',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message url_prohibited
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Der angeforderte URL ist nicht zulässig. Wenden Sie sich an Ihren Administrator.';

wwv_flow_api.create_message (
  p_id=>195981225517152335 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'URL_PROHIBITED',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message html_body
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'HTML-Body';

wwv_flow_api.create_message (
  p_id=>195981301779152336 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'HTML_BODY',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_item_help_invalid_item_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Ungültige Element-ID: %0 ';

wwv_flow_api.create_message (
  p_id=>195981431180152336 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_ITEM_HELP.INVALID_ITEM_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message p_valid_page_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Es muss eine gültige Seitennummer angegeben werden. Beispiel: p?n=1234.';

wwv_flow_api.create_message (
  p_id=>195981522583152336 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'P.VALID_PAGE_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_template_name_already_exists
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Template-Name(n) %0 bereits vorhanden. Geben Sie einen neuen Namen ein.';

wwv_flow_api.create_message (
  p_id=>195981603281152336 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000.TEMPLATE_NAME_ALREADY_EXISTS',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_create_dynamic_query
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Sie haben die Erstellung einer Seite für einen interaktiven Bericht angefordert. Bitte bestätigen Sie Ihre Auswahl.';

wwv_flow_api.create_message (
  p_id=>195981715063152336 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CREATE_DYNAMIC_QUERY',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message htmlwithshortcuts
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'HTML mit Shortcuts';

wwv_flow_api.create_message (
  p_id=>195981809072152337 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'HTMLWITHSHORTCUTS',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message print_server_not_configured
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Aktuell können keine Berichte gedruckt werden, weil kein Druckserver konfiguriert ist.';

wwv_flow_api.create_message (
  p_id=>195981927830152337 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PRINT SERVER NOT CONFIGURED',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message list_templates
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Listen-Templates';

wwv_flow_api.create_message (
  p_id=>195982002533152337 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LIST_TEMPLATES',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message regions_list_template_override
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Regionslisten-Template außer Kraft setzen';

wwv_flow_api.create_message (
  p_id=>195982119416152337 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'REGIONS_LIST_TEMPLATE_OVERRIDE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message regioin_references
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Regionsreferenzen';

wwv_flow_api.create_message (
  p_id=>195982227594152337 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'REGIOIN_REFERENCES',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_max_row_cnt
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Diese Abfrage gibt über %0 Zeilen zurück. Filtern Sie die Daten, um vollständige Ergebnisse zu gewährleisten.';

wwv_flow_api.create_message (
  p_id=>195982324858152338 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_MAX_ROW_CNT',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_comparison_doesnot_contain
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'enthält nicht';

wwv_flow_api.create_message (
  p_id=>195982429302152338 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_COMPARISON_DOESNOT_CONTAIN',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_comparison_is_in_last
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ist in den letzten';

wwv_flow_api.create_message (
  p_id=>195982502792152338 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_COMPARISON_IS_IN_LAST',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_comparison_isnot_in_last
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ist nicht in den letzten';

wwv_flow_api.create_message (
  p_id=>195982602666152338 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_COMPARISON_ISNOT_IN_LAST',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_time_mins
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Minuten';

wwv_flow_api.create_message (
  p_id=>195982731439152338 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_TIME_MINS',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_time_hours
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Stunden';

wwv_flow_api.create_message (
  p_id=>195982809852152339 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_TIME_HOURS',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_time_days
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Tage';

wwv_flow_api.create_message (
  p_id=>195982902573152339 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_TIME_DAYS',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_time_weeks
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Wochen';

wwv_flow_api.create_message (
  p_id=>195983010690152339 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_TIME_WEEKS',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_time_months
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Monaten';

wwv_flow_api.create_message (
  p_id=>195983128774152339 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_TIME_MONTHS',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_time_years
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Jahren';

wwv_flow_api.create_message (
  p_id=>195983208546152339 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_TIME_YEARS',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message interactive_report
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Interaktiver Bericht';

wwv_flow_api.create_message (
  p_id=>195983330176152339 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INTERACTIVE_REPORT',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_and
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'und';

wwv_flow_api.create_message (
  p_id=>195983413783152340 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_AND',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p33_breadcrumb
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Wartungsanwendung generieren';

wwv_flow_api.create_message (
  p_id=>195983506972152340 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P33_BREADCRUMB',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_breadcrumb
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Anwendung generieren';

wwv_flow_api.create_message (
  p_id=>195983618258152340 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_BREADCRUMB',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message add_constraint
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Constraint hinzufügen';

wwv_flow_api.create_message (
  p_id=>195983715942152340 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ADD_CONSTRAINT',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_index
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Index erstellen';

wwv_flow_api.create_message (
  p_id=>195983804911152340 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_INDEX',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p49_app_defs
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Anwendungsstandards';

wwv_flow_api.create_message (
  p_id=>195983915951152341 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P49_APP_DEFS',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4500_p24_save_to_worksheet
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'In Arbeitsblatt speichern';

wwv_flow_api.create_message (
  p_id=>195984006341152341 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4500_P24_SAVE_TO_WORKSHEET',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message instadmin_invalid_wksp_id
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Ungültige Workspace-ID.';

wwv_flow_api.create_message (
  p_id=>195984127246152341 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTADMIN_INVALID_WKSP_ID',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message instadmin_wkspc_not_found
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Der Workspace wurde nicht gefunden.';

wwv_flow_api.create_message (
  p_id=>195984218936152341 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTADMIN_WKSPC_NOT_FOUND',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message flash_chart_loading_data
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Daten werden geladen...';

wwv_flow_api.create_message (
  p_id=>195984324157152341 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'FLASH_CHART.LOADING_DATA',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message flash_chart_waiting
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Daten werden geladen. Bitte warten.';

wwv_flow_api.create_message (
  p_id=>195984430795152342 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'FLASH_CHART.WAITING',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_api_check_priv
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Der Benutzer %0 hat keine Berechtigungen für das %1-Schema.';

wwv_flow_api.create_message (
  p_id=>195984513323152342 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_API.CHECK_PRIV',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_api_create_plan_table
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Plantabelle zur einfachen Erstellung der Explain-Plan-Anweisung';

wwv_flow_api.create_message (
  p_id=>195984629045152342 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_API.CREATE_PLAN_TABLE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_api_error_msg
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fehler in Zeile %0: %1';

wwv_flow_api.create_message (
  p_id=>195984726430152342 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_API.ERROR_MSG',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_api_run_sql
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Das Schema "%0" ist in der Datenbank nicht vorhanden. Wenden Sie sich bzgl. des korrekten Standardschemas an Ihren Workspace-Administrator.';

wwv_flow_api.create_message (
  p_id=>195984828312152342 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_API.RUN_SQL',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_api_insert_script_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fehler beim Einfügen von Skript in Dateitabelle.';

wwv_flow_api.create_message (
  p_id=>195984917875152343 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_API.INSERT_SCRIPT_ERROR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_api_parse_script_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fehler beim Parsen von Skript.';

wwv_flow_api.create_message (
  p_id=>195985026542152343 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_API.PARSE_SCRIPT_ERROR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_api_create_script_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fehler beim Erstellen von Skriptdatei.';

wwv_flow_api.create_message (
  p_id=>195985106787152343 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_API.CREATE_SCRIPT_ERROR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_provisioning_not_implemented
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Nicht implementiert.';

wwv_flow_api.create_message (
  p_id=>195985206352152343 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PROVISIONING.NOT_IMPLEMENTED',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4350_product_build
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Produkt-Build:';

wwv_flow_api.create_message (
  p_id=>195985314648152343 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4350.PRODUCT_BUILD',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4350_schema_compatibility
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Schemakompatibilität:';

wwv_flow_api.create_message (
  p_id=>195985408536152343 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4350.SCHEMA_COMPATIBILITY',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4350_last_ddl_time
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Letzte DDL-Zeit:';

wwv_flow_api.create_message (
  p_id=>195985500848152344 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4350.LAST_DDL_TIME',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4350_host_schema
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Host-Schema:';

wwv_flow_api.create_message (
  p_id=>195985611540152344 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4350.HOST_SCHEMA',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4350_application_owner
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Anwendungseigentümer:';

wwv_flow_api.create_message (
  p_id=>195985712134152344 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4350.APPLICATION_OWNER',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4350_workspace_id
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Workspace-ID:';

wwv_flow_api.create_message (
  p_id=>195985807682152344 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4350.WORKSPACE_ID',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4350_workspace_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Name für Workspace:';

wwv_flow_api.create_message (
  p_id=>195985927511152344 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4350.WORKSPACE_NAME',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4350_current_user
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Aktueller Benutzer:';

wwv_flow_api.create_message (
  p_id=>195986016717152344 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4350.CURRENT_USER',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4350_language_preference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Voreinstellung für Sprache:';

wwv_flow_api.create_message (
  p_id=>195986108573152345 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4350.LANGUAGE_PREFERENCE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4350_current_time_on_server
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Aktuelle Uhrzeit (auf dem Server):';

wwv_flow_api.create_message (
  p_id=>195986219586152345 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4350.CURRENT_TIME_ON_SERVER',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_api_add_member_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fehler beim Hinzufügen von Mitglied.';

wwv_flow_api.create_message (
  p_id=>195986303542152345 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_API.ADD_MEMBER_ERROR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_api_update_member_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fehler beim Aktualisieren von Mitglied.';

wwv_flow_api.create_message (
  p_id=>195986416440152345 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_API.UPDATE_MEMBER_ERROR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_api_create_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fehler beim Erstellen von Skript.';

wwv_flow_api.create_message (
  p_id=>195986517424152345 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_API.CREATE_ERROR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message custom_auth_sso_missing_app_reg1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fehler in portal_sso_redirect: Fehlende Informationen zur Anwendungsregistrierung:';

wwv_flow_api.create_message (
  p_id=>195986627551152346 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CUSTOM_AUTH_SSO.MISSING_APP_REG1',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message custom_auth_sso_missing_app_reg2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Registrieren Sie diese Anwendung entsprechend der Beschreibung im Installation Guide.';

wwv_flow_api.create_message (
  p_id=>195986700499152346 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CUSTOM_AUTH_SSO.MISSING_APP_REG2',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message custom_auth_sso_redir_err1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Ausführen der Prozedur portal_sso_redirect als Schema %0 mit Partneranwendung %1 nicht möglich.';

wwv_flow_api.create_message (
  p_id=>195986814514152346 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CUSTOM_AUTH_SSO.REDIR_ERR1',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message custom_auth_sso_process_success_err1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Ungültiger Caller von %0-Prozedur:';

wwv_flow_api.create_message (
  p_id=>195986906622152346 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CUSTOM_AUTH_SSO.PROCESS_SUCCESS_ERR1',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message please_contact_administrator
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Wenden Sie sich an den Administrator.';

wwv_flow_api.create_message (
  p_id=>195987013056152346 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PLEASE_CONTACT_ADMINISTRATOR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message custom_auth_sso_process_success_err2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fehler beim Bestimmen des Callers von %0';

wwv_flow_api.create_message (
  p_id=>195987107381152346 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CUSTOM_AUTH_SSO.PROCESS_SUCCESS_ERR2',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message custom_auth_sso_invalid_app_session
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Ungültige Anwendungssession in URLC-Token: %0';

wwv_flow_api.create_message (
  p_id=>195987229510152346 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CUSTOM_AUTH_SSO.INVALID_APP_SESSION',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message custom_auth_sso_generic_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fehler in %0';

wwv_flow_api.create_message (
  p_id=>195987304560152347 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CUSTOM_AUTH_SSO_GENERIC_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message custom_auth_sso_bad_urlc
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Ungültiges %0 in %1 Token von SSO zurückgegeben.';

wwv_flow_api.create_message (
  p_id=>195987420565152347 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CUSTOM_AUTH_SSO.BAD_URLC',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message custom_auth_sso_parse_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Ausführen von %0-Prozedur als Schema %1 mit Partneranwendung %2 nicht möglich';

wwv_flow_api.create_message (
  p_id=>195987517189152347 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CUSTOM_AUTH_SSO.PARSE_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_render_shortcut_unknown_type_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fehler: Unbekannter Shortcut-Typ.';

wwv_flow_api.create_message (
  p_id=>195987631221152347 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_RENDER_SHORTCUT.UNKNOWN_TYPE_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_speling_add_word
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Wort hinzufügen';

wwv_flow_api.create_message (
  p_id=>195987719507152347 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_SPELING.ADD_WORD',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_speling_word_added
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 wurde zu Ihrem Dictionary hinzugefügt.';

wwv_flow_api.create_message (
  p_id=>195987801220152347 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_SPELING.WORD_ADDED',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_speling_dup_word_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 ist bereits in Ihrem Data Dictionary.';

wwv_flow_api.create_message (
  p_id=>195987926758152348 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_SPELING.DUP_WORD_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_speling_button_done
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fertig';

wwv_flow_api.create_message (
  p_id=>195988032324152348 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_SPELING.BUTTON_DONE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_speling_button_cancel
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Abbrechen';

wwv_flow_api.create_message (
  p_id=>195988125398152348 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_SPELING.BUTTON_CANCEL',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_speling_button_apply_changes
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Änderungen anwenden';

wwv_flow_api.create_message (
  p_id=>195988228310152348 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_SPELING.BUTTON_APPLY_CHANGES',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_speling_button_add_to_dictionary
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Zu Data Dictionary hinzufügen';

wwv_flow_api.create_message (
  p_id=>195988314385152348 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_SPELING.BUTTON_ADD_TO_DICTIONARY',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_speling_pick_a_word
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Wort auswählen';

wwv_flow_api.create_message (
  p_id=>195988418828152349 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_SPELING.PICK_A_WORD',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_speling_enter_new_word
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Geben Sie ein neues Wort ein.';

wwv_flow_api.create_message (
  p_id=>195988521158152349 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_SPELING.ENTER_NEW_WORD',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_region_tree_unexpected_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unerwarteter Fehler %0';

wwv_flow_api.create_message (
  p_id=>195988619234152349 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_REGION_TREE.UNEXPECTED_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_calculator_window_title
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Rechner';

wwv_flow_api.create_message (
  p_id=>195988708917152349 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_CALCULATOR.WINDOW_TITLE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_calculator_cancel
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Abbrechen';

wwv_flow_api.create_message (
  p_id=>195988809086152349 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_CALCULATOR.CANCEL',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_calculator_done
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fertig';

wwv_flow_api.create_message (
  p_id=>195988923273152349 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_CALCULATOR.DONE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_builder_no_flow_selected
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Es ist keine Anwendung ausgewählt.';

wwv_flow_api.create_message (
  p_id=>195989015610152350 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_BUILDER.NO_FLOW_SELECTED',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message vertical
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Vertikal';

wwv_flow_api.create_message (
  p_id=>195989119886152350 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'VERTICAL',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message horizontal
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Horizontal';

wwv_flow_api.create_message (
  p_id=>195989223285152350 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'HORIZONTAL',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_fnd_user_api_t_username
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Benutzername';

wwv_flow_api.create_message (
  p_id=>195989331546152350 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FND_USER_API.T_USERNAME',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_user_api_t_email
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'E-Mail';

wwv_flow_api.create_message (
  p_id=>195989425173152350 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_USER_API.T_EMAIL',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_fnd_user_api_t_password
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Kennwort';

wwv_flow_api.create_message (
  p_id=>195989507908152350 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FND_USER_API.T_PASSWORD',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_fnd_user_api_t_privilege
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Berechtigungen';

wwv_flow_api.create_message (
  p_id=>195989623808152351 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FND_USER_API.T_PRIVILEGE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_fnd_user_api_t_message
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Es wären %0 Benutzer geladen worden.';

wwv_flow_api.create_message (
  p_id=>195989724356152351 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FND_USER_API.T_MESSAGE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_menu
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Navigationspfad';

wwv_flow_api.create_message (
  p_id=>195989818364152351 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.MENU',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_svg_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fehler';

wwv_flow_api.create_message (
  p_id=>195989925382152351 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SVG.ERROR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_svg_max_rows_gt_zero_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Validierung nicht erfolgreich: Die maximale Anzahl der anzuzeigenden Zeilen muss größer als Null sein.';

wwv_flow_api.create_message (
  p_id=>195990001583152351 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SVG.MAX_ROWS_GT_ZERO_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_report3_invalid_col_num
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'In der Abfrage ist eine ungültige Anzahl der Spalten definiert. Es werden %0 Spalten für diesen Regionstyp benötigt';

wwv_flow_api.create_message (
  p_id=>195990123360152351 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_REPORT3.INVALID_COL_NUM',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_svg_axis_max_gt_min_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Validierung nicht erfolgreich: Das Maximum der Achse muss größer als das Minimum der Achse sein.';

wwv_flow_api.create_message (
  p_id=>195990200761152352 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SVG.AXIS_MAX_GT_MIN_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_svg_bar_width_gt_zero_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Validierung nicht erfolgreich: Die Balkenbreite muss größer als Null sein.';

wwv_flow_api.create_message (
  p_id=>195990318567152352 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SVG.BAR_WIDTH_GT_ZERO_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_svg_axis_int_gt_zero_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Validierung nicht erfolgreich: Das Achsenintervall muss größer als Null sein.';

wwv_flow_api.create_message (
  p_id=>195990406686152352 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SVG.AXIS_INT_GT_ZERO_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_svg_axis_min_gt_zero_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Validierung nicht erfolgreich: Das Minimum der Achse muss größer oder gleich 0 sein.';

wwv_flow_api.create_message (
  p_id=>195990521810152352 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SVG.AXIS_MIN_GT_ZERO_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_svg_axis_max_gt_zero_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Validierung nicht erfolgreich: Das Maximum der Achse muss größer als Null sein.';

wwv_flow_api.create_message (
  p_id=>195990600573152352 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SVG.AXIS_MAX_GT_ZERO_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message query_invalid_no_select
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Ungültige Abfrage, keine SELECT-Anweisung gefunden';

wwv_flow_api.create_message (
  p_id=>195990710904152352 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'QUERY.INVALID_NO_SELECT',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_svg_gaps_gt_zero_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Validierung nicht erfolgreich: Der Abstand zwischen den Balken muss größer oder gleich 0 sein.';

wwv_flow_api.create_message (
  p_id=>195990803392152353 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SVG.GAPS_GT_ZERO_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_svg_y_axis_max_gt_min_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Validierung nicht erfolgreich: Das Maximum der Y-Achse muss größer als das Minimum der Achse sein.';

wwv_flow_api.create_message (
  p_id=>195990913026152353 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SVG.Y_AXIS_MAX_GT_MIN_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_svg_x_axis_int_gt_zero_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Validierung nicht erfolgreich: Das X-Achsenintervall muss größer als Null sein.';

wwv_flow_api.create_message (
  p_id=>195991023440152353 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SVG.X_AXIS_INT_GT_ZERO_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_svg_y_axis_int_gt_zero_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Validierung nicht erfolgreich: Das Y-Achsenintervall muss größer als Null sein.';

wwv_flow_api.create_message (
  p_id=>195991127591152353 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SVG.Y_AXIS_INT_GT_ZERO_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_svg_x_axis_min_gt_zero_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Validierung nicht erfolgreich: Das Minimum der X-Achse muss größer oder gleich 0 sein.';

wwv_flow_api.create_message (
  p_id=>195991203310152353 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SVG.X_AXIS_MIN_GT_ZERO_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_svg_y_axis_min_gt_zero_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Validierung nicht erfolgreich: Das Minimum der Y-Achse muss größer oder gleich 0 sein.';

wwv_flow_api.create_message (
  p_id=>195991311512152353 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SVG.Y_AXIS_MIN_GT_ZERO_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_svg_x_axis_max_gt_zero_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Validierung nicht erfolgreich: Das Maximum der X-Achse muss größer als Null sein.';

wwv_flow_api.create_message (
  p_id=>195991410366152354 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SVG.X_AXIS_MAX_GT_ZERO_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_svg_y_axis_max_gt_zero_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Validierung nicht erfolgreich: Das Maximum der Y-Achse muss größer als Null sein.';

wwv_flow_api.create_message (
  p_id=>195991522520152354 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SVG.Y_AXIS_MAX_GT_ZERO_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_svg_unable_get_color_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Abrufen von Farbe %0 nicht möglich';

wwv_flow_api.create_message (
  p_id=>195991629104152354 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SVG.UNABLE_GET_COLOR_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_svg_func_ret_sql_qry_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Funktion, die SQL-Abfrage zurückgibt: Die Abfrage kann innerhalb von Application Builder nicht geparst werden. %0';

wwv_flow_api.create_message (
  p_id=>195991708346152354 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SVG.FUNC_RET_SQL_QRY_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_svg_parse_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fehler beim Parsen: %0 ';

wwv_flow_api.create_message (
  p_id=>195991814848152354 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SVG.PARSE_ERROR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_svg_fetch_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fehler beim Abrufen: %0';

wwv_flow_api.create_message (
  p_id=>195991919554152354 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SVG.FETCH_ERROR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_svg_unable_calc_graph_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Berechnen von Position für Seite null von Diagramm nicht möglich: %0';

wwv_flow_api.create_message (
  p_id=>195992001995152355 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SVG.UNABLE_CALC_GRAPH_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_svg_svg_chart_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'SVG-Diagrammfehler: %0';

wwv_flow_api.create_message (
  p_id=>195992115465152355 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SVG.SVG_CHART_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_svg_more_data_fnd_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Weitere Daten gefunden. Es können jedoch nur maximal 30 Werte angezeigt werden.';

wwv_flow_api.create_message (
  p_id=>195992212457152355 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SVG.MORE_DATA_FND_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_shuttle_top
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Oben';

wwv_flow_api.create_message (
  p_id=>195992308363152355 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.SHUTTLE_TOP',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_shuttle_bottom
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unten';

wwv_flow_api.create_message (
  p_id=>195992423051152355 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.SHUTTLE_BOTTOM',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_shuttle_up
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Nach oben';

wwv_flow_api.create_message (
  p_id=>195992509402152355 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.SHUTTLE_UP',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_shuttle_down
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Nach unten';

wwv_flow_api.create_message (
  p_id=>195992617681152356 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.SHUTTLE_DOWN',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_shuttle_move
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Verschieben';

wwv_flow_api.create_message (
  p_id=>195992703399152356 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.SHUTTLE_MOVE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_shuttle_move_all
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Alle verschieben';

wwv_flow_api.create_message (
  p_id=>195992827346152356 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.SHUTTLE_MOVE_ALL',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_shuttle_remove
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Entfernen';

wwv_flow_api.create_message (
  p_id=>195992927410152356 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.SHUTTLE_REMOVE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_shuttle_remove_all
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Alle entfernen';

wwv_flow_api.create_message (
  p_id=>195993019591152356 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.SHUTTLE_REMOVE_ALL',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_shuttle_reset
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Zurücksetzen';

wwv_flow_api.create_message (
  p_id=>195993102830152356 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.SHUTTLE_RESET',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_asfcookie_unable_fnd_userid_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'USERID in Cookie nicht gefunden: %0';

wwv_flow_api.create_message (
  p_id=>195993201889152357 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_ASFCOOKIE.UNABLE_FND_USERID_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_asfcookie_exception
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Exception';

wwv_flow_api.create_message (
  p_id=>195993329924152357 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_ASFCOOKIE.EXCEPTION',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_asfcookie_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fehler: %0';

wwv_flow_api.create_message (
  p_id=>195993417906152357 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_ASFCOOKIE.ERROR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_asfcookie_invalid_cookie_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Ungültiges ASFCOOKIE. Melden Sie sich erneut bei Ihrer Anwendung an.';

wwv_flow_api.create_message (
  p_id=>195993526652152357 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_ASFCOOKIE.INVALID_COOKIE_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4350_creating_workspace
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Workspace wird erstellt';

wwv_flow_api.create_message (
  p_id=>195993608550152357 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4350.CREATING_WORKSPACE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message pagination_next
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Weiter';

wwv_flow_api.create_message (
  p_id=>195993711662152357 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PAGINATION.NEXT',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message pagination_next_set
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Nächste Gruppe';

wwv_flow_api.create_message (
  p_id=>195993831496152358 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PAGINATION.NEXT_SET',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message pagination_previous
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Zurück';

wwv_flow_api.create_message (
  p_id=>195993903566152358 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PAGINATION.PREVIOUS',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message pagination_previous_set
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Vorherige Gruppe';

wwv_flow_api.create_message (
  p_id=>195994023239152358 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PAGINATION.PREVIOUS_SET',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_security_invalid_user_pass_cookie_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Benutzername/Kennwort ist ungültig, oder das Cookie ist abgelaufen. Melden Sie sich erneut an.';

wwv_flow_api.create_message (
  p_id=>195994108081152358 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SECURITY.INVALID_USER_PASS_COOKIE_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_calendar2_from_query
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 aus Abfrage %1';

wwv_flow_api.create_message (
  p_id=>195994200435152358 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_CALENDAR2.FROM_QUERY',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_calendar2_in_query
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 in Abfrage %1';

wwv_flow_api.create_message (
  p_id=>195994313498152359 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_CALENDAR2.IN_QUERY',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_calendar2_fetch_cal_cursor_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fehler beim Abrufen von Kalender-Cursor: %0';

wwv_flow_api.create_message (
  p_id=>195994412206152359 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_CALENDAR2.FETCH_CAL_CURSOR_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_no_sgid_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Sicherheitsgruppen-ID (Ihre Workspace-ID) ist nicht festgelegt.';

wwv_flow_api.create_message (
  p_id=>195994520752152359 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY.NO_SGID_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_execution_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fehler bei Ausführung von wwv_flow_copy: %0 >> %1';

wwv_flow_api.create_message (
  p_id=>195994610688152359 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY.EXECUTION_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_button_execution_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fehler bei Ausführung von wwv_flow_copy_button: %0 >> %1';

wwv_flow_api.create_message (
  p_id=>195994700015152359 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_BUTTON.EXECUTION_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_page_item_execution_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fehler bei Ausführung von wwv_flow_copy_page_item: %0 >> %1';

wwv_flow_api.create_message (
  p_id=>195994827349152359 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_PAGE_ITEM.EXECUTION_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_lov_numeric_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Wertelisten-ID "%0" ist nicht numerisch.';

wwv_flow_api.create_message (
  p_id=>195994932652152360 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_LOV.NUMERIC_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_lov_not_found_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Wertelisten-ID "%0" nicht gefunden.';

wwv_flow_api.create_message (
  p_id=>195995008906152360 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_LOV.NOT_FOUND_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_lov_execution_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fehler bei Ausführung von wwv_flow_copy_lov: %0';

wwv_flow_api.create_message (
  p_id=>195995116557152360 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_LOV.EXECUTION_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_util_unable_to_find_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Shortcut (%0) für den Kopiervorgang nicht gefunden.';

wwv_flow_api.create_message (
  p_id=>195995220499152360 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_UTIL.UNABLE_TO_FIND_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4050_ws_created
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Der Workspace %0 wurde erstellt, und eine Bestätigungs-E-Mail wurde am %2 an %1 gesendet.';

wwv_flow_api.create_message (
  p_id=>195995305854152360 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4050.WS_CREATED',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message return_to_login_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Zurück zur %0-Anmeldeseite';

wwv_flow_api.create_message (
  p_id=>195995426214152360 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'RETURN_TO_LOGIN_PAGE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4350_disable_work_prov
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Die Workspace-Erstellung wurde vorübergehend deaktiviert.';

wwv_flow_api.create_message (
  p_id=>195995522439152361 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4350.DISABLE.WORK.PROV',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_add_constraint
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Constraint %0 hinzufügen';

wwv_flow_api.create_message (
  p_id=>195995610536152361 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_ADD_CONSTRAINT',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message created_on
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erstellt am';

wwv_flow_api.create_message (
  p_id=>195995732630152361 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATED_ON',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message updated_on
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Aktualisiert am';

wwv_flow_api.create_message (
  p_id=>195995812944152361 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'UPDATED_ON',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_row_order
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Zeilenreihenfolge';

wwv_flow_api.create_message (
  p_id=>195995930391152361 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_ROW_ORDER',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_as_of
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Ab %0';

wwv_flow_api.create_message (
  p_id=>195996008389152361 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_AS_OF',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_min_ago
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'vor %0 Minuten';

wwv_flow_api.create_message (
  p_id=>195996108146152362 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_MIN_AGO',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_format_mask
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Formatmaske';

wwv_flow_api.create_message (
  p_id=>195996208278152362 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_FORMAT_MASK',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_computation
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Berechnung';

wwv_flow_api.create_message (
  p_id=>195996314818152362 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_COMPUTATION',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_choose_download_format
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Format für Herunterladen von Bericht wählen';

wwv_flow_api.create_message (
  p_id=>195996406111152362 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_CHOOSE_DOWNLOAD_FORMAT',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message ir_frm_nav_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Form-Navigation berechnen nicht möglich. %0';

wwv_flow_api.create_message (
  p_id=>195996511586152362 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'IR_FRM_NAV_ERROR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_report_view
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'&lt; Berichtansicht';

wwv_flow_api.create_message (
  p_id=>195996608899152362 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_REPORT_VIEW',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_row_of
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Zeile %0 von %1';

wwv_flow_api.create_message (
  p_id=>195996722093152363 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_ROW_OF',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message ir_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0-Fehler. %1';

wwv_flow_api.create_message (
  p_id=>195996824885152363 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'IR_ERROR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_create_flow_api_verify_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0-Fehler überprüfen: %1';

wwv_flow_api.create_message (
  p_id=>195996910202152363 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CREATE_FLOW_API.VERIFY_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_create_flow_api_create_page_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fehler beim Erstellen von Anwendung (Seite erstellen): %0 ';

wwv_flow_api.create_message (
  p_id=>195997031246152363 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CREATE_FLOW_API.CREATE_PAGE_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_create_flow_api_create_pg_template_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fehler beim Erstellen von Anwendung (Seiten-Template erstellen): %0';

wwv_flow_api.create_message (
  p_id=>195997123134152363 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CREATE_FLOW_API.CREATE_PG_TEMPLATE_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_create_flow_api_create_field_template_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fehler beim Erstellen von Anwendung (Feld-Template erstellen): %0';

wwv_flow_api.create_message (
  p_id=>195997203872152363 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CREATE_FLOW_API.CREATE_FIELD_TEMPLATE_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_create_flow_create_rpt_template_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fehler beim Erstellen von Anwendung (Berichts-Templates erstellen): %0';

wwv_flow_api.create_message (
  p_id=>195997307608152364 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CREATE_FLOW.CREATE_RPT_TEMPLATE_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_create_flow_api_create_region_template_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fehler beim Erstellen von Anwendung (Regions-Templates erstellen): %0';

wwv_flow_api.create_message (
  p_id=>195997426372152364 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CREATE_FLOW_API.CREATE_REGION_TEMPLATE_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_create_flow_api_create_list_template_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fehler beim Erstellen von Anwendung (Listen-Templates erstellen): %0';

wwv_flow_api.create_message (
  p_id=>195997515126152364 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CREATE_FLOW_API.CREATE_LIST_TEMPLATE_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_create_flow_api_create_menu_template_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fehler beim Erstellen von Anwendung (Navigationspfad-Templates erstellen): %0';

wwv_flow_api.create_message (
  p_id=>195997616283152364 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CREATE_FLOW_API.CREATE_MENU_TEMPLATE_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_create_flow_api_create_popup_template_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fehler beim Erstellen von Anwendung (Template für Popup-Werteliste erstellen): %0';

wwv_flow_api.create_message (
  p_id=>195997704471152364 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CREATE_FLOW_API.CREATE_POPUP_TEMPLATE_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_create_flow_api_create_standard_tabs_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fehler beim Erstellen von Anwendung (Standardregisterkarten erstellen): %0';

wwv_flow_api.create_message (
  p_id=>195997810931152364 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CREATE_FLOW_API.CREATE_STANDARD_TABS_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_create_flow_api_compute_tab_target_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fehler beim Erstellen von Anwendung (Registerkartenziele berechnen): %0';

wwv_flow_api.create_message (
  p_id=>195997910926152365 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CREATE_FLOW_API.COMPUTE_TAB_TARGET_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_create_flow_api_create_parent_tabs_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fehler beim Erstellen von Anwendung (übergeordnete Registerkarten erstellen): %0';

wwv_flow_api.create_message (
  p_id=>195998004754152365 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CREATE_FLOW_API.CREATE_PARENT_TABS_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_create_flow_api_copy_page_template_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fehler beim Erstellen von Anwendung (Seiten-Template kopieren): %0';

wwv_flow_api.create_message (
  p_id=>195998108180152365 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CREATE_FLOW_API.COPY_PAGE_TEMPLATE_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_create_flow_api_copy_field_template_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fehler beim Erstellen von Anwendung (Feld-Template kopieren): %0';

wwv_flow_api.create_message (
  p_id=>195998207768152365 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CREATE_FLOW_API.COPY_FIELD_TEMPLATE_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_create_flow_api_copy_report_templates_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fehler beim Erstellen von Anwendung (Berichts-Templates kopieren): %0 ';

wwv_flow_api.create_message (
  p_id=>195998329809152365 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CREATE_FLOW_API.COPY_REPORT_TEMPLATES_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_create_flow_api_copy_region_template_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fehler beim Erstellen von Anwendung (Regions-Templates kopieren): %0';

wwv_flow_api.create_message (
  p_id=>195998413935152365 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CREATE_FLOW_API.COPY_REGION_TEMPLATE_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_create_flow_api_copy_list_template_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fehler beim Erstellen von Anwendung (Listen-Templates kopieren): %0';

wwv_flow_api.create_message (
  p_id=>195998516704152366 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CREATE_FLOW_API.COPY_LIST_TEMPLATE_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_create_flow_api_copy_menu_template_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fehler beim Erstellen von Anwendung (Navigationspfad-Templates kopieren): %0';

wwv_flow_api.create_message (
  p_id=>195998628555152366 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CREATE_FLOW_API.COPY_MENU_TEMPLATE_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_create_flow_api_copy_button_template_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fehler beim Erstellen von Anwendung (Schaltflächen-Templates kopieren): %0';

wwv_flow_api.create_message (
  p_id=>195998723001152366 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CREATE_FLOW_API.COPY_BUTTON_TEMPLATE_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_create_flow_api_copy_navbar_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fehler beim Erstellen von Anwendung (Navigationsleiste kopieren): %0';

wwv_flow_api.create_message (
  p_id=>195998814051152366 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CREATE_FLOW_API.COPY_NAVBAR_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_create_flow_api_copy_lov_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fehler beim Erstellen von Anwendung (Werteliste kopieren): %0';

wwv_flow_api.create_message (
  p_id=>195998916614152366 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CREATE_FLOW_API.COPY_LOV_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_create_flow_api_copy_security_scheme_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fehler beim Erstellen von Anwendung (Sicherheitsschema kopieren): %0';

wwv_flow_api.create_message (
  p_id=>195999019625152366 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CREATE_FLOW_API.COPY_SECURITY_SCHEME_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_crypt_key_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Der Schlüssel muss 8, 16 oder 24 Byte enthalten.';

wwv_flow_api.create_message (
  p_id=>195999111501152367 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_CRYPT.KEY_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_css_api_unable_to_remove_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Entfernen von CSS nicht möglich: %0';

wwv_flow_api.create_message (
  p_id=>195999231218152367 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CSS_API.UNABLE_TO_REMOVE_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_debugtab_biu_fer_invalid_date_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Ungültiges Datumsformat.';

wwv_flow_api.create_message (
  p_id=>195999318782152367 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_DEBUGTAB_BIU_FER.INVALID_DATE_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_dbms_sql_unable_to_bind_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Binden von %0 nicht möglich. Überprüfen Sie, ob die Länge des Elements maximal 30 Byte beträgt. Verwenden Sie die v()-Syntax, um Elemente zu referenzieren, die länger als 30 Byte sind. %1';

wwv_flow_api.create_message (
  p_id=>195999403458152367 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_DBMS_SQL.UNABLE_TO_BIND_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message run_only
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Nur ausführen';

wwv_flow_api.create_message (
  p_id=>195999509178152367 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'RUN_ONLY',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wizapi_delete_checked
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Markierte Elemente löschen';

wwv_flow_api.create_message (
  p_id=>195999605954152368 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WIZAPI_DELETE_CHECKED',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p18_script_olb_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Name der Forms-Objekt-Library-XML-Datei';

wwv_flow_api.create_message (
  p_id=>195999707889152368 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P18_SCRIPT_OLB_NAME',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_create_flow_api_copy_authorization_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fehler beim Erstellen von Anwendung (Autorisierungsschemas kopieren): %0';

wwv_flow_api.create_message (
  p_id=>195999809284152368 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CREATE_FLOW_API.COPY_AUTHORIZATION_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_create_flow_api_copy_authentication_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fehler beim Erstellen von Anwendung (Authentifizierungsschemas kopieren): %0';

wwv_flow_api.create_message (
  p_id=>195999908656152368 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CREATE_FLOW_API.COPY_AUTHENTICATION_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_cannot_determine_flow_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fehler: Bestimmen der Anwendung einer angegebenen Sicherheitsgruppen-ID und Anwendungsaliasnamen nicht möglich.';

wwv_flow_api.create_message (
  p_id=>196000030116152368 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.CANNOT_DETERMINE_FLOW_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_alias_convert_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Der Anwendungsaliasname "%0" kann nicht in eine eindeutige Anwendungs-ID konvertiert werden.';

wwv_flow_api.create_message (
  p_id=>196000125871152368 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.ALIAS_CONVERT_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_alias_exist_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Aliasname "%0" ist nicht vorhanden.';

wwv_flow_api.create_message (
  p_id=>196000225256152369 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.ALIAS_EXIST_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_unable_home_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Es ist nicht möglich, Sie zur Homepage weiterzuleiten.';

wwv_flow_api.create_message (
  p_id=>196000328960152369 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.UNABLE_HOME_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_update_sub_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fehler in update_substitution_cache: %0';

wwv_flow_api.create_message (
  p_id=>196000423267152369 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.UPDATE_SUB_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_dml_dml_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fehler in DML: p_rowid=%0, p_alt_rowid=%1, p_rowid2=%2, p_alt_rowid2=%3. %4';

wwv_flow_api.create_message (
  p_id=>196000503278152369 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_DML.DML_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_conditions_unable_proc_cond_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Verarbeiten von Bedingungstyp "%0" in wwv_flow_conditions nicht möglich.';

wwv_flow_api.create_message (
  p_id=>196000624411152369 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CONDITIONS.UNABLE_PROC_COND_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_conditions_unexpected_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unerwarteter Fehler in wwv_flow_conditions. Die Funktion muss einen Wert zurückgeben.';

wwv_flow_api.create_message (
  p_id=>196000710899152369 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CONDITIONS.UNEXPECTED_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message mru_no_rows_to_process
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Es sind keine Zeilen für die Verarbeitung vorhanden';

wwv_flow_api.create_message (
  p_id=>196000822989152370 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'MRU.NO_ROWS_TO_PROCESS',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message mru_table_owner_not_specified
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Der Tabelleneigentümer wurde nicht angegeben';

wwv_flow_api.create_message (
  p_id=>196000917446152370 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'MRU.TABLE_OWNER_NOT_SPECIFIED',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message mru_table_name_not_specified
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Der Tabellenname wurde nicht angegeben';

wwv_flow_api.create_message (
  p_id=>196001001967152370 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'MRU.TABLE_NAME_NOT_SPECIFIED',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message mru_prim_key_col_not_specified
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Die Primärschlüsselspalte wurde nicht angegeben';

wwv_flow_api.create_message (
  p_id=>196001117933152370 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'MRU.PRIM_KEY_COL_NOT_SPECIFIED',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message mru_fcs_missing
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Die Checksum-Spalte (FCS) ist erforderlich, wurde aber nicht angegeben';

wwv_flow_api.create_message (
  p_id=>196001219072152370 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'MRU.FCS_MISSING',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message mru_invalid_prim_key_col
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Die angegebene Primärschlüsselspalte wurde in der Auswahlliste der Abfrage nicht ermittelt';

wwv_flow_api.create_message (
  p_id=>196001301609152370 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'MRU.INVALID_PRIM_KEY_COL',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message mru_no_prim_key_vals
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Es wurden keine Primärschlüsselwerte angegeben. Um Aktualisierungen ausführen zu können, muss mindestens eine Zeile angegeben werden';

wwv_flow_api.create_message (
  p_id=>196001410626152371 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'MRU.NO_PRIM_KEY_VALS',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_remove_cal_template_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Abonnieren von Kalender-Template nicht möglich. %0'||chr(10)||
'';

wwv_flow_api.create_message (
  p_id=>196001504195152371 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.REMOVE_CAL_TEMPLATE_REFERENCE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_publish_cal_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Veröffentlichen von Kalender-Template nicht möglich. %0'||chr(10)||
'';

wwv_flow_api.create_message (
  p_id=>196001614583152371 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.PUBLISH_CAL_TEMPLATE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message autocommit
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'COMMIT-Anweisung nicht anwendbar. Alle Anweisungen werden automatisch festgeschrieben.';

wwv_flow_api.create_message (
  p_id=>196001709863152371 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'AUTOCOMMIT',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message rollback
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ROLLBACK-Anweisung nicht anwendbar. Alle Anweisungen werden automatisch festgeschrieben.';

wwv_flow_api.create_message (
  p_id=>196001800367152371 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ROLLBACK',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p254_validation
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Sie müssen mindestens eine Region für den Erstellvorgang angeben.';

wwv_flow_api.create_message (
  p_id=>196001900633152371 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000.P254.VALIDATION',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p295_validation
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Sie müssen mindestens eine Seite für den Erstellvorgang angeben.';

wwv_flow_api.create_message (
  p_id=>196002030165152372 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000.P295.VALIDATION',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message mru_sec_key_col_not_in_select_list
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Die angegebene Sekundärschlüsselspalte wurde in der Auswahlliste der Abfrage nicht ermittelt';

wwv_flow_api.create_message (
  p_id=>196002129313152372 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'MRU.SEC_KEY_COL_NOT_IN_SELECT_LIST',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message mru_no_sec_key_vals
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Es wurden keine Sekundärwerte für die angegebene Sekundärschlüsselspalte angegeben';

wwv_flow_api.create_message (
  p_id=>196002206452152372 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'MRU.NO_SEC_KEY_VALS',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_calendar_column
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Kalenderspalte.';

wwv_flow_api.create_message (
  p_id=>196002313728152372 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000.CALENDAR_COLUMN',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p108_menu_file_type
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Menü';

wwv_flow_api.create_message (
  p_id=>196002413680152372 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P108_MENU_FILE_TYPE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message mru_error_in_mru
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fehler in MRU: row= %0, %1, %2';

wwv_flow_api.create_message (
  p_id=>196002518349152372 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'MRU.ERROR_IN_MRU',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message mru_lost_update
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Die aktuelle Version der Daten in der Datenbank wurde geändert, seit der Benutzer einen Update-Prozess eingeleitet hat. Aktuelle Prüfsumme (Checksum) = "%0" Element-Prüfsumme (Checksum) = "%1".';

wwv_flow_api.create_message (
  p_id=>196002600611152373 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'MRU.LOST_UPDATE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_job_unauthorized_attempt_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unberechtigter Versuch, Job %0 pro Schema %1 in Anwendung %2 auszuführen';

wwv_flow_api.create_message (
  p_id=>196002728974152373 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_JOB.UNAUTHORIZED_ATTEMPT_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_popup_bg_select_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Popup-Werteliste muss mit "select" beginnen.';

wwv_flow_api.create_message (
  p_id=>196002826913152373 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.POPUP_BG_SELECT_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_popup_init_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fehler beim Initialisieren von Popup-Werteliste: %0 %1';

wwv_flow_api.create_message (
  p_id=>196002914347152373 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.POPUP_INIT_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_popup_filter_init_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fehler beim Initialisieren von Popup-Werteliste mit Filter: %0 %1';

wwv_flow_api.create_message (
  p_id=>196003014669152373 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.POPUP_FILTER_INIT_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_generate_popup_lov_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fehler beim Generieren von Popup-Werteliste: %0 %1';

wwv_flow_api.create_message (
  p_id=>196003103423152373 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.GENERATE_POPUP_LOV_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_forms_combo_no_query_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Element %0 vom Typ <b>combobox</b> hat keine Abfrage.';

wwv_flow_api.create_message (
  p_id=>196003216075152374 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FORMS.COMBO_NO_QUERY_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_forms_combo_js_no_query_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Element %0 vom Typ <b>combobox</b> mit JS-Umleitung hat keine Abfrage.';

wwv_flow_api.create_message (
  p_id=>196003306693152374 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FORMS.COMBO_JS_NO_QUERY_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_forms_combo_url_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Element %0 vom Typ <b>combobox</b> mit URL-Umleitung hat keine Abfrage.';

wwv_flow_api.create_message (
  p_id=>196003415404152374 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FORMS.COMBO_URL_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_forms_combo_url_page_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Element %0 vom Typ <b>combobox</b> mit URL-Umleitung zur Seite hat keine Abfrage.';

wwv_flow_api.create_message (
  p_id=>196003510092152374 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FORMS.COMBO_URL_PAGE_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_generate_table_api_package_invalid_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fehler: Package-Name %0 ist ungültig oder bereits vergeben.';

wwv_flow_api.create_message (
  p_id=>196003629353152374 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_GENERATE_TABLE_API.PACKAGE_INVALID_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p108_prog_file_type
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Programmblock';

wwv_flow_api.create_message (
  p_id=>196003708269152374 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P108_PROG_FILE_TYPE',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_generic_attr_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fehler';

wwv_flow_api.create_message (
  p_id=>196003808848152375 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_GENERIC_ATTR.ERROR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p52_olb_content_invalid
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Die Datei, die Sie in Ihr Forms-Migrationsprojekt hochladen möchten, ist keine gültige Objekt-Library-Datei (_olb.XML). Nur Objekt-Library-XML-Dateien, die mit dem Forms2XML-Konvertierungstool von Oracle Forms generiert wurden, können hochgeladen werden.';

wwv_flow_api.create_message (
  p_id=>196003925322152375 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P52_OLB_CONTENT_INVALID',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_region_layout_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fehler';

wwv_flow_api.create_message (
  p_id=>196004024413152375 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_REGION_LAYOUT.ERROR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_migrate_metadata_update_navbar_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Aktualisieren von Bedingungstyp für die Anzeige der Navigationsleiste nicht möglich. %0';

wwv_flow_api.create_message (
  p_id=>196004121266152375 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_MIGRATE_METADATA.UPDATE_NAVBAR_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_migrate_metadata_update_flow_proc_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Aktualisieren von Anwendungsprozess bei Bedingungstyp nicht möglich. %0';

wwv_flow_api.create_message (
  p_id=>196004216652152375 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_MIGRATE_METADATA.UPDATE_FLOW_PROC_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_migrate_metadata_update_flow_comp_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Aktualisieren von Anwendungsberechnungstyp nicht möglich. %0';

wwv_flow_api.create_message (
  p_id=>196004313413152376 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_MIGRATE_METADATA.UPDATE_FLOW_COMP_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_migrate_metadata_update_page_subtitle_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Aktualisieren von Typ für die Seitenuntertitel nicht möglich. %0';

wwv_flow_api.create_message (
  p_id=>196004430775152376 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_MIGRATE_METADATA.UPDATE_PAGE_SUBTITLE_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_migrate_metadata_update_button_cond_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Aktualisieren von Bedingungstyp für Seitenschaltfläche nicht möglich. %0';

wwv_flow_api.create_message (
  p_id=>196004502820152376 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_MIGRATE_METADATA.UPDATE_BUTTON_COND_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_migrate_metadata_branch_cond_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Aktualisieren von Bedingungstyp für Seitenverzweigung nicht möglich. %0';

wwv_flow_api.create_message (
  p_id=>196004609504152376 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_MIGRATE_METADATA.BRANCH_COND_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_migrate_metadata_update_page_comp_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Aktualisieren von Seitenberechnungstyp nicht möglich. %0';

wwv_flow_api.create_message (
  p_id=>196004728989152376 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_MIGRATE_METADATA.UPDATE_PAGE_COMP_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_migrate_metadata_update_page_valid_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Aktualisieren von Seitenvalidierungstyp nicht möglich. %0';

wwv_flow_api.create_message (
  p_id=>196004806594152376 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_MIGRATE_METADATA.UPDATE_PAGE_VALID_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_migrate_metadata_update_page_proc_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Aktualisieren von Seitenprozesstyp nicht möglich. %0';

wwv_flow_api.create_message (
  p_id=>196004917834152376 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_MIGRATE_METADATA.UPDATE_PAGE_PROC_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_migrate_metadata_update_misspell_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fehler beim Aktualisieren von falsch geschriebenen Wörtern. %0';

wwv_flow_api.create_message (
  p_id=>196005030058152377 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_MIGRATE_METADATA.UPDATE_MISSPELL_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_disp_page_plugs_unable_to_bind_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Binden von %0 nicht möglich. Überprüfen Sie, ob die Länge des Elements maximal 30 Byte beträgt. Verwenden Sie die v()-Syntax, um Elemente zu referenzieren, die länger als 30 Byte sind. %1';

wwv_flow_api.create_message (
  p_id=>196005108384152377 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_DISP_PAGE_PLUGS.UNABLE_TO_BIND_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_popup_lov_convert_id_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1711 Popup-Wertelisten-ID kann in Request nicht konvertiert werden.';

wwv_flow_api.create_message (
  p_id=>196005223701152377 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_POPUP_LOV.CONVERT_ID_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_popup_lov_find_item_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1721 Element für Popup-Wertelisten-ID in Request nicht gefunden.';

wwv_flow_api.create_message (
  p_id=>196005329121152377 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_POPUP_LOV.FIND_ITEM_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_provision_drop_tablespace_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fehler in drop_tablespace. p_name ist Null.';

wwv_flow_api.create_message (
  p_id=>196005400521152377 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PROVISION.DROP_TABLESPACE_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_provision_unable_drop_tablespace_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Löschen von Tablespace nicht möglich. Fehler: %0 \nsql:\n %1';

wwv_flow_api.create_message (
  p_id=>196005519080152377 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PROVISION.UNABLE_DROP_TABLESPACE_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_provision_drop_user_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fehler in drop_user. Kein l_username.';

wwv_flow_api.create_message (
  p_id=>196005622104152378 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PROVISION.DROP_USER_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_provision_unable_drop_user_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Löschen von Benutzer nicht möglich. Fehler: %0 \nsql:\n %1';

wwv_flow_api.create_message (
  p_id=>196005703766152378 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PROVISION.UNABLE_DROP_USER_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_provision_with_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fehler mit: %0 %1';

wwv_flow_api.create_message (
  p_id=>196005804434152378 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PROVISION.WITH_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_provision_unable_create_user_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Benutzer kann nicht erstellt werden. %0';

wwv_flow_api.create_message (
  p_id=>196005915895152378 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PROVISION.UNABLE_CREATE_USER_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_provision_unable_create_tablespace_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Tablespace kann nicht erstellt werden. %0';

wwv_flow_api.create_message (
  p_id=>196006029973152378 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PROVISION.UNABLE_CREATE_TABLESPACE_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_provision_unable_grant_privs_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erteilen von Ausgangsberechtigungen nicht möglich. %0';

wwv_flow_api.create_message (
  p_id=>196006115206152378 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PROVISION.UNABLE_GRANT_PRIVS_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_provision_remove_company_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fehler in remove_provisioned_company. Workspace ist Null.';

wwv_flow_api.create_message (
  p_id=>196006213495152379 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PROVISION.REMOVE_COMPANY_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_table_created
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Tabelle wurde erstellt.';

wwv_flow_api.create_message (
  p_id=>196006304018152379 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.TABLE_CREATED',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_view_created
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'View wurde erstellt.';

wwv_flow_api.create_message (
  p_id=>196006424769152379 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.VIEW_CREATED',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_provisioning_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fehler';

wwv_flow_api.create_message (
  p_id=>196006504116152379 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PROVISIONING.ERROR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_trigger_created
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Trigger wurde erstellt.';

wwv_flow_api.create_message (
  p_id=>196006612787152379 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.TRIGGER_CREATED',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_function_created
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Funktion wurde erstellt.';

wwv_flow_api.create_message (
  p_id=>196006718043152380 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.FUNCTION_CREATED',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_procedure_created
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Prozedur wurde erstellt.';

wwv_flow_api.create_message (
  p_id=>196006803850152380 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.PROCEDURE_CREATED',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_pkg_body_created
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Package Body wurde erstellt.';

wwv_flow_api.create_message (
  p_id=>196006924491152380 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.PKG_BODY_CREATED',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_pkg_created
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Package wurde erstellt.';

wwv_flow_api.create_message (
  p_id=>196007019579152380 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.PKG_CREATED',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_index_created
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Index wurde erstellt.';

wwv_flow_api.create_message (
  p_id=>196007130674152380 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.INDEX_CREATED',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_type_created
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Typ wurde erstellt.';

wwv_flow_api.create_message (
  p_id=>196007230051152380 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.TYPE_CREATED',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_user_created
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Benutzer wurde erstellt.';

wwv_flow_api.create_message (
  p_id=>196007315414152380 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.USER_CREATED',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_materialized_view_created
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Materialized View erstellt.';

wwv_flow_api.create_message (
  p_id=>196007431521152381 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.MATERIALIZED_VIEW_CREATED',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_role_created
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Rolle wurde erstellt.';

wwv_flow_api.create_message (
  p_id=>196007519437152381 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.ROLE_CREATED',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_seq_created
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Sequence wurde erstellt.';

wwv_flow_api.create_message (
  p_id=>196007601358152381 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.SEQ_CREATED',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_synonym_created
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Synonym wurde erstellt.';

wwv_flow_api.create_message (
  p_id=>196007723197152381 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.SYNONYM_CREATED',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_cmd_executed
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Befehl ausgeführt.';

wwv_flow_api.create_message (
  p_id=>196007822027152381 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.CMD_EXECUTED',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_util_table_create_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erstellen der Tabelle aufgrund ungültiger SQL-Syntax nicht erfolgreich.';

wwv_flow_api.create_message (
  p_id=>196007910166152381 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_UTIL.TABLE_CREATE_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_rows_updated
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 Zeile(n) wurde(n) aktualisiert.';

wwv_flow_api.create_message (
  p_id=>196008024297152382 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.ROWS_UPDATED',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_rows_inserted
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 Zeile(n) wurde(n) eingefügt.';

wwv_flow_api.create_message (
  p_id=>196008112706152382 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.ROWS_INSERTED',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_util_package_create_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Erstellen des Packages aufgrund ungültiger SQL-Syntax nicht erfolgreich.';

wwv_flow_api.create_message (
  p_id=>196008218644152382 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_UTIL.PACKAGE_CREATE_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_rows_deleted
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 Zeile(n) wurde(n) gelöscht.';

wwv_flow_api.create_message (
  p_id=>196008330693152382 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.ROWS_DELETED',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_templates_util_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fehler';

wwv_flow_api.create_message (
  p_id=>196008426044152382 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_TEMPLATES_UTIL.ERROR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_admin_api_fetch_fnd_user_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Abrufen von FND-Benutzerinformationen nicht möglich. %0';

wwv_flow_api.create_message (
  p_id=>196008528700152383 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_ADMIN_API.FETCH_FND_USER_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_admin_api_delete_dev_role_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fehler beim Löschen von Entwicklerrolle. %0';

wwv_flow_api.create_message (
  p_id=>196008621760152383 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_ADMIN_API.DELETE_DEV_ROLE_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_builder_user_no_priv_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Der Benutzer %0 hat keine Berechtigungen für das %1-Schema.';

wwv_flow_api.create_message (
  p_id=>196008722878152383 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_BUILDER.USER_NO_PRIV_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_builder_updatable_report_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Parse-Fehler für aktualisierbaren Bericht: %0';

wwv_flow_api.create_message (
  p_id=>196008809153152383 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_BUILDER.UPDATABLE_REPORT_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_table_dropped
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Tabelle wurde gelöscht.';

wwv_flow_api.create_message (
  p_id=>196008909842152383 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.TABLE_DROPPED',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_pkg_dropped
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Package wurde gelöscht.';

wwv_flow_api.create_message (
  p_id=>196009028837152383 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.PKG_DROPPED',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_user_dropped
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Benutzer wurde gelöscht.';

wwv_flow_api.create_message (
  p_id=>196009106861152384 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.USER_DROPPED',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_view_dropped
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'View wurde gelöscht.';

wwv_flow_api.create_message (
  p_id=>196009209909152384 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.VIEW_DROPPED',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_page_execution_page_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fehler bei Ausführung von wwv_flow_copy_page: %0 >> %1';

wwv_flow_api.create_message (
  p_id=>196009316219152384 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_PAGE.EXECUTION_PAGE_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_seq_dropped
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Sequence wurde gelöscht.';

wwv_flow_api.create_message (
  p_id=>196009419800152384 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.SEQ_DROPPED',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_table_altered
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Tabelle wurde geändert.';

wwv_flow_api.create_message (
  p_id=>196009521375152384 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.TABLE_ALTERED',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_dataload_xml_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fehler';

wwv_flow_api.create_message (
  p_id=>196009617310152384 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_DATALOAD_XML.ERROR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_function_dropped
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Funktion wurde gelöscht.';

wwv_flow_api.create_message (
  p_id=>196009709172152384 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.FUNCTION_DROPPED',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_procedure_dropped
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Prozedur wurde gelöscht.';

wwv_flow_api.create_message (
  p_id=>196009804950152385 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.PROCEDURE_DROPPED',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_fnd_developer_api_credentials_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unberechtigter Zugriff (wwv_flow_api.set_credentials nicht festgelegt).';

wwv_flow_api.create_message (
  p_id=>196009902948152385 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FND_DEVELOPER_API.CREDENTIALS_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_fnd_developer_api_dev_role_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fehler beim Löschen von Entwicklerrolle. %0';

wwv_flow_api.create_message (
  p_id=>196010027805152385 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FND_DEVELOPER_API.DEV_ROLE_ERR',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_index_dropped
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Index wurde gelöscht.';

wwv_flow_api.create_message (
  p_id=>196010109825152385 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.INDEX_DROPPED',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_materialized_view_dropped
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Materialized View wurde gelöscht.';

wwv_flow_api.create_message (
  p_id=>196010223796152385 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.MATERIALIZED_VIEW_DROPPED',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_role_dropped
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Rolle wurde gelöscht.';

wwv_flow_api.create_message (
  p_id=>196010312547152386 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.ROLE_DROPPED',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_synonym_dropped
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Synonym wurde gelöscht.';

wwv_flow_api.create_message (
  p_id=>196010401270152386 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.SYNONYM_DROPPED',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_trigger_dropped
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Trigger wurde gelöscht.';

wwv_flow_api.create_message (
  p_id=>196010504489152386 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.TRIGGER_DROPPED',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_type_dropped
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Typ wurde gelöscht.';

wwv_flow_api.create_message (
  p_id=>196010632328152386 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.TYPE_DROPPED',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_indextype_dropped
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Indextyp wurde gelöscht.';

wwv_flow_api.create_message (
  p_id=>196010722237152386 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.INDEXTYPE_DROPPED',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_context_dropped
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Kontext gelöscht.';

wwv_flow_api.create_message (
  p_id=>196010824413152386 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.CONTEXT_DROPPED',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_database_link_dropped
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Datenbank-Link gelöscht.';

wwv_flow_api.create_message (
  p_id=>196010930092152387 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.DATABASE_LINK_DROPPED',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_database_link_created
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Datenbank-Link wurde erstellt.';

wwv_flow_api.create_message (
  p_id=>196011025881152387 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.DATABASE_LINK_CREATED',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_table_renamed
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Tabelle wurde umbenannt.';

wwv_flow_api.create_message (
  p_id=>196011130854152387 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.TABLE_RENAMED',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_view_altered
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'View wurde geändert.';

wwv_flow_api.create_message (
  p_id=>196011221123152387 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.VIEW_ALTERED',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_type_altered
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Typ wurde geändert.';

wwv_flow_api.create_message (
  p_id=>196011304455152387 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.TYPE_ALTERED',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_trigger_altered
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Trigger wurde geändert.';

wwv_flow_api.create_message (
  p_id=>196011407429152387 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.TRIGGER_ALTERED',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_indextype_altered
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Indextyp wurde geändert.';

wwv_flow_api.create_message (
  p_id=>196011516160152388 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.INDEXTYPE_ALTERED',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_table_truncated
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Tabelle wurde geleert.';

wwv_flow_api.create_message (
  p_id=>196011604065152388 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.TABLE_TRUNCATED',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_cluster_truncated
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Cluster wurde geleert.';

wwv_flow_api.create_message (
  p_id=>196011729451152388 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.CLUSTER_TRUNCATED',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_package_altered
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Package wurde geändert.';

wwv_flow_api.create_message (
  p_id=>196011817393152388 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.PACKAGE_ALTERED',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_function_altered
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Funktion wurde geändert.';

wwv_flow_api.create_message (
  p_id=>196011900985152388 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.FUNCTION_ALTERED',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_procedure_altered
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Prozedur wurde geändert.';

wwv_flow_api.create_message (
  p_id=>196012010436152388 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.PROCEDURE_ALTERED',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_seq_altered
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Sequence wurde geändert.';

wwv_flow_api.create_message (
  p_id=>196012110969152389 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.SEQ_ALTERED',
  p_message_language=>'de',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_user_altered
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Benutzer wurde geändert.';

wwv_flow_api.create_message (
  p_id=>196012231414152389 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.USE