Rem drv: <migrate type="data_upgrade" version="10.2.0.2" />
Rem $Header: db_policies.sql 26-aug-2006.08:45:42 rmadampa Exp $
Rem
Rem db_policies.sql
Rem
Rem Copyright (c) 2005, 2006, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      db_policies.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    rmadampa    08/26/06 - remove condition of CENTRAL mode
Rem    bmallipe    08/13/06 - adding the condition for CENTRAL mode only
Rem    dsukhwal    01/24/06 - bug 4958316:make end metaver 3.99 
Rem    dkjain      11/23/05 - Created
Rem

SET ECHO ON
SET FEEDBACK 1
SET NUMWIDTH 10
SET LINESIZE 80
SET TRIMSPOOL ON
SET TAB OFF
SET PAGESIZE 100

SET ESCAPE '\' ;
SET ESCAPE ON ;
DECLARE
 -- Metric Variable
 l_metric_column_list        	   	           MGMT_METRIC_COLUMN_ARRAY;
 l_metric_type				  	   NUMBER ;
 l_snapshot_list			           MGMT_SNAPSHOT_ARRAY;
 l_snapshot_list_rac			       MGMT_SNAPSHOT_ARRAY;
 l_snapshot_list_inst_10gR1		       MGMT_SNAPSHOT_ARRAY;
 l_snapshot_list_inst_10gR2		       MGMT_SNAPSHOT_ARRAY;
 -- Policy Variable
 l_ctxList    		  			   MGMT_VIOL_CTXT_DEF_ARRAY;
 l_paramDefList            			   MGMT_POLICY_PARAM_DEF_ARRAY;
 l_defaultParamValList      			   MGMT_POLICY_PARAM_VAL_ARRAY;
 l_defaultSettingsList      			   MGMT_POLICY_KEY_VAL_ARRAY;
 l_auto_enable				           NUMBER ;	
 l_10gR1_db_meta_ver                   VARCHAR2(3) ; 
 l_10gR1_db_end_meta_ver                   VARCHAR2(4) ;
 l_valid_if_list                       MGMT_VALIDIF_ARRAY ;
 l_rac_database                          CONSTANT VARCHAR2(12) := 'rac_database';
 -- New snapshot name for the instance specific oracle_security metrics is oracle_security_inst
 l_oracle_security_inst                CONSTANT VARCHAR2(20) := 'oracle_security_inst';

 pol_eval_func_10gR2  CONSTANT VARCHAR2(50) := 'ESM.EVAL_POLICY10GR2'  ;
 pol_eval_func_10gR1  CONSTANT VARCHAR2(50) := 'ESM.EVAL_POLICY10GR1'  ;

 -- Variables used by the code which does delete the sqlnet policies and metrics
 TYPE POLICY_LIST is table of VARCHAR2(50);
 l_policyName  VARCHAR2(50);
 l_policyNameList POLICY_LIST;

 TYPE METRIC_LIST is table of VARCHAR2(50);
 l_metricName  VARCHAR2(50);
 l_metricNameList METRIC_LIST;
 l_target_type  VARCHAR2(20) := 'oracle_database' ;

BEGIN

  l_policyNameList := POLICY_LIST('Unlimited_login_attempts', 'Database_User_With_Unlimited_login_attempts','Unlimited_login_attempts', 'Database_User_With_Unlimited_login_attempts') ;

  l_metricNameList := METRIC_LIST('unlimitedFailedLoginAttemptsRep','unlimitedFailedLoginAttempts10gR1Rep','unlimitedFailedLoginAttemptsRep','unlimitedFailedLoginAttempts10gR1Rep') ;
FOR i IN 1..4 LOOP
 l_policyName := l_policyNameList(i);
 if i > 2 then
  l_target_type := l_rac_database ;
 end if ;
 ESM.DELETE_POLICY(
   P_TARGET_TYPE => l_target_type,
   P_POLICY_NAME => l_policyName
 );
 COMMIT ;
 
 l_metricName := l_metricNameList(i);
 MGMT_METRIC.DELETE_METRIC(
    P_TARGET_TYPE => l_target_type,
    P_METRIC_NAME => l_metricName,
    P_TYPE_META_VER => NULL 
 );
 COMMIT ;
END LOOP;
  l_10gR1_db_meta_ver := '3.0' ;
  l_10gR1_db_end_meta_ver := '3.99' ;
  l_metric_type := MGMT_GLOBAL.G_METRIC_TYPE_TABLE ;
  l_snapshot_list := MGMT_SNAPSHOT_ARRAY(
        MGMT_SNAPSHOT_OBJ.NEW(
                p_target_type => ESM.DB_TARGET_TYPE,
                p_snapshot_name => ESM.SECURITY_SNAPSHOT_TYPE));

  l_snapshot_list_rac := MGMT_SNAPSHOT_ARRAY(
        MGMT_SNAPSHOT_OBJ.NEW(
                p_target_type   => l_rac_database,
                p_snapshot_name => ESM.SECURITY_SNAPSHOT_TYPE));


  -- This snapshot list is prepared for all the db instance 
  -- security metrics which are applicable For both 10gR1 + 10gR2.
  -- In 10gR2 release oracle_security snapshot name has split up into two
  -- oracle_security + oracle_security_int(all db instance security metric used this)
  -- oracle_security_inst snapshot name is included in the snapshot list
  -- bcoz 10gR2 agent will upload the instance data with this snapshot name 
  -- Snapshot name used by 10gR1 agent remains same so included to support the 
  -- backward compatibility as 10gR1 agent uploads the data for 
  -- those metric with oracle_security snapshot name.
  l_snapshot_list_inst_10gR1 := MGMT_SNAPSHOT_ARRAY(
        MGMT_SNAPSHOT_OBJ.NEW(
                p_target_type   => ESM.DB_TARGET_TYPE,
                p_snapshot_name => l_oracle_security_inst),
        MGMT_SNAPSHOT_OBJ.NEW(
                p_target_type   => ESM.DB_TARGET_TYPE,
                p_snapshot_name => ESM.SECURITY_SNAPSHOT_TYPE));
 
  -- for 10gR2 db instance specific metrics => this is oracle_security_inst
  l_snapshot_list_inst_10gR2 := MGMT_SNAPSHOT_ARRAY(
        MGMT_SNAPSHOT_OBJ.NEW(
                p_target_type   => ESM.DB_TARGET_TYPE,
                p_snapshot_name => l_oracle_security_inst));

  l_valid_if_list := MGMT_VALIDIF_ARRAY(
       MGMT_VALIDIF_OBJ.NEW(
            p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY('DB'))
  );
  l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'profile',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Profile',
                p_column_label_nlsid =>'PROFILE_COL'),
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'limit',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'Failed Login Attempts',
                p_column_label_nlsid =>'FAILED_LOGIN_ATTEMPTS_COL'));
   MGMT_METRIC.CREATE_METRIC(
      p_target_type => ESM.DB_TARGET_TYPE,
      p_metric_name => 'unlimitedFailedLoginAttemptsRep',	
      p_type_meta_ver => ESM.DB_TYPE_META_VERSION,
      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type, 
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,    			
      p_metric_label => 'Profiles with Unlimited Login Attempts',
      p_metric_label_nlsid => 'FAILED_LOGIN_ATTEMPTS_METRIC_LABEL',
      p_description  => 'Collect setting of FAILED_LOGIN_ATTEMPTS',
      p_description_nlsid => 'FAILED_LOGIN_ATTEMPTS_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE ,     
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_PLSQL,
      p_source => pol_eval_func_10gR2,
      p_snapshot_name_list => l_snapshot_list,
      p_metric_column_list => l_metric_column_list  
 );
COMMIT ;
   MGMT_METRIC.CREATE_METRIC(
      p_target_type => 'rac_database',
      p_metric_name => 'unlimitedFailedLoginAttemptsRep',	
      p_type_meta_ver => ESM.DB_TYPE_META_VERSION,
 --     p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type, 
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,   			
      p_metric_label => 'Profiles with Unlimited Login Attempts',
      p_metric_label_nlsid => 'FAILED_LOGIN_ATTEMPTS_METRIC_LABEL',
      p_description  => 'Collect setting of FAILED_LOGIN_ATTEMPTS',
      p_description_nlsid => 'FAILED_LOGIN_ATTEMPTS_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE ,     
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_PLSQL,
      p_source => pol_eval_func_10gR2,
      p_snapshot_name_list => l_snapshot_list_rac,
      p_metric_column_list => l_metric_column_list  
 );
COMMIT ;

 -- Policy
  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(
	         p_metric_column => 'profile', 
    		 p_url_link_template =>'database/security/profile?oname=^profile^\&event=edit\&otype=PROFILE\&target=^TARGET_NAME^\&type=^TARGET_TYPE^\&cancelURL=^CANCEL_URL^', 
   		     p_url_link_type => MGMT_POLICY.G_URL_TYPE_JSP),
      	MGMT_VIOL_CTXT_DEF.NEW(
		     p_metric_column => 'limit'));
  l_paramDefList := MGMT_POLICY_PARAM_DEF_ARRAY(
        MGMT_POLICY_PARAM_DEF(
                param_name => 'MAX_FAILED_LOGIN_ATTEMPTS',
                param_name_nlsid => 'MAX_FAILED_LOGIN_ATTEMPTS_PNAME',
                param_type => MGMT_POLICY.G_PARAM_TYPE_NUMBER));
  l_defaultParamValList := MGMT_POLICY_PARAM_VAL_ARRAY(
        MGMT_POLICY_PARAM_VAL.NEW(
                p_param_name => 'MAX_FAILED_LOGIN_ATTEMPTS',
                p_crit_threshold => '10'));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
        MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL,
                p_param_values => l_defaultParamValList));
 ESM.CREATE_POLICY(
  p_target_type => ESM.DB_TARGET_TYPE,
  p_policy_name =>'Unlimited_login_attempts',   --Policy name
  p_metric_name =>'unlimitedFailedLoginAttemptsRep',      --Metric name
  p_policy_label_nlsid =>'PROFILE_UNLMTED_FAILED_NAME',    
  p_description =>'Ensure that the number of allowed failed login attempts is set to a reasonable number of login attempts for all profiles',
  p_description_nlsid =>'UNLMT_FAILED_LGIN_DESC',
  p_impact =>'Permits manual and automated password guessing by a malicious user.',
  p_impact_nlsid =>'UNLMT_FAILED_LGIN_IMPACT',
  p_recommendation =>'Set FAILED_LOGIN_ATTEMPTS in user profiles to no more than 10.',
  p_recommendation_nlsid =>'UNLMT_FAILED_LGIN_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_CRITICAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'decode(:limit ,''UNLIMITED'',2147483647,to_number(:limit)) > :MAX_FAILED_LOGIN_ATTEMPTS',
  p_message =>'Database is in an insecure state. FAILED_LOGIN_ATTEMPTS is set to  %limit% for the profile %profile%.',
  p_message_nlsid =>'UNLMT_FAILED_LGIN2_MESG',
  p_cs_consider_percentage =>MGMT_GLOBAL.G_TRUE,
  p_start_type_meta_ver => ESM.DB_TYPE_META_VERSION,  
  p_policy_param_list =>l_paramDefList,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList	
);
COMMIT; 
 ESM.CREATE_POLICY(
  p_target_type => 'rac_database',
  p_policy_name =>'Unlimited_login_attempts',   --Policy name
  p_metric_name =>'unlimitedFailedLoginAttemptsRep',      --Metric name
  p_policy_label_nlsid =>'PROFILE_UNLMTED_FAILED_NAME',    
  p_description =>'Ensure that the number of allowed failed login attempts is set to a reasonable number of login attempts for all profiles',
  p_description_nlsid =>'UNLMT_FAILED_LGIN_DESC',
  p_impact =>'Permits manual and automated password guessing by a malicious user.',
  p_impact_nlsid =>'UNLMT_FAILED_LGIN_IMPACT',
  p_recommendation =>'Set FAILED_LOGIN_ATTEMPTS in user profiles to no more than 10.',
  p_recommendation_nlsid =>'UNLMT_FAILED_LGIN_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_CRITICAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'decode(:limit ,''UNLIMITED'',2147483647,to_number(:limit)) > :MAX_FAILED_LOGIN_ATTEMPTS',
  p_message =>'Database is in an insecure state. FAILED_LOGIN_ATTEMPTS is set to  %limit% for the profile %profile%.',
  p_message_nlsid =>'UNLMT_FAILED_LGIN2_MESG',
  p_cs_consider_percentage =>MGMT_GLOBAL.G_TRUE,
  p_start_type_meta_ver => ESM.DB_TYPE_META_VERSION,  
  p_policy_param_list =>l_paramDefList,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList	
);
COMMIT; 
 l_valid_if_list := MGMT_VALIDIF_ARRAY(
       MGMT_VALIDIF_OBJ.NEW(
            p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY('NO'))
 );
 l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'dbuser',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'DATABASE USER',
                p_column_label_nlsid =>'DBUSER_COL'),
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'dummy',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'Dummy',
                p_column_label_nlsid =>'DUMMY_COL'));
   MGMT_METRIC.CREATE_METRIC(
      p_target_type => ESM.DB_TARGET_TYPE,
      p_metric_name => 'unlimitedFailedLoginAttempts10gR1Rep',	
      p_type_meta_ver => l_10gR1_db_meta_ver,  -- applicable upto 10gR1 
      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type,
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,     			
      p_metric_label => 'Db Users with Unlimited Login Attempts',
      p_metric_label_nlsid => 'USR_FAILED_LOGIN_ATTEMPTS_METRIC_LABEL',
      p_description  => 'Collect setting of FAILED_LOGIN_ATTEMPTS',
      p_description_nlsid => 'FAILED_LOGIN_ATTEMPTS_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE ,     
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_PLSQL,
      p_source => pol_eval_func_10gR1,
      p_snapshot_name_list => l_snapshot_list,
      p_metric_column_list => l_metric_column_list, 
      p_end_type_meta_ver => l_10gR1_db_end_meta_ver-- applicable upto 10gR1 
 );
COMMIT ;
 l_valid_if_list := MGMT_VALIDIF_ARRAY(
       MGMT_VALIDIF_OBJ.NEW(
            p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY(' '))
 ); 
   MGMT_METRIC.CREATE_METRIC(
      p_target_type => 'rac_database',
      p_metric_name => 'unlimitedFailedLoginAttempts10gR1Rep',	
      p_type_meta_ver => l_10gR1_db_meta_ver,  -- applicable upto 10gR1 
 --     p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type,
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,     			
      p_metric_label => 'Db Users with Unlimited Login Attempts',
      p_metric_label_nlsid => 'USR_FAILED_LOGIN_ATTEMPTS_METRIC_LABEL',
      p_description  => 'Collect setting of FAILED_LOGIN_ATTEMPTS',
      p_description_nlsid => 'FAILED_LOGIN_ATTEMPTS_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE ,     
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_PLSQL,
      p_source => pol_eval_func_10gR1,
      p_snapshot_name_list => l_snapshot_list_rac,
      p_metric_column_list => l_metric_column_list, 
      p_end_type_meta_ver => l_10gR1_db_end_meta_ver-- applicable upto 10gR1 
 );
COMMIT ;
  
  -- Policy
  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(
	         p_metric_column => 'dbuser'));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
        MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));
 ESM.CREATE_POLICY(
  p_target_type => ESM.DB_TARGET_TYPE,
  p_policy_name =>'Database_User_With_Unlimited_login_attempts',   --Policy name
  p_metric_name =>'unlimitedFailedLoginAttempts10gR1Rep',      --Metric name
  p_policy_label_nlsid =>'UNLMT_FAILED_LGIN_NAME',    
  p_description =>'Ensure that the number of allowed failed login attempts is set to a reasonable number of login attempts for all users',
  p_description_nlsid =>'USR_UNLMT_FAILED_LGIN_DESC',
  p_impact =>'Permits manual and automated password guessing by a malicious user.',
  p_impact_nlsid =>'UNLMT_FAILED_LGIN_IMPACT',
  p_recommendation =>'Oracle strongly recommends changing the parameter FAILED_LOGIN_ATTEMPTS '||
              'in user profiles to no more than 10.',
  p_recommendation_nlsid =>'UNLMT_FAILED_LGIN_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_CRITICAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'rownum > 0',
  p_message =>'Database may be in an insecure state as the UNLIMITED FAILED_LOGIN_ATTEMPTS is assigned to user %dbuser%.',
  p_message_nlsid =>'UNLMT_FAILED_LGIN1_MESG',
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver => l_10gR1_db_meta_ver,
  p_end_type_meta_ver => l_10gR1_db_end_meta_ver,	
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList	
);
COMMIT;
 ESM.CREATE_POLICY(
  p_target_type => 'rac_database',
  p_policy_name =>'Database_User_With_Unlimited_login_attempts',   --Policy name
  p_metric_name =>'unlimitedFailedLoginAttempts10gR1Rep',      --Metric name
  p_policy_label_nlsid =>'UNLMT_FAILED_LGIN_NAME',    
  p_description =>'Ensure that the number of allowed failed login attempts is set to a reasonable number of login attempts for all users',
  p_description_nlsid =>'USR_UNLMT_FAILED_LGIN_DESC',
  p_impact =>'Permits manual and automated password guessing by a malicious user.',
  p_impact_nlsid =>'UNLMT_FAILED_LGIN_IMPACT',
  p_recommendation =>'Oracle strongly recommends changing the parameter FAILED_LOGIN_ATTEMPTS '||
              'in user profiles to no more than 10.',
  p_recommendation_nlsid =>'UNLMT_FAILED_LGIN_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_CRITICAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'rownum > 0',
  p_message =>'Database may be in an insecure state as the UNLIMITED FAILED_LOGIN_ATTEMPTS is assigned to user %dbuser%.',
  p_message_nlsid =>'UNLMT_FAILED_LGIN1_MESG',
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver => l_10gR1_db_meta_ver,
  p_end_type_meta_ver => l_10gR1_db_end_meta_ver,	
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList	
);
COMMIT;

--------------------------bug 4958316 : make end metadata version 3.99 --------------------------
 ESM.DELETE_POLICY_METADATA(
   P_TARGET_TYPE => 'oracle_database',
   P_POLICY_NAME => 'Well_known_Accounts_Status'
 );
 COMMIT ;
 
 MGMT_METRIC.DELETE_METRIC_METADATA(
    P_TARGET_TYPE => 'oracle_database',
    P_METRIC_NAME => 'installAndDemoAcccounts10gR1Rep',
    P_TYPE_META_VER => NULL 
 );
 COMMIT ;

 ESM.DELETE_POLICY_METADATA(
   P_TARGET_TYPE => 'rac_database',
   P_POLICY_NAME => 'Well_known_Accounts_Status'
 );
 COMMIT ;
 
 MGMT_METRIC.DELETE_METRIC_METADATA(
    P_TARGET_TYPE => 'rac_database',
    P_METRIC_NAME => 'installAndDemoAcccounts10gR1Rep',
    P_TYPE_META_VER => NULL 
 );
 COMMIT ;
l_valid_if_list := MGMT_VALIDIF_ARRAY(
       MGMT_VALIDIF_OBJ.NEW(
            p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY('NO'))
 );
 l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'dbuser',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'DATABASE USER(STATUS)',
                p_column_label_nlsid =>'DBUSER_STATUS_COL'),
         MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'dummy',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'Dummy',
                p_column_label_nlsid =>'DUMMY_COL'));

  MGMT_METRIC.CREATE_METRIC(
      p_target_type => ESM.DB_TARGET_TYPE,
      p_metric_name => 'installAndDemoAcccounts10gR1Rep',   
      p_type_meta_ver => l_10gR1_db_meta_ver,  -- Applicable for 10gR1 only
      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type, 
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,     
      p_metric_label => 'Default Installed and Demo Accounts',
      p_metric_label_nlsid => 'INSTALL_ACCT_METRIC_LABEL',
      p_description  => 'Collect the information of default installed and demo accounts',
      p_description_nlsid => 'INSTALL_ACCT_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE ,
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source =>'SELECT target_guid,value as dbuser,value2 as dummy '
                 ||'FROM esm_collection_latest  '
                 ||'WHERE property=''default user account''',
      p_snapshot_name_list => l_snapshot_list,
      p_metric_column_list => l_metric_column_list,
      p_end_type_meta_ver => l_10gR1_db_end_meta_ver-- Applicable for 10gR1 only
 );
COMMIT;

  l_valid_if_list := MGMT_VALIDIF_ARRAY(
       MGMT_VALIDIF_OBJ.NEW(
            p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY(' '))
 ); 
  MGMT_METRIC.CREATE_METRIC(
      p_target_type => 'rac_database',
      p_metric_name => 'installAndDemoAcccounts10gR1Rep',   
      p_type_meta_ver => l_10gR1_db_meta_ver,  -- Applicable for 10gR1 only
  --    p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type,
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,     
      p_metric_label => 'Default Installed and Demo Accounts',
      p_metric_label_nlsid => 'INSTALL_ACCT_METRIC_LABEL',
      p_description  => 'Collect the information of default installed and demo accounts',
      p_description_nlsid => 'INSTALL_ACCT_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE ,
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source =>'SELECT target_guid,value as dbuser,value2 as dummy '
                 ||'FROM esm_collection_latest  '
                 ||'WHERE property=''default user account''',
      p_snapshot_name_list => l_snapshot_list_rac,
      p_metric_column_list => l_metric_column_list,
      p_end_type_meta_ver => l_10gR1_db_end_meta_ver-- Applicable for 10gR1 only
 );
COMMIT;

  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'dbuser',
                p_url_link_template =>'database/security/user?oname=^dbuser^\&event=edit\&otype=USER\&target=^TARGET_NAME^\&type=^TARGET_TYPE^\&cancelURL=^CANCEL_URL^',
                p_url_link_type => MGMT_POLICY.G_URL_TYPE_JSP));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));
 ESM.CREATE_POLICY(
  p_target_type => ESM.DB_TARGET_TYPE,
  p_policy_name =>'Well_known_Accounts_Status',   --Policy name 
  p_metric_name =>'installAndDemoAcccounts10gR1Rep',      --Metric name
  p_policy_label_nlsid =>'WELL_KNOWN_ACCOUNT1_NAME',   
  p_description =>'Checks for accessibility of well-known accounts',
  p_description_nlsid =>'WELL_KNOWN_ACCOUNT_DESC',
  p_impact =>'A knowledgeable malicious user can gain access to the database using a well-known account.',
  p_impact_nlsid =>'WELL_KNOWN_ACCOUNT_IMPACT',
  p_recommendation =>'Oracle recommends that you to expire and lock well-known accounts.',
  p_recommendation_nlsid =>'WELL_KNOWN_ACCOUNT_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_WARNING,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'rownum > 0',
  p_message =>'Database may be in an insecure state as password status for db user is:%dbuser%.',
  p_message_nlsid =>'WELL_KNOWN_ACCOUNT1_MESG',
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE, 
  p_start_type_meta_ver =>  l_10gR1_db_meta_ver,  -- Applicable for 10gR1 only
  p_end_type_meta_ver => l_10gR1_db_end_meta_ver,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList
);
COMMIT ;

 ESM.CREATE_POLICY(
  p_target_type => 'rac_database',
  p_policy_name =>'Well_known_Accounts_Status',   --Policy name 
  p_metric_name =>'installAndDemoAcccounts10gR1Rep',      --Metric name
  p_policy_label_nlsid =>'WELL_KNOWN_ACCOUNT1_NAME',   
  p_description =>'Checks for accessibility of well-known accounts',
  p_description_nlsid =>'WELL_KNOWN_ACCOUNT_DESC',
  p_impact =>'A knowledgeable malicious user can gain access to the database using a well-known account.',
  p_impact_nlsid =>'WELL_KNOWN_ACCOUNT_IMPACT',
  p_recommendation =>'Oracle recommends that you to expire and lock well-known accounts.',
  p_recommendation_nlsid =>'WELL_KNOWN_ACCOUNT_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_WARNING,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'rownum > 0',
  p_message =>'Database may be in an insecure state as password status for db user is:%dbuser%.',
  p_message_nlsid =>'WELL_KNOWN_ACCOUNT1_MESG',
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE, 
  p_start_type_meta_ver =>  l_10gR1_db_meta_ver,  -- Applicable for 10gR1 only
  p_end_type_meta_ver => l_10gR1_db_end_meta_ver,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList
);
COMMIT ;
 

END ;
/
show errors ;
SET ESCAPE OFF ;
