Rem drv: <migrate type="data_upgrade" version="10.2.0.2" />
Rem $Header: lsnr_policies.sql 26-aug-2006.08:45:42 rmadampa Exp $
Rem
Rem lsnr_policies.sql
Rem
Rem Copyright (c) 2005, 2006, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      lsnr_policies.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    rmadampa    08/26/06 - remove condition of CENTRAL mode
Rem    bmallipe    08/13/06 - adding the condition for CENTRAL mode only
Rem    dsukhwal    11/23/05 - Created
Rem

SET ECHO ON
SET FEEDBACK 1
SET NUMWIDTH 10
SET LINESIZE 80
SET TRIMSPOOL ON
SET TAB OFF
SET PAGESIZE 100


DECLARE
 l_ctxList    		     			MGMT_VIOL_CTXT_DEF_ARRAY; 
 l_defaultSettingsList      		        MGMT_POLICY_KEY_VAL_ARRAY;
BEGIN
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));                                             
  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(p_metric_column => 'users'),
        MGMT_VIOL_CTXT_DEF.NEW(p_metric_column => 'file_name'));
 ESM.MODIFY_POLICY(
  p_target_type => ESM.LSNR_TARGET_TYPE,     --Target Type
  p_policy_name => 'Lsnr_Logfile_Perm_PolicyNT',   --Policy name
  p_metric_name => 'lsnrLogFilePermMetricNTRep',      --Metric name
  p_policy_label_nlsid => 'LSNR_LOG_FILE_PERM_NAME_NT', --policylabelnlsid
  p_description  => 'Ensures that the listener logfile cannot be read by  or written to by public',  
  p_description_nlsid =>'LSNR_LOG_FILE_PERM_DESC',    --Policy Decription NLSID
  p_impact =>'The information in the logfile can reveal important network and database connection details. Allowing access to the log file can expose them to public scrutiny with possible security implications.', --Impact
  p_impact_nlsid =>'LSNR_LOG_FILE_PERM_IMPACT',  --Impact NLSID
  p_recommendation =>'The listener logfile must not allow public to read/write to it. Restrict the file permission to Oracle software owner and DBA group.', --Recommendation
  p_recommendation_nlsid =>'LSNR_LOG_FILE_PERM_RECOMM',  --Recommendation NLSID
  p_violation_level => MGMT_GLOBAL.G_SEVERITY_CRITICAL,  --violation level
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL, --condition type
  p_condition =>'rownum > 0', --condition
  p_message =>'The listener is in an insecure state. Users %users% have critical permissions on the listener log file %file_name%.', 
  p_message_nlsid =>'LSNR_LOG_FILE_NT_PERM_MESG', --MESSAGE NLSID
  p_start_type_meta_ver => ESM.LSNR_TYPE_META_VERSION,
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE, --if there is a violation, we have exactly one row in the table. 
                                                  --So considering the percentage does not make sense here.
  p_dflt_param_val_list =>l_defaultSettingsList,  --default param val list
  p_viol_ctxt_list =>l_ctxList
);
COMMIT ;

  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY( --show all the columns in violations list
        MGMT_VIOL_CTXT_DEF.NEW(p_metric_column => 'users'),
        MGMT_VIOL_CTXT_DEF.NEW(p_metric_column => 'dir_name'));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));
 ESM.MODIFY_POLICY(
  p_target_type => ESM.LSNR_TARGET_TYPE,     --Target Type
  p_policy_name => 'Lsnr_Tracedir_Perm_PolicyNT',   --Policy name
  p_metric_name => 'lsnrTraceDirPermMetricNTRep',      --Metric name
  p_policy_label_nlsid => 'LSNR_TRACE_DIR_PERM_NAME_NT', --policylabelnlsid
  p_description  => 'Ensures that the listener trace directory does not have public read/write permissions',
  p_description_nlsid =>'LSNR_TRACE_DIR_PERM_DESC',    --Policy Decription NLSID
  p_impact =>'Allowing access to the trace directory can expose them to public scrutiny with possible security implications.', --Impact
  p_impact_nlsid =>'LSNR_TRACE_DIR_PERM_IMPACT',  --Impact NLSID
  p_recommendation =>'The listener trace directory must not allow public to read/write to it. Restrict the directory permission to Oracle software owner and DBA group.', --Recommendation
  p_recommendation_nlsid =>'LSNR_TRACE_DIR_PERM_RECOMM',  --Recommendation NLSID
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_CRITICAL,  --violation level
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL, --condition type
  --(check for existence of row for violation)
  p_condition =>'rownum > 0', 
  p_message =>'The listener is in an insecure state. Users %users% have crritical permissions on listener trace directory %dir_name%.',  
  p_message_nlsid =>'LSNR_TRACE_DIR_NT_PERM_MESG', --MESSAGE NLSID
  p_start_type_meta_ver => ESM.LSNR_TYPE_META_VERSION,
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE, --if there is a violation, we have exactly one row in the table. 
                                                  --So considering the percentage does not make sense here.
  p_dflt_param_val_list =>l_defaultSettingsList,  --default param val list
  p_viol_ctxt_list =>l_ctxList
);
COMMIT ;

  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(p_metric_column => 'users'),
	    MGMT_VIOL_CTXT_DEF.NEW(p_metric_column => 'file_name'));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL
                ));
 ESM.MODIFY_POLICY(
  p_target_type => ESM.LSNR_TARGET_TYPE,     --Target Type
  p_policy_name => 'Lsnr_Tracefile_Perm_PolicyNT',   --Policy name
  p_metric_name => 'lsnrTraceFilePermMetricNTRep',      --Metric name
  p_policy_label_nlsid => 'LSNR_TRACE_FILE_PERM_NAME_NT',   --policylabelnlsid
  p_description  => 'Ensures that the listener trace file is not accessible to public',
  p_description_nlsid =>'LSNR_TRACE_FILE_PERM_DESC',    --Policy Decription NLSID
  p_impact =>'Allowing access to the trace files can expose them to public scrutiny with possible security implications.', --Impact
  p_impact_nlsid =>'LSNR_TRACE_FILE_PERM_IMPACT',  --Impact NLSID
  p_recommendation =>'The listener trace file must not allow public to read/write to it. Restrict the file permission to Oracle software owner and DBA group.', --Recommendation
  p_recommendation_nlsid =>'LSNR_TRACE_FILE_PERM_RECOMM',  --Recommendation NLSID
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_CRITICAL,  --violation level
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL, --condition type
  p_condition =>'rownum > 0',--file_permission value comes in octal. Taking mod with 
  p_message =>'The listener is in an insecure state. The users %users% have critical permissions on listener trace file %file_name%.',  --message
  p_message_nlsid =>'LSNR_TRACE_FILE_NT_PERM_MESG', --MESSAGE NLSID
  p_start_type_meta_ver => ESM.LSNR_TYPE_META_VERSION,
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE, --if there is a violation, we have exactly one row in the table. 
                                                  --So considering the percentage does not make sense here.
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList
);
COMMIT ;

 l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(p_metric_column => 'users'),
        MGMT_VIOL_CTXT_DEF.NEW(p_metric_column => 'file_path'));
 l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));
 ESM.MODIFY_POLICY(
  p_target_type => ESM.LSNR_TARGET_TYPE,     --Target Type
  p_policy_name => 'Lsnr_Ora_Restrict_PermsNT',   --Policy name
  p_metric_name => 'lsnrOraPermNTRep',      --Metric name
  p_policy_label_nlsid => 'LSNR_ORA_PERM_NAME_NT',            --policylabelnlsid
  p_description  => 'Ensures that the file permissions for listener.ora are restricted to the owner of Oracle software',
  p_description_nlsid =>'LSNR_ORA_PERM_DESC',    --Policy Decription NLSID
  p_impact =>'If the listener.ora file is public readable, passwords may be extracted from this file. This can also lead to exposure of detailed information on the Listener, database, and application configuration. Also, if public has write permissions, a malicious user can remove any password that has been set on the listener.', --Impact
  p_impact_nlsid =>'LSNR_ORA_PERM_IMPACT',  --Impact NLSID
  p_recommendation =>'Listener.ora permissions should be restricted to the owner of Oracle software installation and DBA group.', --Recommendation
  p_recommendation_nlsid =>'LSNR_ORA_PERM_RECOMM',  --Recommendation NLSID
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_CRITICAL,  --violation level
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL, --condition type
  p_condition =>'rownum > 0',--'substr(:file_permission,-3,2) <> ''--'' ',
  p_message =>'Listener is in an insecure state. Permissions of listener.ora are not restricted to the Oracle set',
  p_message_nlsid =>'LSNR_ORA_NT_PERM_MESG', --MESSAGE NLSID
  p_start_type_meta_ver => ESM.LSNR_TYPE_META_VERSION,
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE, --consider percentage
  p_dflt_param_val_list =>l_defaultSettingsList,  --default param val list
  p_viol_ctxt_list =>l_ctxList
);
COMMIT ;

  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
    MGMT_VIOL_CTXT_DEF.NEW(p_metric_column => 'users'),
    MGMT_VIOL_CTXT_DEF.NEW(p_metric_column => 'dir_name'));
 
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));

 ESM.MODIFY_POLICY(
  p_target_type => ESM.LSNR_TARGET_TYPE,
  p_policy_name =>'sqlnet_Client_Log_DirNT',   --Policy name
  p_metric_name =>'clientLogDirNTRep',      --Metric name
  p_policy_label_nlsid =>'CLIENT_LOG_DIR_PERM_NAME_NT',   
  p_description =>'Ensures that the client log directory is a valid directory owned by Oracle set with no permissions to public',
  p_description_nlsid =>'CLIENT_LOG_DIR_PERM_DESC',
  p_impact =>'Log files provide information contained in an error stack. An error stack refers to the information that is produced by each layer in an Oracle communications stack as the result of a network error. The information in log files can reveal important network and database connection details. Allowing access to the log directory can expose the log files to public scrutiny.',
  p_impact_nlsid =>'CLIENT_LOG_DIR_PERM_IMPACT',
  p_recommendation =>'The client log directory must be a valid directory owned by the Oracle set with no permissions to public.',
  p_recommendation_nlsid =>'CLIENT_LOG_DIR_PERM_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_CRITICAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>  'rownum > 0', 
  p_message =>'The listener is in an insecure state. The users %users% have critical permissions on the client log directory %dir_name%.',
  p_message_nlsid =>'CLIENT_LOG_DIR_NT_PERM_MESG',
  p_start_type_meta_ver => ESM.LSNR_TYPE_META_VERSION,
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList  
);
COMMIT;

  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
    MGMT_VIOL_CTXT_DEF.NEW(p_metric_column => 'users'),
    MGMT_VIOL_CTXT_DEF.NEW(p_metric_column => 'dir_name'));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));

 ESM.MODIFY_POLICY(
  p_target_type => ESM.LSNR_TARGET_TYPE,
  p_policy_name =>'sqlnet_Server_Log_DirNT',   --Policy name
  p_metric_name =>'svrLogDirNTRep',      --Metric name
  p_policy_label_nlsid =>'SERV_LOG_DIR_PERM_NAME_NT',   
  p_description =>'Ensures that the server log directory is a valid directory owned by Oracle set with no permissions to public',
  p_description_nlsid =>'SERV_LOG_DIR_PERM_DESC',
  p_impact =>'Log files provide information contained in an error stack. An error stack refers to the information that is produced by each layer in an Oracle communications stack as the result of a network error. The information in log files can reveal important network and database connection details. Allowing access to the log directory can expose the log files to public scrutiny.',
  p_impact_nlsid =>'SERV_LOG_DIR_PERM_IMPACT',
  p_recommendation =>'The server log directory must be a valid directory owned by the Oracle set with no permissions to public.',
  p_recommendation_nlsid =>'SERV_LOG_DIR_PERM_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_CRITICAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>  'rownum > 0', 
  p_message =>'The listener is in an insecure state. The users %users% have critical permissions on the server log directory %dir_name%.',
  p_message_nlsid =>'SERV_LOG_DIR_NT_PERM_MESG',
  p_start_type_meta_ver => ESM.LSNR_TYPE_META_VERSION,
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList  
);
COMMIT;

  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
    MGMT_VIOL_CTXT_DEF.NEW(p_metric_column => 'users'),
    MGMT_VIOL_CTXT_DEF.NEW(p_metric_column => 'dir_name'));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));
 ESM.MODIFY_POLICY(
  p_target_type => ESM.LSNR_TARGET_TYPE,
  p_policy_name =>'sqlnet_Client_Trace_DirNT',   --Policy name
  p_metric_name =>'clientTrcDirNTRep',      --Metric name
  p_policy_label_nlsid =>'CLIENT_TRC_DIR_PERM_NAME_NT',   
  p_description =>'Ensures that the client trace directory is a valid directory owned by Oracle set with no permissions to public',
  p_description_nlsid =>'CLIENT_TRC_DIR_PERM_DESC',
  p_impact =>'Tracing produces a detailed sequence of statements that describe network events as they are executed. Tracing an operation enables you to obtain more information on the internal operations of the components of Oracle Net Services than is provided in a log file. The information in this file can reveal important network and database connection details. Allowing access to the log directory can expose the log files to public scrutiny.',
  p_impact_nlsid =>'CLIENT_TRC_DIR_PERM_IMPACT',
  p_recommendation =>'The client trace directory must be a valid directory owned by the Oracle set with no permissions to public.',
  p_recommendation_nlsid =>'CLIENT_TRC_DIR_PERM_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_CRITICAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>  'rownum > 0', 
  p_message =>'The listener is in an insecure state. The users %users% have critical permissions on the client trace directory %dir_name%.',
  p_message_nlsid =>'CLIENT_TRC_DIR_NT_PERM_MESG',
  p_start_type_meta_ver => ESM.LSNR_TYPE_META_VERSION,
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList  
);
COMMIT;

  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
    MGMT_VIOL_CTXT_DEF.NEW(p_metric_column => 'users'),
    MGMT_VIOL_CTXT_DEF.NEW(p_metric_column => 'dir_name'));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));
 ESM.MODIFY_POLICY(
  p_target_type => ESM.LSNR_TARGET_TYPE,
  p_policy_name =>'sqlnet_Server_Trace_DirNT',   --Policy name
  p_metric_name =>'svrTrcDirNTRep',      --Metric name
  p_policy_label_nlsid =>'SERV_TRC_DIR_PERM_NAME_NT',   
  p_description =>'Ensures that the server trace directory is a valid directory owned by Oracle set with no permissions to public',
  p_description_nlsid =>'SERV_TRC_DIR_PERM_DESC',
  p_impact =>'Tracing produces a detailed sequence of statements that describe network events as they are executed. Tracing an operation enables you to obtain more information on the internal operations of the components of Oracle Net Services than is provided in a log file. The information in this file can reveal important network and database connection details. Allowing access to the log directory can expose the log files to public scrutiny.',
  p_impact_nlsid =>'SERV_TRC_DIR_PERM_IMPACT',
  p_recommendation =>'The server trace directory must be a valid directory owned by the Oracle set with no permissions to public.',
  p_recommendation_nlsid =>'SERV_TRC_DIR_PERM_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_CRITICAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>  'rownum > 0', 
  p_message =>'The listener is in an insecure state. The users %users% have critical permissions on the server trace directory %dir_name%.',
  p_message_nlsid =>'SERV_TRC_DIR_NT_PERM_MESG',
  p_start_type_meta_ver => ESM.LSNR_TYPE_META_VERSION,
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList  
);
COMMIT;

  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
    MGMT_VIOL_CTXT_DEF.NEW(p_metric_column => 'users'));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));
 ESM.MODIFY_POLICY(
  p_target_type => ESM.LSNR_TARGET_TYPE,
  p_policy_name =>'Sqlnet_Ora_Restrict_PermsNT',   --Policy name
  p_metric_name =>'sqlnetOraPermNTRep',      --Metric name
  p_policy_label_nlsid =>'SQLNET_PERM_NAME_NT',   
  p_description =>'Ensures that the sqlnet.ora file is not accessible to public',
  p_description_nlsid =>'SQLNET_PERM_DESC',
  p_impact =>'If sqlnet.ora is public readable a malicious user may attempt to read this hence could lead to sensitive information getting exposed .For example, log and trace destination information of the client and server.',
  p_impact_nlsid =>'SQLNET_PERM_IMPACT',
  p_recommendation =>'Public should not be given any  permissions on the sqlnet.ora file.',
  p_recommendation_nlsid =>'SQLNET_PERM_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_CRITICAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition => 'rownum > 0',
  p_message =>'Listener is in insecure state. The following users have critical privileges on the sqlnet.ora file : %users%.',
  p_message_nlsid =>'SQLNET_PERM_NT_MESG',
  p_start_type_meta_ver => ESM.LSNR_TYPE_META_VERSION,
  p_cs_consider_percentage =>MGMT_GLOBAL.G_TRUE,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList  
);
COMMIT;



END;
/
show errors;

