Rem
Rem $Header: dbSecureConfigCS.sql 16-nov-2006.11:32:18 groyal Exp $
Rem
Rem dbSecureConfigCS.sql
Rem
Rem Copyright (c) 2006, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      dbSecureConfigCS.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    groyal      11/16/06 - XbranchMerge groyal_bug-5660652 from
Rem                           st_emdbgc_10.2.0.1.0
Rem    groyal      11/15/06 - Create in single transaction
Rem    groyal      10/13/06 - Created
Rem

-- SET ECHO ON
-- SET FEEDBACK 1
-- SET NUMWIDTH 10
-- SET LINESIZE 80
-- SET TRIMSPOOL ON
-- SET TAB OFF
-- SET PAGESIZE 100

SET DEFINE OFF

DECLARE

  l_cs_guid               mgmt_cs_config_standard.cs_guid%TYPE;
  l_folder_guid           mgmt_cs_rulefolder.rulefolder_guid%TYPE;
  l_nested_folder_guid    mgmt_cs_rulefolder.rulefolder_guid%TYPE;
  l_rule_guid             mgmt_cs_rule.rule_guid%TYPE;  
  l_keyword_list          MGMT_SHORT_STRING_TABLE;

BEGIN

  l_keyword_list := MGMT_SHORT_STRING_TABLE();
  l_keyword_list.extend();
  l_keyword_list(1) := 'dbSecure_SecurityKEYWORD';

  l_cs_guid := MGMT_CONFIG_STD.CREATE_CONFIG_STANDARD(
      p_cs_iname          => 'dbSecure',
      p_cs_dname          => 'dbSecure_NAME',
      p_version           => 1,
      p_target_type       => MGMT_GLOBAL.G_DATABASE_TARGET_TYPE,
      p_author            => 'ORACLE',
      p_lifecycle_status  => MGMT_CONFIG_STD.G_LIFECYCLE_PRODUCTION,
      p_description       => 'dbSecure_DESC',
      p_keyword_list      => l_keyword_list);
  
  -- COMMIT;

  -- ********************************************************************* 
  -- Post Installation 
  -- *********************************************************************   
  
  l_folder_guid := MGMT_CONFIG_STD.ADD_RULEFOLDER(
      p_cs_guid           => l_cs_guid,
      p_rulefolder_iname  => 'PostInstallation',
      p_rulefolder_dname  => 'PostInstallation_NAME',
      p_parent_guid       => l_cs_guid,      
      p_child_position    => 1,
      p_description       => 'PostInstallation_DESC');
  
  -- COMMIT;

  -- Default Passwords Have Been Changed         
  l_rule_guid := MGMT_CONFIG_STD.ADD_RULE(
      p_cs_guid           => l_cs_guid,
      p_rule_iname        => 'DefaultPwd',    
      p_rule_dname        => 'DefaultPwd_NAME',
      p_parent_guid       => l_folder_guid,
      p_child_position    => 1,
      p_importance_level  => MGMT_CONFIG_STD.G_IMPORTANCE_HIGH,
      p_test              => 'Default_Passwords',   
      p_test_type         => MGMT_CONFIG_STD.G_TEST_TYPE_POLICY,
      p_description       => 'DefaultPwd_DESC',
      p_rationale         => 'DefaultPwd_RATIONALE',
      p_fixtext           => 'DefaultPwd_FIX');
      
  -- COMMIT;
     
  -- Default Accounts are Locked and Expired   
  l_rule_guid := MGMT_CONFIG_STD.ADD_RULE(
      p_cs_guid           => l_cs_guid,
      p_rule_iname        => 'DefaultAccountLockedAndExpired',    
      p_rule_dname        => 'DefaultAccountLockedAndExpired_NAME',
      p_parent_guid       => l_folder_guid,
      p_child_position    => 2,
      p_importance_level  => MGMT_CONFIG_STD.G_IMPORTANCE_HIGH,
      p_test              => 'Well_known_Accounts',   
      p_test_type         => MGMT_CONFIG_STD.G_TEST_TYPE_POLICY,
      p_description       => 'DefaultAccountLockedAndExpired_DESC',
      p_rationale         => 'DefaultAccountLockedAndExpired_RATIONALE',
      p_fixtext           => 'DefaultAccountLockedAndExpired_FIX');
      
  -- COMMIT;     
     

  -- *********************************************************************
  -- Oracle Directory and File Permissions 
  -- *********************************************************************

  l_folder_guid := MGMT_CONFIG_STD.ADD_RULEFOLDER(
      p_cs_guid => l_cs_guid,
      p_rulefolder_iname  => 'OracleDirAndFilePerms',
      p_rulefolder_dname  => 'OracleDirAndFilePerms_NAME',
      p_parent_guid       => l_cs_guid,
      p_child_position    => 2,
      p_description       => 'OracleDirAndFilePerms_DESC');
  
  -- COMMIT;
  
  -- *********************************************************************
  -- Unix Platform 
  -- *********************************************************************

  l_nested_folder_guid := MGMT_CONFIG_STD.ADD_RULEFOLDER(
      p_cs_guid           => l_cs_guid,
      p_rulefolder_iname  => 'OracleDirAndFilePermsU',
      p_rulefolder_dname  => 'OracleDirAndFilePermsU_NAME',
      p_parent_guid       => l_folder_guid,
      p_child_position    => 1,
      p_description       => 'OracleDirAndFilePermsU_DESC');
  
  -- COMMIT;
  
  -- Appropriate umask Value       
  l_rule_guid := MGMT_CONFIG_STD.ADD_RULE(
      p_cs_guid           => l_cs_guid,
      p_rule_iname        => 'AppropriateUMaskValue',    
      p_rule_dname        => 'AppropriateUMaskValue_NAME',
      p_parent_guid       => l_nested_folder_guid,
      p_child_position    => 1,
      p_importance_level  => MGMT_CONFIG_STD.G_IMPORTANCE_NORMAL,
      p_test              => 'Umask_Setting',   
      p_test_type         => MGMT_CONFIG_STD.G_TEST_TYPE_POLICY,
      p_description       => 'AppropriateUMaskValue_DESC',
      p_rationale         => 'AppropriateUMaskValue_RATIONALE',
      p_fixtext           => 'AppropriateUMaskValue_FIX');
            
  -- COMMIT;

  -- Database Datafiles       
  l_rule_guid := MGMT_CONFIG_STD.ADD_RULE(
      p_cs_guid           => l_cs_guid,
      p_rule_iname        => 'DbDatafilesU',    
      p_rule_dname        => 'DbDatafilesU_NAME',
      p_parent_guid       => l_nested_folder_guid,
      p_child_position    => 2,
      p_importance_level  => MGMT_CONFIG_STD.G_IMPORTANCE_HIGH,
      p_test              => 'Oracle_Home_Data_Files_Permission',   
      p_test_type         => MGMT_CONFIG_STD.G_TEST_TYPE_POLICY,
      p_description       => 'DbDatafilesU_DESC',
      p_rationale         => 'DbDatafilesU_RATIONALE',
      p_fixtext           => 'DbDatafilesU_FIX');
               
  -- COMMIT;
 
  -- IFILE Referenced File (IFILE)       
  l_rule_guid := MGMT_CONFIG_STD.ADD_RULE(
      p_cs_guid           => l_cs_guid,
      p_rule_iname        => 'IFileU',    
      p_rule_dname        => 'IFileU_NAME',
      p_parent_guid       => l_nested_folder_guid,
      p_child_position    => 3,
      p_importance_level  => MGMT_CONFIG_STD.G_IMPORTANCE_HIGH,
      p_test              => 'ifile_File_Permission',   
      p_test_type         => MGMT_CONFIG_STD.G_TEST_TYPE_POLICY,
      p_description       => 'IFileU_DESC',
      p_rationale         => 'IFileU_RATIONALE',
      p_fixtext           => 'IFileU_FIX');
                   
  -- COMMIT;
 
  -- Audit File Destination (AUDIT_FILE_DEST)       
  l_rule_guid := MGMT_CONFIG_STD.ADD_RULE(
      p_cs_guid           => l_cs_guid,
      p_rule_iname        => 'AuditFileDestU',    
      p_rule_dname        => 'AuditFileDestU_NAME',
      p_parent_guid       => l_nested_folder_guid,
      p_child_position    => 4,
      p_importance_level  => MGMT_CONFIG_STD.G_IMPORTANCE_HIGH,
      p_test              => 'Audit_File_Destination',   
      p_test_type         => MGMT_CONFIG_STD.G_TEST_TYPE_POLICY,
      p_description       => 'AuditFileDestU_DESC',
      p_rationale         => 'AuditFileDestU_RATIONALE',
      p_fixtext           => 'AuditFileDestU_FIX');
                   
  -- COMMIT;
  
  -- User Dump Destination (USER_DUMP_DEST)      
  l_rule_guid := MGMT_CONFIG_STD.ADD_RULE(
      p_cs_guid           => l_cs_guid,
      p_rule_iname        => 'UserDumpDestU',    
      p_rule_dname        => 'UserDumpDestU_NAME',
      p_parent_guid       => l_nested_folder_guid,
      p_child_position    => 5,
      p_importance_level  => MGMT_CONFIG_STD.G_IMPORTANCE_HIGH,
      p_test              => 'User_Dump_Destination',   
      p_test_type         => MGMT_CONFIG_STD.G_TEST_TYPE_POLICY,
      p_description       => 'UserDumpDestU_DESC',
      p_rationale         => 'UserDumpDestU_RATIONALE',
      p_fixtext           => 'UserDumpDestU_FIX');
                   
  -- COMMIT;
 
  -- Background Dump Destination (BACKGROUND_DUMP_DEST)       
  l_rule_guid := MGMT_CONFIG_STD.ADD_RULE(
      p_cs_guid           => l_cs_guid,
      p_rule_iname        => 'BackgroundDumpDestU',    
      p_rule_dname        => 'BackgroundDumpDestU_NAME',
      p_parent_guid       => l_nested_folder_guid,
      p_child_position    => 6,
      p_importance_level  => MGMT_CONFIG_STD.G_IMPORTANCE_HIGH,
      p_test              => 'Background_Dump_Destination',   
      p_test_type         => MGMT_CONFIG_STD.G_TEST_TYPE_POLICY,
      p_description       => 'BackgroundDumpDestU_DESC',
      p_rationale         => 'BackgroundDumpDestU_RATIONALE',
      p_fixtext           => 'BackgroundDumpDestU_FIX');
                   
  -- COMMIT;
 
  -- Core Dump Destination (CORE_DUMP_DEST)      
  l_rule_guid := MGMT_CONFIG_STD.ADD_RULE(
      p_cs_guid           => l_cs_guid,
      p_rule_iname        => 'CoreDumpDestU',    
      p_rule_dname        => 'CoreDumpDestU_NAME',
      p_parent_guid       => l_nested_folder_guid,
      p_child_position    => 7,
      p_importance_level  => MGMT_CONFIG_STD.G_IMPORTANCE_HIGH,
      p_test              => 'Core_Dump_Destination',   
      p_test_type         => MGMT_CONFIG_STD.G_TEST_TYPE_POLICY,
      p_description       => 'CoreDumpDestU_DESC',
      p_rationale         => 'CoreDumpDestU_RATIONALE',
      p_fixtext           => 'CoreDumpDestU_FIX');
                   
  -- COMMIT;
  
  -- Control Files (CONTROL_FILES)      
  l_rule_guid := MGMT_CONFIG_STD.ADD_RULE(
      p_cs_guid           => l_cs_guid,
      p_rule_iname        => 'ControlFilesU',    
      p_rule_dname        => 'ControlFilesU_NAME',
      p_parent_guid       => l_nested_folder_guid,
      p_child_position    => 8,
      p_importance_level  => MGMT_CONFIG_STD.G_IMPORTANCE_HIGH,
      p_test              => 'DB_control_files_Permission',   
      p_test_type         => MGMT_CONFIG_STD.G_TEST_TYPE_POLICY,
      p_description       => 'ControlFilesU_DESC',
      p_rationale         => 'ControlFilesU_RATIONALE',
      p_fixtext           => 'ControlFilesU_FIX');
                   
  -- COMMIT;
  
  -- Oracle Home Executables   
  l_rule_guid := MGMT_CONFIG_STD.ADD_RULE(
      p_cs_guid           => l_cs_guid,
      p_rule_iname        => 'OHExecutablesU',    
      p_rule_dname        => 'OHExecutablesU_NAME',
      p_parent_guid       => l_nested_folder_guid,
      p_child_position    => 9,
      p_importance_level  => MGMT_CONFIG_STD.G_IMPORTANCE_NORMAL,
      p_test              => 'Oracle_Home_Executable_Files_Permission',   
      p_test_type         => MGMT_CONFIG_STD.G_TEST_TYPE_POLICY,
      p_description       => 'OHExecutablesU_DESC',
      p_rationale         => 'OHExecutablesU_RATIONALE',
      p_fixtext           => 'OHExecutablesU_FIX');
                   
  -- COMMIT;

  -- Oracle Home Non-Executables  
  l_rule_guid := MGMT_CONFIG_STD.ADD_RULE(
      p_cs_guid           => l_cs_guid,
      p_rule_iname        => 'OHNonExecutablesU',    
      p_rule_dname        => 'OHNonExecutablesU_NAME',
      p_parent_guid       => l_nested_folder_guid,
      p_child_position    => 10,
      p_importance_level  => MGMT_CONFIG_STD.G_IMPORTANCE_NORMAL,
      p_test              => 'Oracle_Home_File_Permission',   
      p_test_type         => MGMT_CONFIG_STD.G_TEST_TYPE_POLICY,
      p_description       => 'OHNonExecutablesU_DESC',
      p_rationale         => 'OHNonExecutablesU_RATIONALE',
      p_fixtext           => 'OHNonExecutablesU_FIX');
                   
  -- COMMIT;

  -- *********************************************************************
  -- END Unix Platform
  -- *********************************************************************


  -- *********************************************************************
  -- Windows Platform
  -- *********************************************************************

  l_nested_folder_guid := MGMT_CONFIG_STD.ADD_RULEFOLDER(
      p_cs_guid           => l_cs_guid,
      p_rulefolder_iname  => 'OracleDirAndFilePermsW',
      p_rulefolder_dname  => 'OracleDirAndFilePermsW_NAME',
      p_parent_guid       => l_folder_guid,
      p_child_position    => 2,
      p_description       => 'OracleDirAndFilePermsW_DESC');
  
  -- COMMIT;
 
  -- Database Datafiles 
  l_rule_guid := MGMT_CONFIG_STD.ADD_RULE(
      p_cs_guid           => l_cs_guid,
      p_rule_iname        => 'DbDatafilesW',    
      p_rule_dname        => 'DbDatafilesW_NAME',
      p_parent_guid       => l_nested_folder_guid,
      p_child_position    => 1,
      p_importance_level  => MGMT_CONFIG_STD.G_IMPORTANCE_HIGH,
      p_test              => 'Oracle_Home_Data_Files_PermissionNT',   
      p_test_type         => MGMT_CONFIG_STD.G_TEST_TYPE_POLICY,
      p_description       => 'DbDatafilesW_DESC',
      p_rationale         => 'DbDatafilesW_RATIONALE',
      p_fixtext           => 'DbDatafilesW_FIX');
                   
  -- COMMIT;
  
  -- IFILE Referenced File (IFILE)
  l_rule_guid := MGMT_CONFIG_STD.ADD_RULE(
      p_cs_guid           => l_cs_guid,
      p_rule_iname        => 'IFileW',    
      p_rule_dname        => 'IFileW_NAME',
      p_parent_guid       => l_nested_folder_guid,
      p_child_position    => 2,
      p_importance_level  => MGMT_CONFIG_STD.G_IMPORTANCE_HIGH,
      p_test              => 'ifile_File_PermissionNT',   
      p_test_type         => MGMT_CONFIG_STD.G_TEST_TYPE_POLICY,
      p_description       => 'IFileW_DESC',
      p_rationale         => 'IFileW_RATIONALE',
      p_fixtext           => 'IFileW_FIX');
                   
  -- COMMIT;
  
  --  Audit File Destination (AUDIT_FILE_DEST)
  l_rule_guid := MGMT_CONFIG_STD.ADD_RULE(
      p_cs_guid           => l_cs_guid,
      p_rule_iname        => 'AuditFileDestW',    
      p_rule_dname        => 'AuditFileDestW_NAME',
      p_parent_guid       => l_nested_folder_guid,
      p_child_position    => 3,
      p_importance_level  => MGMT_CONFIG_STD.G_IMPORTANCE_HIGH,
      p_test              => 'Audit_File_DestinationNT',   
      p_test_type         => MGMT_CONFIG_STD.G_TEST_TYPE_POLICY,
      p_description       => 'AuditFileDestW_DESC',
      p_rationale         => 'AuditFileDestW_RATIONALE',
      p_fixtext           => 'AuditFileDestW_FIX');
                   
  -- COMMIT;

  --  User Dump Destination (USER_DUMP_DEST)
  l_rule_guid := MGMT_CONFIG_STD.ADD_RULE(
      p_cs_guid           => l_cs_guid,
      p_rule_iname        => 'UserDumpDestW',    
      p_rule_dname        => 'UserDumpDestW_NAME',
      p_parent_guid       => l_nested_folder_guid,
      p_child_position    => 4,
      p_importance_level  => MGMT_CONFIG_STD.G_IMPORTANCE_HIGH,
      p_test              => 'User_Dump_DestinationNT',   
      p_test_type         => MGMT_CONFIG_STD.G_TEST_TYPE_POLICY,
      p_description       => 'UserDumpDestW_DESC',
      p_rationale         => 'UserDumpDestW_RATIONALE',
      p_fixtext           => 'UserDumpDestW_FIX');
                   
  -- COMMIT;

  --  Background Dump Destination (BACKGROUND_DUMP_DEST) 
  l_rule_guid := MGMT_CONFIG_STD.ADD_RULE(
      p_cs_guid           => l_cs_guid,
      p_rule_iname        => 'BackgroundDumpDestW',    
      p_rule_dname        => 'BackgroundDumpDestW_NAME',
      p_parent_guid       => l_nested_folder_guid,
      p_child_position    => 5,
      p_importance_level  => MGMT_CONFIG_STD.G_IMPORTANCE_HIGH,
      p_test              => 'Background_Dump_DestinationNT',   
      p_test_type         => MGMT_CONFIG_STD.G_TEST_TYPE_POLICY,
      p_description       => 'BackgroundDumpDestW_DESC',
      p_rationale         => 'BackgroundDumpDestW_RATIONALE',
      p_fixtext           => 'BackgroundDumpDestW_FIX');
                   
  -- COMMIT;
  
  --  Core Dump Destination (CORE_DUMP_DEST) 
  l_rule_guid := MGMT_CONFIG_STD.ADD_RULE(
      p_cs_guid           => l_cs_guid,
      p_rule_iname        => 'CoreDumpDestW',    
      p_rule_dname        => 'CoreDumpDestW_NAME',
      p_parent_guid       => l_nested_folder_guid,
      p_child_position    => 6,
      p_importance_level  => MGMT_CONFIG_STD.G_IMPORTANCE_HIGH,
      p_test              => 'Core_Dump_DestinationNT',   
      p_test_type         => MGMT_CONFIG_STD.G_TEST_TYPE_POLICY,
      p_description       => 'CoreDumpDestW_DESC',
      p_rationale         => 'CoreDumpDestW_RATIONALE',
      p_fixtext           => 'CoreDumpDestW_FIX');
                   
  -- COMMIT;
  
  --  Control Files (CONTROL_FILES) 
  l_rule_guid := MGMT_CONFIG_STD.ADD_RULE(
      p_cs_guid           => l_cs_guid,
      p_rule_iname        => 'ControlFilesW',    
      p_rule_dname        => 'ControlFilesW_NAME',
      p_parent_guid       => l_nested_folder_guid,
      p_child_position    => 7,
      p_importance_level  => MGMT_CONFIG_STD.G_IMPORTANCE_HIGH,
      p_test              => 'DB_control_files_PermissionNT',   
      p_test_type         => MGMT_CONFIG_STD.G_TEST_TYPE_POLICY,
      p_description       => 'ControlFilesW_DESC',
      p_rationale         => 'ControlFilesW_RATIONALE',
      p_fixtext           => 'ControlFilesW_FIX');
                   
  -- COMMIT;
  
  --  Oracle Home Executables
  l_rule_guid := MGMT_CONFIG_STD.ADD_RULE(
      p_cs_guid           => l_cs_guid,
      p_rule_iname        => 'OHExecutablesW',    
      p_rule_dname        => 'OHExecutablesW_NAME',
      p_parent_guid       => l_nested_folder_guid,
      p_child_position    => 8,
      p_importance_level  => MGMT_CONFIG_STD.G_IMPORTANCE_NORMAL,
      p_test              => 'Oracle_Home_Executable_Files_PermissionNT',   
      p_test_type         => MGMT_CONFIG_STD.G_TEST_TYPE_POLICY,
      p_description       => 'OHExecutablesW_DESC',
      p_rationale         => 'OHExecutablesW_RATIONALE',
      p_fixtext           => 'OHExecutablesW_FIX');
      
  -- COMMIT;

  -- *********************************************************************
  -- END Windows Platform
  -- *********************************************************************

  --  Oracle Home Executable Files Owned by Oracle
  l_rule_guid := MGMT_CONFIG_STD.ADD_RULE(
      p_cs_guid           => l_cs_guid,
      p_rule_iname        => 'OHExecutablesOracleOwned',    
      p_rule_dname        => 'OHExecutablesOracleOwned_NAME',
      p_parent_guid       => l_folder_guid,
      p_child_position    => 3,
      p_importance_level  => MGMT_CONFIG_STD.G_IMPORTANCE_HIGH,
      p_test              => 'Oracle_Home_Executable_Files_Owner',   
      p_test_type         => MGMT_CONFIG_STD.G_TEST_TYPE_POLICY,
      p_description       => 'OHExecutablesOracleOwned_DESC',
      p_rationale         => 'OHExecutablesOracleOwned_RATIONALE',
      p_fixtext           => 'OHExecutablesOracleOwned_FIX');
      
  -- COMMIT;
  
  -- *********************************************************************
  -- END Oracle Directory and File Permissions
  -- *********************************************************************
  

  -- *********************************************************************
  -- Oracle Parameter Settings 
  -- *********************************************************************

  l_folder_guid := MGMT_CONFIG_STD.ADD_RULEFOLDER(
      p_cs_guid           => l_cs_guid,
      p_rulefolder_iname  => 'OracleParamSettings',
      p_rulefolder_dname  => 'OracleParamSettings_NAME',
      p_parent_guid       => l_cs_guid,
      p_child_position    => 3,
      p_description       => 'OracleParamSettings_DESC');
  
  -- COMMIT;
 
  --  Access to Trace Files Disabled (_TRACE_FILES_PUBLIC)
  l_rule_guid := MGMT_CONFIG_STD.ADD_RULE(
      p_cs_guid           => l_cs_guid,
      p_rule_iname        => 'AccessToTraceFileDisabled',    
      p_rule_dname        => 'AccessToTraceFileDisabled_NAME',
      p_parent_guid       => l_folder_guid,
      p_child_position    => 1,
      p_importance_level  => MGMT_CONFIG_STD.G_IMPORTANCE_HIGH,
      p_test              => 'PUBLIC_Trace_Files',   
      p_test_type         => MGMT_CONFIG_STD.G_TEST_TYPE_POLICY,
      p_description       => 'AccessToTraceFileDisabled_DESC',
      p_rationale         => 'AccessToTraceFileDisabled_RATIONALE',
      p_fixtext           => 'AccessToTraceFileDisabled_FIX');
      
  -- COMMIT;  
   
   --  Remote OS Roles Disabled (REMOTE_OS_ROLES)
  l_rule_guid := MGMT_CONFIG_STD.ADD_RULE(
      p_cs_guid           => l_cs_guid,
      p_rule_iname        => 'RemoteOSRolesDisabled',    
      p_rule_dname        => 'RemoteOSRolesDisabled_NAME',
      p_parent_guid       => l_folder_guid,
      p_child_position    => 2,
      p_importance_level  => MGMT_CONFIG_STD.G_IMPORTANCE_HIGH,
      p_test              => 'Remote_OS_Role',   
      p_test_type         => MGMT_CONFIG_STD.G_TEST_TYPE_POLICY,
      p_description       => 'RemoteOSRolesDisabled_DESC',
      p_rationale         => 'RemoteOSRolesDisabled_RATIONALE',
      p_fixtext           => 'RemoteOSRolesDisabled_FIX');
      
  -- COMMIT;  
  
   --  Remote OS Authentication Disabled (REMOTE_OS_AUTHENT)
  l_rule_guid := MGMT_CONFIG_STD.ADD_RULE(
      p_cs_guid           => l_cs_guid,
      p_rule_iname        => 'RemoteOSAuthenticationDisabled',    
      p_rule_dname        => 'RemoteOSAuthenticationDisabled_NAME',
      p_parent_guid       => l_folder_guid,
      p_child_position    => 3,
      p_importance_level  => MGMT_CONFIG_STD.G_IMPORTANCE_HIGH,
      p_test              => 'Remote_OS_Authentication',   
      p_test_type         => MGMT_CONFIG_STD.G_TEST_TYPE_POLICY,
      p_description       => 'RemoteOSAuthenticationDisabled_DESC',
      p_rationale         => 'RemoteOSAuthenticationDisabled_RATIONALE',
      p_fixtext           => 'RemoteOSAuthenticationDisabled_FIX');
      
  -- COMMIT; 
  
  --  Use of Remote Listener Instances Disabled (REMOTE_LISTENER)
  l_rule_guid := MGMT_CONFIG_STD.ADD_RULE(
      p_cs_guid           => l_cs_guid,
      p_rule_iname        => 'RemoteLsnrInstancesDisabled',    
      p_rule_dname        => 'RemoteLsnrInstancesDisabled_NAME',
      p_parent_guid       => l_folder_guid,
      p_child_position    => 4,
      p_importance_level  => MGMT_CONFIG_STD.G_IMPORTANCE_NORMAL,
      p_test              => 'Remote_Listener_Instances',   
      p_test_type         => MGMT_CONFIG_STD.G_TEST_TYPE_POLICY,
      p_description       => 'RemoteLsnrInstancesDisabled_DESC',
      p_rationale         => 'RemoteLsnrInstancesDisabled_RATIONALE',
      p_fixtext           => 'RemoteLsnrInstancesDisabled_FIX');
      
  -- COMMIT;  

  --  Database Auditing Enabled (AUDIT_TRAIL)
  l_rule_guid := MGMT_CONFIG_STD.ADD_RULE(
      p_cs_guid           => l_cs_guid,
      p_rule_iname        => 'DbAuditingEnabled',    
      p_rule_dname        => 'DbAuditingEnabled_NAME',
      p_parent_guid       => l_folder_guid,
      p_child_position    => 5,
      p_importance_level  => MGMT_CONFIG_STD.G_IMPORTANCE_LOW,
      p_test              => 'Audit_Trail',   
      p_test_type         => MGMT_CONFIG_STD.G_TEST_TYPE_POLICY,
      p_description       => 'DbAuditingEnabled_DESC',
      p_rationale         => 'DbAuditingEnabled_RATIONALE',
      p_fixtext           => 'DbAuditingEnabled_FIX',
      p_warning           => 'DbAuditingEnabled_WARNING');
      
  -- COMMIT; 

  --  Secure OS Authentication Prefix (OS_AUTHENT_PREFIX)
  l_rule_guid := MGMT_CONFIG_STD.ADD_RULE(
      p_cs_guid           => l_cs_guid,
      p_rule_iname        => 'SecureOSAuthenticationPrefix',    
      p_rule_dname        => 'SecureOSAuthenticationPrefix_NAME',
      p_parent_guid       => l_folder_guid,
      p_child_position    => 6,
      p_importance_level  => MGMT_CONFIG_STD.G_IMPORTANCE_NORMAL,
      p_test              => 'Os_Authent_Prefix',   
      p_test_type         => MGMT_CONFIG_STD.G_TEST_TYPE_POLICY,
      p_description       => 'SecureOSAuthenticationPrefix_DESC',
      p_rationale         => 'SecureOSAuthenticationPrefix_RATIONALE',
      p_fixtext           => 'SecureOSAuthenticationPrefix_FIX');
      
  -- COMMIT;

  --  Access to Data Dictionary Protected (07_DICTIONARY_ACCESSIBILITY) 
  l_rule_guid := MGMT_CONFIG_STD.ADD_RULE(
      p_cs_guid           => l_cs_guid,
      p_rule_iname        => 'AccessToDataDictionaryProtected',    
      p_rule_dname        => 'AccessToDataDictionaryProtected_NAME',
      p_parent_guid       => l_folder_guid,
      p_child_position    => 7,
      p_importance_level  => MGMT_CONFIG_STD.G_IMPORTANCE_HIGH,
      p_test              => 'DATA_DICTIONARY_PROTECTED',   
      p_test_type         => MGMT_CONFIG_STD.G_TEST_TYPE_POLICY,
      p_description       => 'AccessToDataDictionaryProtected_DESC',
      p_rationale         => 'AccessToDataDictionaryProtected_RATIONALE',
      p_fixtext           => 'AccessToDataDictionaryProtected_FIX');
      
  -- COMMIT;
  
  --  Auditing of SYS Operations Enabled (AUDIT_SYS_OPERATIONS) 
  l_rule_guid := MGMT_CONFIG_STD.ADD_RULE(
      p_cs_guid           => l_cs_guid,
      p_rule_iname        => 'AuditingSysOperationsEnabled',    
      p_rule_dname        => 'AuditingSysOperationsEnabled_NAME',
      p_parent_guid       => l_folder_guid,
      p_child_position    => 8,
      p_importance_level  => MGMT_CONFIG_STD.G_IMPORTANCE_NORMAL,
      p_test              => 'AUDIT_SYS_OPS',   
      p_test_type         => MGMT_CONFIG_STD.G_TEST_TYPE_POLICY,
      p_description       => 'AuditingSysOperationsEnabled_DESC',
      p_rationale         => 'AuditingSysOperationsEnabled_RATIONALE',
      p_fixtext           => 'AuditingSysOperationsEnabled_FIX',
      p_warning           => 'AuditingSysOperationsEnabled_WARNING');
      
  -- COMMIT;
  
  -- *********************************************************************
  -- END Oracle Parameter Settings 
  -- *********************************************************************
  

  -- *********************************************************************
  -- Database Password Profile Settings
  -- *********************************************************************

  l_folder_guid := MGMT_CONFIG_STD.ADD_RULEFOLDER(
      p_cs_guid           => l_cs_guid,
      p_rulefolder_iname  => 'DbPwdProfileSettings',
      p_rulefolder_dname  => 'DbPwdProfileSettings_NAME',
      p_parent_guid       => l_cs_guid,
      p_child_position    => 4,
      p_description       => 'DbPwdProfileSettings_DESC');
  
  -- COMMIT;
  
  --  Secure Failed Login Attempts Setting 
  l_rule_guid := MGMT_CONFIG_STD.ADD_RULE(
      p_cs_guid           => l_cs_guid,
      p_rule_iname        => 'SecureFailedLoginAttemptsSetting',    
      p_rule_dname        => 'SecureFailedLoginAttemptsSetting_NAME',
      p_parent_guid       => l_folder_guid,
      p_child_position    => 1,
      p_importance_level  => MGMT_CONFIG_STD.G_IMPORTANCE_HIGH,
      p_test              => 'Unlimited_login_attempts',   
      p_test_type         => MGMT_CONFIG_STD.G_TEST_TYPE_POLICY,
      p_description       => 'SecureFailedLoginAttemptsSetting_DESC',
      p_rationale         => 'SecureFailedLoginAttemptsSetting_RATIONALE',
      p_fixtext           => 'SecureFailedLoginAttemptsSetting_FIX');
      
  -- COMMIT; 

  --  Secure Password Life Time Setting 
  l_rule_guid := MGMT_CONFIG_STD.ADD_RULE(
      p_cs_guid           => l_cs_guid,
      p_rule_iname        => 'SecurePwdLifeTimeSetting',    
      p_rule_dname        => 'SecurePwdLifeTimeSetting_NAME',
      p_parent_guid       => l_folder_guid,
      p_child_position    => 2,
      p_importance_level  => MGMT_CONFIG_STD.G_IMPORTANCE_NORMAL,
      p_test              => 'Password_Life_Time',   
      p_test_type         => MGMT_CONFIG_STD.G_TEST_TYPE_POLICY,
      p_description       => 'SecurePwdLifeTimeSetting_DESC',
      p_rationale         => 'SecurePwdLifeTimeSetting_RATIONALE',
      p_fixtext           => 'SecurePwdLifeTimeSetting_FIX');
      
  -- COMMIT; 
  
  --  Secure Password Lock Time Setting 
  l_rule_guid := MGMT_CONFIG_STD.ADD_RULE(
      p_cs_guid           => l_cs_guid,
      p_rule_iname        => 'SecurePwdLockTimeSetting',    
      p_rule_dname        => 'SecurePwdLockTimeSetting_NAME',
      p_parent_guid       => l_folder_guid,
      p_child_position    => 3,
      p_importance_level  => MGMT_CONFIG_STD.G_IMPORTANCE_NORMAL,
      p_test              => 'Password_Locking_Time',   
      p_test_type         => MGMT_CONFIG_STD.G_TEST_TYPE_POLICY,
      p_description       => 'SecurePwdLockTimeSetting_DESC',
      p_rationale         => 'SecurePwdLockTimeSetting_RATIONALE',
      p_fixtext           => 'SecurePwdLockTimeSetting_FIX');
      
  -- COMMIT; 
  
  --  Secure Password Grace Time Setting 
  l_rule_guid := MGMT_CONFIG_STD.ADD_RULE(
      p_cs_guid           => l_cs_guid,
      p_rule_iname        => 'SecurePwdGraceTimeSetting',    
      p_rule_dname        => 'SecurePwdGraceTimeSetting_NAME',
      p_parent_guid       => l_folder_guid,
      p_child_position    => 4,
      p_importance_level  => MGMT_CONFIG_STD.G_IMPORTANCE_HIGH,
      p_test              => 'Password_Grace_Time',   
      p_test_type         => MGMT_CONFIG_STD.G_TEST_TYPE_POLICY,
      p_description       => 'SecurePwdGraceTimeSetting_DESC',
      p_rationale         => 'SecurePwdGraceTimeSetting_RATIONALE',
      p_fixtext           => 'SecurePwdGraceTimeSetting_FIX');
      
  -- COMMIT;   
   
  --  Password Complexity Checking Enabled
  l_rule_guid := MGMT_CONFIG_STD.ADD_RULE(
      p_cs_guid           => l_cs_guid,
      p_rule_iname        => 'PwdComplexityCheckingEnabled',    
      p_rule_dname        => 'PwdComplexityCheckingEnabled_NAME',
      p_parent_guid       => l_folder_guid,
      p_child_position    => 5,
      p_importance_level  => MGMT_CONFIG_STD.G_IMPORTANCE_HIGH,
      p_test              => 'Password_Complexity_Fn_Usage',   
      p_test_type         => MGMT_CONFIG_STD.G_TEST_TYPE_POLICY,
      p_description       => 'PwdComplexityCheckingEnabled_DESC',
      p_rationale         => 'PwdComplexityCheckingEnabled_RATIONALE',
      p_fixtext           => 'PwdComplexityCheckingEnabled_FIX');
      
  -- COMMIT;  
  
  -- *********************************************************************
  -- END Database Password Profile Settings
  -- *********************************************************************


  -- *********************************************************************
  -- Database Access Settings
  -- *********************************************************************

  l_folder_guid := MGMT_CONFIG_STD.ADD_RULEFOLDER(
      p_cs_guid           => l_cs_guid,
      p_rulefolder_iname  => 'DbAccessSettings',
      p_rulefolder_dname  => 'DbAccessSettings_NAME',
      p_parent_guid       => l_cs_guid,
      p_child_position    => 5,
      p_description       => 'DbAccessSettings_DESC');
  
  -- COMMIT;
  
  -- *********************************************************************
  -- Views
  -- *********************************************************************

  l_nested_folder_guid := MGMT_CONFIG_STD.ADD_RULEFOLDER(
      p_cs_guid           => l_cs_guid,
      p_rulefolder_iname  => 'Views',
      p_rulefolder_dname  => 'Views_NAME',
      p_parent_guid       => l_folder_guid,
      p_child_position    => 1,
      p_description       => 'Views_DESC');
  
  -- COMMIT;

  --  Restricted Access to DBA_ROLES
  l_rule_guid := MGMT_CONFIG_STD.ADD_RULE(
      p_cs_guid           => l_cs_guid,
      p_rule_iname        => 'DBARoles',    
      p_rule_dname        => 'DBARoles_NAME',
      p_parent_guid       => l_nested_folder_guid,
      p_child_position    => 1,
      p_importance_level  => MGMT_CONFIG_STD.G_IMPORTANCE_LOW,
      p_test              => 'Access_To_DBA_ROLES_View',   
      p_test_type         => MGMT_CONFIG_STD.G_TEST_TYPE_POLICY,
      p_description       => 'DBARoles_DESC',
      p_rationale         => 'DBARoles_RATIONALE',
      p_fixtext           => 'DBARoles_FIX');
      
  -- COMMIT;  
  
  --  Restricted Access to DBA_SYS_PRIVS
  l_rule_guid := MGMT_CONFIG_STD.ADD_RULE(
      p_cs_guid           => l_cs_guid,
      p_rule_iname        => 'DBASysPrivs',    
      p_rule_dname        => 'DBASysPrivs_NAME',
      p_parent_guid       => l_nested_folder_guid,
      p_child_position    => 2,
      p_importance_level  => MGMT_CONFIG_STD.G_IMPORTANCE_LOW,
      p_test              => 'Access_To_DBA_SYS_PRIVS_View',   
      p_test_type         => MGMT_CONFIG_STD.G_TEST_TYPE_POLICY,
      p_description       => 'DBASysPrivs_DESC',
      p_rationale         => 'DBASysPrivs_RATIONALE',
      p_fixtext           => 'DBASysPrivs_FIX');
      
  -- COMMIT;  

  --  Restricted Access to DBA_ROLE_PRIVS
  l_rule_guid := MGMT_CONFIG_STD.ADD_RULE(
      p_cs_guid           => l_cs_guid,
      p_rule_iname        => 'DBARolePrivs',    
      p_rule_dname        => 'DBARolePrivs_NAME',
      p_parent_guid       => l_nested_folder_guid,
      p_child_position    => 3,
      p_importance_level  => MGMT_CONFIG_STD.G_IMPORTANCE_LOW,
      p_test              => 'Access_To_DBA_ROLE_PRIVS_View',   
      p_test_type         => MGMT_CONFIG_STD.G_TEST_TYPE_POLICY,
      p_description       => 'DBARolePrivs_DESC',
      p_rationale         => 'DBARolePrivs_RATIONALE',
      p_fixtext           => 'DBARolePrivs_FIX');
      
  -- COMMIT; 
  
  --  Restricted Access to DBA_TAB_PRIVS
  l_rule_guid := MGMT_CONFIG_STD.ADD_RULE(
      p_cs_guid           => l_cs_guid,
      p_rule_iname        => 'DBATabPrivs',    
      p_rule_dname        => 'DBATabPrivs_NAME',
      p_parent_guid       => l_nested_folder_guid,
      p_child_position    => 4,
      p_importance_level  => MGMT_CONFIG_STD.G_IMPORTANCE_LOW,
      p_test              => 'Access_To_DBA_TAB_PRIVS_View',   
      p_test_type         => MGMT_CONFIG_STD.G_TEST_TYPE_POLICY,
      p_description       => 'DBATabPrivs_DESC',
      p_rationale         => 'DBATabPrivs_RATIONALE',
      p_fixtext           => 'DBATabPrivs_FIX');
      
  -- COMMIT;  
  
  --  Restricted Access to DBA_USERS
  l_rule_guid := MGMT_CONFIG_STD.ADD_RULE(
      p_cs_guid           => l_cs_guid,
      p_rule_iname        => 'DBAUsers',    
      p_rule_dname        => 'DBAUsers_NAME',
      p_parent_guid       => l_nested_folder_guid,
      p_child_position    => 5,
      p_importance_level  => MGMT_CONFIG_STD.G_IMPORTANCE_LOW,
      p_test              => 'Access_To_DBA_USERS_View',   
      p_test_type         => MGMT_CONFIG_STD.G_TEST_TYPE_POLICY,
      p_description       => 'DBAUsers_DESC',
      p_rationale         => 'DBAUsers_RATIONALE',
      p_fixtext           => 'DBAUsers_FIX');
      
  -- COMMIT;  

  -- *********************************************************************
  -- END Views
  -- *********************************************************************

  -- *********************************************************************
  -- Tables
  -- *********************************************************************

  l_nested_folder_guid := MGMT_CONFIG_STD.ADD_RULEFOLDER(
      p_cs_guid           => l_cs_guid,
      p_rulefolder_iname  => 'Tables',
      p_rulefolder_dname  => 'Tables_NAME',
      p_parent_guid       => l_folder_guid,
      p_child_position    => 2,
      p_description       => 'Tables_DESC');
  
  -- COMMIT;

  --  Restricted Access to SYS.AUD$
  l_rule_guid := MGMT_CONFIG_STD.ADD_RULE(
      p_cs_guid           => l_cs_guid,
      p_rule_iname        => 'SYSAud',    
      p_rule_dname        => 'SYSAud_NAME',
      p_parent_guid       => l_nested_folder_guid,
      p_child_position    => 1,
      p_importance_level  => MGMT_CONFIG_STD.G_IMPORTANCE_LOW,
      p_test              => 'Access_To_AUD_Table',   
      p_test_type         => MGMT_CONFIG_STD.G_TEST_TYPE_POLICY,
      p_description       => 'SYSAud_DESC',
      p_rationale         => 'SYSAud_RATIONALE',
      p_fixtext           => 'SYSAud_FIX');
      
  -- COMMIT; 
  
  --  Restricted Access to SYS.USER_HISTORY$
  l_rule_guid := MGMT_CONFIG_STD.ADD_RULE(
      p_cs_guid           => l_cs_guid,
      p_rule_iname        => 'SYSUserHistory',    
      p_rule_dname        => 'SYSUserHistory_NAME',
      p_parent_guid       => l_nested_folder_guid,
      p_child_position    => 2,
      p_importance_level  => MGMT_CONFIG_STD.G_IMPORTANCE_LOW,
      p_test              => 'Access_To_USER_HISTORY_Table',   
      p_test_type         => MGMT_CONFIG_STD.G_TEST_TYPE_POLICY,
      p_description       => 'SYSUserHistory_DESC',
      p_rationale         => 'SYSUserHistory_RATIONALE',
      p_fixtext           => 'SYSUserHistory_FIX');
      
  -- COMMIT; 
  
  --  Restricted Access to SYS.USER$
  l_rule_guid := MGMT_CONFIG_STD.ADD_RULE(
      p_cs_guid           => l_cs_guid,
      p_rule_iname        => 'SYSUser',    
      p_rule_dname        => 'SYSUser_NAME',
      p_parent_guid       => l_nested_folder_guid,
      p_child_position    => 3,
      p_importance_level  => MGMT_CONFIG_STD.G_IMPORTANCE_LOW,
      p_test              => 'Access_To_USER_Table',   
      p_test_type         => MGMT_CONFIG_STD.G_TEST_TYPE_POLICY,
      p_description       => 'SYSUser_DESC',
      p_rationale         => 'SYSUser_RATIONALE',
      p_fixtext           => 'SYSUser_FIX');
      
  -- COMMIT; 
  
  --  Restricted Access to SYS.SOURCE$
  l_rule_guid := MGMT_CONFIG_STD.ADD_RULE(
      p_cs_guid           => l_cs_guid,
      p_rule_iname        => 'SYSSource',    
      p_rule_dname        => 'SYSSource_NAME',
      p_parent_guid       => l_nested_folder_guid,
      p_child_position    => 4,
      p_importance_level  => MGMT_CONFIG_STD.G_IMPORTANCE_LOW,
      p_test              => 'Access_To_SOURCE_Table',   
      p_test_type         => MGMT_CONFIG_STD.G_TEST_TYPE_POLICY,
      p_description       => 'SYSSource_DESC',
      p_rationale         => 'SYSSource_RATIONALE',
      p_fixtext           => 'SYSSource_FIX');
      
  -- COMMIT;  
 
  --  Restricted Access to PERFSTAT.STATS$SQLTEXT
  l_rule_guid := MGMT_CONFIG_STD.ADD_RULE(
      p_cs_guid           => l_cs_guid,
      p_rule_iname        => 'PERFSTATStatsSqlText',    
      p_rule_dname        => 'PERFSTATStatsSqlText_NAME',
      p_parent_guid       => l_nested_folder_guid,
      p_child_position    => 5,
      p_importance_level  => MGMT_CONFIG_STD.G_IMPORTANCE_LOW,
      p_test              => 'Access_To_STATSSQLTEXT_Table',   
      p_test_type         => MGMT_CONFIG_STD.G_TEST_TYPE_POLICY,
      p_description       => 'PERFSTATStatsSqlText_DESC',
      p_rationale         => 'PERFSTATStatsSqlText_RATIONALE',
      p_fixtext           => 'PERFSTATStatsSqlText_FIX');
      
  -- COMMIT;  
  
  --  Restricted Access to PERFSTAT.STATS$SQL_SUMMARY
  l_rule_guid := MGMT_CONFIG_STD.ADD_RULE(
      p_cs_guid           => l_cs_guid,
      p_rule_iname        => 'PERFSTATStatsSqlSummary',    
      p_rule_dname        => 'PERFSTATStatsSqlSummary_NAME',
      p_parent_guid       => l_nested_folder_guid,
      p_child_position    => 6,
      p_importance_level  => MGMT_CONFIG_STD.G_IMPORTANCE_LOW,
      p_test              => 'Access_To_STATSSQL_SUMMARY_Table',   
      p_test_type         => MGMT_CONFIG_STD.G_TEST_TYPE_POLICY,
      p_description       => 'PERFSTATStatsSqlSummary_DESC',
      p_rationale         => 'PERFSTATStatsSqlSummary_RATIONALE',
      p_fixtext           => 'PERFSTATStatsSqlSummary_FIX');
      
  -- COMMIT; 
  
  -- *********************************************************************
  -- END Tables
  -- *********************************************************************

  -- *********************************************************************
  -- Packages
  -- *********************************************************************

  l_nested_folder_guid := MGMT_CONFIG_STD.ADD_RULEFOLDER(
      p_cs_guid           => l_cs_guid,
      p_rulefolder_iname  => 'Packages',
      p_rulefolder_dname  => 'Packages_NAME',
      p_parent_guid       => l_folder_guid,
      p_child_position    => 3,
      p_description       => 'Packages_DESC');
  
  -- COMMIT;
  
  --  Restricted Privilege to Execute UTL_FILE
  l_rule_guid := MGMT_CONFIG_STD.ADD_RULE(
      p_cs_guid           => l_cs_guid,
      p_rule_iname        => 'UtlFile',    
      p_rule_dname        => 'UtlFile_NAME',
      p_parent_guid       => l_nested_folder_guid,
      p_child_position    => 1,
      p_importance_level  => MGMT_CONFIG_STD.G_IMPORTANCE_HIGH,
      p_test              => 'EXECUTE_UTL_FILE_Privileges_To_PUBLIC',   
      p_test_type         => MGMT_CONFIG_STD.G_TEST_TYPE_POLICY,
      p_description       => 'UtlFile_DESC',
      p_rationale         => 'UtlFile_RATIONALE',
      p_fixtext           => 'UtlFile_FIX');
      
  -- COMMIT;
  
  --  Restricted Privilege to Execute UTL_TCP
  l_rule_guid := MGMT_CONFIG_STD.ADD_RULE(
      p_cs_guid           => l_cs_guid,
      p_rule_iname        => 'UtlTcp',    
      p_rule_dname        => 'UtlTcp_NAME',
      p_parent_guid       => l_nested_folder_guid,
      p_child_position    => 2,
      p_importance_level  => MGMT_CONFIG_STD.G_IMPORTANCE_HIGH,
      p_test              => 'Public_Exec_Priv_Utl_Tcp',   
      p_test_type         => MGMT_CONFIG_STD.G_TEST_TYPE_POLICY,
      p_description       => 'UtlTcp_DESC',
      p_rationale         => 'UtlTcp_RATIONALE',
      p_fixtext           => 'UtlTcp_FIX');
      
  -- COMMIT;
  
  --  Restricted Privilege to Execute UTL_HTTP
  l_rule_guid := MGMT_CONFIG_STD.ADD_RULE(
      p_cs_guid           => l_cs_guid,
      p_rule_iname        => 'UtlHttp',    
      p_rule_dname        => 'UtlHttp_NAME',
      p_parent_guid       => l_nested_folder_guid,
      p_child_position    => 3,
      p_importance_level  => MGMT_CONFIG_STD.G_IMPORTANCE_HIGH,
      p_test              => 'Public_Exec_Priv_Utl_Http',   
      p_test_type         => MGMT_CONFIG_STD.G_TEST_TYPE_POLICY,
      p_description       => 'UtlHttp_DESC',
      p_rationale         => 'UtlHttp_RATIONALE',
      p_fixtext           => 'UtlHttp_FIX');
      
  -- COMMIT;
  
  --  Restricted Privilege to Execute UTL_SMTP
  l_rule_guid := MGMT_CONFIG_STD.ADD_RULE(
      p_cs_guid           => l_cs_guid,
      p_rule_iname        => 'UtlSmtp',    
      p_rule_dname        => 'UtlSmtp_NAME',
      p_parent_guid       => l_nested_folder_guid,
      p_child_position    => 4,
      p_importance_level  => MGMT_CONFIG_STD.G_IMPORTANCE_HIGH,
      p_test              => 'Public_Exec_Priv_Utl_Smtp',   
      p_test_type         => MGMT_CONFIG_STD.G_TEST_TYPE_POLICY,
      p_description       => 'UtlSmtp_DESC',
      p_rationale         => 'UtlSmtp_RATIONALE',
      p_fixtext           => 'UtlSmtp_FIX');
      
  -- COMMIT;

  --  Restricted Privilege to Execute DBMS_JOB
  l_rule_guid := MGMT_CONFIG_STD.ADD_RULE(
      p_cs_guid           => l_cs_guid,
      p_rule_iname        => 'DbmsJob',    
      p_rule_dname        => 'DbmsJob_NAME',
      p_parent_guid       => l_nested_folder_guid,
      p_child_position    => 5,
      p_importance_level  => MGMT_CONFIG_STD.G_IMPORTANCE_HIGH,
      p_test              => 'PUBLIC_Privileges_To_DBMS_JOB',   
      p_test_type         => MGMT_CONFIG_STD.G_TEST_TYPE_POLICY,
      p_description       => 'DbmsJob_DESC',
      p_rationale         => 'DbmsJob_RATIONALE',
      p_fixtext           => 'DbmsJob_FIX');
      
  -- COMMIT;
  
  --  Restricted Privilege to Execute DBMS_SYS_SQL
  l_rule_guid := MGMT_CONFIG_STD.ADD_RULE(
      p_cs_guid           => l_cs_guid,
      p_rule_iname        => 'DbmsSysSql',    
      p_rule_dname        => 'DbmsSysSql_NAME',
      p_parent_guid       => l_nested_folder_guid,
      p_child_position    => 6,
      p_importance_level  => MGMT_CONFIG_STD.G_IMPORTANCE_HIGH,
      p_test              => 'PUBLIC_Privileges_To_DBMS_SYS_SQL',   
      p_test_type         => MGMT_CONFIG_STD.G_TEST_TYPE_POLICY,
      p_description       => 'DbmsSysSql_DESC',
      p_rationale         => 'DbmsSysSql_RATIONALE',
      p_fixtext           => 'DbmsSysSql_FIX');
      
  -- COMMIT;

  -- *********************************************************************
  -- END Packages
  -- *********************************************************************

  -- *********************************************************************
  -- END Database Access Settings
  -- *********************************************************************
 
  COMMIT;
  
END;
/

SET DEFINE ON
