Rem
Rem $Header: lsnrSecureConfigCS.sql 16-nov-2006.11:32:20 groyal Exp $
Rem
Rem lsnrSecureConfigCS.sql
Rem
Rem Copyright (c) 2006, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      lsnrSecureConfigCS.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    groyal      11/16/06 - XbranchMerge groyal_bug-5660652 from
Rem                           st_emdbgc_10.2.0.1.0
Rem    groyal      11/15/06 - Create in single transaction
Rem    groyal      10/16/06 - Created
Rem

-- SET ECHO ON
-- SET FEEDBACK 1
-- SET NUMWIDTH 10
-- SET LINESIZE 80
-- SET TRIMSPOOL ON
-- SET TAB OFF
-- SET PAGESIZE 100

SET DEFINE OFF

DECLARE

  l_cs_guid               mgmt_cs_config_standard.cs_guid%TYPE;
  l_folder_guid           mgmt_cs_rulefolder.rulefolder_guid%TYPE;
  l_nested_folder_guid    mgmt_cs_rulefolder.rulefolder_guid%TYPE;
  l_rule_guid             mgmt_cs_rule.rule_guid%TYPE;  
  l_keyword_list          MGMT_SHORT_STRING_TABLE;

BEGIN

  l_keyword_list := MGMT_SHORT_STRING_TABLE();
  l_keyword_list.extend();
  l_keyword_list(1) := 'lsnrSecure_SecurityKEYWORD';

  l_cs_guid := MGMT_CONFIG_STD.CREATE_CONFIG_STANDARD(
      p_cs_iname          => 'lsnrSecure',
      p_cs_dname          => 'lsnrSecure_NAME',
      p_version           => 1,
      p_target_type       => MGMT_GLOBAL.G_LISTENER_TARGET_TYPE,
      p_author            => 'ORACLE',
      p_lifecycle_status  => MGMT_CONFIG_STD.G_LIFECYCLE_PRODUCTION,
      p_description       => 'lsnrSecure_DESC',
      p_keyword_list      => l_keyword_list);
  
  -- COMMIT;
  

  -- ********************************************************************* 
  -- Oracle Directory and File Permissions
  -- *********************************************************************   
  
  l_folder_guid := MGMT_CONFIG_STD.ADD_RULEFOLDER(
      p_cs_guid           => l_cs_guid,
      p_rulefolder_iname  => 'OracleDirAndFilePerms',
      p_rulefolder_dname  => 'LsnrOracleDirAndFilePerms_NAME',
      p_parent_guid       => l_cs_guid,      
      p_child_position    => 1,
      p_description       => 'LsnrOracleDirAndFilePerms_DESC');
  
  -- COMMIT;
  
  -- ********************************************************************* 
  --  Unix Platform
  -- *********************************************************************   
  
  l_nested_folder_guid := MGMT_CONFIG_STD.ADD_RULEFOLDER(
      p_cs_guid           => l_cs_guid,
      p_rulefolder_iname  => 'OracleDirAndFilePermsU',
      p_rulefolder_dname  => 'LsnrOracleDirAndFilePermsU_NAME',
      p_parent_guid       => l_folder_guid,      
      p_child_position    => 1,
      p_description       => 'LsnrOracleDirAndFilePermsU_DESC');
  
  -- COMMIT;
  
  -- Oracle Net Client Log Directory (LOG_DIRECTORY_CLIENT)        
  l_rule_guid := MGMT_CONFIG_STD.ADD_RULE(
      p_cs_guid           => l_cs_guid,
      p_rule_iname        => 'OracleNetClientLogDirU',    
      p_rule_dname        => 'OracleNetClientLogDirU_NAME',
      p_parent_guid       => l_nested_folder_guid,
      p_child_position    => 1,
      p_importance_level  => MGMT_CONFIG_STD.G_IMPORTANCE_HIGH,
      p_test              => 'sqlnet_Client_Log_Dir',   
      p_test_type         => MGMT_CONFIG_STD.G_TEST_TYPE_POLICY,
      p_description       => 'OracleNetClientLogDirU_DESC',
      p_rationale         => 'OracleNetClientLogDirU_RATIONALE',
      p_fixtext           => 'OracleNetClientLogDirU_FIX');
      
  -- COMMIT;
  
  -- Oracle Net Client Trace Directory (TRACE_DIRECTORY_CLIENT)       
  l_rule_guid := MGMT_CONFIG_STD.ADD_RULE(
      p_cs_guid           => l_cs_guid,
      p_rule_iname        => 'OracleNetClientTraceDirU',    
      p_rule_dname        => 'OracleNetClientTraceDirU_NAME',
      p_parent_guid       => l_nested_folder_guid,
      p_child_position    => 2,
      p_importance_level  => MGMT_CONFIG_STD.G_IMPORTANCE_HIGH,
      p_test              => 'sqlnet_Client_Trace_Dir',   
      p_test_type         => MGMT_CONFIG_STD.G_TEST_TYPE_POLICY,
      p_description       => 'OracleNetClientTraceDirU_DESC',
      p_rationale         => 'OracleNetClientTraceDirU_RATIONALE',
      p_fixtext           => 'OracleNetClientTraceDirU_FIX');
      
  -- COMMIT;

  -- Oracle Net Server Log Directory (LOG_DIRECTORY_SERVER)     
  l_rule_guid := MGMT_CONFIG_STD.ADD_RULE(
      p_cs_guid           => l_cs_guid,
      p_rule_iname        => 'OracleNetServerLogDirU',    
      p_rule_dname        => 'OracleNetServerLogDirU_NAME',
      p_parent_guid       => l_nested_folder_guid,
      p_child_position    => 3,
      p_importance_level  => MGMT_CONFIG_STD.G_IMPORTANCE_HIGH,
      p_test              => 'sqlnet_Server_Log_Dir',   
      p_test_type         => MGMT_CONFIG_STD.G_TEST_TYPE_POLICY,
      p_description       => 'OracleNetServerLogDirU_DESC',
      p_rationale         => 'OracleNetServerLogDirU_RATIONALE',
      p_fixtext           => 'OracleNetServerLogDirU_FIX');
      
  -- COMMIT;
  
  -- Oracle Net Server Trace Directory (TRACE_DIRECTORY_SERVER)     
  l_rule_guid := MGMT_CONFIG_STD.ADD_RULE(
      p_cs_guid           => l_cs_guid,
      p_rule_iname        => 'OracleNetServerTraceDirU',    
      p_rule_dname        => 'OracleNetServerTraceDirU_NAME',
      p_parent_guid       => l_nested_folder_guid,
      p_child_position    => 4,
      p_importance_level  => MGMT_CONFIG_STD.G_IMPORTANCE_HIGH,
      p_test              => 'sqlnet_Server_Trace_Dir',   
      p_test_type         => MGMT_CONFIG_STD.G_TEST_TYPE_POLICY,
      p_description       => 'OracleNetServerTraceDirU_DESC',
      p_rationale         => 'OracleNetServerTraceDirU_RATIONALE',
      p_fixtext           => 'OracleNetServerTraceDirU_FIX');
      
  -- COMMIT;
  
  -- Listener Log File (LOG_FILE_listener_name)     
  l_rule_guid := MGMT_CONFIG_STD.ADD_RULE(
      p_cs_guid           => l_cs_guid,
      p_rule_iname        => 'LsnrLogFileU',    
      p_rule_dname        => 'LsnrLogFileU_NAME',
      p_parent_guid       => l_nested_folder_guid,
      p_child_position    => 5,
      p_importance_level  => MGMT_CONFIG_STD.G_IMPORTANCE_HIGH,
      p_test              => 'Lsnr_Logfile_Perm_Policy',   
      p_test_type         => MGMT_CONFIG_STD.G_TEST_TYPE_POLICY,
      p_description       => 'LsnrLogFileU_DESC',
      p_rationale         => 'LsnrLogFileU_RATIONALE',
      p_fixtext           => 'LsnrLogFileU_FIX');
      
  -- COMMIT;
  
  -- Listener Trace Directory (TRACE_DIRECTORY_listener_name)     
  l_rule_guid := MGMT_CONFIG_STD.ADD_RULE(
      p_cs_guid           => l_cs_guid,
      p_rule_iname        => 'LsnrTraceDirU',    
      p_rule_dname        => 'LsnrTraceDirU_NAME',
      p_parent_guid       => l_nested_folder_guid,
      p_child_position    => 6,
      p_importance_level  => MGMT_CONFIG_STD.G_IMPORTANCE_HIGH,
      p_test              => 'Lsnr_Tracedir_Perm_Policy',   
      p_test_type         => MGMT_CONFIG_STD.G_TEST_TYPE_POLICY,
      p_description       => 'LsnrTraceDirU_DESC',
      p_rationale         => 'LsnrTraceDirU_RATIONALE',
      p_fixtext           => 'LsnrTraceDirU_FIX');
      
  -- COMMIT;            
  
  -- Listener Trace File (TRACE_FILE_listener_name)     
  l_rule_guid := MGMT_CONFIG_STD.ADD_RULE(
      p_cs_guid           => l_cs_guid,
      p_rule_iname        => 'LsnrTraceFileU',    
      p_rule_dname        => 'LsnrTraceFileU_NAME',
      p_parent_guid       => l_nested_folder_guid,
      p_child_position    => 7,
      p_importance_level  => MGMT_CONFIG_STD.G_IMPORTANCE_HIGH,
      p_test              => 'Lsnr_Tracefile_Perm_Policy',   
      p_test_type         => MGMT_CONFIG_STD.G_TEST_TYPE_POLICY,
      p_description       => 'LsnrTraceFileU_DESC',
      p_rationale         => 'LsnrTraceFileU_RATIONALE',
      p_fixtext           => 'LsnrTraceFileU_FIX');
      
  -- COMMIT;     
  
  -- ********************************************************************* 
  --  END Unix Platform
  -- *********************************************************************   
  
  -- ********************************************************************* 
  --  Windows Platform
  -- *********************************************************************   
  
  l_nested_folder_guid := MGMT_CONFIG_STD.ADD_RULEFOLDER(
      p_cs_guid           => l_cs_guid,
      p_rulefolder_iname  => 'OracleDirAndFilePermsW',
      p_rulefolder_dname  => 'LsnrOracleDirAndFilePermsW_NAME',
      p_parent_guid       => l_folder_guid,      
      p_child_position    => 2,
      p_description       => 'LsnrOracleDirAndFilePermsW_DESC');
  
  -- COMMIT;
  
  -- Oracle Net Client Log Directory (LOG_DIRECTORY_CLIENT)    
  l_rule_guid := MGMT_CONFIG_STD.ADD_RULE(
      p_cs_guid           => l_cs_guid,
      p_rule_iname        => 'OracleNetClientLogDirW',    
      p_rule_dname        => 'OracleNetClientLogDirW_NAME',
      p_parent_guid       => l_nested_folder_guid,
      p_child_position    => 1,
      p_importance_level  => MGMT_CONFIG_STD.G_IMPORTANCE_HIGH,
      p_test              => 'sqlnet_Client_Log_DirNT',   
      p_test_type         => MGMT_CONFIG_STD.G_TEST_TYPE_POLICY,
      p_description       => 'OracleNetClientLogDirW_DESC',
      p_rationale         => 'OracleNetClientLogDirW_RATIONALE',
      p_fixtext           => 'OracleNetClientLogDirW_FIX');
      
  -- COMMIT;    
  
  -- Oracle Net Client Trace Directory (TRACE_DIRECTORY_CLIENT)   
  l_rule_guid := MGMT_CONFIG_STD.ADD_RULE(
      p_cs_guid           => l_cs_guid,
      p_rule_iname        => 'OracleNetClientTraceDirW',    
      p_rule_dname        => 'OracleNetClientTraceDirW_NAME',
      p_parent_guid       => l_nested_folder_guid,
      p_child_position    => 2,
      p_importance_level  => MGMT_CONFIG_STD.G_IMPORTANCE_HIGH,
      p_test              => 'sqlnet_Client_Trace_DirNT',   
      p_test_type         => MGMT_CONFIG_STD.G_TEST_TYPE_POLICY,
      p_description       => 'OracleNetClientTraceDirW_DESC',
      p_rationale         => 'OracleNetClientTraceDirW_RATIONALE',
      p_fixtext           => 'OracleNetClientTraceDirW_FIX');
      
  -- COMMIT;    
  
  -- Oracle Net Server Log Directory (LOG_DIRECTORY_SERVER)  
  l_rule_guid := MGMT_CONFIG_STD.ADD_RULE(
      p_cs_guid           => l_cs_guid,
      p_rule_iname        => 'OracleNetServerLogDirW',    
      p_rule_dname        => 'OracleNetServerLogDirW_NAME',
      p_parent_guid       => l_nested_folder_guid,
      p_child_position    => 3,
      p_importance_level  => MGMT_CONFIG_STD.G_IMPORTANCE_HIGH,
      p_test              => 'sqlnet_Server_Log_DirNT',   
      p_test_type         => MGMT_CONFIG_STD.G_TEST_TYPE_POLICY,
      p_description       => 'OracleNetServerLogDirW_DESC',
      p_rationale         => 'OracleNetServerLogDirW_RATIONALE',
      p_fixtext           => 'OracleNetServerLogDirW_FIX');
      
  -- COMMIT;    
  
  -- Oracle Net Server Trace Directory (TRACE_DIRECTORY_SERVER)  
  l_rule_guid := MGMT_CONFIG_STD.ADD_RULE(
      p_cs_guid           => l_cs_guid,
      p_rule_iname        => 'OracleNetServerTraceDirW',    
      p_rule_dname        => 'OracleNetServerTraceDirW_NAME',
      p_parent_guid       => l_nested_folder_guid,
      p_child_position    => 4,
      p_importance_level  => MGMT_CONFIG_STD.G_IMPORTANCE_HIGH,
      p_test              => 'sqlnet_Server_Trace_DirNT',   
      p_test_type         => MGMT_CONFIG_STD.G_TEST_TYPE_POLICY,
      p_description       => 'OracleNetServerTraceDirW_DESC',
      p_rationale         => 'OracleNetServerTraceDirW_RATIONALE',
      p_fixtext           => 'OracleNetServerTraceDirW_FIX');
      
  -- COMMIT;    

  -- Listener Log File (LOG_FILE_listener_name) 
  l_rule_guid := MGMT_CONFIG_STD.ADD_RULE(
      p_cs_guid           => l_cs_guid,
      p_rule_iname        => 'LsnrLogFileW',    
      p_rule_dname        => 'LsnrLogFileW_NAME',
      p_parent_guid       => l_nested_folder_guid,
      p_child_position    => 5,
      p_importance_level  => MGMT_CONFIG_STD.G_IMPORTANCE_HIGH,
      p_test              => 'Lsnr_Logfile_Perm_PolicyNT',   
      p_test_type         => MGMT_CONFIG_STD.G_TEST_TYPE_POLICY,
      p_description       => 'LsnrLogFileW_DESC',
      p_rationale         => 'LsnrLogFileW_RATIONALE',
      p_fixtext           => 'LsnrLogFileW_FIX');
      
  -- COMMIT;    

   -- Listener Trace Directory (TRACE_DIRECTORY_listener_name)
  l_rule_guid := MGMT_CONFIG_STD.ADD_RULE(
      p_cs_guid           => l_cs_guid,
      p_rule_iname        => 'LsnrTraceDirW',    
      p_rule_dname        => 'LsnrTraceDirW_NAME',
      p_parent_guid       => l_nested_folder_guid,
      p_child_position    => 6,
      p_importance_level  => MGMT_CONFIG_STD.G_IMPORTANCE_HIGH,
      p_test              => 'Lsnr_Tracedir_Perm_PolicyNT',   
      p_test_type         => MGMT_CONFIG_STD.G_TEST_TYPE_POLICY,
      p_description       => 'LsnrTraceDirW_DESC',
      p_rationale         => 'LsnrTraceDirW_RATIONALE',
      p_fixtext           => 'LsnrTraceDirW_FIX');
      
  -- COMMIT;    

   -- Listener Trace File (TRACE_FILE_listener_name)
  l_rule_guid := MGMT_CONFIG_STD.ADD_RULE(
      p_cs_guid           => l_cs_guid,
      p_rule_iname        => 'LsnrTraceFileW',    
      p_rule_dname        => 'LsnrTraceFileW_NAME',
      p_parent_guid       => l_nested_folder_guid,
      p_child_position    => 7,
      p_importance_level  => MGMT_CONFIG_STD.G_IMPORTANCE_HIGH,
      p_test              => 'Lsnr_Tracefile_Perm_PolicyNT',   
      p_test_type         => MGMT_CONFIG_STD.G_TEST_TYPE_POLICY,
      p_description       => 'LsnrTraceFileW_DESC',
      p_rationale         => 'LsnrTraceFileW_RATIONALE',
      p_fixtext           => 'LsnrTraceFileW_FIX');
      
  -- COMMIT;    
  
  -- ********************************************************************* 
  --  END Windows Platform
  -- *********************************************************************   

  -- ********************************************************************* 
  -- END Oracle Directory and File Permissions
  -- *********************************************************************   

  -- ********************************************************************* 
  -- Network Configuration Settings
  -- *********************************************************************   
  
  l_folder_guid := MGMT_CONFIG_STD.ADD_RULEFOLDER(
      p_cs_guid           => l_cs_guid,
      p_rulefolder_iname  => 'NetworkConfigSettings',
      p_rulefolder_dname  => 'NetworkConfigSettings_NAME',
      p_parent_guid       => l_cs_guid,      
      p_child_position    => 2,
      p_description       => 'NetworkConfigSettings_DESC');
  
  -- COMMIT;
  
  -- Secure Logon Authentication Protocol Version (SQLNET.ALLOWED_LOGON_VERSION)
  l_rule_guid := MGMT_CONFIG_STD.ADD_RULE(
      p_cs_guid           => l_cs_guid,
      p_rule_iname        => 'SecureLogonAuthenProtocolVersion',    
      p_rule_dname        => 'SecureLogonAuthenProtocolVersion_NAME',
      p_parent_guid       => l_folder_guid,
      p_child_position    => 1,
      p_importance_level  => MGMT_CONFIG_STD.G_IMPORTANCE_NORMAL,
      p_test              => 'Sqlnet_Allowed_Logon_Version',   
      p_test_type         => MGMT_CONFIG_STD.G_TEST_TYPE_POLICY,
      p_description       => 'SecureLogonAuthenProtocolVersion_DESC',
      p_rationale         => 'SecureLogonAuthenProtocolVersion_RATIONALE',
      p_fixtext           => 'SecureLogonAuthenProtocolVersion_FIX');
      
  -- COMMIT;     

  -- ********************************************************************* 
  -- END Network Configuration Settings
  -- *********************************************************************  
  
  COMMIT;

END;
/

SET DEFINE ON
