Rem
Rem $Header: db_policies.sql 06-nov-2006.02:18:37 dsukhwal Exp $
Rem
Rem db_policies.sql
Rem
Rem Copyright (c) 2006, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      db_policies.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    dsukhwal    10/17/06 - OS_AUTHENT_PREFIX impact
Rem    dsukhwal    10/20/06 - OS_AUTHENT_PREFIX case insensitive
Rem    rmadampa    08/03/06 - remove the header used by repmgr, shifted to
Rem                           esm_data_upgrade which invokes this file
Rem    rmadampa    08/20/06 - fix policy delete error
Rem    bmallipe    08/13/06 - adding the condition for CENTRAL mode only
Rem    rmadampa    08/01/06 - bug 5435113: fix policies to internal sec team
Rem                           recomm
Rem    dsukhwal    07/19/06 - bug 5234593 : change threshold type
Rem    rmadampa    07/28/06 - Bug 5259286: New policy for password complexity verification usage
Rem    rmadampa    07/24/06 - Bug 5242230: Modify policy 'Excessive_PUBLIC_EXECUTE_privileges'
Rem    rmadampa    07/24/06 - Bug 5242230: Modify policy 'Excessive_PUBLIC_EXECUTE_privileges'
Rem    dsukhwal    07/12/06 - Created
Rem

SET ECHO ON
SET FEEDBACK 1
SET NUMWIDTH 10
SET LINESIZE 80
SET TRIMSPOOL ON
SET TAB OFF
SET PAGESIZE 100

SET ESCAPE '\' ;
SET ESCAPE ON ;
DECLARE
 -- Metric Variable
 l_metric_column_list                              MGMT_METRIC_COLUMN_ARRAY;
 l_metric_type                         NUMBER ;
 l_snapshot_list                       MGMT_SNAPSHOT_ARRAY;
 l_snapshot_list_rac                   MGMT_SNAPSHOT_ARRAY;
 l_snapshot_list_inst_10gR1               MGMT_SNAPSHOT_ARRAY;
 l_snapshot_list_inst_10gR2               MGMT_SNAPSHOT_ARRAY;
 -- Policy Variable
 l_ctxList                             MGMT_VIOL_CTXT_DEF_ARRAY;
 l_paramDefList                           MGMT_POLICY_PARAM_DEF_ARRAY;
 l_defaultParamValList                     MGMT_POLICY_PARAM_VAL_ARRAY;
 l_defaultSettingsList                     MGMT_POLICY_KEY_VAL_ARRAY;
 l_auto_enable                           NUMBER ;    
 l_10gR1_db_meta_ver                   VARCHAR2(3) ; 
 l_10gR1_db_end_meta_ver                   VARCHAR2(4) ;
 l_valid_if_list                       MGMT_VALIDIF_ARRAY ;
 l_rac_database                          CONSTANT VARCHAR2(12) := 'rac_database';
 -- New snapshot name for the instance specific oracle_security metrics is oracle_security_inst
 l_oracle_security_inst                CONSTANT VARCHAR2(20) := 'oracle_security_inst';

 pol_eval_func_10gR2  CONSTANT VARCHAR2(50) := 'ESM.EVAL_POLICY10GR2'  ;
 pol_eval_func_10gR1  CONSTANT VARCHAR2(50) := 'ESM.EVAL_POLICY10GR1'  ;

 -- Variables used by the code which does delete the sqlnet policies and metrics
 TYPE POLICY_LIST is table of VARCHAR2(50);
 l_policyName  VARCHAR2(50);
 l_policyNameList POLICY_LIST;

 TYPE METRIC_LIST is table of VARCHAR2(50);
 l_metricName  VARCHAR2(50);
 l_metricNameList METRIC_LIST;
 l_target_type  VARCHAR2(20) := ESM.DB_TARGET_TYPE;

BEGIN

  l_policyNameList := 
    POLICY_LIST('Password_Life_Time','Password_Reuse_Max','Password_Grace_Time', 
                'Password_Life_Time','Password_Reuse_Max','Password_Grace_Time') ;

  l_metricNameList := METRIC_LIST('pwdLifeRep', 'reuseMaxRep', 'pwdGraceRep',
                                  'pwdLifeRep', 'reuseMaxRep', 'pwdGraceRep') ;
FOR i IN 1..6 LOOP
 l_policyName := l_policyNameList(i);
 if i > 3 then
  l_target_type := l_rac_database ;
 end if ;
 ESM.DELETE_POLICY(
   P_TARGET_TYPE => l_target_type,
   P_POLICY_NAME => l_policyName
 );
 COMMIT ;
 
 l_metricName := l_metricNameList(i);
 MGMT_METRIC.DELETE_METRIC(
    P_TARGET_TYPE => l_target_type,
    P_METRIC_NAME => l_metricName,
    P_TYPE_META_VER => NULL 
 );
 COMMIT ;
END LOOP;
  l_10gR1_db_meta_ver := '3.0' ;
  l_10gR1_db_end_meta_ver := '3.99' ;
  l_metric_type := MGMT_GLOBAL.G_METRIC_TYPE_TABLE ;
  l_snapshot_list := MGMT_SNAPSHOT_ARRAY(
        MGMT_SNAPSHOT_OBJ.NEW(
                p_target_type => ESM.DB_TARGET_TYPE,
                p_snapshot_name => ESM.SECURITY_SNAPSHOT_TYPE));

  l_snapshot_list_rac := MGMT_SNAPSHOT_ARRAY(
        MGMT_SNAPSHOT_OBJ.NEW(
                p_target_type   => l_rac_database,
                p_snapshot_name => ESM.SECURITY_SNAPSHOT_TYPE));


  -- This snapshot list is prepared for all the db instance 
  -- security metrics which are applicable For both 10gR1 + 10gR2.
  -- In 10gR2 release oracle_security snapshot name has split up into two
  -- oracle_security + oracle_security_int(all db instance security metric used this)
  -- oracle_security_inst snapshot name is included in the snapshot list
  -- bcoz 10gR2 agent will upload the instance data with this snapshot name 
  -- Snapshot name used by 10gR1 agent remains same so included to support the 
  -- backward compatibility as 10gR1 agent uploads the data for 
  -- those metric with oracle_security snapshot name.
  l_snapshot_list_inst_10gR1 := MGMT_SNAPSHOT_ARRAY(
        MGMT_SNAPSHOT_OBJ.NEW(
                p_target_type   => ESM.DB_TARGET_TYPE,
                p_snapshot_name => l_oracle_security_inst),
        MGMT_SNAPSHOT_OBJ.NEW(
                p_target_type   => ESM.DB_TARGET_TYPE,
                p_snapshot_name => ESM.SECURITY_SNAPSHOT_TYPE));
 
  -- for 10gR2 db instance specific metrics => this is oracle_security_inst
  l_snapshot_list_inst_10gR2 := MGMT_SNAPSHOT_ARRAY(
        MGMT_SNAPSHOT_OBJ.NEW(
                p_target_type   => ESM.DB_TARGET_TYPE,
                p_snapshot_name => l_oracle_security_inst));


  l_valid_if_list := MGMT_VALIDIF_ARRAY(
       MGMT_VALIDIF_OBJ.NEW(
            p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY('DB'))
 );
 l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'profile',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Profile',
                p_column_label_nlsid =>'PROFILE_COL'),
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'limit',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'Password Grace Time',
                p_column_label_nlsid =>'PWD_GRACE_TIME_COL'));
  MGMT_METRIC.CREATE_METRIC(
      p_target_type => ESM.DB_TARGET_TYPE,
      p_metric_name => 'pwdGraceRep',
      p_type_meta_ver => ESM.DB_TYPE_META_VERSION,
      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type, 
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,                
      p_metric_label => 'Password Grace Time',
      p_metric_label_nlsid => 'PWD_GRACE_TIME_METRIC_LABEL',
      p_description  => 'Collect setting of PASSWORD_GRACE_TIME',
      p_description_nlsid => 'PWD_GRACE_TIME_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE ,     
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source =>'SELECT target_guid, value as limit, value2 as profile '
                 ||'FROM esm_collection_latest '
                 ||'WHERE  property = ''password_grace_time''',
      p_snapshot_name_list => l_snapshot_list,
      p_metric_column_list => l_metric_column_list  
 ) ;
COMMIT ;
MGMT_METRIC.CREATE_METRIC(
      p_target_type => 'rac_database',
      p_metric_name => 'pwdGraceRep',
      p_type_meta_ver => ESM.DB_TYPE_META_VERSION,
  --    p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type, 
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,                
      p_metric_label => 'Password Grace Time',
      p_metric_label_nlsid => 'PWD_GRACE_TIME_METRIC_LABEL',
      p_description  => 'Collect setting of PASSWORD_GRACE_TIME',
      p_description_nlsid => 'PWD_GRACE_TIME_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE ,     
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source =>'SELECT target_guid, value as limit, value2 as profile '
                 ||'FROM esm_collection_latest '
                 ||'WHERE  property = ''password_grace_time''',
      p_snapshot_name_list => l_snapshot_list_rac,
      p_metric_column_list => l_metric_column_list  
 ) ;
COMMIT ;


  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(
             p_metric_column => 'profile', 
             p_url_link_template =>'database/security/profile?oname=^profile^\&event=edit\&otype=PROFILE\&target=^TARGET_NAME^\&type=^TARGET_TYPE^\&cancelURL=^CANCEL_URL^', 
                p_url_link_type => MGMT_POLICY.G_URL_TYPE_JSP),
          MGMT_VIOL_CTXT_DEF.NEW(
             p_metric_column => 'limit'));
  l_paramDefList := MGMT_POLICY_PARAM_DEF_ARRAY(
        MGMT_POLICY_PARAM_DEF(
                param_name => 'MAX_PASSWORD_GRACE_TIME',
                param_name_nlsid => 'MAX_PWD_GRACE_TIME_PNAME',
                param_type => MGMT_POLICY.G_PARAM_TYPE_NUMBER));

  l_defaultParamValList := MGMT_POLICY_PARAM_VAL_ARRAY(
        MGMT_POLICY_PARAM_VAL.NEW(
                p_param_name => 'MAX_PASSWORD_GRACE_TIME',
                p_crit_threshold => '7'));

  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL,
                p_param_values => l_defaultParamValList));

  ESM.CREATE_POLICY(
  p_target_type => ESM.DB_TARGET_TYPE,
  p_policy_name =>'Password_Grace_Time',   --Policy name
  p_metric_name =>'pwdGraceRep',      --Metric name
  p_policy_label_nlsid =>'PWD_GRACE_TIME_NAME',    
  p_description =>'Ensures that all profiles have PASSWORD_GRACE_TIME set to a reasonable number of days',
  p_description_nlsid =>'PWD_GRACE_TIME_DESC',
  p_impact =>'A high value for the PASSWORD_GRACE_TIME parameter may cause serious '||
             'database security issues by allowing the user to keep the same password for a long time.',
  p_impact_nlsid =>'PWD_GRACE_TIME_IMPACT',
  p_recommendation =>'Set the PASSWORD_GRACE_TIME parameter to no more than 7 days for all profiles.',
  p_recommendation_nlsid =>'PWD_GRACE_TIME_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_CRITICAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition => ':MAX_PASSWORD_GRACE_TIME < decode(:limit,''UNLIMITED'', 2147483647,to_number(:limit))',
  p_message =>'Database is in an insecure state. PASSWORD_GRACE_TIME is set to %limit% days for the profile %profile%.',
  p_message_nlsid =>'PWD_GRACE_TIME_MESG',
  p_cs_consider_percentage =>MGMT_GLOBAL.G_TRUE,
  p_start_type_meta_ver => ESM.DB_TYPE_META_VERSION,
  p_policy_param_list =>l_paramDefList,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList    
);
COMMIT ;
  ESM.CREATE_POLICY(
  p_target_type => 'rac_database',
  p_policy_name =>'Password_Grace_Time',   --Policy name
  p_metric_name =>'pwdGraceRep',      --Metric name
  p_policy_label_nlsid =>'PWD_GRACE_TIME_NAME',    
  p_description =>'Ensures that all profiles have PASSWORD_GRACE_TIME set to a reasonable number of days',
  p_description_nlsid =>'PWD_GRACE_TIME_DESC',
  p_impact =>'A high value for the PASSWORD_GRACE_TIME parameter may cause serious '||
             'database security issues by allowing the user to keep the same password for a long time.',
  p_impact_nlsid =>'PWD_GRACE_TIME_IMPACT',
  p_recommendation =>'Set the PASSWORD_GRACE_TIME parameter to no more  than 7 days for all profiles.',
  p_recommendation_nlsid =>'PWD_GRACE_TIME_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_CRITICAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition => ':MAX_PASSWORD_GRACE_TIME < decode(:limit,''UNLIMITED'', 2147483647,to_number(:limit))',
  p_message =>'Database is in an insecure state. PASSWORD_GRACE_TIME is set to %limit% days for the profile %profile%.',
  p_message_nlsid =>'PWD_GRACE_TIME_MESG',
  p_cs_consider_percentage =>MGMT_GLOBAL.G_TRUE,
  p_start_type_meta_ver => ESM.DB_TYPE_META_VERSION,
  p_policy_param_list =>l_paramDefList,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList    
);
COMMIT ;

  l_valid_if_list := MGMT_VALIDIF_ARRAY(
       MGMT_VALIDIF_OBJ.NEW(
            p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY('DB'))
 );
 l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'profile',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Profile',
                p_column_label_nlsid =>'PROFILE_COL'),
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'limit',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'Password Reuse Max',
                p_column_label_nlsid =>'PWD_REUSE_MAX_COL'));
  MGMT_METRIC.CREATE_METRIC(
      p_target_type => ESM.DB_TARGET_TYPE,
      p_metric_name => 'reuseMaxRep',
      p_type_meta_ver => ESM.DB_TYPE_META_VERSION,
      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type, 
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,                
      p_metric_label => 'Password Reuse Max',
      p_metric_label_nlsid => 'PWD_REUSE_MAX_METRIC_LABEL',
      p_description  => 'Collect setting of PASSWORD_REUSE_MAX',
      p_description_nlsid => 'PWD_REUSE_MAX_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE ,     
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source =>'SELECT target_guid, value as limit, value2 as profile '
                 ||'FROM esm_collection_latest '
                 ||'WHERE  property =''password_reuse_max''',
      p_snapshot_name_list => l_snapshot_list,
      p_metric_column_list => l_metric_column_list  
 ) ;
COMMIT ;
  MGMT_METRIC.CREATE_METRIC(
      p_target_type => 'rac_database',
      p_metric_name => 'reuseMaxRep',
      p_type_meta_ver => ESM.DB_TYPE_META_VERSION,
 --     p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type, 
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,                
      p_metric_label => 'Password Reuse Max',
      p_metric_label_nlsid => 'PWD_REUSE_MAX_METRIC_LABEL',
      p_description  => 'Collect setting of PASSWORD_REUSE_MAX',
      p_description_nlsid => 'PWD_REUSE_MAX_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE ,     
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source =>'SELECT target_guid, value as limit, value2 as profile '
                 ||'FROM esm_collection_latest '
                 ||'WHERE  property =''password_reuse_max''',
      p_snapshot_name_list => l_snapshot_list_rac,
      p_metric_column_list => l_metric_column_list  
 ) ;
COMMIT ;
  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(
             p_metric_column => 'profile', 
             p_url_link_template =>'database/security/profile?oname=^profile^\&event=edit\&otype=PROFILE\&target=^TARGET_NAME^\&type=^TARGET_TYPE^\&cancelURL=^CANCEL_URL^', 
                p_url_link_type => MGMT_POLICY.G_URL_TYPE_JSP),
          MGMT_VIOL_CTXT_DEF.NEW(
             p_metric_column => 'limit'));
  l_paramDefList := MGMT_POLICY_PARAM_DEF_ARRAY(
        MGMT_POLICY_PARAM_DEF(
                param_name => 'MIN_PASSWORD_REUSE_MAX',
                param_name_nlsid => 'MIN_PWD_REUSE_MAX_PNAME',
                param_type => MGMT_POLICY.G_PARAM_TYPE_NUMBER));
  l_defaultParamValList := MGMT_POLICY_PARAM_VAL_ARRAY(
        MGMT_POLICY_PARAM_VAL.NEW(
                p_param_name => 'MIN_PASSWORD_REUSE_MAX',
                p_warn_threshold => '2147483647'));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL,
                p_param_values => l_defaultParamValList));
 ESM.CREATE_POLICY(
  p_target_type => ESM.DB_TARGET_TYPE,
  p_policy_name =>'Password_Reuse_Max',   --Policy name
  p_metric_name =>'reuseMaxRep',      --Metric name
  p_policy_label_nlsid =>'PWD_REUSE_MAX_NAME',    
  p_description =>'Ensures that all profiles have PASSWORD_REUSE_MAX set to a reasonable number of times',
  p_description_nlsid =>'PWD_REUSE_MAX_DESC', 
  p_impact => 'Old passwords are usually the best guesses for the current password. '||
              'A low value for the PASSWORD_REUSE_MAX parameter may cause serious '||
              'database security issues by allowing users to reuse their old passwords more often.',
  p_impact_nlsid =>'PWD_REUSE_MAX_IMPACT',
  p_recommendation =>'Set the PASSWORD_REUSE_MAX parameter to UNLIMITED for all profiles.',
  p_recommendation_nlsid =>'PWD_REUSE_MAX_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_WARNING,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'decode(:limit,''UNLIMITED'', 2147483647,to_number(:limit)) < :MIN_PASSWORD_REUSE_MAX',
  p_message =>'Database is in an insecure state. PASSWORD_REUSE_MAX  is set to %limit% times for the profile %profile%.',
  p_message_nlsid =>'PWD_REUSE_MAX_MESG',
  p_cs_consider_percentage =>MGMT_GLOBAL.G_TRUE,
  p_start_type_meta_ver => ESM.DB_TYPE_META_VERSION,
  p_policy_param_list =>l_paramDefList,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList    
);
COMMIT ;
 ESM.CREATE_POLICY(
  p_target_type => 'rac_database',
  p_policy_name =>'Password_Reuse_Max',   --Policy name
  p_metric_name =>'reuseMaxRep',      --Metric name
  p_policy_label_nlsid =>'PWD_REUSE_MAX_NAME',    
  p_description =>'Ensures that all profiles have PASSWORD_REUSE_MAX set to a reasonable number of times',
  p_description_nlsid =>'PWD_REUSE_MAX_DESC', 
  p_impact => 'Old passwords are usually the best guesses for the current password. '||
              'A low value for the PASSWORD_REUSE_MAX parameter may cause serious '||
              'database security issues by allowing users to reuse their old passwords more often.',
  p_impact_nlsid =>'PWD_REUSE_MAX_IMPACT',
  p_recommendation =>'Set the PASSWORD_REUSE_MAX parameter to UNLIMITED for all profiles.',
  p_recommendation_nlsid =>'PWD_REUSE_MAX_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_WARNING,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'decode(:limit,''UNLIMITED'', 2147483647,to_number(:limit)) < :MIN_PASSWORD_REUSE_MAX',
  p_message =>'Database is in an insecure state. PASSWORD_REUSE_MAX  is set to %limit% times for the profile %profile%.',
  p_message_nlsid =>'PWD_REUSE_MAX_MESG',
  p_cs_consider_percentage =>MGMT_GLOBAL.G_TRUE,
  p_start_type_meta_ver => ESM.DB_TYPE_META_VERSION,
  p_policy_param_list =>l_paramDefList,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList    
);
COMMIT ;


 l_valid_if_list := MGMT_VALIDIF_ARRAY(
       MGMT_VALIDIF_OBJ.NEW(
            p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY('DB'))
 );
l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'profile',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Profile',
                p_column_label_nlsid =>'PROFILE_COL'),
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'limit',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'Password Life Time',
                p_column_label_nlsid =>'PWD_LIFE_TIME_COL'));
  MGMT_METRIC.CREATE_METRIC(
      p_target_type => ESM.DB_TARGET_TYPE,
      p_metric_name => 'pwdLifeRep',
      p_type_meta_ver => ESM.DB_TYPE_META_VERSION,
      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type, 
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,                
      p_metric_label => 'Password Life Time',
      p_metric_label_nlsid => 'PWD_LIFE_TIME_COL',
      p_description  => 'Collect setting of PASSWORD_LIFE_TIME',
      p_description_nlsid => 'PWD_LIFE_TIME_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE ,     
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source =>'SELECT target_guid, value as limit, value2 as profile '
                 ||'FROM esm_collection_latest '
                 ||'WHERE  property =''password_life_time''',
      p_snapshot_name_list => l_snapshot_list,
      p_metric_column_list => l_metric_column_list  
 ) ;
COMMIT ;
  MGMT_METRIC.CREATE_METRIC(
      p_target_type => 'rac_database',
      p_metric_name => 'pwdLifeRep',
      p_type_meta_ver => ESM.DB_TYPE_META_VERSION,
  --    p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type, 
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,                
      p_metric_label => 'Password Life Time',
      p_metric_label_nlsid => 'PWD_LIFE_TIME_COL',
      p_description  => 'Collect setting of PASSWORD_LIFE_TIME',
      p_description_nlsid => 'PWD_LIFE_TIME_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE ,     
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source =>'SELECT target_guid, value as limit, value2 as profile '
                 ||'FROM esm_collection_latest '
                 ||'WHERE  property =''password_life_time''',
      p_snapshot_name_list => l_snapshot_list_rac,
      p_metric_column_list => l_metric_column_list  
 ) ;
COMMIT ;
  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(
             p_metric_column => 'profile', 
             p_url_link_template =>'database/security/profile?oname=^profile^\&event=edit\&otype=PROFILE\&target=^TARGET_NAME^\&type=^TARGET_TYPE^\&cancelURL=^CANCEL_URL^', 
                p_url_link_type => MGMT_POLICY.G_URL_TYPE_JSP),
          MGMT_VIOL_CTXT_DEF.NEW(
             p_metric_column => 'limit'));
  l_paramDefList := MGMT_POLICY_PARAM_DEF_ARRAY(
        MGMT_POLICY_PARAM_DEF(
                param_name => 'MAX_PASSWORD_LIFE_TIME',
                param_name_nlsid => 'MAX_PWD_LIFE_TIME_PNAME',
                param_type => MGMT_POLICY.G_PARAM_TYPE_NUMBER));
  l_defaultParamValList := MGMT_POLICY_PARAM_VAL_ARRAY(
        MGMT_POLICY_PARAM_VAL.NEW(
                p_param_name => 'MAX_PASSWORD_LIFE_TIME',
                p_warn_threshold => '180'));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL,
                p_param_values => l_defaultParamValList));
 ESM.CREATE_POLICY(
  p_target_type => ESM.DB_TARGET_TYPE,
  p_policy_name =>'Password_Life_Time',   --Policy name
  p_metric_name =>'pwdLifeRep',      --Metric name
  p_policy_label_nlsid =>'PWD_LIFE_TIME_NAME',    
  p_description =>'Ensures that all profiles have PASSWORD_LIFE_TIME set to a reasonable number of days',
  p_description_nlsid =>'PWD_LIFE_TIME_DESC',
  p_impact => 'A long password life time gives hackers a long time to try and cook '||
              'the password. May cause serious database security issues.',
  p_impact_nlsid =>'PWD_LIFE_TIME_IMPACT',
  p_recommendation =>'Set the PASSWORD_LIFE_TIME parameter to no more than 180 days for all profiles.',
  p_recommendation_nlsid =>'PWD_LIFE_TIME_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_WARNING,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition => 'decode(:limit,''UNLIMITED'',2147483647,to_number(:limit)) > :MAX_PASSWORD_LIFE_TIME',
  p_message =>'Database is in an insecure state. PASSWORD_LIFE_TIME is set to  %limit% days for the profile %profile%.',
  p_message_nlsid =>'PWD_LIFE_TIME_MESG',
  p_cs_consider_percentage =>MGMT_GLOBAL.G_TRUE,
  p_start_type_meta_ver => ESM.DB_TYPE_META_VERSION,
  p_policy_param_list =>l_paramDefList,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList    
);
COMMIT ;
 ESM.CREATE_POLICY(
  p_target_type => 'rac_database',
  p_policy_name =>'Password_Life_Time',   --Policy name
  p_metric_name =>'pwdLifeRep',      --Metric name
  p_policy_label_nlsid =>'PWD_LIFE_TIME_NAME',    
  p_description =>'Ensures that all profiles have PASSWORD_LIFE_TIME set to a reasonable number of days',
  p_description_nlsid =>'PWD_LIFE_TIME_DESC',
  p_impact => 'A long password life time gives hackers a long time to try and cook '||
              'the password. May cause serious database security issues.',
  p_impact_nlsid =>'PWD_LIFE_TIME_IMPACT',
  p_recommendation =>'Set the PASSWORD_LIFE_TIME parameter to no more than 180 days for all profiles.',
  p_recommendation_nlsid =>'PWD_LIFE_TIME_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_WARNING,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition => 'decode(:limit,''UNLIMITED'',2147483647,to_number(:limit)) > :MAX_PASSWORD_LIFE_TIME',
  p_message =>'Database is in an insecure state. PASSWORD_LIFE_TIME is set to  %limit% days for the profile %profile%.',
  p_message_nlsid =>'PWD_LIFE_TIME_MESG',
  p_cs_consider_percentage =>MGMT_GLOBAL.G_TRUE,
  p_start_type_meta_ver => ESM.DB_TYPE_META_VERSION,
  p_policy_param_list =>l_paramDefList,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList    
);
COMMIT ;

------------------------------------------------------------------------
--Bug 5242230 : Fix description to have UTL_TCP as a powerful pkg
------------------------------------------------------------------------
--Bug 5435113 has split this policy into 3 and hence overrides this fix

/*
l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'package',
                p_url_link_template =>'database/security/user?oname=PUBLIC\&event=edit\&otype=USER\&target=^TARGET_NAME^\&type=^TARGET_TYPE^\&cancelURL=^CANCEL_URL^',
                        p_url_link_type => MGMT_POLICY.G_URL_TYPE_JSP));
l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));

ESM.MODIFY_POLICY(
  p_target_type => ESM.DB_TARGET_TYPE,
  p_policy_name =>'Excessive_PUBLIC_EXECUTE_privileges',   --Policy name
  p_metric_name =>'executePrivilegesRep',      --Metric name
  p_policy_label_nlsid =>'PUB_EXE_PRIV_NAME',
  p_description =>'Ensure PUBLIC does not have execute privileges on powerful packages (UTL_TCP, UTL_HTTP and UTL_SMTP)',
  p_description_nlsid =>'PUB_EXE_PRIV_DESC',
  p_impact =>'Privileges granted to the PUBLIC role automatically apply to all users. A  malicious user can gain access to email, network and http modules using the EXECUTE privilege.',
  p_impact_nlsid =>'PUB_EXE_PRIV_IMPACT',
  p_recommendation =>'Revoke EXECUTE privileges on powerful packages.',
  p_recommendation_nlsid =>'PUB_EXE_PRIV_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_CRITICAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'rownum > 0',
  p_message =>'Database is in insecure state. EXECUTE privilege on the package %package% is granted to PUBLIC.',
  p_message_nlsid =>'PUB_EXE_PRIV_MESG',
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver => l_10gR1_db_meta_ver,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList
);
COMMIT;
  
ESM.MODIFY_POLICY(
  p_target_type => 'rac_database',
  p_policy_name =>'Excessive_PUBLIC_EXECUTE_privileges',   --Policy name
  p_metric_name =>'executePrivilegesRep',      --Metric name
  p_policy_label_nlsid =>'PUB_EXE_PRIV_NAME',
  p_description =>'Ensure PUBLIC does not have execute privileges on powerful packages (UTL_TCP, UTL_HTTP and UTL_SMTP)',
  p_description_nlsid =>'PUB_EXE_PRIV_DESC',
  p_impact =>'Privileges granted to the PUBLIC role automatically apply to all users. A  malicious user can gain access to email, network and http modules using the EXECUTE privilege.',
  p_impact_nlsid =>'PUB_EXE_PRIV_IMPACT',
  p_recommendation =>'Revoke EXECUTE privileges on powerful packages.',
  p_recommendation_nlsid =>'PUB_EXE_PRIV_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_CRITICAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'rownum > 0',
  p_message =>'Database is in insecure state. EXECUTE privilege on the package %package% is granted to PUBLIC.',
  p_message_nlsid =>'PUB_EXE_PRIV_MESG',
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver => l_10gR1_db_meta_ver,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList
);
COMMIT;
*/
-----------------------------------------------------------
--End of bug 5242230
-----------------------------------------------------------

---------------------------------------------------------------------------------
--Bug 5259286 New policy to check password complexity verification function usage
----------------------------------------------------------------------------------
BEGIN
   ESM.DELETE_POLICY(
     P_TARGET_TYPE => 'oracle_database',
     P_POLICY_NAME => 'Password_Complexity_Fn_Usage'
   );
   COMMIT ;
 
   ESM.DELETE_POLICY(
     P_TARGET_TYPE => 'rac_database',
     P_POLICY_NAME => 'Password_Complexity_Fn_Usage'
   );
   COMMIT ;
   MGMT_METRIC.DELETE_METRIC(
    P_TARGET_TYPE => 'oracle_database',
    P_METRIC_NAME => 'pwdComplexityFnRep',
    P_TYPE_META_VER => NULL 
   );
   COMMIT ;
   MGMT_METRIC.DELETE_METRIC(
    P_TARGET_TYPE => 'rac_database',
    P_METRIC_NAME => 'pwdComplexityFnRep',
    P_TYPE_META_VER => NULL 
   );
   COMMIT ;
EXCEPTION
   WHEN  OTHERS THEN NULL;
END;

l_valid_if_list := MGMT_VALIDIF_ARRAY(
       MGMT_VALIDIF_OBJ.NEW(
            p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY('DB'))
 );
 l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
    MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'profile',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Profile',
                p_column_label_nlsid =>'PROFILE_COL'),    
   MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'limit',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'Password Complexity Verification Function',
                p_column_label_nlsid =>'PWD_CMPLX_FN_COL'));
  MGMT_METRIC.CREATE_METRIC(
      p_target_type => ESM.DB_TARGET_TYPE,
      p_metric_name => 'pwdComplexityFnRep',       
      p_type_meta_ver => ESM.DB_TYPE_META_VERSION,
      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type, 
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,
      p_metric_label => 'Password Complexity Verification Function',
      p_metric_label_nlsid => 'PWD_CMPLX_FN_METRIC_LABEL',
      p_description  => 'Collect setting of PASSWORD_VERIFY_FUNCTION',
      p_description_nlsid => 'PWD_CMPLX_FN_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE ,     
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source =>'SELECT target_guid, value as limit, value2 as profile '
                 ||'FROM esm_collection_latest '
                 ||'WHERE  property =''password_complexity_fn''',
      p_snapshot_name_list => l_snapshot_list,
      p_metric_column_list => l_metric_column_list  
 ) ;
COMMIT ;
MGMT_METRIC.CREATE_METRIC(
      p_target_type => 'rac_database',
      p_metric_name => 'pwdComplexityFnRep',
      p_type_meta_ver => ESM.DB_TYPE_META_VERSION,
--      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type, 
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,    			
      p_metric_label => 'Password Complexity Verification Function',
      p_metric_label_nlsid => 'PWD_CMPLX_FN_METRIC_LABEL',
      p_description  => 'Collect setting of PASSWORD_VERIFY_FUNCTION',
      p_description_nlsid => 'PWD_CMPLX_FN_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE ,     
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source =>'SELECT target_guid, value as limit, value2 as profile '
                 ||'FROM esm_collection_latest '
                 ||'WHERE  property =''password_complexity_fn''',
      p_snapshot_name_list => l_snapshot_list_rac,
      p_metric_column_list => l_metric_column_list  
 ) ;
COMMIT ;
--Policies


  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(
	         p_metric_column => 'profile', 
    		 p_url_link_template =>'database/security/profile?oname=^profile^\&event=edit\&otype=PROFILE\&target=^TARGET_NAME^\&type=^TARGET_TYPE^\&cancelURL=^CANCEL_URL^', 
    		 p_url_link_type => MGMT_POLICY.G_URL_TYPE_JSP),
      	MGMT_VIOL_CTXT_DEF.NEW(
		     p_metric_column => 'limit'));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));
                
 ESM.CREATE_POLICY(
  p_target_type => ESM.DB_TARGET_TYPE,
  p_policy_name =>'Password_Complexity_Fn_Usage',   --Policy name
  p_metric_name =>'pwdComplexityFnRep',      --Metric name
  p_policy_label_nlsid =>'PWD_CMPLX_FN_NAME',   --Password Complexity Verification Function 
  p_description =>'Ensures PASSWORD_VERIFY_FUNCTION resource for the profile is set',
  p_description_nlsid =>'PWD_CMPLX_FN_DESC',
  p_impact => 'Having passwords that do not meet minimum complexity requirements offer '||
              'substantially less protection than complex passwords.',
  p_impact_nlsid =>'PWD_CMPLX_FN_IMPACT',
  p_recommendation =>'Set the PASSWORD_VERIFY_FUNCTION resource of the profile.',
  p_recommendation_nlsid =>'PWD_CMPLX_FN_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_CRITICAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition => ':limit = ''NULL''',
  p_message =>'Database is in an insecure state. PASSWORD_VERIFY_FUNCTION resource is not set for the profile %profile%.',
  p_message_nlsid =>'PWD_CMPLX_FN_MESG',
  p_cs_consider_percentage =>MGMT_GLOBAL.G_TRUE,
  p_start_type_meta_ver => ESM.DB_TYPE_META_VERSION,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList	
);
COMMIT ;
 ESM.CREATE_POLICY(
  p_target_type => 'rac_database',
  p_policy_name =>'Password_Complexity_Fn_Usage',   --Policy name
  p_metric_name =>'pwdComplexityFnRep',      --Metric name
  p_policy_label_nlsid =>'PWD_CMPLX_FN_NAME',   --Password Complexity Verification Function 
  p_description =>'Ensures PASSWORD_VERIFY_FUNCTION resource for the profile is set',
  p_description_nlsid =>'PWD_CMPLX_FN_DESC',
  p_impact => 'Having passwords that do not meet minimum complexity requirements offer '||
              'substantially less protection than complex passwords.',
  p_impact_nlsid =>'PWD_CMPLX_FN_IMPACT',
  p_recommendation =>'Set the PASSWORD_VERIFY_FUNCTION resource of the profile.',
  p_recommendation_nlsid =>'PWD_CMPLX_FN_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_CRITICAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition => ':limit = ''NULL''',
  p_message =>'Database is in an insecure state. PASSWORD_VERIFY_FUNCTION is not set for the profile %profile%.',
  p_message_nlsid =>'PWD_CMPLX_FN_MESG',
  p_cs_consider_percentage =>MGMT_GLOBAL.G_TRUE,
  p_start_type_meta_ver => ESM.DB_TYPE_META_VERSION,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList	
);
COMMIT;

-----------------------------------------------
--End of Bug 5259286
-----------------------------------------------

---------------------------------------------------------------------------------
--Bug 5234593 : change threshold type
----------------------------------------------------------------------------------
 ESM.DELETE_POLICY(
   P_TARGET_TYPE => 'oracle_database',
   P_POLICY_NAME => 'Password_Reuse_Time'
 );
 COMMIT ;
 
 ESM.DELETE_POLICY(
   P_TARGET_TYPE => 'rac_database',
   P_POLICY_NAME => 'Password_Reuse_Time'
 );
 COMMIT ;
 
 MGMT_METRIC.DELETE_METRIC(
    P_TARGET_TYPE => 'oracle_database',
    P_METRIC_NAME => 'passwdReuseTimeRep',
    P_TYPE_META_VER => NULL 
 );
 COMMIT ;
 
 MGMT_METRIC.DELETE_METRIC(
    P_TARGET_TYPE => 'rac_database',
    P_METRIC_NAME => 'passwdReuseTimeRep',
    P_TYPE_META_VER => NULL 
 );
 COMMIT ;

  l_valid_if_list := MGMT_VALIDIF_ARRAY(
       MGMT_VALIDIF_OBJ.NEW(
            p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY('DB'))
 );
 l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'profile',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Profile',
                p_column_label_nlsid =>'PROFILE_COL'),
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'limit',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'Password Reuse Time',
                p_column_label_nlsid =>'PWD_REUSE_TIME_COL'));

  MGMT_METRIC.CREATE_METRIC(
      p_target_type => ESM.DB_TARGET_TYPE,
      p_metric_name => 'passwdReuseTimeRep',
      p_type_meta_ver => ESM.DB_TYPE_META_VERSION,
      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type, 
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,    			
      p_metric_label => 'Password Reuse Time',
      p_metric_label_nlsid => 'PWD_REUSE_TIME_METRIC_LABEL',
      p_description  => 'Collect setting of PASSWORD_REUSE_TIME',
      p_description_nlsid => 'PWD_REUSE_TIME_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE ,     
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source =>'SELECT target_guid, value as limit, value2 as profile '
                 ||'FROM esm_collection_latest '
                 ||'WHERE  property =''password_reuse_time''',
      p_snapshot_name_list => l_snapshot_list,
      p_metric_column_list => l_metric_column_list  
 ) ;
 COMMIT ;
   MGMT_METRIC.CREATE_METRIC(
      p_target_type => 'rac_database',
      p_metric_name => 'passwdReuseTimeRep',
      p_type_meta_ver => ESM.DB_TYPE_META_VERSION,
  --    p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type, 
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,    			
      p_metric_label => 'Password Reuse Time',
      p_metric_label_nlsid => 'PWD_REUSE_TIME_METRIC_LABEL',
      p_description  => 'Collect setting of PASSWORD_REUSE_TIME',
      p_description_nlsid => 'PWD_REUSE_TIME_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE ,     
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source =>'SELECT target_guid, value as limit, value2 as profile '
                 ||'FROM esm_collection_latest '
                 ||'WHERE  property =''password_reuse_time''',
      p_snapshot_name_list => l_snapshot_list_rac,
      p_metric_column_list => l_metric_column_list  
 ) ;
 COMMIT ;

  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(
	         p_metric_column => 'profile', 
    		 p_url_link_template =>'database/security/profile?oname=^profile^\&event=edit\&otype=PROFILE\&target=^TARGET_NAME^\&type=^TARGET_TYPE^\&cancelURL=^CANCEL_URL^', 
   		     p_url_link_type => MGMT_POLICY.G_URL_TYPE_JSP),
      	MGMT_VIOL_CTXT_DEF.NEW(
		     p_metric_column => 'limit'));
  l_paramDefList := MGMT_POLICY_PARAM_DEF_ARRAY(
        MGMT_POLICY_PARAM_DEF(
                param_name => 'MIN_PASSWORD_REUSE_TIME',
                param_name_nlsid => 'MIN_PWD_REUSE_TIME_PNAME',
                param_type => MGMT_POLICY.G_PARAM_TYPE_NUMBER));
  l_defaultParamValList := MGMT_POLICY_PARAM_VAL_ARRAY(
        MGMT_POLICY_PARAM_VAL.NEW(
                p_param_name => 'MIN_PASSWORD_REUSE_TIME',
                p_crit_threshold => '2147483647'));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL,
                p_param_values => l_defaultParamValList));
  ESM.CREATE_POLICY(
  p_target_type => ESM.DB_TARGET_TYPE,
  p_policy_name =>'Password_Reuse_Time',   --Policy name
  p_metric_name =>'passwdReuseTimeRep',      --Metric name
  p_policy_label_nlsid =>'PWD_REUSE_TIME_NAME',    
  p_description =>'Ensures that all profiles have PASSWORD_REUSE_TIME set to a reasonable number of days',
  p_description_nlsid =>'PWD_REUSE_TIME_DESC', 
  p_impact => 'A low value for the PASSWORD_REUSE_TIME parameter may cause serious '||
              'database security issues by allowing users to reuse their old passwords more often.',
  p_impact_nlsid =>'PWD_REUSE_TIME_IMPACT',
  p_recommendation =>'Set the PASSWORD_REUSE_TIME parameter to UNLIMITED for all profiles.',
  p_recommendation_nlsid =>'PWD_REUSE_TIME_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_CRITICAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'decode(:limit,''UNLIMITED'',2147483647,to_number(:limit)) < :MIN_PASSWORD_REUSE_TIME', -- If not unlimited
  p_message =>'Database is in an insecure state. PASSWORD_REUSE_TIME  is set to %limit% for the profile %profile%.',
  p_message_nlsid =>'PWD_REUSE_TIME_MESG',
  p_cs_consider_percentage =>MGMT_GLOBAL.G_TRUE,
  p_start_type_meta_ver => ESM.DB_TYPE_META_VERSION,
  p_policy_param_list =>l_paramDefList,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList	
);
COMMIT ;
  ESM.CREATE_POLICY(
  p_target_type => 'rac_database',
  p_policy_name =>'Password_Reuse_Time',   --Policy name
  p_metric_name =>'passwdReuseTimeRep',      --Metric name
  p_policy_label_nlsid =>'PWD_REUSE_TIME_NAME',    
  p_description =>'Ensures that all profiles have PASSWORD_REUSE_TIME set to a reasonable number of days',
  p_description_nlsid =>'PWD_REUSE_TIME_DESC', 
  p_impact => 'A low value for the PASSWORD_REUSE_TIME parameter may cause serious '||
              'database security issues by allowing users to reuse their old passwords more often.',
  p_impact_nlsid =>'PWD_REUSE_TIME_IMPACT',
  p_recommendation =>'Set the PASSWORD_REUSE_TIME parameter to UNLIMITED for all profiles.',
  p_recommendation_nlsid =>'PWD_REUSE_TIME_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_CRITICAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'decode(:limit,''UNLIMITED'',2147483647,to_number(:limit)) < :MIN_PASSWORD_REUSE_TIME', -- If not unlimited
  p_message =>'Database is in an insecure state. PASSWORD_REUSE_TIME  is set to %limit% for the profile %profile%.',
  p_message_nlsid =>'PWD_REUSE_TIME_MESG',
  p_cs_consider_percentage =>MGMT_GLOBAL.G_TRUE,
  p_start_type_meta_ver => ESM.DB_TYPE_META_VERSION,
  p_policy_param_list =>l_paramDefList,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList	
);
COMMIT ;


-----------------------------------------------
--End of Bug 5234593
-----------------------------------------------

-----------------------------------------------------------
--Bug 5435113: Internal Sec Team recommendations
--3 policies have changed conditions, hence delete existing
--violations and create new policy
-----------------------------------------------------------

  l_policyNameList := POLICY_LIST('Remote_Password_File','Audit_Trail','Os_Authent_Prefix') ;

  l_metricNameList := METRIC_LIST('remoteLoginPasswordFileRep','auditTrailRep','osAuthRep') ;
 
  --All policies being fixed are db instance only policies
  l_target_type := ESM.DB_TARGET_TYPE;

  FOR i IN 1..3 LOOP
   l_policyName := l_policyNameList(i);
 
   ESM.DELETE_POLICY(
     P_TARGET_TYPE => l_target_type,
     P_POLICY_NAME => l_policyName
   );
   COMMIT ;
 
   l_metricName := l_metricNameList(i);
   MGMT_METRIC.DELETE_METRIC(
     P_TARGET_TYPE => l_target_type,
     P_METRIC_NAME => l_metricName,
     P_TYPE_META_VER => NULL 
   );
   COMMIT ;
  END LOOP;
-----------------------------------------------------------

  l_valid_if_list := MGMT_VALIDIF_ARRAY(
       MGMT_VALIDIF_OBJ.NEW(
            p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY(' ')));
            
  l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'value',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'Remote Login Passwordfile',
                p_column_label_nlsid =>'RMT_LOGIN_PWDFILE_COL_'));

  MGMT_METRIC.CREATE_METRIC(
      p_target_type => ESM.DB_TARGET_TYPE,
      p_metric_name => 'remoteLoginPasswordFileRep',	
      p_type_meta_ver => l_10gR1_db_meta_ver,
      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type,
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT, 
      p_metric_label => 'Remote Login Password File',
      p_metric_label_nlsid => 'RMT_LOGIN_PWDFILE_METRIC_LABEL',
      p_description  => 'Collect the information of remote login password file',
      p_description_nlsid => 'RMT_LOGIN_PWDFILE_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE ,     
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source =>'SELECT target_guid, value '
                 ||'FROM esm_collection_latest '
                 ||'WHERE property=''remote_login_passwordfile''',
      p_snapshot_name_list => l_snapshot_list_inst_10gR1,
      p_metric_column_list => l_metric_column_list  
 );
COMMIT ;
 -- This Url will direct to Initialization Parameters page
 -- From you can edit setting for Initialization Parameters
 l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
      MGMT_VIOL_CTXT_DEF.NEW(
 	         p_metric_column => 'value', 
       		 p_url_link_template =>'database/instance/initParameters?event=findParameter\&target=^TARGET_NAME^\&type=^TARGET_TYPE^\&initParamName=remote_login_passwordfile\&cancelURL=^CANCEL_URL^', 
           	 p_url_link_type => MGMT_POLICY.G_URL_TYPE_JSP));
 l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));
 ESM.CREATE_POLICY(
  p_target_type => ESM.DB_TARGET_TYPE,
  p_policy_name =>'Remote_Password_File',   --Policy name
  p_metric_name =>'remoteLoginPasswordFileRep',      --Metric name
  p_policy_label_nlsid =>'RMT_LGIN_NAME',   
  --p_description =>'Ensure REMOTE_LOGIN_PASSWORDFILE initialization parameter is set to NONE',
  p_description =>'Ensures privileged users are authenticated by the operating '||
                  'system; that is, Oracle ignores any password file',
  p_description_nlsid =>'RMT_LGIN_DESC',
  --p_impact =>'A malicious user can gain access to the database if remote '||
  --      'password files are allowed.',
  p_impact =>'The REMOTE_LOGIN_PASSWORDFILE parameter specifies whether or '||
             'not Oracle checks for a password file. Because password files '||
             'contain the passwords for users, including SYS, the most secure '||
             'way of preventing an attacker from connecting through brute-force '||
             'password-related attacks is to require privileged users be '||
             'authenticated by the operating system.',
  p_impact_nlsid =>'RMT_LGIN_IMPACT',
  --p_recommendation =>'For non-RAC configurations, Oracle recommends setting '||
  --      'REMOTE_LOGIN_PASSWORDFILE to ''NONE''.',
  p_recommendation =>'Remove the password file and to set REMOTE_LOGIN_PASSWORDFILE '||
                     'to NONE.',
  p_recommendation_nlsid =>'RMT_LGIN_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_INFORMATIONAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  --p_condition =>'upper(:value)=''SHARED''',
  --Bug 5435113: REMOTE_LOGIN_PASSWORDFILE = 'NONE' is recommended
  p_condition =>'upper(:value) <> ''NONE''',
  p_message =>'Database is in an insecure state. REMOTE_LOGIN_PASSWORDFILE '||
        'initialization parameter is set to %value%.',
  p_message_nlsid =>'RMT_LGIN_MESG',
  p_cs_consider_percentage =>MGMT_GLOBAL.G_TRUE,
  p_start_type_meta_ver => l_10gR1_db_meta_ver,  -- Applicable for 10gR1 + 10gR2 
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList	
);
COMMIT; 

------
l_valid_if_list := MGMT_VALIDIF_ARRAY(
       MGMT_VALIDIF_OBJ.NEW(
            p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY(' '))
 );
    l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'value',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'Audit Trail',
                p_column_label_nlsid =>'AUDIT_TRAIL_COL'));
  MGMT_METRIC.CREATE_METRIC(
      p_target_type => ESM.DB_TARGET_TYPE,
      p_metric_name => 'auditTrailRep', 	
      p_type_meta_ver => ESM.DB_TYPE_META_VERSION,
      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type, 
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,    			
      p_metric_label => 'Audit Trail',
      p_metric_label_nlsid => 'AUDIT_TRAIL_METRIC_LABEL',
      p_description  => 'Collect the information of AUDIT_TRAIL initialization parameter',
      p_description_nlsid => 'AUDIT_TRAIL_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE ,     
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT target_guid, value '
                 ||'FROM esm_collection_latest '
                 ||'WHERE property =''audit_trail''',
      p_snapshot_name_list => l_snapshot_list_inst_10gR2,
      p_metric_column_list => l_metric_column_list  
 );
COMMIT ;

-- Policies
 -- This Url will direct to Initialization Parameters page
 -- From there you can edit setting for Initialization Parameters
 l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
      MGMT_VIOL_CTXT_DEF.NEW(
 	         p_metric_column => 'value', 
       		 p_url_link_template =>'database/instance/initParameters?event=findParameter\&target=^TARGET_NAME^\&type=^TARGET_TYPE^\&initParamName=audit_trail\&cancelURL=^CANCEL_URL^', 
           	 p_url_link_type => MGMT_POLICY.G_URL_TYPE_JSP));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));
 ESM.CREATE_POLICY(
  p_target_type => ESM.DB_TARGET_TYPE,
  p_policy_name =>'Audit_Trail',   --Policy name
  p_metric_name =>'auditTrailRep',      --Metric name
  p_policy_label_nlsid =>'AUDIT_TRAIL_NAME',    
  --p_description =>'Ensures basic auditing features are enabled',
  p_description =>'Ensures database auditing is enabled',
  p_description_nlsid =>'AUDIT_TRAIL_DESC', 
  --p_impact => 'Not enabling basic audit features might increase the likelihood '||
  --            'of a denial of service attack going unnoticed.',
  p_impact => 'The AUDIT_TRAIL parameter enables or disables database auditing. '||
              'Auditing enhances security because it enforces accountability,'||
              'provides evidence of misuse, and is frequently required for '||
              'regulatory compliance. Auditing also enables system administrators to'||
              'implement enhanced protections, early detection of suspicious '||
              'activities, and finely-tuned security responses.',
  p_impact_nlsid =>'AUDIT_TRAIL_IMPACT',
  --p_recommendation =>'Enable auditing by setting the AUDIT_TRAIL initialization parameter '||
  --             'to a value other than NONE or FALSE. A value of OS is the most secure setting.',
  p_recommendation =>'Set AUDIT_TRAIL to either DB, default, or OS. Database-stored '||
              'audit records can be easier to review and manage than OS-stored audit '||
              'records. However, audit records stored in operating system files can '||
              'be protected from DBAs via appropriate file permissions, and will '||
              'remain available even if the database is temporarily inaccessible.',
  p_recommendation_nlsid =>'AUDIT_TRAIL_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_INFORMATIONAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  --p_condition =>'(upper(:value) = ''NONE'') OR (upper(:value) = ''FALSE'')',
  --Bug 5435113: AUDIT_TRAIL = 'DB' or 'OS' is recommended
  p_condition =>'(upper(:value) <> ''DB'') AND (upper(:value) <> ''OS'')',
  p_message =>'Database is in an insecure state. AUDIT_TRAIL initialization parameter is set to %value%.',
  p_message_nlsid =>'AUDIT_TRAIL_MESG',
  p_cs_consider_percentage =>MGMT_GLOBAL.G_TRUE,
  p_start_type_meta_ver => ESM.DB_TYPE_META_VERSION,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList	
);
COMMIT ;

----
l_valid_if_list := MGMT_VALIDIF_ARRAY(
       MGMT_VALIDIF_OBJ.NEW(
            p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY(' '))
 );
    l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'value',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'Os Authentication Prefix',
                p_column_label_nlsid =>'OS_AUTHENT_PREFIX_COL'));
  MGMT_METRIC.CREATE_METRIC(
      p_target_type => ESM.DB_TARGET_TYPE,
      p_metric_name => 'osAuthRep', 	
      p_type_meta_ver => ESM.DB_TYPE_META_VERSION,
      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type, 
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,    			
      p_metric_label => 'Os Authentication Prefix',
      p_metric_label_nlsid => 'OS_AUTHENT_PREFIX_METRIC_LABEL',
      p_description  => 'Collect the information of OS_AUTHENT_PREFIX initialization parameter',
      p_description_nlsid => 'OS_AUTHENT_PREFIX_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE ,     
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT target_guid, value '
                 ||'FROM esm_collection_latest '
                 ||'WHERE property =''os_authent_prefix''',
      p_snapshot_name_list => l_snapshot_list_inst_10gR2,
      p_metric_column_list => l_metric_column_list  
 );
COMMIT ;


 -- This Url will direct to Initialization Parameters page
 -- From there you can edit setting for Initialization Parameters
 l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
      MGMT_VIOL_CTXT_DEF.NEW(
 	         p_metric_column => 'value', 
       		 p_url_link_template =>'database/instance/initParameters?event=findParameter\&target=^TARGET_NAME^\&type=^TARGET_TYPE^\&initParamName=os_authent_prefix\&cancelURL=^CANCEL_URL^', 
           	 p_url_link_type => MGMT_POLICY.G_URL_TYPE_JSP));
l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));
 ESM.CREATE_POLICY(
  p_target_type => ESM.DB_TARGET_TYPE,
  p_policy_name =>'Os_Authent_Prefix',--Policy Name
  p_metric_name =>'osAuthRep',      --Metric name
  p_policy_label_nlsid =>'OS_AUTH_PREFIX_NAME',    
  --p_description =>'Ensures that the OS_AUTHENT_PREFIX is set to a value other than OPS$ or null string ("")',
  p_description =>'Ensures that the OS authentication prefix is set to a value other than OPS$',
  p_description_nlsid =>'OS_AUTH_PREFIX_DESC',
  --p_impact => 'Setting this ensures that the only way an account can be used externally is by specifying IDENTIFIED EXTERNALLY when creating a user.',
  p_impact => 'The OS_AUTHENT_PREFIX parameter specifies a prefix used to authenticate '||
              'users attempting to connect to the server. When a connection request is '||
              'attempted, Oracle compares the prefixed username with usernames in the '||
              'database.  Using a prefix, especially OPS$, tends to result in an '||
              'insecure configuration as an account can be authenticated either as '||
              'an operating system user or with the password used in the IDENTIFIED BY '||
              'clause. Attackers are aware of this and will attack these accounts.',
  p_impact_nlsid =>'OS_AUTH_PREFIX_IMPACT',
  --p_recommendation =>'The identified externally approach should only be used on development and test databases. On a production system, ensure that the user cannot get to the operating system level.',
  p_recommendation =>'Set OS_AUTHENT_PREFIX to a value other than OPS$.',
  p_recommendation_nlsid =>'OS_AUTH_PREFIX_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_WARNING,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  --Bug 5435113: OS_AUTHENT_PREFIX anything other than OPS$ is recommended
  --p_condition =>'(:value = '' '') OR (:value = ''OPS$'')' ,
  p_condition =>'upper(:value) = ''OPS$''' ,
  p_message =>'Database is in an insecure state. Operating System authentication prefix is set to %value%.',
  p_message_nlsid =>'OS_AUTH_PREFIX_MESG',
  p_cs_consider_percentage =>MGMT_GLOBAL.G_TRUE,
  p_start_type_meta_ver => ESM.DB_TYPE_META_VERSION,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList	
);
COMMIT ;

----------------------------------------------------------------------
--Spliting Excessive Public Execute Privileges policy into 3 policies
--The original metric is reused, so no deleting of metric required
----------------------------------------------------------------------
BEGIN
   ESM.DELETE_POLICY(
     P_TARGET_TYPE => 'oracle_database',
     P_POLICY_NAME => 'Excessive_PUBLIC_EXECUTE_privileges'
   );
   COMMIT ;
 
   ESM.DELETE_POLICY(
     P_TARGET_TYPE => 'rac_database',
     P_POLICY_NAME => 'Excessive_PUBLIC_EXECUTE_privileges'
   );
   COMMIT ;
EXCEPTION
   WHEN  OTHERS THEN NULL;
END;

-- Start Public Execute Privileges on UTL_TCP Package Policy

-- This Url will take user to USER EDIT SETTING PAGE
 -- From there he/she can modify object privileges(EXECUTE) given to PUBLIC for the packages.
 l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'package',
                p_url_link_template =>'database/security/user?oname=PUBLIC\&event=edit\&otype=USER\&target=^TARGET_NAME^\&type=^TARGET_TYPE^\&cancelURL=^CANCEL_URL^', 
   		        p_url_link_type => MGMT_POLICY.G_URL_TYPE_JSP));
 l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));
 ESM.CREATE_POLICY(
  p_target_type => ESM.DB_TARGET_TYPE, 
  p_policy_name =>'Public_Exec_Priv_Utl_Tcp',   --Policy name
  p_metric_name =>'executePrivilegesRep',      --Metric name
  p_policy_label_nlsid =>'UTL_TCP_PUB_EXE_PRIV_NAME',     
  p_description =>'Ensure PUBLIC does not have execute privileges on the UTL_TCP package',
  p_description_nlsid =>'UTL_TCP_PUB_EXE_PRIV_DESC', 
  p_impact =>'Privileges granted to the PUBLIC role automatically apply to all users. '||
             'A  malicious user can gain access to email, network and http modules '||
             'using the EXECUTE privilege.',
  p_impact_nlsid =>'PUB_EXE_PRIV_IMPACT',
  p_recommendation =>'Revoke EXECUTE privileges on the UTL_TCP package.',
  p_recommendation_nlsid =>'UTL_TCP_PUB_EXE_PRIV_RECOMM', 
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_CRITICAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>':package = ''UTL_TCP''',
  p_message =>'Database is in insecure state. EXECUTE privilege on the package '||
              '%package% is granted to PUBLIC.',
  p_message_nlsid =>'PUB_EXE_PRIV_MESG',
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver => l_10gR1_db_meta_ver,  
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList	
);
COMMIT;
 ESM.CREATE_POLICY(
  p_target_type => 'rac_database', 
  p_policy_name =>'Public_Exec_Priv_Utl_Tcp',   --Policy name
  p_metric_name =>'executePrivilegesRep',      --Metric name
  p_policy_label_nlsid =>'UTL_TCP_PUB_EXE_PRIV_NAME',     
  p_description =>'Ensure PUBLIC does not have execute privileges on the UTL_TCP package',
  p_description_nlsid =>'UTL_TCP_PUB_EXE_PRIV_DESC', 
  p_impact =>'Privileges granted to the PUBLIC role automatically apply to all users. '||
             'A  malicious user can gain access to email, network and http modules '||
             'using the EXECUTE privilege.',
  p_impact_nlsid =>'PUB_EXE_PRIV_IMPACT',
  p_recommendation =>'Revoke EXECUTE privileges on the UTL_TCP package.',
  p_recommendation_nlsid =>'UTL_TCP_PUB_EXE_PRIV_RECOMM', 
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_CRITICAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>':package = ''UTL_TCP''',
  p_message =>'Database is in insecure state. EXECUTE privilege on the package '||
              '%package% is granted to PUBLIC.',
  p_message_nlsid =>'PUB_EXE_PRIV_MESG',
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver => l_10gR1_db_meta_ver,  
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList	
);
COMMIT;

-- End of Public Execute Privileges on UTL_TCP Package Policy

-- Start Public Execute Privileges on UTL_HTTP Package Policy

-- This Url will take user to USER EDIT SETTING PAGE
 -- From there he/she can modify object privileges(EXECUTE) given to PUBLIC for the packages.
 l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'package',
                p_url_link_template =>'database/security/user?oname=PUBLIC\&event=edit\&otype=USER\&target=^TARGET_NAME^\&type=^TARGET_TYPE^\&cancelURL=^CANCEL_URL^', 
   		        p_url_link_type => MGMT_POLICY.G_URL_TYPE_JSP));
 l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));
 ESM.CREATE_POLICY(
  p_target_type => ESM.DB_TARGET_TYPE, 
  p_policy_name =>'Public_Exec_Priv_Utl_Http',   --Policy name
  p_metric_name =>'executePrivilegesRep',      --Metric name
  p_policy_label_nlsid =>'UTL_HTTP_PUB_EXE_PRIV_NAME',     
  p_description =>'Ensure PUBLIC does not have execute privileges on the UTL_HTTP package',
  p_description_nlsid =>'UTL_HTTP_PUB_EXE_PRIV_DESC', 
  p_impact =>'Privileges granted to the PUBLIC role automatically apply to all users. '||
             'A  malicious user can gain access to email, network and http modules '||
             'using the EXECUTE privilege.',
  p_impact_nlsid =>'PUB_EXE_PRIV_IMPACT',
  p_recommendation =>'Revoke EXECUTE privileges on the UTL_HTTP package.',
  p_recommendation_nlsid =>'UTL_HTTP_PUB_EXE_PRIV_RECOMM', 
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_CRITICAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>':package = ''UTL_HTTP''',
  p_message =>'Database is in insecure state. EXECUTE privilege on the package '||
              '%package% is granted to PUBLIC.',
  p_message_nlsid =>'PUB_EXE_PRIV_MESG',
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver => l_10gR1_db_meta_ver,  
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList	
);
COMMIT;
 ESM.CREATE_POLICY(
  p_target_type => 'rac_database', 
  p_policy_name =>'Public_Exec_Priv_Utl_Http',   --Policy name
  p_metric_name =>'executePrivilegesRep',      --Metric name
  p_policy_label_nlsid =>'UTL_HTTP_PUB_EXE_PRIV_NAME',     
  p_description =>'Ensure PUBLIC does not have execute privileges on the UTL_HTTP package',
  p_description_nlsid =>'UTL_HTTP_PUB_EXE_PRIV_DESC', 
  p_impact =>'Privileges granted to the PUBLIC role automatically apply to all users. '||
             'A  malicious user can gain access to email, network and http modules '||
             'using the EXECUTE privilege.',
  p_impact_nlsid =>'PUB_EXE_PRIV_IMPACT',
  p_recommendation =>'Revoke EXECUTE privileges on the UTL_HTTP package.',
  p_recommendation_nlsid =>'UTL_HTTP_PUB_EXE_PRIV_RECOMM', 
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_CRITICAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>':package = ''UTL_HTTP''',
  p_message =>'Database is in insecure state. EXECUTE privilege on the package '||
              '%package% is granted to PUBLIC.',
  p_message_nlsid =>'PUB_EXE_PRIV_MESG',
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver => l_10gR1_db_meta_ver,  
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList	
);
COMMIT;

-- End of Public Execute Privileges on UTL_HTTP Package Policy

-- Start Public Execute Privileges on UTL_SMTP Package Policy

-- This Url will take user to USER EDIT SETTING PAGE
 -- From there he/she can modify object privileges(EXECUTE) given to PUBLIC for the packages.
 l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'package',
                p_url_link_template =>'database/security/user?oname=PUBLIC\&event=edit\&otype=USER\&target=^TARGET_NAME^\&type=^TARGET_TYPE^\&cancelURL=^CANCEL_URL^', 
   		        p_url_link_type => MGMT_POLICY.G_URL_TYPE_JSP));
 l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));
 ESM.CREATE_POLICY(
  p_target_type => ESM.DB_TARGET_TYPE, 
  p_policy_name =>'Public_Exec_Priv_Utl_Smtp',   --Policy name
  p_metric_name =>'executePrivilegesRep',      --Metric name
  p_policy_label_nlsid =>'UTL_SMTP_PUB_EXE_PRIV_NAME',     
  p_description =>'Ensure PUBLIC does not have execute privileges on the UTL_SMTP package',
  p_description_nlsid =>'UTL_SMTP_PUB_EXE_PRIV_DESC', 
  p_impact =>'Privileges granted to the PUBLIC role automatically apply to all users. '||
             'A  malicious user can gain access to email, network and http modules '||
             'using the EXECUTE privilege.',
  p_impact_nlsid =>'PUB_EXE_PRIV_IMPACT',
  p_recommendation =>'Revoke EXECUTE privileges on the UTL_SMTP package.',
  p_recommendation_nlsid =>'UTL_SMTP_PUB_EXE_PRIV_RECOMM', 
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_CRITICAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>':package = ''UTL_SMTP''',
  p_message =>'Database is in insecure state. EXECUTE privilege on the package '||
              '%package% is granted to PUBLIC.',
  p_message_nlsid =>'PUB_EXE_PRIV_MESG',
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver => l_10gR1_db_meta_ver,  
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList	
);
COMMIT;
 ESM.CREATE_POLICY(
  p_target_type => 'rac_database', 
  p_policy_name =>'Public_Exec_Priv_Utl_Smtp',   --Policy name
  p_metric_name =>'executePrivilegesRep',      --Metric name
  p_policy_label_nlsid =>'UTL_SMTP_PUB_EXE_PRIV_NAME',     
  p_description =>'Ensure PUBLIC does not have execute privileges on the UTL_SMTP package',
  p_description_nlsid =>'UTL_SMTP_PUB_EXE_PRIV_DESC', 
  p_impact =>'Privileges granted to the PUBLIC role automatically apply to all users. '||
             'A  malicious user can gain access to email, network and http modules '||
             'using the EXECUTE privilege.',
  p_impact_nlsid =>'PUB_EXE_PRIV_IMPACT',
  p_recommendation =>'Revoke EXECUTE privileges on the UTL_SMTP package.',
  p_recommendation_nlsid =>'UTL_SMTP_PUB_EXE_PRIV_RECOMM', 
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_CRITICAL,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>':package = ''UTL_SMTP''',
  p_message =>'Database is in insecure state. EXECUTE privilege on the package '||
              '%package% is granted to PUBLIC.',
  p_message_nlsid =>'PUB_EXE_PRIV_MESG',
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver => l_10gR1_db_meta_ver,  
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList	
);
COMMIT;

-- End of Public Execute Privileges on UTL_SMTP Package Policy
-----------------------------------------------------------
--End of bug 5435113
-----------------------------------------------------------

END ;
/
show errors ;
SET ESCAPE OFF ;
