Rem drv: <migrate type="data_upgrade" version="10.2.0.3"/>
Rem
Rem $Header: security_policy_setup.sql 30-aug-2006.14:24:39 groyal Exp $
Rem
Rem security_policy_setup.sql
Rem
Rem Copyright (c) 2006, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      security_policy_setup.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    groyal      08/30/06 - Change sys ops policy to security category
Rem    groyal      08/23/06 - Add new 10.2.0.3 security policies
Rem    groyal      08/23/06 - Created
Rem

-- SET ECHO ON
-- SET FEEDBACK 1
-- SET NUMWIDTH 10
-- SET LINESIZE 80
-- SET TRIMSPOOL ON
-- SET TAB OFF
-- SET PAGESIZE 100

SET DEFINE OFF


-- ==========================================================
--
-- CREATE Security Policies
--
-- ==========================================================

DECLARE

  l_conditionSql        VARCHAR2(1000);
  l_categoryList        MGMT_CATEGORY_ARRAY;
  l_defaultSettingsList MGMT_POLICY_KEY_VAL_ARRAY;
  l_violCtxtList        MGMT_VIOL_CTXT_DEF_ARRAY;
  l_paramList           MGMT_POLICY_PARAM_DEF_ARRAY;
  l_defParamValList     MGMT_POLICY_PARAM_VAL_ARRAY;
  l_10gR1MetaVersion    CONSTANT VARCHAR2(3) := '3.0';

BEGIN

  -- ----------------------------------------------------------
  -- Policy: Data Dictionary Protected
  -- Policy ID: DATA_DICTIONARY_PROTECTED
  -- Uses Metric: DB_INIT_PARAMS
  --
  -- Category: Configuration
  -- Violation Level: Warning
  -- DB Versions: 9.2 +
  -- Agent Version: 10.1.0.2 +
  -- Description: 
  --    This policy is considered to be in violation if
  --    the init param '07_DICTIONARY_ACCESSIBILITY' has a value of
  --    'TRUE'.
  --    Added by groyal for 10gR2 GC (10.2.0.3.0) 
  -- ----------------------------------------------------------

  l_conditionSql := 'upper(nvl(:INIT_PARAM_VALUE, ''TRUE'')) = ''TRUE'' ';

  l_categoryList := MGMT_CATEGORY_ARRAY(
    MGMT_CATEGORY_OBJ.NEW(
      p_class_name => MGMT_GLOBAL.G_CATEGORY_CLASS_FUNCTIONAL,
      p_category_name => MGMT_GLOBAL.G_FUNC_CATEGORY_SECURITY)); 

  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
    MGMT_POLICY_KEY_VAL.NEW(
      p_importance   => MGMT_GlOBAL.G_IMPORTANCE_NORMAL, 
      p_key_value    => mgmt_policy_key_col_cond_array(
                        mgmt_policy_key_col_cond.new('O7_DICTIONARY_ACCESSIBILITY',0,'INIT_PARAM_NAME')),
      p_is_exception => 0,
      p_condition_operator => MGMT_GLOBAL.G_CONDITION_SQL));

  l_violCtxtList := MGMT_VIOL_CTXT_DEF_ARRAY(
    MGMT_VIOL_CTXT_DEF.NEW(
      p_metric_column => 'INIT_PARAM_NAME',
      p_url_link_template => 'database/instance/initParameters?event=findParameter&target=^TARGET_NAME^&type=^TARGET_TYPE^&initParamName=07_DICTIONARY_ACCESSIBILITY&cancelURL=^CANCEL_URL^',
      p_url_link_type => MGMT_POLICY.G_URL_TYPE_JSP),
    MGMT_VIOL_CTXT_DEF.NEW(
      p_metric_column => 'INIT_PARAM_VALUE'));

  MGMT_POLICY.CREATE_POLICY(
      p_target_type => 'oracle_database',
      p_policy_name => 'DATA_DICTIONARY_PROTECTED',
      p_metric_name => 'DB_INIT_PARAMS',
      p_policy_label_nlsid => 'DATA_DICTIONARY_PROTECTED_NAME',
      p_description => 'DATA_DICTIONARY_PROTECTED_DESC',
      p_description_nlsid => 'DATA_DICTIONARY_PROTECTED_DESC',
      p_impact => 'DATA_DICTIONARY_PROTECTED_IMPACT',
      p_impact_nlsid => 'DATA_DICTIONARY_PROTECTED_IMPACT',
      p_recommendation => 'DATA_DICTIONARY_PROTECTED_RECOM',
      p_recommendation_nlsid => 'DATA_DICTIONARY_PROTECTED_RECOM',
      p_violation_level => MGMT_GLOBAL.G_SEVERITY_CRITICAL,
      p_condition_type => MGMT_GLOBAL.G_CONDITION_SQL,
      p_condition => l_conditionSql,
      p_message => 'Access to the data dictionary is not protected.',
      p_message_nlsid => 'DATA_DICTIONARY_PROTECTED_MESSAGE',
      p_auto_enable => MGMT_GLOBAL.G_FALSE,
      p_cs_consider_percentage => MGMT_GLOBAL.G_FALSE,
      p_start_type_meta_ver => l_10gR1MetaVersion,
      p_category_list => l_categoryList,
      p_dflt_param_val_list => l_defaultSettingsList,
      p_viol_ctxt_list => l_violCtxtList);
  
  COMMIT;

  -- ----------------------------------------------------------
  -- Policy: Auditing of SYS Operations Enabled
  -- Policy ID: AUDIT_SYS_OPS
  -- Uses Metric: DB_INIT_PARAMS
  --
  -- Category: Configuration
  -- Violation Level: Warning
  -- DB Versions: 9.2 +
  -- Agent Version: 10.1.0.2 +
  -- Description: 
  --    This policy is considered to be in violation if
  --    the init param 'audit_sys_operations' has a value of
  --    'FALSE'.
  --    Added by groyal for 10gR2 GC (10.2.0.3.0) 
  -- ----------------------------------------------------------

  l_conditionSql := 'upper(nvl(:INIT_PARAM_VALUE, ''FALSE'')) = ''FALSE'' ';

  l_categoryList := MGMT_CATEGORY_ARRAY(
    MGMT_CATEGORY_OBJ.NEW(
      p_class_name => MGMT_GLOBAL.G_CATEGORY_CLASS_FUNCTIONAL,
      p_category_name => MGMT_GLOBAL.G_FUNC_CATEGORY_SECURITY)); 

  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
    MGMT_POLICY_KEY_VAL.NEW(
      p_importance   => MGMT_GlOBAL.G_IMPORTANCE_NORMAL, 
      p_key_value    => mgmt_policy_key_col_cond_array(
                        mgmt_policy_key_col_cond.new('audit_sys_operations',0,'INIT_PARAM_NAME')),
      p_is_exception => 0,
      p_condition_operator => MGMT_GLOBAL.G_CONDITION_SQL));

  l_violCtxtList := MGMT_VIOL_CTXT_DEF_ARRAY(
    MGMT_VIOL_CTXT_DEF.NEW(
      p_metric_column => 'INIT_PARAM_NAME',
      p_url_link_template => 'database/instance/initParameters?event=findParameter&target=^TARGET_NAME^&type=^TARGET_TYPE^&initParamName=audit_sys_operations&cancelURL=^CANCEL_URL^',
      p_url_link_type => MGMT_POLICY.G_URL_TYPE_JSP),
    MGMT_VIOL_CTXT_DEF.NEW(
      p_metric_column => 'INIT_PARAM_VALUE'));

  MGMT_POLICY.CREATE_POLICY(
      p_target_type => 'oracle_database',
      p_policy_name => 'AUDIT_SYS_OPS',
      p_metric_name => 'DB_INIT_PARAMS',
      p_policy_label_nlsid => 'AUDIT_SYS_OPS_NAME',
      p_description => 'AUDIT_SYS_OPS_DESC',
      p_description_nlsid => 'AUDIT_SYS_OPS_DESC',
      p_impact => 'AUDIT_SYS_OPS_IMPACT',
      p_impact_nlsid => 'AUDIT_SYS_OPS_IMPACT',
      p_recommendation => 'AUDIT_SYS_OPS_RECOM',
      p_recommendation_nlsid => 'AUDIT_SYS_OPS_RECOM',
      p_violation_level => MGMT_GLOBAL.G_SEVERITY_WARNING,
      p_condition_type => MGMT_GLOBAL.G_CONDITION_SQL,
      p_condition => l_conditionSql,
      p_message => 'Auditing of SYS operations is disabled.',
      p_message_nlsid => 'AUDIT_SYS_OPS_MESSAGE',
      p_auto_enable => MGMT_GLOBAL.G_FALSE,
      p_cs_consider_percentage => MGMT_GLOBAL.G_FALSE,
      p_start_type_meta_ver => l_10gR1MetaVersion,
      p_category_list => l_categoryList,
      p_dflt_param_val_list => l_defaultSettingsList,
      p_viol_ctxt_list => l_violCtxtList);
  
  COMMIT;
END;
/

SET DEFINE ON
  