Rem drv: <migrate type="schema_upgrade" version="11.0.0.0" condition="EM_REPOS_MODE=SYSAUX"/>
Rem
Rem THIS SQL SCRIPT is to bring the CM schemas in 11G DBCONTROL up to date.
Rem  When there are changes to the 11G latest/changemgr/ schema, not only the
Rem regular Central Mode upgrade script needs to be constructed/modified,
Rem this script would also need to be modified as well.
Rem The goal is to have 11G DB component schema CM component to aligne in
Rem both DBControl and Grid Control
Rem
Rem $Header: cm_schema_upgrade_dbcontrol_only.sql 16-oct-2006.13:26:59 xshen Exp $
Rem
Rem cm_schema_upgrade_dbcontrol_only.sql
Rem
Rem Copyright (c) 2006, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      cm_schema_upgrade_dbcontrol_only.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    xshen       10/16/06 - 5014260
Rem    bmallipe    08/14/06 - creating the CM schema upgrade scripts for
Rem                           DBControl only
Rem    bmallipe    08/14/06 - Created
Rem


-- MGMT_CM type definition

-- annotation
CREATE OR REPLACE TYPE COMPARISON_OBJ_RECORD AS OBJECT
  (
    COMPARISON_GUID	RAW(16),
    OBJECT_TYPE		NUMBER,
    OBJECT_SCHEMA       VARCHAR2(30), 
    OBJECT_NAME		VARCHAR2(128), 
    VERSION_NUMBER      NUMBER
  ); 
/

CREATE OR REPLACE TYPE COMPARISON_OBJ_LIST AS TABLE 
       OF COMPARISON_OBJ_RECORD;
/

-- Scope specification

CREATE TABLE MGMT_CM_SCOPESPECS
(
  SS_GUID	RAW(16),
  OBJECT_TYPES	NUMBER NOT NULL,
  FLAGS		NUMBER DEFAULT 0 NOT NULL,
  CONSTRAINT MGMT_CM_SCOPESPECS_PK PRIMARY KEY (SS_GUID)
) MONITORING;

CREATE TABLE MGMT_CM_SCOPESPEC_NAMES
(
  SS_GUID	RAW(16) NOT NULL,
  MATCH_TYPES	NUMBER DEFAULT 0 NOT NULL,
  SCHEMA        VARCHAR2(30),  -- For specific objects
  NAME		VARCHAR2(128) NOT NULL,
  LONGNAME	CLOB,  -- For objects such as Java classes
  CONSTRAINT MGMT_CM_SCOPESPEC_NAMES_FK
    FOREIGN KEY (SS_GUID) REFERENCES MGMT_CM_SCOPESPECS (SS_GUID)
    ON DELETE CASCADE,
  CONSTRAINT MGMT_CM_SCOPESPEC_NAMES_UC 
    UNIQUE (SS_GUID, MATCH_TYPES, SCHEMA, NAME)
)
  LOB (LONGNAME) STORE AS (TABLESPACE &EM_ECM_DEPOT_TABLESPACE ENABLE STORAGE IN ROW) MONITORING
;

-- Baselines

CREATE TABLE MGMT_CM_BASELINES
(
  BASELINE_GUID	RAW(16) DEFAULT SYS_GUID(),
  BASELINE_OWNER	VARCHAR2(30) NOT NULL,  -- or GUID?
  BASELINE_NAME	VARCHAR2(40) NOT NULL,  -- Need 40 chars to fit temp BL name
  BASELINE_SS	RAW(16) NOT NULL,
  SOURCE_ID	RAW(16) NOT NULL,  -- Target GUID of database
  SOURCE_NAME	VARCHAR2(256) NOT NULL,  -- Name of database
  JOB_ID        RAW(16),
  DESCRIPTION   VARCHAR2(2000),    -- description of baseline
  TEMP_BL       NUMBER(1) DEFAULT 0,  -- 0: permanent, 1: temporary
  CONSTRAINT MGMT_CM_BASELINES_PK PRIMARY KEY (BASELINE_GUID),
  CONSTRAINT MGMT_CM_BASELINES_UC 
    UNIQUE (BASELINE_OWNER, BASELINE_NAME)
) MONITORING;

CREATE TABLE MGMT_CM_BASELINE_VERSIONS
(
  BASELINE_GUID	RAW(16) NOT NULL,
  BASELINE_VERSION	NUMBER NOT NULL,
  CAPTURE_TIME          DATE,
  TIMEZONE_REGION       VARCHAR2(64),
  DB_VERSION            VARCHAR2(20),
  JOB_EXECUTION_ID      RAW(16),
  VERSION_STATUS        VARCHAR(3),
  DDL                   BLOB,
  DDL_STATUS            NUMBER DEFAULT -999 NOT NULL,
  DDL_TIME              DATE,
  CONSTRAINT MGMT_CM_BASELINE_VERSIONS_FK
    FOREIGN KEY (BASELINE_GUID) 
    REFERENCES MGMT_CM_BASELINES (BASELINE_GUID)
    ON DELETE CASCADE,
  CONSTRAINT MGMT_CM_BASELINE_VERSIONS_UC 
    UNIQUE(BASELINE_GUID, BASELINE_VERSION)
)
  LOB (DDL) STORE AS (TABLESPACE &EM_ECM_DEPOT_TABLESPACE ENABLE STORAGE IN ROW) MONITORING
;

CREATE TABLE MGMT_CM_BASELINE_OBJECTS
(
  BASELINE_GUID	RAW(16) NOT NULL,
  OBJECT_TYPE	NUMBER NOT NULL,
  OBJECT_SCHEMA	VARCHAR2(30),
  OBJECT_NAME	VARCHAR2(128) NOT NULL,
  OBJECT_LONGNAME	CLOB,
  LAST_DDL_TIME         DATE,
  HASH_VALUE    CHAR(32),
  FIRST_VERSION	NUMBER NOT NULL,
  LAST_VERSION	NUMBER DEFAULT 99999 NOT NULL,
  DEFINITION	BLOB, -- NOT NULL,
  ADDNL_INFO    VARCHAR2(30),
  CONSTRAINT MGMT_CM_BASELINE_OBJECTS_FK
    FOREIGN KEY (BASELINE_GUID) 
    REFERENCES MGMT_CM_BASELINES (BASELINE_GUID)
    ON DELETE CASCADE,
  CONSTRAINT MGMT_CM_BASELINE_OBJECT_UC
    UNIQUE (BASELINE_GUID, OBJECT_TYPE, 
            OBJECT_SCHEMA, OBJECT_NAME, FIRST_VERSION)
)
  LOB (OBJECT_LONGNAME) STORE AS (TABLESPACE &EM_ECM_DEPOT_TABLESPACE ENABLE STORAGE IN ROW) MONITORING,
  LOB (DEFINITION) STORE AS (TABLESPACE &EM_ECM_DEPOT_TABLESPACE ENABLE STORAGE IN ROW) MONITORING
;

-- dependents such as comments, object grants, etc.
CREATE TABLE MGMT_CM_BASELINE_DEPENDENTS
(
  BASELINE_GUID         RAW(16) NOT NULL,
  BASE_OBJECT_TYPE	NUMBER NOT NULL,
  BASE_OBJECT_SCHEMA	VARCHAR2(30),
  BASE_OBJECT_NAME	VARCHAR2(128) NOT NULL,
  DEPENDENT_TYPE        NUMBER NOT NULL,
  HASH_VALUE            CHAR(32),
  FIRST_VERSION         NUMBER NOT NULL,
  LAST_VERSION          NUMBER DEFAULT 99999 NOT NULL,
  DEFINITION            BLOB, -- NOT NULL,
  BASE_OBJECT_COLUMN    VARCHAR2(30),
  CONSTRAINT MGMT_CM_BASELINE_DEPENDENTS_FK
    FOREIGN KEY (BASELINE_GUID) 
    REFERENCES MGMT_CM_BASELINES (BASELINE_GUID)
    ON DELETE CASCADE,
  CONSTRAINT MGMT_CM_BASELINE_DEPEND_UC
    UNIQUE (BASELINE_GUID, BASE_OBJECT_TYPE, BASE_OBJECT_SCHEMA,
            BASE_OBJECT_NAME, DEPENDENT_TYPE, HASH_VALUE, FIRST_VERSION)
)
  LOB (DEFINITION) STORE AS (TABLESPACE &EM_ECM_DEPOT_TABLESPACE ENABLE STORAGE IN ROW) MONITORING
;

CREATE TABLE MGMT_CM_BASELINE_OBJGRANTS
(
  BASELINE_GUID RAW(16) NOT NULL,
  FIRST_VERSION NUMBER NOT NULL,
  LAST_VERSION  NUMBER DEFAULT 99999 NOT NULL,
  GRANTEE_NAME  VARCHAR2(30) NOT NULL,
  OBJ_OWNER     VARCHAR2(30) NOT NULL,
  OBJ_NAME      VARCHAR2(30) NOT NULL,
  COL_NAME      VARCHAR2(30),
  GRANTOR_NAME  VARCHAR2(30) NOT NULL,
  PRIVILEGE     VARCHAR2(40) NOT NULL,
  FLAG          NUMBER,
  CONSTRAINT MGMT_CM_BASELINE_OBJGRANTS_FK
    FOREIGN KEY (BASELINE_GUID) 
    REFERENCES MGMT_CM_BASELINES (BASELINE_GUID)
    ON DELETE CASCADE,
  CONSTRAINT MGMT_CM_BASELINE_OBJGRANTS_UC
    UNIQUE (BASELINE_GUID, GRANTEE_NAME, OBJ_OWNER, 
         OBJ_NAME, COL_NAME, GRANTOR_NAME, PRIVILEGE, FIRST_VERSION)
) MONITORING
;

CREATE TABLE MGMT_CM_BASELINE_SYSGRANTS
(
  BASELINE_GUID RAW(16) NOT NULL,
  FIRST_VERSION NUMBER NOT NULL,
  LAST_VERSION  NUMBER DEFAULT 99999 NOT NULL,
  GRANTEE_NAME  VARCHAR2(30) NOT NULL,
  PRIVILEGE     VARCHAR2(40) NOT NULL,
  FLAG          NUMBER,
  CONSTRAINT MGMT_CM_BASELINE_SYSGRANTS_FK
    FOREIGN KEY (BASELINE_GUID) 
    REFERENCES MGMT_CM_BASELINES (BASELINE_GUID)
    ON DELETE CASCADE,
  CONSTRAINT MGMT_CM_BASELINE_SYSGRANTS_UC
    UNIQUE (BASELINE_GUID, GRANTEE_NAME, PRIVILEGE, FIRST_VERSION)
) MONITORING
;

CREATE TABLE MGMT_CM_BASELINE_ROLEGRANTS
(
  BASELINE_GUID RAW(16) NOT NULL,
  FIRST_VERSION NUMBER NOT NULL,
  LAST_VERSION  NUMBER DEFAULT 99999 NOT NULL,
  GRANTEE_NAME  VARCHAR2(30) NOT NULL,
  ROLEPRIV      VARCHAR2(30) NOT NULL,
  FLAG          NUMBER,
  CONSTRAINT MGMT_CM_BASELINE_ROLEGRANTS_FK
    FOREIGN KEY (BASELINE_GUID) 
    REFERENCES MGMT_CM_BASELINES (BASELINE_GUID)
    ON DELETE CASCADE,
  CONSTRAINT MGMT_CM_BASELINE_ROLEGRANTS_UC
    UNIQUE (BASELINE_GUID, GRANTEE_NAME, ROLEPRIV, FIRST_VERSION)
) MONITORING
;

CREATE TABLE MGMT_CM_BASELINE_QUOTAGRANTS
(
  BASELINE_GUID RAW(16) NOT NULL,
  FIRST_VERSION NUMBER NOT NULL,
  LAST_VERSION  NUMBER DEFAULT 99999 NOT NULL,
  GRANTEE_NAME  VARCHAR2(30) NOT NULL,
  TABLESPACE    VARCHAR2(30) NOT NULL,
  MAXBYTES      NUMBER,
  CONSTRAINT MGMT_CM_BASELINE_QUOTGRNNTS_FK
    FOREIGN KEY (BASELINE_GUID) 
    REFERENCES MGMT_CM_BASELINES (BASELINE_GUID)
    ON DELETE CASCADE,
  CONSTRAINT MGMT_CM_BASELINE_QUOTGRNNTS_UC
    UNIQUE (BASELINE_GUID, GRANTEE_NAME, TABLESPACE, FIRST_VERSION)
) MONITORING
;

CREATE TABLE MGMT_CM_BASELINE_PROXYGRANTS
(
  BASELINE_GUID RAW(16) NOT NULL,
  FIRST_VERSION NUMBER NOT NULL,
  LAST_VERSION  NUMBER DEFAULT 99999 NOT NULL,
  GRANTEE_NAME  VARCHAR2(30) NOT NULL,
  PROXY_USER    VARCHAR2(30) NOT NULL,
  DIRECTION     NUMBER,  -- MGMT_CM.PROXY_USER or PROXIED_FOR_USER
  CONSTRAINT MGMT_CM_BASELINE_PROXGRNTS_FK
    FOREIGN KEY (BASELINE_GUID) 
    REFERENCES MGMT_CM_BASELINES (BASELINE_GUID)
    ON DELETE CASCADE,
  CONSTRAINT MGMT_CM_BASELINE_PROXGRNTS_UC
    UNIQUE (BASELINE_GUID, GRANTEE_NAME, PROXY_USER, FIRST_VERSION)
) MONITORING
;

CREATE TABLE MGMT_CM_BASELINE_CONS_GROUPS
(
  BASELINE_GUID RAW(16) NOT NULL,
  FIRST_VERSION NUMBER NOT NULL,
  LAST_VERSION  NUMBER DEFAULT 99999 NOT NULL,
  GRANTEE_NAME  VARCHAR2(30) NOT NULL,
  CONS_GROUP    VARCHAR2(30) NOT NULL,
  FLAG          NUMBER,  
  CONSTRAINT MGMT_CM_BASELINE_CONSGRPS_FK
    FOREIGN KEY (BASELINE_GUID) 
    REFERENCES MGMT_CM_BASELINES (BASELINE_GUID)
    ON DELETE CASCADE,
  CONSTRAINT MGMT_CM_BASELINE_CONSGRPS_UC
    UNIQUE (BASELINE_GUID, GRANTEE_NAME, CONS_GROUP, FIRST_VERSION)
) MONITORING
;

CREATE TABLE MGMT_CM_BASELINE_INIT_PARAMS
(
  BASELINE_GUID RAW(16) NOT NULL,
  FIRST_VERSION NUMBER NOT NULL,
  LAST_VERSION  NUMBER DEFAULT 99999 NOT NULL,
  PARAM_NAME    VARCHAR2(64) NOT NULL,
  PARAM_VALUE   VARCHAR2(4000),
  CONSTRAINT MGMT_CM_BASELINE_PARAMS_FK
    FOREIGN KEY (BASELINE_GUID) 
    REFERENCES MGMT_CM_BASELINES (BASELINE_GUID)
    ON DELETE CASCADE,
  CONSTRAINT MGMT_CM_BASELINE_PARAMS_UC
    UNIQUE (BASELINE_GUID, PARAM_NAME, FIRST_VERSION)
) MONITORING
;

-- Comparisons

CREATE TABLE MGMT_CM_COMPARISONS
(
  COMPARISON_GUID	RAW(16) DEFAULT SYS_GUID(),
  COMPARISON_OWNER	VARCHAR2(30) NOT NULL,  -- or GUID?
  COMPARISON_NAME	VARCHAR2(30) NOT NULL,
  COMPARISON_SS	RAW(16) NOT NULL,
  DESCRIPTION           VARCHAR2(2000),    -- description of comparison
  JOB_ID                RAW(16),
  LEFT_TYPE		VARCHAR2(1) NOT NULL, -- 'B' OR 'D'
  LEFT_ID		RAW(16) NOT NULL,
  LEFT_NAME		VARCHAR2(256) NOT NULL,
  LEFT_VERSION	NUMBER, -- When source is a baseline
  RIGHT_TYPE		VARCHAR2(1) NOT NULL, -- 'B' OR 'D'
  RIGHT_ID		RAW(16) NOT NULL,
  RIGHT_NAME		VARCHAR2(256) NOT NULL,
  RIGHT_VERSION	NUMBER, -- When source is a baseline
  CONSTRAINT MGMT_CM_COMPARISONS_PK PRIMARY KEY (COMPARISON_GUID),
  CONSTRAINT MGMT_CM_COMPARISONS_UC 
    UNIQUE (COMPARISON_OWNER, COMPARISON_NAME)
) MONITORING;

CREATE TABLE MGMT_CM_COMPARISON_VERSIONS
(
  COMPARISON_GUID		RAW(16) NOT NULL,
  COMPARISON_VERSION	NUMBER NOT NULL, -- Comparison version
  JOB_EXECUTION_ID      RAW(16),
  VERSION_STATUS        VARCHAR(3),
  LEFT_VERSION		NUMBER,  -- Actual baseline version used
  RIGHT_VERSION		NUMBER,  -- Actual baseline version used
  COMPARISON_TIME	DATE,
  TIMEZONE_REGION       VARCHAR2(64),
  CONSTRAINT MGMT_CM_COMPARISON_VERSIONS_FK
    FOREIGN KEY (COMPARISON_GUID) 
    REFERENCES MGMT_CM_COMPARISONS (COMPARISON_GUID)
    ON DELETE CASCADE,
  CONSTRAINT MGMT_CM_COMPARISON_VERSIONS_UC 
    UNIQUE(COMPARISON_GUID, COMPARISON_VERSION)
) MONITORING;

CREATE TABLE MGMT_CM_COMPARISON_OBJECTS
(
  COMPARISON_GUID	RAW(16) NOT NULL,
  OBJECT_TYPE		NUMBER NOT NULL,
  OBJECT_SCHEMA         VARCHAR2(30),  -- Left-side schema
  OBJECT_NAME		VARCHAR2(128) NOT NULL,  -- Left-side name
  OBJECT_LONGNAME	CLOB,
  FIRST_VERSION         NUMBER NOT NULL,
  LAST_VERSION          NUMBER DEFAULT 99999 NOT NULL,
  LAST_LEFT_DDL_TIME    DATE,
  LEFT_HASH_VALUE       CHAR(32),
  LAST_RIGHT_DDL_TIME   DATE,
  RIGHT_HASH_VALUE      CHAR(32),
  GRANTS_DIFF_HASH      CHAR(32),
  STATE                 NUMBER NOT NULL,
  ANNOTATION_GUID       RAW(16),
  IGNORED               NUMBER(1) DEFAULT 0,
  DIFFERENCES		BLOB,
  COMMENTS_DIFF_HASH    CHAR(32),
  CONSTRAINT MGMT_CM_COMPARISON_OBJECTS_FK
    FOREIGN KEY (COMPARISON_GUID) 
    REFERENCES MGMT_CM_COMPARISONS (COMPARISON_GUID)
    ON DELETE CASCADE,
  CONSTRAINT MGMT_CM_COMPARISON_OBJECT_UC
    UNIQUE (COMPARISON_GUID, OBJECT_TYPE, 
            OBJECT_SCHEMA, OBJECT_NAME, FIRST_VERSION)
)
  LOB (OBJECT_LONGNAME) STORE AS (TABLESPACE &EM_ECM_DEPOT_TABLESPACE ENABLE STORAGE IN ROW) MONITORING,
  LOB (DIFFERENCES) STORE AS (TABLESPACE &EM_ECM_DEPOT_TABLESPACE ENABLE STORAGE IN ROW) MONITORING
;

CREATE TABLE MGMT_CM_COMPARISON_INIT_PRMS
(
  COMPARISON_GUID	RAW(16) NOT NULL,
  FIRST_VERSION NUMBER NOT NULL,
  LAST_VERSION  NUMBER DEFAULT 99999 NOT NULL,
  PARAM_NAME    VARCHAR2(64) NOT NULL,
  STATE			NUMBER NOT NULL,
  LEFT_PARAM_VALUE   VARCHAR2(4000),
  RIGHT_PARAM_VALUE   VARCHAR2(4000),
  CONSTRAINT MGMT_CM_COMPARISON_INITP_FK
    FOREIGN KEY (COMPARISON_GUID) 
    REFERENCES MGMT_CM_COMPARISONS (COMPARISON_GUID)
    ON DELETE CASCADE,
  CONSTRAINT MGMT_CM_COMPARISON_INITP_UC
    UNIQUE (COMPARISON_GUID, PARAM_NAME, FIRST_VERSION)
)
;
 
CREATE TABLE MGMT_CM_SCHEMA_MAPS
(
  OWNER_ID		RAW(16) NOT NULL,
  LEFT_SCHEMA		VARCHAR2(30) NOT NULL,
  RIGHT_SCHEMA	VARCHAR2(30) NOT NULL,
  CONSTRAINT MGMT_CM_SCHMPS_LEFT_UC UNIQUE (OWNER_ID, LEFT_SCHEMA),
  CONSTRAINT MGMT_CM_SCHMPS_RIGHT_UC UNIQUE (OWNER_ID, RIGHT_SCHEMA)
) MONITORING;
