Rem
Rem $Header: db_policies.sql 14-jan-2007.01:10:20 manosing Exp $
Rem
Rem db_policies.sql
Rem
Rem Copyright (c) 2006, 2007, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      db_policies.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    manosing    01/12/07 - XbranchMerge manosing_lastpols from main
Rem    dsukhwal    01/06/07 - XbranchMerge manosing_ntpol from main
Rem    manosing    01/09/07 - Translation changes
Rem    manosing    12/04/06 - add windows NT 10.2.0.4 policies
Rem    manosing    10/11/06 - ESA database policies for 10.2.0.4GC
Rem    dsukhwal    10/17/06 - Created
Rem


SET ESCAPE '\' ;
SET ESCAPE ON ;
DECLARE
 -- Metric Variable
 l_metric_column_list                              MGMT_METRIC_COLUMN_ARRAY;
 l_metric_type                         NUMBER ;
 l_snapshot_list                       MGMT_SNAPSHOT_ARRAY;
 l_snapshot_list_rac                   MGMT_SNAPSHOT_ARRAY;
 l_snapshot_list_inst_10gR1               MGMT_SNAPSHOT_ARRAY;
 l_snapshot_list_inst_10gR2               MGMT_SNAPSHOT_ARRAY;
 -- Policy Variable
 l_ctxList                              MGMT_VIOL_CTXT_DEF_ARRAY;
 l_paramDefList                         MGMT_POLICY_PARAM_DEF_ARRAY;
 l_defaultParamValList                  MGMT_POLICY_PARAM_VAL_ARRAY;
 l_defaultSettingsList                  MGMT_POLICY_KEY_VAL_ARRAY;
 l_auto_enable                          NUMBER ;    
 l_10gR1_db_meta_ver                    VARCHAR2(3) ; 
 l_10gR1_db_end_meta_ver                VARCHAR2(4) ; 
 l_valid_if_list                        MGMT_VALIDIF_ARRAY ;
 l_rac_database                         CONSTANT VARCHAR2(12) := 'rac_database';
 
 -- New snapshot name for the instance specific oracle_security metrics is oracle_security_inst
 l_oracle_security_inst                 CONSTANT VARCHAR2(20) := 'oracle_security_inst';
 
BEGIN

  l_10gR1_db_meta_ver := '3.0' ;
  l_10gR1_db_end_meta_ver := '3.99' ;
  l_metric_type := MGMT_GLOBAL.G_METRIC_TYPE_TABLE ;
  l_snapshot_list := MGMT_SNAPSHOT_ARRAY(
        MGMT_SNAPSHOT_OBJ.NEW(
                p_target_type => ESM.DB_TARGET_TYPE,
                p_snapshot_name => ESM.SECURITY_SNAPSHOT_TYPE));
  
  l_snapshot_list_rac := MGMT_SNAPSHOT_ARRAY(
        MGMT_SNAPSHOT_OBJ.NEW(
                p_target_type   => l_rac_database,
                p_snapshot_name => ESM.SECURITY_SNAPSHOT_TYPE));

 
  -- This snapshot list is prepared for all the db instance 
  -- security metrics which are applicable For both 10gR1 + 10gR2.
  -- In 10gR2 release oracle_security snapshot name has split up into two
  -- oracle_security + oracle_security_int(all db instance security metric used this)
  -- oracle_security_inst snapshot name is included in the snapshot list
  -- bcoz 10gR2 agent will upload the instance data with this snapshot name 
  -- Snapshot name used by 10gR1 agent remains same so included to support the 
  -- backward compatibility as 10gR1 agent uploads the data for 
  -- those metric with oracle_security snapshot name.


  l_snapshot_list_inst_10gR1 := MGMT_SNAPSHOT_ARRAY(
        MGMT_SNAPSHOT_OBJ.NEW(
                p_target_type   => ESM.DB_TARGET_TYPE,
                p_snapshot_name => l_oracle_security_inst),
        MGMT_SNAPSHOT_OBJ.NEW(
                p_target_type   => ESM.DB_TARGET_TYPE,
                p_snapshot_name => ESM.SECURITY_SNAPSHOT_TYPE));
 
  -- for 10gR2 db instance specific metrics => this is oracle_security_inst
  l_snapshot_list_inst_10gR2 := MGMT_SNAPSHOT_ARRAY(
        MGMT_SNAPSHOT_OBJ.NEW(
                p_target_type   => ESM.DB_TARGET_TYPE,
                p_snapshot_name => l_oracle_security_inst));


 
l_valid_if_list := MGMT_VALIDIF_ARRAY(
       MGMT_VALIDIF_OBJ.NEW(
            p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY(' '))
 );
 l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'users',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Users',
                p_column_label_nlsid =>'USERS_COL'),
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'file_name',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'OH File (Absolute Path)',
                p_column_label_nlsid =>'OH_FILE_COL'),
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'dummy',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'Dummy',
                p_column_label_nlsid =>'DUMMY_COL'));
  MGMT_METRIC.CREATE_METRIC(
      p_target_type => ESM.DB_TARGET_TYPE,
      p_metric_name =>     'ohFilesPermissionRepNT',
      p_type_meta_ver => ESM.DB_TYPE_META_VERSION,
      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type, 
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,               
      p_metric_label => 'Permission of Files and Folders in OH Folder',
      p_metric_label_nlsid => 'OH_FILE_PERM_METRIC_LABEL',
      p_description  => 'Collect permissions of all files and directories '||
                 'except bin directory in oralcehome folder',
      p_description_nlsid => 'OH_FILE_PERM_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE ,     
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source =>'SELECT target_guid,value as users, '
                 ||'value2 as file_name,value2 as dummy FROM esm_collection_latest  '
                 ||'WHERE property=''nt_oh_files_perm''',
      p_snapshot_name_list => l_snapshot_list_inst_10gR2,
      p_metric_column_list => l_metric_column_list  
 ) ;
COMMIT ;
-------Metric ohFilesPermissionRepWINDOWS End---------------------------
-----------Policy Oracle_Home_File_Permission WINDOWS Start--------------
--Policy
  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'users'),
        MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'file_name'));
 l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));
ESM.CREATE_POLICY(
  p_target_type => ESM.DB_TARGET_TYPE,
  p_policy_name =>'Oracle_Home_File_PermissionNT',   --Policy name
  p_metric_name =>'ohFilesPermissionRepNT',      --Metric name
  p_policy_label_nlsid =>'OH_FILEPERM_NAME_NT', 
  p_description =>'Ensures that all files in the ORACLE_HOME directories (except for ORACLE_HOME/bin) do not have public read, write and  execute permissions',
  p_description_nlsid =>'OH_FILEPERM_DESC',
  p_impact => 'Incorrect file permissions on some of the Oracle files can cause major security issues.',
  p_impact_nlsid =>'OH_FILEPERM_IMPACT',
  p_recommendation =>'Restrict permissions to all files in the ORACLE_HOME directories (except for ORACLE_HOME/bin) to the owner of the Oracle software set and DBA group. Do not give read, write, and execute permissions to public.',
  p_recommendation_nlsid =>'OH_FILEPERM_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_WARNING,
  p_condition_type => MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition => 'rownum > 0',
  p_message =>'Database is in an insecure state. Users %users% have critical permissions on the file (%file_name%).',
  p_message_nlsid => 'OH_FILEPERM_NT_MESG',
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver => ESM.DB_TYPE_META_VERSION,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList    
);
COMMIT ;
-----------Policy Oracle_Home_File_Permission WINDOWSEnd--------------






l_valid_if_list := MGMT_VALIDIF_ARRAY(
       MGMT_VALIDIF_OBJ.NEW(
            p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY('DB'))
 );
 l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
    MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'account',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Account',
                p_column_label_nlsid =>'ACCOUNT_COL'),    
   MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'dummy',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'Dummy',
                p_column_label_nlsid =>'DUMMY_COL'));

  MGMT_METRIC.CREATE_METRIC(
      p_target_type => ESM.DB_TARGET_TYPE,
      p_metric_name => 'proxyAcctRep',
      p_type_meta_ver => ESM.DB_TYPE_META_VERSION,
      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type, 
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT, 
      p_metric_label => 'proxy_account',
      p_metric_label_nlsid => 'PROXY_ACCOUNT_LABEL',
      p_description  => 'Collect proxy acounts with privilege other than CREATE SESSION',
      p_description_nlsid => 'PROXY_ACCOUNT_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE ,     
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source =>'SELECT target_guid, value as account, value2 as dummy '
                 ||'FROM esm_collection_latest '
                 ||'WHERE  property =''proxy_account''',
      p_snapshot_name_list => l_snapshot_list,
      p_metric_column_list => l_metric_column_list  
 ) ;
COMMIT ;
  MGMT_METRIC.CREATE_METRIC(
      p_target_type => 'rac_database',
      p_metric_name => 'proxyAcctRep',
      p_type_meta_ver => ESM.DB_TYPE_META_VERSION,
      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type, 
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,
      p_metric_label => 'proxy_account',
      p_metric_label_nlsid => 'PROXY_ACCOUNT_LABEL',
      p_description  => 'Collect proxy acounts with privilege other than CREATE SESSION',
      p_description_nlsid => 'PROXY_ACCOUNT_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE ,     
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source =>'SELECT target_guid, value as account, value2 as dummy '
                 ||'FROM esm_collection_latest '
                 ||'WHERE  property =''proxy_account''',
      p_snapshot_name_list => l_snapshot_list,
      p_metric_column_list => l_metric_column_list  
 ) ;
COMMIT ;


  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(
                 p_metric_column => 'account',
                 p_url_link_template =>'database/security/user?oname=^account^\&event=edit\&otype=USER\&target=^TARGET_NAME^\&type=^TARGET_TYPE^\&cancelURL=^CANCEL_URL^',
                 p_url_link_type => MGMT_POLICY.G_URL_TYPE_JSP));
  l_defaultParamValList := MGMT_POLICY_PARAM_VAL_ARRAY(
        MGMT_POLICY_PARAM_VAL.NEW(
                p_param_name => 'ACCOUNT_LIST',
                p_warn_threshold => ''));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL,
                p_param_values => l_defaultParamValList));



                
 ESM.CREATE_POLICY(
  p_target_type => ESM.DB_TARGET_TYPE,
  p_policy_name =>'Proxy_Account',   --Policy name
  p_metric_name =>'proxyAcctRep',      --Metric name
  p_policy_label_nlsid =>'PROXY_ACCOUNT_NAME',    
  p_description =>'Ensures that the proxy accounts have limited privileges',
  p_description_nlsid =>'PROXY_ACCOUNT_DESC',
  p_impact => 'The proxy user only needs to connect to the database. Once connected it will use the privileges of the user it is connecting on behalf of. Granting any other privilege than the CREATE SESSION privilege to the proxy user is unnecessary and open to misuse.',
  p_impact_nlsid =>'PROXY_ACCOUNT_IMPACT',
  p_recommendation =>'Limit the privileges of the proxy accounts to CREATE SESSION.',
  p_recommendation_nlsid =>'PROXY_ACCOUNT_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_WARNING,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition => 'rownum > 0',
  p_message =>'The database may be in an insecure state as the proxy user %account% has privileges other than CREATE SESSION.',
  p_message_nlsid =>'PROXY_ACCOUNT_MESG',
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver => ESM.DB_TYPE_META_VERSION,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList
);
COMMIT ;
 ESM.CREATE_POLICY(
  p_target_type => 'rac_database',
  p_policy_name =>'Proxy_Account',   --Policy name
  p_metric_name =>'proxyAcctRep',      --Metric name
  p_policy_label_nlsid =>'PROXY_ACCOUNT_NAME',    
  p_description =>'Ensures that the proxy accounts have limited privileges',
  p_description_nlsid =>'PROXY_ACCOUNT_DESC',
  p_impact => 'The proxy user only needs to connect to the database. Once connected it will use the privileges of the user it is connecting on behalf of. Granting any other privilege than the CREATE SESSION privilege to the proxy user is unnecessary and open to misuse.',
  p_impact_nlsid =>'PROXY_ACCOUNT_IMPACT',
  p_recommendation =>'Limit the privileges of the proxy accounts to CREATE SESSION.',
  p_recommendation_nlsid =>'PROXY_ACCOUNT_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_WARNING,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition => 'rownum > 0',
  p_message =>'The database may be in an insecure state as the proxy user %account% has privileges other than CREATE SESSION..',
  p_message_nlsid =>'PROXY_ACCOUNT_MESG',
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver => ESM.DB_TYPE_META_VERSION,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList
);
COMMIT ;

--tkrpof
  l_valid_if_list := MGMT_VALIDIF_ARRAY(
       MGMT_VALIDIF_OBJ.NEW(
            p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY(' ')));
 l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
       MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'permission',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Permission ',
                p_column_label_nlsid =>'PERM_COL'),
       MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'filename',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Filename',
                p_column_label_nlsid =>'FILE_NAME_COL'), 
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'dummy',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'DUMMY',
                p_column_label_nlsid =>'DUMMY_COL'));

  MGMT_METRIC.CREATE_METRIC(
      p_target_type => ESM.DB_TARGET_TYPE,
      p_metric_name => 'tkprofRep',    
      p_type_meta_ver => ESM.DB_TYPE_META_VERSION,
      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type, 
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,                
      p_metric_label => 'tkprof  Permission', 
      p_metric_label_nlsid => 'TKPROF_METRIC_LABEL',
      p_description  => 'Collect permissions of  tkprof file',
      p_description_nlsid => 'TKPROF_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE ,
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT target_guid, value as permission, '
                 ||'value2 as filename, value as dummy FROM esm_collection_latest  '
                 ||'WHERE property=''tkprof_perm''', 
      p_snapshot_name_list => l_snapshot_list_inst_10gR2,
      p_metric_column_list => l_metric_column_list  
 );
COMMIT;


-- Policy
  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'permission'),
 MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'filename'));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));

 ESM.CREATE_POLICY(
  p_target_type => ESM.DB_TARGET_TYPE,
  p_policy_name =>'tkprof',   --Policy name
  p_metric_name =>'tkprofRep',      --Metric name
  p_policy_label_nlsid =>'TKPROF_NAME', 
  p_description =>'Ensures tkprof executable file permissions are restricted to read and execute for the group, and inaccessible to public',
  p_description_nlsid =>'TKPROF_DESC',
  p_impact => 'Excessive permission for tkprof leaves information within, unprotected.',
  p_impact_nlsid =>'TKPROF_IMPACT',
  p_recommendation =>'Remove tkprof executable if not required. Otherwise, file permissions for tkprof executable should be restricted to read and execute for the group, and inaccessible to public.',
  p_recommendation_nlsid =>'TKPROF_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_WARNING,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'rownum > 0',
  p_message =>'System  is in an insecure state. The tkprof executable has %permission% permission.',
  p_message_nlsid =>'TKPROF_MESG',
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver => ESM.DB_TYPE_META_VERSION,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList    
);
COMMIT ;

--tkprof_owner
  l_valid_if_list := MGMT_VALIDIF_ARRAY(
       MGMT_VALIDIF_OBJ.NEW(
            p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY(' ')));
 l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
       MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'owner',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Owner ',
                p_column_label_nlsid =>'FILE_OWNER_COL'),
       MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'filename',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Filename',
                p_column_label_nlsid =>'FILE_NAME_COL'), 
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'dummy',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'DUMMY',
                p_column_label_nlsid =>'DUMMY_COL'));

  MGMT_METRIC.CREATE_METRIC(
      p_target_type => ESM.DB_TARGET_TYPE,
      p_metric_name => 'tkprofOwnerRep',    
      p_type_meta_ver => ESM.DB_TYPE_META_VERSION,
      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type, 
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,                
      p_metric_label => 'tkprof  Owner', 
      p_metric_label_nlsid => 'TKPROF_OWNER_METRIC_LABEL',
      p_description  => 'Collect  owner of  tkprof file',
      p_description_nlsid => 'TKPROF_OWNER_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE ,
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT target_guid, value as owner, '
                 ||'value2 as filename, value as dummy FROM esm_collection_latest  '
                 ||'WHERE property=''tkprof_owner''', 
      p_snapshot_name_list => l_snapshot_list_inst_10gR2,
      p_metric_column_list => l_metric_column_list  
 );
COMMIT;

-- Policy
  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'owner'),
 MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'filename'));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));

 ESM.CREATE_POLICY(
  p_target_type => ESM.DB_TARGET_TYPE,
  p_policy_name =>'tkprof_owner',   --Policy name
  p_metric_name =>'tkprofOwnerRep',      --Metric name
  p_policy_label_nlsid =>'TKPROF_OWNER_NAME', 
  p_description =>'Ensures tkprof executable file is owned by Oracle software owner',
  p_description_nlsid =>'TKPROF_OWNER_DESC',
  p_impact => 'Not restricting ownership of tkprof to the Oracle software set and DBA group may cause information leak.',
  p_impact_nlsid =>'TKPROF_OWNER_IMPACT',
  p_recommendation =>'Restrict permissions of the tkprof executable to the owner of the Oracle software set and the DBA group.',
  p_recommendation_nlsid =>'TKPROF_OWNER_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_WARNING,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'rownum > 0',
  p_message =>'System  is in an insecure state. The tkprof executable owner is %owner%.',
  p_message_nlsid =>'TKPROF_OWNER_MESG',
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver => ESM.DB_TYPE_META_VERSION,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList    
);
COMMIT ;



--otrace


  l_valid_if_list := MGMT_VALIDIF_ARRAY(
       MGMT_VALIDIF_OBJ.NEW(
            p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY(' ')));
 l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
       MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'existence',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Existence',
                p_column_label_nlsid =>'OTRACE_FILE_COL'),
           MGMT_METRIC_COLUMN_OBJ.NEW(
            p_column_name => 'dummy',  
            p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING, 
               p_is_key => MGMT_GLOBAL.G_FALSE, 
            p_column_label => 'Dummy',  
            p_column_label_nlsid =>'DUMMY_COL'));

  MGMT_METRIC.CREATE_METRIC(
      p_target_type => ESM.DB_TARGET_TYPE,
      p_metric_name => 'otraceRep',    
      p_type_meta_ver => ESM.DB_TYPE_META_VERSION,
      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type, 
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,                
      p_metric_label => 'otrace *.dat files', 
      p_metric_label_nlsid => 'OTRACE_METRIC_LABEL',
      p_description  => 'Collect existence *.dat files in otrace dir',
      p_description_nlsid => 'OTRACE_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE ,
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT target_guid, value as existence, value as dummy '
                 ||' FROM esm_collection_latest  '
                 ||'WHERE property=''otrace''', 
      p_snapshot_name_list => l_snapshot_list_inst_10gR2,
      p_metric_column_list => l_metric_column_list  
 );
COMMIT ;


-- Policy
  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'existence'));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));

 ESM.CREATE_POLICY(
  p_target_type => ESM.DB_TARGET_TYPE,
  p_policy_name =>'otrace',   --Policy name
  p_metric_name =>'otraceRep',      --Metric name
  p_policy_label_nlsid =>'OTRACE_NAME', 
  p_description =>'Avoids negative impact on database performance and disk space usage, caused by data collected by otrace',
  p_description_nlsid =>'OTRACE_DESC',
  p_impact => 'Performance and resource utilization data collection can have a negative impact on database performance and disk space usage.',
  p_impact_nlsid =>'OTRACE_IMPACT',
  p_recommendation =>'Otrace should be disabled',
  p_recommendation_nlsid =>'OTRACE_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_WARNING,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'rownum > 0',
  p_message =>'System  is in an insecure state. There exist log file[s] created by otrace, they can be source for unwanted information leak .',
  p_message_nlsid =>'OTRACE_MESG',
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver => ESM.DB_TYPE_META_VERSION,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList    
);
COMMIT ;

--------------->>sqlplus perm<<-------------------------

  l_valid_if_list := MGMT_VALIDIF_ARRAY(
       MGMT_VALIDIF_OBJ.NEW(
            p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY(' '))); --must be conformed by devesh
 l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
       MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'permission',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Permission ',
                p_column_label_nlsid =>'PERM_COL'),
       MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'filename',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Filename',
                p_column_label_nlsid =>'FILE_NAME_COL'), 
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'dummy',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'Dummy',
                p_column_label_nlsid =>'DUMMY_COL'));

  MGMT_METRIC.CREATE_METRIC(
      p_target_type => ESM.DB_TARGET_TYPE,
      p_metric_name => 'sqlplusRep',    
      p_type_meta_ver => ESM.DB_TYPE_META_VERSION,
      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type, 
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,                
      p_metric_label => 'sqlplus  Permission', 
      p_metric_label_nlsid => 'SQLPLUS_METRIC_LABEL',
      p_description  => 'Collect permissions  sqlplus executable file',
      p_description_nlsid => 'SQLPLUS_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE ,
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT target_guid, value as permission, '
                 ||'value2 as filename, value as dummy  FROM esm_collection_latest  '
                 ||'WHERE property=''sqlplus_perm''', 
      p_snapshot_name_list => l_snapshot_list_inst_10gR2,
      p_metric_column_list => l_metric_column_list  
 );
COMMIT ;

-- Policy
  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'permission'),
 MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'filename'));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));


 ESM.CREATE_POLICY(
  p_target_type => ESM.DB_TARGET_TYPE,
  p_policy_name =>'sqlplus',   --Policy name
  p_metric_name =>'sqlplusRep',      --Metric name
  p_policy_label_nlsid =>'SQLPLUS_NAME', 
  p_description =>'Ensures that SQL*Plus executable file permissions are limited to the Oracle software set and DBA group',
  p_description_nlsid =>'SQLPLUS_DESC',
  p_impact => 'SQL*Plus allows a user to execute any SQL on the database provided the user has an account with appropriate privileges. Public execute permissions on SQL*Plus can cause security issues by exposing sensitive data to malicious users.',
  p_impact_nlsid =>'SQLPLUS_IMPACT',
  p_recommendation =>'Restrict file permissions for SQL*Plus executable to the Oracle software set and DBA group.',
  p_recommendation_nlsid =>'SQLPLUS_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_WARNING,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'rownum > 0',
  p_message =>'System is in an insecure state. SQL*Plus permission is %permission%',
  p_message_nlsid =>'SQLPLUS_MESG',
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver => ESM.DB_TYPE_META_VERSION,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList    
);
COMMIT ;

---------------<<sqlplus perm>>-------------------------

--------------->>sqlplus owner<<-------------------------

--tkprof_owner
  l_valid_if_list := MGMT_VALIDIF_ARRAY(
       MGMT_VALIDIF_OBJ.NEW(
            p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY(' ')));
 l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
       MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'owner',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Owner ',
                p_column_label_nlsid =>'FILE_OWNER_COL'),
       MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'filename',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Filename',
                p_column_label_nlsid =>'FILE_NAME_COL'), 
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'dummy',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'DUMMY',
                p_column_label_nlsid =>'DUMMY_COL'));

  MGMT_METRIC.CREATE_METRIC(
      p_target_type => ESM.DB_TARGET_TYPE,
      p_metric_name => 'sqlplusOwnerRep',    
      p_type_meta_ver => ESM.DB_TYPE_META_VERSION,
      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type, 
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,                
      p_metric_label => 'sqlplus  Owner', 
      p_metric_label_nlsid => 'SQLPLUS_OWNER_METRIC_LABEL',
      p_description  => 'Collect  owner of  sqlplus file',
      p_description_nlsid => 'SQLPLUS_OWNER_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE ,
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT target_guid, value as owner, '
                 ||'value2 as filename, value as dummy FROM esm_collection_latest  '
                 ||'WHERE property=''sqlplus_owner''', 
      p_snapshot_name_list => l_snapshot_list_inst_10gR2,
      p_metric_column_list => l_metric_column_list  
 );
COMMIT;

-- Policy
  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'owner'),
 MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'filename'));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));

 ESM.CREATE_POLICY(
  p_target_type => ESM.DB_TARGET_TYPE,
  p_policy_name =>'sqlplus_owner',   --Policy name
  p_metric_name =>'sqlplusOwnerRep',      --Metric name
  p_policy_label_nlsid =>'SQLPLUS_OWNER_NAME', 
  p_description =>'Ensures SQL*Plus ownership is restricted to the Oracle software set and DBA group',
  p_description_nlsid =>'SQLPLUS_OWNER_DESC',
  p_impact => 'SQL*Plus allows a user to execute any SQL on the database provided the user has an account with appropriate privileges. Not restricting ownership of SQL*Plus to the Oracle software set and DBA group may cause security issues by exposing sensitive data to malicious users.',
  p_impact_nlsid =>'SQLPLUS_OWNER_IMPACT',
  p_recommendation =>'Restrict SQL*Plus ownership to the Oracle software set and DBA group.',
  p_recommendation_nlsid =>'SQLPLUS_OWNER_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_WARNING,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'rownum > 0',
  p_message =>'System is in an insecure state. The SQL*Plus owner is %owner%.',
  p_message_nlsid =>'SQLPLUS_OWNER_MESG',
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver => ESM.DB_TYPE_META_VERSION,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList    
);
COMMIT ;

---------------<<sqlplus owner>>-------------------------



--------------->>WEBCACHE<<-------------------------
  l_valid_if_list := MGMT_VALIDIF_ARRAY(
       MGMT_VALIDIF_OBJ.NEW(
            p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY(' ')));
 l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
       MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'permission',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Permission ',
                p_column_label_nlsid =>'PERM_COL'),
       MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'filename',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Filename',
                p_column_label_nlsid =>'FILE_NAME_COL'), 
       MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'dummy',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'DUMMY',
                p_column_label_nlsid =>'DUMMY_COL'));

  MGMT_METRIC.CREATE_METRIC(
      p_target_type => ESM.DB_TARGET_TYPE,
      p_metric_name => 'webcacheRep',    
      p_type_meta_ver => ESM.DB_TYPE_META_VERSION,
      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type, 
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,                
      p_metric_label => 'webcache  Permission', 
      p_metric_label_nlsid => 'WEBCACHE_METRIC_LABEL',
      p_description  => 'Collect permissions of  webcache.xml file',
      p_description_nlsid => 'WEBCACHE_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE ,
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT target_guid, value as permission, '
                 ||'value2 as filename, value as dummy FROM esm_collection_latest  '
                 ||'WHERE property=''webcache_perm''', 
      p_snapshot_name_list => l_snapshot_list_inst_10gR2,
      p_metric_column_list => l_metric_column_list  
 );

COMMIT;


-- Policy
  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'permission'),
 MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'filename'));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));

 ESM.CREATE_POLICY(
  p_target_type => ESM.DB_TARGET_TYPE,
  p_policy_name =>'Webcache',   --Policy name
  p_metric_name =>'webcacheRep',      --Metric name
  p_policy_label_nlsid =>'WEBCACHE_NAME', 
  p_description =>'Ensures the Webcache initialization file (webcache.xml) permissions are limited to the Oracle software set and DBA group',
  p_description_nlsid =>'WEBCACHE_DESC',
  p_impact => 'Webcache stores sensitive information in the initialization file (webcache.xml). A publicly accessible Webcache initialization file can be used to extract sensitive data like the administrator password hash.',
  p_impact_nlsid =>'WEBCACHE_IMPACT',
  p_recommendation =>'Restrict Webcache initialization file (webcache.xml) access to the Oracle software set and DBA group.',
  p_recommendation_nlsid =>'WEBCACHE_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_WARNING,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'rownum > 0',
  p_message =>'System is in an insecure state. The Webcache initialization file (webcache.xml) has %permission% permission.',
  p_message_nlsid =>'WEBCACHE_MESG',
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver => ESM.DB_TYPE_META_VERSION,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList    
);
COMMIT ;

---------------<<WEBCACHE>>-------------------------


---------------<<SNMP_RO>>-------------------------
  l_valid_if_list := MGMT_VALIDIF_ARRAY(
       MGMT_VALIDIF_OBJ.NEW(
            p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY(' ')));
 l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
       MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'permission',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Permission ',
                p_column_label_nlsid =>'PERM_COL'),
       MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'filename',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Filename',
                p_column_label_nlsid =>'FILE_NAME_COL'), 
       MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'dummy',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'DUMMY',
                p_column_label_nlsid =>'DUMMY_COL'));

  MGMT_METRIC.CREATE_METRIC(
      p_target_type => ESM.DB_TARGET_TYPE,
      p_metric_name => 'snmp_roRep',    
      p_type_meta_ver => ESM.DB_TYPE_META_VERSION,
      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type, 
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,                
      p_metric_label => 'snmp_ro Permission', 
      p_metric_label_nlsid => 'SNMP_RO_METRIC_LABEL',
      p_description  => 'Collect permissions of  snmp_ro.ora file',
      p_description_nlsid => 'SNMP_RO_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE ,
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT target_guid, value as permission, '
                 ||'value2 as filename, value as dummy FROM esm_collection_latest  '
                 ||'WHERE property=''snmp_ro_perm''', 
      p_snapshot_name_list => l_snapshot_list_inst_10gR2,
      p_metric_column_list => l_metric_column_list  
 );

COMMIT;


-- Policy
  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'permission'),
 MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'filename'));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));

 ESM.CREATE_POLICY(
  p_target_type => ESM.DB_TARGET_TYPE,
  p_policy_name =>'Snmp_ro',   --Policy name
  p_metric_name =>'snmp_roRep',      --Metric name
  p_policy_label_nlsid =>'SNMP_RO_NAME', 
  p_description =>'Ensures Oracle Agent SNMP read-only configuration file (snmp_ro.ora) permissions are limited to the Oracle software set and DBA group',
  p_description_nlsid =>'SNMP_RO_DESC',
  p_impact => 'The Oracle Agent SNMP read-only configuration file (snmp_ro.ora) contains the listening address of the agent, the names of SQL*Net listener and Oracle database services it knows about, plus tracing parameters. A publicly accessible SNMP read-only configuration file can be used to extract sensitive data like the tracing directory location, dbsnmp address, etc.',
  p_impact_nlsid =>'SNMP_RO_IMPACT',
  p_recommendation =>'Restrict Oracle Agent SNMP read-only configuration file (snmp_ro.ora) access to the Oracle software set and DBA group.',
  p_recommendation_nlsid =>'SNMP_RO_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_WARNING,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'rownum > 0',
  p_message =>'System is in an insecure state. The Oracle Agent SNMP read-only configuration file (snmp_ro.ora) has %permission% permission.',
  p_message_nlsid =>'SNMP_RO_MESG',
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver => ESM.DB_TYPE_META_VERSION,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList    
);
COMMIT ;

---------------<<SNMP_RO>>-------------------------

---------------<<SNMP_RW>>-------------------------
  l_valid_if_list := MGMT_VALIDIF_ARRAY(
       MGMT_VALIDIF_OBJ.NEW(
            p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY(' ')));
 l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
       MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'permission',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Permission ',
                p_column_label_nlsid =>'PERM_COL'),
       MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'filename',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Filename',
                p_column_label_nlsid =>'FILE_NAME_COL'), 
       MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'dummy',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'DUMMY',
                p_column_label_nlsid =>'DUMMY_COL'));

  MGMT_METRIC.CREATE_METRIC(
      p_target_type => ESM.DB_TARGET_TYPE,
      p_metric_name => 'snmp_rwRep',    
      p_type_meta_ver => ESM.DB_TYPE_META_VERSION,
      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type, 
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,                
      p_metric_label => 'snmp_rw  Permission', 
      p_metric_label_nlsid => 'SNMP_RW_METRIC_LABEL',
      p_description  => 'Collect permissions of snmp_rw.ora file',
      p_description_nlsid => 'SNMP_RW_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE ,
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT target_guid, value as permission, '
                 ||'value2 as filename, value as dummy FROM esm_collection_latest  '
                 ||'WHERE property=''snmp_rw_perm''', 
      p_snapshot_name_list => l_snapshot_list_inst_10gR2,
      p_metric_column_list => l_metric_column_list  
 );

COMMIT;


-- Policy
  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'permission'),
 MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'filename'));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));

 ESM.CREATE_POLICY(
  p_target_type => ESM.DB_TARGET_TYPE,
  p_policy_name =>'Snmp_rw',   --Policy name
  p_metric_name =>'snmp_rwRep',      --Metric name
  p_policy_label_nlsid =>'SNMP_RW_NAME', 
  p_description =>'Ensures Oracle Agent SNMP read-write configuration file (snmp_rw.ora) permissions are limited to the Oracle software set and DBA group',
  p_description_nlsid =>'SNMP_RW_DESC',
  p_impact => 'The Oracle Agent SNMP read-write configuration file (snmp_rw.ora) contains the listening address of the agent, the names of SQL*Net listener and Oracle database services it knows about, plus tracing parameters. A publicly accessible SNMP read-write configuration file can be used to extract sensitive data like the tracing directory location, dbsnmp address, etc.',
  p_impact_nlsid =>'SNMP_RW_IMPACT',
  p_recommendation =>'Restrict Oracle Agent SNMP read-write configuration file (snmp_rw.ora) access to the Oracle software set and DBA group.',
  p_recommendation_nlsid =>'SNMP_RW_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_WARNING,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'rownum > 0',
  p_message =>'System is in an insecure state. The Oracle Agent SNMP read-write configuration file (snmp_rw.ora) has %permission% permission.',
  p_message_nlsid =>'SNMP_RW_MESG',
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver => ESM.DB_TYPE_META_VERSION,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList    
);
COMMIT ;

---------------<<SNMP_RW>>-------------------------

---------------<<WDBSVR>>-------------------------
  l_valid_if_list := MGMT_VALIDIF_ARRAY(
       MGMT_VALIDIF_OBJ.NEW(
            p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY(' ')));
 l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
       MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'permission',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Permission ',
                p_column_label_nlsid =>'PERM_COL'),
       MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'filename',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Filename',
                p_column_label_nlsid =>'FILE_NAME_COL'), 
       MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'dummy',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'DUMMY',
                p_column_label_nlsid =>'DUMMY_COL'));

  MGMT_METRIC.CREATE_METRIC(
      p_target_type => ESM.DB_TARGET_TYPE,
      p_metric_name => 'wdbsvrRep',    
      p_type_meta_ver => ESM.DB_TYPE_META_VERSION,
      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type, 
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,                
      p_metric_label => 'wdbsvr.app  Permission', 
      p_metric_label_nlsid => 'WDBSVR_METRIC_LABEL',
      p_description  => 'Collect permissions of  wdbsvr.app file',
      p_description_nlsid => 'WDBSVR_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE ,
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT target_guid, value as permission, '
                 ||'value2 as filename, value as dummy FROM esm_collection_latest  '
                 ||'WHERE property=''wdbsvr_perm''', 
      p_snapshot_name_list => l_snapshot_list_inst_10gR2,
      p_metric_column_list => l_metric_column_list  
 );

COMMIT;


-- Policy
  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'permission'),
 MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'filename'));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));

 ESM.CREATE_POLICY(
  p_target_type => ESM.DB_TARGET_TYPE,
  p_policy_name =>'Wdbsvr',   --Policy name
  p_metric_name =>'wdbsvrRep',      --Metric name
  p_policy_label_nlsid =>'WDBSVR_NAME', 
  p_description =>'Ensures Oracle HTTP Server mod_plsql Configuration file (wdbsvr.app) permissions are limited to the Oracle software set and DBA group',
  p_description_nlsid =>'WDBSVR_DESC',
  p_impact => 'The Oracle HTTP Server mod_plsql configuration file (wdbsvr.app) contains the Database Access Descriptors used for authentication. A publicly accessible mod_plsql configuration file can allow a malicious user to modify the Database Access Descriptor settings to gain access to PL/SQL applications or launch a Denial Of Service attack.',
  p_impact_nlsid =>'WDBSVR_IMPACT',
  p_recommendation =>'Restrict Oracle HTTP Server mod_plsql configuration file (wdbsvr.app) access to the Oracle software set and DBA group.',
  p_recommendation_nlsid =>'WDBSVR_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_WARNING,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'rownum > 0',
  p_message =>'System is in an insecure state. The Oracle HTTP Server mod_plsql configuration file (wdbsvr.app) has %permission% permission.',
  p_message_nlsid =>'WDBSVR_MESG',
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver => ESM.DB_TYPE_META_VERSION,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList    
);
COMMIT ;

---------------<<WDBSVR>>-------------------------

--------------->>XSQL<<-------------------------
  l_valid_if_list := MGMT_VALIDIF_ARRAY(
       MGMT_VALIDIF_OBJ.NEW(
            p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY(' ')));
 l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
       MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'permission',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Permission ',
                p_column_label_nlsid =>'PERM_COL'),
       MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'filename',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Filename',
                p_column_label_nlsid =>'FILE_NAME_COL'), 
       MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'dummy',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'DUMMY',
                p_column_label_nlsid =>'DUMMY_COL'));

  MGMT_METRIC.CREATE_METRIC(
      p_target_type => ESM.DB_TARGET_TYPE,
      p_metric_name => 'xsqlRep',    
      p_type_meta_ver => ESM.DB_TYPE_META_VERSION,
      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type, 
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,                
      p_metric_label => 'XSQLConfig.xml  Permission', 
      p_metric_label_nlsid => 'XSQL_METRIC_LABEL',
      p_description  => 'Collect permissions of  XSQLConfig.xml file',
      p_description_nlsid => 'XSQL_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE ,
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT target_guid, value as permission, '
                 ||'value2 as filename, value as dummy FROM esm_collection_latest  '
                 ||'WHERE property=''xsql_perm''', 
      p_snapshot_name_list => l_snapshot_list_inst_10gR2,
      p_metric_column_list => l_metric_column_list  
 );

COMMIT;


-- Policy
  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'permission'),
 MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'filename'));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));

 ESM.CREATE_POLICY(
  p_target_type => ESM.DB_TARGET_TYPE,
  p_policy_name =>'Xsql',   --Policy name
  p_metric_name =>'xsqlRep',      --Metric name
  p_policy_label_nlsid =>'XSQL_NAME', 
  p_description =>'Ensures Oracle XSQL configuration file (XSQLConfig.xml) permissions are limited to the Oracle software set and DBA group',
  p_description_nlsid =>'XSQL_DESC',
  p_impact => 'The Oracle XSQL configuration file (XSQLConfig.xml) contains sensitive database connection information. A publicly accessible XSQL configuration file can expose the database username and password that can be used access sensitive data or to launch further attacks.',
  p_impact_nlsid =>'XSQL_IMPACT',
  p_recommendation =>'Restrict Oracle XSQL configuration file (XSQLConfig.xml) access to the Oracle software set and DBA group.',
  p_recommendation_nlsid =>'XSQL_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_WARNING,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'rownum > 0',
  p_message =>'System is in an insecure state. The Oracle XSQL configuration file (XSQLConfig.xml) has %permission% permission.',
  p_message_nlsid =>'XSQL_MESG',
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver => ESM.DB_TYPE_META_VERSION,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList    
);
COMMIT ;
---------------<<XSQL>>-------------------------


  l_valid_if_list := MGMT_VALIDIF_ARRAY(
       MGMT_VALIDIF_OBJ.NEW(
            p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY(' ')));

 l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
       MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'owner',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Owner ',
                p_column_label_nlsid =>'FILE_OWNER_COL'),
       MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'filename',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Filename',
                p_column_label_nlsid =>'FILE_NAME_COL'), 
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'dummy',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'DUMMY',
                p_column_label_nlsid =>'DUMMY_COL'));

  MGMT_METRIC.CREATE_METRIC(
      p_target_type => ESM.DB_TARGET_TYPE,
      p_metric_name => 'webcacheOwnerRep',    
      p_type_meta_ver => ESM.DB_TYPE_META_VERSION,
      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type, 
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,                
      p_metric_label => 'webcache Owner', 
      p_metric_label_nlsid => 'WEBCACHE_OWNER_METRIC_LABEL',
      p_description  => 'Collect  owner of  webcache file',
      p_description_nlsid => 'WEBCACHE_OWNER_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE ,
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT target_guid, value as owner, '
                 ||'value2 as filename, value as dummy FROM esm_collection_latest  '
                 ||'WHERE property=''webcache_owner''', 
      p_snapshot_name_list => l_snapshot_list_inst_10gR2,
      p_metric_column_list => l_metric_column_list  
 );
COMMIT;

-- Policy
  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'owner'),
 MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'filename'));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));

 ESM.CREATE_POLICY(
  p_target_type => ESM.DB_TARGET_TYPE,
  p_policy_name =>'Webcache_Owner',   --Policy name
  p_metric_name =>'webcacheOwnerRep',      --Metric name
  p_policy_label_nlsid =>'WEBCACHE_OWNER_NAME', 
  p_description =>'Ensures Webcache initialization file (webcache.xml) is owned by Oracle software owner',
  p_description_nlsid =>'WEBCACHE_OWNER_DESC',
  p_impact => 'Webcache stores sensitive information in the initialization file (webcache.xml). A publicly accessible Webcache initialization file can be used to extract sensitive data like the administrator password hash.',
  p_impact_nlsid =>'WEBCACHE_OWNER_IMPACT',
  p_recommendation =>'Restrict permission of Webcache initialization file (webcache.xml) to the owner of Oracle software set and DBA group.',
  p_recommendation_nlsid =>'WEBCACHE_OWNER_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_WARNING,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'rownum > 0',
  p_message =>'System  is in an insecure state. The Webcache initialization file (webcache.xml) owner is %owner%.',
  p_message_nlsid =>'WEBCACHE_OWNER_MESG',
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver => ESM.DB_TYPE_META_VERSION,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList    
);
COMMIT ;


  l_valid_if_list := MGMT_VALIDIF_ARRAY(
       MGMT_VALIDIF_OBJ.NEW(
            p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY(' ')));

 l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
       MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'owner',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Owner ',
                p_column_label_nlsid =>'FILE_OWNER_COL'),
       MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'filename',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Filename',
                p_column_label_nlsid =>'FILE_NAME_COL'), 
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'dummy',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'DUMMY',
                p_column_label_nlsid =>'DUMMY_COL'));

  MGMT_METRIC.CREATE_METRIC(
      p_target_type => ESM.DB_TARGET_TYPE,
      p_metric_name => 'snmp_roOwnerRep',    
      p_type_meta_ver => ESM.DB_TYPE_META_VERSION,
      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type, 
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,                
      p_metric_label => 'snmp_ro.ora Owner', 
      p_metric_label_nlsid => 'SNMP_RO_OWNER_METRIC_LABEL',
      p_description  => 'Collect  owner of  snmp_ro.ora file',
      p_description_nlsid => 'SNMP_RO_OWNER_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE ,
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT target_guid, value as owner, '
                 ||'value2 as filename, value as dummy FROM esm_collection_latest  '
                 ||'WHERE property=''snmp_ro_owner''', 
      p_snapshot_name_list => l_snapshot_list_inst_10gR2,
      p_metric_column_list => l_metric_column_list  
 );
COMMIT;

-- Policy
  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'owner'),
 MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'filename'));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));

 ESM.CREATE_POLICY(
  p_target_type => ESM.DB_TARGET_TYPE,
  p_policy_name =>'Snmp_ro_Owner',   --Policy name
  p_metric_name =>'snmp_roOwnerRep',      --Metric name
  p_policy_label_nlsid =>'SNMP_RO_OWNER_NAME', 
  p_description =>'Ensures Oracle Agent SNMP read-only configuration file (snmp_ro.ora) is owned by Oracle software owner',
  p_description_nlsid =>'SNMP_RO_OWNER_DESC',
  p_impact => 'The Oracle Agent SNMP read-only configuration file (snmp_ro.ora) contains the listening address of the agent, the names of SQL*Net listener and Oracle database services it knows about, plus tracing parameters. A publicly accessible SNMP read-only configuration file can be used to extract sensitive data like the tracing directory location, dbsnmp address, etc.',
  p_impact_nlsid =>'SNMP_RO_OWNER_IMPACT',
  p_recommendation =>'Restrict permissions of Oracle Agent SNMP read-only configuration file (snmp_ro.ora) to the owner of Oracle software set and DBA group.',
  p_recommendation_nlsid =>'SNMP_RO_OWNER_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_WARNING,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'rownum > 0',
  p_message =>'System is in an insecure state. The Oracle Agent SNMP read-only configuration file (snmp_ro.ora) owner is %owner%.',
  p_message_nlsid =>'SNMP_RO_OWNER_MESG',
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver => ESM.DB_TYPE_META_VERSION,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList    
);
COMMIT ;




 
---------------<<SNMP_RW_OWNER>>-------------------------
  l_valid_if_list := MGMT_VALIDIF_ARRAY(
       MGMT_VALIDIF_OBJ.NEW(
            p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY(' ')));

 l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
       MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'owner',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Owner ',
                p_column_label_nlsid =>'FILE_OWNER_COL'),
       MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'filename',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Filename',
                p_column_label_nlsid =>'FILE_NAME_COL'), 
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'dummy',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'DUMMY',
                p_column_label_nlsid =>'DUMMY_COL'));

  MGMT_METRIC.CREATE_METRIC(
      p_target_type => ESM.DB_TARGET_TYPE,
      p_metric_name => 'snmp_rwOwnerRep',    
      p_type_meta_ver => ESM.DB_TYPE_META_VERSION,
      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type, 
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,                
      p_metric_label => 'snmp_rw.ora Owner', 
      p_metric_label_nlsid => 'SNMP_RW_OWNER_METRIC_LABEL',
      p_description  => 'Collect  owner of  snmp_rw.ora file',
      p_description_nlsid => 'SNMP_RW_OWNER_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE ,
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT target_guid, value as owner, '
                 ||'value2 as filename, value as dummy FROM esm_collection_latest  '
                 ||'WHERE property=''snmp_rw_owner''', 
      p_snapshot_name_list => l_snapshot_list_inst_10gR2,
      p_metric_column_list => l_metric_column_list  
 );
COMMIT;

-- Policy
  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'owner'),
 MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'filename'));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));

 ESM.CREATE_POLICY(
  p_target_type => ESM.DB_TARGET_TYPE,
  p_policy_name =>'Snmp_rw_Owner',   --Policy name
  p_metric_name =>'snmp_rwOwnerRep',      --Metric name
  p_policy_label_nlsid =>'SNMP_RW_OWNER_NAME', 
  p_description =>'Ensures Oracle Agent SNMP read-write configuration file (snmp_rw.ora) is owned by Oracle software owner',
  p_description_nlsid =>'SNMP_RW_OWNER_DESC',
  p_impact => 'The Oracle Agent SNMP read-write configuration file (snmp_rw.ora) contains the listening address of the agent, the names of SQL*Net listener and Oracle database services it knows about, plus tracing parameters. A publicly accessible SNMP read-write configuration file can be used to extract sensitive data like the tracing directory location, dbsnmp address, etc.',
  p_impact_nlsid =>'SNMP_RW_OWNER_IMPACT',
  p_recommendation =>'Restrict permissions of Oracle Agent SNMP read-write configuration file (snmp_rw.ora) to the owner of Oracle software set and DBA group',
  p_recommendation_nlsid =>'SNMP_RW_OWNER_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_WARNING,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'rownum > 0',
  p_message =>'System is in an insecure state. The Oracle Agent SNMP read-write configuration file (snmp_rw.ora) owner is %owner%.',
  p_message_nlsid =>'SNMP_RW_OWNER_MESG',
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver => ESM.DB_TYPE_META_VERSION,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList    
);
COMMIT ;




 
---------------<<WDBSVR_OWNER>>-------------------------
  l_valid_if_list := MGMT_VALIDIF_ARRAY(
       MGMT_VALIDIF_OBJ.NEW(
            p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY(' ')));

 l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
       MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'owner',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Owner ',
                p_column_label_nlsid =>'FILE_OWNER_COL'),
       MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'filename',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Filename',
                p_column_label_nlsid =>'FILE_NAME_COL'), 
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'dummy',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'DUMMY',
                p_column_label_nlsid =>'DUMMY_COL'));

  MGMT_METRIC.CREATE_METRIC(
      p_target_type => ESM.DB_TARGET_TYPE,
      p_metric_name => 'wdbsvrOwnerRep',    
      p_type_meta_ver => ESM.DB_TYPE_META_VERSION,
      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type, 
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,                
      p_metric_label => 'wdbsvr.app Owner', 
      p_metric_label_nlsid => 'WDBSVR_OWNER_METRIC_LABEL',
      p_description  => 'Collect  owner of  wdbsvr.app file',
      p_description_nlsid => 'WDBSVR_OWNER_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE ,
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT target_guid, value as owner, '
                 ||'value2 as filename, value as dummy FROM esm_collection_latest  '
                 ||'WHERE property=''wdbsvr_owner''', 
      p_snapshot_name_list => l_snapshot_list_inst_10gR2,
      p_metric_column_list => l_metric_column_list  
 );
COMMIT;

-- Policy
  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'owner'),
 MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'filename'));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));

 ESM.CREATE_POLICY(
  p_target_type => ESM.DB_TARGET_TYPE,
  p_policy_name =>'Wdbsvr_Owner',   --Policy name
  p_metric_name =>'wdbsvrOwnerRep',      --Metric name
  p_policy_label_nlsid =>'WDBSVR_OWNER_NAME', 
  p_description =>'Ensures Oracle HTTP Server mod_plsql configuration file (wdbsvr.app) is owned by Oracle software owner',
  p_description_nlsid =>'WDBSVR_OWNER_DESC',
  p_impact => 'The Oracle HTTP Server mod_plsql configuration file (wdbsvr.app) contains the Database Access Descriptors used for authentication. A publicly accessible mod_plsql configuration file can allow a malicious user to modify the Database Access Descriptor settings to gain access to PL/SQL applications or launch a Denial Of Service attack.',
  p_impact_nlsid =>'WDBSVR_OWNER_IMPACT',
  p_recommendation =>'Restrict permissions of Oracle HTTP Server mod_plsql configuration file (wdbsvr.app) to the owner of Oracle software set and DBA group.',
  p_recommendation_nlsid =>'WDBSVR_OWNER_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_WARNING,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'rownum > 0',
  p_message =>'System is in an insecure state. The Oracle HTTP Server mod_plsql configuration file (wdbsvr.app) owner is %owner%.',
  p_message_nlsid =>'WDBSVR_OWNER_MESG',
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver => ESM.DB_TYPE_META_VERSION,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList    
);
COMMIT ;




 
---------------<<XSQL_OWNER>>-------------------------
  l_valid_if_list := MGMT_VALIDIF_ARRAY(
       MGMT_VALIDIF_OBJ.NEW(
            p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY(' ')));

 l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
       MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'owner',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Owner ',
                p_column_label_nlsid =>'FILE_OWNER_COL'),
       MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'filename',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Filename',
                p_column_label_nlsid =>'FILE_NAME_COL'), 
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'dummy',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'DUMMY',
                p_column_label_nlsid =>'DUMMY_COL'));

  MGMT_METRIC.CREATE_METRIC(
      p_target_type => ESM.DB_TARGET_TYPE,
      p_metric_name => 'xsqlOwnerRep',    
      p_type_meta_ver => ESM.DB_TYPE_META_VERSION,
      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type, 
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,                
      p_metric_label => 'XSQLConfig.xml Owner', 
      p_metric_label_nlsid => 'XSQL_OWNER_METRIC_LABEL',
      p_description  => 'Collect  owner of  XSQLConfig.xml file',
      p_description_nlsid => 'XSQL_OWNER_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE ,
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT target_guid, value as owner, '
                 ||'value2 as filename, value as dummy FROM esm_collection_latest  '
                 ||'WHERE property=''xsql_owner''', 
      p_snapshot_name_list => l_snapshot_list_inst_10gR2,
      p_metric_column_list => l_metric_column_list  
 );
COMMIT;

-- Policy
  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'owner'),
 MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'filename'));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));

 ESM.CREATE_POLICY(
  p_target_type => ESM.DB_TARGET_TYPE,
  p_policy_name =>'Xsql_Owner',   --Policy name
  p_metric_name =>'xsqlOwnerRep',      --Metric name
  p_policy_label_nlsid =>'XSQL_OWNER_NAME', 
  p_description =>'Ensures Oracle XSQL configuration file  (XSQLConfig.xml) is owned by Oracle software owner',
  p_description_nlsid =>'XSQL_OWNER_DESC',
  p_impact => 'The Oracle XSQL configuration file (XSQLConfig.xml) contains sensitive database connection information. A publicly accessible XSQL configuration file can expose the database username and password that can be used access sensitive data or to launch further attacks.',
  p_impact_nlsid =>'XSQL_OWNER_IMPACT',
  p_recommendation =>'Restrict permissions of Oracle XSQL configuration file (XSQLConfig.xml) to the owner of Oracle software set and DBA group.',
  p_recommendation_nlsid =>'XSQL_OWNER_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_WARNING,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'rownum > 0',
  p_message =>'System  is in an insecure state. The Oracle XSQL configuration file  (XSQLConfig.xml) owner is %owner%.',
  p_message_nlsid =>'XSQL_OWNER_MESG',
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver => ESM.DB_TYPE_META_VERSION,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList    
);
COMMIT ;


---------------<<HTACCESS>>-------------------------
  l_valid_if_list := MGMT_VALIDIF_ARRAY(
       MGMT_VALIDIF_OBJ.NEW(
            p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY(' ')));
 l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
       MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'permission',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Permission ',
                p_column_label_nlsid =>'PERM_COL'),
       MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'filename',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Filename',
                p_column_label_nlsid =>'FILE_NAME_COL'), 
       MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'dummy',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'DUMMY',
                p_column_label_nlsid =>'DUMMY_COL'));

  MGMT_METRIC.CREATE_METRIC(
      p_target_type => ESM.DB_TARGET_TYPE,
      p_metric_name => 'htaccessRep',	
      p_type_meta_ver => ESM.DB_TYPE_META_VERSION,
      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type, 
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,    			
      p_metric_label => '.htaccess  Permission', 
      p_metric_label_nlsid => 'HTACCESS_METRIC_LABEL',
      p_description  => 'Collect permissions of  .htaccess file',
      p_description_nlsid => 'HTACCESS_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE ,
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT target_guid, value as permission, '
                 ||'value2 as filename, value as dummy FROM esm_collection_latest  '
                 ||'WHERE property=''htperm''', 
      p_snapshot_name_list => l_snapshot_list_inst_10gR2,
      p_metric_column_list => l_metric_column_list  
 );

COMMIT;


-- Policy
  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'permission'),
 MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'filename'));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));

 ESM.CREATE_POLICY(
  p_target_type => ESM.DB_TARGET_TYPE,
  p_policy_name =>'Htaccess',   --Policy name
  p_metric_name =>'htaccessRep',      --Metric name
  p_policy_label_nlsid =>'HTACCESS_NAME', 
  p_description =>'Ensures Oracle HTTP Server Distributed Configuration Files permissions are limited to the Oracle software set and DBA group',
  p_description_nlsid =>'HTACCESS_DESC',
  p_impact => 'The Oracle HTTP Server distributed configuration file (usually .htaccess) is used for access control and authentication of web folders. This file can be modified to gain access to pages containing sensitive information.',
  p_impact_nlsid =>'HTACCESS_IMPACT',
  p_recommendation =>'Restrict Oracle HTTP Server Distributed configuration files access to the Oracle software set and DBA group.',
  p_recommendation_nlsid =>'HTACCESS_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_WARNING,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'rownum > 0',
  p_message =>'System is in an insecure state. The Oracle HTTP Server Distributed configuration file %filename% has %permission% permission.',
  p_message_nlsid =>'HTACCESS_MESG',
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver => ESM.DB_TYPE_META_VERSION,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList	
);
COMMIT ;

---------------<<HTACCESS>>-------------------------


--------------->>HTACCESS_OWNER<<-------------------------
  l_valid_if_list := MGMT_VALIDIF_ARRAY(
       MGMT_VALIDIF_OBJ.NEW(
            p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY(' ')));

 l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
       MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'owner',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Owner ',
                p_column_label_nlsid =>'FILE_OWNER_COL'),
       MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'filename',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Filename',
                p_column_label_nlsid =>'FILE_NAME_COL'), 
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'dummy',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'DUMMY',
                p_column_label_nlsid =>'DUMMY_COL'));

  MGMT_METRIC.CREATE_METRIC(
      p_target_type => ESM.DB_TARGET_TYPE,
      p_metric_name => 'htaccessOwnerRep',	
      p_type_meta_ver => ESM.DB_TYPE_META_VERSION,
      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type, 
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,    			
      p_metric_label => '.htaccess Owner', 
      p_metric_label_nlsid => 'HTACCESS_OWNER_METRIC_LABEL',
      p_description  => 'Collect  owner of  .htaccess file',
      p_description_nlsid => 'HTACCESS_OWNER_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE ,
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT target_guid, value as owner, '
                 ||'value2 as filename, value as dummy FROM esm_collection_latest  '
                 ||'WHERE property=''htowner''', 
      p_snapshot_name_list => l_snapshot_list_inst_10gR2,
      p_metric_column_list => l_metric_column_list  
 );
COMMIT;

-- Policy
  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'owner'),
 MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'filename'));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));
 ESM.CREATE_POLICY(
  p_target_type => ESM.DB_TARGET_TYPE,
  p_policy_name =>'Htaccess_Owner',   --Policy name
  p_metric_name =>'htaccessOwnerRep',      --Metric name
  p_policy_label_nlsid =>'HTACCESS_OWNER_NAME', 
  p_description =>'Ensures Oracle HTTP Server distributed configuration file ownership is restricted to the Oracle software set and DBA group',
  p_description_nlsid =>'HTACCESS_OWNER_DESC',
  p_impact => 'The Oracle HTTP Server distributed configuration file (usually .htaccess) is used for access control and authentication of web folders. This file can be modified to gain access to pages containing sensitive information.',
  p_impact_nlsid =>'HTACCESS_OWNER_IMPACT',
  p_recommendation =>'Restrict Oracle HTTP Server distributed configuration file ownership to the Oracle software set and DBA group.',
  p_recommendation_nlsid =>'HTACCESS_OWNER_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_WARNING,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'rownum > 0',
  p_message =>'System is in an insecure state. The Oracle HTTP Server Distributed configuration file %filename% owner is %owner%.',
  p_message_nlsid =>'HTACCESS_OWNER_MESG',
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver => ESM.DB_TYPE_META_VERSION,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList	
);
COMMIT ;


---------------<<SELECT_ANY_TABLE>>-------------------------
  l_valid_if_list := MGMT_VALIDIF_ARRAY(
       MGMT_VALIDIF_OBJ.NEW(
            p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY(' ')));
 l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
       MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'path',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Path ',
                p_column_label_nlsid =>'PATH_COL'),
       MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'grantee',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Grantee',
                p_column_label_nlsid =>'GRANTEE_COL'),
       MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'dummy',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'DUMMY',
                p_column_label_nlsid =>'DUMMY_COL'));

  MGMT_METRIC.CREATE_METRIC(
      p_target_type => ESM.DB_TARGET_TYPE,
      p_metric_name => 'select_any_tableRep',	
      p_type_meta_ver => ESM.DB_TYPE_META_VERSION,
      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type, 
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,    			
      p_metric_label => 'Select any table privilege', 
      p_metric_label_nlsid => 'SELECT_ANY_TABLE_METRIC_LABEL',
      p_description  => 'Collect entites granted select any table privilege',
      p_description_nlsid => 'SELECT_ANY_TABLE_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE ,
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT target_guid, value as path, '
                 ||'value2 as grantee, value as dummy FROM esm_collection_latest  '
                 ||'WHERE property=''select_any_table''', 
      p_snapshot_name_list => l_snapshot_list,
      p_metric_column_list => l_metric_column_list  
 );

COMMIT;

  MGMT_METRIC.CREATE_METRIC(
      p_target_type => 'rac_database',
      p_metric_name => 'select_any_tableRep',	
      p_type_meta_ver => ESM.DB_TYPE_META_VERSION,
      --p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type, 
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,    			
      p_metric_label => 'Select any table privilege', 
      p_metric_label_nlsid => 'SELECT_ANY_TABLE_METRIC_LABEL',
      p_description  => 'Collect entites granted select any table privilege',
      p_description_nlsid => 'SELECT_ANY_TABLE_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE ,
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT target_guid, value as path, '
                 ||'value2 as grantee, value as dummy FROM esm_collection_latest  '
                 ||'WHERE property=''select_any_table''', 
      p_snapshot_name_list => l_snapshot_list_rac,
      p_metric_column_list => l_metric_column_list  
 );

COMMIT;

-- Policy
  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'path'),
 MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'grantee'));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));

 ESM.CREATE_POLICY(
  p_target_type => ESM.DB_TARGET_TYPE,
  p_policy_name =>'Select_Any_Table',   --Policy name
  p_metric_name =>'select_any_tableRep',      --Metric name
  p_policy_label_nlsid =>'SELECT_ANY_TABLE_NAME', 
  p_description =>'Ensures SELECT ANY PRIVILEGE is never granted to any user or role',
  p_description_nlsid =>'SELECT_ANY_TABLE_DESC',
  p_impact => 'The SELECT ANY TABLE privilege can be used to grant users or roles with the ability to view data in tables that are not owned by them. A malicious user with access to any user account that has this privilege can use this to gain access to sensitive data.',
  p_impact_nlsid =>'SELECT_ANY_TABLE_IMPACT',
  p_recommendation =>'Never grant SELECT ANY TABLE privilege.',
  p_recommendation_nlsid =>'SELECT_ANY_TABLE_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_WARNING,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'rownum > 0',
  p_message =>'Database is in an insecure state. SELECT ANY TABLE privilege granted.',
  p_message_nlsid =>'SELECT_ANY_TABLE_MESG',
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver => ESM.DB_TYPE_META_VERSION,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList	
);
COMMIT ;


 ESM.CREATE_POLICY(
  p_target_type => 'rac_database',
  p_policy_name =>'Select_Any_Table',   --Policy name
  p_metric_name =>'select_any_tableRep',      --Metric name
  p_policy_label_nlsid =>'SELECT_ANY_TABLE_NAME', 
  p_description =>'Ensures SELECT ANY PRIVILEGE is never granted to any user or role',
  p_description_nlsid =>'SELECT_ANY_TABLE_DESC',
  p_impact => 'The SELECT ANY TABLE privilege can be used to grant users or roles with the ability to view data in tables that are not owned by them. A malicious user with access to any user account that has this privilege can use this to gain access to sensitive data.',
  p_impact_nlsid =>'SELECT_ANY_TABLE_IMPACT',
  p_recommendation =>'Never grant SELECT ANY TABLE privilege.',
  p_recommendation_nlsid =>'SELECT_ANY_TABLE_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_WARNING,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'rownum > 0',
  p_message =>'Database is in an insecure state. SELECT ANY TABLE privilege granted.',
  p_message_nlsid =>'SELECT_ANY_TABLE_MESG',
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver => ESM.DB_TYPE_META_VERSION,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList	
);
COMMIT ;
---------------<<SELECT_ANY_TABLE>>-------------------------



---------------<<SELECT_PRIVILEGE>>-------------------------
  l_valid_if_list := MGMT_VALIDIF_ARRAY(
       MGMT_VALIDIF_OBJ.NEW(
            p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY('DB')));
 l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
       MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'path',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Path ',
                p_column_label_nlsid =>'PATH_COL'),
       MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'grantee',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Grantee',
                p_column_label_nlsid =>'GRANTEE_COL'),
       MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'dummy',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'DUMMY',
                p_column_label_nlsid =>'DUMMY_COL'));

  MGMT_METRIC.CREATE_METRIC(
      p_target_type => ESM.DB_TARGET_TYPE,
      p_metric_name => 'select_privilegeRep',	
      p_type_meta_ver => ESM.DB_TYPE_META_VERSION,
      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type, 
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,    			
      p_metric_label => 'Select privilege to any DBA_ view', 
      p_metric_label_nlsid => 'SELECT_PRIVILEGE_METRIC_LABEL',
      p_description  => 'Collect  entities granted select privilege to DBA_ view',
      p_description_nlsid => 'SELECT_PRIVILEGE_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE ,
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT target_guid, value as path, '
                 ||'value2 as grantee, value as dummy FROM esm_collection_latest  '
                 ||'WHERE property=''select_privilege''', 
      p_snapshot_name_list => l_snapshot_list,
      p_metric_column_list => l_metric_column_list  
 );

COMMIT;

  MGMT_METRIC.CREATE_METRIC(
      p_target_type => 'rac_database',
      p_metric_name => 'select_privilegeRep',	
      p_type_meta_ver => ESM.DB_TYPE_META_VERSION,
   --   p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type, 
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,    			
      p_metric_label => 'Select privilege to any DBA_ view', 
      p_metric_label_nlsid => 'SELECT_PRIVILEGE_METRIC_LABEL',
      p_description  => 'Collect  entities granted select privilege to DBA_ view',
      p_description_nlsid => 'SELECT_PRIVILEGE_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE ,
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT target_guid, value as path, '
                 ||'value2 as grantee, value as dummy FROM esm_collection_latest  '
                 ||'WHERE property=''select_privilege''', 
      p_snapshot_name_list => l_snapshot_list_rac,
      p_metric_column_list => l_metric_column_list  
 );

COMMIT;

-- Policy
  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'path'),
 MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'grantee'));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));

 ESM.CREATE_POLICY(
  p_target_type => ESM.DB_TARGET_TYPE,
  p_policy_name =>'Select_Privilege',   --Policy name
  p_metric_name =>'select_privilegeRep',      --Metric name
  p_policy_label_nlsid =>'SELECT_PRIVILEGE_NAME', 
  p_description =>'Ensures SELECT privilege is never granted to any DBA_ view',
  p_description_nlsid =>'SELECT_PRIVILEGE_DESC',
  p_impact => 'The DBA_* views provide access to privileges and policy settings of the database. Some of these views also allow viewing of sensitive PL/SQL code that can be used to understand the security policies.',
  p_impact_nlsid =>'SELECT_PRIVILEGE_IMPACT',
  p_recommendation =>'None of the DBA_ views should be granted SELECT privileges. If there are users with the SELECT privilege, ensure all access to the DBA_ view is audited.',
  p_recommendation_nlsid =>'SELECT_PRIVILEGE_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_WARNING,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'rownum > 0',
  p_message =>'Database is in an insecure state. Granted SELECT Privilege to DBA_ views can be misused.',
  p_message_nlsid =>'SELECT_PRIVILEGE_MESG',
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver => ESM.DB_TYPE_META_VERSION,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList	
);
COMMIT ;


 ESM.CREATE_POLICY(
  p_target_type => 'rac_database',
  p_policy_name =>'Select_Privilege',   --Policy name
  p_metric_name =>'select_privilegeRep',      --Metric name
  p_policy_label_nlsid =>'SELECT_PRIVILEGE_NAME', 
  p_description =>'Ensures SELECT privilege is never granted to any DBA_ view',
  p_description_nlsid =>'SELECT_PRIVILEGE_DESC',
  p_impact => 'The DBA_* views provide access to privileges and policy settings of the database. Some of these views also allow viewing of sensitive PL/SQL code that can be used to understand the security policies.',
  p_impact_nlsid =>'SELECT_PRIVILEGE_IMPACT',
  p_recommendation =>'None of the DBA_ views should be granted SELECT privileges. If there are users with the SELECT privilege, ensure all access to the DBA_ view is audited.',
  p_recommendation_nlsid =>'SELECT_PRIVILEGE_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_WARNING,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'rownum > 0',
  p_message =>'Database is in an insecure state. Granted SELECT Privilege to DBA_ views can be misused.',
  p_message_nlsid =>'SELECT_PRIVILEGE_MESG',
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver => ESM.DB_TYPE_META_VERSION,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList	
);
COMMIT ;
---------------<<SELECT_PRIVILEGE>>-------------------------

--------------->>WINDOWS_PLATFORM<<-------------------------

  l_valid_if_list := MGMT_VALIDIF_ARRAY(
       MGMT_VALIDIF_OBJ.NEW(
            p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY(' '))
 );

 l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
       MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'domain',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'Domain Controller',
                p_column_label_nlsid =>'DOMAIN_COL'));

  MGMT_METRIC.CREATE_METRIC(
      p_target_type => ESM.DB_TARGET_TYPE,
      p_metric_name => 'winPlatformNTRep',
      p_type_meta_ver => ESM.DB_TYPE_META_VERSION,
      p_valid_if_list => l_valid_if_list,  --NT metrics use the same category prop as the UNIX ones
      p_metric_type => l_metric_type ,
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT, 
      p_metric_label => 'Domain Controller',
      p_metric_label_nlsid => 'WIN_PLATFORM_METRIC_LABEL',
      p_description  => 'Collect if Oracle installed on a Domain Controller',
      p_description_nlsid => 'WIN_PLATFORM_METRIC_DESC', 
      p_is_repository => MGMT_GLOBAL.G_TRUE ,
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT  target_guid, value as domain '
       ||' FROM esm_collection_latest '
       ||'WHERE property =''win_plat''',
  p_snapshot_name_list => l_snapshot_list_inst_10gR2,
  p_metric_column_list => l_metric_column_list  
 ) ;

COMMIT ;
  

l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'domain')
  );
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));

 ESM.CREATE_POLICY(
  p_target_type => ESM.DB_TARGET_TYPE,
  p_policy_name =>'winPlatformNT',   --Policy name
  p_metric_name =>'winPlatformNTRep',      --Metric name
  p_policy_label_nlsid =>'WIN_PLATFORM_NAME', 
  p_description =>'Ensures that Oracle is not installed on a domain controller',
  p_description_nlsid =>'WIN_PLATFORM_DESC',
  p_impact => 'Installing Oracle on a domain controller can cause serious security issues.',
  p_impact_nlsid =>'WIN_PLATFORM_IMPACT',
  p_recommendation =>'Oracle must only be installed on a domain member server or a standalone server.',
  p_recommendation_nlsid =>'WIN_PLATFORM_RECOMM' ,
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_WARNING,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'rownum > 0',
  p_message =>'System is in an insecure state. Oracle installed on a domain controller.',
  p_message_nlsid =>'WIN_PLATFORM_MESG',
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver => ESM.DB_TYPE_META_VERSION,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList
);
COMMIT ;
---------------<<WINDOWS_PLATFORM>>-------------------------



--------------->>DRIVE_PERM<<-------------------------

  l_valid_if_list := MGMT_VALIDIF_ARRAY(
       MGMT_VALIDIF_OBJ.NEW(
            p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY(' '))
 );

 l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
       MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'users',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'User',
                p_column_label_nlsid =>'USER_COL'),
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'dummy',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'Dummy',
                p_column_label_nlsid =>'DUMMY_COL'));

  MGMT_METRIC.CREATE_METRIC(
      p_target_type => ESM.DB_TARGET_TYPE,
      p_metric_name => 'drivePermNTRep',
      p_type_meta_ver => ESM.DB_TYPE_META_VERSION,
      p_valid_if_list => l_valid_if_list,  --NT metrics use the same category prop as the UNIX ones
      p_metric_type => l_metric_type ,
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,  
      p_metric_label => 'Drive permissions',
      p_metric_label_nlsid => 'DRIVE_PERM_METRIC_LABEL',
      p_description  => 'Collect Oracle installed drive permissions',
      p_description_nlsid => 'DRIVE_PERM_METRIC_DESC', 
      p_is_repository => MGMT_GLOBAL.G_TRUE ,
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT  target_guid, value as users, '
       ||'value as dummy FROM esm_collection_latest '
       ||'WHERE property =''drive_perm''',
  p_snapshot_name_list => l_snapshot_list_inst_10gR2,
  p_metric_column_list => l_metric_column_list  
 ) ;

COMMIT ;
  

l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'users')
  );
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));

 ESM.CREATE_POLICY(
  p_target_type => ESM.DB_TARGET_TYPE,
  p_policy_name =>'drivePermNT',   --Policy name
  p_metric_name =>'drivePermNTRep',      --Metric name
  p_policy_label_nlsid =>'DRIVE_PERM_NAME', 
  p_description =>'On Windows, ensures that the installed Oracle Home drive is not accessible to Everyone Group',
  p_description_nlsid =>'DRIVE_PERM_DESC',
  p_impact => 'Giving permission of Oracle installed drive to everyone can cause serious security issues.',
  p_impact_nlsid =>'DRIVE_PERM_IMPACT',
  p_recommendation =>'The installed Oracle Home drive should not be accessible to Everyone Group.',
  p_recommendation_nlsid =>'DRIVE_PERM_RECOMM' ,
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_WARNING,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'rownum > 0',
  p_message =>'System is in an insecure state. Oracle installed drive is accessible to Everyone Group.',
  p_message_nlsid =>'DRIVE_PERM_MESG',
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver => ESM.DB_TYPE_META_VERSION,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList
);
COMMIT ;
---------------<<DRIVE_PERM>>-------------------------


--------------->>DOMAIN_USERS<<-------------------------

  l_valid_if_list := MGMT_VALIDIF_ARRAY(
       MGMT_VALIDIF_OBJ.NEW(
            p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY(' '))
 );

 l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
       MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'domainusers',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'Domain Users',
                p_column_label_nlsid =>'DOMAIN_USERS_COL'));

  MGMT_METRIC.CREATE_METRIC(
      p_target_type => ESM.DB_TARGET_TYPE,
      p_metric_name => 'domainUserGrpNTRep',
      p_type_meta_ver => ESM.DB_TYPE_META_VERSION,
      p_valid_if_list => l_valid_if_list,  --NT metrics use the same category prop as the UNIX ones
      p_metric_type => l_metric_type ,
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,  
      p_metric_label => 'Domain users group',
      p_metric_label_nlsid => 'DOMAIN_USERS_METRIC_LABEL',
      p_description  => 'Collect if local account has domain users group on a server',
      p_description_nlsid => 'DOMAIN_USERS_METRIC_DESC', 
      p_is_repository => MGMT_GLOBAL.G_TRUE ,
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT  target_guid, value as domainusers '
       ||' FROM esm_collection_latest '
       ||'WHERE property =''domain_user_grp''',
  p_snapshot_name_list => l_snapshot_list_inst_10gR2,
  p_metric_column_list => l_metric_column_list  
 ) ;

COMMIT ;

  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'domainusers')
  );
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));

 ESM.CREATE_POLICY(
  p_target_type => ESM.DB_TARGET_TYPE,
  p_policy_name =>'domainUserGrpNT',   --Policy name
  p_metric_name =>'domainUserGrpNTRep',      --Metric name
  p_policy_label_nlsid =>'DOMAIN_USERS_NAME', 
  p_description =>'Ensures domain server local Users group does not have Domain Users group',
  p_description_nlsid =>'DOMAIN_USERS_DESC',
  p_impact => 'Including Domain Users group in local Users group of a domain server can cause serious security issues.',
  p_impact_nlsid =>'DOMAIN_USERS_IMPACT',
  p_recommendation =>'Remove Domain Users group form local Users group.',
  p_recommendation_nlsid =>'DOMAIN_USERS_RECOMM' ,
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_WARNING,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'rownum > 0',
  p_message =>'System is in an insecure state. Domain servers local Users group has Domain Users group.',
  p_message_nlsid =>'DOMAIN_USERS_MESG',
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver => ESM.DB_TYPE_META_VERSION,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList
);
COMMIT ;
---------------<<DOMAIN_USERS>>-------------------------


--------------->>WIN_TOOLS<<-------------------------

  l_valid_if_list := MGMT_VALIDIF_ARRAY(
       MGMT_VALIDIF_OBJ.NEW(
            p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY(' '))
 );

 l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
       MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'filename',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Filename',
                p_column_label_nlsid =>'FILE_NAME_COL'),
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'dummy',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'Dummy',
                p_column_label_nlsid =>'DUMMY_COL'));

  MGMT_METRIC.CREATE_METRIC(
      p_target_type => ESM.DB_TARGET_TYPE,
      p_metric_name => 'winToolsNTRep',
      p_type_meta_ver => ESM.DB_TYPE_META_VERSION,
      p_valid_if_list => l_valid_if_list,  --NT metrics use the same category prop as the UNIX ones
      p_metric_type => l_metric_type ,
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,  
      p_metric_label => 'Windows Tools Permissions',
      p_metric_label_nlsid => 'WIN_TOOLS_METRIC_LABEL',
      p_description  => 'Collect if Oracle service have permission on windows tools',
      p_description_nlsid => 'WIN_TOOLS_METRIC_DESC', 
      p_is_repository => MGMT_GLOBAL.G_TRUE ,
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT  target_guid, value as filename, '
       ||'value as dummy FROM esm_collection_latest '
       ||'WHERE property =''win_tools''',
  p_snapshot_name_list => l_snapshot_list_inst_10gR2,
  p_metric_column_list => l_metric_column_list  
 ) ;

COMMIT ;
  

l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'filename')
  );
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));

 ESM.CREATE_POLICY(
  p_target_type => ESM.DB_TARGET_TYPE,
  p_policy_name =>'winToolsNT',   --Policy name
  p_metric_name =>'winToolsNTRep',      --Metric name
  p_policy_label_nlsid =>'WIN_TOOLS_NAME', 
  p_description =>'Ensures Oracle service does not have permissions on windows tools',
  p_description_nlsid =>'WIN_TOOLS_DESC',
  p_impact => 'Granting Oracle service the permissions of windows tools may cause serious securty issues.',
  p_impact_nlsid =>'WIN_TOOLS_IMPACT',
  p_recommendation =>'Remove Windows tools permission from Oracle service account.',
  p_recommendation_nlsid =>'WIN_TOOLS_RECOMM' ,
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_WARNING,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'rownum > 0',
  p_message =>'System is in an insecure state. Oracle service account has permissions of windows tool (%filename%).',
  p_message_nlsid =>'WIN_TOOLS_MESG',
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver => ESM.DB_TYPE_META_VERSION,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList
);
COMMIT ;
---------------<<WIN_TOOLS>>-------------------------

--------------->>windows specific policies<<-------------------------
 
--tkrpof
  l_valid_if_list := MGMT_VALIDIF_ARRAY(
       MGMT_VALIDIF_OBJ.NEW(
            p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY(' ')));
 l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
       MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'users',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Users',
                p_column_label_nlsid =>'USERS_COL'),
       MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'filename',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Filename',
                p_column_label_nlsid =>'FILE_NAME_COL'), 
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'dummy',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'DUMMY',
                p_column_label_nlsid =>'DUMMY_COL'));

  MGMT_METRIC.CREATE_METRIC(
      p_target_type => ESM.DB_TARGET_TYPE,
      p_metric_name => 'tkprofRepNT',    
      p_type_meta_ver => ESM.DB_TYPE_META_VERSION,
      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type, 
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,                
      p_metric_label => 'tkprof  Permission', 
      p_metric_label_nlsid => 'TKPROF_METRIC_LABEL',
      p_description  => 'Collect permissions of  tkprof file',
      p_description_nlsid => 'TKPROF_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE ,
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT target_guid, value as users, '
                 ||'value2 as filename, value as dummy FROM esm_collection_latest  '
                 ||'WHERE property=''nt_tkprof_perm''', 
      p_snapshot_name_list => l_snapshot_list_inst_10gR2,
      p_metric_column_list => l_metric_column_list  
 );
COMMIT;


-- Policy
  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'users'),
 MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'filename'));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));

 ESM.CREATE_POLICY(
  p_target_type => ESM.DB_TARGET_TYPE,
  p_policy_name =>'tkprofNT',   --Policy name
  p_metric_name =>'tkprofRepNT',      --Metric name
  p_policy_label_nlsid =>'TKPROF_NAME_NT', 
  p_description =>'Ensures tkprof executable file permissions are restricted to read and execute for the group, and inaccessible to public',
  p_description_nlsid =>'TKPROF_DESC',
  p_impact => 'Excessive permission for tkprof leaves information within, unprotected.',
  p_impact_nlsid =>'TKPROF_IMPACT',
  p_recommendation =>'Remove tkprof executable if not required. Otherwise, file permissions for tkprof executable should be restricted to read and execute for the group, and inaccessible to public.',
  p_recommendation_nlsid =>'TKPROF_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_WARNING,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'rownum > 0',
  p_message =>'System is in an insecure state. Users %users% have permissions on the tkprof executable file (%filename%).',
  p_message_nlsid =>'TKPROF_NT_MESG',
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver => ESM.DB_TYPE_META_VERSION,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList    
);
COMMIT ;


--------------->>sqlplus perm<<-------------------------

  l_valid_if_list := MGMT_VALIDIF_ARRAY(
       MGMT_VALIDIF_OBJ.NEW(
            p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY(' '))); 
 l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
       MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'users',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Users',
                p_column_label_nlsid =>'USERS_COL'),
       MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'filename',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Filename',
                p_column_label_nlsid =>'FILE_NAME_COL'), 
        MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'dummy',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'Dummy',
                p_column_label_nlsid =>'DUMMY_COL'));

  MGMT_METRIC.CREATE_METRIC(
      p_target_type => ESM.DB_TARGET_TYPE,
      p_metric_name => 'sqlplusRepNT',    
      p_type_meta_ver => ESM.DB_TYPE_META_VERSION,
      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type, 
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,                
      p_metric_label => 'sqlplus  Permission', 
      p_metric_label_nlsid => 'SQLPLUS_METRIC_LABEL',
      p_description  => 'Collect permissions  sqlplus executable file',
      p_description_nlsid => 'SQLPLUS_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE ,
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT target_guid, value as users, '
                 ||'value2 as filename, value as dummy FROM esm_collection_latest '
                 ||'WHERE property=''nt_sqlplus_perm''', 
      p_snapshot_name_list => l_snapshot_list_inst_10gR2,
      p_metric_column_list => l_metric_column_list  
 );
COMMIT ;

-- Policy
  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'users'),
 MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'filename'));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));


 ESM.CREATE_POLICY(
  p_target_type => ESM.DB_TARGET_TYPE,
  p_policy_name =>'sqlplusNT',   --Policy name
  p_metric_name =>'sqlplusRepNT',      --Metric name
  p_policy_label_nlsid =>'SQLPLUS_NAME_NT', 
  p_description =>'Ensures that SQL*Plus executable file permissions are limited to the Oracle software set and DBA group',
  p_description_nlsid =>'SQLPLUS_DESC',
  p_impact => 'SQL*Plus allows a user to execute any SQL on the database provided the user has an account with appropriate privileges. Public execute permissions on SQL*Plus can cause security issues by exposing sensitive data to malicious users.',
  p_impact_nlsid =>'SQLPLUS_IMPACT',
  p_recommendation =>'Restrict file permissions for SQL*Plus executable to the Oracle software set and DBA group.',
  p_recommendation_nlsid =>'SQLPLUS_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_WARNING,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'rownum > 0',
  p_message =>'System is in an insecure state. Users %users% have permissions on the SQL*Plus executable file (%filename%).',
  p_message_nlsid =>'SQLPLUS_NT_MESG',
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver => ESM.DB_TYPE_META_VERSION,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList    
);
COMMIT ;

---------------<<sqlplus perm>>-------------------------




--------------->>WEBCACHE<<-------------------------
  l_valid_if_list := MGMT_VALIDIF_ARRAY(
       MGMT_VALIDIF_OBJ.NEW(
            p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY(' ')));
 l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
       MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'users',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Users',
                p_column_label_nlsid =>'Users_COL'),
       MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'filename',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Filename',
                p_column_label_nlsid =>'FILE_NAME_COL'), 
       MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'dummy',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'DUMMY',
                p_column_label_nlsid =>'DUMMY_COL'));

  MGMT_METRIC.CREATE_METRIC(
      p_target_type => ESM.DB_TARGET_TYPE,
      p_metric_name => 'webcacheRepNT',    
      p_type_meta_ver => ESM.DB_TYPE_META_VERSION,
      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type, 
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,                
      p_metric_label => 'webcache  Permission', 
      p_metric_label_nlsid => 'WEBCACHE_METRIC_LABEL',
      p_description  => 'Collect permissions of  webcache.xml file',
      p_description_nlsid => 'WEBCACHE_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE ,
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT target_guid, value as users, '
                 ||'value2 as filename, value as dummy FROM esm_collection_latest  '
                 ||'WHERE property=''nt_webcache_perm''', 
      p_snapshot_name_list => l_snapshot_list_inst_10gR2,
      p_metric_column_list => l_metric_column_list  
 );

COMMIT;


-- Policy
  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'users'),
 MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'filename'));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));

 ESM.CREATE_POLICY(
  p_target_type => ESM.DB_TARGET_TYPE,
  p_policy_name =>'WebcacheNT',   --Policy name
  p_metric_name =>'webcacheRepNT',      --Metric name
  p_policy_label_nlsid =>'WEBCACHE_NAME_NT', 
  p_description =>'Ensures the Webcache initialization file (webcache.xml) permissions are limited to the Oracle software set and DBA group',
  p_description_nlsid =>'WEBCACHE_DESC',
  p_impact => 'Webcache stores sensitive information in the initialization file (webcache.xml). A publicly accessible Webcache initialization file can be used to extract sensitive data like the administrator password hash.',
  p_impact_nlsid =>'WEBCACHE_IMPACT',
  p_recommendation =>'Restrict Webcache initialization file (webcache.xml) access to the Oracle software set and DBA group.',
  p_recommendation_nlsid =>'WEBCACHE_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_WARNING,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'rownum > 0',
  p_message =>'System is in an insecure state. Users %users% have critical permissions on the Webcache initialization file (%filename%).',
  p_message_nlsid =>'WEBCACHE_NT_MESG',
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver => ESM.DB_TYPE_META_VERSION,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList    
);
COMMIT ;

---------------<<WEBCACHE>>-------------------------


---------------<<SNMP_RO>>-------------------------
  l_valid_if_list := MGMT_VALIDIF_ARRAY(
       MGMT_VALIDIF_OBJ.NEW(
            p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY(' ')));
 l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
       MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'users',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Users',
                p_column_label_nlsid =>'USERS_COL'),
       MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'filename',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Filename',
                p_column_label_nlsid =>'FILE_NAME_COL'), 
       MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'dummy',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'DUMMY',
                p_column_label_nlsid =>'DUMMY_COL'));

  MGMT_METRIC.CREATE_METRIC(
      p_target_type => ESM.DB_TARGET_TYPE,
      p_metric_name => 'snmp_roRepNT',    
      p_type_meta_ver => ESM.DB_TYPE_META_VERSION,
      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type, 
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,                
      p_metric_label => 'snmp_ro Permission', 
      p_metric_label_nlsid => 'SNMP_RO_METRIC_LABEL',
      p_description  => 'Collect permissions of  snmp_ro.ora file',
      p_description_nlsid => 'SNMP_RO_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE ,
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT target_guid, value as users, '
                 ||'value2 as filename, value as dummy FROM esm_collection_latest  '
                 ||'WHERE property=''nt_snmp_ro_perm''', 
      p_snapshot_name_list => l_snapshot_list_inst_10gR2,
      p_metric_column_list => l_metric_column_list  
 );

COMMIT;


-- Policy
  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'users'),
 MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'filename'));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));

 ESM.CREATE_POLICY(
  p_target_type => ESM.DB_TARGET_TYPE,
  p_policy_name =>'Snmp_roNT',   --Policy name
  p_metric_name =>'snmp_roRepNT',      --Metric name
  p_policy_label_nlsid =>'SNMP_RO_NAME_NT', 
  p_description =>'Ensures Oracle Agent SNMP read-only configuration file (snmp_ro.ora) permissions are limited to the Oracle software set and DBA group',
  p_description_nlsid =>'SNMP_RO_DESC',
  p_impact => 'The Oracle Agent SNMP read-only configuration file (snmp_ro.ora) contains the listening address of the agent, the names of SQL*Net listener and Oracle database services it knows about, plus tracing parameters. A publicly accessible SNMP read-only configuration file can be used to extract sensitive data like the tracing directory location, dbsnmp address, etc.',
  p_impact_nlsid =>'SNMP_RO_IMPACT',
  p_recommendation =>'Restrict Oracle Agent SNMP read-only configuration file (snmp_ro.ora) access to the Oracle software set and DBA group.',
  p_recommendation_nlsid =>'SNMP_RO_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_WARNING,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'rownum > 0',
  p_message =>'System is in an insecure state. Users %users% have permissions on the Oracle Agent SNMP read-only configuration file (%filename%).',
  p_message_nlsid =>'SNMP_RO_NT_MESG',
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver => ESM.DB_TYPE_META_VERSION,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList    
);
COMMIT ;

---------------<<SNMP_RO>>-------------------------

---------------<<SNMP_RW>>-------------------------
  l_valid_if_list := MGMT_VALIDIF_ARRAY(
       MGMT_VALIDIF_OBJ.NEW(
            p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY(' ')));
 l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
       MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'users',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Users',
                p_column_label_nlsid =>'USERS_COL'),
       MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'filename',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Filename',
                p_column_label_nlsid =>'FILE_NAME_COL'), 
       MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'dummy',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'DUMMY',
                p_column_label_nlsid =>'DUMMY_COL'));

  MGMT_METRIC.CREATE_METRIC(
      p_target_type => ESM.DB_TARGET_TYPE,
      p_metric_name => 'snmp_rwRepNT',    
      p_type_meta_ver => ESM.DB_TYPE_META_VERSION,
      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type, 
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,                
      p_metric_label => 'snmp_rw  Permission', 
      p_metric_label_nlsid => 'SNMP_RW_METRIC_LABEL',
      p_description  => 'Collect permissions of snmp_rw.ora file',
      p_description_nlsid => 'SNMP_RW_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE ,
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT target_guid, value as users, '
                 ||'value2 as filename, value as dummy FROM esm_collection_latest  '
                 ||'WHERE property=''nt_snmp_rw_perm''', 
      p_snapshot_name_list => l_snapshot_list_inst_10gR2,
      p_metric_column_list => l_metric_column_list  
 );

COMMIT;


-- Policy
  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'users'),
 MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'filename'));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));

 ESM.CREATE_POLICY(
  p_target_type => ESM.DB_TARGET_TYPE,
  p_policy_name =>'Snmp_rwNT',   --Policy name
  p_metric_name =>'snmp_rwRepNT',      --Metric name
  p_policy_label_nlsid =>'SNMP_RW_NAME_NT', 
  p_description =>'Ensures Oracle Agent SNMP read-write configuration file (snmp_rw.ora) permissions are limited to the Oracle software set and DBA group',
  p_description_nlsid =>'SNMP_RW_DESC',
  p_impact => 'The Oracle Agent SNMP read-write configuration file (snmp_rw.ora) contains the listening address of the agent, the names of SQL*Net listener and Oracle database services it knows about, plus tracing parameters. A publicly accessible SNMP read-write configuration file can be used to extract sensitive data like the tracing directory location, dbsnmp address, etc.',
  p_impact_nlsid =>'SNMP_RW_IMPACT',
  p_recommendation =>'Restrict Oracle Agent SNMP read-write configuration file (snmp_rw.ora) access to the Oracle software set and DBA group.',
  p_recommendation_nlsid =>'SNMP_RW_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_WARNING,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'rownum > 0',
  p_message =>'System is in an insecure state. Users %users% have permissions on the Oracle Agent SNMP read-write configuration file (%filename%).',
  p_message_nlsid =>'SNMP_RW_NT_MESG',
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver => ESM.DB_TYPE_META_VERSION,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList    
);
COMMIT ;

---------------<<SNMP_RW>>-------------------------

---------------<<WDBSVR>>-------------------------
  l_valid_if_list := MGMT_VALIDIF_ARRAY(
       MGMT_VALIDIF_OBJ.NEW(
            p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY(' ')));
 l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
       MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'users',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Users',
                p_column_label_nlsid =>'USERS_COL'),
       MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'filename',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Filename',
                p_column_label_nlsid =>'FILE_NAME_COL'), 
       MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'dummy',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'DUMMY',
                p_column_label_nlsid =>'DUMMY_COL'));

  MGMT_METRIC.CREATE_METRIC(
      p_target_type => ESM.DB_TARGET_TYPE,
      p_metric_name => 'wdbsvrRepNT',    
      p_type_meta_ver => ESM.DB_TYPE_META_VERSION,
      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type, 
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,                
      p_metric_label => 'wdbsvr.app  Permission', 
      p_metric_label_nlsid => 'WDBSVR_METRIC_LABEL',
      p_description  => 'Collect permissions of  wdbsvr.app file',
      p_description_nlsid => 'WDBSVR_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE ,
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT target_guid, value as users, '
                 ||'value2 as filename, value as dummy FROM esm_collection_latest  '
                 ||'WHERE property=''nt_wdbsvr_perm''', 
      p_snapshot_name_list => l_snapshot_list_inst_10gR2,
      p_metric_column_list => l_metric_column_list  
 );

COMMIT;


-- Policy
  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'users'),
 MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'filename'));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));

 ESM.CREATE_POLICY(
  p_target_type => ESM.DB_TARGET_TYPE,
  p_policy_name =>'WdbsvrNT',   --Policy name
  p_metric_name =>'wdbsvrRepNT',      --Metric name
  p_policy_label_nlsid =>'WDBSVR_NAME_NT', 
  p_description =>'Oracle HTTP Server mod_plsql Configuration file (wdbsvr.app) permissions are limited to the Oracle software set and DBA group',
  p_description_nlsid =>'WDBSVR_DESC',
  p_impact => 'The Oracle HTTP Server mod_plsql configuration file (wdbsvr.app) contains the Database Access Descriptors used for authentication. A publicly accessible mod_plsql configuration file can allow a malicious user to modify the Database Access Descriptor settings to gain access to PL/SQL applications or launch a Denial Of Service attack.',
  p_impact_nlsid =>'WDBSVR_IMPACT',
  p_recommendation =>'Restrict Oracle HTTP Server mod_plsql configuration file (wdbsvr.app) access to the Oracle software set and DBA group.',
  p_recommendation_nlsid =>'WDBSVR_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_WARNING,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'rownum > 0',
  p_message =>'System is in an insecure state. Users %users% have permissions on the Oracle HTTP Server mod_plsql configuration file (%filename%).',
  p_message_nlsid =>'WDBSVR_NT_MESG',
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver => ESM.DB_TYPE_META_VERSION,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList    
);
COMMIT ;

---------------<<WDBSVR>>-------------------------

--------------->>XSQL<<-------------------------
  l_valid_if_list := MGMT_VALIDIF_ARRAY(
       MGMT_VALIDIF_OBJ.NEW(
            p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY(' ')));
 l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
       MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'users',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Users',
                p_column_label_nlsid =>'USERS_COL'),
       MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'filename',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Filename',
                p_column_label_nlsid =>'FILE_NAME_COL'), 
       MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'dummy',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'DUMMY',
                p_column_label_nlsid =>'DUMMY_COL'));

  MGMT_METRIC.CREATE_METRIC(
      p_target_type => ESM.DB_TARGET_TYPE,
      p_metric_name => 'xsqlRepNT',    
      p_type_meta_ver => ESM.DB_TYPE_META_VERSION,
      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type, 
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,                
      p_metric_label => 'XSQLConfig.xml  Permission', 
      p_metric_label_nlsid => 'XSQL_METRIC_LABEL',
      p_description  => 'Collect permissions of  XSQLConfig.xml file',
      p_description_nlsid => 'XSQL_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE ,
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT target_guid, value as users, '
                 ||'value2 as filename, value as dummy FROM esm_collection_latest  '
                 ||'WHERE property=''nt_xsql_perm''', 
      p_snapshot_name_list => l_snapshot_list_inst_10gR2,
      p_metric_column_list => l_metric_column_list  
 );

COMMIT;


-- Policy
  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'users'),
 MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'filename'));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));

 ESM.CREATE_POLICY(
  p_target_type => ESM.DB_TARGET_TYPE,
  p_policy_name =>'XsqlNT',   --Policy name
  p_metric_name =>'xsqlRepNT',      --Metric name
  p_policy_label_nlsid =>'XSQL_NAME_NT', 
  p_description =>'Ensures Oracle XSQL Configuration File  (XSQLConfig.xml) permissions are limited to the Oracle software set and DBA group',
  p_description_nlsid =>'XSQL_DESC',
  p_impact => 'The Oracle XSQL configuration file (XSQLConfig.xml) contains sensitive database connection information. A publicly accessible XSQL configuration file can expose the database username and password that can be used access sensitive data or to launch further attacks.',
  p_impact_nlsid =>'XSQL_IMPACT',
  p_recommendation =>'Restrict Oracle XSQL Configuration file (XSQLConfig.xml) access to the Oracle software set and DBA group.',
  p_recommendation_nlsid =>'XSQL_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_WARNING,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'rownum > 0',
  p_message =>'System is in an insecure state. Users %users% have permissions on the Oracle XSQL Configuration file (%filename%).',
  p_message_nlsid =>'XSQL_NT_MESG',
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver => ESM.DB_TYPE_META_VERSION,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList    
);
COMMIT ;
---------------<<XSQL>>-------------------------


---------------<<HTACCESS>>-------------------------
  l_valid_if_list := MGMT_VALIDIF_ARRAY(
       MGMT_VALIDIF_OBJ.NEW(
            p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY(' ')));
 l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
       MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'users',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Users',
                p_column_label_nlsid =>'USERS_COL'),
       MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'filename',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Filename',
                p_column_label_nlsid =>'FILE_NAME_COL'), 
       MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'dummy',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'DUMMY',
                p_column_label_nlsid =>'DUMMY_COL'));

  MGMT_METRIC.CREATE_METRIC(
      p_target_type => ESM.DB_TARGET_TYPE,
      p_metric_name => 'htaccessRepNT',	
      p_type_meta_ver => ESM.DB_TYPE_META_VERSION,

      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type, 
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,    			
      p_metric_label => '.htaccess  Permission', 
      p_metric_label_nlsid => 'HTACCESS_METRIC_LABEL',
      p_description  => 'Collect permissions of  .htaccess file',
      p_description_nlsid => 'HTACCESS_METRIC_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE ,
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source => 'SELECT target_guid, value as users, '
                 ||'value2 as filename, value as dummy FROM esm_collection_latest  '
                 ||'WHERE property=''nt_htperm''', 
      p_snapshot_name_list => l_snapshot_list_inst_10gR2,
      p_metric_column_list => l_metric_column_list  
 );

COMMIT;


-- Policy
  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'users'),
 MGMT_VIOL_CTXT_DEF.NEW(
                p_metric_column => 'filename'));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL));

 ESM.CREATE_POLICY(
  p_target_type => ESM.DB_TARGET_TYPE,
  p_policy_name =>'HtaccessNT',   --Policy name
  p_metric_name =>'htaccessRepNT',      --Metric name
  p_policy_label_nlsid =>'HTACCESS_NAME_NT', 
  p_description =>'Ensures Oracle HTTP Server Distributed Configuration Files permissions are limited to the Oracle software set and DBA group',
  p_description_nlsid =>'HTACCESS_DESC',
  p_impact => 'The Oracle HTTP Server distributed configuration file (usually .htaccess) is used for access control and authentication of web folders. This file can be modified to gain access to pages containing sensitive information.',
  p_impact_nlsid =>'HTACCESS_IMPACT',
  p_recommendation =>'Restrict Oracle HTTP Server Distributed configuration files access to the Oracle software set and DBA group.',
  p_recommendation_nlsid =>'HTACCESS_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_WARNING,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  p_condition =>'rownum > 0',
  p_message =>'System is in an insecure state. Users %users% have permissions on the Oracle HTTP Server distributed configuration file (%filename%).',
  p_message_nlsid =>'HTACCESS_NT_MESG',
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver => ESM.DB_TYPE_META_VERSION,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList	
);
COMMIT ;

---------------<<HTACCESS>>-------------------------


---------------<<windows specific policies>>-------------------------

l_valid_if_list := MGMT_VALIDIF_ARRAY(
       MGMT_VALIDIF_OBJ.NEW(
            p_catprop_3_choices => MGMT_CATEGORY_PROP_ARRAY('DB'))
 );
 l_metric_column_list := MGMT_METRIC_COLUMN_ARRAY(
    MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'object',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_TRUE,
                p_column_label => 'Object',
                p_column_label_nlsid =>'OBJECT_COL'),    
   MGMT_METRIC_COLUMN_OBJ.NEW(
                p_column_name => 'dummy',
                p_column_type => MGMT_GLOBAL.G_METRIC_TYPE_STRING,
                p_is_key => MGMT_GLOBAL.G_FALSE,
                p_column_label => 'Dummy',
                p_column_label_nlsid =>'DUMMY_COL'));

  MGMT_METRIC.CREATE_METRIC(
      p_target_type => ESM.DB_TARGET_TYPE,
      p_metric_name => 'InsFailRep',
      p_type_meta_ver => ESM.DB_TYPE_META_VERSION,
      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type, 
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,   			
      p_metric_label => 'Audit of Insert Failures',
      p_metric_label_nlsid => 'INSERT_FAILURE_LABEL',
      p_description  => 'Collects objects for which insert failures are not audited',
      p_description_nlsid => 'INSERT_FAILURE_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE ,     
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      --p_source =>'SELECT target_guid, value as object, value2 as dummy '
      --p_source =>'SELECT target_guid, REGEXP_REPLACE(value, ''\$'', ''\$'') as object, value2 as dummy '
      p_source =>'SELECT target_guid, value as object, value2 as dummy '
                 ||'FROM esm_collection_latest '
                 ||'WHERE  property =''insert_failure''',
      p_snapshot_name_list => l_snapshot_list,
      p_metric_column_list => l_metric_column_list  
 ) ;
COMMIT ;
  MGMT_METRIC.CREATE_METRIC(
      p_target_type => 'rac_database',
      p_metric_name => 'InsFailRep',
      p_type_meta_ver => ESM.DB_TYPE_META_VERSION,
--      p_valid_if_list => l_valid_if_list,
      p_metric_type => l_metric_type, 
      p_usage_type => MGMT_GLOBAL.G_USAGE_HIDDEN_COLLECT,   			
      p_metric_label => 'Audit of Insert Failures',
      p_metric_label_nlsid => 'INSERT_FAILURE_LABEL',
      p_description  => 'Collects objects for which insert failures are not audited',
      p_description_nlsid => 'INSERT_FAILURE_DESC',
      p_is_repository => MGMT_GLOBAL.G_TRUE ,     
      p_author => ESM.METRIC_AUTHOR,
      p_source_type => MGMT_GLOBAL.G_METRIC_SOURCE_QUERY,
      p_source =>'SELECT target_guid, value as object, value2 as dummy '
                 ||'FROM esm_collection_latest '
                 ||'WHERE  property =''insert_failure''',
      p_snapshot_name_list => l_snapshot_list,
      p_metric_column_list => l_metric_column_list  
 ) ;
COMMIT ;


  l_ctxList := MGMT_VIOL_CTXT_DEF_ARRAY(
        MGMT_VIOL_CTXT_DEF.NEW(
             p_metric_column => 'object',
             p_url_link_template =>'database/security/profile?oname=^object^\&event=edit\&otype=PROFILE\&target=^TARGET_NAME^\&type=^TARGET_TYPE^\&cancelURL=^CANCEL_URL^',
             p_url_link_type => MGMT_POLICY.G_URL_TYPE_JSP));
  l_paramDefList := MGMT_POLICY_PARAM_DEF_ARRAY(
        MGMT_POLICY_PARAM_DEF(
                param_name => 'CRITICAL_OBJECT_LIST',
                param_name_nlsid => 'CRITICAL_OBJECT_LIST_PNAME',
                param_type => MGMT_POLICY.G_PARAM_TYPE_STRING));
  l_defaultParamValList := MGMT_POLICY_PARAM_VAL_ARRAY(
        MGMT_POLICY_PARAM_VAL.NEW(
                p_param_name => 'CRITICAL_OBJECT_LIST',
                p_warn_threshold => ''));
  l_defaultSettingsList := MGMT_POLICY_KEY_VAL_ARRAY(
      MGMT_POLICY_KEY_VAL.NEW(
                p_importance => MGMT_GLOBAL.G_IMPORTANCE_NORMAL,
                p_param_values => l_defaultParamValList));

 ESM.CREATE_POLICY(
  p_target_type => ESM.DB_TARGET_TYPE,
  p_policy_name =>'Audit_Insert_Failure',   --Policy name
  p_metric_name =>'InsFailRep',      --Metric name
  p_policy_label_nlsid =>'INSERT_FAILURE_NAME',    
  p_description =>'Ensures that insert failures are audited for critical data objects',
  p_description_nlsid =>'INSERT_FAILURE_DESC',
  p_impact => 'Not auditing insert failures for critical data objects may allow a malicious user to infiltrate system security..',
  p_impact_nlsid =>'INSERT_FAILURE_IMPACT',
  p_recommendation =>'Audit insert failures for critical data objects.',
  p_recommendation_nlsid =>'INSERT_FAILURE_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_WARNING,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  --p_condition => 'regexp_like(:CRITICAL_OBJECT_LIST, ''(((.*),)|^)( *)''||REGEXP_REPLACE(:object, '\\$', '\\$')||''( *)($|(,(.*)))'', ''i'' )',
  p_condition => 'regexp_like(:CRITICAL_OBJECT_LIST, ''(((.*),)|^)( *)''||REGEXP_REPLACE(REGEXP_REPLACE(:object, ''\\$'', ''\\$''), ''\\.'', ''\\.'')||''( *)($|(,(.*)))'', ''i'' )',
  p_message =>'System is in an insecure state. Insert failures for critical data objects are not audited.',
  p_message_nlsid =>'INSERT_FAILURE_MESG',
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver => ESM.DB_TYPE_META_VERSION,
  p_policy_param_list =>l_paramDefList,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList	
);
COMMIT ;
 ESM.CREATE_POLICY(
  p_target_type => 'rac_database',
  p_policy_name =>'Audit_Insert_Failure',   --Policy name
  p_metric_name =>'InsFailRep',      --Metric name
  p_policy_label_nlsid =>'INSERT_FAILURE_NAME',    
  p_description =>'Ensures that insert failures are audited for critical data objects',
  p_description_nlsid =>'INSERT_FAILURE_DESC',
  p_impact => 'Not auditing insert failures for critical data objects may allow a malicious user to infiltrate system security.',
  p_impact_nlsid =>'INSERT_FAILURE_IMPACT',
  p_recommendation =>'Audit insert failures for critical data objects.',
  p_recommendation_nlsid =>'INSERT_FAILURE_RECOMM',
  p_violation_level =>MGMT_GLOBAL.G_SEVERITY_WARNING,
  p_condition_type =>MGMT_GLOBAL.G_CONDITION_SQL,
  --p_condition => 'regexp_like(:CRITICAL_OBJECT_LIST, ''(((.*),)|^)( *)''||REGEXP_REPLACE(:object, '\$', '\$')||''( *)($|(,(.*)))'', ''i'' )',
  --p_condition => 'regexp_like(:CRITICAL_OBJECT_LIST, ''(((.*),)|^)( *)''||:object||''( *)($|(,(.*)))'', ''i'' )',
  p_condition => 'regexp_like(:CRITICAL_OBJECT_LIST, ''(((.*),)|^)( *)''||REGEXP_REPLACE(REGEXP_REPLACE(:object, ''\\$'', ''\\$''), ''\\.'', ''\\.'')||''( *)($|(,(.*)))'', ''i'' )',
  --p_condition => 'regexp_like(:CRITICAL_OBJECT_LIST, ''(((.*),)|^)( *)''||:object||''( *)($|(,(.*)))'' ',
  p_message =>'System is in an insecure state. Insert failures for critical data objects are not audited.',
  p_message_nlsid =>'INSERT_FAILURE_MESG',
  p_cs_consider_percentage =>MGMT_GLOBAL.G_FALSE,
  p_start_type_meta_ver => ESM.DB_TYPE_META_VERSION,
  p_policy_param_list =>l_paramDefList,
  p_dflt_param_val_list =>l_defaultSettingsList,
  p_viol_ctxt_list =>l_ctxList	
);
COMMIT ;



END ;
/
show errors ;
SET ESCAPE OFF ;

