Rem drv: <migrate type="data_upgrade" version="11.0.0.0"/>
Rem
Rem $Header: notification_data_upgrade.sql 08-jun-2007.21:13:46 keiwong Exp $
Rem
Rem notification_data_upgrade.sql
Rem
Rem Copyright (c) 2007, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      notification_data_upgrade.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    keiwong     06/06/07 - Created
Rem

Rem
Rem Update rules for database type
Rem

BEGIN

    DECLARE
        l_rule_name VARCHAR2(64);
        l_owner VARCHAR2(256);
        l_target_type VARCHAR2(64);
        l_target_name VARCHAR2(256);
        l_target_guid RAW(16);
        l_metric_name VARCHAR2(64);
        l_metric_column VARCHAR2(64);
        l_key_value VARCHAR2(256);
        l_key_part_1 VARCHAR2(256);
        l_key_part_2 VARCHAR2(256);
        l_key_part_3 VARCHAR2(256);
        l_key_part_4 VARCHAR2(256);
        l_key_part_5 VARCHAR2(256);   
        l_want_clears NUMBER(1);
        l_want_warnings NUMBER(1);
        l_want_critical_alerts NUMBER(1);
        l_want_tgt_up NUMBER(1);
        l_want_tgt_down NUMBER(1);
        l_want_tgt_unreachable_start NUMBER(1);
        l_want_tgt_unreachable_end NUMBER(1);
        l_want_tgt_metric_err_start NUMBER(1);
        l_want_tgt_metric_err_end NUMBER(1);
        l_want_tgt_blackout_start NUMBER(1);
        l_want_tgt_blackout_end NUMBER(1);
        l_want_policy_clears NUMBER(1);
        l_want_policy_violations NUMBER(1);
        l_want_warning_job_succeeded NUMBER(1);
        l_want_warning_job_problems NUMBER(1);
        l_want_critical_job_succeeded NUMBER(1);
        l_want_critical_job_problems NUMBER(1);
        l_want_policy_job_succeeded NUMBER(1);
        l_want_policy_job_problems NUMBER(1);
        l_ignore_rca NUMBER(1);

        l_count INTEGER;
    
        CURSOR c_notify_rule_configs (metric_name_in IN VARCHAR2,
                metric_column_in IN VARCHAR2) IS
            SELECT rule_name, owner, target_type, target_name, target_guid,
                metric_name, metric_column, key_value, key_part_1, key_part_2,
                key_part_3, key_part_4, key_part_5, want_clears, want_warnings,
                want_critical_alerts, want_target_up, want_target_down,
                want_target_unreachable_start, want_target_unreachable_end,
                want_target_metric_err_start, want_target_metric_err_end,
                want_target_blackout_start, want_target_blackout_end,
                want_policy_clears, want_policy_violations,
                want_warning_job_succeeded, want_warning_job_problems,
                want_critical_job_succeeded, want_critical_job_problems,
                want_policy_job_succeeded, want_policy_job_problems,
                ignore_rca
            FROM mgmt_notify_rule_configs
            WHERE target_type = 'oracle_database'
            AND metric_name = metric_name_in
            AND metric_column = metric_column_in;
    
    BEGIN
        SELECT COUNT(*) INTO l_count
        FROM mgmt_notify_rule_configs
        WHERE metric_name = 'adrAlertLogIncidentErrorStatus'
        OR metric_name = 'adrAlertLogOperationalErrorStatus'
        OR metric_name = 'adrAlertLogIncidentError'
        OR metric_name = 'adrAlertLogOperationalError';

        -- exit if rules may already be upgraded
        IF l_count > 0 THEN
            RETURN;
        END IF;

        -- add new metric columns for each old column

        l_metric_name := 'alertLogStatus';
        l_metric_column := 'genericErrors';
    
        OPEN c_notify_rule_configs (l_metric_name, l_metric_column);
        LOOP
            FETCH c_notify_rule_configs INTO
                l_rule_name, l_owner, l_target_type, l_target_name,
                l_target_guid, l_metric_name, l_metric_column, l_key_value,
                l_key_part_1, l_key_part_2, l_key_part_3, l_key_part_4,
                l_key_part_5, l_want_clears, l_want_warnings,
                l_want_critical_alerts, l_want_tgt_up, l_want_tgt_down,
                l_want_tgt_unreachable_start, l_want_tgt_unreachable_end,
                l_want_tgt_metric_err_start, l_want_tgt_metric_err_end,
                l_want_tgt_blackout_start, l_want_tgt_blackout_end,
                l_want_policy_clears, l_want_policy_violations,
                l_want_warning_job_succeeded, l_want_warning_job_problems,
                l_want_critical_job_succeeded, l_want_critical_job_problems,
                l_want_policy_job_succeeded, l_want_policy_job_problems,
                l_ignore_rca;
            EXIT WHEN c_notify_rule_configs%NOTFOUND;
    
            INSERT INTO mgmt_notify_rule_configs (
                rule_name, owner, target_type, target_name, target_guid,
                metric_name, metric_column, key_value, key_part_1, key_part_2,
                key_part_3, key_part_4, key_part_5, want_clears, want_warnings,
                want_critical_alerts, want_target_up, want_target_down,
                want_target_unreachable_start, want_target_unreachable_end,
                want_target_metric_err_start, want_target_metric_err_end,
                want_target_blackout_start, want_target_blackout_end,
                want_policy_clears, want_policy_violations,
                want_warning_job_succeeded, want_warning_job_problems,
                want_critical_job_succeeded, want_critical_job_problems,
                want_policy_job_succeeded, want_policy_job_problems,
                ignore_rca
                )
            VALUES (
                l_rule_name, l_owner, l_target_type, l_target_name, l_target_guid,
                'adrAlertLogIncidentErrorStatus', 'genericIncidentErrors',
                l_key_value, l_key_part_1, l_key_part_2, l_key_part_3,
                l_key_part_4, l_key_part_5,
                l_want_clears, l_want_warnings, l_want_critical_alerts,
                l_want_tgt_up, l_want_tgt_down,
                l_want_tgt_unreachable_start, l_want_tgt_unreachable_end,
                l_want_tgt_metric_err_start, l_want_tgt_metric_err_end,
                l_want_tgt_blackout_start, l_want_tgt_blackout_end,
                l_want_policy_clears, l_want_policy_violations,
                l_want_warning_job_succeeded, l_want_warning_job_problems,
                l_want_critical_job_succeeded, l_want_critical_job_problems,
                l_want_policy_job_succeeded, l_want_policy_job_problems,
                l_ignore_rca
            );
    
            INSERT INTO mgmt_notify_rule_configs (
                rule_name, owner, target_type, target_name, target_guid,
                metric_name, metric_column, key_value, key_part_1, key_part_2,
                key_part_3, key_part_4, key_part_5, want_clears, want_warnings,
                want_critical_alerts, want_target_up, want_target_down,
                want_target_unreachable_start, want_target_unreachable_end,
                want_target_metric_err_start, want_target_metric_err_end,
                want_target_blackout_start, want_target_blackout_end,
                want_policy_clears, want_policy_violations,
                want_warning_job_succeeded, want_warning_job_problems,
                want_critical_job_succeeded, want_critical_job_problems,
                want_policy_job_succeeded, want_policy_job_problems,
                ignore_rca
                )
            VALUES (
                l_rule_name, l_owner, l_target_type, l_target_name, l_target_guid,
                'adrAlertLogIncidentErrorStatus', 'genericInternalErrors',
                l_key_value, l_key_part_1, l_key_part_2, l_key_part_3,
                l_key_part_4, l_key_part_5,
                l_want_clears, l_want_warnings, l_want_critical_alerts,
                l_want_tgt_up, l_want_tgt_down,
                l_want_tgt_unreachable_start, l_want_tgt_unreachable_end,
                l_want_tgt_metric_err_start, l_want_tgt_metric_err_end,
                l_want_tgt_blackout_start, l_want_tgt_blackout_end,
                l_want_policy_clears, l_want_policy_violations,
                l_want_warning_job_succeeded, l_want_warning_job_problems,
                l_want_critical_job_succeeded, l_want_critical_job_problems,
                l_want_policy_job_succeeded, l_want_policy_job_problems,
                l_ignore_rca
            );
    
            INSERT INTO mgmt_notify_rule_configs (
                rule_name, owner, target_type, target_name, target_guid,
                metric_name, metric_column, key_value, key_part_1, key_part_2,
                key_part_3, key_part_4, key_part_5, want_clears, want_warnings,
                want_critical_alerts, want_target_up, want_target_down,
                want_target_unreachable_start, want_target_unreachable_end,
                want_target_metric_err_start, want_target_metric_err_end,
                want_target_blackout_start, want_target_blackout_end,
                want_policy_clears, want_policy_violations,
                want_warning_job_succeeded, want_warning_job_problems,
                want_critical_job_succeeded, want_critical_job_problems,
                want_policy_job_succeeded, want_policy_job_problems,
                ignore_rca
                )
            VALUES (
                l_rule_name, l_owner, l_target_type, l_target_name, l_target_guid,
                'adrAlertLogIncidentErrorStatus', 'internalSqlErrors',
                l_key_value, l_key_part_1, l_key_part_2, l_key_part_3,
                l_key_part_4, l_key_part_5,
                l_want_clears, l_want_warnings, l_want_critical_alerts,
                l_want_tgt_up, l_want_tgt_down,
                l_want_tgt_unreachable_start, l_want_tgt_unreachable_end,
                l_want_tgt_metric_err_start, l_want_tgt_metric_err_end,
                l_want_tgt_blackout_start, l_want_tgt_blackout_end,
                l_want_policy_clears, l_want_policy_violations,
                l_want_warning_job_succeeded, l_want_warning_job_problems,
                l_want_critical_job_succeeded, l_want_critical_job_problems,
                l_want_policy_job_succeeded, l_want_policy_job_problems,
                l_ignore_rca
            );
    
            INSERT INTO mgmt_notify_rule_configs (
                rule_name, owner, target_type, target_name, target_guid,
                metric_name, metric_column, key_value, key_part_1, key_part_2,
                key_part_3, key_part_4, key_part_5, want_clears, want_warnings,
                want_critical_alerts, want_target_up, want_target_down,
                want_target_unreachable_start, want_target_unreachable_end,
                want_target_metric_err_start, want_target_metric_err_end,
                want_target_blackout_start, want_target_blackout_end,
                want_policy_clears, want_policy_violations,
                want_warning_job_succeeded, want_warning_job_problems,
                want_critical_job_succeeded, want_critical_job_problems,
                want_policy_job_succeeded, want_policy_job_problems,
                ignore_rca
                )
            VALUES (
                l_rule_name, l_owner, l_target_type, l_target_name, l_target_guid,
                'adrAlertLogIncidentErrorStatus', 'accessViolationErrors',
                l_key_value, l_key_part_1, l_key_part_2, l_key_part_3,
                l_key_part_4, l_key_part_5,
                l_want_clears, l_want_warnings, l_want_critical_alerts,
                l_want_tgt_up, l_want_tgt_down,
                l_want_tgt_unreachable_start, l_want_tgt_unreachable_end,
                l_want_tgt_metric_err_start, l_want_tgt_metric_err_end,
                l_want_tgt_blackout_start, l_want_tgt_blackout_end,
                l_want_policy_clears, l_want_policy_violations,
                l_want_warning_job_succeeded, l_want_warning_job_problems,
                l_want_critical_job_succeeded, l_want_critical_job_problems,
                l_want_policy_job_succeeded, l_want_policy_job_problems,
                l_ignore_rca
            );
    
            INSERT INTO mgmt_notify_rule_configs (
                rule_name, owner, target_type, target_name, target_guid,
                metric_name, metric_column, key_value, key_part_1, key_part_2,
                key_part_3, key_part_4, key_part_5, want_clears, want_warnings,
                want_critical_alerts, want_target_up, want_target_down,
                want_target_unreachable_start, want_target_unreachable_end,
                want_target_metric_err_start, want_target_metric_err_end,
                want_target_blackout_start, want_target_blackout_end,
                want_policy_clears, want_policy_violations,
                want_warning_job_succeeded, want_warning_job_problems,
                want_critical_job_succeeded, want_critical_job_problems,
                want_policy_job_succeeded, want_policy_job_problems,
                ignore_rca
                )
            VALUES (
                l_rule_name, l_owner, l_target_type, l_target_name, l_target_guid,
                'adrAlertLogIncidentErrorStatus', 'redoLogCorruptErrors',
                l_key_value, l_key_part_1, l_key_part_2, l_key_part_3,
                l_key_part_4, l_key_part_5,
                l_want_clears, l_want_warnings, l_want_critical_alerts,
                l_want_tgt_up, l_want_tgt_down,
                l_want_tgt_unreachable_start, l_want_tgt_unreachable_end,
                l_want_tgt_metric_err_start, l_want_tgt_metric_err_end,
                l_want_tgt_blackout_start, l_want_tgt_blackout_end,
                l_want_policy_clears, l_want_policy_violations,
                l_want_warning_job_succeeded, l_want_warning_job_problems,
                l_want_critical_job_succeeded, l_want_critical_job_problems,
                l_want_policy_job_succeeded, l_want_policy_job_problems,
                l_ignore_rca
            );
    
            INSERT INTO mgmt_notify_rule_configs (
                rule_name, owner, target_type, target_name, target_guid,
                metric_name, metric_column, key_value, key_part_1, key_part_2,
                key_part_3, key_part_4, key_part_5, want_clears, want_warnings,
                want_critical_alerts, want_target_up, want_target_down,
                want_target_unreachable_start, want_target_unreachable_end,
                want_target_metric_err_start, want_target_metric_err_end,
                want_target_blackout_start, want_target_blackout_end,
                want_policy_clears, want_policy_violations,
                want_warning_job_succeeded, want_warning_job_problems,
                want_critical_job_succeeded, want_critical_job_problems,
                want_policy_job_succeeded, want_policy_job_problems,
                ignore_rca
                )
            VALUES (
                l_rule_name, l_owner, l_target_type, l_target_name, l_target_guid,
                'adrAlertLogIncidentErrorStatus', 'fileAccessErrors',
                l_key_value, l_key_part_1, l_key_part_2, l_key_part_3,
                l_key_part_4, l_key_part_5,
                l_want_clears, l_want_warnings, l_want_critical_alerts,
                l_want_tgt_up, l_want_tgt_down,
                l_want_tgt_unreachable_start, l_want_tgt_unreachable_end,
                l_want_tgt_metric_err_start, l_want_tgt_metric_err_end,
                l_want_tgt_blackout_start, l_want_tgt_blackout_end,
                l_want_policy_clears, l_want_policy_violations,
                l_want_warning_job_succeeded, l_want_warning_job_problems,
                l_want_critical_job_succeeded, l_want_critical_job_problems,
                l_want_policy_job_succeeded, l_want_policy_job_problems,
                l_ignore_rca
            );
    
            INSERT INTO mgmt_notify_rule_configs (
                rule_name, owner, target_type, target_name, target_guid,
                metric_name, metric_column, key_value, key_part_1, key_part_2,
                key_part_3, key_part_4, key_part_5, want_clears, want_warnings,
                want_critical_alerts, want_target_up, want_target_down,
                want_target_unreachable_start, want_target_unreachable_end,
                want_target_metric_err_start, want_target_metric_err_end,
                want_target_blackout_start, want_target_blackout_end,
                want_policy_clears, want_policy_violations,
                want_warning_job_succeeded, want_warning_job_problems,
                want_critical_job_succeeded, want_critical_job_problems,
                want_policy_job_succeeded, want_policy_job_problems,
                ignore_rca
                )
            VALUES (
                l_rule_name, l_owner, l_target_type, l_target_name, l_target_guid,
                'adrAlertLogIncidentErrorStatus', 'inconsistentDbStateErrors',
                l_key_value, l_key_part_1, l_key_part_2, l_key_part_3,
                l_key_part_4, l_key_part_5,
                l_want_clears, l_want_warnings, l_want_critical_alerts,
                l_want_tgt_up, l_want_tgt_down,
                l_want_tgt_unreachable_start, l_want_tgt_unreachable_end,
                l_want_tgt_metric_err_start, l_want_tgt_metric_err_end,
                l_want_tgt_blackout_start, l_want_tgt_blackout_end,
                l_want_policy_clears, l_want_policy_violations,
                l_want_warning_job_succeeded, l_want_warning_job_problems,
                l_want_critical_job_succeeded, l_want_critical_job_problems,
                l_want_policy_job_succeeded, l_want_policy_job_problems,
                l_ignore_rca
            );
    
            INSERT INTO mgmt_notify_rule_configs (
                rule_name, owner, target_type, target_name, target_guid,
                metric_name, metric_column, key_value, key_part_1, key_part_2,
                key_part_3, key_part_4, key_part_5, want_clears, want_warnings,
                want_critical_alerts, want_target_up, want_target_down,
                want_target_unreachable_start, want_target_unreachable_end,
                want_target_metric_err_start, want_target_metric_err_end,
                want_target_blackout_start, want_target_blackout_end,
                want_policy_clears, want_policy_violations,
                want_warning_job_succeeded, want_warning_job_problems,
                want_critical_job_succeeded, want_critical_job_problems,
                want_policy_job_succeeded, want_policy_job_problems,
                ignore_rca
                )
            VALUES (
                l_rule_name, l_owner, l_target_type, l_target_name, l_target_guid,
                'adrAlertLogIncidentErrorStatus', 'deadlockErrors',
                l_key_value, l_key_part_1, l_key_part_2, l_key_part_3,
                l_key_part_4, l_key_part_5,
                l_want_clears, l_want_warnings, l_want_critical_alerts,
                l_want_tgt_up, l_want_tgt_down,
                l_want_tgt_unreachable_start, l_want_tgt_unreachable_end,
                l_want_tgt_metric_err_start, l_want_tgt_metric_err_end,
                l_want_tgt_blackout_start, l_want_tgt_blackout_end,
                l_want_policy_clears, l_want_policy_violations,
                l_want_warning_job_succeeded, l_want_warning_job_problems,
                l_want_critical_job_succeeded, l_want_critical_job_problems,
                l_want_policy_job_succeeded, l_want_policy_job_problems,
                l_ignore_rca
            );
    
            INSERT INTO mgmt_notify_rule_configs (
                rule_name, owner, target_type, target_name, target_guid,
                metric_name, metric_column, key_value, key_part_1, key_part_2,
                key_part_3, key_part_4, key_part_5, want_clears, want_warnings,
                want_critical_alerts, want_target_up, want_target_down,
                want_target_unreachable_start, want_target_unreachable_end,
                want_target_metric_err_start, want_target_metric_err_end,
                want_target_blackout_start, want_target_blackout_end,
                want_policy_clears, want_policy_violations,
                want_warning_job_succeeded, want_warning_job_problems,
                want_critical_job_succeeded, want_critical_job_problems,
                want_policy_job_succeeded, want_policy_job_problems,
                ignore_rca
                )
            VALUES (
                l_rule_name, l_owner, l_target_type, l_target_name, l_target_guid,
                'adrAlertLogIncidentErrorStatus', 'outOfMemoryErrors',
                l_key_value, l_key_part_1, l_key_part_2, l_key_part_3,
                l_key_part_4, l_key_part_5,
                l_want_clears, l_want_warnings, l_want_critical_alerts,
                l_want_tgt_up, l_want_tgt_down,
                l_want_tgt_unreachable_start, l_want_tgt_unreachable_end,
                l_want_tgt_metric_err_start, l_want_tgt_metric_err_end,
                l_want_tgt_blackout_start, l_want_tgt_blackout_end,
                l_want_policy_clears, l_want_policy_violations,
                l_want_warning_job_succeeded, l_want_warning_job_problems,
                l_want_critical_job_succeeded, l_want_critical_job_problems,
                l_want_policy_job_succeeded, l_want_policy_job_problems,
                l_ignore_rca
            );
    
            INSERT INTO mgmt_notify_rule_configs (
                rule_name, owner, target_type, target_name, target_guid,
                metric_name, metric_column, key_value, key_part_1, key_part_2,
                key_part_3, key_part_4, key_part_5, want_clears, want_warnings,
                want_critical_alerts, want_target_up, want_target_down,
                want_target_unreachable_start, want_target_unreachable_end,
                want_target_metric_err_start, want_target_metric_err_end,
                want_target_blackout_start, want_target_blackout_end,
                want_policy_clears, want_policy_violations,
                want_warning_job_succeeded, want_warning_job_problems,
                want_critical_job_succeeded, want_critical_job_problems,
                want_policy_job_succeeded, want_policy_job_problems,
                ignore_rca
                )
            VALUES (
                l_rule_name, l_owner, l_target_type, l_target_name, l_target_guid,
                'adrAlertLogIncidentErrorStatus', 'clusterErrors',
                l_key_value, l_key_part_1, l_key_part_2, l_key_part_3,
                l_key_part_4, l_key_part_5,
                l_want_clears, l_want_warnings, l_want_critical_alerts,
                l_want_tgt_up, l_want_tgt_down,
                l_want_tgt_unreachable_start, l_want_tgt_unreachable_end,
                l_want_tgt_metric_err_start, l_want_tgt_metric_err_end,
                l_want_tgt_blackout_start, l_want_tgt_blackout_end,
                l_want_policy_clears, l_want_policy_violations,
                l_want_warning_job_succeeded, l_want_warning_job_problems,
                l_want_critical_job_succeeded, l_want_critical_job_problems,
                l_want_policy_job_succeeded, l_want_policy_job_problems,
                l_ignore_rca
            );
    
            INSERT INTO mgmt_notify_rule_configs (
                rule_name, owner, target_type, target_name, target_guid,
                metric_name, metric_column, key_value, key_part_1, key_part_2,
                key_part_3, key_part_4, key_part_5, want_clears, want_warnings,
                want_critical_alerts, want_target_up, want_target_down,
                want_target_unreachable_start, want_target_unreachable_end,
                want_target_metric_err_start, want_target_metric_err_end,
                want_target_blackout_start, want_target_blackout_end,
                want_policy_clears, want_policy_violations,
                want_warning_job_succeeded, want_warning_job_problems,
                want_critical_job_succeeded, want_critical_job_problems,
                want_policy_job_succeeded, want_policy_job_problems,
                ignore_rca
                )
            VALUES (
                l_rule_name, l_owner, l_target_type, l_target_name, l_target_guid,
                'adrAlertLogOperationalErrorStatus', 'genericOperationalErrors',
                l_key_value, l_key_part_1, l_key_part_2, l_key_part_3,
                l_key_part_4, l_key_part_5,
                l_want_clears, l_want_warnings, l_want_critical_alerts,
                l_want_tgt_up, l_want_tgt_down,
                l_want_tgt_unreachable_start, l_want_tgt_unreachable_end,
                l_want_tgt_metric_err_start, l_want_tgt_metric_err_end,
                l_want_tgt_blackout_start, l_want_tgt_blackout_end,
                l_want_policy_clears, l_want_policy_violations,
                l_want_warning_job_succeeded, l_want_warning_job_problems,
                l_want_critical_job_succeeded, l_want_critical_job_problems,
                l_want_policy_job_succeeded, l_want_policy_job_problems,
                l_ignore_rca
            );
        END LOOP;
        CLOSE c_notify_rule_configs;
    
        l_metric_name := 'alertLogStatus';
        l_metric_column := 'archiveHungErrors';
    
        OPEN c_notify_rule_configs (l_metric_name, l_metric_column);
        LOOP
            FETCH c_notify_rule_configs INTO
                l_rule_name, l_owner, l_target_type, l_target_name, l_target_guid,
                l_metric_name, l_metric_column, l_key_value, l_key_part_1,
                l_key_part_2, l_key_part_3, l_key_part_4, l_key_part_5,
                l_want_clears, l_want_warnings, l_want_critical_alerts,
                l_want_tgt_up, l_want_tgt_down,
                l_want_tgt_unreachable_start, l_want_tgt_unreachable_end,
                l_want_tgt_metric_err_start, l_want_tgt_metric_err_end,
                l_want_tgt_blackout_start, l_want_tgt_blackout_end,
                l_want_policy_clears, l_want_policy_violations,
                l_want_warning_job_succeeded, l_want_warning_job_problems,
                l_want_critical_job_succeeded, l_want_critical_job_problems,
                l_want_policy_job_succeeded, l_want_policy_job_problems,
                l_ignore_rca;
            EXIT WHEN c_notify_rule_configs%NOTFOUND;
    
            INSERT INTO mgmt_notify_rule_configs (
                rule_name, owner, target_type, target_name, target_guid,
                metric_name, metric_column, key_value, key_part_1, key_part_2,
                key_part_3, key_part_4, key_part_5, want_clears, want_warnings,
                want_critical_alerts, want_target_up, want_target_down,
                want_target_unreachable_start, want_target_unreachable_end,
                want_target_metric_err_start, want_target_metric_err_end,
                want_target_blackout_start, want_target_blackout_end,
                want_policy_clears, want_policy_violations,
                want_warning_job_succeeded, want_warning_job_problems,
                want_critical_job_succeeded, want_critical_job_problems,
                want_policy_job_succeeded, want_policy_job_problems,
                ignore_rca
                )
            VALUES (
                l_rule_name, l_owner, l_target_type, l_target_name, l_target_guid,
                'adrAlertLogOperationalErrorStatus', 'archiveHungErrors',
                l_key_value, l_key_part_1, l_key_part_2, l_key_part_3,
                l_key_part_4, l_key_part_5,
                l_want_clears, l_want_warnings, l_want_critical_alerts,
                l_want_tgt_up, l_want_tgt_down,
                l_want_tgt_unreachable_start, l_want_tgt_unreachable_end,
                l_want_tgt_metric_err_start, l_want_tgt_metric_err_end,
                l_want_tgt_blackout_start, l_want_tgt_blackout_end,
                l_want_policy_clears, l_want_policy_violations,
                l_want_warning_job_succeeded, l_want_warning_job_problems,
                l_want_critical_job_succeeded, l_want_critical_job_problems,
                l_want_policy_job_succeeded, l_want_policy_job_problems,
                l_ignore_rca
            );
        END LOOP;
        CLOSE c_notify_rule_configs;
    
        l_metric_name := 'alertLogStatus';
        l_metric_column := 'blockCorruptErrors';
    
        OPEN c_notify_rule_configs (l_metric_name, l_metric_column);
        LOOP
            FETCH c_notify_rule_configs INTO
                l_rule_name, l_owner, l_target_type, l_target_name, l_target_guid,
                l_metric_name, l_metric_column, l_key_value, l_key_part_1,
                l_key_part_2, l_key_part_3, l_key_part_4, l_key_part_5,
                l_want_clears, l_want_warnings, l_want_critical_alerts,
                l_want_tgt_up, l_want_tgt_down,
                l_want_tgt_unreachable_start, l_want_tgt_unreachable_end,
                l_want_tgt_metric_err_start, l_want_tgt_metric_err_end,
                l_want_tgt_blackout_start, l_want_tgt_blackout_end,
                l_want_policy_clears, l_want_policy_violations,
                l_want_warning_job_succeeded, l_want_warning_job_problems,
                l_want_critical_job_succeeded, l_want_critical_job_problems,
                l_want_policy_job_succeeded, l_want_policy_job_problems,
                l_ignore_rca;
            EXIT WHEN c_notify_rule_configs%NOTFOUND;
    
            INSERT INTO mgmt_notify_rule_configs (
                rule_name, owner, target_type, target_name, target_guid,
                metric_name, metric_column, key_value, key_part_1, key_part_2,
                key_part_3, key_part_4, key_part_5, want_clears, want_warnings,
                want_critical_alerts, want_target_up, want_target_down,
                want_target_unreachable_start, want_target_unreachable_end,
                want_target_metric_err_start, want_target_metric_err_end,
                want_target_blackout_start, want_target_blackout_end,
                want_policy_clears, want_policy_violations,
                want_warning_job_succeeded, want_warning_job_problems,
                want_critical_job_succeeded, want_critical_job_problems,
                want_policy_job_succeeded, want_policy_job_problems,
                ignore_rca
                )
            VALUES (
                l_rule_name, l_owner, l_target_type, l_target_name, l_target_guid,
                'adrAlertLogIncidentErrorStatus', 'oraBlockCorruptErrors',
                l_key_value, l_key_part_1, l_key_part_2, l_key_part_3,
                l_key_part_4, l_key_part_5,
                l_want_clears, l_want_warnings, l_want_critical_alerts,
                l_want_tgt_up, l_want_tgt_down,
                l_want_tgt_unreachable_start, l_want_tgt_unreachable_end,
                l_want_tgt_metric_err_start, l_want_tgt_metric_err_end,
                l_want_tgt_blackout_start, l_want_tgt_blackout_end,
                l_want_policy_clears, l_want_policy_violations,
                l_want_warning_job_succeeded, l_want_warning_job_problems,
                l_want_critical_job_succeeded, l_want_critical_job_problems,
                l_want_policy_job_succeeded, l_want_policy_job_problems,
                l_ignore_rca
            );
    
            INSERT INTO mgmt_notify_rule_configs (
                rule_name, owner, target_type, target_name, target_guid,
                metric_name, metric_column, key_value, key_part_1, key_part_2,
                key_part_3, key_part_4, key_part_5, want_clears, want_warnings,
                want_critical_alerts, want_target_up, want_target_down,
                want_target_unreachable_start, want_target_unreachable_end,
                want_target_metric_err_start, want_target_metric_err_end,
                want_target_blackout_start, want_target_blackout_end,
                want_policy_clears, want_policy_violations,
                want_warning_job_succeeded, want_warning_job_problems,
                want_critical_job_succeeded, want_critical_job_problems,
                want_policy_job_succeeded, want_policy_job_problems,
                ignore_rca
                )
            VALUES (
                l_rule_name, l_owner, l_target_type, l_target_name, l_target_guid,
                'adrAlertLogOperationalErrorStatus', 'blockCorruptErrors',
                l_key_value, l_key_part_1, l_key_part_2, l_key_part_3,
                l_key_part_4, l_key_part_5,
                l_want_clears, l_want_warnings, l_want_critical_alerts,
                l_want_tgt_up, l_want_tgt_down,
                l_want_tgt_unreachable_start, l_want_tgt_unreachable_end,
                l_want_tgt_metric_err_start, l_want_tgt_metric_err_end,
                l_want_tgt_blackout_start, l_want_tgt_blackout_end,
                l_want_policy_clears, l_want_policy_violations,
                l_want_warning_job_succeeded, l_want_warning_job_problems,
                l_want_critical_job_succeeded, l_want_critical_job_problems,
                l_want_policy_job_succeeded, l_want_policy_job_problems,
                l_ignore_rca
            );
        END LOOP;
        CLOSE c_notify_rule_configs;
    
        l_metric_name := 'alertLogStatus';
        l_metric_column := 'sessTerminateErrors';
    
        OPEN c_notify_rule_configs (l_metric_name, l_metric_column);
        LOOP
            FETCH c_notify_rule_configs INTO
                l_rule_name, l_owner, l_target_type, l_target_name, l_target_guid,
                l_metric_name, l_metric_column, l_key_value, l_key_part_1,
                l_key_part_2, l_key_part_3, l_key_part_4, l_key_part_5,
                l_want_clears, l_want_warnings, l_want_critical_alerts,
                l_want_tgt_up, l_want_tgt_down,
                l_want_tgt_unreachable_start, l_want_tgt_unreachable_end,
                l_want_tgt_metric_err_start, l_want_tgt_metric_err_end,
                l_want_tgt_blackout_start, l_want_tgt_blackout_end,
                l_want_policy_clears, l_want_policy_violations,
                l_want_warning_job_succeeded, l_want_warning_job_problems,
                l_want_critical_job_succeeded, l_want_critical_job_problems,
                l_want_policy_job_succeeded, l_want_policy_job_problems,
                l_ignore_rca;
            EXIT WHEN c_notify_rule_configs%NOTFOUND;
    
            INSERT INTO mgmt_notify_rule_configs (
                rule_name, owner, target_type, target_name, target_guid,
                metric_name, metric_column, key_value, key_part_1, key_part_2,
                key_part_3, key_part_4, key_part_5, want_clears, want_warnings,
                want_critical_alerts, want_target_up, want_target_down,
                want_target_unreachable_start, want_target_unreachable_end,
                want_target_metric_err_start, want_target_metric_err_end,
                want_target_blackout_start, want_target_blackout_end,
                want_policy_clears, want_policy_violations,
                want_warning_job_succeeded, want_warning_job_problems,
                want_critical_job_succeeded, want_critical_job_problems,
                want_policy_job_succeeded, want_policy_job_problems,
                ignore_rca
                )
            VALUES (
                l_rule_name, l_owner, l_target_type, l_target_name, l_target_guid,
                'adrAlertLogIncidentErrorStatus', 'sessTerminateErrors',
                l_key_value, l_key_part_1, l_key_part_2, l_key_part_3,
                l_key_part_4, l_key_part_5,
                l_want_clears, l_want_warnings, l_want_critical_alerts,
                l_want_tgt_up, l_want_tgt_down,
                l_want_tgt_unreachable_start, l_want_tgt_unreachable_end,
                l_want_tgt_metric_err_start, l_want_tgt_metric_err_end,
                l_want_tgt_blackout_start, l_want_tgt_blackout_end,
                l_want_policy_clears, l_want_policy_violations,
                l_want_warning_job_succeeded, l_want_warning_job_problems,
                l_want_critical_job_succeeded, l_want_critical_job_problems,
                l_want_policy_job_succeeded, l_want_policy_job_problems,
                l_ignore_rca
            );
        END LOOP;
        CLOSE c_notify_rule_configs;
    
        l_metric_name := 'alertLogStatus';
        l_metric_column := 'mediaFailureErrors';
    
        OPEN c_notify_rule_configs (l_metric_name, l_metric_column);
        LOOP
            FETCH c_notify_rule_configs INTO
                l_rule_name, l_owner, l_target_type, l_target_name, l_target_guid,
                l_metric_name, l_metric_column, l_key_value, l_key_part_1,
                l_key_part_2, l_key_part_3, l_key_part_4, l_key_part_5,
                l_want_clears, l_want_warnings, l_want_critical_alerts,
                l_want_tgt_up, l_want_tgt_down,
                l_want_tgt_unreachable_start, l_want_tgt_unreachable_end,
                l_want_tgt_metric_err_start, l_want_tgt_metric_err_end,
                l_want_tgt_blackout_start, l_want_tgt_blackout_end,
                l_want_policy_clears, l_want_policy_violations,
                l_want_warning_job_succeeded, l_want_warning_job_problems,
                l_want_critical_job_succeeded, l_want_critical_job_problems,
                l_want_policy_job_succeeded, l_want_policy_job_problems,
                l_ignore_rca;
            EXIT WHEN c_notify_rule_configs%NOTFOUND;
    
            INSERT INTO mgmt_notify_rule_configs (
                rule_name, owner, target_type, target_name, target_guid,
                metric_name, metric_column, key_value, key_part_1, key_part_2,
                key_part_3, key_part_4, key_part_5, want_clears, want_warnings,
                want_critical_alerts, want_target_up, want_target_down,
                want_target_unreachable_start, want_target_unreachable_end,
                want_target_metric_err_start, want_target_metric_err_end,
                want_target_blackout_start, want_target_blackout_end,
                want_policy_clears, want_policy_violations,
                want_warning_job_succeeded, want_warning_job_problems,
                want_critical_job_succeeded, want_critical_job_problems,
                want_policy_job_succeeded, want_policy_job_problems,
                ignore_rca
                )
            VALUES (
                l_rule_name, l_owner, l_target_type, l_target_name, l_target_guid,
                'adrAlertLogOperationalErrorStatus', 'mediaFailureErrors',
                l_key_value, l_key_part_1, l_key_part_2, l_key_part_3,
                l_key_part_4, l_key_part_5,
                l_want_clears, l_want_warnings, l_want_critical_alerts,
                l_want_tgt_up, l_want_tgt_down,
                l_want_tgt_unreachable_start, l_want_tgt_unreachable_end,
                l_want_tgt_metric_err_start, l_want_tgt_metric_err_end,
                l_want_tgt_blackout_start, l_want_tgt_blackout_end,
                l_want_policy_clears, l_want_policy_violations,
                l_want_warning_job_succeeded, l_want_warning_job_problems,
                l_want_critical_job_succeeded, l_want_critical_job_problems,
                l_want_policy_job_succeeded, l_want_policy_job_problems,
                l_ignore_rca
            );
        END LOOP;
        CLOSE c_notify_rule_configs;

        l_metric_name := 'alertLog';
        l_metric_column := 'genericErrStack';
    
        OPEN c_notify_rule_configs (l_metric_name, l_metric_column);
        LOOP
            FETCH c_notify_rule_configs INTO
                l_rule_name, l_owner, l_target_type, l_target_name,
                l_target_guid, l_metric_name, l_metric_column, l_key_value,
                l_key_part_1, l_key_part_2, l_key_part_3, l_key_part_4,
                l_key_part_5, l_want_clears, l_want_warnings,
                l_want_critical_alerts, l_want_tgt_up, l_want_tgt_down,
                l_want_tgt_unreachable_start, l_want_tgt_unreachable_end,
                l_want_tgt_metric_err_start, l_want_tgt_metric_err_end,
                l_want_tgt_blackout_start, l_want_tgt_blackout_end,
                l_want_policy_clears, l_want_policy_violations,
                l_want_warning_job_succeeded, l_want_warning_job_problems,
                l_want_critical_job_succeeded, l_want_critical_job_problems,
                l_want_policy_job_succeeded, l_want_policy_job_problems,
                l_ignore_rca;
            EXIT WHEN c_notify_rule_configs%NOTFOUND;
    
            INSERT INTO mgmt_notify_rule_configs (
                rule_name, owner, target_type, target_name, target_guid,
                metric_name, metric_column, key_value, key_part_1, key_part_2,
                key_part_3, key_part_4, key_part_5, want_clears, want_warnings,
                want_critical_alerts, want_target_up, want_target_down,
                want_target_unreachable_start, want_target_unreachable_end,
                want_target_metric_err_start, want_target_metric_err_end,
                want_target_blackout_start, want_target_blackout_end,
                want_policy_clears, want_policy_violations,
                want_warning_job_succeeded, want_warning_job_problems,
                want_critical_job_succeeded, want_critical_job_problems,
                want_policy_job_succeeded, want_policy_job_problems,
                ignore_rca
                )
            VALUES (
                l_rule_name, l_owner, l_target_type, l_target_name, l_target_guid,
                'adrAlertLogIncidentError', 'genericIncidentErrStack',
                l_key_value, l_key_part_1, l_key_part_2, l_key_part_3,
                l_key_part_4, l_key_part_5,
                l_want_clears, l_want_warnings, l_want_critical_alerts,
                l_want_tgt_up, l_want_tgt_down,
                l_want_tgt_unreachable_start, l_want_tgt_unreachable_end,
                l_want_tgt_metric_err_start, l_want_tgt_metric_err_end,
                l_want_tgt_blackout_start, l_want_tgt_blackout_end,
                l_want_policy_clears, l_want_policy_violations,
                l_want_warning_job_succeeded, l_want_warning_job_problems,
                l_want_critical_job_succeeded, l_want_critical_job_problems,
                l_want_policy_job_succeeded, l_want_policy_job_problems,
                l_ignore_rca
            );
    
            INSERT INTO mgmt_notify_rule_configs (
                rule_name, owner, target_type, target_name, target_guid,
                metric_name, metric_column, key_value, key_part_1, key_part_2,
                key_part_3, key_part_4, key_part_5, want_clears, want_warnings,
                want_critical_alerts, want_target_up, want_target_down,
                want_target_unreachable_start, want_target_unreachable_end,
                want_target_metric_err_start, want_target_metric_err_end,
                want_target_blackout_start, want_target_blackout_end,
                want_policy_clears, want_policy_violations,
                want_warning_job_succeeded, want_warning_job_problems,
                want_critical_job_succeeded, want_critical_job_problems,
                want_policy_job_succeeded, want_policy_job_problems,
                ignore_rca
                )
            VALUES (
                l_rule_name, l_owner, l_target_type, l_target_name, l_target_guid,
                'adrAlertLogIncidentError', 'genericInternalErrStack',
                l_key_value, l_key_part_1, l_key_part_2, l_key_part_3,
                l_key_part_4, l_key_part_5,
                l_want_clears, l_want_warnings, l_want_critical_alerts,
                l_want_tgt_up, l_want_tgt_down,
                l_want_tgt_unreachable_start, l_want_tgt_unreachable_end,
                l_want_tgt_metric_err_start, l_want_tgt_metric_err_end,
                l_want_tgt_blackout_start, l_want_tgt_blackout_end,
                l_want_policy_clears, l_want_policy_violations,
                l_want_warning_job_succeeded, l_want_warning_job_problems,
                l_want_critical_job_succeeded, l_want_critical_job_problems,
                l_want_policy_job_succeeded, l_want_policy_job_problems,
                l_ignore_rca
            );
    
            INSERT INTO mgmt_notify_rule_configs (
                rule_name, owner, target_type, target_name, target_guid,
                metric_name, metric_column, key_value, key_part_1, key_part_2,
                key_part_3, key_part_4, key_part_5, want_clears, want_warnings,
                want_critical_alerts, want_target_up, want_target_down,
                want_target_unreachable_start, want_target_unreachable_end,
                want_target_metric_err_start, want_target_metric_err_end,
                want_target_blackout_start, want_target_blackout_end,
                want_policy_clears, want_policy_violations,
                want_warning_job_succeeded, want_warning_job_problems,
                want_critical_job_succeeded, want_critical_job_problems,
                want_policy_job_succeeded, want_policy_job_problems,
                ignore_rca
                )
            VALUES (
                l_rule_name, l_owner, l_target_type, l_target_name, l_target_guid,
                'adrAlertLogIncidentError', 'internalSqlErrStack',
                l_key_value, l_key_part_1, l_key_part_2, l_key_part_3,
                l_key_part_4, l_key_part_5,
                l_want_clears, l_want_warnings, l_want_critical_alerts,
                l_want_tgt_up, l_want_tgt_down,
                l_want_tgt_unreachable_start, l_want_tgt_unreachable_end,
                l_want_tgt_metric_err_start, l_want_tgt_metric_err_end,
                l_want_tgt_blackout_start, l_want_tgt_blackout_end,
                l_want_policy_clears, l_want_policy_violations,
                l_want_warning_job_succeeded, l_want_warning_job_problems,
                l_want_critical_job_succeeded, l_want_critical_job_problems,
                l_want_policy_job_succeeded, l_want_policy_job_problems,
                l_ignore_rca
            );
    
            INSERT INTO mgmt_notify_rule_configs (
                rule_name, owner, target_type, target_name, target_guid,
                metric_name, metric_column, key_value, key_part_1, key_part_2,
                key_part_3, key_part_4, key_part_5, want_clears, want_warnings,
                want_critical_alerts, want_target_up, want_target_down,
                want_target_unreachable_start, want_target_unreachable_end,
                want_target_metric_err_start, want_target_metric_err_end,
                want_target_blackout_start, want_target_blackout_end,
                want_policy_clears, want_policy_violations,
                want_warning_job_succeeded, want_warning_job_problems,
                want_critical_job_succeeded, want_critical_job_problems,
                want_policy_job_succeeded, want_policy_job_problems,
                ignore_rca
                )
            VALUES (
                l_rule_name, l_owner, l_target_type, l_target_name, l_target_guid,
                'adrAlertLogIncidentError', 'accessViolationErrStack',
                l_key_value, l_key_part_1, l_key_part_2, l_key_part_3,
                l_key_part_4, l_key_part_5,
                l_want_clears, l_want_warnings, l_want_critical_alerts,
                l_want_tgt_up, l_want_tgt_down,
                l_want_tgt_unreachable_start, l_want_tgt_unreachable_end,
                l_want_tgt_metric_err_start, l_want_tgt_metric_err_end,
                l_want_tgt_blackout_start, l_want_tgt_blackout_end,
                l_want_policy_clears, l_want_policy_violations,
                l_want_warning_job_succeeded, l_want_warning_job_problems,
                l_want_critical_job_succeeded, l_want_critical_job_problems,
                l_want_policy_job_succeeded, l_want_policy_job_problems,
                l_ignore_rca
            );
    
            INSERT INTO mgmt_notify_rule_configs (
                rule_name, owner, target_type, target_name, target_guid,
                metric_name, metric_column, key_value, key_part_1, key_part_2,
                key_part_3, key_part_4, key_part_5, want_clears, want_warnings,
                want_critical_alerts, want_target_up, want_target_down,
                want_target_unreachable_start, want_target_unreachable_end,
                want_target_metric_err_start, want_target_metric_err_end,
                want_target_blackout_start, want_target_blackout_end,
                want_policy_clears, want_policy_violations,
                want_warning_job_succeeded, want_warning_job_problems,
                want_critical_job_succeeded, want_critical_job_problems,
                want_policy_job_succeeded, want_policy_job_problems,
                ignore_rca
                )
            VALUES (
                l_rule_name, l_owner, l_target_type, l_target_name, l_target_guid,
                'adrAlertLogIncidentError', 'redoLogCorruptErrStack',
                l_key_value, l_key_part_1, l_key_part_2, l_key_part_3,
                l_key_part_4, l_key_part_5,
                l_want_clears, l_want_warnings, l_want_critical_alerts,
                l_want_tgt_up, l_want_tgt_down,
                l_want_tgt_unreachable_start, l_want_tgt_unreachable_end,
                l_want_tgt_metric_err_start, l_want_tgt_metric_err_end,
                l_want_tgt_blackout_start, l_want_tgt_blackout_end,
                l_want_policy_clears, l_want_policy_violations,
                l_want_warning_job_succeeded, l_want_warning_job_problems,
                l_want_critical_job_succeeded, l_want_critical_job_problems,
                l_want_policy_job_succeeded, l_want_policy_job_problems,
                l_ignore_rca
            );
    
            INSERT INTO mgmt_notify_rule_configs (
                rule_name, owner, target_type, target_name, target_guid,
                metric_name, metric_column, key_value, key_part_1, key_part_2,
                key_part_3, key_part_4, key_part_5, want_clears, want_warnings,
                want_critical_alerts, want_target_up, want_target_down,
                want_target_unreachable_start, want_target_unreachable_end,
                want_target_metric_err_start, want_target_metric_err_end,
                want_target_blackout_start, want_target_blackout_end,
                want_policy_clears, want_policy_violations,
                want_warning_job_succeeded, want_warning_job_problems,
                want_critical_job_succeeded, want_critical_job_problems,
                want_policy_job_succeeded, want_policy_job_problems,
                ignore_rca
                )
            VALUES (
                l_rule_name, l_owner, l_target_type, l_target_name, l_target_guid,
                'adrAlertLogIncidentError', 'fileAccessErrStack',
                l_key_value, l_key_part_1, l_key_part_2, l_key_part_3,
                l_key_part_4, l_key_part_5,
                l_want_clears, l_want_warnings, l_want_critical_alerts,
                l_want_tgt_up, l_want_tgt_down,
                l_want_tgt_unreachable_start, l_want_tgt_unreachable_end,
                l_want_tgt_metric_err_start, l_want_tgt_metric_err_end,
                l_want_tgt_blackout_start, l_want_tgt_blackout_end,
                l_want_policy_clears, l_want_policy_violations,
                l_want_warning_job_succeeded, l_want_warning_job_problems,
                l_want_critical_job_succeeded, l_want_critical_job_problems,
                l_want_policy_job_succeeded, l_want_policy_job_problems,
                l_ignore_rca
            );
    
            INSERT INTO mgmt_notify_rule_configs (
                rule_name, owner, target_type, target_name, target_guid,
                metric_name, metric_column, key_value, key_part_1, key_part_2,
                key_part_3, key_part_4, key_part_5, want_clears, want_warnings,
                want_critical_alerts, want_target_up, want_target_down,
                want_target_unreachable_start, want_target_unreachable_end,
                want_target_metric_err_start, want_target_metric_err_end,
                want_target_blackout_start, want_target_blackout_end,
                want_policy_clears, want_policy_violations,
                want_warning_job_succeeded, want_warning_job_problems,
                want_critical_job_succeeded, want_critical_job_problems,
                want_policy_job_succeeded, want_policy_job_problems,
                ignore_rca
                )
            VALUES (
                l_rule_name, l_owner, l_target_type, l_target_name, l_target_guid,
                'adrAlertLogIncidentError', 'inconsistentDbStateErrStack',
                l_key_value, l_key_part_1, l_key_part_2, l_key_part_3,
                l_key_part_4, l_key_part_5,
                l_want_clears, l_want_warnings, l_want_critical_alerts,
                l_want_tgt_up, l_want_tgt_down,
                l_want_tgt_unreachable_start, l_want_tgt_unreachable_end,
                l_want_tgt_metric_err_start, l_want_tgt_metric_err_end,
                l_want_tgt_blackout_start, l_want_tgt_blackout_end,
                l_want_policy_clears, l_want_policy_violations,
                l_want_warning_job_succeeded, l_want_warning_job_problems,
                l_want_critical_job_succeeded, l_want_critical_job_problems,
                l_want_policy_job_succeeded, l_want_policy_job_problems,
                l_ignore_rca
            );
    
            INSERT INTO mgmt_notify_rule_configs (
                rule_name, owner, target_type, target_name, target_guid,
                metric_name, metric_column, key_value, key_part_1, key_part_2,
                key_part_3, key_part_4, key_part_5, want_clears, want_warnings,
                want_critical_alerts, want_target_up, want_target_down,
                want_target_unreachable_start, want_target_unreachable_end,
                want_target_metric_err_start, want_target_metric_err_end,
                want_target_blackout_start, want_target_blackout_end,
                want_policy_clears, want_policy_violations,
                want_warning_job_succeeded, want_warning_job_problems,
                want_critical_job_succeeded, want_critical_job_problems,
                want_policy_job_succeeded, want_policy_job_problems,
                ignore_rca
                )
            VALUES (
                l_rule_name, l_owner, l_target_type, l_target_name, l_target_guid,
                'adrAlertLogIncidentError', 'deadlockErrStack',
                l_key_value, l_key_part_1, l_key_part_2, l_key_part_3,
                l_key_part_4, l_key_part_5,
                l_want_clears, l_want_warnings, l_want_critical_alerts,
                l_want_tgt_up, l_want_tgt_down,
                l_want_tgt_unreachable_start, l_want_tgt_unreachable_end,
                l_want_tgt_metric_err_start, l_want_tgt_metric_err_end,
                l_want_tgt_blackout_start, l_want_tgt_blackout_end,
                l_want_policy_clears, l_want_policy_violations,
                l_want_warning_job_succeeded, l_want_warning_job_problems,
                l_want_critical_job_succeeded, l_want_critical_job_problems,
                l_want_policy_job_succeeded, l_want_policy_job_problems,
                l_ignore_rca
            );
    
            INSERT INTO mgmt_notify_rule_configs (
                rule_name, owner, target_type, target_name, target_guid,
                metric_name, metric_column, key_value, key_part_1, key_part_2,
                key_part_3, key_part_4, key_part_5, want_clears, want_warnings,
                want_critical_alerts, want_target_up, want_target_down,
                want_target_unreachable_start, want_target_unreachable_end,
                want_target_metric_err_start, want_target_metric_err_end,
                want_target_blackout_start, want_target_blackout_end,
                want_policy_clears, want_policy_violations,
                want_warning_job_succeeded, want_warning_job_problems,
                want_critical_job_succeeded, want_critical_job_problems,
                want_policy_job_succeeded, want_policy_job_problems,
                ignore_rca
                )
            VALUES (
                l_rule_name, l_owner, l_target_type, l_target_name, l_target_guid,
                'adrAlertLogIncidentError', 'outOfMemoryErrStack',
                l_key_value, l_key_part_1, l_key_part_2, l_key_part_3,
                l_key_part_4, l_key_part_5,
                l_want_clears, l_want_warnings, l_want_critical_alerts,
                l_want_tgt_up, l_want_tgt_down,
                l_want_tgt_unreachable_start, l_want_tgt_unreachable_end,
                l_want_tgt_metric_err_start, l_want_tgt_metric_err_end,
                l_want_tgt_blackout_start, l_want_tgt_blackout_end,
                l_want_policy_clears, l_want_policy_violations,
                l_want_warning_job_succeeded, l_want_warning_job_problems,
                l_want_critical_job_succeeded, l_want_critical_job_problems,
                l_want_policy_job_succeeded, l_want_policy_job_problems,
                l_ignore_rca
            );
    
            INSERT INTO mgmt_notify_rule_configs (
                rule_name, owner, target_type, target_name, target_guid,
                metric_name, metric_column, key_value, key_part_1, key_part_2,
                key_part_3, key_part_4, key_part_5, want_clears, want_warnings,
                want_critical_alerts, want_target_up, want_target_down,
                want_target_unreachable_start, want_target_unreachable_end,
                want_target_metric_err_start, want_target_metric_err_end,
                want_target_blackout_start, want_target_blackout_end,
                want_policy_clears, want_policy_violations,
                want_warning_job_succeeded, want_warning_job_problems,
                want_critical_job_succeeded, want_critical_job_problems,
                want_policy_job_succeeded, want_policy_job_problems,
                ignore_rca
                )
            VALUES (
                l_rule_name, l_owner, l_target_type, l_target_name, l_target_guid,
                'adrAlertLogIncidentError', 'clusterErrStack',
                l_key_value, l_key_part_1, l_key_part_2, l_key_part_3,
                l_key_part_4, l_key_part_5,
                l_want_clears, l_want_warnings, l_want_critical_alerts,
                l_want_tgt_up, l_want_tgt_down,
                l_want_tgt_unreachable_start, l_want_tgt_unreachable_end,
                l_want_tgt_metric_err_start, l_want_tgt_metric_err_end,
                l_want_tgt_blackout_start, l_want_tgt_blackout_end,
                l_want_policy_clears, l_want_policy_violations,
                l_want_warning_job_succeeded, l_want_warning_job_problems,
                l_want_critical_job_succeeded, l_want_critical_job_problems,
                l_want_policy_job_succeeded, l_want_policy_job_problems,
                l_ignore_rca
            );
    
            INSERT INTO mgmt_notify_rule_configs (
                rule_name, owner, target_type, target_name, target_guid,
                metric_name, metric_column, key_value, key_part_1, key_part_2,
                key_part_3, key_part_4, key_part_5, want_clears, want_warnings,
                want_critical_alerts, want_target_up, want_target_down,
                want_target_unreachable_start, want_target_unreachable_end,
                want_target_metric_err_start, want_target_metric_err_end,
                want_target_blackout_start, want_target_blackout_end,
                want_policy_clears, want_policy_violations,
                want_warning_job_succeeded, want_warning_job_problems,
                want_critical_job_succeeded, want_critical_job_problems,
                want_policy_job_succeeded, want_policy_job_problems,
                ignore_rca
                )
            VALUES (
                l_rule_name, l_owner, l_target_type, l_target_name, l_target_guid,
                'adrAlertLogOperationalError', 'genericOperationalErrStack',
                l_key_value, l_key_part_1, l_key_part_2, l_key_part_3,
                l_key_part_4, l_key_part_5,
                l_want_clears, l_want_warnings, l_want_critical_alerts,
                l_want_tgt_up, l_want_tgt_down,
                l_want_tgt_unreachable_start, l_want_tgt_unreachable_end,
                l_want_tgt_metric_err_start, l_want_tgt_metric_err_end,
                l_want_tgt_blackout_start, l_want_tgt_blackout_end,
                l_want_policy_clears, l_want_policy_violations,
                l_want_warning_job_succeeded, l_want_warning_job_problems,
                l_want_critical_job_succeeded, l_want_critical_job_problems,
                l_want_policy_job_succeeded, l_want_policy_job_problems,
                l_ignore_rca
            );
        END LOOP;
        CLOSE c_notify_rule_configs;
    
        l_metric_name := 'alertLog';
        l_metric_column := 'archiveHungErrStack';
    
        OPEN c_notify_rule_configs (l_metric_name, l_metric_column);
        LOOP
            FETCH c_notify_rule_configs INTO
                l_rule_name, l_owner, l_target_type, l_target_name, l_target_guid,
                l_metric_name, l_metric_column, l_key_value, l_key_part_1,
                l_key_part_2, l_key_part_3, l_key_part_4, l_key_part_5,
                l_want_clears, l_want_warnings, l_want_critical_alerts,
                l_want_tgt_up, l_want_tgt_down,
                l_want_tgt_unreachable_start, l_want_tgt_unreachable_end,
                l_want_tgt_metric_err_start, l_want_tgt_metric_err_end,
                l_want_tgt_blackout_start, l_want_tgt_blackout_end,
                l_want_policy_clears, l_want_policy_violations,
                l_want_warning_job_succeeded, l_want_warning_job_problems,
                l_want_critical_job_succeeded, l_want_critical_job_problems,
                l_want_policy_job_succeeded, l_want_policy_job_problems,
                l_ignore_rca;
            EXIT WHEN c_notify_rule_configs%NOTFOUND;
    
            INSERT INTO mgmt_notify_rule_configs (
                rule_name, owner, target_type, target_name, target_guid,
                metric_name, metric_column, key_value, key_part_1, key_part_2,
                key_part_3, key_part_4, key_part_5, want_clears, want_warnings,
                want_critical_alerts, want_target_up, want_target_down,
                want_target_unreachable_start, want_target_unreachable_end,
                want_target_metric_err_start, want_target_metric_err_end,
                want_target_blackout_start, want_target_blackout_end,
                want_policy_clears, want_policy_violations,
                want_warning_job_succeeded, want_warning_job_problems,
                want_critical_job_succeeded, want_critical_job_problems,
                want_policy_job_succeeded, want_policy_job_problems,
                ignore_rca
                )
            VALUES (
                l_rule_name, l_owner, l_target_type, l_target_name, l_target_guid,
                'adrAlertLogOperationalError', 'archiveHungErrStack',
                l_key_value, l_key_part_1, l_key_part_2, l_key_part_3,
                l_key_part_4, l_key_part_5,
                l_want_clears, l_want_warnings, l_want_critical_alerts,
                l_want_tgt_up, l_want_tgt_down,
                l_want_tgt_unreachable_start, l_want_tgt_unreachable_end,
                l_want_tgt_metric_err_start, l_want_tgt_metric_err_end,
                l_want_tgt_blackout_start, l_want_tgt_blackout_end,
                l_want_policy_clears, l_want_policy_violations,
                l_want_warning_job_succeeded, l_want_warning_job_problems,
                l_want_critical_job_succeeded, l_want_critical_job_problems,
                l_want_policy_job_succeeded, l_want_policy_job_problems,
                l_ignore_rca
            );
        END LOOP;
        CLOSE c_notify_rule_configs;
    
        l_metric_name := 'alertLog';
        l_metric_column := 'blockCorruptErrStack';
    
        OPEN c_notify_rule_configs (l_metric_name, l_metric_column);
        LOOP
            FETCH c_notify_rule_configs INTO
                l_rule_name, l_owner, l_target_type, l_target_name, l_target_guid,
                l_metric_name, l_metric_column, l_key_value, l_key_part_1,
                l_key_part_2, l_key_part_3, l_key_part_4, l_key_part_5,
                l_want_clears, l_want_warnings, l_want_critical_alerts,
                l_want_tgt_up, l_want_tgt_down,
                l_want_tgt_unreachable_start, l_want_tgt_unreachable_end,
                l_want_tgt_metric_err_start, l_want_tgt_metric_err_end,
                l_want_tgt_blackout_start, l_want_tgt_blackout_end,
                l_want_policy_clears, l_want_policy_violations,
                l_want_warning_job_succeeded, l_want_warning_job_problems,
                l_want_critical_job_succeeded, l_want_critical_job_problems,
                l_want_policy_job_succeeded, l_want_policy_job_problems,
                l_ignore_rca;
            EXIT WHEN c_notify_rule_configs%NOTFOUND;
    
            INSERT INTO mgmt_notify_rule_configs (
                rule_name, owner, target_type, target_name, target_guid,
                metric_name, metric_column, key_value, key_part_1, key_part_2,
                key_part_3, key_part_4, key_part_5, want_clears, want_warnings,
                want_critical_alerts, want_target_up, want_target_down,
                want_target_unreachable_start, want_target_unreachable_end,
                want_target_metric_err_start, want_target_metric_err_end,
                want_target_blackout_start, want_target_blackout_end,
                want_policy_clears, want_policy_violations,
                want_warning_job_succeeded, want_warning_job_problems,
                want_critical_job_succeeded, want_critical_job_problems,
                want_policy_job_succeeded, want_policy_job_problems,
                ignore_rca
                )
            VALUES (
                l_rule_name, l_owner, l_target_type, l_target_name, l_target_guid,
                'adrAlertLogIncidentError', 'oraBlockCorruptErrStack',
                l_key_value, l_key_part_1, l_key_part_2, l_key_part_3,
                l_key_part_4, l_key_part_5,
                l_want_clears, l_want_warnings, l_want_critical_alerts,
                l_want_tgt_up, l_want_tgt_down,
                l_want_tgt_unreachable_start, l_want_tgt_unreachable_end,
                l_want_tgt_metric_err_start, l_want_tgt_metric_err_end,
                l_want_tgt_blackout_start, l_want_tgt_blackout_end,
                l_want_policy_clears, l_want_policy_violations,
                l_want_warning_job_succeeded, l_want_warning_job_problems,
                l_want_critical_job_succeeded, l_want_critical_job_problems,
                l_want_policy_job_succeeded, l_want_policy_job_problems,
                l_ignore_rca
            );
    
            INSERT INTO mgmt_notify_rule_configs (
                rule_name, owner, target_type, target_name, target_guid,
                metric_name, metric_column, key_value, key_part_1, key_part_2,
                key_part_3, key_part_4, key_part_5, want_clears, want_warnings,
                want_critical_alerts, want_target_up, want_target_down,
                want_target_unreachable_start, want_target_unreachable_end,
                want_target_metric_err_start, want_target_metric_err_end,
                want_target_blackout_start, want_target_blackout_end,
                want_policy_clears, want_policy_violations,
                want_warning_job_succeeded, want_warning_job_problems,
                want_critical_job_succeeded, want_critical_job_problems,
                want_policy_job_succeeded, want_policy_job_problems,
                ignore_rca
                )
            VALUES (
                l_rule_name, l_owner, l_target_type, l_target_name, l_target_guid,
                'adrAlertLogOperationalError', 'blockCorruptErrStack',
                l_key_value, l_key_part_1, l_key_part_2, l_key_part_3,
                l_key_part_4, l_key_part_5,
                l_want_clears, l_want_warnings, l_want_critical_alerts,
                l_want_tgt_up, l_want_tgt_down,
                l_want_tgt_unreachable_start, l_want_tgt_unreachable_end,
                l_want_tgt_metric_err_start, l_want_tgt_metric_err_end,
                l_want_tgt_blackout_start, l_want_tgt_blackout_end,
                l_want_policy_clears, l_want_policy_violations,
                l_want_warning_job_succeeded, l_want_warning_job_problems,
                l_want_critical_job_succeeded, l_want_critical_job_problems,
                l_want_policy_job_succeeded, l_want_policy_job_problems,
                l_ignore_rca
            );
        END LOOP;
        CLOSE c_notify_rule_configs;
    
        l_metric_name := 'alertLog';
        l_metric_column := 'sessTerminateErrStack';
    
        OPEN c_notify_rule_configs (l_metric_name, l_metric_column);
        LOOP
            FETCH c_notify_rule_configs INTO
                l_rule_name, l_owner, l_target_type, l_target_name, l_target_guid,
                l_metric_name, l_metric_column, l_key_value, l_key_part_1,
                l_key_part_2, l_key_part_3, l_key_part_4, l_key_part_5,
                l_want_clears, l_want_warnings, l_want_critical_alerts,
                l_want_tgt_up, l_want_tgt_down,
                l_want_tgt_unreachable_start, l_want_tgt_unreachable_end,
                l_want_tgt_metric_err_start, l_want_tgt_metric_err_end,
                l_want_tgt_blackout_start, l_want_tgt_blackout_end,
                l_want_policy_clears, l_want_policy_violations,
                l_want_warning_job_succeeded, l_want_warning_job_problems,
                l_want_critical_job_succeeded, l_want_critical_job_problems,
                l_want_policy_job_succeeded, l_want_policy_job_problems,
                l_ignore_rca;
            EXIT WHEN c_notify_rule_configs%NOTFOUND;
    
            INSERT INTO mgmt_notify_rule_configs (
                rule_name, owner, target_type, target_name, target_guid,
                metric_name, metric_column, key_value, key_part_1, key_part_2,
                key_part_3, key_part_4, key_part_5, want_clears, want_warnings,
                want_critical_alerts, want_target_up, want_target_down,
                want_target_unreachable_start, want_target_unreachable_end,
                want_target_metric_err_start, want_target_metric_err_end,
                want_target_blackout_start, want_target_blackout_end,
                want_policy_clears, want_policy_violations,
                want_warning_job_succeeded, want_warning_job_problems,
                want_critical_job_succeeded, want_critical_job_problems,
                want_policy_job_succeeded, want_policy_job_problems,
                ignore_rca
                )
            VALUES (
                l_rule_name, l_owner, l_target_type, l_target_name, l_target_guid,
                'adrAlertLogIncidentError', 'sessTerminateErrStack',
                l_key_value, l_key_part_1, l_key_part_2, l_key_part_3,
                l_key_part_4, l_key_part_5,
                l_want_clears, l_want_warnings, l_want_critical_alerts,
                l_want_tgt_up, l_want_tgt_down,
                l_want_tgt_unreachable_start, l_want_tgt_unreachable_end,
                l_want_tgt_metric_err_start, l_want_tgt_metric_err_end,
                l_want_tgt_blackout_start, l_want_tgt_blackout_end,
                l_want_policy_clears, l_want_policy_violations,
                l_want_warning_job_succeeded, l_want_warning_job_problems,
                l_want_critical_job_succeeded, l_want_critical_job_problems,
                l_want_policy_job_succeeded, l_want_policy_job_problems,
                l_ignore_rca
            );
        END LOOP;
        CLOSE c_notify_rule_configs;
    
        l_metric_name := 'alertLog';
        l_metric_column := 'mediaFailureErrStack';
    
        OPEN c_notify_rule_configs (l_metric_name, l_metric_column);
        LOOP
            FETCH c_notify_rule_configs INTO
                l_rule_name, l_owner, l_target_type, l_target_name, l_target_guid,
                l_metric_name, l_metric_column, l_key_value, l_key_part_1,
                l_key_part_2, l_key_part_3, l_key_part_4, l_key_part_5,
                l_want_clears, l_want_warnings, l_want_critical_alerts,
                l_want_tgt_up, l_want_tgt_down,
                l_want_tgt_unreachable_start, l_want_tgt_unreachable_end,
                l_want_tgt_metric_err_start, l_want_tgt_metric_err_end,
                l_want_tgt_blackout_start, l_want_tgt_blackout_end,
                l_want_policy_clears, l_want_policy_violations,
                l_want_warning_job_succeeded, l_want_warning_job_problems,
                l_want_critical_job_succeeded, l_want_critical_job_problems,
                l_want_policy_job_succeeded, l_want_policy_job_problems,
                l_ignore_rca;
            EXIT WHEN c_notify_rule_configs%NOTFOUND;
    
            INSERT INTO mgmt_notify_rule_configs (
                rule_name, owner, target_type, target_name, target_guid,
                metric_name, metric_column, key_value, key_part_1, key_part_2,
                key_part_3, key_part_4, key_part_5, want_clears, want_warnings,
                want_critical_alerts, want_target_up, want_target_down,
                want_target_unreachable_start, want_target_unreachable_end,
                want_target_metric_err_start, want_target_metric_err_end,
                want_target_blackout_start, want_target_blackout_end,
                want_policy_clears, want_policy_violations,
                want_warning_job_succeeded, want_warning_job_problems,
                want_critical_job_succeeded, want_critical_job_problems,
                want_policy_job_succeeded, want_policy_job_problems,
                ignore_rca
                )
            VALUES (
                l_rule_name, l_owner, l_target_type, l_target_name, l_target_guid,
                'adrAlertLogOperationalError', 'mediaFailureErrStack',
                l_key_value, l_key_part_1, l_key_part_2, l_key_part_3,
                l_key_part_4, l_key_part_5,
                l_want_clears, l_want_warnings, l_want_critical_alerts,
                l_want_tgt_up, l_want_tgt_down,
                l_want_tgt_unreachable_start, l_want_tgt_unreachable_end,
                l_want_tgt_metric_err_start, l_want_tgt_metric_err_end,
                l_want_tgt_blackout_start, l_want_tgt_blackout_end,
                l_want_policy_clears, l_want_policy_violations,
                l_want_warning_job_succeeded, l_want_warning_job_problems,
                l_want_critical_job_succeeded, l_want_critical_job_problems,
                l_want_policy_job_succeeded, l_want_policy_job_problems,
                l_ignore_rca
            );
        END LOOP;
        CLOSE c_notify_rule_configs;

        -- remove old metrics in DB Control
        IF ('&EM_REPOS_MODE' = 'SYSAUX') THEN
            DELETE mgmt_notify_rule_configs
            WHERE target_type = 'oracle_database'
            AND (metric_name = 'alertLogStatus'
            OR metric_name = 'alertLog');
        END IF;
    
        COMMIT;
    END;

END;
/
