Rem
Rem $Header: upgrade_delete_policies.sql 02-feb-2007.07:45:07 mnihalan Exp $
Rem
Rem upgrade_delete_policies.sql
Rem
Rem Copyright (c) 2005, 2007, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      upgrade_delete_policies.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      <short description of component this file declares/defines>
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    mnihalan    02/02/07 - Remove JAccelerator
Rem    denath      09/28/06 - Fix 5572415.SET DEFINE ON added at end.
Rem    denath      08/05/06 - Fix Bug 5390067.Deleted policies for metrics
Rem                           DB_REDO_LOG_COUNT, DB_CONTROL_FILE_COUNT.

SET DEFINE OFF

-- Delete Policies
--
-- NOTE: Metrics will not delete unless all associated policies
--       are first removed.  So, delete policy must run first,
--       then the metrics can be deleted.
--       After all policies and metrics are removed, then 
--       the metrics should be re-created and NEXT the
--       policies should be re-created.
-- 
-- Have to add error handling to PL/SQL because the fix for bug 4602294
-- means we cannot count on the metrics/policies being created, so
-- we have to handle the NO_SUCH_METRIC_FOUND and NO_SUCH_POLICY_FOUND 
-- exceptions.


-- --------------------------------------------------------
-- --------------------------------------------------------
--                CONFIGURATION: Delete Policies
-- --------------------------------------------------------
-- --------------------------------------------------------

BEGIN

 BEGIN
  -- Config: Insufficient Number of Redo Logs
  MGMT_POLICY.DELETE_POLICY(
      p_target_type => 'oracle_database',
      p_policy_name => 'INSUFF_REDO_LOGS');

  EXCEPTION
   WHEN MGMT_GLOBAL.POLICY_DOES_NOT_EXIST THEN
   NULL;

 END;

 BEGIN

  MGMT_POLICY.DELETE_POLICY(
      p_target_type => 'rac_database',
      p_policy_name => 'INSUFF_REDO_LOGS');

  EXCEPTION
   WHEN MGMT_GLOBAL.POLICY_DOES_NOT_EXIST THEN
   NULL;

 END;

 BEGIN
  -- Config: Insufficient Number of Control Files
  MGMT_POLICY.DELETE_POLICY(
      p_target_type => 'oracle_database',
      p_policy_name => 'INSUFF_CONTROL_FILES');

  EXCEPTION
   WHEN MGMT_GLOBAL.POLICY_DOES_NOT_EXIST THEN
   NULL;
 END;

 BEGIN
  MGMT_POLICY.DELETE_POLICY(
      p_target_type => 'rac_database',
      p_policy_name => 'INSUFF_CONTROL_FILES');

  EXCEPTION
   WHEN MGMT_GLOBAL.POLICY_DOES_NOT_EXIST THEN
   NULL;

 END;

 BEGIN
  -- Config: JAccelerator
  MGMT_POLICY.DELETE_POLICY(
      p_target_type => 'oracle_database',
      p_policy_name => 'INSTALL_NCOMPS');

  EXCEPTION
   WHEN MGMT_GLOBAL.POLICY_DOES_NOT_EXIST THEN
   NULL;
 END;
 
 BEGIN
  -- Config: JAccelerator
  MGMT_POLICY.DELETE_POLICY(
      p_target_type => 'rac_database',
      p_policy_name => 'INSTALL_NCOMPS');

  EXCEPTION
   WHEN MGMT_GLOBAL.POLICY_DOES_NOT_EXIST THEN
   NULL;
 END;

 COMMIT;  

END;
/

SET DEFINE ON

